#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 6252
#define LARGE_STATE_COUNT 1025
#define SYMBOL_COUNT 375
#define ALIAS_COUNT 4
#define TOKEN_COUNT 167
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 33
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 177

enum {
  sym_identifier = 1,
  aux_sym_preproc_include_token1 = 2,
  anon_sym_LF = 3,
  aux_sym_preproc_def_token1 = 4,
  anon_sym_LPAREN = 5,
  anon_sym_DOT_DOT_DOT = 6,
  anon_sym_COMMA = 7,
  anon_sym_RPAREN = 8,
  aux_sym_preproc_if_token1 = 9,
  aux_sym_preproc_if_token2 = 10,
  aux_sym_preproc_ifdef_token1 = 11,
  aux_sym_preproc_ifdef_token2 = 12,
  aux_sym_preproc_else_token1 = 13,
  aux_sym_preproc_elif_token1 = 14,
  sym_preproc_directive = 15,
  sym_preproc_arg = 16,
  anon_sym_LPAREN2 = 17,
  anon_sym_defined = 18,
  anon_sym_BANG = 19,
  anon_sym_TILDE = 20,
  anon_sym_DASH = 21,
  anon_sym_PLUS = 22,
  anon_sym_STAR = 23,
  anon_sym_SLASH = 24,
  anon_sym_PERCENT = 25,
  anon_sym_PIPE_PIPE = 26,
  anon_sym_AMP_AMP = 27,
  anon_sym_PIPE = 28,
  anon_sym_CARET = 29,
  anon_sym_AMP = 30,
  anon_sym_EQ_EQ = 31,
  anon_sym_BANG_EQ = 32,
  anon_sym_GT = 33,
  anon_sym_GT_EQ = 34,
  anon_sym_LT_EQ = 35,
  anon_sym_LT = 36,
  anon_sym_LT_LT = 37,
  anon_sym_GT_GT = 38,
  anon_sym___device__ = 39,
  anon_sym___host__ = 40,
  anon_sym___global__ = 41,
  anon_sym___forceinline__ = 42,
  anon_sym_SEMI = 43,
  anon_sym_typedef = 44,
  anon_sym_extern = 45,
  anon_sym___attribute__ = 46,
  anon_sym___declspec = 47,
  anon_sym___based = 48,
  anon_sym___cdecl = 49,
  anon_sym___clrcall = 50,
  anon_sym___stdcall = 51,
  anon_sym___fastcall = 52,
  anon_sym___thiscall = 53,
  anon_sym___vectorcall = 54,
  sym_ms_restrict_modifier = 55,
  sym_ms_unsigned_ptr_modifier = 56,
  sym_ms_signed_ptr_modifier = 57,
  anon_sym__unaligned = 58,
  anon_sym___unaligned = 59,
  anon_sym_LBRACE = 60,
  anon_sym_RBRACE = 61,
  anon_sym_LBRACK = 62,
  anon_sym_RBRACK = 63,
  anon_sym_EQ = 64,
  anon_sym_static = 65,
  anon_sym_register = 66,
  anon_sym_inline = 67,
  anon_sym_const = 68,
  anon_sym_volatile = 69,
  anon_sym_restrict = 70,
  anon_sym__Atomic = 71,
  anon_sym_mutable = 72,
  anon_sym_constexpr = 73,
  anon_sym___shared__ = 74,
  anon_sym___local__ = 75,
  anon_sym___constant__ = 76,
  anon_sym___restrict__ = 77,
  anon_sym_signed = 78,
  anon_sym_unsigned = 79,
  anon_sym_long = 80,
  anon_sym_short = 81,
  sym_primitive_type = 82,
  anon_sym_enum = 83,
  anon_sym_class = 84,
  anon_sym_struct = 85,
  anon_sym_union = 86,
  anon_sym_COLON = 87,
  anon_sym_if = 88,
  anon_sym_else = 89,
  anon_sym_switch = 90,
  anon_sym_case = 91,
  anon_sym_default = 92,
  anon_sym_while = 93,
  anon_sym_do = 94,
  anon_sym_for = 95,
  anon_sym_return = 96,
  anon_sym_break = 97,
  anon_sym_continue = 98,
  anon_sym_goto = 99,
  anon_sym_QMARK = 100,
  anon_sym_STAR_EQ = 101,
  anon_sym_SLASH_EQ = 102,
  anon_sym_PERCENT_EQ = 103,
  anon_sym_PLUS_EQ = 104,
  anon_sym_DASH_EQ = 105,
  anon_sym_LT_LT_EQ = 106,
  anon_sym_GT_GT_EQ = 107,
  anon_sym_AMP_EQ = 108,
  anon_sym_CARET_EQ = 109,
  anon_sym_PIPE_EQ = 110,
  anon_sym_DASH_DASH = 111,
  anon_sym_PLUS_PLUS = 112,
  anon_sym_sizeof = 113,
  anon_sym_DOT = 114,
  anon_sym_DASH_GT = 115,
  sym_number_literal = 116,
  anon_sym_L_SQUOTE = 117,
  anon_sym_u_SQUOTE = 118,
  anon_sym_U_SQUOTE = 119,
  anon_sym_u8_SQUOTE = 120,
  anon_sym_SQUOTE = 121,
  aux_sym_char_literal_token1 = 122,
  anon_sym_L_DQUOTE = 123,
  anon_sym_u_DQUOTE = 124,
  anon_sym_U_DQUOTE = 125,
  anon_sym_u8_DQUOTE = 126,
  anon_sym_DQUOTE = 127,
  aux_sym_string_literal_token1 = 128,
  sym_escape_sequence = 129,
  sym_system_lib_string = 130,
  sym_true = 131,
  sym_false = 132,
  sym_null = 133,
  sym_comment = 134,
  anon_sym_decltype = 135,
  anon_sym_final = 136,
  anon_sym_override = 137,
  anon_sym_virtual = 138,
  anon_sym_explicit = 139,
  anon_sym_public = 140,
  anon_sym_private = 141,
  anon_sym_protected = 142,
  sym_auto = 143,
  anon_sym_typename = 144,
  anon_sym_template = 145,
  anon_sym_GT2 = 146,
  anon_sym_COLON_COLON = 147,
  anon_sym_operator = 148,
  anon_sym_delete = 149,
  anon_sym_friend = 150,
  anon_sym_noexcept = 151,
  anon_sym_throw = 152,
  anon_sym_namespace = 153,
  anon_sym_using = 154,
  anon_sym_static_assert = 155,
  anon_sym_try = 156,
  anon_sym_catch = 157,
  anon_sym_LBRACK_LBRACK = 158,
  anon_sym_RBRACK_RBRACK = 159,
  anon_sym_new = 160,
  sym_operator_name = 161,
  sym_this = 162,
  sym_nullptr = 163,
  aux_sym_kernel_call_syntax_token1 = 164,
  aux_sym_kernel_call_syntax_token2 = 165,
  sym_raw_string_literal = 166,
  sym_translation_unit = 167,
  sym_preproc_include = 168,
  sym_preproc_def = 169,
  sym_preproc_function_def = 170,
  sym_preproc_params = 171,
  sym_preproc_call = 172,
  sym_preproc_if = 173,
  sym_preproc_ifdef = 174,
  sym_preproc_else = 175,
  sym_preproc_elif = 176,
  sym_preproc_if_in_field_declaration_list = 177,
  sym_preproc_ifdef_in_field_declaration_list = 178,
  sym_preproc_else_in_field_declaration_list = 179,
  sym_preproc_elif_in_field_declaration_list = 180,
  sym__preproc_expression = 181,
  sym_preproc_parenthesized_expression = 182,
  sym_preproc_defined = 183,
  sym_preproc_unary_expression = 184,
  sym_preproc_call_expression = 185,
  sym_preproc_argument_list = 186,
  sym_preproc_binary_expression = 187,
  sym_function_definition = 188,
  sym_declaration = 189,
  sym_type_definition = 190,
  sym__declaration_specifiers = 191,
  sym_linkage_specification = 192,
  sym_attribute_specifier = 193,
  sym_ms_declspec_modifier = 194,
  sym_ms_based_modifier = 195,
  sym_ms_call_modifier = 196,
  sym_ms_unaligned_ptr_modifier = 197,
  sym_ms_pointer_modifier = 198,
  sym_declaration_list = 199,
  sym__declarator = 200,
  sym__field_declarator = 201,
  sym__type_declarator = 202,
  sym__abstract_declarator = 203,
  sym_parenthesized_declarator = 204,
  sym_parenthesized_field_declarator = 205,
  sym_parenthesized_type_declarator = 206,
  sym_abstract_parenthesized_declarator = 207,
  sym_pointer_declarator = 208,
  sym_pointer_field_declarator = 209,
  sym_pointer_type_declarator = 210,
  sym_abstract_pointer_declarator = 211,
  sym_function_declarator = 212,
  sym_function_field_declarator = 213,
  sym_function_type_declarator = 214,
  sym_abstract_function_declarator = 215,
  sym_array_declarator = 216,
  sym_array_field_declarator = 217,
  sym_array_type_declarator = 218,
  sym_abstract_array_declarator = 219,
  sym_init_declarator = 220,
  sym_compound_statement = 221,
  sym_storage_class_specifier = 222,
  sym_type_qualifier = 223,
  sym__type_specifier = 224,
  sym_sized_type_specifier = 225,
  sym_enum_specifier = 226,
  sym_enumerator_list = 227,
  sym_struct_specifier = 228,
  sym_union_specifier = 229,
  sym_field_declaration_list = 230,
  sym__field_declaration_list_item = 231,
  sym_field_declaration = 232,
  sym_bitfield_clause = 233,
  sym_enumerator = 234,
  sym_parameter_list = 235,
  sym_parameter_declaration = 236,
  sym_labeled_statement = 237,
  sym_expression_statement = 238,
  sym_if_statement = 239,
  sym_switch_statement = 240,
  sym_case_statement = 241,
  sym_while_statement = 242,
  sym_do_statement = 243,
  sym_for_statement = 244,
  sym_return_statement = 245,
  sym_break_statement = 246,
  sym_continue_statement = 247,
  sym_goto_statement = 248,
  sym__expression = 249,
  sym_comma_expression = 250,
  sym_conditional_expression = 251,
  sym_assignment_expression = 252,
  sym_pointer_expression = 253,
  sym_unary_expression = 254,
  sym_binary_expression = 255,
  sym_update_expression = 256,
  sym_cast_expression = 257,
  sym_type_descriptor = 258,
  sym_sizeof_expression = 259,
  sym_subscript_expression = 260,
  sym_call_expression = 261,
  sym_argument_list = 262,
  sym_field_expression = 263,
  sym_compound_literal_expression = 264,
  sym_parenthesized_expression = 265,
  sym_initializer_list = 266,
  sym_initializer_pair = 267,
  sym_subscript_designator = 268,
  sym_field_designator = 269,
  sym_char_literal = 270,
  sym_concatenated_string = 271,
  sym_string_literal = 272,
  sym__empty_declaration = 273,
  sym_decltype = 274,
  sym_class_specifier = 275,
  sym__class_name = 276,
  sym_virtual_specifier = 277,
  sym_virtual_function_specifier = 278,
  sym_explicit_function_specifier = 279,
  sym_base_class_clause = 280,
  sym__enum_base_clause = 281,
  sym_dependent_type = 282,
  sym_template_declaration = 283,
  sym_template_instantiation = 284,
  sym_template_parameter_list = 285,
  sym_type_parameter_declaration = 286,
  sym_variadic_type_parameter_declaration = 287,
  sym_optional_type_parameter_declaration = 288,
  sym_template_template_parameter_declaration = 289,
  sym_optional_parameter_declaration = 290,
  sym_variadic_parameter_declaration = 291,
  sym_variadic_declarator = 292,
  sym_variadic_reference_declarator = 293,
  sym_operator_cast = 294,
  sym_field_initializer_list = 295,
  sym_field_initializer = 296,
  sym_inline_method_definition = 297,
  aux_sym__constructor_specifiers = 298,
  sym_operator_cast_definition = 299,
  sym_operator_cast_declaration = 300,
  sym_constructor_or_destructor_definition = 301,
  sym_constructor_or_destructor_declaration = 302,
  sym_default_method_clause = 303,
  sym_delete_method_clause = 304,
  sym_friend_declaration = 305,
  sym_access_specifier = 306,
  sym_reference_declarator = 307,
  sym_reference_field_declarator = 308,
  sym_abstract_reference_declarator = 309,
  sym_structured_binding_declarator = 310,
  sym_trailing_return_type = 311,
  sym_noexcept = 312,
  sym_throw_specifier = 313,
  sym_template_type = 314,
  sym_template_method = 315,
  sym_template_function = 316,
  sym_template_argument_list = 317,
  sym_namespace_definition = 318,
  sym_using_declaration = 319,
  sym_alias_declaration = 320,
  sym_static_assert_declaration = 321,
  sym_condition_clause = 322,
  sym_condition_declaration = 323,
  sym_for_range_loop = 324,
  sym_throw_statement = 325,
  sym_try_statement = 326,
  sym_catch_clause = 327,
  sym_attribute = 328,
  sym_new_expression = 329,
  sym_new_declarator = 330,
  sym_delete_expression = 331,
  sym_lambda_expression = 332,
  sym_lambda_capture_specifier = 333,
  sym_lambda_default_capture = 334,
  sym_parameter_pack_expansion = 335,
  sym_type_parameter_pack_expansion = 336,
  sym_destructor_name = 337,
  sym_scoped_field_identifier = 338,
  sym_scoped_identifier = 339,
  sym_scoped_type_identifier = 340,
  sym_scoped_namespace_identifier = 341,
  sym_kernel_call_syntax = 342,
  aux_sym_translation_unit_repeat1 = 343,
  aux_sym_preproc_params_repeat1 = 344,
  aux_sym_preproc_if_in_field_declaration_list_repeat1 = 345,
  aux_sym_preproc_argument_list_repeat1 = 346,
  aux_sym_function_definition_repeat1 = 347,
  aux_sym_function_definition_repeat2 = 348,
  aux_sym_declaration_repeat1 = 349,
  aux_sym_type_definition_repeat1 = 350,
  aux_sym_type_definition_repeat2 = 351,
  aux_sym__declaration_specifiers_repeat1 = 352,
  aux_sym_pointer_declarator_repeat1 = 353,
  aux_sym_function_declarator_repeat1 = 354,
  aux_sym_function_declarator_repeat2 = 355,
  aux_sym_abstract_function_declarator_repeat1 = 356,
  aux_sym_sized_type_specifier_repeat1 = 357,
  aux_sym_enumerator_list_repeat1 = 358,
  aux_sym_field_declaration_repeat1 = 359,
  aux_sym_parameter_list_repeat1 = 360,
  aux_sym_case_statement_repeat1 = 361,
  aux_sym_argument_list_repeat1 = 362,
  aux_sym_initializer_list_repeat1 = 363,
  aux_sym_initializer_pair_repeat1 = 364,
  aux_sym_concatenated_string_repeat1 = 365,
  aux_sym_string_literal_repeat1 = 366,
  aux_sym_base_class_clause_repeat1 = 367,
  aux_sym_template_parameter_list_repeat1 = 368,
  aux_sym_field_initializer_list_repeat1 = 369,
  aux_sym_structured_binding_declarator_repeat1 = 370,
  aux_sym_throw_specifier_repeat1 = 371,
  aux_sym_template_argument_list_repeat1 = 372,
  aux_sym_try_statement_repeat1 = 373,
  aux_sym_attribute_repeat1 = 374,
  alias_sym_field_identifier = 375,
  alias_sym_namespace_identifier = 376,
  alias_sym_statement_identifier = 377,
  alias_sym_type_identifier = 378,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [aux_sym_preproc_include_token1] = "#include",
  [anon_sym_LF] = "\n",
  [aux_sym_preproc_def_token1] = "#define",
  [anon_sym_LPAREN] = "(",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [aux_sym_preproc_if_token1] = "#if",
  [aux_sym_preproc_if_token2] = "#endif",
  [aux_sym_preproc_ifdef_token1] = "#ifdef",
  [aux_sym_preproc_ifdef_token2] = "#ifndef",
  [aux_sym_preproc_else_token1] = "#else",
  [aux_sym_preproc_elif_token1] = "#elif",
  [sym_preproc_directive] = "preproc_directive",
  [sym_preproc_arg] = "preproc_arg",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_defined] = "defined",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym___device__] = "__device__",
  [anon_sym___host__] = "__host__",
  [anon_sym___global__] = "__global__",
  [anon_sym___forceinline__] = "__forceinline__",
  [anon_sym_SEMI] = ";",
  [anon_sym_typedef] = "typedef",
  [anon_sym_extern] = "extern",
  [anon_sym___attribute__] = "__attribute__",
  [anon_sym___declspec] = "__declspec",
  [anon_sym___based] = "__based",
  [anon_sym___cdecl] = "__cdecl",
  [anon_sym___clrcall] = "__clrcall",
  [anon_sym___stdcall] = "__stdcall",
  [anon_sym___fastcall] = "__fastcall",
  [anon_sym___thiscall] = "__thiscall",
  [anon_sym___vectorcall] = "__vectorcall",
  [sym_ms_restrict_modifier] = "ms_restrict_modifier",
  [sym_ms_unsigned_ptr_modifier] = "ms_unsigned_ptr_modifier",
  [sym_ms_signed_ptr_modifier] = "ms_signed_ptr_modifier",
  [anon_sym__unaligned] = "_unaligned",
  [anon_sym___unaligned] = "__unaligned",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_EQ] = "=",
  [anon_sym_static] = "static",
  [anon_sym_register] = "register",
  [anon_sym_inline] = "inline",
  [anon_sym_const] = "const",
  [anon_sym_volatile] = "volatile",
  [anon_sym_restrict] = "restrict",
  [anon_sym__Atomic] = "_Atomic",
  [anon_sym_mutable] = "mutable",
  [anon_sym_constexpr] = "constexpr",
  [anon_sym___shared__] = "__shared__",
  [anon_sym___local__] = "__local__",
  [anon_sym___constant__] = "__constant__",
  [anon_sym___restrict__] = "__restrict__",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_long] = "long",
  [anon_sym_short] = "short",
  [sym_primitive_type] = "primitive_type",
  [anon_sym_enum] = "enum",
  [anon_sym_class] = "class",
  [anon_sym_struct] = "struct",
  [anon_sym_union] = "union",
  [anon_sym_COLON] = ":",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_for] = "for",
  [anon_sym_return] = "return",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_goto] = "goto",
  [anon_sym_QMARK] = "\?",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_sizeof] = "sizeof",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH_GT] = "->",
  [sym_number_literal] = "number_literal",
  [anon_sym_L_SQUOTE] = "L'",
  [anon_sym_u_SQUOTE] = "u'",
  [anon_sym_U_SQUOTE] = "U'",
  [anon_sym_u8_SQUOTE] = "u8'",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_char_literal_token1] = "char_literal_token1",
  [anon_sym_L_DQUOTE] = "L\"",
  [anon_sym_u_DQUOTE] = "u\"",
  [anon_sym_U_DQUOTE] = "U\"",
  [anon_sym_u8_DQUOTE] = "u8\"",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_literal_token1] = "string_literal_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_system_lib_string] = "system_lib_string",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_comment] = "comment",
  [anon_sym_decltype] = "decltype",
  [anon_sym_final] = "final",
  [anon_sym_override] = "override",
  [anon_sym_virtual] = "virtual",
  [anon_sym_explicit] = "explicit",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [sym_auto] = "auto",
  [anon_sym_typename] = "typename",
  [anon_sym_template] = "template",
  [anon_sym_GT2] = ">",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_operator] = "operator",
  [anon_sym_delete] = "delete",
  [anon_sym_friend] = "friend",
  [anon_sym_noexcept] = "noexcept",
  [anon_sym_throw] = "throw",
  [anon_sym_namespace] = "namespace",
  [anon_sym_using] = "using",
  [anon_sym_static_assert] = "static_assert",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_new] = "new",
  [sym_operator_name] = "operator_name",
  [sym_this] = "this",
  [sym_nullptr] = "nullptr",
  [aux_sym_kernel_call_syntax_token1] = "<<<",
  [aux_sym_kernel_call_syntax_token2] = ">>>",
  [sym_raw_string_literal] = "raw_string_literal",
  [sym_translation_unit] = "translation_unit",
  [sym_preproc_include] = "preproc_include",
  [sym_preproc_def] = "preproc_def",
  [sym_preproc_function_def] = "preproc_function_def",
  [sym_preproc_params] = "preproc_params",
  [sym_preproc_call] = "preproc_call",
  [sym_preproc_if] = "preproc_if",
  [sym_preproc_ifdef] = "preproc_ifdef",
  [sym_preproc_else] = "preproc_else",
  [sym_preproc_elif] = "preproc_elif",
  [sym_preproc_if_in_field_declaration_list] = "preproc_if",
  [sym_preproc_ifdef_in_field_declaration_list] = "preproc_ifdef",
  [sym_preproc_else_in_field_declaration_list] = "preproc_else",
  [sym_preproc_elif_in_field_declaration_list] = "preproc_elif",
  [sym__preproc_expression] = "_preproc_expression",
  [sym_preproc_parenthesized_expression] = "parenthesized_expression",
  [sym_preproc_defined] = "preproc_defined",
  [sym_preproc_unary_expression] = "unary_expression",
  [sym_preproc_call_expression] = "call_expression",
  [sym_preproc_argument_list] = "argument_list",
  [sym_preproc_binary_expression] = "binary_expression",
  [sym_function_definition] = "function_definition",
  [sym_declaration] = "declaration",
  [sym_type_definition] = "type_definition",
  [sym__declaration_specifiers] = "_declaration_specifiers",
  [sym_linkage_specification] = "linkage_specification",
  [sym_attribute_specifier] = "attribute_specifier",
  [sym_ms_declspec_modifier] = "ms_declspec_modifier",
  [sym_ms_based_modifier] = "ms_based_modifier",
  [sym_ms_call_modifier] = "ms_call_modifier",
  [sym_ms_unaligned_ptr_modifier] = "ms_unaligned_ptr_modifier",
  [sym_ms_pointer_modifier] = "ms_pointer_modifier",
  [sym_declaration_list] = "declaration_list",
  [sym__declarator] = "_declarator",
  [sym__field_declarator] = "_field_declarator",
  [sym__type_declarator] = "_type_declarator",
  [sym__abstract_declarator] = "_abstract_declarator",
  [sym_parenthesized_declarator] = "parenthesized_declarator",
  [sym_parenthesized_field_declarator] = "parenthesized_declarator",
  [sym_parenthesized_type_declarator] = "parenthesized_declarator",
  [sym_abstract_parenthesized_declarator] = "abstract_parenthesized_declarator",
  [sym_pointer_declarator] = "pointer_declarator",
  [sym_pointer_field_declarator] = "pointer_declarator",
  [sym_pointer_type_declarator] = "pointer_declarator",
  [sym_abstract_pointer_declarator] = "abstract_pointer_declarator",
  [sym_function_declarator] = "function_declarator",
  [sym_function_field_declarator] = "function_declarator",
  [sym_function_type_declarator] = "function_declarator",
  [sym_abstract_function_declarator] = "abstract_function_declarator",
  [sym_array_declarator] = "array_declarator",
  [sym_array_field_declarator] = "array_declarator",
  [sym_array_type_declarator] = "array_declarator",
  [sym_abstract_array_declarator] = "abstract_array_declarator",
  [sym_init_declarator] = "init_declarator",
  [sym_compound_statement] = "compound_statement",
  [sym_storage_class_specifier] = "storage_class_specifier",
  [sym_type_qualifier] = "type_qualifier",
  [sym__type_specifier] = "_type_specifier",
  [sym_sized_type_specifier] = "sized_type_specifier",
  [sym_enum_specifier] = "enum_specifier",
  [sym_enumerator_list] = "enumerator_list",
  [sym_struct_specifier] = "struct_specifier",
  [sym_union_specifier] = "union_specifier",
  [sym_field_declaration_list] = "field_declaration_list",
  [sym__field_declaration_list_item] = "_field_declaration_list_item",
  [sym_field_declaration] = "field_declaration",
  [sym_bitfield_clause] = "bitfield_clause",
  [sym_enumerator] = "enumerator",
  [sym_parameter_list] = "parameter_list",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym_labeled_statement] = "labeled_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_case_statement] = "case_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_for_statement] = "for_statement",
  [sym_return_statement] = "return_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_goto_statement] = "goto_statement",
  [sym__expression] = "_expression",
  [sym_comma_expression] = "comma_expression",
  [sym_conditional_expression] = "conditional_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_pointer_expression] = "pointer_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_update_expression] = "update_expression",
  [sym_cast_expression] = "cast_expression",
  [sym_type_descriptor] = "type_descriptor",
  [sym_sizeof_expression] = "sizeof_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_call_expression] = "call_expression",
  [sym_argument_list] = "argument_list",
  [sym_field_expression] = "field_expression",
  [sym_compound_literal_expression] = "compound_literal_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_initializer_list] = "initializer_list",
  [sym_initializer_pair] = "initializer_pair",
  [sym_subscript_designator] = "subscript_designator",
  [sym_field_designator] = "field_designator",
  [sym_char_literal] = "char_literal",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string_literal] = "string_literal",
  [sym__empty_declaration] = "_empty_declaration",
  [sym_decltype] = "decltype",
  [sym_class_specifier] = "class_specifier",
  [sym__class_name] = "_class_name",
  [sym_virtual_specifier] = "virtual_specifier",
  [sym_virtual_function_specifier] = "virtual_function_specifier",
  [sym_explicit_function_specifier] = "explicit_function_specifier",
  [sym_base_class_clause] = "base_class_clause",
  [sym__enum_base_clause] = "_enum_base_clause",
  [sym_dependent_type] = "dependent_type",
  [sym_template_declaration] = "template_declaration",
  [sym_template_instantiation] = "template_instantiation",
  [sym_template_parameter_list] = "template_parameter_list",
  [sym_type_parameter_declaration] = "type_parameter_declaration",
  [sym_variadic_type_parameter_declaration] = "variadic_type_parameter_declaration",
  [sym_optional_type_parameter_declaration] = "optional_type_parameter_declaration",
  [sym_template_template_parameter_declaration] = "template_template_parameter_declaration",
  [sym_optional_parameter_declaration] = "optional_parameter_declaration",
  [sym_variadic_parameter_declaration] = "variadic_parameter_declaration",
  [sym_variadic_declarator] = "variadic_declarator",
  [sym_variadic_reference_declarator] = "reference_declarator",
  [sym_operator_cast] = "operator_cast",
  [sym_field_initializer_list] = "field_initializer_list",
  [sym_field_initializer] = "field_initializer",
  [sym_inline_method_definition] = "function_definition",
  [aux_sym__constructor_specifiers] = "_constructor_specifiers",
  [sym_operator_cast_definition] = "function_definition",
  [sym_operator_cast_declaration] = "declaration",
  [sym_constructor_or_destructor_definition] = "function_definition",
  [sym_constructor_or_destructor_declaration] = "declaration",
  [sym_default_method_clause] = "default_method_clause",
  [sym_delete_method_clause] = "delete_method_clause",
  [sym_friend_declaration] = "friend_declaration",
  [sym_access_specifier] = "access_specifier",
  [sym_reference_declarator] = "reference_declarator",
  [sym_reference_field_declarator] = "reference_declarator",
  [sym_abstract_reference_declarator] = "abstract_reference_declarator",
  [sym_structured_binding_declarator] = "structured_binding_declarator",
  [sym_trailing_return_type] = "trailing_return_type",
  [sym_noexcept] = "noexcept",
  [sym_throw_specifier] = "throw_specifier",
  [sym_template_type] = "template_type",
  [sym_template_method] = "template_method",
  [sym_template_function] = "template_function",
  [sym_template_argument_list] = "template_argument_list",
  [sym_namespace_definition] = "namespace_definition",
  [sym_using_declaration] = "using_declaration",
  [sym_alias_declaration] = "alias_declaration",
  [sym_static_assert_declaration] = "static_assert_declaration",
  [sym_condition_clause] = "condition_clause",
  [sym_condition_declaration] = "declaration",
  [sym_for_range_loop] = "for_range_loop",
  [sym_throw_statement] = "throw_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_attribute] = "attribute",
  [sym_new_expression] = "new_expression",
  [sym_new_declarator] = "new_declarator",
  [sym_delete_expression] = "delete_expression",
  [sym_lambda_expression] = "lambda_expression",
  [sym_lambda_capture_specifier] = "lambda_capture_specifier",
  [sym_lambda_default_capture] = "lambda_default_capture",
  [sym_parameter_pack_expansion] = "parameter_pack_expansion",
  [sym_type_parameter_pack_expansion] = "parameter_pack_expansion",
  [sym_destructor_name] = "destructor_name",
  [sym_scoped_field_identifier] = "scoped_field_identifier",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_scoped_type_identifier] = "scoped_type_identifier",
  [sym_scoped_namespace_identifier] = "scoped_namespace_identifier",
  [sym_kernel_call_syntax] = "kernel_call_syntax",
  [aux_sym_translation_unit_repeat1] = "translation_unit_repeat1",
  [aux_sym_preproc_params_repeat1] = "preproc_params_repeat1",
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = "preproc_if_in_field_declaration_list_repeat1",
  [aux_sym_preproc_argument_list_repeat1] = "preproc_argument_list_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_function_definition_repeat2] = "function_definition_repeat2",
  [aux_sym_declaration_repeat1] = "declaration_repeat1",
  [aux_sym_type_definition_repeat1] = "type_definition_repeat1",
  [aux_sym_type_definition_repeat2] = "type_definition_repeat2",
  [aux_sym__declaration_specifiers_repeat1] = "_declaration_specifiers_repeat1",
  [aux_sym_pointer_declarator_repeat1] = "pointer_declarator_repeat1",
  [aux_sym_function_declarator_repeat1] = "function_declarator_repeat1",
  [aux_sym_function_declarator_repeat2] = "function_declarator_repeat2",
  [aux_sym_abstract_function_declarator_repeat1] = "abstract_function_declarator_repeat1",
  [aux_sym_sized_type_specifier_repeat1] = "sized_type_specifier_repeat1",
  [aux_sym_enumerator_list_repeat1] = "enumerator_list_repeat1",
  [aux_sym_field_declaration_repeat1] = "field_declaration_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_initializer_list_repeat1] = "initializer_list_repeat1",
  [aux_sym_initializer_pair_repeat1] = "initializer_pair_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym_base_class_clause_repeat1] = "base_class_clause_repeat1",
  [aux_sym_template_parameter_list_repeat1] = "template_parameter_list_repeat1",
  [aux_sym_field_initializer_list_repeat1] = "field_initializer_list_repeat1",
  [aux_sym_structured_binding_declarator_repeat1] = "structured_binding_declarator_repeat1",
  [aux_sym_throw_specifier_repeat1] = "throw_specifier_repeat1",
  [aux_sym_template_argument_list_repeat1] = "template_argument_list_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_attribute_repeat1] = "attribute_repeat1",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_namespace_identifier] = "namespace_identifier",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [aux_sym_preproc_include_token1] = aux_sym_preproc_include_token1,
  [anon_sym_LF] = anon_sym_LF,
  [aux_sym_preproc_def_token1] = aux_sym_preproc_def_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_preproc_if_token1] = aux_sym_preproc_if_token1,
  [aux_sym_preproc_if_token2] = aux_sym_preproc_if_token2,
  [aux_sym_preproc_ifdef_token1] = aux_sym_preproc_ifdef_token1,
  [aux_sym_preproc_ifdef_token2] = aux_sym_preproc_ifdef_token2,
  [aux_sym_preproc_else_token1] = aux_sym_preproc_else_token1,
  [aux_sym_preproc_elif_token1] = aux_sym_preproc_elif_token1,
  [sym_preproc_directive] = sym_preproc_directive,
  [sym_preproc_arg] = sym_preproc_arg,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_defined] = anon_sym_defined,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym___device__] = anon_sym___device__,
  [anon_sym___host__] = anon_sym___host__,
  [anon_sym___global__] = anon_sym___global__,
  [anon_sym___forceinline__] = anon_sym___forceinline__,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_typedef] = anon_sym_typedef,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym___attribute__] = anon_sym___attribute__,
  [anon_sym___declspec] = anon_sym___declspec,
  [anon_sym___based] = anon_sym___based,
  [anon_sym___cdecl] = anon_sym___cdecl,
  [anon_sym___clrcall] = anon_sym___clrcall,
  [anon_sym___stdcall] = anon_sym___stdcall,
  [anon_sym___fastcall] = anon_sym___fastcall,
  [anon_sym___thiscall] = anon_sym___thiscall,
  [anon_sym___vectorcall] = anon_sym___vectorcall,
  [sym_ms_restrict_modifier] = sym_ms_restrict_modifier,
  [sym_ms_unsigned_ptr_modifier] = sym_ms_unsigned_ptr_modifier,
  [sym_ms_signed_ptr_modifier] = sym_ms_signed_ptr_modifier,
  [anon_sym__unaligned] = anon_sym__unaligned,
  [anon_sym___unaligned] = anon_sym___unaligned,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_register] = anon_sym_register,
  [anon_sym_inline] = anon_sym_inline,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_restrict] = anon_sym_restrict,
  [anon_sym__Atomic] = anon_sym__Atomic,
  [anon_sym_mutable] = anon_sym_mutable,
  [anon_sym_constexpr] = anon_sym_constexpr,
  [anon_sym___shared__] = anon_sym___shared__,
  [anon_sym___local__] = anon_sym___local__,
  [anon_sym___constant__] = anon_sym___constant__,
  [anon_sym___restrict__] = anon_sym___restrict__,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_short] = anon_sym_short,
  [sym_primitive_type] = sym_primitive_type,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_sizeof] = anon_sym_sizeof,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [sym_number_literal] = sym_number_literal,
  [anon_sym_L_SQUOTE] = anon_sym_L_SQUOTE,
  [anon_sym_u_SQUOTE] = anon_sym_u_SQUOTE,
  [anon_sym_U_SQUOTE] = anon_sym_U_SQUOTE,
  [anon_sym_u8_SQUOTE] = anon_sym_u8_SQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_char_literal_token1] = aux_sym_char_literal_token1,
  [anon_sym_L_DQUOTE] = anon_sym_L_DQUOTE,
  [anon_sym_u_DQUOTE] = anon_sym_u_DQUOTE,
  [anon_sym_U_DQUOTE] = anon_sym_U_DQUOTE,
  [anon_sym_u8_DQUOTE] = anon_sym_u8_DQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_system_lib_string] = sym_system_lib_string,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_comment] = sym_comment,
  [anon_sym_decltype] = anon_sym_decltype,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_virtual] = anon_sym_virtual,
  [anon_sym_explicit] = anon_sym_explicit,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [sym_auto] = sym_auto,
  [anon_sym_typename] = anon_sym_typename,
  [anon_sym_template] = anon_sym_template,
  [anon_sym_GT2] = anon_sym_GT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_operator] = anon_sym_operator,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_friend] = anon_sym_friend,
  [anon_sym_noexcept] = anon_sym_noexcept,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_static_assert] = anon_sym_static_assert,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym_new] = anon_sym_new,
  [sym_operator_name] = sym_operator_name,
  [sym_this] = sym_this,
  [sym_nullptr] = sym_nullptr,
  [aux_sym_kernel_call_syntax_token1] = aux_sym_kernel_call_syntax_token1,
  [aux_sym_kernel_call_syntax_token2] = aux_sym_kernel_call_syntax_token2,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [sym_translation_unit] = sym_translation_unit,
  [sym_preproc_include] = sym_preproc_include,
  [sym_preproc_def] = sym_preproc_def,
  [sym_preproc_function_def] = sym_preproc_function_def,
  [sym_preproc_params] = sym_preproc_params,
  [sym_preproc_call] = sym_preproc_call,
  [sym_preproc_if] = sym_preproc_if,
  [sym_preproc_ifdef] = sym_preproc_ifdef,
  [sym_preproc_else] = sym_preproc_else,
  [sym_preproc_elif] = sym_preproc_elif,
  [sym_preproc_if_in_field_declaration_list] = sym_preproc_if,
  [sym_preproc_ifdef_in_field_declaration_list] = sym_preproc_ifdef,
  [sym_preproc_else_in_field_declaration_list] = sym_preproc_else,
  [sym_preproc_elif_in_field_declaration_list] = sym_preproc_elif,
  [sym__preproc_expression] = sym__preproc_expression,
  [sym_preproc_parenthesized_expression] = sym_parenthesized_expression,
  [sym_preproc_defined] = sym_preproc_defined,
  [sym_preproc_unary_expression] = sym_unary_expression,
  [sym_preproc_call_expression] = sym_call_expression,
  [sym_preproc_argument_list] = sym_argument_list,
  [sym_preproc_binary_expression] = sym_binary_expression,
  [sym_function_definition] = sym_function_definition,
  [sym_declaration] = sym_declaration,
  [sym_type_definition] = sym_type_definition,
  [sym__declaration_specifiers] = sym__declaration_specifiers,
  [sym_linkage_specification] = sym_linkage_specification,
  [sym_attribute_specifier] = sym_attribute_specifier,
  [sym_ms_declspec_modifier] = sym_ms_declspec_modifier,
  [sym_ms_based_modifier] = sym_ms_based_modifier,
  [sym_ms_call_modifier] = sym_ms_call_modifier,
  [sym_ms_unaligned_ptr_modifier] = sym_ms_unaligned_ptr_modifier,
  [sym_ms_pointer_modifier] = sym_ms_pointer_modifier,
  [sym_declaration_list] = sym_declaration_list,
  [sym__declarator] = sym__declarator,
  [sym__field_declarator] = sym__field_declarator,
  [sym__type_declarator] = sym__type_declarator,
  [sym__abstract_declarator] = sym__abstract_declarator,
  [sym_parenthesized_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_field_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_type_declarator] = sym_parenthesized_declarator,
  [sym_abstract_parenthesized_declarator] = sym_abstract_parenthesized_declarator,
  [sym_pointer_declarator] = sym_pointer_declarator,
  [sym_pointer_field_declarator] = sym_pointer_declarator,
  [sym_pointer_type_declarator] = sym_pointer_declarator,
  [sym_abstract_pointer_declarator] = sym_abstract_pointer_declarator,
  [sym_function_declarator] = sym_function_declarator,
  [sym_function_field_declarator] = sym_function_declarator,
  [sym_function_type_declarator] = sym_function_declarator,
  [sym_abstract_function_declarator] = sym_abstract_function_declarator,
  [sym_array_declarator] = sym_array_declarator,
  [sym_array_field_declarator] = sym_array_declarator,
  [sym_array_type_declarator] = sym_array_declarator,
  [sym_abstract_array_declarator] = sym_abstract_array_declarator,
  [sym_init_declarator] = sym_init_declarator,
  [sym_compound_statement] = sym_compound_statement,
  [sym_storage_class_specifier] = sym_storage_class_specifier,
  [sym_type_qualifier] = sym_type_qualifier,
  [sym__type_specifier] = sym__type_specifier,
  [sym_sized_type_specifier] = sym_sized_type_specifier,
  [sym_enum_specifier] = sym_enum_specifier,
  [sym_enumerator_list] = sym_enumerator_list,
  [sym_struct_specifier] = sym_struct_specifier,
  [sym_union_specifier] = sym_union_specifier,
  [sym_field_declaration_list] = sym_field_declaration_list,
  [sym__field_declaration_list_item] = sym__field_declaration_list_item,
  [sym_field_declaration] = sym_field_declaration,
  [sym_bitfield_clause] = sym_bitfield_clause,
  [sym_enumerator] = sym_enumerator,
  [sym_parameter_list] = sym_parameter_list,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_case_statement] = sym_case_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym__expression] = sym__expression,
  [sym_comma_expression] = sym_comma_expression,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_pointer_expression] = sym_pointer_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_type_descriptor] = sym_type_descriptor,
  [sym_sizeof_expression] = sym_sizeof_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_argument_list] = sym_argument_list,
  [sym_field_expression] = sym_field_expression,
  [sym_compound_literal_expression] = sym_compound_literal_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_initializer_list] = sym_initializer_list,
  [sym_initializer_pair] = sym_initializer_pair,
  [sym_subscript_designator] = sym_subscript_designator,
  [sym_field_designator] = sym_field_designator,
  [sym_char_literal] = sym_char_literal,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string_literal] = sym_string_literal,
  [sym__empty_declaration] = sym__empty_declaration,
  [sym_decltype] = sym_decltype,
  [sym_class_specifier] = sym_class_specifier,
  [sym__class_name] = sym__class_name,
  [sym_virtual_specifier] = sym_virtual_specifier,
  [sym_virtual_function_specifier] = sym_virtual_function_specifier,
  [sym_explicit_function_specifier] = sym_explicit_function_specifier,
  [sym_base_class_clause] = sym_base_class_clause,
  [sym__enum_base_clause] = sym__enum_base_clause,
  [sym_dependent_type] = sym_dependent_type,
  [sym_template_declaration] = sym_template_declaration,
  [sym_template_instantiation] = sym_template_instantiation,
  [sym_template_parameter_list] = sym_template_parameter_list,
  [sym_type_parameter_declaration] = sym_type_parameter_declaration,
  [sym_variadic_type_parameter_declaration] = sym_variadic_type_parameter_declaration,
  [sym_optional_type_parameter_declaration] = sym_optional_type_parameter_declaration,
  [sym_template_template_parameter_declaration] = sym_template_template_parameter_declaration,
  [sym_optional_parameter_declaration] = sym_optional_parameter_declaration,
  [sym_variadic_parameter_declaration] = sym_variadic_parameter_declaration,
  [sym_variadic_declarator] = sym_variadic_declarator,
  [sym_variadic_reference_declarator] = sym_reference_declarator,
  [sym_operator_cast] = sym_operator_cast,
  [sym_field_initializer_list] = sym_field_initializer_list,
  [sym_field_initializer] = sym_field_initializer,
  [sym_inline_method_definition] = sym_function_definition,
  [aux_sym__constructor_specifiers] = aux_sym__constructor_specifiers,
  [sym_operator_cast_definition] = sym_function_definition,
  [sym_operator_cast_declaration] = sym_declaration,
  [sym_constructor_or_destructor_definition] = sym_function_definition,
  [sym_constructor_or_destructor_declaration] = sym_declaration,
  [sym_default_method_clause] = sym_default_method_clause,
  [sym_delete_method_clause] = sym_delete_method_clause,
  [sym_friend_declaration] = sym_friend_declaration,
  [sym_access_specifier] = sym_access_specifier,
  [sym_reference_declarator] = sym_reference_declarator,
  [sym_reference_field_declarator] = sym_reference_declarator,
  [sym_abstract_reference_declarator] = sym_abstract_reference_declarator,
  [sym_structured_binding_declarator] = sym_structured_binding_declarator,
  [sym_trailing_return_type] = sym_trailing_return_type,
  [sym_noexcept] = sym_noexcept,
  [sym_throw_specifier] = sym_throw_specifier,
  [sym_template_type] = sym_template_type,
  [sym_template_method] = sym_template_method,
  [sym_template_function] = sym_template_function,
  [sym_template_argument_list] = sym_template_argument_list,
  [sym_namespace_definition] = sym_namespace_definition,
  [sym_using_declaration] = sym_using_declaration,
  [sym_alias_declaration] = sym_alias_declaration,
  [sym_static_assert_declaration] = sym_static_assert_declaration,
  [sym_condition_clause] = sym_condition_clause,
  [sym_condition_declaration] = sym_declaration,
  [sym_for_range_loop] = sym_for_range_loop,
  [sym_throw_statement] = sym_throw_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_attribute] = sym_attribute,
  [sym_new_expression] = sym_new_expression,
  [sym_new_declarator] = sym_new_declarator,
  [sym_delete_expression] = sym_delete_expression,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_lambda_capture_specifier] = sym_lambda_capture_specifier,
  [sym_lambda_default_capture] = sym_lambda_default_capture,
  [sym_parameter_pack_expansion] = sym_parameter_pack_expansion,
  [sym_type_parameter_pack_expansion] = sym_parameter_pack_expansion,
  [sym_destructor_name] = sym_destructor_name,
  [sym_scoped_field_identifier] = sym_scoped_field_identifier,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_scoped_type_identifier] = sym_scoped_type_identifier,
  [sym_scoped_namespace_identifier] = sym_scoped_namespace_identifier,
  [sym_kernel_call_syntax] = sym_kernel_call_syntax,
  [aux_sym_translation_unit_repeat1] = aux_sym_translation_unit_repeat1,
  [aux_sym_preproc_params_repeat1] = aux_sym_preproc_params_repeat1,
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = aux_sym_preproc_if_in_field_declaration_list_repeat1,
  [aux_sym_preproc_argument_list_repeat1] = aux_sym_preproc_argument_list_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_function_definition_repeat2] = aux_sym_function_definition_repeat2,
  [aux_sym_declaration_repeat1] = aux_sym_declaration_repeat1,
  [aux_sym_type_definition_repeat1] = aux_sym_type_definition_repeat1,
  [aux_sym_type_definition_repeat2] = aux_sym_type_definition_repeat2,
  [aux_sym__declaration_specifiers_repeat1] = aux_sym__declaration_specifiers_repeat1,
  [aux_sym_pointer_declarator_repeat1] = aux_sym_pointer_declarator_repeat1,
  [aux_sym_function_declarator_repeat1] = aux_sym_function_declarator_repeat1,
  [aux_sym_function_declarator_repeat2] = aux_sym_function_declarator_repeat2,
  [aux_sym_abstract_function_declarator_repeat1] = aux_sym_abstract_function_declarator_repeat1,
  [aux_sym_sized_type_specifier_repeat1] = aux_sym_sized_type_specifier_repeat1,
  [aux_sym_enumerator_list_repeat1] = aux_sym_enumerator_list_repeat1,
  [aux_sym_field_declaration_repeat1] = aux_sym_field_declaration_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_case_statement_repeat1] = aux_sym_case_statement_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_initializer_list_repeat1] = aux_sym_initializer_list_repeat1,
  [aux_sym_initializer_pair_repeat1] = aux_sym_initializer_pair_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym_base_class_clause_repeat1] = aux_sym_base_class_clause_repeat1,
  [aux_sym_template_parameter_list_repeat1] = aux_sym_template_parameter_list_repeat1,
  [aux_sym_field_initializer_list_repeat1] = aux_sym_field_initializer_list_repeat1,
  [aux_sym_structured_binding_declarator_repeat1] = aux_sym_structured_binding_declarator_repeat1,
  [aux_sym_throw_specifier_repeat1] = aux_sym_throw_specifier_repeat1,
  [aux_sym_template_argument_list_repeat1] = aux_sym_template_argument_list_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_attribute_repeat1] = aux_sym_attribute_repeat1,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_namespace_identifier] = alias_sym_namespace_identifier,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_preproc_include_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_def_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_else_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elif_token1] = {
    .visible = true,
    .named = false,
  },
  [sym_preproc_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_arg] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defined] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___device__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___host__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___global__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___forceinline__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typedef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___attribute__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___declspec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___based] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___cdecl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___clrcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___stdcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___fastcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___thiscall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___vectorcall] = {
    .visible = true,
    .named = false,
  },
  [sym_ms_restrict_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unsigned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_signed_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_register] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_restrict] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Atomic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mutable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constexpr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___shared__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___local__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___constant__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___restrict__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sizeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_char_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_L_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_system_lib_string] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_decltype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_virtual] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_explicit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [sym_auto] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_typename] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_template] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_operator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_friend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noexcept] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [sym_operator_name] = {
    .visible = true,
    .named = true,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_nullptr] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_kernel_call_syntax_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_kernel_call_syntax_token2] = {
    .visible = true,
    .named = false,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_translation_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_include] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_params] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__preproc_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_preproc_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_defined] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration_specifiers] = {
    .visible = false,
    .named = true,
  },
  [sym_linkage_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_declspec_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_based_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_call_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unaligned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_pointer_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__field_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__type_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__abstract_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_init_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_class_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym__type_specifier] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_sized_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_union_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__field_declaration_list_item] = {
    .visible = false,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_bitfield_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_comma_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym_sizeof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_literal_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_list] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_field_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_char_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_decltype] = {
    .visible = true,
    .named = true,
  },
  [sym_class_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__class_name] = {
    .visible = false,
    .named = true,
  },
  [sym_virtual_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_virtual_function_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_explicit_function_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_base_class_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__enum_base_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_dependent_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_template_instantiation] = {
    .visible = true,
    .named = true,
  },
  [sym_template_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_type_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_template_template_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_reference_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_field_initializer_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_method_definition] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__constructor_specifiers] = {
    .visible = false,
    .named = false,
  },
  [sym_operator_cast_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_cast_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_or_destructor_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_or_destructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_default_method_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_method_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_friend_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_access_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_reference_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_structured_binding_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_trailing_return_type] = {
    .visible = true,
    .named = true,
  },
  [sym_noexcept] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_template_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_method] = {
    .visible = true,
    .named = true,
  },
  [sym_template_function] = {
    .visible = true,
    .named = true,
  },
  [sym_template_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_using_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_static_assert_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_for_range_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_capture_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_default_capture] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_pack_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_pack_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_destructor_name] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_namespace_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_kernel_call_syntax] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_translation_unit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_params_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_definition_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__declaration_specifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pointer_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_declarator_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_abstract_function_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sized_type_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_pair_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_base_class_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_initializer_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_structured_binding_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_throw_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_namespace_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_base = 4,
  field_body = 5,
  field_captures = 6,
  field_condition = 7,
  field_consequence = 8,
  field_declarator = 9,
  field_default_type = 10,
  field_default_value = 11,
  field_designator = 12,
  field_directive = 13,
  field_field = 14,
  field_function = 15,
  field_index = 16,
  field_initializer = 17,
  field_label = 18,
  field_left = 19,
  field_length = 20,
  field_message = 21,
  field_name = 22,
  field_namespace = 23,
  field_operator = 24,
  field_parameters = 25,
  field_path = 26,
  field_pattern = 27,
  field_placement = 28,
  field_right = 29,
  field_size = 30,
  field_type = 31,
  field_update = 32,
  field_value = 33,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_base] = "base",
  [field_body] = "body",
  [field_captures] = "captures",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_declarator] = "declarator",
  [field_default_type] = "default_type",
  [field_default_value] = "default_value",
  [field_designator] = "designator",
  [field_directive] = "directive",
  [field_field] = "field",
  [field_function] = "function",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_label] = "label",
  [field_left] = "left",
  [field_length] = "length",
  [field_message] = "message",
  [field_name] = "name",
  [field_namespace] = "namespace",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_pattern] = "pattern",
  [field_placement] = "placement",
  [field_right] = "right",
  [field_size] = "size",
  [field_type] = "type",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 2},
  [5] = {.index = 4, .length = 1},
  [6] = {.index = 5, .length = 2},
  [7] = {.index = 7, .length = 1},
  [8] = {.index = 8, .length = 1},
  [9] = {.index = 9, .length = 1},
  [10] = {.index = 10, .length = 2},
  [11] = {.index = 12, .length = 2},
  [12] = {.index = 12, .length = 2},
  [13] = {.index = 8, .length = 1},
  [14] = {.index = 8, .length = 1},
  [15] = {.index = 14, .length = 1},
  [16] = {.index = 15, .length = 2},
  [17] = {.index = 17, .length = 2},
  [18] = {.index = 19, .length = 1},
  [19] = {.index = 20, .length = 1},
  [20] = {.index = 21, .length = 2},
  [21] = {.index = 10, .length = 2},
  [22] = {.index = 23, .length = 2},
  [23] = {.index = 25, .length = 1},
  [24] = {.index = 14, .length = 1},
  [25] = {.index = 26, .length = 1},
  [26] = {.index = 27, .length = 2},
  [27] = {.index = 29, .length = 2},
  [28] = {.index = 31, .length = 1},
  [29] = {.index = 32, .length = 2},
  [30] = {.index = 34, .length = 1},
  [31] = {.index = 35, .length = 1},
  [32] = {.index = 36, .length = 1},
  [33] = {.index = 37, .length = 2},
  [34] = {.index = 39, .length = 2},
  [35] = {.index = 41, .length = 2},
  [36] = {.index = 43, .length = 2},
  [37] = {.index = 45, .length = 1},
  [38] = {.index = 46, .length = 3},
  [39] = {.index = 49, .length = 1},
  [40] = {.index = 50, .length = 2},
  [41] = {.index = 50, .length = 2},
  [42] = {.index = 50, .length = 2},
  [43] = {.index = 52, .length = 1},
  [44] = {.index = 53, .length = 1},
  [45] = {.index = 54, .length = 1},
  [46] = {.index = 55, .length = 2},
  [47] = {.index = 57, .length = 2},
  [48] = {.index = 59, .length = 2},
  [49] = {.index = 61, .length = 2},
  [50] = {.index = 63, .length = 2},
  [51] = {.index = 65, .length = 3},
  [52] = {.index = 68, .length = 2},
  [53] = {.index = 70, .length = 2},
  [54] = {.index = 72, .length = 2},
  [55] = {.index = 74, .length = 3},
  [56] = {.index = 77, .length = 2},
  [57] = {.index = 79, .length = 2},
  [58] = {.index = 81, .length = 2},
  [59] = {.index = 50, .length = 2},
  [60] = {.index = 50, .length = 2},
  [61] = {.index = 50, .length = 2},
  [62] = {.index = 83, .length = 3},
  [63] = {.index = 86, .length = 2},
  [64] = {.index = 88, .length = 2},
  [65] = {.index = 90, .length = 1},
  [66] = {.index = 91, .length = 2},
  [67] = {.index = 93, .length = 2},
  [68] = {.index = 95, .length = 2},
  [69] = {.index = 97, .length = 1},
  [70] = {.index = 98, .length = 2},
  [71] = {.index = 100, .length = 2},
  [72] = {.index = 102, .length = 1},
  [73] = {.index = 102, .length = 1},
  [74] = {.index = 103, .length = 3},
  [76] = {.index = 106, .length = 1},
  [77] = {.index = 107, .length = 2},
  [78] = {.index = 109, .length = 2},
  [81] = {.index = 111, .length = 1},
  [82] = {.index = 112, .length = 2},
  [83] = {.index = 114, .length = 2},
  [84] = {.index = 116, .length = 2},
  [85] = {.index = 118, .length = 2},
  [86] = {.index = 120, .length = 3},
  [87] = {.index = 123, .length = 3},
  [88] = {.index = 126, .length = 3},
  [89] = {.index = 129, .length = 2},
  [90] = {.index = 131, .length = 3},
  [91] = {.index = 134, .length = 2},
  [92] = {.index = 136, .length = 3},
  [93] = {.index = 139, .length = 2},
  [94] = {.index = 8, .length = 1},
  [95] = {.index = 141, .length = 2},
  [96] = {.index = 12, .length = 2},
  [97] = {.index = 143, .length = 2},
  [98] = {.index = 145, .length = 2},
  [99] = {.index = 147, .length = 1},
  [100] = {.index = 148, .length = 3},
  [101] = {.index = 151, .length = 2},
  [102] = {.index = 153, .length = 2},
  [103] = {.index = 155, .length = 2},
  [104] = {.index = 157, .length = 3},
  [105] = {.index = 160, .length = 2},
  [106] = {.index = 162, .length = 3},
  [107] = {.index = 165, .length = 2},
  [108] = {.index = 167, .length = 2},
  [109] = {.index = 169, .length = 1},
  [110] = {.index = 170, .length = 2},
  [111] = {.index = 172, .length = 2},
  [112] = {.index = 174, .length = 3},
  [113] = {.index = 177, .length = 3},
  [114] = {.index = 180, .length = 2},
  [115] = {.index = 182, .length = 2},
  [116] = {.index = 184, .length = 1},
  [117] = {.index = 185, .length = 3},
  [119] = {.index = 188, .length = 1},
  [120] = {.index = 189, .length = 2},
  [121] = {.index = 191, .length = 3},
  [122] = {.index = 194, .length = 3},
  [123] = {.index = 197, .length = 3},
  [124] = {.index = 200, .length = 2},
  [125] = {.index = 202, .length = 1},
  [126] = {.index = 203, .length = 2},
  [127] = {.index = 205, .length = 1},
  [128] = {.index = 206, .length = 4},
  [129] = {.index = 210, .length = 1},
  [130] = {.index = 211, .length = 2},
  [131] = {.index = 50, .length = 2},
  [132] = {.index = 50, .length = 2},
  [133] = {.index = 213, .length = 3},
  [134] = {.index = 216, .length = 2},
  [135] = {.index = 185, .length = 3},
  [136] = {.index = 218, .length = 1},
  [137] = {.index = 219, .length = 3},
  [138] = {.index = 222, .length = 3},
  [139] = {.index = 225, .length = 2},
  [140] = {.index = 227, .length = 3},
  [141] = {.index = 230, .length = 3},
  [142] = {.index = 233, .length = 2},
  [143] = {.index = 235, .length = 1},
  [144] = {.index = 236, .length = 2},
  [145] = {.index = 238, .length = 3},
  [146] = {.index = 241, .length = 3},
  [147] = {.index = 244, .length = 1},
  [148] = {.index = 245, .length = 2},
  [149] = {.index = 247, .length = 3},
  [150] = {.index = 250, .length = 4},
  [151] = {.index = 254, .length = 3},
  [152] = {.index = 257, .length = 4},
  [153] = {.index = 261, .length = 2},
  [154] = {.index = 263, .length = 3},
  [155] = {.index = 266, .length = 2},
  [156] = {.index = 268, .length = 1},
  [157] = {.index = 269, .length = 1},
  [158] = {.index = 270, .length = 2},
  [159] = {.index = 272, .length = 2},
  [160] = {.index = 274, .length = 2},
  [161] = {.index = 276, .length = 4},
  [162] = {.index = 280, .length = 3},
  [163] = {.index = 283, .length = 4},
  [164] = {.index = 287, .length = 2},
  [165] = {.index = 289, .length = 3},
  [166] = {.index = 292, .length = 3},
  [167] = {.index = 295, .length = 2},
  [168] = {.index = 297, .length = 3},
  [169] = {.index = 300, .length = 4},
  [170] = {.index = 304, .length = 2},
  [171] = {.index = 306, .length = 2},
  [172] = {.index = 308, .length = 4},
  [173] = {.index = 312, .length = 3},
  [174] = {.index = 315, .length = 4},
  [175] = {.index = 319, .length = 3},
  [176] = {.index = 322, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_type, 0},
  [1] =
    {field_directive, 0},
  [2] =
    {field_argument, 1},
    {field_operator, 0},
  [4] =
    {field_declarator, 1},
  [5] =
    {field_arguments, 1},
    {field_function, 0},
  [7] =
    {field_body, 1},
  [8] =
    {field_name, 1},
  [9] =
    {field_value, 1},
  [10] =
    {field_type, 0},
    {field_value, 1},
  [12] =
    {field_arguments, 1},
    {field_name, 0},
  [14] =
    {field_type, 1},
  [15] =
    {field_declarator, 0},
    {field_parameters, 1},
  [17] =
    {field_body, 1},
    {field_declarator, 0},
  [19] =
    {field_declarator, 0},
  [20] =
    {field_pattern, 0},
  [21] =
    {field_argument, 0},
    {field_operator, 1},
  [23] =
    {field_body, 1},
    {field_captures, 0},
  [25] =
    {field_parameters, 0},
  [26] =
    {field_path, 1},
  [27] =
    {field_argument, 1},
    {field_directive, 0},
  [29] =
    {field_declarator, 1},
    {field_type, 0},
  [31] =
    {field_declarator, 2},
  [32] =
    {field_body, 2},
    {field_value, 1},
  [34] =
    {field_name, 0},
  [35] =
    {field_body, 2},
  [36] =
    {field_name, 2},
  [37] =
    {field_body, 2},
    {field_name, 1},
  [39] =
    {field_base, 2, .inherited = true},
    {field_name, 1},
  [41] =
    {field_condition, 1},
    {field_consequence, 2},
  [43] =
    {field_body, 2},
    {field_condition, 1},
  [45] =
    {field_label, 1},
  [46] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [49] =
    {field_label, 0},
  [50] =
    {field_name, 2},
    {field_namespace, 0},
  [52] =
    {field_type, 0, .inherited = true},
  [53] =
    {field_parameters, 1},
  [54] =
    {field_type, 2},
  [55] =
    {field_declarator, 2},
    {field_type, 1, .inherited = true},
  [57] =
    {field_arguments, 2},
    {field_type, 1},
  [59] =
    {field_declarator, 2},
    {field_type, 1},
  [61] =
    {field_placement, 1},
    {field_type, 2},
  [63] =
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [65] =
    {field_body, 2},
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [68] =
    {field_declarator, 0},
    {field_value, 1},
  [70] =
    {field_body, 2},
    {field_declarator, 0},
  [72] =
    {field_left, 0},
    {field_right, 2},
  [74] =
    {field_argument, 0},
    {field_field, 2},
    {field_operator, 1},
  [77] =
    {field_argument, 0},
    {field_field, 2},
  [79] =
    {field_arguments, 2},
    {field_function, 0},
  [81] =
    {field_body, 2},
    {field_declarator, 1},
  [83] =
    {field_body, 2},
    {field_captures, 0},
    {field_declarator, 1},
  [86] =
    {field_name, 1},
    {field_value, 2},
  [88] =
    {field_name, 1},
    {field_parameters, 2},
  [90] =
    {field_condition, 1},
  [91] =
    {field_alternative, 2},
    {field_name, 1},
  [93] =
    {field_declarator, 2},
    {field_type, 0},
  [95] =
    {field_type, 1},
    {field_value, 3},
  [97] =
    {field_declarator, 3},
  [98] =
    {field_body, 3},
    {field_name, 2},
  [100] =
    {field_base, 3, .inherited = true},
    {field_name, 2},
  [102] =
    {field_base, 1},
  [103] =
    {field_base, 2, .inherited = true},
    {field_body, 3},
    {field_name, 1},
  [106] =
    {field_body, 3},
  [107] =
    {field_body, 3},
    {field_name, 1},
  [109] =
    {field_condition, 2},
    {field_consequence, 3},
  [111] =
    {field_type, 1, .inherited = true},
  [112] =
    {field_declarator, 3},
    {field_type, 2, .inherited = true},
  [114] =
    {field_arguments, 3},
    {field_type, 2},
  [116] =
    {field_declarator, 3},
    {field_type, 2},
  [118] =
    {field_placement, 2},
    {field_type, 3},
  [120] =
    {field_arguments, 3},
    {field_declarator, 2},
    {field_type, 1},
  [123] =
    {field_arguments, 3},
    {field_placement, 1},
    {field_type, 2},
  [126] =
    {field_declarator, 3},
    {field_placement, 1},
    {field_type, 2},
  [129] =
    {field_declarator, 0},
    {field_value, 2},
  [131] =
    {field_declarator, 1},
    {field_declarator, 2, .inherited = true},
    {field_type, 0, .inherited = true},
  [134] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [136] =
    {field_body, 3},
    {field_declarator, 2},
    {field_type, 1, .inherited = true},
  [139] =
    {field_declarator, 0},
    {field_size, 2},
  [141] =
    {field_argument, 0},
    {field_index, 2},
  [143] =
    {field_declarator, 0},
    {field_default_value, 2},
  [145] =
    {field_body, 3},
    {field_declarator, 1},
  [147] =
    {field_size, 1},
  [148] =
    {field_name, 1},
    {field_parameters, 2},
    {field_value, 3},
  [151] =
    {field_alternative, 3},
    {field_condition, 1},
  [153] =
    {field_alternative, 3},
    {field_name, 1},
  [155] =
    {field_declarator, 3},
    {field_type, 1},
  [157] =
    {field_declarator, 2},
    {field_declarator, 3, .inherited = true},
    {field_type, 1},
  [160] =
    {field_name, 0},
    {field_value, 2},
  [162] =
    {field_base, 3, .inherited = true},
    {field_body, 4},
    {field_name, 2},
  [165] =
    {field_default_value, 1},
    {field_type, 0, .inherited = true},
  [167] =
    {field_body, 4},
    {field_name, 2},
  [169] =
    {field_body, 4},
  [170] =
    {field_body, 4},
    {field_name, 1},
  [172] =
    {field_initializer, 1},
    {field_value, 2},
  [174] =
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
    {field_value, 2},
  [177] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [180] =
    {field_body, 1},
    {field_condition, 3},
  [182] =
    {field_designator, 0},
    {field_value, 2},
  [184] =
    {field_value, 3},
  [185] =
    {field_declarator, 4},
    {field_namespace, 0},
    {field_type, 3, .inherited = true},
  [188] =
    {field_default_type, 2},
  [189] =
    {field_default_value, 2},
    {field_type, 0, .inherited = true},
  [191] =
    {field_arguments, 4},
    {field_declarator, 3},
    {field_type, 2},
  [194] =
    {field_arguments, 4},
    {field_placement, 2},
    {field_type, 3},
  [197] =
    {field_declarator, 4},
    {field_placement, 2},
    {field_type, 3},
  [200] =
    {field_name, 1},
    {field_type, 3},
  [202] =
    {field_condition, 2},
  [203] =
    {field_body, 2},
    {field_parameters, 1},
  [205] =
    {field_length, 1},
  [206] =
    {field_arguments, 4},
    {field_declarator, 3},
    {field_placement, 1},
    {field_type, 2},
  [210] =
    {field_declarator, 4},
  [211] =
    {field_declarator, 0},
    {field_size, 3},
  [213] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [216] =
    {field_declarator, 1},
    {field_default_value, 3},
  [218] =
    {field_size, 2},
  [219] =
    {field_body, 4},
    {field_declarator, 3},
    {field_type, 2, .inherited = true},
  [222] =
    {field_declarator, 2},
    {field_declarator, 3, .inherited = true},
    {field_type, 1, .inherited = true},
  [225] =
    {field_alternative, 4},
    {field_condition, 1},
  [227] =
    {field_declarator, 3},
    {field_declarator, 4, .inherited = true},
    {field_type, 2},
  [230] =
    {field_declarator, 1},
    {field_default_value, 2},
    {field_type, 0, .inherited = true},
  [233] =
    {field_default_value, 2},
    {field_type, 1, .inherited = true},
  [235] =
    {field_type, 2, .inherited = true},
  [236] =
    {field_body, 5},
    {field_name, 2},
  [238] =
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
    {field_value, 3},
  [241] =
    {field_alternative, 5},
    {field_condition, 2},
    {field_consequence, 3},
  [244] =
    {field_initializer, 2},
  [245] =
    {field_default_type, 3},
    {field_name, 1},
  [247] =
    {field_declarator, 1},
    {field_default_value, 3},
    {field_type, 0, .inherited = true},
  [250] =
    {field_arguments, 5},
    {field_declarator, 4},
    {field_placement, 2},
    {field_type, 3},
  [254] =
    {field_body, 5},
    {field_declarator, 4},
    {field_type, 3, .inherited = true},
  [257] =
    {field_declarator, 1},
    {field_declarator, 2, .inherited = true},
    {field_default_value, 3},
    {field_type, 0, .inherited = true},
  [261] =
    {field_default_value, 3},
    {field_type, 1, .inherited = true},
  [263] =
    {field_declarator, 2},
    {field_default_value, 3},
    {field_type, 1, .inherited = true},
  [266] =
    {field_default_value, 3},
    {field_type, 2, .inherited = true},
  [268] =
    {field_update, 4},
  [269] =
    {field_condition, 3},
  [270] =
    {field_initializer, 2},
    {field_update, 4},
  [272] =
    {field_condition, 3},
    {field_initializer, 2},
  [274] =
    {field_condition, 2},
    {field_message, 4},
  [276] =
    {field_declarator, 1},
    {field_declarator, 2, .inherited = true},
    {field_default_value, 4},
    {field_type, 0, .inherited = true},
  [280] =
    {field_declarator, 2},
    {field_default_value, 4},
    {field_type, 1, .inherited = true},
  [283] =
    {field_declarator, 2},
    {field_declarator, 3, .inherited = true},
    {field_default_value, 4},
    {field_type, 1, .inherited = true},
  [287] =
    {field_default_value, 4},
    {field_type, 2, .inherited = true},
  [289] =
    {field_declarator, 3},
    {field_default_value, 4},
    {field_type, 2, .inherited = true},
  [292] =
    {field_declarator, 3},
    {field_declarator, 4, .inherited = true},
    {field_type, 2, .inherited = true},
  [295] =
    {field_condition, 3},
    {field_update, 5},
  [297] =
    {field_condition, 3},
    {field_initializer, 2},
    {field_update, 5},
  [300] =
    {field_body, 7},
    {field_declarator, 3},
    {field_right, 5},
    {field_type, 2, .inherited = true},
  [304] =
    {field_initializer, 2},
    {field_update, 5},
  [306] =
    {field_condition, 4},
    {field_initializer, 2},
  [308] =
    {field_declarator, 2},
    {field_declarator, 3, .inherited = true},
    {field_default_value, 5},
    {field_type, 1, .inherited = true},
  [312] =
    {field_declarator, 3},
    {field_default_value, 5},
    {field_type, 2, .inherited = true},
  [315] =
    {field_declarator, 3},
    {field_declarator, 4, .inherited = true},
    {field_default_value, 5},
    {field_type, 2, .inherited = true},
  [319] =
    {field_condition, 4},
    {field_initializer, 2},
    {field_update, 6},
  [322] =
    {field_declarator, 3},
    {field_declarator, 4, .inherited = true},
    {field_default_value, 6},
    {field_type, 2, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [10] = {
    [0] = alias_sym_type_identifier,
  },
  [11] = {
    [0] = alias_sym_type_identifier,
  },
  [13] = {
    [1] = alias_sym_type_identifier,
  },
  [14] = {
    [1] = alias_sym_namespace_identifier,
  },
  [24] = {
    [1] = alias_sym_type_identifier,
  },
  [37] = {
    [1] = alias_sym_statement_identifier,
  },
  [39] = {
    [0] = alias_sym_statement_identifier,
  },
  [40] = {
    [0] = alias_sym_namespace_identifier,
  },
  [41] = {
    [0] = alias_sym_namespace_identifier,
    [2] = alias_sym_type_identifier,
  },
  [42] = {
    [0] = alias_sym_namespace_identifier,
    [2] = alias_sym_namespace_identifier,
  },
  [55] = {
    [2] = alias_sym_field_identifier,
  },
  [60] = {
    [2] = alias_sym_type_identifier,
  },
  [61] = {
    [2] = alias_sym_namespace_identifier,
  },
  [72] = {
    [1] = alias_sym_type_identifier,
  },
  [75] = {
    [0] = alias_sym_field_identifier,
  },
  [79] = {
    [1] = alias_sym_field_identifier,
  },
  [80] = {
    [1] = alias_sym_type_identifier,
  },
  [94] = {
    [1] = alias_sym_field_identifier,
  },
  [96] = {
    [0] = alias_sym_field_identifier,
  },
  [117] = {
    [0] = alias_sym_namespace_identifier,
  },
  [118] = {
    [2] = alias_sym_type_identifier,
  },
  [124] = {
    [1] = alias_sym_type_identifier,
  },
  [131] = {
    [0] = alias_sym_namespace_identifier,
    [2] = alias_sym_field_identifier,
  },
  [132] = {
    [2] = alias_sym_field_identifier,
  },
  [148] = {
    [1] = alias_sym_type_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(215);
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '#') ADVANCE(183);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(220);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(282);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(274);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(324);
      if (lookahead == '\\') SKIP(210)
      if (lookahead == ']') ADVANCE(325);
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == 'o') ADVANCE(402);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(213)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(115)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(115)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(117)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(117)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(116)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(116)
      if (lookahead == '\r') SKIP(5)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(129)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(129)
      if (lookahead == '\r') SKIP(7)
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(155)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(155)
      if (lookahead == '\r') SKIP(9)
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(156)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(156)
      if (lookahead == '\r') SKIP(11)
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(118)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(118)
      if (lookahead == '\r') SKIP(13)
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(107)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(107)
      if (lookahead == '\r') SKIP(15)
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(119)
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(119)
      if (lookahead == '\r') SKIP(17)
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(109)
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(109)
      if (lookahead == '\r') SKIP(19)
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(110)
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(110)
      if (lookahead == '\r') SKIP(21)
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(157)
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(157)
      if (lookahead == '\r') SKIP(23)
      END_STATE();
    case 25:
      if (lookahead == '\n') SKIP(160)
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(160)
      if (lookahead == '\r') SKIP(25)
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(131)
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(131)
      if (lookahead == '\r') SKIP(27)
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(144)
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(144)
      if (lookahead == '\r') SKIP(29)
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(139)
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(139)
      if (lookahead == '\r') SKIP(31)
      END_STATE();
    case 33:
      if (lookahead == '\n') SKIP(130)
      END_STATE();
    case 34:
      if (lookahead == '\n') SKIP(130)
      if (lookahead == '\r') SKIP(33)
      END_STATE();
    case 35:
      if (lookahead == '\n') SKIP(121)
      END_STATE();
    case 36:
      if (lookahead == '\n') SKIP(121)
      if (lookahead == '\r') SKIP(35)
      END_STATE();
    case 37:
      if (lookahead == '\n') SKIP(147)
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(147)
      if (lookahead == '\r') SKIP(37)
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(126)
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(126)
      if (lookahead == '\r') SKIP(39)
      END_STATE();
    case 41:
      if (lookahead == '\n') SKIP(137)
      END_STATE();
    case 42:
      if (lookahead == '\n') SKIP(137)
      if (lookahead == '\r') SKIP(41)
      END_STATE();
    case 43:
      if (lookahead == '\n') SKIP(124)
      END_STATE();
    case 44:
      if (lookahead == '\n') SKIP(124)
      if (lookahead == '\r') SKIP(43)
      END_STATE();
    case 45:
      if (lookahead == '\n') SKIP(123)
      END_STATE();
    case 46:
      if (lookahead == '\n') SKIP(123)
      if (lookahead == '\r') SKIP(45)
      END_STATE();
    case 47:
      if (lookahead == '\n') SKIP(138)
      END_STATE();
    case 48:
      if (lookahead == '\n') SKIP(138)
      if (lookahead == '\r') SKIP(47)
      END_STATE();
    case 49:
      if (lookahead == '\n') SKIP(158)
      END_STATE();
    case 50:
      if (lookahead == '\n') SKIP(158)
      if (lookahead == '\r') SKIP(49)
      END_STATE();
    case 51:
      if (lookahead == '\n') SKIP(120)
      END_STATE();
    case 52:
      if (lookahead == '\n') SKIP(120)
      if (lookahead == '\r') SKIP(51)
      END_STATE();
    case 53:
      if (lookahead == '\n') SKIP(55)
      END_STATE();
    case 54:
      if (lookahead == '\n') SKIP(55)
      if (lookahead == '\r') SKIP(53)
      END_STATE();
    case 55:
      if (lookahead == '\n') ADVANCE(217);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(280);
      if (lookahead == '-') ADVANCE(273);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == '<') ADVANCE(311);
      if (lookahead == '=') ADVANCE(175);
      if (lookahead == '>') ADVANCE(303);
      if (lookahead == '\\') SKIP(54)
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(55)
      END_STATE();
    case 56:
      if (lookahead == '\n') SKIP(149)
      END_STATE();
    case 57:
      if (lookahead == '\n') SKIP(149)
      if (lookahead == '\r') SKIP(56)
      END_STATE();
    case 58:
      if (lookahead == '\n') SKIP(150)
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '/') ADVANCE(375);
      if (lookahead == '\\') ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(378);
      if (lookahead != 0) ADVANCE(379);
      END_STATE();
    case 59:
      if (lookahead == '\n') ADVANCE(381);
      if (lookahead == '\r') ADVANCE(380);
      if (lookahead == 'U') ADVANCE(207);
      if (lookahead == 'u') ADVANCE(203);
      if (lookahead == 'x') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(383);
      if (lookahead != 0) ADVANCE(380);
      END_STATE();
    case 60:
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '(') ADVANCE(220);
      if (lookahead == '/') ADVANCE(262);
      if (lookahead == '\\') ADVANCE(260);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(259);
      if (lookahead != 0) ADVANCE(263);
      END_STATE();
    case 61:
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '/') ADVANCE(262);
      if (lookahead == '\\') ADVANCE(260);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(259);
      if (lookahead != 0) ADVANCE(263);
      END_STATE();
    case 62:
      if (lookahead == '\n') SKIP(170)
      if (lookahead == '/') ADVANCE(368);
      if (lookahead == '\\') ADVANCE(367);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(369);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(366);
      END_STATE();
    case 63:
      if (lookahead == '\n') SKIP(111)
      END_STATE();
    case 64:
      if (lookahead == '\n') SKIP(111)
      if (lookahead == '\r') SKIP(63)
      END_STATE();
    case 65:
      if (lookahead == '\n') SKIP(108)
      END_STATE();
    case 66:
      if (lookahead == '\n') SKIP(108)
      if (lookahead == '\r') SKIP(65)
      END_STATE();
    case 67:
      if (lookahead == '\n') SKIP(113)
      END_STATE();
    case 68:
      if (lookahead == '\n') SKIP(113)
      if (lookahead == '\r') SKIP(67)
      END_STATE();
    case 69:
      if (lookahead == '\n') SKIP(141)
      END_STATE();
    case 70:
      if (lookahead == '\n') SKIP(141)
      if (lookahead == '\r') SKIP(69)
      END_STATE();
    case 71:
      if (lookahead == '\n') SKIP(142)
      END_STATE();
    case 72:
      if (lookahead == '\n') SKIP(142)
      if (lookahead == '\r') SKIP(71)
      END_STATE();
    case 73:
      if (lookahead == '\n') SKIP(140)
      END_STATE();
    case 74:
      if (lookahead == '\n') SKIP(140)
      if (lookahead == '\r') SKIP(73)
      END_STATE();
    case 75:
      if (lookahead == '\n') SKIP(125)
      END_STATE();
    case 76:
      if (lookahead == '\n') SKIP(125)
      if (lookahead == '\r') SKIP(75)
      END_STATE();
    case 77:
      if (lookahead == '\n') SKIP(136)
      END_STATE();
    case 78:
      if (lookahead == '\n') SKIP(136)
      if (lookahead == '\r') SKIP(77)
      END_STATE();
    case 79:
      if (lookahead == '\n') SKIP(127)
      END_STATE();
    case 80:
      if (lookahead == '\n') SKIP(127)
      if (lookahead == '\r') SKIP(79)
      END_STATE();
    case 81:
      if (lookahead == '\n') SKIP(122)
      END_STATE();
    case 82:
      if (lookahead == '\n') SKIP(122)
      if (lookahead == '\r') SKIP(81)
      END_STATE();
    case 83:
      if (lookahead == '\n') SKIP(135)
      END_STATE();
    case 84:
      if (lookahead == '\n') SKIP(135)
      if (lookahead == '\r') SKIP(83)
      END_STATE();
    case 85:
      if (lookahead == '\n') SKIP(159)
      END_STATE();
    case 86:
      if (lookahead == '\n') SKIP(159)
      if (lookahead == '\r') SKIP(85)
      END_STATE();
    case 87:
      if (lookahead == '\n') SKIP(114)
      END_STATE();
    case 88:
      if (lookahead == '\n') SKIP(114)
      if (lookahead == '\r') SKIP(87)
      END_STATE();
    case 89:
      if (lookahead == '\n') SKIP(132)
      END_STATE();
    case 90:
      if (lookahead == '\n') SKIP(132)
      if (lookahead == '\r') SKIP(89)
      END_STATE();
    case 91:
      if (lookahead == '\n') SKIP(143)
      END_STATE();
    case 92:
      if (lookahead == '\n') SKIP(143)
      if (lookahead == '\r') SKIP(91)
      END_STATE();
    case 93:
      if (lookahead == '\n') SKIP(134)
      END_STATE();
    case 94:
      if (lookahead == '\n') SKIP(134)
      if (lookahead == '\r') SKIP(93)
      END_STATE();
    case 95:
      if (lookahead == '\n') SKIP(128)
      END_STATE();
    case 96:
      if (lookahead == '\n') SKIP(128)
      if (lookahead == '\r') SKIP(95)
      END_STATE();
    case 97:
      if (lookahead == '\n') SKIP(145)
      END_STATE();
    case 98:
      if (lookahead == '\n') SKIP(145)
      if (lookahead == '\r') SKIP(97)
      END_STATE();
    case 99:
      if (lookahead == '\n') SKIP(112)
      END_STATE();
    case 100:
      if (lookahead == '\n') SKIP(112)
      if (lookahead == '\r') SKIP(99)
      END_STATE();
    case 101:
      if (lookahead == '\n') SKIP(133)
      END_STATE();
    case 102:
      if (lookahead == '\n') SKIP(133)
      if (lookahead == '\r') SKIP(101)
      END_STATE();
    case 103:
      if (lookahead == '\n') SKIP(148)
      END_STATE();
    case 104:
      if (lookahead == '\n') SKIP(148)
      if (lookahead == '\r') SKIP(103)
      END_STATE();
    case 105:
      if (lookahead == '\n') SKIP(146)
      END_STATE();
    case 106:
      if (lookahead == '\n') SKIP(146)
      if (lookahead == '\r') SKIP(105)
      END_STATE();
    case 107:
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(282);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(274);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(304);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(16)
      if (lookahead == ']') ADVANCE(325);
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(107)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 108:
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(282);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(274);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(66)
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(108)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 109:
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(282);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(274);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(305);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(20)
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(109)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 110:
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(282);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(274);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(304);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(22)
      if (lookahead == ']') ADVANCE(182);
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(110)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 111:
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(283);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(275);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(175);
      if (lookahead == '>') ADVANCE(303);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(64)
      if (lookahead == ']') ADVANCE(182);
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(111)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 112:
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(283);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(275);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(175);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(100)
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(112)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 113:
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(283);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(275);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(175);
      if (lookahead == '>') ADVANCE(303);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(68)
      if (lookahead == ']') ADVANCE(325);
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(113)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 114:
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(283);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(275);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(175);
      if (lookahead == '>') ADVANCE(306);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(88)
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(114)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 115:
      if (lookahead == '!') ADVANCE(270);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '#') ADVANCE(183);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(283);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(276);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '>') ADVANCE(180);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(324);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == 'o') ADVANCE(402);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(115)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 116:
      if (lookahead == '!') ADVANCE(270);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '&') ADVANCE(298);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(283);
      if (lookahead == '-') ADVANCE(276);
      if (lookahead == '.') ADVANCE(168);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(324);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(116)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 117:
      if (lookahead == '!') ADVANCE(270);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '#') ADVANCE(185);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(283);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(276);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(324);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == 'o') ADVANCE(402);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(117)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 118:
      if (lookahead == '!') ADVANCE(270);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(283);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(276);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(309);
      if (lookahead == '=') ADVANCE(326);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(14)
      if (lookahead == 'o') ADVANCE(402);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(118)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 119:
      if (lookahead == '!') ADVANCE(270);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '&') ADVANCE(298);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(283);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(276);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '=') ADVANCE(326);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(18)
      if (lookahead == ']') ADVANCE(325);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(119)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 120:
      if (lookahead == '!') ADVANCE(270);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '+') ADVANCE(285);
      if (lookahead == '-') ADVANCE(279);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == 'L') ADVANCE(395);
      if (lookahead == 'U') ADVANCE(396);
      if (lookahead == '\\') SKIP(52)
      if (lookahead == 'u') ADVANCE(397);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(120)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 121:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(284);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(277);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(328);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(304);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(151);
      if (lookahead == 'U') ADVANCE(152);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(36)
      if (lookahead == ']') ADVANCE(325);
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == 'u') ADVANCE(153);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(121)
      END_STATE();
    case 122:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(284);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(277);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(305);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(151);
      if (lookahead == 'U') ADVANCE(152);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(82)
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == 'u') ADVANCE(153);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(122)
      END_STATE();
    case 123:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(284);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(277);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(328);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(151);
      if (lookahead == 'U') ADVANCE(152);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(46)
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == 'u') ADVANCE(153);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(123)
      END_STATE();
    case 124:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(284);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(277);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(328);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(304);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(151);
      if (lookahead == 'U') ADVANCE(152);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(44)
      if (lookahead == ']') ADVANCE(182);
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == 'u') ADVANCE(153);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(124)
      END_STATE();
    case 125:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(281);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(278);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(328);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(175);
      if (lookahead == '>') ADVANCE(303);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(151);
      if (lookahead == 'U') ADVANCE(152);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(76)
      if (lookahead == ']') ADVANCE(325);
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == 'u') ADVANCE(153);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(125)
      END_STATE();
    case 126:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(281);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(278);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(175);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(388);
      if (lookahead == 'U') ADVANCE(390);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(40)
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == 'o') ADVANCE(402);
      if (lookahead == 'u') ADVANCE(392);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(126)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 127:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(281);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(278);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(175);
      if (lookahead == '>') ADVANCE(303);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(151);
      if (lookahead == 'U') ADVANCE(152);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(80)
      if (lookahead == ']') ADVANCE(182);
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == 'u') ADVANCE(153);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(127)
      END_STATE();
    case 128:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(281);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(278);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(175);
      if (lookahead == '>') ADVANCE(306);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(151);
      if (lookahead == 'U') ADVANCE(152);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(96)
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == 'u') ADVANCE(153);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(128)
      END_STATE();
    case 129:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(184);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(280);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(273);
      if (lookahead == '.') ADVANCE(167);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(311);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(303);
      if (lookahead == '[') ADVANCE(324);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == 'o') ADVANCE(402);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(129)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 130:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(284);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(277);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(34)
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(130)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 131:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(284);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(277);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(304);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(28)
      if (lookahead == ']') ADVANCE(325);
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == 'o') ADVANCE(402);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(131)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 132:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(284);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(277);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(304);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(90)
      if (lookahead == ']') ADVANCE(325);
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(132)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 133:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(284);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(277);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(328);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(304);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(102)
      if (lookahead == ']') ADVANCE(325);
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(133)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 134:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(284);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(277);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(305);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(94)
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(134)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 135:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(284);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(277);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(304);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(84)
      if (lookahead == ']') ADVANCE(182);
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(135)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 136:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(284);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(277);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(328);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(78)
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(136)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 137:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(284);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(277);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(328);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(305);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(42)
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(137)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 138:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(284);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(277);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(328);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(304);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(48)
      if (lookahead == ']') ADVANCE(182);
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(138)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 139:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(281);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(278);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(32)
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == 'o') ADVANCE(402);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(139)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 140:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(281);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(278);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(74)
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(140)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 141:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(281);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(278);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(303);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(70)
      if (lookahead == ']') ADVANCE(325);
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == 'o') ADVANCE(402);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(141)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 142:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(281);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(278);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(303);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(72)
      if (lookahead == ']') ADVANCE(325);
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(142)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 143:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(281);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(278);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(328);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(92)
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(143)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 144:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(281);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(278);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(328);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(303);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(30)
      if (lookahead == ']') ADVANCE(325);
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(144)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 145:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(281);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(278);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(175);
      if (lookahead == '>') ADVANCE(303);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(98)
      if (lookahead == ']') ADVANCE(182);
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(145)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 146:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(281);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(278);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(175);
      if (lookahead == '>') ADVANCE(306);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(106)
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(146)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 147:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(281);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(278);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(328);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(303);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(38)
      if (lookahead == ']') ADVANCE(182);
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(147)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 148:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(290);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(281);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(278);
      if (lookahead == '.') ADVANCE(343);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == ':') ADVANCE(328);
      if (lookahead == '<') ADVANCE(312);
      if (lookahead == '=') ADVANCE(175);
      if (lookahead == '>') ADVANCE(306);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(104)
      if (lookahead == '^') ADVANCE(296);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(148)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 149:
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '<') ADVANCE(178);
      if (lookahead == 'L') ADVANCE(388);
      if (lookahead == 'U') ADVANCE(390);
      if (lookahead == '\\') SKIP(57)
      if (lookahead == 'u') ADVANCE(392);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(149)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 150:
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '\\') ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(150)
      END_STATE();
    case 151:
      if (lookahead == '"') ADVANCE(370);
      END_STATE();
    case 152:
      if (lookahead == '"') ADVANCE(372);
      END_STATE();
    case 153:
      if (lookahead == '"') ADVANCE(371);
      if (lookahead == '8') ADVANCE(154);
      END_STATE();
    case 154:
      if (lookahead == '"') ADVANCE(373);
      END_STATE();
    case 155:
      if (lookahead == '#') ADVANCE(188);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '[') ADVANCE(324);
      if (lookahead == '\\') SKIP(10)
      if (lookahead == 'o') ADVANCE(402);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(155)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 156:
      if (lookahead == '#') ADVANCE(186);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '[') ADVANCE(324);
      if (lookahead == '\\') SKIP(12)
      if (lookahead == 'o') ADVANCE(402);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(156)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 157:
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(176);
      if (lookahead == '.') ADVANCE(167);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(309);
      if (lookahead == '=') ADVANCE(326);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(24)
      if (lookahead == 'o') ADVANCE(402);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(157)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 158:
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(176);
      if (lookahead == '.') ADVANCE(167);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(309);
      if (lookahead == '=') ADVANCE(326);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(50)
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(158)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 159:
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(176);
      if (lookahead == '.') ADVANCE(167);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == ':') ADVANCE(328);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(309);
      if (lookahead == '=') ADVANCE(326);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '[') ADVANCE(323);
      if (lookahead == '\\') SKIP(86)
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(159)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 160:
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '.') ADVANCE(167);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == '<') ADVANCE(309);
      if (lookahead == '=') ADVANCE(326);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '[') ADVANCE(324);
      if (lookahead == '\\') SKIP(26)
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(160)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 161:
      if (lookahead == ')') ADVANCE(417);
      END_STATE();
    case 162:
      if (lookahead == '*') ADVANCE(164);
      if (lookahead == '/') ADVANCE(409);
      END_STATE();
    case 163:
      if (lookahead == '*') ADVANCE(163);
      if (lookahead == '/') ADVANCE(407);
      if (lookahead != 0) ADVANCE(164);
      END_STATE();
    case 164:
      if (lookahead == '*') ADVANCE(163);
      if (lookahead != 0) ADVANCE(164);
      END_STATE();
    case 165:
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '0') ADVANCE(348);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(349);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(357);
      END_STATE();
    case 166:
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '0') ADVANCE(351);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      END_STATE();
    case 167:
      if (lookahead == '.') ADVANCE(169);
      END_STATE();
    case 168:
      if (lookahead == '.') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(346);
      END_STATE();
    case 169:
      if (lookahead == '.') ADVANCE(221);
      END_STATE();
    case 170:
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '\\') ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(170)
      END_STATE();
    case 171:
      if (lookahead == ':') ADVANCE(414);
      END_STATE();
    case 172:
      if (lookahead == '<') ADVANCE(426);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(172);
      END_STATE();
    case 173:
      if (lookahead == '<') ADVANCE(172);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(173);
      END_STATE();
    case 174:
      if (lookahead == '=') ADVANCE(302);
      END_STATE();
    case 175:
      if (lookahead == '=') ADVANCE(301);
      END_STATE();
    case 176:
      if (lookahead == '>') ADVANCE(345);
      END_STATE();
    case 177:
      if (lookahead == '>') ADVANCE(427);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(177);
      END_STATE();
    case 178:
      if (lookahead == '>') ADVANCE(384);
      if (lookahead == '\\') ADVANCE(179);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(178);
      END_STATE();
    case 179:
      if (lookahead == '>') ADVANCE(385);
      if (lookahead == '\\') ADVANCE(179);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(178);
      END_STATE();
    case 180:
      if (lookahead == '>') ADVANCE(177);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(180);
      END_STATE();
    case 181:
      if (lookahead == ']') ADVANCE(417);
      END_STATE();
    case 182:
      if (lookahead == ']') ADVANCE(416);
      END_STATE();
    case 183:
      if (lookahead == 'd') ADVANCE(235);
      if (lookahead == 'e') ADVANCE(251);
      if (lookahead == 'i') ADVANCE(241);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 184:
      if (lookahead == 'd') ADVANCE(235);
      if (lookahead == 'e') ADVANCE(251);
      if (lookahead == 'i') ADVANCE(242);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 185:
      if (lookahead == 'd') ADVANCE(235);
      if (lookahead == 'e') ADVANCE(253);
      if (lookahead == 'i') ADVANCE(241);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(185);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 186:
      if (lookahead == 'd') ADVANCE(235);
      if (lookahead == 'e') ADVANCE(253);
      if (lookahead == 'i') ADVANCE(242);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(186);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 187:
      if (lookahead == 'd') ADVANCE(235);
      if (lookahead == 'i') ADVANCE(241);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 188:
      if (lookahead == 'd') ADVANCE(235);
      if (lookahead == 'i') ADVANCE(242);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(188);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 189:
      if (lookahead == 'd') ADVANCE(192);
      END_STATE();
    case 190:
      if (lookahead == 'e') ADVANCE(193);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(190);
      END_STATE();
    case 191:
      if (lookahead == 'f') ADVANCE(225);
      END_STATE();
    case 192:
      if (lookahead == 'i') ADVANCE(191);
      END_STATE();
    case 193:
      if (lookahead == 'n') ADVANCE(189);
      END_STATE();
    case 194:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(352);
      END_STATE();
    case 195:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(346);
      END_STATE();
    case 196:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(349);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(357);
      END_STATE();
    case 197:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(354);
      END_STATE();
    case 198:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(357);
      END_STATE();
    case 199:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(347);
      END_STATE();
    case 200:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(380);
      END_STATE();
    case 201:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(200);
      END_STATE();
    case 202:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(201);
      END_STATE();
    case 203:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 204:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(203);
      END_STATE();
    case 205:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(204);
      END_STATE();
    case 206:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(205);
      END_STATE();
    case 207:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(206);
      END_STATE();
    case 208:
      if (lookahead != 0 &&
          lookahead != '\r') ADVANCE(409);
      if (lookahead == '\r') ADVANCE(411);
      END_STATE();
    case 209:
      if (eof) ADVANCE(215);
      if (lookahead == '\n') SKIP(213)
      END_STATE();
    case 210:
      if (eof) ADVANCE(215);
      if (lookahead == '\n') SKIP(213)
      if (lookahead == '\r') SKIP(209)
      END_STATE();
    case 211:
      if (eof) ADVANCE(215);
      if (lookahead == '\n') SKIP(214)
      END_STATE();
    case 212:
      if (eof) ADVANCE(215);
      if (lookahead == '\n') SKIP(214)
      if (lookahead == '\r') SKIP(211)
      END_STATE();
    case 213:
      if (eof) ADVANCE(215);
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '#') ADVANCE(183);
      if (lookahead == '%') ADVANCE(291);
      if (lookahead == '&') ADVANCE(300);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '+') ADVANCE(282);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(274);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(329);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(310);
      if (lookahead == '=') ADVANCE(327);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == '?') ADVANCE(330);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(324);
      if (lookahead == '\\') SKIP(210)
      if (lookahead == ']') ADVANCE(325);
      if (lookahead == '^') ADVANCE(297);
      if (lookahead == 'o') ADVANCE(402);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '|') ADVANCE(294);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(213)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 214:
      if (eof) ADVANCE(215);
      if (lookahead == '!') ADVANCE(270);
      if (lookahead == '"') ADVANCE(374);
      if (lookahead == '#') ADVANCE(187);
      if (lookahead == '&') ADVANCE(299);
      if (lookahead == '\'') ADVANCE(365);
      if (lookahead == '(') ADVANCE(269);
      if (lookahead == ')') ADVANCE(223);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '+') ADVANCE(283);
      if (lookahead == ',') ADVANCE(222);
      if (lookahead == '-') ADVANCE(276);
      if (lookahead == '.') ADVANCE(344);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == ';') ADVANCE(320);
      if (lookahead == '<') ADVANCE(309);
      if (lookahead == '=') ADVANCE(326);
      if (lookahead == '>') ADVANCE(413);
      if (lookahead == 'L') ADVANCE(387);
      if (lookahead == 'U') ADVANCE(389);
      if (lookahead == '[') ADVANCE(324);
      if (lookahead == '\\') SKIP(212)
      if (lookahead == ']') ADVANCE(182);
      if (lookahead == 'o') ADVANCE(402);
      if (lookahead == 'u') ADVANCE(391);
      if (lookahead == '{') ADVANCE(321);
      if (lookahead == '}') ADVANCE(322);
      if (lookahead == '~') ADVANCE(272);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(214)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(aux_sym_preproc_include_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(217);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '\\') ADVANCE(260);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(259);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(aux_sym_preproc_def_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(aux_sym_preproc_if_token1);
      if (lookahead == 'd') ADVANCE(239);
      if (lookahead == 'n') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(aux_sym_preproc_else_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'c') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(238);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(240);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(224);
      if (lookahead == 'n') ADVANCE(231);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(230);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(227);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(228);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(244);
      if (lookahead == 's') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(245);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(249);
      if (lookahead == 'n') ADVANCE(232);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(255);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'n') ADVANCE(232);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'n') ADVANCE(237);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'u') ADVANCE(233);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(164);
      if (lookahead == '*') ADVANCE(257);
      if (lookahead == '/') ADVANCE(407);
      if (lookahead == '\\') ADVANCE(264);
      if (lookahead != 0) ADVANCE(258);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(164);
      if (lookahead == '*') ADVANCE(257);
      if (lookahead == '\\') ADVANCE(264);
      if (lookahead != 0) ADVANCE(258);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '/') ADVANCE(262);
      if (lookahead == '\\') ADVANCE(260);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(259);
      if (lookahead != 0) ADVANCE(263);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(259);
      if (lookahead == '\r') ADVANCE(261);
      if (lookahead == '\\') ADVANCE(265);
      if (lookahead != 0) ADVANCE(263);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(259);
      if (lookahead == '\\') ADVANCE(265);
      if (lookahead != 0) ADVANCE(263);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '*') ADVANCE(258);
      if (lookahead == '/') ADVANCE(410);
      if (lookahead == '\\') ADVANCE(265);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(263);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\\') ADVANCE(265);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(263);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '*' &&
          lookahead != '\\') ADVANCE(258);
      if (lookahead == '\r') ADVANCE(267);
      if (lookahead == '*') ADVANCE(257);
      if (lookahead == '\\') ADVANCE(264);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '\\') ADVANCE(263);
      if (lookahead == '\r') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(265);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '\\') ADVANCE(410);
      if (lookahead == '\r') ADVANCE(412);
      if (lookahead == '\\') ADVANCE(408);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '*' &&
          lookahead != '\\') ADVANCE(258);
      if (lookahead == '*') ADVANCE(257);
      if (lookahead == '\\') ADVANCE(264);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(263);
      if (lookahead == '\\') ADVANCE(265);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(302);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(341);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == '=') ADVANCE(335);
      if (lookahead == '>') ADVANCE(345);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(341);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == '>') ADVANCE(345);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(341);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '0') ADVANCE(350);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(341);
      if (lookahead == '=') ADVANCE(335);
      if (lookahead == '>') ADVANCE(345);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(341);
      if (lookahead == '>') ADVANCE(345);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '0') ADVANCE(350);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(342);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(342);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '0') ADVANCE(350);
      if (lookahead == '=') ADVANCE(334);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(342);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '0') ADVANCE(350);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(342);
      if (lookahead == '=') ADVANCE(334);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '0') ADVANCE(350);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(352);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(331);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(164);
      if (lookahead == '/') ADVANCE(409);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(164);
      if (lookahead == '/') ADVANCE(409);
      if (lookahead == '=') ADVANCE(332);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(333);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(340);
      if (lookahead == '|') ADVANCE(292);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(292);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(339);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(293);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(293);
      if (lookahead == '=') ADVANCE(338);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(307);
      if (lookahead == '>') ADVANCE(316);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(307);
      if (lookahead == '>') ADVANCE(317);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(307);
      if (lookahead == '>') ADVANCE(318);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(180);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(307);
      if (lookahead == '>') ADVANCE(319);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(180);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(314);
      if (lookahead == '=') ADVANCE(308);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(173);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(313);
      if (lookahead == '=') ADVANCE(308);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(315);
      if (lookahead == '=') ADVANCE(308);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(173);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '<') ADVANCE(426);
      if (lookahead == '=') ADVANCE(336);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(172);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '<') ADVANCE(426);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(172);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(337);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(337);
      if (lookahead == '>') ADVANCE(427);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(177);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(427);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(177);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(415);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(301);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(414);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(169);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(346);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(195);
      if (lookahead == 'F' ||
          lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'f' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(346);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(199);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(347);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'E') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(347);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '.') ADVANCE(358);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(357);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      if (lookahead == 'b') ADVANCE(356);
      if (lookahead == 'x') ADVANCE(198);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(355);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(359);
      if (('A' <= lookahead && lookahead <= 'D') ||
          ('a' <= lookahead && lookahead <= 'd')) ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(349);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '.') ADVANCE(358);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(357);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(355);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(359);
      if (('A' <= lookahead && lookahead <= 'D') ||
          ('a' <= lookahead && lookahead <= 'd')) ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(349);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(194);
      if (lookahead == '.') ADVANCE(358);
      if (lookahead == 'F' ||
          lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'f' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      if (lookahead == 'b') ADVANCE(166);
      if (lookahead == 'x') ADVANCE(165);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(352);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(194);
      if (lookahead == '.') ADVANCE(358);
      if (lookahead == 'F' ||
          lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'f' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      if (lookahead == 'b') ADVANCE(194);
      if (lookahead == 'x') ADVANCE(198);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(352);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(194);
      if (lookahead == '.') ADVANCE(358);
      if (lookahead == 'F' ||
          lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'f' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(352);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(197);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(354);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(199);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(353);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'D') ||
          ('a' <= lookahead && lookahead <= 'd')) ADVANCE(354);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(197);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(354);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(353);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'D') ||
          ('a' <= lookahead && lookahead <= 'd')) ADVANCE(354);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(198);
      if (lookahead == '.') ADVANCE(358);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(357);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(199);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(355);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'D') ||
          ('a' <= lookahead && lookahead <= 'd')) ADVANCE(357);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(198);
      if (lookahead == '.') ADVANCE(358);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(357);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(355);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(359);
      if (('A' <= lookahead && lookahead <= 'D') ||
          ('a' <= lookahead && lookahead <= 'd')) ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(349);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(198);
      if (lookahead == '.') ADVANCE(358);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(357);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(355);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'D') ||
          ('a' <= lookahead && lookahead <= 'd')) ADVANCE(357);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(354);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(353);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'D') ||
          ('a' <= lookahead && lookahead <= 'd')) ADVANCE(354);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(347);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'E') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(347);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == 'F' ||
          lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'f' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(360);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_L_SQUOTE);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_u_SQUOTE);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_U_SQUOTE);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_u8_SQUOTE);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '\n') ADVANCE(381);
      if (lookahead == '\r') ADVANCE(380);
      if (lookahead == 'U') ADVANCE(207);
      if (lookahead == 'u') ADVANCE(203);
      if (lookahead == 'x') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(383);
      if (lookahead != 0) ADVANCE(380);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '*') ADVANCE(164);
      if (lookahead == '/') ADVANCE(409);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(aux_sym_char_literal_token1);
      if (lookahead == '\\') ADVANCE(59);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_L_DQUOTE);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_u_DQUOTE);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_U_DQUOTE);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_u8_DQUOTE);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(377);
      if (lookahead == '/') ADVANCE(379);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(379);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(376);
      if (lookahead == '/') ADVANCE(379);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(377);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(376);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(377);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '/') ADVANCE(375);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(378);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(379);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(379);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(59);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(380);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(382);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_system_lib_string);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_system_lib_string);
      if (lookahead == '>') ADVANCE(384);
      if (lookahead == '\\') ADVANCE(179);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(178);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '!') ADVANCE(420);
      if (lookahead == '%') ADVANCE(420);
      if (lookahead == '&') ADVANCE(422);
      if (lookahead == '(') ADVANCE(161);
      if (lookahead == '*') ADVANCE(420);
      if (lookahead == '+') ADVANCE(423);
      if (lookahead == ',' ||
          lookahead == '~') ADVANCE(417);
      if (lookahead == '-') ADVANCE(424);
      if (lookahead == '/') ADVANCE(420);
      if (lookahead == '<') ADVANCE(419);
      if (lookahead == '=') ADVANCE(420);
      if (lookahead == '>') ADVANCE(421);
      if (lookahead == '[') ADVANCE(181);
      if (lookahead == '^') ADVANCE(420);
      if (lookahead == '|') ADVANCE(425);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(370);
      if (lookahead == '\'') ADVANCE(361);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(372);
      if (lookahead == '\'') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(371);
      if (lookahead == '\'') ADVANCE(362);
      if (lookahead == '8') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(371);
      if (lookahead == '8') ADVANCE(394);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(373);
      if (lookahead == '\'') ADVANCE(364);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(361);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(362);
      if (lookahead == '8') ADVANCE(398);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(364);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(403);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(404);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(400);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(399);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(386);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(401);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\r') ADVANCE(410);
      if (lookahead == '\\') ADVANCE(266);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(410);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(208);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(409);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(266);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(410);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(409);
      if (lookahead == '\\') ADVANCE(208);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(410);
      if (lookahead == '\\') ADVANCE(266);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(anon_sym_GT2);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym_operator_name);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym_operator_name);
      if (lookahead == '*') ADVANCE(417);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym_operator_name);
      if (lookahead == '<') ADVANCE(420);
      if (lookahead == '=') ADVANCE(417);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym_operator_name);
      if (lookahead == '=') ADVANCE(417);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym_operator_name);
      if (lookahead == '=') ADVANCE(417);
      if (lookahead == '>') ADVANCE(420);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym_operator_name);
      if (lookahead == '&' ||
          lookahead == '=') ADVANCE(417);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym_operator_name);
      if (lookahead == '+' ||
          lookahead == '=') ADVANCE(417);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym_operator_name);
      if (lookahead == '-' ||
          lookahead == '=') ADVANCE(417);
      if (lookahead == '>') ADVANCE(418);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym_operator_name);
      if (lookahead == '=' ||
          lookahead == '|') ADVANCE(417);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(aux_sym_kernel_call_syntax_token1);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(aux_sym_kernel_call_syntax_token2);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == '_') ADVANCE(5);
      if (lookahead == 'a') ADVANCE(6);
      if (lookahead == 'b') ADVANCE(7);
      if (lookahead == 'c') ADVANCE(8);
      if (lookahead == 'd') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(10);
      if (lookahead == 'f') ADVANCE(11);
      if (lookahead == 'g') ADVANCE(12);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(14);
      if (lookahead == 'm') ADVANCE(15);
      if (lookahead == 'n') ADVANCE(16);
      if (lookahead == 'o') ADVANCE(17);
      if (lookahead == 'p') ADVANCE(18);
      if (lookahead == 'r') ADVANCE(19);
      if (lookahead == 's') ADVANCE(20);
      if (lookahead == 't') ADVANCE(21);
      if (lookahead == 'u') ADVANCE(22);
      if (lookahead == 'v') ADVANCE(23);
      if (lookahead == 'w') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'A') ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == 'U') ADVANCE(26);
      END_STATE();
    case 3:
      if (lookahead == 'R') ADVANCE(27);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(28)
      END_STATE();
    case 5:
      if (lookahead == 'A') ADVANCE(29);
      if (lookahead == '_') ADVANCE(30);
      if (lookahead == 'u') ADVANCE(31);
      END_STATE();
    case 6:
      if (lookahead == 'u') ADVANCE(32);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(33);
      if (lookahead == 'r') ADVANCE(34);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(35);
      if (lookahead == 'h') ADVANCE(36);
      if (lookahead == 'l') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(38);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(39);
      if (lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 10:
      if (lookahead == 'l') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(42);
      if (lookahead == 'x') ADVANCE(43);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(44);
      if (lookahead == 'i') ADVANCE(45);
      if (lookahead == 'l') ADVANCE(46);
      if (lookahead == 'o') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 12:
      if (lookahead == 'o') ADVANCE(49);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(50);
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 14:
      if (lookahead == 'o') ADVANCE(52);
      END_STATE();
    case 15:
      if (lookahead == 'u') ADVANCE(53);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(54);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'o') ADVANCE(56);
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 17:
      if (lookahead == 'p') ADVANCE(58);
      if (lookahead == 'v') ADVANCE(59);
      END_STATE();
    case 18:
      if (lookahead == 'r') ADVANCE(60);
      if (lookahead == 'u') ADVANCE(61);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(62);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(63);
      if (lookahead == 'i') ADVANCE(64);
      if (lookahead == 's') ADVANCE(65);
      if (lookahead == 't') ADVANCE(66);
      if (lookahead == 'w') ADVANCE(67);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(68);
      if (lookahead == 'h') ADVANCE(69);
      if (lookahead == 'r') ADVANCE(70);
      if (lookahead == 'y') ADVANCE(71);
      END_STATE();
    case 22:
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'n') ADVANCE(73);
      if (lookahead == 's') ADVANCE(74);
      END_STATE();
    case 23:
      if (lookahead == 'i') ADVANCE(75);
      if (lookahead == 'o') ADVANCE(76);
      END_STATE();
    case 24:
      if (lookahead == 'h') ADVANCE(77);
      END_STATE();
    case 25:
      if (lookahead == 'L') ADVANCE(78);
      END_STATE();
    case 26:
      if (lookahead == 'L') ADVANCE(79);
      END_STATE();
    case 27:
      if (lookahead == 'U') ADVANCE(80);
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 29:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(82);
      if (lookahead == 'b') ADVANCE(83);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'd') ADVANCE(85);
      if (lookahead == 'f') ADVANCE(86);
      if (lookahead == 'g') ADVANCE(87);
      if (lookahead == 'h') ADVANCE(88);
      if (lookahead == 'l') ADVANCE(89);
      if (lookahead == 'r') ADVANCE(90);
      if (lookahead == 's') ADVANCE(91);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == 'u') ADVANCE(93);
      if (lookahead == 'v') ADVANCE(94);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(95);
      END_STATE();
    case 32:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 33:
      if (lookahead == 'o') ADVANCE(97);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 35:
      if (lookahead == 's') ADVANCE(99);
      if (lookahead == 't') ADVANCE(100);
      END_STATE();
    case 36:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 37:
      if (lookahead == 'a') ADVANCE(102);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(103);
      END_STATE();
    case 39:
      if (lookahead == 'c') ADVANCE(104);
      if (lookahead == 'f') ADVANCE(105);
      if (lookahead == 'l') ADVANCE(106);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 41:
      if (lookahead == 's') ADVANCE(108);
      END_STATE();
    case 42:
      if (lookahead == 'u') ADVANCE(109);
      END_STATE();
    case 43:
      if (lookahead == 'p') ADVANCE(110);
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 44:
      if (lookahead == 'l') ADVANCE(112);
      END_STATE();
    case 45:
      if (lookahead == 'n') ADVANCE(113);
      END_STATE();
    case 46:
      if (lookahead == 'o') ADVANCE(114);
      END_STATE();
    case 47:
      if (lookahead == 'r') ADVANCE(115);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(116);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 51:
      if (lookahead == 'l') ADVANCE(118);
      if (lookahead == 't') ADVANCE(119);
      END_STATE();
    case 52:
      if (lookahead == 'n') ADVANCE(120);
      END_STATE();
    case 53:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 54:
      if (lookahead == 'm') ADVANCE(122);
      END_STATE();
    case 55:
      if (lookahead == 'w') ADVANCE(123);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(124);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(125);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(128);
      if (lookahead == 'o') ADVANCE(129);
      END_STATE();
    case 61:
      if (lookahead == 'b') ADVANCE(130);
      END_STATE();
    case 62:
      if (lookahead == 'g') ADVANCE(131);
      if (lookahead == 's') ADVANCE(132);
      if (lookahead == 't') ADVANCE(133);
      END_STATE();
    case 63:
      if (lookahead == 'o') ADVANCE(134);
      END_STATE();
    case 64:
      if (lookahead == 'g') ADVANCE(135);
      if (lookahead == 'z') ADVANCE(136);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(137);
      END_STATE();
    case 66:
      if (lookahead == 'a') ADVANCE(138);
      if (lookahead == 'r') ADVANCE(139);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(140);
      END_STATE();
    case 68:
      if (lookahead == 'm') ADVANCE(141);
      END_STATE();
    case 69:
      if (lookahead == 'i') ADVANCE(142);
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 70:
      if (lookahead == 'u') ADVANCE(144);
      if (lookahead == 'y') ADVANCE(145);
      END_STATE();
    case 71:
      if (lookahead == 'p') ADVANCE(146);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(147);
      END_STATE();
    case 73:
      if (lookahead == 'i') ADVANCE(148);
      if (lookahead == 's') ADVANCE(149);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(150);
      END_STATE();
    case 75:
      if (lookahead == 'r') ADVANCE(151);
      END_STATE();
    case 76:
      if (lookahead == 'i') ADVANCE(152);
      if (lookahead == 'l') ADVANCE(153);
      END_STATE();
    case 77:
      if (lookahead == 'i') ADVANCE(154);
      END_STATE();
    case 78:
      if (lookahead == 'S') ADVANCE(155);
      END_STATE();
    case 79:
      if (lookahead == 'L') ADVANCE(156);
      END_STATE();
    case 80:
      if (lookahead == 'E') ADVANCE(157);
      END_STATE();
    case 81:
      if (lookahead == 'o') ADVANCE(158);
      END_STATE();
    case 82:
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(160);
      END_STATE();
    case 84:
      if (lookahead == 'd') ADVANCE(161);
      if (lookahead == 'l') ADVANCE(162);
      if (lookahead == 'o') ADVANCE(163);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 86:
      if (lookahead == 'a') ADVANCE(165);
      if (lookahead == 'o') ADVANCE(166);
      END_STATE();
    case 87:
      if (lookahead == 'l') ADVANCE(167);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(168);
      END_STATE();
    case 89:
      if (lookahead == 'o') ADVANCE(169);
      END_STATE();
    case 90:
      if (lookahead == 'e') ADVANCE(170);
      END_STATE();
    case 91:
      if (lookahead == 'h') ADVANCE(171);
      if (lookahead == 'p') ADVANCE(172);
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 92:
      if (lookahead == 'h') ADVANCE(174);
      END_STATE();
    case 93:
      if (lookahead == 'n') ADVANCE(175);
      if (lookahead == 'p') ADVANCE(176);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 95:
      if (lookahead == 'a') ADVANCE(178);
      END_STATE();
    case 96:
      if (lookahead == 'o') ADVANCE(179);
      END_STATE();
    case 97:
      if (lookahead == 'l') ADVANCE(180);
      END_STATE();
    case 98:
      if (lookahead == 'a') ADVANCE(181);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 100:
      if (lookahead == 'c') ADVANCE(183);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(184);
      END_STATE();
    case 102:
      if (lookahead == 's') ADVANCE(185);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(186);
      if (lookahead == 't') ADVANCE(187);
      END_STATE();
    case 104:
      if (lookahead == 'l') ADVANCE(188);
      END_STATE();
    case 105:
      if (lookahead == 'a') ADVANCE(189);
      if (lookahead == 'i') ADVANCE(190);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 107:
      if (lookahead == 'b') ADVANCE(192);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(193);
      END_STATE();
    case 109:
      if (lookahead == 'm') ADVANCE(194);
      END_STATE();
    case 110:
      if (lookahead == 'l') ADVANCE(195);
      END_STATE();
    case 111:
      if (lookahead == 'e') ADVANCE(196);
      END_STATE();
    case 112:
      if (lookahead == 's') ADVANCE(197);
      END_STATE();
    case 113:
      if (lookahead == 'a') ADVANCE(198);
      END_STATE();
    case 114:
      if (lookahead == 'a') ADVANCE(199);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(200);
      END_STATE();
    case 117:
      if (lookahead == 'o') ADVANCE(201);
      END_STATE();
    case 118:
      if (lookahead == 'i') ADVANCE(202);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_primitive_type);
      if (lookahead == '1') ADVANCE(203);
      if (lookahead == '3') ADVANCE(204);
      if (lookahead == '6') ADVANCE(205);
      if (lookahead == '8') ADVANCE(206);
      if (lookahead == 'p') ADVANCE(207);
      END_STATE();
    case 120:
      if (lookahead == 'g') ADVANCE(208);
      END_STATE();
    case 121:
      if (lookahead == 'a') ADVANCE(209);
      END_STATE();
    case 122:
      if (lookahead == 'e') ADVANCE(210);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 124:
      if (lookahead == 'x') ADVANCE(211);
      END_STATE();
    case 125:
      if (lookahead == 'l') ADVANCE(212);
      END_STATE();
    case 126:
      if (lookahead == 'r') ADVANCE(213);
      END_STATE();
    case 127:
      if (lookahead == 'r') ADVANCE(214);
      END_STATE();
    case 128:
      if (lookahead == 'v') ADVANCE(215);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(216);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(217);
      END_STATE();
    case 131:
      if (lookahead == 'i') ADVANCE(218);
      END_STATE();
    case 132:
      if (lookahead == 't') ADVANCE(219);
      END_STATE();
    case 133:
      if (lookahead == 'u') ADVANCE(220);
      END_STATE();
    case 134:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 135:
      if (lookahead == 'n') ADVANCE(222);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(223);
      END_STATE();
    case 137:
      if (lookahead == 'z') ADVANCE(224);
      END_STATE();
    case 138:
      if (lookahead == 't') ADVANCE(225);
      END_STATE();
    case 139:
      if (lookahead == 'u') ADVANCE(226);
      END_STATE();
    case 140:
      if (lookahead == 't') ADVANCE(227);
      END_STATE();
    case 141:
      if (lookahead == 'p') ADVANCE(228);
      END_STATE();
    case 142:
      if (lookahead == 's') ADVANCE(229);
      END_STATE();
    case 143:
      if (lookahead == 'o') ADVANCE(230);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 146:
      if (lookahead == 'e') ADVANCE(231);
      END_STATE();
    case 147:
      if (lookahead == 't') ADVANCE(232);
      END_STATE();
    case 148:
      if (lookahead == 'o') ADVANCE(233);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(234);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(235);
      END_STATE();
    case 151:
      if (lookahead == 't') ADVANCE(236);
      END_STATE();
    case 152:
      if (lookahead == 'd') ADVANCE(180);
      END_STATE();
    case 153:
      if (lookahead == 'a') ADVANCE(237);
      END_STATE();
    case 154:
      if (lookahead == 'l') ADVANCE(238);
      END_STATE();
    case 155:
      if (lookahead == 'E') ADVANCE(239);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 158:
      if (lookahead == 'm') ADVANCE(240);
      END_STATE();
    case 159:
      if (lookahead == 't') ADVANCE(241);
      END_STATE();
    case 160:
      if (lookahead == 's') ADVANCE(242);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(243);
      END_STATE();
    case 162:
      if (lookahead == 'r') ADVANCE(244);
      END_STATE();
    case 163:
      if (lookahead == 'n') ADVANCE(245);
      END_STATE();
    case 164:
      if (lookahead == 'c') ADVANCE(246);
      if (lookahead == 'v') ADVANCE(247);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(248);
      END_STATE();
    case 166:
      if (lookahead == 'r') ADVANCE(249);
      END_STATE();
    case 167:
      if (lookahead == 'o') ADVANCE(250);
      END_STATE();
    case 168:
      if (lookahead == 's') ADVANCE(251);
      END_STATE();
    case 169:
      if (lookahead == 'c') ADVANCE(252);
      END_STATE();
    case 170:
      if (lookahead == 's') ADVANCE(253);
      END_STATE();
    case 171:
      if (lookahead == 'a') ADVANCE(254);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(255);
      END_STATE();
    case 173:
      if (lookahead == 'd') ADVANCE(256);
      END_STATE();
    case 174:
      if (lookahead == 'i') ADVANCE(257);
      END_STATE();
    case 175:
      if (lookahead == 'a') ADVANCE(258);
      END_STATE();
    case 176:
      if (lookahead == 't') ADVANCE(259);
      END_STATE();
    case 177:
      if (lookahead == 'c') ADVANCE(260);
      END_STATE();
    case 178:
      if (lookahead == 'l') ADVANCE(261);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_auto);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_primitive_type);
      END_STATE();
    case 181:
      if (lookahead == 'k') ADVANCE(262);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 183:
      if (lookahead == 'h') ADVANCE(263);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_primitive_type);
      if (lookahead == '1') ADVANCE(264);
      if (lookahead == '3') ADVANCE(265);
      if (lookahead == '6') ADVANCE(266);
      if (lookahead == '8') ADVANCE(267);
      if (lookahead == 'p') ADVANCE(268);
      END_STATE();
    case 185:
      if (lookahead == 's') ADVANCE(269);
      END_STATE();
    case 186:
      if (lookahead == 't') ADVANCE(270);
      END_STATE();
    case 187:
      if (lookahead == 'i') ADVANCE(271);
      END_STATE();
    case 188:
      if (lookahead == 't') ADVANCE(272);
      END_STATE();
    case 189:
      if (lookahead == 'u') ADVANCE(273);
      END_STATE();
    case 190:
      if (lookahead == 'n') ADVANCE(274);
      END_STATE();
    case 191:
      if (lookahead == 't') ADVANCE(275);
      END_STATE();
    case 192:
      if (lookahead == 'l') ADVANCE(276);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 195:
      if (lookahead == 'i') ADVANCE(277);
      END_STATE();
    case 196:
      if (lookahead == 'r') ADVANCE(278);
      END_STATE();
    case 197:
      if (lookahead == 'e') ADVANCE(239);
      END_STATE();
    case 198:
      if (lookahead == 'l') ADVANCE(279);
      END_STATE();
    case 199:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 200:
      if (lookahead == 'n') ADVANCE(280);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 202:
      if (lookahead == 'n') ADVANCE(281);
      END_STATE();
    case 203:
      if (lookahead == '6') ADVANCE(282);
      END_STATE();
    case 204:
      if (lookahead == '2') ADVANCE(283);
      END_STATE();
    case 205:
      if (lookahead == '4') ADVANCE(284);
      END_STATE();
    case 206:
      if (lookahead == '_') ADVANCE(285);
      END_STATE();
    case 207:
      if (lookahead == 't') ADVANCE(286);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 209:
      if (lookahead == 'b') ADVANCE(287);
      END_STATE();
    case 210:
      if (lookahead == 's') ADVANCE(288);
      END_STATE();
    case 211:
      if (lookahead == 'c') ADVANCE(289);
      END_STATE();
    case 212:
      if (lookahead == 'p') ADVANCE(290);
      END_STATE();
    case 213:
      if (lookahead == 'a') ADVANCE(291);
      END_STATE();
    case 214:
      if (lookahead == 'r') ADVANCE(292);
      END_STATE();
    case 215:
      if (lookahead == 'a') ADVANCE(293);
      END_STATE();
    case 216:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 217:
      if (lookahead == 'i') ADVANCE(295);
      END_STATE();
    case 218:
      if (lookahead == 's') ADVANCE(296);
      END_STATE();
    case 219:
      if (lookahead == 'r') ADVANCE(297);
      END_STATE();
    case 220:
      if (lookahead == 'r') ADVANCE(298);
      END_STATE();
    case 221:
      if (lookahead == 't') ADVANCE(299);
      END_STATE();
    case 222:
      if (lookahead == 'e') ADVANCE(300);
      END_STATE();
    case 223:
      if (lookahead == '_') ADVANCE(301);
      if (lookahead == 'o') ADVANCE(302);
      END_STATE();
    case 224:
      if (lookahead == 'e') ADVANCE(303);
      END_STATE();
    case 225:
      if (lookahead == 'i') ADVANCE(304);
      END_STATE();
    case 226:
      if (lookahead == 'c') ADVANCE(305);
      END_STATE();
    case 227:
      if (lookahead == 'c') ADVANCE(306);
      END_STATE();
    case 228:
      if (lookahead == 'l') ADVANCE(307);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 230:
      if (lookahead == 'w') ADVANCE(308);
      END_STATE();
    case 231:
      if (lookahead == 'd') ADVANCE(309);
      if (lookahead == 'n') ADVANCE(310);
      END_STATE();
    case 232:
      if (lookahead == '1') ADVANCE(311);
      if (lookahead == '3') ADVANCE(312);
      if (lookahead == '6') ADVANCE(313);
      if (lookahead == '8') ADVANCE(314);
      if (lookahead == 'p') ADVANCE(315);
      END_STATE();
    case 233:
      if (lookahead == 'n') ADVANCE(316);
      END_STATE();
    case 234:
      if (lookahead == 'g') ADVANCE(317);
      END_STATE();
    case 235:
      if (lookahead == 'g') ADVANCE(318);
      END_STATE();
    case 236:
      if (lookahead == 'u') ADVANCE(319);
      END_STATE();
    case 237:
      if (lookahead == 't') ADVANCE(320);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 240:
      if (lookahead == 'i') ADVANCE(322);
      END_STATE();
    case 241:
      if (lookahead == 'r') ADVANCE(323);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(324);
      END_STATE();
    case 243:
      if (lookahead == 'c') ADVANCE(325);
      END_STATE();
    case 244:
      if (lookahead == 'c') ADVANCE(326);
      END_STATE();
    case 245:
      if (lookahead == 's') ADVANCE(327);
      END_STATE();
    case 246:
      if (lookahead == 'l') ADVANCE(328);
      END_STATE();
    case 247:
      if (lookahead == 'i') ADVANCE(329);
      END_STATE();
    case 248:
      if (lookahead == 't') ADVANCE(330);
      END_STATE();
    case 249:
      if (lookahead == 'c') ADVANCE(331);
      END_STATE();
    case 250:
      if (lookahead == 'b') ADVANCE(332);
      END_STATE();
    case 251:
      if (lookahead == 't') ADVANCE(333);
      END_STATE();
    case 252:
      if (lookahead == 'a') ADVANCE(334);
      END_STATE();
    case 253:
      if (lookahead == 't') ADVANCE(335);
      END_STATE();
    case 254:
      if (lookahead == 'r') ADVANCE(336);
      END_STATE();
    case 255:
      if (lookahead == 'r') ADVANCE(337);
      END_STATE();
    case 256:
      if (lookahead == 'c') ADVANCE(338);
      END_STATE();
    case 257:
      if (lookahead == 's') ADVANCE(339);
      END_STATE();
    case 258:
      if (lookahead == 'l') ADVANCE(340);
      END_STATE();
    case 259:
      if (lookahead == 'r') ADVANCE(341);
      END_STATE();
    case 260:
      if (lookahead == 't') ADVANCE(342);
      END_STATE();
    case 261:
      if (lookahead == 'i') ADVANCE(343);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 264:
      if (lookahead == '6') ADVANCE(344);
      END_STATE();
    case 265:
      if (lookahead == '2') ADVANCE(345);
      END_STATE();
    case 266:
      if (lookahead == '4') ADVANCE(346);
      END_STATE();
    case 267:
      if (lookahead == '_') ADVANCE(347);
      END_STATE();
    case 268:
      if (lookahead == 't') ADVANCE(348);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_const);
      if (lookahead == 'e') ADVANCE(349);
      END_STATE();
    case 271:
      if (lookahead == 'n') ADVANCE(350);
      END_STATE();
    case 272:
      if (lookahead == 'y') ADVANCE(351);
      END_STATE();
    case 273:
      if (lookahead == 'l') ADVANCE(352);
      END_STATE();
    case 274:
      if (lookahead == 'e') ADVANCE(353);
      END_STATE();
    case 275:
      if (lookahead == 'e') ADVANCE(354);
      END_STATE();
    case 276:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 277:
      if (lookahead == 'c') ADVANCE(355);
      END_STATE();
    case 278:
      if (lookahead == 'n') ADVANCE(356);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_final);
      END_STATE();
    case 280:
      if (lookahead == 'd') ADVANCE(357);
      END_STATE();
    case 281:
      if (lookahead == 'e') ADVANCE(358);
      END_STATE();
    case 282:
      if (lookahead == '_') ADVANCE(359);
      END_STATE();
    case 283:
      if (lookahead == '_') ADVANCE(360);
      END_STATE();
    case 284:
      if (lookahead == '_') ADVANCE(361);
      END_STATE();
    case 285:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 286:
      if (lookahead == 'r') ADVANCE(362);
      END_STATE();
    case 287:
      if (lookahead == 'l') ADVANCE(363);
      END_STATE();
    case 288:
      if (lookahead == 'p') ADVANCE(364);
      END_STATE();
    case 289:
      if (lookahead == 'e') ADVANCE(365);
      END_STATE();
    case 290:
      if (lookahead == 't') ADVANCE(366);
      END_STATE();
    case 291:
      if (lookahead == 't') ADVANCE(367);
      END_STATE();
    case 292:
      if (lookahead == 'i') ADVANCE(368);
      END_STATE();
    case 293:
      if (lookahead == 't') ADVANCE(369);
      END_STATE();
    case 294:
      if (lookahead == 'c') ADVANCE(370);
      END_STATE();
    case 295:
      if (lookahead == 'c') ADVANCE(371);
      END_STATE();
    case 296:
      if (lookahead == 't') ADVANCE(372);
      END_STATE();
    case 297:
      if (lookahead == 'i') ADVANCE(373);
      END_STATE();
    case 298:
      if (lookahead == 'n') ADVANCE(374);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 300:
      if (lookahead == 'd') ADVANCE(375);
      END_STATE();
    case 301:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 302:
      if (lookahead == 'f') ADVANCE(376);
      END_STATE();
    case 303:
      if (lookahead == '_') ADVANCE(377);
      END_STATE();
    case 304:
      if (lookahead == 'c') ADVANCE(378);
      END_STATE();
    case 305:
      if (lookahead == 't') ADVANCE(379);
      END_STATE();
    case 306:
      if (lookahead == 'h') ADVANCE(380);
      END_STATE();
    case 307:
      if (lookahead == 'a') ADVANCE(381);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 309:
      if (lookahead == 'e') ADVANCE(382);
      END_STATE();
    case 310:
      if (lookahead == 'a') ADVANCE(383);
      END_STATE();
    case 311:
      if (lookahead == '6') ADVANCE(384);
      END_STATE();
    case 312:
      if (lookahead == '2') ADVANCE(385);
      END_STATE();
    case 313:
      if (lookahead == '4') ADVANCE(386);
      END_STATE();
    case 314:
      if (lookahead == '_') ADVANCE(387);
      END_STATE();
    case 315:
      if (lookahead == 't') ADVANCE(388);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 317:
      if (lookahead == 'n') ADVANCE(389);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 319:
      if (lookahead == 'a') ADVANCE(390);
      END_STATE();
    case 320:
      if (lookahead == 'i') ADVANCE(391);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 322:
      if (lookahead == 'c') ADVANCE(392);
      END_STATE();
    case 323:
      if (lookahead == 'i') ADVANCE(393);
      END_STATE();
    case 324:
      if (lookahead == 'd') ADVANCE(394);
      END_STATE();
    case 325:
      if (lookahead == 'l') ADVANCE(395);
      END_STATE();
    case 326:
      if (lookahead == 'a') ADVANCE(396);
      END_STATE();
    case 327:
      if (lookahead == 't') ADVANCE(397);
      END_STATE();
    case 328:
      if (lookahead == 's') ADVANCE(398);
      END_STATE();
    case 329:
      if (lookahead == 'c') ADVANCE(399);
      END_STATE();
    case 330:
      if (lookahead == 'c') ADVANCE(400);
      END_STATE();
    case 331:
      if (lookahead == 'e') ADVANCE(401);
      END_STATE();
    case 332:
      if (lookahead == 'a') ADVANCE(402);
      END_STATE();
    case 333:
      if (lookahead == '_') ADVANCE(403);
      END_STATE();
    case 334:
      if (lookahead == 'l') ADVANCE(404);
      END_STATE();
    case 335:
      if (lookahead == 'r') ADVANCE(405);
      END_STATE();
    case 336:
      if (lookahead == 'e') ADVANCE(406);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_ms_signed_ptr_modifier);
      END_STATE();
    case 338:
      if (lookahead == 'a') ADVANCE(407);
      END_STATE();
    case 339:
      if (lookahead == 'c') ADVANCE(408);
      END_STATE();
    case 340:
      if (lookahead == 'i') ADVANCE(409);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_ms_unsigned_ptr_modifier);
      END_STATE();
    case 342:
      if (lookahead == 'o') ADVANCE(410);
      END_STATE();
    case 343:
      if (lookahead == 'g') ADVANCE(411);
      END_STATE();
    case 344:
      if (lookahead == '_') ADVANCE(412);
      END_STATE();
    case 345:
      if (lookahead == '_') ADVANCE(413);
      END_STATE();
    case 346:
      if (lookahead == '_') ADVANCE(414);
      END_STATE();
    case 347:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 348:
      if (lookahead == 'r') ADVANCE(415);
      END_STATE();
    case 349:
      if (lookahead == 'x') ADVANCE(416);
      END_STATE();
    case 350:
      if (lookahead == 'u') ADVANCE(417);
      END_STATE();
    case 351:
      if (lookahead == 'p') ADVANCE(418);
      END_STATE();
    case 352:
      if (lookahead == 't') ADVANCE(419);
      END_STATE();
    case 353:
      if (lookahead == 'd') ADVANCE(420);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 355:
      if (lookahead == 'i') ADVANCE(421);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_extern);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_friend);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_inline);
      END_STATE();
    case 359:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 360:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 361:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 362:
      if (lookahead == '_') ADVANCE(422);
      END_STATE();
    case 363:
      if (lookahead == 'e') ADVANCE(423);
      END_STATE();
    case 364:
      if (lookahead == 'a') ADVANCE(424);
      END_STATE();
    case 365:
      if (lookahead == 'p') ADVANCE(425);
      END_STATE();
    case 366:
      if (lookahead == 'r') ADVANCE(426);
      END_STATE();
    case 367:
      if (lookahead == 'o') ADVANCE(427);
      END_STATE();
    case 368:
      if (lookahead == 'd') ADVANCE(428);
      END_STATE();
    case 369:
      if (lookahead == 'e') ADVANCE(429);
      END_STATE();
    case 370:
      if (lookahead == 't') ADVANCE(430);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 372:
      if (lookahead == 'e') ADVANCE(431);
      END_STATE();
    case 373:
      if (lookahead == 'c') ADVANCE(432);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym_signed);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_sizeof);
      END_STATE();
    case 377:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_static);
      if (lookahead == '_') ADVANCE(433);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 381:
      if (lookahead == 't') ADVANCE(434);
      END_STATE();
    case 382:
      if (lookahead == 'f') ADVANCE(435);
      END_STATE();
    case 383:
      if (lookahead == 'm') ADVANCE(436);
      END_STATE();
    case 384:
      if (lookahead == '_') ADVANCE(437);
      END_STATE();
    case 385:
      if (lookahead == '_') ADVANCE(438);
      END_STATE();
    case 386:
      if (lookahead == '_') ADVANCE(439);
      END_STATE();
    case 387:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 388:
      if (lookahead == 'r') ADVANCE(440);
      END_STATE();
    case 389:
      if (lookahead == 'e') ADVANCE(441);
      END_STATE();
    case 390:
      if (lookahead == 'l') ADVANCE(442);
      END_STATE();
    case 391:
      if (lookahead == 'l') ADVANCE(443);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym__Atomic);
      END_STATE();
    case 393:
      if (lookahead == 'b') ADVANCE(444);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym___based);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym___cdecl);
      END_STATE();
    case 396:
      if (lookahead == 'l') ADVANCE(445);
      END_STATE();
    case 397:
      if (lookahead == 'a') ADVANCE(446);
      END_STATE();
    case 398:
      if (lookahead == 'p') ADVANCE(447);
      END_STATE();
    case 399:
      if (lookahead == 'e') ADVANCE(448);
      END_STATE();
    case 400:
      if (lookahead == 'a') ADVANCE(449);
      END_STATE();
    case 401:
      if (lookahead == 'i') ADVANCE(450);
      END_STATE();
    case 402:
      if (lookahead == 'l') ADVANCE(451);
      END_STATE();
    case 403:
      if (lookahead == '_') ADVANCE(452);
      END_STATE();
    case 404:
      if (lookahead == '_') ADVANCE(453);
      END_STATE();
    case 405:
      if (lookahead == 'i') ADVANCE(454);
      END_STATE();
    case 406:
      if (lookahead == 'd') ADVANCE(455);
      END_STATE();
    case 407:
      if (lookahead == 'l') ADVANCE(456);
      END_STATE();
    case 408:
      if (lookahead == 'a') ADVANCE(457);
      END_STATE();
    case 409:
      if (lookahead == 'g') ADVANCE(458);
      END_STATE();
    case 410:
      if (lookahead == 'r') ADVANCE(459);
      END_STATE();
    case 411:
      if (lookahead == 'n') ADVANCE(460);
      END_STATE();
    case 412:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 413:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 414:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 415:
      if (lookahead == '_') ADVANCE(461);
      END_STATE();
    case 416:
      if (lookahead == 'p') ADVANCE(462);
      END_STATE();
    case 417:
      if (lookahead == 'e') ADVANCE(463);
      END_STATE();
    case 418:
      if (lookahead == 'e') ADVANCE(464);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_defined);
      END_STATE();
    case 421:
      if (lookahead == 't') ADVANCE(465);
      END_STATE();
    case 422:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_mutable);
      END_STATE();
    case 424:
      if (lookahead == 'c') ADVANCE(466);
      END_STATE();
    case 425:
      if (lookahead == 't') ADVANCE(467);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym_nullptr);
      END_STATE();
    case 427:
      if (lookahead == 'r') ADVANCE(468);
      END_STATE();
    case 428:
      if (lookahead == 'e') ADVANCE(469);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 430:
      if (lookahead == 'e') ADVANCE(470);
      END_STATE();
    case 431:
      if (lookahead == 'r') ADVANCE(471);
      END_STATE();
    case 432:
      if (lookahead == 't') ADVANCE(472);
      END_STATE();
    case 433:
      if (lookahead == 'a') ADVANCE(473);
      END_STATE();
    case 434:
      if (lookahead == 'e') ADVANCE(474);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(anon_sym_typedef);
      END_STATE();
    case 436:
      if (lookahead == 'e') ADVANCE(475);
      END_STATE();
    case 437:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 438:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 439:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 440:
      if (lookahead == '_') ADVANCE(476);
      END_STATE();
    case 441:
      if (lookahead == 'd') ADVANCE(477);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_virtual);
      END_STATE();
    case 443:
      if (lookahead == 'e') ADVANCE(478);
      END_STATE();
    case 444:
      if (lookahead == 'u') ADVANCE(479);
      END_STATE();
    case 445:
      if (lookahead == 'l') ADVANCE(480);
      END_STATE();
    case 446:
      if (lookahead == 'n') ADVANCE(481);
      END_STATE();
    case 447:
      if (lookahead == 'e') ADVANCE(482);
      END_STATE();
    case 448:
      if (lookahead == '_') ADVANCE(483);
      END_STATE();
    case 449:
      if (lookahead == 'l') ADVANCE(484);
      END_STATE();
    case 450:
      if (lookahead == 'n') ADVANCE(485);
      END_STATE();
    case 451:
      if (lookahead == '_') ADVANCE(486);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(anon_sym___host__);
      END_STATE();
    case 453:
      if (lookahead == '_') ADVANCE(487);
      END_STATE();
    case 454:
      if (lookahead == 'c') ADVANCE(488);
      END_STATE();
    case 455:
      if (lookahead == '_') ADVANCE(489);
      END_STATE();
    case 456:
      if (lookahead == 'l') ADVANCE(490);
      END_STATE();
    case 457:
      if (lookahead == 'l') ADVANCE(491);
      END_STATE();
    case 458:
      if (lookahead == 'n') ADVANCE(492);
      END_STATE();
    case 459:
      if (lookahead == 'c') ADVANCE(493);
      END_STATE();
    case 460:
      if (lookahead == 'e') ADVANCE(494);
      END_STATE();
    case 461:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 462:
      if (lookahead == 'r') ADVANCE(495);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_decltype);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym_explicit);
      END_STATE();
    case 466:
      if (lookahead == 'e') ADVANCE(496);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_noexcept);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_operator);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 470:
      if (lookahead == 'd') ADVANCE(497);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_register);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(anon_sym_restrict);
      END_STATE();
    case 473:
      if (lookahead == 's') ADVANCE(498);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_template);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_typename);
      END_STATE();
    case 476:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 479:
      if (lookahead == 't') ADVANCE(499);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym___clrcall);
      END_STATE();
    case 481:
      if (lookahead == 't') ADVANCE(500);
      END_STATE();
    case 482:
      if (lookahead == 'c') ADVANCE(501);
      END_STATE();
    case 483:
      if (lookahead == '_') ADVANCE(502);
      END_STATE();
    case 484:
      if (lookahead == 'l') ADVANCE(503);
      END_STATE();
    case 485:
      if (lookahead == 'l') ADVANCE(504);
      END_STATE();
    case 486:
      if (lookahead == '_') ADVANCE(505);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(anon_sym___local__);
      END_STATE();
    case 488:
      if (lookahead == 't') ADVANCE(506);
      END_STATE();
    case 489:
      if (lookahead == '_') ADVANCE(507);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym___stdcall);
      END_STATE();
    case 491:
      if (lookahead == 'l') ADVANCE(508);
      END_STATE();
    case 492:
      if (lookahead == 'e') ADVANCE(509);
      END_STATE();
    case 493:
      if (lookahead == 'a') ADVANCE(510);
      END_STATE();
    case 494:
      if (lookahead == 'd') ADVANCE(511);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(anon_sym_constexpr);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 498:
      if (lookahead == 's') ADVANCE(512);
      END_STATE();
    case 499:
      if (lookahead == 'e') ADVANCE(513);
      END_STATE();
    case 500:
      if (lookahead == '_') ADVANCE(514);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(anon_sym___declspec);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(anon_sym___device__);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(anon_sym___fastcall);
      END_STATE();
    case 504:
      if (lookahead == 'i') ADVANCE(515);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(anon_sym___global__);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(sym_ms_restrict_modifier);
      if (lookahead == '_') ADVANCE(516);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(anon_sym___shared__);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(anon_sym___thiscall);
      END_STATE();
    case 509:
      if (lookahead == 'd') ADVANCE(517);
      END_STATE();
    case 510:
      if (lookahead == 'l') ADVANCE(518);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(anon_sym__unaligned);
      END_STATE();
    case 512:
      if (lookahead == 'e') ADVANCE(519);
      END_STATE();
    case 513:
      if (lookahead == '_') ADVANCE(520);
      END_STATE();
    case 514:
      if (lookahead == '_') ADVANCE(521);
      END_STATE();
    case 515:
      if (lookahead == 'n') ADVANCE(522);
      END_STATE();
    case 516:
      if (lookahead == '_') ADVANCE(523);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(anon_sym___unaligned);
      END_STATE();
    case 518:
      if (lookahead == 'l') ADVANCE(524);
      END_STATE();
    case 519:
      if (lookahead == 'r') ADVANCE(525);
      END_STATE();
    case 520:
      if (lookahead == '_') ADVANCE(526);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym___constant__);
      END_STATE();
    case 522:
      if (lookahead == 'e') ADVANCE(527);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym___restrict__);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym___vectorcall);
      END_STATE();
    case 525:
      if (lookahead == 't') ADVANCE(528);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym___attribute__);
      END_STATE();
    case 527:
      if (lookahead == '_') ADVANCE(529);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(anon_sym_static_assert);
      END_STATE();
    case 529:
      if (lookahead == '_') ADVANCE(530);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym___forceinline__);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 214, .external_lex_state = 1},
  [2] = {.lex_state = 214, .external_lex_state = 1},
  [3] = {.lex_state = 214, .external_lex_state = 1},
  [4] = {.lex_state = 214, .external_lex_state = 1},
  [5] = {.lex_state = 214, .external_lex_state = 1},
  [6] = {.lex_state = 214, .external_lex_state = 1},
  [7] = {.lex_state = 214, .external_lex_state = 1},
  [8] = {.lex_state = 214, .external_lex_state = 1},
  [9] = {.lex_state = 214, .external_lex_state = 1},
  [10] = {.lex_state = 115, .external_lex_state = 1},
  [11] = {.lex_state = 115, .external_lex_state = 1},
  [12] = {.lex_state = 115, .external_lex_state = 1},
  [13] = {.lex_state = 115, .external_lex_state = 1},
  [14] = {.lex_state = 115, .external_lex_state = 1},
  [15] = {.lex_state = 115, .external_lex_state = 1},
  [16] = {.lex_state = 115, .external_lex_state = 1},
  [17] = {.lex_state = 115, .external_lex_state = 1},
  [18] = {.lex_state = 115, .external_lex_state = 1},
  [19] = {.lex_state = 115, .external_lex_state = 1},
  [20] = {.lex_state = 115, .external_lex_state = 1},
  [21] = {.lex_state = 115, .external_lex_state = 1},
  [22] = {.lex_state = 115, .external_lex_state = 1},
  [23] = {.lex_state = 115, .external_lex_state = 1},
  [24] = {.lex_state = 115, .external_lex_state = 1},
  [25] = {.lex_state = 115, .external_lex_state = 1},
  [26] = {.lex_state = 115, .external_lex_state = 1},
  [27] = {.lex_state = 115, .external_lex_state = 1},
  [28] = {.lex_state = 115, .external_lex_state = 1},
  [29] = {.lex_state = 214, .external_lex_state = 1},
  [30] = {.lex_state = 214, .external_lex_state = 1},
  [31] = {.lex_state = 214, .external_lex_state = 1},
  [32] = {.lex_state = 214, .external_lex_state = 1},
  [33] = {.lex_state = 214, .external_lex_state = 1},
  [34] = {.lex_state = 214, .external_lex_state = 1},
  [35] = {.lex_state = 214, .external_lex_state = 1},
  [36] = {.lex_state = 214, .external_lex_state = 1},
  [37] = {.lex_state = 214, .external_lex_state = 1},
  [38] = {.lex_state = 214, .external_lex_state = 1},
  [39] = {.lex_state = 214, .external_lex_state = 1},
  [40] = {.lex_state = 214, .external_lex_state = 1},
  [41] = {.lex_state = 214, .external_lex_state = 1},
  [42] = {.lex_state = 214, .external_lex_state = 1},
  [43] = {.lex_state = 214, .external_lex_state = 1},
  [44] = {.lex_state = 214, .external_lex_state = 1},
  [45] = {.lex_state = 117, .external_lex_state = 1},
  [46] = {.lex_state = 214, .external_lex_state = 1},
  [47] = {.lex_state = 214, .external_lex_state = 1},
  [48] = {.lex_state = 214, .external_lex_state = 1},
  [49] = {.lex_state = 214, .external_lex_state = 1},
  [50] = {.lex_state = 214, .external_lex_state = 1},
  [51] = {.lex_state = 214, .external_lex_state = 1},
  [52] = {.lex_state = 214, .external_lex_state = 1},
  [53] = {.lex_state = 214, .external_lex_state = 1},
  [54] = {.lex_state = 214, .external_lex_state = 1},
  [55] = {.lex_state = 214, .external_lex_state = 1},
  [56] = {.lex_state = 214, .external_lex_state = 1},
  [57] = {.lex_state = 214, .external_lex_state = 1},
  [58] = {.lex_state = 214, .external_lex_state = 1},
  [59] = {.lex_state = 214, .external_lex_state = 1},
  [60] = {.lex_state = 214, .external_lex_state = 1},
  [61] = {.lex_state = 117, .external_lex_state = 1},
  [62] = {.lex_state = 214, .external_lex_state = 1},
  [63] = {.lex_state = 214, .external_lex_state = 1},
  [64] = {.lex_state = 214, .external_lex_state = 1},
  [65] = {.lex_state = 214, .external_lex_state = 1},
  [66] = {.lex_state = 117, .external_lex_state = 1},
  [67] = {.lex_state = 214, .external_lex_state = 1},
  [68] = {.lex_state = 214, .external_lex_state = 1},
  [69] = {.lex_state = 214, .external_lex_state = 1},
  [70] = {.lex_state = 214, .external_lex_state = 1},
  [71] = {.lex_state = 214, .external_lex_state = 1},
  [72] = {.lex_state = 214, .external_lex_state = 1},
  [73] = {.lex_state = 214, .external_lex_state = 1},
  [74] = {.lex_state = 214, .external_lex_state = 1},
  [75] = {.lex_state = 115, .external_lex_state = 1},
  [76] = {.lex_state = 115, .external_lex_state = 1},
  [77] = {.lex_state = 115, .external_lex_state = 1},
  [78] = {.lex_state = 115, .external_lex_state = 1},
  [79] = {.lex_state = 115, .external_lex_state = 1},
  [80] = {.lex_state = 117, .external_lex_state = 1},
  [81] = {.lex_state = 117, .external_lex_state = 1},
  [82] = {.lex_state = 117, .external_lex_state = 1},
  [83] = {.lex_state = 214, .external_lex_state = 1},
  [84] = {.lex_state = 214, .external_lex_state = 1},
  [85] = {.lex_state = 214, .external_lex_state = 1},
  [86] = {.lex_state = 214, .external_lex_state = 1},
  [87] = {.lex_state = 214, .external_lex_state = 1},
  [88] = {.lex_state = 214, .external_lex_state = 1},
  [89] = {.lex_state = 214, .external_lex_state = 1},
  [90] = {.lex_state = 214, .external_lex_state = 1},
  [91] = {.lex_state = 214, .external_lex_state = 1},
  [92] = {.lex_state = 214, .external_lex_state = 1},
  [93] = {.lex_state = 117, .external_lex_state = 1},
  [94] = {.lex_state = 117, .external_lex_state = 1},
  [95] = {.lex_state = 116, .external_lex_state = 1},
  [96] = {.lex_state = 116, .external_lex_state = 1},
  [97] = {.lex_state = 116, .external_lex_state = 1},
  [98] = {.lex_state = 116, .external_lex_state = 1},
  [99] = {.lex_state = 116, .external_lex_state = 1},
  [100] = {.lex_state = 129},
  [101] = {.lex_state = 129},
  [102] = {.lex_state = 129},
  [103] = {.lex_state = 129},
  [104] = {.lex_state = 129},
  [105] = {.lex_state = 129},
  [106] = {.lex_state = 129},
  [107] = {.lex_state = 129},
  [108] = {.lex_state = 129},
  [109] = {.lex_state = 129},
  [110] = {.lex_state = 129},
  [111] = {.lex_state = 129},
  [112] = {.lex_state = 129},
  [113] = {.lex_state = 129},
  [114] = {.lex_state = 129},
  [115] = {.lex_state = 116, .external_lex_state = 1},
  [116] = {.lex_state = 155},
  [117] = {.lex_state = 155},
  [118] = {.lex_state = 156},
  [119] = {.lex_state = 155},
  [120] = {.lex_state = 155},
  [121] = {.lex_state = 155},
  [122] = {.lex_state = 155},
  [123] = {.lex_state = 155},
  [124] = {.lex_state = 155},
  [125] = {.lex_state = 156},
  [126] = {.lex_state = 155},
  [127] = {.lex_state = 155},
  [128] = {.lex_state = 155},
  [129] = {.lex_state = 155},
  [130] = {.lex_state = 155},
  [131] = {.lex_state = 155},
  [132] = {.lex_state = 155},
  [133] = {.lex_state = 155},
  [134] = {.lex_state = 155},
  [135] = {.lex_state = 156},
  [136] = {.lex_state = 116, .external_lex_state = 1},
  [137] = {.lex_state = 116, .external_lex_state = 1},
  [138] = {.lex_state = 115, .external_lex_state = 1},
  [139] = {.lex_state = 115, .external_lex_state = 1},
  [140] = {.lex_state = 116, .external_lex_state = 1},
  [141] = {.lex_state = 116, .external_lex_state = 1},
  [142] = {.lex_state = 116, .external_lex_state = 1},
  [143] = {.lex_state = 116, .external_lex_state = 1},
  [144] = {.lex_state = 116, .external_lex_state = 1},
  [145] = {.lex_state = 116, .external_lex_state = 1},
  [146] = {.lex_state = 116, .external_lex_state = 1},
  [147] = {.lex_state = 116, .external_lex_state = 1},
  [148] = {.lex_state = 116, .external_lex_state = 1},
  [149] = {.lex_state = 116, .external_lex_state = 1},
  [150] = {.lex_state = 116, .external_lex_state = 1},
  [151] = {.lex_state = 214, .external_lex_state = 1},
  [152] = {.lex_state = 117, .external_lex_state = 1},
  [153] = {.lex_state = 214, .external_lex_state = 1},
  [154] = {.lex_state = 117, .external_lex_state = 1},
  [155] = {.lex_state = 115, .external_lex_state = 1},
  [156] = {.lex_state = 115, .external_lex_state = 1},
  [157] = {.lex_state = 214, .external_lex_state = 1},
  [158] = {.lex_state = 115, .external_lex_state = 1},
  [159] = {.lex_state = 214, .external_lex_state = 1},
  [160] = {.lex_state = 115, .external_lex_state = 1},
  [161] = {.lex_state = 115, .external_lex_state = 1},
  [162] = {.lex_state = 115, .external_lex_state = 1},
  [163] = {.lex_state = 115, .external_lex_state = 1},
  [164] = {.lex_state = 115, .external_lex_state = 1},
  [165] = {.lex_state = 115, .external_lex_state = 1},
  [166] = {.lex_state = 115, .external_lex_state = 1},
  [167] = {.lex_state = 115, .external_lex_state = 1},
  [168] = {.lex_state = 115, .external_lex_state = 1},
  [169] = {.lex_state = 115, .external_lex_state = 1},
  [170] = {.lex_state = 115, .external_lex_state = 1},
  [171] = {.lex_state = 115, .external_lex_state = 1},
  [172] = {.lex_state = 115, .external_lex_state = 1},
  [173] = {.lex_state = 115, .external_lex_state = 1},
  [174] = {.lex_state = 115, .external_lex_state = 1},
  [175] = {.lex_state = 115, .external_lex_state = 1},
  [176] = {.lex_state = 115, .external_lex_state = 1},
  [177] = {.lex_state = 115, .external_lex_state = 1},
  [178] = {.lex_state = 115, .external_lex_state = 1},
  [179] = {.lex_state = 115, .external_lex_state = 1},
  [180] = {.lex_state = 115, .external_lex_state = 1},
  [181] = {.lex_state = 115, .external_lex_state = 1},
  [182] = {.lex_state = 115, .external_lex_state = 1},
  [183] = {.lex_state = 118, .external_lex_state = 1},
  [184] = {.lex_state = 115, .external_lex_state = 1},
  [185] = {.lex_state = 115, .external_lex_state = 1},
  [186] = {.lex_state = 115, .external_lex_state = 1},
  [187] = {.lex_state = 115, .external_lex_state = 1},
  [188] = {.lex_state = 115, .external_lex_state = 1},
  [189] = {.lex_state = 115, .external_lex_state = 1},
  [190] = {.lex_state = 115, .external_lex_state = 1},
  [191] = {.lex_state = 115, .external_lex_state = 1},
  [192] = {.lex_state = 118, .external_lex_state = 1},
  [193] = {.lex_state = 115, .external_lex_state = 1},
  [194] = {.lex_state = 115, .external_lex_state = 1},
  [195] = {.lex_state = 115, .external_lex_state = 1},
  [196] = {.lex_state = 115, .external_lex_state = 1},
  [197] = {.lex_state = 115, .external_lex_state = 1},
  [198] = {.lex_state = 115, .external_lex_state = 1},
  [199] = {.lex_state = 115, .external_lex_state = 1},
  [200] = {.lex_state = 115, .external_lex_state = 1},
  [201] = {.lex_state = 115, .external_lex_state = 1},
  [202] = {.lex_state = 115, .external_lex_state = 1},
  [203] = {.lex_state = 115, .external_lex_state = 1},
  [204] = {.lex_state = 115, .external_lex_state = 1},
  [205] = {.lex_state = 115, .external_lex_state = 1},
  [206] = {.lex_state = 115, .external_lex_state = 1},
  [207] = {.lex_state = 115, .external_lex_state = 1},
  [208] = {.lex_state = 115, .external_lex_state = 1},
  [209] = {.lex_state = 115, .external_lex_state = 1},
  [210] = {.lex_state = 115, .external_lex_state = 1},
  [211] = {.lex_state = 115, .external_lex_state = 1},
  [212] = {.lex_state = 115, .external_lex_state = 1},
  [213] = {.lex_state = 115, .external_lex_state = 1},
  [214] = {.lex_state = 115, .external_lex_state = 1},
  [215] = {.lex_state = 115, .external_lex_state = 1},
  [216] = {.lex_state = 115, .external_lex_state = 1},
  [217] = {.lex_state = 115, .external_lex_state = 1},
  [218] = {.lex_state = 115, .external_lex_state = 1},
  [219] = {.lex_state = 115, .external_lex_state = 1},
  [220] = {.lex_state = 115, .external_lex_state = 1},
  [221] = {.lex_state = 115, .external_lex_state = 1},
  [222] = {.lex_state = 115, .external_lex_state = 1},
  [223] = {.lex_state = 115, .external_lex_state = 1},
  [224] = {.lex_state = 115, .external_lex_state = 1},
  [225] = {.lex_state = 115, .external_lex_state = 1},
  [226] = {.lex_state = 115, .external_lex_state = 1},
  [227] = {.lex_state = 115, .external_lex_state = 1},
  [228] = {.lex_state = 115, .external_lex_state = 1},
  [229] = {.lex_state = 115, .external_lex_state = 1},
  [230] = {.lex_state = 115, .external_lex_state = 1},
  [231] = {.lex_state = 115, .external_lex_state = 1},
  [232] = {.lex_state = 115, .external_lex_state = 1},
  [233] = {.lex_state = 115, .external_lex_state = 1},
  [234] = {.lex_state = 115, .external_lex_state = 1},
  [235] = {.lex_state = 115, .external_lex_state = 1},
  [236] = {.lex_state = 115, .external_lex_state = 1},
  [237] = {.lex_state = 115, .external_lex_state = 1},
  [238] = {.lex_state = 115, .external_lex_state = 1},
  [239] = {.lex_state = 115, .external_lex_state = 1},
  [240] = {.lex_state = 115, .external_lex_state = 1},
  [241] = {.lex_state = 117, .external_lex_state = 1},
  [242] = {.lex_state = 115, .external_lex_state = 1},
  [243] = {.lex_state = 115, .external_lex_state = 1},
  [244] = {.lex_state = 115, .external_lex_state = 1},
  [245] = {.lex_state = 115, .external_lex_state = 1},
  [246] = {.lex_state = 214, .external_lex_state = 1},
  [247] = {.lex_state = 115, .external_lex_state = 1},
  [248] = {.lex_state = 115, .external_lex_state = 1},
  [249] = {.lex_state = 115, .external_lex_state = 1},
  [250] = {.lex_state = 115, .external_lex_state = 1},
  [251] = {.lex_state = 214, .external_lex_state = 1},
  [252] = {.lex_state = 115, .external_lex_state = 1},
  [253] = {.lex_state = 115, .external_lex_state = 1},
  [254] = {.lex_state = 115, .external_lex_state = 1},
  [255] = {.lex_state = 115, .external_lex_state = 1},
  [256] = {.lex_state = 115, .external_lex_state = 1},
  [257] = {.lex_state = 115, .external_lex_state = 1},
  [258] = {.lex_state = 115, .external_lex_state = 1},
  [259] = {.lex_state = 117, .external_lex_state = 1},
  [260] = {.lex_state = 115, .external_lex_state = 1},
  [261] = {.lex_state = 214, .external_lex_state = 1},
  [262] = {.lex_state = 115, .external_lex_state = 1},
  [263] = {.lex_state = 115, .external_lex_state = 1},
  [264] = {.lex_state = 115, .external_lex_state = 1},
  [265] = {.lex_state = 115, .external_lex_state = 1},
  [266] = {.lex_state = 115, .external_lex_state = 1},
  [267] = {.lex_state = 214, .external_lex_state = 1},
  [268] = {.lex_state = 115, .external_lex_state = 1},
  [269] = {.lex_state = 115, .external_lex_state = 1},
  [270] = {.lex_state = 117, .external_lex_state = 1},
  [271] = {.lex_state = 115, .external_lex_state = 1},
  [272] = {.lex_state = 115, .external_lex_state = 1},
  [273] = {.lex_state = 115, .external_lex_state = 1},
  [274] = {.lex_state = 115, .external_lex_state = 1},
  [275] = {.lex_state = 115, .external_lex_state = 1},
  [276] = {.lex_state = 115, .external_lex_state = 1},
  [277] = {.lex_state = 115, .external_lex_state = 1},
  [278] = {.lex_state = 115, .external_lex_state = 1},
  [279] = {.lex_state = 115, .external_lex_state = 1},
  [280] = {.lex_state = 115, .external_lex_state = 1},
  [281] = {.lex_state = 115, .external_lex_state = 1},
  [282] = {.lex_state = 115, .external_lex_state = 1},
  [283] = {.lex_state = 115, .external_lex_state = 1},
  [284] = {.lex_state = 115, .external_lex_state = 1},
  [285] = {.lex_state = 115, .external_lex_state = 1},
  [286] = {.lex_state = 115, .external_lex_state = 1},
  [287] = {.lex_state = 115, .external_lex_state = 1},
  [288] = {.lex_state = 115, .external_lex_state = 1},
  [289] = {.lex_state = 115, .external_lex_state = 1},
  [290] = {.lex_state = 115, .external_lex_state = 1},
  [291] = {.lex_state = 115, .external_lex_state = 1},
  [292] = {.lex_state = 214, .external_lex_state = 1},
  [293] = {.lex_state = 115, .external_lex_state = 1},
  [294] = {.lex_state = 115, .external_lex_state = 1},
  [295] = {.lex_state = 115, .external_lex_state = 1},
  [296] = {.lex_state = 115, .external_lex_state = 1},
  [297] = {.lex_state = 115, .external_lex_state = 1},
  [298] = {.lex_state = 214, .external_lex_state = 1},
  [299] = {.lex_state = 115, .external_lex_state = 1},
  [300] = {.lex_state = 115, .external_lex_state = 1},
  [301] = {.lex_state = 214, .external_lex_state = 1},
  [302] = {.lex_state = 117, .external_lex_state = 1},
  [303] = {.lex_state = 214, .external_lex_state = 1},
  [304] = {.lex_state = 117, .external_lex_state = 1},
  [305] = {.lex_state = 214, .external_lex_state = 1},
  [306] = {.lex_state = 214, .external_lex_state = 1},
  [307] = {.lex_state = 214, .external_lex_state = 1},
  [308] = {.lex_state = 214, .external_lex_state = 1},
  [309] = {.lex_state = 117, .external_lex_state = 1},
  [310] = {.lex_state = 117, .external_lex_state = 1},
  [311] = {.lex_state = 117, .external_lex_state = 1},
  [312] = {.lex_state = 117, .external_lex_state = 1},
  [313] = {.lex_state = 117, .external_lex_state = 1},
  [314] = {.lex_state = 214, .external_lex_state = 1},
  [315] = {.lex_state = 214, .external_lex_state = 1},
  [316] = {.lex_state = 117, .external_lex_state = 1},
  [317] = {.lex_state = 117, .external_lex_state = 1},
  [318] = {.lex_state = 117, .external_lex_state = 1},
  [319] = {.lex_state = 214, .external_lex_state = 1},
  [320] = {.lex_state = 214, .external_lex_state = 1},
  [321] = {.lex_state = 214, .external_lex_state = 1},
  [322] = {.lex_state = 214, .external_lex_state = 1},
  [323] = {.lex_state = 117, .external_lex_state = 1},
  [324] = {.lex_state = 117, .external_lex_state = 1},
  [325] = {.lex_state = 117, .external_lex_state = 1},
  [326] = {.lex_state = 117, .external_lex_state = 1},
  [327] = {.lex_state = 214, .external_lex_state = 1},
  [328] = {.lex_state = 214, .external_lex_state = 1},
  [329] = {.lex_state = 117, .external_lex_state = 1},
  [330] = {.lex_state = 117, .external_lex_state = 1},
  [331] = {.lex_state = 214, .external_lex_state = 1},
  [332] = {.lex_state = 214, .external_lex_state = 1},
  [333] = {.lex_state = 117, .external_lex_state = 1},
  [334] = {.lex_state = 117, .external_lex_state = 1},
  [335] = {.lex_state = 214, .external_lex_state = 1},
  [336] = {.lex_state = 214, .external_lex_state = 1},
  [337] = {.lex_state = 117, .external_lex_state = 1},
  [338] = {.lex_state = 214, .external_lex_state = 1},
  [339] = {.lex_state = 214, .external_lex_state = 1},
  [340] = {.lex_state = 214, .external_lex_state = 1},
  [341] = {.lex_state = 117, .external_lex_state = 1},
  [342] = {.lex_state = 117, .external_lex_state = 1},
  [343] = {.lex_state = 117, .external_lex_state = 1},
  [344] = {.lex_state = 117, .external_lex_state = 1},
  [345] = {.lex_state = 117, .external_lex_state = 1},
  [346] = {.lex_state = 117, .external_lex_state = 1},
  [347] = {.lex_state = 117, .external_lex_state = 1},
  [348] = {.lex_state = 117, .external_lex_state = 1},
  [349] = {.lex_state = 117, .external_lex_state = 1},
  [350] = {.lex_state = 117, .external_lex_state = 1},
  [351] = {.lex_state = 117, .external_lex_state = 1},
  [352] = {.lex_state = 117, .external_lex_state = 1},
  [353] = {.lex_state = 117, .external_lex_state = 1},
  [354] = {.lex_state = 117, .external_lex_state = 1},
  [355] = {.lex_state = 117, .external_lex_state = 1},
  [356] = {.lex_state = 117, .external_lex_state = 1},
  [357] = {.lex_state = 117, .external_lex_state = 1},
  [358] = {.lex_state = 117, .external_lex_state = 1},
  [359] = {.lex_state = 117, .external_lex_state = 1},
  [360] = {.lex_state = 117, .external_lex_state = 1},
  [361] = {.lex_state = 117, .external_lex_state = 1},
  [362] = {.lex_state = 117, .external_lex_state = 1},
  [363] = {.lex_state = 117, .external_lex_state = 1},
  [364] = {.lex_state = 117, .external_lex_state = 1},
  [365] = {.lex_state = 117, .external_lex_state = 1},
  [366] = {.lex_state = 214, .external_lex_state = 1},
  [367] = {.lex_state = 214, .external_lex_state = 1},
  [368] = {.lex_state = 117, .external_lex_state = 1},
  [369] = {.lex_state = 117, .external_lex_state = 1},
  [370] = {.lex_state = 117, .external_lex_state = 1},
  [371] = {.lex_state = 117, .external_lex_state = 1},
  [372] = {.lex_state = 117, .external_lex_state = 1},
  [373] = {.lex_state = 117, .external_lex_state = 1},
  [374] = {.lex_state = 117, .external_lex_state = 1},
  [375] = {.lex_state = 117, .external_lex_state = 1},
  [376] = {.lex_state = 117, .external_lex_state = 1},
  [377] = {.lex_state = 117, .external_lex_state = 1},
  [378] = {.lex_state = 117, .external_lex_state = 1},
  [379] = {.lex_state = 117, .external_lex_state = 1},
  [380] = {.lex_state = 117, .external_lex_state = 1},
  [381] = {.lex_state = 117, .external_lex_state = 1},
  [382] = {.lex_state = 117, .external_lex_state = 1},
  [383] = {.lex_state = 117, .external_lex_state = 1},
  [384] = {.lex_state = 117, .external_lex_state = 1},
  [385] = {.lex_state = 117, .external_lex_state = 1},
  [386] = {.lex_state = 214, .external_lex_state = 1},
  [387] = {.lex_state = 117, .external_lex_state = 1},
  [388] = {.lex_state = 117, .external_lex_state = 1},
  [389] = {.lex_state = 117, .external_lex_state = 1},
  [390] = {.lex_state = 214, .external_lex_state = 1},
  [391] = {.lex_state = 117, .external_lex_state = 1},
  [392] = {.lex_state = 117, .external_lex_state = 1},
  [393] = {.lex_state = 214, .external_lex_state = 1},
  [394] = {.lex_state = 117, .external_lex_state = 1},
  [395] = {.lex_state = 117, .external_lex_state = 1},
  [396] = {.lex_state = 214, .external_lex_state = 1},
  [397] = {.lex_state = 117, .external_lex_state = 1},
  [398] = {.lex_state = 214, .external_lex_state = 1},
  [399] = {.lex_state = 117, .external_lex_state = 1},
  [400] = {.lex_state = 214, .external_lex_state = 1},
  [401] = {.lex_state = 117, .external_lex_state = 1},
  [402] = {.lex_state = 214, .external_lex_state = 1},
  [403] = {.lex_state = 214, .external_lex_state = 1},
  [404] = {.lex_state = 214, .external_lex_state = 1},
  [405] = {.lex_state = 214, .external_lex_state = 1},
  [406] = {.lex_state = 214, .external_lex_state = 1},
  [407] = {.lex_state = 214, .external_lex_state = 1},
  [408] = {.lex_state = 117, .external_lex_state = 1},
  [409] = {.lex_state = 214, .external_lex_state = 1},
  [410] = {.lex_state = 214, .external_lex_state = 1},
  [411] = {.lex_state = 214, .external_lex_state = 1},
  [412] = {.lex_state = 214, .external_lex_state = 1},
  [413] = {.lex_state = 214, .external_lex_state = 1},
  [414] = {.lex_state = 214, .external_lex_state = 1},
  [415] = {.lex_state = 214, .external_lex_state = 1},
  [416] = {.lex_state = 214, .external_lex_state = 1},
  [417] = {.lex_state = 214, .external_lex_state = 1},
  [418] = {.lex_state = 214, .external_lex_state = 1},
  [419] = {.lex_state = 214, .external_lex_state = 1},
  [420] = {.lex_state = 214, .external_lex_state = 1},
  [421] = {.lex_state = 214, .external_lex_state = 1},
  [422] = {.lex_state = 214, .external_lex_state = 1},
  [423] = {.lex_state = 214, .external_lex_state = 1},
  [424] = {.lex_state = 214, .external_lex_state = 1},
  [425] = {.lex_state = 214, .external_lex_state = 1},
  [426] = {.lex_state = 214, .external_lex_state = 1},
  [427] = {.lex_state = 214, .external_lex_state = 1},
  [428] = {.lex_state = 117, .external_lex_state = 1},
  [429] = {.lex_state = 214, .external_lex_state = 1},
  [430] = {.lex_state = 214, .external_lex_state = 1},
  [431] = {.lex_state = 214, .external_lex_state = 1},
  [432] = {.lex_state = 214, .external_lex_state = 1},
  [433] = {.lex_state = 214, .external_lex_state = 1},
  [434] = {.lex_state = 214, .external_lex_state = 1},
  [435] = {.lex_state = 214, .external_lex_state = 1},
  [436] = {.lex_state = 214, .external_lex_state = 1},
  [437] = {.lex_state = 214, .external_lex_state = 1},
  [438] = {.lex_state = 214, .external_lex_state = 1},
  [439] = {.lex_state = 214, .external_lex_state = 1},
  [440] = {.lex_state = 214, .external_lex_state = 1},
  [441] = {.lex_state = 214, .external_lex_state = 1},
  [442] = {.lex_state = 214, .external_lex_state = 1},
  [443] = {.lex_state = 214, .external_lex_state = 1},
  [444] = {.lex_state = 214, .external_lex_state = 1},
  [445] = {.lex_state = 214, .external_lex_state = 1},
  [446] = {.lex_state = 214, .external_lex_state = 1},
  [447] = {.lex_state = 214, .external_lex_state = 1},
  [448] = {.lex_state = 214, .external_lex_state = 1},
  [449] = {.lex_state = 214, .external_lex_state = 1},
  [450] = {.lex_state = 214, .external_lex_state = 1},
  [451] = {.lex_state = 214, .external_lex_state = 1},
  [452] = {.lex_state = 214, .external_lex_state = 1},
  [453] = {.lex_state = 214, .external_lex_state = 1},
  [454] = {.lex_state = 214, .external_lex_state = 1},
  [455] = {.lex_state = 214, .external_lex_state = 1},
  [456] = {.lex_state = 214, .external_lex_state = 1},
  [457] = {.lex_state = 214, .external_lex_state = 1},
  [458] = {.lex_state = 214, .external_lex_state = 1},
  [459] = {.lex_state = 214, .external_lex_state = 1},
  [460] = {.lex_state = 214, .external_lex_state = 1},
  [461] = {.lex_state = 214, .external_lex_state = 1},
  [462] = {.lex_state = 214, .external_lex_state = 1},
  [463] = {.lex_state = 214, .external_lex_state = 1},
  [464] = {.lex_state = 214, .external_lex_state = 1},
  [465] = {.lex_state = 214, .external_lex_state = 1},
  [466] = {.lex_state = 214, .external_lex_state = 1},
  [467] = {.lex_state = 214, .external_lex_state = 1},
  [468] = {.lex_state = 214, .external_lex_state = 1},
  [469] = {.lex_state = 214, .external_lex_state = 1},
  [470] = {.lex_state = 214, .external_lex_state = 1},
  [471] = {.lex_state = 214, .external_lex_state = 1},
  [472] = {.lex_state = 214, .external_lex_state = 1},
  [473] = {.lex_state = 214, .external_lex_state = 1},
  [474] = {.lex_state = 214, .external_lex_state = 1},
  [475] = {.lex_state = 214, .external_lex_state = 1},
  [476] = {.lex_state = 214, .external_lex_state = 1},
  [477] = {.lex_state = 214, .external_lex_state = 1},
  [478] = {.lex_state = 214, .external_lex_state = 1},
  [479] = {.lex_state = 214, .external_lex_state = 1},
  [480] = {.lex_state = 214, .external_lex_state = 1},
  [481] = {.lex_state = 214, .external_lex_state = 1},
  [482] = {.lex_state = 214, .external_lex_state = 1},
  [483] = {.lex_state = 214, .external_lex_state = 1},
  [484] = {.lex_state = 214, .external_lex_state = 1},
  [485] = {.lex_state = 214, .external_lex_state = 1},
  [486] = {.lex_state = 214, .external_lex_state = 1},
  [487] = {.lex_state = 214, .external_lex_state = 1},
  [488] = {.lex_state = 214, .external_lex_state = 1},
  [489] = {.lex_state = 214, .external_lex_state = 1},
  [490] = {.lex_state = 214, .external_lex_state = 1},
  [491] = {.lex_state = 214, .external_lex_state = 1},
  [492] = {.lex_state = 214, .external_lex_state = 1},
  [493] = {.lex_state = 214, .external_lex_state = 1},
  [494] = {.lex_state = 214, .external_lex_state = 1},
  [495] = {.lex_state = 214, .external_lex_state = 1},
  [496] = {.lex_state = 214, .external_lex_state = 1},
  [497] = {.lex_state = 214, .external_lex_state = 1},
  [498] = {.lex_state = 214, .external_lex_state = 1},
  [499] = {.lex_state = 214, .external_lex_state = 1},
  [500] = {.lex_state = 214, .external_lex_state = 1},
  [501] = {.lex_state = 214, .external_lex_state = 1},
  [502] = {.lex_state = 214, .external_lex_state = 1},
  [503] = {.lex_state = 214, .external_lex_state = 1},
  [504] = {.lex_state = 214, .external_lex_state = 1},
  [505] = {.lex_state = 214, .external_lex_state = 1},
  [506] = {.lex_state = 214, .external_lex_state = 1},
  [507] = {.lex_state = 214, .external_lex_state = 1},
  [508] = {.lex_state = 214, .external_lex_state = 1},
  [509] = {.lex_state = 214, .external_lex_state = 1},
  [510] = {.lex_state = 214, .external_lex_state = 1},
  [511] = {.lex_state = 214, .external_lex_state = 1},
  [512] = {.lex_state = 214, .external_lex_state = 1},
  [513] = {.lex_state = 214, .external_lex_state = 1},
  [514] = {.lex_state = 214, .external_lex_state = 1},
  [515] = {.lex_state = 214, .external_lex_state = 1},
  [516] = {.lex_state = 214, .external_lex_state = 1},
  [517] = {.lex_state = 214, .external_lex_state = 1},
  [518] = {.lex_state = 214, .external_lex_state = 1},
  [519] = {.lex_state = 214, .external_lex_state = 1},
  [520] = {.lex_state = 214, .external_lex_state = 1},
  [521] = {.lex_state = 214, .external_lex_state = 1},
  [522] = {.lex_state = 214, .external_lex_state = 1},
  [523] = {.lex_state = 214, .external_lex_state = 1},
  [524] = {.lex_state = 214, .external_lex_state = 1},
  [525] = {.lex_state = 117, .external_lex_state = 1},
  [526] = {.lex_state = 117, .external_lex_state = 1},
  [527] = {.lex_state = 214, .external_lex_state = 1},
  [528] = {.lex_state = 117, .external_lex_state = 1},
  [529] = {.lex_state = 117, .external_lex_state = 1},
  [530] = {.lex_state = 214, .external_lex_state = 1},
  [531] = {.lex_state = 117, .external_lex_state = 1},
  [532] = {.lex_state = 117, .external_lex_state = 1},
  [533] = {.lex_state = 214, .external_lex_state = 1},
  [534] = {.lex_state = 214, .external_lex_state = 1},
  [535] = {.lex_state = 214, .external_lex_state = 1},
  [536] = {.lex_state = 214, .external_lex_state = 1},
  [537] = {.lex_state = 214, .external_lex_state = 1},
  [538] = {.lex_state = 214, .external_lex_state = 1},
  [539] = {.lex_state = 214, .external_lex_state = 1},
  [540] = {.lex_state = 214, .external_lex_state = 1},
  [541] = {.lex_state = 214, .external_lex_state = 1},
  [542] = {.lex_state = 214, .external_lex_state = 1},
  [543] = {.lex_state = 214, .external_lex_state = 1},
  [544] = {.lex_state = 117, .external_lex_state = 1},
  [545] = {.lex_state = 214, .external_lex_state = 1},
  [546] = {.lex_state = 214, .external_lex_state = 1},
  [547] = {.lex_state = 117, .external_lex_state = 1},
  [548] = {.lex_state = 214, .external_lex_state = 1},
  [549] = {.lex_state = 214, .external_lex_state = 1},
  [550] = {.lex_state = 214, .external_lex_state = 1},
  [551] = {.lex_state = 117, .external_lex_state = 1},
  [552] = {.lex_state = 214, .external_lex_state = 1},
  [553] = {.lex_state = 214, .external_lex_state = 1},
  [554] = {.lex_state = 214, .external_lex_state = 1},
  [555] = {.lex_state = 214, .external_lex_state = 1},
  [556] = {.lex_state = 214, .external_lex_state = 1},
  [557] = {.lex_state = 214, .external_lex_state = 1},
  [558] = {.lex_state = 214, .external_lex_state = 1},
  [559] = {.lex_state = 214, .external_lex_state = 1},
  [560] = {.lex_state = 214, .external_lex_state = 1},
  [561] = {.lex_state = 214, .external_lex_state = 1},
  [562] = {.lex_state = 214, .external_lex_state = 1},
  [563] = {.lex_state = 214, .external_lex_state = 1},
  [564] = {.lex_state = 214, .external_lex_state = 1},
  [565] = {.lex_state = 214, .external_lex_state = 1},
  [566] = {.lex_state = 214, .external_lex_state = 1},
  [567] = {.lex_state = 214, .external_lex_state = 1},
  [568] = {.lex_state = 214, .external_lex_state = 1},
  [569] = {.lex_state = 214, .external_lex_state = 1},
  [570] = {.lex_state = 214, .external_lex_state = 1},
  [571] = {.lex_state = 214, .external_lex_state = 1},
  [572] = {.lex_state = 214, .external_lex_state = 1},
  [573] = {.lex_state = 214, .external_lex_state = 1},
  [574] = {.lex_state = 214, .external_lex_state = 1},
  [575] = {.lex_state = 214, .external_lex_state = 1},
  [576] = {.lex_state = 214, .external_lex_state = 1},
  [577] = {.lex_state = 117, .external_lex_state = 1},
  [578] = {.lex_state = 214, .external_lex_state = 1},
  [579] = {.lex_state = 214, .external_lex_state = 1},
  [580] = {.lex_state = 214, .external_lex_state = 1},
  [581] = {.lex_state = 214, .external_lex_state = 1},
  [582] = {.lex_state = 117, .external_lex_state = 1},
  [583] = {.lex_state = 117, .external_lex_state = 1},
  [584] = {.lex_state = 214, .external_lex_state = 1},
  [585] = {.lex_state = 117, .external_lex_state = 1},
  [586] = {.lex_state = 214, .external_lex_state = 1},
  [587] = {.lex_state = 214, .external_lex_state = 1},
  [588] = {.lex_state = 214, .external_lex_state = 1},
  [589] = {.lex_state = 214, .external_lex_state = 1},
  [590] = {.lex_state = 117, .external_lex_state = 1},
  [591] = {.lex_state = 117, .external_lex_state = 1},
  [592] = {.lex_state = 214, .external_lex_state = 1},
  [593] = {.lex_state = 117, .external_lex_state = 1},
  [594] = {.lex_state = 214, .external_lex_state = 1},
  [595] = {.lex_state = 117, .external_lex_state = 1},
  [596] = {.lex_state = 214, .external_lex_state = 1},
  [597] = {.lex_state = 214, .external_lex_state = 1},
  [598] = {.lex_state = 214, .external_lex_state = 1},
  [599] = {.lex_state = 214, .external_lex_state = 1},
  [600] = {.lex_state = 117, .external_lex_state = 1},
  [601] = {.lex_state = 214, .external_lex_state = 1},
  [602] = {.lex_state = 214, .external_lex_state = 1},
  [603] = {.lex_state = 117, .external_lex_state = 1},
  [604] = {.lex_state = 117, .external_lex_state = 1},
  [605] = {.lex_state = 117, .external_lex_state = 1},
  [606] = {.lex_state = 214, .external_lex_state = 1},
  [607] = {.lex_state = 214, .external_lex_state = 1},
  [608] = {.lex_state = 214, .external_lex_state = 1},
  [609] = {.lex_state = 117, .external_lex_state = 1},
  [610] = {.lex_state = 117, .external_lex_state = 1},
  [611] = {.lex_state = 117, .external_lex_state = 1},
  [612] = {.lex_state = 214, .external_lex_state = 1},
  [613] = {.lex_state = 214, .external_lex_state = 1},
  [614] = {.lex_state = 214, .external_lex_state = 1},
  [615] = {.lex_state = 214, .external_lex_state = 1},
  [616] = {.lex_state = 214, .external_lex_state = 1},
  [617] = {.lex_state = 214, .external_lex_state = 1},
  [618] = {.lex_state = 214, .external_lex_state = 1},
  [619] = {.lex_state = 214, .external_lex_state = 1},
  [620] = {.lex_state = 117, .external_lex_state = 1},
  [621] = {.lex_state = 214, .external_lex_state = 1},
  [622] = {.lex_state = 214, .external_lex_state = 1},
  [623] = {.lex_state = 214, .external_lex_state = 1},
  [624] = {.lex_state = 214, .external_lex_state = 1},
  [625] = {.lex_state = 214, .external_lex_state = 1},
  [626] = {.lex_state = 214, .external_lex_state = 1},
  [627] = {.lex_state = 214, .external_lex_state = 1},
  [628] = {.lex_state = 214, .external_lex_state = 1},
  [629] = {.lex_state = 214, .external_lex_state = 1},
  [630] = {.lex_state = 214, .external_lex_state = 1},
  [631] = {.lex_state = 214, .external_lex_state = 1},
  [632] = {.lex_state = 214, .external_lex_state = 1},
  [633] = {.lex_state = 214, .external_lex_state = 1},
  [634] = {.lex_state = 214, .external_lex_state = 1},
  [635] = {.lex_state = 214, .external_lex_state = 1},
  [636] = {.lex_state = 214, .external_lex_state = 1},
  [637] = {.lex_state = 214, .external_lex_state = 1},
  [638] = {.lex_state = 117, .external_lex_state = 1},
  [639] = {.lex_state = 214, .external_lex_state = 1},
  [640] = {.lex_state = 214, .external_lex_state = 1},
  [641] = {.lex_state = 214, .external_lex_state = 1},
  [642] = {.lex_state = 214, .external_lex_state = 1},
  [643] = {.lex_state = 117, .external_lex_state = 1},
  [644] = {.lex_state = 117, .external_lex_state = 1},
  [645] = {.lex_state = 214, .external_lex_state = 1},
  [646] = {.lex_state = 214, .external_lex_state = 1},
  [647] = {.lex_state = 117, .external_lex_state = 1},
  [648] = {.lex_state = 117, .external_lex_state = 1},
  [649] = {.lex_state = 117, .external_lex_state = 1},
  [650] = {.lex_state = 117, .external_lex_state = 1},
  [651] = {.lex_state = 117, .external_lex_state = 1},
  [652] = {.lex_state = 214, .external_lex_state = 1},
  [653] = {.lex_state = 117, .external_lex_state = 1},
  [654] = {.lex_state = 214, .external_lex_state = 1},
  [655] = {.lex_state = 117, .external_lex_state = 1},
  [656] = {.lex_state = 117, .external_lex_state = 1},
  [657] = {.lex_state = 117, .external_lex_state = 1},
  [658] = {.lex_state = 117, .external_lex_state = 1},
  [659] = {.lex_state = 117, .external_lex_state = 1},
  [660] = {.lex_state = 117, .external_lex_state = 1},
  [661] = {.lex_state = 214, .external_lex_state = 1},
  [662] = {.lex_state = 117, .external_lex_state = 1},
  [663] = {.lex_state = 214, .external_lex_state = 1},
  [664] = {.lex_state = 214, .external_lex_state = 1},
  [665] = {.lex_state = 214, .external_lex_state = 1},
  [666] = {.lex_state = 214, .external_lex_state = 1},
  [667] = {.lex_state = 117, .external_lex_state = 1},
  [668] = {.lex_state = 117, .external_lex_state = 1},
  [669] = {.lex_state = 214, .external_lex_state = 1},
  [670] = {.lex_state = 214, .external_lex_state = 1},
  [671] = {.lex_state = 117, .external_lex_state = 1},
  [672] = {.lex_state = 214, .external_lex_state = 1},
  [673] = {.lex_state = 214, .external_lex_state = 1},
  [674] = {.lex_state = 214, .external_lex_state = 1},
  [675] = {.lex_state = 214, .external_lex_state = 1},
  [676] = {.lex_state = 117, .external_lex_state = 1},
  [677] = {.lex_state = 214, .external_lex_state = 1},
  [678] = {.lex_state = 117, .external_lex_state = 1},
  [679] = {.lex_state = 117, .external_lex_state = 1},
  [680] = {.lex_state = 117, .external_lex_state = 1},
  [681] = {.lex_state = 214, .external_lex_state = 1},
  [682] = {.lex_state = 117, .external_lex_state = 1},
  [683] = {.lex_state = 117, .external_lex_state = 1},
  [684] = {.lex_state = 117, .external_lex_state = 1},
  [685] = {.lex_state = 117, .external_lex_state = 1},
  [686] = {.lex_state = 117, .external_lex_state = 1},
  [687] = {.lex_state = 117, .external_lex_state = 1},
  [688] = {.lex_state = 214, .external_lex_state = 1},
  [689] = {.lex_state = 214, .external_lex_state = 1},
  [690] = {.lex_state = 117, .external_lex_state = 1},
  [691] = {.lex_state = 117, .external_lex_state = 1},
  [692] = {.lex_state = 129},
  [693] = {.lex_state = 129},
  [694] = {.lex_state = 129},
  [695] = {.lex_state = 129},
  [696] = {.lex_state = 129},
  [697] = {.lex_state = 129},
  [698] = {.lex_state = 129},
  [699] = {.lex_state = 107, .external_lex_state = 1},
  [700] = {.lex_state = 119, .external_lex_state = 1},
  [701] = {.lex_state = 119, .external_lex_state = 1},
  [702] = {.lex_state = 119, .external_lex_state = 1},
  [703] = {.lex_state = 119, .external_lex_state = 1},
  [704] = {.lex_state = 119, .external_lex_state = 1},
  [705] = {.lex_state = 119, .external_lex_state = 1},
  [706] = {.lex_state = 119, .external_lex_state = 1},
  [707] = {.lex_state = 119, .external_lex_state = 1},
  [708] = {.lex_state = 119, .external_lex_state = 1},
  [709] = {.lex_state = 119, .external_lex_state = 1},
  [710] = {.lex_state = 119, .external_lex_state = 1},
  [711] = {.lex_state = 119, .external_lex_state = 1},
  [712] = {.lex_state = 119, .external_lex_state = 1},
  [713] = {.lex_state = 119, .external_lex_state = 1},
  [714] = {.lex_state = 119, .external_lex_state = 1},
  [715] = {.lex_state = 119, .external_lex_state = 1},
  [716] = {.lex_state = 119, .external_lex_state = 1},
  [717] = {.lex_state = 119, .external_lex_state = 1},
  [718] = {.lex_state = 119, .external_lex_state = 1},
  [719] = {.lex_state = 119, .external_lex_state = 1},
  [720] = {.lex_state = 119, .external_lex_state = 1},
  [721] = {.lex_state = 119, .external_lex_state = 1},
  [722] = {.lex_state = 119, .external_lex_state = 1},
  [723] = {.lex_state = 119, .external_lex_state = 1},
  [724] = {.lex_state = 119, .external_lex_state = 1},
  [725] = {.lex_state = 119, .external_lex_state = 1},
  [726] = {.lex_state = 119, .external_lex_state = 1},
  [727] = {.lex_state = 119, .external_lex_state = 1},
  [728] = {.lex_state = 119, .external_lex_state = 1},
  [729] = {.lex_state = 119, .external_lex_state = 1},
  [730] = {.lex_state = 119, .external_lex_state = 1},
  [731] = {.lex_state = 119, .external_lex_state = 1},
  [732] = {.lex_state = 119, .external_lex_state = 1},
  [733] = {.lex_state = 119, .external_lex_state = 1},
  [734] = {.lex_state = 109, .external_lex_state = 1},
  [735] = {.lex_state = 108, .external_lex_state = 1},
  [736] = {.lex_state = 110, .external_lex_state = 1},
  [737] = {.lex_state = 118, .external_lex_state = 1},
  [738] = {.lex_state = 107, .external_lex_state = 1},
  [739] = {.lex_state = 119, .external_lex_state = 1},
  [740] = {.lex_state = 119, .external_lex_state = 1},
  [741] = {.lex_state = 119, .external_lex_state = 1},
  [742] = {.lex_state = 119, .external_lex_state = 1},
  [743] = {.lex_state = 119, .external_lex_state = 1},
  [744] = {.lex_state = 119, .external_lex_state = 1},
  [745] = {.lex_state = 119, .external_lex_state = 1},
  [746] = {.lex_state = 119, .external_lex_state = 1},
  [747] = {.lex_state = 119, .external_lex_state = 1},
  [748] = {.lex_state = 119, .external_lex_state = 1},
  [749] = {.lex_state = 119, .external_lex_state = 1},
  [750] = {.lex_state = 119, .external_lex_state = 1},
  [751] = {.lex_state = 119, .external_lex_state = 1},
  [752] = {.lex_state = 119, .external_lex_state = 1},
  [753] = {.lex_state = 119, .external_lex_state = 1},
  [754] = {.lex_state = 119, .external_lex_state = 1},
  [755] = {.lex_state = 119, .external_lex_state = 1},
  [756] = {.lex_state = 119, .external_lex_state = 1},
  [757] = {.lex_state = 119, .external_lex_state = 1},
  [758] = {.lex_state = 119, .external_lex_state = 1},
  [759] = {.lex_state = 119, .external_lex_state = 1},
  [760] = {.lex_state = 119, .external_lex_state = 1},
  [761] = {.lex_state = 119, .external_lex_state = 1},
  [762] = {.lex_state = 119, .external_lex_state = 1},
  [763] = {.lex_state = 119, .external_lex_state = 1},
  [764] = {.lex_state = 119, .external_lex_state = 1},
  [765] = {.lex_state = 119, .external_lex_state = 1},
  [766] = {.lex_state = 119, .external_lex_state = 1},
  [767] = {.lex_state = 119, .external_lex_state = 1},
  [768] = {.lex_state = 119, .external_lex_state = 1},
  [769] = {.lex_state = 119, .external_lex_state = 1},
  [770] = {.lex_state = 119, .external_lex_state = 1},
  [771] = {.lex_state = 119, .external_lex_state = 1},
  [772] = {.lex_state = 119, .external_lex_state = 1},
  [773] = {.lex_state = 119, .external_lex_state = 1},
  [774] = {.lex_state = 119, .external_lex_state = 1},
  [775] = {.lex_state = 119, .external_lex_state = 1},
  [776] = {.lex_state = 119, .external_lex_state = 1},
  [777] = {.lex_state = 119, .external_lex_state = 1},
  [778] = {.lex_state = 119, .external_lex_state = 1},
  [779] = {.lex_state = 119, .external_lex_state = 1},
  [780] = {.lex_state = 119, .external_lex_state = 1},
  [781] = {.lex_state = 119, .external_lex_state = 1},
  [782] = {.lex_state = 119, .external_lex_state = 1},
  [783] = {.lex_state = 119, .external_lex_state = 1},
  [784] = {.lex_state = 119, .external_lex_state = 1},
  [785] = {.lex_state = 119, .external_lex_state = 1},
  [786] = {.lex_state = 119, .external_lex_state = 1},
  [787] = {.lex_state = 119, .external_lex_state = 1},
  [788] = {.lex_state = 119, .external_lex_state = 1},
  [789] = {.lex_state = 119, .external_lex_state = 1},
  [790] = {.lex_state = 119, .external_lex_state = 1},
  [791] = {.lex_state = 119, .external_lex_state = 1},
  [792] = {.lex_state = 119, .external_lex_state = 1},
  [793] = {.lex_state = 119, .external_lex_state = 1},
  [794] = {.lex_state = 119, .external_lex_state = 1},
  [795] = {.lex_state = 119, .external_lex_state = 1},
  [796] = {.lex_state = 119, .external_lex_state = 1},
  [797] = {.lex_state = 119, .external_lex_state = 1},
  [798] = {.lex_state = 119, .external_lex_state = 1},
  [799] = {.lex_state = 119, .external_lex_state = 1},
  [800] = {.lex_state = 119, .external_lex_state = 1},
  [801] = {.lex_state = 119, .external_lex_state = 1},
  [802] = {.lex_state = 119, .external_lex_state = 1},
  [803] = {.lex_state = 119, .external_lex_state = 1},
  [804] = {.lex_state = 119, .external_lex_state = 1},
  [805] = {.lex_state = 119, .external_lex_state = 1},
  [806] = {.lex_state = 119, .external_lex_state = 1},
  [807] = {.lex_state = 119, .external_lex_state = 1},
  [808] = {.lex_state = 119, .external_lex_state = 1},
  [809] = {.lex_state = 119, .external_lex_state = 1},
  [810] = {.lex_state = 119, .external_lex_state = 1},
  [811] = {.lex_state = 119, .external_lex_state = 1},
  [812] = {.lex_state = 119, .external_lex_state = 1},
  [813] = {.lex_state = 119, .external_lex_state = 1},
  [814] = {.lex_state = 119, .external_lex_state = 1},
  [815] = {.lex_state = 119, .external_lex_state = 1},
  [816] = {.lex_state = 119, .external_lex_state = 1},
  [817] = {.lex_state = 119, .external_lex_state = 1},
  [818] = {.lex_state = 119, .external_lex_state = 1},
  [819] = {.lex_state = 119, .external_lex_state = 1},
  [820] = {.lex_state = 119, .external_lex_state = 1},
  [821] = {.lex_state = 119, .external_lex_state = 1},
  [822] = {.lex_state = 119, .external_lex_state = 1},
  [823] = {.lex_state = 119, .external_lex_state = 1},
  [824] = {.lex_state = 119, .external_lex_state = 1},
  [825] = {.lex_state = 119, .external_lex_state = 1},
  [826] = {.lex_state = 119, .external_lex_state = 1},
  [827] = {.lex_state = 119, .external_lex_state = 1},
  [828] = {.lex_state = 119, .external_lex_state = 1},
  [829] = {.lex_state = 119, .external_lex_state = 1},
  [830] = {.lex_state = 119, .external_lex_state = 1},
  [831] = {.lex_state = 119, .external_lex_state = 1},
  [832] = {.lex_state = 119, .external_lex_state = 1},
  [833] = {.lex_state = 119, .external_lex_state = 1},
  [834] = {.lex_state = 119, .external_lex_state = 1},
  [835] = {.lex_state = 119, .external_lex_state = 1},
  [836] = {.lex_state = 119, .external_lex_state = 1},
  [837] = {.lex_state = 119, .external_lex_state = 1},
  [838] = {.lex_state = 119, .external_lex_state = 1},
  [839] = {.lex_state = 119, .external_lex_state = 1},
  [840] = {.lex_state = 119, .external_lex_state = 1},
  [841] = {.lex_state = 119, .external_lex_state = 1},
  [842] = {.lex_state = 119, .external_lex_state = 1},
  [843] = {.lex_state = 119, .external_lex_state = 1},
  [844] = {.lex_state = 119, .external_lex_state = 1},
  [845] = {.lex_state = 119, .external_lex_state = 1},
  [846] = {.lex_state = 119, .external_lex_state = 1},
  [847] = {.lex_state = 119, .external_lex_state = 1},
  [848] = {.lex_state = 119, .external_lex_state = 1},
  [849] = {.lex_state = 119, .external_lex_state = 1},
  [850] = {.lex_state = 119, .external_lex_state = 1},
  [851] = {.lex_state = 119, .external_lex_state = 1},
  [852] = {.lex_state = 119, .external_lex_state = 1},
  [853] = {.lex_state = 119, .external_lex_state = 1},
  [854] = {.lex_state = 119, .external_lex_state = 1},
  [855] = {.lex_state = 119, .external_lex_state = 1},
  [856] = {.lex_state = 119, .external_lex_state = 1},
  [857] = {.lex_state = 119, .external_lex_state = 1},
  [858] = {.lex_state = 119, .external_lex_state = 1},
  [859] = {.lex_state = 119, .external_lex_state = 1},
  [860] = {.lex_state = 119, .external_lex_state = 1},
  [861] = {.lex_state = 119, .external_lex_state = 1},
  [862] = {.lex_state = 119, .external_lex_state = 1},
  [863] = {.lex_state = 119, .external_lex_state = 1},
  [864] = {.lex_state = 119, .external_lex_state = 1},
  [865] = {.lex_state = 111, .external_lex_state = 1},
  [866] = {.lex_state = 114, .external_lex_state = 1},
  [867] = {.lex_state = 111, .external_lex_state = 1},
  [868] = {.lex_state = 113, .external_lex_state = 1},
  [869] = {.lex_state = 112, .external_lex_state = 1},
  [870] = {.lex_state = 129},
  [871] = {.lex_state = 111, .external_lex_state = 1},
  [872] = {.lex_state = 116, .external_lex_state = 1},
  [873] = {.lex_state = 116, .external_lex_state = 1},
  [874] = {.lex_state = 116, .external_lex_state = 1},
  [875] = {.lex_state = 116, .external_lex_state = 1},
  [876] = {.lex_state = 116, .external_lex_state = 1},
  [877] = {.lex_state = 116, .external_lex_state = 1},
  [878] = {.lex_state = 116, .external_lex_state = 1},
  [879] = {.lex_state = 116, .external_lex_state = 1},
  [880] = {.lex_state = 116, .external_lex_state = 1},
  [881] = {.lex_state = 116, .external_lex_state = 1},
  [882] = {.lex_state = 116, .external_lex_state = 1},
  [883] = {.lex_state = 116, .external_lex_state = 1},
  [884] = {.lex_state = 116, .external_lex_state = 1},
  [885] = {.lex_state = 116, .external_lex_state = 1},
  [886] = {.lex_state = 116, .external_lex_state = 1},
  [887] = {.lex_state = 116, .external_lex_state = 1},
  [888] = {.lex_state = 116, .external_lex_state = 1},
  [889] = {.lex_state = 116, .external_lex_state = 1},
  [890] = {.lex_state = 116, .external_lex_state = 1},
  [891] = {.lex_state = 116, .external_lex_state = 1},
  [892] = {.lex_state = 116, .external_lex_state = 1},
  [893] = {.lex_state = 116, .external_lex_state = 1},
  [894] = {.lex_state = 116, .external_lex_state = 1},
  [895] = {.lex_state = 116, .external_lex_state = 1},
  [896] = {.lex_state = 116, .external_lex_state = 1},
  [897] = {.lex_state = 116, .external_lex_state = 1},
  [898] = {.lex_state = 116, .external_lex_state = 1},
  [899] = {.lex_state = 116, .external_lex_state = 1},
  [900] = {.lex_state = 116, .external_lex_state = 1},
  [901] = {.lex_state = 116, .external_lex_state = 1},
  [902] = {.lex_state = 116, .external_lex_state = 1},
  [903] = {.lex_state = 116, .external_lex_state = 1},
  [904] = {.lex_state = 116, .external_lex_state = 1},
  [905] = {.lex_state = 116, .external_lex_state = 1},
  [906] = {.lex_state = 116, .external_lex_state = 1},
  [907] = {.lex_state = 116, .external_lex_state = 1},
  [908] = {.lex_state = 116, .external_lex_state = 1},
  [909] = {.lex_state = 116, .external_lex_state = 1},
  [910] = {.lex_state = 116, .external_lex_state = 1},
  [911] = {.lex_state = 116, .external_lex_state = 1},
  [912] = {.lex_state = 116, .external_lex_state = 1},
  [913] = {.lex_state = 116, .external_lex_state = 1},
  [914] = {.lex_state = 116, .external_lex_state = 1},
  [915] = {.lex_state = 116, .external_lex_state = 1},
  [916] = {.lex_state = 116, .external_lex_state = 1},
  [917] = {.lex_state = 116, .external_lex_state = 1},
  [918] = {.lex_state = 116, .external_lex_state = 1},
  [919] = {.lex_state = 116, .external_lex_state = 1},
  [920] = {.lex_state = 116, .external_lex_state = 1},
  [921] = {.lex_state = 116, .external_lex_state = 1},
  [922] = {.lex_state = 116, .external_lex_state = 1},
  [923] = {.lex_state = 116, .external_lex_state = 1},
  [924] = {.lex_state = 116, .external_lex_state = 1},
  [925] = {.lex_state = 116, .external_lex_state = 1},
  [926] = {.lex_state = 116, .external_lex_state = 1},
  [927] = {.lex_state = 116, .external_lex_state = 1},
  [928] = {.lex_state = 116, .external_lex_state = 1},
  [929] = {.lex_state = 116, .external_lex_state = 1},
  [930] = {.lex_state = 116, .external_lex_state = 1},
  [931] = {.lex_state = 116, .external_lex_state = 1},
  [932] = {.lex_state = 116, .external_lex_state = 1},
  [933] = {.lex_state = 116, .external_lex_state = 1},
  [934] = {.lex_state = 116, .external_lex_state = 1},
  [935] = {.lex_state = 116, .external_lex_state = 1},
  [936] = {.lex_state = 116, .external_lex_state = 1},
  [937] = {.lex_state = 116, .external_lex_state = 1},
  [938] = {.lex_state = 116, .external_lex_state = 1},
  [939] = {.lex_state = 116, .external_lex_state = 1},
  [940] = {.lex_state = 116, .external_lex_state = 1},
  [941] = {.lex_state = 116, .external_lex_state = 1},
  [942] = {.lex_state = 116, .external_lex_state = 1},
  [943] = {.lex_state = 116, .external_lex_state = 1},
  [944] = {.lex_state = 116, .external_lex_state = 1},
  [945] = {.lex_state = 116, .external_lex_state = 1},
  [946] = {.lex_state = 116, .external_lex_state = 1},
  [947] = {.lex_state = 116, .external_lex_state = 1},
  [948] = {.lex_state = 116, .external_lex_state = 1},
  [949] = {.lex_state = 116, .external_lex_state = 1},
  [950] = {.lex_state = 119, .external_lex_state = 1},
  [951] = {.lex_state = 119, .external_lex_state = 1},
  [952] = {.lex_state = 119, .external_lex_state = 1},
  [953] = {.lex_state = 119, .external_lex_state = 1},
  [954] = {.lex_state = 119, .external_lex_state = 1},
  [955] = {.lex_state = 119, .external_lex_state = 1},
  [956] = {.lex_state = 119, .external_lex_state = 1},
  [957] = {.lex_state = 119, .external_lex_state = 1},
  [958] = {.lex_state = 119, .external_lex_state = 1},
  [959] = {.lex_state = 119, .external_lex_state = 1},
  [960] = {.lex_state = 119, .external_lex_state = 1},
  [961] = {.lex_state = 118, .external_lex_state = 1},
  [962] = {.lex_state = 157},
  [963] = {.lex_state = 157},
  [964] = {.lex_state = 157},
  [965] = {.lex_state = 157},
  [966] = {.lex_state = 119, .external_lex_state = 1},
  [967] = {.lex_state = 160},
  [968] = {.lex_state = 119, .external_lex_state = 1},
  [969] = {.lex_state = 119, .external_lex_state = 1},
  [970] = {.lex_state = 119, .external_lex_state = 1},
  [971] = {.lex_state = 119, .external_lex_state = 1},
  [972] = {.lex_state = 119, .external_lex_state = 1},
  [973] = {.lex_state = 119, .external_lex_state = 1},
  [974] = {.lex_state = 119, .external_lex_state = 1},
  [975] = {.lex_state = 119, .external_lex_state = 1},
  [976] = {.lex_state = 119, .external_lex_state = 1},
  [977] = {.lex_state = 119, .external_lex_state = 1},
  [978] = {.lex_state = 119, .external_lex_state = 1},
  [979] = {.lex_state = 119, .external_lex_state = 1},
  [980] = {.lex_state = 119, .external_lex_state = 1},
  [981] = {.lex_state = 119, .external_lex_state = 1},
  [982] = {.lex_state = 119, .external_lex_state = 1},
  [983] = {.lex_state = 119, .external_lex_state = 1},
  [984] = {.lex_state = 119, .external_lex_state = 1},
  [985] = {.lex_state = 119, .external_lex_state = 1},
  [986] = {.lex_state = 119, .external_lex_state = 1},
  [987] = {.lex_state = 119, .external_lex_state = 1},
  [988] = {.lex_state = 119, .external_lex_state = 1},
  [989] = {.lex_state = 119, .external_lex_state = 1},
  [990] = {.lex_state = 119, .external_lex_state = 1},
  [991] = {.lex_state = 119, .external_lex_state = 1},
  [992] = {.lex_state = 131},
  [993] = {.lex_state = 160},
  [994] = {.lex_state = 160},
  [995] = {.lex_state = 160},
  [996] = {.lex_state = 160},
  [997] = {.lex_state = 119, .external_lex_state = 1},
  [998] = {.lex_state = 131},
  [999] = {.lex_state = 160},
  [1000] = {.lex_state = 131},
  [1001] = {.lex_state = 131},
  [1002] = {.lex_state = 131},
  [1003] = {.lex_state = 131},
  [1004] = {.lex_state = 160},
  [1005] = {.lex_state = 131},
  [1006] = {.lex_state = 131},
  [1007] = {.lex_state = 131},
  [1008] = {.lex_state = 160},
  [1009] = {.lex_state = 131},
  [1010] = {.lex_state = 131},
  [1011] = {.lex_state = 131},
  [1012] = {.lex_state = 131},
  [1013] = {.lex_state = 131},
  [1014] = {.lex_state = 131},
  [1015] = {.lex_state = 119, .external_lex_state = 1},
  [1016] = {.lex_state = 131},
  [1017] = {.lex_state = 119, .external_lex_state = 1},
  [1018] = {.lex_state = 119, .external_lex_state = 1},
  [1019] = {.lex_state = 131},
  [1020] = {.lex_state = 131},
  [1021] = {.lex_state = 119, .external_lex_state = 1},
  [1022] = {.lex_state = 119, .external_lex_state = 1},
  [1023] = {.lex_state = 144},
  [1024] = {.lex_state = 119, .external_lex_state = 1},
  [1025] = {.lex_state = 119, .external_lex_state = 1},
  [1026] = {.lex_state = 119, .external_lex_state = 1},
  [1027] = {.lex_state = 160},
  [1028] = {.lex_state = 160},
  [1029] = {.lex_state = 119, .external_lex_state = 1},
  [1030] = {.lex_state = 119, .external_lex_state = 1},
  [1031] = {.lex_state = 119, .external_lex_state = 1},
  [1032] = {.lex_state = 119, .external_lex_state = 1},
  [1033] = {.lex_state = 119, .external_lex_state = 1},
  [1034] = {.lex_state = 119, .external_lex_state = 1},
  [1035] = {.lex_state = 119, .external_lex_state = 1},
  [1036] = {.lex_state = 131},
  [1037] = {.lex_state = 131},
  [1038] = {.lex_state = 131},
  [1039] = {.lex_state = 119, .external_lex_state = 1},
  [1040] = {.lex_state = 119, .external_lex_state = 1},
  [1041] = {.lex_state = 160},
  [1042] = {.lex_state = 160},
  [1043] = {.lex_state = 119, .external_lex_state = 1},
  [1044] = {.lex_state = 119, .external_lex_state = 1},
  [1045] = {.lex_state = 119, .external_lex_state = 1},
  [1046] = {.lex_state = 119, .external_lex_state = 1},
  [1047] = {.lex_state = 119, .external_lex_state = 1},
  [1048] = {.lex_state = 119, .external_lex_state = 1},
  [1049] = {.lex_state = 119, .external_lex_state = 1},
  [1050] = {.lex_state = 119, .external_lex_state = 1},
  [1051] = {.lex_state = 119, .external_lex_state = 1},
  [1052] = {.lex_state = 119, .external_lex_state = 1},
  [1053] = {.lex_state = 160},
  [1054] = {.lex_state = 119, .external_lex_state = 1},
  [1055] = {.lex_state = 119, .external_lex_state = 1},
  [1056] = {.lex_state = 119, .external_lex_state = 1},
  [1057] = {.lex_state = 119, .external_lex_state = 1},
  [1058] = {.lex_state = 119, .external_lex_state = 1},
  [1059] = {.lex_state = 119, .external_lex_state = 1},
  [1060] = {.lex_state = 119, .external_lex_state = 1},
  [1061] = {.lex_state = 119, .external_lex_state = 1},
  [1062] = {.lex_state = 119, .external_lex_state = 1},
  [1063] = {.lex_state = 119, .external_lex_state = 1},
  [1064] = {.lex_state = 119, .external_lex_state = 1},
  [1065] = {.lex_state = 119, .external_lex_state = 1},
  [1066] = {.lex_state = 160},
  [1067] = {.lex_state = 119, .external_lex_state = 1},
  [1068] = {.lex_state = 160},
  [1069] = {.lex_state = 119, .external_lex_state = 1},
  [1070] = {.lex_state = 119, .external_lex_state = 1},
  [1071] = {.lex_state = 119, .external_lex_state = 1},
  [1072] = {.lex_state = 119, .external_lex_state = 1},
  [1073] = {.lex_state = 119, .external_lex_state = 1},
  [1074] = {.lex_state = 119, .external_lex_state = 1},
  [1075] = {.lex_state = 119, .external_lex_state = 1},
  [1076] = {.lex_state = 119, .external_lex_state = 1},
  [1077] = {.lex_state = 119, .external_lex_state = 1},
  [1078] = {.lex_state = 119, .external_lex_state = 1},
  [1079] = {.lex_state = 119, .external_lex_state = 1},
  [1080] = {.lex_state = 119, .external_lex_state = 1},
  [1081] = {.lex_state = 111, .external_lex_state = 1},
  [1082] = {.lex_state = 119, .external_lex_state = 1},
  [1083] = {.lex_state = 119, .external_lex_state = 1},
  [1084] = {.lex_state = 119, .external_lex_state = 1},
  [1085] = {.lex_state = 119, .external_lex_state = 1},
  [1086] = {.lex_state = 119, .external_lex_state = 1},
  [1087] = {.lex_state = 119, .external_lex_state = 1},
  [1088] = {.lex_state = 119, .external_lex_state = 1},
  [1089] = {.lex_state = 119, .external_lex_state = 1},
  [1090] = {.lex_state = 119, .external_lex_state = 1},
  [1091] = {.lex_state = 119, .external_lex_state = 1},
  [1092] = {.lex_state = 119, .external_lex_state = 1},
  [1093] = {.lex_state = 119, .external_lex_state = 1},
  [1094] = {.lex_state = 111, .external_lex_state = 1},
  [1095] = {.lex_state = 119, .external_lex_state = 1},
  [1096] = {.lex_state = 119, .external_lex_state = 1},
  [1097] = {.lex_state = 119, .external_lex_state = 1},
  [1098] = {.lex_state = 119, .external_lex_state = 1},
  [1099] = {.lex_state = 119, .external_lex_state = 1},
  [1100] = {.lex_state = 111, .external_lex_state = 1},
  [1101] = {.lex_state = 119, .external_lex_state = 1},
  [1102] = {.lex_state = 119, .external_lex_state = 1},
  [1103] = {.lex_state = 119, .external_lex_state = 1},
  [1104] = {.lex_state = 111, .external_lex_state = 1},
  [1105] = {.lex_state = 119, .external_lex_state = 1},
  [1106] = {.lex_state = 119, .external_lex_state = 1},
  [1107] = {.lex_state = 119, .external_lex_state = 1},
  [1108] = {.lex_state = 119, .external_lex_state = 1},
  [1109] = {.lex_state = 119, .external_lex_state = 1},
  [1110] = {.lex_state = 119, .external_lex_state = 1},
  [1111] = {.lex_state = 119, .external_lex_state = 1},
  [1112] = {.lex_state = 119, .external_lex_state = 1},
  [1113] = {.lex_state = 119, .external_lex_state = 1},
  [1114] = {.lex_state = 144},
  [1115] = {.lex_state = 119, .external_lex_state = 1},
  [1116] = {.lex_state = 119, .external_lex_state = 1},
  [1117] = {.lex_state = 119, .external_lex_state = 1},
  [1118] = {.lex_state = 111, .external_lex_state = 1},
  [1119] = {.lex_state = 119, .external_lex_state = 1},
  [1120] = {.lex_state = 119, .external_lex_state = 1},
  [1121] = {.lex_state = 119, .external_lex_state = 1},
  [1122] = {.lex_state = 111, .external_lex_state = 1},
  [1123] = {.lex_state = 111, .external_lex_state = 1},
  [1124] = {.lex_state = 111, .external_lex_state = 1},
  [1125] = {.lex_state = 119, .external_lex_state = 1},
  [1126] = {.lex_state = 119, .external_lex_state = 1},
  [1127] = {.lex_state = 119, .external_lex_state = 1},
  [1128] = {.lex_state = 119, .external_lex_state = 1},
  [1129] = {.lex_state = 119, .external_lex_state = 1},
  [1130] = {.lex_state = 119, .external_lex_state = 1},
  [1131] = {.lex_state = 111, .external_lex_state = 1},
  [1132] = {.lex_state = 111, .external_lex_state = 1},
  [1133] = {.lex_state = 119, .external_lex_state = 1},
  [1134] = {.lex_state = 119, .external_lex_state = 1},
  [1135] = {.lex_state = 119, .external_lex_state = 1},
  [1136] = {.lex_state = 119, .external_lex_state = 1},
  [1137] = {.lex_state = 119, .external_lex_state = 1},
  [1138] = {.lex_state = 119, .external_lex_state = 1},
  [1139] = {.lex_state = 119, .external_lex_state = 1},
  [1140] = {.lex_state = 119, .external_lex_state = 1},
  [1141] = {.lex_state = 119, .external_lex_state = 1},
  [1142] = {.lex_state = 119, .external_lex_state = 1},
  [1143] = {.lex_state = 119, .external_lex_state = 1},
  [1144] = {.lex_state = 119, .external_lex_state = 1},
  [1145] = {.lex_state = 119, .external_lex_state = 1},
  [1146] = {.lex_state = 119, .external_lex_state = 1},
  [1147] = {.lex_state = 119, .external_lex_state = 1},
  [1148] = {.lex_state = 119, .external_lex_state = 1},
  [1149] = {.lex_state = 111, .external_lex_state = 1},
  [1150] = {.lex_state = 119, .external_lex_state = 1},
  [1151] = {.lex_state = 111, .external_lex_state = 1},
  [1152] = {.lex_state = 119, .external_lex_state = 1},
  [1153] = {.lex_state = 111, .external_lex_state = 1},
  [1154] = {.lex_state = 111, .external_lex_state = 1},
  [1155] = {.lex_state = 111, .external_lex_state = 1},
  [1156] = {.lex_state = 111, .external_lex_state = 1},
  [1157] = {.lex_state = 119, .external_lex_state = 1},
  [1158] = {.lex_state = 119, .external_lex_state = 1},
  [1159] = {.lex_state = 119, .external_lex_state = 1},
  [1160] = {.lex_state = 119, .external_lex_state = 1},
  [1161] = {.lex_state = 119, .external_lex_state = 1},
  [1162] = {.lex_state = 119, .external_lex_state = 1},
  [1163] = {.lex_state = 119, .external_lex_state = 1},
  [1164] = {.lex_state = 119, .external_lex_state = 1},
  [1165] = {.lex_state = 119, .external_lex_state = 1},
  [1166] = {.lex_state = 111, .external_lex_state = 1},
  [1167] = {.lex_state = 119, .external_lex_state = 1},
  [1168] = {.lex_state = 119, .external_lex_state = 1},
  [1169] = {.lex_state = 119, .external_lex_state = 1},
  [1170] = {.lex_state = 119, .external_lex_state = 1},
  [1171] = {.lex_state = 119, .external_lex_state = 1},
  [1172] = {.lex_state = 119, .external_lex_state = 1},
  [1173] = {.lex_state = 119, .external_lex_state = 1},
  [1174] = {.lex_state = 119, .external_lex_state = 1},
  [1175] = {.lex_state = 111, .external_lex_state = 1},
  [1176] = {.lex_state = 111, .external_lex_state = 1},
  [1177] = {.lex_state = 119, .external_lex_state = 1},
  [1178] = {.lex_state = 119, .external_lex_state = 1},
  [1179] = {.lex_state = 111, .external_lex_state = 1},
  [1180] = {.lex_state = 111, .external_lex_state = 1},
  [1181] = {.lex_state = 111, .external_lex_state = 1},
  [1182] = {.lex_state = 119, .external_lex_state = 1},
  [1183] = {.lex_state = 119, .external_lex_state = 1},
  [1184] = {.lex_state = 119, .external_lex_state = 1},
  [1185] = {.lex_state = 119, .external_lex_state = 1},
  [1186] = {.lex_state = 141},
  [1187] = {.lex_state = 119, .external_lex_state = 1},
  [1188] = {.lex_state = 119, .external_lex_state = 1},
  [1189] = {.lex_state = 141},
  [1190] = {.lex_state = 141},
  [1191] = {.lex_state = 141},
  [1192] = {.lex_state = 141},
  [1193] = {.lex_state = 129},
  [1194] = {.lex_state = 119, .external_lex_state = 1},
  [1195] = {.lex_state = 119, .external_lex_state = 1},
  [1196] = {.lex_state = 119, .external_lex_state = 1},
  [1197] = {.lex_state = 119, .external_lex_state = 1},
  [1198] = {.lex_state = 119, .external_lex_state = 1},
  [1199] = {.lex_state = 141},
  [1200] = {.lex_state = 119, .external_lex_state = 1},
  [1201] = {.lex_state = 141},
  [1202] = {.lex_state = 119, .external_lex_state = 1},
  [1203] = {.lex_state = 119, .external_lex_state = 1},
  [1204] = {.lex_state = 141},
  [1205] = {.lex_state = 141},
  [1206] = {.lex_state = 141},
  [1207] = {.lex_state = 119, .external_lex_state = 1},
  [1208] = {.lex_state = 119, .external_lex_state = 1},
  [1209] = {.lex_state = 141},
  [1210] = {.lex_state = 141},
  [1211] = {.lex_state = 119, .external_lex_state = 1},
  [1212] = {.lex_state = 119, .external_lex_state = 1},
  [1213] = {.lex_state = 119, .external_lex_state = 1},
  [1214] = {.lex_state = 141},
  [1215] = {.lex_state = 119, .external_lex_state = 1},
  [1216] = {.lex_state = 119, .external_lex_state = 1},
  [1217] = {.lex_state = 141},
  [1218] = {.lex_state = 141},
  [1219] = {.lex_state = 141},
  [1220] = {.lex_state = 141},
  [1221] = {.lex_state = 141},
  [1222] = {.lex_state = 141},
  [1223] = {.lex_state = 119, .external_lex_state = 1},
  [1224] = {.lex_state = 119, .external_lex_state = 1},
  [1225] = {.lex_state = 119, .external_lex_state = 1},
  [1226] = {.lex_state = 141},
  [1227] = {.lex_state = 141},
  [1228] = {.lex_state = 119, .external_lex_state = 1},
  [1229] = {.lex_state = 119, .external_lex_state = 1},
  [1230] = {.lex_state = 119, .external_lex_state = 1},
  [1231] = {.lex_state = 119, .external_lex_state = 1},
  [1232] = {.lex_state = 141},
  [1233] = {.lex_state = 141},
  [1234] = {.lex_state = 160},
  [1235] = {.lex_state = 119, .external_lex_state = 1},
  [1236] = {.lex_state = 141},
  [1237] = {.lex_state = 141},
  [1238] = {.lex_state = 119, .external_lex_state = 1},
  [1239] = {.lex_state = 119, .external_lex_state = 1},
  [1240] = {.lex_state = 119, .external_lex_state = 1},
  [1241] = {.lex_state = 141},
  [1242] = {.lex_state = 119, .external_lex_state = 1},
  [1243] = {.lex_state = 141},
  [1244] = {.lex_state = 141},
  [1245] = {.lex_state = 141},
  [1246] = {.lex_state = 141},
  [1247] = {.lex_state = 141},
  [1248] = {.lex_state = 141},
  [1249] = {.lex_state = 119, .external_lex_state = 1},
  [1250] = {.lex_state = 119, .external_lex_state = 1},
  [1251] = {.lex_state = 119, .external_lex_state = 1},
  [1252] = {.lex_state = 141},
  [1253] = {.lex_state = 119, .external_lex_state = 1},
  [1254] = {.lex_state = 119, .external_lex_state = 1},
  [1255] = {.lex_state = 141},
  [1256] = {.lex_state = 119, .external_lex_state = 1},
  [1257] = {.lex_state = 119, .external_lex_state = 1},
  [1258] = {.lex_state = 119, .external_lex_state = 1},
  [1259] = {.lex_state = 119, .external_lex_state = 1},
  [1260] = {.lex_state = 119, .external_lex_state = 1},
  [1261] = {.lex_state = 119, .external_lex_state = 1},
  [1262] = {.lex_state = 119, .external_lex_state = 1},
  [1263] = {.lex_state = 119, .external_lex_state = 1},
  [1264] = {.lex_state = 119, .external_lex_state = 1},
  [1265] = {.lex_state = 141},
  [1266] = {.lex_state = 141},
  [1267] = {.lex_state = 141},
  [1268] = {.lex_state = 141},
  [1269] = {.lex_state = 119, .external_lex_state = 1},
  [1270] = {.lex_state = 141},
  [1271] = {.lex_state = 141},
  [1272] = {.lex_state = 119, .external_lex_state = 1},
  [1273] = {.lex_state = 119, .external_lex_state = 1},
  [1274] = {.lex_state = 119, .external_lex_state = 1},
  [1275] = {.lex_state = 141},
  [1276] = {.lex_state = 141},
  [1277] = {.lex_state = 119, .external_lex_state = 1},
  [1278] = {.lex_state = 141},
  [1279] = {.lex_state = 119, .external_lex_state = 1},
  [1280] = {.lex_state = 141},
  [1281] = {.lex_state = 141},
  [1282] = {.lex_state = 141},
  [1283] = {.lex_state = 119, .external_lex_state = 1},
  [1284] = {.lex_state = 119, .external_lex_state = 1},
  [1285] = {.lex_state = 141},
  [1286] = {.lex_state = 119, .external_lex_state = 1},
  [1287] = {.lex_state = 119, .external_lex_state = 1},
  [1288] = {.lex_state = 119, .external_lex_state = 1},
  [1289] = {.lex_state = 119, .external_lex_state = 1},
  [1290] = {.lex_state = 119, .external_lex_state = 1},
  [1291] = {.lex_state = 141},
  [1292] = {.lex_state = 119, .external_lex_state = 1},
  [1293] = {.lex_state = 119, .external_lex_state = 1},
  [1294] = {.lex_state = 119, .external_lex_state = 1},
  [1295] = {.lex_state = 119, .external_lex_state = 1},
  [1296] = {.lex_state = 141},
  [1297] = {.lex_state = 141},
  [1298] = {.lex_state = 141},
  [1299] = {.lex_state = 141},
  [1300] = {.lex_state = 141},
  [1301] = {.lex_state = 141},
  [1302] = {.lex_state = 141},
  [1303] = {.lex_state = 141},
  [1304] = {.lex_state = 141},
  [1305] = {.lex_state = 119, .external_lex_state = 1},
  [1306] = {.lex_state = 119, .external_lex_state = 1},
  [1307] = {.lex_state = 119, .external_lex_state = 1},
  [1308] = {.lex_state = 119, .external_lex_state = 1},
  [1309] = {.lex_state = 119, .external_lex_state = 1},
  [1310] = {.lex_state = 119, .external_lex_state = 1},
  [1311] = {.lex_state = 119, .external_lex_state = 1},
  [1312] = {.lex_state = 141},
  [1313] = {.lex_state = 119, .external_lex_state = 1},
  [1314] = {.lex_state = 119, .external_lex_state = 1},
  [1315] = {.lex_state = 119, .external_lex_state = 1},
  [1316] = {.lex_state = 119, .external_lex_state = 1},
  [1317] = {.lex_state = 119, .external_lex_state = 1},
  [1318] = {.lex_state = 119, .external_lex_state = 1},
  [1319] = {.lex_state = 119, .external_lex_state = 1},
  [1320] = {.lex_state = 119, .external_lex_state = 1},
  [1321] = {.lex_state = 119, .external_lex_state = 1},
  [1322] = {.lex_state = 119, .external_lex_state = 1},
  [1323] = {.lex_state = 119, .external_lex_state = 1},
  [1324] = {.lex_state = 119, .external_lex_state = 1},
  [1325] = {.lex_state = 119, .external_lex_state = 1},
  [1326] = {.lex_state = 119, .external_lex_state = 1},
  [1327] = {.lex_state = 119, .external_lex_state = 1},
  [1328] = {.lex_state = 119, .external_lex_state = 1},
  [1329] = {.lex_state = 119, .external_lex_state = 1},
  [1330] = {.lex_state = 119, .external_lex_state = 1},
  [1331] = {.lex_state = 119, .external_lex_state = 1},
  [1332] = {.lex_state = 119, .external_lex_state = 1},
  [1333] = {.lex_state = 119, .external_lex_state = 1},
  [1334] = {.lex_state = 119, .external_lex_state = 1},
  [1335] = {.lex_state = 119, .external_lex_state = 1},
  [1336] = {.lex_state = 119, .external_lex_state = 1},
  [1337] = {.lex_state = 119, .external_lex_state = 1},
  [1338] = {.lex_state = 119, .external_lex_state = 1},
  [1339] = {.lex_state = 119, .external_lex_state = 1},
  [1340] = {.lex_state = 119, .external_lex_state = 1},
  [1341] = {.lex_state = 119, .external_lex_state = 1},
  [1342] = {.lex_state = 119, .external_lex_state = 1},
  [1343] = {.lex_state = 119, .external_lex_state = 1},
  [1344] = {.lex_state = 119, .external_lex_state = 1},
  [1345] = {.lex_state = 119, .external_lex_state = 1},
  [1346] = {.lex_state = 119, .external_lex_state = 1},
  [1347] = {.lex_state = 119, .external_lex_state = 1},
  [1348] = {.lex_state = 119, .external_lex_state = 1},
  [1349] = {.lex_state = 119, .external_lex_state = 1},
  [1350] = {.lex_state = 119, .external_lex_state = 1},
  [1351] = {.lex_state = 119, .external_lex_state = 1},
  [1352] = {.lex_state = 119, .external_lex_state = 1},
  [1353] = {.lex_state = 119, .external_lex_state = 1},
  [1354] = {.lex_state = 119, .external_lex_state = 1},
  [1355] = {.lex_state = 119, .external_lex_state = 1},
  [1356] = {.lex_state = 119, .external_lex_state = 1},
  [1357] = {.lex_state = 157},
  [1358] = {.lex_state = 119, .external_lex_state = 1},
  [1359] = {.lex_state = 119, .external_lex_state = 1},
  [1360] = {.lex_state = 119, .external_lex_state = 1},
  [1361] = {.lex_state = 119, .external_lex_state = 1},
  [1362] = {.lex_state = 119, .external_lex_state = 1},
  [1363] = {.lex_state = 119, .external_lex_state = 1},
  [1364] = {.lex_state = 119, .external_lex_state = 1},
  [1365] = {.lex_state = 119, .external_lex_state = 1},
  [1366] = {.lex_state = 119, .external_lex_state = 1},
  [1367] = {.lex_state = 119, .external_lex_state = 1},
  [1368] = {.lex_state = 119, .external_lex_state = 1},
  [1369] = {.lex_state = 119, .external_lex_state = 1},
  [1370] = {.lex_state = 119, .external_lex_state = 1},
  [1371] = {.lex_state = 119, .external_lex_state = 1},
  [1372] = {.lex_state = 119, .external_lex_state = 1},
  [1373] = {.lex_state = 119, .external_lex_state = 1},
  [1374] = {.lex_state = 119, .external_lex_state = 1},
  [1375] = {.lex_state = 119, .external_lex_state = 1},
  [1376] = {.lex_state = 119, .external_lex_state = 1},
  [1377] = {.lex_state = 119, .external_lex_state = 1},
  [1378] = {.lex_state = 119, .external_lex_state = 1},
  [1379] = {.lex_state = 119, .external_lex_state = 1},
  [1380] = {.lex_state = 119, .external_lex_state = 1},
  [1381] = {.lex_state = 119, .external_lex_state = 1},
  [1382] = {.lex_state = 119, .external_lex_state = 1},
  [1383] = {.lex_state = 119, .external_lex_state = 1},
  [1384] = {.lex_state = 119, .external_lex_state = 1},
  [1385] = {.lex_state = 119, .external_lex_state = 1},
  [1386] = {.lex_state = 119, .external_lex_state = 1},
  [1387] = {.lex_state = 119, .external_lex_state = 1},
  [1388] = {.lex_state = 119, .external_lex_state = 1},
  [1389] = {.lex_state = 119, .external_lex_state = 1},
  [1390] = {.lex_state = 119, .external_lex_state = 1},
  [1391] = {.lex_state = 119, .external_lex_state = 1},
  [1392] = {.lex_state = 119, .external_lex_state = 1},
  [1393] = {.lex_state = 119, .external_lex_state = 1},
  [1394] = {.lex_state = 119, .external_lex_state = 1},
  [1395] = {.lex_state = 119, .external_lex_state = 1},
  [1396] = {.lex_state = 119, .external_lex_state = 1},
  [1397] = {.lex_state = 119, .external_lex_state = 1},
  [1398] = {.lex_state = 119, .external_lex_state = 1},
  [1399] = {.lex_state = 119, .external_lex_state = 1},
  [1400] = {.lex_state = 119, .external_lex_state = 1},
  [1401] = {.lex_state = 119, .external_lex_state = 1},
  [1402] = {.lex_state = 119, .external_lex_state = 1},
  [1403] = {.lex_state = 119, .external_lex_state = 1},
  [1404] = {.lex_state = 119, .external_lex_state = 1},
  [1405] = {.lex_state = 119, .external_lex_state = 1},
  [1406] = {.lex_state = 119, .external_lex_state = 1},
  [1407] = {.lex_state = 119, .external_lex_state = 1},
  [1408] = {.lex_state = 119, .external_lex_state = 1},
  [1409] = {.lex_state = 119, .external_lex_state = 1},
  [1410] = {.lex_state = 119, .external_lex_state = 1},
  [1411] = {.lex_state = 119, .external_lex_state = 1},
  [1412] = {.lex_state = 119, .external_lex_state = 1},
  [1413] = {.lex_state = 119, .external_lex_state = 1},
  [1414] = {.lex_state = 119, .external_lex_state = 1},
  [1415] = {.lex_state = 119, .external_lex_state = 1},
  [1416] = {.lex_state = 119, .external_lex_state = 1},
  [1417] = {.lex_state = 119, .external_lex_state = 1},
  [1418] = {.lex_state = 119, .external_lex_state = 1},
  [1419] = {.lex_state = 119, .external_lex_state = 1},
  [1420] = {.lex_state = 119, .external_lex_state = 1},
  [1421] = {.lex_state = 119, .external_lex_state = 1},
  [1422] = {.lex_state = 119, .external_lex_state = 1},
  [1423] = {.lex_state = 119, .external_lex_state = 1},
  [1424] = {.lex_state = 119, .external_lex_state = 1},
  [1425] = {.lex_state = 119, .external_lex_state = 1},
  [1426] = {.lex_state = 119, .external_lex_state = 1},
  [1427] = {.lex_state = 119, .external_lex_state = 1},
  [1428] = {.lex_state = 119, .external_lex_state = 1},
  [1429] = {.lex_state = 119, .external_lex_state = 1},
  [1430] = {.lex_state = 119, .external_lex_state = 1},
  [1431] = {.lex_state = 119, .external_lex_state = 1},
  [1432] = {.lex_state = 119, .external_lex_state = 1},
  [1433] = {.lex_state = 119, .external_lex_state = 1},
  [1434] = {.lex_state = 119, .external_lex_state = 1},
  [1435] = {.lex_state = 119, .external_lex_state = 1},
  [1436] = {.lex_state = 119, .external_lex_state = 1},
  [1437] = {.lex_state = 119, .external_lex_state = 1},
  [1438] = {.lex_state = 119, .external_lex_state = 1},
  [1439] = {.lex_state = 119, .external_lex_state = 1},
  [1440] = {.lex_state = 119, .external_lex_state = 1},
  [1441] = {.lex_state = 119, .external_lex_state = 1},
  [1442] = {.lex_state = 119, .external_lex_state = 1},
  [1443] = {.lex_state = 119, .external_lex_state = 1},
  [1444] = {.lex_state = 119, .external_lex_state = 1},
  [1445] = {.lex_state = 119, .external_lex_state = 1},
  [1446] = {.lex_state = 119, .external_lex_state = 1},
  [1447] = {.lex_state = 119, .external_lex_state = 1},
  [1448] = {.lex_state = 119, .external_lex_state = 1},
  [1449] = {.lex_state = 119, .external_lex_state = 1},
  [1450] = {.lex_state = 119, .external_lex_state = 1},
  [1451] = {.lex_state = 119, .external_lex_state = 1},
  [1452] = {.lex_state = 119, .external_lex_state = 1},
  [1453] = {.lex_state = 119, .external_lex_state = 1},
  [1454] = {.lex_state = 119, .external_lex_state = 1},
  [1455] = {.lex_state = 157},
  [1456] = {.lex_state = 119, .external_lex_state = 1},
  [1457] = {.lex_state = 119, .external_lex_state = 1},
  [1458] = {.lex_state = 119, .external_lex_state = 1},
  [1459] = {.lex_state = 119, .external_lex_state = 1},
  [1460] = {.lex_state = 119, .external_lex_state = 1},
  [1461] = {.lex_state = 119, .external_lex_state = 1},
  [1462] = {.lex_state = 119, .external_lex_state = 1},
  [1463] = {.lex_state = 139},
  [1464] = {.lex_state = 119, .external_lex_state = 1},
  [1465] = {.lex_state = 119, .external_lex_state = 1},
  [1466] = {.lex_state = 119, .external_lex_state = 1},
  [1467] = {.lex_state = 119, .external_lex_state = 1},
  [1468] = {.lex_state = 119, .external_lex_state = 1},
  [1469] = {.lex_state = 119, .external_lex_state = 1},
  [1470] = {.lex_state = 119, .external_lex_state = 1},
  [1471] = {.lex_state = 119, .external_lex_state = 1},
  [1472] = {.lex_state = 119, .external_lex_state = 1},
  [1473] = {.lex_state = 119, .external_lex_state = 1},
  [1474] = {.lex_state = 119, .external_lex_state = 1},
  [1475] = {.lex_state = 119, .external_lex_state = 1},
  [1476] = {.lex_state = 119, .external_lex_state = 1},
  [1477] = {.lex_state = 119, .external_lex_state = 1},
  [1478] = {.lex_state = 119, .external_lex_state = 1},
  [1479] = {.lex_state = 119, .external_lex_state = 1},
  [1480] = {.lex_state = 119, .external_lex_state = 1},
  [1481] = {.lex_state = 119, .external_lex_state = 1},
  [1482] = {.lex_state = 119, .external_lex_state = 1},
  [1483] = {.lex_state = 119, .external_lex_state = 1},
  [1484] = {.lex_state = 119, .external_lex_state = 1},
  [1485] = {.lex_state = 119, .external_lex_state = 1},
  [1486] = {.lex_state = 119, .external_lex_state = 1},
  [1487] = {.lex_state = 119, .external_lex_state = 1},
  [1488] = {.lex_state = 119, .external_lex_state = 1},
  [1489] = {.lex_state = 119, .external_lex_state = 1},
  [1490] = {.lex_state = 119, .external_lex_state = 1},
  [1491] = {.lex_state = 119, .external_lex_state = 1},
  [1492] = {.lex_state = 119, .external_lex_state = 1},
  [1493] = {.lex_state = 119, .external_lex_state = 1},
  [1494] = {.lex_state = 119, .external_lex_state = 1},
  [1495] = {.lex_state = 119, .external_lex_state = 1},
  [1496] = {.lex_state = 119, .external_lex_state = 1},
  [1497] = {.lex_state = 119, .external_lex_state = 1},
  [1498] = {.lex_state = 119, .external_lex_state = 1},
  [1499] = {.lex_state = 119, .external_lex_state = 1},
  [1500] = {.lex_state = 119, .external_lex_state = 1},
  [1501] = {.lex_state = 119, .external_lex_state = 1},
  [1502] = {.lex_state = 119, .external_lex_state = 1},
  [1503] = {.lex_state = 119, .external_lex_state = 1},
  [1504] = {.lex_state = 157},
  [1505] = {.lex_state = 119, .external_lex_state = 1},
  [1506] = {.lex_state = 119, .external_lex_state = 1},
  [1507] = {.lex_state = 119, .external_lex_state = 1},
  [1508] = {.lex_state = 119, .external_lex_state = 1},
  [1509] = {.lex_state = 119, .external_lex_state = 1},
  [1510] = {.lex_state = 119, .external_lex_state = 1},
  [1511] = {.lex_state = 119, .external_lex_state = 1},
  [1512] = {.lex_state = 119, .external_lex_state = 1},
  [1513] = {.lex_state = 119, .external_lex_state = 1},
  [1514] = {.lex_state = 119, .external_lex_state = 1},
  [1515] = {.lex_state = 119, .external_lex_state = 1},
  [1516] = {.lex_state = 119, .external_lex_state = 1},
  [1517] = {.lex_state = 119, .external_lex_state = 1},
  [1518] = {.lex_state = 119, .external_lex_state = 1},
  [1519] = {.lex_state = 119, .external_lex_state = 1},
  [1520] = {.lex_state = 119, .external_lex_state = 1},
  [1521] = {.lex_state = 119, .external_lex_state = 1},
  [1522] = {.lex_state = 119, .external_lex_state = 1},
  [1523] = {.lex_state = 119, .external_lex_state = 1},
  [1524] = {.lex_state = 119, .external_lex_state = 1},
  [1525] = {.lex_state = 119, .external_lex_state = 1},
  [1526] = {.lex_state = 119, .external_lex_state = 1},
  [1527] = {.lex_state = 119, .external_lex_state = 1},
  [1528] = {.lex_state = 119, .external_lex_state = 1},
  [1529] = {.lex_state = 119, .external_lex_state = 1},
  [1530] = {.lex_state = 119, .external_lex_state = 1},
  [1531] = {.lex_state = 119, .external_lex_state = 1},
  [1532] = {.lex_state = 119, .external_lex_state = 1},
  [1533] = {.lex_state = 119, .external_lex_state = 1},
  [1534] = {.lex_state = 119, .external_lex_state = 1},
  [1535] = {.lex_state = 119, .external_lex_state = 1},
  [1536] = {.lex_state = 119, .external_lex_state = 1},
  [1537] = {.lex_state = 119, .external_lex_state = 1},
  [1538] = {.lex_state = 119, .external_lex_state = 1},
  [1539] = {.lex_state = 119, .external_lex_state = 1},
  [1540] = {.lex_state = 119, .external_lex_state = 1},
  [1541] = {.lex_state = 160},
  [1542] = {.lex_state = 119, .external_lex_state = 1},
  [1543] = {.lex_state = 119, .external_lex_state = 1},
  [1544] = {.lex_state = 119, .external_lex_state = 1},
  [1545] = {.lex_state = 119, .external_lex_state = 1},
  [1546] = {.lex_state = 119, .external_lex_state = 1},
  [1547] = {.lex_state = 119, .external_lex_state = 1},
  [1548] = {.lex_state = 119, .external_lex_state = 1},
  [1549] = {.lex_state = 119, .external_lex_state = 1},
  [1550] = {.lex_state = 119, .external_lex_state = 1},
  [1551] = {.lex_state = 119, .external_lex_state = 1},
  [1552] = {.lex_state = 119, .external_lex_state = 1},
  [1553] = {.lex_state = 119, .external_lex_state = 1},
  [1554] = {.lex_state = 119, .external_lex_state = 1},
  [1555] = {.lex_state = 119, .external_lex_state = 1},
  [1556] = {.lex_state = 119, .external_lex_state = 1},
  [1557] = {.lex_state = 119, .external_lex_state = 1},
  [1558] = {.lex_state = 119, .external_lex_state = 1},
  [1559] = {.lex_state = 119, .external_lex_state = 1},
  [1560] = {.lex_state = 119, .external_lex_state = 1},
  [1561] = {.lex_state = 119, .external_lex_state = 1},
  [1562] = {.lex_state = 129},
  [1563] = {.lex_state = 129},
  [1564] = {.lex_state = 144},
  [1565] = {.lex_state = 144},
  [1566] = {.lex_state = 142},
  [1567] = {.lex_state = 129},
  [1568] = {.lex_state = 155},
  [1569] = {.lex_state = 129},
  [1570] = {.lex_state = 160},
  [1571] = {.lex_state = 160},
  [1572] = {.lex_state = 160},
  [1573] = {.lex_state = 129},
  [1574] = {.lex_state = 129},
  [1575] = {.lex_state = 129},
  [1576] = {.lex_state = 129},
  [1577] = {.lex_state = 129},
  [1578] = {.lex_state = 129},
  [1579] = {.lex_state = 129},
  [1580] = {.lex_state = 129},
  [1581] = {.lex_state = 129},
  [1582] = {.lex_state = 144},
  [1583] = {.lex_state = 129},
  [1584] = {.lex_state = 129},
  [1585] = {.lex_state = 129},
  [1586] = {.lex_state = 129},
  [1587] = {.lex_state = 129},
  [1588] = {.lex_state = 129},
  [1589] = {.lex_state = 129},
  [1590] = {.lex_state = 129},
  [1591] = {.lex_state = 129},
  [1592] = {.lex_state = 129},
  [1593] = {.lex_state = 129},
  [1594] = {.lex_state = 129},
  [1595] = {.lex_state = 129},
  [1596] = {.lex_state = 129},
  [1597] = {.lex_state = 129},
  [1598] = {.lex_state = 129},
  [1599] = {.lex_state = 129},
  [1600] = {.lex_state = 129},
  [1601] = {.lex_state = 129},
  [1602] = {.lex_state = 129},
  [1603] = {.lex_state = 129},
  [1604] = {.lex_state = 129},
  [1605] = {.lex_state = 129},
  [1606] = {.lex_state = 129},
  [1607] = {.lex_state = 129},
  [1608] = {.lex_state = 129},
  [1609] = {.lex_state = 129},
  [1610] = {.lex_state = 129},
  [1611] = {.lex_state = 129},
  [1612] = {.lex_state = 129},
  [1613] = {.lex_state = 160},
  [1614] = {.lex_state = 129},
  [1615] = {.lex_state = 129},
  [1616] = {.lex_state = 160},
  [1617] = {.lex_state = 160},
  [1618] = {.lex_state = 160},
  [1619] = {.lex_state = 160},
  [1620] = {.lex_state = 129},
  [1621] = {.lex_state = 129},
  [1622] = {.lex_state = 129},
  [1623] = {.lex_state = 144},
  [1624] = {.lex_state = 144},
  [1625] = {.lex_state = 144},
  [1626] = {.lex_state = 129},
  [1627] = {.lex_state = 160},
  [1628] = {.lex_state = 129},
  [1629] = {.lex_state = 129},
  [1630] = {.lex_state = 156},
  [1631] = {.lex_state = 129},
  [1632] = {.lex_state = 129},
  [1633] = {.lex_state = 129},
  [1634] = {.lex_state = 129},
  [1635] = {.lex_state = 160},
  [1636] = {.lex_state = 129},
  [1637] = {.lex_state = 129},
  [1638] = {.lex_state = 129},
  [1639] = {.lex_state = 129},
  [1640] = {.lex_state = 160},
  [1641] = {.lex_state = 129},
  [1642] = {.lex_state = 129},
  [1643] = {.lex_state = 160},
  [1644] = {.lex_state = 129},
  [1645] = {.lex_state = 129},
  [1646] = {.lex_state = 129},
  [1647] = {.lex_state = 129},
  [1648] = {.lex_state = 129},
  [1649] = {.lex_state = 160},
  [1650] = {.lex_state = 129},
  [1651] = {.lex_state = 129},
  [1652] = {.lex_state = 129},
  [1653] = {.lex_state = 129},
  [1654] = {.lex_state = 129},
  [1655] = {.lex_state = 129},
  [1656] = {.lex_state = 129},
  [1657] = {.lex_state = 129},
  [1658] = {.lex_state = 129},
  [1659] = {.lex_state = 129},
  [1660] = {.lex_state = 129},
  [1661] = {.lex_state = 129},
  [1662] = {.lex_state = 129},
  [1663] = {.lex_state = 160},
  [1664] = {.lex_state = 129},
  [1665] = {.lex_state = 129},
  [1666] = {.lex_state = 129},
  [1667] = {.lex_state = 129},
  [1668] = {.lex_state = 129},
  [1669] = {.lex_state = 129},
  [1670] = {.lex_state = 129},
  [1671] = {.lex_state = 129},
  [1672] = {.lex_state = 129},
  [1673] = {.lex_state = 129},
  [1674] = {.lex_state = 129},
  [1675] = {.lex_state = 129},
  [1676] = {.lex_state = 129},
  [1677] = {.lex_state = 129},
  [1678] = {.lex_state = 129},
  [1679] = {.lex_state = 129},
  [1680] = {.lex_state = 129},
  [1681] = {.lex_state = 129},
  [1682] = {.lex_state = 129},
  [1683] = {.lex_state = 129},
  [1684] = {.lex_state = 129},
  [1685] = {.lex_state = 129},
  [1686] = {.lex_state = 129},
  [1687] = {.lex_state = 129},
  [1688] = {.lex_state = 129},
  [1689] = {.lex_state = 129},
  [1690] = {.lex_state = 129},
  [1691] = {.lex_state = 129},
  [1692] = {.lex_state = 129},
  [1693] = {.lex_state = 129},
  [1694] = {.lex_state = 129},
  [1695] = {.lex_state = 129},
  [1696] = {.lex_state = 129},
  [1697] = {.lex_state = 129},
  [1698] = {.lex_state = 129},
  [1699] = {.lex_state = 129},
  [1700] = {.lex_state = 129},
  [1701] = {.lex_state = 129},
  [1702] = {.lex_state = 129},
  [1703] = {.lex_state = 129},
  [1704] = {.lex_state = 129},
  [1705] = {.lex_state = 129},
  [1706] = {.lex_state = 129},
  [1707] = {.lex_state = 129},
  [1708] = {.lex_state = 129},
  [1709] = {.lex_state = 129},
  [1710] = {.lex_state = 129},
  [1711] = {.lex_state = 129},
  [1712] = {.lex_state = 129},
  [1713] = {.lex_state = 129},
  [1714] = {.lex_state = 129},
  [1715] = {.lex_state = 129},
  [1716] = {.lex_state = 129},
  [1717] = {.lex_state = 129},
  [1718] = {.lex_state = 129},
  [1719] = {.lex_state = 129},
  [1720] = {.lex_state = 129},
  [1721] = {.lex_state = 129},
  [1722] = {.lex_state = 129},
  [1723] = {.lex_state = 139},
  [1724] = {.lex_state = 155},
  [1725] = {.lex_state = 155},
  [1726] = {.lex_state = 155},
  [1727] = {.lex_state = 155},
  [1728] = {.lex_state = 156},
  [1729] = {.lex_state = 155},
  [1730] = {.lex_state = 155},
  [1731] = {.lex_state = 155},
  [1732] = {.lex_state = 156},
  [1733] = {.lex_state = 155},
  [1734] = {.lex_state = 155},
  [1735] = {.lex_state = 155},
  [1736] = {.lex_state = 156},
  [1737] = {.lex_state = 156},
  [1738] = {.lex_state = 156},
  [1739] = {.lex_state = 156},
  [1740] = {.lex_state = 156},
  [1741] = {.lex_state = 156},
  [1742] = {.lex_state = 155},
  [1743] = {.lex_state = 155},
  [1744] = {.lex_state = 155},
  [1745] = {.lex_state = 155},
  [1746] = {.lex_state = 155},
  [1747] = {.lex_state = 156},
  [1748] = {.lex_state = 155},
  [1749] = {.lex_state = 155},
  [1750] = {.lex_state = 155},
  [1751] = {.lex_state = 156},
  [1752] = {.lex_state = 155},
  [1753] = {.lex_state = 155},
  [1754] = {.lex_state = 155},
  [1755] = {.lex_state = 155},
  [1756] = {.lex_state = 155},
  [1757] = {.lex_state = 156},
  [1758] = {.lex_state = 155},
  [1759] = {.lex_state = 156},
  [1760] = {.lex_state = 155},
  [1761] = {.lex_state = 155},
  [1762] = {.lex_state = 156},
  [1763] = {.lex_state = 155},
  [1764] = {.lex_state = 156},
  [1765] = {.lex_state = 155},
  [1766] = {.lex_state = 156},
  [1767] = {.lex_state = 155},
  [1768] = {.lex_state = 139},
  [1769] = {.lex_state = 139},
  [1770] = {.lex_state = 156},
  [1771] = {.lex_state = 155},
  [1772] = {.lex_state = 155},
  [1773] = {.lex_state = 155},
  [1774] = {.lex_state = 155},
  [1775] = {.lex_state = 155},
  [1776] = {.lex_state = 139},
  [1777] = {.lex_state = 139},
  [1778] = {.lex_state = 156},
  [1779] = {.lex_state = 156},
  [1780] = {.lex_state = 139},
  [1781] = {.lex_state = 139},
  [1782] = {.lex_state = 139},
  [1783] = {.lex_state = 155},
  [1784] = {.lex_state = 139},
  [1785] = {.lex_state = 139},
  [1786] = {.lex_state = 155},
  [1787] = {.lex_state = 139},
  [1788] = {.lex_state = 139},
  [1789] = {.lex_state = 139},
  [1790] = {.lex_state = 155},
  [1791] = {.lex_state = 139},
  [1792] = {.lex_state = 155},
  [1793] = {.lex_state = 155},
  [1794] = {.lex_state = 155},
  [1795] = {.lex_state = 155},
  [1796] = {.lex_state = 156},
  [1797] = {.lex_state = 155},
  [1798] = {.lex_state = 156},
  [1799] = {.lex_state = 156},
  [1800] = {.lex_state = 156},
  [1801] = {.lex_state = 156},
  [1802] = {.lex_state = 155},
  [1803] = {.lex_state = 155},
  [1804] = {.lex_state = 155},
  [1805] = {.lex_state = 155},
  [1806] = {.lex_state = 155},
  [1807] = {.lex_state = 155},
  [1808] = {.lex_state = 155},
  [1809] = {.lex_state = 156},
  [1810] = {.lex_state = 156},
  [1811] = {.lex_state = 156},
  [1812] = {.lex_state = 156},
  [1813] = {.lex_state = 155},
  [1814] = {.lex_state = 155},
  [1815] = {.lex_state = 155},
  [1816] = {.lex_state = 155},
  [1817] = {.lex_state = 156},
  [1818] = {.lex_state = 156},
  [1819] = {.lex_state = 155},
  [1820] = {.lex_state = 155},
  [1821] = {.lex_state = 155},
  [1822] = {.lex_state = 155},
  [1823] = {.lex_state = 155},
  [1824] = {.lex_state = 156},
  [1825] = {.lex_state = 155},
  [1826] = {.lex_state = 155},
  [1827] = {.lex_state = 155},
  [1828] = {.lex_state = 155},
  [1829] = {.lex_state = 155},
  [1830] = {.lex_state = 156},
  [1831] = {.lex_state = 156},
  [1832] = {.lex_state = 156},
  [1833] = {.lex_state = 155},
  [1834] = {.lex_state = 155},
  [1835] = {.lex_state = 156},
  [1836] = {.lex_state = 156},
  [1837] = {.lex_state = 155},
  [1838] = {.lex_state = 155},
  [1839] = {.lex_state = 155},
  [1840] = {.lex_state = 155},
  [1841] = {.lex_state = 155},
  [1842] = {.lex_state = 155},
  [1843] = {.lex_state = 155},
  [1844] = {.lex_state = 155},
  [1845] = {.lex_state = 156},
  [1846] = {.lex_state = 155},
  [1847] = {.lex_state = 155},
  [1848] = {.lex_state = 155},
  [1849] = {.lex_state = 156},
  [1850] = {.lex_state = 155},
  [1851] = {.lex_state = 155},
  [1852] = {.lex_state = 155},
  [1853] = {.lex_state = 156},
  [1854] = {.lex_state = 156},
  [1855] = {.lex_state = 155},
  [1856] = {.lex_state = 155},
  [1857] = {.lex_state = 155},
  [1858] = {.lex_state = 156},
  [1859] = {.lex_state = 155},
  [1860] = {.lex_state = 155},
  [1861] = {.lex_state = 155},
  [1862] = {.lex_state = 155},
  [1863] = {.lex_state = 155},
  [1864] = {.lex_state = 155},
  [1865] = {.lex_state = 155},
  [1866] = {.lex_state = 155},
  [1867] = {.lex_state = 155},
  [1868] = {.lex_state = 155},
  [1869] = {.lex_state = 155},
  [1870] = {.lex_state = 155},
  [1871] = {.lex_state = 155},
  [1872] = {.lex_state = 155},
  [1873] = {.lex_state = 155},
  [1874] = {.lex_state = 156},
  [1875] = {.lex_state = 155},
  [1876] = {.lex_state = 155},
  [1877] = {.lex_state = 155},
  [1878] = {.lex_state = 155},
  [1879] = {.lex_state = 155},
  [1880] = {.lex_state = 160},
  [1881] = {.lex_state = 156},
  [1882] = {.lex_state = 155},
  [1883] = {.lex_state = 155},
  [1884] = {.lex_state = 139},
  [1885] = {.lex_state = 155},
  [1886] = {.lex_state = 139},
  [1887] = {.lex_state = 156},
  [1888] = {.lex_state = 139},
  [1889] = {.lex_state = 139},
  [1890] = {.lex_state = 155},
  [1891] = {.lex_state = 139},
  [1892] = {.lex_state = 139},
  [1893] = {.lex_state = 155},
  [1894] = {.lex_state = 139},
  [1895] = {.lex_state = 139},
  [1896] = {.lex_state = 139},
  [1897] = {.lex_state = 139},
  [1898] = {.lex_state = 139},
  [1899] = {.lex_state = 156},
  [1900] = {.lex_state = 155},
  [1901] = {.lex_state = 139},
  [1902] = {.lex_state = 155},
  [1903] = {.lex_state = 156},
  [1904] = {.lex_state = 155},
  [1905] = {.lex_state = 139},
  [1906] = {.lex_state = 156},
  [1907] = {.lex_state = 139},
  [1908] = {.lex_state = 156},
  [1909] = {.lex_state = 156},
  [1910] = {.lex_state = 156},
  [1911] = {.lex_state = 156},
  [1912] = {.lex_state = 155},
  [1913] = {.lex_state = 156},
  [1914] = {.lex_state = 156},
  [1915] = {.lex_state = 156},
  [1916] = {.lex_state = 139},
  [1917] = {.lex_state = 156},
  [1918] = {.lex_state = 156},
  [1919] = {.lex_state = 139},
  [1920] = {.lex_state = 156},
  [1921] = {.lex_state = 139},
  [1922] = {.lex_state = 156},
  [1923] = {.lex_state = 156},
  [1924] = {.lex_state = 156},
  [1925] = {.lex_state = 155},
  [1926] = {.lex_state = 139},
  [1927] = {.lex_state = 155},
  [1928] = {.lex_state = 155},
  [1929] = {.lex_state = 155},
  [1930] = {.lex_state = 139},
  [1931] = {.lex_state = 156},
  [1932] = {.lex_state = 156},
  [1933] = {.lex_state = 156},
  [1934] = {.lex_state = 139},
  [1935] = {.lex_state = 139},
  [1936] = {.lex_state = 139},
  [1937] = {.lex_state = 139},
  [1938] = {.lex_state = 155},
  [1939] = {.lex_state = 156},
  [1940] = {.lex_state = 155},
  [1941] = {.lex_state = 139},
  [1942] = {.lex_state = 139},
  [1943] = {.lex_state = 156},
  [1944] = {.lex_state = 156},
  [1945] = {.lex_state = 155},
  [1946] = {.lex_state = 155},
  [1947] = {.lex_state = 156},
  [1948] = {.lex_state = 156},
  [1949] = {.lex_state = 156},
  [1950] = {.lex_state = 156},
  [1951] = {.lex_state = 156},
  [1952] = {.lex_state = 139},
  [1953] = {.lex_state = 156},
  [1954] = {.lex_state = 156},
  [1955] = {.lex_state = 139},
  [1956] = {.lex_state = 156},
  [1957] = {.lex_state = 156},
  [1958] = {.lex_state = 156},
  [1959] = {.lex_state = 156},
  [1960] = {.lex_state = 156},
  [1961] = {.lex_state = 139},
  [1962] = {.lex_state = 139},
  [1963] = {.lex_state = 156},
  [1964] = {.lex_state = 139},
  [1965] = {.lex_state = 156},
  [1966] = {.lex_state = 156},
  [1967] = {.lex_state = 139},
  [1968] = {.lex_state = 139},
  [1969] = {.lex_state = 156},
  [1970] = {.lex_state = 156},
  [1971] = {.lex_state = 139},
  [1972] = {.lex_state = 156},
  [1973] = {.lex_state = 156},
  [1974] = {.lex_state = 139},
  [1975] = {.lex_state = 156},
  [1976] = {.lex_state = 155},
  [1977] = {.lex_state = 156},
  [1978] = {.lex_state = 155},
  [1979] = {.lex_state = 156},
  [1980] = {.lex_state = 156},
  [1981] = {.lex_state = 156},
  [1982] = {.lex_state = 156},
  [1983] = {.lex_state = 155},
  [1984] = {.lex_state = 156},
  [1985] = {.lex_state = 156},
  [1986] = {.lex_state = 156},
  [1987] = {.lex_state = 156},
  [1988] = {.lex_state = 156},
  [1989] = {.lex_state = 156},
  [1990] = {.lex_state = 156},
  [1991] = {.lex_state = 156},
  [1992] = {.lex_state = 156},
  [1993] = {.lex_state = 156},
  [1994] = {.lex_state = 156},
  [1995] = {.lex_state = 156},
  [1996] = {.lex_state = 156},
  [1997] = {.lex_state = 156},
  [1998] = {.lex_state = 156},
  [1999] = {.lex_state = 156},
  [2000] = {.lex_state = 156},
  [2001] = {.lex_state = 155},
  [2002] = {.lex_state = 156},
  [2003] = {.lex_state = 156},
  [2004] = {.lex_state = 156},
  [2005] = {.lex_state = 155},
  [2006] = {.lex_state = 156},
  [2007] = {.lex_state = 156},
  [2008] = {.lex_state = 156},
  [2009] = {.lex_state = 156},
  [2010] = {.lex_state = 156},
  [2011] = {.lex_state = 156},
  [2012] = {.lex_state = 156},
  [2013] = {.lex_state = 155},
  [2014] = {.lex_state = 156},
  [2015] = {.lex_state = 156},
  [2016] = {.lex_state = 156},
  [2017] = {.lex_state = 155},
  [2018] = {.lex_state = 156},
  [2019] = {.lex_state = 156},
  [2020] = {.lex_state = 156},
  [2021] = {.lex_state = 155},
  [2022] = {.lex_state = 155},
  [2023] = {.lex_state = 155},
  [2024] = {.lex_state = 155},
  [2025] = {.lex_state = 155},
  [2026] = {.lex_state = 155},
  [2027] = {.lex_state = 155},
  [2028] = {.lex_state = 156},
  [2029] = {.lex_state = 156},
  [2030] = {.lex_state = 156},
  [2031] = {.lex_state = 156},
  [2032] = {.lex_state = 155},
  [2033] = {.lex_state = 156},
  [2034] = {.lex_state = 156},
  [2035] = {.lex_state = 155},
  [2036] = {.lex_state = 156},
  [2037] = {.lex_state = 156},
  [2038] = {.lex_state = 156},
  [2039] = {.lex_state = 156},
  [2040] = {.lex_state = 156},
  [2041] = {.lex_state = 156},
  [2042] = {.lex_state = 155},
  [2043] = {.lex_state = 156},
  [2044] = {.lex_state = 155},
  [2045] = {.lex_state = 155},
  [2046] = {.lex_state = 156},
  [2047] = {.lex_state = 156},
  [2048] = {.lex_state = 160},
  [2049] = {.lex_state = 157},
  [2050] = {.lex_state = 130},
  [2051] = {.lex_state = 132},
  [2052] = {.lex_state = 157},
  [2053] = {.lex_state = 132},
  [2054] = {.lex_state = 157},
  [2055] = {.lex_state = 129},
  [2056] = {.lex_state = 129},
  [2057] = {.lex_state = 160},
  [2058] = {.lex_state = 144},
  [2059] = {.lex_state = 141},
  [2060] = {.lex_state = 129},
  [2061] = {.lex_state = 160},
  [2062] = {.lex_state = 157},
  [2063] = {.lex_state = 160},
  [2064] = {.lex_state = 141},
  [2065] = {.lex_state = 140},
  [2066] = {.lex_state = 130},
  [2067] = {.lex_state = 130},
  [2068] = {.lex_state = 141},
  [2069] = {.lex_state = 130},
  [2070] = {.lex_state = 140},
  [2071] = {.lex_state = 133},
  [2072] = {.lex_state = 160},
  [2073] = {.lex_state = 144},
  [2074] = {.lex_state = 160},
  [2075] = {.lex_state = 121, .external_lex_state = 1},
  [2076] = {.lex_state = 160},
  [2077] = {.lex_state = 121, .external_lex_state = 1},
  [2078] = {.lex_state = 160},
  [2079] = {.lex_state = 144},
  [2080] = {.lex_state = 144},
  [2081] = {.lex_state = 144},
  [2082] = {.lex_state = 121, .external_lex_state = 1},
  [2083] = {.lex_state = 160},
  [2084] = {.lex_state = 160},
  [2085] = {.lex_state = 129},
  [2086] = {.lex_state = 144},
  [2087] = {.lex_state = 144},
  [2088] = {.lex_state = 160},
  [2089] = {.lex_state = 160},
  [2090] = {.lex_state = 133},
  [2091] = {.lex_state = 147},
  [2092] = {.lex_state = 147},
  [2093] = {.lex_state = 140},
  [2094] = {.lex_state = 140},
  [2095] = {.lex_state = 140},
  [2096] = {.lex_state = 147},
  [2097] = {.lex_state = 147},
  [2098] = {.lex_state = 147},
  [2099] = {.lex_state = 147},
  [2100] = {.lex_state = 147},
  [2101] = {.lex_state = 147},
  [2102] = {.lex_state = 147},
  [2103] = {.lex_state = 143},
  [2104] = {.lex_state = 143},
  [2105] = {.lex_state = 121, .external_lex_state = 1},
  [2106] = {.lex_state = 143},
  [2107] = {.lex_state = 133},
  [2108] = {.lex_state = 133},
  [2109] = {.lex_state = 133},
  [2110] = {.lex_state = 147},
  [2111] = {.lex_state = 157},
  [2112] = {.lex_state = 157},
  [2113] = {.lex_state = 157},
  [2114] = {.lex_state = 147},
  [2115] = {.lex_state = 157},
  [2116] = {.lex_state = 147},
  [2117] = {.lex_state = 140},
  [2118] = {.lex_state = 147},
  [2119] = {.lex_state = 157},
  [2120] = {.lex_state = 157},
  [2121] = {.lex_state = 147},
  [2122] = {.lex_state = 147},
  [2123] = {.lex_state = 147},
  [2124] = {.lex_state = 147},
  [2125] = {.lex_state = 147},
  [2126] = {.lex_state = 147},
  [2127] = {.lex_state = 147},
  [2128] = {.lex_state = 157},
  [2129] = {.lex_state = 147},
  [2130] = {.lex_state = 147},
  [2131] = {.lex_state = 147},
  [2132] = {.lex_state = 147},
  [2133] = {.lex_state = 143},
  [2134] = {.lex_state = 147},
  [2135] = {.lex_state = 147},
  [2136] = {.lex_state = 147},
  [2137] = {.lex_state = 147},
  [2138] = {.lex_state = 147},
  [2139] = {.lex_state = 147},
  [2140] = {.lex_state = 140},
  [2141] = {.lex_state = 140},
  [2142] = {.lex_state = 140},
  [2143] = {.lex_state = 147},
  [2144] = {.lex_state = 147},
  [2145] = {.lex_state = 147},
  [2146] = {.lex_state = 157},
  [2147] = {.lex_state = 147},
  [2148] = {.lex_state = 157},
  [2149] = {.lex_state = 133},
  [2150] = {.lex_state = 143},
  [2151] = {.lex_state = 157},
  [2152] = {.lex_state = 133},
  [2153] = {.lex_state = 157},
  [2154] = {.lex_state = 147},
  [2155] = {.lex_state = 147},
  [2156] = {.lex_state = 147},
  [2157] = {.lex_state = 147},
  [2158] = {.lex_state = 143},
  [2159] = {.lex_state = 147},
  [2160] = {.lex_state = 133},
  [2161] = {.lex_state = 147},
  [2162] = {.lex_state = 157},
  [2163] = {.lex_state = 147},
  [2164] = {.lex_state = 121, .external_lex_state = 1},
  [2165] = {.lex_state = 140},
  [2166] = {.lex_state = 147},
  [2167] = {.lex_state = 147},
  [2168] = {.lex_state = 147},
  [2169] = {.lex_state = 147},
  [2170] = {.lex_state = 147},
  [2171] = {.lex_state = 147},
  [2172] = {.lex_state = 147},
  [2173] = {.lex_state = 160},
  [2174] = {.lex_state = 160},
  [2175] = {.lex_state = 160},
  [2176] = {.lex_state = 160},
  [2177] = {.lex_state = 160},
  [2178] = {.lex_state = 160},
  [2179] = {.lex_state = 160},
  [2180] = {.lex_state = 160},
  [2181] = {.lex_state = 160},
  [2182] = {.lex_state = 160},
  [2183] = {.lex_state = 160},
  [2184] = {.lex_state = 160},
  [2185] = {.lex_state = 160},
  [2186] = {.lex_state = 160},
  [2187] = {.lex_state = 160},
  [2188] = {.lex_state = 132},
  [2189] = {.lex_state = 160},
  [2190] = {.lex_state = 160},
  [2191] = {.lex_state = 160},
  [2192] = {.lex_state = 160},
  [2193] = {.lex_state = 160},
  [2194] = {.lex_state = 160},
  [2195] = {.lex_state = 160},
  [2196] = {.lex_state = 160},
  [2197] = {.lex_state = 160},
  [2198] = {.lex_state = 160},
  [2199] = {.lex_state = 160},
  [2200] = {.lex_state = 160},
  [2201] = {.lex_state = 160},
  [2202] = {.lex_state = 142},
  [2203] = {.lex_state = 126},
  [2204] = {.lex_state = 132},
  [2205] = {.lex_state = 137},
  [2206] = {.lex_state = 133},
  [2207] = {.lex_state = 160},
  [2208] = {.lex_state = 133},
  [2209] = {.lex_state = 126},
  [2210] = {.lex_state = 119, .external_lex_state = 1},
  [2211] = {.lex_state = 133},
  [2212] = {.lex_state = 137},
  [2213] = {.lex_state = 160},
  [2214] = {.lex_state = 126},
  [2215] = {.lex_state = 124, .external_lex_state = 1},
  [2216] = {.lex_state = 133},
  [2217] = {.lex_state = 132},
  [2218] = {.lex_state = 160},
  [2219] = {.lex_state = 132},
  [2220] = {.lex_state = 133},
  [2221] = {.lex_state = 124, .external_lex_state = 1},
  [2222] = {.lex_state = 124, .external_lex_state = 1},
  [2223] = {.lex_state = 123, .external_lex_state = 1},
  [2224] = {.lex_state = 132},
  [2225] = {.lex_state = 119, .external_lex_state = 1},
  [2226] = {.lex_state = 160},
  [2227] = {.lex_state = 131},
  [2228] = {.lex_state = 132},
  [2229] = {.lex_state = 132},
  [2230] = {.lex_state = 123, .external_lex_state = 1},
  [2231] = {.lex_state = 132},
  [2232] = {.lex_state = 122, .external_lex_state = 1},
  [2233] = {.lex_state = 132},
  [2234] = {.lex_state = 132},
  [2235] = {.lex_state = 122, .external_lex_state = 1},
  [2236] = {.lex_state = 130},
  [2237] = {.lex_state = 138},
  [2238] = {.lex_state = 130},
  [2239] = {.lex_state = 138},
  [2240] = {.lex_state = 132},
  [2241] = {.lex_state = 122, .external_lex_state = 1},
  [2242] = {.lex_state = 126},
  [2243] = {.lex_state = 123, .external_lex_state = 1},
  [2244] = {.lex_state = 132},
  [2245] = {.lex_state = 142},
  [2246] = {.lex_state = 142},
  [2247] = {.lex_state = 132},
  [2248] = {.lex_state = 132},
  [2249] = {.lex_state = 136},
  [2250] = {.lex_state = 138},
  [2251] = {.lex_state = 136},
  [2252] = {.lex_state = 131},
  [2253] = {.lex_state = 133},
  [2254] = {.lex_state = 131},
  [2255] = {.lex_state = 133},
  [2256] = {.lex_state = 136},
  [2257] = {.lex_state = 136},
  [2258] = {.lex_state = 119, .external_lex_state = 1},
  [2259] = {.lex_state = 138},
  [2260] = {.lex_state = 133},
  [2261] = {.lex_state = 138},
  [2262] = {.lex_state = 133},
  [2263] = {.lex_state = 137},
  [2264] = {.lex_state = 137},
  [2265] = {.lex_state = 137},
  [2266] = {.lex_state = 137},
  [2267] = {.lex_state = 137},
  [2268] = {.lex_state = 137},
  [2269] = {.lex_state = 136},
  [2270] = {.lex_state = 138},
  [2271] = {.lex_state = 136},
  [2272] = {.lex_state = 138},
  [2273] = {.lex_state = 133},
  [2274] = {.lex_state = 133},
  [2275] = {.lex_state = 138},
  [2276] = {.lex_state = 131},
  [2277] = {.lex_state = 123, .external_lex_state = 1},
  [2278] = {.lex_state = 133},
  [2279] = {.lex_state = 131},
  [2280] = {.lex_state = 123, .external_lex_state = 1},
  [2281] = {.lex_state = 131},
  [2282] = {.lex_state = 134},
  [2283] = {.lex_state = 131},
  [2284] = {.lex_state = 131},
  [2285] = {.lex_state = 131},
  [2286] = {.lex_state = 133},
  [2287] = {.lex_state = 131},
  [2288] = {.lex_state = 135},
  [2289] = {.lex_state = 131},
  [2290] = {.lex_state = 122, .external_lex_state = 1},
  [2291] = {.lex_state = 124, .external_lex_state = 1},
  [2292] = {.lex_state = 124, .external_lex_state = 1},
  [2293] = {.lex_state = 133},
  [2294] = {.lex_state = 131},
  [2295] = {.lex_state = 157},
  [2296] = {.lex_state = 122, .external_lex_state = 1},
  [2297] = {.lex_state = 133},
  [2298] = {.lex_state = 130},
  [2299] = {.lex_state = 131},
  [2300] = {.lex_state = 133},
  [2301] = {.lex_state = 131},
  [2302] = {.lex_state = 157},
  [2303] = {.lex_state = 134},
  [2304] = {.lex_state = 157},
  [2305] = {.lex_state = 133},
  [2306] = {.lex_state = 133},
  [2307] = {.lex_state = 133},
  [2308] = {.lex_state = 130},
  [2309] = {.lex_state = 130},
  [2310] = {.lex_state = 157},
  [2311] = {.lex_state = 131},
  [2312] = {.lex_state = 131},
  [2313] = {.lex_state = 130},
  [2314] = {.lex_state = 131},
  [2315] = {.lex_state = 130},
  [2316] = {.lex_state = 137},
  [2317] = {.lex_state = 133},
  [2318] = {.lex_state = 133},
  [2319] = {.lex_state = 133},
  [2320] = {.lex_state = 133},
  [2321] = {.lex_state = 136},
  [2322] = {.lex_state = 133},
  [2323] = {.lex_state = 135},
  [2324] = {.lex_state = 135},
  [2325] = {.lex_state = 135},
  [2326] = {.lex_state = 135},
  [2327] = {.lex_state = 131},
  [2328] = {.lex_state = 133},
  [2329] = {.lex_state = 157},
  [2330] = {.lex_state = 133},
  [2331] = {.lex_state = 134},
  [2332] = {.lex_state = 133},
  [2333] = {.lex_state = 130},
  [2334] = {.lex_state = 138},
  [2335] = {.lex_state = 130},
  [2336] = {.lex_state = 133},
  [2337] = {.lex_state = 157},
  [2338] = {.lex_state = 133},
  [2339] = {.lex_state = 157},
  [2340] = {.lex_state = 133},
  [2341] = {.lex_state = 133},
  [2342] = {.lex_state = 130},
  [2343] = {.lex_state = 133},
  [2344] = {.lex_state = 133},
  [2345] = {.lex_state = 133},
  [2346] = {.lex_state = 134},
  [2347] = {.lex_state = 134},
  [2348] = {.lex_state = 134},
  [2349] = {.lex_state = 134},
  [2350] = {.lex_state = 157},
  [2351] = {.lex_state = 131},
  [2352] = {.lex_state = 134},
  [2353] = {.lex_state = 133},
  [2354] = {.lex_state = 133},
  [2355] = {.lex_state = 133},
  [2356] = {.lex_state = 157},
  [2357] = {.lex_state = 157},
  [2358] = {.lex_state = 131},
  [2359] = {.lex_state = 133},
  [2360] = {.lex_state = 133},
  [2361] = {.lex_state = 157},
  [2362] = {.lex_state = 133},
  [2363] = {.lex_state = 157},
  [2364] = {.lex_state = 133},
  [2365] = {.lex_state = 133},
  [2366] = {.lex_state = 133},
  [2367] = {.lex_state = 157},
  [2368] = {.lex_state = 131},
  [2369] = {.lex_state = 134},
  [2370] = {.lex_state = 133},
  [2371] = {.lex_state = 157},
  [2372] = {.lex_state = 157},
  [2373] = {.lex_state = 133},
  [2374] = {.lex_state = 131},
  [2375] = {.lex_state = 135},
  [2376] = {.lex_state = 133},
  [2377] = {.lex_state = 133},
  [2378] = {.lex_state = 131},
  [2379] = {.lex_state = 131},
  [2380] = {.lex_state = 135},
  [2381] = {.lex_state = 133},
  [2382] = {.lex_state = 131},
  [2383] = {.lex_state = 133},
  [2384] = {.lex_state = 133},
  [2385] = {.lex_state = 131},
  [2386] = {.lex_state = 131},
  [2387] = {.lex_state = 134},
  [2388] = {.lex_state = 134},
  [2389] = {.lex_state = 131},
  [2390] = {.lex_state = 131},
  [2391] = {.lex_state = 131},
  [2392] = {.lex_state = 157},
  [2393] = {.lex_state = 135},
  [2394] = {.lex_state = 130},
  [2395] = {.lex_state = 131},
  [2396] = {.lex_state = 133},
  [2397] = {.lex_state = 131},
  [2398] = {.lex_state = 133},
  [2399] = {.lex_state = 133},
  [2400] = {.lex_state = 135},
  [2401] = {.lex_state = 131},
  [2402] = {.lex_state = 157},
  [2403] = {.lex_state = 131},
  [2404] = {.lex_state = 130},
  [2405] = {.lex_state = 133},
  [2406] = {.lex_state = 133},
  [2407] = {.lex_state = 134},
  [2408] = {.lex_state = 133},
  [2409] = {.lex_state = 130},
  [2410] = {.lex_state = 133},
  [2411] = {.lex_state = 157},
  [2412] = {.lex_state = 133},
  [2413] = {.lex_state = 131},
  [2414] = {.lex_state = 133},
  [2415] = {.lex_state = 134},
  [2416] = {.lex_state = 133},
  [2417] = {.lex_state = 131},
  [2418] = {.lex_state = 130},
  [2419] = {.lex_state = 133},
  [2420] = {.lex_state = 131},
  [2421] = {.lex_state = 133},
  [2422] = {.lex_state = 133},
  [2423] = {.lex_state = 133},
  [2424] = {.lex_state = 135},
  [2425] = {.lex_state = 133},
  [2426] = {.lex_state = 133},
  [2427] = {.lex_state = 135},
  [2428] = {.lex_state = 130},
  [2429] = {.lex_state = 135},
  [2430] = {.lex_state = 131},
  [2431] = {.lex_state = 131},
  [2432] = {.lex_state = 135},
  [2433] = {.lex_state = 135},
  [2434] = {.lex_state = 131},
  [2435] = {.lex_state = 134},
  [2436] = {.lex_state = 131},
  [2437] = {.lex_state = 131},
  [2438] = {.lex_state = 119, .external_lex_state = 1},
  [2439] = {.lex_state = 131},
  [2440] = {.lex_state = 130},
  [2441] = {.lex_state = 124},
  [2442] = {.lex_state = 133},
  [2443] = {.lex_state = 130},
  [2444] = {.lex_state = 130},
  [2445] = {.lex_state = 133},
  [2446] = {.lex_state = 133},
  [2447] = {.lex_state = 133},
  [2448] = {.lex_state = 133},
  [2449] = {.lex_state = 133},
  [2450] = {.lex_state = 133},
  [2451] = {.lex_state = 133},
  [2452] = {.lex_state = 133},
  [2453] = {.lex_state = 130},
  [2454] = {.lex_state = 133},
  [2455] = {.lex_state = 133},
  [2456] = {.lex_state = 130},
  [2457] = {.lex_state = 131},
  [2458] = {.lex_state = 133},
  [2459] = {.lex_state = 137},
  [2460] = {.lex_state = 133},
  [2461] = {.lex_state = 133},
  [2462] = {.lex_state = 137},
  [2463] = {.lex_state = 130},
  [2464] = {.lex_state = 133},
  [2465] = {.lex_state = 133},
  [2466] = {.lex_state = 124},
  [2467] = {.lex_state = 133},
  [2468] = {.lex_state = 124},
  [2469] = {.lex_state = 133},
  [2470] = {.lex_state = 133},
  [2471] = {.lex_state = 135},
  [2472] = {.lex_state = 133},
  [2473] = {.lex_state = 133},
  [2474] = {.lex_state = 133},
  [2475] = {.lex_state = 133},
  [2476] = {.lex_state = 133},
  [2477] = {.lex_state = 133},
  [2478] = {.lex_state = 133},
  [2479] = {.lex_state = 122},
  [2480] = {.lex_state = 133},
  [2481] = {.lex_state = 133},
  [2482] = {.lex_state = 124},
  [2483] = {.lex_state = 131},
  [2484] = {.lex_state = 133},
  [2485] = {.lex_state = 124},
  [2486] = {.lex_state = 133},
  [2487] = {.lex_state = 133},
  [2488] = {.lex_state = 130},
  [2489] = {.lex_state = 133},
  [2490] = {.lex_state = 133},
  [2491] = {.lex_state = 133},
  [2492] = {.lex_state = 122},
  [2493] = {.lex_state = 137},
  [2494] = {.lex_state = 137},
  [2495] = {.lex_state = 133},
  [2496] = {.lex_state = 124},
  [2497] = {.lex_state = 123},
  [2498] = {.lex_state = 133},
  [2499] = {.lex_state = 135},
  [2500] = {.lex_state = 133},
  [2501] = {.lex_state = 123},
  [2502] = {.lex_state = 133},
  [2503] = {.lex_state = 137},
  [2504] = {.lex_state = 137},
  [2505] = {.lex_state = 133},
  [2506] = {.lex_state = 130},
  [2507] = {.lex_state = 124},
  [2508] = {.lex_state = 131},
  [2509] = {.lex_state = 130},
  [2510] = {.lex_state = 130},
  [2511] = {.lex_state = 131},
  [2512] = {.lex_state = 130},
  [2513] = {.lex_state = 137},
  [2514] = {.lex_state = 137},
  [2515] = {.lex_state = 137},
  [2516] = {.lex_state = 137},
  [2517] = {.lex_state = 130},
  [2518] = {.lex_state = 130},
  [2519] = {.lex_state = 122},
  [2520] = {.lex_state = 124},
  [2521] = {.lex_state = 124},
  [2522] = {.lex_state = 124},
  [2523] = {.lex_state = 122},
  [2524] = {.lex_state = 135},
  [2525] = {.lex_state = 135},
  [2526] = {.lex_state = 137},
  [2527] = {.lex_state = 124},
  [2528] = {.lex_state = 137},
  [2529] = {.lex_state = 137},
  [2530] = {.lex_state = 137},
  [2531] = {.lex_state = 124},
  [2532] = {.lex_state = 124},
  [2533] = {.lex_state = 122},
  [2534] = {.lex_state = 137},
  [2535] = {.lex_state = 137},
  [2536] = {.lex_state = 137},
  [2537] = {.lex_state = 137},
  [2538] = {.lex_state = 137},
  [2539] = {.lex_state = 137},
  [2540] = {.lex_state = 137},
  [2541] = {.lex_state = 137},
  [2542] = {.lex_state = 137},
  [2543] = {.lex_state = 137},
  [2544] = {.lex_state = 122},
  [2545] = {.lex_state = 137},
  [2546] = {.lex_state = 124},
  [2547] = {.lex_state = 122},
  [2548] = {.lex_state = 124},
  [2549] = {.lex_state = 130},
  [2550] = {.lex_state = 130},
  [2551] = {.lex_state = 130},
  [2552] = {.lex_state = 130},
  [2553] = {.lex_state = 130},
  [2554] = {.lex_state = 130},
  [2555] = {.lex_state = 130},
  [2556] = {.lex_state = 130},
  [2557] = {.lex_state = 130},
  [2558] = {.lex_state = 130},
  [2559] = {.lex_state = 130},
  [2560] = {.lex_state = 130},
  [2561] = {.lex_state = 130},
  [2562] = {.lex_state = 130},
  [2563] = {.lex_state = 130},
  [2564] = {.lex_state = 124},
  [2565] = {.lex_state = 137},
  [2566] = {.lex_state = 137},
  [2567] = {.lex_state = 137},
  [2568] = {.lex_state = 137},
  [2569] = {.lex_state = 130},
  [2570] = {.lex_state = 137},
  [2571] = {.lex_state = 124},
  [2572] = {.lex_state = 140},
  [2573] = {.lex_state = 124},
  [2574] = {.lex_state = 124},
  [2575] = {.lex_state = 137},
  [2576] = {.lex_state = 135},
  [2577] = {.lex_state = 157},
  [2578] = {.lex_state = 124},
  [2579] = {.lex_state = 130},
  [2580] = {.lex_state = 124},
  [2581] = {.lex_state = 124},
  [2582] = {.lex_state = 130},
  [2583] = {.lex_state = 130},
  [2584] = {.lex_state = 130},
  [2585] = {.lex_state = 130},
  [2586] = {.lex_state = 124},
  [2587] = {.lex_state = 124},
  [2588] = {.lex_state = 124},
  [2589] = {.lex_state = 124},
  [2590] = {.lex_state = 135},
  [2591] = {.lex_state = 124},
  [2592] = {.lex_state = 124},
  [2593] = {.lex_state = 124},
  [2594] = {.lex_state = 124},
  [2595] = {.lex_state = 130},
  [2596] = {.lex_state = 124},
  [2597] = {.lex_state = 157},
  [2598] = {.lex_state = 124},
  [2599] = {.lex_state = 124},
  [2600] = {.lex_state = 130},
  [2601] = {.lex_state = 133},
  [2602] = {.lex_state = 122},
  [2603] = {.lex_state = 133},
  [2604] = {.lex_state = 130},
  [2605] = {.lex_state = 130},
  [2606] = {.lex_state = 137},
  [2607] = {.lex_state = 130},
  [2608] = {.lex_state = 135},
  [2609] = {.lex_state = 135},
  [2610] = {.lex_state = 135},
  [2611] = {.lex_state = 137},
  [2612] = {.lex_state = 137},
  [2613] = {.lex_state = 137},
  [2614] = {.lex_state = 137},
  [2615] = {.lex_state = 124},
  [2616] = {.lex_state = 130},
  [2617] = {.lex_state = 160},
  [2618] = {.lex_state = 130},
  [2619] = {.lex_state = 160},
  [2620] = {.lex_state = 122},
  [2621] = {.lex_state = 135},
  [2622] = {.lex_state = 124},
  [2623] = {.lex_state = 124},
  [2624] = {.lex_state = 131},
  [2625] = {.lex_state = 130},
  [2626] = {.lex_state = 130},
  [2627] = {.lex_state = 130},
  [2628] = {.lex_state = 160},
  [2629] = {.lex_state = 122},
  [2630] = {.lex_state = 130},
  [2631] = {.lex_state = 131},
  [2632] = {.lex_state = 157},
  [2633] = {.lex_state = 137},
  [2634] = {.lex_state = 124},
  [2635] = {.lex_state = 129},
  [2636] = {.lex_state = 133},
  [2637] = {.lex_state = 122},
  [2638] = {.lex_state = 133},
  [2639] = {.lex_state = 129},
  [2640] = {.lex_state = 133},
  [2641] = {.lex_state = 129},
  [2642] = {.lex_state = 133},
  [2643] = {.lex_state = 137},
  [2644] = {.lex_state = 129},
  [2645] = {.lex_state = 133},
  [2646] = {.lex_state = 133},
  [2647] = {.lex_state = 130},
  [2648] = {.lex_state = 130},
  [2649] = {.lex_state = 130},
  [2650] = {.lex_state = 130},
  [2651] = {.lex_state = 137},
  [2652] = {.lex_state = 130},
  [2653] = {.lex_state = 133},
  [2654] = {.lex_state = 129},
  [2655] = {.lex_state = 133},
  [2656] = {.lex_state = 133},
  [2657] = {.lex_state = 124},
  [2658] = {.lex_state = 130},
  [2659] = {.lex_state = 124},
  [2660] = {.lex_state = 125, .external_lex_state = 1},
  [2661] = {.lex_state = 124},
  [2662] = {.lex_state = 124},
  [2663] = {.lex_state = 129},
  [2664] = {.lex_state = 130},
  [2665] = {.lex_state = 124},
  [2666] = {.lex_state = 130},
  [2667] = {.lex_state = 124},
  [2668] = {.lex_state = 160},
  [2669] = {.lex_state = 130},
  [2670] = {.lex_state = 130},
  [2671] = {.lex_state = 130},
  [2672] = {.lex_state = 130},
  [2673] = {.lex_state = 137},
  [2674] = {.lex_state = 130},
  [2675] = {.lex_state = 124},
  [2676] = {.lex_state = 130},
  [2677] = {.lex_state = 130},
  [2678] = {.lex_state = 133},
  [2679] = {.lex_state = 124},
  [2680] = {.lex_state = 124},
  [2681] = {.lex_state = 124},
  [2682] = {.lex_state = 130},
  [2683] = {.lex_state = 130},
  [2684] = {.lex_state = 124},
  [2685] = {.lex_state = 124},
  [2686] = {.lex_state = 130},
  [2687] = {.lex_state = 130},
  [2688] = {.lex_state = 137},
  [2689] = {.lex_state = 124},
  [2690] = {.lex_state = 124},
  [2691] = {.lex_state = 124},
  [2692] = {.lex_state = 125, .external_lex_state = 1},
  [2693] = {.lex_state = 137},
  [2694] = {.lex_state = 137},
  [2695] = {.lex_state = 137},
  [2696] = {.lex_state = 137},
  [2697] = {.lex_state = 137},
  [2698] = {.lex_state = 124},
  [2699] = {.lex_state = 137},
  [2700] = {.lex_state = 124},
  [2701] = {.lex_state = 124},
  [2702] = {.lex_state = 124},
  [2703] = {.lex_state = 133},
  [2704] = {.lex_state = 130},
  [2705] = {.lex_state = 124},
  [2706] = {.lex_state = 124},
  [2707] = {.lex_state = 130},
  [2708] = {.lex_state = 124},
  [2709] = {.lex_state = 160},
  [2710] = {.lex_state = 130},
  [2711] = {.lex_state = 137},
  [2712] = {.lex_state = 137},
  [2713] = {.lex_state = 130},
  [2714] = {.lex_state = 137},
  [2715] = {.lex_state = 130},
  [2716] = {.lex_state = 137},
  [2717] = {.lex_state = 137},
  [2718] = {.lex_state = 137},
  [2719] = {.lex_state = 130},
  [2720] = {.lex_state = 130},
  [2721] = {.lex_state = 130},
  [2722] = {.lex_state = 130},
  [2723] = {.lex_state = 130},
  [2724] = {.lex_state = 137},
  [2725] = {.lex_state = 137},
  [2726] = {.lex_state = 130},
  [2727] = {.lex_state = 130},
  [2728] = {.lex_state = 130},
  [2729] = {.lex_state = 130},
  [2730] = {.lex_state = 130},
  [2731] = {.lex_state = 130},
  [2732] = {.lex_state = 130},
  [2733] = {.lex_state = 130},
  [2734] = {.lex_state = 130},
  [2735] = {.lex_state = 130},
  [2736] = {.lex_state = 137},
  [2737] = {.lex_state = 130},
  [2738] = {.lex_state = 130},
  [2739] = {.lex_state = 130},
  [2740] = {.lex_state = 137},
  [2741] = {.lex_state = 130},
  [2742] = {.lex_state = 137},
  [2743] = {.lex_state = 137},
  [2744] = {.lex_state = 137},
  [2745] = {.lex_state = 137},
  [2746] = {.lex_state = 157},
  [2747] = {.lex_state = 130},
  [2748] = {.lex_state = 130},
  [2749] = {.lex_state = 130},
  [2750] = {.lex_state = 124},
  [2751] = {.lex_state = 130},
  [2752] = {.lex_state = 124},
  [2753] = {.lex_state = 130},
  [2754] = {.lex_state = 124},
  [2755] = {.lex_state = 125, .external_lex_state = 1},
  [2756] = {.lex_state = 137},
  [2757] = {.lex_state = 137},
  [2758] = {.lex_state = 130},
  [2759] = {.lex_state = 133},
  [2760] = {.lex_state = 137},
  [2761] = {.lex_state = 133},
  [2762] = {.lex_state = 137},
  [2763] = {.lex_state = 137},
  [2764] = {.lex_state = 129},
  [2765] = {.lex_state = 137},
  [2766] = {.lex_state = 137},
  [2767] = {.lex_state = 124},
  [2768] = {.lex_state = 137},
  [2769] = {.lex_state = 137},
  [2770] = {.lex_state = 124},
  [2771] = {.lex_state = 137},
  [2772] = {.lex_state = 124},
  [2773] = {.lex_state = 135},
  [2774] = {.lex_state = 124},
  [2775] = {.lex_state = 124},
  [2776] = {.lex_state = 124},
  [2777] = {.lex_state = 124},
  [2778] = {.lex_state = 124},
  [2779] = {.lex_state = 137},
  [2780] = {.lex_state = 124},
  [2781] = {.lex_state = 124},
  [2782] = {.lex_state = 124},
  [2783] = {.lex_state = 124},
  [2784] = {.lex_state = 133},
  [2785] = {.lex_state = 124},
  [2786] = {.lex_state = 133},
  [2787] = {.lex_state = 133},
  [2788] = {.lex_state = 129},
  [2789] = {.lex_state = 133},
  [2790] = {.lex_state = 130},
  [2791] = {.lex_state = 130},
  [2792] = {.lex_state = 124},
  [2793] = {.lex_state = 124},
  [2794] = {.lex_state = 137},
  [2795] = {.lex_state = 137},
  [2796] = {.lex_state = 137},
  [2797] = {.lex_state = 124},
  [2798] = {.lex_state = 124},
  [2799] = {.lex_state = 124},
  [2800] = {.lex_state = 124},
  [2801] = {.lex_state = 133},
  [2802] = {.lex_state = 137},
  [2803] = {.lex_state = 133},
  [2804] = {.lex_state = 137},
  [2805] = {.lex_state = 137},
  [2806] = {.lex_state = 137},
  [2807] = {.lex_state = 133},
  [2808] = {.lex_state = 133},
  [2809] = {.lex_state = 137},
  [2810] = {.lex_state = 137},
  [2811] = {.lex_state = 124},
  [2812] = {.lex_state = 124},
  [2813] = {.lex_state = 124},
  [2814] = {.lex_state = 124},
  [2815] = {.lex_state = 124},
  [2816] = {.lex_state = 124},
  [2817] = {.lex_state = 124},
  [2818] = {.lex_state = 124},
  [2819] = {.lex_state = 124},
  [2820] = {.lex_state = 137},
  [2821] = {.lex_state = 124},
  [2822] = {.lex_state = 124},
  [2823] = {.lex_state = 124},
  [2824] = {.lex_state = 137},
  [2825] = {.lex_state = 137},
  [2826] = {.lex_state = 137},
  [2827] = {.lex_state = 137},
  [2828] = {.lex_state = 137},
  [2829] = {.lex_state = 130},
  [2830] = {.lex_state = 137},
  [2831] = {.lex_state = 124},
  [2832] = {.lex_state = 137},
  [2833] = {.lex_state = 124},
  [2834] = {.lex_state = 124},
  [2835] = {.lex_state = 130},
  [2836] = {.lex_state = 137},
  [2837] = {.lex_state = 137},
  [2838] = {.lex_state = 124},
  [2839] = {.lex_state = 124},
  [2840] = {.lex_state = 124},
  [2841] = {.lex_state = 124},
  [2842] = {.lex_state = 124},
  [2843] = {.lex_state = 124},
  [2844] = {.lex_state = 124},
  [2845] = {.lex_state = 130},
  [2846] = {.lex_state = 124},
  [2847] = {.lex_state = 137},
  [2848] = {.lex_state = 124},
  [2849] = {.lex_state = 130},
  [2850] = {.lex_state = 137},
  [2851] = {.lex_state = 137},
  [2852] = {.lex_state = 124},
  [2853] = {.lex_state = 124},
  [2854] = {.lex_state = 157},
  [2855] = {.lex_state = 124},
  [2856] = {.lex_state = 137},
  [2857] = {.lex_state = 130},
  [2858] = {.lex_state = 130},
  [2859] = {.lex_state = 160},
  [2860] = {.lex_state = 124},
  [2861] = {.lex_state = 137},
  [2862] = {.lex_state = 130},
  [2863] = {.lex_state = 160},
  [2864] = {.lex_state = 130},
  [2865] = {.lex_state = 130},
  [2866] = {.lex_state = 160},
  [2867] = {.lex_state = 124},
  [2868] = {.lex_state = 124},
  [2869] = {.lex_state = 160},
  [2870] = {.lex_state = 124},
  [2871] = {.lex_state = 137},
  [2872] = {.lex_state = 137},
  [2873] = {.lex_state = 130},
  [2874] = {.lex_state = 130},
  [2875] = {.lex_state = 137},
  [2876] = {.lex_state = 124},
  [2877] = {.lex_state = 130},
  [2878] = {.lex_state = 160},
  [2879] = {.lex_state = 124},
  [2880] = {.lex_state = 124},
  [2881] = {.lex_state = 124},
  [2882] = {.lex_state = 157},
  [2883] = {.lex_state = 137},
  [2884] = {.lex_state = 137},
  [2885] = {.lex_state = 137},
  [2886] = {.lex_state = 130},
  [2887] = {.lex_state = 130},
  [2888] = {.lex_state = 130},
  [2889] = {.lex_state = 130},
  [2890] = {.lex_state = 130},
  [2891] = {.lex_state = 130},
  [2892] = {.lex_state = 130},
  [2893] = {.lex_state = 130},
  [2894] = {.lex_state = 133},
  [2895] = {.lex_state = 130},
  [2896] = {.lex_state = 130},
  [2897] = {.lex_state = 130},
  [2898] = {.lex_state = 130},
  [2899] = {.lex_state = 137},
  [2900] = {.lex_state = 157},
  [2901] = {.lex_state = 137},
  [2902] = {.lex_state = 130},
  [2903] = {.lex_state = 130},
  [2904] = {.lex_state = 137},
  [2905] = {.lex_state = 137},
  [2906] = {.lex_state = 137},
  [2907] = {.lex_state = 137},
  [2908] = {.lex_state = 130},
  [2909] = {.lex_state = 130},
  [2910] = {.lex_state = 124},
  [2911] = {.lex_state = 124},
  [2912] = {.lex_state = 124},
  [2913] = {.lex_state = 137},
  [2914] = {.lex_state = 124},
  [2915] = {.lex_state = 130},
  [2916] = {.lex_state = 137},
  [2917] = {.lex_state = 137},
  [2918] = {.lex_state = 137},
  [2919] = {.lex_state = 137},
  [2920] = {.lex_state = 137},
  [2921] = {.lex_state = 137},
  [2922] = {.lex_state = 131},
  [2923] = {.lex_state = 137},
  [2924] = {.lex_state = 124},
  [2925] = {.lex_state = 130},
  [2926] = {.lex_state = 137},
  [2927] = {.lex_state = 157},
  [2928] = {.lex_state = 124},
  [2929] = {.lex_state = 142},
  [2930] = {.lex_state = 130},
  [2931] = {.lex_state = 157},
  [2932] = {.lex_state = 137},
  [2933] = {.lex_state = 137},
  [2934] = {.lex_state = 137},
  [2935] = {.lex_state = 130},
  [2936] = {.lex_state = 130},
  [2937] = {.lex_state = 137},
  [2938] = {.lex_state = 130},
  [2939] = {.lex_state = 130},
  [2940] = {.lex_state = 124},
  [2941] = {.lex_state = 160},
  [2942] = {.lex_state = 137},
  [2943] = {.lex_state = 130},
  [2944] = {.lex_state = 137},
  [2945] = {.lex_state = 124},
  [2946] = {.lex_state = 124},
  [2947] = {.lex_state = 124},
  [2948] = {.lex_state = 124},
  [2949] = {.lex_state = 137},
  [2950] = {.lex_state = 124},
  [2951] = {.lex_state = 130},
  [2952] = {.lex_state = 124},
  [2953] = {.lex_state = 130},
  [2954] = {.lex_state = 124},
  [2955] = {.lex_state = 130},
  [2956] = {.lex_state = 130},
  [2957] = {.lex_state = 137},
  [2958] = {.lex_state = 124},
  [2959] = {.lex_state = 137},
  [2960] = {.lex_state = 130},
  [2961] = {.lex_state = 137},
  [2962] = {.lex_state = 160},
  [2963] = {.lex_state = 157},
  [2964] = {.lex_state = 124},
  [2965] = {.lex_state = 160},
  [2966] = {.lex_state = 124},
  [2967] = {.lex_state = 124},
  [2968] = {.lex_state = 157},
  [2969] = {.lex_state = 160},
  [2970] = {.lex_state = 157},
  [2971] = {.lex_state = 160},
  [2972] = {.lex_state = 125, .external_lex_state = 1},
  [2973] = {.lex_state = 160},
  [2974] = {.lex_state = 160},
  [2975] = {.lex_state = 160},
  [2976] = {.lex_state = 160},
  [2977] = {.lex_state = 125, .external_lex_state = 1},
  [2978] = {.lex_state = 158},
  [2979] = {.lex_state = 160},
  [2980] = {.lex_state = 160},
  [2981] = {.lex_state = 133},
  [2982] = {.lex_state = 160},
  [2983] = {.lex_state = 157},
  [2984] = {.lex_state = 158},
  [2985] = {.lex_state = 160},
  [2986] = {.lex_state = 158},
  [2987] = {.lex_state = 160},
  [2988] = {.lex_state = 160},
  [2989] = {.lex_state = 160},
  [2990] = {.lex_state = 157},
  [2991] = {.lex_state = 160},
  [2992] = {.lex_state = 160},
  [2993] = {.lex_state = 160},
  [2994] = {.lex_state = 160},
  [2995] = {.lex_state = 160},
  [2996] = {.lex_state = 157},
  [2997] = {.lex_state = 160},
  [2998] = {.lex_state = 157},
  [2999] = {.lex_state = 160},
  [3000] = {.lex_state = 157},
  [3001] = {.lex_state = 157},
  [3002] = {.lex_state = 157},
  [3003] = {.lex_state = 157},
  [3004] = {.lex_state = 157},
  [3005] = {.lex_state = 157},
  [3006] = {.lex_state = 157},
  [3007] = {.lex_state = 157},
  [3008] = {.lex_state = 157},
  [3009] = {.lex_state = 157},
  [3010] = {.lex_state = 157},
  [3011] = {.lex_state = 157},
  [3012] = {.lex_state = 160},
  [3013] = {.lex_state = 157},
  [3014] = {.lex_state = 157},
  [3015] = {.lex_state = 157},
  [3016] = {.lex_state = 158},
  [3017] = {.lex_state = 157},
  [3018] = {.lex_state = 142},
  [3019] = {.lex_state = 160},
  [3020] = {.lex_state = 160},
  [3021] = {.lex_state = 160},
  [3022] = {.lex_state = 142},
  [3023] = {.lex_state = 126, .external_lex_state = 1},
  [3024] = {.lex_state = 147},
  [3025] = {.lex_state = 157},
  [3026] = {.lex_state = 142},
  [3027] = {.lex_state = 157},
  [3028] = {.lex_state = 127, .external_lex_state = 1},
  [3029] = {.lex_state = 157},
  [3030] = {.lex_state = 148},
  [3031] = {.lex_state = 127, .external_lex_state = 1},
  [3032] = {.lex_state = 157},
  [3033] = {.lex_state = 157},
  [3034] = {.lex_state = 128, .external_lex_state = 1},
  [3035] = {.lex_state = 157},
  [3036] = {.lex_state = 126, .external_lex_state = 1},
  [3037] = {.lex_state = 157},
  [3038] = {.lex_state = 127, .external_lex_state = 1},
  [3039] = {.lex_state = 157},
  [3040] = {.lex_state = 157},
  [3041] = {.lex_state = 157},
  [3042] = {.lex_state = 158},
  [3043] = {.lex_state = 157},
  [3044] = {.lex_state = 147},
  [3045] = {.lex_state = 157},
  [3046] = {.lex_state = 148},
  [3047] = {.lex_state = 157},
  [3048] = {.lex_state = 157},
  [3049] = {.lex_state = 157},
  [3050] = {.lex_state = 142},
  [3051] = {.lex_state = 142},
  [3052] = {.lex_state = 157},
  [3053] = {.lex_state = 157},
  [3054] = {.lex_state = 128, .external_lex_state = 1},
  [3055] = {.lex_state = 128, .external_lex_state = 1},
  [3056] = {.lex_state = 126, .external_lex_state = 1},
  [3057] = {.lex_state = 144},
  [3058] = {.lex_state = 157},
  [3059] = {.lex_state = 157},
  [3060] = {.lex_state = 158},
  [3061] = {.lex_state = 144},
  [3062] = {.lex_state = 147},
  [3063] = {.lex_state = 157},
  [3064] = {.lex_state = 144},
  [3065] = {.lex_state = 157},
  [3066] = {.lex_state = 144},
  [3067] = {.lex_state = 160},
  [3068] = {.lex_state = 144},
  [3069] = {.lex_state = 147},
  [3070] = {.lex_state = 148},
  [3071] = {.lex_state = 144},
  [3072] = {.lex_state = 148},
  [3073] = {.lex_state = 144},
  [3074] = {.lex_state = 144},
  [3075] = {.lex_state = 148},
  [3076] = {.lex_state = 144},
  [3077] = {.lex_state = 141},
  [3078] = {.lex_state = 157},
  [3079] = {.lex_state = 157},
  [3080] = {.lex_state = 141},
  [3081] = {.lex_state = 142},
  [3082] = {.lex_state = 148},
  [3083] = {.lex_state = 157},
  [3084] = {.lex_state = 148},
  [3085] = {.lex_state = 148},
  [3086] = {.lex_state = 147},
  [3087] = {.lex_state = 147},
  [3088] = {.lex_state = 147},
  [3089] = {.lex_state = 147},
  [3090] = {.lex_state = 141},
  [3091] = {.lex_state = 157},
  [3092] = {.lex_state = 144},
  [3093] = {.lex_state = 141},
  [3094] = {.lex_state = 128, .external_lex_state = 1},
  [3095] = {.lex_state = 144},
  [3096] = {.lex_state = 157},
  [3097] = {.lex_state = 140},
  [3098] = {.lex_state = 157},
  [3099] = {.lex_state = 157},
  [3100] = {.lex_state = 146},
  [3101] = {.lex_state = 157},
  [3102] = {.lex_state = 144},
  [3103] = {.lex_state = 142},
  [3104] = {.lex_state = 144},
  [3105] = {.lex_state = 128, .external_lex_state = 1},
  [3106] = {.lex_state = 157},
  [3107] = {.lex_state = 144},
  [3108] = {.lex_state = 157},
  [3109] = {.lex_state = 159},
  [3110] = {.lex_state = 157},
  [3111] = {.lex_state = 144},
  [3112] = {.lex_state = 159},
  [3113] = {.lex_state = 157},
  [3114] = {.lex_state = 157},
  [3115] = {.lex_state = 157},
  [3116] = {.lex_state = 157},
  [3117] = {.lex_state = 144},
  [3118] = {.lex_state = 144},
  [3119] = {.lex_state = 157},
  [3120] = {.lex_state = 144},
  [3121] = {.lex_state = 144},
  [3122] = {.lex_state = 144},
  [3123] = {.lex_state = 157},
  [3124] = {.lex_state = 126, .external_lex_state = 1},
  [3125] = {.lex_state = 157},
  [3126] = {.lex_state = 157},
  [3127] = {.lex_state = 157},
  [3128] = {.lex_state = 145},
  [3129] = {.lex_state = 127, .external_lex_state = 1},
  [3130] = {.lex_state = 144},
  [3131] = {.lex_state = 144},
  [3132] = {.lex_state = 144},
  [3133] = {.lex_state = 157},
  [3134] = {.lex_state = 144},
  [3135] = {.lex_state = 157},
  [3136] = {.lex_state = 157},
  [3137] = {.lex_state = 157},
  [3138] = {.lex_state = 157},
  [3139] = {.lex_state = 157},
  [3140] = {.lex_state = 157},
  [3141] = {.lex_state = 157},
  [3142] = {.lex_state = 126, .external_lex_state = 1},
  [3143] = {.lex_state = 144},
  [3144] = {.lex_state = 127, .external_lex_state = 1},
  [3145] = {.lex_state = 144},
  [3146] = {.lex_state = 144},
  [3147] = {.lex_state = 146},
  [3148] = {.lex_state = 146},
  [3149] = {.lex_state = 145},
  [3150] = {.lex_state = 148},
  [3151] = {.lex_state = 144},
  [3152] = {.lex_state = 119, .external_lex_state = 1},
  [3153] = {.lex_state = 146},
  [3154] = {.lex_state = 146},
  [3155] = {.lex_state = 146},
  [3156] = {.lex_state = 146},
  [3157] = {.lex_state = 146},
  [3158] = {.lex_state = 146},
  [3159] = {.lex_state = 146},
  [3160] = {.lex_state = 140},
  [3161] = {.lex_state = 146},
  [3162] = {.lex_state = 146},
  [3163] = {.lex_state = 145},
  [3164] = {.lex_state = 143},
  [3165] = {.lex_state = 157},
  [3166] = {.lex_state = 119, .external_lex_state = 1},
  [3167] = {.lex_state = 146},
  [3168] = {.lex_state = 140},
  [3169] = {.lex_state = 119, .external_lex_state = 1},
  [3170] = {.lex_state = 119, .external_lex_state = 1},
  [3171] = {.lex_state = 144},
  [3172] = {.lex_state = 140},
  [3173] = {.lex_state = 144},
  [3174] = {.lex_state = 140},
  [3175] = {.lex_state = 144},
  [3176] = {.lex_state = 145},
  [3177] = {.lex_state = 145},
  [3178] = {.lex_state = 160},
  [3179] = {.lex_state = 144},
  [3180] = {.lex_state = 145},
  [3181] = {.lex_state = 145},
  [3182] = {.lex_state = 119, .external_lex_state = 1},
  [3183] = {.lex_state = 119, .external_lex_state = 1},
  [3184] = {.lex_state = 145},
  [3185] = {.lex_state = 140},
  [3186] = {.lex_state = 140},
  [3187] = {.lex_state = 144},
  [3188] = {.lex_state = 145},
  [3189] = {.lex_state = 119, .external_lex_state = 1},
  [3190] = {.lex_state = 145},
  [3191] = {.lex_state = 144},
  [3192] = {.lex_state = 145},
  [3193] = {.lex_state = 147},
  [3194] = {.lex_state = 145},
  [3195] = {.lex_state = 144},
  [3196] = {.lex_state = 145},
  [3197] = {.lex_state = 145},
  [3198] = {.lex_state = 146},
  [3199] = {.lex_state = 119, .external_lex_state = 1},
  [3200] = {.lex_state = 129},
  [3201] = {.lex_state = 157},
  [3202] = {.lex_state = 119, .external_lex_state = 1},
  [3203] = {.lex_state = 148},
  [3204] = {.lex_state = 144},
  [3205] = {.lex_state = 144},
  [3206] = {.lex_state = 144},
  [3207] = {.lex_state = 148},
  [3208] = {.lex_state = 157},
  [3209] = {.lex_state = 144},
  [3210] = {.lex_state = 144},
  [3211] = {.lex_state = 144},
  [3212] = {.lex_state = 157},
  [3213] = {.lex_state = 144},
  [3214] = {.lex_state = 144},
  [3215] = {.lex_state = 129},
  [3216] = {.lex_state = 147},
  [3217] = {.lex_state = 157},
  [3218] = {.lex_state = 144},
  [3219] = {.lex_state = 148},
  [3220] = {.lex_state = 148},
  [3221] = {.lex_state = 129},
  [3222] = {.lex_state = 157},
  [3223] = {.lex_state = 147},
  [3224] = {.lex_state = 144},
  [3225] = {.lex_state = 144},
  [3226] = {.lex_state = 157},
  [3227] = {.lex_state = 129},
  [3228] = {.lex_state = 144},
  [3229] = {.lex_state = 144},
  [3230] = {.lex_state = 143},
  [3231] = {.lex_state = 144},
  [3232] = {.lex_state = 139},
  [3233] = {.lex_state = 157},
  [3234] = {.lex_state = 144},
  [3235] = {.lex_state = 144},
  [3236] = {.lex_state = 144},
  [3237] = {.lex_state = 157},
  [3238] = {.lex_state = 144},
  [3239] = {.lex_state = 144},
  [3240] = {.lex_state = 143},
  [3241] = {.lex_state = 144},
  [3242] = {.lex_state = 157},
  [3243] = {.lex_state = 144},
  [3244] = {.lex_state = 148},
  [3245] = {.lex_state = 139},
  [3246] = {.lex_state = 144},
  [3247] = {.lex_state = 144},
  [3248] = {.lex_state = 148},
  [3249] = {.lex_state = 129},
  [3250] = {.lex_state = 157},
  [3251] = {.lex_state = 144},
  [3252] = {.lex_state = 157},
  [3253] = {.lex_state = 157},
  [3254] = {.lex_state = 147},
  [3255] = {.lex_state = 157},
  [3256] = {.lex_state = 144},
  [3257] = {.lex_state = 144},
  [3258] = {.lex_state = 144},
  [3259] = {.lex_state = 144},
  [3260] = {.lex_state = 147},
  [3261] = {.lex_state = 147},
  [3262] = {.lex_state = 144},
  [3263] = {.lex_state = 147},
  [3264] = {.lex_state = 144},
  [3265] = {.lex_state = 144},
  [3266] = {.lex_state = 139},
  [3267] = {.lex_state = 147},
  [3268] = {.lex_state = 157},
  [3269] = {.lex_state = 157},
  [3270] = {.lex_state = 144},
  [3271] = {.lex_state = 157},
  [3272] = {.lex_state = 147},
  [3273] = {.lex_state = 147},
  [3274] = {.lex_state = 147},
  [3275] = {.lex_state = 139},
  [3276] = {.lex_state = 144},
  [3277] = {.lex_state = 147},
  [3278] = {.lex_state = 144},
  [3279] = {.lex_state = 144},
  [3280] = {.lex_state = 157},
  [3281] = {.lex_state = 144},
  [3282] = {.lex_state = 147},
  [3283] = {.lex_state = 119, .external_lex_state = 1},
  [3284] = {.lex_state = 144},
  [3285] = {.lex_state = 144},
  [3286] = {.lex_state = 144},
  [3287] = {.lex_state = 144},
  [3288] = {.lex_state = 144},
  [3289] = {.lex_state = 157},
  [3290] = {.lex_state = 157},
  [3291] = {.lex_state = 144},
  [3292] = {.lex_state = 147},
  [3293] = {.lex_state = 129},
  [3294] = {.lex_state = 144},
  [3295] = {.lex_state = 139},
  [3296] = {.lex_state = 140},
  [3297] = {.lex_state = 148},
  [3298] = {.lex_state = 139},
  [3299] = {.lex_state = 144},
  [3300] = {.lex_state = 148},
  [3301] = {.lex_state = 144},
  [3302] = {.lex_state = 144},
  [3303] = {.lex_state = 144},
  [3304] = {.lex_state = 144},
  [3305] = {.lex_state = 144},
  [3306] = {.lex_state = 144},
  [3307] = {.lex_state = 144},
  [3308] = {.lex_state = 139},
  [3309] = {.lex_state = 157},
  [3310] = {.lex_state = 144},
  [3311] = {.lex_state = 144},
  [3312] = {.lex_state = 139},
  [3313] = {.lex_state = 144},
  [3314] = {.lex_state = 139},
  [3315] = {.lex_state = 144},
  [3316] = {.lex_state = 144},
  [3317] = {.lex_state = 140},
  [3318] = {.lex_state = 144},
  [3319] = {.lex_state = 144},
  [3320] = {.lex_state = 127},
  [3321] = {.lex_state = 139},
  [3322] = {.lex_state = 144},
  [3323] = {.lex_state = 147},
  [3324] = {.lex_state = 144},
  [3325] = {.lex_state = 147},
  [3326] = {.lex_state = 144},
  [3327] = {.lex_state = 144},
  [3328] = {.lex_state = 144},
  [3329] = {.lex_state = 140},
  [3330] = {.lex_state = 139},
  [3331] = {.lex_state = 139},
  [3332] = {.lex_state = 147},
  [3333] = {.lex_state = 139},
  [3334] = {.lex_state = 144},
  [3335] = {.lex_state = 139},
  [3336] = {.lex_state = 148},
  [3337] = {.lex_state = 144},
  [3338] = {.lex_state = 144},
  [3339] = {.lex_state = 144},
  [3340] = {.lex_state = 144},
  [3341] = {.lex_state = 139},
  [3342] = {.lex_state = 144},
  [3343] = {.lex_state = 144},
  [3344] = {.lex_state = 157},
  [3345] = {.lex_state = 144},
  [3346] = {.lex_state = 144},
  [3347] = {.lex_state = 139},
  [3348] = {.lex_state = 139},
  [3349] = {.lex_state = 144},
  [3350] = {.lex_state = 147},
  [3351] = {.lex_state = 139},
  [3352] = {.lex_state = 144},
  [3353] = {.lex_state = 139},
  [3354] = {.lex_state = 144},
  [3355] = {.lex_state = 147},
  [3356] = {.lex_state = 139},
  [3357] = {.lex_state = 144},
  [3358] = {.lex_state = 144},
  [3359] = {.lex_state = 128},
  [3360] = {.lex_state = 144},
  [3361] = {.lex_state = 148},
  [3362] = {.lex_state = 128},
  [3363] = {.lex_state = 147},
  [3364] = {.lex_state = 148},
  [3365] = {.lex_state = 147},
  [3366] = {.lex_state = 139},
  [3367] = {.lex_state = 127},
  [3368] = {.lex_state = 144},
  [3369] = {.lex_state = 147},
  [3370] = {.lex_state = 144},
  [3371] = {.lex_state = 144},
  [3372] = {.lex_state = 144},
  [3373] = {.lex_state = 144},
  [3374] = {.lex_state = 144},
  [3375] = {.lex_state = 157},
  [3376] = {.lex_state = 148},
  [3377] = {.lex_state = 144},
  [3378] = {.lex_state = 144},
  [3379] = {.lex_state = 144},
  [3380] = {.lex_state = 144},
  [3381] = {.lex_state = 157},
  [3382] = {.lex_state = 147},
  [3383] = {.lex_state = 144},
  [3384] = {.lex_state = 148},
  [3385] = {.lex_state = 139},
  [3386] = {.lex_state = 128},
  [3387] = {.lex_state = 144},
  [3388] = {.lex_state = 144},
  [3389] = {.lex_state = 144},
  [3390] = {.lex_state = 139},
  [3391] = {.lex_state = 144},
  [3392] = {.lex_state = 144},
  [3393] = {.lex_state = 144},
  [3394] = {.lex_state = 144},
  [3395] = {.lex_state = 144},
  [3396] = {.lex_state = 144},
  [3397] = {.lex_state = 144},
  [3398] = {.lex_state = 147},
  [3399] = {.lex_state = 144},
  [3400] = {.lex_state = 144},
  [3401] = {.lex_state = 144},
  [3402] = {.lex_state = 144},
  [3403] = {.lex_state = 147},
  [3404] = {.lex_state = 144},
  [3405] = {.lex_state = 144},
  [3406] = {.lex_state = 148},
  [3407] = {.lex_state = 139},
  [3408] = {.lex_state = 148},
  [3409] = {.lex_state = 160},
  [3410] = {.lex_state = 144},
  [3411] = {.lex_state = 139},
  [3412] = {.lex_state = 144},
  [3413] = {.lex_state = 144},
  [3414] = {.lex_state = 147},
  [3415] = {.lex_state = 148},
  [3416] = {.lex_state = 147},
  [3417] = {.lex_state = 144},
  [3418] = {.lex_state = 144},
  [3419] = {.lex_state = 144},
  [3420] = {.lex_state = 144},
  [3421] = {.lex_state = 144},
  [3422] = {.lex_state = 144},
  [3423] = {.lex_state = 147},
  [3424] = {.lex_state = 144},
  [3425] = {.lex_state = 157},
  [3426] = {.lex_state = 147},
  [3427] = {.lex_state = 148},
  [3428] = {.lex_state = 147},
  [3429] = {.lex_state = 147},
  [3430] = {.lex_state = 147},
  [3431] = {.lex_state = 160},
  [3432] = {.lex_state = 147},
  [3433] = {.lex_state = 139},
  [3434] = {.lex_state = 144},
  [3435] = {.lex_state = 148},
  [3436] = {.lex_state = 160},
  [3437] = {.lex_state = 144},
  [3438] = {.lex_state = 144},
  [3439] = {.lex_state = 144},
  [3440] = {.lex_state = 144},
  [3441] = {.lex_state = 144},
  [3442] = {.lex_state = 144},
  [3443] = {.lex_state = 148},
  [3444] = {.lex_state = 144},
  [3445] = {.lex_state = 144},
  [3446] = {.lex_state = 144},
  [3447] = {.lex_state = 144},
  [3448] = {.lex_state = 139},
  [3449] = {.lex_state = 148},
  [3450] = {.lex_state = 147},
  [3451] = {.lex_state = 144},
  [3452] = {.lex_state = 144},
  [3453] = {.lex_state = 144},
  [3454] = {.lex_state = 160},
  [3455] = {.lex_state = 148},
  [3456] = {.lex_state = 144},
  [3457] = {.lex_state = 139},
  [3458] = {.lex_state = 144},
  [3459] = {.lex_state = 160},
  [3460] = {.lex_state = 144},
  [3461] = {.lex_state = 144},
  [3462] = {.lex_state = 148},
  [3463] = {.lex_state = 144},
  [3464] = {.lex_state = 144},
  [3465] = {.lex_state = 144},
  [3466] = {.lex_state = 139},
  [3467] = {.lex_state = 139},
  [3468] = {.lex_state = 144},
  [3469] = {.lex_state = 144},
  [3470] = {.lex_state = 144},
  [3471] = {.lex_state = 139},
  [3472] = {.lex_state = 144},
  [3473] = {.lex_state = 147},
  [3474] = {.lex_state = 144},
  [3475] = {.lex_state = 144},
  [3476] = {.lex_state = 144},
  [3477] = {.lex_state = 160},
  [3478] = {.lex_state = 144},
  [3479] = {.lex_state = 144},
  [3480] = {.lex_state = 144},
  [3481] = {.lex_state = 144},
  [3482] = {.lex_state = 139},
  [3483] = {.lex_state = 157},
  [3484] = {.lex_state = 144},
  [3485] = {.lex_state = 139},
  [3486] = {.lex_state = 144},
  [3487] = {.lex_state = 144},
  [3488] = {.lex_state = 144},
  [3489] = {.lex_state = 148},
  [3490] = {.lex_state = 148},
  [3491] = {.lex_state = 148},
  [3492] = {.lex_state = 144},
  [3493] = {.lex_state = 148},
  [3494] = {.lex_state = 128},
  [3495] = {.lex_state = 148},
  [3496] = {.lex_state = 148},
  [3497] = {.lex_state = 144},
  [3498] = {.lex_state = 144},
  [3499] = {.lex_state = 127},
  [3500] = {.lex_state = 147},
  [3501] = {.lex_state = 144},
  [3502] = {.lex_state = 148},
  [3503] = {.lex_state = 148},
  [3504] = {.lex_state = 147},
  [3505] = {.lex_state = 148},
  [3506] = {.lex_state = 144},
  [3507] = {.lex_state = 147},
  [3508] = {.lex_state = 144},
  [3509] = {.lex_state = 144},
  [3510] = {.lex_state = 139},
  [3511] = {.lex_state = 148},
  [3512] = {.lex_state = 139},
  [3513] = {.lex_state = 139},
  [3514] = {.lex_state = 144},
  [3515] = {.lex_state = 144},
  [3516] = {.lex_state = 148},
  [3517] = {.lex_state = 139},
  [3518] = {.lex_state = 139},
  [3519] = {.lex_state = 144},
  [3520] = {.lex_state = 144},
  [3521] = {.lex_state = 148},
  [3522] = {.lex_state = 147},
  [3523] = {.lex_state = 139},
  [3524] = {.lex_state = 144},
  [3525] = {.lex_state = 139},
  [3526] = {.lex_state = 144},
  [3527] = {.lex_state = 147},
  [3528] = {.lex_state = 139},
  [3529] = {.lex_state = 144},
  [3530] = {.lex_state = 147},
  [3531] = {.lex_state = 160},
  [3532] = {.lex_state = 144},
  [3533] = {.lex_state = 139},
  [3534] = {.lex_state = 139},
  [3535] = {.lex_state = 129},
  [3536] = {.lex_state = 139},
  [3537] = {.lex_state = 159},
  [3538] = {.lex_state = 147},
  [3539] = {.lex_state = 144},
  [3540] = {.lex_state = 147},
  [3541] = {.lex_state = 129},
  [3542] = {.lex_state = 144},
  [3543] = {.lex_state = 144},
  [3544] = {.lex_state = 139},
  [3545] = {.lex_state = 160},
  [3546] = {.lex_state = 144},
  [3547] = {.lex_state = 144},
  [3548] = {.lex_state = 144},
  [3549] = {.lex_state = 127},
  [3550] = {.lex_state = 148},
  [3551] = {.lex_state = 144},
  [3552] = {.lex_state = 144},
  [3553] = {.lex_state = 147},
  [3554] = {.lex_state = 139},
  [3555] = {.lex_state = 139},
  [3556] = {.lex_state = 139},
  [3557] = {.lex_state = 147},
  [3558] = {.lex_state = 144},
  [3559] = {.lex_state = 144},
  [3560] = {.lex_state = 148},
  [3561] = {.lex_state = 148},
  [3562] = {.lex_state = 144},
  [3563] = {.lex_state = 139},
  [3564] = {.lex_state = 139},
  [3565] = {.lex_state = 144},
  [3566] = {.lex_state = 139},
  [3567] = {.lex_state = 144},
  [3568] = {.lex_state = 144},
  [3569] = {.lex_state = 144},
  [3570] = {.lex_state = 144},
  [3571] = {.lex_state = 144},
  [3572] = {.lex_state = 144},
  [3573] = {.lex_state = 140},
  [3574] = {.lex_state = 144},
  [3575] = {.lex_state = 144},
  [3576] = {.lex_state = 144},
  [3577] = {.lex_state = 144},
  [3578] = {.lex_state = 144},
  [3579] = {.lex_state = 144},
  [3580] = {.lex_state = 144},
  [3581] = {.lex_state = 144},
  [3582] = {.lex_state = 144},
  [3583] = {.lex_state = 144},
  [3584] = {.lex_state = 144},
  [3585] = {.lex_state = 144},
  [3586] = {.lex_state = 144},
  [3587] = {.lex_state = 159},
  [3588] = {.lex_state = 144},
  [3589] = {.lex_state = 144},
  [3590] = {.lex_state = 144},
  [3591] = {.lex_state = 144},
  [3592] = {.lex_state = 144},
  [3593] = {.lex_state = 144},
  [3594] = {.lex_state = 144},
  [3595] = {.lex_state = 144},
  [3596] = {.lex_state = 144},
  [3597] = {.lex_state = 130},
  [3598] = {.lex_state = 144},
  [3599] = {.lex_state = 144},
  [3600] = {.lex_state = 144},
  [3601] = {.lex_state = 144},
  [3602] = {.lex_state = 139},
  [3603] = {.lex_state = 147},
  [3604] = {.lex_state = 148},
  [3605] = {.lex_state = 144},
  [3606] = {.lex_state = 148},
  [3607] = {.lex_state = 148},
  [3608] = {.lex_state = 144},
  [3609] = {.lex_state = 148},
  [3610] = {.lex_state = 148},
  [3611] = {.lex_state = 144},
  [3612] = {.lex_state = 144},
  [3613] = {.lex_state = 144},
  [3614] = {.lex_state = 144},
  [3615] = {.lex_state = 144},
  [3616] = {.lex_state = 144},
  [3617] = {.lex_state = 144},
  [3618] = {.lex_state = 158},
  [3619] = {.lex_state = 144},
  [3620] = {.lex_state = 139},
  [3621] = {.lex_state = 144},
  [3622] = {.lex_state = 144},
  [3623] = {.lex_state = 144},
  [3624] = {.lex_state = 147},
  [3625] = {.lex_state = 144},
  [3626] = {.lex_state = 144},
  [3627] = {.lex_state = 144},
  [3628] = {.lex_state = 148},
  [3629] = {.lex_state = 148},
  [3630] = {.lex_state = 148},
  [3631] = {.lex_state = 148},
  [3632] = {.lex_state = 144},
  [3633] = {.lex_state = 148},
  [3634] = {.lex_state = 148},
  [3635] = {.lex_state = 148},
  [3636] = {.lex_state = 148},
  [3637] = {.lex_state = 148},
  [3638] = {.lex_state = 148},
  [3639] = {.lex_state = 148},
  [3640] = {.lex_state = 144},
  [3641] = {.lex_state = 144},
  [3642] = {.lex_state = 144},
  [3643] = {.lex_state = 148},
  [3644] = {.lex_state = 144},
  [3645] = {.lex_state = 140},
  [3646] = {.lex_state = 144},
  [3647] = {.lex_state = 144},
  [3648] = {.lex_state = 144},
  [3649] = {.lex_state = 144},
  [3650] = {.lex_state = 160},
  [3651] = {.lex_state = 139},
  [3652] = {.lex_state = 157},
  [3653] = {.lex_state = 144},
  [3654] = {.lex_state = 144},
  [3655] = {.lex_state = 144},
  [3656] = {.lex_state = 144},
  [3657] = {.lex_state = 144},
  [3658] = {.lex_state = 144},
  [3659] = {.lex_state = 144},
  [3660] = {.lex_state = 148},
  [3661] = {.lex_state = 144},
  [3662] = {.lex_state = 157},
  [3663] = {.lex_state = 147},
  [3664] = {.lex_state = 148},
  [3665] = {.lex_state = 148},
  [3666] = {.lex_state = 144},
  [3667] = {.lex_state = 148},
  [3668] = {.lex_state = 144},
  [3669] = {.lex_state = 148},
  [3670] = {.lex_state = 148},
  [3671] = {.lex_state = 144},
  [3672] = {.lex_state = 148},
  [3673] = {.lex_state = 144},
  [3674] = {.lex_state = 148},
  [3675] = {.lex_state = 144},
  [3676] = {.lex_state = 148},
  [3677] = {.lex_state = 148},
  [3678] = {.lex_state = 144},
  [3679] = {.lex_state = 144},
  [3680] = {.lex_state = 148},
  [3681] = {.lex_state = 148},
  [3682] = {.lex_state = 148},
  [3683] = {.lex_state = 144},
  [3684] = {.lex_state = 144},
  [3685] = {.lex_state = 148},
  [3686] = {.lex_state = 144},
  [3687] = {.lex_state = 144},
  [3688] = {.lex_state = 148},
  [3689] = {.lex_state = 144},
  [3690] = {.lex_state = 144},
  [3691] = {.lex_state = 144},
  [3692] = {.lex_state = 144},
  [3693] = {.lex_state = 144},
  [3694] = {.lex_state = 144},
  [3695] = {.lex_state = 144},
  [3696] = {.lex_state = 144},
  [3697] = {.lex_state = 157},
  [3698] = {.lex_state = 144},
  [3699] = {.lex_state = 144},
  [3700] = {.lex_state = 144},
  [3701] = {.lex_state = 144},
  [3702] = {.lex_state = 144},
  [3703] = {.lex_state = 160},
  [3704] = {.lex_state = 144},
  [3705] = {.lex_state = 144},
  [3706] = {.lex_state = 144},
  [3707] = {.lex_state = 144},
  [3708] = {.lex_state = 144},
  [3709] = {.lex_state = 144},
  [3710] = {.lex_state = 144},
  [3711] = {.lex_state = 144},
  [3712] = {.lex_state = 144},
  [3713] = {.lex_state = 144},
  [3714] = {.lex_state = 144},
  [3715] = {.lex_state = 144},
  [3716] = {.lex_state = 144},
  [3717] = {.lex_state = 144},
  [3718] = {.lex_state = 144},
  [3719] = {.lex_state = 144},
  [3720] = {.lex_state = 144},
  [3721] = {.lex_state = 144},
  [3722] = {.lex_state = 144},
  [3723] = {.lex_state = 144},
  [3724] = {.lex_state = 144},
  [3725] = {.lex_state = 144},
  [3726] = {.lex_state = 144},
  [3727] = {.lex_state = 130},
  [3728] = {.lex_state = 144},
  [3729] = {.lex_state = 144},
  [3730] = {.lex_state = 144},
  [3731] = {.lex_state = 144},
  [3732] = {.lex_state = 148},
  [3733] = {.lex_state = 148},
  [3734] = {.lex_state = 148},
  [3735] = {.lex_state = 148},
  [3736] = {.lex_state = 148},
  [3737] = {.lex_state = 144},
  [3738] = {.lex_state = 148},
  [3739] = {.lex_state = 148},
  [3740] = {.lex_state = 148},
  [3741] = {.lex_state = 148},
  [3742] = {.lex_state = 148},
  [3743] = {.lex_state = 144},
  [3744] = {.lex_state = 144},
  [3745] = {.lex_state = 144},
  [3746] = {.lex_state = 144},
  [3747] = {.lex_state = 144},
  [3748] = {.lex_state = 144},
  [3749] = {.lex_state = 147},
  [3750] = {.lex_state = 144},
  [3751] = {.lex_state = 148},
  [3752] = {.lex_state = 144},
  [3753] = {.lex_state = 148},
  [3754] = {.lex_state = 144},
  [3755] = {.lex_state = 144},
  [3756] = {.lex_state = 144},
  [3757] = {.lex_state = 144},
  [3758] = {.lex_state = 144},
  [3759] = {.lex_state = 144},
  [3760] = {.lex_state = 144},
  [3761] = {.lex_state = 144},
  [3762] = {.lex_state = 144},
  [3763] = {.lex_state = 144},
  [3764] = {.lex_state = 144},
  [3765] = {.lex_state = 144},
  [3766] = {.lex_state = 148},
  [3767] = {.lex_state = 144},
  [3768] = {.lex_state = 144},
  [3769] = {.lex_state = 148},
  [3770] = {.lex_state = 144},
  [3771] = {.lex_state = 148},
  [3772] = {.lex_state = 148},
  [3773] = {.lex_state = 144},
  [3774] = {.lex_state = 144},
  [3775] = {.lex_state = 148},
  [3776] = {.lex_state = 157},
  [3777] = {.lex_state = 147},
  [3778] = {.lex_state = 144},
  [3779] = {.lex_state = 144},
  [3780] = {.lex_state = 144},
  [3781] = {.lex_state = 144},
  [3782] = {.lex_state = 144},
  [3783] = {.lex_state = 144},
  [3784] = {.lex_state = 144},
  [3785] = {.lex_state = 144},
  [3786] = {.lex_state = 144},
  [3787] = {.lex_state = 148},
  [3788] = {.lex_state = 144},
  [3789] = {.lex_state = 144},
  [3790] = {.lex_state = 157},
  [3791] = {.lex_state = 147},
  [3792] = {.lex_state = 139},
  [3793] = {.lex_state = 139},
  [3794] = {.lex_state = 147},
  [3795] = {.lex_state = 157},
  [3796] = {.lex_state = 139},
  [3797] = {.lex_state = 139},
  [3798] = {.lex_state = 148},
  [3799] = {.lex_state = 148},
  [3800] = {.lex_state = 157},
  [3801] = {.lex_state = 147},
  [3802] = {.lex_state = 139},
  [3803] = {.lex_state = 148},
  [3804] = {.lex_state = 139},
  [3805] = {.lex_state = 157},
  [3806] = {.lex_state = 139},
  [3807] = {.lex_state = 148},
  [3808] = {.lex_state = 148},
  [3809] = {.lex_state = 139},
  [3810] = {.lex_state = 144},
  [3811] = {.lex_state = 139},
  [3812] = {.lex_state = 139},
  [3813] = {.lex_state = 148},
  [3814] = {.lex_state = 147},
  [3815] = {.lex_state = 157},
  [3816] = {.lex_state = 139},
  [3817] = {.lex_state = 148},
  [3818] = {.lex_state = 147},
  [3819] = {.lex_state = 139},
  [3820] = {.lex_state = 157},
  [3821] = {.lex_state = 147},
  [3822] = {.lex_state = 148},
  [3823] = {.lex_state = 147},
  [3824] = {.lex_state = 147},
  [3825] = {.lex_state = 148},
  [3826] = {.lex_state = 144},
  [3827] = {.lex_state = 139},
  [3828] = {.lex_state = 139},
  [3829] = {.lex_state = 147},
  [3830] = {.lex_state = 148},
  [3831] = {.lex_state = 148},
  [3832] = {.lex_state = 147},
  [3833] = {.lex_state = 148},
  [3834] = {.lex_state = 130},
  [3835] = {.lex_state = 148},
  [3836] = {.lex_state = 148},
  [3837] = {.lex_state = 148},
  [3838] = {.lex_state = 157},
  [3839] = {.lex_state = 139},
  [3840] = {.lex_state = 144},
  [3841] = {.lex_state = 139},
  [3842] = {.lex_state = 148},
  [3843] = {.lex_state = 144},
  [3844] = {.lex_state = 148},
  [3845] = {.lex_state = 144},
  [3846] = {.lex_state = 147},
  [3847] = {.lex_state = 139},
  [3848] = {.lex_state = 147},
  [3849] = {.lex_state = 158},
  [3850] = {.lex_state = 148},
  [3851] = {.lex_state = 148},
  [3852] = {.lex_state = 148},
  [3853] = {.lex_state = 147},
  [3854] = {.lex_state = 148},
  [3855] = {.lex_state = 157},
  [3856] = {.lex_state = 143},
  [3857] = {.lex_state = 148},
  [3858] = {.lex_state = 148},
  [3859] = {.lex_state = 148},
  [3860] = {.lex_state = 139},
  [3861] = {.lex_state = 139},
  [3862] = {.lex_state = 139},
  [3863] = {.lex_state = 147},
  [3864] = {.lex_state = 147},
  [3865] = {.lex_state = 147},
  [3866] = {.lex_state = 139},
  [3867] = {.lex_state = 139},
  [3868] = {.lex_state = 148},
  [3869] = {.lex_state = 148},
  [3870] = {.lex_state = 148},
  [3871] = {.lex_state = 147},
  [3872] = {.lex_state = 139},
  [3873] = {.lex_state = 147},
  [3874] = {.lex_state = 143},
  [3875] = {.lex_state = 148},
  [3876] = {.lex_state = 139},
  [3877] = {.lex_state = 147},
  [3878] = {.lex_state = 148},
  [3879] = {.lex_state = 139},
  [3880] = {.lex_state = 147},
  [3881] = {.lex_state = 148},
  [3882] = {.lex_state = 139},
  [3883] = {.lex_state = 139},
  [3884] = {.lex_state = 147},
  [3885] = {.lex_state = 147},
  [3886] = {.lex_state = 139},
  [3887] = {.lex_state = 148},
  [3888] = {.lex_state = 147},
  [3889] = {.lex_state = 147},
  [3890] = {.lex_state = 147},
  [3891] = {.lex_state = 144},
  [3892] = {.lex_state = 147},
  [3893] = {.lex_state = 147},
  [3894] = {.lex_state = 139},
  [3895] = {.lex_state = 139},
  [3896] = {.lex_state = 147},
  [3897] = {.lex_state = 147},
  [3898] = {.lex_state = 148},
  [3899] = {.lex_state = 129},
  [3900] = {.lex_state = 139},
  [3901] = {.lex_state = 140},
  [3902] = {.lex_state = 160},
  [3903] = {.lex_state = 160},
  [3904] = {.lex_state = 144},
  [3905] = {.lex_state = 160},
  [3906] = {.lex_state = 160},
  [3907] = {.lex_state = 160},
  [3908] = {.lex_state = 140},
  [3909] = {.lex_state = 144},
  [3910] = {.lex_state = 160},
  [3911] = {.lex_state = 160},
  [3912] = {.lex_state = 160},
  [3913] = {.lex_state = 144},
  [3914] = {.lex_state = 144},
  [3915] = {.lex_state = 157},
  [3916] = {.lex_state = 160},
  [3917] = {.lex_state = 160},
  [3918] = {.lex_state = 144},
  [3919] = {.lex_state = 160},
  [3920] = {.lex_state = 160},
  [3921] = {.lex_state = 160},
  [3922] = {.lex_state = 160},
  [3923] = {.lex_state = 144},
  [3924] = {.lex_state = 140},
  [3925] = {.lex_state = 140},
  [3926] = {.lex_state = 160},
  [3927] = {.lex_state = 160},
  [3928] = {.lex_state = 144},
  [3929] = {.lex_state = 144},
  [3930] = {.lex_state = 144},
  [3931] = {.lex_state = 144},
  [3932] = {.lex_state = 144},
  [3933] = {.lex_state = 144},
  [3934] = {.lex_state = 160},
  [3935] = {.lex_state = 157},
  [3936] = {.lex_state = 144},
  [3937] = {.lex_state = 157},
  [3938] = {.lex_state = 160},
  [3939] = {.lex_state = 144},
  [3940] = {.lex_state = 160},
  [3941] = {.lex_state = 144},
  [3942] = {.lex_state = 160},
  [3943] = {.lex_state = 144},
  [3944] = {.lex_state = 144},
  [3945] = {.lex_state = 144},
  [3946] = {.lex_state = 144},
  [3947] = {.lex_state = 158},
  [3948] = {.lex_state = 130},
  [3949] = {.lex_state = 144},
  [3950] = {.lex_state = 144},
  [3951] = {.lex_state = 144},
  [3952] = {.lex_state = 144},
  [3953] = {.lex_state = 144},
  [3954] = {.lex_state = 130},
  [3955] = {.lex_state = 130},
  [3956] = {.lex_state = 144},
  [3957] = {.lex_state = 144},
  [3958] = {.lex_state = 143},
  [3959] = {.lex_state = 144},
  [3960] = {.lex_state = 130},
  [3961] = {.lex_state = 144},
  [3962] = {.lex_state = 130},
  [3963] = {.lex_state = 144},
  [3964] = {.lex_state = 143},
  [3965] = {.lex_state = 144},
  [3966] = {.lex_state = 144},
  [3967] = {.lex_state = 144},
  [3968] = {.lex_state = 130},
  [3969] = {.lex_state = 130},
  [3970] = {.lex_state = 130},
  [3971] = {.lex_state = 144},
  [3972] = {.lex_state = 144},
  [3973] = {.lex_state = 143},
  [3974] = {.lex_state = 144},
  [3975] = {.lex_state = 129},
  [3976] = {.lex_state = 143},
  [3977] = {.lex_state = 160},
  [3978] = {.lex_state = 143},
  [3979] = {.lex_state = 160},
  [3980] = {.lex_state = 143},
  [3981] = {.lex_state = 160},
  [3982] = {.lex_state = 160},
  [3983] = {.lex_state = 160},
  [3984] = {.lex_state = 157},
  [3985] = {.lex_state = 160},
  [3986] = {.lex_state = 160},
  [3987] = {.lex_state = 160},
  [3988] = {.lex_state = 143},
  [3989] = {.lex_state = 160},
  [3990] = {.lex_state = 129},
  [3991] = {.lex_state = 160},
  [3992] = {.lex_state = 129},
  [3993] = {.lex_state = 140},
  [3994] = {.lex_state = 143},
  [3995] = {.lex_state = 143},
  [3996] = {.lex_state = 160},
  [3997] = {.lex_state = 160},
  [3998] = {.lex_state = 160},
  [3999] = {.lex_state = 160},
  [4000] = {.lex_state = 160},
  [4001] = {.lex_state = 144},
  [4002] = {.lex_state = 129},
  [4003] = {.lex_state = 160},
  [4004] = {.lex_state = 160},
  [4005] = {.lex_state = 160},
  [4006] = {.lex_state = 160},
  [4007] = {.lex_state = 143},
  [4008] = {.lex_state = 143},
  [4009] = {.lex_state = 160},
  [4010] = {.lex_state = 143},
  [4011] = {.lex_state = 160},
  [4012] = {.lex_state = 160},
  [4013] = {.lex_state = 160},
  [4014] = {.lex_state = 129},
  [4015] = {.lex_state = 143},
  [4016] = {.lex_state = 129},
  [4017] = {.lex_state = 160},
  [4018] = {.lex_state = 160},
  [4019] = {.lex_state = 144},
  [4020] = {.lex_state = 160},
  [4021] = {.lex_state = 160},
  [4022] = {.lex_state = 129},
  [4023] = {.lex_state = 143},
  [4024] = {.lex_state = 160},
  [4025] = {.lex_state = 160},
  [4026] = {.lex_state = 160},
  [4027] = {.lex_state = 160},
  [4028] = {.lex_state = 143},
  [4029] = {.lex_state = 160},
  [4030] = {.lex_state = 143},
  [4031] = {.lex_state = 143},
  [4032] = {.lex_state = 160},
  [4033] = {.lex_state = 160},
  [4034] = {.lex_state = 160},
  [4035] = {.lex_state = 160},
  [4036] = {.lex_state = 160},
  [4037] = {.lex_state = 160},
  [4038] = {.lex_state = 157},
  [4039] = {.lex_state = 129},
  [4040] = {.lex_state = 143},
  [4041] = {.lex_state = 143},
  [4042] = {.lex_state = 160},
  [4043] = {.lex_state = 160},
  [4044] = {.lex_state = 129},
  [4045] = {.lex_state = 160},
  [4046] = {.lex_state = 143},
  [4047] = {.lex_state = 143},
  [4048] = {.lex_state = 160},
  [4049] = {.lex_state = 143},
  [4050] = {.lex_state = 160},
  [4051] = {.lex_state = 160},
  [4052] = {.lex_state = 160},
  [4053] = {.lex_state = 129},
  [4054] = {.lex_state = 129},
  [4055] = {.lex_state = 143},
  [4056] = {.lex_state = 129},
  [4057] = {.lex_state = 157},
  [4058] = {.lex_state = 157},
  [4059] = {.lex_state = 157},
  [4060] = {.lex_state = 157},
  [4061] = {.lex_state = 157},
  [4062] = {.lex_state = 157},
  [4063] = {.lex_state = 157},
  [4064] = {.lex_state = 157},
  [4065] = {.lex_state = 143},
  [4066] = {.lex_state = 157},
  [4067] = {.lex_state = 157},
  [4068] = {.lex_state = 157},
  [4069] = {.lex_state = 157},
  [4070] = {.lex_state = 157},
  [4071] = {.lex_state = 157},
  [4072] = {.lex_state = 157},
  [4073] = {.lex_state = 157},
  [4074] = {.lex_state = 157},
  [4075] = {.lex_state = 157},
  [4076] = {.lex_state = 157},
  [4077] = {.lex_state = 157},
  [4078] = {.lex_state = 157},
  [4079] = {.lex_state = 157},
  [4080] = {.lex_state = 157},
  [4081] = {.lex_state = 157},
  [4082] = {.lex_state = 157},
  [4083] = {.lex_state = 157},
  [4084] = {.lex_state = 157},
  [4085] = {.lex_state = 144},
  [4086] = {.lex_state = 157},
  [4087] = {.lex_state = 157},
  [4088] = {.lex_state = 157},
  [4089] = {.lex_state = 157},
  [4090] = {.lex_state = 157},
  [4091] = {.lex_state = 157},
  [4092] = {.lex_state = 157},
  [4093] = {.lex_state = 157},
  [4094] = {.lex_state = 144},
  [4095] = {.lex_state = 157},
  [4096] = {.lex_state = 157},
  [4097] = {.lex_state = 157},
  [4098] = {.lex_state = 157},
  [4099] = {.lex_state = 157},
  [4100] = {.lex_state = 144},
  [4101] = {.lex_state = 144},
  [4102] = {.lex_state = 157},
  [4103] = {.lex_state = 157},
  [4104] = {.lex_state = 157},
  [4105] = {.lex_state = 157},
  [4106] = {.lex_state = 144},
  [4107] = {.lex_state = 157},
  [4108] = {.lex_state = 157},
  [4109] = {.lex_state = 144},
  [4110] = {.lex_state = 144},
  [4111] = {.lex_state = 157},
  [4112] = {.lex_state = 144},
  [4113] = {.lex_state = 157},
  [4114] = {.lex_state = 157},
  [4115] = {.lex_state = 157},
  [4116] = {.lex_state = 157},
  [4117] = {.lex_state = 157},
  [4118] = {.lex_state = 157},
  [4119] = {.lex_state = 157},
  [4120] = {.lex_state = 157},
  [4121] = {.lex_state = 157},
  [4122] = {.lex_state = 144},
  [4123] = {.lex_state = 157},
  [4124] = {.lex_state = 157},
  [4125] = {.lex_state = 157},
  [4126] = {.lex_state = 157},
  [4127] = {.lex_state = 157},
  [4128] = {.lex_state = 157},
  [4129] = {.lex_state = 157},
  [4130] = {.lex_state = 157},
  [4131] = {.lex_state = 157},
  [4132] = {.lex_state = 157},
  [4133] = {.lex_state = 157},
  [4134] = {.lex_state = 157},
  [4135] = {.lex_state = 157},
  [4136] = {.lex_state = 157},
  [4137] = {.lex_state = 157},
  [4138] = {.lex_state = 157},
  [4139] = {.lex_state = 157},
  [4140] = {.lex_state = 157},
  [4141] = {.lex_state = 157},
  [4142] = {.lex_state = 157},
  [4143] = {.lex_state = 157},
  [4144] = {.lex_state = 157},
  [4145] = {.lex_state = 157},
  [4146] = {.lex_state = 130},
  [4147] = {.lex_state = 144},
  [4148] = {.lex_state = 144},
  [4149] = {.lex_state = 160},
  [4150] = {.lex_state = 160},
  [4151] = {.lex_state = 144},
  [4152] = {.lex_state = 144},
  [4153] = {.lex_state = 144},
  [4154] = {.lex_state = 144},
  [4155] = {.lex_state = 144},
  [4156] = {.lex_state = 144},
  [4157] = {.lex_state = 144},
  [4158] = {.lex_state = 130},
  [4159] = {.lex_state = 144},
  [4160] = {.lex_state = 160},
  [4161] = {.lex_state = 130},
  [4162] = {.lex_state = 130},
  [4163] = {.lex_state = 158},
  [4164] = {.lex_state = 160},
  [4165] = {.lex_state = 130},
  [4166] = {.lex_state = 129},
  [4167] = {.lex_state = 140},
  [4168] = {.lex_state = 120},
  [4169] = {.lex_state = 129},
  [4170] = {.lex_state = 120},
  [4171] = {.lex_state = 55},
  [4172] = {.lex_state = 129},
  [4173] = {.lex_state = 129},
  [4174] = {.lex_state = 120},
  [4175] = {.lex_state = 120},
  [4176] = {.lex_state = 129},
  [4177] = {.lex_state = 129},
  [4178] = {.lex_state = 129},
  [4179] = {.lex_state = 129},
  [4180] = {.lex_state = 129},
  [4181] = {.lex_state = 129},
  [4182] = {.lex_state = 120},
  [4183] = {.lex_state = 129},
  [4184] = {.lex_state = 129},
  [4185] = {.lex_state = 129},
  [4186] = {.lex_state = 120},
  [4187] = {.lex_state = 129},
  [4188] = {.lex_state = 120},
  [4189] = {.lex_state = 129},
  [4190] = {.lex_state = 129},
  [4191] = {.lex_state = 129},
  [4192] = {.lex_state = 120},
  [4193] = {.lex_state = 120},
  [4194] = {.lex_state = 129},
  [4195] = {.lex_state = 120},
  [4196] = {.lex_state = 120},
  [4197] = {.lex_state = 120},
  [4198] = {.lex_state = 120},
  [4199] = {.lex_state = 120},
  [4200] = {.lex_state = 120},
  [4201] = {.lex_state = 129},
  [4202] = {.lex_state = 120},
  [4203] = {.lex_state = 129},
  [4204] = {.lex_state = 120},
  [4205] = {.lex_state = 120},
  [4206] = {.lex_state = 120},
  [4207] = {.lex_state = 120},
  [4208] = {.lex_state = 120},
  [4209] = {.lex_state = 120},
  [4210] = {.lex_state = 120},
  [4211] = {.lex_state = 120},
  [4212] = {.lex_state = 120},
  [4213] = {.lex_state = 120},
  [4214] = {.lex_state = 120},
  [4215] = {.lex_state = 120},
  [4216] = {.lex_state = 142},
  [4217] = {.lex_state = 120},
  [4218] = {.lex_state = 120},
  [4219] = {.lex_state = 129},
  [4220] = {.lex_state = 129},
  [4221] = {.lex_state = 129},
  [4222] = {.lex_state = 129},
  [4223] = {.lex_state = 129},
  [4224] = {.lex_state = 120},
  [4225] = {.lex_state = 129},
  [4226] = {.lex_state = 160},
  [4227] = {.lex_state = 120},
  [4228] = {.lex_state = 160},
  [4229] = {.lex_state = 120},
  [4230] = {.lex_state = 120},
  [4231] = {.lex_state = 140},
  [4232] = {.lex_state = 120},
  [4233] = {.lex_state = 129},
  [4234] = {.lex_state = 120},
  [4235] = {.lex_state = 55},
  [4236] = {.lex_state = 55},
  [4237] = {.lex_state = 55},
  [4238] = {.lex_state = 55},
  [4239] = {.lex_state = 55},
  [4240] = {.lex_state = 55},
  [4241] = {.lex_state = 55},
  [4242] = {.lex_state = 55},
  [4243] = {.lex_state = 55},
  [4244] = {.lex_state = 55},
  [4245] = {.lex_state = 129},
  [4246] = {.lex_state = 55},
  [4247] = {.lex_state = 55},
  [4248] = {.lex_state = 55},
  [4249] = {.lex_state = 55},
  [4250] = {.lex_state = 55},
  [4251] = {.lex_state = 55},
  [4252] = {.lex_state = 55},
  [4253] = {.lex_state = 55},
  [4254] = {.lex_state = 55},
  [4255] = {.lex_state = 55},
  [4256] = {.lex_state = 55},
  [4257] = {.lex_state = 55},
  [4258] = {.lex_state = 55},
  [4259] = {.lex_state = 55},
  [4260] = {.lex_state = 55},
  [4261] = {.lex_state = 55},
  [4262] = {.lex_state = 55},
  [4263] = {.lex_state = 129},
  [4264] = {.lex_state = 55},
  [4265] = {.lex_state = 160},
  [4266] = {.lex_state = 160},
  [4267] = {.lex_state = 160},
  [4268] = {.lex_state = 160},
  [4269] = {.lex_state = 160},
  [4270] = {.lex_state = 160},
  [4271] = {.lex_state = 160},
  [4272] = {.lex_state = 160},
  [4273] = {.lex_state = 160},
  [4274] = {.lex_state = 160},
  [4275] = {.lex_state = 160},
  [4276] = {.lex_state = 160},
  [4277] = {.lex_state = 160},
  [4278] = {.lex_state = 160},
  [4279] = {.lex_state = 160},
  [4280] = {.lex_state = 160},
  [4281] = {.lex_state = 160},
  [4282] = {.lex_state = 160},
  [4283] = {.lex_state = 160},
  [4284] = {.lex_state = 160},
  [4285] = {.lex_state = 160},
  [4286] = {.lex_state = 160},
  [4287] = {.lex_state = 160},
  [4288] = {.lex_state = 160},
  [4289] = {.lex_state = 160},
  [4290] = {.lex_state = 160},
  [4291] = {.lex_state = 160},
  [4292] = {.lex_state = 160},
  [4293] = {.lex_state = 160},
  [4294] = {.lex_state = 160},
  [4295] = {.lex_state = 160},
  [4296] = {.lex_state = 160},
  [4297] = {.lex_state = 160},
  [4298] = {.lex_state = 160},
  [4299] = {.lex_state = 160},
  [4300] = {.lex_state = 160},
  [4301] = {.lex_state = 160},
  [4302] = {.lex_state = 160},
  [4303] = {.lex_state = 160},
  [4304] = {.lex_state = 160},
  [4305] = {.lex_state = 160},
  [4306] = {.lex_state = 160},
  [4307] = {.lex_state = 160},
  [4308] = {.lex_state = 160},
  [4309] = {.lex_state = 160},
  [4310] = {.lex_state = 160},
  [4311] = {.lex_state = 160},
  [4312] = {.lex_state = 160},
  [4313] = {.lex_state = 160},
  [4314] = {.lex_state = 160},
  [4315] = {.lex_state = 160},
  [4316] = {.lex_state = 160},
  [4317] = {.lex_state = 160},
  [4318] = {.lex_state = 160},
  [4319] = {.lex_state = 160},
  [4320] = {.lex_state = 160},
  [4321] = {.lex_state = 160},
  [4322] = {.lex_state = 160},
  [4323] = {.lex_state = 118},
  [4324] = {.lex_state = 144},
  [4325] = {.lex_state = 144},
  [4326] = {.lex_state = 144},
  [4327] = {.lex_state = 144},
  [4328] = {.lex_state = 144},
  [4329] = {.lex_state = 144},
  [4330] = {.lex_state = 118},
  [4331] = {.lex_state = 144},
  [4332] = {.lex_state = 118},
  [4333] = {.lex_state = 144},
  [4334] = {.lex_state = 118},
  [4335] = {.lex_state = 144},
  [4336] = {.lex_state = 118},
  [4337] = {.lex_state = 118},
  [4338] = {.lex_state = 144},
  [4339] = {.lex_state = 144},
  [4340] = {.lex_state = 144},
  [4341] = {.lex_state = 118},
  [4342] = {.lex_state = 118},
  [4343] = {.lex_state = 160},
  [4344] = {.lex_state = 160},
  [4345] = {.lex_state = 160},
  [4346] = {.lex_state = 160},
  [4347] = {.lex_state = 160},
  [4348] = {.lex_state = 160},
  [4349] = {.lex_state = 160},
  [4350] = {.lex_state = 160},
  [4351] = {.lex_state = 160},
  [4352] = {.lex_state = 160},
  [4353] = {.lex_state = 160},
  [4354] = {.lex_state = 160},
  [4355] = {.lex_state = 160},
  [4356] = {.lex_state = 160},
  [4357] = {.lex_state = 160},
  [4358] = {.lex_state = 160},
  [4359] = {.lex_state = 160},
  [4360] = {.lex_state = 160},
  [4361] = {.lex_state = 160},
  [4362] = {.lex_state = 160},
  [4363] = {.lex_state = 160},
  [4364] = {.lex_state = 160},
  [4365] = {.lex_state = 160},
  [4366] = {.lex_state = 160},
  [4367] = {.lex_state = 160},
  [4368] = {.lex_state = 160},
  [4369] = {.lex_state = 160},
  [4370] = {.lex_state = 160},
  [4371] = {.lex_state = 160},
  [4372] = {.lex_state = 160},
  [4373] = {.lex_state = 160},
  [4374] = {.lex_state = 160},
  [4375] = {.lex_state = 160},
  [4376] = {.lex_state = 160},
  [4377] = {.lex_state = 160},
  [4378] = {.lex_state = 160},
  [4379] = {.lex_state = 160},
  [4380] = {.lex_state = 160},
  [4381] = {.lex_state = 160},
  [4382] = {.lex_state = 160},
  [4383] = {.lex_state = 160},
  [4384] = {.lex_state = 160},
  [4385] = {.lex_state = 160},
  [4386] = {.lex_state = 160},
  [4387] = {.lex_state = 160},
  [4388] = {.lex_state = 160},
  [4389] = {.lex_state = 160},
  [4390] = {.lex_state = 160},
  [4391] = {.lex_state = 107},
  [4392] = {.lex_state = 107},
  [4393] = {.lex_state = 107},
  [4394] = {.lex_state = 118},
  [4395] = {.lex_state = 107},
  [4396] = {.lex_state = 107},
  [4397] = {.lex_state = 107},
  [4398] = {.lex_state = 107},
  [4399] = {.lex_state = 107},
  [4400] = {.lex_state = 107},
  [4401] = {.lex_state = 118},
  [4402] = {.lex_state = 107},
  [4403] = {.lex_state = 107},
  [4404] = {.lex_state = 107},
  [4405] = {.lex_state = 107},
  [4406] = {.lex_state = 118},
  [4407] = {.lex_state = 107},
  [4408] = {.lex_state = 107},
  [4409] = {.lex_state = 107},
  [4410] = {.lex_state = 118},
  [4411] = {.lex_state = 118},
  [4412] = {.lex_state = 118},
  [4413] = {.lex_state = 118},
  [4414] = {.lex_state = 118},
  [4415] = {.lex_state = 144},
  [4416] = {.lex_state = 118},
  [4417] = {.lex_state = 118},
  [4418] = {.lex_state = 160},
  [4419] = {.lex_state = 118},
  [4420] = {.lex_state = 144},
  [4421] = {.lex_state = 118},
  [4422] = {.lex_state = 118},
  [4423] = {.lex_state = 118},
  [4424] = {.lex_state = 160},
  [4425] = {.lex_state = 118},
  [4426] = {.lex_state = 118},
  [4427] = {.lex_state = 160},
  [4428] = {.lex_state = 118},
  [4429] = {.lex_state = 160},
  [4430] = {.lex_state = 160},
  [4431] = {.lex_state = 160},
  [4432] = {.lex_state = 160},
  [4433] = {.lex_state = 160},
  [4434] = {.lex_state = 160},
  [4435] = {.lex_state = 144},
  [4436] = {.lex_state = 160},
  [4437] = {.lex_state = 160},
  [4438] = {.lex_state = 144},
  [4439] = {.lex_state = 118},
  [4440] = {.lex_state = 118},
  [4441] = {.lex_state = 118},
  [4442] = {.lex_state = 144},
  [4443] = {.lex_state = 160},
  [4444] = {.lex_state = 160},
  [4445] = {.lex_state = 160},
  [4446] = {.lex_state = 144},
  [4447] = {.lex_state = 118},
  [4448] = {.lex_state = 160},
  [4449] = {.lex_state = 160},
  [4450] = {.lex_state = 118},
  [4451] = {.lex_state = 144},
  [4452] = {.lex_state = 118},
  [4453] = {.lex_state = 118},
  [4454] = {.lex_state = 160},
  [4455] = {.lex_state = 160},
  [4456] = {.lex_state = 144},
  [4457] = {.lex_state = 144},
  [4458] = {.lex_state = 160},
  [4459] = {.lex_state = 118},
  [4460] = {.lex_state = 160},
  [4461] = {.lex_state = 144},
  [4462] = {.lex_state = 144},
  [4463] = {.lex_state = 144},
  [4464] = {.lex_state = 160},
  [4465] = {.lex_state = 160},
  [4466] = {.lex_state = 144},
  [4467] = {.lex_state = 160},
  [4468] = {.lex_state = 118},
  [4469] = {.lex_state = 160},
  [4470] = {.lex_state = 160},
  [4471] = {.lex_state = 160},
  [4472] = {.lex_state = 160},
  [4473] = {.lex_state = 160},
  [4474] = {.lex_state = 160},
  [4475] = {.lex_state = 160},
  [4476] = {.lex_state = 144},
  [4477] = {.lex_state = 160},
  [4478] = {.lex_state = 118},
  [4479] = {.lex_state = 118},
  [4480] = {.lex_state = 160},
  [4481] = {.lex_state = 144},
  [4482] = {.lex_state = 144},
  [4483] = {.lex_state = 160},
  [4484] = {.lex_state = 160},
  [4485] = {.lex_state = 118},
  [4486] = {.lex_state = 144},
  [4487] = {.lex_state = 160},
  [4488] = {.lex_state = 118},
  [4489] = {.lex_state = 160},
  [4490] = {.lex_state = 144},
  [4491] = {.lex_state = 160},
  [4492] = {.lex_state = 118},
  [4493] = {.lex_state = 118},
  [4494] = {.lex_state = 144},
  [4495] = {.lex_state = 160},
  [4496] = {.lex_state = 159},
  [4497] = {.lex_state = 159},
  [4498] = {.lex_state = 159},
  [4499] = {.lex_state = 160},
  [4500] = {.lex_state = 160},
  [4501] = {.lex_state = 118},
  [4502] = {.lex_state = 160},
  [4503] = {.lex_state = 160},
  [4504] = {.lex_state = 118},
  [4505] = {.lex_state = 118},
  [4506] = {.lex_state = 160},
  [4507] = {.lex_state = 160},
  [4508] = {.lex_state = 160},
  [4509] = {.lex_state = 160},
  [4510] = {.lex_state = 160},
  [4511] = {.lex_state = 160},
  [4512] = {.lex_state = 118},
  [4513] = {.lex_state = 160},
  [4514] = {.lex_state = 160},
  [4515] = {.lex_state = 160},
  [4516] = {.lex_state = 159},
  [4517] = {.lex_state = 160},
  [4518] = {.lex_state = 144},
  [4519] = {.lex_state = 160},
  [4520] = {.lex_state = 143},
  [4521] = {.lex_state = 144},
  [4522] = {.lex_state = 149},
  [4523] = {.lex_state = 144},
  [4524] = {.lex_state = 143},
  [4525] = {.lex_state = 149},
  [4526] = {.lex_state = 143},
  [4527] = {.lex_state = 0, .external_lex_state = 1},
  [4528] = {.lex_state = 0, .external_lex_state = 1},
  [4529] = {.lex_state = 160},
  [4530] = {.lex_state = 144},
  [4531] = {.lex_state = 160},
  [4532] = {.lex_state = 149},
  [4533] = {.lex_state = 144},
  [4534] = {.lex_state = 144},
  [4535] = {.lex_state = 143},
  [4536] = {.lex_state = 118},
  [4537] = {.lex_state = 160},
  [4538] = {.lex_state = 160},
  [4539] = {.lex_state = 159},
  [4540] = {.lex_state = 143},
  [4541] = {.lex_state = 160},
  [4542] = {.lex_state = 0, .external_lex_state = 1},
  [4543] = {.lex_state = 160},
  [4544] = {.lex_state = 0, .external_lex_state = 1},
  [4545] = {.lex_state = 144},
  [4546] = {.lex_state = 149},
  [4547] = {.lex_state = 144},
  [4548] = {.lex_state = 144},
  [4549] = {.lex_state = 143},
  [4550] = {.lex_state = 118},
  [4551] = {.lex_state = 0, .external_lex_state = 1},
  [4552] = {.lex_state = 118},
  [4553] = {.lex_state = 0, .external_lex_state = 1},
  [4554] = {.lex_state = 143},
  [4555] = {.lex_state = 160},
  [4556] = {.lex_state = 0, .external_lex_state = 1},
  [4557] = {.lex_state = 143},
  [4558] = {.lex_state = 118},
  [4559] = {.lex_state = 160},
  [4560] = {.lex_state = 160},
  [4561] = {.lex_state = 144},
  [4562] = {.lex_state = 144},
  [4563] = {.lex_state = 160},
  [4564] = {.lex_state = 160},
  [4565] = {.lex_state = 160},
  [4566] = {.lex_state = 160},
  [4567] = {.lex_state = 160},
  [4568] = {.lex_state = 144},
  [4569] = {.lex_state = 0, .external_lex_state = 1},
  [4570] = {.lex_state = 160},
  [4571] = {.lex_state = 144},
  [4572] = {.lex_state = 144},
  [4573] = {.lex_state = 118},
  [4574] = {.lex_state = 160},
  [4575] = {.lex_state = 144},
  [4576] = {.lex_state = 144},
  [4577] = {.lex_state = 144},
  [4578] = {.lex_state = 144},
  [4579] = {.lex_state = 144},
  [4580] = {.lex_state = 160},
  [4581] = {.lex_state = 144},
  [4582] = {.lex_state = 160},
  [4583] = {.lex_state = 0, .external_lex_state = 1},
  [4584] = {.lex_state = 0, .external_lex_state = 1},
  [4585] = {.lex_state = 144},
  [4586] = {.lex_state = 160},
  [4587] = {.lex_state = 160},
  [4588] = {.lex_state = 118},
  [4589] = {.lex_state = 144},
  [4590] = {.lex_state = 144},
  [4591] = {.lex_state = 160},
  [4592] = {.lex_state = 144},
  [4593] = {.lex_state = 144},
  [4594] = {.lex_state = 160},
  [4595] = {.lex_state = 0, .external_lex_state = 1},
  [4596] = {.lex_state = 144},
  [4597] = {.lex_state = 160},
  [4598] = {.lex_state = 144},
  [4599] = {.lex_state = 0, .external_lex_state = 1},
  [4600] = {.lex_state = 144},
  [4601] = {.lex_state = 0, .external_lex_state = 1},
  [4602] = {.lex_state = 0, .external_lex_state = 1},
  [4603] = {.lex_state = 144},
  [4604] = {.lex_state = 144},
  [4605] = {.lex_state = 160},
  [4606] = {.lex_state = 144},
  [4607] = {.lex_state = 144},
  [4608] = {.lex_state = 144},
  [4609] = {.lex_state = 144},
  [4610] = {.lex_state = 160},
  [4611] = {.lex_state = 144},
  [4612] = {.lex_state = 144},
  [4613] = {.lex_state = 144},
  [4614] = {.lex_state = 160},
  [4615] = {.lex_state = 144},
  [4616] = {.lex_state = 160},
  [4617] = {.lex_state = 144},
  [4618] = {.lex_state = 144},
  [4619] = {.lex_state = 160},
  [4620] = {.lex_state = 160},
  [4621] = {.lex_state = 118},
  [4622] = {.lex_state = 160},
  [4623] = {.lex_state = 118},
  [4624] = {.lex_state = 118},
  [4625] = {.lex_state = 118},
  [4626] = {.lex_state = 160},
  [4627] = {.lex_state = 214},
  [4628] = {.lex_state = 160},
  [4629] = {.lex_state = 160},
  [4630] = {.lex_state = 118},
  [4631] = {.lex_state = 160},
  [4632] = {.lex_state = 129},
  [4633] = {.lex_state = 118},
  [4634] = {.lex_state = 160},
  [4635] = {.lex_state = 160},
  [4636] = {.lex_state = 118},
  [4637] = {.lex_state = 118},
  [4638] = {.lex_state = 118},
  [4639] = {.lex_state = 118},
  [4640] = {.lex_state = 160},
  [4641] = {.lex_state = 118},
  [4642] = {.lex_state = 118},
  [4643] = {.lex_state = 118},
  [4644] = {.lex_state = 160},
  [4645] = {.lex_state = 118},
  [4646] = {.lex_state = 118},
  [4647] = {.lex_state = 118},
  [4648] = {.lex_state = 118},
  [4649] = {.lex_state = 0},
  [4650] = {.lex_state = 118},
  [4651] = {.lex_state = 144},
  [4652] = {.lex_state = 160},
  [4653] = {.lex_state = 160},
  [4654] = {.lex_state = 118},
  [4655] = {.lex_state = 129},
  [4656] = {.lex_state = 118},
  [4657] = {.lex_state = 118},
  [4658] = {.lex_state = 118},
  [4659] = {.lex_state = 118},
  [4660] = {.lex_state = 118},
  [4661] = {.lex_state = 118},
  [4662] = {.lex_state = 160},
  [4663] = {.lex_state = 0},
  [4664] = {.lex_state = 160},
  [4665] = {.lex_state = 129},
  [4666] = {.lex_state = 129},
  [4667] = {.lex_state = 0},
  [4668] = {.lex_state = 118},
  [4669] = {.lex_state = 0},
  [4670] = {.lex_state = 118},
  [4671] = {.lex_state = 118},
  [4672] = {.lex_state = 0},
  [4673] = {.lex_state = 129},
  [4674] = {.lex_state = 160},
  [4675] = {.lex_state = 118},
  [4676] = {.lex_state = 143},
  [4677] = {.lex_state = 118},
  [4678] = {.lex_state = 118},
  [4679] = {.lex_state = 0},
  [4680] = {.lex_state = 129},
  [4681] = {.lex_state = 143},
  [4682] = {.lex_state = 0},
  [4683] = {.lex_state = 118},
  [4684] = {.lex_state = 118},
  [4685] = {.lex_state = 129},
  [4686] = {.lex_state = 129},
  [4687] = {.lex_state = 118},
  [4688] = {.lex_state = 160},
  [4689] = {.lex_state = 118},
  [4690] = {.lex_state = 129},
  [4691] = {.lex_state = 118},
  [4692] = {.lex_state = 0},
  [4693] = {.lex_state = 160},
  [4694] = {.lex_state = 118},
  [4695] = {.lex_state = 129},
  [4696] = {.lex_state = 118},
  [4697] = {.lex_state = 0},
  [4698] = {.lex_state = 160},
  [4699] = {.lex_state = 0},
  [4700] = {.lex_state = 118},
  [4701] = {.lex_state = 129},
  [4702] = {.lex_state = 0},
  [4703] = {.lex_state = 118},
  [4704] = {.lex_state = 0},
  [4705] = {.lex_state = 118},
  [4706] = {.lex_state = 0},
  [4707] = {.lex_state = 118},
  [4708] = {.lex_state = 129},
  [4709] = {.lex_state = 118},
  [4710] = {.lex_state = 118},
  [4711] = {.lex_state = 129},
  [4712] = {.lex_state = 118},
  [4713] = {.lex_state = 129},
  [4714] = {.lex_state = 118},
  [4715] = {.lex_state = 129},
  [4716] = {.lex_state = 160},
  [4717] = {.lex_state = 118},
  [4718] = {.lex_state = 118},
  [4719] = {.lex_state = 118},
  [4720] = {.lex_state = 118},
  [4721] = {.lex_state = 118},
  [4722] = {.lex_state = 118},
  [4723] = {.lex_state = 118},
  [4724] = {.lex_state = 129},
  [4725] = {.lex_state = 118},
  [4726] = {.lex_state = 0},
  [4727] = {.lex_state = 118},
  [4728] = {.lex_state = 160},
  [4729] = {.lex_state = 118},
  [4730] = {.lex_state = 118},
  [4731] = {.lex_state = 0},
  [4732] = {.lex_state = 118},
  [4733] = {.lex_state = 118},
  [4734] = {.lex_state = 118},
  [4735] = {.lex_state = 118},
  [4736] = {.lex_state = 118},
  [4737] = {.lex_state = 118},
  [4738] = {.lex_state = 118},
  [4739] = {.lex_state = 118},
  [4740] = {.lex_state = 129},
  [4741] = {.lex_state = 214},
  [4742] = {.lex_state = 118},
  [4743] = {.lex_state = 0},
  [4744] = {.lex_state = 160},
  [4745] = {.lex_state = 0},
  [4746] = {.lex_state = 118},
  [4747] = {.lex_state = 118},
  [4748] = {.lex_state = 118},
  [4749] = {.lex_state = 129},
  [4750] = {.lex_state = 129},
  [4751] = {.lex_state = 129},
  [4752] = {.lex_state = 118},
  [4753] = {.lex_state = 118},
  [4754] = {.lex_state = 0},
  [4755] = {.lex_state = 118},
  [4756] = {.lex_state = 118},
  [4757] = {.lex_state = 214},
  [4758] = {.lex_state = 214},
  [4759] = {.lex_state = 118},
  [4760] = {.lex_state = 0},
  [4761] = {.lex_state = 118},
  [4762] = {.lex_state = 0},
  [4763] = {.lex_state = 129},
  [4764] = {.lex_state = 0},
  [4765] = {.lex_state = 129},
  [4766] = {.lex_state = 214},
  [4767] = {.lex_state = 0},
  [4768] = {.lex_state = 214},
  [4769] = {.lex_state = 129},
  [4770] = {.lex_state = 129},
  [4771] = {.lex_state = 118},
  [4772] = {.lex_state = 118},
  [4773] = {.lex_state = 0},
  [4774] = {.lex_state = 118},
  [4775] = {.lex_state = 118},
  [4776] = {.lex_state = 129},
  [4777] = {.lex_state = 118},
  [4778] = {.lex_state = 0},
  [4779] = {.lex_state = 214},
  [4780] = {.lex_state = 118},
  [4781] = {.lex_state = 118},
  [4782] = {.lex_state = 0},
  [4783] = {.lex_state = 118},
  [4784] = {.lex_state = 129},
  [4785] = {.lex_state = 129},
  [4786] = {.lex_state = 118},
  [4787] = {.lex_state = 118},
  [4788] = {.lex_state = 118},
  [4789] = {.lex_state = 0},
  [4790] = {.lex_state = 118},
  [4791] = {.lex_state = 118},
  [4792] = {.lex_state = 118},
  [4793] = {.lex_state = 214},
  [4794] = {.lex_state = 118},
  [4795] = {.lex_state = 118},
  [4796] = {.lex_state = 160},
  [4797] = {.lex_state = 118},
  [4798] = {.lex_state = 160},
  [4799] = {.lex_state = 118},
  [4800] = {.lex_state = 118},
  [4801] = {.lex_state = 0},
  [4802] = {.lex_state = 118},
  [4803] = {.lex_state = 118},
  [4804] = {.lex_state = 118},
  [4805] = {.lex_state = 160},
  [4806] = {.lex_state = 118},
  [4807] = {.lex_state = 118},
  [4808] = {.lex_state = 118},
  [4809] = {.lex_state = 0},
  [4810] = {.lex_state = 118},
  [4811] = {.lex_state = 118},
  [4812] = {.lex_state = 118},
  [4813] = {.lex_state = 118},
  [4814] = {.lex_state = 118},
  [4815] = {.lex_state = 118},
  [4816] = {.lex_state = 118},
  [4817] = {.lex_state = 118},
  [4818] = {.lex_state = 214},
  [4819] = {.lex_state = 214},
  [4820] = {.lex_state = 129},
  [4821] = {.lex_state = 144},
  [4822] = {.lex_state = 144},
  [4823] = {.lex_state = 144},
  [4824] = {.lex_state = 129},
  [4825] = {.lex_state = 58},
  [4826] = {.lex_state = 129},
  [4827] = {.lex_state = 118},
  [4828] = {.lex_state = 214},
  [4829] = {.lex_state = 118},
  [4830] = {.lex_state = 214},
  [4831] = {.lex_state = 0},
  [4832] = {.lex_state = 129},
  [4833] = {.lex_state = 144},
  [4834] = {.lex_state = 144},
  [4835] = {.lex_state = 144},
  [4836] = {.lex_state = 0},
  [4837] = {.lex_state = 214},
  [4838] = {.lex_state = 214},
  [4839] = {.lex_state = 0},
  [4840] = {.lex_state = 129},
  [4841] = {.lex_state = 214},
  [4842] = {.lex_state = 144},
  [4843] = {.lex_state = 144},
  [4844] = {.lex_state = 214},
  [4845] = {.lex_state = 160},
  [4846] = {.lex_state = 144},
  [4847] = {.lex_state = 144},
  [4848] = {.lex_state = 144},
  [4849] = {.lex_state = 144},
  [4850] = {.lex_state = 144},
  [4851] = {.lex_state = 144},
  [4852] = {.lex_state = 144},
  [4853] = {.lex_state = 144},
  [4854] = {.lex_state = 144},
  [4855] = {.lex_state = 144},
  [4856] = {.lex_state = 129},
  [4857] = {.lex_state = 129},
  [4858] = {.lex_state = 118},
  [4859] = {.lex_state = 144},
  [4860] = {.lex_state = 144},
  [4861] = {.lex_state = 129},
  [4862] = {.lex_state = 144},
  [4863] = {.lex_state = 0},
  [4864] = {.lex_state = 58},
  [4865] = {.lex_state = 214},
  [4866] = {.lex_state = 214},
  [4867] = {.lex_state = 58},
  [4868] = {.lex_state = 144},
  [4869] = {.lex_state = 160},
  [4870] = {.lex_state = 144},
  [4871] = {.lex_state = 144},
  [4872] = {.lex_state = 144},
  [4873] = {.lex_state = 144},
  [4874] = {.lex_state = 129},
  [4875] = {.lex_state = 160},
  [4876] = {.lex_state = 214},
  [4877] = {.lex_state = 214},
  [4878] = {.lex_state = 60},
  [4879] = {.lex_state = 118},
  [4880] = {.lex_state = 60},
  [4881] = {.lex_state = 214},
  [4882] = {.lex_state = 144},
  [4883] = {.lex_state = 118},
  [4884] = {.lex_state = 144},
  [4885] = {.lex_state = 58},
  [4886] = {.lex_state = 144},
  [4887] = {.lex_state = 144},
  [4888] = {.lex_state = 144},
  [4889] = {.lex_state = 144},
  [4890] = {.lex_state = 144},
  [4891] = {.lex_state = 144},
  [4892] = {.lex_state = 129},
  [4893] = {.lex_state = 214},
  [4894] = {.lex_state = 129},
  [4895] = {.lex_state = 129},
  [4896] = {.lex_state = 118},
  [4897] = {.lex_state = 129},
  [4898] = {.lex_state = 144},
  [4899] = {.lex_state = 144},
  [4900] = {.lex_state = 214},
  [4901] = {.lex_state = 58},
  [4902] = {.lex_state = 118},
  [4903] = {.lex_state = 0},
  [4904] = {.lex_state = 129},
  [4905] = {.lex_state = 118},
  [4906] = {.lex_state = 129},
  [4907] = {.lex_state = 160},
  [4908] = {.lex_state = 160},
  [4909] = {.lex_state = 129},
  [4910] = {.lex_state = 118},
  [4911] = {.lex_state = 129},
  [4912] = {.lex_state = 58},
  [4913] = {.lex_state = 0},
  [4914] = {.lex_state = 144},
  [4915] = {.lex_state = 144},
  [4916] = {.lex_state = 144},
  [4917] = {.lex_state = 144},
  [4918] = {.lex_state = 129},
  [4919] = {.lex_state = 144},
  [4920] = {.lex_state = 129},
  [4921] = {.lex_state = 58},
  [4922] = {.lex_state = 144},
  [4923] = {.lex_state = 144},
  [4924] = {.lex_state = 144},
  [4925] = {.lex_state = 129},
  [4926] = {.lex_state = 144},
  [4927] = {.lex_state = 144},
  [4928] = {.lex_state = 60},
  [4929] = {.lex_state = 58},
  [4930] = {.lex_state = 214},
  [4931] = {.lex_state = 129},
  [4932] = {.lex_state = 214},
  [4933] = {.lex_state = 144},
  [4934] = {.lex_state = 144},
  [4935] = {.lex_state = 144},
  [4936] = {.lex_state = 214},
  [4937] = {.lex_state = 118},
  [4938] = {.lex_state = 214},
  [4939] = {.lex_state = 58},
  [4940] = {.lex_state = 160},
  [4941] = {.lex_state = 144},
  [4942] = {.lex_state = 214},
  [4943] = {.lex_state = 58},
  [4944] = {.lex_state = 144},
  [4945] = {.lex_state = 144},
  [4946] = {.lex_state = 60},
  [4947] = {.lex_state = 144},
  [4948] = {.lex_state = 144},
  [4949] = {.lex_state = 118},
  [4950] = {.lex_state = 144},
  [4951] = {.lex_state = 144},
  [4952] = {.lex_state = 144},
  [4953] = {.lex_state = 144},
  [4954] = {.lex_state = 144},
  [4955] = {.lex_state = 118},
  [4956] = {.lex_state = 144},
  [4957] = {.lex_state = 144},
  [4958] = {.lex_state = 144},
  [4959] = {.lex_state = 144},
  [4960] = {.lex_state = 144},
  [4961] = {.lex_state = 58},
  [4962] = {.lex_state = 58},
  [4963] = {.lex_state = 214},
  [4964] = {.lex_state = 144},
  [4965] = {.lex_state = 0},
  [4966] = {.lex_state = 129},
  [4967] = {.lex_state = 144},
  [4968] = {.lex_state = 58},
  [4969] = {.lex_state = 118},
  [4970] = {.lex_state = 129},
  [4971] = {.lex_state = 144},
  [4972] = {.lex_state = 129},
  [4973] = {.lex_state = 118},
  [4974] = {.lex_state = 129},
  [4975] = {.lex_state = 118},
  [4976] = {.lex_state = 129},
  [4977] = {.lex_state = 129},
  [4978] = {.lex_state = 129},
  [4979] = {.lex_state = 144},
  [4980] = {.lex_state = 129},
  [4981] = {.lex_state = 214},
  [4982] = {.lex_state = 144},
  [4983] = {.lex_state = 214},
  [4984] = {.lex_state = 58},
  [4985] = {.lex_state = 144},
  [4986] = {.lex_state = 129},
  [4987] = {.lex_state = 144},
  [4988] = {.lex_state = 144},
  [4989] = {.lex_state = 144},
  [4990] = {.lex_state = 144},
  [4991] = {.lex_state = 144},
  [4992] = {.lex_state = 144},
  [4993] = {.lex_state = 144},
  [4994] = {.lex_state = 144},
  [4995] = {.lex_state = 144},
  [4996] = {.lex_state = 144},
  [4997] = {.lex_state = 144},
  [4998] = {.lex_state = 144},
  [4999] = {.lex_state = 129},
  [5000] = {.lex_state = 144},
  [5001] = {.lex_state = 214},
  [5002] = {.lex_state = 160},
  [5003] = {.lex_state = 214},
  [5004] = {.lex_state = 118},
  [5005] = {.lex_state = 214},
  [5006] = {.lex_state = 214},
  [5007] = {.lex_state = 129},
  [5008] = {.lex_state = 129},
  [5009] = {.lex_state = 214},
  [5010] = {.lex_state = 118},
  [5011] = {.lex_state = 144},
  [5012] = {.lex_state = 60},
  [5013] = {.lex_state = 144},
  [5014] = {.lex_state = 144},
  [5015] = {.lex_state = 118},
  [5016] = {.lex_state = 118},
  [5017] = {.lex_state = 214},
  [5018] = {.lex_state = 58},
  [5019] = {.lex_state = 58},
  [5020] = {.lex_state = 129},
  [5021] = {.lex_state = 160},
  [5022] = {.lex_state = 118},
  [5023] = {.lex_state = 129},
  [5024] = {.lex_state = 58},
  [5025] = {.lex_state = 118},
  [5026] = {.lex_state = 214},
  [5027] = {.lex_state = 58},
  [5028] = {.lex_state = 144},
  [5029] = {.lex_state = 144},
  [5030] = {.lex_state = 144},
  [5031] = {.lex_state = 160},
  [5032] = {.lex_state = 118},
  [5033] = {.lex_state = 144},
  [5034] = {.lex_state = 58},
  [5035] = {.lex_state = 60},
  [5036] = {.lex_state = 58},
  [5037] = {.lex_state = 144},
  [5038] = {.lex_state = 144},
  [5039] = {.lex_state = 129},
  [5040] = {.lex_state = 144},
  [5041] = {.lex_state = 144},
  [5042] = {.lex_state = 144},
  [5043] = {.lex_state = 214},
  [5044] = {.lex_state = 118},
  [5045] = {.lex_state = 60},
  [5046] = {.lex_state = 118},
  [5047] = {.lex_state = 118},
  [5048] = {.lex_state = 214},
  [5049] = {.lex_state = 129},
  [5050] = {.lex_state = 129},
  [5051] = {.lex_state = 129},
  [5052] = {.lex_state = 58},
  [5053] = {.lex_state = 144},
  [5054] = {.lex_state = 214},
  [5055] = {.lex_state = 0},
  [5056] = {.lex_state = 0},
  [5057] = {.lex_state = 214},
  [5058] = {.lex_state = 214},
  [5059] = {.lex_state = 214},
  [5060] = {.lex_state = 214},
  [5061] = {.lex_state = 214},
  [5062] = {.lex_state = 160},
  [5063] = {.lex_state = 0},
  [5064] = {.lex_state = 0},
  [5065] = {.lex_state = 0},
  [5066] = {.lex_state = 160},
  [5067] = {.lex_state = 214},
  [5068] = {.lex_state = 0},
  [5069] = {.lex_state = 160},
  [5070] = {.lex_state = 0},
  [5071] = {.lex_state = 0},
  [5072] = {.lex_state = 0},
  [5073] = {.lex_state = 0},
  [5074] = {.lex_state = 118},
  [5075] = {.lex_state = 160},
  [5076] = {.lex_state = 55},
  [5077] = {.lex_state = 0},
  [5078] = {.lex_state = 0},
  [5079] = {.lex_state = 160},
  [5080] = {.lex_state = 0},
  [5081] = {.lex_state = 0},
  [5082] = {.lex_state = 160},
  [5083] = {.lex_state = 0},
  [5084] = {.lex_state = 0},
  [5085] = {.lex_state = 118},
  [5086] = {.lex_state = 160},
  [5087] = {.lex_state = 0},
  [5088] = {.lex_state = 214},
  [5089] = {.lex_state = 0},
  [5090] = {.lex_state = 0},
  [5091] = {.lex_state = 0},
  [5092] = {.lex_state = 0},
  [5093] = {.lex_state = 0},
  [5094] = {.lex_state = 0},
  [5095] = {.lex_state = 0},
  [5096] = {.lex_state = 0},
  [5097] = {.lex_state = 0},
  [5098] = {.lex_state = 0},
  [5099] = {.lex_state = 160},
  [5100] = {.lex_state = 0},
  [5101] = {.lex_state = 0},
  [5102] = {.lex_state = 160},
  [5103] = {.lex_state = 160},
  [5104] = {.lex_state = 0},
  [5105] = {.lex_state = 214},
  [5106] = {.lex_state = 160},
  [5107] = {.lex_state = 160},
  [5108] = {.lex_state = 0},
  [5109] = {.lex_state = 55},
  [5110] = {.lex_state = 0},
  [5111] = {.lex_state = 0},
  [5112] = {.lex_state = 0},
  [5113] = {.lex_state = 214},
  [5114] = {.lex_state = 0},
  [5115] = {.lex_state = 0},
  [5116] = {.lex_state = 214},
  [5117] = {.lex_state = 0},
  [5118] = {.lex_state = 214},
  [5119] = {.lex_state = 0},
  [5120] = {.lex_state = 0},
  [5121] = {.lex_state = 0},
  [5122] = {.lex_state = 214},
  [5123] = {.lex_state = 0},
  [5124] = {.lex_state = 160},
  [5125] = {.lex_state = 0},
  [5126] = {.lex_state = 0},
  [5127] = {.lex_state = 0},
  [5128] = {.lex_state = 0},
  [5129] = {.lex_state = 0},
  [5130] = {.lex_state = 0},
  [5131] = {.lex_state = 0},
  [5132] = {.lex_state = 0},
  [5133] = {.lex_state = 214},
  [5134] = {.lex_state = 0},
  [5135] = {.lex_state = 55},
  [5136] = {.lex_state = 0},
  [5137] = {.lex_state = 0},
  [5138] = {.lex_state = 0},
  [5139] = {.lex_state = 0},
  [5140] = {.lex_state = 160},
  [5141] = {.lex_state = 0},
  [5142] = {.lex_state = 160},
  [5143] = {.lex_state = 0},
  [5144] = {.lex_state = 0},
  [5145] = {.lex_state = 0},
  [5146] = {.lex_state = 160},
  [5147] = {.lex_state = 0},
  [5148] = {.lex_state = 0},
  [5149] = {.lex_state = 0},
  [5150] = {.lex_state = 160},
  [5151] = {.lex_state = 118},
  [5152] = {.lex_state = 0},
  [5153] = {.lex_state = 0},
  [5154] = {.lex_state = 160},
  [5155] = {.lex_state = 214},
  [5156] = {.lex_state = 0},
  [5157] = {.lex_state = 0},
  [5158] = {.lex_state = 214},
  [5159] = {.lex_state = 214},
  [5160] = {.lex_state = 160},
  [5161] = {.lex_state = 214},
  [5162] = {.lex_state = 214},
  [5163] = {.lex_state = 0},
  [5164] = {.lex_state = 0},
  [5165] = {.lex_state = 0},
  [5166] = {.lex_state = 0},
  [5167] = {.lex_state = 0},
  [5168] = {.lex_state = 0},
  [5169] = {.lex_state = 214},
  [5170] = {.lex_state = 0},
  [5171] = {.lex_state = 160},
  [5172] = {.lex_state = 214},
  [5173] = {.lex_state = 214},
  [5174] = {.lex_state = 0},
  [5175] = {.lex_state = 0},
  [5176] = {.lex_state = 115},
  [5177] = {.lex_state = 0},
  [5178] = {.lex_state = 160},
  [5179] = {.lex_state = 0},
  [5180] = {.lex_state = 0},
  [5181] = {.lex_state = 0},
  [5182] = {.lex_state = 0},
  [5183] = {.lex_state = 214},
  [5184] = {.lex_state = 0},
  [5185] = {.lex_state = 0},
  [5186] = {.lex_state = 0},
  [5187] = {.lex_state = 214},
  [5188] = {.lex_state = 0},
  [5189] = {.lex_state = 214},
  [5190] = {.lex_state = 0},
  [5191] = {.lex_state = 160},
  [5192] = {.lex_state = 214},
  [5193] = {.lex_state = 214},
  [5194] = {.lex_state = 0},
  [5195] = {.lex_state = 0},
  [5196] = {.lex_state = 0},
  [5197] = {.lex_state = 0},
  [5198] = {.lex_state = 0},
  [5199] = {.lex_state = 0},
  [5200] = {.lex_state = 0},
  [5201] = {.lex_state = 0},
  [5202] = {.lex_state = 214},
  [5203] = {.lex_state = 0},
  [5204] = {.lex_state = 214},
  [5205] = {.lex_state = 0},
  [5206] = {.lex_state = 214},
  [5207] = {.lex_state = 214},
  [5208] = {.lex_state = 214},
  [5209] = {.lex_state = 160},
  [5210] = {.lex_state = 0},
  [5211] = {.lex_state = 55},
  [5212] = {.lex_state = 0},
  [5213] = {.lex_state = 0},
  [5214] = {.lex_state = 0},
  [5215] = {.lex_state = 160},
  [5216] = {.lex_state = 0},
  [5217] = {.lex_state = 214},
  [5218] = {.lex_state = 214},
  [5219] = {.lex_state = 214},
  [5220] = {.lex_state = 214},
  [5221] = {.lex_state = 214},
  [5222] = {.lex_state = 214},
  [5223] = {.lex_state = 0},
  [5224] = {.lex_state = 0},
  [5225] = {.lex_state = 0},
  [5226] = {.lex_state = 214},
  [5227] = {.lex_state = 214},
  [5228] = {.lex_state = 214},
  [5229] = {.lex_state = 0},
  [5230] = {.lex_state = 0},
  [5231] = {.lex_state = 0},
  [5232] = {.lex_state = 214},
  [5233] = {.lex_state = 118},
  [5234] = {.lex_state = 0},
  [5235] = {.lex_state = 214},
  [5236] = {.lex_state = 214},
  [5237] = {.lex_state = 214},
  [5238] = {.lex_state = 214},
  [5239] = {.lex_state = 0},
  [5240] = {.lex_state = 214},
  [5241] = {.lex_state = 214},
  [5242] = {.lex_state = 160},
  [5243] = {.lex_state = 0},
  [5244] = {.lex_state = 160},
  [5245] = {.lex_state = 0},
  [5246] = {.lex_state = 0},
  [5247] = {.lex_state = 0},
  [5248] = {.lex_state = 0},
  [5249] = {.lex_state = 160},
  [5250] = {.lex_state = 0},
  [5251] = {.lex_state = 214},
  [5252] = {.lex_state = 214},
  [5253] = {.lex_state = 214},
  [5254] = {.lex_state = 0},
  [5255] = {.lex_state = 0},
  [5256] = {.lex_state = 160},
  [5257] = {.lex_state = 0},
  [5258] = {.lex_state = 0},
  [5259] = {.lex_state = 0},
  [5260] = {.lex_state = 160},
  [5261] = {.lex_state = 0},
  [5262] = {.lex_state = 0},
  [5263] = {.lex_state = 0},
  [5264] = {.lex_state = 0},
  [5265] = {.lex_state = 0},
  [5266] = {.lex_state = 214},
  [5267] = {.lex_state = 160},
  [5268] = {.lex_state = 0},
  [5269] = {.lex_state = 0},
  [5270] = {.lex_state = 0},
  [5271] = {.lex_state = 214},
  [5272] = {.lex_state = 0},
  [5273] = {.lex_state = 0},
  [5274] = {.lex_state = 0},
  [5275] = {.lex_state = 0},
  [5276] = {.lex_state = 0},
  [5277] = {.lex_state = 115},
  [5278] = {.lex_state = 0},
  [5279] = {.lex_state = 0},
  [5280] = {.lex_state = 160},
  [5281] = {.lex_state = 214},
  [5282] = {.lex_state = 0},
  [5283] = {.lex_state = 0},
  [5284] = {.lex_state = 0},
  [5285] = {.lex_state = 214},
  [5286] = {.lex_state = 160},
  [5287] = {.lex_state = 0},
  [5288] = {.lex_state = 0},
  [5289] = {.lex_state = 0},
  [5290] = {.lex_state = 0},
  [5291] = {.lex_state = 214},
  [5292] = {.lex_state = 214},
  [5293] = {.lex_state = 0},
  [5294] = {.lex_state = 214},
  [5295] = {.lex_state = 0},
  [5296] = {.lex_state = 0},
  [5297] = {.lex_state = 0},
  [5298] = {.lex_state = 0},
  [5299] = {.lex_state = 160},
  [5300] = {.lex_state = 0},
  [5301] = {.lex_state = 160},
  [5302] = {.lex_state = 0},
  [5303] = {.lex_state = 0},
  [5304] = {.lex_state = 0},
  [5305] = {.lex_state = 0},
  [5306] = {.lex_state = 0},
  [5307] = {.lex_state = 0},
  [5308] = {.lex_state = 0},
  [5309] = {.lex_state = 0},
  [5310] = {.lex_state = 0},
  [5311] = {.lex_state = 0},
  [5312] = {.lex_state = 160},
  [5313] = {.lex_state = 0},
  [5314] = {.lex_state = 0},
  [5315] = {.lex_state = 214},
  [5316] = {.lex_state = 214},
  [5317] = {.lex_state = 0},
  [5318] = {.lex_state = 214},
  [5319] = {.lex_state = 214},
  [5320] = {.lex_state = 0},
  [5321] = {.lex_state = 0},
  [5322] = {.lex_state = 0},
  [5323] = {.lex_state = 0},
  [5324] = {.lex_state = 214},
  [5325] = {.lex_state = 61},
  [5326] = {.lex_state = 160},
  [5327] = {.lex_state = 0},
  [5328] = {.lex_state = 160},
  [5329] = {.lex_state = 61},
  [5330] = {.lex_state = 160},
  [5331] = {.lex_state = 214},
  [5332] = {.lex_state = 0},
  [5333] = {.lex_state = 0},
  [5334] = {.lex_state = 0},
  [5335] = {.lex_state = 0},
  [5336] = {.lex_state = 0},
  [5337] = {.lex_state = 0},
  [5338] = {.lex_state = 0},
  [5339] = {.lex_state = 0},
  [5340] = {.lex_state = 0},
  [5341] = {.lex_state = 0},
  [5342] = {.lex_state = 0},
  [5343] = {.lex_state = 0},
  [5344] = {.lex_state = 0},
  [5345] = {.lex_state = 0},
  [5346] = {.lex_state = 0},
  [5347] = {.lex_state = 160},
  [5348] = {.lex_state = 214},
  [5349] = {.lex_state = 0},
  [5350] = {.lex_state = 0},
  [5351] = {.lex_state = 0},
  [5352] = {.lex_state = 214},
  [5353] = {.lex_state = 62},
  [5354] = {.lex_state = 0},
  [5355] = {.lex_state = 0},
  [5356] = {.lex_state = 0},
  [5357] = {.lex_state = 0},
  [5358] = {.lex_state = 0},
  [5359] = {.lex_state = 160},
  [5360] = {.lex_state = 0},
  [5361] = {.lex_state = 0},
  [5362] = {.lex_state = 160},
  [5363] = {.lex_state = 0},
  [5364] = {.lex_state = 0},
  [5365] = {.lex_state = 61},
  [5366] = {.lex_state = 0},
  [5367] = {.lex_state = 0},
  [5368] = {.lex_state = 160},
  [5369] = {.lex_state = 0},
  [5370] = {.lex_state = 0},
  [5371] = {.lex_state = 214},
  [5372] = {.lex_state = 0},
  [5373] = {.lex_state = 0},
  [5374] = {.lex_state = 0},
  [5375] = {.lex_state = 0},
  [5376] = {.lex_state = 0},
  [5377] = {.lex_state = 0},
  [5378] = {.lex_state = 160},
  [5379] = {.lex_state = 0},
  [5380] = {.lex_state = 0},
  [5381] = {.lex_state = 0},
  [5382] = {.lex_state = 214},
  [5383] = {.lex_state = 0},
  [5384] = {.lex_state = 0},
  [5385] = {.lex_state = 0},
  [5386] = {.lex_state = 160},
  [5387] = {.lex_state = 0},
  [5388] = {.lex_state = 0},
  [5389] = {.lex_state = 0},
  [5390] = {.lex_state = 0},
  [5391] = {.lex_state = 0},
  [5392] = {.lex_state = 0},
  [5393] = {.lex_state = 214},
  [5394] = {.lex_state = 0},
  [5395] = {.lex_state = 160},
  [5396] = {.lex_state = 0},
  [5397] = {.lex_state = 214},
  [5398] = {.lex_state = 0},
  [5399] = {.lex_state = 0},
  [5400] = {.lex_state = 0},
  [5401] = {.lex_state = 0},
  [5402] = {.lex_state = 0},
  [5403] = {.lex_state = 0},
  [5404] = {.lex_state = 160},
  [5405] = {.lex_state = 0},
  [5406] = {.lex_state = 0},
  [5407] = {.lex_state = 0},
  [5408] = {.lex_state = 0},
  [5409] = {.lex_state = 214},
  [5410] = {.lex_state = 160},
  [5411] = {.lex_state = 0},
  [5412] = {.lex_state = 160},
  [5413] = {.lex_state = 160},
  [5414] = {.lex_state = 0},
  [5415] = {.lex_state = 0},
  [5416] = {.lex_state = 160},
  [5417] = {.lex_state = 0},
  [5418] = {.lex_state = 160},
  [5419] = {.lex_state = 0},
  [5420] = {.lex_state = 160},
  [5421] = {.lex_state = 0},
  [5422] = {.lex_state = 160},
  [5423] = {.lex_state = 0},
  [5424] = {.lex_state = 214},
  [5425] = {.lex_state = 62},
  [5426] = {.lex_state = 62},
  [5427] = {.lex_state = 160},
  [5428] = {.lex_state = 0},
  [5429] = {.lex_state = 0},
  [5430] = {.lex_state = 61},
  [5431] = {.lex_state = 0},
  [5432] = {.lex_state = 0},
  [5433] = {.lex_state = 214},
  [5434] = {.lex_state = 0},
  [5435] = {.lex_state = 62},
  [5436] = {.lex_state = 0},
  [5437] = {.lex_state = 0},
  [5438] = {.lex_state = 0},
  [5439] = {.lex_state = 160},
  [5440] = {.lex_state = 61},
  [5441] = {.lex_state = 0},
  [5442] = {.lex_state = 62},
  [5443] = {.lex_state = 0},
  [5444] = {.lex_state = 0},
  [5445] = {.lex_state = 160},
  [5446] = {.lex_state = 0},
  [5447] = {.lex_state = 160},
  [5448] = {.lex_state = 0},
  [5449] = {.lex_state = 0},
  [5450] = {.lex_state = 214},
  [5451] = {.lex_state = 214},
  [5452] = {.lex_state = 214},
  [5453] = {.lex_state = 214},
  [5454] = {.lex_state = 160},
  [5455] = {.lex_state = 0},
  [5456] = {.lex_state = 160},
  [5457] = {.lex_state = 0},
  [5458] = {.lex_state = 61},
  [5459] = {.lex_state = 0},
  [5460] = {.lex_state = 0},
  [5461] = {.lex_state = 0},
  [5462] = {.lex_state = 214},
  [5463] = {.lex_state = 0},
  [5464] = {.lex_state = 160},
  [5465] = {.lex_state = 0},
  [5466] = {.lex_state = 61},
  [5467] = {.lex_state = 0},
  [5468] = {.lex_state = 0},
  [5469] = {.lex_state = 62},
  [5470] = {.lex_state = 214},
  [5471] = {.lex_state = 61},
  [5472] = {.lex_state = 0},
  [5473] = {.lex_state = 214},
  [5474] = {.lex_state = 61},
  [5475] = {.lex_state = 0},
  [5476] = {.lex_state = 214},
  [5477] = {.lex_state = 214},
  [5478] = {.lex_state = 214},
  [5479] = {.lex_state = 214},
  [5480] = {.lex_state = 214},
  [5481] = {.lex_state = 214},
  [5482] = {.lex_state = 0},
  [5483] = {.lex_state = 0},
  [5484] = {.lex_state = 0},
  [5485] = {.lex_state = 160},
  [5486] = {.lex_state = 0},
  [5487] = {.lex_state = 0},
  [5488] = {.lex_state = 0},
  [5489] = {.lex_state = 160},
  [5490] = {.lex_state = 0},
  [5491] = {.lex_state = 0},
  [5492] = {.lex_state = 0},
  [5493] = {.lex_state = 160},
  [5494] = {.lex_state = 0},
  [5495] = {.lex_state = 0},
  [5496] = {.lex_state = 0},
  [5497] = {.lex_state = 0},
  [5498] = {.lex_state = 214},
  [5499] = {.lex_state = 160},
  [5500] = {.lex_state = 0},
  [5501] = {.lex_state = 214},
  [5502] = {.lex_state = 0},
  [5503] = {.lex_state = 160},
  [5504] = {.lex_state = 0},
  [5505] = {.lex_state = 0},
  [5506] = {.lex_state = 61},
  [5507] = {.lex_state = 0},
  [5508] = {.lex_state = 0},
  [5509] = {.lex_state = 0},
  [5510] = {.lex_state = 0},
  [5511] = {.lex_state = 160},
  [5512] = {.lex_state = 0},
  [5513] = {.lex_state = 160},
  [5514] = {.lex_state = 62},
  [5515] = {.lex_state = 0},
  [5516] = {.lex_state = 160},
  [5517] = {.lex_state = 160},
  [5518] = {.lex_state = 160},
  [5519] = {.lex_state = 214},
  [5520] = {.lex_state = 160},
  [5521] = {.lex_state = 0},
  [5522] = {.lex_state = 0},
  [5523] = {.lex_state = 214},
  [5524] = {.lex_state = 0},
  [5525] = {.lex_state = 214},
  [5526] = {.lex_state = 214},
  [5527] = {.lex_state = 214},
  [5528] = {.lex_state = 0},
  [5529] = {.lex_state = 214},
  [5530] = {.lex_state = 0},
  [5531] = {.lex_state = 0},
  [5532] = {.lex_state = 214},
  [5533] = {.lex_state = 214},
  [5534] = {.lex_state = 214},
  [5535] = {.lex_state = 160},
  [5536] = {.lex_state = 0},
  [5537] = {.lex_state = 0},
  [5538] = {.lex_state = 214},
  [5539] = {.lex_state = 214},
  [5540] = {.lex_state = 214},
  [5541] = {.lex_state = 160},
  [5542] = {.lex_state = 0},
  [5543] = {.lex_state = 0},
  [5544] = {.lex_state = 0},
  [5545] = {.lex_state = 0},
  [5546] = {.lex_state = 0},
  [5547] = {.lex_state = 0},
  [5548] = {.lex_state = 214},
  [5549] = {.lex_state = 160},
  [5550] = {.lex_state = 160},
  [5551] = {.lex_state = 160},
  [5552] = {.lex_state = 0},
  [5553] = {.lex_state = 214},
  [5554] = {.lex_state = 0},
  [5555] = {.lex_state = 0},
  [5556] = {.lex_state = 214},
  [5557] = {.lex_state = 0},
  [5558] = {.lex_state = 214},
  [5559] = {.lex_state = 160},
  [5560] = {.lex_state = 214},
  [5561] = {.lex_state = 160},
  [5562] = {.lex_state = 0},
  [5563] = {.lex_state = 0},
  [5564] = {.lex_state = 0},
  [5565] = {.lex_state = 160},
  [5566] = {.lex_state = 0},
  [5567] = {.lex_state = 62},
  [5568] = {.lex_state = 214},
  [5569] = {.lex_state = 214},
  [5570] = {.lex_state = 0},
  [5571] = {.lex_state = 214},
  [5572] = {.lex_state = 0},
  [5573] = {.lex_state = 0},
  [5574] = {.lex_state = 0},
  [5575] = {.lex_state = 0},
  [5576] = {.lex_state = 0},
  [5577] = {.lex_state = 0},
  [5578] = {.lex_state = 160},
  [5579] = {.lex_state = 214},
  [5580] = {.lex_state = 214},
  [5581] = {.lex_state = 0},
  [5582] = {.lex_state = 160},
  [5583] = {.lex_state = 0},
  [5584] = {.lex_state = 160},
  [5585] = {.lex_state = 214},
  [5586] = {.lex_state = 160},
  [5587] = {.lex_state = 160},
  [5588] = {.lex_state = 61},
  [5589] = {.lex_state = 0},
  [5590] = {.lex_state = 61},
  [5591] = {.lex_state = 0},
  [5592] = {.lex_state = 214},
  [5593] = {.lex_state = 0},
  [5594] = {.lex_state = 214},
  [5595] = {.lex_state = 0},
  [5596] = {.lex_state = 160},
  [5597] = {.lex_state = 214},
  [5598] = {.lex_state = 214},
  [5599] = {.lex_state = 160},
  [5600] = {.lex_state = 160},
  [5601] = {.lex_state = 61},
  [5602] = {.lex_state = 160},
  [5603] = {.lex_state = 160},
  [5604] = {.lex_state = 214},
  [5605] = {.lex_state = 160},
  [5606] = {.lex_state = 160},
  [5607] = {.lex_state = 160},
  [5608] = {.lex_state = 214},
  [5609] = {.lex_state = 214},
  [5610] = {.lex_state = 0},
  [5611] = {.lex_state = 160},
  [5612] = {.lex_state = 0},
  [5613] = {.lex_state = 0},
  [5614] = {.lex_state = 0},
  [5615] = {.lex_state = 0},
  [5616] = {.lex_state = 160},
  [5617] = {.lex_state = 0},
  [5618] = {.lex_state = 160},
  [5619] = {.lex_state = 0},
  [5620] = {.lex_state = 0},
  [5621] = {.lex_state = 160},
  [5622] = {.lex_state = 160},
  [5623] = {.lex_state = 160},
  [5624] = {.lex_state = 0},
  [5625] = {.lex_state = 0},
  [5626] = {.lex_state = 0},
  [5627] = {.lex_state = 214},
  [5628] = {.lex_state = 160},
  [5629] = {.lex_state = 160},
  [5630] = {.lex_state = 0},
  [5631] = {.lex_state = 0},
  [5632] = {.lex_state = 0},
  [5633] = {.lex_state = 160},
  [5634] = {.lex_state = 0},
  [5635] = {.lex_state = 0},
  [5636] = {.lex_state = 0},
  [5637] = {.lex_state = 160},
  [5638] = {.lex_state = 214},
  [5639] = {.lex_state = 62},
  [5640] = {.lex_state = 160},
  [5641] = {.lex_state = 214},
  [5642] = {.lex_state = 160},
  [5643] = {.lex_state = 0},
  [5644] = {.lex_state = 214},
  [5645] = {.lex_state = 0},
  [5646] = {.lex_state = 214},
  [5647] = {.lex_state = 0},
  [5648] = {.lex_state = 0},
  [5649] = {.lex_state = 0},
  [5650] = {.lex_state = 0},
  [5651] = {.lex_state = 0},
  [5652] = {.lex_state = 214},
  [5653] = {.lex_state = 0},
  [5654] = {.lex_state = 0},
  [5655] = {.lex_state = 62},
  [5656] = {.lex_state = 0},
  [5657] = {.lex_state = 160},
  [5658] = {.lex_state = 0},
  [5659] = {.lex_state = 0},
  [5660] = {.lex_state = 0},
  [5661] = {.lex_state = 0},
  [5662] = {.lex_state = 0},
  [5663] = {.lex_state = 0},
  [5664] = {.lex_state = 214},
  [5665] = {.lex_state = 0},
  [5666] = {.lex_state = 61},
  [5667] = {.lex_state = 0},
  [5668] = {.lex_state = 0},
  [5669] = {.lex_state = 0},
  [5670] = {.lex_state = 61},
  [5671] = {.lex_state = 0},
  [5672] = {.lex_state = 0},
  [5673] = {.lex_state = 0},
  [5674] = {.lex_state = 0},
  [5675] = {.lex_state = 0},
  [5676] = {.lex_state = 0},
  [5677] = {.lex_state = 214},
  [5678] = {.lex_state = 61},
  [5679] = {.lex_state = 0},
  [5680] = {.lex_state = 0},
  [5681] = {.lex_state = 0},
  [5682] = {.lex_state = 0},
  [5683] = {.lex_state = 214},
  [5684] = {.lex_state = 0},
  [5685] = {.lex_state = 0},
  [5686] = {.lex_state = 214},
  [5687] = {.lex_state = 160},
  [5688] = {.lex_state = 0},
  [5689] = {.lex_state = 0},
  [5690] = {.lex_state = 214},
  [5691] = {.lex_state = 0},
  [5692] = {.lex_state = 0},
  [5693] = {.lex_state = 160},
  [5694] = {.lex_state = 0},
  [5695] = {.lex_state = 214},
  [5696] = {.lex_state = 61},
  [5697] = {.lex_state = 0},
  [5698] = {.lex_state = 0},
  [5699] = {.lex_state = 0},
  [5700] = {.lex_state = 0},
  [5701] = {.lex_state = 0},
  [5702] = {.lex_state = 0},
  [5703] = {.lex_state = 0},
  [5704] = {.lex_state = 0},
  [5705] = {.lex_state = 160},
  [5706] = {.lex_state = 160},
  [5707] = {.lex_state = 116},
  [5708] = {.lex_state = 0},
  [5709] = {.lex_state = 160},
  [5710] = {.lex_state = 0},
  [5711] = {.lex_state = 0},
  [5712] = {.lex_state = 0},
  [5713] = {.lex_state = 0},
  [5714] = {.lex_state = 0},
  [5715] = {.lex_state = 144},
  [5716] = {.lex_state = 116},
  [5717] = {.lex_state = 0},
  [5718] = {.lex_state = 0},
  [5719] = {.lex_state = 0},
  [5720] = {.lex_state = 0},
  [5721] = {.lex_state = 116},
  [5722] = {.lex_state = 116},
  [5723] = {.lex_state = 214},
  [5724] = {.lex_state = 160},
  [5725] = {.lex_state = 0},
  [5726] = {.lex_state = 214},
  [5727] = {.lex_state = 116},
  [5728] = {.lex_state = 116},
  [5729] = {.lex_state = 0},
  [5730] = {.lex_state = 0},
  [5731] = {.lex_state = 116},
  [5732] = {.lex_state = 160},
  [5733] = {.lex_state = 0},
  [5734] = {.lex_state = 0},
  [5735] = {.lex_state = 0},
  [5736] = {.lex_state = 0},
  [5737] = {.lex_state = 0},
  [5738] = {.lex_state = 0},
  [5739] = {.lex_state = 0},
  [5740] = {.lex_state = 0},
  [5741] = {.lex_state = 0},
  [5742] = {.lex_state = 0},
  [5743] = {.lex_state = 0},
  [5744] = {.lex_state = 0},
  [5745] = {.lex_state = 0},
  [5746] = {.lex_state = 0},
  [5747] = {.lex_state = 160},
  [5748] = {.lex_state = 0},
  [5749] = {.lex_state = 0},
  [5750] = {.lex_state = 0},
  [5751] = {.lex_state = 160},
  [5752] = {.lex_state = 55},
  [5753] = {.lex_state = 0},
  [5754] = {.lex_state = 160},
  [5755] = {.lex_state = 0},
  [5756] = {.lex_state = 0},
  [5757] = {.lex_state = 0},
  [5758] = {.lex_state = 0},
  [5759] = {.lex_state = 0},
  [5760] = {.lex_state = 55},
  [5761] = {.lex_state = 160},
  [5762] = {.lex_state = 0},
  [5763] = {.lex_state = 160},
  [5764] = {.lex_state = 0},
  [5765] = {.lex_state = 0},
  [5766] = {.lex_state = 0},
  [5767] = {.lex_state = 0},
  [5768] = {.lex_state = 0},
  [5769] = {.lex_state = 0},
  [5770] = {.lex_state = 0},
  [5771] = {.lex_state = 0},
  [5772] = {.lex_state = 0},
  [5773] = {.lex_state = 214},
  [5774] = {.lex_state = 0},
  [5775] = {.lex_state = 0},
  [5776] = {.lex_state = 0},
  [5777] = {.lex_state = 160},
  [5778] = {.lex_state = 0},
  [5779] = {.lex_state = 0},
  [5780] = {.lex_state = 144},
  [5781] = {.lex_state = 0},
  [5782] = {.lex_state = 0},
  [5783] = {.lex_state = 160},
  [5784] = {.lex_state = 0},
  [5785] = {.lex_state = 0},
  [5786] = {.lex_state = 0},
  [5787] = {.lex_state = 0},
  [5788] = {.lex_state = 0},
  [5789] = {.lex_state = 160},
  [5790] = {.lex_state = 0},
  [5791] = {.lex_state = 0},
  [5792] = {.lex_state = 0},
  [5793] = {.lex_state = 0},
  [5794] = {.lex_state = 0},
  [5795] = {.lex_state = 214},
  [5796] = {.lex_state = 0},
  [5797] = {.lex_state = 0},
  [5798] = {.lex_state = 0},
  [5799] = {.lex_state = 116},
  [5800] = {.lex_state = 0},
  [5801] = {.lex_state = 116},
  [5802] = {.lex_state = 0},
  [5803] = {.lex_state = 55},
  [5804] = {.lex_state = 0},
  [5805] = {.lex_state = 0},
  [5806] = {.lex_state = 0},
  [5807] = {.lex_state = 0},
  [5808] = {.lex_state = 0},
  [5809] = {.lex_state = 0},
  [5810] = {.lex_state = 160},
  [5811] = {.lex_state = 160},
  [5812] = {.lex_state = 0},
  [5813] = {.lex_state = 0},
  [5814] = {.lex_state = 0},
  [5815] = {.lex_state = 0},
  [5816] = {.lex_state = 160},
  [5817] = {.lex_state = 116},
  [5818] = {.lex_state = 0},
  [5819] = {.lex_state = 0},
  [5820] = {.lex_state = 160},
  [5821] = {.lex_state = 55},
  [5822] = {.lex_state = 214},
  [5823] = {.lex_state = 0},
  [5824] = {.lex_state = 0},
  [5825] = {.lex_state = 0},
  [5826] = {.lex_state = 0},
  [5827] = {.lex_state = 0},
  [5828] = {.lex_state = 0},
  [5829] = {.lex_state = 0},
  [5830] = {.lex_state = 0},
  [5831] = {.lex_state = 0},
  [5832] = {.lex_state = 0},
  [5833] = {.lex_state = 0},
  [5834] = {.lex_state = 55},
  [5835] = {.lex_state = 0},
  [5836] = {.lex_state = 0},
  [5837] = {.lex_state = 0},
  [5838] = {.lex_state = 0},
  [5839] = {.lex_state = 0},
  [5840] = {.lex_state = 0},
  [5841] = {.lex_state = 0},
  [5842] = {.lex_state = 116},
  [5843] = {.lex_state = 0},
  [5844] = {.lex_state = 0},
  [5845] = {.lex_state = 0},
  [5846] = {.lex_state = 0},
  [5847] = {.lex_state = 0},
  [5848] = {.lex_state = 160},
  [5849] = {.lex_state = 0},
  [5850] = {.lex_state = 0},
  [5851] = {.lex_state = 0},
  [5852] = {.lex_state = 144},
  [5853] = {.lex_state = 0},
  [5854] = {.lex_state = 116},
  [5855] = {.lex_state = 0},
  [5856] = {.lex_state = 160},
  [5857] = {.lex_state = 144},
  [5858] = {.lex_state = 0},
  [5859] = {.lex_state = 0},
  [5860] = {.lex_state = 0},
  [5861] = {.lex_state = 0},
  [5862] = {.lex_state = 116},
  [5863] = {.lex_state = 0},
  [5864] = {.lex_state = 55},
  [5865] = {.lex_state = 160},
  [5866] = {.lex_state = 116},
  [5867] = {.lex_state = 55},
  [5868] = {.lex_state = 0},
  [5869] = {.lex_state = 55},
  [5870] = {.lex_state = 0},
  [5871] = {.lex_state = 55},
  [5872] = {.lex_state = 55},
  [5873] = {.lex_state = 0},
  [5874] = {.lex_state = 0},
  [5875] = {.lex_state = 0},
  [5876] = {.lex_state = 0},
  [5877] = {.lex_state = 0},
  [5878] = {.lex_state = 0},
  [5879] = {.lex_state = 0},
  [5880] = {.lex_state = 55},
  [5881] = {.lex_state = 0},
  [5882] = {.lex_state = 160},
  [5883] = {.lex_state = 0},
  [5884] = {.lex_state = 0},
  [5885] = {.lex_state = 0},
  [5886] = {.lex_state = 160},
  [5887] = {.lex_state = 0},
  [5888] = {.lex_state = 0},
  [5889] = {.lex_state = 0},
  [5890] = {.lex_state = 214},
  [5891] = {.lex_state = 0},
  [5892] = {.lex_state = 55},
  [5893] = {.lex_state = 160},
  [5894] = {.lex_state = 160},
  [5895] = {.lex_state = 160},
  [5896] = {.lex_state = 0},
  [5897] = {.lex_state = 55},
  [5898] = {.lex_state = 160},
  [5899] = {.lex_state = 160},
  [5900] = {.lex_state = 0},
  [5901] = {.lex_state = 160},
  [5902] = {.lex_state = 160},
  [5903] = {.lex_state = 0},
  [5904] = {.lex_state = 0},
  [5905] = {.lex_state = 214},
  [5906] = {.lex_state = 0},
  [5907] = {.lex_state = 0},
  [5908] = {.lex_state = 160},
  [5909] = {.lex_state = 55},
  [5910] = {.lex_state = 0},
  [5911] = {.lex_state = 160},
  [5912] = {.lex_state = 0},
  [5913] = {.lex_state = 160},
  [5914] = {.lex_state = 0},
  [5915] = {.lex_state = 160},
  [5916] = {.lex_state = 0},
  [5917] = {.lex_state = 160},
  [5918] = {.lex_state = 0},
  [5919] = {.lex_state = 160},
  [5920] = {.lex_state = 0},
  [5921] = {.lex_state = 0},
  [5922] = {.lex_state = 55},
  [5923] = {.lex_state = 0},
  [5924] = {.lex_state = 0},
  [5925] = {.lex_state = 0},
  [5926] = {.lex_state = 160},
  [5927] = {.lex_state = 160},
  [5928] = {.lex_state = 0},
  [5929] = {.lex_state = 0},
  [5930] = {.lex_state = 160},
  [5931] = {.lex_state = 160},
  [5932] = {.lex_state = 0},
  [5933] = {.lex_state = 0},
  [5934] = {.lex_state = 0},
  [5935] = {.lex_state = 160},
  [5936] = {.lex_state = 0},
  [5937] = {.lex_state = 0},
  [5938] = {.lex_state = 0},
  [5939] = {.lex_state = 214},
  [5940] = {.lex_state = 0},
  [5941] = {.lex_state = 0},
  [5942] = {.lex_state = 0},
  [5943] = {.lex_state = 160},
  [5944] = {.lex_state = 0},
  [5945] = {.lex_state = 0},
  [5946] = {.lex_state = 0},
  [5947] = {.lex_state = 160},
  [5948] = {.lex_state = 160},
  [5949] = {.lex_state = 0},
  [5950] = {.lex_state = 160},
  [5951] = {.lex_state = 0},
  [5952] = {.lex_state = 55},
  [5953] = {.lex_state = 0},
  [5954] = {.lex_state = 116},
  [5955] = {.lex_state = 55},
  [5956] = {.lex_state = 0},
  [5957] = {.lex_state = 0},
  [5958] = {.lex_state = 0},
  [5959] = {.lex_state = 0},
  [5960] = {.lex_state = 0},
  [5961] = {.lex_state = 0},
  [5962] = {.lex_state = 0},
  [5963] = {.lex_state = 0},
  [5964] = {.lex_state = 0},
  [5965] = {.lex_state = 0},
  [5966] = {.lex_state = 0},
  [5967] = {.lex_state = 0},
  [5968] = {.lex_state = 0},
  [5969] = {.lex_state = 0},
  [5970] = {.lex_state = 0},
  [5971] = {.lex_state = 0},
  [5972] = {.lex_state = 160},
  [5973] = {.lex_state = 0},
  [5974] = {.lex_state = 0},
  [5975] = {.lex_state = 0},
  [5976] = {.lex_state = 144},
  [5977] = {.lex_state = 160},
  [5978] = {.lex_state = 144},
  [5979] = {.lex_state = 0},
  [5980] = {.lex_state = 55},
  [5981] = {.lex_state = 0},
  [5982] = {.lex_state = 0},
  [5983] = {.lex_state = 0},
  [5984] = {.lex_state = 0},
  [5985] = {.lex_state = 0},
  [5986] = {.lex_state = 0},
  [5987] = {.lex_state = 0},
  [5988] = {.lex_state = 0},
  [5989] = {.lex_state = 160},
  [5990] = {.lex_state = 0},
  [5991] = {.lex_state = 160},
  [5992] = {.lex_state = 55},
  [5993] = {.lex_state = 0},
  [5994] = {.lex_state = 0},
  [5995] = {.lex_state = 0},
  [5996] = {.lex_state = 116},
  [5997] = {.lex_state = 0},
  [5998] = {.lex_state = 160},
  [5999] = {.lex_state = 160},
  [6000] = {.lex_state = 0},
  [6001] = {.lex_state = 0},
  [6002] = {.lex_state = 0},
  [6003] = {.lex_state = 0},
  [6004] = {.lex_state = 160},
  [6005] = {.lex_state = 160},
  [6006] = {.lex_state = 0},
  [6007] = {.lex_state = 116},
  [6008] = {.lex_state = 0},
  [6009] = {.lex_state = 0},
  [6010] = {.lex_state = 0},
  [6011] = {.lex_state = 214},
  [6012] = {.lex_state = 160},
  [6013] = {.lex_state = 0},
  [6014] = {.lex_state = 0},
  [6015] = {.lex_state = 0},
  [6016] = {.lex_state = 160},
  [6017] = {.lex_state = 0},
  [6018] = {.lex_state = 144},
  [6019] = {.lex_state = 0},
  [6020] = {.lex_state = 0},
  [6021] = {.lex_state = 0},
  [6022] = {.lex_state = 0},
  [6023] = {.lex_state = 160},
  [6024] = {.lex_state = 116},
  [6025] = {.lex_state = 160},
  [6026] = {.lex_state = 160},
  [6027] = {.lex_state = 0},
  [6028] = {.lex_state = 160},
  [6029] = {.lex_state = 160},
  [6030] = {.lex_state = 0},
  [6031] = {.lex_state = 0},
  [6032] = {.lex_state = 0},
  [6033] = {.lex_state = 0},
  [6034] = {.lex_state = 0},
  [6035] = {.lex_state = 0},
  [6036] = {.lex_state = 0},
  [6037] = {.lex_state = 0},
  [6038] = {.lex_state = 0},
  [6039] = {.lex_state = 0},
  [6040] = {.lex_state = 0},
  [6041] = {.lex_state = 0},
  [6042] = {.lex_state = 0},
  [6043] = {.lex_state = 160},
  [6044] = {.lex_state = 0},
  [6045] = {.lex_state = 0},
  [6046] = {.lex_state = 0},
  [6047] = {.lex_state = 0},
  [6048] = {.lex_state = 0},
  [6049] = {.lex_state = 0},
  [6050] = {.lex_state = 160},
  [6051] = {.lex_state = 0},
  [6052] = {.lex_state = 0},
  [6053] = {.lex_state = 0},
  [6054] = {.lex_state = 0},
  [6055] = {.lex_state = 0},
  [6056] = {.lex_state = 0},
  [6057] = {.lex_state = 0},
  [6058] = {.lex_state = 0},
  [6059] = {.lex_state = 160},
  [6060] = {.lex_state = 55},
  [6061] = {.lex_state = 0},
  [6062] = {.lex_state = 0},
  [6063] = {.lex_state = 0},
  [6064] = {.lex_state = 214},
  [6065] = {.lex_state = 0},
  [6066] = {.lex_state = 0},
  [6067] = {.lex_state = 0},
  [6068] = {.lex_state = 0},
  [6069] = {.lex_state = 0},
  [6070] = {.lex_state = 214},
  [6071] = {.lex_state = 214},
  [6072] = {.lex_state = 214},
  [6073] = {.lex_state = 0},
  [6074] = {.lex_state = 0},
  [6075] = {.lex_state = 0},
  [6076] = {.lex_state = 0},
  [6077] = {.lex_state = 0},
  [6078] = {.lex_state = 160},
  [6079] = {.lex_state = 0},
  [6080] = {.lex_state = 214},
  [6081] = {.lex_state = 160},
  [6082] = {.lex_state = 0},
  [6083] = {.lex_state = 0},
  [6084] = {.lex_state = 55},
  [6085] = {.lex_state = 0},
  [6086] = {.lex_state = 116},
  [6087] = {.lex_state = 160},
  [6088] = {.lex_state = 214},
  [6089] = {.lex_state = 0},
  [6090] = {.lex_state = 0},
  [6091] = {.lex_state = 160},
  [6092] = {.lex_state = 116},
  [6093] = {.lex_state = 0},
  [6094] = {.lex_state = 0},
  [6095] = {.lex_state = 0},
  [6096] = {.lex_state = 116},
  [6097] = {.lex_state = 0},
  [6098] = {.lex_state = 0},
  [6099] = {.lex_state = 0},
  [6100] = {.lex_state = 0},
  [6101] = {.lex_state = 0},
  [6102] = {.lex_state = 0},
  [6103] = {.lex_state = 0},
  [6104] = {.lex_state = 0},
  [6105] = {.lex_state = 214},
  [6106] = {.lex_state = 0},
  [6107] = {.lex_state = 0},
  [6108] = {.lex_state = 160},
  [6109] = {.lex_state = 0},
  [6110] = {.lex_state = 0},
  [6111] = {.lex_state = 0},
  [6112] = {.lex_state = 0},
  [6113] = {.lex_state = 0},
  [6114] = {.lex_state = 0},
  [6115] = {.lex_state = 0},
  [6116] = {.lex_state = 0},
  [6117] = {.lex_state = 55},
  [6118] = {.lex_state = 0},
  [6119] = {.lex_state = 0},
  [6120] = {.lex_state = 160},
  [6121] = {.lex_state = 214},
  [6122] = {.lex_state = 214},
  [6123] = {.lex_state = 160},
  [6124] = {.lex_state = 0},
  [6125] = {.lex_state = 0},
  [6126] = {.lex_state = 0},
  [6127] = {.lex_state = 160},
  [6128] = {.lex_state = 0},
  [6129] = {.lex_state = 214},
  [6130] = {.lex_state = 0},
  [6131] = {.lex_state = 214},
  [6132] = {.lex_state = 160},
  [6133] = {.lex_state = 0},
  [6134] = {.lex_state = 0},
  [6135] = {.lex_state = 214},
  [6136] = {.lex_state = 0},
  [6137] = {.lex_state = 0},
  [6138] = {.lex_state = 160},
  [6139] = {.lex_state = 0},
  [6140] = {.lex_state = 0},
  [6141] = {.lex_state = 0},
  [6142] = {.lex_state = 160},
  [6143] = {.lex_state = 116},
  [6144] = {.lex_state = 116},
  [6145] = {.lex_state = 214},
  [6146] = {.lex_state = 0},
  [6147] = {.lex_state = 0},
  [6148] = {.lex_state = 0},
  [6149] = {.lex_state = 0},
  [6150] = {.lex_state = 160},
  [6151] = {.lex_state = 160},
  [6152] = {.lex_state = 214},
  [6153] = {.lex_state = 0},
  [6154] = {.lex_state = 0},
  [6155] = {.lex_state = 160},
  [6156] = {.lex_state = 160},
  [6157] = {.lex_state = 214},
  [6158] = {.lex_state = 0},
  [6159] = {.lex_state = 0},
  [6160] = {.lex_state = 160},
  [6161] = {.lex_state = 0},
  [6162] = {.lex_state = 0},
  [6163] = {.lex_state = 55},
  [6164] = {.lex_state = 116},
  [6165] = {.lex_state = 214},
  [6166] = {.lex_state = 55},
  [6167] = {.lex_state = 116},
  [6168] = {.lex_state = 0},
  [6169] = {.lex_state = 0},
  [6170] = {.lex_state = 160},
  [6171] = {.lex_state = 116},
  [6172] = {.lex_state = 214},
  [6173] = {.lex_state = 0},
  [6174] = {.lex_state = 55},
  [6175] = {.lex_state = 0},
  [6176] = {.lex_state = 0},
  [6177] = {.lex_state = 214},
  [6178] = {.lex_state = 116},
  [6179] = {.lex_state = 0},
  [6180] = {.lex_state = 160},
  [6181] = {.lex_state = 0},
  [6182] = {.lex_state = 0},
  [6183] = {.lex_state = 0},
  [6184] = {.lex_state = 0},
  [6185] = {.lex_state = 214},
  [6186] = {.lex_state = 0},
  [6187] = {.lex_state = 55},
  [6188] = {.lex_state = 0},
  [6189] = {.lex_state = 0},
  [6190] = {.lex_state = 160},
  [6191] = {.lex_state = 116},
  [6192] = {.lex_state = 214},
  [6193] = {.lex_state = 0},
  [6194] = {.lex_state = 0},
  [6195] = {.lex_state = 0},
  [6196] = {.lex_state = 214},
  [6197] = {.lex_state = 0},
  [6198] = {.lex_state = 160},
  [6199] = {.lex_state = 0},
  [6200] = {.lex_state = 55},
  [6201] = {.lex_state = 116},
  [6202] = {.lex_state = 0},
  [6203] = {.lex_state = 214},
  [6204] = {.lex_state = 0},
  [6205] = {.lex_state = 214},
  [6206] = {.lex_state = 116},
  [6207] = {.lex_state = 0},
  [6208] = {.lex_state = 214},
  [6209] = {.lex_state = 0},
  [6210] = {.lex_state = 214},
  [6211] = {.lex_state = 116},
  [6212] = {.lex_state = 160},
  [6213] = {.lex_state = 0},
  [6214] = {.lex_state = 0},
  [6215] = {.lex_state = 160},
  [6216] = {.lex_state = 214},
  [6217] = {.lex_state = 0},
  [6218] = {.lex_state = 214},
  [6219] = {.lex_state = 0},
  [6220] = {.lex_state = 214},
  [6221] = {.lex_state = 214},
  [6222] = {.lex_state = 214},
  [6223] = {.lex_state = 0},
  [6224] = {.lex_state = 0},
  [6225] = {.lex_state = 0},
  [6226] = {.lex_state = 144},
  [6227] = {.lex_state = 0},
  [6228] = {.lex_state = 0},
  [6229] = {.lex_state = 0},
  [6230] = {.lex_state = 0},
  [6231] = {.lex_state = 0},
  [6232] = {.lex_state = 0},
  [6233] = {.lex_state = 0},
  [6234] = {.lex_state = 0},
  [6235] = {.lex_state = 116},
  [6236] = {.lex_state = 214},
  [6237] = {.lex_state = 214},
  [6238] = {.lex_state = 0},
  [6239] = {.lex_state = 214},
  [6240] = {.lex_state = 214},
  [6241] = {.lex_state = 214},
  [6242] = {.lex_state = 214},
  [6243] = {.lex_state = 0},
  [6244] = {.lex_state = 214},
  [6245] = {.lex_state = 214},
  [6246] = {.lex_state = 160},
  [6247] = {.lex_state = 160},
  [6248] = {.lex_state = 214},
  [6249] = {.lex_state = 214},
  [6250] = {.lex_state = 160},
  [6251] = {.lex_state = 214},
};

enum {
  ts_external_token_raw_string_literal = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_raw_string_literal] = sym_raw_string_literal,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_raw_string_literal] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [aux_sym_preproc_include_token1] = ACTIONS(1),
    [aux_sym_preproc_def_token1] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [aux_sym_preproc_if_token1] = ACTIONS(1),
    [aux_sym_preproc_if_token2] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1),
    [aux_sym_preproc_else_token1] = ACTIONS(1),
    [aux_sym_preproc_elif_token1] = ACTIONS(1),
    [sym_preproc_directive] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_defined] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym___device__] = ACTIONS(1),
    [anon_sym___host__] = ACTIONS(1),
    [anon_sym___global__] = ACTIONS(1),
    [anon_sym___forceinline__] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_typedef] = ACTIONS(1),
    [anon_sym_extern] = ACTIONS(1),
    [anon_sym___attribute__] = ACTIONS(1),
    [anon_sym___declspec] = ACTIONS(1),
    [anon_sym___based] = ACTIONS(1),
    [anon_sym___cdecl] = ACTIONS(1),
    [anon_sym___clrcall] = ACTIONS(1),
    [anon_sym___stdcall] = ACTIONS(1),
    [anon_sym___fastcall] = ACTIONS(1),
    [anon_sym___thiscall] = ACTIONS(1),
    [anon_sym___vectorcall] = ACTIONS(1),
    [sym_ms_restrict_modifier] = ACTIONS(1),
    [sym_ms_unsigned_ptr_modifier] = ACTIONS(1),
    [sym_ms_signed_ptr_modifier] = ACTIONS(1),
    [anon_sym__unaligned] = ACTIONS(1),
    [anon_sym___unaligned] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_register] = ACTIONS(1),
    [anon_sym_inline] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_restrict] = ACTIONS(1),
    [anon_sym__Atomic] = ACTIONS(1),
    [anon_sym_mutable] = ACTIONS(1),
    [anon_sym_constexpr] = ACTIONS(1),
    [anon_sym___shared__] = ACTIONS(1),
    [anon_sym___local__] = ACTIONS(1),
    [anon_sym___constant__] = ACTIONS(1),
    [anon_sym___restrict__] = ACTIONS(1),
    [anon_sym_signed] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [sym_primitive_type] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_sizeof] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [sym_number_literal] = ACTIONS(1),
    [anon_sym_L_SQUOTE] = ACTIONS(1),
    [anon_sym_u_SQUOTE] = ACTIONS(1),
    [anon_sym_U_SQUOTE] = ACTIONS(1),
    [anon_sym_u8_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_L_DQUOTE] = ACTIONS(1),
    [anon_sym_u_DQUOTE] = ACTIONS(1),
    [anon_sym_U_DQUOTE] = ACTIONS(1),
    [anon_sym_u8_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(1),
    [anon_sym_final] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_virtual] = ACTIONS(1),
    [anon_sym_explicit] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [sym_auto] = ACTIONS(1),
    [anon_sym_typename] = ACTIONS(1),
    [anon_sym_template] = ACTIONS(1),
    [anon_sym_GT2] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_operator] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_friend] = ACTIONS(1),
    [anon_sym_noexcept] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_static_assert] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [sym_operator_name] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_nullptr] = ACTIONS(1),
    [aux_sym_kernel_call_syntax_token1] = ACTIONS(1),
    [aux_sym_kernel_call_syntax_token2] = ACTIONS(1),
    [sym_raw_string_literal] = ACTIONS(1),
  },
  [1] = {
    [sym_translation_unit] = STATE(6199),
    [sym_preproc_include] = STATE(68),
    [sym_preproc_def] = STATE(68),
    [sym_preproc_function_def] = STATE(68),
    [sym_preproc_call] = STATE(68),
    [sym_preproc_if] = STATE(68),
    [sym_preproc_ifdef] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_declaration] = STATE(68),
    [sym_type_definition] = STATE(68),
    [sym__declaration_specifiers] = STATE(4088),
    [sym_linkage_specification] = STATE(68),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2195),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4534),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(68),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3237),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(68),
    [sym_expression_statement] = STATE(68),
    [sym_if_statement] = STATE(68),
    [sym_switch_statement] = STATE(68),
    [sym_case_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_do_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_return_statement] = STATE(68),
    [sym_break_statement] = STATE(68),
    [sym_continue_statement] = STATE(68),
    [sym_goto_statement] = STATE(68),
    [sym__expression] = STATE(3451),
    [sym_comma_expression] = STATE(6193),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(68),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2113),
    [sym_explicit_function_specifier] = STATE(2113),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(68),
    [sym_template_instantiation] = STATE(68),
    [sym_operator_cast] = STATE(4702),
    [aux_sym__constructor_specifiers] = STATE(2113),
    [sym_operator_cast_definition] = STATE(68),
    [sym_operator_cast_declaration] = STATE(68),
    [sym_constructor_or_destructor_definition] = STATE(68),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(68),
    [sym_using_declaration] = STATE(68),
    [sym_alias_declaration] = STATE(68),
    [sym_static_assert_declaration] = STATE(68),
    [sym_for_range_loop] = STATE(68),
    [sym_throw_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_attribute] = STATE(1643),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(68),
    [aux_sym_function_definition_repeat1] = STATE(1028),
    [aux_sym_function_definition_repeat2] = STATE(1643),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [aux_sym_preproc_include_token1] = ACTIONS(9),
    [aux_sym_preproc_def_token1] = ACTIONS(11),
    [aux_sym_preproc_if_token1] = ACTIONS(13),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(15),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(15),
    [sym_preproc_directive] = ACTIONS(17),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(33),
    [anon_sym___host__] = ACTIONS(33),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_typedef] = ACTIONS(39),
    [anon_sym_extern] = ACTIONS(41),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [anon_sym_case] = ACTIONS(75),
    [anon_sym_default] = ACTIONS(77),
    [anon_sym_while] = ACTIONS(79),
    [anon_sym_do] = ACTIONS(81),
    [anon_sym_for] = ACTIONS(83),
    [anon_sym_return] = ACTIONS(85),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_goto] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(115),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(123),
    [anon_sym_namespace] = ACTIONS(125),
    [anon_sym_using] = ACTIONS(127),
    [anon_sym_static_assert] = ACTIONS(129),
    [anon_sym_try] = ACTIONS(131),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [2] = {
    [sym_preproc_include] = STATE(30),
    [sym_preproc_def] = STATE(30),
    [sym_preproc_function_def] = STATE(30),
    [sym_preproc_call] = STATE(30),
    [sym_preproc_if] = STATE(30),
    [sym_preproc_ifdef] = STATE(30),
    [sym_function_definition] = STATE(30),
    [sym_declaration] = STATE(30),
    [sym_type_definition] = STATE(30),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(30),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(30),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(30),
    [sym_expression_statement] = STATE(30),
    [sym_if_statement] = STATE(30),
    [sym_switch_statement] = STATE(30),
    [sym_case_statement] = STATE(30),
    [sym_while_statement] = STATE(30),
    [sym_do_statement] = STATE(30),
    [sym_for_statement] = STATE(30),
    [sym_return_statement] = STATE(30),
    [sym_break_statement] = STATE(30),
    [sym_continue_statement] = STATE(30),
    [sym_goto_statement] = STATE(30),
    [sym__expression] = STATE(3276),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_initializer_list] = STATE(5112),
    [sym_initializer_pair] = STATE(5112),
    [sym_subscript_designator] = STATE(4694),
    [sym_field_designator] = STATE(4694),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(30),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(30),
    [sym_template_instantiation] = STATE(30),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(30),
    [sym_operator_cast_declaration] = STATE(30),
    [sym_constructor_or_destructor_definition] = STATE(30),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(30),
    [sym_using_declaration] = STATE(30),
    [sym_alias_declaration] = STATE(30),
    [sym_static_assert_declaration] = STATE(30),
    [sym_for_range_loop] = STATE(30),
    [sym_throw_statement] = STATE(30),
    [sym_try_statement] = STATE(30),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(30),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [aux_sym_initializer_pair_repeat1] = STATE(4694),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [anon_sym_COMMA] = ACTIONS(147),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(163),
    [anon_sym_RBRACE] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [anon_sym_DOT] = ACTIONS(191),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [3] = {
    [sym_preproc_include] = STATE(32),
    [sym_preproc_def] = STATE(32),
    [sym_preproc_function_def] = STATE(32),
    [sym_preproc_call] = STATE(32),
    [sym_preproc_if] = STATE(32),
    [sym_preproc_ifdef] = STATE(32),
    [sym_function_definition] = STATE(32),
    [sym_declaration] = STATE(32),
    [sym_type_definition] = STATE(32),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(32),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(32),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(32),
    [sym_expression_statement] = STATE(32),
    [sym_if_statement] = STATE(32),
    [sym_switch_statement] = STATE(32),
    [sym_case_statement] = STATE(32),
    [sym_while_statement] = STATE(32),
    [sym_do_statement] = STATE(32),
    [sym_for_statement] = STATE(32),
    [sym_return_statement] = STATE(32),
    [sym_break_statement] = STATE(32),
    [sym_continue_statement] = STATE(32),
    [sym_goto_statement] = STATE(32),
    [sym__expression] = STATE(3276),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_initializer_list] = STATE(5112),
    [sym_initializer_pair] = STATE(5112),
    [sym_subscript_designator] = STATE(4694),
    [sym_field_designator] = STATE(4694),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(32),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(32),
    [sym_template_instantiation] = STATE(32),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(32),
    [sym_operator_cast_declaration] = STATE(32),
    [sym_constructor_or_destructor_definition] = STATE(32),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(32),
    [sym_using_declaration] = STATE(32),
    [sym_alias_declaration] = STATE(32),
    [sym_static_assert_declaration] = STATE(32),
    [sym_for_range_loop] = STATE(32),
    [sym_throw_statement] = STATE(32),
    [sym_try_statement] = STATE(32),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(32),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [aux_sym_initializer_pair_repeat1] = STATE(4694),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [anon_sym_COMMA] = ACTIONS(147),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(163),
    [anon_sym_RBRACE] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [anon_sym_DOT] = ACTIONS(191),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [4] = {
    [sym_preproc_include] = STATE(69),
    [sym_preproc_def] = STATE(69),
    [sym_preproc_function_def] = STATE(69),
    [sym_preproc_call] = STATE(69),
    [sym_preproc_if] = STATE(69),
    [sym_preproc_ifdef] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_declaration] = STATE(69),
    [sym_type_definition] = STATE(69),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(69),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(69),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(69),
    [sym_expression_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_case_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_return_statement] = STATE(69),
    [sym_break_statement] = STATE(69),
    [sym_continue_statement] = STATE(69),
    [sym_goto_statement] = STATE(69),
    [sym__expression] = STATE(3276),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_initializer_list] = STATE(5112),
    [sym_initializer_pair] = STATE(5112),
    [sym_subscript_designator] = STATE(4694),
    [sym_field_designator] = STATE(4694),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(69),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(69),
    [sym_template_instantiation] = STATE(69),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(69),
    [sym_operator_cast_declaration] = STATE(69),
    [sym_constructor_or_destructor_definition] = STATE(69),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(69),
    [sym_using_declaration] = STATE(69),
    [sym_alias_declaration] = STATE(69),
    [sym_static_assert_declaration] = STATE(69),
    [sym_for_range_loop] = STATE(69),
    [sym_throw_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(69),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [aux_sym_initializer_pair_repeat1] = STATE(4694),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [anon_sym_COMMA] = ACTIONS(147),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(163),
    [anon_sym_RBRACE] = ACTIONS(207),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [anon_sym_DOT] = ACTIONS(191),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [5] = {
    [sym_preproc_include] = STATE(73),
    [sym_preproc_def] = STATE(73),
    [sym_preproc_function_def] = STATE(73),
    [sym_preproc_call] = STATE(73),
    [sym_preproc_if] = STATE(73),
    [sym_preproc_ifdef] = STATE(73),
    [sym_function_definition] = STATE(73),
    [sym_declaration] = STATE(73),
    [sym_type_definition] = STATE(73),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(73),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(73),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(73),
    [sym_expression_statement] = STATE(73),
    [sym_if_statement] = STATE(73),
    [sym_switch_statement] = STATE(73),
    [sym_case_statement] = STATE(73),
    [sym_while_statement] = STATE(73),
    [sym_do_statement] = STATE(73),
    [sym_for_statement] = STATE(73),
    [sym_return_statement] = STATE(73),
    [sym_break_statement] = STATE(73),
    [sym_continue_statement] = STATE(73),
    [sym_goto_statement] = STATE(73),
    [sym__expression] = STATE(3276),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_initializer_list] = STATE(5112),
    [sym_initializer_pair] = STATE(5112),
    [sym_subscript_designator] = STATE(4694),
    [sym_field_designator] = STATE(4694),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(73),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(73),
    [sym_template_instantiation] = STATE(73),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(73),
    [sym_operator_cast_declaration] = STATE(73),
    [sym_constructor_or_destructor_definition] = STATE(73),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(73),
    [sym_using_declaration] = STATE(73),
    [sym_alias_declaration] = STATE(73),
    [sym_static_assert_declaration] = STATE(73),
    [sym_for_range_loop] = STATE(73),
    [sym_throw_statement] = STATE(73),
    [sym_try_statement] = STATE(73),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(73),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [aux_sym_initializer_pair_repeat1] = STATE(4694),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [anon_sym_COMMA] = ACTIONS(147),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(163),
    [anon_sym_RBRACE] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [anon_sym_DOT] = ACTIONS(191),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [6] = {
    [sym_preproc_include] = STATE(37),
    [sym_preproc_def] = STATE(37),
    [sym_preproc_function_def] = STATE(37),
    [sym_preproc_call] = STATE(37),
    [sym_preproc_if] = STATE(37),
    [sym_preproc_ifdef] = STATE(37),
    [sym_function_definition] = STATE(37),
    [sym_declaration] = STATE(37),
    [sym_type_definition] = STATE(37),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(37),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(37),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(37),
    [sym_expression_statement] = STATE(37),
    [sym_if_statement] = STATE(37),
    [sym_switch_statement] = STATE(37),
    [sym_case_statement] = STATE(37),
    [sym_while_statement] = STATE(37),
    [sym_do_statement] = STATE(37),
    [sym_for_statement] = STATE(37),
    [sym_return_statement] = STATE(37),
    [sym_break_statement] = STATE(37),
    [sym_continue_statement] = STATE(37),
    [sym_goto_statement] = STATE(37),
    [sym__expression] = STATE(3276),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_initializer_list] = STATE(5112),
    [sym_initializer_pair] = STATE(5112),
    [sym_subscript_designator] = STATE(4694),
    [sym_field_designator] = STATE(4694),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(37),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(37),
    [sym_template_instantiation] = STATE(37),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(37),
    [sym_operator_cast_declaration] = STATE(37),
    [sym_constructor_or_destructor_definition] = STATE(37),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(37),
    [sym_using_declaration] = STATE(37),
    [sym_alias_declaration] = STATE(37),
    [sym_static_assert_declaration] = STATE(37),
    [sym_for_range_loop] = STATE(37),
    [sym_throw_statement] = STATE(37),
    [sym_try_statement] = STATE(37),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(37),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [aux_sym_initializer_pair_repeat1] = STATE(4694),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [anon_sym_COMMA] = ACTIONS(147),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(163),
    [anon_sym_RBRACE] = ACTIONS(211),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [anon_sym_DOT] = ACTIONS(191),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [7] = {
    [sym_preproc_include] = STATE(73),
    [sym_preproc_def] = STATE(73),
    [sym_preproc_function_def] = STATE(73),
    [sym_preproc_call] = STATE(73),
    [sym_preproc_if] = STATE(73),
    [sym_preproc_ifdef] = STATE(73),
    [sym_function_definition] = STATE(73),
    [sym_declaration] = STATE(73),
    [sym_type_definition] = STATE(73),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(73),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(73),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(73),
    [sym_expression_statement] = STATE(73),
    [sym_if_statement] = STATE(73),
    [sym_switch_statement] = STATE(73),
    [sym_case_statement] = STATE(73),
    [sym_while_statement] = STATE(73),
    [sym_do_statement] = STATE(73),
    [sym_for_statement] = STATE(73),
    [sym_return_statement] = STATE(73),
    [sym_break_statement] = STATE(73),
    [sym_continue_statement] = STATE(73),
    [sym_goto_statement] = STATE(73),
    [sym__expression] = STATE(3276),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_initializer_list] = STATE(5112),
    [sym_initializer_pair] = STATE(5112),
    [sym_subscript_designator] = STATE(4694),
    [sym_field_designator] = STATE(4694),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(73),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(73),
    [sym_template_instantiation] = STATE(73),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(73),
    [sym_operator_cast_declaration] = STATE(73),
    [sym_constructor_or_destructor_definition] = STATE(73),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(73),
    [sym_using_declaration] = STATE(73),
    [sym_alias_declaration] = STATE(73),
    [sym_static_assert_declaration] = STATE(73),
    [sym_for_range_loop] = STATE(73),
    [sym_throw_statement] = STATE(73),
    [sym_try_statement] = STATE(73),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(73),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [aux_sym_initializer_pair_repeat1] = STATE(4694),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [anon_sym_COMMA] = ACTIONS(147),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(163),
    [anon_sym_RBRACE] = ACTIONS(213),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [anon_sym_DOT] = ACTIONS(191),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [8] = {
    [sym_preproc_include] = STATE(35),
    [sym_preproc_def] = STATE(35),
    [sym_preproc_function_def] = STATE(35),
    [sym_preproc_call] = STATE(35),
    [sym_preproc_if] = STATE(35),
    [sym_preproc_ifdef] = STATE(35),
    [sym_function_definition] = STATE(35),
    [sym_declaration] = STATE(35),
    [sym_type_definition] = STATE(35),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(35),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(35),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(35),
    [sym_expression_statement] = STATE(35),
    [sym_if_statement] = STATE(35),
    [sym_switch_statement] = STATE(35),
    [sym_case_statement] = STATE(35),
    [sym_while_statement] = STATE(35),
    [sym_do_statement] = STATE(35),
    [sym_for_statement] = STATE(35),
    [sym_return_statement] = STATE(35),
    [sym_break_statement] = STATE(35),
    [sym_continue_statement] = STATE(35),
    [sym_goto_statement] = STATE(35),
    [sym__expression] = STATE(3276),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_initializer_list] = STATE(5112),
    [sym_initializer_pair] = STATE(5112),
    [sym_subscript_designator] = STATE(4694),
    [sym_field_designator] = STATE(4694),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(35),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(35),
    [sym_template_instantiation] = STATE(35),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(35),
    [sym_operator_cast_declaration] = STATE(35),
    [sym_constructor_or_destructor_definition] = STATE(35),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(35),
    [sym_using_declaration] = STATE(35),
    [sym_alias_declaration] = STATE(35),
    [sym_static_assert_declaration] = STATE(35),
    [sym_for_range_loop] = STATE(35),
    [sym_throw_statement] = STATE(35),
    [sym_try_statement] = STATE(35),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(35),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [aux_sym_initializer_pair_repeat1] = STATE(4694),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [anon_sym_COMMA] = ACTIONS(147),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(163),
    [anon_sym_RBRACE] = ACTIONS(215),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [anon_sym_DOT] = ACTIONS(191),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [9] = {
    [sym_preproc_include] = STATE(60),
    [sym_preproc_def] = STATE(60),
    [sym_preproc_function_def] = STATE(60),
    [sym_preproc_call] = STATE(60),
    [sym_preproc_if] = STATE(60),
    [sym_preproc_ifdef] = STATE(60),
    [sym_function_definition] = STATE(60),
    [sym_declaration] = STATE(60),
    [sym_type_definition] = STATE(60),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(60),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(60),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(60),
    [sym_expression_statement] = STATE(60),
    [sym_if_statement] = STATE(60),
    [sym_switch_statement] = STATE(60),
    [sym_case_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_do_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_return_statement] = STATE(60),
    [sym_break_statement] = STATE(60),
    [sym_continue_statement] = STATE(60),
    [sym_goto_statement] = STATE(60),
    [sym__expression] = STATE(3276),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_initializer_list] = STATE(5112),
    [sym_initializer_pair] = STATE(5112),
    [sym_subscript_designator] = STATE(4694),
    [sym_field_designator] = STATE(4694),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(60),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(60),
    [sym_template_instantiation] = STATE(60),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(60),
    [sym_operator_cast_declaration] = STATE(60),
    [sym_constructor_or_destructor_definition] = STATE(60),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(60),
    [sym_using_declaration] = STATE(60),
    [sym_alias_declaration] = STATE(60),
    [sym_static_assert_declaration] = STATE(60),
    [sym_for_range_loop] = STATE(60),
    [sym_throw_statement] = STATE(60),
    [sym_try_statement] = STATE(60),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(60),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [aux_sym_initializer_pair_repeat1] = STATE(4694),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [anon_sym_COMMA] = ACTIONS(147),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(163),
    [anon_sym_RBRACE] = ACTIONS(217),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [anon_sym_DOT] = ACTIONS(191),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [10] = {
    [sym_preproc_include] = STATE(28),
    [sym_preproc_def] = STATE(28),
    [sym_preproc_function_def] = STATE(28),
    [sym_preproc_call] = STATE(28),
    [sym_preproc_if] = STATE(28),
    [sym_preproc_ifdef] = STATE(28),
    [sym_preproc_else] = STATE(5799),
    [sym_preproc_elif] = STATE(5799),
    [sym_function_definition] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_type_definition] = STATE(28),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(28),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(28),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_case_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_goto_statement] = STATE(28),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(28),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(28),
    [sym_template_instantiation] = STATE(28),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(28),
    [sym_operator_cast_declaration] = STATE(28),
    [sym_constructor_or_destructor_definition] = STATE(28),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(28),
    [sym_using_declaration] = STATE(28),
    [sym_alias_declaration] = STATE(28),
    [sym_static_assert_declaration] = STATE(28),
    [sym_for_range_loop] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(28),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(227),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [11] = {
    [sym_preproc_include] = STATE(13),
    [sym_preproc_def] = STATE(13),
    [sym_preproc_function_def] = STATE(13),
    [sym_preproc_call] = STATE(13),
    [sym_preproc_if] = STATE(13),
    [sym_preproc_ifdef] = STATE(13),
    [sym_preproc_else] = STATE(6167),
    [sym_preproc_elif] = STATE(6167),
    [sym_function_definition] = STATE(13),
    [sym_declaration] = STATE(13),
    [sym_type_definition] = STATE(13),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(13),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(13),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(13),
    [sym_expression_statement] = STATE(13),
    [sym_if_statement] = STATE(13),
    [sym_switch_statement] = STATE(13),
    [sym_case_statement] = STATE(13),
    [sym_while_statement] = STATE(13),
    [sym_do_statement] = STATE(13),
    [sym_for_statement] = STATE(13),
    [sym_return_statement] = STATE(13),
    [sym_break_statement] = STATE(13),
    [sym_continue_statement] = STATE(13),
    [sym_goto_statement] = STATE(13),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(13),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(13),
    [sym_template_instantiation] = STATE(13),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(13),
    [sym_operator_cast_declaration] = STATE(13),
    [sym_constructor_or_destructor_definition] = STATE(13),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(13),
    [sym_using_declaration] = STATE(13),
    [sym_alias_declaration] = STATE(13),
    [sym_static_assert_declaration] = STATE(13),
    [sym_for_range_loop] = STATE(13),
    [sym_throw_statement] = STATE(13),
    [sym_try_statement] = STATE(13),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(13),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(281),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [12] = {
    [sym_preproc_include] = STATE(28),
    [sym_preproc_def] = STATE(28),
    [sym_preproc_function_def] = STATE(28),
    [sym_preproc_call] = STATE(28),
    [sym_preproc_if] = STATE(28),
    [sym_preproc_ifdef] = STATE(28),
    [sym_preproc_else] = STATE(5842),
    [sym_preproc_elif] = STATE(5842),
    [sym_function_definition] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_type_definition] = STATE(28),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(28),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(28),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_case_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_goto_statement] = STATE(28),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(28),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(28),
    [sym_template_instantiation] = STATE(28),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(28),
    [sym_operator_cast_declaration] = STATE(28),
    [sym_constructor_or_destructor_definition] = STATE(28),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(28),
    [sym_using_declaration] = STATE(28),
    [sym_alias_declaration] = STATE(28),
    [sym_static_assert_declaration] = STATE(28),
    [sym_for_range_loop] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(28),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(283),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [13] = {
    [sym_preproc_include] = STATE(28),
    [sym_preproc_def] = STATE(28),
    [sym_preproc_function_def] = STATE(28),
    [sym_preproc_call] = STATE(28),
    [sym_preproc_if] = STATE(28),
    [sym_preproc_ifdef] = STATE(28),
    [sym_preproc_else] = STATE(6164),
    [sym_preproc_elif] = STATE(6164),
    [sym_function_definition] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_type_definition] = STATE(28),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(28),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(28),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_case_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_goto_statement] = STATE(28),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(28),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(28),
    [sym_template_instantiation] = STATE(28),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(28),
    [sym_operator_cast_declaration] = STATE(28),
    [sym_constructor_or_destructor_definition] = STATE(28),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(28),
    [sym_using_declaration] = STATE(28),
    [sym_alias_declaration] = STATE(28),
    [sym_static_assert_declaration] = STATE(28),
    [sym_for_range_loop] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(28),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(285),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [14] = {
    [sym_preproc_include] = STATE(15),
    [sym_preproc_def] = STATE(15),
    [sym_preproc_function_def] = STATE(15),
    [sym_preproc_call] = STATE(15),
    [sym_preproc_if] = STATE(15),
    [sym_preproc_ifdef] = STATE(15),
    [sym_preproc_else] = STATE(6178),
    [sym_preproc_elif] = STATE(6178),
    [sym_function_definition] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_type_definition] = STATE(15),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(15),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(15),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_case_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_goto_statement] = STATE(15),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(15),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(15),
    [sym_template_instantiation] = STATE(15),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(15),
    [sym_operator_cast_declaration] = STATE(15),
    [sym_constructor_or_destructor_definition] = STATE(15),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(15),
    [sym_using_declaration] = STATE(15),
    [sym_alias_declaration] = STATE(15),
    [sym_static_assert_declaration] = STATE(15),
    [sym_for_range_loop] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(15),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(287),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [15] = {
    [sym_preproc_include] = STATE(28),
    [sym_preproc_def] = STATE(28),
    [sym_preproc_function_def] = STATE(28),
    [sym_preproc_call] = STATE(28),
    [sym_preproc_if] = STATE(28),
    [sym_preproc_ifdef] = STATE(28),
    [sym_preproc_else] = STATE(5854),
    [sym_preproc_elif] = STATE(5854),
    [sym_function_definition] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_type_definition] = STATE(28),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(28),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(28),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_case_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_goto_statement] = STATE(28),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(28),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(28),
    [sym_template_instantiation] = STATE(28),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(28),
    [sym_operator_cast_declaration] = STATE(28),
    [sym_constructor_or_destructor_definition] = STATE(28),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(28),
    [sym_using_declaration] = STATE(28),
    [sym_alias_declaration] = STATE(28),
    [sym_static_assert_declaration] = STATE(28),
    [sym_for_range_loop] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(28),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(289),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [16] = {
    [sym_preproc_include] = STATE(28),
    [sym_preproc_def] = STATE(28),
    [sym_preproc_function_def] = STATE(28),
    [sym_preproc_call] = STATE(28),
    [sym_preproc_if] = STATE(28),
    [sym_preproc_ifdef] = STATE(28),
    [sym_preproc_else] = STATE(6201),
    [sym_preproc_elif] = STATE(6201),
    [sym_function_definition] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_type_definition] = STATE(28),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(28),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(28),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_case_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_goto_statement] = STATE(28),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(28),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(28),
    [sym_template_instantiation] = STATE(28),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(28),
    [sym_operator_cast_declaration] = STATE(28),
    [sym_constructor_or_destructor_definition] = STATE(28),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(28),
    [sym_using_declaration] = STATE(28),
    [sym_alias_declaration] = STATE(28),
    [sym_static_assert_declaration] = STATE(28),
    [sym_for_range_loop] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(28),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(291),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [17] = {
    [sym_preproc_include] = STATE(27),
    [sym_preproc_def] = STATE(27),
    [sym_preproc_function_def] = STATE(27),
    [sym_preproc_call] = STATE(27),
    [sym_preproc_if] = STATE(27),
    [sym_preproc_ifdef] = STATE(27),
    [sym_preproc_else] = STATE(5996),
    [sym_preproc_elif] = STATE(5996),
    [sym_function_definition] = STATE(27),
    [sym_declaration] = STATE(27),
    [sym_type_definition] = STATE(27),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(27),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(27),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_case_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_goto_statement] = STATE(27),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(27),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(27),
    [sym_template_instantiation] = STATE(27),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(27),
    [sym_operator_cast_declaration] = STATE(27),
    [sym_constructor_or_destructor_definition] = STATE(27),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(27),
    [sym_using_declaration] = STATE(27),
    [sym_alias_declaration] = STATE(27),
    [sym_static_assert_declaration] = STATE(27),
    [sym_for_range_loop] = STATE(27),
    [sym_throw_statement] = STATE(27),
    [sym_try_statement] = STATE(27),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(27),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(293),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [18] = {
    [sym_preproc_include] = STATE(21),
    [sym_preproc_def] = STATE(21),
    [sym_preproc_function_def] = STATE(21),
    [sym_preproc_call] = STATE(21),
    [sym_preproc_if] = STATE(21),
    [sym_preproc_ifdef] = STATE(21),
    [sym_preproc_else] = STATE(6007),
    [sym_preproc_elif] = STATE(6007),
    [sym_function_definition] = STATE(21),
    [sym_declaration] = STATE(21),
    [sym_type_definition] = STATE(21),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(21),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(21),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(21),
    [sym_expression_statement] = STATE(21),
    [sym_if_statement] = STATE(21),
    [sym_switch_statement] = STATE(21),
    [sym_case_statement] = STATE(21),
    [sym_while_statement] = STATE(21),
    [sym_do_statement] = STATE(21),
    [sym_for_statement] = STATE(21),
    [sym_return_statement] = STATE(21),
    [sym_break_statement] = STATE(21),
    [sym_continue_statement] = STATE(21),
    [sym_goto_statement] = STATE(21),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(21),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(21),
    [sym_template_instantiation] = STATE(21),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(21),
    [sym_operator_cast_declaration] = STATE(21),
    [sym_constructor_or_destructor_definition] = STATE(21),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(21),
    [sym_using_declaration] = STATE(21),
    [sym_alias_declaration] = STATE(21),
    [sym_static_assert_declaration] = STATE(21),
    [sym_for_range_loop] = STATE(21),
    [sym_throw_statement] = STATE(21),
    [sym_try_statement] = STATE(21),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(21),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(295),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [19] = {
    [sym_preproc_include] = STATE(10),
    [sym_preproc_def] = STATE(10),
    [sym_preproc_function_def] = STATE(10),
    [sym_preproc_call] = STATE(10),
    [sym_preproc_if] = STATE(10),
    [sym_preproc_ifdef] = STATE(10),
    [sym_preproc_else] = STATE(5866),
    [sym_preproc_elif] = STATE(5866),
    [sym_function_definition] = STATE(10),
    [sym_declaration] = STATE(10),
    [sym_type_definition] = STATE(10),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(10),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(10),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(10),
    [sym_expression_statement] = STATE(10),
    [sym_if_statement] = STATE(10),
    [sym_switch_statement] = STATE(10),
    [sym_case_statement] = STATE(10),
    [sym_while_statement] = STATE(10),
    [sym_do_statement] = STATE(10),
    [sym_for_statement] = STATE(10),
    [sym_return_statement] = STATE(10),
    [sym_break_statement] = STATE(10),
    [sym_continue_statement] = STATE(10),
    [sym_goto_statement] = STATE(10),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(10),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(10),
    [sym_template_instantiation] = STATE(10),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(10),
    [sym_operator_cast_declaration] = STATE(10),
    [sym_constructor_or_destructor_definition] = STATE(10),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(10),
    [sym_using_declaration] = STATE(10),
    [sym_alias_declaration] = STATE(10),
    [sym_static_assert_declaration] = STATE(10),
    [sym_for_range_loop] = STATE(10),
    [sym_throw_statement] = STATE(10),
    [sym_try_statement] = STATE(10),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(10),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(297),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [20] = {
    [sym_preproc_include] = STATE(23),
    [sym_preproc_def] = STATE(23),
    [sym_preproc_function_def] = STATE(23),
    [sym_preproc_call] = STATE(23),
    [sym_preproc_if] = STATE(23),
    [sym_preproc_ifdef] = STATE(23),
    [sym_preproc_else] = STATE(5862),
    [sym_preproc_elif] = STATE(5862),
    [sym_function_definition] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_type_definition] = STATE(23),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(23),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(23),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_case_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_goto_statement] = STATE(23),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(23),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(23),
    [sym_template_instantiation] = STATE(23),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(23),
    [sym_operator_cast_declaration] = STATE(23),
    [sym_constructor_or_destructor_definition] = STATE(23),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(23),
    [sym_using_declaration] = STATE(23),
    [sym_alias_declaration] = STATE(23),
    [sym_static_assert_declaration] = STATE(23),
    [sym_for_range_loop] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(23),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(299),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [21] = {
    [sym_preproc_include] = STATE(28),
    [sym_preproc_def] = STATE(28),
    [sym_preproc_function_def] = STATE(28),
    [sym_preproc_call] = STATE(28),
    [sym_preproc_if] = STATE(28),
    [sym_preproc_ifdef] = STATE(28),
    [sym_preproc_else] = STATE(6171),
    [sym_preproc_elif] = STATE(6171),
    [sym_function_definition] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_type_definition] = STATE(28),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(28),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(28),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_case_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_goto_statement] = STATE(28),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(28),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(28),
    [sym_template_instantiation] = STATE(28),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(28),
    [sym_operator_cast_declaration] = STATE(28),
    [sym_constructor_or_destructor_definition] = STATE(28),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(28),
    [sym_using_declaration] = STATE(28),
    [sym_alias_declaration] = STATE(28),
    [sym_static_assert_declaration] = STATE(28),
    [sym_for_range_loop] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(28),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(301),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [22] = {
    [sym_preproc_include] = STATE(28),
    [sym_preproc_def] = STATE(28),
    [sym_preproc_function_def] = STATE(28),
    [sym_preproc_call] = STATE(28),
    [sym_preproc_if] = STATE(28),
    [sym_preproc_ifdef] = STATE(28),
    [sym_preproc_else] = STATE(5727),
    [sym_preproc_elif] = STATE(5727),
    [sym_function_definition] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_type_definition] = STATE(28),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(28),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(28),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_case_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_goto_statement] = STATE(28),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(28),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(28),
    [sym_template_instantiation] = STATE(28),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(28),
    [sym_operator_cast_declaration] = STATE(28),
    [sym_constructor_or_destructor_definition] = STATE(28),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(28),
    [sym_using_declaration] = STATE(28),
    [sym_alias_declaration] = STATE(28),
    [sym_static_assert_declaration] = STATE(28),
    [sym_for_range_loop] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(28),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(303),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [23] = {
    [sym_preproc_include] = STATE(28),
    [sym_preproc_def] = STATE(28),
    [sym_preproc_function_def] = STATE(28),
    [sym_preproc_call] = STATE(28),
    [sym_preproc_if] = STATE(28),
    [sym_preproc_ifdef] = STATE(28),
    [sym_preproc_else] = STATE(5707),
    [sym_preproc_elif] = STATE(5707),
    [sym_function_definition] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_type_definition] = STATE(28),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(28),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(28),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_case_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_goto_statement] = STATE(28),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(28),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(28),
    [sym_template_instantiation] = STATE(28),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(28),
    [sym_operator_cast_declaration] = STATE(28),
    [sym_constructor_or_destructor_definition] = STATE(28),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(28),
    [sym_using_declaration] = STATE(28),
    [sym_alias_declaration] = STATE(28),
    [sym_static_assert_declaration] = STATE(28),
    [sym_for_range_loop] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(28),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(305),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [24] = {
    [sym_preproc_include] = STATE(12),
    [sym_preproc_def] = STATE(12),
    [sym_preproc_function_def] = STATE(12),
    [sym_preproc_call] = STATE(12),
    [sym_preproc_if] = STATE(12),
    [sym_preproc_ifdef] = STATE(12),
    [sym_preproc_else] = STATE(6024),
    [sym_preproc_elif] = STATE(6024),
    [sym_function_definition] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_type_definition] = STATE(12),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(12),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(12),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_case_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_goto_statement] = STATE(12),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(12),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(12),
    [sym_template_instantiation] = STATE(12),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(12),
    [sym_operator_cast_declaration] = STATE(12),
    [sym_constructor_or_destructor_definition] = STATE(12),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(12),
    [sym_using_declaration] = STATE(12),
    [sym_alias_declaration] = STATE(12),
    [sym_static_assert_declaration] = STATE(12),
    [sym_for_range_loop] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(12),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(307),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [25] = {
    [sym_preproc_include] = STATE(22),
    [sym_preproc_def] = STATE(22),
    [sym_preproc_function_def] = STATE(22),
    [sym_preproc_call] = STATE(22),
    [sym_preproc_if] = STATE(22),
    [sym_preproc_ifdef] = STATE(22),
    [sym_preproc_else] = STATE(5801),
    [sym_preproc_elif] = STATE(5801),
    [sym_function_definition] = STATE(22),
    [sym_declaration] = STATE(22),
    [sym_type_definition] = STATE(22),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(22),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(22),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_case_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_goto_statement] = STATE(22),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(22),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(22),
    [sym_template_instantiation] = STATE(22),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(22),
    [sym_operator_cast_declaration] = STATE(22),
    [sym_constructor_or_destructor_definition] = STATE(22),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(22),
    [sym_using_declaration] = STATE(22),
    [sym_alias_declaration] = STATE(22),
    [sym_static_assert_declaration] = STATE(22),
    [sym_for_range_loop] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(22),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(309),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [26] = {
    [sym_preproc_include] = STATE(16),
    [sym_preproc_def] = STATE(16),
    [sym_preproc_function_def] = STATE(16),
    [sym_preproc_call] = STATE(16),
    [sym_preproc_if] = STATE(16),
    [sym_preproc_ifdef] = STATE(16),
    [sym_preproc_else] = STATE(6092),
    [sym_preproc_elif] = STATE(6092),
    [sym_function_definition] = STATE(16),
    [sym_declaration] = STATE(16),
    [sym_type_definition] = STATE(16),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(16),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(16),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(16),
    [sym_expression_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_switch_statement] = STATE(16),
    [sym_case_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_do_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_return_statement] = STATE(16),
    [sym_break_statement] = STATE(16),
    [sym_continue_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(16),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(16),
    [sym_template_instantiation] = STATE(16),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(16),
    [sym_operator_cast_declaration] = STATE(16),
    [sym_constructor_or_destructor_definition] = STATE(16),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(16),
    [sym_using_declaration] = STATE(16),
    [sym_alias_declaration] = STATE(16),
    [sym_static_assert_declaration] = STATE(16),
    [sym_for_range_loop] = STATE(16),
    [sym_throw_statement] = STATE(16),
    [sym_try_statement] = STATE(16),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(16),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(311),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [27] = {
    [sym_preproc_include] = STATE(28),
    [sym_preproc_def] = STATE(28),
    [sym_preproc_function_def] = STATE(28),
    [sym_preproc_call] = STATE(28),
    [sym_preproc_if] = STATE(28),
    [sym_preproc_ifdef] = STATE(28),
    [sym_preproc_else] = STATE(6096),
    [sym_preproc_elif] = STATE(6096),
    [sym_function_definition] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_type_definition] = STATE(28),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(28),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(28),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_case_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_goto_statement] = STATE(28),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(28),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(28),
    [sym_template_instantiation] = STATE(28),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(28),
    [sym_operator_cast_declaration] = STATE(28),
    [sym_constructor_or_destructor_definition] = STATE(28),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(28),
    [sym_using_declaration] = STATE(28),
    [sym_alias_declaration] = STATE(28),
    [sym_static_assert_declaration] = STATE(28),
    [sym_for_range_loop] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(28),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(219),
    [aux_sym_preproc_include_token1] = ACTIONS(221),
    [aux_sym_preproc_def_token1] = ACTIONS(223),
    [aux_sym_preproc_if_token1] = ACTIONS(225),
    [aux_sym_preproc_if_token2] = ACTIONS(313),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(229),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(229),
    [aux_sym_preproc_else_token1] = ACTIONS(231),
    [aux_sym_preproc_elif_token1] = ACTIONS(233),
    [sym_preproc_directive] = ACTIONS(235),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(237),
    [anon_sym___host__] = ACTIONS(237),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_typedef] = ACTIONS(241),
    [anon_sym_extern] = ACTIONS(243),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_goto] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(269),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_namespace] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(275),
    [anon_sym_static_assert] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [28] = {
    [sym_preproc_include] = STATE(28),
    [sym_preproc_def] = STATE(28),
    [sym_preproc_function_def] = STATE(28),
    [sym_preproc_call] = STATE(28),
    [sym_preproc_if] = STATE(28),
    [sym_preproc_ifdef] = STATE(28),
    [sym_function_definition] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_type_definition] = STATE(28),
    [sym__declaration_specifiers] = STATE(4093),
    [sym_linkage_specification] = STATE(28),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2201),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4547),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(28),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3271),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_case_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_goto_statement] = STATE(28),
    [sym__expression] = STATE(3519),
    [sym_comma_expression] = STATE(5879),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(28),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2111),
    [sym_explicit_function_specifier] = STATE(2111),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(28),
    [sym_template_instantiation] = STATE(28),
    [sym_operator_cast] = STATE(4669),
    [aux_sym__constructor_specifiers] = STATE(2111),
    [sym_operator_cast_definition] = STATE(28),
    [sym_operator_cast_declaration] = STATE(28),
    [sym_constructor_or_destructor_definition] = STATE(28),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(28),
    [sym_using_declaration] = STATE(28),
    [sym_alias_declaration] = STATE(28),
    [sym_static_assert_declaration] = STATE(28),
    [sym_for_range_loop] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_attribute] = STATE(1616),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(28),
    [aux_sym_function_definition_repeat1] = STATE(1068),
    [aux_sym_function_definition_repeat2] = STATE(1616),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(315),
    [aux_sym_preproc_include_token1] = ACTIONS(318),
    [aux_sym_preproc_def_token1] = ACTIONS(321),
    [aux_sym_preproc_if_token1] = ACTIONS(324),
    [aux_sym_preproc_if_token2] = ACTIONS(327),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(329),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(329),
    [aux_sym_preproc_else_token1] = ACTIONS(327),
    [aux_sym_preproc_elif_token1] = ACTIONS(327),
    [sym_preproc_directive] = ACTIONS(332),
    [anon_sym_LPAREN2] = ACTIONS(335),
    [anon_sym_BANG] = ACTIONS(338),
    [anon_sym_TILDE] = ACTIONS(341),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_STAR] = ACTIONS(347),
    [anon_sym_AMP_AMP] = ACTIONS(350),
    [anon_sym_AMP] = ACTIONS(353),
    [anon_sym___device__] = ACTIONS(356),
    [anon_sym___host__] = ACTIONS(356),
    [anon_sym___global__] = ACTIONS(359),
    [anon_sym___forceinline__] = ACTIONS(356),
    [anon_sym_SEMI] = ACTIONS(362),
    [anon_sym_typedef] = ACTIONS(365),
    [anon_sym_extern] = ACTIONS(368),
    [anon_sym___attribute__] = ACTIONS(371),
    [anon_sym___declspec] = ACTIONS(374),
    [anon_sym___based] = ACTIONS(377),
    [anon_sym___cdecl] = ACTIONS(380),
    [anon_sym___clrcall] = ACTIONS(380),
    [anon_sym___stdcall] = ACTIONS(380),
    [anon_sym___fastcall] = ACTIONS(380),
    [anon_sym___thiscall] = ACTIONS(380),
    [anon_sym___vectorcall] = ACTIONS(380),
    [anon_sym_LBRACE] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(386),
    [anon_sym_static] = ACTIONS(389),
    [anon_sym_register] = ACTIONS(389),
    [anon_sym_inline] = ACTIONS(389),
    [anon_sym_const] = ACTIONS(392),
    [anon_sym_volatile] = ACTIONS(392),
    [anon_sym_restrict] = ACTIONS(392),
    [anon_sym__Atomic] = ACTIONS(392),
    [anon_sym_mutable] = ACTIONS(392),
    [anon_sym_constexpr] = ACTIONS(392),
    [anon_sym___shared__] = ACTIONS(392),
    [anon_sym___local__] = ACTIONS(392),
    [anon_sym___constant__] = ACTIONS(392),
    [anon_sym___restrict__] = ACTIONS(392),
    [anon_sym_signed] = ACTIONS(395),
    [anon_sym_unsigned] = ACTIONS(395),
    [anon_sym_long] = ACTIONS(395),
    [anon_sym_short] = ACTIONS(395),
    [sym_primitive_type] = ACTIONS(398),
    [anon_sym_enum] = ACTIONS(401),
    [anon_sym_class] = ACTIONS(404),
    [anon_sym_struct] = ACTIONS(407),
    [anon_sym_union] = ACTIONS(410),
    [anon_sym_if] = ACTIONS(413),
    [anon_sym_switch] = ACTIONS(416),
    [anon_sym_case] = ACTIONS(419),
    [anon_sym_default] = ACTIONS(422),
    [anon_sym_while] = ACTIONS(425),
    [anon_sym_do] = ACTIONS(428),
    [anon_sym_for] = ACTIONS(431),
    [anon_sym_return] = ACTIONS(434),
    [anon_sym_break] = ACTIONS(437),
    [anon_sym_continue] = ACTIONS(440),
    [anon_sym_goto] = ACTIONS(443),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_sizeof] = ACTIONS(449),
    [sym_number_literal] = ACTIONS(452),
    [anon_sym_L_SQUOTE] = ACTIONS(455),
    [anon_sym_u_SQUOTE] = ACTIONS(455),
    [anon_sym_U_SQUOTE] = ACTIONS(455),
    [anon_sym_u8_SQUOTE] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(455),
    [anon_sym_L_DQUOTE] = ACTIONS(458),
    [anon_sym_u_DQUOTE] = ACTIONS(458),
    [anon_sym_U_DQUOTE] = ACTIONS(458),
    [anon_sym_u8_DQUOTE] = ACTIONS(458),
    [anon_sym_DQUOTE] = ACTIONS(458),
    [sym_true] = ACTIONS(461),
    [sym_false] = ACTIONS(461),
    [sym_null] = ACTIONS(461),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(464),
    [anon_sym_virtual] = ACTIONS(467),
    [anon_sym_explicit] = ACTIONS(470),
    [sym_auto] = ACTIONS(473),
    [anon_sym_typename] = ACTIONS(476),
    [anon_sym_template] = ACTIONS(479),
    [anon_sym_COLON_COLON] = ACTIONS(482),
    [anon_sym_operator] = ACTIONS(485),
    [anon_sym_delete] = ACTIONS(488),
    [anon_sym_throw] = ACTIONS(491),
    [anon_sym_namespace] = ACTIONS(494),
    [anon_sym_using] = ACTIONS(497),
    [anon_sym_static_assert] = ACTIONS(500),
    [anon_sym_try] = ACTIONS(503),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(506),
    [anon_sym_new] = ACTIONS(509),
    [sym_operator_name] = ACTIONS(512),
    [sym_this] = ACTIONS(461),
    [sym_nullptr] = ACTIONS(461),
    [sym_raw_string_literal] = ACTIONS(515),
  },
  [29] = {
    [sym_preproc_include] = STATE(46),
    [sym_preproc_def] = STATE(46),
    [sym_preproc_function_def] = STATE(46),
    [sym_preproc_call] = STATE(46),
    [sym_preproc_if] = STATE(46),
    [sym_preproc_ifdef] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym_declaration] = STATE(46),
    [sym_type_definition] = STATE(46),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(46),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(46),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(46),
    [sym_expression_statement] = STATE(46),
    [sym_if_statement] = STATE(46),
    [sym_switch_statement] = STATE(46),
    [sym_case_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_do_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_return_statement] = STATE(46),
    [sym_break_statement] = STATE(46),
    [sym_continue_statement] = STATE(46),
    [sym_goto_statement] = STATE(46),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(46),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(46),
    [sym_template_instantiation] = STATE(46),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(46),
    [sym_operator_cast_declaration] = STATE(46),
    [sym_constructor_or_destructor_definition] = STATE(46),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(46),
    [sym_using_declaration] = STATE(46),
    [sym_alias_declaration] = STATE(46),
    [sym_static_assert_declaration] = STATE(46),
    [sym_for_range_loop] = STATE(46),
    [sym_throw_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(46),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(520),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [30] = {
    [sym_preproc_include] = STATE(58),
    [sym_preproc_def] = STATE(58),
    [sym_preproc_function_def] = STATE(58),
    [sym_preproc_call] = STATE(58),
    [sym_preproc_if] = STATE(58),
    [sym_preproc_ifdef] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(58),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_case_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(58),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(58),
    [sym_template_instantiation] = STATE(58),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(58),
    [sym_operator_cast_declaration] = STATE(58),
    [sym_constructor_or_destructor_definition] = STATE(58),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(58),
    [sym_using_declaration] = STATE(58),
    [sym_alias_declaration] = STATE(58),
    [sym_static_assert_declaration] = STATE(58),
    [sym_for_range_loop] = STATE(58),
    [sym_throw_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(58),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(522),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [31] = {
    [sym_preproc_include] = STATE(62),
    [sym_preproc_def] = STATE(62),
    [sym_preproc_function_def] = STATE(62),
    [sym_preproc_call] = STATE(62),
    [sym_preproc_if] = STATE(62),
    [sym_preproc_ifdef] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_declaration] = STATE(62),
    [sym_type_definition] = STATE(62),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(62),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(62),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(62),
    [sym_expression_statement] = STATE(62),
    [sym_if_statement] = STATE(62),
    [sym_switch_statement] = STATE(62),
    [sym_case_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_do_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_return_statement] = STATE(62),
    [sym_break_statement] = STATE(62),
    [sym_continue_statement] = STATE(62),
    [sym_goto_statement] = STATE(62),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(62),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(62),
    [sym_template_instantiation] = STATE(62),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(62),
    [sym_operator_cast_declaration] = STATE(62),
    [sym_constructor_or_destructor_definition] = STATE(62),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(62),
    [sym_using_declaration] = STATE(62),
    [sym_alias_declaration] = STATE(62),
    [sym_static_assert_declaration] = STATE(62),
    [sym_for_range_loop] = STATE(62),
    [sym_throw_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(62),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(524),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [32] = {
    [sym_preproc_include] = STATE(58),
    [sym_preproc_def] = STATE(58),
    [sym_preproc_function_def] = STATE(58),
    [sym_preproc_call] = STATE(58),
    [sym_preproc_if] = STATE(58),
    [sym_preproc_ifdef] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(58),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_case_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(58),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(58),
    [sym_template_instantiation] = STATE(58),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(58),
    [sym_operator_cast_declaration] = STATE(58),
    [sym_constructor_or_destructor_definition] = STATE(58),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(58),
    [sym_using_declaration] = STATE(58),
    [sym_alias_declaration] = STATE(58),
    [sym_static_assert_declaration] = STATE(58),
    [sym_for_range_loop] = STATE(58),
    [sym_throw_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(58),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(526),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [33] = {
    [sym_preproc_include] = STATE(34),
    [sym_preproc_def] = STATE(34),
    [sym_preproc_function_def] = STATE(34),
    [sym_preproc_call] = STATE(34),
    [sym_preproc_if] = STATE(34),
    [sym_preproc_ifdef] = STATE(34),
    [sym_function_definition] = STATE(34),
    [sym_declaration] = STATE(34),
    [sym_type_definition] = STATE(34),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(34),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(34),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_case_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(34),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(34),
    [sym_template_instantiation] = STATE(34),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(34),
    [sym_operator_cast_declaration] = STATE(34),
    [sym_constructor_or_destructor_definition] = STATE(34),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(34),
    [sym_using_declaration] = STATE(34),
    [sym_alias_declaration] = STATE(34),
    [sym_static_assert_declaration] = STATE(34),
    [sym_for_range_loop] = STATE(34),
    [sym_throw_statement] = STATE(34),
    [sym_try_statement] = STATE(34),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(34),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(528),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [34] = {
    [sym_preproc_include] = STATE(58),
    [sym_preproc_def] = STATE(58),
    [sym_preproc_function_def] = STATE(58),
    [sym_preproc_call] = STATE(58),
    [sym_preproc_if] = STATE(58),
    [sym_preproc_ifdef] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(58),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_case_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(58),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(58),
    [sym_template_instantiation] = STATE(58),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(58),
    [sym_operator_cast_declaration] = STATE(58),
    [sym_constructor_or_destructor_definition] = STATE(58),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(58),
    [sym_using_declaration] = STATE(58),
    [sym_alias_declaration] = STATE(58),
    [sym_static_assert_declaration] = STATE(58),
    [sym_for_range_loop] = STATE(58),
    [sym_throw_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(58),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(530),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [35] = {
    [sym_preproc_include] = STATE(58),
    [sym_preproc_def] = STATE(58),
    [sym_preproc_function_def] = STATE(58),
    [sym_preproc_call] = STATE(58),
    [sym_preproc_if] = STATE(58),
    [sym_preproc_ifdef] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(58),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_case_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(58),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(58),
    [sym_template_instantiation] = STATE(58),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(58),
    [sym_operator_cast_declaration] = STATE(58),
    [sym_constructor_or_destructor_definition] = STATE(58),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(58),
    [sym_using_declaration] = STATE(58),
    [sym_alias_declaration] = STATE(58),
    [sym_static_assert_declaration] = STATE(58),
    [sym_for_range_loop] = STATE(58),
    [sym_throw_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(58),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(532),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [36] = {
    [sym_preproc_include] = STATE(35),
    [sym_preproc_def] = STATE(35),
    [sym_preproc_function_def] = STATE(35),
    [sym_preproc_call] = STATE(35),
    [sym_preproc_if] = STATE(35),
    [sym_preproc_ifdef] = STATE(35),
    [sym_function_definition] = STATE(35),
    [sym_declaration] = STATE(35),
    [sym_type_definition] = STATE(35),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(35),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(35),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(35),
    [sym_expression_statement] = STATE(35),
    [sym_if_statement] = STATE(35),
    [sym_switch_statement] = STATE(35),
    [sym_case_statement] = STATE(35),
    [sym_while_statement] = STATE(35),
    [sym_do_statement] = STATE(35),
    [sym_for_statement] = STATE(35),
    [sym_return_statement] = STATE(35),
    [sym_break_statement] = STATE(35),
    [sym_continue_statement] = STATE(35),
    [sym_goto_statement] = STATE(35),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(35),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(35),
    [sym_template_instantiation] = STATE(35),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(35),
    [sym_operator_cast_declaration] = STATE(35),
    [sym_constructor_or_destructor_definition] = STATE(35),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(35),
    [sym_using_declaration] = STATE(35),
    [sym_alias_declaration] = STATE(35),
    [sym_static_assert_declaration] = STATE(35),
    [sym_for_range_loop] = STATE(35),
    [sym_throw_statement] = STATE(35),
    [sym_try_statement] = STATE(35),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(35),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(534),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [37] = {
    [sym_preproc_include] = STATE(58),
    [sym_preproc_def] = STATE(58),
    [sym_preproc_function_def] = STATE(58),
    [sym_preproc_call] = STATE(58),
    [sym_preproc_if] = STATE(58),
    [sym_preproc_ifdef] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(58),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_case_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(58),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(58),
    [sym_template_instantiation] = STATE(58),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(58),
    [sym_operator_cast_declaration] = STATE(58),
    [sym_constructor_or_destructor_definition] = STATE(58),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(58),
    [sym_using_declaration] = STATE(58),
    [sym_alias_declaration] = STATE(58),
    [sym_static_assert_declaration] = STATE(58),
    [sym_for_range_loop] = STATE(58),
    [sym_throw_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(58),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(536),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [38] = {
    [sym_preproc_include] = STATE(37),
    [sym_preproc_def] = STATE(37),
    [sym_preproc_function_def] = STATE(37),
    [sym_preproc_call] = STATE(37),
    [sym_preproc_if] = STATE(37),
    [sym_preproc_ifdef] = STATE(37),
    [sym_function_definition] = STATE(37),
    [sym_declaration] = STATE(37),
    [sym_type_definition] = STATE(37),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(37),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(37),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(37),
    [sym_expression_statement] = STATE(37),
    [sym_if_statement] = STATE(37),
    [sym_switch_statement] = STATE(37),
    [sym_case_statement] = STATE(37),
    [sym_while_statement] = STATE(37),
    [sym_do_statement] = STATE(37),
    [sym_for_statement] = STATE(37),
    [sym_return_statement] = STATE(37),
    [sym_break_statement] = STATE(37),
    [sym_continue_statement] = STATE(37),
    [sym_goto_statement] = STATE(37),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(37),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(37),
    [sym_template_instantiation] = STATE(37),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(37),
    [sym_operator_cast_declaration] = STATE(37),
    [sym_constructor_or_destructor_definition] = STATE(37),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(37),
    [sym_using_declaration] = STATE(37),
    [sym_alias_declaration] = STATE(37),
    [sym_static_assert_declaration] = STATE(37),
    [sym_for_range_loop] = STATE(37),
    [sym_throw_statement] = STATE(37),
    [sym_try_statement] = STATE(37),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(37),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(538),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [39] = {
    [sym_preproc_include] = STATE(58),
    [sym_preproc_def] = STATE(58),
    [sym_preproc_function_def] = STATE(58),
    [sym_preproc_call] = STATE(58),
    [sym_preproc_if] = STATE(58),
    [sym_preproc_ifdef] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(58),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_case_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(58),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(58),
    [sym_template_instantiation] = STATE(58),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(58),
    [sym_operator_cast_declaration] = STATE(58),
    [sym_constructor_or_destructor_definition] = STATE(58),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(58),
    [sym_using_declaration] = STATE(58),
    [sym_alias_declaration] = STATE(58),
    [sym_static_assert_declaration] = STATE(58),
    [sym_for_range_loop] = STATE(58),
    [sym_throw_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(58),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(540),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [40] = {
    [sym_preproc_include] = STATE(42),
    [sym_preproc_def] = STATE(42),
    [sym_preproc_function_def] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym_preproc_if] = STATE(42),
    [sym_preproc_ifdef] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym_declaration] = STATE(42),
    [sym_type_definition] = STATE(42),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(42),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(42),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(42),
    [sym_expression_statement] = STATE(42),
    [sym_if_statement] = STATE(42),
    [sym_switch_statement] = STATE(42),
    [sym_case_statement] = STATE(42),
    [sym_while_statement] = STATE(42),
    [sym_do_statement] = STATE(42),
    [sym_for_statement] = STATE(42),
    [sym_return_statement] = STATE(42),
    [sym_break_statement] = STATE(42),
    [sym_continue_statement] = STATE(42),
    [sym_goto_statement] = STATE(42),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(42),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(42),
    [sym_template_instantiation] = STATE(42),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(42),
    [sym_operator_cast_declaration] = STATE(42),
    [sym_constructor_or_destructor_definition] = STATE(42),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(42),
    [sym_using_declaration] = STATE(42),
    [sym_alias_declaration] = STATE(42),
    [sym_static_assert_declaration] = STATE(42),
    [sym_for_range_loop] = STATE(42),
    [sym_throw_statement] = STATE(42),
    [sym_try_statement] = STATE(42),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(42),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(542),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [41] = {
    [sym_preproc_include] = STATE(58),
    [sym_preproc_def] = STATE(58),
    [sym_preproc_function_def] = STATE(58),
    [sym_preproc_call] = STATE(58),
    [sym_preproc_if] = STATE(58),
    [sym_preproc_ifdef] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(58),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_case_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(58),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(58),
    [sym_template_instantiation] = STATE(58),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(58),
    [sym_operator_cast_declaration] = STATE(58),
    [sym_constructor_or_destructor_definition] = STATE(58),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(58),
    [sym_using_declaration] = STATE(58),
    [sym_alias_declaration] = STATE(58),
    [sym_static_assert_declaration] = STATE(58),
    [sym_for_range_loop] = STATE(58),
    [sym_throw_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(58),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(544),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [42] = {
    [sym_preproc_include] = STATE(58),
    [sym_preproc_def] = STATE(58),
    [sym_preproc_function_def] = STATE(58),
    [sym_preproc_call] = STATE(58),
    [sym_preproc_if] = STATE(58),
    [sym_preproc_ifdef] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(58),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_case_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(58),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(58),
    [sym_template_instantiation] = STATE(58),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(58),
    [sym_operator_cast_declaration] = STATE(58),
    [sym_constructor_or_destructor_definition] = STATE(58),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(58),
    [sym_using_declaration] = STATE(58),
    [sym_alias_declaration] = STATE(58),
    [sym_static_assert_declaration] = STATE(58),
    [sym_for_range_loop] = STATE(58),
    [sym_throw_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(58),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(546),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [43] = {
    [sym_preproc_include] = STATE(41),
    [sym_preproc_def] = STATE(41),
    [sym_preproc_function_def] = STATE(41),
    [sym_preproc_call] = STATE(41),
    [sym_preproc_if] = STATE(41),
    [sym_preproc_ifdef] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_declaration] = STATE(41),
    [sym_type_definition] = STATE(41),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(41),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(41),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(41),
    [sym_expression_statement] = STATE(41),
    [sym_if_statement] = STATE(41),
    [sym_switch_statement] = STATE(41),
    [sym_case_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_do_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_return_statement] = STATE(41),
    [sym_break_statement] = STATE(41),
    [sym_continue_statement] = STATE(41),
    [sym_goto_statement] = STATE(41),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(41),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(41),
    [sym_template_instantiation] = STATE(41),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(41),
    [sym_operator_cast_declaration] = STATE(41),
    [sym_constructor_or_destructor_definition] = STATE(41),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(41),
    [sym_using_declaration] = STATE(41),
    [sym_alias_declaration] = STATE(41),
    [sym_static_assert_declaration] = STATE(41),
    [sym_for_range_loop] = STATE(41),
    [sym_throw_statement] = STATE(41),
    [sym_try_statement] = STATE(41),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(41),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(548),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [44] = {
    [sym_preproc_include] = STATE(58),
    [sym_preproc_def] = STATE(58),
    [sym_preproc_function_def] = STATE(58),
    [sym_preproc_call] = STATE(58),
    [sym_preproc_if] = STATE(58),
    [sym_preproc_ifdef] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(58),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_case_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(58),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(58),
    [sym_template_instantiation] = STATE(58),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(58),
    [sym_operator_cast_declaration] = STATE(58),
    [sym_constructor_or_destructor_definition] = STATE(58),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(58),
    [sym_using_declaration] = STATE(58),
    [sym_alias_declaration] = STATE(58),
    [sym_static_assert_declaration] = STATE(58),
    [sym_for_range_loop] = STATE(58),
    [sym_throw_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(58),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(550),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [45] = {
    [sym_preproc_include] = STATE(45),
    [sym_preproc_def] = STATE(45),
    [sym_preproc_function_def] = STATE(45),
    [sym_preproc_call] = STATE(45),
    [sym_preproc_if] = STATE(45),
    [sym_preproc_ifdef] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_declaration] = STATE(45),
    [sym_type_definition] = STATE(45),
    [sym__declaration_specifiers] = STATE(4092),
    [sym_linkage_specification] = STATE(45),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2185),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4530),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(45),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3208),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(45),
    [sym_expression_statement] = STATE(45),
    [sym_if_statement] = STATE(45),
    [sym_switch_statement] = STATE(45),
    [sym_case_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_do_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_return_statement] = STATE(45),
    [sym_break_statement] = STATE(45),
    [sym_continue_statement] = STATE(45),
    [sym_goto_statement] = STATE(45),
    [sym__expression] = STATE(3558),
    [sym_comma_expression] = STATE(5868),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(45),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2148),
    [sym_explicit_function_specifier] = STATE(2148),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(45),
    [sym_template_instantiation] = STATE(45),
    [sym_operator_cast] = STATE(4706),
    [aux_sym__constructor_specifiers] = STATE(2148),
    [sym_operator_cast_definition] = STATE(45),
    [sym_operator_cast_declaration] = STATE(45),
    [sym_constructor_or_destructor_definition] = STATE(45),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(45),
    [sym_using_declaration] = STATE(45),
    [sym_alias_declaration] = STATE(45),
    [sym_static_assert_declaration] = STATE(45),
    [sym_for_range_loop] = STATE(45),
    [sym_throw_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_attribute] = STATE(1618),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(45),
    [aux_sym_function_definition_repeat1] = STATE(1066),
    [aux_sym_function_definition_repeat2] = STATE(1618),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(552),
    [aux_sym_preproc_include_token1] = ACTIONS(555),
    [aux_sym_preproc_def_token1] = ACTIONS(558),
    [aux_sym_preproc_if_token1] = ACTIONS(561),
    [aux_sym_preproc_if_token2] = ACTIONS(327),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(564),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(564),
    [sym_preproc_directive] = ACTIONS(567),
    [anon_sym_LPAREN2] = ACTIONS(335),
    [anon_sym_BANG] = ACTIONS(338),
    [anon_sym_TILDE] = ACTIONS(341),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_STAR] = ACTIONS(347),
    [anon_sym_AMP_AMP] = ACTIONS(350),
    [anon_sym_AMP] = ACTIONS(353),
    [anon_sym___device__] = ACTIONS(570),
    [anon_sym___host__] = ACTIONS(570),
    [anon_sym___global__] = ACTIONS(359),
    [anon_sym___forceinline__] = ACTIONS(570),
    [anon_sym_SEMI] = ACTIONS(573),
    [anon_sym_typedef] = ACTIONS(576),
    [anon_sym_extern] = ACTIONS(579),
    [anon_sym___attribute__] = ACTIONS(371),
    [anon_sym___declspec] = ACTIONS(374),
    [anon_sym___based] = ACTIONS(377),
    [anon_sym___cdecl] = ACTIONS(380),
    [anon_sym___clrcall] = ACTIONS(380),
    [anon_sym___stdcall] = ACTIONS(380),
    [anon_sym___fastcall] = ACTIONS(380),
    [anon_sym___thiscall] = ACTIONS(380),
    [anon_sym___vectorcall] = ACTIONS(380),
    [anon_sym_LBRACE] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(386),
    [anon_sym_static] = ACTIONS(389),
    [anon_sym_register] = ACTIONS(389),
    [anon_sym_inline] = ACTIONS(389),
    [anon_sym_const] = ACTIONS(392),
    [anon_sym_volatile] = ACTIONS(392),
    [anon_sym_restrict] = ACTIONS(392),
    [anon_sym__Atomic] = ACTIONS(392),
    [anon_sym_mutable] = ACTIONS(392),
    [anon_sym_constexpr] = ACTIONS(392),
    [anon_sym___shared__] = ACTIONS(392),
    [anon_sym___local__] = ACTIONS(392),
    [anon_sym___constant__] = ACTIONS(392),
    [anon_sym___restrict__] = ACTIONS(392),
    [anon_sym_signed] = ACTIONS(395),
    [anon_sym_unsigned] = ACTIONS(395),
    [anon_sym_long] = ACTIONS(395),
    [anon_sym_short] = ACTIONS(395),
    [sym_primitive_type] = ACTIONS(398),
    [anon_sym_enum] = ACTIONS(401),
    [anon_sym_class] = ACTIONS(404),
    [anon_sym_struct] = ACTIONS(407),
    [anon_sym_union] = ACTIONS(410),
    [anon_sym_if] = ACTIONS(585),
    [anon_sym_switch] = ACTIONS(588),
    [anon_sym_case] = ACTIONS(591),
    [anon_sym_default] = ACTIONS(594),
    [anon_sym_while] = ACTIONS(597),
    [anon_sym_do] = ACTIONS(600),
    [anon_sym_for] = ACTIONS(603),
    [anon_sym_return] = ACTIONS(606),
    [anon_sym_break] = ACTIONS(609),
    [anon_sym_continue] = ACTIONS(612),
    [anon_sym_goto] = ACTIONS(615),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_sizeof] = ACTIONS(449),
    [sym_number_literal] = ACTIONS(452),
    [anon_sym_L_SQUOTE] = ACTIONS(455),
    [anon_sym_u_SQUOTE] = ACTIONS(455),
    [anon_sym_U_SQUOTE] = ACTIONS(455),
    [anon_sym_u8_SQUOTE] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(455),
    [anon_sym_L_DQUOTE] = ACTIONS(458),
    [anon_sym_u_DQUOTE] = ACTIONS(458),
    [anon_sym_U_DQUOTE] = ACTIONS(458),
    [anon_sym_u8_DQUOTE] = ACTIONS(458),
    [anon_sym_DQUOTE] = ACTIONS(458),
    [sym_true] = ACTIONS(461),
    [sym_false] = ACTIONS(461),
    [sym_null] = ACTIONS(461),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(464),
    [anon_sym_virtual] = ACTIONS(467),
    [anon_sym_explicit] = ACTIONS(470),
    [sym_auto] = ACTIONS(473),
    [anon_sym_typename] = ACTIONS(476),
    [anon_sym_template] = ACTIONS(618),
    [anon_sym_COLON_COLON] = ACTIONS(482),
    [anon_sym_operator] = ACTIONS(485),
    [anon_sym_delete] = ACTIONS(488),
    [anon_sym_throw] = ACTIONS(621),
    [anon_sym_namespace] = ACTIONS(624),
    [anon_sym_using] = ACTIONS(627),
    [anon_sym_static_assert] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(633),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(506),
    [anon_sym_new] = ACTIONS(509),
    [sym_operator_name] = ACTIONS(512),
    [sym_this] = ACTIONS(461),
    [sym_nullptr] = ACTIONS(461),
    [sym_raw_string_literal] = ACTIONS(515),
  },
  [46] = {
    [sym_preproc_include] = STATE(58),
    [sym_preproc_def] = STATE(58),
    [sym_preproc_function_def] = STATE(58),
    [sym_preproc_call] = STATE(58),
    [sym_preproc_if] = STATE(58),
    [sym_preproc_ifdef] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(58),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_case_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(58),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(58),
    [sym_template_instantiation] = STATE(58),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(58),
    [sym_operator_cast_declaration] = STATE(58),
    [sym_constructor_or_destructor_definition] = STATE(58),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(58),
    [sym_using_declaration] = STATE(58),
    [sym_alias_declaration] = STATE(58),
    [sym_static_assert_declaration] = STATE(58),
    [sym_for_range_loop] = STATE(58),
    [sym_throw_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(58),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [47] = {
    [sym_preproc_include] = STATE(30),
    [sym_preproc_def] = STATE(30),
    [sym_preproc_function_def] = STATE(30),
    [sym_preproc_call] = STATE(30),
    [sym_preproc_if] = STATE(30),
    [sym_preproc_ifdef] = STATE(30),
    [sym_function_definition] = STATE(30),
    [sym_declaration] = STATE(30),
    [sym_type_definition] = STATE(30),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(30),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(30),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(30),
    [sym_expression_statement] = STATE(30),
    [sym_if_statement] = STATE(30),
    [sym_switch_statement] = STATE(30),
    [sym_case_statement] = STATE(30),
    [sym_while_statement] = STATE(30),
    [sym_do_statement] = STATE(30),
    [sym_for_statement] = STATE(30),
    [sym_return_statement] = STATE(30),
    [sym_break_statement] = STATE(30),
    [sym_continue_statement] = STATE(30),
    [sym_goto_statement] = STATE(30),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(30),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(30),
    [sym_template_instantiation] = STATE(30),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(30),
    [sym_operator_cast_declaration] = STATE(30),
    [sym_constructor_or_destructor_definition] = STATE(30),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(30),
    [sym_using_declaration] = STATE(30),
    [sym_alias_declaration] = STATE(30),
    [sym_static_assert_declaration] = STATE(30),
    [sym_for_range_loop] = STATE(30),
    [sym_throw_statement] = STATE(30),
    [sym_try_statement] = STATE(30),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(30),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(638),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [48] = {
    [sym_preproc_include] = STATE(73),
    [sym_preproc_def] = STATE(73),
    [sym_preproc_function_def] = STATE(73),
    [sym_preproc_call] = STATE(73),
    [sym_preproc_if] = STATE(73),
    [sym_preproc_ifdef] = STATE(73),
    [sym_function_definition] = STATE(73),
    [sym_declaration] = STATE(73),
    [sym_type_definition] = STATE(73),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(73),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(73),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(73),
    [sym_expression_statement] = STATE(73),
    [sym_if_statement] = STATE(73),
    [sym_switch_statement] = STATE(73),
    [sym_case_statement] = STATE(73),
    [sym_while_statement] = STATE(73),
    [sym_do_statement] = STATE(73),
    [sym_for_statement] = STATE(73),
    [sym_return_statement] = STATE(73),
    [sym_break_statement] = STATE(73),
    [sym_continue_statement] = STATE(73),
    [sym_goto_statement] = STATE(73),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(73),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(73),
    [sym_template_instantiation] = STATE(73),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(73),
    [sym_operator_cast_declaration] = STATE(73),
    [sym_constructor_or_destructor_definition] = STATE(73),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(73),
    [sym_using_declaration] = STATE(73),
    [sym_alias_declaration] = STATE(73),
    [sym_static_assert_declaration] = STATE(73),
    [sym_for_range_loop] = STATE(73),
    [sym_throw_statement] = STATE(73),
    [sym_try_statement] = STATE(73),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(73),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(640),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [49] = {
    [sym_preproc_include] = STATE(39),
    [sym_preproc_def] = STATE(39),
    [sym_preproc_function_def] = STATE(39),
    [sym_preproc_call] = STATE(39),
    [sym_preproc_if] = STATE(39),
    [sym_preproc_ifdef] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym_declaration] = STATE(39),
    [sym_type_definition] = STATE(39),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(39),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(39),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(39),
    [sym_expression_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_switch_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_do_statement] = STATE(39),
    [sym_for_statement] = STATE(39),
    [sym_return_statement] = STATE(39),
    [sym_break_statement] = STATE(39),
    [sym_continue_statement] = STATE(39),
    [sym_goto_statement] = STATE(39),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(39),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(39),
    [sym_template_instantiation] = STATE(39),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(39),
    [sym_operator_cast_declaration] = STATE(39),
    [sym_constructor_or_destructor_definition] = STATE(39),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(39),
    [sym_using_declaration] = STATE(39),
    [sym_alias_declaration] = STATE(39),
    [sym_static_assert_declaration] = STATE(39),
    [sym_for_range_loop] = STATE(39),
    [sym_throw_statement] = STATE(39),
    [sym_try_statement] = STATE(39),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(39),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [50] = {
    [sym_preproc_include] = STATE(54),
    [sym_preproc_def] = STATE(54),
    [sym_preproc_function_def] = STATE(54),
    [sym_preproc_call] = STATE(54),
    [sym_preproc_if] = STATE(54),
    [sym_preproc_ifdef] = STATE(54),
    [sym_function_definition] = STATE(54),
    [sym_declaration] = STATE(54),
    [sym_type_definition] = STATE(54),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(54),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(54),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(54),
    [sym_expression_statement] = STATE(54),
    [sym_if_statement] = STATE(54),
    [sym_switch_statement] = STATE(54),
    [sym_case_statement] = STATE(54),
    [sym_while_statement] = STATE(54),
    [sym_do_statement] = STATE(54),
    [sym_for_statement] = STATE(54),
    [sym_return_statement] = STATE(54),
    [sym_break_statement] = STATE(54),
    [sym_continue_statement] = STATE(54),
    [sym_goto_statement] = STATE(54),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(54),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(54),
    [sym_template_instantiation] = STATE(54),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(54),
    [sym_operator_cast_declaration] = STATE(54),
    [sym_constructor_or_destructor_definition] = STATE(54),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(54),
    [sym_using_declaration] = STATE(54),
    [sym_alias_declaration] = STATE(54),
    [sym_static_assert_declaration] = STATE(54),
    [sym_for_range_loop] = STATE(54),
    [sym_throw_statement] = STATE(54),
    [sym_try_statement] = STATE(54),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(54),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(644),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [51] = {
    [sym_preproc_include] = STATE(55),
    [sym_preproc_def] = STATE(55),
    [sym_preproc_function_def] = STATE(55),
    [sym_preproc_call] = STATE(55),
    [sym_preproc_if] = STATE(55),
    [sym_preproc_ifdef] = STATE(55),
    [sym_function_definition] = STATE(55),
    [sym_declaration] = STATE(55),
    [sym_type_definition] = STATE(55),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(55),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(55),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(55),
    [sym_expression_statement] = STATE(55),
    [sym_if_statement] = STATE(55),
    [sym_switch_statement] = STATE(55),
    [sym_case_statement] = STATE(55),
    [sym_while_statement] = STATE(55),
    [sym_do_statement] = STATE(55),
    [sym_for_statement] = STATE(55),
    [sym_return_statement] = STATE(55),
    [sym_break_statement] = STATE(55),
    [sym_continue_statement] = STATE(55),
    [sym_goto_statement] = STATE(55),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(55),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(55),
    [sym_template_instantiation] = STATE(55),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(55),
    [sym_operator_cast_declaration] = STATE(55),
    [sym_constructor_or_destructor_definition] = STATE(55),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(55),
    [sym_using_declaration] = STATE(55),
    [sym_alias_declaration] = STATE(55),
    [sym_static_assert_declaration] = STATE(55),
    [sym_for_range_loop] = STATE(55),
    [sym_throw_statement] = STATE(55),
    [sym_try_statement] = STATE(55),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(55),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(646),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [52] = {
    [sym_preproc_include] = STATE(67),
    [sym_preproc_def] = STATE(67),
    [sym_preproc_function_def] = STATE(67),
    [sym_preproc_call] = STATE(67),
    [sym_preproc_if] = STATE(67),
    [sym_preproc_ifdef] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_declaration] = STATE(67),
    [sym_type_definition] = STATE(67),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(67),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(67),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(67),
    [sym_expression_statement] = STATE(67),
    [sym_if_statement] = STATE(67),
    [sym_switch_statement] = STATE(67),
    [sym_case_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_do_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_return_statement] = STATE(67),
    [sym_break_statement] = STATE(67),
    [sym_continue_statement] = STATE(67),
    [sym_goto_statement] = STATE(67),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(67),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(67),
    [sym_template_instantiation] = STATE(67),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(67),
    [sym_operator_cast_declaration] = STATE(67),
    [sym_constructor_or_destructor_definition] = STATE(67),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(67),
    [sym_using_declaration] = STATE(67),
    [sym_alias_declaration] = STATE(67),
    [sym_static_assert_declaration] = STATE(67),
    [sym_for_range_loop] = STATE(67),
    [sym_throw_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(67),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(648),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [53] = {
    [sym_preproc_include] = STATE(63),
    [sym_preproc_def] = STATE(63),
    [sym_preproc_function_def] = STATE(63),
    [sym_preproc_call] = STATE(63),
    [sym_preproc_if] = STATE(63),
    [sym_preproc_ifdef] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_declaration] = STATE(63),
    [sym_type_definition] = STATE(63),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(63),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(63),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(63),
    [sym_expression_statement] = STATE(63),
    [sym_if_statement] = STATE(63),
    [sym_switch_statement] = STATE(63),
    [sym_case_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_do_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_return_statement] = STATE(63),
    [sym_break_statement] = STATE(63),
    [sym_continue_statement] = STATE(63),
    [sym_goto_statement] = STATE(63),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(63),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(63),
    [sym_template_instantiation] = STATE(63),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(63),
    [sym_operator_cast_declaration] = STATE(63),
    [sym_constructor_or_destructor_definition] = STATE(63),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(63),
    [sym_using_declaration] = STATE(63),
    [sym_alias_declaration] = STATE(63),
    [sym_static_assert_declaration] = STATE(63),
    [sym_for_range_loop] = STATE(63),
    [sym_throw_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(63),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [54] = {
    [sym_preproc_include] = STATE(58),
    [sym_preproc_def] = STATE(58),
    [sym_preproc_function_def] = STATE(58),
    [sym_preproc_call] = STATE(58),
    [sym_preproc_if] = STATE(58),
    [sym_preproc_ifdef] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(58),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_case_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(58),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(58),
    [sym_template_instantiation] = STATE(58),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(58),
    [sym_operator_cast_declaration] = STATE(58),
    [sym_constructor_or_destructor_definition] = STATE(58),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(58),
    [sym_using_declaration] = STATE(58),
    [sym_alias_declaration] = STATE(58),
    [sym_static_assert_declaration] = STATE(58),
    [sym_for_range_loop] = STATE(58),
    [sym_throw_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(58),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(652),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [55] = {
    [sym_preproc_include] = STATE(58),
    [sym_preproc_def] = STATE(58),
    [sym_preproc_function_def] = STATE(58),
    [sym_preproc_call] = STATE(58),
    [sym_preproc_if] = STATE(58),
    [sym_preproc_ifdef] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(58),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_case_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(58),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(58),
    [sym_template_instantiation] = STATE(58),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(58),
    [sym_operator_cast_declaration] = STATE(58),
    [sym_constructor_or_destructor_definition] = STATE(58),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(58),
    [sym_using_declaration] = STATE(58),
    [sym_alias_declaration] = STATE(58),
    [sym_static_assert_declaration] = STATE(58),
    [sym_for_range_loop] = STATE(58),
    [sym_throw_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(58),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(654),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [56] = {
    [sym_preproc_include] = STATE(71),
    [sym_preproc_def] = STATE(71),
    [sym_preproc_function_def] = STATE(71),
    [sym_preproc_call] = STATE(71),
    [sym_preproc_if] = STATE(71),
    [sym_preproc_ifdef] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_declaration] = STATE(71),
    [sym_type_definition] = STATE(71),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(71),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(71),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(71),
    [sym_expression_statement] = STATE(71),
    [sym_if_statement] = STATE(71),
    [sym_switch_statement] = STATE(71),
    [sym_case_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_do_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_return_statement] = STATE(71),
    [sym_break_statement] = STATE(71),
    [sym_continue_statement] = STATE(71),
    [sym_goto_statement] = STATE(71),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(71),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(71),
    [sym_template_instantiation] = STATE(71),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(71),
    [sym_operator_cast_declaration] = STATE(71),
    [sym_constructor_or_destructor_definition] = STATE(71),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(71),
    [sym_using_declaration] = STATE(71),
    [sym_alias_declaration] = STATE(71),
    [sym_static_assert_declaration] = STATE(71),
    [sym_for_range_loop] = STATE(71),
    [sym_throw_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(71),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [57] = {
    [sym_preproc_include] = STATE(44),
    [sym_preproc_def] = STATE(44),
    [sym_preproc_function_def] = STATE(44),
    [sym_preproc_call] = STATE(44),
    [sym_preproc_if] = STATE(44),
    [sym_preproc_ifdef] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_declaration] = STATE(44),
    [sym_type_definition] = STATE(44),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(44),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(44),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(44),
    [sym_expression_statement] = STATE(44),
    [sym_if_statement] = STATE(44),
    [sym_switch_statement] = STATE(44),
    [sym_case_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_do_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_return_statement] = STATE(44),
    [sym_break_statement] = STATE(44),
    [sym_continue_statement] = STATE(44),
    [sym_goto_statement] = STATE(44),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(44),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(44),
    [sym_template_instantiation] = STATE(44),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(44),
    [sym_operator_cast_declaration] = STATE(44),
    [sym_constructor_or_destructor_definition] = STATE(44),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(44),
    [sym_using_declaration] = STATE(44),
    [sym_alias_declaration] = STATE(44),
    [sym_static_assert_declaration] = STATE(44),
    [sym_for_range_loop] = STATE(44),
    [sym_throw_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(44),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(141),
    [aux_sym_preproc_include_token1] = ACTIONS(143),
    [aux_sym_preproc_def_token1] = ACTIONS(145),
    [aux_sym_preproc_if_token1] = ACTIONS(149),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(151),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(151),
    [sym_preproc_directive] = ACTIONS(153),
    [anon_sym_LPAREN2] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_AMP_AMP] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym___device__] = ACTIONS(155),
    [anon_sym___host__] = ACTIONS(155),
    [anon_sym___global__] = ACTIONS(35),
    [anon_sym___forceinline__] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(157),
    [anon_sym_typedef] = ACTIONS(159),
    [anon_sym_extern] = ACTIONS(161),
    [anon_sym___attribute__] = ACTIONS(43),
    [anon_sym___declspec] = ACTIONS(45),
    [anon_sym___based] = ACTIONS(47),
    [anon_sym___cdecl] = ACTIONS(49),
    [anon_sym___clrcall] = ACTIONS(49),
    [anon_sym___stdcall] = ACTIONS(49),
    [anon_sym___fastcall] = ACTIONS(49),
    [anon_sym___thiscall] = ACTIONS(49),
    [anon_sym___vectorcall] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(658),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(55),
    [anon_sym_register] = ACTIONS(55),
    [anon_sym_inline] = ACTIONS(55),
    [anon_sym_const] = ACTIONS(57),
    [anon_sym_volatile] = ACTIONS(57),
    [anon_sym_restrict] = ACTIONS(57),
    [anon_sym__Atomic] = ACTIONS(57),
    [anon_sym_mutable] = ACTIONS(57),
    [anon_sym_constexpr] = ACTIONS(57),
    [anon_sym___shared__] = ACTIONS(57),
    [anon_sym___local__] = ACTIONS(57),
    [anon_sym___constant__] = ACTIONS(57),
    [anon_sym___restrict__] = ACTIONS(57),
    [anon_sym_signed] = ACTIONS(59),
    [anon_sym_unsigned] = ACTIONS(59),
    [anon_sym_long] = ACTIONS(59),
    [anon_sym_short] = ACTIONS(59),
    [sym_primitive_type] = ACTIONS(61),
    [anon_sym_enum] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_struct] = ACTIONS(67),
    [anon_sym_union] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_case] = ACTIONS(173),
    [anon_sym_default] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(185),
    [anon_sym_continue] = ACTIONS(187),
    [anon_sym_goto] = ACTIONS(189),
    [anon_sym_DASH_DASH] = ACTIONS(93),
    [anon_sym_PLUS_PLUS] = ACTIONS(93),
    [anon_sym_sizeof] = ACTIONS(95),
    [sym_number_literal] = ACTIONS(97),
    [anon_sym_L_SQUOTE] = ACTIONS(99),
    [anon_sym_u_SQUOTE] = ACTIONS(99),
    [anon_sym_U_SQUOTE] = ACTIONS(99),
    [anon_sym_u8_SQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_L_DQUOTE] = ACTIONS(101),
    [anon_sym_u_DQUOTE] = ACTIONS(101),
    [anon_sym_U_DQUOTE] = ACTIONS(101),
    [anon_sym_u8_DQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [anon_sym_decltype] = ACTIONS(105),
    [anon_sym_virtual] = ACTIONS(107),
    [anon_sym_explicit] = ACTIONS(109),
    [sym_auto] = ACTIONS(111),
    [anon_sym_typename] = ACTIONS(113),
    [anon_sym_template] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(117),
    [anon_sym_operator] = ACTIONS(119),
    [anon_sym_delete] = ACTIONS(121),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_namespace] = ACTIONS(197),
    [anon_sym_using] = ACTIONS(199),
    [anon_sym_static_assert] = ACTIONS(201),
    [anon_sym_try] = ACTIONS(203),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(133),
    [anon_sym_new] = ACTIONS(135),
    [sym_operator_name] = ACTIONS(137),
    [sym_this] = ACTIONS(103),
    [sym_nullptr] = ACTIONS(103),
    [sym_raw_string_literal] = ACTIONS(139),
  },
  [58] = {
    [sym_preproc_include] = STATE(58),
    [sym_preproc_def] = STATE(58),
    [sym_preproc_function_def] = STATE(58),
    [sym_preproc_call] = STATE(58),
    [sym_preproc_if] = STATE(58),
    [sym_preproc_ifdef] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_declaration] = STATE(58),
    [sym_type_definition] = STATE(58),
    [sym__declaration_specifiers] = STATE(4074),
    [sym_linkage_specification] = STATE(58),
    [sym_attribute_specifier] = STATE(2632),
    [sym_ms_declspec_modifier] = STATE(2213),
    [sym_ms_based_modifier] = STATE(6196),
    [sym_ms_call_modifier] = STATE(2193),
    [sym__declarator] = STATE(5074),
    [sym_parenthesized_declarator] = STATE(4540),
    [sym_pointer_declarator] = STATE(4540),
    [sym_function_declarator] = STATE(4521),
    [sym_array_declarator] = STATE(4540),
    [sym_compound_statement] = STATE(58),
    [sym_storage_class_specifier] = STATE(2632),
    [sym_type_qualifier] = STATE(2632),
    [sym__type_specifier] = STATE(3269),
    [sym_sized_type_specifier] = STATE(1291),
    [sym_enum_specifier] = STATE(1291),
    [sym_struct_specifier] = STATE(1291),
    [sym_union_specifier] = STATE(1291),
    [sym_labeled_statement] = STATE(58),
    [sym_expression_statement] = STATE(58),
    [sym_if_statement] = STATE(58),
    [sym_switch_statement] = STATE(58),
    [sym_case_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_do_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_return_statement] = STATE(58),
    [sym_break_statement] = STATE(58),
    [sym_continue_statement] = STATE(58),
    [sym_goto_statement] = STATE(58),
    [sym__expression] = STATE(3397),
    [sym_comma_expression] = STATE(5807),
    [sym_conditional_expression] = STATE(3213),
    [sym_assignment_expression] = STATE(3213),
    [sym_pointer_expression] = STATE(2624),
    [sym_unary_expression] = STATE(3213),
    [sym_binary_expression] = STATE(3213),
    [sym_update_expression] = STATE(3213),
    [sym_cast_expression] = STATE(3213),
    [sym_sizeof_expression] = STATE(3213),
    [sym_subscript_expression] = STATE(2624),
    [sym_call_expression] = STATE(2624),
    [sym_field_expression] = STATE(2624),
    [sym_compound_literal_expression] = STATE(3213),
    [sym_parenthesized_expression] = STATE(2624),
    [sym_char_literal] = STATE(3213),
    [sym_concatenated_string] = STATE(3213),
    [sym_string_literal] = STATE(2660),
    [sym__empty_declaration] = STATE(58),
    [sym_decltype] = STATE(1291),
    [sym_class_specifier] = STATE(1291),
    [sym_virtual_function_specifier] = STATE(2146),
    [sym_explicit_function_specifier] = STATE(2146),
    [sym_dependent_type] = STATE(1291),
    [sym_template_declaration] = STATE(58),
    [sym_template_instantiation] = STATE(58),
    [sym_operator_cast] = STATE(4697),
    [aux_sym__constructor_specifiers] = STATE(2146),
    [sym_operator_cast_definition] = STATE(58),
    [sym_operator_cast_declaration] = STATE(58),
    [sym_constructor_or_destructor_definition] = STATE(58),
    [sym_reference_declarator] = STATE(4540),
    [sym_structured_binding_declarator] = STATE(4540),
    [sym_template_type] = STATE(3776),
    [sym_template_function] = STATE(3568),
    [sym_namespace_definition] = STATE(58),
    [sym_using_declaration] = STATE(58),
    [sym_alias_declaration] = STATE(58),
    [sym_static_assert_declaration] = STATE(58),
    [sym_for_range_loop] = STATE(58),
    [sym_throw_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_attribute] = STATE(1571),
    [sym_new_expression] = STATE(3213),
    [sym_delete_expression] = STATE(3213),
    [sym_lambda_expression] = STATE(3213),
    [sym_lambda_capture_specifier] = STATE(4336),
    [sym_parameter_pack_expansion] = STATE(3213),
    [sym_destructor_name] = STATE(4540),
    [sym_scoped_identifier] = STATE(3306),
    [sym_scoped_type_identifier] = STATE(3079),
    [sym_scoped_namespace_identifier] = STATE(4398),
    [aux_sym_translation_unit_repeat1] = STATE(58),
    [aux_sym_function_definition_repeat1] = STATE(1053),
    [aux_sym_function_definition_repeat2] = STATE(1571),
    [aux_sym__declaration_specifiers_repeat1] = STATE(2213),
    [aux_sym_sized_type_specifier_repeat1] = STATE(2927),
    [sym_identifier] = ACTIONS(660),
    [aux_sym_preproc_include_token1] = ACTIONS(663),
    [aux_sym_preproc_def_token1] = ACTIONS(666),
    [aux_sym_preproc_if_token1] = ACTIONS(669),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(672),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(672),
    [sym_preproc_directive] = ACTIONS(675),
    [anon_sym_LPAREN2] = ACTIONS(335),
    [anon_sym_BANG] = ACTIONS(338),
    [anon_sym_TILDE] = ACTIONS(341),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_STAR] = ACTIONS(347),
    [anon_sym_AMP_AMP] = ACTIONS(350),
    [anon_sym_AMP] = ACTIONS(353),
    [anon_sym___device__] = ACTIONS(678),
    [anon_sym___host__] = ACTIONS(678),
    [anon_sym___global__] = ACTIONS(359),
    [anon_sym___forceinline__] = ACTIONS(678),
    [anon_sym_SEMI] = ACTIONS(681),
    [anon_sym_typedef] = ACTIONS(684),
    [anon_sym_extern] = ACTIONS(687),
    [anon_sym___attribute__] = ACTIONS(371),
    [anon_sym___declspec] = ACTIONS(374),
    [anon_sym___based] = ACTIONS(377),
    [anon_sym___cdecl] = ACTIONS(380),
    [anon_sym___clrcall] = ACTIONS(380),
    [anon_sym___stdcall] = ACTIONS(380),
    [anon_sym___fastcall] = ACTIONS(380),
    [anon_sym___thiscall] = ACTIONS(380),
    [anon_sym___vectorcall] = ACTIONS(380),
    [anon_sym_LBRACE] = ACTIONS(690),
    [anon_sym_RBRACE] = ACTIONS(693),
    [anon_sym_LBRACK] = ACTIONS(386),
    [anon_sym_static] = ACTIONS(389),
    [anon_sym_register] = ACTIONS(389),
    [anon_sym_inline] = ACTIONS(389),
    [anon_sym_const] = ACTIONS(392),
    [anon_sym_volatile] = ACTIONS(392),
    [anon_sym_restrict] = ACTIONS(392),
    [anon_sym__Atomic] = ACTIONS(392),
    [anon_sym_mutable] = ACTIONS(392),
    [anon_sym_constexpr] = ACTIONS(392),
    [anon_sym___shared__] = ACTIONS(392),
    [anon_sym___local__] = ACTIONS(392),
    [anon_sym___constant__] = ACTIONS(392),
    [anon_sym___restrict__] = ACTIONS(392),
    [anon_sym_signed] = ACTIONS(395),
    [anon_sym_unsigned] = ACTIONS(395),
    [anon_sym_long] = ACTIONS(395),
    [anon_sym_short] = ACTIONS(395),
    [sym_primitive_type] = ACTIONS(398),
    [anon_sym_enum] = ACTIONS(401),
    [anon_sym_class] = ACTIONS(404),
    [anon_sym_struct] = ACTIONS(407),
    [anon_sym_union] = ACTIONS(410),
    [anon_sym_if] = ACTIONS(695),
    [anon_sym_switch] = ACTIONS(698),
    [anon_sym_case] = ACTIONS(701),
    [anon_sym_default] = ACTIONS(704),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_do] = ACTIONS(710),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_return] = ACTIONS(716),
    [anon_sym_break] = ACTIONS(719),
    [anon_sym_continue] = ACTIONS(722),
    [anon_sym_goto] = ACTIONS(725),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_sizeof] = ACTIONS(449),
    [sym_number_literal] = ACTIONS(452),
    [anon_sym_L_SQUOTE] = ACTIONS(455),
    [anon_sym_u_SQUOTE] = ACTIONS(455),
    [anon_sym_U_SQUOTE] = ACTIONS(455),
    [anon_sym_u8_SQUOTE] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(455),
    [anon_sym_L_DQUOTE] = ACTIONS(458),
    [anon_sym_u_DQUOTE] = ACTIONS(458),
    [anon_sym_U_DQUOTE] = ACTIONS(458),
    [anon_sym_u8_DQUOTE] = ACTIONS(458),
    [anon_sym_DQUOTE] = ACTIONS(458),
    [sym_true] = ACTIONS(461),
   