#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 762
#define LARGE_STATE_COUNT 4
#define SYMBOL_COUNT 176
#define ALIAS_COUNT 0
#define TOKEN_COUNT 97
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 14
#define PRODUCTION_ID_COUNT 1

enum {
  sym_comment = 1,
  sym_ADD = 2,
  sym_AND = 3,
  sym_EQ = 4,
  sym_AT = 5,
  sym_BNOT = 6,
  sym_COLON = 7,
  sym_COMMA = 8,
  sym_CONST = 9,
  sym_COUNT = 10,
  sym_CSP = 11,
  sym_CSP_ADD = 12,
  sym_CSP_SUB = 13,
  sym_CSP_MUL = 14,
  sym_CSP_LEQ = 15,
  sym_CSP_LT = 16,
  sym_CSP_GT = 17,
  sym_CSP_GEQ = 18,
  sym_CSP_EQ = 19,
  sym_CSP_NEQ = 20,
  sym_DISJOINT = 21,
  sym_DOT = 22,
  sym_DOTS = 23,
  sym_EXTERNAL = 24,
  sym_DEFINED = 25,
  sym_FALSE = 26,
  sym_GEQ = 27,
  sym_GT = 28,
  sym_IF = 29,
  sym_INCLUDE = 30,
  anon_sym_POUNDinf = 31,
  anon_sym_POUNDinfimum = 32,
  sym_LBRACE = 33,
  sym_LBRACK = 34,
  sym_LEQ = 35,
  sym_LPAREN = 36,
  sym_LT = 37,
  sym_MAX = 38,
  anon_sym_POUNDmaximize = 39,
  anon_sym_POUNDmaximise = 40,
  sym_MIN = 41,
  anon_sym_POUNDminimize = 42,
  anon_sym_POUNDminimise = 43,
  sym_MOD = 44,
  sym_MUL = 45,
  sym_NEQ = 46,
  sym_POW = 47,
  sym_QUESTION = 48,
  sym_RBRACE = 49,
  sym_RBRACK = 50,
  sym_RPAREN = 51,
  sym_SEM = 52,
  sym_SHOW = 53,
  sym_EDGE = 54,
  sym_PROJECT = 55,
  sym_HEURISTIC = 56,
  sym_SLASH = 57,
  sym_SUB = 58,
  sym_SUM = 59,
  sym_SUMP = 60,
  anon_sym_POUNDsup = 61,
  anon_sym_POUNDsupremum = 62,
  sym_TRUE = 63,
  sym_BLOCK = 64,
  sym_VBAR = 65,
  sym_WIF = 66,
  sym_XOR = 67,
  sym_ANY = 68,
  sym_UNARY = 69,
  sym_BINARY = 70,
  sym_LEFT = 71,
  sym_RIGHT = 72,
  sym_HEAD = 73,
  sym_BODY = 74,
  sym_DIRECTIVE = 75,
  sym_THEORY = 76,
  anon_sym_0 = 77,
  aux_sym_dec_token1 = 78,
  sym_hex = 79,
  sym_oct = 80,
  sym_bin = 81,
  sym_ANONYMOUS = 82,
  sym_identifier = 83,
  anon_sym_LPAREN = 84,
  sym_SCRIPT = 85,
  sym_CODE = 86,
  sym_VARIABLE = 87,
  sym_THEORY_OP = 88,
  sym_NOT = 89,
  sym_DEFAULT = 90,
  sym_OVERRIDE = 91,
  anon_sym_BSLASH_BSLASH = 92,
  anon_sym_EQ_EQ = 93,
  anon_sym_DQUOTE = 94,
  sym_unescaped_double_string_fragment = 95,
  sym_escape_sequence = 96,
  sym_source_file = 97,
  sym_INFIMUM = 98,
  sym_MAXIMIZE = 99,
  sym_MINIMIZE = 100,
  sym_SUPREMUM = 101,
  sym_NUMBER = 102,
  sym_dec = 103,
  sym__widentifier = 104,
  sym_constterm = 105,
  sym_consttermvec = 106,
  sym_nconstargvec = 107,
  sym_term = 108,
  sym_unaryargvec = 109,
  sym_ntermvec = 110,
  sym_ntuple = 111,
  sym_tuplevec_sem = 112,
  sym_ntuplevec = 113,
  sym_argvec = 114,
  sym_binaryargvec = 115,
  sym_cmp = 116,
  sym_atom = 117,
  sym_literal = 118,
  sym_csp_mul_term = 119,
  sym_csp_add_term = 120,
  sym_csp_rel = 121,
  sym_csp_literal = 122,
  sym_nlitvec = 123,
  sym_noptcondition = 124,
  sym_aggregatefunction = 125,
  sym_bodyaggrelem = 126,
  sym_bodyaggrelemvec = 127,
  sym_altbodyaggrelem = 128,
  sym_altbodyaggrelemvec = 129,
  sym_bodyaggregate = 130,
  sym_nupper = 131,
  sym_lubodyaggregate = 132,
  sym_headaggrelemvec = 133,
  sym_altheadaggrelemvec = 134,
  sym_headaggregate = 135,
  sym_luheadaggregate = 136,
  sym_ncspelemvec = 137,
  sym_disjoint = 138,
  sym_conjunction = 139,
  sym_dsym = 140,
  sym_disjunctionsep = 141,
  sym_disjunction = 142,
  sym_nbodycomma = 143,
  sym_bodydot = 144,
  sym_bodyconddot = 145,
  sym_head = 146,
  sym_statement = 147,
  sym_noptimizetuple = 148,
  sym_optimizeweight = 149,
  sym_optimizelitvec = 150,
  sym_noptimizecond = 151,
  sym_maxelemlist = 152,
  sym_minelemlist = 153,
  sym_nidlist = 154,
  sym_theory_identifier = 155,
  sym_theory_op = 156,
  sym_theory_op_list = 157,
  sym_theory_term = 158,
  sym_theory_opterm = 159,
  sym_theory_opterm_nlist = 160,
  sym_theory_atom_element = 161,
  sym_theory_atom_element_nlist = 162,
  sym_theory_atom_name = 163,
  sym_theory_atom = 164,
  sym_theory_operator_nlist = 165,
  sym_theory_operator_definition = 166,
  sym_theory_operator_definition_nlist = 167,
  sym_theory_definition_identifier = 168,
  sym_theory_term_definition = 169,
  sym_theory_atom_type = 170,
  sym_theory_atom_definition = 171,
  sym_theory_definition_nlist = 172,
  sym_STRING = 173,
  aux_sym_source_file_repeat1 = 174,
  aux_sym_STRING_repeat1 = 175,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_comment] = "comment",
  [sym_ADD] = "ADD",
  [sym_AND] = "AND",
  [sym_EQ] = "EQ",
  [sym_AT] = "AT",
  [sym_BNOT] = "BNOT",
  [sym_COLON] = "COLON",
  [sym_COMMA] = "COMMA",
  [sym_CONST] = "CONST",
  [sym_COUNT] = "COUNT",
  [sym_CSP] = "CSP",
  [sym_CSP_ADD] = "CSP_ADD",
  [sym_CSP_SUB] = "CSP_SUB",
  [sym_CSP_MUL] = "CSP_MUL",
  [sym_CSP_LEQ] = "CSP_LEQ",
  [sym_CSP_LT] = "CSP_LT",
  [sym_CSP_GT] = "CSP_GT",
  [sym_CSP_GEQ] = "CSP_GEQ",
  [sym_CSP_EQ] = "CSP_EQ",
  [sym_CSP_NEQ] = "CSP_NEQ",
  [sym_DISJOINT] = "DISJOINT",
  [sym_DOT] = "DOT",
  [sym_DOTS] = "DOTS",
  [sym_EXTERNAL] = "EXTERNAL",
  [sym_DEFINED] = "DEFINED",
  [sym_FALSE] = "FALSE",
  [sym_GEQ] = "GEQ",
  [sym_GT] = "GT",
  [sym_IF] = "IF",
  [sym_INCLUDE] = "INCLUDE",
  [anon_sym_POUNDinf] = "#inf",
  [anon_sym_POUNDinfimum] = "#infimum",
  [sym_LBRACE] = "LBRACE",
  [sym_LBRACK] = "LBRACK",
  [sym_LEQ] = "LEQ",
  [sym_LPAREN] = "LPAREN",
  [sym_LT] = "LT",
  [sym_MAX] = "MAX",
  [anon_sym_POUNDmaximize] = "#maximize",
  [anon_sym_POUNDmaximise] = "#maximise",
  [sym_MIN] = "MIN",
  [anon_sym_POUNDminimize] = "#minimize",
  [anon_sym_POUNDminimise] = "#minimise",
  [sym_MOD] = "MOD",
  [sym_MUL] = "MUL",
  [sym_NEQ] = "NEQ",
  [sym_POW] = "POW",
  [sym_QUESTION] = "QUESTION",
  [sym_RBRACE] = "RBRACE",
  [sym_RBRACK] = "RBRACK",
  [sym_RPAREN] = "RPAREN",
  [sym_SEM] = "SEM",
  [sym_SHOW] = "SHOW",
  [sym_EDGE] = "EDGE",
  [sym_PROJECT] = "PROJECT",
  [sym_HEURISTIC] = "HEURISTIC",
  [sym_SLASH] = "SLASH",
  [sym_SUB] = "SUB",
  [sym_SUM] = "SUM",
  [sym_SUMP] = "SUMP",
  [anon_sym_POUNDsup] = "#sup",
  [anon_sym_POUNDsupremum] = "#supremum",
  [sym_TRUE] = "TRUE",
  [sym_BLOCK] = "BLOCK",
  [sym_VBAR] = "VBAR",
  [sym_WIF] = "WIF",
  [sym_XOR] = "XOR",
  [sym_ANY] = "ANY",
  [sym_UNARY] = "UNARY",
  [sym_BINARY] = "BINARY",
  [sym_LEFT] = "LEFT",
  [sym_RIGHT] = "RIGHT",
  [sym_HEAD] = "HEAD",
  [sym_BODY] = "BODY",
  [sym_DIRECTIVE] = "DIRECTIVE",
  [sym_THEORY] = "THEORY",
  [anon_sym_0] = "0",
  [aux_sym_dec_token1] = "dec_token1",
  [sym_hex] = "hex",
  [sym_oct] = "oct",
  [sym_bin] = "bin",
  [sym_ANONYMOUS] = "ANONYMOUS",
  [sym_identifier] = "identifier",
  [anon_sym_LPAREN] = "LPAREN",
  [sym_SCRIPT] = "SCRIPT",
  [sym_CODE] = "CODE",
  [sym_VARIABLE] = "VARIABLE",
  [sym_THEORY_OP] = "THEORY_OP",
  [sym_NOT] = "NOT",
  [sym_DEFAULT] = "DEFAULT",
  [sym_OVERRIDE] = "OVERRIDE",
  [anon_sym_BSLASH_BSLASH] = "\\\\",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_DQUOTE] = "\"",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_source_file] = "source_file",
  [sym_INFIMUM] = "INFIMUM",
  [sym_MAXIMIZE] = "MAXIMIZE",
  [sym_MINIMIZE] = "MINIMIZE",
  [sym_SUPREMUM] = "SUPREMUM",
  [sym_NUMBER] = "NUMBER",
  [sym_dec] = "dec",
  [sym__widentifier] = "_widentifier",
  [sym_constterm] = "constterm",
  [sym_consttermvec] = "consttermvec",
  [sym_nconstargvec] = "nconstargvec",
  [sym_term] = "term",
  [sym_unaryargvec] = "unaryargvec",
  [sym_ntermvec] = "ntermvec",
  [sym_ntuple] = "ntuple",
  [sym_tuplevec_sem] = "tuplevec_sem",
  [sym_ntuplevec] = "ntuplevec",
  [sym_argvec] = "argvec",
  [sym_binaryargvec] = "binaryargvec",
  [sym_cmp] = "cmp",
  [sym_atom] = "atom",
  [sym_literal] = "literal",
  [sym_csp_mul_term] = "csp_mul_term",
  [sym_csp_add_term] = "csp_add_term",
  [sym_csp_rel] = "csp_rel",
  [sym_csp_literal] = "csp_literal",
  [sym_nlitvec] = "nlitvec",
  [sym_noptcondition] = "noptcondition",
  [sym_aggregatefunction] = "aggregatefunction",
  [sym_bodyaggrelem] = "bodyaggrelem",
  [sym_bodyaggrelemvec] = "bodyaggrelemvec",
  [sym_altbodyaggrelem] = "altbodyaggrelem",
  [sym_altbodyaggrelemvec] = "altbodyaggrelemvec",
  [sym_bodyaggregate] = "bodyaggregate",
  [sym_nupper] = "nupper",
  [sym_lubodyaggregate] = "lubodyaggregate",
  [sym_headaggrelemvec] = "headaggrelemvec",
  [sym_altheadaggrelemvec] = "altheadaggrelemvec",
  [sym_headaggregate] = "headaggregate",
  [sym_luheadaggregate] = "luheadaggregate",
  [sym_ncspelemvec] = "ncspelemvec",
  [sym_disjoint] = "disjoint",
  [sym_conjunction] = "conjunction",
  [sym_dsym] = "dsym",
  [sym_disjunctionsep] = "disjunctionsep",
  [sym_disjunction] = "disjunction",
  [sym_nbodycomma] = "nbodycomma",
  [sym_bodydot] = "bodydot",
  [sym_bodyconddot] = "bodyconddot",
  [sym_head] = "head",
  [sym_statement] = "statement",
  [sym_noptimizetuple] = "noptimizetuple",
  [sym_optimizeweight] = "optimizeweight",
  [sym_optimizelitvec] = "optimizelitvec",
  [sym_noptimizecond] = "noptimizecond",
  [sym_maxelemlist] = "maxelemlist",
  [sym_minelemlist] = "minelemlist",
  [sym_nidlist] = "nidlist",
  [sym_theory_identifier] = "theory_identifier",
  [sym_theory_op] = "theory_op",
  [sym_theory_op_list] = "theory_op_list",
  [sym_theory_term] = "theory_term",
  [sym_theory_opterm] = "theory_opterm",
  [sym_theory_opterm_nlist] = "theory_opterm_nlist",
  [sym_theory_atom_element] = "theory_atom_element",
  [sym_theory_atom_element_nlist] = "theory_atom_element_nlist",
  [sym_theory_atom_name] = "theory_atom_name",
  [sym_theory_atom] = "theory_atom",
  [sym_theory_operator_nlist] = "theory_operator_nlist",
  [sym_theory_operator_definition] = "theory_operator_definition",
  [sym_theory_operator_definition_nlist] = "theory_operator_definition_nlist",
  [sym_theory_definition_identifier] = "theory_definition_identifier",
  [sym_theory_term_definition] = "theory_term_definition",
  [sym_theory_atom_type] = "theory_atom_type",
  [sym_theory_atom_definition] = "theory_atom_definition",
  [sym_theory_definition_nlist] = "theory_definition_nlist",
  [sym_STRING] = "STRING",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_STRING_repeat1] = "STRING_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_comment] = sym_comment,
  [sym_ADD] = sym_ADD,
  [sym_AND] = sym_AND,
  [sym_EQ] = sym_EQ,
  [sym_AT] = sym_AT,
  [sym_BNOT] = sym_BNOT,
  [sym_COLON] = sym_COLON,
  [sym_COMMA] = sym_COMMA,
  [sym_CONST] = sym_CONST,
  [sym_COUNT] = sym_COUNT,
  [sym_CSP] = sym_CSP,
  [sym_CSP_ADD] = sym_CSP_ADD,
  [sym_CSP_SUB] = sym_CSP_SUB,
  [sym_CSP_MUL] = sym_CSP_MUL,
  [sym_CSP_LEQ] = sym_CSP_LEQ,
  [sym_CSP_LT] = sym_CSP_LT,
  [sym_CSP_GT] = sym_CSP_GT,
  [sym_CSP_GEQ] = sym_CSP_GEQ,
  [sym_CSP_EQ] = sym_CSP_EQ,
  [sym_CSP_NEQ] = sym_CSP_NEQ,
  [sym_DISJOINT] = sym_DISJOINT,
  [sym_DOT] = sym_DOT,
  [sym_DOTS] = sym_DOTS,
  [sym_EXTERNAL] = sym_EXTERNAL,
  [sym_DEFINED] = sym_DEFINED,
  [sym_FALSE] = sym_FALSE,
  [sym_GEQ] = sym_GEQ,
  [sym_GT] = sym_GT,
  [sym_IF] = sym_IF,
  [sym_INCLUDE] = sym_INCLUDE,
  [anon_sym_POUNDinf] = anon_sym_POUNDinf,
  [anon_sym_POUNDinfimum] = anon_sym_POUNDinfimum,
  [sym_LBRACE] = sym_LBRACE,
  [sym_LBRACK] = sym_LBRACK,
  [sym_LEQ] = sym_LEQ,
  [sym_LPAREN] = sym_LPAREN,
  [sym_LT] = sym_LT,
  [sym_MAX] = sym_MAX,
  [anon_sym_POUNDmaximize] = anon_sym_POUNDmaximize,
  [anon_sym_POUNDmaximise] = anon_sym_POUNDmaximise,
  [sym_MIN] = sym_MIN,
  [anon_sym_POUNDminimize] = anon_sym_POUNDminimize,
  [anon_sym_POUNDminimise] = anon_sym_POUNDminimise,
  [sym_MOD] = sym_MOD,
  [sym_MUL] = sym_MUL,
  [sym_NEQ] = sym_NEQ,
  [sym_POW] = sym_POW,
  [sym_QUESTION] = sym_QUESTION,
  [sym_RBRACE] = sym_RBRACE,
  [sym_RBRACK] = sym_RBRACK,
  [sym_RPAREN] = sym_RPAREN,
  [sym_SEM] = sym_SEM,
  [sym_SHOW] = sym_SHOW,
  [sym_EDGE] = sym_EDGE,
  [sym_PROJECT] = sym_PROJECT,
  [sym_HEURISTIC] = sym_HEURISTIC,
  [sym_SLASH] = sym_SLASH,
  [sym_SUB] = sym_SUB,
  [sym_SUM] = sym_SUM,
  [sym_SUMP] = sym_SUMP,
  [anon_sym_POUNDsup] = anon_sym_POUNDsup,
  [anon_sym_POUNDsupremum] = anon_sym_POUNDsupremum,
  [sym_TRUE] = sym_TRUE,
  [sym_BLOCK] = sym_BLOCK,
  [sym_VBAR] = sym_VBAR,
  [sym_WIF] = sym_WIF,
  [sym_XOR] = sym_XOR,
  [sym_ANY] = sym_ANY,
  [sym_UNARY] = sym_UNARY,
  [sym_BINARY] = sym_BINARY,
  [sym_LEFT] = sym_LEFT,
  [sym_RIGHT] = sym_RIGHT,
  [sym_HEAD] = sym_HEAD,
  [sym_BODY] = sym_BODY,
  [sym_DIRECTIVE] = sym_DIRECTIVE,
  [sym_THEORY] = sym_THEORY,
  [anon_sym_0] = anon_sym_0,
  [aux_sym_dec_token1] = aux_sym_dec_token1,
  [sym_hex] = sym_hex,
  [sym_oct] = sym_oct,
  [sym_bin] = sym_bin,
  [sym_ANONYMOUS] = sym_ANONYMOUS,
  [sym_identifier] = sym_identifier,
  [anon_sym_LPAREN] = sym_LPAREN,
  [sym_SCRIPT] = sym_SCRIPT,
  [sym_CODE] = sym_CODE,
  [sym_VARIABLE] = sym_VARIABLE,
  [sym_THEORY_OP] = sym_THEORY_OP,
  [sym_NOT] = sym_NOT,
  [sym_DEFAULT] = sym_DEFAULT,
  [sym_OVERRIDE] = sym_OVERRIDE,
  [anon_sym_BSLASH_BSLASH] = anon_sym_BSLASH_BSLASH,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_source_file] = sym_source_file,
  [sym_INFIMUM] = sym_INFIMUM,
  [sym_MAXIMIZE] = sym_MAXIMIZE,
  [sym_MINIMIZE] = sym_MINIMIZE,
  [sym_SUPREMUM] = sym_SUPREMUM,
  [sym_NUMBER] = sym_NUMBER,
  [sym_dec] = sym_dec,
  [sym__widentifier] = sym__widentifier,
  [sym_constterm] = sym_constterm,
  [sym_consttermvec] = sym_consttermvec,
  [sym_nconstargvec] = sym_nconstargvec,
  [sym_term] = sym_term,
  [sym_unaryargvec] = sym_unaryargvec,
  [sym_ntermvec] = sym_ntermvec,
  [sym_ntuple] = sym_ntuple,
  [sym_tuplevec_sem] = sym_tuplevec_sem,
  [sym_ntuplevec] = sym_ntuplevec,
  [sym_argvec] = sym_argvec,
  [sym_binaryargvec] = sym_binaryargvec,
  [sym_cmp] = sym_cmp,
  [sym_atom] = sym_atom,
  [sym_literal] = sym_literal,
  [sym_csp_mul_term] = sym_csp_mul_term,
  [sym_csp_add_term] = sym_csp_add_term,
  [sym_csp_rel] = sym_csp_rel,
  [sym_csp_literal] = sym_csp_literal,
  [sym_nlitvec] = sym_nlitvec,
  [sym_noptcondition] = sym_noptcondition,
  [sym_aggregatefunction] = sym_aggregatefunction,
  [sym_bodyaggrelem] = sym_bodyaggrelem,
  [sym_bodyaggrelemvec] = sym_bodyaggrelemvec,
  [sym_altbodyaggrelem] = sym_altbodyaggrelem,
  [sym_altbodyaggrelemvec] = sym_altbodyaggrelemvec,
  [sym_bodyaggregate] = sym_bodyaggregate,
  [sym_nupper] = sym_nupper,
  [sym_lubodyaggregate] = sym_lubodyaggregate,
  [sym_headaggrelemvec] = sym_headaggrelemvec,
  [sym_altheadaggrelemvec] = sym_altheadaggrelemvec,
  [sym_headaggregate] = sym_headaggregate,
  [sym_luheadaggregate] = sym_luheadaggregate,
  [sym_ncspelemvec] = sym_ncspelemvec,
  [sym_disjoint] = sym_disjoint,
  [sym_conjunction] = sym_conjunction,
  [sym_dsym] = sym_dsym,
  [sym_disjunctionsep] = sym_disjunctionsep,
  [sym_disjunction] = sym_disjunction,
  [sym_nbodycomma] = sym_nbodycomma,
  [sym_bodydot] = sym_bodydot,
  [sym_bodyconddot] = sym_bodyconddot,
  [sym_head] = sym_head,
  [sym_statement] = sym_statement,
  [sym_noptimizetuple] = sym_noptimizetuple,
  [sym_optimizeweight] = sym_optimizeweight,
  [sym_optimizelitvec] = sym_optimizelitvec,
  [sym_noptimizecond] = sym_noptimizecond,
  [sym_maxelemlist] = sym_maxelemlist,
  [sym_minelemlist] = sym_minelemlist,
  [sym_nidlist] = sym_nidlist,
  [sym_theory_identifier] = sym_theory_identifier,
  [sym_theory_op] = sym_theory_op,
  [sym_theory_op_list] = sym_theory_op_list,
  [sym_theory_term] = sym_theory_term,
  [sym_theory_opterm] = sym_theory_opterm,
  [sym_theory_opterm_nlist] = sym_theory_opterm_nlist,
  [sym_theory_atom_element] = sym_theory_atom_element,
  [sym_theory_atom_element_nlist] = sym_theory_atom_element_nlist,
  [sym_theory_atom_name] = sym_theory_atom_name,
  [sym_theory_atom] = sym_theory_atom,
  [sym_theory_operator_nlist] = sym_theory_operator_nlist,
  [sym_theory_operator_definition] = sym_theory_operator_definition,
  [sym_theory_operator_definition_nlist] = sym_theory_operator_definition_nlist,
  [sym_theory_definition_identifier] = sym_theory_definition_identifier,
  [sym_theory_term_definition] = sym_theory_term_definition,
  [sym_theory_atom_type] = sym_theory_atom_type,
  [sym_theory_atom_definition] = sym_theory_atom_definition,
  [sym_theory_definition_nlist] = sym_theory_definition_nlist,
  [sym_STRING] = sym_STRING,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_STRING_repeat1] = aux_sym_STRING_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_ADD] = {
    .visible = true,
    .named = true,
  },
  [sym_AND] = {
    .visible = true,
    .named = true,
  },
  [sym_EQ] = {
    .visible = true,
    .named = true,
  },
  [sym_AT] = {
    .visible = true,
    .named = true,
  },
  [sym_BNOT] = {
    .visible = true,
    .named = true,
  },
  [sym_COLON] = {
    .visible = true,
    .named = true,
  },
  [sym_COMMA] = {
    .visible = true,
    .named = true,
  },
  [sym_CONST] = {
    .visible = true,
    .named = true,
  },
  [sym_COUNT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_ADD] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_SUB] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_MUL] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_LEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_LT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_GT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_GEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_EQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_NEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_DISJOINT] = {
    .visible = true,
    .named = true,
  },
  [sym_DOT] = {
    .visible = true,
    .named = true,
  },
  [sym_DOTS] = {
    .visible = true,
    .named = true,
  },
  [sym_EXTERNAL] = {
    .visible = true,
    .named = true,
  },
  [sym_DEFINED] = {
    .visible = true,
    .named = true,
  },
  [sym_FALSE] = {
    .visible = true,
    .named = true,
  },
  [sym_GEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_GT] = {
    .visible = true,
    .named = true,
  },
  [sym_IF] = {
    .visible = true,
    .named = true,
  },
  [sym_INCLUDE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDinf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDinfimum] = {
    .visible = true,
    .named = false,
  },
  [sym_LBRACE] = {
    .visible = true,
    .named = true,
  },
  [sym_LBRACK] = {
    .visible = true,
    .named = true,
  },
  [sym_LEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_LPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_LT] = {
    .visible = true,
    .named = true,
  },
  [sym_MAX] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDmaximize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDmaximise] = {
    .visible = true,
    .named = false,
  },
  [sym_MIN] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDminimize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDminimise] = {
    .visible = true,
    .named = false,
  },
  [sym_MOD] = {
    .visible = true,
    .named = true,
  },
  [sym_MUL] = {
    .visible = true,
    .named = true,
  },
  [sym_NEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_POW] = {
    .visible = true,
    .named = true,
  },
  [sym_QUESTION] = {
    .visible = true,
    .named = true,
  },
  [sym_RBRACE] = {
    .visible = true,
    .named = true,
  },
  [sym_RBRACK] = {
    .visible = true,
    .named = true,
  },
  [sym_RPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_SEM] = {
    .visible = true,
    .named = true,
  },
  [sym_SHOW] = {
    .visible = true,
    .named = true,
  },
  [sym_EDGE] = {
    .visible = true,
    .named = true,
  },
  [sym_PROJECT] = {
    .visible = true,
    .named = true,
  },
  [sym_HEURISTIC] = {
    .visible = true,
    .named = true,
  },
  [sym_SLASH] = {
    .visible = true,
    .named = true,
  },
  [sym_SUB] = {
    .visible = true,
    .named = true,
  },
  [sym_SUM] = {
    .visible = true,
    .named = true,
  },
  [sym_SUMP] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDsup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDsupremum] = {
    .visible = true,
    .named = false,
  },
  [sym_TRUE] = {
    .visible = true,
    .named = true,
  },
  [sym_BLOCK] = {
    .visible = true,
    .named = true,
  },
  [sym_VBAR] = {
    .visible = true,
    .named = true,
  },
  [sym_WIF] = {
    .visible = true,
    .named = true,
  },
  [sym_XOR] = {
    .visible = true,
    .named = true,
  },
  [sym_ANY] = {
    .visible = true,
    .named = true,
  },
  [sym_UNARY] = {
    .visible = true,
    .named = true,
  },
  [sym_BINARY] = {
    .visible = true,
    .named = true,
  },
  [sym_LEFT] = {
    .visible = true,
    .named = true,
  },
  [sym_RIGHT] = {
    .visible = true,
    .named = true,
  },
  [sym_HEAD] = {
    .visible = true,
    .named = true,
  },
  [sym_BODY] = {
    .visible = true,
    .named = true,
  },
  [sym_DIRECTIVE] = {
    .visible = true,
    .named = true,
  },
  [sym_THEORY] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_dec_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_hex] = {
    .visible = true,
    .named = true,
  },
  [sym_oct] = {
    .visible = true,
    .named = true,
  },
  [sym_bin] = {
    .visible = true,
    .named = true,
  },
  [sym_ANONYMOUS] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_SCRIPT] = {
    .visible = true,
    .named = true,
  },
  [sym_CODE] = {
    .visible = true,
    .named = true,
  },
  [sym_VARIABLE] = {
    .visible = true,
    .named = true,
  },
  [sym_THEORY_OP] = {
    .visible = true,
    .named = true,
  },
  [sym_NOT] = {
    .visible = true,
    .named = true,
  },
  [sym_DEFAULT] = {
    .visible = true,
    .named = true,
  },
  [sym_OVERRIDE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_INFIMUM] = {
    .visible = true,
    .named = true,
  },
  [sym_MAXIMIZE] = {
    .visible = true,
    .named = true,
  },
  [sym_MINIMIZE] = {
    .visible = true,
    .named = true,
  },
  [sym_SUPREMUM] = {
    .visible = true,
    .named = true,
  },
  [sym_NUMBER] = {
    .visible = true,
    .named = true,
  },
  [sym_dec] = {
    .visible = true,
    .named = true,
  },
  [sym__widentifier] = {
    .visible = false,
    .named = true,
  },
  [sym_constterm] = {
    .visible = true,
    .named = true,
  },
  [sym_consttermvec] = {
    .visible = true,
    .named = true,
  },
  [sym_nconstargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_term] = {
    .visible = true,
    .named = true,
  },
  [sym_unaryargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_ntermvec] = {
    .visible = true,
    .named = true,
  },
  [sym_ntuple] = {
    .visible = true,
    .named = true,
  },
  [sym_tuplevec_sem] = {
    .visible = true,
    .named = true,
  },
  [sym_ntuplevec] = {
    .visible = true,
    .named = true,
  },
  [sym_argvec] = {
    .visible = true,
    .named = true,
  },
  [sym_binaryargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_cmp] = {
    .visible = true,
    .named = true,
  },
  [sym_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_mul_term] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_add_term] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_rel] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_nlitvec] = {
    .visible = true,
    .named = true,
  },
  [sym_noptcondition] = {
    .visible = true,
    .named = true,
  },
  [sym_aggregatefunction] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggrelem] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_altbodyaggrelem] = {
    .visible = true,
    .named = true,
  },
  [sym_altbodyaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_nupper] = {
    .visible = true,
    .named = true,
  },
  [sym_lubodyaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_headaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_altheadaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_headaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_luheadaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_ncspelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_disjoint] = {
    .visible = true,
    .named = true,
  },
  [sym_conjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_dsym] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunctionsep] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_nbodycomma] = {
    .visible = true,
    .named = true,
  },
  [sym_bodydot] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyconddot] = {
    .visible = true,
    .named = true,
  },
  [sym_head] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_noptimizetuple] = {
    .visible = true,
    .named = true,
  },
  [sym_optimizeweight] = {
    .visible = true,
    .named = true,
  },
  [sym_optimizelitvec] = {
    .visible = true,
    .named = true,
  },
  [sym_noptimizecond] = {
    .visible = true,
    .named = true,
  },
  [sym_maxelemlist] = {
    .visible = true,
    .named = true,
  },
  [sym_minelemlist] = {
    .visible = true,
    .named = true,
  },
  [sym_nidlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_op] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_op_list] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_term] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_opterm] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_opterm_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_element] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_element_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_name] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_definition_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_definition_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_term_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_type] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_definition_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_STRING] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_STRING_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_THEORY_OP_character_set_1(int32_t c) {
  return (c < ';'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '-' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static inline bool sym_THEORY_OP_character_set_2(int32_t c) {
  return (c < ':'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '-' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static inline bool sym_THEORY_OP_character_set_3(int32_t c) {
  return (c < ':'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '.' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(212);
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(390);
      if (lookahead == '#') ADVANCE(84);
      if (lookahead == '$') ADVANCE(245);
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '&') ADVANCE(234);
      if (lookahead == '(') ADVANCE(371);
      if (lookahead == ')') ADVANCE(291);
      if (lookahead == '*') ADVANCE(285);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == '-') ADVANCE(299);
      if (lookahead == '.') ADVANCE(257);
      if (lookahead == '/') ADVANCE(298);
      if (lookahead == '0') ADVANCE(318);
      if (lookahead == ':') ADVANCE(239);
      if (lookahead == ';') ADVANCE(292);
      if (lookahead == '<') ADVANCE(274);
      if (lookahead == '=') ADVANCE(235);
      if (lookahead == '>') ADVANCE(264);
      if (lookahead == '?') ADVANCE(288);
      if (lookahead == '@') ADVANCE(236);
      if (lookahead == '[') ADVANCE(271);
      if (lookahead == '\\') ADVANCE(284);
      if (lookahead == ']') ADVANCE(290);
      if (lookahead == '^') ADVANCE(308);
      if (lookahead == '_') ADVANCE(323);
      if (lookahead == 'a') ADVANCE(349);
      if (lookahead == 'b') ADVANCE(347);
      if (lookahead == 'd') ADVANCE(332);
      if (lookahead == 'h') ADVANCE(333);
      if (lookahead == 'l') ADVANCE(337);
      if (lookahead == 'n') ADVANCE(352);
      if (lookahead == 'o') ADVANCE(364);
      if (lookahead == 'r') ADVANCE(344);
      if (lookahead == 'u') ADVANCE(350);
      if (lookahead == '{') ADVANCE(270);
      if (lookahead == '|') ADVANCE(306);
      if (lookahead == '}') ADVANCE(289);
      if (lookahead == '~') ADVANCE(237);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(210)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(319);
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(379);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(390);
      if (lookahead == '#') ADVANCE(88);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '&') ADVANCE(234);
      if (lookahead == '(') ADVANCE(273);
      if (lookahead == ')') ADVANCE(291);
      if (lookahead == '*') ADVANCE(285);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == '-') ADVANCE(299);
      if (lookahead == '.') ADVANCE(257);
      if (lookahead == '/') ADVANCE(298);
      if (lookahead == '0') ADVANCE(318);
      if (lookahead == ':') ADVANCE(238);
      if (lookahead == ';') ADVANCE(292);
      if (lookahead == '<') ADVANCE(274);
      if (lookahead == '=') ADVANCE(235);
      if (lookahead == '>') ADVANCE(264);
      if (lookahead == '?') ADVANCE(288);
      if (lookahead == '@') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(284);
      if (lookahead == ']') ADVANCE(290);
      if (lookahead == '^') ADVANCE(308);
      if (lookahead == '_') ADVANCE(323);
      if (lookahead == '{') ADVANCE(270);
      if (lookahead == '|') ADVANCE(306);
      if (lookahead == '}') ADVANCE(289);
      if (lookahead == '~') ADVANCE(237);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(319);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(379);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(390);
      if (lookahead == '#') ADVANCE(124);
      if (lookahead == '$') ADVANCE(244);
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '&') ADVANCE(234);
      if (lookahead == '(') ADVANCE(273);
      if (lookahead == ')') ADVANCE(291);
      if (lookahead == '*') ADVANCE(285);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == '-') ADVANCE(299);
      if (lookahead == '.') ADVANCE(256);
      if (lookahead == '/') ADVANCE(298);
      if (lookahead == '0') ADVANCE(318);
      if (lookahead == ':') ADVANCE(71);
      if (lookahead == '<') ADVANCE(274);
      if (lookahead == '=') ADVANCE(235);
      if (lookahead == '>') ADVANCE(264);
      if (lookahead == '?') ADVANCE(288);
      if (lookahead == '@') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(283);
      if (lookahead == '^') ADVANCE(308);
      if (lookahead == '_') ADVANCE(323);
      if (lookahead == '|') ADVANCE(306);
      if (lookahead == '~') ADVANCE(237);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(319);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(379);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '&') ADVANCE(234);
      if (lookahead == '(') ADVANCE(371);
      if (lookahead == ')') ADVANCE(291);
      if (lookahead == '*') ADVANCE(285);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == '-') ADVANCE(299);
      if (lookahead == '.') ADVANCE(257);
      if (lookahead == '/') ADVANCE(298);
      if (lookahead == ':') ADVANCE(239);
      if (lookahead == ';') ADVANCE(292);
      if (lookahead == '<') ADVANCE(274);
      if (lookahead == '=') ADVANCE(235);
      if (lookahead == '>') ADVANCE(264);
      if (lookahead == '?') ADVANCE(288);
      if (lookahead == '@') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == ']') ADVANCE(290);
      if (lookahead == '^') ADVANCE(308);
      if (lookahead == '_') ADVANCE(77);
      if (lookahead == 'a') ADVANCE(349);
      if (lookahead == 'b') ADVANCE(347);
      if (lookahead == 'd') ADVANCE(343);
      if (lookahead == 'h') ADVANCE(333);
      if (lookahead == 'l') ADVANCE(337);
      if (lookahead == 'r') ADVANCE(344);
      if (lookahead == 'u') ADVANCE(350);
      if (lookahead == '{') ADVANCE(270);
      if (lookahead == '|') ADVANCE(306);
      if (lookahead == '}') ADVANCE(289);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '&') ADVANCE(234);
      if (lookahead == '(') ADVANCE(371);
      if (lookahead == ')') ADVANCE(291);
      if (lookahead == '*') ADVANCE(285);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == '-') ADVANCE(299);
      if (lookahead == '.') ADVANCE(257);
      if (lookahead == '/') ADVANCE(298);
      if (lookahead == ':') ADVANCE(238);
      if (lookahead == ';') ADVANCE(292);
      if (lookahead == '<') ADVANCE(274);
      if (lookahead == '=') ADVANCE(235);
      if (lookahead == '>') ADVANCE(264);
      if (lookahead == '?') ADVANCE(288);
      if (lookahead == '@') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == ']') ADVANCE(290);
      if (lookahead == '^') ADVANCE(308);
      if (lookahead == 'd') ADVANCE(109);
      if (lookahead == 'o') ADVANCE(196);
      if (lookahead == '{') ADVANCE(270);
      if (lookahead == '|') ADVANCE(306);
      if (lookahead == '}') ADVANCE(289);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '&') ADVANCE(234);
      if (lookahead == ')') ADVANCE(291);
      if (lookahead == '*') ADVANCE(285);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == '-') ADVANCE(299);
      if (lookahead == '.') ADVANCE(257);
      if (lookahead == '/') ADVANCE(298);
      if (lookahead == ':') ADVANCE(239);
      if (lookahead == ';') ADVANCE(292);
      if (lookahead == '<') ADVANCE(274);
      if (lookahead == '=') ADVANCE(235);
      if (lookahead == '>') ADVANCE(264);
      if (lookahead == '?') ADVANCE(288);
      if (lookahead == '@') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == ']') ADVANCE(290);
      if (lookahead == '^') ADVANCE(308);
      if (lookahead == '_') ADVANCE(77);
      if (lookahead == 'a') ADVANCE(349);
      if (lookahead == 'b') ADVANCE(347);
      if (lookahead == 'd') ADVANCE(343);
      if (lookahead == 'h') ADVANCE(333);
      if (lookahead == 'l') ADVANCE(337);
      if (lookahead == 'r') ADVANCE(344);
      if (lookahead == 'u') ADVANCE(350);
      if (lookahead == '{') ADVANCE(270);
      if (lookahead == '|') ADVANCE(306);
      if (lookahead == '}') ADVANCE(289);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '&') ADVANCE(234);
      if (lookahead == ')') ADVANCE(291);
      if (lookahead == '*') ADVANCE(285);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == '-') ADVANCE(299);
      if (lookahead == '.') ADVANCE(257);
      if (lookahead == '/') ADVANCE(298);
      if (lookahead == ':') ADVANCE(238);
      if (lookahead == ';') ADVANCE(292);
      if (lookahead == '<') ADVANCE(274);
      if (lookahead == '=') ADVANCE(235);
      if (lookahead == '>') ADVANCE(264);
      if (lookahead == '?') ADVANCE(288);
      if (lookahead == '@') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == ']') ADVANCE(290);
      if (lookahead == '^') ADVANCE(308);
      if (lookahead == 'd') ADVANCE(109);
      if (lookahead == 'o') ADVANCE(196);
      if (lookahead == '{') ADVANCE(270);
      if (lookahead == '|') ADVANCE(306);
      if (lookahead == '}') ADVANCE(289);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '*') ADVANCE(248);
      if (lookahead == '+') ADVANCE(246);
      if (lookahead == '-') ADVANCE(247);
      if (lookahead == '<') ADVANCE(250);
      if (lookahead == '=') ADVANCE(253);
      if (lookahead == '>') ADVANCE(251);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(390);
      if (lookahead == '#') ADVANCE(124);
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '(') ADVANCE(273);
      if (lookahead == ')') ADVANCE(291);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == '0') ADVANCE(318);
      if (lookahead == '[') ADVANCE(271);
      if (lookahead == ']') ADVANCE(290);
      if (lookahead == '_') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(352);
      if (lookahead == '{') ADVANCE(270);
      if (lookahead == '}') ADVANCE(289);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(319);
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(381);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(379);
      END_STATE();
    case 9:
      if (lookahead == '"') ADVANCE(390);
      if (lookahead == '#') ADVANCE(124);
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '(') ADVANCE(273);
      if (lookahead == '0') ADVANCE(318);
      if (lookahead == ':') ADVANCE(240);
      if (lookahead == '[') ADVANCE(271);
      if (lookahead == '_') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(352);
      if (lookahead == '{') ADVANCE(270);
      if (lookahead == '}') ADVANCE(289);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(319);
      if (lookahead == '!' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(381);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(379);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(390);
      if (lookahead == '%') ADVANCE(395);
      if (lookahead == '\\') ADVANCE(187);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(392);
      if (lookahead != 0) ADVANCE(396);
      END_STATE();
    case 11:
      if (lookahead == '#') ADVANCE(31);
      if (lookahead == '%') ADVANCE(228);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(11);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '#') ADVANCE(31);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '%') ADVANCE(227);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 14:
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(33);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '%') ADVANCE(229);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 17:
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 18:
      if (lookahead == '#') ADVANCE(49);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 19:
      if (lookahead == '#') ADVANCE(50);
      if (lookahead == '%') ADVANCE(230);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 20:
      if (lookahead == '#') ADVANCE(50);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 21:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 22:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 23:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(25);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 24:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 25:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(375);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 26:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(376);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 27:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 28:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'e') ADVANCE(28);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 29:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'e') ADVANCE(28);
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 30:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 31:
      if (lookahead == '#') ADVANCE(37);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 32:
      if (lookahead == '#') ADVANCE(40);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 33:
      if (lookahead == '#') ADVANCE(22);
      if (lookahead == 'e') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0 &&
          lookahead != 'd') ADVANCE(15);
      END_STATE();
    case 34:
      if (lookahead == '#') ADVANCE(28);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(70);
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 35:
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 36:
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 37:
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 38:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 39:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 40:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 41:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 42:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 43:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(59);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 44:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 45:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 46:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 47:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(61);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 48:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 49:
      if (lookahead == '#') ADVANCE(44);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 50:
      if (lookahead == '#') ADVANCE(48);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 51:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 52:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(54);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 53:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 54:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(373);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 55:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 56:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(58);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 57:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 58:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(374);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 59:
      if (lookahead == '#') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(377);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 60:
      if (lookahead == '#') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 61:
      if (lookahead == '#') ADVANCE(45);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(378);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 62:
      if (lookahead == '#') ADVANCE(45);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 63:
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '&') ADVANCE(234);
      if (lookahead == '(') ADVANCE(371);
      if (lookahead == ')') ADVANCE(291);
      if (lookahead == '*') ADVANCE(285);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == '-') ADVANCE(299);
      if (lookahead == '.') ADVANCE(256);
      if (lookahead == '/') ADVANCE(298);
      if (lookahead == '?') ADVANCE(288);
      if (lookahead == '\\') ADVANCE(283);
      if (lookahead == '^') ADVANCE(308);
      if (lookahead == '|') ADVANCE(306);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      END_STATE();
    case 64:
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '&') ADVANCE(234);
      if (lookahead == ')') ADVANCE(291);
      if (lookahead == '*') ADVANCE(285);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == '-') ADVANCE(299);
      if (lookahead == '.') ADVANCE(256);
      if (lookahead == '/') ADVANCE(298);
      if (lookahead == '?') ADVANCE(288);
      if (lookahead == '\\') ADVANCE(283);
      if (lookahead == '^') ADVANCE(308);
      if (lookahead == '|') ADVANCE(306);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      END_STATE();
    case 65:
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '(') ADVANCE(273);
      if (lookahead == ')') ADVANCE(291);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == ']') ADVANCE(290);
      if (lookahead == 'n') ADVANCE(157);
      if (lookahead == '}') ADVANCE(289);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(65)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          (':' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(381);
      END_STATE();
    case 66:
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '(') ADVANCE(273);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == '.') ADVANCE(258);
      if (lookahead == ';') ADVANCE(293);
      if (lookahead == 'n') ADVANCE(157);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(66)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          (':' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(381);
      END_STATE();
    case 67:
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '(') ADVANCE(273);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == ':') ADVANCE(240);
      if (lookahead == ';') ADVANCE(293);
      if (lookahead == 'n') ADVANCE(157);
      if (lookahead == '}') ADVANCE(289);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(67)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          ('<' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(381);
      END_STATE();
    case 68:
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '(') ADVANCE(273);
      if (lookahead == '.') ADVANCE(258);
      if (lookahead == ':') ADVANCE(380);
      if (lookahead == 'n') ADVANCE(157);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(68)
      if (sym_THEORY_OP_character_set_1(lookahead)) ADVANCE(381);
      END_STATE();
    case 69:
      if (lookahead == '%') ADVANCE(213);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 70:
      if (lookahead == '*') ADVANCE(69);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 71:
      if (lookahead == '-') ADVANCE(265);
      END_STATE();
    case 72:
      if (lookahead == '-') ADVANCE(265);
      if (lookahead == '~') ADVANCE(307);
      END_STATE();
    case 73:
      if (lookahead == '=') ADVANCE(286);
      END_STATE();
    case 74:
      if (lookahead == '=') ADVANCE(254);
      END_STATE();
    case 75:
      if (lookahead == '\\') ADVANCE(388);
      END_STATE();
    case 76:
      if (lookahead == '_') ADVANCE(76);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(379);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 77:
      if (lookahead == '_') ADVANCE(77);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 78:
      if (lookahead == 'a') ADVANCE(131);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(198);
      if (lookahead == 'i') ADVANCE(144);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(199);
      if (lookahead == 'i') ADVANCE(145);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 82:
      if (lookahead == 'a') ADVANCE(137);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(191);
      END_STATE();
    case 84:
      if (lookahead == 'c') ADVANCE(152);
      if (lookahead == 'd') ADVANCE(95);
      if (lookahead == 'e') ADVANCE(91);
      if (lookahead == 'f') ADVANCE(78);
      if (lookahead == 'h') ADVANCE(96);
      if (lookahead == 'i') ADVANCE(143);
      if (lookahead == 'm') ADVANCE(79);
      if (lookahead == 'p') ADVANCE(162);
      if (lookahead == 's') ADVANCE(86);
      if (lookahead == 't') ADVANCE(118);
      END_STATE();
    case 85:
      if (lookahead == 'c') ADVANCE(297);
      END_STATE();
    case 86:
      if (lookahead == 'c') ADVANCE(165);
      if (lookahead == 'h') ADVANCE(154);
      if (lookahead == 'u') ADVANCE(135);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(268);
      END_STATE();
    case 88:
      if (lookahead == 'c') ADVANCE(156);
      if (lookahead == 'd') ADVANCE(119);
      if (lookahead == 'f') ADVANCE(78);
      if (lookahead == 'i') ADVANCE(146);
      if (lookahead == 'm') ADVANCE(80);
      if (lookahead == 's') ADVANCE(185);
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 89:
      if (lookahead == 'c') ADVANCE(156);
      if (lookahead == 'm') ADVANCE(80);
      if (lookahead == 's') ADVANCE(194);
      END_STATE();
    case 90:
      if (lookahead == 'c') ADVANCE(179);
      END_STATE();
    case 91:
      if (lookahead == 'd') ADVANCE(116);
      if (lookahead == 'x') ADVANCE(183);
      END_STATE();
    case 92:
      if (lookahead == 'd') ADVANCE(261);
      END_STATE();
    case 93:
      if (lookahead == 'd') ADVANCE(101);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(106);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(113);
      if (lookahead == 'i') ADVANCE(170);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(195);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(295);
      END_STATE();
    case 98:
      if (lookahead == 'e') ADVANCE(304);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(267);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(278);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(277);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(282);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(281);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(386);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 110:
      if (lookahead == 'e') ADVANCE(155);
      END_STATE();
    case 111:
      if (lookahead == 'e') ADVANCE(169);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(141);
      END_STATE();
    case 113:
      if (lookahead == 'f') ADVANCE(123);
      END_STATE();
    case 114:
      if (lookahead == 'f') ADVANCE(268);
      END_STATE();
    case 115:
      if (lookahead == 'f') ADVANCE(83);
      END_STATE();
    case 116:
      if (lookahead == 'g') ADVANCE(97);
      END_STATE();
    case 117:
      if (lookahead == 'g') ADVANCE(163);
      if (lookahead == 'j') ADVANCE(100);
      END_STATE();
    case 118:
      if (lookahead == 'h') ADVANCE(110);
      if (lookahead == 'r') ADVANCE(192);
      END_STATE();
    case 119:
      if (lookahead == 'i') ADVANCE(170);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(160);
      END_STATE();
    case 121:
      if (lookahead == 'i') ADVANCE(174);
      END_STATE();
    case 122:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 123:
      if (lookahead == 'i') ADVANCE(150);
      END_STATE();
    case 124:
      if (lookahead == 'i') ADVANCE(146);
      if (lookahead == 's') ADVANCE(188);
      END_STATE();
    case 125:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 126:
      if (lookahead == 'i') ADVANCE(175);
      END_STATE();
    case 127:
      if (lookahead == 'i') ADVANCE(172);
      END_STATE();
    case 128:
      if (lookahead == 'i') ADVANCE(149);
      END_STATE();
    case 129:
      if (lookahead == 'j') ADVANCE(158);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(260);
      END_STATE();
    case 131:
      if (lookahead == 'l') ADVANCE(173);
      END_STATE();
    case 132:
      if (lookahead == 'l') ADVANCE(186);
      END_STATE();
    case 133:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 134:
      if (lookahead == 'm') ADVANCE(300);
      END_STATE();
    case 135:
      if (lookahead == 'm') ADVANCE(300);
      if (lookahead == 'p') ADVANCE(302);
      END_STATE();
    case 136:
      if (lookahead == 'm') ADVANCE(269);
      END_STATE();
    case 137:
      if (lookahead == 'm') ADVANCE(305);
      END_STATE();
    case 138:
      if (lookahead == 'm') ADVANCE(303);
      END_STATE();
    case 139:
      if (lookahead == 'm') ADVANCE(190);
      END_STATE();
    case 140:
      if (lookahead == 'm') ADVANCE(121);
      END_STATE();
    case 141:
      if (lookahead == 'm') ADVANCE(193);
      END_STATE();
    case 142:
      if (lookahead == 'm') ADVANCE(126);
      END_STATE();
    case 143:
      if (lookahead == 'n') ADVANCE(87);
      END_STATE();
    case 144:
      if (lookahead == 'n') ADVANCE(280);
      END_STATE();
    case 145:
      if (lookahead == 'n') ADVANCE(279);
      END_STATE();
    case 146:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 147:
      if (lookahead == 'n') ADVANCE(171);
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 148:
      if (lookahead == 'n') ADVANCE(177);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(180);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(107);
      END_STATE();
    case 151:
      if (lookahead == 'n') ADVANCE(81);
      END_STATE();
    case 152:
      if (lookahead == 'o') ADVANCE(147);
      END_STATE();
    case 153:
      if (lookahead == 'o') ADVANCE(117);
      END_STATE();
    case 154:
      if (lookahead == 'o') ADVANCE(197);
      END_STATE();
    case 155:
      if (lookahead == 'o') ADVANCE(161);
      END_STATE();
    case 156:
      if (lookahead == 'o') ADVANCE(189);
      END_STATE();
    case 157:
      if (lookahead == 'o') ADVANCE(182);
      END_STATE();
    case 158:
      if (lookahead == 'o') ADVANCE(128);
      END_STATE();
    case 159:
      if (lookahead == 'p') ADVANCE(302);
      END_STATE();
    case 160:
      if (lookahead == 'p') ADVANCE(178);
      END_STATE();
    case 161:
      if (lookahead == 'r') ADVANCE(200);
      END_STATE();
    case 162:
      if (lookahead == 'r') ADVANCE(153);
      END_STATE();
    case 163:
      if (lookahead == 'r') ADVANCE(82);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(192);
      END_STATE();
    case 165:
      if (lookahead == 'r') ADVANCE(120);
      END_STATE();
    case 166:
      if (lookahead == 'r') ADVANCE(127);
      END_STATE();
    case 167:
      if (lookahead == 'r') ADVANCE(151);
      END_STATE();
    case 168:
      if (lookahead == 'r') ADVANCE(125);
      END_STATE();
    case 169:
      if (lookahead == 'r') ADVANCE(168);
      END_STATE();
    case 170:
      if (lookahead == 's') ADVANCE(129);
      END_STATE();
    case 171:
      if (lookahead == 's') ADVANCE(176);
      END_STATE();
    case 172:
      if (lookahead == 's') ADVANCE(184);
      END_STATE();
    case 173:
      if (lookahead == 's') ADVANCE(99);
      END_STATE();
    case 174:
      if (lookahead == 's') ADVANCE(102);
      if (lookahead == 'z') ADVANCE(103);
      END_STATE();
    case 175:
      if (lookahead == 's') ADVANCE(104);
      if (lookahead == 'z') ADVANCE(105);
      END_STATE();
    case 176:
      if (lookahead == 't') ADVANCE(242);
      END_STATE();
    case 177:
      if (lookahead == 't') ADVANCE(243);
      END_STATE();
    case 178:
      if (lookahead == 't') ADVANCE(372);
      END_STATE();
    case 179:
      if (lookahead == 't') ADVANCE(296);
      END_STATE();
    case 180:
      if (lookahead == 't') ADVANCE(255);
      END_STATE();
    case 181:
      if (lookahead == 't') ADVANCE(384);
      END_STATE();
    case 182:
      if (lookahead == 't') ADVANCE(382);
      END_STATE();
    case 183:
      if (lookahead == 't') ADVANCE(108);
      END_STATE();
    case 184:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 185:
      if (lookahead == 'u') ADVANCE(135);
      END_STATE();
    case 186:
      if (lookahead == 'u') ADVANCE(93);
      END_STATE();
    case 187:
      if (lookahead == 'u') ADVANCE(201);
      if (lookahead == 'x') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(399);
      if (lookahead != 0) ADVANCE(397);
      END_STATE();
    case 188:
      if (lookahead == 'u') ADVANCE(159);
      END_STATE();
    case 189:
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 190:
      if (lookahead == 'u') ADVANCE(136);
      END_STATE();
    case 191:
      if (lookahead == 'u') ADVANCE(133);
      END_STATE();
    case 192:
      if (lookahead == 'u') ADVANCE(98);
      END_STATE();
    case 193:
      if (lookahead == 'u') ADVANCE(138);
      END_STATE();
    case 194:
      if (lookahead == 'u') ADVANCE(134);
      END_STATE();
    case 195:
      if (lookahead == 'u') ADVANCE(166);
      END_STATE();
    case 196:
      if (lookahead == 'v') ADVANCE(111);
      END_STATE();
    case 197:
      if (lookahead == 'w') ADVANCE(294);
      END_STATE();
    case 198:
      if (lookahead == 'x') ADVANCE(276);
      END_STATE();
    case 199:
      if (lookahead == 'x') ADVANCE(275);
      END_STATE();
    case 200:
      if (lookahead == 'y') ADVANCE(317);
      END_STATE();
    case 201:
      if (lookahead == '{') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(208);
      END_STATE();
    case 202:
      if (lookahead == '}') ADVANCE(397);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 203:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(322);
      END_STATE();
    case 204:
      if (('1' <= lookahead && lookahead <= '7')) ADVANCE(321);
      END_STATE();
    case 205:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(320);
      END_STATE();
    case 206:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(397);
      END_STATE();
    case 207:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 208:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(209);
      END_STATE();
    case 209:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(206);
      END_STATE();
    case 210:
      if (eof) ADVANCE(212);
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(390);
      if (lookahead == '#') ADVANCE(84);
      if (lookahead == '$') ADVANCE(245);
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '&') ADVANCE(234);
      if (lookahead == '(') ADVANCE(273);
      if (lookahead == ')') ADVANCE(291);
      if (lookahead == '*') ADVANCE(285);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == '-') ADVANCE(299);
      if (lookahead == '.') ADVANCE(257);
      if (lookahead == '/') ADVANCE(298);
      if (lookahead == '0') ADVANCE(318);
      if (lookahead == ':') ADVANCE(239);
      if (lookahead == ';') ADVANCE(292);
      if (lookahead == '<') ADVANCE(274);
      if (lookahead == '=') ADVANCE(235);
      if (lookahead == '>') ADVANCE(264);
      if (lookahead == '?') ADVANCE(288);
      if (lookahead == '@') ADVANCE(236);
      if (lookahead == '[') ADVANCE(271);
      if (lookahead == '\\') ADVANCE(284);
      if (lookahead == ']') ADVANCE(290);
      if (lookahead == '^') ADVANCE(308);
      if (lookahead == '_') ADVANCE(323);
      if (lookahead == 'a') ADVANCE(349);
      if (lookahead == 'b') ADVANCE(347);
      if (lookahead == 'd') ADVANCE(332);
      if (lookahead == 'h') ADVANCE(333);
      if (lookahead == 'l') ADVANCE(337);
      if (lookahead == 'n') ADVANCE(352);
      if (lookahead == 'o') ADVANCE(364);
      if (lookahead == 'r') ADVANCE(344);
      if (lookahead == 'u') ADVANCE(350);
      if (lookahead == '{') ADVANCE(270);
      if (lookahead == '|') ADVANCE(306);
      if (lookahead == '}') ADVANCE(289);
      if (lookahead == '~') ADVANCE(237);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(210)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(319);
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(379);
      END_STATE();
    case 211:
      if (eof) ADVANCE(212);
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(390);
      if (lookahead == '#') ADVANCE(84);
      if (lookahead == '$') ADVANCE(244);
      if (lookahead == '%') ADVANCE(231);
      if (lookahead == '&') ADVANCE(234);
      if (lookahead == '(') ADVANCE(273);
      if (lookahead == ')') ADVANCE(291);
      if (lookahead == '*') ADVANCE(285);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(241);
      if (lookahead == '-') ADVANCE(299);
      if (lookahead == '.') ADVANCE(257);
      if (lookahead == '/') ADVANCE(298);
      if (lookahead == '0') ADVANCE(318);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(292);
      if (lookahead == '<') ADVANCE(274);
      if (lookahead == '=') ADVANCE(235);
      if (lookahead == '>') ADVANCE(264);
      if (lookahead == '?') ADVANCE(288);
      if (lookahead == '@') ADVANCE(236);
      if (lookahead == '[') ADVANCE(271);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == ']') ADVANCE(290);
      if (lookahead == '^') ADVANCE(308);
      if (lookahead == '_') ADVANCE(323);
      if (lookahead == 'n') ADVANCE(352);
      if (lookahead == '{') ADVANCE(270);
      if (lookahead == '|') ADVANCE(306);
      if (lookahead == '}') ADVANCE(289);
      if (lookahead == '~') ADVANCE(237);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(211)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(319);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(379);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(217);
      if (lookahead == 'd') ADVANCE(216);
      if (lookahead == 'e') ADVANCE(214);
      if (lookahead == 'n') ADVANCE(215);
      if (lookahead != 0) ADVANCE(216);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(217);
      if (lookahead == 'd') ADVANCE(216);
      if (lookahead == 'n') ADVANCE(215);
      if (lookahead != 0) ADVANCE(216);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(217);
      if (lookahead != 0) ADVANCE(216);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(218);
      if (lookahead == 'd') ADVANCE(216);
      if (lookahead == 'e') ADVANCE(224);
      if (lookahead == 'n') ADVANCE(215);
      if (lookahead != 0) ADVANCE(216);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(218);
      if (lookahead == 'd') ADVANCE(216);
      if (lookahead == 'e') ADVANCE(214);
      if (lookahead == 'n') ADVANCE(215);
      if (lookahead != 0) ADVANCE(216);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == 'd') ADVANCE(232);
      if (lookahead == 'e') ADVANCE(220);
      if (lookahead == 'n') ADVANCE(221);
      if (lookahead != 0) ADVANCE(222);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == 'd') ADVANCE(222);
      if (lookahead == 'e') ADVANCE(220);
      if (lookahead == 'n') ADVANCE(221);
      if (lookahead != 0) ADVANCE(222);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == 'd') ADVANCE(222);
      if (lookahead == 'n') ADVANCE(221);
      if (lookahead != 0) ADVANCE(222);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(219);
      if (lookahead != 0) ADVANCE(222);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(224);
      if (lookahead == 'd') ADVANCE(226);
      if (lookahead == 'e') ADVANCE(224);
      if (lookahead == 'n') ADVANCE(221);
      if (lookahead != 0) ADVANCE(226);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(224);
      if (lookahead == 'd') ADVANCE(226);
      if (lookahead == 'e') ADVANCE(224);
      if (lookahead == 'n') ADVANCE(225);
      if (lookahead != 0) ADVANCE(226);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(223);
      if (lookahead == 'd') ADVANCE(226);
      if (lookahead == 'n') ADVANCE(225);
      if (lookahead != 0) ADVANCE(226);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(223);
      if (lookahead != 0) ADVANCE(226);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(31);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(217);
      if (lookahead == '*') ADVANCE(14);
      if (lookahead != 0) ADVANCE(216);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(49);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead != 0) ADVANCE(232);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(232);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_ADD);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_AND);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_EQ);
      if (lookahead == '=') ADVANCE(389);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_AT);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_BNOT);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_COLON);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_COLON);
      if (lookahead == '-') ADVANCE(265);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_COLON);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(381);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_COMMA);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_CONST);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_COUNT);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_CSP);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_CSP);
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '*') ADVANCE(248);
      if (lookahead == '+') ADVANCE(246);
      if (lookahead == '<') ADVANCE(250);
      if (lookahead == '=') ADVANCE(253);
      if (lookahead == '>') ADVANCE(251);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_CSP_ADD);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_CSP_SUB);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_CSP_MUL);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_CSP_LEQ);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_CSP_LT);
      if (lookahead == '=') ADVANCE(249);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_CSP_GT);
      if (lookahead == '=') ADVANCE(252);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_CSP_GEQ);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_CSP_EQ);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_CSP_NEQ);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_DISJOINT);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_DOT);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_DOT);
      if (lookahead == '.') ADVANCE(259);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_DOT);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(381);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_DOTS);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_EXTERNAL);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_DEFINED);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_FALSE);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_GEQ);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_GT);
      if (lookahead == '=') ADVANCE(263);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_IF);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_IF);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(381);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_INCLUDE);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_POUNDinf);
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_POUNDinfimum);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_LBRACE);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_LBRACK);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_LEQ);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_LPAREN);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_LT);
      if (lookahead == '=') ADVANCE(272);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_MAX);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_MAX);
      if (lookahead == 'i') ADVANCE(140);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_POUNDmaximize);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_POUNDmaximise);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_MIN);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_MIN);
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_POUNDminimize);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_POUNDminimise);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_MOD);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_MOD);
      if (lookahead == '\\') ADVANCE(388);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_MUL);
      if (lookahead == '*') ADVANCE(287);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_NEQ);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_POW);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_QUESTION);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_RBRACE);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_RBRACK);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_RPAREN);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_SEM);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_SEM);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(381);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_SHOW);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_EDGE);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_PROJECT);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_HEURISTIC);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_SLASH);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_SUB);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_SUM);
      if (lookahead == '+') ADVANCE(301);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_SUMP);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_POUNDsup);
      if (lookahead == 'r') ADVANCE(112);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_POUNDsupremum);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_TRUE);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_BLOCK);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_VBAR);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_WIF);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_XOR);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_ANY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_UNARY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_BINARY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_LEFT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_RIGHT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_HEAD);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_BODY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_DIRECTIVE);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_THEORY);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == 'b') ADVANCE(203);
      if (lookahead == 'o') ADVANCE(204);
      if (lookahead == 'x') ADVANCE(205);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(aux_sym_dec_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(319);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_hex);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(320);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_oct);
      if (('1' <= lookahead && lookahead <= '7')) ADVANCE(321);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_bin);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(322);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_ANONYMOUS);
      if (lookahead == '_') ADVANCE(76);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(379);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(363);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(329);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(354);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(356);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(362);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(314);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(367);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(335);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(340);
      if (lookahead == 'i') ADVANCE(355);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(325);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(328);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(387);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(316);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(339);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(357);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(359);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(324);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'g') ADVANCE(342);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(360);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(355);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(341);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(331);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(365);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(351);
      if (lookahead == 'o') ADVANCE(330);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(361);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(366);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(326);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(327);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(358);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(345);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(368);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(334);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(369);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(353);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(383);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(312);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(313);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(385);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(346);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(348);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(338);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(336);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(309);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(315);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(310);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(311);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_SCRIPT);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(31);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(49);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(50);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_VARIABLE);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(379);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_THEORY_OP);
      if (lookahead == '-') ADVANCE(266);
      if (sym_THEORY_OP_character_set_3(lookahead)) ADVANCE(381);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_THEORY_OP);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(381);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_NOT);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_NOT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_DEFAULT);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_DEFAULT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_OVERRIDE);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_OVERRIDE);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(370);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_BSLASH_BSLASH);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(396);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(391);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '%') ADVANCE(395);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(392);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(396);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '%') ADVANCE(396);
      if (lookahead == '*') ADVANCE(393);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(394);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(393);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(394);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(394);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(391);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(396);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(397);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(398);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 211},
  [2] = {.lex_state = 211},
  [3] = {.lex_state = 211},
  [4] = {.lex_state = 211},
  [5] = {.lex_state = 211},
  [6] = {.lex_state = 211},
  [7] = {.lex_state = 211},
  [8] = {.lex_state = 211},
  [9] = {.lex_state = 211},
  [10] = {.lex_state = 211},
  [11] = {.lex_state = 211},
  [12] = {.lex_state = 211},
  [13] = {.lex_state = 211},
  [14] = {.lex_state = 211},
  [15] = {.lex_state = 211},
  [16] = {.lex_state = 211},
  [17] = {.lex_state = 211},
  [18] = {.lex_state = 211},
  [19] = {.lex_state = 211},
  [20] = {.lex_state = 211},
  [21] = {.lex_state = 211},
  [22] = {.lex_state = 211},
  [23] = {.lex_state = 211},
  [24] = {.lex_state = 211},
  [25] = {.lex_state = 211},
  [26] = {.lex_state = 211},
  [27] = {.lex_state = 211},
  [28] = {.lex_state = 211},
  [29] = {.lex_state = 211},
  [30] = {.lex_state = 211},
  [31] = {.lex_state = 3},
  [32] = {.lex_state = 1},
  [33] = {.lex_state = 1},
  [34] = {.lex_state = 1},
  [35] = {.lex_state = 4},
  [36] = {.lex_state = 1},
  [37] = {.lex_state = 1},
  [38] = {.lex_state = 1},
  [39] = {.lex_state = 4},
  [40] = {.lex_state = 4},
  [41] = {.lex_state = 211},
  [42] = {.lex_state = 4},
  [43] = {.lex_state = 4},
  [44] = {.lex_state = 4},
  [45] = {.lex_state = 211},
  [46] = {.lex_state = 3},
  [47] = {.lex_state = 3},
  [48] = {.lex_state = 3},
  [49] = {.lex_state = 3},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 3},
  [53] = {.lex_state = 3},
  [54] = {.lex_state = 3},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 3},
  [57] = {.lex_state = 3},
  [58] = {.lex_state = 3},
  [59] = {.lex_state = 211},
  [60] = {.lex_state = 4},
  [61] = {.lex_state = 4},
  [62] = {.lex_state = 211},
  [63] = {.lex_state = 4},
  [64] = {.lex_state = 211},
  [65] = {.lex_state = 211},
  [66] = {.lex_state = 211},
  [67] = {.lex_state = 4},
  [68] = {.lex_state = 1},
  [69] = {.lex_state = 211},
  [70] = {.lex_state = 211},
  [71] = {.lex_state = 211},
  [72] = {.lex_state = 1},
  [73] = {.lex_state = 211},
  [74] = {.lex_state = 1},
  [75] = {.lex_state = 2},
  [76] = {.lex_state = 2},
  [77] = {.lex_state = 211},
  [78] = {.lex_state = 2},
  [79] = {.lex_state = 3},
  [80] = {.lex_state = 3},
  [81] = {.lex_state = 211},
  [82] = {.lex_state = 211},
  [83] = {.lex_state = 211},
  [84] = {.lex_state = 211},
  [85] = {.lex_state = 211},
  [86] = {.lex_state = 211},
  [87] = {.lex_state = 211},
  [88] = {.lex_state = 211},
  [89] = {.lex_state = 211},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 1},
  [92] = {.lex_state = 1},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 1},
  [96] = {.lex_state = 9},
  [97] = {.lex_state = 9},
  [98] = {.lex_state = 1},
  [99] = {.lex_state = 211},
  [100] = {.lex_state = 211},
  [101] = {.lex_state = 211},
  [102] = {.lex_state = 211},
  [103] = {.lex_state = 211},
  [104] = {.lex_state = 1},
  [105] = {.lex_state = 1},
  [106] = {.lex_state = 211},
  [107] = {.lex_state = 211},
  [108] = {.lex_state = 1},
  [109] = {.lex_state = 9},
  [110] = {.lex_state = 1},
  [111] = {.lex_state = 1},
  [112] = {.lex_state = 211},
  [113] = {.lex_state = 1},
  [114] = {.lex_state = 8},
  [115] = {.lex_state = 8},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 2},
  [118] = {.lex_state = 8},
  [119] = {.lex_state = 1},
  [120] = {.lex_state = 1},
  [121] = {.lex_state = 8},
  [122] = {.lex_state = 8},
  [123] = {.lex_state = 8},
  [124] = {.lex_state = 8},
  [125] = {.lex_state = 8},
  [126] = {.lex_state = 1},
  [127] = {.lex_state = 1},
  [128] = {.lex_state = 2},
  [129] = {.lex_state = 8},
  [130] = {.lex_state = 8},
  [131] = {.lex_state = 1},
  [132] = {.lex_state = 1},
  [133] = {.lex_state = 8},
  [134] = {.lex_state = 1},
  [135] = {.lex_state = 2},
  [136] = {.lex_state = 1},
  [137] = {.lex_state = 8},
  [138] = {.lex_state = 1},
  [139] = {.lex_state = 8},
  [140] = {.lex_state = 1},
  [141] = {.lex_state = 2},
  [142] = {.lex_state = 1},
  [143] = {.lex_state = 2},
  [144] = {.lex_state = 1},
  [145] = {.lex_state = 1},
  [146] = {.lex_state = 8},
  [147] = {.lex_state = 1},
  [148] = {.lex_state = 8},
  [149] = {.lex_state = 2},
  [150] = {.lex_state = 2},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 8},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 8},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 1},
  [157] = {.lex_state = 1},
  [158] = {.lex_state = 1},
  [159] = {.lex_state = 2},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 8},
  [162] = {.lex_state = 2},
  [163] = {.lex_state = 8},
  [164] = {.lex_state = 3},
  [165] = {.lex_state = 2},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 2},
  [168] = {.lex_state = 2},
  [169] = {.lex_state = 8},
  [170] = {.lex_state = 3},
  [171] = {.lex_state = 2},
  [172] = {.lex_state = 3},
  [173] = {.lex_state = 2},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 8},
  [176] = {.lex_state = 1},
  [177] = {.lex_state = 211},
  [178] = {.lex_state = 211},
  [179] = {.lex_state = 8},
  [180] = {.lex_state = 1},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 8},
  [183] = {.lex_state = 8},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 1},
  [186] = {.lex_state = 8},
  [187] = {.lex_state = 1},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 1},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 3},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 8},
  [194] = {.lex_state = 4},
  [195] = {.lex_state = 3},
  [196] = {.lex_state = 3},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 3},
  [201] = {.lex_state = 3},
  [202] = {.lex_state = 3},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 3},
  [215] = {.lex_state = 3},
  [216] = {.lex_state = 3},
  [217] = {.lex_state = 3},
  [218] = {.lex_state = 3},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 3},
  [227] = {.lex_state = 3},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 4},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 3},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 4},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 3},
  [248] = {.lex_state = 4},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 3},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 3},
  [253] = {.lex_state = 3},
  [254] = {.lex_state = 1},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 4},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 4},
  [263] = {.lex_state = 4},
  [264] = {.lex_state = 1},
  [265] = {.lex_state = 3},
  [266] = {.lex_state = 1},
  [267] = {.lex_state = 1},
  [268] = {.lex_state = 4},
  [269] = {.lex_state = 1},
  [270] = {.lex_state = 1},
  [271] = {.lex_state = 1},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 3},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 3},
  [279] = {.lex_state = 1},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 1},
  [282] = {.lex_state = 8},
  [283] = {.lex_state = 3},
  [284] = {.lex_state = 8},
  [285] = {.lex_state = 4},
  [286] = {.lex_state = 8},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 4},
  [289] = {.lex_state = 8},
  [290] = {.lex_state = 8},
  [291] = {.lex_state = 8},
  [292] = {.lex_state = 8},
  [293] = {.lex_state = 1},
  [294] = {.lex_state = 8},
  [295] = {.lex_state = 1},
  [296] = {.lex_state = 1},
  [297] = {.lex_state = 1},
  [298] = {.lex_state = 1},
  [299] = {.lex_state = 1},
  [300] = {.lex_state = 1},
  [301] = {.lex_state = 1},
  [302] = {.lex_state = 3},
  [303] = {.lex_state = 4},
  [304] = {.lex_state = 1},
  [305] = {.lex_state = 1},
  [306] = {.lex_state = 1},
  [307] = {.lex_state = 3},
  [308] = {.lex_state = 211},
  [309] = {.lex_state = 211},
  [310] = {.lex_state = 211},
  [311] = {.lex_state = 3},
  [312] = {.lex_state = 211},
  [313] = {.lex_state = 211},
  [314] = {.lex_state = 1},
  [315] = {.lex_state = 1},
  [316] = {.lex_state = 1},
  [317] = {.lex_state = 8},
  [318] = {.lex_state = 2},
  [319] = {.lex_state = 1},
  [320] = {.lex_state = 211},
  [321] = {.lex_state = 211},
  [322] = {.lex_state = 211},
  [323] = {.lex_state = 211},
  [324] = {.lex_state = 211},
  [325] = {.lex_state = 211},
  [326] = {.lex_state = 8},
  [327] = {.lex_state = 8},
  [328] = {.lex_state = 3},
  [329] = {.lex_state = 3},
  [330] = {.lex_state = 3},
  [331] = {.lex_state = 4},
  [332] = {.lex_state = 3},
  [333] = {.lex_state = 3},
  [334] = {.lex_state = 4},
  [335] = {.lex_state = 4},
  [336] = {.lex_state = 3},
  [337] = {.lex_state = 4},
  [338] = {.lex_state = 63},
  [339] = {.lex_state = 211},
  [340] = {.lex_state = 3},
  [341] = {.lex_state = 4},
  [342] = {.lex_state = 211},
  [343] = {.lex_state = 4},
  [344] = {.lex_state = 3},
  [345] = {.lex_state = 211},
  [346] = {.lex_state = 63},
  [347] = {.lex_state = 211},
  [348] = {.lex_state = 211},
  [349] = {.lex_state = 4},
  [350] = {.lex_state = 2},
  [351] = {.lex_state = 2},
  [352] = {.lex_state = 4},
  [353] = {.lex_state = 1},
  [354] = {.lex_state = 211},
  [355] = {.lex_state = 1},
  [356] = {.lex_state = 2},
  [357] = {.lex_state = 4},
  [358] = {.lex_state = 2},
  [359] = {.lex_state = 2},
  [360] = {.lex_state = 2},
  [361] = {.lex_state = 211},
  [362] = {.lex_state = 3},
  [363] = {.lex_state = 2},
  [364] = {.lex_state = 2},
  [365] = {.lex_state = 1},
  [366] = {.lex_state = 2},
  [367] = {.lex_state = 211},
  [368] = {.lex_state = 2},
  [369] = {.lex_state = 2},
  [370] = {.lex_state = 4},
  [371] = {.lex_state = 211},
  [372] = {.lex_state = 211},
  [373] = {.lex_state = 211},
  [374] = {.lex_state = 211},
  [375] = {.lex_state = 211},
  [376] = {.lex_state = 3},
  [377] = {.lex_state = 211},
  [378] = {.lex_state = 4},
  [379] = {.lex_state = 211},
  [380] = {.lex_state = 1},
  [381] = {.lex_state = 211},
  [382] = {.lex_state = 3},
  [383] = {.lex_state = 211},
  [384] = {.lex_state = 211},
  [385] = {.lex_state = 2},
  [386] = {.lex_state = 211},
  [387] = {.lex_state = 2},
  [388] = {.lex_state = 211},
  [389] = {.lex_state = 211},
  [390] = {.lex_state = 211},
  [391] = {.lex_state = 211},
  [392] = {.lex_state = 2},
  [393] = {.lex_state = 3},
  [394] = {.lex_state = 3},
  [395] = {.lex_state = 3},
  [396] = {.lex_state = 2},
  [397] = {.lex_state = 3},
  [398] = {.lex_state = 3},
  [399] = {.lex_state = 3},
  [400] = {.lex_state = 3},
  [401] = {.lex_state = 65},
  [402] = {.lex_state = 67},
  [403] = {.lex_state = 67},
  [404] = {.lex_state = 65},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 66},
  [410] = {.lex_state = 0},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 0},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 65},
  [416] = {.lex_state = 0},
  [417] = {.lex_state = 66},
  [418] = {.lex_state = 0},
  [419] = {.lex_state = 0},
  [420] = {.lex_state = 0},
  [421] = {.lex_state = 67},
  [422] = {.lex_state = 65},
  [423] = {.lex_state = 65},
  [424] = {.lex_state = 1},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 65},
  [427] = {.lex_state = 65},
  [428] = {.lex_state = 0},
  [429] = {.lex_state = 66},
  [430] = {.lex_state = 67},
  [431] = {.lex_state = 67},
  [432] = {.lex_state = 68},
  [433] = {.lex_state = 67},
  [434] = {.lex_state = 67},
  [435] = {.lex_state = 67},
  [436] = {.lex_state = 1},
  [437] = {.lex_state = 67},
  [438] = {.lex_state = 67},
  [439] = {.lex_state = 65},
  [440] = {.lex_state = 67},
  [441] = {.lex_state = 67},
  [442] = {.lex_state = 3},
  [443] = {.lex_state = 1},
  [444] = {.lex_state = 65},
  [445] = {.lex_state = 65},
  [446] = {.lex_state = 1},
  [447] = {.lex_state = 67},
  [448] = {.lex_state = 65},
  [449] = {.lex_state = 67},
  [450] = {.lex_state = 65},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 1},
  [454] = {.lex_state = 66},
  [455] = {.lex_state = 1},
  [456] = {.lex_state = 65},
  [457] = {.lex_state = 1},
  [458] = {.lex_state = 65},
  [459] = {.lex_state = 65},
  [460] = {.lex_state = 65},
  [461] = {.lex_state = 65},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 65},
  [464] = {.lex_state = 65},
  [465] = {.lex_state = 65},
  [466] = {.lex_state = 67},
  [467] = {.lex_state = 67},
  [468] = {.lex_state = 67},
  [469] = {.lex_state = 68},
  [470] = {.lex_state = 66},
  [471] = {.lex_state = 65},
  [472] = {.lex_state = 65},
  [473] = {.lex_state = 1},
  [474] = {.lex_state = 1},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 1},
  [477] = {.lex_state = 1},
  [478] = {.lex_state = 66},
  [479] = {.lex_state = 66},
  [480] = {.lex_state = 66},
  [481] = {.lex_state = 66},
  [482] = {.lex_state = 66},
  [483] = {.lex_state = 68},
  [484] = {.lex_state = 1},
  [485] = {.lex_state = 1},
  [486] = {.lex_state = 66},
  [487] = {.lex_state = 68},
  [488] = {.lex_state = 66},
  [489] = {.lex_state = 66},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 66},
  [492] = {.lex_state = 68},
  [493] = {.lex_state = 1},
  [494] = {.lex_state = 1},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 66},
  [497] = {.lex_state = 66},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 66},
  [500] = {.lex_state = 66},
  [501] = {.lex_state = 66},
  [502] = {.lex_state = 65},
  [503] = {.lex_state = 1},
  [504] = {.lex_state = 68},
  [505] = {.lex_state = 1},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 10},
  [508] = {.lex_state = 10},
  [509] = {.lex_state = 10},
  [510] = {.lex_state = 10},
  [511] = {.lex_state = 1},
  [512] = {.lex_state = 1},
  [513] = {.lex_state = 10},
  [514] = {.lex_state = 10},
  [515] = {.lex_state = 1},
  [516] = {.lex_state = 1},
  [517] = {.lex_state = 10},
  [518] = {.lex_state = 10},
  [519] = {.lex_state = 68},
  [520] = {.lex_state = 1},
  [521] = {.lex_state = 1},
  [522] = {.lex_state = 10},
  [523] = {.lex_state = 1},
  [524] = {.lex_state = 10},
  [525] = {.lex_state = 4},
  [526] = {.lex_state = 10},
  [527] = {.lex_state = 68},
  [528] = {.lex_state = 10},
  [529] = {.lex_state = 1},
  [530] = {.lex_state = 10},
  [531] = {.lex_state = 1},
  [532] = {.lex_state = 68},
  [533] = {.lex_state = 68},
  [534] = {.lex_state = 68},
  [535] = {.lex_state = 65},
  [536] = {.lex_state = 68},
  [537] = {.lex_state = 68},
  [538] = {.lex_state = 68},
  [539] = {.lex_state = 68},
  [540] = {.lex_state = 1},
  [541] = {.lex_state = 1},
  [542] = {.lex_state = 1},
  [543] = {.lex_state = 68},
  [544] = {.lex_state = 68},
  [545] = {.lex_state = 4},
  [546] = {.lex_state = 1},
  [547] = {.lex_state = 1},
  [548] = {.lex_state = 68},
  [549] = {.lex_state = 68},
  [550] = {.lex_state = 1},
  [551] = {.lex_state = 1},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 4},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 1},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 1},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 4},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 1},
  [571] = {.lex_state = 1},
  [572] = {.lex_state = 65},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 1},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 1},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 1},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 1},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 211},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 1},
  [611] = {.lex_state = 1},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 1},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 1},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 1},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 4},
  [674] = {.lex_state = 1},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 1},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 1},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 1},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 1},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 211},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 1},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 1},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 1},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 211},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 211},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 211},
  [734] = {.lex_state = 1},
  [735] = {.lex_state = 211},
  [736] = {.lex_state = 1},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 11},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 1},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 1},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 1},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 1},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_ADD] = ACTIONS(1),
    [sym_AND] = ACTIONS(1),
    [sym_EQ] = ACTIONS(1),
    [sym_AT] = ACTIONS(1),
    [sym_BNOT] = ACTIONS(1),
    [sym_COLON] = ACTIONS(1),
    [sym_COMMA] = ACTIONS(1),
    [sym_CONST] = ACTIONS(1),
    [sym_COUNT] = ACTIONS(1),
    [sym_CSP] = ACTIONS(1),
    [sym_CSP_ADD] = ACTIONS(1),
    [sym_CSP_MUL] = ACTIONS(1),
    [sym_CSP_LEQ] = ACTIONS(1),
    [sym_CSP_LT] = ACTIONS(1),
    [sym_CSP_GT] = ACTIONS(1),
    [sym_CSP_GEQ] = ACTIONS(1),
    [sym_CSP_EQ] = ACTIONS(1),
    [sym_CSP_NEQ] = ACTIONS(1),
    [sym_DISJOINT] = ACTIONS(1),
    [sym_DOT] = ACTIONS(1),
    [sym_DOTS] = ACTIONS(1),
    [sym_EXTERNAL] = ACTIONS(1),
    [sym_DEFINED] = ACTIONS(1),
    [sym_FALSE] = ACTIONS(1),
    [sym_GEQ] = ACTIONS(1),
    [sym_GT] = ACTIONS(1),
    [sym_IF] = ACTIONS(1),
    [sym_INCLUDE] = ACTIONS(1),
    [anon_sym_POUNDinf] = ACTIONS(1),
    [anon_sym_POUNDinfimum] = ACTIONS(1),
    [sym_LBRACE] = ACTIONS(1),
    [sym_LBRACK] = ACTIONS(1),
    [sym_LEQ] = ACTIONS(1),
    [sym_LPAREN] = ACTIONS(1),
    [sym_LT] = ACTIONS(1),
    [sym_MAX] = ACTIONS(1),
    [anon_sym_POUNDmaximize] = ACTIONS(1),
    [anon_sym_POUNDmaximise] = ACTIONS(1),
    [sym_MIN] = ACTIONS(1),
    [anon_sym_POUNDminimize] = ACTIONS(1),
    [anon_sym_POUNDminimise] = ACTIONS(1),
    [sym_MOD] = ACTIONS(1),
    [sym_MUL] = ACTIONS(1),
    [sym_NEQ] = ACTIONS(1),
    [sym_POW] = ACTIONS(1),
    [sym_QUESTION] = ACTIONS(1),
    [sym_RBRACE] = ACTIONS(1),
    [sym_RBRACK] = ACTIONS(1),
    [sym_RPAREN] = ACTIONS(1),
    [sym_SEM] = ACTIONS(1),
    [sym_SHOW] = ACTIONS(1),
    [sym_EDGE] = ACTIONS(1),
    [sym_PROJECT] = ACTIONS(1),
    [sym_HEURISTIC] = ACTIONS(1),
    [sym_SLASH] = ACTIONS(1),
    [sym_SUB] = ACTIONS(1),
    [sym_SUM] = ACTIONS(1),
    [sym_SUMP] = ACTIONS(1),
    [anon_sym_POUNDsup] = ACTIONS(1),
    [anon_sym_POUNDsupremum] = ACTIONS(1),
    [sym_TRUE] = ACTIONS(1),
    [sym_BLOCK] = ACTIONS(1),
    [sym_VBAR] = ACTIONS(1),
    [sym_XOR] = ACTIONS(1),
    [sym_ANY] = ACTIONS(1),
    [sym_UNARY] = ACTIONS(1),
    [sym_BINARY] = ACTIONS(1),
    [sym_LEFT] = ACTIONS(1),
    [sym_RIGHT] = ACTIONS(1),
    [sym_HEAD] = ACTIONS(1),
    [sym_BODY] = ACTIONS(1),
    [sym_DIRECTIVE] = ACTIONS(1),
    [sym_THEORY] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [aux_sym_dec_token1] = ACTIONS(1),
    [sym_hex] = ACTIONS(1),
    [sym_oct] = ACTIONS(1),
    [sym_bin] = ACTIONS(1),
    [sym_ANONYMOUS] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [sym_SCRIPT] = ACTIONS(1),
    [sym_VARIABLE] = ACTIONS(1),
    [sym_NOT] = ACTIONS(1),
    [sym_DEFAULT] = ACTIONS(1),
    [sym_OVERRIDE] = ACTIONS(1),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(710),
    [sym_INFIMUM] = STATE(44),
    [sym_MAXIMIZE] = STATE(732),
    [sym_MINIMIZE] = STATE(707),
    [sym_SUPREMUM] = STATE(44),
    [sym_NUMBER] = STATE(44),
    [sym_dec] = STATE(37),
    [sym__widentifier] = STATE(145),
    [sym_term] = STATE(80),
    [sym_atom] = STATE(419),
    [sym_literal] = STATE(411),
    [sym_csp_mul_term] = STATE(332),
    [sym_csp_add_term] = STATE(400),
    [sym_csp_literal] = STATE(362),
    [sym_aggregatefunction] = STATE(716),
    [sym_headaggregate] = STATE(75),
    [sym_luheadaggregate] = STATE(678),
    [sym_disjoint] = STATE(627),
    [sym_disjunctionsep] = STATE(84),
    [sym_disjunction] = STATE(678),
    [sym_head] = STATE(627),
    [sym_statement] = STATE(2),
    [sym_theory_atom] = STATE(626),
    [sym_STRING] = STATE(44),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(7),
    [sym_AT] = ACTIONS(9),
    [sym_BNOT] = ACTIONS(11),
    [sym_CONST] = ACTIONS(13),
    [sym_COUNT] = ACTIONS(15),
    [sym_CSP] = ACTIONS(17),
    [sym_DISJOINT] = ACTIONS(19),
    [sym_EXTERNAL] = ACTIONS(21),
    [sym_DEFINED] = ACTIONS(23),
    [sym_FALSE] = ACTIONS(25),
    [sym_IF] = ACTIONS(27),
    [sym_INCLUDE] = ACTIONS(29),
    [anon_sym_POUNDinf] = ACTIONS(31),
    [anon_sym_POUNDinfimum] = ACTIONS(33),
    [sym_LBRACE] = ACTIONS(35),
    [sym_LPAREN] = ACTIONS(37),
    [sym_MAX] = ACTIONS(39),
    [anon_sym_POUNDmaximize] = ACTIONS(41),
    [anon_sym_POUNDmaximise] = ACTIONS(41),
    [sym_MIN] = ACTIONS(39),
    [anon_sym_POUNDminimize] = ACTIONS(43),
    [anon_sym_POUNDminimise] = ACTIONS(43),
    [sym_SHOW] = ACTIONS(45),
    [sym_EDGE] = ACTIONS(47),
    [sym_PROJECT] = ACTIONS(49),
    [sym_HEURISTIC] = ACTIONS(51),
    [sym_SUB] = ACTIONS(53),
    [sym_SUM] = ACTIONS(39),
    [sym_SUMP] = ACTIONS(15),
    [anon_sym_POUNDsup] = ACTIONS(55),
    [anon_sym_POUNDsupremum] = ACTIONS(57),
    [sym_TRUE] = ACTIONS(25),
    [sym_BLOCK] = ACTIONS(59),
    [sym_VBAR] = ACTIONS(61),
    [sym_WIF] = ACTIONS(63),
    [sym_THEORY] = ACTIONS(65),
    [anon_sym_0] = ACTIONS(67),
    [aux_sym_dec_token1] = ACTIONS(69),
    [sym_hex] = ACTIONS(71),
    [sym_oct] = ACTIONS(71),
    [sym_bin] = ACTIONS(71),
    [sym_ANONYMOUS] = ACTIONS(73),
    [sym_identifier] = ACTIONS(75),
    [sym_SCRIPT] = ACTIONS(77),
    [sym_VARIABLE] = ACTIONS(79),
    [sym_NOT] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
  },
  [2] = {
    [sym_INFIMUM] = STATE(44),
    [sym_MAXIMIZE] = STATE(732),
    [sym_MINIMIZE] = STATE(707),
    [sym_SUPREMUM] = STATE(44),
    [sym_NUMBER] = STATE(44),
    [sym_dec] = STATE(37),
    [sym__widentifier] = STATE(145),
    [sym_term] = STATE(80),
    [sym_atom] = STATE(419),
    [sym_literal] = STATE(411),
    [sym_csp_mul_term] = STATE(332),
    [sym_csp_add_term] = STATE(400),
    [sym_csp_literal] = STATE(362),
    [sym_aggregatefunction] = STATE(716),
    [sym_headaggregate] = STATE(75),
    [sym_luheadaggregate] = STATE(678),
    [sym_disjoint] = STATE(627),
    [sym_disjunctionsep] = STATE(84),
    [sym_disjunction] = STATE(678),
    [sym_head] = STATE(627),
    [sym_statement] = STATE(3),
    [sym_theory_atom] = STATE(626),
    [sym_STRING] = STATE(44),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(85),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(7),
    [sym_AT] = ACTIONS(9),
    [sym_BNOT] = ACTIONS(11),
    [sym_CONST] = ACTIONS(13),
    [sym_COUNT] = ACTIONS(15),
    [sym_CSP] = ACTIONS(17),
    [sym_DISJOINT] = ACTIONS(19),
    [sym_EXTERNAL] = ACTIONS(21),
    [sym_DEFINED] = ACTIONS(23),
    [sym_FALSE] = ACTIONS(25),
    [sym_IF] = ACTIONS(27),
    [sym_INCLUDE] = ACTIONS(29),
    [anon_sym_POUNDinf] = ACTIONS(31),
    [anon_sym_POUNDinfimum] = ACTIONS(33),
    [sym_LBRACE] = ACTIONS(35),
    [sym_LPAREN] = ACTIONS(37),
    [sym_MAX] = ACTIONS(39),
    [anon_sym_POUNDmaximize] = ACTIONS(41),
    [anon_sym_POUNDmaximise] = ACTIONS(41),
    [sym_MIN] = ACTIONS(39),
    [anon_sym_POUNDminimize] = ACTIONS(43),
    [anon_sym_POUNDminimise] = ACTIONS(43),
    [sym_SHOW] = ACTIONS(45),
    [sym_EDGE] = ACTIONS(47),
    [sym_PROJECT] = ACTIONS(49),
    [sym_HEURISTIC] = ACTIONS(51),
    [sym_SUB] = ACTIONS(53),
    [sym_SUM] = ACTIONS(39),
    [sym_SUMP] = ACTIONS(15),
    [anon_sym_POUNDsup] = ACTIONS(55),
    [anon_sym_POUNDsupremum] = ACTIONS(57),
    [sym_TRUE] = ACTIONS(25),
    [sym_BLOCK] = ACTIONS(59),
    [sym_VBAR] = ACTIONS(61),
    [sym_WIF] = ACTIONS(63),
    [sym_THEORY] = ACTIONS(65),
    [anon_sym_0] = ACTIONS(67),
    [aux_sym_dec_token1] = ACTIONS(69),
    [sym_hex] = ACTIONS(71),
    [sym_oct] = ACTIONS(71),
    [sym_bin] = ACTIONS(71),
    [sym_ANONYMOUS] = ACTIONS(73),
    [sym_identifier] = ACTIONS(75),
    [sym_SCRIPT] = ACTIONS(77),
    [sym_VARIABLE] = ACTIONS(79),
    [sym_NOT] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
  },
  [3] = {
    [sym_INFIMUM] = STATE(44),
    [sym_MAXIMIZE] = STATE(732),
    [sym_MINIMIZE] = STATE(707),
    [sym_SUPREMUM] = STATE(44),
    [sym_NUMBER] = STATE(44),
    [sym_dec] = STATE(37),
    [sym__widentifier] = STATE(145),
    [sym_term] = STATE(80),
    [sym_atom] = STATE(419),
    [sym_literal] = STATE(411),
    [sym_csp_mul_term] = STATE(332),
    [sym_csp_add_term] = STATE(400),
    [sym_csp_literal] = STATE(362),
    [sym_aggregatefunction] = STATE(716),
    [sym_headaggregate] = STATE(75),
    [sym_luheadaggregate] = STATE(678),
    [sym_disjoint] = STATE(627),
    [sym_disjunctionsep] = STATE(84),
    [sym_disjunction] = STATE(678),
    [sym_head] = STATE(627),
    [sym_statement] = STATE(3),
    [sym_theory_atom] = STATE(626),
    [sym_STRING] = STATE(44),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(89),
    [sym_AT] = ACTIONS(92),
    [sym_BNOT] = ACTIONS(95),
    [sym_CONST] = ACTIONS(98),
    [sym_COUNT] = ACTIONS(101),
    [sym_CSP] = ACTIONS(104),
    [sym_DISJOINT] = ACTIONS(107),
    [sym_EXTERNAL] = ACTIONS(110),
    [sym_DEFINED] = ACTIONS(113),
    [sym_FALSE] = ACTIONS(116),
    [sym_IF] = ACTIONS(119),
    [sym_INCLUDE] = ACTIONS(122),
    [anon_sym_POUNDinf] = ACTIONS(125),
    [anon_sym_POUNDinfimum] = ACTIONS(128),
    [sym_LBRACE] = ACTIONS(131),
    [sym_LPAREN] = ACTIONS(134),
    [sym_MAX] = ACTIONS(137),
    [anon_sym_POUNDmaximize] = ACTIONS(140),
    [anon_sym_POUNDmaximise] = ACTIONS(140),
    [sym_MIN] = ACTIONS(137),
    [anon_sym_POUNDminimize] = ACTIONS(143),
    [anon_sym_POUNDminimise] = ACTIONS(143),
    [sym_SHOW] = ACTIONS(146),
    [sym_EDGE] = ACTIONS(149),
    [sym_PROJECT] = ACTIONS(152),
    [sym_HEURISTIC] = ACTIONS(155),
    [sym_SUB] = ACTIONS(158),
    [sym_SUM] = ACTIONS(137),
    [sym_SUMP] = ACTIONS(101),
    [anon_sym_POUNDsup] = ACTIONS(161),
    [anon_sym_POUNDsupremum] = ACTIONS(164),
    [sym_TRUE] = ACTIONS(116),
    [sym_BLOCK] = ACTIONS(167),
    [sym_VBAR] = ACTIONS(170),
    [sym_WIF] = ACTIONS(173),
    [sym_THEORY] = ACTIONS(176),
    [anon_sym_0] = ACTIONS(179),
    [aux_sym_dec_token1] = ACTIONS(182),
    [sym_hex] = ACTIONS(185),
    [sym_oct] = ACTIONS(185),
    [sym_bin] = ACTIONS(185),
    [sym_ANONYMOUS] = ACTIONS(188),
    [sym_identifier] = ACTIONS(191),
    [sym_SCRIPT] = ACTIONS(194),
    [sym_VARIABLE] = ACTIONS(197),
    [sym_NOT] = ACTIONS(200),
    [anon_sym_DQUOTE] = ACTIONS(203),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 42,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(206), 1,
      sym_AND,
    ACTIONS(208), 1,
      sym_DOT,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(218), 1,
      sym_NOT,
    STATE(27), 1,
      sym_nbodycomma,
    STATE(30), 1,
      sym_bodydot,
    STATE(37), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(79), 1,
      sym_term,
    STATE(136), 1,
      sym__widentifier,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(540), 1,
      sym_literal,
    STATE(557), 1,
      sym_lubodyaggregate,
    STATE(569), 1,
      sym_theory_atom,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(612), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [137] = 42,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(206), 1,
      sym_AND,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(218), 1,
      sym_NOT,
    ACTIONS(220), 1,
      sym_DOT,
    STATE(15), 1,
      sym_bodydot,
    STATE(27), 1,
      sym_nbodycomma,
    STATE(37), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(79), 1,
      sym_term,
    STATE(136), 1,
      sym__widentifier,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(540), 1,
      sym_literal,
    STATE(557), 1,
      sym_lubodyaggregate,
    STATE(569), 1,
      sym_theory_atom,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(612), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [274] = 42,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(206), 1,
      sym_AND,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(218), 1,
      sym_NOT,
    ACTIONS(222), 1,
      sym_DOT,
    STATE(27), 1,
      sym_nbodycomma,
    STATE(28), 1,
      sym_bodydot,
    STATE(37), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(79), 1,
      sym_term,
    STATE(136), 1,
      sym__widentifier,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(540), 1,
      sym_literal,
    STATE(557), 1,
      sym_lubodyaggregate,
    STATE(569), 1,
      sym_theory_atom,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(612), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [411] = 42,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(206), 1,
      sym_AND,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(218), 1,
      sym_NOT,
    ACTIONS(224), 1,
      sym_DOT,
    STATE(13), 1,
      sym_bodydot,
    STATE(27), 1,
      sym_nbodycomma,
    STATE(37), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(79), 1,
      sym_term,
    STATE(136), 1,
      sym__widentifier,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(540), 1,
      sym_literal,
    STATE(557), 1,
      sym_lubodyaggregate,
    STATE(569), 1,
      sym_theory_atom,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(612), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [548] = 41,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(206), 1,
      sym_AND,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(218), 1,
      sym_NOT,
    STATE(25), 1,
      sym_bodydot,
    STATE(27), 1,
      sym_nbodycomma,
    STATE(37), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(79), 1,
      sym_term,
    STATE(136), 1,
      sym__widentifier,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(540), 1,
      sym_literal,
    STATE(557), 1,
      sym_lubodyaggregate,
    STATE(569), 1,
      sym_theory_atom,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(612), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [682] = 41,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(206), 1,
      sym_AND,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(218), 1,
      sym_NOT,
    STATE(20), 1,
      sym_bodydot,
    STATE(27), 1,
      sym_nbodycomma,
    STATE(37), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(79), 1,
      sym_term,
    STATE(136), 1,
      sym__widentifier,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(540), 1,
      sym_literal,
    STATE(557), 1,
      sym_lubodyaggregate,
    STATE(569), 1,
      sym_theory_atom,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(612), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [816] = 41,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(206), 1,
      sym_AND,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(218), 1,
      sym_NOT,
    STATE(27), 1,
      sym_nbodycomma,
    STATE(37), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(79), 1,
      sym_term,
    STATE(136), 1,
      sym__widentifier,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(540), 1,
      sym_literal,
    STATE(557), 1,
      sym_lubodyaggregate,
    STATE(569), 1,
      sym_theory_atom,
    STATE(717), 1,
      sym_aggregatefunction,
    STATE(746), 1,
      sym_bodydot,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(612), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(226), 40,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1007] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(232), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(230), 40,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1064] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(234), 40,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1121] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(240), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(238), 40,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1178] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(246), 1,
      sym_LBRACK,
    ACTIONS(244), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(242), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1237] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 1,
      sym_LBRACK,
    ACTIONS(250), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(248), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1296] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(254), 40,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1353] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(262), 1,
      sym_LBRACK,
    ACTIONS(260), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(258), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(266), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(264), 40,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1469] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(250), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(248), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1525] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(250), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(248), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1581] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(268), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1637] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(274), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(272), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1693] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(278), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(276), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1749] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(242), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1805] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(278), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(276), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1861] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(206), 1,
      sym_AND,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(280), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(79), 1,
      sym_term,
    STATE(136), 1,
      sym__widentifier,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(521), 1,
      sym_literal,
    STATE(569), 1,
      sym_theory_atom,
    STATE(576), 1,
      sym_lubodyaggregate,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(661), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [1989] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(282), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [2045] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(286), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [2101] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 9,
      anon_sym_POUNDinf,
      sym_MAX,
      sym_MIN,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(258), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      anon_sym_POUNDmaximize,
      anon_sym_POUNDmaximise,
      anon_sym_POUNDminimize,
      anon_sym_POUNDminimise,
      sym_SHOW,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [2157] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 9,
      sym_EQ,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(290), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_IF,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2210] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(298), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(296), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2260] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(300), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2310] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(306), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(304), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2360] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(310), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(308), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(314), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(312), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2462] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(318), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(316), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2512] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(322), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(320), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2562] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(326), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(324), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2611] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(330), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(328), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2660] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(206), 1,
      sym_AND,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(332), 1,
      sym_DISJOINT,
    ACTIONS(336), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(136), 1,
      sym__widentifier,
    STATE(177), 1,
      sym_term,
    STATE(477), 1,
      sym_atom,
    STATE(569), 1,
      sym_theory_atom,
    STATE(576), 1,
      sym_lubodyaggregate,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(334), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [2769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(308), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2818] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(326), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(324), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(290), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2916] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(206), 1,
      sym_AND,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(332), 1,
      sym_DISJOINT,
    ACTIONS(338), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(136), 1,
      sym__widentifier,
    STATE(177), 1,
      sym_term,
    STATE(477), 1,
      sym_atom,
    STATE(555), 1,
      sym_lubodyaggregate,
    STATE(569), 1,
      sym_theory_atom,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(334), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [3025] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(310), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_SUM,
    ACTIONS(308), 23,
      sym_AT,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SUMP,
      sym_VBAR,
      anon_sym_EQ_EQ,
  [3089] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(358), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(292), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(290), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3143] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(326), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(324), 26,
      sym_AT,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3201] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(326), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(324), 29,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3255] = 32,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(206), 1,
      sym_AND,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(360), 1,
      sym_DISJOINT,
    ACTIONS(364), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(136), 1,
      sym__widentifier,
    STATE(178), 1,
      sym_term,
    STATE(485), 1,
      sym_atom,
    STATE(555), 1,
      sym_lubodyaggregate,
    STATE(569), 1,
      sym_theory_atom,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(362), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [3361] = 32,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(206), 1,
      sym_AND,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(360), 1,
      sym_DISJOINT,
    ACTIONS(364), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(136), 1,
      sym__widentifier,
    STATE(178), 1,
      sym_term,
    STATE(485), 1,
      sym_atom,
    STATE(569), 1,
      sym_theory_atom,
    STATE(575), 1,
      sym_lubodyaggregate,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(362), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [3467] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(326), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(324), 31,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3517] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(326), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(324), 30,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3569] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(326), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(324), 28,
      sym_ADD,
      sym_AT,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3625] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(326), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_SUM,
    ACTIONS(324), 23,
      sym_AT,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SUMP,
      sym_VBAR,
      anon_sym_EQ_EQ,
  [3689] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(368), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(292), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(290), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3743] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(372), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(326), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(324), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3794] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(376), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(326), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(324), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3845] = 32,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(380), 1,
      sym_SEM,
    ACTIONS(382), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(164), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(362), 1,
      sym_csp_literal,
    STATE(400), 1,
      sym_csp_add_term,
    STATE(419), 1,
      sym_atom,
    STATE(451), 1,
      sym_nlitvec,
    STATE(452), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(378), 2,
      sym_DOT,
      sym_IF,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [3949] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      sym_DOT,
    ACTIONS(358), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(292), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(290), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [4001] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      sym_DOT,
    ACTIONS(368), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(292), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(290), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [4053] = 32,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(382), 1,
      sym_NOT,
    ACTIONS(386), 1,
      sym_SEM,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(164), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(362), 1,
      sym_csp_literal,
    STATE(400), 1,
      sym_csp_add_term,
    STATE(419), 1,
      sym_atom,
    STATE(452), 1,
      sym_literal,
    STATE(462), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(384), 2,
      sym_DOT,
      sym_IF,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [4157] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      sym_DOT,
    ACTIONS(376), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(326), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(324), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [4206] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(388), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(170), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(382), 1,
      sym_csp_literal,
    STATE(399), 1,
      sym_csp_add_term,
    STATE(419), 1,
      sym_atom,
    STATE(452), 1,
      sym_literal,
    STATE(552), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(384), 2,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [4307] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(388), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(170), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(382), 1,
      sym_csp_literal,
    STATE(399), 1,
      sym_csp_add_term,
    STATE(419), 1,
      sym_atom,
    STATE(452), 1,
      sym_literal,
    STATE(579), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(390), 2,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [4408] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(394), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(136), 1,
      sym__widentifier,
    STATE(172), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(511), 1,
      sym_literal,
    STATE(606), 1,
      sym_altbodyaggrelem,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(392), 2,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [4509] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 1,
      sym_DOT,
    ACTIONS(372), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(326), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(324), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [4558] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(221), 1,
      sym_cmp,
    STATE(361), 1,
      sym_term,
    STATE(554), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(398), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [4647] = 32,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(394), 1,
      sym_NOT,
    ACTIONS(404), 1,
      sym_RBRACE,
    STATE(37), 1,
      sym_dec,
    STATE(136), 1,
      sym__widentifier,
    STATE(172), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(511), 1,
      sym_literal,
    STATE(639), 1,
      sym_altbodyaggrelem,
    STATE(645), 1,
      sym_altbodyaggrelemvec,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [4750] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(388), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(170), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(382), 1,
      sym_csp_literal,
    STATE(399), 1,
      sym_csp_add_term,
    STATE(419), 1,
      sym_atom,
    STATE(452), 1,
      sym_literal,
    STATE(553), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(406), 2,
      sym_DOT,
      sym_SEM,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [4851] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(388), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(170), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(382), 1,
      sym_csp_literal,
    STATE(399), 1,
      sym_csp_add_term,
    STATE(419), 1,
      sym_atom,
    STATE(581), 1,
      sym_optimizelitvec,
    STATE(582), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(408), 2,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [4952] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(221), 1,
      sym_cmp,
    STATE(361), 1,
      sym_term,
    STATE(567), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(410), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [5041] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(388), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(170), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(382), 1,
      sym_csp_literal,
    STATE(399), 1,
      sym_csp_add_term,
    STATE(419), 1,
      sym_atom,
    STATE(452), 1,
      sym_literal,
    STATE(583), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(412), 2,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [5142] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(221), 1,
      sym_cmp,
    STATE(361), 1,
      sym_term,
    STATE(584), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(414), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [5231] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(252), 1,
      sym_dec,
    STATE(276), 1,
      sym_cmp,
    STATE(377), 1,
      sym_term,
    STATE(667), 1,
      sym_nupper,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(420), 2,
      sym_DOT,
      sym_IF,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [5319] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(252), 1,
      sym_dec,
    STATE(276), 1,
      sym_cmp,
    STATE(377), 1,
      sym_term,
    STATE(628), 1,
      sym_nupper,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(446), 2,
      sym_DOT,
      sym_IF,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [5407] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(394), 1,
      sym_NOT,
    ACTIONS(448), 1,
      sym_RBRACE,
    STATE(37), 1,
      sym_dec,
    STATE(136), 1,
      sym__widentifier,
    STATE(172), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(546), 1,
      sym_literal,
    STATE(651), 1,
      sym_altheadaggrelemvec,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [5507] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(252), 1,
      sym_dec,
    STATE(276), 1,
      sym_cmp,
    STATE(377), 1,
      sym_term,
    STATE(685), 1,
      sym_nupper,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(450), 2,
      sym_DOT,
      sym_IF,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [5595] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(454), 1,
      sym_CSP_MUL,
    STATE(68), 1,
      sym_bodyaggregate,
    STATE(91), 1,
      sym_cmp,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(456), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(452), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [5672] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      sym_LBRACE,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(454), 1,
      sym_CSP_MUL,
    STATE(78), 1,
      sym_headaggregate,
    STATE(90), 1,
      sym_cmp,
    STATE(716), 1,
      sym_aggregatefunction,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(456), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(452), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [5749] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(394), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(136), 1,
      sym__widentifier,
    STATE(172), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(547), 1,
      sym_literal,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [5843] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(382), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(164), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(362), 1,
      sym_csp_literal,
    STATE(400), 1,
      sym_csp_add_term,
    STATE(419), 1,
      sym_atom,
    STATE(425), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [5937] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(394), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(136), 1,
      sym__widentifier,
    STATE(172), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(515), 1,
      sym_literal,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [6031] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(382), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(164), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(362), 1,
      sym_csp_literal,
    STATE(400), 1,
      sym_csp_add_term,
    STATE(405), 1,
      sym_literal,
    STATE(419), 1,
      sym_atom,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [6125] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(394), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(136), 1,
      sym__widentifier,
    STATE(172), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(542), 1,
      sym_literal,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [6219] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(394), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(136), 1,
      sym__widentifier,
    STATE(172), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(516), 1,
      sym_literal,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [6313] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(394), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(136), 1,
      sym__widentifier,
    STATE(172), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_literal,
    STATE(398), 1,
      sym_csp_add_term,
    STATE(494), 1,
      sym_atom,
    STATE(529), 1,
      sym_literal,
    ACTIONS(210), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [6407] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(388), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(170), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(382), 1,
      sym_csp_literal,
    STATE(399), 1,
      sym_csp_add_term,
    STATE(419), 1,
      sym_atom,
    STATE(425), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [6501] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(388), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(170), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(382), 1,
      sym_csp_literal,
    STATE(399), 1,
      sym_csp_add_term,
    STATE(419), 1,
      sym_atom,
    STATE(559), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [6595] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      sym_LBRACE,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(76), 1,
      sym_headaggregate,
    STATE(155), 1,
      sym__widentifier,
    STATE(252), 1,
      sym_dec,
    STATE(329), 1,
      sym_term,
    STATE(716), 1,
      sym_aggregatefunction,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [6680] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(74), 1,
      sym_bodyaggregate,
    STATE(166), 1,
      sym__widentifier,
    STATE(337), 1,
      sym_term,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [6765] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(74), 1,
      sym_bodyaggregate,
    STATE(166), 1,
      sym__widentifier,
    STATE(331), 1,
      sym_term,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [6850] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(74), 1,
      sym_bodyaggregate,
    STATE(166), 1,
      sym__widentifier,
    STATE(335), 1,
      sym_term,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [6935] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(462), 1,
      sym_COMMA,
    ACTIONS(464), 1,
      sym_RPAREN,
    ACTIONS(466), 1,
      sym_SEM,
    STATE(37), 1,
      sym_dec,
    STATE(113), 1,
      sym_tuplevec_sem,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(566), 1,
      sym_ntermvec,
    STATE(638), 1,
      sym_ntuple,
    STATE(709), 1,
      sym_ntuplevec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [7023] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(462), 1,
      sym_COMMA,
    ACTIONS(466), 1,
      sym_SEM,
    ACTIONS(468), 1,
      sym_RPAREN,
    STATE(37), 1,
      sym_dec,
    STATE(113), 1,
      sym_tuplevec_sem,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(566), 1,
      sym_ntermvec,
    STATE(638), 1,
      sym_ntuple,
    STATE(760), 1,
      sym_ntuplevec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [7111] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(470), 1,
      sym_COLON,
    ACTIONS(472), 1,
      anon_sym_POUNDinf,
    ACTIONS(474), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(476), 1,
      sym_LBRACE,
    ACTIONS(478), 1,
      sym_LBRACK,
    ACTIONS(480), 1,
      sym_LPAREN,
    ACTIONS(482), 1,
      sym_RBRACE,
    ACTIONS(484), 1,
      anon_sym_POUNDsup,
    ACTIONS(486), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(488), 1,
      anon_sym_0,
    ACTIONS(490), 1,
      aux_sym_dec_token1,
    ACTIONS(494), 1,
      sym_identifier,
    ACTIONS(496), 1,
      sym_VARIABLE,
    ACTIONS(500), 1,
      anon_sym_DQUOTE,
    STATE(294), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(402), 1,
      sym_theory_opterm,
    STATE(435), 1,
      sym_theory_term,
    STATE(441), 1,
      sym_dec,
    STATE(493), 1,
      sym_theory_opterm_nlist,
    STATE(677), 1,
      sym_theory_atom_element,
    STATE(694), 1,
      sym_theory_atom_element_nlist,
    ACTIONS(498), 2,
      sym_THEORY_OP,
      sym_NOT,
    ACTIONS(492), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(437), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [7196] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(470), 1,
      sym_COLON,
    ACTIONS(472), 1,
      anon_sym_POUNDinf,
    ACTIONS(474), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(476), 1,
      sym_LBRACE,
    ACTIONS(478), 1,
      sym_LBRACK,
    ACTIONS(480), 1,
      sym_LPAREN,
    ACTIONS(484), 1,
      anon_sym_POUNDsup,
    ACTIONS(486), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(488), 1,
      anon_sym_0,
    ACTIONS(490), 1,
      aux_sym_dec_token1,
    ACTIONS(494), 1,
      sym_identifier,
    ACTIONS(496), 1,
      sym_VARIABLE,
    ACTIONS(500), 1,
      anon_sym_DQUOTE,
    ACTIONS(502), 1,
      sym_RBRACE,
    STATE(294), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(402), 1,
      sym_theory_opterm,
    STATE(435), 1,
      sym_theory_term,
    STATE(441), 1,
      sym_dec,
    STATE(493), 1,
      sym_theory_opterm_nlist,
    STATE(676), 1,
      sym_theory_atom_element_nlist,
    STATE(677), 1,
      sym_theory_atom_element,
    ACTIONS(498), 2,
      sym_THEORY_OP,
      sym_NOT,
    ACTIONS(492), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(437), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [7281] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(504), 1,
      sym_COLON,
    ACTIONS(506), 1,
      sym_RBRACE,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(349), 1,
      sym_term,
    STATE(474), 1,
      sym_ntermvec,
    STATE(662), 1,
      sym_bodyaggrelemvec,
    STATE(663), 1,
      sym_bodyaggrelem,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [7363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(510), 7,
      anon_sym_POUNDinf,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(508), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [7401] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(332), 1,
      sym_DISJOINT,
    ACTIONS(514), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(321), 1,
      sym_term,
    STATE(406), 1,
      sym_atom,
    ACTIONS(512), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [7483] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 7,
      anon_sym_POUNDinf,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(516), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [7521] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(522), 7,
      anon_sym_POUNDinf,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(520), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [7559] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 7,
      anon_sym_POUNDinf,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(524), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [7597] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(528), 1,
      sym_COLON,
    ACTIONS(530), 1,
      sym_RBRACE,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(349), 1,
      sym_term,
    STATE(634), 1,
      sym_ncspelemvec,
    STATE(679), 1,
      sym_ntermvec,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [7676] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(360), 1,
      sym_DISJOINT,
    ACTIONS(534), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(323), 1,
      sym_term,
    STATE(412), 1,
      sym_atom,
    ACTIONS(532), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [7755] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(536), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(321), 1,
      sym_term,
    STATE(406), 1,
      sym_atom,
    ACTIONS(512), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [7834] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(322), 1,
      sym_term,
    STATE(406), 1,
      sym_atom,
    ACTIONS(512), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [7913] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(540), 1,
      sym_COLON,
    ACTIONS(542), 1,
      sym_RBRACE,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(349), 1,
      sym_term,
    STATE(682), 1,
      sym_headaggrelemvec,
    STATE(683), 1,
      sym_ntermvec,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [7992] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(470), 1,
      sym_COLON,
    ACTIONS(472), 1,
      anon_sym_POUNDinf,
    ACTIONS(474), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(476), 1,
      sym_LBRACE,
    ACTIONS(478), 1,
      sym_LBRACK,
    ACTIONS(480), 1,
      sym_LPAREN,
    ACTIONS(484), 1,
      anon_sym_POUNDsup,
    ACTIONS(486), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(488), 1,
      anon_sym_0,
    ACTIONS(490), 1,
      aux_sym_dec_token1,
    ACTIONS(494), 1,
      sym_identifier,
    ACTIONS(496), 1,
      sym_VARIABLE,
    ACTIONS(500), 1,
      anon_sym_DQUOTE,
    STATE(294), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(402), 1,
      sym_theory_opterm,
    STATE(435), 1,
      sym_theory_term,
    STATE(441), 1,
      sym_dec,
    STATE(493), 1,
      sym_theory_opterm_nlist,
    STATE(589), 1,
      sym_theory_atom_element,
    ACTIONS(498), 2,
      sym_THEORY_OP,
      sym_NOT,
    ACTIONS(492), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(437), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [8071] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(528), 1,
      sym_COLON,
    ACTIONS(544), 1,
      sym_RBRACE,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(349), 1,
      sym_term,
    STATE(597), 1,
      sym_ncspelemvec,
    STATE(679), 1,
      sym_ntermvec,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [8150] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(528), 1,
      sym_COLON,
    ACTIONS(546), 1,
      sym_RBRACE,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(349), 1,
      sym_term,
    STATE(630), 1,
      sym_ncspelemvec,
    STATE(679), 1,
      sym_ntermvec,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [8229] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(548), 1,
      sym_NOT,
    STATE(37), 1,
      sym_dec,
    STATE(136), 1,
      sym__widentifier,
    STATE(324), 1,
      sym_term,
    STATE(477), 1,
      sym_atom,
    ACTIONS(334), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [8308] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(462), 1,
      sym_COMMA,
    ACTIONS(550), 1,
      sym_SEM,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(566), 1,
      sym_ntermvec,
    STATE(690), 1,
      sym_ntuple,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [8387] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(562), 1,
      sym_RPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(591), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [8465] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(582), 1,
      sym_RBRACE,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(624), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [8543] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(584), 1,
      sym_RPAREN,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(573), 1,
      sym_ntermvec,
    STATE(697), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [8619] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(586), 1,
      sym_CSP,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(288), 1,
      sym_term,
    STATE(353), 1,
      sym_csp_mul_term,
    STATE(446), 1,
      sym_csp_add_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [8695] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(588), 1,
      sym_RPAREN,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(602), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [8773] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(214), 1,
      sym_SUB,
    ACTIONS(364), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(136), 1,
      sym__widentifier,
    STATE(325), 1,
      sym_term,
    STATE(485), 1,
      sym_atom,
    ACTIONS(362), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [8849] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(590), 1,
      sym_RPAREN,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(573), 1,
      sym_ntermvec,
    STATE(596), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [8925] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(592), 1,
      sym_RPAREN,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(609), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [9003] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym_RBRACK,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(615), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [9081] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym_RBRACE,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(618), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [9159] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(596), 1,
      sym_RPAREN,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(632), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [9237] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(598), 1,
      sym_RPAREN,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(636), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [9315] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(600), 1,
      sym_RBRACE,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(334), 1,
      sym_term,
    STATE(455), 1,
      sym_optimizeweight,
    STATE(689), 1,
      sym_maxelemlist,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [9391] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(600), 1,
      sym_RBRACE,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(334), 1,
      sym_term,
    STATE(453), 1,
      sym_optimizeweight,
    STATE(688), 1,
      sym_minelemlist,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [9467] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(586), 1,
      sym_CSP,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(288), 1,
      sym_term,
    STATE(353), 1,
      sym_csp_mul_term,
    STATE(473), 1,
      sym_csp_add_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [9543] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(602), 1,
      sym_RBRACK,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(647), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [9621] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(602), 1,
      sym_RBRACE,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(650), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [9699] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(604), 1,
      sym_RPAREN,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(573), 1,
      sym_ntermvec,
    STATE(672), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [9775] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(534), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(320), 1,
      sym_term,
    STATE(412), 1,
      sym_atom,
    ACTIONS(532), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [9851] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(606), 1,
      sym_RPAREN,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(657), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [9929] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(608), 7,
      sym_EQ,
      sym_GT,
      anon_sym_POUNDinf,
      sym_LT,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(610), 21,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      anon_sym_POUNDinfimum,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [9965] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(302), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(376), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [10041] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(590), 1,
      sym_RPAREN,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(573), 1,
      sym_ntermvec,
    STATE(699), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [10117] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(612), 1,
      sym_RPAREN,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(669), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [10195] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(614), 1,
      sym_RPAREN,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(573), 1,
      sym_ntermvec,
    STATE(701), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [10271] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(616), 1,
      sym_RPAREN,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(671), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [10349] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(614), 1,
      sym_RPAREN,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(573), 1,
      sym_ntermvec,
    STATE(670), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [10425] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    ACTIONS(618), 1,
      sym_CSP,
    STATE(155), 1,
      sym__widentifier,
    STATE(252), 1,
      sym_dec,
    STATE(274), 1,
      sym_term,
    STATE(332), 1,
      sym_csp_mul_term,
    STATE(344), 1,
      sym_csp_add_term,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [10501] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(504), 1,
      sym_COLON,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(349), 1,
      sym_term,
    STATE(474), 1,
      sym_ntermvec,
    STATE(641), 1,
      sym_bodyaggrelem,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [10577] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(586), 1,
      sym_CSP,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(288), 1,
      sym_term,
    STATE(353), 1,
      sym_csp_mul_term,
    STATE(365), 1,
      sym_csp_add_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [10653] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(620), 7,
      sym_EQ,
      sym_GT,
      anon_sym_POUNDinf,
      sym_LT,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(622), 21,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      anon_sym_POUNDinfimum,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [10689] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(624), 1,
      sym_RPAREN,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(573), 1,
      sym_ntermvec,
    STATE(586), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [10765] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(626), 1,
      sym_RBRACE,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(693), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [10843] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(628), 7,
      sym_EQ,
      sym_GT,
      anon_sym_POUNDinf,
      sym_LT,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(630), 21,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      anon_sym_POUNDinfimum,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [10879] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(626), 1,
      sym_RBRACK,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(692), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [10957] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(586), 1,
      sym_CSP,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(288), 1,
      sym_term,
    STATE(353), 1,
      sym_csp_mul_term,
    STATE(436), 1,
      sym_csp_add_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [11033] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(586), 1,
      sym_CSP,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(288), 1,
      sym_term,
    STATE(353), 1,
      sym_csp_mul_term,
    STATE(457), 1,
      sym_csp_add_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [11109] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(534), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(145), 1,
      sym__widentifier,
    STATE(323), 1,
      sym_term,
    STATE(412), 1,
      sym_atom,
    ACTIONS(532), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [11185] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(582), 1,
      sym_RBRACK,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(623), 1,
      sym_theory_opterm_nlist,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [11263] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(632), 1,
      sym_COLON,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(349), 1,
      sym_term,
    STATE(592), 1,
      sym_ntermvec,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [11336] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym_RPAREN,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(445), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [11411] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(573), 1,
      sym_ntermvec,
    STATE(703), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [11484] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(573), 1,
      sym_ntermvec,
    STATE(702), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [11557] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(347), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(634), 2,
      sym_RPAREN,
      sym_SEM,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [11628] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(636), 1,
      sym_COLON,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(349), 1,
      sym_term,
    STATE(611), 1,
      sym_ntermvec,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [11701] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 7,
      sym_EQ,
      sym_GT,
      anon_sym_POUNDinf,
      sym_LT,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(640), 20,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      anon_sym_POUNDinfimum,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [11736] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(573), 1,
      sym_ntermvec,
    STATE(587), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [11809] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(626), 1,
      sym_RPAREN,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(472), 1,
      sym_theory_opterm,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [11884] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(302), 1,
      sym_term,
    STATE(336), 1,
      sym_csp_mul_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [11957] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(582), 1,
      sym_RPAREN,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    STATE(471), 1,
      sym_theory_opterm,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [12032] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(454), 1,
      sym_CSP_MUL,
    STATE(225), 1,
      sym_cmp,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(456), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(452), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [12091] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 7,
      sym_EQ,
      sym_GT,
      anon_sym_POUNDinf,
      sym_LT,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(644), 20,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      anon_sym_POUNDinfimum,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [12126] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(573), 1,
      sym_ntermvec,
    STATE(675), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [12199] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    ACTIONS(586), 1,
      sym_CSP,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(288), 1,
      sym_term,
    STATE(355), 1,
      sym_csp_mul_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [12272] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(646), 7,
      sym_EQ,
      sym_GT,
      anon_sym_POUNDinf,
      sym_LT,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(648), 20,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      anon_sym_POUNDinfimum,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [12307] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(602), 1,
      sym_RPAREN,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(456), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [12382] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(454), 1,
      sym_CSP_MUL,
    STATE(266), 1,
      sym_cmp,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(456), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(452), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [12441] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(222), 1,
      sym_DOT,
    ACTIONS(458), 1,
      sym_BNOT,
    ACTIONS(650), 1,
      sym_CSP,
    ACTIONS(652), 1,
      sym_SUB,
    ACTIONS(654), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(370), 1,
      sym_term,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [12516] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(454), 1,
      sym_CSP_MUL,
    STATE(206), 1,
      sym_cmp,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(456), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(452), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [12575] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    ACTIONS(618), 1,
      sym_CSP,
    STATE(155), 1,
      sym__widentifier,
    STATE(252), 1,
      sym_dec,
    STATE(274), 1,
      sym_term,
    STATE(336), 1,
      sym_csp_mul_term,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [12648] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(607), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [12718] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(656), 1,
      anon_sym_POUNDinf,
    ACTIONS(658), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(660), 1,
      sym_LBRACE,
    ACTIONS(662), 1,
      sym_LBRACK,
    ACTIONS(664), 1,
      sym_LPAREN,
    ACTIONS(666), 1,
      anon_sym_POUNDsup,
    ACTIONS(668), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(670), 1,
      anon_sym_0,
    ACTIONS(672), 1,
      aux_sym_dec_token1,
    ACTIONS(676), 1,
      sym_identifier,
    ACTIONS(678), 1,
      sym_VARIABLE,
    ACTIONS(680), 1,
      anon_sym_DQUOTE,
    STATE(291), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(469), 1,
      sym_theory_opterm,
    STATE(527), 1,
      sym_theory_term,
    STATE(548), 1,
      sym_dec,
    ACTIONS(674), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(519), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [12790] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(334), 1,
      sym_term,
    STATE(443), 1,
      sym_optimizeweight,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [12860] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    STATE(68), 1,
      sym_bodyaggregate,
    STATE(92), 1,
      sym_cmp,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [12922] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_SUM,
    ACTIONS(212), 1,
      sym_LBRACE,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    STATE(68), 1,
      sym_bodyaggregate,
    STATE(93), 1,
      sym_cmp,
    STATE(717), 1,
      sym_aggregatefunction,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [12984] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    STATE(286), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(404), 1,
      sym_theory_opterm,
    STATE(461), 1,
      sym_dec,
    STATE(465), 1,
      sym_theory_term,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [13056] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(334), 1,
      sym_term,
    STATE(424), 1,
      sym_optimizeweight,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [13126] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(574), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [13196] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(682), 1,
      anon_sym_POUNDinf,
    ACTIONS(684), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(686), 1,
      sym_LBRACE,
    ACTIONS(688), 1,
      sym_LBRACK,
    ACTIONS(690), 1,
      sym_LPAREN,
    ACTIONS(692), 1,
      anon_sym_POUNDsup,
    ACTIONS(694), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(696), 1,
      anon_sym_0,
    ACTIONS(698), 1,
      aux_sym_dec_token1,
    ACTIONS(702), 1,
      sym_identifier,
    ACTIONS(704), 1,
      sym_VARIABLE,
    ACTIONS(706), 1,
      anon_sym_DQUOTE,
    STATE(292), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(417), 1,
      sym_theory_opterm,
    STATE(482), 1,
      sym_dec,
    STATE(501), 1,
      sym_theory_term,
    ACTIONS(700), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(479), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [13268] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(682), 1,
      anon_sym_POUNDinf,
    ACTIONS(684), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(686), 1,
      sym_LBRACE,
    ACTIONS(688), 1,
      sym_LBRACK,
    ACTIONS(690), 1,
      sym_LPAREN,
    ACTIONS(692), 1,
      anon_sym_POUNDsup,
    ACTIONS(694), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(696), 1,
      anon_sym_0,
    ACTIONS(698), 1,
      aux_sym_dec_token1,
    ACTIONS(702), 1,
      sym_identifier,
    ACTIONS(704), 1,
      sym_VARIABLE,
    ACTIONS(706), 1,
      anon_sym_DQUOTE,
    STATE(292), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(409), 1,
      sym_theory_opterm,
    STATE(482), 1,
      sym_dec,
    STATE(501), 1,
      sym_theory_term,
    ACTIONS(700), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(479), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [13340] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(379), 1,
      sym_term,
    STATE(614), 1,
      sym_unaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [13410] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      sym_AT,
    ACTIONS(712), 1,
      sym_LPAREN,
    ACTIONS(714), 1,
      sym_RPAREN,
    ACTIONS(716), 1,
      sym_VBAR,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(185), 1,
      sym__widentifier,
    STATE(387), 1,
      sym_constterm,
    STATE(616), 1,
      sym_consttermvec,
    STATE(747), 1,
      sym_nconstargvec,
    ACTIONS(710), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(358), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [13480] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(472), 1,
      anon_sym_POUNDinf,
    ACTIONS(474), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(476), 1,
      sym_LBRACE,
    ACTIONS(478), 1,
      sym_LBRACK,
    ACTIONS(480), 1,
      sym_LPAREN,
    ACTIONS(484), 1,
      anon_sym_POUNDsup,
    ACTIONS(486), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(488), 1,
      anon_sym_0,
    ACTIONS(490), 1,
      aux_sym_dec_token1,
    ACTIONS(494), 1,
      sym_identifier,
    ACTIONS(496), 1,
      sym_VARIABLE,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(500), 1,
      anon_sym_DQUOTE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    STATE(294), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(403), 1,
      sym_theory_opterm,
    STATE(435), 1,
      sym_theory_term,
    STATE(441), 1,
      sym_dec,
    ACTIONS(492), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(437), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [13552] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      sym_AT,
    ACTIONS(712), 1,
      sym_LPAREN,
    ACTIONS(716), 1,
      sym_VBAR,
    ACTIONS(718), 1,
      sym_identifier,
    ACTIONS(720), 1,
      sym_RPAREN,
    STATE(37), 1,
      sym_dec,
    STATE(185), 1,
      sym__widentifier,
    STATE(387), 1,
      sym_constterm,
    STATE(616), 1,
      sym_consttermvec,
    STATE(761), 1,
      sym_nconstargvec,
    ACTIONS(710), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(358), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [13622] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(379), 1,
      sym_term,
    STATE(696), 1,
      sym_unaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [13692] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(367), 1,
      sym_term,
    STATE(562), 1,
      sym_optimizeweight,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [13762] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(349), 1,
      sym_term,
    STATE(505), 1,
      sym_ntermvec,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [13832] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(310), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(308), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [13868] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(386), 1,
      sym_term,
    STATE(695), 1,
      sym_binaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [13938] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(656), 1,
      anon_sym_POUNDinf,
    ACTIONS(658), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(660), 1,
      sym_LBRACE,
    ACTIONS(662), 1,
      sym_LBRACK,
    ACTIONS(664), 1,
      sym_LPAREN,
    ACTIONS(666), 1,
      anon_sym_POUNDsup,
    ACTIONS(668), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(670), 1,
      anon_sym_0,
    ACTIONS(672), 1,
      aux_sym_dec_token1,
    ACTIONS(676), 1,
      sym_identifier,
    ACTIONS(678), 1,
      sym_VARIABLE,
    ACTIONS(680), 1,
      anon_sym_DQUOTE,
    STATE(291), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    STATE(432), 1,
      sym_theory_opterm,
    STATE(527), 1,
      sym_theory_term,
    STATE(548), 1,
      sym_dec,
    ACTIONS(674), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(519), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [14010] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 4,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(290), 21,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [14046] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(326), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(324), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [14079] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(322), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(320), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [14112] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(46), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [14179] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(307), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [14246] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(391), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [14313] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(290), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [14346] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      sym_AND,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(728), 1,
      sym_MUL,
    ACTIONS(730), 1,
      sym_POW,
    ACTIONS(732), 1,
      sym_QUESTION,
    ACTIONS(736), 1,
      sym_XOR,
    ACTIONS(722), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(734), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(310), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(308), 11,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [14395] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(308), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [14428] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(285), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [14495] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(201), 1,
      sym_term,
    STATE(252), 1,
      sym_dec,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [14562] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(738), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(46), 1,
      sym_term,
    STATE(116), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [14629] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(337), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [14696] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(245), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [14763] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(248), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [14830] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(39), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [14897] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(258), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [14964] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(262), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [15031] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(263), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [15098] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(339), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [15165] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      sym_AND,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(732), 1,
      sym_QUESTION,
    ACTIONS(736), 1,
      sym_XOR,
    ACTIONS(326), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(324), 16,
      sym_ADD,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [15206] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(732), 1,
      sym_QUESTION,
    ACTIONS(736), 1,
      sym_XOR,
    ACTIONS(326), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(324), 17,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [15245] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      sym_AND,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(732), 1,
      sym_QUESTION,
    ACTIONS(736), 1,
      sym_XOR,
    ACTIONS(722), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(326), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(324), 14,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [15288] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      sym_AND,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(728), 1,
      sym_MUL,
    ACTIONS(730), 1,
      sym_POW,
    ACTIONS(732), 1,
      sym_QUESTION,
    ACTIONS(736), 1,
      sym_XOR,
    ACTIONS(722), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(734), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(326), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(324), 11,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [15337] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(736), 1,
      sym_XOR,
    ACTIONS(326), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(324), 18,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [15374] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(54), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [15441] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(268), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [15508] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(354), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [15575] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(252), 1,
      sym_dec,
    STATE(283), 1,
      sym_term,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [15642] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(381), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [15709] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(343), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [15776] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(252), 1,
      sym_dec,
    STATE(329), 1,
      sym_term,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [15843] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      sym_AND,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(728), 1,
      sym_MUL,
    ACTIONS(730), 1,
      sym_POW,
    ACTIONS(732), 1,
      sym_QUESTION,
    ACTIONS(736), 1,
      sym_XOR,
    ACTIONS(744), 1,
      sym_CSP_MUL,
    ACTIONS(722), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(734), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(740), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(742), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [15894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(326), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(324), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [15927] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(252), 1,
      sym_dec,
    STATE(328), 1,
      sym_term,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [15994] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(252), 1,
      sym_dec,
    STATE(330), 1,
      sym_term,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [16061] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(752), 1,
      sym_MUL,
    ACTIONS(754), 1,
      sym_POW,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(758), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(310), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(308), 12,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [16110] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(383), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [16177] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(49), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [16244] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(388), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [16311] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(373), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [16378] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(331), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [16445] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(762), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(46), 1,
      sym_term,
    STATE(138), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [16512] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(347), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [16579] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(326), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(324), 19,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [16614] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(226), 1,
      sym_term,
    STATE(252), 1,
      sym_dec,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [16681] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [16748] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(238), 1,
      sym_term,
    STATE(252), 1,
      sym_dec,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [16815] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(341), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [16882] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(218), 1,
      sym_term,
    STATE(252), 1,
      sym_dec,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [16949] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(345), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [17016] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(326), 4,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(324), 17,
      sym_ADD,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      anon_sym_BSLASH_BSLASH,
  [17057] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(230), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [17124] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(300), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [17157] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(326), 4,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(324), 18,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      anon_sym_BSLASH_BSLASH,
  [17196] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(48), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [17263] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(298), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(296), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [17296] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(217), 1,
      sym_term,
    STATE(252), 1,
      sym_dec,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [17363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(318), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(316), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [17396] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(314), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(312), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [17429] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(311), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [17496] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(371), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [17563] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(390), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [17630] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(216), 1,
      sym_term,
    STATE(252), 1,
      sym_dec,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [17697] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(326), 4,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(324), 15,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_SEM,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [17740] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(372), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [17807] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(195), 1,
      sym_term,
    STATE(252), 1,
      sym_dec,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [17874] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(39), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [17941] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(752), 1,
      sym_MUL,
    ACTIONS(754), 1,
      sym_POW,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(758), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(326), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(324), 12,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [17990] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(326), 4,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(324), 19,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      anon_sym_BSLASH_BSLASH,
  [18027] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(764), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(378), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [18094] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(306), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(304), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [18127] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(342), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [18194] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(215), 1,
      sym_term,
    STATE(252), 1,
      sym_dec,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [18261] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(326), 4,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(324), 20,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [18296] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(55), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [18363] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      sym_AT,
    ACTIONS(712), 1,
      sym_LPAREN,
    ACTIONS(714), 1,
      sym_RPAREN,
    ACTIONS(716), 1,
      sym_VBAR,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(185), 1,
      sym__widentifier,
    STATE(387), 1,
      sym_constterm,
    STATE(617), 1,
      sym_consttermvec,
    ACTIONS(710), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(358), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [18430] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(214), 1,
      sym_term,
    STATE(252), 1,
      sym_dec,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [18497] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(764), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(230), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [18564] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(53), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [18631] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      sym_AND,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(728), 1,
      sym_MUL,
    ACTIONS(730), 1,
      sym_POW,
    ACTIONS(732), 1,
      sym_QUESTION,
    ACTIONS(736), 1,
      sym_XOR,
    ACTIONS(766), 1,
      sym_CSP_MUL,
    ACTIONS(722), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(734), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(456), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(452), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [18682] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(52), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [18749] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym_identifier,
    ACTIONS(416), 1,
      sym_AT,
    ACTIONS(422), 1,
      anon_sym_POUNDinf,
    ACTIONS(424), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(426), 1,
      sym_LPAREN,
    ACTIONS(428), 1,
      anon_sym_POUNDsup,
    ACTIONS(430), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(432), 1,
      sym_VBAR,
    ACTIONS(434), 1,
      anon_sym_0,
    ACTIONS(436), 1,
      aux_sym_dec_token1,
    ACTIONS(440), 1,
      sym_ANONYMOUS,
    ACTIONS(442), 1,
      sym_VARIABLE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE,
    STATE(155), 1,
      sym__widentifier,
    STATE(252), 1,
      sym_dec,
    STATE(375), 1,
      sym_term,
    ACTIONS(418), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(438), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(200), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [18816] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(389), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [18883] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(330), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(328), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [18916] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(384), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [18983] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(460), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(335), 1,
      sym_term,
    ACTIONS(458), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [19050] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(37), 1,
      sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(61), 1,
      sym_VBAR,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(73), 1,
      sym_ANONYMOUS,
    ACTIONS(79), 1,
      sym_VARIABLE,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(374), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(44), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [19117] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(682), 1,
      anon_sym_POUNDinf,
    ACTIONS(684), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(686), 1,
      sym_LBRACE,
    ACTIONS(688), 1,
      sym_LBRACK,
    ACTIONS(690), 1,
      sym_LPAREN,
    ACTIONS(692), 1,
      anon_sym_POUNDsup,
    ACTIONS(694), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(696), 1,
      anon_sym_0,
    ACTIONS(698), 1,
      aux_sym_dec_token1,
    ACTIONS(702), 1,
      sym_identifier,
    ACTIONS(704), 1,
      sym_VARIABLE,
    ACTIONS(706), 1,
      anon_sym_DQUOTE,
    STATE(326), 1,
      sym_theory_op,
    STATE(482), 1,
      sym_dec,
    STATE(500), 1,
      sym_theory_term,
    ACTIONS(700), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(479), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [19183] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      sym_AND,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(728), 1,
      sym_MUL,
    ACTIONS(730), 1,
      sym_POW,
    ACTIONS(732), 1,
      sym_QUESTION,
    ACTIONS(736), 1,
      sym_XOR,
    ACTIONS(722), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(734), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(768), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(770), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [19231] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    STATE(326), 1,
      sym_theory_op,
    STATE(448), 1,
      sym_theory_term,
    STATE(461), 1,
      sym_dec,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [19297] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(752), 1,
      sym_MUL,
    ACTIONS(754), 1,
      sym_POW,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(772), 1,
      sym_CSP_MUL,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(758), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(740), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(742), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [19347] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(552), 1,
      anon_sym_POUNDinf,
    ACTIONS(554), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(556), 1,
      sym_LBRACE,
    ACTIONS(558), 1,
      sym_LBRACK,
    ACTIONS(560), 1,
      sym_LPAREN,
    ACTIONS(564), 1,
      anon_sym_POUNDsup,
    ACTIONS(566), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(568), 1,
      anon_sym_0,
    ACTIONS(570), 1,
      aux_sym_dec_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_VARIABLE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    STATE(326), 1,
      sym_theory_op,
    STATE(444), 1,
      sym_theory_term,
    STATE(461), 1,
      sym_dec,
    ACTIONS(572), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(460), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [19413] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      sym_AT,
    ACTIONS(712), 1,
      sym_LPAREN,
    ACTIONS(716), 1,
      sym_VBAR,
    ACTIONS(718), 1,
      sym_identifier,
    ACTIONS(774), 1,
      sym_RPAREN,
    STATE(37), 1,
      sym_dec,
    STATE(185), 1,
      sym__widentifier,
    STATE(385), 1,
      sym_constterm,
    ACTIONS(710), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(358), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [19477] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(752), 1,
      sym_MUL,
    ACTIONS(754), 1,
      sym_POW,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(776), 1,
      sym_CSP_MUL,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(758), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(456), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(452), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [19527] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(656), 1,
      anon_sym_POUNDinf,
    ACTIONS(658), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(660), 1,
      sym_LBRACE,
    ACTIONS(662), 1,
      sym_LBRACK,
    ACTIONS(664), 1,
      sym_LPAREN,
    ACTIONS(666), 1,
      anon_sym_POUNDsup,
    ACTIONS(668), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(670), 1,
      anon_sym_0,
    ACTIONS(672), 1,
      aux_sym_dec_token1,
    ACTIONS(676), 1,
      sym_identifier,
    ACTIONS(678), 1,
      sym_VARIABLE,
    ACTIONS(680), 1,
      anon_sym_DQUOTE,
    STATE(326), 1,
      sym_theory_op,
    STATE(536), 1,
      sym_theory_term,
    STATE(548), 1,
      sym_dec,
    ACTIONS(674), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(519), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [19593] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(472), 1,
      anon_sym_POUNDinf,
    ACTIONS(474), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(476), 1,
      sym_LBRACE,
    ACTIONS(478), 1,
      sym_LBRACK,
    ACTIONS(480), 1,
      sym_LPAREN,
    ACTIONS(484), 1,
      anon_sym_POUNDsup,
    ACTIONS(486), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(488), 1,
      anon_sym_0,
    ACTIONS(490), 1,
      aux_sym_dec_token1,
    ACTIONS(494), 1,
      sym_identifier,
    ACTIONS(496), 1,
      sym_VARIABLE,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(500), 1,
      anon_sym_DQUOTE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    STATE(326), 1,
      sym_theory_op,
    STATE(434), 1,
      sym_theory_term,
    STATE(441), 1,
      sym_dec,
    ACTIONS(492), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(437), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [19659] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(656), 1,
      anon_sym_POUNDinf,
    ACTIONS(658), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(660), 1,
      sym_LBRACE,
    ACTIONS(662), 1,
      sym_LBRACK,
    ACTIONS(664), 1,
      sym_LPAREN,
    ACTIONS(666), 1,
      anon_sym_POUNDsup,
    ACTIONS(668), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(670), 1,
      anon_sym_0,
    ACTIONS(672), 1,
      aux_sym_dec_token1,
    ACTIONS(676), 1,
      sym_identifier,
    ACTIONS(678), 1,
      sym_VARIABLE,
    ACTIONS(680), 1,
      anon_sym_DQUOTE,
    STATE(326), 1,
      sym_theory_op,
    STATE(533), 1,
      sym_theory_term,
    STATE(548), 1,
      sym_dec,
    ACTIONS(674), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(519), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [19725] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    ACTIONS(682), 1,
      anon_sym_POUNDinf,
    ACTIONS(684), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(686), 1,
      sym_LBRACE,
    ACTIONS(688), 1,
      sym_LBRACK,
    ACTIONS(690), 1,
      sym_LPAREN,
    ACTIONS(692), 1,
      anon_sym_POUNDsup,
    ACTIONS(694), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(696), 1,
      anon_sym_0,
    ACTIONS(698), 1,
      aux_sym_dec_token1,
    ACTIONS(702), 1,
      sym_identifier,
    ACTIONS(704), 1,
      sym_VARIABLE,
    ACTIONS(706), 1,
      anon_sym_DQUOTE,
    STATE(326), 1,
      sym_theory_op,
    STATE(482), 1,
      sym_dec,
    STATE(489), 1,
      sym_theory_term,
    ACTIONS(700), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(479), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [19791] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 5,
      anon_sym_POUNDinf,
      sym_SUM,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(778), 19,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      anon_sym_POUNDsupremum,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [19823] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(472), 1,
      anon_sym_POUNDinf,
    ACTIONS(474), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(476), 1,
      sym_LBRACE,
    ACTIONS(478), 1,
      sym_LBRACK,
    ACTIONS(480), 1,
      sym_LPAREN,
    ACTIONS(484), 1,
      anon_sym_POUNDsup,
    ACTIONS(486), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(488), 1,
      anon_sym_0,
    ACTIONS(490), 1,
      aux_sym_dec_token1,
    ACTIONS(494), 1,
      sym_identifier,
    ACTIONS(496), 1,
      sym_VARIABLE,
    ACTIONS(498), 1,
      sym_NOT,
    ACTIONS(500), 1,
      anon_sym_DQUOTE,
    ACTIONS(578), 1,
      sym_THEORY_OP,
    STATE(326), 1,
      sym_theory_op,
    STATE(441), 1,
      sym_dec,
    STATE(466), 1,
      sym_theory_term,
    ACTIONS(492), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(437), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [19889] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      sym_AT,
    ACTIONS(712), 1,
      sym_LPAREN,
    ACTIONS(716), 1,
      sym_VBAR,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(185), 1,
      sym__widentifier,
    STATE(385), 1,
      sym_constterm,
    ACTIONS(710), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(358), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [19950] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      sym_AT,
    ACTIONS(712), 1,
      sym_LPAREN,
    ACTIONS(716), 1,
      sym_VBAR,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(185), 1,
      sym__widentifier,
    STATE(366), 1,
      sym_constterm,
    ACTIONS(710), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(358), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [20011] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      sym_AT,
    ACTIONS(712), 1,
      sym_LPAREN,
    ACTIONS(716), 1,
      sym_VBAR,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(185), 1,
      sym__widentifier,
    STATE(351), 1,
      sym_constterm,
    ACTIONS(710), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(358), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [20072] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      sym_AT,
    ACTIONS(712), 1,
      sym_LPAREN,
    ACTIONS(716), 1,
      sym_VBAR,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(185), 1,
      sym__widentifier,
    STATE(363), 1,
      sym_constterm,
    ACTIONS(710), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(358), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [20133] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      sym_AT,
    ACTIONS(712), 1,
      sym_LPAREN,
    ACTIONS(716), 1,
      sym_VBAR,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(185), 1,
      sym__widentifier,
    STATE(360), 1,
      sym_constterm,
    ACTIONS(710), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(358), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [20194] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      sym_AT,
    ACTIONS(712), 1,
      sym_LPAREN,
    ACTIONS(716), 1,
      sym_VBAR,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(185), 1,
      sym__widentifier,
    STATE(396), 1,
      sym_constterm,
    ACTIONS(710), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(358), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [20255] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      sym_AT,
    ACTIONS(712), 1,
      sym_LPAREN,
    ACTIONS(716), 1,
      sym_VBAR,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(185), 1,
      sym__widentifier,
    STATE(364), 1,
      sym_constterm,
    ACTIONS(710), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(358), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [20316] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(454), 1,
      sym_CSP_MUL,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(456), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(452), 9,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [20365] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(752), 1,
      sym_MUL,
    ACTIONS(754), 1,
      sym_POW,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(758), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(768), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(770), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [20412] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      sym_AT,
    ACTIONS(712), 1,
      sym_LPAREN,
    ACTIONS(716), 1,
      sym_VBAR,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(185), 1,
      sym__widentifier,
    STATE(392), 1,
      sym_constterm,
    ACTIONS(710), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(358), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [20473] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      sym_AT,
    ACTIONS(712), 1,
      sym_LPAREN,
    ACTIONS(716), 1,
      sym_VBAR,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(185), 1,
      sym__widentifier,
    STATE(368), 1,
      sym_constterm,
    ACTIONS(710), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(358), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [20534] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_POUNDinf,
    ACTIONS(33), 1,
      anon_sym_POUNDinfimum,
    ACTIONS(55), 1,
      anon_sym_POUNDsup,
    ACTIONS(57), 1,
      anon_sym_POUNDsupremum,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      sym_AT,
    ACTIONS(712), 1,
      sym_LPAREN,
    ACTIONS(716), 1,
      sym_VBAR,
    ACTIONS(718), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec,
    STATE(185), 1,
      sym__widentifier,
    STATE(369), 1,
      sym_constterm,
    ACTIONS(710), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    STATE(358), 4,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_NUMBER,
      sym_STRING,
  [20595] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(782), 1,
      sym_CSP_MUL,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(740), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(742), 9,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [20644] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 6,
      anon_sym_POUNDinf,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(784), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      anon_sym_POUNDinfimum,
      sym_LPAREN,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [20674] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 6,
      anon_sym_POUNDinf,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(788), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      anon_sym_POUNDinfimum,
      sym_LPAREN,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [20704] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 6,
      anon_sym_POUNDinf,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(792), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      anon_sym_POUNDinfimum,
      sym_LPAREN,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [20734] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(768), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(770), 9,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [20780] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 6,
      anon_sym_POUNDinf,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(796), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      anon_sym_POUNDinfimum,
      sym_LPAREN,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [20810] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 6,
      anon_sym_POUNDinf,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(800), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      anon_sym_POUNDinfimum,
      sym_LPAREN,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [20840] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 4,
      anon_sym_POUNDinf,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(804), 16,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      anon_sym_POUNDinfimum,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [20868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 4,
      anon_sym_POUNDinf,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(808), 16,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      anon_sym_POUNDinfimum,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [20896] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 4,
      anon_sym_POUNDinf,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(812), 16,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      anon_sym_POUNDinfimum,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [20924] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 5,
      anon_sym_POUNDinf,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(816), 14,
      sym_COMMA,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_RBRACE,
      anon_sym_POUNDsupremum,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
  [20951] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 4,
      anon_sym_POUNDinf,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(820), 15,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      anon_sym_POUNDinfimum,
      sym_LPAREN,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [20978] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(826), 4,
      anon_sym_POUNDinf,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(824), 15,
      sym_AT,
      sym_BNOT,
      anon_sym_POUNDinfimum,
      sym_LPAREN,
      sym_RPAREN,
      sym_SUB,
      anon_sym_POUNDsupremum,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [21005] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    STATE(244), 1,
      sym_cmp,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [21049] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    STATE(229), 1,
      sym_cmp,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [21093] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    STATE(213), 1,
      sym_cmp,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [21137] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    STATE(228), 1,
      sym_cmp,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [21181] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    STATE(235), 1,
      sym_cmp,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [21225] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    STATE(280), 1,
      sym_cmp,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(396), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(400), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [21269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(828), 5,
      anon_sym_POUNDinf,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(830), 12,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      anon_sym_POUNDsupremum,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
  [21294] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 5,
      anon_sym_POUNDinf,
      anon_sym_POUNDsup,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(834), 12,
      anon_sym_POUNDinfimum,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      anon_sym_POUNDsupremum,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
  [21319] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      sym_AND,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(728), 1,
      sym_MUL,
    ACTIONS(730), 1,
      sym_POW,
    ACTIONS(732), 1,
      sym_QUESTION,
    ACTIONS(736), 1,
      sym_XOR,
    ACTIONS(722), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(734), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(836), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(838), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [21359] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      sym_AND,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(728), 1,
      sym_MUL,
    ACTIONS(730), 1,
      sym_POW,
    ACTIONS(732), 1,
      sym_QUESTION,
    ACTIONS(736), 1,
      sym_XOR,
    ACTIONS(722), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(734), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(840), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(842), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [21399] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      sym_AND,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(728), 1,
      sym_MUL,
    ACTIONS(730), 1,
      sym_POW,
    ACTIONS(732), 1,
      sym_QUESTION,
    ACTIONS(736), 1,
      sym_XOR,
    ACTIONS(722), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(734), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(844), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(846), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [21439] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(752), 1,
      sym_MUL,
    ACTIONS(754), 1,
      sym_POW,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(844), 1,
      sym_DOT,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(758), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(846), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21478] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(850), 12,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [21501] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(852), 1,
      sym_AND,
    ACTIONS(854), 1,
      sym_RBRACE,
    STATE(738), 1,
      sym_theory_definition_identifier,
    STATE(739), 1,
      sym_theory_definition_nlist,
    STATE(637), 2,
      sym_theory_term_definition,
      sym_theory_atom_definition,
    ACTIONS(856), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [21532] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(752), 1,
      sym_MUL,
    ACTIONS(754), 1,
      sym_POW,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(858), 1,
      sym_AT,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(758), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(860), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21571] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(752), 1,
      sym_MUL,
    ACTIONS(754), 1,
      sym_POW,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(836), 1,
      sym_DOT,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(758), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(838), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21610] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(864), 12,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [21633] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(752), 1,
      sym_MUL,
    ACTIONS(754), 1,
      sym_POW,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(840), 1,
      sym_DOT,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(758), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(842), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21672] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(868), 1,
      sym_MUL,
    ACTIONS(866), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [21696] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(844), 1,
      sym_DOT,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(846), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21734] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(852), 1,
      sym_AND,
    STATE(706), 1,
      sym_theory_definition_nlist,
    STATE(738), 1,
      sym_theory_definition_identifier,
    STATE(637), 2,
      sym_theory_term_definition,
      sym_theory_atom_definition,
    ACTIONS(856), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [21762] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(752), 1,
      sym_MUL,
    ACTIONS(754), 1,
      sym_POW,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(758), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(870), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21798] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(840), 1,
      sym_DOT,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(842), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21836] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(752), 1,
      sym_MUL,
    ACTIONS(754), 1,
      sym_POW,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(758), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(872), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21872] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(878), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(874), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(876), 9,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [21896] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(836), 1,
      sym_DOT,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(838), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21934] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(882), 1,
      sym_MUL,
    ACTIONS(880), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [21958] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(870), 4,
      sym_COMMA,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
  [21994] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(884), 4,
      sym_COMMA,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
  [22030] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(752), 1,
      sym_MUL,
    ACTIONS(754), 1,
      sym_POW,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(758), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(884), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [22066] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 1,
      sym_MUL,
    ACTIONS(880), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [22087] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      sym_MUL,
    ACTIONS(886), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [22108] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(890), 1,
      sym_SLASH,
    ACTIONS(292), 2,
      sym_DOT,
      sym_MUL,
    ACTIONS(290), 9,
      sym_ADD,
      sym_AND,
      sym_COLON,
      sym_DOTS,
      sym_POW,
      sym_QUESTION,
      sym_SUB,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [22133] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(850), 11,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [22154] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(894), 1,
      sym_DOT,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(892), 2,
      sym_COMMA,
      sym_SEM,
  [22191] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(864), 11,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [22212] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(898), 1,
      sym_MUL,
    ACTIONS(896), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [22233] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(900), 1,
      sym_SLASH,
    ACTIONS(292), 2,
      sym_DOT,
      sym_MUL,
    ACTIONS(290), 9,
      sym_ADD,
      sym_AND,
      sym_COLON,
      sym_DOTS,
      sym_POW,
      sym_QUESTION,
      sym_SUB,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [22258] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(868), 1,
      sym_MUL,
    ACTIONS(866), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [22279] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      sym_MUL,
    ACTIONS(886), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [22300] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      sym_MUL,
    ACTIONS(902), 1,
      sym_AND,
    ACTIONS(904), 1,
      sym_QUESTION,
    ACTIONS(906), 1,
      sym_XOR,
    ACTIONS(886), 9,
      sym_ADD,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [22327] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(910), 1,
      sym_DOT,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(908), 2,
      sym_COMMA,
      sym_SEM,
  [22364] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 1,
      sym_COLON,
    STATE(141), 1,
      sym_csp_rel,
    ACTIONS(918), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(916), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
    ACTIONS(914), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [22391] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      sym_MUL,
    ACTIONS(904), 1,
      sym_QUESTION,
    ACTIONS(906), 1,
      sym_XOR,
    ACTIONS(886), 10,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [22416] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      sym_AND,
    ACTIONS(904), 1,
      sym_QUESTION,
    ACTIONS(906), 1,
      sym_XOR,
    ACTIONS(924), 1,
      sym_MUL,
    ACTIONS(926), 1,
      sym_POW,
    ACTIONS(920), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(922), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(880), 4,
      sym_COMMA,
      sym_DOT,
      sym_RPAREN,
      sym_VBAR,
  [22449] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(874), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(928), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(876), 9,
      sym_COLON,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [22472] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      sym_MUL,
    ACTIONS(902), 1,
      sym_AND,
    ACTIONS(904), 1,
      sym_QUESTION,
    ACTIONS(906), 1,
      sym_XOR,
    ACTIONS(920), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(886), 7,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_VBAR,
  [22501] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(930), 1,
      sym_AT,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(860), 2,
      sym_COMMA,
      sym_RBRACK,
  [22538] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      sym_AND,
    ACTIONS(904), 1,
      sym_QUESTION,
    ACTIONS(906), 1,
      sym_XOR,
    ACTIONS(924), 1,
      sym_MUL,
    ACTIONS(926), 1,
      sym_POW,
    ACTIONS(920), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(922), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(886), 4,
      sym_COMMA,
      sym_DOT,
      sym_RPAREN,
      sym_VBAR,
  [22571] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      sym_MUL,
    ACTIONS(906), 1,
      sym_XOR,
    ACTIONS(886), 11,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [22594] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(752), 1,
      sym_MUL,
    ACTIONS(754), 1,
      sym_POW,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(932), 1,
      sym_COLON,
    ACTIONS(934), 1,
      sym_DOT,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(758), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [22630] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(936), 1,
      sym_AT,
    ACTIONS(938), 1,
      sym_COMMA,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [22666] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(940), 2,
      sym_RPAREN,
      sym_SEM,
  [22700] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(942), 2,
      sym_RPAREN,
      sym_SEM,
  [22734] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(872), 2,
      sym_COMMA,
      sym_RBRACK,
  [22768] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      sym_AND,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(728), 1,
      sym_MUL,
    ACTIONS(730), 1,
      sym_POW,
    ACTIONS(732), 1,
      sym_QUESTION,
    ACTIONS(736), 1,
      sym_XOR,
    ACTIONS(892), 1,
      sym_IF,
    ACTIONS(894), 1,
      sym_DOT,
    ACTIONS(722), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(734), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [22804] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(874), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(944), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(876), 8,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [22826] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      sym_AND,
    ACTIONS(726), 1,
      sym_DOTS,
    ACTIONS(728), 1,
      sym_MUL,
    ACTIONS(730), 1,
      sym_POW,
    ACTIONS(732), 1,
      sym_QUESTION,
    ACTIONS(736), 1,
      sym_XOR,
    ACTIONS(908), 1,
      sym_IF,
    ACTIONS(910), 1,
      sym_DOT,
    ACTIONS(722), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(734), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [22862] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      sym_AND,
    ACTIONS(750), 1,
      sym_DOTS,
    ACTIONS(752), 1,
      sym_MUL,
    ACTIONS(754), 1,
      sym_POW,
    ACTIONS(756), 1,
      sym_QUESTION,
    ACTIONS(760), 1,
      sym_XOR,
    ACTIONS(946), 1,
      sym_COLON,
    ACTIONS(948), 1,
      sym_DOT,
    ACTIONS(746), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(758), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [22898] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(950), 2,
      sym_SEM,
      sym_VBAR,
  [22932] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(143), 1,
      sym_csp_rel,
    ACTIONS(918), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(916), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
    ACTIONS(914), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [22956] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(952), 2,
      sym_SEM,
      sym_VBAR,
  [22990] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(135), 1,
      sym_csp_rel,
    ACTIONS(918), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(914), 4,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(916), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [23013] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(954), 1,
      sym_RBRACK,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [23046] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(956), 1,
      sym_RBRACK,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [23079] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      sym_AND,
    ACTIONS(904), 1,
      sym_QUESTION,
    ACTIONS(906), 1,
      sym_XOR,
    ACTIONS(924), 1,
      sym_MUL,
    ACTIONS(926), 1,
      sym_POW,
    ACTIONS(920), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(922), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(958), 2,
      sym_COMMA,
      sym_RPAREN,
  [23110] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(960), 1,
      sym_COMMA,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [23143] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      sym_AND,
    ACTIONS(904), 1,
      sym_QUESTION,
    ACTIONS(906), 1,
      sym_XOR,
    ACTIONS(924), 1,
      sym_MUL,
    ACTIONS(926), 1,
      sym_POW,
    ACTIONS(920), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(922), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(962), 2,
      sym_COMMA,
      sym_RPAREN,
  [23174] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(964), 1,
      sym_COMMA,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [23207] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(966), 1,
      sym_RBRACK,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [23240] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(968), 1,
      sym_COMMA,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [23273] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_AND,
    ACTIONS(344), 1,
      sym_DOTS,
    ACTIONS(346), 1,
      sym_MUL,
    ACTIONS(348), 1,
      sym_POW,
    ACTIONS(350), 1,
      sym_QUESTION,
    ACTIONS(354), 1,
      sym_XOR,
    ACTIONS(970), 1,
      sym_RBRACK,
    ACTIONS(340), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(352), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [23306] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      sym_AND,
    ACTIONS(904), 1,
      sym_QUESTION,
    ACTIONS(906), 1,
      sym_XOR,
    ACTIONS(924), 1,
      sym_MUL,
    ACTIONS(926), 1,
      sym_POW,
    ACTIONS(972), 1,
      sym_DOT,
    ACTIONS(920), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(922), 2,
      sym_MOD,
      sym_SLASH,
  [23336] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(728), 1,
      sym_theory_definition_identifier,
    ACTIONS(856), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [23354] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(705), 1,
      sym_theory_definition_identifier,
    ACTIONS(856), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [23372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(737), 1,
      sym_theory_definition_identifier,
    ACTIONS(856), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [23390] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(720), 1,
      sym_VBAR,
    ACTIONS(902), 1,
      sym_AND,
    ACTIONS(904), 1,
      sym_QUESTION,
    ACTIONS(906), 1,
      sym_XOR,
    ACTIONS(924), 1,
      sym_MUL,
    ACTIONS(926), 1,
      sym_POW,
    ACTIONS(920), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(922), 2,
      sym_MOD,
      sym_SLASH,
  [23420] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(756), 1,
      sym_theory_definition_identifier,
    ACTIONS(856), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [23438] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(143), 1,
      sym_csp_rel,
    ACTIONS(918), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(944), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(916), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [23459] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(135), 1,
      sym_csp_rel,
    ACTIONS(918), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(944), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(916), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [23480] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(141), 1,
      sym_csp_rel,
    ACTIONS(918), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(944), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(916), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [23501] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(284), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    ACTIONS(578), 2,
      sym_THEORY_OP,
      sym_NOT,
    ACTIONS(974), 4,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
  [23521] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_THEORY_OP,
    ACTIONS(578), 1,
      sym_NOT,
    STATE(290), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    ACTIONS(974), 2,
      sym_COMMA,
      sym_RBRACE,
    ACTIONS(976), 2,
      sym_COLON,
      sym_SEM,
  [23545] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_THEORY_OP,
    ACTIONS(578), 1,
      sym_NOT,
    STATE(290), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    ACTIONS(978), 2,
      sym_COLON,
      sym_SEM,
    ACTIONS(980), 2,
      sym_COMMA,
      sym_RBRACE,
  [23569] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(284), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    ACTIONS(578), 2,
      sym_THEORY_OP,
      sym_NOT,
    ACTIONS(980), 4,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
  [23589] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(380), 1,
      sym_COMMA,
    ACTIONS(982), 1,
      sym_COLON,
    STATE(310), 1,
      sym_dsym,
    STATE(680), 1,
      sym_noptcondition,
    ACTIONS(378), 2,
      sym_DOT,
      sym_IF,
    ACTIONS(984), 2,
      sym_SEM,
      sym_VBAR,
  [23613] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(986), 1,
      sym_COLON,
    ACTIONS(988), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [23628] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    STATE(37), 1,
      sym_dec,
    STATE(753), 1,
      sym_NUMBER,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [23649] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    STATE(37), 1,
      sym_dec,
    STATE(725), 1,
      sym_NUMBER,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [23670] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_THEORY_OP,
    ACTIONS(578), 1,
      sym_NOT,
    ACTIONS(990), 1,
      sym_COMMA,
    STATE(282), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    ACTIONS(992), 2,
      sym_DOT,
      sym_SEM,
  [23693] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      sym_COLON,
    ACTIONS(376), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [23708] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(994), 1,
      sym_COLON,
    ACTIONS(996), 1,
      sym_COMMA,
    STATE(309), 1,
      sym_dsym,
    ACTIONS(984), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(998), 2,
      sym_DOT,
      sym_IF,
  [23729] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 1,
      sym_COLON,
    ACTIONS(842), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [23744] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    STATE(37), 1,
      sym_dec,
    STATE(720), 1,
      sym_NUMBER,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [23765] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    STATE(37), 1,
      sym_dec,
    STATE(751), 1,
      sym_NUMBER,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [23786] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1002), 1,
      sym_LPAREN,
    ACTIONS(1000), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [23801] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    STATE(37), 1,
      sym_dec,
    STATE(714), 1,
      sym_NUMBER,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [23822] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_THEORY_OP,
    ACTIONS(578), 1,
      sym_NOT,
    ACTIONS(1004), 1,
      sym_COMMA,
    STATE(282), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    ACTIONS(1006), 2,
      sym_DOT,
      sym_SEM,
  [23845] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(366), 1,
      sym_COLON,
    ACTIONS(368), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [23860] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 1,
      sym_COLON,
    ACTIONS(914), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [23875] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 1,
      anon_sym_0,
    ACTIONS(69), 1,
      aux_sym_dec_token1,
    STATE(37), 1,
      sym_dec,
    STATE(719), 1,
      sym_NUMBER,
    ACTIONS(71), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [23896] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      sym_LPAREN,
    ACTIONS(1000), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(1008), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [23913] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [23925] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(320), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [23937] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      sym_COLON,
    ACTIONS(1016), 1,
      sym_COMMA,
    STATE(550), 1,
      sym_noptimizetuple,
    STATE(655), 1,
      sym_noptimizecond,
    ACTIONS(1018), 2,
      sym_RBRACE,
      sym_SEM,
  [23957] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [23969] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [23981] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1022), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [23993] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      sym_LBRACE,
    STATE(600), 1,
      sym_theory_atom_type,
    ACTIONS(1026), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [24009] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_THEORY_OP,
    ACTIONS(578), 1,
      sym_NOT,
    ACTIONS(1028), 1,
      sym_COMMA,
    STATE(182), 1,
      sym_theory_op,
    ACTIONS(1030), 2,
      sym_DOT,
      sym_SEM,
  [24029] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1022), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(1032), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [24043] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(1034), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [24057] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_THEORY_OP,
    ACTIONS(578), 1,
      sym_NOT,
    STATE(289), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    ACTIONS(992), 2,
      sym_DOT,
      sym_IF,
  [24077] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(320), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(322), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [24091] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(1038), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [24105] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(1042), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [24119] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_COLON,
    STATE(633), 1,
      sym_noptcondition,
    ACTIONS(928), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(1046), 2,
      sym_RBRACE,
      sym_SEM,
  [24137] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(1008), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [24151] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(304), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(306), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [24165] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [24177] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(312), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(314), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [24191] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(318), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [24205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(1050), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [24219] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      sym_COLON,
    ACTIONS(1016), 1,
      sym_COMMA,
    STATE(541), 1,
      sym_noptimizetuple,
    STATE(654), 1,
      sym_noptimizecond,
    ACTIONS(1052), 2,
      sym_RBRACE,
      sym_SEM,
  [24239] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1054), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [24251] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(592), 1,
      sym_RPAREN,
    ACTIONS(1056), 1,
      sym_COMMA,
    STATE(284), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    ACTIONS(578), 2,
      sym_THEORY_OP,
      sym_NOT,
  [24271] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_COLON,
    STATE(660), 1,
      sym_noptcondition,
    ACTIONS(928), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(1058), 2,
      sym_RBRACE,
      sym_SEM,
  [24289] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1060), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(1062), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [24303] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1038), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [24315] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(302), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [24329] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(304), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [24341] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 1,
      sym_COMMA,
    STATE(308), 1,
      sym_dsym,
    ACTIONS(984), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(1066), 2,
      sym_DOT,
      sym_IF,
  [24359] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1068), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [24371] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      sym_COLON,
    ACTIONS(1016), 1,
      sym_COMMA,
    STATE(503), 1,
      sym_noptimizetuple,
    STATE(629), 1,
      sym_noptimizecond,
    ACTIONS(1070), 2,
      sym_RBRACE,
      sym_SEM,
  [24391] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_THEORY_OP,
    ACTIONS(578), 1,
      sym_NOT,
    ACTIONS(1072), 1,
      sym_COMMA,
    STATE(183), 1,
      sym_theory_op,
    ACTIONS(1074), 2,
      sym_DOT,
      sym_SEM,
  [24411] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      sym_COLON,
    ACTIONS(1016), 1,
      sym_COMMA,
    STATE(531), 1,
      sym_noptimizetuple,
    STATE(631), 1,
      sym_noptimizecond,
    ACTIONS(1076), 2,
      sym_RBRACE,
      sym_SEM,
  [24431] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(598), 1,
      sym_RPAREN,
    ACTIONS(1078), 1,
      sym_COMMA,
    STATE(284), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    ACTIONS(578), 2,
      sym_THEORY_OP,
      sym_NOT,
  [24451] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_COLON,
    STATE(613), 1,
      sym_noptcondition,
    ACTIONS(928), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(1080), 2,
      sym_RBRACE,
      sym_SEM,
  [24469] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1062), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [24481] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(312), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [24493] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [24505] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [24517] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 1,
      sym_COMMA,
    STATE(312), 1,
      sym_dsym,
    ACTIONS(984), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(1082), 2,
      sym_DOT,
      sym_IF,
  [24535] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [24547] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1084), 1,
      sym_RBRACE,
    STATE(648), 1,
      sym_theory_operator_definition,
    STATE(649), 1,
      sym_theory_operator_definition_nlist,
    STATE(736), 1,
      sym_theory_op,
    ACTIONS(1086), 2,
      sym_THEORY_OP,
      sym_NOT,
  [24567] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1042), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [24579] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1054), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(1088), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [24593] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(1090), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [24607] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(298), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [24621] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_THEORY_OP,
    ACTIONS(578), 1,
      sym_NOT,
    STATE(289), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    ACTIONS(1006), 2,
      sym_DOT,
      sym_IF,
  [24641] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      sym_LPAREN,
    ACTIONS(1000), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(1008), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [24657] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 1,
      sym_RPAREN,
    ACTIONS(1094), 1,
      sym_COMMA,
    STATE(284), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    ACTIONS(578), 2,
      sym_THEORY_OP,
      sym_NOT,
  [24677] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(616), 1,
      sym_RPAREN,
    ACTIONS(1096), 1,
      sym_COMMA,
    STATE(284), 1,
      sym_theory_op_list,
    STATE(327), 1,
      sym_theory_op,
    ACTIONS(578), 2,
      sym_THEORY_OP,
      sym_NOT,
  [24697] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_COLON,
    STATE(698), 1,
      sym_noptcondition,
    ACTIONS(928), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(1098), 2,
      sym_RBRACE,
      sym_SEM,
  [24715] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_COLON,
    ACTIONS(1100), 1,
      sym_COMMA,
    STATE(605), 1,
      sym_noptcondition,
    ACTIONS(412), 2,
      sym_RBRACE,
      sym_SEM,
  [24732] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1102), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [24743] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(368), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [24754] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [24765] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(312), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(314), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [24778] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(1008), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [24791] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(322), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [24804] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(304), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(306), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [24817] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(318), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [24830] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_THEORY_OP,
    ACTIONS(578), 1,
      sym_NOT,
    STATE(175), 1,
      sym_theory_op,
    ACTIONS(1030), 2,
      sym_DOT,
      sym_IF,
  [24847] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(376), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [24858] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [24869] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(1034), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [24882] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      sym_NOT,
    ACTIONS(1104), 1,
      sym_LPAREN,
    ACTIONS(1008), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [24897] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1062), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(1060), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [24910] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1054), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(1088), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [24923] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1106), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [24934] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1022), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(1032), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [24947] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_THEORY_OP,
    ACTIONS(578), 1,
      sym_NOT,
    STATE(193), 1,
      sym_theory_op,
    ACTIONS(1074), 2,
      sym_DOT,
      sym_IF,
  [24964] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_COLON,
    ACTIONS(1108), 1,
      sym_COMMA,
    STATE(620), 1,
      sym_noptcondition,
    ACTIONS(390), 2,
      sym_RBRACE,
      sym_SEM,
  [24981] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(914), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [24992] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(700), 1,
      sym_theory_atom_type,
    ACTIONS(1026), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [25005] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(302), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [25018] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(1090), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [25031] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(664), 1,
      sym_theory_atom_type,
    ACTIONS(1026), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [25044] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(298), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [25057] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1038), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(1036), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [25070] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1042), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(1040), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [25083] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1110), 1,
      sym_RBRACE,
    STATE(619), 1,
      sym_theory_op,
    STATE(622), 1,
      sym_theory_operator_nlist,
    ACTIONS(578), 2,
      sym_THEORY_OP,
      sym_NOT,
  [25100] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      sym_COLON,
    STATE(594), 1,
      sym_noptimizecond,
    ACTIONS(1112), 2,
      sym_RBRACE,
      sym_SEM,
  [25114] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 1,
      sym_NOT,
    ACTIONS(298), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [25126] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1100), 1,
      sym_COMMA,
    ACTIONS(1114), 3,
      sym_COLON,
      sym_RBRACE,
      sym_SEM,
  [25138] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 1,
      sym_LBRACE,
    ACTIONS(1116), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [25150] = 4,
    ACTIONS(1120), 1,
      sym_comment,
    ACTIONS(1122), 1,
      anon_sym_DQUOTE,
    STATE(528), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1124), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [25164] = 4,
    ACTIONS(1120), 1,
      sym_comment,
    ACTIONS(1126), 1,
      anon_sym_DQUOTE,
    STATE(507), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1128), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [25178] = 4,
    ACTIONS(1120), 1,
      sym_comment,
    ACTIONS(1130), 1,
      anon_sym_DQUOTE,
    STATE(528), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1124), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [25192] = 4,
    ACTIONS(1120), 1,
      sym_comment,
    ACTIONS(1132), 1,
      anon_sym_DQUOTE,
    STATE(509), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1134), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [25206] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_COLON,
    STATE(668), 1,
      sym_noptcondition,
    ACTIONS(1136), 2,
      sym_RBRACE,
      sym_SEM,
  [25220] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1138), 1,
      sym_SUB,
    ACTIONS(1140), 1,
      sym_identifier,
    STATE(120), 1,
      sym__widentifier,
    STATE(652), 1,
      sym_atom,
  [25236] = 4,
    ACTIONS(1120), 1,
      sym_comment,
    ACTIONS(1142), 1,
      anon_sym_DQUOTE,
    STATE(528), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1124), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [25250] = 4,
    ACTIONS(1120), 1,
      sym_comment,
    ACTIONS(1144), 1,
      anon_sym_DQUOTE,
    STATE(513), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1146), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [25264] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_COLON,
    STATE(593), 1,
      sym_noptcondition,
    ACTIONS(1148), 2,
      sym_RBRACE,
      sym_SEM,
  [25278] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_COLON,
    STATE(656), 1,
      sym_noptcondition,
    ACTIONS(1150), 2,
      sym_RBRACE,
      sym_SEM,
  [25292] = 4,
    ACTIONS(1120), 1,
      sym_comment,
    ACTIONS(1152), 1,
      anon_sym_DQUOTE,
    STATE(528), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1124), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [25306] = 4,
    ACTIONS(1120), 1,
      sym_comment,
    ACTIONS(1154), 1,
      anon_sym_DQUOTE,
    STATE(528), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1124), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [25320] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      sym_NOT,
    ACTIONS(1008), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [25332] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1156), 1,
      sym_SUB,
    ACTIONS(1158), 1,
      sym_identifier,
    STATE(120), 1,
      sym__widentifier,
    STATE(570), 1,
      sym_atom,
  [25348] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1160), 1,
      sym_COLON,
    ACTIONS(1164), 1,
      sym_DOT,
    ACTIONS(1162), 2,
      sym_COMMA,
      sym_SEM,
  [25362] = 4,
    ACTIONS(1120), 1,
      sym_comment,
    ACTIONS(1166), 1,
      anon_sym_DQUOTE,
    STATE(518), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1168), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [25376] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1138), 1,
      sym_SUB,
    ACTIONS(1140), 1,
      sym_identifier,
    STATE(120), 1,
      sym__widentifier,
    STATE(571), 1,
      sym_atom,
  [25392] = 4,
    ACTIONS(1120), 1,
      sym_comment,
    ACTIONS(1170), 1,
      anon_sym_DQUOTE,
    STATE(517), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1172), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [25406] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(1174), 1,
      sym_SLASH,
    ACTIONS(368), 2,
      sym_COLON,
      sym_DOT,
  [25420] = 4,
    ACTIONS(1120), 1,
      sym_comment,
    ACTIONS(1176), 1,
      anon_sym_DQUOTE,
    STATE(528), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1124), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [25434] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1042), 1,
      sym_NOT,
    ACTIONS(1040), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [25446] = 4,
    ACTIONS(1120), 1,
      sym_comment,
    ACTIONS(1178), 1,
      anon_sym_DQUOTE,
    STATE(528), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1180), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [25460] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_COLON,
    STATE(658), 1,
      sym_noptcondition,
    ACTIONS(1183), 2,
      sym_RBRACE,
      sym_SEM,
  [25474] = 4,
    ACTIONS(1120), 1,
      sym_comment,
    ACTIONS(1185), 1,
      anon_sym_DQUOTE,
    STATE(526), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1187), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [25488] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      sym_COLON,
    STATE(595), 1,
      sym_noptimizecond,
    ACTIONS(1189), 2,
      sym_RBRACE,
      sym_SEM,
  [25502] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1062), 1,
      sym_NOT,
    ACTIONS(1060), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [25514] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1054), 1,
      sym_NOT,
    ACTIONS(1088), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [25526] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1022), 1,
      sym_NOT,
    ACTIONS(1032), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [25538] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(659), 1,
      sym_theory_operator_definition,
    STATE(736), 1,
      sym_theory_op,
    ACTIONS(1086), 2,
      sym_THEORY_OP,
      sym_NOT,
  [25552] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1038), 1,
      sym_NOT,
    ACTIONS(1036), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [25564] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 1,
      sym_NOT,
    ACTIONS(1090), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [25576] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 1,
      sym_NOT,
    ACTIONS(1034), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [25588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(320), 1,
      sym_NOT,
    ACTIONS(322), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [25600] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1160), 1,
      sym_COLON,
    ACTIONS(1193), 1,
      sym_DOT,
    ACTIONS(1191), 2,
      sym_COMMA,
      sym_SEM,
  [25614] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      sym_COLON,
    STATE(684), 1,
      sym_noptimizecond,
    ACTIONS(1195), 2,
      sym_RBRACE,
      sym_SEM,
  [25628] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_COLON,
    STATE(603), 1,
      sym_noptcondition,
    ACTIONS(1197), 2,
      sym_RBRACE,
      sym_SEM,
  [25642] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(304), 1,
      sym_NOT,
    ACTIONS(306), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [25654] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 1,
      sym_NOT,
    ACTIONS(302), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [25666] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(1199), 1,
      sym_SLASH,
    ACTIONS(358), 2,
      sym_COLON,
      sym_DOT,
  [25680] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_COLON,
    STATE(665), 1,
      sym_noptcondition,
    ACTIONS(1201), 2,
      sym_RBRACE,
      sym_SEM,
  [25694] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_COLON,
    STATE(691), 1,
      sym_noptcondition,
    ACTIONS(1203), 2,
      sym_RBRACE,
      sym_SEM,
  [25708] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym_NOT,
    ACTIONS(318), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [25720] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(312), 1,
      sym_NOT,
    ACTIONS(314), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [25732] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      sym_COLON,
    STATE(686), 1,
      sym_noptimizecond,
    ACTIONS(1205), 2,
      sym_RBRACE,
      sym_SEM,
  [25746] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1207), 1,
      sym_COLON,
    ACTIONS(1209), 1,
      sym_DOT,
    STATE(20), 1,
      sym_bodyconddot,
  [25759] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1211), 1,
      sym_COMMA,
    ACTIONS(1082), 2,
      sym_RBRACE,
      sym_SEM,
  [25770] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1211), 1,
      sym_COMMA,
    ACTIONS(1213), 2,
      sym_DOT,
      sym_SEM,
  [25781] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [25790] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_DOT,
    ACTIONS(1215), 2,
      sym_COMMA,
      sym_SEM,
  [25801] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1219), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [25810] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1193), 1,
      sym_DOT,
    ACTIONS(1191), 2,
      sym_COMMA,
      sym_SEM,
  [25821] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 2,
      sym_COLON,
      sym_DOT,
  [25832] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1221), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [25841] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1223), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [25850] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [25859] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1227), 1,
      sym_COMMA,
    ACTIONS(1229), 1,
      sym_RBRACK,
    STATE(755), 1,
      sym_noptimizetuple,
  [25872] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1231), 1,
      sym_identifier,
    STATE(131), 1,
      sym__widentifier,
    STATE(578), 1,
      sym_theory_atom_name,
  [25885] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1233), 3,
      sym_COMMA,
      sym_LBRACE,
      sym_SLASH,
  [25894] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 1,
      sym_RPAREN,
    ACTIONS(1235), 1,
      sym_identifier,
    STATE(643), 1,
      sym_nidlist,
  [25907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1237), 1,
      sym_COMMA,
    ACTIONS(1239), 2,
      sym_RPAREN,
      sym_SEM,
  [25918] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [25927] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      anon_sym_LPAREN,
    ACTIONS(368), 2,
      sym_COLON,
      sym_DOT,
  [25938] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(410), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [25947] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1207), 1,
      sym_COLON,
    ACTIONS(1209), 1,
      sym_DOT,
    STATE(30), 1,
      sym_bodyconddot,
  [25960] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1207), 1,
      sym_COLON,
    ACTIONS(1209), 1,
      sym_DOT,
    STATE(708), 1,
      sym_bodyconddot,
  [25973] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(653), 1,
      sym_theory_op,
    ACTIONS(578), 2,
      sym_THEORY_OP,
      sym_NOT,
  [25984] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1241), 1,
      sym_COMMA,
    ACTIONS(1243), 2,
      sym_RPAREN,
      sym_SEM,
  [25995] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1241), 1,
      sym_COMMA,
    ACTIONS(1245), 2,
      sym_RPAREN,
      sym_SEM,
  [26006] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1249), 1,
      sym_DOT,
    ACTIONS(1247), 2,
      sym_COMMA,
      sym_SEM,
  [26017] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      sym_DOT,
    ACTIONS(1162), 2,
      sym_COMMA,
      sym_SEM,
  [26028] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(1251), 1,
      sym_LT,
    STATE(721), 1,
      sym_STRING,
  [26041] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1253), 1,
      sym_LBRACE,
    ACTIONS(1116), 2,
      sym_DOT,
      sym_IF,
  [26052] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1211), 1,
      sym_COMMA,
    ACTIONS(1255), 2,
      sym_RBRACE,
      sym_SEM,
  [26063] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1231), 1,
      sym_identifier,
    STATE(131), 1,
      sym__widentifier,
    STATE(506), 1,
      sym_theory_atom_name,
  [26076] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1257), 1,
      sym_COMMA,
    ACTIONS(1259), 2,
      sym_RBRACE,
      sym_SEM,
  [26087] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1261), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [26096] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1211), 1,
      sym_COMMA,
    ACTIONS(1263), 2,
      sym_RBRACE,
      sym_SEM,
  [26107] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1265), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [26116] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1267), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [26125] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1269), 1,
      sym_RPAREN,
    ACTIONS(1271), 1,
      sym_SEM,
  [26135] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1271), 1,
      sym_SEM,
    ACTIONS(1273), 1,
      sym_RPAREN,
  [26145] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1275), 2,
      sym_RBRACE,
      sym_SEM,
  [26153] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1277), 2,
      sym_RBRACE,
      sym_SEM,
  [26161] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1279), 1,
      sym_identifier,
    STATE(160), 1,
      sym__widentifier,
  [26171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 1,
      sym_RPAREN,
    ACTIONS(1281), 1,
      sym_COMMA,
  [26181] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1100), 1,
      sym_COMMA,
    ACTIONS(1283), 1,
      sym_COLON,
  [26191] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1150), 2,
      sym_RBRACE,
      sym_SEM,
  [26199] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1018), 2,
      sym_RBRACE,
      sym_SEM,
  [26207] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1052), 2,
      sym_RBRACE,
      sym_SEM,
  [26215] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(614), 1,
      sym_RPAREN,
    ACTIONS(1271), 1,
      sym_SEM,
  [26225] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1285), 1,
      sym_RBRACE,
    ACTIONS(1287), 1,
      sym_SEM,
  [26235] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1289), 1,
      sym_UNARY,
    ACTIONS(1291), 1,
      sym_BINARY,
  [26245] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1293), 2,
      sym_RBRACE,
      sym_SEM,
  [26253] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 2,
      sym_RBRACE,
      sym_SEM,
  [26261] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1297), 2,
      sym_LEFT,
      sym_RIGHT,
  [26269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1281), 1,
      sym_COMMA,
    ACTIONS(1299), 1,
      sym_RPAREN,
  [26279] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1301), 2,
      sym_RBRACE,
      sym_SEM,
  [26287] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    STATE(140), 1,
      sym__widentifier,
  [26297] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1263), 2,
      sym_RBRACE,
      sym_SEM,
  [26305] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 2,
      sym_RBRACE,
      sym_SEM,
  [26313] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1114), 1,
      sym_RBRACK,
    ACTIONS(1241), 1,
      sym_COMMA,
  [26323] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(208), 1,
      sym_DOT,
    ACTIONS(1307), 1,
      sym_LPAREN,
  [26333] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(588), 1,
      sym_RPAREN,
    ACTIONS(1281), 1,
      sym_COMMA,
  [26343] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 2,
      sym_COLON,
      sym_DOT,
  [26351] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1100), 1,
      sym_COMMA,
    ACTIONS(1309), 1,
      sym_COLON,
  [26361] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 1,
      sym_SEM,
    ACTIONS(1193), 1,
      sym_DOT,
  [26371] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1046), 2,
      sym_RBRACE,
      sym_SEM,
  [26379] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1311), 1,
      sym_SEM,
    ACTIONS(1313), 1,
      sym_VBAR,
  [26389] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(592), 1,
      sym_RBRACK,
    ACTIONS(1281), 1,
      sym_COMMA,
  [26399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1315), 1,
      sym_COMMA,
    ACTIONS(1317), 1,
      sym_RPAREN,
  [26409] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(720), 1,
      sym_RPAREN,
    ACTIONS(1319), 1,
      sym_COMMA,
  [26419] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(592), 1,
      sym_RBRACE,
    ACTIONS(1281), 1,
      sym_COMMA,
  [26429] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1321), 2,
      sym_COMMA,
      sym_RBRACE,
  [26437] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1255), 2,
      sym_RBRACE,
      sym_SEM,
  [26445] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1323), 1,
      sym_SUB,
    ACTIONS(1325), 1,
      sym_identifier,
  [26455] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1327), 1,
      sym_COMMA,
    ACTIONS(1329), 1,
      sym_RBRACE,
  [26465] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 1,
      sym_RBRACK,
    ACTIONS(1281), 1,
      sym_COMMA,
  [26475] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 1,
      sym_RBRACE,
    ACTIONS(1281), 1,
      sym_COMMA,
  [26485] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1331), 2,
      sym_RBRACE,
      sym_SEM,
  [26493] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(420), 2,
      sym_DOT,
      sym_IF,
  [26501] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(222), 1,
      sym_DOT,
    ACTIONS(1333), 1,
      sym_IF,
  [26511] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1335), 2,
      sym_DOT,
      sym_IF,
  [26519] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1112), 2,
      sym_RBRACE,
      sym_SEM,
  [26527] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(530), 1,
      sym_RBRACE,
    ACTIONS(1287), 1,
      sym_SEM,
  [26537] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1189), 2,
      sym_RBRACE,
      sym_SEM,
  [26545] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1281), 1,
      sym_COMMA,
    ACTIONS(1337), 1,
      sym_RPAREN,
  [26555] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1058), 2,
      sym_RBRACE,
      sym_SEM,
  [26563] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(544), 1,
      sym_RBRACE,
    ACTIONS(1287), 1,
      sym_SEM,
  [26573] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1339), 2,
      sym_COMMA,
      sym_RPAREN,
  [26581] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 1,
      sym_RPAREN,
    ACTIONS(1281), 1,
      sym_COMMA,
  [26591] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1341), 1,
      sym_RBRACE,
    ACTIONS(1343), 1,
      sym_SEM,
  [26601] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      sym_SEM,
    ACTIONS(1345), 1,
      sym_RPAREN,
  [26611] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1347), 2,
      sym_RBRACE,
      sym_SEM,
  [26619] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1349), 1,
      sym_identifier,
    STATE(140), 1,
      sym__widentifier,
  [26629] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1351), 2,
      sym_RBRACE,
      sym_SEM,
  [26637] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1239), 2,
      sym_RPAREN,
      sym_SEM,
  [26645] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1353), 1,
      sym_COMMA,
    ACTIONS(1355), 1,
      sym_RPAREN,
  [26655] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1357), 2,
      sym_RBRACE,
      sym_SEM,
  [26663] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(506), 1,
      sym_RBRACE,
    ACTIONS(1359), 1,
      sym_SEM,
  [26673] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1361), 2,
      sym_COMMA,
      sym_RPAREN,
  [26681] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(598), 1,
      sym_RBRACK,
    ACTIONS(1281), 1,
      sym_COMMA,
  [26691] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1363), 2,
      sym_RBRACE,
      sym_SEM,
  [26699] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1365), 1,
      sym_RBRACE,
    ACTIONS(1367), 1,
      sym_SEM,
  [26709] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(598), 1,
      sym_RBRACE,
    ACTIONS(1281), 1,
      sym_COMMA,
  [26719] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(542), 1,
      sym_RBRACE,
    ACTIONS(1369), 1,
      sym_SEM,
  [26729] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1371), 1,
      sym_COLON,
    ACTIONS(1373), 1,
      sym_DOT,
  [26739] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1375), 2,
      sym_COMMA,
      sym_RBRACE,
  [26747] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 2,
      sym_RBRACE,
      sym_SEM,
  [26755] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1205), 2,
      sym_RBRACE,
      sym_SEM,
  [26763] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1203), 2,
      sym_RBRACE,
      sym_SEM,
  [26771] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1281), 1,
      sym_COMMA,
    ACTIONS(1377), 1,
      sym_RPAREN,
  [26781] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1379), 2,
      sym_RBRACE,
      sym_SEM,
  [26789] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1381), 2,
      sym_RBRACE,
      sym_SEM,
  [26797] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1098), 2,
      sym_RBRACE,
      sym_SEM,
  [26805] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1162), 1,
      sym_SEM,
    ACTIONS(1164), 1,
      sym_DOT,
  [26815] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1383), 1,
      sym_RBRACE,
    ACTIONS(1385), 1,
      sym_SEM,
  [26825] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1387), 2,
      sym_RBRACE,
      sym_SEM,
  [26833] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1389), 2,
      sym_RBRACE,
      sym_SEM,
  [26841] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1391), 2,
      sym_RBRACE,
      sym_SEM,
  [26849] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 2,
      sym_RBRACE,
      sym_SEM,
  [26857] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(450), 2,
      sym_DOT,
      sym_IF,
  [26865] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1395), 2,
      sym_RBRACE,
      sym_SEM,
  [26873] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1281), 1,
      sym_COMMA,
    ACTIONS(1397), 1,
      sym_RPAREN,
  [26883] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1271), 1,
      sym_SEM,
    ACTIONS(1399), 1,
      sym_RPAREN,
  [26893] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(612), 1,
      sym_RPAREN,
    ACTIONS(1281), 1,
      sym_COMMA,
  [26903] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1271), 1,
      sym_SEM,
    ACTIONS(1401), 1,
      sym_RPAREN,
  [26913] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1403), 2,
      sym_DEFAULT,
      sym_OVERRIDE,
  [26921] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1405), 1,
      sym_identifier,
    STATE(187), 1,
      sym__widentifier,
  [26931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1271), 1,
      sym_SEM,
    ACTIONS(1313), 1,
      sym_RPAREN,
  [26941] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1407), 1,
      sym_RBRACE,
    ACTIONS(1409), 1,
      sym_SEM,
  [26951] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1411), 2,
      sym_RBRACE,
      sym_SEM,
  [26959] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(998), 2,
      sym_DOT,
      sym_IF,
  [26967] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1100), 1,
      sym_COMMA,
    ACTIONS(1413), 1,
      sym_COLON,
  [26977] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1066), 2,
      sym_DOT,
      sym_IF,
  [26985] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1415), 1,
      sym_identifier,
    STATE(156), 1,
      sym__widentifier,
  [26995] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1417), 1,
      sym_RBRACE,
    ACTIONS(1419), 1,
      sym_SEM,
  [27005] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1100), 1,
      sym_COMMA,
    ACTIONS(1421), 1,
      sym_COLON,
  [27015] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1423), 2,
      sym_RBRACE,
      sym_SEM,
  [27023] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(446), 2,
      sym_DOT,
      sym_IF,
  [27031] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1425), 2,
      sym_RBRACE,
      sym_SEM,
  [27039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1427), 1,
      sym_identifier,
    STATE(743), 1,
      sym_theory_identifier,
  [27049] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 1,
      sym_RBRACE,
    ACTIONS(1429), 1,
      sym_SEM,
  [27059] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 1,
      sym_RBRACE,
    ACTIONS(1431), 1,
      sym_SEM,
  [27069] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1433), 1,
      sym_RPAREN,
    ACTIONS(1435), 1,
      sym_SEM,
  [27079] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1183), 2,
      sym_RBRACE,
      sym_SEM,
  [27087] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(616), 1,
      sym_RBRACK,
    ACTIONS(1281), 1,
      sym_COMMA,
  [27097] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(616), 1,
      sym_RBRACE,
    ACTIONS(1281), 1,
      sym_COMMA,
  [27107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1409), 1,
      sym_SEM,
    ACTIONS(1437), 1,
      sym_RBRACE,
  [27117] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1439), 1,
      sym_RPAREN,
    ACTIONS(1441), 1,
      sym_SEM,
  [27127] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1311), 1,
      sym_SEM,
    ACTIONS(1443), 1,
      sym_VBAR,
  [27137] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1271), 1,
      sym_SEM,
    ACTIONS(1445), 1,
      sym_RPAREN,
  [27147] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1447), 2,
      sym_RBRACE,
      sym_SEM,
  [27155] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1271), 1,
      sym_SEM,
    ACTIONS(1449), 1,
      sym_RPAREN,
  [27165] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1451), 2,
      sym_RBRACE,
      sym_SEM,
  [27173] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1271), 1,
      sym_SEM,
    ACTIONS(1453), 1,
      sym_RPAREN,
  [27183] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1271), 1,
      sym_SEM,
    ACTIONS(1455), 1,
      sym_RPAREN,
  [27193] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1271), 1,
      sym_SEM,
    ACTIONS(1443), 1,
      sym_RPAREN,
  [27203] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1457), 1,
      sym_LBRACE,
  [27210] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1459), 1,
      sym_COMMA,
  [27217] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1461), 1,
      sym_RBRACE,
  [27224] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1463), 1,
      sym_LBRACE,
  [27231] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1465), 1,
      sym_LBRACK,
  [27238] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1443), 1,
      sym_RPAREN,
  [27245] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      ts_builtin_sym_end,
  [27252] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1469), 1,
      sym_RPAREN,
  [27259] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1471), 1,
      sym_LBRACE,
  [27266] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1473), 1,
      sym_DOT,
  [27273] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1475), 1,
      sym_COMMA,
  [27280] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1477), 1,
      sym_LPAREN,
  [27287] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1479), 1,
      sym_LBRACE,
  [27294] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1481), 1,
      sym_LBRACE,
  [27301] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1483), 1,
      sym_identifier,
  [27308] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1229), 1,
      sym_DOT,
  [27315] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1485), 1,
      sym_COLON,
  [27322] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(208), 1,
      sym_DOT,
  [27329] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 1,
      sym_GT,
  [27336] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1199), 1,
      sym_SLASH,
  [27343] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1487), 1,
      sym_LBRACE,
  [27350] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1489), 1,
      sym_DOT,
  [27357] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(954), 1,
      sym_RBRACK,
  [27364] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1491), 1,
      sym_identifier,
  [27371] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1493), 1,
      sym_COMMA,
  [27378] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(772), 1,
      sym_CSP,
  [27385] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1495), 1,
      sym_COMMA,
  [27392] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1497), 1,
      sym_LPAREN,
  [27399] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1499), 1,
      sym_LBRACE,
  [27406] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      sym_CSP,
  [27413] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1501), 1,
      sym_identifier,
  [27420] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(782), 1,
      sym_CSP,
  [27427] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1503), 1,
      sym_COLON,
  [27434] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1505), 1,
      sym_COMMA,
  [27441] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      sym_LBRACE,
  [27448] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1355), 1,
      sym_RBRACE,
  [27455] = 2,
    ACTIONS(1120), 1,
      sym_comment,
    ACTIONS(1509), 1,
      sym_CODE,
  [27462] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      sym_LBRACE,
  [27469] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      sym_identifier,
  [27476] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1515), 1,
      sym_LBRACE,
  [27483] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1517), 1,
      sym_LBRACE,
  [27490] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1519), 1,
      sym_LBRACE,
  [27497] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1521), 1,
      sym_LBRACK,
  [27504] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(720), 1,
      sym_RPAREN,
  [27511] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1523), 1,
      sym_COMMA,
  [27518] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1174), 1,
      sym_SLASH,
  [27525] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1525), 1,
      sym_LBRACE,
  [27532] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 1,
      sym_DOT,
  [27539] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1527), 1,
      sym_EQ,
  [27546] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1529), 1,
      sym_DOT,
  [27553] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1531), 1,
      sym_identifier,
  [27560] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 1,
      sym_RBRACK,
  [27567] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1533), 1,
      sym_SLASH,
  [27574] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1535), 1,
      sym_identifier,
  [27581] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1537), 1,
      sym_COMMA,
  [27588] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 1,
      sym_COLON,
  [27595] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1313), 1,
      sym_RPAREN,
  [27602] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      sym_RPAREN,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(4)] = 0,
  [SMALL_STATE(5)] = 137,
  [SMALL_STATE(6)] = 274,
  [SMALL_STATE(7)] = 411,
  [SMALL_STATE(8)] = 548,
  [SMALL_STATE(9)] = 682,
  [SMALL_STATE(10)] = 816,
  [SMALL_STATE(11)] = 950,
  [SMALL_STATE(12)] = 1007,
  [SMALL_STATE(13)] = 1064,
  [SMALL_STATE(14)] = 1121,
  [SMALL_STATE(15)] = 1178,
  [SMALL_STATE(16)] = 1237,
  [SMALL_STATE(17)] = 1296,
  [SMALL_STATE(18)] = 1353,
  [SMALL_STATE(19)] = 1412,
  [SMALL_STATE(20)] = 1469,
  [SMALL_STATE(21)] = 1525,
  [SMALL_STATE(22)] = 1581,
  [SMALL_STATE(23)] = 1637,
  [SMALL_STATE(24)] = 1693,
  [SMALL_STATE(25)] = 1749,
  [SMALL_STATE(26)] = 1805,
  [SMALL_STATE(27)] = 1861,
  [SMALL_STATE(28)] = 1989,
  [SMALL_STATE(29)] = 2045,
  [SMALL_STATE(30)] = 2101,
  [SMALL_STATE(31)] = 2157,
  [SMALL_STATE(32)] = 2210,
  [SMALL_STATE(33)] = 2260,
  [SMALL_STATE(34)] = 2310,
  [SMALL_STATE(35)] = 2360,
  [SMALL_STATE(36)] = 2412,
  [SMALL_STATE(37)] = 2462,
  [SMALL_STATE(38)] = 2512,
  [SMALL_STATE(39)] = 2562,
  [SMALL_STATE(40)] = 2611,
  [SMALL_STATE(41)] = 2660,
  [SMALL_STATE(42)] = 2769,
  [SMALL_STATE(43)] = 2818,
  [SMALL_STATE(44)] = 2867,
  [SMALL_STATE(45)] = 2916,
  [SMALL_STATE(46)] = 3025,
  [SMALL_STATE(47)] = 3089,
  [SMALL_STATE(48)] = 3143,
  [SMALL_STATE(49)] = 3201,
  [SMALL_STATE(50)] = 3255,
  [SMALL_STATE(51)] = 3361,
  [SMALL_STATE(52)] = 3467,
  [SMALL_STATE(53)] = 3517,
  [SMALL_STATE(54)] = 3569,
  [SMALL_STATE(55)] = 3625,
  [SMALL_STATE(56)] = 3689,
  [SMALL_STATE(57)] = 3743,
  [SMALL_STATE(58)] = 3794,
  [SMALL_STATE(59)] = 3845,
  [SMALL_STATE(60)] = 3949,
  [SMALL_STATE(61)] = 4001,
  [SMALL_STATE(62)] = 4053,
  [SMALL_STATE(63)] = 4157,
  [SMALL_STATE(64)] = 4206,
  [SMALL_STATE(65)] = 4307,
  [SMALL_STATE(66)] = 4408,
  [SMALL_STATE(67)] = 4509,
  [SMALL_STATE(68)] = 4558,
  [SMALL_STATE(69)] = 4647,
  [SMALL_STATE(70)] = 4750,
  [SMALL_STATE(71)] = 4851,
  [SMALL_STATE(72)] = 4952,
  [SMALL_STATE(73)] = 5041,
  [SMALL_STATE(74)] = 5142,
  [SMALL_STATE(75)] = 5231,
  [SMALL_STATE(76)] = 5319,
  [SMALL_STATE(77)] = 5407,
  [SMALL_STATE(78)] = 5507,
  [SMALL_STATE(79)] = 5595,
  [SMALL_STATE(80)] = 5672,
  [SMALL_STATE(81)] = 5749,
  [SMALL_STATE(82)] = 5843,
  [SMALL_STATE(83)] = 5937,
  [SMALL_STATE(84)] = 6031,
  [SMALL_STATE(85)] = 6125,
  [SMALL_STATE(86)] = 6219,
  [SMALL_STATE(87)] = 6313,
  [SMALL_STATE(88)] = 6407,
  [SMALL_STATE(89)] = 6501,
  [SMALL_STATE(90)] = 6595,
  [SMALL_STATE(91)] = 6680,
  [SMALL_STATE(92)] = 6765,
  [SMALL_STATE(93)] = 6850,
  [SMALL_STATE(94)] = 6935,
  [SMALL_STATE(95)] = 7023,
  [SMALL_STATE(96)] = 7111,
  [SMALL_STATE(97)] = 7196,
  [SMALL_STATE(98)] = 7281,
  [SMALL_STATE(99)] = 7363,
  [SMALL_STATE(100)] = 7401,
  [SMALL_STATE(101)] = 7483,
  [SMALL_STATE(102)] = 7521,
  [SMALL_STATE(103)] = 7559,
  [SMALL_STATE(104)] = 7597,
  [SMALL_STATE(105)] = 7676,
  [SMALL_STATE(106)] = 7755,
  [SMALL_STATE(107)] = 7834,
  [SMALL_STATE(108)] = 7913,
  [SMALL_STATE(109)] = 7992,
  [SMALL_STATE(110)] = 8071,
  [SMALL_STATE(111)] = 8150,
  [SMALL_STATE(112)] = 8229,
  [SMALL_STATE(113)] = 8308,
  [SMALL_STATE(114)] = 8387,
  [SMALL_STATE(115)] = 8465,
  [SMALL_STATE(116)] = 8543,
  [SMALL_STATE(117)] = 8619,
  [SMALL_STATE(118)] = 8695,
  [SMALL_STATE(119)] = 8773,
  [SMALL_STATE(120)] = 8849,
  [SMALL_STATE(121)] = 8925,
  [SMALL_STATE(122)] = 9003,
  [SMALL_STATE(123)] = 9081,
  [SMALL_STATE(124)] = 9159,
  [SMALL_STATE(125)] = 9237,
  [SMALL_STATE(126)] = 9315,
  [SMALL_STATE(127)] = 9391,
  [SMALL_STATE(128)] = 9467,
  [SMALL_STATE(129)] = 9543,
  [SMALL_STATE(130)] = 9621,
  [SMALL_STATE(131)] = 9699,
  [SMALL_STATE(132)] = 9775,
  [SMALL_STATE(133)] = 9851,
  [SMALL_STATE(134)] = 9929,
  [SMALL_STATE(135)] = 9965,
  [SMALL_STATE(136)] = 10041,
  [SMALL_STATE(137)] = 10117,
  [SMALL_STATE(138)] = 10195,
  [SMALL_STATE(139)] = 10271,
  [SMALL_STATE(140)] = 10349,
  [SMALL_STATE(141)] = 10425,
  [SMALL_STATE(142)] = 10501,
  [SMALL_STATE(143)] = 10577,
  [SMALL_STATE(144)] = 10653,
  [SMALL_STATE(145)] = 10689,
  [SMALL_STATE(146)] = 10765,
  [SMALL_STATE(147)] = 10843,
  [SMALL_STATE(148)] = 10879,
  [SMALL_STATE(149)] = 10957,
  [SMALL_STATE(150)] = 11033,
  [SMALL_STATE(151)] = 11109,
  [SMALL_STATE(152)] = 11185,
  [SMALL_STATE(153)] = 11263,
  [SMALL_STATE(154)] = 11336,
  [SMALL_STATE(155)] = 11411,
  [SMALL_STATE(156)] = 11484,
  [SMALL_STATE(157)] = 11557,
  [SMALL_STATE(158)] = 11628,
  [SMALL_STATE(159)] = 11701,
  [SMALL_STATE(160)] = 11736,
  [SMALL_STATE(161)] = 11809,
  [SMALL_STATE(162)] = 11884,
  [SMALL_STATE(163)] = 11957,
  [SMALL_STATE(164)] = 12032,
  [SMALL_STATE(165)] = 12091,
  [SMALL_STATE(166)] = 12126,
  [SMALL_STATE(167)] = 12199,
  [SMALL_STATE(168)] = 12272,
  [SMALL_STATE(169)] = 12307,
  [SMALL_STATE(170)] = 12382,
  [SMALL_STATE(171)] = 12441,
  [SMALL_STATE(172)] = 12516,
  [SMALL_STATE(173)] = 12575,
  [SMALL_STATE(174)] = 12648,
  [SMALL_STATE(175)] = 12718,
  [SMALL_STATE(176)] = 12790,
  [SMALL_STATE(177)] = 12860,
  [SMALL_STATE(178)] = 12922,
  [SMALL_STATE(179)] = 12984,
  [SMALL_STATE(180)] = 13056,
  [SMALL_STATE(181)] = 13126,
  [SMALL_STATE(182)] = 13196,
  [SMALL_STATE(183)] = 13268,
  [SMALL_STATE(184)] = 13340,
  [SMALL_STATE(185)] = 13410,
  [SMALL_STATE(186)] = 13480,
  [SMALL_STATE(187)] = 13552,
  [SMALL_STATE(188)] = 13622,
  [SMALL_STATE(189)] = 13692,
  [SMALL_STATE(190)] = 13762,
  [SMALL_STATE(191)] = 13832,
  [SMALL_STATE(192)] = 13868,
  [SMALL_STATE(193)] = 13938,
  [SMALL_STATE(194)] = 14010,
  [SMALL_STATE(195)] = 14046,
  [SMALL_STATE(196)] = 14079,
  [SMALL_STATE(197)] = 14112,
  [SMALL_STATE(198)] = 14179,
  [SMALL_STATE(199)] = 14246,
  [SMALL_STATE(200)] = 14313,
  [SMALL_STATE(201)] = 14346,
  [SMALL_STATE(202)] = 14395,
  [SMALL_STATE(203)] = 14428,
  [SMALL_STATE(204)] = 14495,
  [SMALL_STATE(205)] = 14562,
  [SMALL_STATE(206)] = 14629,
  [SMALL_STATE(207)] = 14696,
  [SMALL_STATE(208)] = 14763,
  [SMALL_STATE(209)] = 14830,
  [SMALL_STATE(210)] = 14897,
  [SMALL_STATE(211)] = 14964,
  [SMALL_STATE(212)] = 15031,
  [SMALL_STATE(213)] = 15098,
  [SMALL_STATE(214)] = 15165,
  [SMALL_STATE(215)] = 15206,
  [SMALL_STATE(216)] = 15245,
  [SMALL_STATE(217)] = 15288,
  [SMALL_STATE(218)] = 15337,
  [SMALL_STATE(219)] = 15374,
  [SMALL_STATE(220)] = 15441,
  [SMALL_STATE(221)] = 15508,
  [SMALL_STATE(222)] = 15575,
  [SMALL_STATE(223)] = 15642,
  [SMALL_STATE(224)] = 15709,
  [SMALL_STATE(225)] = 15776,
  [SMALL_STATE(226)] = 15843,
  [SMALL_STATE(227)] = 15894,
  [SMALL_STATE(228)] = 15927,
  [SMALL_STATE(229)] = 15994,
  [SMALL_STATE(230)] = 16061,
  [SMALL_STATE(231)] = 16110,
  [SMALL_STATE(232)] = 16177,
  [SMALL_STATE(233)] = 16244,
  [SMALL_STATE(234)] = 16311,
  [SMALL_STATE(235)] = 16378,
  [SMALL_STATE(236)] = 16445,
  [SMALL_STATE(237)] = 16512,
  [SMALL_STATE(238)] = 16579,
  [SMALL_STATE(239)] = 16614,
  [SMALL_STATE(240)] = 16681,
  [SMALL_STATE(241)] = 16748,
  [SMALL_STATE(242)] = 16815,
  [SMALL_STATE(243)] = 16882,
  [SMALL_STATE(244)] = 16949,
  [SMALL_STATE(245)] = 17016,
  [SMALL_STATE(246)] = 17057,
  [SMALL_STATE(247)] = 17124,
  [SMALL_STATE(248)] = 17157,
  [SMALL_STATE(249)] = 17196,
  [SMALL_STATE(250)] = 17263,
  [SMALL_STATE(251)] = 17296,
  [SMALL_STATE(252)] = 17363,
  [SMALL_STATE(253)] = 17396,
  [SMALL_STATE(254)] = 17429,
  [SMALL_STATE(255)] = 17496,
  [SMALL_STATE(256)] = 17563,
  [SMALL_STATE(257)] = 17630,
  [SMALL_STATE(258)] = 17697,
  [SMALL_STATE(259)] = 17740,
  [SMALL_STATE(260)] = 17807,
  [SMALL_STATE(261)] = 17874,
  [SMALL_STATE(262)] = 17941,
  [SMALL_STATE(263)] = 17990,
  [SMALL_STATE(264)] = 18027,
  [SMALL_STATE(265)] = 18094,
  [SMALL_STATE(266)] = 18127,
  [SMALL_STATE(267)] = 18194,
  [SMALL_STATE(268)] = 18261,
  [SMALL_STATE(269)] = 18296,
  [SMALL_STATE(270)] = 18363,
  [SMALL_STATE(271)] = 18430,
  [SMALL_STATE(272)] = 18497,
  [SMALL_STATE(273)] = 18564,
  [SMALL_STATE(274)] = 18631,
  [SMALL_STATE(275)] = 18682,
  [SMALL_STATE(276)] = 18749,
  [SMALL_STATE(277)] = 18816,
  [SMALL_STATE(278)] = 18883,
  [SMALL_STATE(279)] = 18916,
  [SMALL_STATE(280)] = 18983,
  [SMALL_STATE(281)] = 19050,
  [SMALL_STATE(282)] = 19117,
  [SMALL_STATE(283)] = 19183,
  [SMALL_STATE(284)] = 19231,
  [SMALL_STATE(285)] = 19297,
  [SMALL_STATE(286)] = 19347,
  [SMALL_STATE(287)] = 19413,
  [SMALL_STATE(288)] = 19477,
  [SMALL_STATE(289)] = 19527,
  [SMALL_STATE(290)] = 19593,
  [SMALL_STATE(291)] = 19659,
  [SMALL_STATE(292)] = 19725,
  [SMALL_STATE(293)] = 19791,
  [SMALL_STATE(294)] = 19823,
  [SMALL_STATE(295)] = 19889,
  [SMALL_STATE(296)] = 19950,
  [SMALL_STATE(297)] = 20011,
  [SMALL_STATE(298)] = 20072,
  [SMALL_STATE(299)] = 20133,
  [SMALL_STATE(300)] = 20194,
  [SMALL_STATE(301)] = 20255,
  [SMALL_STATE(302)] = 20316,
  [SMALL_STATE(303)] = 20365,
  [SMALL_STATE(304)] = 20412,
  [SMALL_STATE(305)] = 20473,
  [SMALL_STATE(306)] = 20534,
  [SMALL_STATE(307)] = 20595,
  [SMALL_STATE(308)] = 20644,
  [SMALL_STATE(309)] = 20674,
  [SMALL_STATE(310)] = 20704,
  [SMALL_STATE(311)] = 20734,
  [SMALL_STATE(312)] = 20780,
  [SMALL_STATE(313)] = 20810,
  [SMALL_STATE(314)] = 20840,
  [SMALL_STATE(315)] = 20868,
  [SMALL_STATE(316)] = 20896,
  [SMALL_STATE(317)] = 20924,
  [SMALL_STATE(318)] = 20951,
  [SMALL_STATE(319)] = 20978,
  [SMALL_STATE(320)] = 21005,
  [SMALL_STATE(321)] = 21049,
  [SMALL_STATE(322)] = 21093,
  [SMALL_STATE(323)] = 21137,
  [SMALL_STATE(324)] = 21181,
  [SMALL_STATE(325)] = 21225,
  [SMALL_STATE(326)] = 21269,
  [SMALL_STATE(327)] = 21294,
  [SMALL_STATE(328)] = 21319,
  [SMALL_STATE(329)] = 21359,
  [SMALL_STATE(330)] = 21399,
  [SMALL_STATE(331)] = 21439,
  [SMALL_STATE(332)] = 21478,
  [SMALL_STATE(333)] = 21501,
  [SMALL_STATE(334)] = 21532,
  [SMALL_STATE(335)] = 21571,
  [SMALL_STATE(336)] = 21610,
  [SMALL_STATE(337)] = 21633,
  [SMALL_STATE(338)] = 21672,
  [SMALL_STATE(339)] = 21696,
  [SMALL_STATE(340)] = 21734,
  [SMALL_STATE(341)] = 21762,
  [SMALL_STATE(342)] = 21798,
  [SMALL_STATE(343)] = 21836,
  [SMALL_STATE(344)] = 21872,
  [SMALL_STATE(345)] = 21896,
  [SMALL_STATE(346)] = 21934,
  [SMALL_STATE(347)] = 21958,
  [SMALL_STATE(348)] = 21994,
  [SMALL_STATE(349)] = 22030,
  [SMALL_STATE(350)] = 22066,
  [SMALL_STATE(351)] = 22087,
  [SMALL_STATE(352)] = 22108,
  [SMALL_STATE(353)] = 22133,
  [SMALL_STATE(354)] = 22154,
  [SMALL_STATE(355)] = 22191,
  [SMALL_STATE(356)] = 22212,
  [SMALL_STATE(357)] = 22233,
  [SMALL_STATE(358)] = 22258,
  [SMALL_STATE(359)] = 22279,
  [SMALL_STATE(360)] = 22300,
  [SMALL_STATE(361)] = 22327,
  [SMALL_STATE(362)] = 22364,
  [SMALL_STATE(363)] = 22391,
  [SMALL_STATE(364)] = 22416,
  [SMALL_STATE(365)] = 22449,
  [SMALL_STATE(366)] = 22472,
  [SMALL_STATE(367)] = 22501,
  [SMALL_STATE(368)] = 22538,
  [SMALL_STATE(369)] = 22571,
  [SMALL_STATE(370)] = 22594,
  [SMALL_STATE(371)] = 22630,
  [SMALL_STATE(372)] = 22666,
  [SMALL_STATE(373)] = 22700,
  [SMALL_STATE(374)] = 22734,
  [SMALL_STATE(375)] = 22768,
  [SMALL_STATE(376)] = 22804,
  [SMALL_STATE(377)] = 22826,
  [SMALL_STATE(378)] = 22862,
  [SMALL_STATE(379)] = 22898,
  [SMALL_STATE(380)] = 22932,
  [SMALL_STATE(381)] = 22956,
  [SMALL_STATE(382)] = 22990,
  [SMALL_STATE(383)] = 23013,
  [SMALL_STATE(384)] = 23046,
  [SMALL_STATE(385)] = 23079,
  [SMALL_STATE(386)] = 23110,
  [SMALL_STATE(387)] = 23143,
  [SMALL_STATE(388)] = 23174,
  [SMALL_STATE(389)] = 23207,
  [SMALL_STATE(390)] = 23240,
  [SMALL_STATE(391)] = 23273,
  [SMALL_STATE(392)] = 23306,
  [SMALL_STATE(393)] = 23336,
  [SMALL_STATE(394)] = 23354,
  [SMALL_STATE(395)] = 23372,
  [SMALL_STATE(396)] = 23390,
  [SMALL_STATE(397)] = 23420,
  [SMALL_STATE(398)] = 23438,
  [SMALL_STATE(399)] = 23459,
  [SMALL_STATE(400)] = 23480,
  [SMALL_STATE(401)] = 23501,
  [SMALL_STATE(402)] = 23521,
  [SMALL_STATE(403)] = 23545,
  [SMALL_STATE(404)] = 23569,
  [SMALL_STATE(405)] = 23589,
  [SMALL_STATE(406)] = 23613,
  [SMALL_STATE(407)] = 23628,
  [SMALL_STATE(408)] = 23649,
  [SMALL_STATE(409)] = 23670,
  [SMALL_STATE(410)] = 23693,
  [SMALL_STATE(411)] = 23708,
  [SMALL_STATE(412)] = 23729,
  [SMALL_STATE(413)] = 23744,
  [SMALL_STATE(414)] = 23765,
  [SMALL_STATE(415)] = 23786,
  [SMALL_STATE(416)] = 23801,
  [SMALL_STATE(417)] = 23822,
  [SMALL_STATE(418)] = 23845,
  [SMALL_STATE(419)] = 23860,
  [SMALL_STATE(420)] = 23875,
  [SMALL_STATE(421)] = 23896,
  [SMALL_STATE(422)] = 23913,
  [SMALL_STATE(423)] = 23925,
  [SMALL_STATE(424)] = 23937,
  [SMALL_STATE(425)] = 23957,
  [SMALL_STATE(426)] = 23969,
  [SMALL_STATE(427)] = 23981,
  [SMALL_STATE(428)] = 23993,
  [SMALL_STATE(429)] = 24009,
  [SMALL_STATE(430)] = 24029,
  [SMALL_STATE(431)] = 24043,
  [SMALL_STATE(432)] = 24057,
  [SMALL_STATE(433)] = 24077,
  [SMALL_STATE(434)] = 24091,
  [SMALL_STATE(435)] = 24105,
  [SMALL_STATE(436)] = 24119,
  [SMALL_STATE(437)] = 24137,
  [SMALL_STATE(438)] = 24151,
  [SMALL_STATE(439)] = 24165,
  [SMALL_STATE(440)] = 24177,
  [SMALL_STATE(441)] = 24191,
  [SMALL_STATE(442)] = 24205,
  [SMALL_STATE(443)] = 24219,
  [SMALL_STATE(444)] = 24239,
  [SMALL_STATE(445)] = 24251,
  [SMALL_STATE(446)] = 24271,
  [SMALL_STATE(447)] = 24289,
  [SMALL_STATE(448)] = 24303,
  [SMALL_STATE(449)] = 24315,
  [SMALL_STATE(450)] = 24329,
  [SMALL_STATE(451)] = 24341,
  [SMALL_STATE(452)] = 24359,
  [SMALL_STATE(453)] = 24371,
  [SMALL_STATE(454)] = 24391,
  [SMALL_STATE(455)] = 24411,
  [SMALL_STATE(456)] = 24431,
  [SMALL_STATE(457)] = 24451,
  [SMALL_STATE(458)] = 24469,
  [SMALL_STATE(459)] = 24481,
  [SMALL_STATE(460)] = 24493,
  [SMALL_STATE(461)] = 24505,
  [SMALL_STATE(462)] = 24517,
  [SMALL_STATE(463)] = 24535,
  [SMALL_STATE(464)] = 24547,
  [SMALL_STATE(465)] = 24567,
  [SMALL_STATE(466)] = 24579,
  [SMALL_STATE(467)] = 24593,
  [SMALL_STATE(468)] = 24607,
  [SMALL_STATE(469)] = 24621,
  [SMALL_STATE(470)] = 24641,
  [SMALL_STATE(471)] = 24657,
  [SMALL_STATE(472)] = 24677,
  [SMALL_STATE(473)] = 24697,
  [SMALL_STATE(474)] = 24715,
  [SMALL_STATE(475)] = 24732,
  [SMALL_STATE(476)] = 24743,
  [SMALL_STATE(477)] = 24754,
  [SMALL_STATE(478)] = 24765,
  [SMALL_STATE(479)] = 24778,
  [SMALL_STATE(480)] = 24791,
  [SMALL_STATE(481)] = 24804,
  [SMALL_STATE(482)] = 24817,
  [SMALL_STATE(483)] = 24830,
  [SMALL_STATE(484)] = 24847,
  [SMALL_STATE(485)] = 24858,
  [SMALL_STATE(486)] = 24869,
  [SMALL_STATE(487)] = 24882,
  [SMALL_STATE(488)] = 24897,
  [SMALL_STATE(489)] = 24910,
  [SMALL_STATE(490)] = 24923,
  [SMALL_STATE(491)] = 24934,
  [SMALL_STATE(492)] = 24947,
  [SMALL_STATE(493)] = 24964,
  [SMALL_STATE(494)] = 24981,
  [SMALL_STATE(495)] = 24992,
  [SMALL_STATE(496)] = 25005,
  [SMALL_STATE(497)] = 25018,
  [SMALL_STATE(498)] = 25031,
  [SMALL_STATE(499)] = 25044,
  [SMALL_STATE(500)] = 25057,
  [SMALL_STATE(501)] = 25070,
  [SMALL_STATE(502)] = 25083,
  [SMALL_STATE(503)] = 25100,
  [SMALL_STATE(504)] = 25114,
  [SMALL_STATE(505)] = 25126,
  [SMALL_STATE(506)] = 25138,
  [SMALL_STATE(507)] = 25150,
  [SMALL_STATE(508)] = 25164,
  [SMALL_STATE(509)] = 25178,
  [SMALL_STATE(510)] = 25192,
  [SMALL_STATE(511)] = 25206,
  [SMALL_STATE(512)] = 25220,
  [SMALL_STATE(513)] = 25236,
  [SMALL_STATE(514)] = 25250,
  [SMALL_STATE(515)] = 25264,
  [SMALL_STATE(516)] = 25278,
  [SMALL_STATE(517)] = 25292,
  [SMALL_STATE(518)] = 25306,
  [SMALL_STATE(519)] = 25320,
  [SMALL_STATE(520)] = 25332,
  [SMALL_STATE(521)] = 25348,
  [SMALL_STATE(522)] = 25362,
  [SMALL_STATE(523)] = 25376,
  [SMALL_STATE(524)] = 25392,
  [SMALL_STATE(525)] = 25406,
  [SMALL_STATE(526)] = 25420,
  [SMALL_STATE(527)] = 25434,
  [SMALL_STATE(528)] = 25446,
  [SMALL_STATE(529)] = 25460,
  [SMALL_STATE(530)] = 25474,
  [SMALL_STATE(531)] = 25488,
  [SMALL_STATE(532)] = 25502,
  [SMALL_STATE(533)] = 25514,
  [SMALL_STATE(534)] = 25526,
  [SMALL_STATE(535)] = 25538,
  [SMALL_STATE(536)] = 25552,
  [SMALL_STATE(537)] = 25564,
  [SMALL_STATE(538)] = 25576,
  [SMALL_STATE(539)] = 25588,
  [SMALL_STATE(540)] = 25600,
  [SMALL_STATE(541)] = 25614,
  [SMALL_STATE(542)] = 25628,
  [SMALL_STATE(543)] = 25642,
  [SMALL_STATE(544)] = 25654,
  [SMALL_STATE(545)] = 25666,
  [SMALL_STATE(546)] = 25680,
  [SMALL_STATE(547)] = 25694,
  [SMALL_STATE(548)] = 25708,
  [SMALL_STATE(549)] = 25720,
  [SMALL_STATE(550)] = 25732,
  [SMALL_STATE(551)] = 25746,
  [SMALL_STATE(552)] = 25759,
  [SMALL_STATE(553)] = 25770,
  [SMALL_STATE(554)] = 25781,
  [SMALL_STATE(555)] = 25790,
  [SMALL_STATE(556)] = 25801,
  [SMALL_STATE(557)] = 25810,
  [SMALL_STATE(558)] = 25821,
  [SMALL_STATE(559)] = 25832,
  [SMALL_STATE(560)] = 25841,
  [SMALL_STATE(561)] = 25850,
  [SMALL_STATE(562)] = 25859,
  [SMALL_STATE(563)] = 25872,
  [SMALL_STATE(564)] = 25885,
  [SMALL_STATE(565)] = 25894,
  [SMALL_STATE(566)] = 25907,
  [SMALL_STATE(567)] = 25918,
  [SMALL_STATE(568)] = 25927,
  [SMALL_STATE(569)] = 25938,
  [SMALL_STATE(570)] = 25947,
  [SMALL_STATE(571)] = 25960,
  [SMALL_STATE(572)] = 25973,
  [SMALL_STATE(573)] = 25984,
  [SMALL_STATE(574)] = 25995,
  [SMALL_STATE(575)] = 26006,
  [SMALL_STATE(576)] = 26017,
  [SMALL_STATE(577)] = 26028,
  [SMALL_STATE(578)] = 26041,
  [SMALL_STATE(579)] = 26052,
  [SMALL_STATE(580)] = 26063,
  [SMALL_STATE(581)] = 26076,
  [SMALL_STATE(582)] = 26087,
  [SMALL_STATE(583)] = 26096,
  [SMALL_STATE(584)] = 26107,
  [SMALL_STATE(585)] = 26116,
  [SMALL_STATE(586)] = 26125,
  [SMALL_STATE(587)] = 26135,
  [SMALL_STATE(588)] = 26145,
  [SMALL_STATE(589)] = 26153,
  [SMALL_STATE(590)] = 26161,
  [SMALL_STATE(591)] = 26171,
  [SMALL_STATE(592)] = 26181,
  [SMALL_STATE(593)] = 26191,
  [SMALL_STATE(594)] = 26199,
  [SMALL_STATE(595)] = 26207,
  [SMALL_STATE(596)] = 26215,
  [SMALL_STATE(597)] = 26225,
  [SMALL_STATE(598)] = 26235,
  [SMALL_STATE(599)] = 26245,
  [SMALL_STATE(600)] = 26253,
  [SMALL_STATE(601)] = 26261,
  [SMALL_STATE(602)] = 26269,
  [SMALL_STATE(603)] = 26279,
  [SMALL_STATE(604)] = 26287,
  [SMALL_STATE(605)] = 26297,
  [SMALL_STATE(606)] = 26305,
  [SMALL_STATE(607)] = 26313,
  [SMALL_STATE(608)] = 26323,
  [SMALL_STATE(609)] = 26333,
  [SMALL_STATE(610)] = 26343,
  [SMALL_STATE(611)] = 26351,
  [SMALL_STATE(612)] = 26361,
  [SMALL_STATE(613)] = 26371,
  [SMALL_STATE(614)] = 26379,
  [SMALL_STATE(615)] = 26389,
  [SMALL_STATE(616)] = 26399,
  [SMALL_STATE(617)] = 26409,
  [SMALL_STATE(618)] = 26419,
  [SMALL_STATE(619)] = 26429,
  [SMALL_STATE(620)] = 26437,
  [SMALL_STATE(621)] = 26445,
  [SMALL_STATE(622)] = 26455,
  [SMALL_STATE(623)] = 26465,
  [SMALL_STATE(624)] = 26475,
  [SMALL_STATE(625)] = 26485,
  [SMALL_STATE(626)] = 26493,
  [SMALL_STATE(627)] = 26501,
  [SMALL_STATE(628)] = 26511,
  [SMALL_STATE(629)] = 26519,
  [SMALL_STATE(630)] = 26527,
  [SMALL_STATE(631)] = 26537,
  [SMALL_STATE(632)] = 26545,
  [SMALL_STATE(633)] = 26555,
  [SMALL_STATE(634)] = 26563,
  [SMALL_STATE(635)] = 26573,
  [SMALL_STATE(636)] = 26581,
  [SMALL_STATE(637)] = 26591,
  [SMALL_STATE(638)] = 26601,
  [SMALL_STATE(639)] = 26611,
  [SMALL_STATE(640)] = 26619,
  [SMALL_STATE(641)] = 26629,
  [SMALL_STATE(642)] = 26637,
  [SMALL_STATE(643)] = 26645,
  [SMALL_STATE(644)] = 26655,
  [SMALL_STATE(645)] = 26663,
  [SMALL_STATE(646)] = 26673,
  [SMALL_STATE(647)] = 26681,
  [SMALL_STATE(648)] = 26691,
  [SMALL_STATE(649)] = 26699,
  [SMALL_STATE(650)] = 26709,
  [SMALL_STATE(651)] = 26719,
  [SMALL_STATE(652)] = 26729,
  [SMALL_STATE(653)] = 26739,
  [SMALL_STATE(654)] = 26747,
  [SMALL_STATE(655)] = 26755,
  [SMALL_STATE(656)] = 26763,
  [SMALL_STATE(657)] = 26771,
  [SMALL_STATE(658)] = 26781,
  [SMALL_STATE(659)] = 26789,
  [SMALL_STATE(660)] = 26797,
  [SMALL_STATE(661)] = 26805,
  [SMALL_STATE(662)] = 26815,
  [SMALL_STATE(663)] = 26825,
  [SMALL_STATE(664)] = 26833,
  [SMALL_STATE(665)] = 26841,
  [SMALL_STATE(666)] = 26849,
  [SMALL_STATE(667)] = 26857,
  [SMALL_STATE(668)] = 26865,
  [SMALL_STATE(669)] = 26873,
  [SMALL_STATE(670)] = 26883,
  [SMALL_STATE(671)] = 26893,
  [SMALL_STATE(672)] = 26903,
  [SMALL_STATE(673)] = 26913,
  [SMALL_STATE(674)] = 26921,
  [SMALL_STATE(675)] = 26931,
  [SMALL_STATE(676)] = 26941,
  [SMALL_STATE(677)] = 26951,
  [SMALL_STATE(678)] = 26959,
  [SMALL_STATE(679)] = 26967,
  [SMALL_STATE(680)] = 26977,
  [SMALL_STATE(681)] = 26985,
  [SMALL_STATE(682)] = 26995,
  [SMALL_STATE(683)] = 27005,
  [SMALL_STATE(684)] = 27015,
  [SMALL_STATE(685)] = 27023,
  [SMALL_STATE(686)] = 27031,
  [SMALL_STATE(687)] = 27039,
  [SMALL_STATE(688)] = 27049,
  [SMALL_STATE(689)] = 27059,
  [SMALL_STATE(690)] = 27069,
  [SMALL_STATE(691)] = 27079,
  [SMALL_STATE(692)] = 27087,
  [SMALL_STATE(693)] = 27097,
  [SMALL_STATE(694)] = 27107,
  [SMALL_STATE(695)] = 27117,
  [SMALL_STATE(696)] = 27127,
  [SMALL_STATE(697)] = 27137,
  [SMALL_STATE(698)] = 27147,
  [SMALL_STATE(699)] = 27155,
  [SMALL_STATE(700)] = 27165,
  [SMALL_STATE(701)] = 27173,
  [SMALL_STATE(702)] = 27183,
  [SMALL_STATE(703)] = 27193,
  [SMALL_STATE(704)] = 27203,
  [SMALL_STATE(705)] = 27210,
  [SMALL_STATE(706)] = 27217,
  [SMALL_STATE(707)] = 27224,
  [SMALL_STATE(708)] = 27231,
  [SMALL_STATE(709)] = 27238,
  [SMALL_STATE(710)] = 27245,
  [SMALL_STATE(711)] = 27252,
  [SMALL_STATE(712)] = 27259,
  [SMALL_STATE(713)] = 27266,
  [SMALL_STATE(714)] = 27273,
  [SMALL_STATE(715)] = 27280,
  [SMALL_STATE(716)] = 27287,
  [SMALL_STATE(717)] = 27294,
  [SMALL_STATE(718)] = 27301,
  [SMALL_STATE(719)] = 27308,
  [SMALL_STATE(720)] = 27315,
  [SMALL_STATE(721)] = 27322,
  [SMALL_STATE(722)] = 27329,
  [SMALL_STATE(723)] = 27336,
  [SMALL_STATE(724)] = 27343,
  [SMALL_STATE(725)] = 27350,
  [SMALL_STATE(726)] = 27357,
  [SMALL_STATE(727)] = 27364,
  [SMALL_STATE(728)] = 27371,
  [SMALL_STATE(729)] = 27378,
  [SMALL_STATE(730)] = 27385,
  [SMALL_STATE(731)] = 27392,
  [SMALL_STATE(732)] = 27399,
  [SMALL_STATE(733)] = 27406,
  [SMALL_STATE(734)] = 27413,
  [SMALL_STATE(735)] = 27420,
  [SMALL_STATE(736)] = 27427,
  [SMALL_STATE(737)] = 27434,
  [SMALL_STATE(738)] = 27441,
  [SMALL_STATE(739)] = 27448,
  [SMALL_STATE(740)] = 27455,
  [SMALL_STATE(741)] = 27462,
  [SMALL_STATE(742)] = 27469,
  [SMALL_STATE(743)] = 27476,
  [SMALL_STATE(744)] = 27483,
  [SMALL_STATE(745)] = 27490,
  [SMALL_STATE(746)] = 27497,
  [SMALL_STATE(747)] = 27504,
  [SMALL_STATE(748)] = 27511,
  [SMALL_STATE(749)] = 27518,
  [SMALL_STATE(750)] = 27525,
  [SMALL_STATE(751)] = 27532,
  [SMALL_STATE(752)] = 27539,
  [SMALL_STATE(753)] = 27546,
  [SMALL_STATE(754)] = 27553,
  [SMALL_STATE(755)] = 27560,
  [SMALL_STATE(756)] = 27567,
  [SMALL_STATE(757)] = 27574,
  [SMALL_STATE(758)] = 27581,
  [SMALL_STATE(759)] = 27588,
  [SMALL_STATE(760)] = 27595,
  [SMALL_STATE(761)] = 27602,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(757),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(750),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(745),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(621),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(750),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(724),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(704),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(731),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(718),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(687),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(47),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(715),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [85] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [87] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [89] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(563),
  [92] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(590),
  [95] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(197),
  [98] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(757),
  [101] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(750),
  [104] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(198),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(745),
  [110] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(512),
  [113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(621),
  [116] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(419),
  [119] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(6),
  [122] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(577),
  [125] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(38),
  [128] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(38),
  [131] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(77),
  [134] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(95),
  [137] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(750),
  [140] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(724),
  [143] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(704),
  [146] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(171),
  [149] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(731),
  [152] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(520),
  [155] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(523),
  [158] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(205),
  [161] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(34),
  [164] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(34),
  [167] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(718),
  [170] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(184),
  [173] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(10),
  [176] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(687),
  [179] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(36),
  [182] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(36),
  [185] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(37),
  [188] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(44),
  [191] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(47),
  [194] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(715),
  [197] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(44),
  [200] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(100),
  [203] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(524),
  [206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [216] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [218] = {.entry = {.count = 1, .reusable = false}}, SHIFT(41),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 2),
  [228] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 2),
  [230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 4),
  [232] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 4),
  [234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyconddot, 2),
  [236] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyconddot, 2),
  [238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 3),
  [240] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 3),
  [242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 4),
  [244] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 4),
  [246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 5),
  [250] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 5),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(673),
  [254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 5),
  [256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 5),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 3),
  [260] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 3),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyconddot, 1),
  [266] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyconddot, 1),
  [268] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 8),
  [270] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 8),
  [272] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 7),
  [274] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 7),
  [276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 6),
  [278] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 6),
  [280] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [284] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 2),
  [286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 10),
  [288] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 10),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 1),
  [292] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 1),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [296] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_STRING, 2),
  [298] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_STRING, 2),
  [300] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_STRING, 3),
  [302] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_STRING, 3),
  [304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_SUPREMUM, 1),
  [306] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_SUPREMUM, 1),
  [308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 2),
  [310] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 2),
  [312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dec, 1),
  [314] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dec, 1),
  [316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_NUMBER, 1),
  [318] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_NUMBER, 1),
  [320] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_INFIMUM, 1),
  [322] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_INFIMUM, 1),
  [324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 3),
  [326] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 3),
  [328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 4),
  [330] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 4),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(741),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [336] = {.entry = {.count = 1, .reusable = false}}, SHIFT(50),
  [338] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [346] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 1),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 1),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(712),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [366] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 2),
  [368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 2),
  [370] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 4),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 4),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 3),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 3),
  [378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunction, 2),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptcondition, 1),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [390] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element, 1),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 2),
  [394] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(293),
  [398] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 2),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [406] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conjunction, 2),
  [408] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizecond, 1),
  [410] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 1),
  [412] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelem, 1),
  [414] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 3),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(681),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 1),
  [422] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [428] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [434] = {.entry = {.count = 1, .reusable = false}}, SHIFT(253),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [440] = {.entry = {.count = 1, .reusable = false}}, SHIFT(200),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [446] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 3),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [450] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 2),
  [452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 1),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(735),
  [456] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 1),
  [458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(642),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [470] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [472] = {.entry = {.count = 1, .reusable = false}}, SHIFT(433),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [484] = {.entry = {.count = 1, .reusable = false}}, SHIFT(438),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [488] = {.entry = {.count = 1, .reusable = false}}, SHIFT(440),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [494] = {.entry = {.count = 1, .reusable = false}}, SHIFT(421),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(317),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [508] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 5),
  [510] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 5),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [514] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 2),
  [518] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 2),
  [520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 4),
  [522] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 4),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 3),
  [526] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 3),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [536] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [538] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [548] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [552] = {.entry = {.count = 1, .reusable = false}}, SHIFT(423),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [564] = {.entry = {.count = 1, .reusable = false}}, SHIFT(450),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [568] = {.entry = {.count = 1, .reusable = false}}, SHIFT(459),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [574] = {.entry = {.count = 1, .reusable = false}}, SHIFT(415),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(534),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(713),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [608] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 2),
  [610] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 2),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [620] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 3),
  [622] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 3),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [628] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 4),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 4),
  [632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [634] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuple, 2),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [638] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 3),
  [640] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 3),
  [642] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 4),
  [644] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 4),
  [646] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 2),
  [648] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 2),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [656] = {.entry = {.count = 1, .reusable = false}}, SHIFT(539),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [666] = {.entry = {.count = 1, .reusable = false}}, SHIFT(543),
  [668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [670] = {.entry = {.count = 1, .reusable = false}}, SHIFT(549),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [676] = {.entry = {.count = 1, .reusable = false}}, SHIFT(487),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [682] = {.entry = {.count = 1, .reusable = false}}, SHIFT(480),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [692] = {.entry = {.count = 1, .reusable = false}}, SHIFT(481),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [696] = {.entry = {.count = 1, .reusable = false}}, SHIFT(478),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [702] = {.entry = {.count = 1, .reusable = false}}, SHIFT(470),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(674),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [728] = {.entry = {.count = 1, .reusable = false}}, SHIFT(257),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [740] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 2),
  [742] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 2),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [752] = {.entry = {.count = 1, .reusable = false}}, SHIFT(210),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(733),
  [768] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 4),
  [770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 4),
  [772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(729),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cmp, 1),
  [780] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cmp, 1),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [784] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 4),
  [786] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 4),
  [788] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 2),
  [790] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 2),
  [792] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 3),
  [794] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 3),
  [796] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 5),
  [798] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 5),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dsym, 1),
  [802] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dsym, 1),
  [804] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 3),
  [806] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 3),
  [808] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 2),
  [810] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 2),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 1),
  [814] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 1),
  [816] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op, 1),
  [818] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op, 1),
  [820] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_rel, 1),
  [822] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_rel, 1),
  [824] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__widentifier, 2),
  [826] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__widentifier, 2),
  [828] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op_list, 2),
  [830] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op_list, 2),
  [832] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op_list, 1),
  [834] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op_list, 1),
  [836] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 5),
  [838] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 5),
  [840] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 3),
  [842] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 3),
  [844] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 4),
  [846] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 4),
  [848] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_add_term, 1),
  [850] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_add_term, 1),
  [852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(719),
  [856] = {.entry = {.count = 1, .reusable = false}}, SHIFT(564),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizeweight, 1),
  [862] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_add_term, 3),
  [864] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_add_term, 3),
  [866] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 1),
  [868] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 1),
  [870] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntermvec, 3),
  [872] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizeweight, 3),
  [874] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_literal, 3),
  [876] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_literal, 3),
  [878] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [880] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 2),
  [882] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 2),
  [884] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntermvec, 1),
  [886] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 3),
  [888] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 3),
  [890] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [892] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nupper, 2),
  [894] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nupper, 2),
  [896] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 4),
  [898] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 4),
  [900] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [902] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [904] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [906] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [908] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nupper, 1),
  [910] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nupper, 1),
  [912] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 1),
  [914] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 1),
  [916] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [918] = {.entry = {.count = 1, .reusable = false}}, SHIFT(318),
  [920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [924] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [926] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [928] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [930] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [934] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [936] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [940] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binaryargvec, 3),
  [942] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binaryargvec, 5),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [948] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [950] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unaryargvec, 1),
  [952] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unaryargvec, 3),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [958] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_consttermvec, 3),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [962] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_consttermvec, 1),
  [964] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [966] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [968] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [970] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [972] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [974] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm_nlist, 1),
  [976] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm_nlist, 1),
  [978] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm_nlist, 3),
  [980] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm_nlist, 3),
  [982] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [986] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 2),
  [988] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 2),
  [990] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 6),
  [992] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 6),
  [994] = {.entry = {.count = 1, .reusable = false}}, SHIFT(59),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [998] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_head, 1),
  [1000] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 1),
  [1002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [1004] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 7),
  [1006] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 7),
  [1008] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 1),
  [1010] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1012] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 5),
  [1014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1018] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 3),
  [1020] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nlitvec, 3),
  [1022] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 3),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [1026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [1028] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 5),
  [1030] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 5),
  [1032] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 3),
  [1034] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 5),
  [1036] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 3),
  [1038] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 3),
  [1040] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 1),
  [1042] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 1),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1046] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 3),
  [1048] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 4),
  [1050] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 1),
  [1052] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 3),
  [1054] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 2),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1058] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 4),
  [1060] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 2),
  [1062] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 2),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [1066] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunction, 3),
  [1068] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nlitvec, 1),
  [1070] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 1),
  [1072] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 4),
  [1074] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 4),
  [1076] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 1),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [1080] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 2),
  [1082] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptcondition, 2),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(644),
  [1086] = {.entry = {.count = 1, .reusable = true}}, SHIFT(759),
  [1088] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 2),
  [1090] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 4),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [1096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [1098] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 5),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [1102] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 2),
  [1104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [1106] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 3),
  [1108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [1110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(748),
  [1112] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 2),
  [1114] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizetuple, 2),
  [1116] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 2),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [1120] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [1122] = {.entry = {.count = 1, .reusable = false}}, SHIFT(496),
  [1124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [1126] = {.entry = {.count = 1, .reusable = false}}, SHIFT(499),
  [1128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [1130] = {.entry = {.count = 1, .reusable = false}}, SHIFT(544),
  [1132] = {.entry = {.count = 1, .reusable = false}}, SHIFT(504),
  [1134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [1136] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelem, 1),
  [1138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(640),
  [1140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [1142] = {.entry = {.count = 1, .reusable = false}}, SHIFT(426),
  [1144] = {.entry = {.count = 1, .reusable = false}}, SHIFT(463),
  [1146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [1148] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 2),
  [1150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 3),
  [1152] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [1154] = {.entry = {.count = 1, .reusable = false}}, SHIFT(449),
  [1156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(604),
  [1158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [1164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1166] = {.entry = {.count = 1, .reusable = false}}, SHIFT(468),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [1170] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [1176] = {.entry = {.count = 1, .reusable = false}}, SHIFT(247),
  [1178] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_STRING_repeat1, 2),
  [1180] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_STRING_repeat1, 2), SHIFT_REPEAT(528),
  [1183] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 5),
  [1185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [1189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 2),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 4),
  [1197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 3),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [1201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 1),
  [1203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 4),
  [1205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 4),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conjunction, 3),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 6),
  [1221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizelitvec, 3),
  [1223] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 4),
  [1225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 3),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_identifier, 1),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(646),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1239] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuple, 1),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [1243] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argvec, 1),
  [1245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argvec, 3),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(734),
  [1253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1255] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element, 2),
  [1257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [1259] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizecond, 2),
  [1261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizelitvec, 1),
  [1263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelem, 2),
  [1265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 4),
  [1267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 5),
  [1269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [1273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition, 5),
  [1277] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element_nlist, 3),
  [1279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [1283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [1285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [1287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [1291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(758),
  [1293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_type, 1),
  [1295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 8),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(625),
  [1299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 4),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [1305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 3),
  [1307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [1311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [1313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [1317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nconstargvec, 1),
  [1319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [1321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_nlist, 1),
  [1323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(727),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(723),
  [1327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [1329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(730),
  [1331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition, 7),
  [1333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 4),
  [1337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [1339] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nidlist, 3),
  [1341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_nlist, 1),
  [1343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [1345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuplevec, 1),
  [1347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 1),
  [1349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [1351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelemvec, 3),
  [1353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(754),
  [1355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(751),
  [1357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term_definition, 3),
  [1359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nidlist, 1),
  [1363] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition_nlist, 1),
  [1365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(666),
  [1367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(535),
  [1369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [1371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [1373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [1375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_nlist, 3),
  [1377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [1379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 6),
  [1381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition_nlist, 3),
  [1383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelemvec, 1),
  [1389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 13),
  [1391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 2),
  [1393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term_definition, 4),
  [1395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelem, 2),
  [1397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(610),
  [1401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [1403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(726),
  [1405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [1411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element_nlist, 1),
  [1413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [1415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [1417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [1419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 5),
  [1425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 5),
  [1427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(744),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [1431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [1433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuplevec, 2),
  [1435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [1437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [1439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [1441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1447] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 6),
  [1449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1451] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 14),
  [1453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1457] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_MINIMIZE, 1),
  [1459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [1461] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_nlist, 3),
  [1463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [1465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [1467] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(740),
  [1471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [1473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [1475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [1477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(742),
  [1479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [1481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [1485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [1487] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_MAXIMIZE, 1),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [1491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(749),
  [1493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [1495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [1497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [1499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [1501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(722),
  [1503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [1505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [1509] = {.entry = {.count = 1, .reusable = false}}, SHIFT(751),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(711),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [1517] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_identifier, 1),
  [1519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [1525] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_aggregatefunction, 1),
  [1527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(635),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(752),
  [1537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_clingo(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
