#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 704
#define LARGE_STATE_COUNT 4
#define SYMBOL_COUNT 169
#define ALIAS_COUNT 0
#define TOKEN_COUNT 94
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 14
#define PRODUCTION_ID_COUNT 1

enum {
  sym_comment = 1,
  sym_ADD = 2,
  sym_AND = 3,
  sym_EQ = 4,
  sym_AT = 5,
  sym_BNOT = 6,
  sym_COLON = 7,
  sym_COMMA = 8,
  sym_CONST = 9,
  sym_COUNT = 10,
  sym_CSP = 11,
  sym_CSP_ADD = 12,
  sym_CSP_SUB = 13,
  sym_CSP_MUL = 14,
  sym_CSP_LEQ = 15,
  sym_CSP_LT = 16,
  sym_CSP_GT = 17,
  sym_CSP_GEQ = 18,
  sym_CSP_EQ = 19,
  sym_CSP_NEQ = 20,
  sym_DISJOINT = 21,
  sym_DOT = 22,
  sym_DOTS = 23,
  sym_EXTERNAL = 24,
  sym_DEFINED = 25,
  sym_FALSE = 26,
  sym_GEQ = 27,
  sym_GT = 28,
  sym_IF = 29,
  sym_INCLUDE = 30,
  sym_INFIMUM = 31,
  sym_LBRACE = 32,
  sym_LBRACK = 33,
  sym_LEQ = 34,
  sym_LPAREN = 35,
  sym_LT = 36,
  sym_MAX = 37,
  sym_MAXIMIZE = 38,
  sym_MIN = 39,
  sym_MINIMIZE = 40,
  sym_MOD = 41,
  sym_MUL = 42,
  sym_NEQ = 43,
  sym_POW = 44,
  sym_QUESTION = 45,
  sym_RBRACE = 46,
  sym_RBRACK = 47,
  sym_RPAREN = 48,
  sym_SEM = 49,
  sym_SHOW = 50,
  sym_EDGE = 51,
  sym_PROJECT = 52,
  sym_HEURISTIC = 53,
  sym_SHOWSIG = 54,
  sym_SLASH = 55,
  sym_SUB = 56,
  sym_SUM = 57,
  sym_SUMP = 58,
  sym_SUPREMUM = 59,
  sym_TRUE = 60,
  sym_BLOCK = 61,
  sym_VBAR = 62,
  sym_WIF = 63,
  sym_XOR = 64,
  sym_ANY = 65,
  sym_UNARY = 66,
  sym_BINARY = 67,
  sym_LEFT = 68,
  sym_RIGHT = 69,
  sym_HEAD = 70,
  sym_BODY = 71,
  sym_DIRECTIVE = 72,
  sym_THEORY = 73,
  anon_sym_0 = 74,
  aux_sym_dec_token1 = 75,
  sym_hex = 76,
  sym_oct = 77,
  sym_bin = 78,
  sym_ANONYMOUS = 79,
  sym_identifier = 80,
  anon_sym_LPAREN = 81,
  sym_SCRIPT = 82,
  sym_CODE = 83,
  sym_VARIABLE = 84,
  sym_THEORY_OP = 85,
  sym_NOT = 86,
  sym_DEFAULT = 87,
  sym_OVERRIDE = 88,
  anon_sym_BSLASH_BSLASH = 89,
  anon_sym_EQ_EQ = 90,
  anon_sym_DQUOTE = 91,
  sym_unescaped_double_string_fragment = 92,
  sym_escape_sequence = 93,
  sym_source_file = 94,
  sym_NUMBER = 95,
  sym_dec = 96,
  sym__widentifier = 97,
  sym_constterm = 98,
  sym_consttermvec = 99,
  sym_nconstargvec = 100,
  sym_term = 101,
  sym_unaryargvec = 102,
  sym_ntermvec = 103,
  sym_ntuple = 104,
  sym_tuplevec_sem = 105,
  sym_ntuplevec = 106,
  sym_argvec = 107,
  sym_binaryargvec = 108,
  sym_cmp = 109,
  sym_atom = 110,
  sym_literal = 111,
  sym_csp_mul_term = 112,
  sym_csp_add_term = 113,
  sym_csp_rel = 114,
  sym_csp_literal = 115,
  sym_nlitvec = 116,
  sym_noptcondition = 117,
  sym_aggregatefunction = 118,
  sym_bodyaggrelem = 119,
  sym_bodyaggrelemvec = 120,
  sym_altbodyaggrelem = 121,
  sym_altbodyaggrelemvec = 122,
  sym_bodyaggregate = 123,
  sym_nupper = 124,
  sym_lubodyaggregate = 125,
  sym_headaggrelemvec = 126,
  sym_altheadaggrelemvec = 127,
  sym_headaggregate = 128,
  sym_luheadaggregate = 129,
  sym_ncspelemvec = 130,
  sym_disjoint = 131,
  sym_conjunction = 132,
  sym_dsym = 133,
  sym_disjunctionsep = 134,
  sym_disjunction = 135,
  sym_nbodycomma = 136,
  sym_bodydot = 137,
  sym_bodyconddot = 138,
  sym_head = 139,
  sym_statement = 140,
  sym_noptimizetuple = 141,
  sym_optimizeweight = 142,
  sym_optimizelitvec = 143,
  sym_noptimizecond = 144,
  sym_maxelemlist = 145,
  sym_minelemlist = 146,
  sym_nidlist = 147,
  sym_theory_identifier = 148,
  sym_theory_op = 149,
  sym_theory_op_list = 150,
  sym_theory_term = 151,
  sym_theory_opterm = 152,
  sym_theory_opterm_nlist = 153,
  sym_theory_atom_element = 154,
  sym_theory_atom_element_nlist = 155,
  sym_theory_atom_name = 156,
  sym_theory_atom = 157,
  sym_theory_operator_nlist = 158,
  sym_theory_operator_definition = 159,
  sym_theory_operator_definition_nlist = 160,
  sym_theory_definition_identifier = 161,
  sym_theory_term_definition = 162,
  sym_theory_atom_type = 163,
  sym_theory_atom_definition = 164,
  sym_theory_definition_nlist = 165,
  sym_STRING = 166,
  aux_sym_source_file_repeat1 = 167,
  aux_sym_STRING_repeat1 = 168,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_comment] = "comment",
  [sym_ADD] = "ADD",
  [sym_AND] = "AND",
  [sym_EQ] = "EQ",
  [sym_AT] = "AT",
  [sym_BNOT] = "BNOT",
  [sym_COLON] = "COLON",
  [sym_COMMA] = "COMMA",
  [sym_CONST] = "CONST",
  [sym_COUNT] = "COUNT",
  [sym_CSP] = "CSP",
  [sym_CSP_ADD] = "CSP_ADD",
  [sym_CSP_SUB] = "CSP_SUB",
  [sym_CSP_MUL] = "CSP_MUL",
  [sym_CSP_LEQ] = "CSP_LEQ",
  [sym_CSP_LT] = "CSP_LT",
  [sym_CSP_GT] = "CSP_GT",
  [sym_CSP_GEQ] = "CSP_GEQ",
  [sym_CSP_EQ] = "CSP_EQ",
  [sym_CSP_NEQ] = "CSP_NEQ",
  [sym_DISJOINT] = "DISJOINT",
  [sym_DOT] = "DOT",
  [sym_DOTS] = "DOTS",
  [sym_EXTERNAL] = "EXTERNAL",
  [sym_DEFINED] = "DEFINED",
  [sym_FALSE] = "FALSE",
  [sym_GEQ] = "GEQ",
  [sym_GT] = "GT",
  [sym_IF] = "IF",
  [sym_INCLUDE] = "INCLUDE",
  [sym_INFIMUM] = "INFIMUM",
  [sym_LBRACE] = "LBRACE",
  [sym_LBRACK] = "LBRACK",
  [sym_LEQ] = "LEQ",
  [sym_LPAREN] = "LPAREN",
  [sym_LT] = "LT",
  [sym_MAX] = "MAX",
  [sym_MAXIMIZE] = "MAXIMIZE",
  [sym_MIN] = "MIN",
  [sym_MINIMIZE] = "MINIMIZE",
  [sym_MOD] = "MOD",
  [sym_MUL] = "MUL",
  [sym_NEQ] = "NEQ",
  [sym_POW] = "POW",
  [sym_QUESTION] = "QUESTION",
  [sym_RBRACE] = "RBRACE",
  [sym_RBRACK] = "RBRACK",
  [sym_RPAREN] = "RPAREN",
  [sym_SEM] = "SEM",
  [sym_SHOW] = "SHOW",
  [sym_EDGE] = "EDGE",
  [sym_PROJECT] = "PROJECT",
  [sym_HEURISTIC] = "HEURISTIC",
  [sym_SHOWSIG] = "SHOWSIG",
  [sym_SLASH] = "SLASH",
  [sym_SUB] = "SUB",
  [sym_SUM] = "SUM",
  [sym_SUMP] = "SUMP",
  [sym_SUPREMUM] = "SUPREMUM",
  [sym_TRUE] = "TRUE",
  [sym_BLOCK] = "BLOCK",
  [sym_VBAR] = "VBAR",
  [sym_WIF] = "WIF",
  [sym_XOR] = "XOR",
  [sym_ANY] = "ANY",
  [sym_UNARY] = "UNARY",
  [sym_BINARY] = "BINARY",
  [sym_LEFT] = "LEFT",
  [sym_RIGHT] = "RIGHT",
  [sym_HEAD] = "HEAD",
  [sym_BODY] = "BODY",
  [sym_DIRECTIVE] = "DIRECTIVE",
  [sym_THEORY] = "THEORY",
  [anon_sym_0] = "0",
  [aux_sym_dec_token1] = "dec_token1",
  [sym_hex] = "hex",
  [sym_oct] = "oct",
  [sym_bin] = "bin",
  [sym_ANONYMOUS] = "ANONYMOUS",
  [sym_identifier] = "identifier",
  [anon_sym_LPAREN] = "LPAREN",
  [sym_SCRIPT] = "SCRIPT",
  [sym_CODE] = "CODE",
  [sym_VARIABLE] = "VARIABLE",
  [sym_THEORY_OP] = "THEORY_OP",
  [sym_NOT] = "NOT",
  [sym_DEFAULT] = "DEFAULT",
  [sym_OVERRIDE] = "OVERRIDE",
  [anon_sym_BSLASH_BSLASH] = "\\\\",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_DQUOTE] = "\"",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_source_file] = "source_file",
  [sym_NUMBER] = "NUMBER",
  [sym_dec] = "dec",
  [sym__widentifier] = "_widentifier",
  [sym_constterm] = "constterm",
  [sym_consttermvec] = "consttermvec",
  [sym_nconstargvec] = "nconstargvec",
  [sym_term] = "term",
  [sym_unaryargvec] = "unaryargvec",
  [sym_ntermvec] = "ntermvec",
  [sym_ntuple] = "ntuple",
  [sym_tuplevec_sem] = "tuplevec_sem",
  [sym_ntuplevec] = "ntuplevec",
  [sym_argvec] = "argvec",
  [sym_binaryargvec] = "binaryargvec",
  [sym_cmp] = "cmp",
  [sym_atom] = "atom",
  [sym_literal] = "literal",
  [sym_csp_mul_term] = "csp_mul_term",
  [sym_csp_add_term] = "csp_add_term",
  [sym_csp_rel] = "csp_rel",
  [sym_csp_literal] = "csp_literal",
  [sym_nlitvec] = "nlitvec",
  [sym_noptcondition] = "noptcondition",
  [sym_aggregatefunction] = "aggregatefunction",
  [sym_bodyaggrelem] = "bodyaggrelem",
  [sym_bodyaggrelemvec] = "bodyaggrelemvec",
  [sym_altbodyaggrelem] = "altbodyaggrelem",
  [sym_altbodyaggrelemvec] = "altbodyaggrelemvec",
  [sym_bodyaggregate] = "bodyaggregate",
  [sym_nupper] = "nupper",
  [sym_lubodyaggregate] = "lubodyaggregate",
  [sym_headaggrelemvec] = "headaggrelemvec",
  [sym_altheadaggrelemvec] = "altheadaggrelemvec",
  [sym_headaggregate] = "headaggregate",
  [sym_luheadaggregate] = "luheadaggregate",
  [sym_ncspelemvec] = "ncspelemvec",
  [sym_disjoint] = "disjoint",
  [sym_conjunction] = "conjunction",
  [sym_dsym] = "dsym",
  [sym_disjunctionsep] = "disjunctionsep",
  [sym_disjunction] = "disjunction",
  [sym_nbodycomma] = "nbodycomma",
  [sym_bodydot] = "bodydot",
  [sym_bodyconddot] = "bodyconddot",
  [sym_head] = "head",
  [sym_statement] = "statement",
  [sym_noptimizetuple] = "noptimizetuple",
  [sym_optimizeweight] = "optimizeweight",
  [sym_optimizelitvec] = "optimizelitvec",
  [sym_noptimizecond] = "noptimizecond",
  [sym_maxelemlist] = "maxelemlist",
  [sym_minelemlist] = "minelemlist",
  [sym_nidlist] = "nidlist",
  [sym_theory_identifier] = "theory_identifier",
  [sym_theory_op] = "theory_op",
  [sym_theory_op_list] = "theory_op_list",
  [sym_theory_term] = "theory_term",
  [sym_theory_opterm] = "theory_opterm",
  [sym_theory_opterm_nlist] = "theory_opterm_nlist",
  [sym_theory_atom_element] = "theory_atom_element",
  [sym_theory_atom_element_nlist] = "theory_atom_element_nlist",
  [sym_theory_atom_name] = "theory_atom_name",
  [sym_theory_atom] = "theory_atom",
  [sym_theory_operator_nlist] = "theory_operator_nlist",
  [sym_theory_operator_definition] = "theory_operator_definition",
  [sym_theory_operator_definition_nlist] = "theory_operator_definition_nlist",
  [sym_theory_definition_identifier] = "theory_definition_identifier",
  [sym_theory_term_definition] = "theory_term_definition",
  [sym_theory_atom_type] = "theory_atom_type",
  [sym_theory_atom_definition] = "theory_atom_definition",
  [sym_theory_definition_nlist] = "theory_definition_nlist",
  [sym_STRING] = "STRING",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_STRING_repeat1] = "STRING_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_comment] = sym_comment,
  [sym_ADD] = sym_ADD,
  [sym_AND] = sym_AND,
  [sym_EQ] = sym_EQ,
  [sym_AT] = sym_AT,
  [sym_BNOT] = sym_BNOT,
  [sym_COLON] = sym_COLON,
  [sym_COMMA] = sym_COMMA,
  [sym_CONST] = sym_CONST,
  [sym_COUNT] = sym_COUNT,
  [sym_CSP] = sym_CSP,
  [sym_CSP_ADD] = sym_CSP_ADD,
  [sym_CSP_SUB] = sym_CSP_SUB,
  [sym_CSP_MUL] = sym_CSP_MUL,
  [sym_CSP_LEQ] = sym_CSP_LEQ,
  [sym_CSP_LT] = sym_CSP_LT,
  [sym_CSP_GT] = sym_CSP_GT,
  [sym_CSP_GEQ] = sym_CSP_GEQ,
  [sym_CSP_EQ] = sym_CSP_EQ,
  [sym_CSP_NEQ] = sym_CSP_NEQ,
  [sym_DISJOINT] = sym_DISJOINT,
  [sym_DOT] = sym_DOT,
  [sym_DOTS] = sym_DOTS,
  [sym_EXTERNAL] = sym_EXTERNAL,
  [sym_DEFINED] = sym_DEFINED,
  [sym_FALSE] = sym_FALSE,
  [sym_GEQ] = sym_GEQ,
  [sym_GT] = sym_GT,
  [sym_IF] = sym_IF,
  [sym_INCLUDE] = sym_INCLUDE,
  [sym_INFIMUM] = sym_INFIMUM,
  [sym_LBRACE] = sym_LBRACE,
  [sym_LBRACK] = sym_LBRACK,
  [sym_LEQ] = sym_LEQ,
  [sym_LPAREN] = sym_LPAREN,
  [sym_LT] = sym_LT,
  [sym_MAX] = sym_MAX,
  [sym_MAXIMIZE] = sym_MAXIMIZE,
  [sym_MIN] = sym_MIN,
  [sym_MINIMIZE] = sym_MINIMIZE,
  [sym_MOD] = sym_MOD,
  [sym_MUL] = sym_MUL,
  [sym_NEQ] = sym_NEQ,
  [sym_POW] = sym_POW,
  [sym_QUESTION] = sym_QUESTION,
  [sym_RBRACE] = sym_RBRACE,
  [sym_RBRACK] = sym_RBRACK,
  [sym_RPAREN] = sym_RPAREN,
  [sym_SEM] = sym_SEM,
  [sym_SHOW] = sym_SHOW,
  [sym_EDGE] = sym_EDGE,
  [sym_PROJECT] = sym_PROJECT,
  [sym_HEURISTIC] = sym_HEURISTIC,
  [sym_SHOWSIG] = sym_SHOWSIG,
  [sym_SLASH] = sym_SLASH,
  [sym_SUB] = sym_SUB,
  [sym_SUM] = sym_SUM,
  [sym_SUMP] = sym_SUMP,
  [sym_SUPREMUM] = sym_SUPREMUM,
  [sym_TRUE] = sym_TRUE,
  [sym_BLOCK] = sym_BLOCK,
  [sym_VBAR] = sym_VBAR,
  [sym_WIF] = sym_WIF,
  [sym_XOR] = sym_XOR,
  [sym_ANY] = sym_ANY,
  [sym_UNARY] = sym_UNARY,
  [sym_BINARY] = sym_BINARY,
  [sym_LEFT] = sym_LEFT,
  [sym_RIGHT] = sym_RIGHT,
  [sym_HEAD] = sym_HEAD,
  [sym_BODY] = sym_BODY,
  [sym_DIRECTIVE] = sym_DIRECTIVE,
  [sym_THEORY] = sym_THEORY,
  [anon_sym_0] = anon_sym_0,
  [aux_sym_dec_token1] = aux_sym_dec_token1,
  [sym_hex] = sym_hex,
  [sym_oct] = sym_oct,
  [sym_bin] = sym_bin,
  [sym_ANONYMOUS] = sym_ANONYMOUS,
  [sym_identifier] = sym_identifier,
  [anon_sym_LPAREN] = sym_LPAREN,
  [sym_SCRIPT] = sym_SCRIPT,
  [sym_CODE] = sym_CODE,
  [sym_VARIABLE] = sym_VARIABLE,
  [sym_THEORY_OP] = sym_THEORY_OP,
  [sym_NOT] = sym_NOT,
  [sym_DEFAULT] = sym_DEFAULT,
  [sym_OVERRIDE] = sym_OVERRIDE,
  [anon_sym_BSLASH_BSLASH] = anon_sym_BSLASH_BSLASH,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_source_file] = sym_source_file,
  [sym_NUMBER] = sym_NUMBER,
  [sym_dec] = sym_dec,
  [sym__widentifier] = sym__widentifier,
  [sym_constterm] = sym_constterm,
  [sym_consttermvec] = sym_consttermvec,
  [sym_nconstargvec] = sym_nconstargvec,
  [sym_term] = sym_term,
  [sym_unaryargvec] = sym_unaryargvec,
  [sym_ntermvec] = sym_ntermvec,
  [sym_ntuple] = sym_ntuple,
  [sym_tuplevec_sem] = sym_tuplevec_sem,
  [sym_ntuplevec] = sym_ntuplevec,
  [sym_argvec] = sym_argvec,
  [sym_binaryargvec] = sym_binaryargvec,
  [sym_cmp] = sym_cmp,
  [sym_atom] = sym_atom,
  [sym_literal] = sym_literal,
  [sym_csp_mul_term] = sym_csp_mul_term,
  [sym_csp_add_term] = sym_csp_add_term,
  [sym_csp_rel] = sym_csp_rel,
  [sym_csp_literal] = sym_csp_literal,
  [sym_nlitvec] = sym_nlitvec,
  [sym_noptcondition] = sym_noptcondition,
  [sym_aggregatefunction] = sym_aggregatefunction,
  [sym_bodyaggrelem] = sym_bodyaggrelem,
  [sym_bodyaggrelemvec] = sym_bodyaggrelemvec,
  [sym_altbodyaggrelem] = sym_altbodyaggrelem,
  [sym_altbodyaggrelemvec] = sym_altbodyaggrelemvec,
  [sym_bodyaggregate] = sym_bodyaggregate,
  [sym_nupper] = sym_nupper,
  [sym_lubodyaggregate] = sym_lubodyaggregate,
  [sym_headaggrelemvec] = sym_headaggrelemvec,
  [sym_altheadaggrelemvec] = sym_altheadaggrelemvec,
  [sym_headaggregate] = sym_headaggregate,
  [sym_luheadaggregate] = sym_luheadaggregate,
  [sym_ncspelemvec] = sym_ncspelemvec,
  [sym_disjoint] = sym_disjoint,
  [sym_conjunction] = sym_conjunction,
  [sym_dsym] = sym_dsym,
  [sym_disjunctionsep] = sym_disjunctionsep,
  [sym_disjunction] = sym_disjunction,
  [sym_nbodycomma] = sym_nbodycomma,
  [sym_bodydot] = sym_bodydot,
  [sym_bodyconddot] = sym_bodyconddot,
  [sym_head] = sym_head,
  [sym_statement] = sym_statement,
  [sym_noptimizetuple] = sym_noptimizetuple,
  [sym_optimizeweight] = sym_optimizeweight,
  [sym_optimizelitvec] = sym_optimizelitvec,
  [sym_noptimizecond] = sym_noptimizecond,
  [sym_maxelemlist] = sym_maxelemlist,
  [sym_minelemlist] = sym_minelemlist,
  [sym_nidlist] = sym_nidlist,
  [sym_theory_identifier] = sym_theory_identifier,
  [sym_theory_op] = sym_theory_op,
  [sym_theory_op_list] = sym_theory_op_list,
  [sym_theory_term] = sym_theory_term,
  [sym_theory_opterm] = sym_theory_opterm,
  [sym_theory_opterm_nlist] = sym_theory_opterm_nlist,
  [sym_theory_atom_element] = sym_theory_atom_element,
  [sym_theory_atom_element_nlist] = sym_theory_atom_element_nlist,
  [sym_theory_atom_name] = sym_theory_atom_name,
  [sym_theory_atom] = sym_theory_atom,
  [sym_theory_operator_nlist] = sym_theory_operator_nlist,
  [sym_theory_operator_definition] = sym_theory_operator_definition,
  [sym_theory_operator_definition_nlist] = sym_theory_operator_definition_nlist,
  [sym_theory_definition_identifier] = sym_theory_definition_identifier,
  [sym_theory_term_definition] = sym_theory_term_definition,
  [sym_theory_atom_type] = sym_theory_atom_type,
  [sym_theory_atom_definition] = sym_theory_atom_definition,
  [sym_theory_definition_nlist] = sym_theory_definition_nlist,
  [sym_STRING] = sym_STRING,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_STRING_repeat1] = aux_sym_STRING_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_ADD] = {
    .visible = true,
    .named = true,
  },
  [sym_AND] = {
    .visible = true,
    .named = true,
  },
  [sym_EQ] = {
    .visible = true,
    .named = true,
  },
  [sym_AT] = {
    .visible = true,
    .named = true,
  },
  [sym_BNOT] = {
    .visible = true,
    .named = true,
  },
  [sym_COLON] = {
    .visible = true,
    .named = true,
  },
  [sym_COMMA] = {
    .visible = true,
    .named = true,
  },
  [sym_CONST] = {
    .visible = true,
    .named = true,
  },
  [sym_COUNT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_ADD] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_SUB] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_MUL] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_LEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_LT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_GT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_GEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_EQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_NEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_DISJOINT] = {
    .visible = true,
    .named = true,
  },
  [sym_DOT] = {
    .visible = true,
    .named = true,
  },
  [sym_DOTS] = {
    .visible = true,
    .named = true,
  },
  [sym_EXTERNAL] = {
    .visible = true,
    .named = true,
  },
  [sym_DEFINED] = {
    .visible = true,
    .named = true,
  },
  [sym_FALSE] = {
    .visible = true,
    .named = true,
  },
  [sym_GEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_GT] = {
    .visible = true,
    .named = true,
  },
  [sym_IF] = {
    .visible = true,
    .named = true,
  },
  [sym_INCLUDE] = {
    .visible = true,
    .named = true,
  },
  [sym_INFIMUM] = {
    .visible = true,
    .named = true,
  },
  [sym_LBRACE] = {
    .visible = true,
    .named = true,
  },
  [sym_LBRACK] = {
    .visible = true,
    .named = true,
  },
  [sym_LEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_LPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_LT] = {
    .visible = true,
    .named = true,
  },
  [sym_MAX] = {
    .visible = true,
    .named = true,
  },
  [sym_MAXIMIZE] = {
    .visible = true,
    .named = true,
  },
  [sym_MIN] = {
    .visible = true,
    .named = true,
  },
  [sym_MINIMIZE] = {
    .visible = true,
    .named = true,
  },
  [sym_MOD] = {
    .visible = true,
    .named = true,
  },
  [sym_MUL] = {
    .visible = true,
    .named = true,
  },
  [sym_NEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_POW] = {
    .visible = true,
    .named = true,
  },
  [sym_QUESTION] = {
    .visible = true,
    .named = true,
  },
  [sym_RBRACE] = {
    .visible = true,
    .named = true,
  },
  [sym_RBRACK] = {
    .visible = true,
    .named = true,
  },
  [sym_RPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_SEM] = {
    .visible = true,
    .named = true,
  },
  [sym_SHOW] = {
    .visible = true,
    .named = true,
  },
  [sym_EDGE] = {
    .visible = true,
    .named = true,
  },
  [sym_PROJECT] = {
    .visible = true,
    .named = true,
  },
  [sym_HEURISTIC] = {
    .visible = true,
    .named = true,
  },
  [sym_SHOWSIG] = {
    .visible = true,
    .named = true,
  },
  [sym_SLASH] = {
    .visible = true,
    .named = true,
  },
  [sym_SUB] = {
    .visible = true,
    .named = true,
  },
  [sym_SUM] = {
    .visible = true,
    .named = true,
  },
  [sym_SUMP] = {
    .visible = true,
    .named = true,
  },
  [sym_SUPREMUM] = {
    .visible = true,
    .named = true,
  },
  [sym_TRUE] = {
    .visible = true,
    .named = true,
  },
  [sym_BLOCK] = {
    .visible = true,
    .named = true,
  },
  [sym_VBAR] = {
    .visible = true,
    .named = true,
  },
  [sym_WIF] = {
    .visible = true,
    .named = true,
  },
  [sym_XOR] = {
    .visible = true,
    .named = true,
  },
  [sym_ANY] = {
    .visible = true,
    .named = true,
  },
  [sym_UNARY] = {
    .visible = true,
    .named = true,
  },
  [sym_BINARY] = {
    .visible = true,
    .named = true,
  },
  [sym_LEFT] = {
    .visible = true,
    .named = true,
  },
  [sym_RIGHT] = {
    .visible = true,
    .named = true,
  },
  [sym_HEAD] = {
    .visible = true,
    .named = true,
  },
  [sym_BODY] = {
    .visible = true,
    .named = true,
  },
  [sym_DIRECTIVE] = {
    .visible = true,
    .named = true,
  },
  [sym_THEORY] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_dec_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_hex] = {
    .visible = true,
    .named = true,
  },
  [sym_oct] = {
    .visible = true,
    .named = true,
  },
  [sym_bin] = {
    .visible = true,
    .named = true,
  },
  [sym_ANONYMOUS] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_SCRIPT] = {
    .visible = true,
    .named = true,
  },
  [sym_CODE] = {
    .visible = true,
    .named = true,
  },
  [sym_VARIABLE] = {
    .visible = true,
    .named = true,
  },
  [sym_THEORY_OP] = {
    .visible = true,
    .named = true,
  },
  [sym_NOT] = {
    .visible = true,
    .named = true,
  },
  [sym_DEFAULT] = {
    .visible = true,
    .named = true,
  },
  [sym_OVERRIDE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_NUMBER] = {
    .visible = true,
    .named = true,
  },
  [sym_dec] = {
    .visible = true,
    .named = true,
  },
  [sym__widentifier] = {
    .visible = false,
    .named = true,
  },
  [sym_constterm] = {
    .visible = true,
    .named = true,
  },
  [sym_consttermvec] = {
    .visible = true,
    .named = true,
  },
  [sym_nconstargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_term] = {
    .visible = true,
    .named = true,
  },
  [sym_unaryargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_ntermvec] = {
    .visible = true,
    .named = true,
  },
  [sym_ntuple] = {
    .visible = true,
    .named = true,
  },
  [sym_tuplevec_sem] = {
    .visible = true,
    .named = true,
  },
  [sym_ntuplevec] = {
    .visible = true,
    .named = true,
  },
  [sym_argvec] = {
    .visible = true,
    .named = true,
  },
  [sym_binaryargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_cmp] = {
    .visible = true,
    .named = true,
  },
  [sym_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_mul_term] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_add_term] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_rel] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_nlitvec] = {
    .visible = true,
    .named = true,
  },
  [sym_noptcondition] = {
    .visible = true,
    .named = true,
  },
  [sym_aggregatefunction] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggrelem] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_altbodyaggrelem] = {
    .visible = true,
    .named = true,
  },
  [sym_altbodyaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_nupper] = {
    .visible = true,
    .named = true,
  },
  [sym_lubodyaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_headaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_altheadaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_headaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_luheadaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_ncspelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_disjoint] = {
    .visible = true,
    .named = true,
  },
  [sym_conjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_dsym] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunctionsep] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_nbodycomma] = {
    .visible = true,
    .named = true,
  },
  [sym_bodydot] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyconddot] = {
    .visible = true,
    .named = true,
  },
  [sym_head] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_noptimizetuple] = {
    .visible = true,
    .named = true,
  },
  [sym_optimizeweight] = {
    .visible = true,
    .named = true,
  },
  [sym_optimizelitvec] = {
    .visible = true,
    .named = true,
  },
  [sym_noptimizecond] = {
    .visible = true,
    .named = true,
  },
  [sym_maxelemlist] = {
    .visible = true,
    .named = true,
  },
  [sym_minelemlist] = {
    .visible = true,
    .named = true,
  },
  [sym_nidlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_op] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_op_list] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_term] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_opterm] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_opterm_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_element] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_element_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_name] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_definition_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_definition_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_term_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_type] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_definition_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_STRING] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_STRING_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_THEORY_OP_character_set_1(int32_t c) {
  return (c < ';'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '-' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static inline bool sym_THEORY_OP_character_set_2(int32_t c) {
  return (c < ':'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '-' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static inline bool sym_THEORY_OP_character_set_3(int32_t c) {
  return (c < ':'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '.' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(205);
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(84);
      if (lookahead == '$') ADVANCE(238);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(361);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(232);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == '\\') ADVANCE(274);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'a') ADVANCE(339);
      if (lookahead == 'b') ADVANCE(337);
      if (lookahead == 'd') ADVANCE(322);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(327);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == 'o') ADVANCE(354);
      if (lookahead == 'r') ADVANCE(334);
      if (lookahead == 'u') ADVANCE(340);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(203)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(88);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(231);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '\\') ADVANCE(274);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == '$') ADVANCE(237);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(249);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(71);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '\\') ADVANCE(273);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(361);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(231);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(77);
      if (lookahead == 'a') ADVANCE(339);
      if (lookahead == 'b') ADVANCE(337);
      if (lookahead == 'd') ADVANCE(333);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(327);
      if (lookahead == 'r') ADVANCE(334);
      if (lookahead == 'u') ADVANCE(340);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(361);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(232);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == 'd') ADVANCE(107);
      if (lookahead == 'o') ADVANCE(187);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(231);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(77);
      if (lookahead == 'a') ADVANCE(339);
      if (lookahead == 'b') ADVANCE(337);
      if (lookahead == 'd') ADVANCE(333);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(327);
      if (lookahead == 'r') ADVANCE(334);
      if (lookahead == 'u') ADVANCE(340);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(232);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == 'd') ADVANCE(107);
      if (lookahead == 'o') ADVANCE(187);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '*') ADVANCE(241);
      if (lookahead == '+') ADVANCE(239);
      if (lookahead == '-') ADVANCE(240);
      if (lookahead == '<') ADVANCE(243);
      if (lookahead == '=') ADVANCE(246);
      if (lookahead == '>') ADVANCE(244);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '_') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(371);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 9:
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(233);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == '_') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '!' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(371);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '\\') ADVANCE(180);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(382);
      if (lookahead != 0) ADVANCE(386);
      END_STATE();
    case 11:
      if (lookahead == '#') ADVANCE(31);
      if (lookahead == '%') ADVANCE(221);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(11);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '#') ADVANCE(31);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '%') ADVANCE(220);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 14:
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(33);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '%') ADVANCE(222);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 17:
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 18:
      if (lookahead == '#') ADVANCE(49);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 19:
      if (lookahead == '#') ADVANCE(50);
      if (lookahead == '%') ADVANCE(223);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 20:
      if (lookahead == '#') ADVANCE(50);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 21:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 22:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 23:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(25);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 24:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 25:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(365);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 26:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(366);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 27:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 28:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'e') ADVANCE(28);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 29:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'e') ADVANCE(28);
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 30:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 31:
      if (lookahead == '#') ADVANCE(37);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 32:
      if (lookahead == '#') ADVANCE(40);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 33:
      if (lookahead == '#') ADVANCE(22);
      if (lookahead == 'e') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0 &&
          lookahead != 'd') ADVANCE(15);
      END_STATE();
    case 34:
      if (lookahead == '#') ADVANCE(28);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(70);
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 35:
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 36:
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 37:
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 38:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 39:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 40:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 41:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 42:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 43:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(59);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 44:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 45:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 46:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 47:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(61);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 48:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 49:
      if (lookahead == '#') ADVANCE(44);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 50:
      if (lookahead == '#') ADVANCE(48);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 51:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 52:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(54);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 53:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 54:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(363);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 55:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 56:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(58);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 57:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 58:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(364);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 59:
      if (lookahead == '#') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(367);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 60:
      if (lookahead == '#') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 61:
      if (lookahead == '#') ADVANCE(45);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(368);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 62:
      if (lookahead == '#') ADVANCE(45);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 63:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(361);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(249);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(273);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      END_STATE();
    case 64:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(249);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(273);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      END_STATE();
    case 65:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(65)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          (':' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(371);
      END_STATE();
    case 66:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '.') ADVANCE(251);
      if (lookahead == ';') ADVANCE(283);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(66)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          (':' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(371);
      END_STATE();
    case 67:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == ':') ADVANCE(233);
      if (lookahead == ';') ADVANCE(283);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(67)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          ('<' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(371);
      END_STATE();
    case 68:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '.') ADVANCE(251);
      if (lookahead == ':') ADVANCE(370);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(68)
      if (sym_THEORY_OP_character_set_1(lookahead)) ADVANCE(371);
      END_STATE();
    case 69:
      if (lookahead == '%') ADVANCE(206);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 70:
      if (lookahead == '*') ADVANCE(69);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 71:
      if (lookahead == '-') ADVANCE(258);
      END_STATE();
    case 72:
      if (lookahead == '-') ADVANCE(258);
      if (lookahead == '~') ADVANCE(297);
      END_STATE();
    case 73:
      if (lookahead == '=') ADVANCE(276);
      END_STATE();
    case 74:
      if (lookahead == '=') ADVANCE(247);
      END_STATE();
    case 75:
      if (lookahead == '\\') ADVANCE(378);
      END_STATE();
    case 76:
      if (lookahead == '_') ADVANCE(76);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 77:
      if (lookahead == '_') ADVANCE(77);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 78:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(189);
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(190);
      if (lookahead == 'i') ADVANCE(140);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(135);
      END_STATE();
    case 82:
      if (lookahead == 'a') ADVANCE(129);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 84:
      if (lookahead == 'c') ADVANCE(147);
      if (lookahead == 'd') ADVANCE(95);
      if (lookahead == 'e') ADVANCE(91);
      if (lookahead == 'f') ADVANCE(78);
      if (lookahead == 'h') ADVANCE(96);
      if (lookahead == 'i') ADVANCE(138);
      if (lookahead == 'm') ADVANCE(79);
      if (lookahead == 'p') ADVANCE(157);
      if (lookahead == 's') ADVANCE(86);
      if (lookahead == 't') ADVANCE(116);
      END_STATE();
    case 85:
      if (lookahead == 'c') ADVANCE(287);
      END_STATE();
    case 86:
      if (lookahead == 'c') ADVANCE(160);
      if (lookahead == 'h') ADVANCE(149);
      if (lookahead == 'u') ADVANCE(134);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(131);
      if (lookahead == 'f') ADVANCE(261);
      END_STATE();
    case 88:
      if (lookahead == 'c') ADVANCE(151);
      if (lookahead == 'd') ADVANCE(117);
      if (lookahead == 'f') ADVANCE(78);
      if (lookahead == 'i') ADVANCE(141);
      if (lookahead == 'm') ADVANCE(80);
      if (lookahead == 's') ADVANCE(178);
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 89:
      if (lookahead == 'c') ADVANCE(151);
      if (lookahead == 'm') ADVANCE(80);
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 90:
      if (lookahead == 'c') ADVANCE(172);
      END_STATE();
    case 91:
      if (lookahead == 'd') ADVANCE(114);
      if (lookahead == 'x') ADVANCE(176);
      END_STATE();
    case 92:
      if (lookahead == 'd') ADVANCE(254);
      END_STATE();
    case 93:
      if (lookahead == 'd') ADVANCE(101);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(104);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(110);
      if (lookahead == 'i') ADVANCE(165);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(285);
      END_STATE();
    case 98:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(255);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(260);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(269);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(272);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(376);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(112);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 110:
      if (lookahead == 'f') ADVANCE(122);
      END_STATE();
    case 111:
      if (lookahead == 'f') ADVANCE(261);
      END_STATE();
    case 112:
      if (lookahead == 'f') ADVANCE(83);
      END_STATE();
    case 113:
      if (lookahead == 'g') ADVANCE(288);
      END_STATE();
    case 114:
      if (lookahead == 'g') ADVANCE(97);
      END_STATE();
    case 115:
      if (lookahead == 'g') ADVANCE(158);
      if (lookahead == 'j') ADVANCE(100);
      END_STATE();
    case 116:
      if (lookahead == 'h') ADVANCE(108);
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 117:
      if (lookahead == 'i') ADVANCE(165);
      END_STATE();
    case 118:
      if (lookahead == 'i') ADVANCE(155);
      END_STATE();
    case 119:
      if (lookahead == 'i') ADVANCE(192);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(113);
      END_STATE();
    case 121:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 122:
      if (lookahead == 'i') ADVANCE(145);
      END_STATE();
    case 123:
      if (lookahead == 'i') ADVANCE(141);
      if (lookahead == 's') ADVANCE(181);
      END_STATE();
    case 124:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 125:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 126:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 127:
      if (lookahead == 'i') ADVANCE(144);
      END_STATE();
    case 128:
      if (lookahead == 'j') ADVANCE(153);
      END_STATE();
    case 129:
      if (lookahead == 'l') ADVANCE(253);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(168);
      END_STATE();
    case 131:
      if (lookahead == 'l') ADVANCE(179);
      END_STATE();
    case 132:
      if (lookahead == 'l') ADVANCE(174);
      END_STATE();
    case 133:
      if (lookahead == 'm') ADVANCE(291);
      END_STATE();
    case 134:
      if (lookahead == 'm') ADVANCE(291);
      if (lookahead == 'p') ADVANCE(293);
      END_STATE();
    case 135:
      if (lookahead == 'm') ADVANCE(295);
      END_STATE();
    case 136:
      if (lookahead == 'm') ADVANCE(119);
      END_STATE();
    case 137:
      if (lookahead == 'm') ADVANCE(125);
      END_STATE();
    case 138:
      if (lookahead == 'n') ADVANCE(87);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(271);
      END_STATE();
    case 140:
      if (lookahead == 'n') ADVANCE(270);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(111);
      END_STATE();
    case 142:
      if (lookahead == 'n') ADVANCE(166);
      if (lookahead == 'u') ADVANCE(143);
      END_STATE();
    case 143:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 144:
      if (lookahead == 'n') ADVANCE(173);
      END_STATE();
    case 145:
      if (lookahead == 'n') ADVANCE(105);
      END_STATE();
    case 146:
      if (lookahead == 'n') ADVANCE(82);
      END_STATE();
    case 147:
      if (lookahead == 'o') ADVANCE(142);
      END_STATE();
    case 148:
      if (lookahead == 'o') ADVANCE(115);
      END_STATE();
    case 149:
      if (lookahead == 'o') ADVANCE(188);
      END_STATE();
    case 150:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 151:
      if (lookahead == 'o') ADVANCE(182);
      END_STATE();
    case 152:
      if (lookahead == 'o') ADVANCE(175);
      END_STATE();
    case 153:
      if (lookahead == 'o') ADVANCE(127);
      END_STATE();
    case 154:
      if (lookahead == 'p') ADVANCE(293);
      END_STATE();
    case 155:
      if (lookahead == 'p') ADVANCE(171);
      END_STATE();
    case 156:
      if (lookahead == 'r') ADVANCE(191);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 158:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 159:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 160:
      if (lookahead == 'r') ADVANCE(118);
      END_STATE();
    case 161:
      if (lookahead == 'r') ADVANCE(126);
      END_STATE();
    case 162:
      if (lookahead == 'r') ADVANCE(146);
      END_STATE();
    case 163:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(163);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(128);
      END_STATE();
    case 166:
      if (lookahead == 's') ADVANCE(169);
      END_STATE();
    case 167:
      if (lookahead == 's') ADVANCE(177);
      END_STATE();
    case 168:
      if (lookahead == 's') ADVANCE(99);
      END_STATE();
    case 169:
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 170:
      if (lookahead == 't') ADVANCE(236);
      END_STATE();
    case 171:
      if (lookahead == 't') ADVANCE(362);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(286);
      END_STATE();
    case 173:
      if (lookahead == 't') ADVANCE(248);
      END_STATE();
    case 174:
      if (lookahead == 't') ADVANCE(374);
      END_STATE();
    case 175:
      if (lookahead == 't') ADVANCE(372);
      END_STATE();
    case 176:
      if (lookahead == 't') ADVANCE(106);
      END_STATE();
    case 177:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 178:
      if (lookahead == 'u') ADVANCE(134);
      END_STATE();
    case 179:
      if (lookahead == 'u') ADVANCE(93);
      END_STATE();
    case 180:
      if (lookahead == 'u') ADVANCE(194);
      if (lookahead == 'x') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(389);
      if (lookahead != 0) ADVANCE(387);
      END_STATE();
    case 181:
      if (lookahead == 'u') ADVANCE(154);
      END_STATE();
    case 182:
      if (lookahead == 'u') ADVANCE(143);
      END_STATE();
    case 183:
      if (lookahead == 'u') ADVANCE(133);
      END_STATE();
    case 184:
      if (lookahead == 'u') ADVANCE(132);
      END_STATE();
    case 185:
      if (lookahead == 'u') ADVANCE(98);
      END_STATE();
    case 186:
      if (lookahead == 'u') ADVANCE(161);
      END_STATE();
    case 187:
      if (lookahead == 'v') ADVANCE(109);
      END_STATE();
    case 188:
      if (lookahead == 'w') ADVANCE(284);
      END_STATE();
    case 189:
      if (lookahead == 'x') ADVANCE(268);
      END_STATE();
    case 190:
      if (lookahead == 'x') ADVANCE(267);
      END_STATE();
    case 191:
      if (lookahead == 'y') ADVANCE(307);
      END_STATE();
    case 192:
      if (lookahead == 'z') ADVANCE(102);
      END_STATE();
    case 193:
      if (lookahead == 'z') ADVANCE(103);
      END_STATE();
    case 194:
      if (lookahead == '{') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(201);
      END_STATE();
    case 195:
      if (lookahead == '}') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(195);
      END_STATE();
    case 196:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(312);
      END_STATE();
    case 197:
      if (('1' <= lookahead && lookahead <= '7')) ADVANCE(311);
      END_STATE();
    case 198:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(310);
      END_STATE();
    case 199:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(387);
      END_STATE();
    case 200:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(195);
      END_STATE();
    case 201:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 202:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(199);
      END_STATE();
    case 203:
      if (eof) ADVANCE(205);
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(84);
      if (lookahead == '$') ADVANCE(238);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(232);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == '\\') ADVANCE(274);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'a') ADVANCE(339);
      if (lookahead == 'b') ADVANCE(337);
      if (lookahead == 'd') ADVANCE(322);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(327);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == 'o') ADVANCE(354);
      if (lookahead == 'r') ADVANCE(334);
      if (lookahead == 'u') ADVANCE(340);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(203)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 204:
      if (eof) ADVANCE(205);
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(84);
      if (lookahead == '$') ADVANCE(237);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(204)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == 'd') ADVANCE(209);
      if (lookahead == 'e') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == 'd') ADVANCE(209);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(211);
      if (lookahead == 'd') ADVANCE(209);
      if (lookahead == 'e') ADVANCE(217);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(211);
      if (lookahead == 'd') ADVANCE(209);
      if (lookahead == 'e') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(213);
      if (lookahead == 'd') ADVANCE(225);
      if (lookahead == 'e') ADVANCE(213);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(213);
      if (lookahead == 'd') ADVANCE(215);
      if (lookahead == 'e') ADVANCE(213);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(213);
      if (lookahead == 'd') ADVANCE(215);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(217);
      if (lookahead == 'd') ADVANCE(219);
      if (lookahead == 'e') ADVANCE(217);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(217);
      if (lookahead == 'd') ADVANCE(219);
      if (lookahead == 'e') ADVANCE(217);
      if (lookahead == 'n') ADVANCE(218);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(216);
      if (lookahead == 'd') ADVANCE(219);
      if (lookahead == 'n') ADVANCE(218);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(216);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(31);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '*') ADVANCE(14);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(49);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead != 0) ADVANCE(225);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(225);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_ADD);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_AND);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_EQ);
      if (lookahead == '=') ADVANCE(379);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_AT);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_BNOT);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_COLON);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_COLON);
      if (lookahead == '-') ADVANCE(258);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_COLON);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_COMMA);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_CONST);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_COUNT);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_CSP);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_CSP);
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '*') ADVANCE(241);
      if (lookahead == '+') ADVANCE(239);
      if (lookahead == '<') ADVANCE(243);
      if (lookahead == '=') ADVANCE(246);
      if (lookahead == '>') ADVANCE(244);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_CSP_ADD);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_CSP_SUB);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_CSP_MUL);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_CSP_LEQ);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_CSP_LT);
      if (lookahead == '=') ADVANCE(242);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_CSP_GT);
      if (lookahead == '=') ADVANCE(245);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_CSP_GEQ);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_CSP_EQ);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_CSP_NEQ);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_DISJOINT);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_DOT);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_DOT);
      if (lookahead == '.') ADVANCE(252);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_DOT);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_DOTS);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_EXTERNAL);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_DEFINED);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_FALSE);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_GEQ);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_GT);
      if (lookahead == '=') ADVANCE(256);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_IF);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_IF);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_INCLUDE);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_INFIMUM);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_LBRACE);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_LBRACK);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_LEQ);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_LPAREN);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_LT);
      if (lookahead == '=') ADVANCE(264);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_MAX);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_MAX);
      if (lookahead == 'i') ADVANCE(136);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_MAXIMIZE);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_MIN);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_MIN);
      if (lookahead == 'i') ADVANCE(137);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_MINIMIZE);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_MOD);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_MOD);
      if (lookahead == '\\') ADVANCE(378);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_MUL);
      if (lookahead == '*') ADVANCE(277);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_NEQ);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_POW);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_QUESTION);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_RBRACE);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_RBRACK);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_RPAREN);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_SEM);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_SEM);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_SHOW);
      if (lookahead == 's') ADVANCE(120);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_EDGE);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_PROJECT);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_HEURISTIC);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_SHOWSIG);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_SLASH);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_SUB);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_SUM);
      if (lookahead == '+') ADVANCE(292);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_SUMP);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_SUPREMUM);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_TRUE);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_BLOCK);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_VBAR);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_WIF);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_XOR);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_ANY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_UNARY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_BINARY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_LEFT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_RIGHT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_HEAD);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_BODY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_DIRECTIVE);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_THEORY);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == 'b') ADVANCE(196);
      if (lookahead == 'o') ADVANCE(197);
      if (lookahead == 'x') ADVANCE(198);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(aux_sym_dec_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(309);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_hex);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(310);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_oct);
      if (('1' <= lookahead && lookahead <= '7')) ADVANCE(311);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_bin);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(312);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_ANONYMOUS);
      if (lookahead == '_') ADVANCE(76);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(353);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(319);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(346);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(352);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(304);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(357);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(325);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(330);
      if (lookahead == 'i') ADVANCE(345);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(315);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(318);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(377);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(306);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(329);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(347);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(349);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(314);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'g') ADVANCE(332);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(350);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(345);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(331);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(321);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(355);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(341);
      if (lookahead == 'o') ADVANCE(320);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(351);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(356);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(316);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(317);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(348);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(335);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(358);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(324);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(359);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(343);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(373);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(302);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(303);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(375);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(336);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(338);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(328);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(326);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(299);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(305);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(300);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(301);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_SCRIPT);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(31);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(49);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(50);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_VARIABLE);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(369);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_THEORY_OP);
      if (lookahead == '-') ADVANCE(259);
      if (sym_THEORY_OP_character_set_3(lookahead)) ADVANCE(371);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_THEORY_OP);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_NOT);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_NOT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_DEFAULT);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_DEFAULT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_OVERRIDE);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_OVERRIDE);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_BSLASH_BSLASH);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(386);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(381);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(382);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(386);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '*') ADVANCE(383);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(384);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(383);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(384);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(384);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(381);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(386);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(387);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(388);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 204},
  [2] = {.lex_state = 204},
  [3] = {.lex_state = 204},
  [4] = {.lex_state = 204},
  [5] = {.lex_state = 204},
  [6] = {.lex_state = 204},
  [7] = {.lex_state = 204},
  [8] = {.lex_state = 204},
  [9] = {.lex_state = 204},
  [10] = {.lex_state = 204},
  [11] = {.lex_state = 204},
  [12] = {.lex_state = 204},
  [13] = {.lex_state = 204},
  [14] = {.lex_state = 204},
  [15] = {.lex_state = 204},
  [16] = {.lex_state = 204},
  [17] = {.lex_state = 204},
  [18] = {.lex_state = 204},
  [19] = {.lex_state = 204},
  [20] = {.lex_state = 204},
  [21] = {.lex_state = 204},
  [22] = {.lex_state = 204},
  [23] = {.lex_state = 204},
  [24] = {.lex_state = 204},
  [25] = {.lex_state = 204},
  [26] = {.lex_state = 204},
  [27] = {.lex_state = 204},
  [28] = {.lex_state = 204},
  [29] = {.lex_state = 1},
  [30] = {.lex_state = 3},
  [31] = {.lex_state = 1},
  [32] = {.lex_state = 1},
  [33] = {.lex_state = 1},
  [34] = {.lex_state = 3},
  [35] = {.lex_state = 3},
  [36] = {.lex_state = 3},
  [37] = {.lex_state = 3},
  [38] = {.lex_state = 3},
  [39] = {.lex_state = 3},
  [40] = {.lex_state = 3},
  [41] = {.lex_state = 3},
  [42] = {.lex_state = 3},
  [43] = {.lex_state = 3},
  [44] = {.lex_state = 3},
  [45] = {.lex_state = 3},
  [46] = {.lex_state = 3},
  [47] = {.lex_state = 4},
  [48] = {.lex_state = 4},
  [49] = {.lex_state = 4},
  [50] = {.lex_state = 4},
  [51] = {.lex_state = 3},
  [52] = {.lex_state = 3},
  [53] = {.lex_state = 204},
  [54] = {.lex_state = 3},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 204},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 3},
  [60] = {.lex_state = 3},
  [61] = {.lex_state = 204},
  [62] = {.lex_state = 204},
  [63] = {.lex_state = 1},
  [64] = {.lex_state = 204},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 204},
  [67] = {.lex_state = 204},
  [68] = {.lex_state = 204},
  [69] = {.lex_state = 1},
  [70] = {.lex_state = 204},
  [71] = {.lex_state = 204},
  [72] = {.lex_state = 204},
  [73] = {.lex_state = 204},
  [74] = {.lex_state = 2},
  [75] = {.lex_state = 2},
  [76] = {.lex_state = 2},
  [77] = {.lex_state = 204},
  [78] = {.lex_state = 204},
  [79] = {.lex_state = 204},
  [80] = {.lex_state = 204},
  [81] = {.lex_state = 204},
  [82] = {.lex_state = 204},
  [83] = {.lex_state = 204},
  [84] = {.lex_state = 204},
  [85] = {.lex_state = 204},
  [86] = {.lex_state = 1},
  [87] = {.lex_state = 1},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 1},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 204},
  [92] = {.lex_state = 204},
  [93] = {.lex_state = 204},
  [94] = {.lex_state = 204},
  [95] = {.lex_state = 1},
  [96] = {.lex_state = 9},
  [97] = {.lex_state = 3},
  [98] = {.lex_state = 9},
  [99] = {.lex_state = 3},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 4},
  [102] = {.lex_state = 204},
  [103] = {.lex_state = 1},
  [104] = {.lex_state = 4},
  [105] = {.lex_state = 1},
  [106] = {.lex_state = 204},
  [107] = {.lex_state = 204},
  [108] = {.lex_state = 1},
  [109] = {.lex_state = 4},
  [110] = {.lex_state = 4},
  [111] = {.lex_state = 4},
  [112] = {.lex_state = 4},
  [113] = {.lex_state = 4},
  [114] = {.lex_state = 4},
  [115] = {.lex_state = 4},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 4},
  [118] = {.lex_state = 4},
  [119] = {.lex_state = 4},
  [120] = {.lex_state = 4},
  [121] = {.lex_state = 1},
  [122] = {.lex_state = 4},
  [123] = {.lex_state = 4},
  [124] = {.lex_state = 2},
  [125] = {.lex_state = 2},
  [126] = {.lex_state = 1},
  [127] = {.lex_state = 204},
  [128] = {.lex_state = 1},
  [129] = {.lex_state = 4},
  [130] = {.lex_state = 1},
  [131] = {.lex_state = 4},
  [132] = {.lex_state = 2},
  [133] = {.lex_state = 4},
  [134] = {.lex_state = 204},
  [135] = {.lex_state = 4},
  [136] = {.lex_state = 4},
  [137] = {.lex_state = 1},
  [138] = {.lex_state = 9},
  [139] = {.lex_state = 204},
  [140] = {.lex_state = 2},
  [141] = {.lex_state = 8},
  [142] = {.lex_state = 2},
  [143] = {.lex_state = 8},
  [144] = {.lex_state = 2},
  [145] = {.lex_state = 8},
  [146] = {.lex_state = 2},
  [147] = {.lex_state = 8},
  [148] = {.lex_state = 2},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 8},
  [151] = {.lex_state = 8},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 2},
  [154] = {.lex_state = 8},
  [155] = {.lex_state = 8},
  [156] = {.lex_state = 1},
  [157] = {.lex_state = 1},
  [158] = {.lex_state = 1},
  [159] = {.lex_state = 8},
  [160] = {.lex_state = 4},
  [161] = {.lex_state = 2},
  [162] = {.lex_state = 3},
  [163] = {.lex_state = 1},
  [164] = {.lex_state = 3},
  [165] = {.lex_state = 8},
  [166] = {.lex_state = 8},
  [167] = {.lex_state = 1},
  [168] = {.lex_state = 1},
  [169] = {.lex_state = 1},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 8},
  [172] = {.lex_state = 8},
  [173] = {.lex_state = 8},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 8},
  [176] = {.lex_state = 1},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 8},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 3},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 2},
  [184] = {.lex_state = 8},
  [185] = {.lex_state = 2},
  [186] = {.lex_state = 1},
  [187] = {.lex_state = 1},
  [188] = {.lex_state = 8},
  [189] = {.lex_state = 2},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 8},
  [192] = {.lex_state = 8},
  [193] = {.lex_state = 2},
  [194] = {.lex_state = 3},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 8},
  [200] = {.lex_state = 1},
  [201] = {.lex_state = 8},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 8},
  [205] = {.lex_state = 8},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 8},
  [208] = {.lex_state = 8},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 1},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 8},
  [259] = {.lex_state = 204},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 8},
  [262] = {.lex_state = 8},
  [263] = {.lex_state = 204},
  [264] = {.lex_state = 8},
  [265] = {.lex_state = 8},
  [266] = {.lex_state = 8},
  [267] = {.lex_state = 204},
  [268] = {.lex_state = 204},
  [269] = {.lex_state = 8},
  [270] = {.lex_state = 204},
  [271] = {.lex_state = 8},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 1},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 1},
  [282] = {.lex_state = 204},
  [283] = {.lex_state = 204},
  [284] = {.lex_state = 1},
  [285] = {.lex_state = 204},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 204},
  [289] = {.lex_state = 8},
  [290] = {.lex_state = 2},
  [291] = {.lex_state = 1},
  [292] = {.lex_state = 4},
  [293] = {.lex_state = 4},
  [294] = {.lex_state = 3},
  [295] = {.lex_state = 3},
  [296] = {.lex_state = 4},
  [297] = {.lex_state = 3},
  [298] = {.lex_state = 3},
  [299] = {.lex_state = 8},
  [300] = {.lex_state = 3},
  [301] = {.lex_state = 3},
  [302] = {.lex_state = 4},
  [303] = {.lex_state = 4},
  [304] = {.lex_state = 3},
  [305] = {.lex_state = 3},
  [306] = {.lex_state = 8},
  [307] = {.lex_state = 63},
  [308] = {.lex_state = 63},
  [309] = {.lex_state = 4},
  [310] = {.lex_state = 3},
  [311] = {.lex_state = 2},
  [312] = {.lex_state = 2},
  [313] = {.lex_state = 204},
  [314] = {.lex_state = 2},
  [315] = {.lex_state = 2},
  [316] = {.lex_state = 204},
  [317] = {.lex_state = 1},
  [318] = {.lex_state = 1},
  [319] = {.lex_state = 4},
  [320] = {.lex_state = 2},
  [321] = {.lex_state = 1},
  [322] = {.lex_state = 2},
  [323] = {.lex_state = 2},
  [324] = {.lex_state = 2},
  [325] = {.lex_state = 2},
  [326] = {.lex_state = 2},
  [327] = {.lex_state = 2},
  [328] = {.lex_state = 204},
  [329] = {.lex_state = 3},
  [330] = {.lex_state = 3},
  [331] = {.lex_state = 1},
  [332] = {.lex_state = 204},
  [333] = {.lex_state = 1},
  [334] = {.lex_state = 204},
  [335] = {.lex_state = 204},
  [336] = {.lex_state = 204},
  [337] = {.lex_state = 204},
  [338] = {.lex_state = 204},
  [339] = {.lex_state = 204},
  [340] = {.lex_state = 204},
  [341] = {.lex_state = 204},
  [342] = {.lex_state = 2},
  [343] = {.lex_state = 204},
  [344] = {.lex_state = 2},
  [345] = {.lex_state = 204},
  [346] = {.lex_state = 204},
  [347] = {.lex_state = 1},
  [348] = {.lex_state = 204},
  [349] = {.lex_state = 3},
  [350] = {.lex_state = 2},
  [351] = {.lex_state = 3},
  [352] = {.lex_state = 3},
  [353] = {.lex_state = 3},
  [354] = {.lex_state = 2},
  [355] = {.lex_state = 1},
  [356] = {.lex_state = 1},
  [357] = {.lex_state = 1},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 65},
  [360] = {.lex_state = 67},
  [361] = {.lex_state = 65},
  [362] = {.lex_state = 67},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 67},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 66},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 66},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 65},
  [377] = {.lex_state = 65},
  [378] = {.lex_state = 1},
  [379] = {.lex_state = 67},
  [380] = {.lex_state = 1},
  [381] = {.lex_state = 67},
  [382] = {.lex_state = 4},
  [383] = {.lex_state = 67},
  [384] = {.lex_state = 65},
  [385] = {.lex_state = 67},
  [386] = {.lex_state = 67},
  [387] = {.lex_state = 67},
  [388] = {.lex_state = 1},
  [389] = {.lex_state = 65},
  [390] = {.lex_state = 67},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 67},
  [393] = {.lex_state = 66},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 68},
  [396] = {.lex_state = 65},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 65},
  [399] = {.lex_state = 1},
  [400] = {.lex_state = 65},
  [401] = {.lex_state = 1},
  [402] = {.lex_state = 1},
  [403] = {.lex_state = 65},
  [404] = {.lex_state = 1},
  [405] = {.lex_state = 65},
  [406] = {.lex_state = 65},
  [407] = {.lex_state = 65},
  [408] = {.lex_state = 65},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 65},
  [411] = {.lex_state = 67},
  [412] = {.lex_state = 65},
  [413] = {.lex_state = 1},
  [414] = {.lex_state = 67},
  [415] = {.lex_state = 65},
  [416] = {.lex_state = 68},
  [417] = {.lex_state = 67},
  [418] = {.lex_state = 67},
  [419] = {.lex_state = 65},
  [420] = {.lex_state = 66},
  [421] = {.lex_state = 65},
  [422] = {.lex_state = 65},
  [423] = {.lex_state = 66},
  [424] = {.lex_state = 0},
  [425] = {.lex_state = 66},
  [426] = {.lex_state = 1},
  [427] = {.lex_state = 66},
  [428] = {.lex_state = 1},
  [429] = {.lex_state = 66},
  [430] = {.lex_state = 68},
  [431] = {.lex_state = 65},
  [432] = {.lex_state = 68},
  [433] = {.lex_state = 66},
  [434] = {.lex_state = 66},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 66},
  [437] = {.lex_state = 66},
  [438] = {.lex_state = 66},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 66},
  [441] = {.lex_state = 66},
  [442] = {.lex_state = 66},
  [443] = {.lex_state = 66},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 1},
  [446] = {.lex_state = 1},
  [447] = {.lex_state = 1},
  [448] = {.lex_state = 1},
  [449] = {.lex_state = 1},
  [450] = {.lex_state = 1},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 68},
  [453] = {.lex_state = 68},
  [454] = {.lex_state = 1},
  [455] = {.lex_state = 68},
  [456] = {.lex_state = 10},
  [457] = {.lex_state = 10},
  [458] = {.lex_state = 1},
  [459] = {.lex_state = 1},
  [460] = {.lex_state = 68},
  [461] = {.lex_state = 68},
  [462] = {.lex_state = 1},
  [463] = {.lex_state = 1},
  [464] = {.lex_state = 10},
  [465] = {.lex_state = 68},
  [466] = {.lex_state = 1},
  [467] = {.lex_state = 68},
  [468] = {.lex_state = 1},
  [469] = {.lex_state = 1},
  [470] = {.lex_state = 68},
  [471] = {.lex_state = 1},
  [472] = {.lex_state = 3},
  [473] = {.lex_state = 1},
  [474] = {.lex_state = 1},
  [475] = {.lex_state = 68},
  [476] = {.lex_state = 10},
  [477] = {.lex_state = 1},
  [478] = {.lex_state = 65},
  [479] = {.lex_state = 68},
  [480] = {.lex_state = 1},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 10},
  [483] = {.lex_state = 68},
  [484] = {.lex_state = 10},
  [485] = {.lex_state = 1},
  [486] = {.lex_state = 10},
  [487] = {.lex_state = 68},
  [488] = {.lex_state = 10},
  [489] = {.lex_state = 10},
  [490] = {.lex_state = 10},
  [491] = {.lex_state = 3},
  [492] = {.lex_state = 10},
  [493] = {.lex_state = 10},
  [494] = {.lex_state = 68},
  [495] = {.lex_state = 1},
  [496] = {.lex_state = 1},
  [497] = {.lex_state = 10},
  [498] = {.lex_state = 1},
  [499] = {.lex_state = 1},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 0},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 65},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 3},
  [508] = {.lex_state = 1},
  [509] = {.lex_state = 1},
  [510] = {.lex_state = 2},
  [511] = {.lex_state = 1},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 0},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 1},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 3},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 1},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 0},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 1},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 1},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 1},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 204},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 4},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 1},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 1},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 1},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 1},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 1},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 1},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 1},
  [639] = {.lex_state = 1},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 1},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 204},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 1},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 1},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 1},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 204},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 1},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 1},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 204},
  [676] = {.lex_state = 1},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 1},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 1},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 11},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 204},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 1},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_ADD] = ACTIONS(1),
    [sym_AND] = ACTIONS(1),
    [sym_EQ] = ACTIONS(1),
    [sym_AT] = ACTIONS(1),
    [sym_BNOT] = ACTIONS(1),
    [sym_COLON] = ACTIONS(1),
    [sym_COMMA] = ACTIONS(1),
    [sym_CONST] = ACTIONS(1),
    [sym_COUNT] = ACTIONS(1),
    [sym_CSP] = ACTIONS(1),
    [sym_CSP_ADD] = ACTIONS(1),
    [sym_CSP_MUL] = ACTIONS(1),
    [sym_CSP_LEQ] = ACTIONS(1),
    [sym_CSP_LT] = ACTIONS(1),
    [sym_CSP_GT] = ACTIONS(1),
    [sym_CSP_GEQ] = ACTIONS(1),
    [sym_CSP_EQ] = ACTIONS(1),
    [sym_CSP_NEQ] = ACTIONS(1),
    [sym_DISJOINT] = ACTIONS(1),
    [sym_DOT] = ACTIONS(1),
    [sym_DOTS] = ACTIONS(1),
    [sym_EXTERNAL] = ACTIONS(1),
    [sym_DEFINED] = ACTIONS(1),
    [sym_FALSE] = ACTIONS(1),
    [sym_GEQ] = ACTIONS(1),
    [sym_GT] = ACTIONS(1),
    [sym_IF] = ACTIONS(1),
    [sym_INCLUDE] = ACTIONS(1),
    [sym_INFIMUM] = ACTIONS(1),
    [sym_LBRACE] = ACTIONS(1),
    [sym_LBRACK] = ACTIONS(1),
    [sym_LEQ] = ACTIONS(1),
    [sym_LPAREN] = ACTIONS(1),
    [sym_LT] = ACTIONS(1),
    [sym_MAX] = ACTIONS(1),
    [sym_MAXIMIZE] = ACTIONS(1),
    [sym_MIN] = ACTIONS(1),
    [sym_MINIMIZE] = ACTIONS(1),
    [sym_MOD] = ACTIONS(1),
    [sym_MUL] = ACTIONS(1),
    [sym_NEQ] = ACTIONS(1),
    [sym_POW] = ACTIONS(1),
    [sym_QUESTION] = ACTIONS(1),
    [sym_RBRACE] = ACTIONS(1),
    [sym_RBRACK] = ACTIONS(1),
    [sym_RPAREN] = ACTIONS(1),
    [sym_SEM] = ACTIONS(1),
    [sym_SHOW] = ACTIONS(1),
    [sym_EDGE] = ACTIONS(1),
    [sym_PROJECT] = ACTIONS(1),
    [sym_HEURISTIC] = ACTIONS(1),
    [sym_SHOWSIG] = ACTIONS(1),
    [sym_SLASH] = ACTIONS(1),
    [sym_SUB] = ACTIONS(1),
    [sym_SUM] = ACTIONS(1),
    [sym_SUMP] = ACTIONS(1),
    [sym_SUPREMUM] = ACTIONS(1),
    [sym_TRUE] = ACTIONS(1),
    [sym_BLOCK] = ACTIONS(1),
    [sym_VBAR] = ACTIONS(1),
    [sym_XOR] = ACTIONS(1),
    [sym_ANY] = ACTIONS(1),
    [sym_UNARY] = ACTIONS(1),
    [sym_BINARY] = ACTIONS(1),
    [sym_LEFT] = ACTIONS(1),
    [sym_RIGHT] = ACTIONS(1),
    [sym_HEAD] = ACTIONS(1),
    [sym_BODY] = ACTIONS(1),
    [sym_DIRECTIVE] = ACTIONS(1),
    [sym_THEORY] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [aux_sym_dec_token1] = ACTIONS(1),
    [sym_hex] = ACTIONS(1),
    [sym_oct] = ACTIONS(1),
    [sym_bin] = ACTIONS(1),
    [sym_ANONYMOUS] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [sym_SCRIPT] = ACTIONS(1),
    [sym_VARIABLE] = ACTIONS(1),
    [sym_NOT] = ACTIONS(1),
    [sym_DEFAULT] = ACTIONS(1),
    [sym_OVERRIDE] = ACTIONS(1),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(661),
    [sym_NUMBER] = STATE(39),
    [sym_dec] = STATE(32),
    [sym__widentifier] = STATE(157),
    [sym_term] = STATE(60),
    [sym_atom] = STATE(363),
    [sym_literal] = STATE(364),
    [sym_csp_mul_term] = STATE(303),
    [sym_csp_add_term] = STATE(357),
    [sym_csp_literal] = STATE(319),
    [sym_aggregatefunction] = STATE(653),
    [sym_headaggregate] = STATE(75),
    [sym_luheadaggregate] = STATE(644),
    [sym_disjoint] = STATE(645),
    [sym_disjunctionsep] = STATE(85),
    [sym_disjunction] = STATE(644),
    [sym_head] = STATE(645),
    [sym_statement] = STATE(2),
    [sym_theory_atom] = STATE(650),
    [sym_STRING] = STATE(39),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(7),
    [sym_AT] = ACTIONS(9),
    [sym_BNOT] = ACTIONS(11),
    [sym_CONST] = ACTIONS(13),
    [sym_COUNT] = ACTIONS(15),
    [sym_CSP] = ACTIONS(17),
    [sym_DISJOINT] = ACTIONS(19),
    [sym_EXTERNAL] = ACTIONS(21),
    [sym_DEFINED] = ACTIONS(23),
    [sym_FALSE] = ACTIONS(25),
    [sym_IF] = ACTIONS(27),
    [sym_INCLUDE] = ACTIONS(29),
    [sym_INFIMUM] = ACTIONS(31),
    [sym_LBRACE] = ACTIONS(33),
    [sym_LPAREN] = ACTIONS(35),
    [sym_MAX] = ACTIONS(37),
    [sym_MAXIMIZE] = ACTIONS(39),
    [sym_MIN] = ACTIONS(37),
    [sym_MINIMIZE] = ACTIONS(41),
    [sym_SHOW] = ACTIONS(43),
    [sym_EDGE] = ACTIONS(45),
    [sym_PROJECT] = ACTIONS(47),
    [sym_HEURISTIC] = ACTIONS(49),
    [sym_SHOWSIG] = ACTIONS(51),
    [sym_SUB] = ACTIONS(53),
    [sym_SUM] = ACTIONS(37),
    [sym_SUMP] = ACTIONS(15),
    [sym_SUPREMUM] = ACTIONS(31),
    [sym_TRUE] = ACTIONS(25),
    [sym_BLOCK] = ACTIONS(55),
    [sym_VBAR] = ACTIONS(57),
    [sym_WIF] = ACTIONS(59),
    [sym_THEORY] = ACTIONS(61),
    [anon_sym_0] = ACTIONS(63),
    [aux_sym_dec_token1] = ACTIONS(65),
    [sym_hex] = ACTIONS(67),
    [sym_oct] = ACTIONS(67),
    [sym_bin] = ACTIONS(67),
    [sym_ANONYMOUS] = ACTIONS(69),
    [sym_identifier] = ACTIONS(71),
    [sym_SCRIPT] = ACTIONS(73),
    [sym_VARIABLE] = ACTIONS(31),
    [sym_NOT] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
  },
  [2] = {
    [sym_NUMBER] = STATE(39),
    [sym_dec] = STATE(32),
    [sym__widentifier] = STATE(157),
    [sym_term] = STATE(60),
    [sym_atom] = STATE(363),
    [sym_literal] = STATE(364),
    [sym_csp_mul_term] = STATE(303),
    [sym_csp_add_term] = STATE(357),
    [sym_csp_literal] = STATE(319),
    [sym_aggregatefunction] = STATE(653),
    [sym_headaggregate] = STATE(75),
    [sym_luheadaggregate] = STATE(644),
    [sym_disjoint] = STATE(645),
    [sym_disjunctionsep] = STATE(85),
    [sym_disjunction] = STATE(644),
    [sym_head] = STATE(645),
    [sym_statement] = STATE(3),
    [sym_theory_atom] = STATE(650),
    [sym_STRING] = STATE(39),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(7),
    [sym_AT] = ACTIONS(9),
    [sym_BNOT] = ACTIONS(11),
    [sym_CONST] = ACTIONS(13),
    [sym_COUNT] = ACTIONS(15),
    [sym_CSP] = ACTIONS(17),
    [sym_DISJOINT] = ACTIONS(19),
    [sym_EXTERNAL] = ACTIONS(21),
    [sym_DEFINED] = ACTIONS(23),
    [sym_FALSE] = ACTIONS(25),
    [sym_IF] = ACTIONS(27),
    [sym_INCLUDE] = ACTIONS(29),
    [sym_INFIMUM] = ACTIONS(31),
    [sym_LBRACE] = ACTIONS(33),
    [sym_LPAREN] = ACTIONS(35),
    [sym_MAX] = ACTIONS(37),
    [sym_MAXIMIZE] = ACTIONS(39),
    [sym_MIN] = ACTIONS(37),
    [sym_MINIMIZE] = ACTIONS(41),
    [sym_SHOW] = ACTIONS(43),
    [sym_EDGE] = ACTIONS(45),
    [sym_PROJECT] = ACTIONS(47),
    [sym_HEURISTIC] = ACTIONS(49),
    [sym_SHOWSIG] = ACTIONS(51),
    [sym_SUB] = ACTIONS(53),
    [sym_SUM] = ACTIONS(37),
    [sym_SUMP] = ACTIONS(15),
    [sym_SUPREMUM] = ACTIONS(31),
    [sym_TRUE] = ACTIONS(25),
    [sym_BLOCK] = ACTIONS(55),
    [sym_VBAR] = ACTIONS(57),
    [sym_WIF] = ACTIONS(59),
    [sym_THEORY] = ACTIONS(61),
    [anon_sym_0] = ACTIONS(63),
    [aux_sym_dec_token1] = ACTIONS(65),
    [sym_hex] = ACTIONS(67),
    [sym_oct] = ACTIONS(67),
    [sym_bin] = ACTIONS(67),
    [sym_ANONYMOUS] = ACTIONS(69),
    [sym_identifier] = ACTIONS(71),
    [sym_SCRIPT] = ACTIONS(73),
    [sym_VARIABLE] = ACTIONS(31),
    [sym_NOT] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
  },
  [3] = {
    [sym_NUMBER] = STATE(39),
    [sym_dec] = STATE(32),
    [sym__widentifier] = STATE(157),
    [sym_term] = STATE(60),
    [sym_atom] = STATE(363),
    [sym_literal] = STATE(364),
    [sym_csp_mul_term] = STATE(303),
    [sym_csp_add_term] = STATE(357),
    [sym_csp_literal] = STATE(319),
    [sym_aggregatefunction] = STATE(653),
    [sym_headaggregate] = STATE(75),
    [sym_luheadaggregate] = STATE(644),
    [sym_disjoint] = STATE(645),
    [sym_disjunctionsep] = STATE(85),
    [sym_disjunction] = STATE(644),
    [sym_head] = STATE(645),
    [sym_statement] = STATE(3),
    [sym_theory_atom] = STATE(650),
    [sym_STRING] = STATE(39),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(83),
    [sym_AT] = ACTIONS(86),
    [sym_BNOT] = ACTIONS(89),
    [sym_CONST] = ACTIONS(92),
    [sym_COUNT] = ACTIONS(95),
    [sym_CSP] = ACTIONS(98),
    [sym_DISJOINT] = ACTIONS(101),
    [sym_EXTERNAL] = ACTIONS(104),
    [sym_DEFINED] = ACTIONS(107),
    [sym_FALSE] = ACTIONS(110),
    [sym_IF] = ACTIONS(113),
    [sym_INCLUDE] = ACTIONS(116),
    [sym_INFIMUM] = ACTIONS(119),
    [sym_LBRACE] = ACTIONS(122),
    [sym_LPAREN] = ACTIONS(125),
    [sym_MAX] = ACTIONS(128),
    [sym_MAXIMIZE] = ACTIONS(131),
    [sym_MIN] = ACTIONS(128),
    [sym_MINIMIZE] = ACTIONS(134),
    [sym_SHOW] = ACTIONS(137),
    [sym_EDGE] = ACTIONS(140),
    [sym_PROJECT] = ACTIONS(143),
    [sym_HEURISTIC] = ACTIONS(146),
    [sym_SHOWSIG] = ACTIONS(149),
    [sym_SUB] = ACTIONS(152),
    [sym_SUM] = ACTIONS(128),
    [sym_SUMP] = ACTIONS(95),
    [sym_SUPREMUM] = ACTIONS(119),
    [sym_TRUE] = ACTIONS(110),
    [sym_BLOCK] = ACTIONS(155),
    [sym_VBAR] = ACTIONS(158),
    [sym_WIF] = ACTIONS(161),
    [sym_THEORY] = ACTIONS(164),
    [anon_sym_0] = ACTIONS(167),
    [aux_sym_dec_token1] = ACTIONS(170),
    [sym_hex] = ACTIONS(173),
    [sym_oct] = ACTIONS(173),
    [sym_bin] = ACTIONS(173),
    [sym_ANONYMOUS] = ACTIONS(176),
    [sym_identifier] = ACTIONS(179),
    [sym_SCRIPT] = ACTIONS(182),
    [sym_VARIABLE] = ACTIONS(119),
    [sym_NOT] = ACTIONS(185),
    [anon_sym_DQUOTE] = ACTIONS(188),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(193), 1,
      sym_DOT,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    STATE(21), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(32), 1,
      sym_dec,
    STATE(59), 1,
      sym_term,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(477), 1,
      sym_literal,
    STATE(514), 1,
      sym_theory_atom,
    STATE(517), 1,
      sym_lubodyaggregate,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(626), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [125] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    ACTIONS(205), 1,
      sym_DOT,
    STATE(25), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(32), 1,
      sym_dec,
    STATE(59), 1,
      sym_term,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(477), 1,
      sym_literal,
    STATE(514), 1,
      sym_theory_atom,
    STATE(517), 1,
      sym_lubodyaggregate,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(626), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [250] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    ACTIONS(207), 1,
      sym_DOT,
    STATE(18), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(32), 1,
      sym_dec,
    STATE(59), 1,
      sym_term,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(477), 1,
      sym_literal,
    STATE(514), 1,
      sym_theory_atom,
    STATE(517), 1,
      sym_lubodyaggregate,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(626), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [375] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    ACTIONS(209), 1,
      sym_DOT,
    STATE(16), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(32), 1,
      sym_dec,
    STATE(59), 1,
      sym_term,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(477), 1,
      sym_literal,
    STATE(514), 1,
      sym_theory_atom,
    STATE(517), 1,
      sym_lubodyaggregate,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(626), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [500] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(211), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [554] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(32), 1,
      sym_dec,
    STATE(59), 1,
      sym_term,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(477), 1,
      sym_literal,
    STATE(514), 1,
      sym_theory_atom,
    STATE(517), 1,
      sym_lubodyaggregate,
    STATE(658), 1,
      sym_aggregatefunction,
    STATE(686), 1,
      sym_bodydot,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(626), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [676] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(215), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [730] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(219), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [784] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(223), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [838] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(229), 1,
      sym_LBRACK,
    ACTIONS(231), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(227), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [894] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(235), 1,
      sym_LBRACK,
    ACTIONS(237), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(233), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [950] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    STATE(26), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(32), 1,
      sym_dec,
    STATE(59), 1,
      sym_term,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(477), 1,
      sym_literal,
    STATE(514), 1,
      sym_theory_atom,
    STATE(517), 1,
      sym_lubodyaggregate,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(626), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [1072] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 1,
      sym_LBRACK,
    ACTIONS(243), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(239), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1128] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    STATE(23), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(32), 1,
      sym_dec,
    STATE(59), 1,
      sym_term,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(477), 1,
      sym_literal,
    STATE(514), 1,
      sym_theory_atom,
    STATE(517), 1,
      sym_lubodyaggregate,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(626), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [1250] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(247), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(245), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(249), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1358] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(253), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1411] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(259), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(257), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(263), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(261), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1517] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(243), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(239), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1570] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(267), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(265), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1623] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(227), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1676] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(237), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(233), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1729] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(271), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(269), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1782] = 35,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(273), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(59), 1,
      sym_term,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(473), 1,
      sym_literal,
    STATE(514), 1,
      sym_theory_atom,
    STATE(524), 1,
      sym_lubodyaggregate,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(547), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [1898] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(275), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [1948] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(281), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(279), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2000] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(285), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2050] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(289), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2100] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(295), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(293), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2150] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(297), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2202] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(305), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 29,
      sym_ADD,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2259] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(299), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(297), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2308] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(315), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(313), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2357] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2406] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(279), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2455] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(299), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_SUM,
    ACTIONS(297), 24,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SUMP,
      sym_VBAR,
      anon_sym_EQ_EQ,
  [2520] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(305), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 30,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2575] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2624] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(305), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 27,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2683] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(305), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 32,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2734] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(305), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 31,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2787] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(305), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_SUM,
    ACTIONS(301), 24,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SUMP,
      sym_VBAR,
      anon_sym_EQ_EQ,
  [2852] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(325), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(327), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(281), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(279), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2906] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(329), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(331), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(281), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(279), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2960] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(335), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(305), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3011] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(339), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(305), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3062] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(325), 1,
      sym_DOT,
    ACTIONS(327), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(281), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(279), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3114] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(329), 1,
      sym_DOT,
    ACTIONS(331), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(281), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(279), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3166] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(341), 1,
      sym_DISJOINT,
    ACTIONS(345), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(102), 1,
      sym_term,
    STATE(152), 1,
      sym__widentifier,
    STATE(449), 1,
      sym_atom,
    STATE(514), 1,
      sym_theory_atom,
    STATE(526), 1,
      sym_lubodyaggregate,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(343), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3263] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 1,
      sym_DOT,
    ACTIONS(339), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(305), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3312] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 1,
      sym_DOT,
    ACTIONS(335), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(305), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3361] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(341), 1,
      sym_DISJOINT,
    ACTIONS(347), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(102), 1,
      sym_term,
    STATE(152), 1,
      sym__widentifier,
    STATE(449), 1,
      sym_atom,
    STATE(514), 1,
      sym_theory_atom,
    STATE(524), 1,
      sym_lubodyaggregate,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(343), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3458] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(349), 1,
      sym_DISJOINT,
    ACTIONS(353), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(107), 1,
      sym_term,
    STATE(152), 1,
      sym__widentifier,
    STATE(448), 1,
      sym_atom,
    STATE(514), 1,
      sym_theory_atom,
    STATE(526), 1,
      sym_lubodyaggregate,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(351), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3552] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(349), 1,
      sym_DISJOINT,
    ACTIONS(353), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(107), 1,
      sym_term,
    STATE(152), 1,
      sym__widentifier,
    STATE(448), 1,
      sym_atom,
    STATE(514), 1,
      sym_theory_atom,
    STATE(518), 1,
      sym_lubodyaggregate,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(351), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3646] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    STATE(63), 1,
      sym_bodyaggregate,
    STATE(87), 1,
      sym_cmp,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(357), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [3723] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      sym_LBRACE,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    STATE(74), 1,
      sym_headaggregate,
    STATE(89), 1,
      sym_cmp,
    STATE(653), 1,
      sym_aggregatefunction,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(357), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [3800] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(367), 1,
      sym_SEM,
    ACTIONS(369), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(157), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(319), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(363), 1,
      sym_atom,
    STATE(394), 1,
      sym_literal,
    STATE(397), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(365), 2,
      sym_DOT,
      sym_IF,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [3892] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(369), 1,
      sym_NOT,
    ACTIONS(373), 1,
      sym_SEM,
    STATE(32), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(157), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(319), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(363), 1,
      sym_atom,
    STATE(391), 1,
      sym_nlitvec,
    STATE(394), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(371), 2,
      sym_DOT,
      sym_IF,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [3984] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(232), 1,
      sym_cmp,
    STATE(316), 1,
      sym_term,
    STATE(522), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(375), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [4061] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(157), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(347), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(363), 1,
      sym_atom,
    STATE(394), 1,
      sym_literal,
    STATE(520), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(379), 2,
      sym_DOT,
      sym_SEM,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4150] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(232), 1,
      sym_cmp,
    STATE(316), 1,
      sym_term,
    STATE(529), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(383), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [4227] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(387), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(463), 1,
      sym_literal,
    STATE(637), 1,
      sym_altbodyaggrelem,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(385), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4316] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(387), 1,
      sym_NOT,
    ACTIONS(389), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(463), 1,
      sym_literal,
    STATE(548), 1,
      sym_altbodyaggrelemvec,
    STATE(549), 1,
      sym_altbodyaggrelem,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4407] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(157), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(347), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(363), 1,
      sym_atom,
    STATE(515), 1,
      sym_optimizelitvec,
    STATE(516), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(391), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4496] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(232), 1,
      sym_cmp,
    STATE(316), 1,
      sym_term,
    STATE(523), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(393), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [4573] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(157), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(347), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(363), 1,
      sym_atom,
    STATE(394), 1,
      sym_literal,
    STATE(528), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(395), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4662] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(157), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(347), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(363), 1,
      sym_atom,
    STATE(394), 1,
      sym_literal,
    STATE(525), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(397), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4751] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(157), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(347), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(363), 1,
      sym_atom,
    STATE(394), 1,
      sym_literal,
    STATE(500), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(365), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4840] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(387), 1,
      sym_NOT,
    ACTIONS(399), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(495), 1,
      sym_literal,
    STATE(610), 1,
      sym_altheadaggrelemvec,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4928] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(179), 1,
      sym__widentifier,
    STATE(224), 1,
      sym_cmp,
    STATE(337), 1,
      sym_term,
    STATE(618), 1,
      sym_nupper,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(405), 2,
      sym_DOT,
      sym_IF,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [5004] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(179), 1,
      sym__widentifier,
    STATE(224), 1,
      sym_cmp,
    STATE(337), 1,
      sym_term,
    STATE(557), 1,
      sym_nupper,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(425), 2,
      sym_DOT,
      sym_IF,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [5080] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(179), 1,
      sym__widentifier,
    STATE(224), 1,
      sym_cmp,
    STATE(337), 1,
      sym_term,
    STATE(568), 1,
      sym_nupper,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(427), 2,
      sym_DOT,
      sym_IF,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [5156] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(387), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(474), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5238] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(387), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(459), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5320] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(369), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(157), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(319), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(363), 1,
      sym_atom,
    STATE(409), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5402] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(157), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(347), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(363), 1,
      sym_atom,
    STATE(409), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5484] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(387), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(485), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5566] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(387), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(458), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5648] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(387), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(152), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(446), 1,
      sym_atom,
    STATE(480), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5730] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(157), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(347), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(363), 1,
      sym_atom,
    STATE(527), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5812] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(369), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(157), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(319), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(358), 1,
      sym_literal,
    STATE(363), 1,
      sym_atom,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5894] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(65), 1,
      sym_bodyaggregate,
    STATE(181), 1,
      sym__widentifier,
    STATE(298), 1,
      sym_term,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [5967] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(65), 1,
      sym_bodyaggregate,
    STATE(181), 1,
      sym__widentifier,
    STATE(305), 1,
      sym_term,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [6040] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(65), 1,
      sym_bodyaggregate,
    STATE(181), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_term,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [6113] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      sym_LBRACE,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(76), 1,
      sym_headaggregate,
    STATE(109), 1,
      sym_dec,
    STATE(179), 1,
      sym__widentifier,
    STATE(293), 1,
      sym_term,
    STATE(653), 1,
      sym_aggregatefunction,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [6186] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(429), 1,
      sym_COMMA,
    ACTIONS(431), 1,
      sym_RPAREN,
    ACTIONS(433), 1,
      sym_SEM,
    STATE(32), 1,
      sym_dec,
    STATE(130), 1,
      sym_tuplevec_sem,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(503), 1,
      sym_ntermvec,
    STATE(581), 1,
      sym_ntuple,
    STATE(682), 1,
      sym_ntuplevec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6262] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(435), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [6298] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(439), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [6334] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(443), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [6370] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(449), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(447), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [6406] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(429), 1,
      sym_COMMA,
    ACTIONS(433), 1,
      sym_SEM,
    ACTIONS(451), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(130), 1,
      sym_tuplevec_sem,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(503), 1,
      sym_ntermvec,
    STATE(581), 1,
      sym_ntuple,
    STATE(655), 1,
      sym_ntuplevec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6482] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      sym_COLON,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(463), 1,
      sym_RBRACE,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    STATE(258), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(360), 1,
      sym_theory_opterm,
    STATE(379), 1,
      sym_theory_term,
    STATE(390), 1,
      sym_dec,
    STATE(426), 1,
      sym_theory_opterm_nlist,
    STATE(565), 1,
      sym_theory_atom_element,
    STATE(641), 1,
      sym_theory_atom_element_nlist,
    ACTIONS(473), 2,
      sym_THEORY_OP,
      sym_NOT,
    STATE(381), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6555] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    STATE(221), 1,
      sym_cmp,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(357), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [6614] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      sym_COLON,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    ACTIONS(477), 1,
      sym_RBRACE,
    STATE(258), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(360), 1,
      sym_theory_opterm,
    STATE(379), 1,
      sym_theory_term,
    STATE(390), 1,
      sym_dec,
    STATE(426), 1,
      sym_theory_opterm_nlist,
    STATE(565), 1,
      sym_theory_atom_element,
    STATE(623), 1,
      sym_theory_atom_element_nlist,
    ACTIONS(473), 2,
      sym_THEORY_OP,
      sym_NOT,
    STATE(381), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6687] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    STATE(213), 1,
      sym_cmp,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(357), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [6746] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(479), 1,
      sym_COLON,
    ACTIONS(481), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(428), 1,
      sym_ntermvec,
    STATE(535), 1,
      sym_bodyaggrelemvec,
    STATE(567), 1,
      sym_bodyaggrelem,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6816] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(281), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(279), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [6852] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    STATE(63), 1,
      sym_bodyaggregate,
    STATE(88), 1,
      sym_cmp,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [6914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(485), 21,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [6948] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(297), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [6984] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(487), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(489), 21,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [7018] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(341), 1,
      sym_DISJOINT,
    ACTIONS(493), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(157), 1,
      sym__widentifier,
    STATE(283), 1,
      sym_term,
    STATE(368), 1,
      sym_atom,
    ACTIONS(491), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7088] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    STATE(63), 1,
      sym_bodyaggregate,
    STATE(86), 1,
      sym_cmp,
    STATE(658), 1,
      sym_aggregatefunction,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [7150] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(497), 21,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [7184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(289), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7217] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 1,
      sym_AND,
    ACTIONS(503), 1,
      sym_CSP_MUL,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(507), 1,
      sym_MUL,
    ACTIONS(509), 1,
      sym_POW,
    ACTIONS(511), 1,
      sym_QUESTION,
    ACTIONS(515), 1,
      sym_XOR,
    ACTIONS(499), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(513), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(357), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [7268] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(507), 1,
      sym_MUL,
    ACTIONS(509), 1,
      sym_POW,
    ACTIONS(511), 1,
      sym_QUESTION,
    ACTIONS(515), 1,
      sym_XOR,
    ACTIONS(499), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(513), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(305), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(301), 11,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [7317] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(507), 1,
      sym_MUL,
    ACTIONS(509), 1,
      sym_POW,
    ACTIONS(511), 1,
      sym_QUESTION,
    ACTIONS(515), 1,
      sym_XOR,
    ACTIONS(521), 1,
      sym_CSP_MUL,
    ACTIONS(499), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(513), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(517), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(519), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [7368] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(511), 1,
      sym_QUESTION,
    ACTIONS(515), 1,
      sym_XOR,
    ACTIONS(499), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(305), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 14,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [7411] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7444] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(511), 1,
      sym_QUESTION,
    ACTIONS(515), 1,
      sym_XOR,
    ACTIONS(305), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 17,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [7483] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(349), 1,
      sym_DISJOINT,
    ACTIONS(525), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(157), 1,
      sym__widentifier,
    STATE(285), 1,
      sym_term,
    STATE(375), 1,
      sym_atom,
    ACTIONS(523), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7550] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(295), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(293), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7583] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(511), 1,
      sym_QUESTION,
    ACTIONS(515), 1,
      sym_XOR,
    ACTIONS(305), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 16,
      sym_ADD,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [7624] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(275), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7657] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7690] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(527), 1,
      sym_COLON,
    ACTIONS(529), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(534), 1,
      sym_ncspelemvec,
    STATE(553), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(285), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7790] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(515), 1,
      sym_XOR,
    ACTIONS(305), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 18,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [7827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(533), 20,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [7860] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(535), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(537), 20,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [7893] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(527), 1,
      sym_COLON,
    ACTIONS(539), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(553), 1,
      sym_ntermvec,
    STATE(561), 1,
      sym_ncspelemvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7960] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(541), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(152), 1,
      sym__widentifier,
    STATE(288), 1,
      sym_term,
    STATE(449), 1,
      sym_atom,
    ACTIONS(343), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8027] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(527), 1,
      sym_COLON,
    ACTIONS(543), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(552), 1,
      sym_ncspelemvec,
    STATE(553), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8094] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(279), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8127] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(429), 1,
      sym_COMMA,
    ACTIONS(545), 1,
      sym_SEM,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(503), 1,
      sym_ntermvec,
    STATE(582), 1,
      sym_ntuple,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8194] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(305), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 19,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8229] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(547), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(549), 20,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [8262] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(507), 1,
      sym_MUL,
    ACTIONS(509), 1,
      sym_POW,
    ACTIONS(511), 1,
      sym_QUESTION,
    ACTIONS(515), 1,
      sym_XOR,
    ACTIONS(499), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(513), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(299), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(297), 11,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [8311] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(551), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(157), 1,
      sym__widentifier,
    STATE(283), 1,
      sym_term,
    STATE(368), 1,
      sym_atom,
    ACTIONS(491), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8378] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(299), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(297), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8411] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(315), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(313), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8444] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(553), 1,
      sym_COLON,
    ACTIONS(555), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(634), 1,
      sym_ntermvec,
    STATE(635), 1,
      sym_headaggrelemvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8511] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      sym_COLON,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    STATE(258), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(360), 1,
      sym_theory_opterm,
    STATE(379), 1,
      sym_theory_term,
    STATE(390), 1,
      sym_dec,
    STATE(426), 1,
      sym_theory_opterm_nlist,
    STATE(612), 1,
      sym_theory_atom_element,
    ACTIONS(473), 2,
      sym_THEORY_OP,
      sym_NOT,
    STATE(381), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8578] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(557), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(157), 1,
      sym__widentifier,
    STATE(288), 1,
      sym_term,
    STATE(368), 1,
      sym_atom,
    ACTIONS(491), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8645] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(559), 1,
      sym_CSP,
    STATE(32), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    STATE(318), 1,
      sym_csp_mul_term,
    STATE(378), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8709] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      sym_RBRACK,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(631), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8775] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(559), 1,
      sym_CSP,
    STATE(32), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    STATE(318), 1,
      sym_csp_mul_term,
    STATE(402), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8839] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      sym_RPAREN,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(614), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8905] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(559), 1,
      sym_CSP,
    STATE(32), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    STATE(318), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8969] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      sym_RPAREN,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(550), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9035] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(559), 1,
      sym_CSP,
    STATE(32), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    STATE(317), 1,
      sym_csp_add_term,
    STATE(318), 1,
      sym_csp_mul_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9099] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(587), 1,
      sym_RPAREN,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(559), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9165] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(333), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9229] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(589), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(533), 1,
      sym_ntermvec,
    STATE(551), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9293] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_RBRACK,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(595), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9359] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_RBRACE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(591), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9425] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(589), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(533), 1,
      sym_ntermvec,
    STATE(643), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9489] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(559), 1,
      sym_CSP,
    STATE(32), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    STATE(318), 1,
      sym_csp_mul_term,
    STATE(413), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9553] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(593), 1,
      sym_RPAREN,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(621), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9619] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(595), 1,
      sym_RPAREN,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(622), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9685] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(597), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(533), 1,
      sym_ntermvec,
    STATE(598), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9749] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(599), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(533), 1,
      sym_ntermvec,
    STATE(560), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9813] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(601), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(533), 1,
      sym_ntermvec,
    STATE(609), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9877] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(603), 1,
      sym_RBRACK,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(562), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9943] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(507), 1,
      sym_MUL,
    ACTIONS(509), 1,
      sym_POW,
    ACTIONS(511), 1,
      sym_QUESTION,
    ACTIONS(515), 1,
      sym_XOR,
    ACTIONS(499), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(513), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(605), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(607), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [9991] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    ACTIONS(609), 1,
      sym_CSP,
    STATE(109), 1,
      sym_dec,
    STATE(110), 1,
      sym_term,
    STATE(179), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    STATE(309), 1,
      sym_csp_add_term,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10055] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(357), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [10105] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(525), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(157), 1,
      sym__widentifier,
    STATE(282), 1,
      sym_term,
    STATE(375), 1,
      sym_atom,
    ACTIONS(523), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10169] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(611), 1,
      sym_CSP_MUL,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(517), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(519), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [10219] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(603), 1,
      sym_RBRACE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(563), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10285] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(613), 1,
      sym_RPAREN,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(592), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10351] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(479), 1,
      sym_COLON,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(428), 1,
      sym_ntermvec,
    STATE(605), 1,
      sym_bodyaggrelem,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10415] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(525), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(157), 1,
      sym__widentifier,
    STATE(285), 1,
      sym_term,
    STATE(375), 1,
      sym_atom,
    ACTIONS(523), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10479] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(615), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(388), 1,
      sym_optimizeweight,
    STATE(624), 1,
      sym_minelemlist,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10543] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(615), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(404), 1,
      sym_optimizeweight,
    STATE(593), 1,
      sym_maxelemlist,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10607] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      sym_RBRACE,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(633), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10673] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(617), 1,
      sym_RPAREN,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(579), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10739] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(619), 1,
      sym_RPAREN,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(580), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10805] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(621), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(533), 1,
      sym_ntermvec,
    STATE(556), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10869] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(623), 1,
      sym_RBRACK,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(584), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10935] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(353), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(152), 1,
      sym__widentifier,
    STATE(282), 1,
      sym_term,
    STATE(448), 1,
      sym_atom,
    ACTIONS(351), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10999] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(597), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(533), 1,
      sym_ntermvec,
    STATE(649), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11063] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(623), 1,
      sym_RBRACE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(587), 1,
      sym_theory_opterm_nlist,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11129] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(533), 1,
      sym_ntermvec,
    STATE(648), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11190] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(611), 1,
      sym_CSP_MUL,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(517), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(519), 9,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [11239] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(533), 1,
      sym_ntermvec,
    STATE(554), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11300] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(533), 1,
      sym_ntermvec,
    STATE(555), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11361] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(193), 1,
      sym_DOT,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(625), 1,
      sym_CSP,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(330), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11422] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(623), 1,
      sym_RPAREN,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(398), 1,
      sym_dec,
    STATE(407), 1,
      sym_theory_opterm,
    STATE(415), 1,
      sym_theory_term,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11485] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(559), 1,
      sym_CSP,
    STATE(32), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    STATE(321), 1,
      sym_csp_mul_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11546] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(627), 1,
      sym_COLON,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(616), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11607] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(295), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(629), 2,
      sym_RPAREN,
      sym_SEM,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11666] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      sym_RPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(377), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11729] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    STATE(302), 1,
      sym_csp_mul_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11790] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(533), 1,
      sym_ntermvec,
    STATE(647), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11851] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(603), 1,
      sym_RPAREN,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(398), 1,
      sym_dec,
    STATE(412), 1,
      sym_theory_opterm,
    STATE(415), 1,
      sym_theory_term,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11914] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_RPAREN,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(398), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_opterm,
    STATE(415), 1,
      sym_theory_term,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11977] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    ACTIONS(609), 1,
      sym_CSP,
    STATE(109), 1,
      sym_dec,
    STATE(110), 1,
      sym_term,
    STATE(179), 1,
      sym__widentifier,
    STATE(302), 1,
      sym_csp_mul_term,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12038] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(605), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(607), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [12085] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    ACTIONS(631), 1,
      sym_COLON,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(638), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12146] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(506), 1,
      sym_optimizeweight,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12204] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(512), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12262] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(399), 1,
      sym_optimizeweight,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12320] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(635), 1,
      sym_LBRACE,
    ACTIONS(637), 1,
      sym_LBRACK,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(641), 1,
      anon_sym_0,
    ACTIONS(643), 1,
      aux_sym_dec_token1,
    ACTIONS(647), 1,
      sym_identifier,
    ACTIONS(649), 1,
      anon_sym_DQUOTE,
    STATE(265), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(416), 1,
      sym_theory_opterm,
    STATE(455), 1,
      sym_theory_term,
    STATE(479), 1,
      sym_dec,
    STATE(453), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(633), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(645), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12380] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      sym_AT,
    ACTIONS(657), 1,
      sym_LPAREN,
    ACTIONS(659), 1,
      sym_RPAREN,
    ACTIONS(661), 1,
      sym_VBAR,
    ACTIONS(663), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(200), 1,
      sym__widentifier,
    STATE(344), 1,
      sym_constterm,
    STATE(615), 1,
      sym_consttermvec,
    STATE(663), 1,
      sym_nconstargvec,
    ACTIONS(653), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(655), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(312), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12440] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    STATE(258), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(362), 1,
      sym_theory_opterm,
    STATE(379), 1,
      sym_theory_term,
    STATE(390), 1,
      sym_dec,
    STATE(381), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12500] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      sym_AT,
    ACTIONS(657), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      sym_VBAR,
    ACTIONS(663), 1,
      sym_identifier,
    ACTIONS(665), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(200), 1,
      sym__widentifier,
    STATE(344), 1,
      sym_constterm,
    STATE(615), 1,
      sym_consttermvec,
    STATE(670), 1,
      sym_nconstargvec,
    ACTIONS(653), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(655), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(312), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12560] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(334), 1,
      sym_term,
    STATE(566), 1,
      sym_unaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12618] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(669), 1,
      sym_LBRACE,
    ACTIONS(671), 1,
      sym_LBRACK,
    ACTIONS(673), 1,
      sym_LPAREN,
    ACTIONS(675), 1,
      anon_sym_0,
    ACTIONS(677), 1,
      aux_sym_dec_token1,
    ACTIONS(681), 1,
      sym_identifier,
    ACTIONS(683), 1,
      anon_sym_DQUOTE,
    STATE(266), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(371), 1,
      sym_theory_opterm,
    STATE(427), 1,
      sym_theory_term,
    STATE(441), 1,
      sym_dec,
    STATE(425), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(667), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(679), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12678] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(669), 1,
      sym_LBRACE,
    ACTIONS(671), 1,
      sym_LBRACK,
    ACTIONS(673), 1,
      sym_LPAREN,
    ACTIONS(675), 1,
      anon_sym_0,
    ACTIONS(677), 1,
      aux_sym_dec_token1,
    ACTIONS(681), 1,
      sym_identifier,
    ACTIONS(683), 1,
      anon_sym_DQUOTE,
    STATE(266), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(369), 1,
      sym_theory_opterm,
    STATE(427), 1,
      sym_theory_term,
    STATE(441), 1,
      sym_dec,
    STATE(425), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(667), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(679), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12738] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(339), 1,
      sym_term,
    STATE(576), 1,
      sym_binaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12796] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(635), 1,
      sym_LBRACE,
    ACTIONS(637), 1,
      sym_LBRACK,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(641), 1,
      anon_sym_0,
    ACTIONS(643), 1,
      aux_sym_dec_token1,
    ACTIONS(647), 1,
      sym_identifier,
    ACTIONS(649), 1,
      anon_sym_DQUOTE,
    STATE(265), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(395), 1,
      sym_theory_opterm,
    STATE(455), 1,
      sym_theory_term,
    STATE(479), 1,
      sym_dec,
    STATE(453), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(633), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(645), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12856] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(398), 1,
      sym_dec,
    STATE(415), 1,
      sym_theory_term,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12916] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(401), 1,
      sym_optimizeweight,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12974] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(445), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13032] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(687), 3,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(685), 19,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [13062] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(334), 1,
      sym_term,
    STATE(640), 1,
      sym_unaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13120] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(179), 1,
      sym__widentifier,
    STATE(293), 1,
      sym_term,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13175] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(346), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13230] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(40), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13285] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(164), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13340] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(341), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13395] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(345), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13450] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13505] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(179), 1,
      sym__widentifier,
    STATE(292), 1,
      sym_term,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13560] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(305), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13615] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13670] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(295), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13725] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(179), 1,
      sym__widentifier,
    STATE(336), 1,
      sym_term,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13780] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(340), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13835] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(338), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13890] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(180), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13945] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(35), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14000] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(41), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14055] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(179), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14110] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(160), 1,
      sym_term,
    STATE(179), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14165] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(313), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14220] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(329), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14275] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(44), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14330] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14385] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(42), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14440] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(43), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14495] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(335), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14550] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(298), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14605] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(118), 1,
      sym_term,
    STATE(179), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14660] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(115), 1,
      sym_term,
    STATE(179), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14715] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(328), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14770] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(343), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14825] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(114), 1,
      sym_term,
    STATE(179), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14880] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(113), 1,
      sym_term,
    STATE(179), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14935] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(46), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14990] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(111), 1,
      sym_term,
    STATE(179), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15045] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(194), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15100] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(45), 1,
      sym_term,
    STATE(181), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15155] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(133), 1,
      sym_term,
    STATE(179), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15210] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym__widentifier,
    STATE(332), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15265] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      sym_AT,
    ACTIONS(657), 1,
      sym_LPAREN,
    ACTIONS(659), 1,
      sym_RPAREN,
    ACTIONS(661), 1,
      sym_VBAR,
    ACTIONS(663), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(200), 1,
      sym__widentifier,
    STATE(344), 1,
      sym_constterm,
    STATE(613), 1,
      sym_consttermvec,
    ACTIONS(653), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(655), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(312), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15322] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(689), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(40), 1,
      sym_term,
    STATE(177), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15377] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(112), 1,
      sym_term,
    STATE(179), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15432] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(123), 1,
      sym_term,
    STATE(179), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15487] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(691), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(40), 1,
      sym_term,
    STATE(158), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(39), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15542] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(109), 1,
      sym_dec,
    STATE(131), 1,
      sym_term,
    STATE(179), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(129), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15597] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    STATE(306), 1,
      sym_theory_op,
    STATE(390), 1,
      sym_dec,
    STATE(411), 1,
      sym_theory_term,
    STATE(381), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15651] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(693), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [15679] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      sym_AT,
    ACTIONS(657), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      sym_VBAR,
    ACTIONS(663), 1,
      sym_identifier,
    ACTIONS(697), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(200), 1,
      sym__widentifier,
    STATE(342), 1,
      sym_constterm,
    ACTIONS(653), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(655), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(312), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15733] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    STATE(306), 1,
      sym_theory_op,
    STATE(390), 1,
      sym_dec,
    STATE(418), 1,
      sym_theory_term,
    STATE(381), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15787] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    STATE(306), 1,
      sym_theory_op,
    STATE(398), 1,
      sym_dec,
    STATE(421), 1,
      sym_theory_term,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(701), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(699), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [15869] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(563), 1,
      sym_LBRACE,
    ACTIONS(565), 1,
      sym_LBRACK,
    ACTIONS(567), 1,
      sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_0,
    ACTIONS(573), 1,
      aux_sym_dec_token1,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(581), 1,
      anon_sym_DQUOTE,
    STATE(306), 1,
      sym_theory_op,
    STATE(398), 1,
      sym_dec,
    STATE(410), 1,
      sym_theory_term,
    STATE(396), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(561), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(575), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15923] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(635), 1,
      sym_LBRACE,
    ACTIONS(637), 1,
      sym_LBRACK,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(641), 1,
      anon_sym_0,
    ACTIONS(643), 1,
      aux_sym_dec_token1,
    ACTIONS(647), 1,
      sym_identifier,
    ACTIONS(649), 1,
      anon_sym_DQUOTE,
    STATE(306), 1,
      sym_theory_op,
    STATE(460), 1,
      sym_theory_term,
    STATE(479), 1,
      sym_dec,
    STATE(453), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(633), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(645), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15977] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(669), 1,
      sym_LBRACE,
    ACTIONS(671), 1,
      sym_LBRACK,
    ACTIONS(673), 1,
      sym_LPAREN,
    ACTIONS(675), 1,
      anon_sym_0,
    ACTIONS(677), 1,
      aux_sym_dec_token1,
    ACTIONS(681), 1,
      sym_identifier,
    ACTIONS(683), 1,
      anon_sym_DQUOTE,
    STATE(306), 1,
      sym_theory_op,
    STATE(433), 1,
      sym_theory_term,
    STATE(441), 1,
      sym_dec,
    STATE(425), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(667), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(679), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16031] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(703), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16059] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(709), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(707), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16087] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(669), 1,
      sym_LBRACE,
    ACTIONS(671), 1,
      sym_LBRACK,
    ACTIONS(673), 1,
      sym_LPAREN,
    ACTIONS(675), 1,
      anon_sym_0,
    ACTIONS(677), 1,
      aux_sym_dec_token1,
    ACTIONS(681), 1,
      sym_identifier,
    ACTIONS(683), 1,
      anon_sym_DQUOTE,
    STATE(306), 1,
      sym_theory_op,
    STATE(436), 1,
      sym_theory_term,
    STATE(441), 1,
      sym_dec,
    STATE(425), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(667), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(679), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16141] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(713), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(711), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16169] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(579), 1,
      sym_THEORY_OP,
    ACTIONS(635), 1,
      sym_LBRACE,
    ACTIONS(637), 1,
      sym_LBRACK,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(641), 1,
      anon_sym_0,
    ACTIONS(643), 1,
      aux_sym_dec_token1,
    ACTIONS(647), 1,
      sym_identifier,
    ACTIONS(649), 1,
      anon_sym_DQUOTE,
    STATE(306), 1,
      sym_theory_op,
    STATE(465), 1,
      sym_theory_term,
    STATE(479), 1,
      sym_dec,
    STATE(453), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(633), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(645), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16223] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      sym_AT,
    ACTIONS(657), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      sym_VBAR,
    ACTIONS(663), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(200), 1,
      sym__widentifier,
    STATE(324), 1,
      sym_constterm,
    ACTIONS(653), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(655), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(312), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16274] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      sym_AT,
    ACTIONS(657), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      sym_VBAR,
    ACTIONS(663), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(200), 1,
      sym__widentifier,
    STATE(354), 1,
      sym_constterm,
    ACTIONS(653), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(655), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(312), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16325] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      sym_AT,
    ACTIONS(657), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      sym_VBAR,
    ACTIONS(663), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(200), 1,
      sym__widentifier,
    STATE(325), 1,
      sym_constterm,
    ACTIONS(653), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(655), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(312), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16376] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      sym_AT,
    ACTIONS(657), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      sym_VBAR,
    ACTIONS(663), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(200), 1,
      sym__widentifier,
    STATE(327), 1,
      sym_constterm,
    ACTIONS(653), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(655), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(312), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16427] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      sym_AT,
    ACTIONS(657), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      sym_VBAR,
    ACTIONS(663), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(200), 1,
      sym__widentifier,
    STATE(342), 1,
      sym_constterm,
    ACTIONS(653), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(655), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(312), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16478] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      sym_AT,
    ACTIONS(657), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      sym_VBAR,
    ACTIONS(663), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(200), 1,
      sym__widentifier,
    STATE(311), 1,
      sym_constterm,
    ACTIONS(653), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(655), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(312), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16529] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      sym_AT,
    ACTIONS(657), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      sym_VBAR,
    ACTIONS(663), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(200), 1,
      sym__widentifier,
    STATE(320), 1,
      sym_constterm,
    ACTIONS(653), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(655), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(312), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16580] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      sym_AT,
    ACTIONS(657), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      sym_VBAR,
    ACTIONS(663), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(200), 1,
      sym__widentifier,
    STATE(350), 1,
      sym_constterm,
    ACTIONS(653), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(655), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(312), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16631] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      sym_AT,
    ACTIONS(657), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      sym_VBAR,
    ACTIONS(663), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(200), 1,
      sym__widentifier,
    STATE(315), 1,
      sym_constterm,
    ACTIONS(653), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(655), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(312), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16682] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(651), 1,
      sym_AT,
    ACTIONS(657), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      sym_VBAR,
    ACTIONS(663), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(200), 1,
      sym__widentifier,
    STATE(323), 1,
      sym_constterm,
    ACTIONS(653), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(655), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(312), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16733] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    STATE(239), 1,
      sym_cmp,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [16777] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    STATE(220), 1,
      sym_cmp,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [16821] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(717), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(715), 16,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16847] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    STATE(230), 1,
      sym_cmp,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [16891] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(719), 16,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16917] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(725), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(723), 16,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16943] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    STATE(222), 1,
      sym_cmp,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [16987] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(729), 3,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(727), 14,
      sym_COMMA,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_RBRACE,
      sym_SUPREMUM,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
  [17012] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(731), 15,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [17037] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(737), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(735), 15,
      sym_AT,
      sym_BNOT,
      sym_INFIMUM,
      sym_LPAREN,
      sym_RPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [17062] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(507), 1,
      sym_MUL,
    ACTIONS(509), 1,
      sym_POW,
    ACTIONS(511), 1,
      sym_QUESTION,
    ACTIONS(515), 1,
      sym_XOR,
    ACTIONS(499), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(513), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(739), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(741), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17102] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(507), 1,
      sym_MUL,
    ACTIONS(509), 1,
      sym_POW,
    ACTIONS(511), 1,
      sym_QUESTION,
    ACTIONS(515), 1,
      sym_XOR,
    ACTIONS(499), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(513), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(743), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(745), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17142] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(747), 6,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
  [17180] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(749), 6,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
  [17218] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(507), 1,
      sym_MUL,
    ACTIONS(509), 1,
      sym_POW,
    ACTIONS(511), 1,
      sym_QUESTION,
    ACTIONS(515), 1,
      sym_XOR,
    ACTIONS(499), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(513), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(751), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(753), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17258] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(755), 1,
      sym_AT,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(757), 5,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_SEM,
  [17298] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(751), 1,
      sym_DOT,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(753), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [17337] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 3,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(759), 12,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_SUPREMUM,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
  [17360] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(763), 5,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_SEM,
  [17397] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(739), 1,
      sym_DOT,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(741), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [17436] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(765), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(767), 12,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [17459] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(771), 12,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [17482] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(773), 1,
      sym_AND,
    ACTIONS(775), 1,
      sym_RBRACE,
    STATE(695), 1,
      sym_theory_definition_nlist,
    STATE(697), 1,
      sym_theory_definition_identifier,
    STATE(546), 2,
      sym_theory_term_definition,
      sym_theory_atom_definition,
    ACTIONS(777), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [17513] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(743), 1,
      sym_DOT,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(745), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [17552] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(781), 3,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(779), 12,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_SUPREMUM,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
  [17575] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(785), 1,
      sym_MUL,
    ACTIONS(783), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17599] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(789), 1,
      sym_MUL,
    ACTIONS(787), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17623] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(791), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(793), 9,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17647] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(773), 1,
      sym_AND,
    STATE(673), 1,
      sym_theory_definition_nlist,
    STATE(697), 1,
      sym_theory_definition_identifier,
    STATE(546), 2,
      sym_theory_term_definition,
      sym_theory_atom_definition,
    ACTIONS(777), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [17675] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 1,
      sym_MUL,
    ACTIONS(801), 1,
      sym_QUESTION,
    ACTIONS(803), 1,
      sym_XOR,
    ACTIONS(797), 10,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [17700] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(789), 1,
      sym_MUL,
    ACTIONS(787), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17721] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(807), 1,
      sym_DOT,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(805), 2,
      sym_COMMA,
      sym_SEM,
  [17758] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym_MUL,
    ACTIONS(809), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17779] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 1,
      sym_MUL,
    ACTIONS(797), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17800] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(815), 1,
      sym_DOT,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(813), 2,
      sym_COMMA,
      sym_SEM,
  [17837] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(817), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(793), 9,
      sym_COLON,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [17860] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(771), 11,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [17881] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 1,
      sym_COLON,
    STATE(161), 1,
      sym_csp_rel,
    ACTIONS(825), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(823), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
    ACTIONS(821), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17908] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 1,
      sym_MUL,
    ACTIONS(803), 1,
      sym_XOR,
    ACTIONS(797), 11,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [17931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(765), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(767), 11,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [17952] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 1,
      sym_MUL,
    ACTIONS(797), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17973] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 1,
      sym_MUL,
    ACTIONS(801), 1,
      sym_QUESTION,
    ACTIONS(803), 1,
      sym_XOR,
    ACTIONS(827), 1,
      sym_AND,
    ACTIONS(797), 9,
      sym_ADD,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [18000] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(801), 1,
      sym_QUESTION,
    ACTIONS(803), 1,
      sym_XOR,
    ACTIONS(827), 1,
      sym_AND,
    ACTIONS(833), 1,
      sym_MUL,
    ACTIONS(835), 1,
      sym_POW,
    ACTIONS(829), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(831), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(797), 4,
      sym_COMMA,
      sym_DOT,
      sym_RPAREN,
      sym_VBAR,
  [18033] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 1,
      sym_MUL,
    ACTIONS(801), 1,
      sym_QUESTION,
    ACTIONS(803), 1,
      sym_XOR,
    ACTIONS(827), 1,
      sym_AND,
    ACTIONS(829), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(797), 7,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_VBAR,
  [18062] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_MUL,
    ACTIONS(783), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [18083] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(801), 1,
      sym_QUESTION,
    ACTIONS(803), 1,
      sym_XOR,
    ACTIONS(827), 1,
      sym_AND,
    ACTIONS(833), 1,
      sym_MUL,
    ACTIONS(835), 1,
      sym_POW,
    ACTIONS(829), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(831), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(783), 4,
      sym_COMMA,
      sym_DOT,
      sym_RPAREN,
      sym_VBAR,
  [18116] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(837), 2,
      sym_SEM,
      sym_VBAR,
  [18150] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(839), 1,
      sym_COLON,
    ACTIONS(841), 1,
      sym_DOT,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18186] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(843), 1,
      sym_COLON,
    ACTIONS(845), 1,
      sym_DOT,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18222] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(146), 1,
      sym_csp_rel,
    ACTIONS(825), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(823), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
    ACTIONS(821), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [18246] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(847), 1,
      sym_AT,
    ACTIONS(849), 1,
      sym_COMMA,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18282] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(851), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(793), 8,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [18304] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(853), 2,
      sym_SEM,
      sym_VBAR,
  [18338] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(855), 2,
      sym_RPAREN,
      sym_SEM,
  [18372] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(507), 1,
      sym_MUL,
    ACTIONS(509), 1,
      sym_POW,
    ACTIONS(511), 1,
      sym_QUESTION,
    ACTIONS(515), 1,
      sym_XOR,
    ACTIONS(805), 1,
      sym_IF,
    ACTIONS(807), 1,
      sym_DOT,
    ACTIONS(499), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(513), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18408] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_DOTS,
    ACTIONS(507), 1,
      sym_MUL,
    ACTIONS(509), 1,
      sym_POW,
    ACTIONS(511), 1,
      sym_QUESTION,
    ACTIONS(515), 1,
      sym_XOR,
    ACTIONS(813), 1,
      sym_IF,
    ACTIONS(815), 1,
      sym_DOT,
    ACTIONS(499), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(513), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18444] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(857), 2,
      sym_RPAREN,
      sym_SEM,
  [18478] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(859), 1,
      sym_COMMA,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18511] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(861), 1,
      sym_COMMA,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18544] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(863), 1,
      sym_RBRACK,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18577] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(801), 1,
      sym_QUESTION,
    ACTIONS(803), 1,
      sym_XOR,
    ACTIONS(827), 1,
      sym_AND,
    ACTIONS(833), 1,
      sym_MUL,
    ACTIONS(835), 1,
      sym_POW,
    ACTIONS(829), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(831), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(865), 2,
      sym_COMMA,
      sym_RPAREN,
  [18608] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(867), 1,
      sym_RBRACK,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18641] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(801), 1,
      sym_QUESTION,
    ACTIONS(803), 1,
      sym_XOR,
    ACTIONS(827), 1,
      sym_AND,
    ACTIONS(833), 1,
      sym_MUL,
    ACTIONS(835), 1,
      sym_POW,
    ACTIONS(829), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(831), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(869), 2,
      sym_COMMA,
      sym_RPAREN,
  [18672] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(871), 1,
      sym_RBRACK,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18705] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(873), 1,
      sym_COMMA,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18738] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(148), 1,
      sym_csp_rel,
    ACTIONS(825), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(821), 4,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(823), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [18761] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      sym_AND,
    ACTIONS(307), 1,
      sym_DOTS,
    ACTIONS(309), 1,
      sym_QUESTION,
    ACTIONS(311), 1,
      sym_XOR,
    ACTIONS(319), 1,
      sym_MUL,
    ACTIONS(321), 1,
      sym_POW,
    ACTIONS(875), 1,
      sym_RBRACK,
    ACTIONS(317), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18794] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(684), 1,
      sym_theory_definition_identifier,
    ACTIONS(777), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [18812] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(801), 1,
      sym_QUESTION,
    ACTIONS(803), 1,
      sym_XOR,
    ACTIONS(827), 1,
      sym_AND,
    ACTIONS(833), 1,
      sym_MUL,
    ACTIONS(835), 1,
      sym_POW,
    ACTIONS(877), 1,
      sym_DOT,
    ACTIONS(829), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(831), 2,
      sym_MOD,
      sym_SLASH,
  [18842] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(666), 1,
      sym_theory_definition_identifier,
    ACTIONS(777), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [18860] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(700), 1,
      sym_theory_definition_identifier,
    ACTIONS(777), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [18878] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(698), 1,
      sym_theory_definition_identifier,
    ACTIONS(777), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [18896] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 1,
      sym_VBAR,
    ACTIONS(801), 1,
      sym_QUESTION,
    ACTIONS(803), 1,
      sym_XOR,
    ACTIONS(827), 1,
      sym_AND,
    ACTIONS(833), 1,
      sym_MUL,
    ACTIONS(835), 1,
      sym_POW,
    ACTIONS(829), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(831), 2,
      sym_MOD,
      sym_SLASH,
  [18926] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(146), 1,
      sym_csp_rel,
    ACTIONS(825), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(851), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(823), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [18947] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(148), 1,
      sym_csp_rel,
    ACTIONS(825), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(851), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(823), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [18968] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(161), 1,
      sym_csp_rel,
    ACTIONS(825), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(851), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(823), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [18989] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 1,
      sym_COMMA,
    ACTIONS(879), 1,
      sym_COLON,
    STATE(263), 1,
      sym_dsym,
    STATE(642), 1,
      sym_noptcondition,
    ACTIONS(371), 2,
      sym_DOT,
      sym_IF,
    ACTIONS(881), 2,
      sym_SEM,
      sym_VBAR,
  [19013] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(264), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(579), 2,
      sym_THEORY_OP,
      sym_NOT,
    ACTIONS(883), 4,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
  [19033] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      sym_NOT,
    STATE(261), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(885), 2,
      sym_COLON,
      sym_SEM,
    ACTIONS(887), 2,
      sym_COMMA,
      sym_RBRACE,
  [19057] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(264), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(579), 2,
      sym_THEORY_OP,
      sym_NOT,
    ACTIONS(887), 4,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
  [19077] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      sym_NOT,
    STATE(261), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(883), 2,
      sym_COMMA,
      sym_RBRACE,
    ACTIONS(889), 2,
      sym_COLON,
      sym_SEM,
  [19101] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 1,
      sym_COLON,
    ACTIONS(821), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19116] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(891), 1,
      sym_COLON,
    ACTIONS(893), 1,
      sym_COMMA,
    STATE(270), 1,
      sym_dsym,
    ACTIONS(881), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(895), 2,
      sym_DOT,
      sym_IF,
  [19137] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(325), 1,
      sym_COLON,
    ACTIONS(327), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19152] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(32), 1,
      sym_dec,
    STATE(676), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19173] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      sym_LPAREN,
    ACTIONS(897), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(899), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19190] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(903), 1,
      sym_COLON,
    ACTIONS(905), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19205] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      sym_NOT,
    ACTIONS(907), 1,
      sym_COMMA,
    STATE(269), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(909), 2,
      sym_DOT,
      sym_SEM,
  [19228] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(32), 1,
      sym_dec,
    STATE(681), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19249] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      sym_NOT,
    ACTIONS(911), 1,
      sym_COMMA,
    STATE(269), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(913), 2,
      sym_DOT,
      sym_SEM,
  [19272] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(32), 1,
      sym_dec,
    STATE(678), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19293] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 1,
      sym_COLON,
    ACTIONS(339), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19308] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(32), 1,
      sym_dec,
    STATE(651), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19329] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(743), 1,
      sym_COLON,
    ACTIONS(745), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19344] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      sym_LPAREN,
    ACTIONS(899), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19359] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(595), 1,
      sym_RPAREN,
    ACTIONS(917), 1,
      sym_COMMA,
    STATE(264), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(579), 2,
      sym_THEORY_OP,
      sym_NOT,
  [19379] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_COLON,
    STATE(629), 1,
      sym_noptcondition,
    ACTIONS(817), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(921), 2,
      sym_RBRACE,
      sym_SEM,
  [19397] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(925), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19411] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_COLON,
    STATE(607), 1,
      sym_noptcondition,
    ACTIONS(817), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(927), 2,
      sym_RBRACE,
      sym_SEM,
  [19429] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(899), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19443] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(929), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [19457] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(277), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19471] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19483] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(931), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(933), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19497] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(295), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19511] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(937), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19525] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 1,
      sym_COLON,
    ACTIONS(941), 1,
      sym_COMMA,
    STATE(454), 1,
      sym_noptimizetuple,
    STATE(536), 1,
      sym_noptimizecond,
    ACTIONS(943), 2,
      sym_RBRACE,
      sym_SEM,
  [19545] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19557] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(291), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19571] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(945), 1,
      sym_COMMA,
    STATE(259), 1,
      sym_dsym,
    ACTIONS(881), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(947), 2,
      sym_DOT,
      sym_IF,
  [19589] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(287), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19603] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      sym_NOT,
    ACTIONS(949), 1,
      sym_COMMA,
    STATE(205), 1,
      sym_theory_op,
    ACTIONS(951), 2,
      sym_DOT,
      sym_SEM,
  [19623] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(953), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19635] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      sym_NOT,
    STATE(271), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(913), 2,
      sym_DOT,
      sym_IF,
  [19655] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19667] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(945), 1,
      sym_COMMA,
    STATE(267), 1,
      sym_dsym,
    ACTIONS(881), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(955), 2,
      sym_DOT,
      sym_IF,
  [19685] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19697] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 1,
      sym_COLON,
    ACTIONS(941), 1,
      sym_COMMA,
    STATE(468), 1,
      sym_noptimizetuple,
    STATE(603), 1,
      sym_noptimizecond,
    ACTIONS(957), 2,
      sym_RBRACE,
      sym_SEM,
  [19717] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19729] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 1,
      sym_COLON,
    ACTIONS(941), 1,
      sym_COMMA,
    STATE(466), 1,
      sym_noptimizetuple,
    STATE(602), 1,
      sym_noptimizecond,
    ACTIONS(959), 2,
      sym_RBRACE,
      sym_SEM,
  [19749] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_COLON,
    STATE(583), 1,
      sym_noptcondition,
    ACTIONS(817), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(961), 2,
      sym_RBRACE,
      sym_SEM,
  [19767] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      sym_RPAREN,
    ACTIONS(963), 1,
      sym_COMMA,
    STATE(264), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(579), 2,
      sym_THEORY_OP,
      sym_NOT,
  [19787] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 1,
      sym_COLON,
    ACTIONS(941), 1,
      sym_COMMA,
    STATE(469), 1,
      sym_noptimizetuple,
    STATE(604), 1,
      sym_noptimizecond,
    ACTIONS(965), 2,
      sym_RBRACE,
      sym_SEM,
  [19807] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(967), 1,
      sym_RBRACE,
    STATE(596), 1,
      sym_theory_operator_definition_nlist,
    STATE(597), 1,
      sym_theory_operator_definition,
    STATE(672), 1,
      sym_theory_op,
    ACTIONS(969), 2,
      sym_THEORY_OP,
      sym_NOT,
  [19827] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19839] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(619), 1,
      sym_RPAREN,
    ACTIONS(973), 1,
      sym_COMMA,
    STATE(264), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(579), 2,
      sym_THEORY_OP,
      sym_NOT,
  [19859] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(937), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19871] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(975), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19883] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(977), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19895] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(981), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19909] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 1,
      sym_RPAREN,
    ACTIONS(983), 1,
      sym_COMMA,
    STATE(264), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(579), 2,
      sym_THEORY_OP,
      sym_NOT,
  [19929] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_COLON,
    STATE(590), 1,
      sym_noptcondition,
    ACTIONS(817), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(985), 2,
      sym_RBRACE,
      sym_SEM,
  [19947] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(987), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(989), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19961] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19973] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      sym_NOT,
    STATE(271), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(909), 2,
      sym_DOT,
      sym_IF,
  [19993] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(991), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [20007] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(977), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(993), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [20021] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20033] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      sym_NOT,
    ACTIONS(995), 1,
      sym_COMMA,
    STATE(204), 1,
      sym_theory_op,
    ACTIONS(997), 2,
      sym_DOT,
      sym_SEM,
  [20053] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20065] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(933), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20077] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(999), 1,
      sym_LPAREN,
    ACTIONS(899), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(897), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20093] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      sym_LBRACE,
    STATE(569), 1,
      sym_theory_atom_type,
    ACTIONS(1003), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [20109] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(897), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20122] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_COLON,
    ACTIONS(1005), 1,
      sym_COMMA,
    STATE(606), 1,
      sym_noptcondition,
    ACTIONS(395), 2,
      sym_RBRACE,
      sym_SEM,
  [20139] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(923), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20152] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_COLON,
    ACTIONS(1007), 1,
      sym_COMMA,
    STATE(632), 1,
      sym_noptcondition,
    ACTIONS(397), 2,
      sym_RBRACE,
      sym_SEM,
  [20169] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(933), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(931), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20182] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      sym_NOT,
    STATE(207), 1,
      sym_theory_op,
    ACTIONS(997), 2,
      sym_DOT,
      sym_IF,
  [20199] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_RBRACE,
    STATE(537), 1,
      sym_theory_op,
    STATE(538), 1,
      sym_theory_operator_nlist,
    ACTIONS(579), 2,
      sym_THEORY_OP,
      sym_NOT,
  [20216] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 1,
      sym_NOT,
    ACTIONS(1011), 1,
      sym_LPAREN,
    ACTIONS(897), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20231] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(979), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20244] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(987), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20257] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1013), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [20268] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(977), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(993), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20281] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(937), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(935), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20294] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(991), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20307] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(544), 1,
      sym_theory_atom_type,
    ACTIONS(1003), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [20320] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(287), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20333] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(291), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20346] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(295), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20359] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(277), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(545), 1,
      sym_theory_atom_type,
    ACTIONS(1003), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [20385] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1007), 1,
      sym_COMMA,
    ACTIONS(1015), 4,
      sym_COLON,
      sym_RBRACE,
      sym_RBRACK,
      sym_SEM,
  [20398] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20409] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(339), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20420] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20431] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20442] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(327), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20453] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [20464] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      sym_NOT,
    STATE(199), 1,
      sym_theory_op,
    ACTIONS(951), 2,
      sym_DOT,
      sym_IF,
  [20481] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 1,
      sym_NOT,
    ACTIONS(897), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20493] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 1,
      sym_COLON,
    STATE(625), 1,
      sym_noptimizecond,
    ACTIONS(1019), 2,
      sym_RBRACE,
      sym_SEM,
  [20507] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 1,
      sym_NOT,
    ACTIONS(923), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20519] = 4,
    ACTIONS(1021), 1,
      sym_comment,
    ACTIONS(1023), 1,
      anon_sym_DQUOTE,
    STATE(490), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1025), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20533] = 4,
    ACTIONS(1021), 1,
      sym_comment,
    ACTIONS(1027), 1,
      anon_sym_DQUOTE,
    STATE(456), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1029), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20547] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_COLON,
    STATE(585), 1,
      sym_noptcondition,
    ACTIONS(1031), 2,
      sym_RBRACE,
      sym_SEM,
  [20561] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_COLON,
    STATE(630), 1,
      sym_noptcondition,
    ACTIONS(1033), 2,
      sym_RBRACE,
      sym_SEM,
  [20575] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym_NOT,
    ACTIONS(979), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20587] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 1,
      sym_NOT,
    ACTIONS(987), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20599] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1035), 1,
      sym_SUB,
    ACTIONS(1037), 1,
      sym_identifier,
    STATE(149), 1,
      sym__widentifier,
    STATE(498), 1,
      sym_atom,
  [20615] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_COLON,
    STATE(572), 1,
      sym_noptcondition,
    ACTIONS(1039), 2,
      sym_RBRACE,
      sym_SEM,
  [20629] = 4,
    ACTIONS(1021), 1,
      sym_comment,
    ACTIONS(1041), 1,
      anon_sym_DQUOTE,
    STATE(490), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1025), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20643] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(977), 1,
      sym_NOT,
    ACTIONS(993), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20655] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 1,
      sym_COLON,
    STATE(588), 1,
      sym_noptimizecond,
    ACTIONS(1043), 2,
      sym_RBRACE,
      sym_SEM,
  [20669] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(937), 1,
      sym_NOT,
    ACTIONS(935), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20681] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 1,
      sym_COLON,
    STATE(589), 1,
      sym_noptimizecond,
    ACTIONS(1045), 2,
      sym_RBRACE,
      sym_SEM,
  [20695] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 1,
      sym_COLON,
    STATE(628), 1,
      sym_noptimizecond,
    ACTIONS(1047), 2,
      sym_RBRACE,
      sym_SEM,
  [20709] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym_NOT,
    ACTIONS(991), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20721] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1049), 1,
      sym_SUB,
    ACTIONS(1051), 1,
      sym_identifier,
    STATE(149), 1,
      sym__widentifier,
    STATE(508), 1,
      sym_atom,
  [20737] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(1053), 1,
      sym_SLASH,
    ACTIONS(327), 2,
      sym_COLON,
      sym_DOT,
  [20751] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1055), 1,
      sym_COLON,
    ACTIONS(1059), 1,
      sym_DOT,
    ACTIONS(1057), 2,
      sym_COMMA,
      sym_SEM,
  [20765] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_COLON,
    STATE(617), 1,
      sym_noptcondition,
    ACTIONS(1061), 2,
      sym_RBRACE,
      sym_SEM,
  [20779] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 1,
      sym_NOT,
    ACTIONS(287), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20791] = 4,
    ACTIONS(1021), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_DQUOTE,
    STATE(493), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1065), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20805] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1055), 1,
      sym_COLON,
    ACTIONS(1069), 1,
      sym_DOT,
    ACTIONS(1067), 2,
      sym_COMMA,
      sym_SEM,
  [20819] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(578), 1,
      sym_theory_operator_definition,
    STATE(672), 1,
      sym_theory_op,
    ACTIONS(969), 2,
      sym_THEORY_OP,
      sym_NOT,
  [20833] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 1,
      sym_NOT,
    ACTIONS(291), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20845] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_COLON,
    STATE(577), 1,
      sym_noptcondition,
    ACTIONS(1071), 2,
      sym_RBRACE,
      sym_SEM,
  [20859] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1075), 1,
      sym_LBRACE,
    ACTIONS(1073), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [20871] = 4,
    ACTIONS(1021), 1,
      sym_comment,
    ACTIONS(1077), 1,
      anon_sym_DQUOTE,
    STATE(489), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1079), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 1,
      sym_NOT,
    ACTIONS(295), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20897] = 4,
    ACTIONS(1021), 1,
      sym_comment,
    ACTIONS(1081), 1,
      anon_sym_DQUOTE,
    STATE(464), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1083), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20911] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_COLON,
    STATE(594), 1,
      sym_noptcondition,
    ACTIONS(1085), 2,
      sym_RBRACE,
      sym_SEM,
  [20925] = 4,
    ACTIONS(1021), 1,
      sym_comment,
    ACTIONS(1087), 1,
      anon_sym_DQUOTE,
    STATE(490), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1025), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20939] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 1,
      sym_NOT,
    ACTIONS(277), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20951] = 4,
    ACTIONS(1021), 1,
      sym_comment,
    ACTIONS(1089), 1,
      anon_sym_DQUOTE,
    STATE(497), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1091), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20965] = 4,
    ACTIONS(1021), 1,
      sym_comment,
    ACTIONS(1093), 1,
      anon_sym_DQUOTE,
    STATE(490), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1025), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20979] = 4,
    ACTIONS(1021), 1,
      sym_comment,
    ACTIONS(1095), 1,
      anon_sym_DQUOTE,
    STATE(490), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1097), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20993] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(1100), 1,
      sym_SLASH,
    ACTIONS(331), 2,
      sym_COLON,
      sym_DOT,
  [21007] = 4,
    ACTIONS(1021), 1,
      sym_comment,
    ACTIONS(1102), 1,
      anon_sym_DQUOTE,
    STATE(486), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1104), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21021] = 4,
    ACTIONS(1021), 1,
      sym_comment,
    ACTIONS(1106), 1,
      anon_sym_DQUOTE,
    STATE(490), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1025), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21035] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(933), 1,
      sym_NOT,
    ACTIONS(931), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21047] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_COLON,
    STATE(574), 1,
      sym_noptcondition,
    ACTIONS(1108), 2,
      sym_RBRACE,
      sym_SEM,
  [21061] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1035), 1,
      sym_SUB,
    ACTIONS(1037), 1,
      sym_identifier,
    STATE(149), 1,
      sym__widentifier,
    STATE(636), 1,
      sym_atom,
  [21077] = 4,
    ACTIONS(1021), 1,
      sym_comment,
    ACTIONS(1110), 1,
      anon_sym_DQUOTE,
    STATE(490), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1025), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21091] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1112), 1,
      sym_COLON,
    ACTIONS(1114), 1,
      sym_DOT,
    STATE(671), 1,
      sym_bodyconddot,
  [21104] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(775), 1,
      sym_RPAREN,
    ACTIONS(1116), 1,
      sym_identifier,
    STATE(543), 1,
      sym_nidlist,
  [21117] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 1,
      sym_COMMA,
    ACTIONS(955), 2,
      sym_RBRACE,
      sym_SEM,
  [21128] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1120), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [21137] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(1122), 1,
      sym_LT,
    STATE(660), 1,
      sym_STRING,
  [21150] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1124), 1,
      sym_COMMA,
    ACTIONS(1126), 2,
      sym_RPAREN,
      sym_SEM,
  [21161] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1128), 3,
      sym_COMMA,
      sym_LBRACE,
      sym_SLASH,
  [21170] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(542), 1,
      sym_theory_op,
    ACTIONS(579), 2,
      sym_THEORY_OP,
      sym_NOT,
  [21181] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_COMMA,
    ACTIONS(1130), 1,
      sym_RBRACK,
    STATE(664), 1,
      sym_noptimizetuple,
  [21194] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(327), 2,
      sym_COLON,
      sym_DOT,
  [21205] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1112), 1,
      sym_COLON,
    ACTIONS(1114), 1,
      sym_DOT,
    STATE(25), 1,
      sym_bodyconddot,
  [21218] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1132), 1,
      sym_identifier,
    STATE(174), 1,
      sym__widentifier,
    STATE(530), 1,
      sym_theory_atom_name,
  [21231] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1136), 1,
      sym_identifier,
    ACTIONS(1134), 2,
      sym_CSP,
      sym_SUB,
  [21242] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1112), 1,
      sym_COLON,
    ACTIONS(1114), 1,
      sym_DOT,
    STATE(26), 1,
      sym_bodyconddot,
  [21255] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1007), 1,
      sym_COMMA,
    ACTIONS(1138), 2,
      sym_RPAREN,
      sym_SEM,
  [21266] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1140), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [21275] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21284] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1142), 1,
      sym_COMMA,
    ACTIONS(1144), 2,
      sym_RBRACE,
      sym_SEM,
  [21295] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1146), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1069), 1,
      sym_DOT,
    ACTIONS(1067), 2,
      sym_COMMA,
      sym_SEM,
  [21315] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1150), 1,
      sym_DOT,
    ACTIONS(1148), 2,
      sym_COMMA,
      sym_SEM,
  [21326] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1152), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [21335] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 1,
      sym_COMMA,
    ACTIONS(1154), 2,
      sym_DOT,
      sym_SEM,
  [21346] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1132), 1,
      sym_identifier,
    STATE(174), 1,
      sym__widentifier,
    STATE(481), 1,
      sym_theory_atom_name,
  [21359] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21368] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1059), 1,
      sym_DOT,
    ACTIONS(1057), 2,
      sym_COMMA,
      sym_SEM,
  [21388] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 1,
      sym_COMMA,
    ACTIONS(1156), 2,
      sym_RBRACE,
      sym_SEM,
  [21399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1160), 1,
      sym_DOT,
    ACTIONS(1158), 2,
      sym_COMMA,
      sym_SEM,
  [21410] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1162), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21419] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 1,
      sym_COMMA,
    ACTIONS(1164), 2,
      sym_RBRACE,
      sym_SEM,
  [21430] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1166), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21439] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1168), 1,
      sym_LBRACE,
    ACTIONS(1073), 2,
      sym_DOT,
      sym_IF,
  [21450] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    ACTIONS(331), 2,
      sym_COLON,
      sym_DOT,
  [21461] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1170), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [21470] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1007), 1,
      sym_COMMA,
    ACTIONS(1172), 2,
      sym_RPAREN,
      sym_SEM,
  [21481] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1174), 1,
      sym_RBRACE,
    ACTIONS(1176), 1,
      sym_SEM,
  [21491] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1178), 1,
      sym_RBRACE,
    ACTIONS(1180), 1,
      sym_SEM,
  [21501] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1019), 2,
      sym_RBRACE,
      sym_SEM,
  [21509] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1182), 2,
      sym_COMMA,
      sym_RBRACE,
  [21517] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1184), 1,
      sym_COMMA,
    ACTIONS(1186), 1,
      sym_RBRACE,
  [21527] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1188), 2,
      sym_RBRACE,
      sym_SEM,
  [21535] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1190), 1,
      sym_identifier,
    STATE(182), 1,
      sym__widentifier,
  [21545] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1192), 2,
      sym_COMMA,
      sym_RPAREN,
  [21553] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1194), 2,
      sym_COMMA,
      sym_RBRACE,
  [21561] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1196), 1,
      sym_COMMA,
    ACTIONS(1198), 1,
      sym_RPAREN,
  [21571] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1200), 2,
      sym_RBRACE,
      sym_SEM,
  [21579] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1202), 2,
      sym_RBRACE,
      sym_SEM,
  [21587] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1204), 1,
      sym_RBRACE,
    ACTIONS(1206), 1,
      sym_SEM,
  [21597] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1057), 1,
      sym_SEM,
    ACTIONS(1059), 1,
      sym_DOT,
  [21607] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 1,
      sym_RBRACE,
    ACTIONS(1208), 1,
      sym_SEM,
  [21617] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1210), 2,
      sym_RBRACE,
      sym_SEM,
  [21625] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1212), 1,
      sym_COMMA,
    ACTIONS(1214), 1,
      sym_RPAREN,
  [21635] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(597), 1,
      sym_RPAREN,
    ACTIONS(1216), 1,
      sym_SEM,
  [21645] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(539), 1,
      sym_RBRACE,
    ACTIONS(1176), 1,
      sym_SEM,
  [21655] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1007), 1,
      sym_COMMA,
    ACTIONS(1218), 1,
      sym_COLON,
  [21665] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1216), 1,
      sym_SEM,
    ACTIONS(1220), 1,
      sym_RPAREN,
  [21675] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1216), 1,
      sym_SEM,
    ACTIONS(1222), 1,
      sym_RPAREN,
  [21685] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1216), 1,
      sym_SEM,
    ACTIONS(1224), 1,
      sym_RPAREN,
  [21695] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(405), 2,
      sym_DOT,
      sym_IF,
  [21703] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1226), 1,
      sym_identifier,
    STATE(156), 1,
      sym__widentifier,
  [21713] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 1,
      sym_RPAREN,
    ACTIONS(1212), 1,
      sym_COMMA,
  [21723] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1216), 1,
      sym_SEM,
    ACTIONS(1228), 1,
      sym_RPAREN,
  [21733] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 1,
      sym_RBRACE,
    ACTIONS(1176), 1,
      sym_SEM,
  [21743] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 1,
      sym_RBRACK,
    ACTIONS(1212), 1,
      sym_COMMA,
  [21753] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 1,
      sym_RBRACE,
    ACTIONS(1212), 1,
      sym_COMMA,
  [21763] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1134), 1,
      sym_SUB,
    ACTIONS(1136), 1,
      sym_identifier,
  [21773] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1230), 2,
      sym_RBRACE,
      sym_SEM,
  [21781] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1220), 1,
      sym_VBAR,
    ACTIONS(1232), 1,
      sym_SEM,
  [21791] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1234), 2,
      sym_RBRACE,
      sym_SEM,
  [21799] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1236), 2,
      sym_DOT,
      sym_IF,
  [21807] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1238), 2,
      sym_RBRACE,
      sym_SEM,
  [21815] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 2,
      sym_RBRACE,
      sym_SEM,
  [21823] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 1,
      sym_DOT,
    ACTIONS(1242), 1,
      sym_LPAREN,
  [21833] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1244), 2,
      sym_RBRACE,
      sym_SEM,
  [21841] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1246), 2,
      sym_RBRACE,
      sym_SEM,
  [21849] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1248), 2,
      sym_RBRACE,
      sym_SEM,
  [21857] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1250), 1,
      sym_UNARY,
    ACTIONS(1252), 1,
      sym_BINARY,
  [21867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1254), 1,
      sym_RPAREN,
    ACTIONS(1256), 1,
      sym_SEM,
  [21877] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1258), 2,
      sym_RBRACE,
      sym_SEM,
  [21885] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1260), 2,
      sym_RBRACE,
      sym_SEM,
  [21893] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1212), 1,
      sym_COMMA,
    ACTIONS(1262), 1,
      sym_RPAREN,
  [21903] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(617), 1,
      sym_RPAREN,
    ACTIONS(1212), 1,
      sym_COMMA,
  [21913] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 1,
      sym_SEM,
    ACTIONS(1264), 1,
      sym_RPAREN,
  [21923] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1266), 1,
      sym_RPAREN,
    ACTIONS(1268), 1,
      sym_SEM,
  [21933] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1270), 2,
      sym_RBRACE,
      sym_SEM,
  [21941] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(619), 1,
      sym_RBRACK,
    ACTIONS(1212), 1,
      sym_COMMA,
  [21951] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1071), 2,
      sym_RBRACE,
      sym_SEM,
  [21959] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1272), 2,
      sym_RBRACE,
      sym_SEM,
  [21967] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(619), 1,
      sym_RBRACE,
    ACTIONS(1212), 1,
      sym_COMMA,
  [21977] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1274), 2,
      sym_RBRACE,
      sym_SEM,
  [21985] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1276), 2,
      sym_RBRACE,
      sym_SEM,
  [21993] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 2,
      sym_RBRACE,
      sym_SEM,
  [22001] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      sym_RBRACE,
    ACTIONS(1212), 1,
      sym_COMMA,
  [22011] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1212), 1,
      sym_COMMA,
    ACTIONS(1278), 1,
      sym_RPAREN,
  [22021] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(775), 1,
      sym_RBRACE,
    ACTIONS(1280), 1,
      sym_SEM,
  [22031] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1031), 2,
      sym_RBRACE,
      sym_SEM,
  [22039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      sym_RBRACK,
    ACTIONS(1212), 1,
      sym_COMMA,
  [22049] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1282), 1,
      sym_RBRACE,
    ACTIONS(1284), 1,
      sym_SEM,
  [22059] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1286), 2,
      sym_RBRACE,
      sym_SEM,
  [22067] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1216), 1,
      sym_SEM,
    ACTIONS(1288), 1,
      sym_RPAREN,
  [22077] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 2,
      sym_RPAREN,
      sym_SEM,
  [22085] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1290), 2,
      sym_RBRACE,
      sym_SEM,
  [22093] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1292), 2,
      sym_COMMA,
      sym_RPAREN,
  [22101] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1043), 2,
      sym_RBRACE,
      sym_SEM,
  [22109] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1045), 2,
      sym_RBRACE,
      sym_SEM,
  [22117] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 2,
      sym_RBRACE,
      sym_SEM,
  [22125] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1294), 2,
      sym_RBRACE,
      sym_SEM,
  [22133] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 2,
      sym_RBRACE,
      sym_SEM,
  [22141] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(985), 2,
      sym_RBRACE,
      sym_SEM,
  [22149] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1296), 2,
      sym_DEFAULT,
      sym_OVERRIDE,
  [22157] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1216), 1,
      sym_SEM,
    ACTIONS(1298), 1,
      sym_RPAREN,
  [22167] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(555), 1,
      sym_RBRACE,
    ACTIONS(1300), 1,
      sym_SEM,
  [22177] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1302), 1,
      sym_identifier,
    STATE(202), 1,
      sym__widentifier,
  [22187] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1304), 2,
      sym_RBRACE,
      sym_SEM,
  [22195] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 1,
      sym_RPAREN,
    ACTIONS(1306), 1,
      sym_COMMA,
  [22205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(613), 1,
      sym_RPAREN,
    ACTIONS(1212), 1,
      sym_COMMA,
  [22215] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1308), 1,
      sym_COMMA,
    ACTIONS(1310), 1,
      sym_RPAREN,
  [22225] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1007), 1,
      sym_COMMA,
    ACTIONS(1312), 1,
      sym_COLON,
  [22235] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 2,
      sym_RBRACE,
      sym_SEM,
  [22243] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 2,
      sym_DOT,
      sym_IF,
  [22251] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1314), 2,
      sym_LEFT,
      sym_RIGHT,
  [22259] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1316), 1,
      sym_identifier,
    STATE(688), 1,
      sym_theory_identifier,
  [22269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1212), 1,
      sym_COMMA,
    ACTIONS(1318), 1,
      sym_RPAREN,
  [22279] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(593), 1,
      sym_RPAREN,
    ACTIONS(1212), 1,
      sym_COMMA,
  [22289] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1320), 1,
      sym_RBRACE,
    ACTIONS(1322), 1,
      sym_SEM,
  [22299] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(775), 1,
      sym_RBRACE,
    ACTIONS(1324), 1,
      sym_SEM,
  [22309] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(959), 2,
      sym_RBRACE,
      sym_SEM,
  [22317] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1067), 1,
      sym_SEM,
    ACTIONS(1069), 1,
      sym_DOT,
  [22327] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1326), 1,
      sym_identifier,
    STATE(190), 1,
      sym__widentifier,
  [22337] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(957), 2,
      sym_RBRACE,
      sym_SEM,
  [22345] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(927), 2,
      sym_RBRACE,
      sym_SEM,
  [22353] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1328), 2,
      sym_RBRACE,
      sym_SEM,
  [22361] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(595), 1,
      sym_RBRACK,
    ACTIONS(1212), 1,
      sym_COMMA,
  [22371] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1156), 2,
      sym_RBRACE,
      sym_SEM,
  [22379] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(595), 1,
      sym_RBRACE,
    ACTIONS(1212), 1,
      sym_COMMA,
  [22389] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1007), 1,
      sym_COMMA,
    ACTIONS(1330), 1,
      sym_COLON,
  [22399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1332), 1,
      sym_RBRACE,
    ACTIONS(1334), 1,
      sym_SEM,
  [22409] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1336), 1,
      sym_COLON,
    ACTIONS(1338), 1,
      sym_DOT,
  [22419] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1340), 2,
      sym_RBRACE,
      sym_SEM,
  [22427] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1007), 1,
      sym_COMMA,
    ACTIONS(1342), 1,
      sym_COLON,
  [22437] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1344), 1,
      sym_identifier,
    STATE(156), 1,
      sym__widentifier,
  [22447] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1232), 1,
      sym_SEM,
    ACTIONS(1346), 1,
      sym_VBAR,
  [22457] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1322), 1,
      sym_SEM,
    ACTIONS(1348), 1,
      sym_RBRACE,
  [22467] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 2,
      sym_DOT,
      sym_IF,
  [22475] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1216), 1,
      sym_SEM,
    ACTIONS(1350), 1,
      sym_RPAREN,
  [22485] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(895), 2,
      sym_DOT,
      sym_IF,
  [22493] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      sym_DOT,
    ACTIONS(1352), 1,
      sym_IF,
  [22503] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(335), 2,
      sym_COLON,
      sym_DOT,
  [22511] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1216), 1,
      sym_SEM,
    ACTIONS(1354), 1,
      sym_RPAREN,
  [22521] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1216), 1,
      sym_SEM,
    ACTIONS(1346), 1,
      sym_RPAREN,
  [22531] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1216), 1,
      sym_SEM,
    ACTIONS(1356), 1,
      sym_RPAREN,
  [22541] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 2,
      sym_DOT,
      sym_IF,
  [22549] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 1,
      sym_DOT,
  [22556] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 1,
      sym_CSP,
  [22563] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1358), 1,
      sym_LBRACE,
  [22570] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1360), 1,
      sym_EQ,
  [22577] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1346), 1,
      sym_RPAREN,
  [22584] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1362), 1,
      sym_identifier,
  [22591] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1100), 1,
      sym_SLASH,
  [22598] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1364), 1,
      sym_LBRACE,
  [22605] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1366), 1,
      sym_identifier,
  [22612] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 1,
      sym_DOT,
  [22619] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1368), 1,
      ts_builtin_sym_end,
  [22626] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1370), 1,
      sym_identifier,
  [22633] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 1,
      sym_RPAREN,
  [22640] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 1,
      sym_RBRACK,
  [22647] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1372), 1,
      sym_LPAREN,
  [22654] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1374), 1,
      sym_SLASH,
  [22661] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1376), 1,
      sym_identifier,
  [22668] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1378), 1,
      sym_LBRACE,
  [22675] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1380), 1,
      sym_RPAREN,
  [22682] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 1,
      sym_RPAREN,
  [22689] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1382), 1,
      sym_LBRACK,
  [22696] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1384), 1,
      sym_COLON,
  [22703] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 1,
      sym_RBRACE,
  [22710] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      sym_RBRACK,
  [22717] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1388), 1,
      sym_LPAREN,
  [22724] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1390), 1,
      sym_COLON,
  [22731] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1392), 1,
      sym_DOT,
  [22738] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1130), 1,
      sym_DOT,
  [22745] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1394), 1,
      sym_LBRACE,
  [22752] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1396), 1,
      sym_LBRACE,
  [22759] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1398), 1,
      sym_COMMA,
  [22766] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1220), 1,
      sym_RPAREN,
  [22773] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_COMMA,
  [22780] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1402), 1,
      sym_COMMA,
  [22787] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(727), 1,
      sym_COLON,
  [22794] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1404), 1,
      sym_LBRACK,
  [22801] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1406), 1,
      sym_LBRACE,
  [22808] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1408), 1,
      sym_LBRACE,
  [22815] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1410), 1,
      sym_identifier,
  [22822] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1412), 1,
      sym_LBRACE,
  [22829] = 2,
    ACTIONS(1021), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_CODE,
  [22836] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 1,
      sym_LBRACE,
  [22843] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(611), 1,
      sym_CSP,
  [22850] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      sym_SLASH,
  [22857] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1198), 1,
      sym_RBRACE,
  [22864] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(775), 1,
      sym_GT,
  [22871] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      sym_LBRACE,
  [22878] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1420), 1,
      sym_COMMA,
  [22885] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1422), 1,
      sym_LBRACE,
  [22892] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1424), 1,
      sym_COMMA,
  [22899] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1426), 1,
      sym_identifier,
  [22906] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1428), 1,
      sym_COMMA,
  [22913] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1430), 1,
      sym_COMMA,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(4)] = 0,
  [SMALL_STATE(5)] = 125,
  [SMALL_STATE(6)] = 250,
  [SMALL_STATE(7)] = 375,
  [SMALL_STATE(8)] = 500,
  [SMALL_STATE(9)] = 554,
  [SMALL_STATE(10)] = 676,
  [SMALL_STATE(11)] = 730,
  [SMALL_STATE(12)] = 784,
  [SMALL_STATE(13)] = 838,
  [SMALL_STATE(14)] = 894,
  [SMALL_STATE(15)] = 950,
  [SMALL_STATE(16)] = 1072,
  [SMALL_STATE(17)] = 1128,
  [SMALL_STATE(18)] = 1250,
  [SMALL_STATE(19)] = 1304,
  [SMALL_STATE(20)] = 1358,
  [SMALL_STATE(21)] = 1411,
  [SMALL_STATE(22)] = 1464,
  [SMALL_STATE(23)] = 1517,
  [SMALL_STATE(24)] = 1570,
  [SMALL_STATE(25)] = 1623,
  [SMALL_STATE(26)] = 1676,
  [SMALL_STATE(27)] = 1729,
  [SMALL_STATE(28)] = 1782,
  [SMALL_STATE(29)] = 1898,
  [SMALL_STATE(30)] = 1948,
  [SMALL_STATE(31)] = 2000,
  [SMALL_STATE(32)] = 2050,
  [SMALL_STATE(33)] = 2100,
  [SMALL_STATE(34)] = 2150,
  [SMALL_STATE(35)] = 2202,
  [SMALL_STATE(36)] = 2259,
  [SMALL_STATE(37)] = 2308,
  [SMALL_STATE(38)] = 2357,
  [SMALL_STATE(39)] = 2406,
  [SMALL_STATE(40)] = 2455,
  [SMALL_STATE(41)] = 2520,
  [SMALL_STATE(42)] = 2575,
  [SMALL_STATE(43)] = 2624,
  [SMALL_STATE(44)] = 2683,
  [SMALL_STATE(45)] = 2734,
  [SMALL_STATE(46)] = 2787,
  [SMALL_STATE(47)] = 2852,
  [SMALL_STATE(48)] = 2906,
  [SMALL_STATE(49)] = 2960,
  [SMALL_STATE(50)] = 3011,
  [SMALL_STATE(51)] = 3062,
  [SMALL_STATE(52)] = 3114,
  [SMALL_STATE(53)] = 3166,
  [SMALL_STATE(54)] = 3263,
  [SMALL_STATE(55)] = 3312,
  [SMALL_STATE(56)] = 3361,
  [SMALL_STATE(57)] = 3458,
  [SMALL_STATE(58)] = 3552,
  [SMALL_STATE(59)] = 3646,
  [SMALL_STATE(60)] = 3723,
  [SMALL_STATE(61)] = 3800,
  [SMALL_STATE(62)] = 3892,
  [SMALL_STATE(63)] = 3984,
  [SMALL_STATE(64)] = 4061,
  [SMALL_STATE(65)] = 4150,
  [SMALL_STATE(66)] = 4227,
  [SMALL_STATE(67)] = 4316,
  [SMALL_STATE(68)] = 4407,
  [SMALL_STATE(69)] = 4496,
  [SMALL_STATE(70)] = 4573,
  [SMALL_STATE(71)] = 4662,
  [SMALL_STATE(72)] = 4751,
  [SMALL_STATE(73)] = 4840,
  [SMALL_STATE(74)] = 4928,
  [SMALL_STATE(75)] = 5004,
  [SMALL_STATE(76)] = 5080,
  [SMALL_STATE(77)] = 5156,
  [SMALL_STATE(78)] = 5238,
  [SMALL_STATE(79)] = 5320,
  [SMALL_STATE(80)] = 5402,
  [SMALL_STATE(81)] = 5484,
  [SMALL_STATE(82)] = 5566,
  [SMALL_STATE(83)] = 5648,
  [SMALL_STATE(84)] = 5730,
  [SMALL_STATE(85)] = 5812,
  [SMALL_STATE(86)] = 5894,
  [SMALL_STATE(87)] = 5967,
  [SMALL_STATE(88)] = 6040,
  [SMALL_STATE(89)] = 6113,
  [SMALL_STATE(90)] = 6186,
  [SMALL_STATE(91)] = 6262,
  [SMALL_STATE(92)] = 6298,
  [SMALL_STATE(93)] = 6334,
  [SMALL_STATE(94)] = 6370,
  [SMALL_STATE(95)] = 6406,
  [SMALL_STATE(96)] = 6482,
  [SMALL_STATE(97)] = 6555,
  [SMALL_STATE(98)] = 6614,
  [SMALL_STATE(99)] = 6687,
  [SMALL_STATE(100)] = 6746,
  [SMALL_STATE(101)] = 6816,
  [SMALL_STATE(102)] = 6852,
  [SMALL_STATE(103)] = 6914,
  [SMALL_STATE(104)] = 6948,
  [SMALL_STATE(105)] = 6984,
  [SMALL_STATE(106)] = 7018,
  [SMALL_STATE(107)] = 7088,
  [SMALL_STATE(108)] = 7150,
  [SMALL_STATE(109)] = 7184,
  [SMALL_STATE(110)] = 7217,
  [SMALL_STATE(111)] = 7268,
  [SMALL_STATE(112)] = 7317,
  [SMALL_STATE(113)] = 7368,
  [SMALL_STATE(114)] = 7411,
  [SMALL_STATE(115)] = 7444,
  [SMALL_STATE(116)] = 7483,
  [SMALL_STATE(117)] = 7550,
  [SMALL_STATE(118)] = 7583,
  [SMALL_STATE(119)] = 7624,
  [SMALL_STATE(120)] = 7657,
  [SMALL_STATE(121)] = 7690,
  [SMALL_STATE(122)] = 7757,
  [SMALL_STATE(123)] = 7790,
  [SMALL_STATE(124)] = 7827,
  [SMALL_STATE(125)] = 7860,
  [SMALL_STATE(126)] = 7893,
  [SMALL_STATE(127)] = 7960,
  [SMALL_STATE(128)] = 8027,
  [SMALL_STATE(129)] = 8094,
  [SMALL_STATE(130)] = 8127,
  [SMALL_STATE(131)] = 8194,
  [SMALL_STATE(132)] = 8229,
  [SMALL_STATE(133)] = 8262,
  [SMALL_STATE(134)] = 8311,
  [SMALL_STATE(135)] = 8378,
  [SMALL_STATE(136)] = 8411,
  [SMALL_STATE(137)] = 8444,
  [SMALL_STATE(138)] = 8511,
  [SMALL_STATE(139)] = 8578,
  [SMALL_STATE(140)] = 8645,
  [SMALL_STATE(141)] = 8709,
  [SMALL_STATE(142)] = 8775,
  [SMALL_STATE(143)] = 8839,
  [SMALL_STATE(144)] = 8905,
  [SMALL_STATE(145)] = 8969,
  [SMALL_STATE(146)] = 9035,
  [SMALL_STATE(147)] = 9099,
  [SMALL_STATE(148)] = 9165,
  [SMALL_STATE(149)] = 9229,
  [SMALL_STATE(150)] = 9293,
  [SMALL_STATE(151)] = 9359,
  [SMALL_STATE(152)] = 9425,
  [SMALL_STATE(153)] = 9489,
  [SMALL_STATE(154)] = 9553,
  [SMALL_STATE(155)] = 9619,
  [SMALL_STATE(156)] = 9685,
  [SMALL_STATE(157)] = 9749,
  [SMALL_STATE(158)] = 9813,
  [SMALL_STATE(159)] = 9877,
  [SMALL_STATE(160)] = 9943,
  [SMALL_STATE(161)] = 9991,
  [SMALL_STATE(162)] = 10055,
  [SMALL_STATE(163)] = 10105,
  [SMALL_STATE(164)] = 10169,
  [SMALL_STATE(165)] = 10219,
  [SMALL_STATE(166)] = 10285,
  [SMALL_STATE(167)] = 10351,
  [SMALL_STATE(168)] = 10415,
  [SMALL_STATE(169)] = 10479,
  [SMALL_STATE(170)] = 10543,
  [SMALL_STATE(171)] = 10607,
  [SMALL_STATE(172)] = 10673,
  [SMALL_STATE(173)] = 10739,
  [SMALL_STATE(174)] = 10805,
  [SMALL_STATE(175)] = 10869,
  [SMALL_STATE(176)] = 10935,
  [SMALL_STATE(177)] = 10999,
  [SMALL_STATE(178)] = 11063,
  [SMALL_STATE(179)] = 11129,
  [SMALL_STATE(180)] = 11190,
  [SMALL_STATE(181)] = 11239,
  [SMALL_STATE(182)] = 11300,
  [SMALL_STATE(183)] = 11361,
  [SMALL_STATE(184)] = 11422,
  [SMALL_STATE(185)] = 11485,
  [SMALL_STATE(186)] = 11546,
  [SMALL_STATE(187)] = 11607,
  [SMALL_STATE(188)] = 11666,
  [SMALL_STATE(189)] = 11729,
  [SMALL_STATE(190)] = 11790,
  [SMALL_STATE(191)] = 11851,
  [SMALL_STATE(192)] = 11914,
  [SMALL_STATE(193)] = 11977,
  [SMALL_STATE(194)] = 12038,
  [SMALL_STATE(195)] = 12085,
  [SMALL_STATE(196)] = 12146,
  [SMALL_STATE(197)] = 12204,
  [SMALL_STATE(198)] = 12262,
  [SMALL_STATE(199)] = 12320,
  [SMALL_STATE(200)] = 12380,
  [SMALL_STATE(201)] = 12440,
  [SMALL_STATE(202)] = 12500,
  [SMALL_STATE(203)] = 12560,
  [SMALL_STATE(204)] = 12618,
  [SMALL_STATE(205)] = 12678,
  [SMALL_STATE(206)] = 12738,
  [SMALL_STATE(207)] = 12796,
  [SMALL_STATE(208)] = 12856,
  [SMALL_STATE(209)] = 12916,
  [SMALL_STATE(210)] = 12974,
  [SMALL_STATE(211)] = 13032,
  [SMALL_STATE(212)] = 13062,
  [SMALL_STATE(213)] = 13120,
  [SMALL_STATE(214)] = 13175,
  [SMALL_STATE(215)] = 13230,
  [SMALL_STATE(216)] = 13285,
  [SMALL_STATE(217)] = 13340,
  [SMALL_STATE(218)] = 13395,
  [SMALL_STATE(219)] = 13450,
  [SMALL_STATE(220)] = 13505,
  [SMALL_STATE(221)] = 13560,
  [SMALL_STATE(222)] = 13615,
  [SMALL_STATE(223)] = 13670,
  [SMALL_STATE(224)] = 13725,
  [SMALL_STATE(225)] = 13780,
  [SMALL_STATE(226)] = 13835,
  [SMALL_STATE(227)] = 13890,
  [SMALL_STATE(228)] = 13945,
  [SMALL_STATE(229)] = 14000,
  [SMALL_STATE(230)] = 14055,
  [SMALL_STATE(231)] = 14110,
  [SMALL_STATE(232)] = 14165,
  [SMALL_STATE(233)] = 14220,
  [SMALL_STATE(234)] = 14275,
  [SMALL_STATE(235)] = 14330,
  [SMALL_STATE(236)] = 14385,
  [SMALL_STATE(237)] = 14440,
  [SMALL_STATE(238)] = 14495,
  [SMALL_STATE(239)] = 14550,
  [SMALL_STATE(240)] = 14605,
  [SMALL_STATE(241)] = 14660,
  [SMALL_STATE(242)] = 14715,
  [SMALL_STATE(243)] = 14770,
  [SMALL_STATE(244)] = 14825,
  [SMALL_STATE(245)] = 14880,
  [SMALL_STATE(246)] = 14935,
  [SMALL_STATE(247)] = 14990,
  [SMALL_STATE(248)] = 15045,
  [SMALL_STATE(249)] = 15100,
  [SMALL_STATE(250)] = 15155,
  [SMALL_STATE(251)] = 15210,
  [SMALL_STATE(252)] = 15265,
  [SMALL_STATE(253)] = 15322,
  [SMALL_STATE(254)] = 15377,
  [SMALL_STATE(255)] = 15432,
  [SMALL_STATE(256)] = 15487,
  [SMALL_STATE(257)] = 15542,
  [SMALL_STATE(258)] = 15597,
  [SMALL_STATE(259)] = 15651,
  [SMALL_STATE(260)] = 15679,
  [SMALL_STATE(261)] = 15733,
  [SMALL_STATE(262)] = 15787,
  [SMALL_STATE(263)] = 15841,
  [SMALL_STATE(264)] = 15869,
  [SMALL_STATE(265)] = 15923,
  [SMALL_STATE(266)] = 15977,
  [SMALL_STATE(267)] = 16031,
  [SMALL_STATE(268)] = 16059,
  [SMALL_STATE(269)] = 16087,
  [SMALL_STATE(270)] = 16141,
  [SMALL_STATE(271)] = 16169,
  [SMALL_STATE(272)] = 16223,
  [SMALL_STATE(273)] = 16274,
  [SMALL_STATE(274)] = 16325,
  [SMALL_STATE(275)] = 16376,
  [SMALL_STATE(276)] = 16427,
  [SMALL_STATE(277)] = 16478,
  [SMALL_STATE(278)] = 16529,
  [SMALL_STATE(279)] = 16580,
  [SMALL_STATE(280)] = 16631,
  [SMALL_STATE(281)] = 16682,
  [SMALL_STATE(282)] = 16733,
  [SMALL_STATE(283)] = 16777,
  [SMALL_STATE(284)] = 16821,
  [SMALL_STATE(285)] = 16847,
  [SMALL_STATE(286)] = 16891,
  [SMALL_STATE(287)] = 16917,
  [SMALL_STATE(288)] = 16943,
  [SMALL_STATE(289)] = 16987,
  [SMALL_STATE(290)] = 17012,
  [SMALL_STATE(291)] = 17037,
  [SMALL_STATE(292)] = 17062,
  [SMALL_STATE(293)] = 17102,
  [SMALL_STATE(294)] = 17142,
  [SMALL_STATE(295)] = 17180,
  [SMALL_STATE(296)] = 17218,
  [SMALL_STATE(297)] = 17258,
  [SMALL_STATE(298)] = 17298,
  [SMALL_STATE(299)] = 17337,
  [SMALL_STATE(300)] = 17360,
  [SMALL_STATE(301)] = 17397,
  [SMALL_STATE(302)] = 17436,
  [SMALL_STATE(303)] = 17459,
  [SMALL_STATE(304)] = 17482,
  [SMALL_STATE(305)] = 17513,
  [SMALL_STATE(306)] = 17552,
  [SMALL_STATE(307)] = 17575,
  [SMALL_STATE(308)] = 17599,
  [SMALL_STATE(309)] = 17623,
  [SMALL_STATE(310)] = 17647,
  [SMALL_STATE(311)] = 17675,
  [SMALL_STATE(312)] = 17700,
  [SMALL_STATE(313)] = 17721,
  [SMALL_STATE(314)] = 17758,
  [SMALL_STATE(315)] = 17779,
  [SMALL_STATE(316)] = 17800,
  [SMALL_STATE(317)] = 17837,
  [SMALL_STATE(318)] = 17860,
  [SMALL_STATE(319)] = 17881,
  [SMALL_STATE(320)] = 17908,
  [SMALL_STATE(321)] = 17931,
  [SMALL_STATE(322)] = 17952,
  [SMALL_STATE(323)] = 17973,
  [SMALL_STATE(324)] = 18000,
  [SMALL_STATE(325)] = 18033,
  [SMALL_STATE(326)] = 18062,
  [SMALL_STATE(327)] = 18083,
  [SMALL_STATE(328)] = 18116,
  [SMALL_STATE(329)] = 18150,
  [SMALL_STATE(330)] = 18186,
  [SMALL_STATE(331)] = 18222,
  [SMALL_STATE(332)] = 18246,
  [SMALL_STATE(333)] = 18282,
  [SMALL_STATE(334)] = 18304,
  [SMALL_STATE(335)] = 18338,
  [SMALL_STATE(336)] = 18372,
  [SMALL_STATE(337)] = 18408,
  [SMALL_STATE(338)] = 18444,
  [SMALL_STATE(339)] = 18478,
  [SMALL_STATE(340)] = 18511,
  [SMALL_STATE(341)] = 18544,
  [SMALL_STATE(342)] = 18577,
  [SMALL_STATE(343)] = 18608,
  [SMALL_STATE(344)] = 18641,
  [SMALL_STATE(345)] = 18672,
  [SMALL_STATE(346)] = 18705,
  [SMALL_STATE(347)] = 18738,
  [SMALL_STATE(348)] = 18761,
  [SMALL_STATE(349)] = 18794,
  [SMALL_STATE(350)] = 18812,
  [SMALL_STATE(351)] = 18842,
  [SMALL_STATE(352)] = 18860,
  [SMALL_STATE(353)] = 18878,
  [SMALL_STATE(354)] = 18896,
  [SMALL_STATE(355)] = 18926,
  [SMALL_STATE(356)] = 18947,
  [SMALL_STATE(357)] = 18968,
  [SMALL_STATE(358)] = 18989,
  [SMALL_STATE(359)] = 19013,
  [SMALL_STATE(360)] = 19033,
  [SMALL_STATE(361)] = 19057,
  [SMALL_STATE(362)] = 19077,
  [SMALL_STATE(363)] = 19101,
  [SMALL_STATE(364)] = 19116,
  [SMALL_STATE(365)] = 19137,
  [SMALL_STATE(366)] = 19152,
  [SMALL_STATE(367)] = 19173,
  [SMALL_STATE(368)] = 19190,
  [SMALL_STATE(369)] = 19205,
  [SMALL_STATE(370)] = 19228,
  [SMALL_STATE(371)] = 19249,
  [SMALL_STATE(372)] = 19272,
  [SMALL_STATE(373)] = 19293,
  [SMALL_STATE(374)] = 19308,
  [SMALL_STATE(375)] = 19329,
  [SMALL_STATE(376)] = 19344,
  [SMALL_STATE(377)] = 19359,
  [SMALL_STATE(378)] = 19379,
  [SMALL_STATE(379)] = 19397,
  [SMALL_STATE(380)] = 19411,
  [SMALL_STATE(381)] = 19429,
  [SMALL_STATE(382)] = 19443,
  [SMALL_STATE(383)] = 19457,
  [SMALL_STATE(384)] = 19471,
  [SMALL_STATE(385)] = 19483,
  [SMALL_STATE(386)] = 19497,
  [SMALL_STATE(387)] = 19511,
  [SMALL_STATE(388)] = 19525,
  [SMALL_STATE(389)] = 19545,
  [SMALL_STATE(390)] = 19557,
  [SMALL_STATE(391)] = 19571,
  [SMALL_STATE(392)] = 19589,
  [SMALL_STATE(393)] = 19603,
  [SMALL_STATE(394)] = 19623,
  [SMALL_STATE(395)] = 19635,
  [SMALL_STATE(396)] = 19655,
  [SMALL_STATE(397)] = 19667,
  [SMALL_STATE(398)] = 19685,
  [SMALL_STATE(399)] = 19697,
  [SMALL_STATE(400)] = 19717,
  [SMALL_STATE(401)] = 19729,
  [SMALL_STATE(402)] = 19749,
  [SMALL_STATE(403)] = 19767,
  [SMALL_STATE(404)] = 19787,
  [SMALL_STATE(405)] = 19807,
  [SMALL_STATE(406)] = 19827,
  [SMALL_STATE(407)] = 19839,
  [SMALL_STATE(408)] = 19859,
  [SMALL_STATE(409)] = 19871,
  [SMALL_STATE(410)] = 19883,
  [SMALL_STATE(411)] = 19895,
  [SMALL_STATE(412)] = 19909,
  [SMALL_STATE(413)] = 19929,
  [SMALL_STATE(414)] = 19947,
  [SMALL_STATE(415)] = 19961,
  [SMALL_STATE(416)] = 19973,
  [SMALL_STATE(417)] = 19993,
  [SMALL_STATE(418)] = 20007,
  [SMALL_STATE(419)] = 20021,
  [SMALL_STATE(420)] = 20033,
  [SMALL_STATE(421)] = 20053,
  [SMALL_STATE(422)] = 20065,
  [SMALL_STATE(423)] = 20077,
  [SMALL_STATE(424)] = 20093,
  [SMALL_STATE(425)] = 20109,
  [SMALL_STATE(426)] = 20122,
  [SMALL_STATE(427)] = 20139,
  [SMALL_STATE(428)] = 20152,
  [SMALL_STATE(429)] = 20169,
  [SMALL_STATE(430)] = 20182,
  [SMALL_STATE(431)] = 20199,
  [SMALL_STATE(432)] = 20216,
  [SMALL_STATE(433)] = 20231,
  [SMALL_STATE(434)] = 20244,
  [SMALL_STATE(435)] = 20257,
  [SMALL_STATE(436)] = 20268,
  [SMALL_STATE(437)] = 20281,
  [SMALL_STATE(438)] = 20294,
  [SMALL_STATE(439)] = 20307,
  [SMALL_STATE(440)] = 20320,
  [SMALL_STATE(441)] = 20333,
  [SMALL_STATE(442)] = 20346,
  [SMALL_STATE(443)] = 20359,
  [SMALL_STATE(444)] = 20372,
  [SMALL_STATE(445)] = 20385,
  [SMALL_STATE(446)] = 20398,
  [SMALL_STATE(447)] = 20409,
  [SMALL_STATE(448)] = 20420,
  [SMALL_STATE(449)] = 20431,
  [SMALL_STATE(450)] = 20442,
  [SMALL_STATE(451)] = 20453,
  [SMALL_STATE(452)] = 20464,
  [SMALL_STATE(453)] = 20481,
  [SMALL_STATE(454)] = 20493,
  [SMALL_STATE(455)] = 20507,
  [SMALL_STATE(456)] = 20519,
  [SMALL_STATE(457)] = 20533,
  [SMALL_STATE(458)] = 20547,
  [SMALL_STATE(459)] = 20561,
  [SMALL_STATE(460)] = 20575,
  [SMALL_STATE(461)] = 20587,
  [SMALL_STATE(462)] = 20599,
  [SMALL_STATE(463)] = 20615,
  [SMALL_STATE(464)] = 20629,
  [SMALL_STATE(465)] = 20643,
  [SMALL_STATE(466)] = 20655,
  [SMALL_STATE(467)] = 20669,
  [SMALL_STATE(468)] = 20681,
  [SMALL_STATE(469)] = 20695,
  [SMALL_STATE(470)] = 20709,
  [SMALL_STATE(471)] = 20721,
  [SMALL_STATE(472)] = 20737,
  [SMALL_STATE(473)] = 20751,
  [SMALL_STATE(474)] = 20765,
  [SMALL_STATE(475)] = 20779,
  [SMALL_STATE(476)] = 20791,
  [SMALL_STATE(477)] = 20805,
  [SMALL_STATE(478)] = 20819,
  [SMALL_STATE(479)] = 20833,
  [SMALL_STATE(480)] = 20845,
  [SMALL_STATE(481)] = 20859,
  [SMALL_STATE(482)] = 20871,
  [SMALL_STATE(483)] = 20885,
  [SMALL_STATE(484)] = 20897,
  [SMALL_STATE(485)] = 20911,
  [SMALL_STATE(486)] = 20925,
  [SMALL_STATE(487)] = 20939,
  [SMALL_STATE(488)] = 20951,
  [SMALL_STATE(489)] = 20965,
  [SMALL_STATE(490)] = 20979,
  [SMALL_STATE(491)] = 20993,
  [SMALL_STATE(492)] = 21007,
  [SMALL_STATE(493)] = 21021,
  [SMALL_STATE(494)] = 21035,
  [SMALL_STATE(495)] = 21047,
  [SMALL_STATE(496)] = 21061,
  [SMALL_STATE(497)] = 21077,
  [SMALL_STATE(498)] = 21091,
  [SMALL_STATE(499)] = 21104,
  [SMALL_STATE(500)] = 21117,
  [SMALL_STATE(501)] = 21128,
  [SMALL_STATE(502)] = 21137,
  [SMALL_STATE(503)] = 21150,
  [SMALL_STATE(504)] = 21161,
  [SMALL_STATE(505)] = 21170,
  [SMALL_STATE(506)] = 21181,
  [SMALL_STATE(507)] = 21194,
  [SMALL_STATE(508)] = 21205,
  [SMALL_STATE(509)] = 21218,
  [SMALL_STATE(510)] = 21231,
  [SMALL_STATE(511)] = 21242,
  [SMALL_STATE(512)] = 21255,
  [SMALL_STATE(513)] = 21266,
  [SMALL_STATE(514)] = 21275,
  [SMALL_STATE(515)] = 21284,
  [SMALL_STATE(516)] = 21295,
  [SMALL_STATE(517)] = 21304,
  [SMALL_STATE(518)] = 21315,
  [SMALL_STATE(519)] = 21326,
  [SMALL_STATE(520)] = 21335,
  [SMALL_STATE(521)] = 21346,
  [SMALL_STATE(522)] = 21359,
  [SMALL_STATE(523)] = 21368,
  [SMALL_STATE(524)] = 21377,
  [SMALL_STATE(525)] = 21388,
  [SMALL_STATE(526)] = 21399,
  [SMALL_STATE(527)] = 21410,
  [SMALL_STATE(528)] = 21419,
  [SMALL_STATE(529)] = 21430,
  [SMALL_STATE(530)] = 21439,
  [SMALL_STATE(531)] = 21450,
  [SMALL_STATE(532)] = 21461,
  [SMALL_STATE(533)] = 21470,
  [SMALL_STATE(534)] = 21481,
  [SMALL_STATE(535)] = 21491,
  [SMALL_STATE(536)] = 21501,
  [SMALL_STATE(537)] = 21509,
  [SMALL_STATE(538)] = 21517,
  [SMALL_STATE(539)] = 21527,
  [SMALL_STATE(540)] = 21535,
  [SMALL_STATE(541)] = 21545,
  [SMALL_STATE(542)] = 21553,
  [SMALL_STATE(543)] = 21561,
  [SMALL_STATE(544)] = 21571,
  [SMALL_STATE(545)] = 21579,
  [SMALL_STATE(546)] = 21587,
  [SMALL_STATE(547)] = 21597,
  [SMALL_STATE(548)] = 21607,
  [SMALL_STATE(549)] = 21617,
  [SMALL_STATE(550)] = 21625,
  [SMALL_STATE(551)] = 21635,
  [SMALL_STATE(552)] = 21645,
  [SMALL_STATE(553)] = 21655,
  [SMALL_STATE(554)] = 21665,
  [SMALL_STATE(555)] = 21675,
  [SMALL_STATE(556)] = 21685,
  [SMALL_STATE(557)] = 21695,
  [SMALL_STATE(558)] = 21703,
  [SMALL_STATE(559)] = 21713,
  [SMALL_STATE(560)] = 21723,
  [SMALL_STATE(561)] = 21733,
  [SMALL_STATE(562)] = 21743,
  [SMALL_STATE(563)] = 21753,
  [SMALL_STATE(564)] = 21763,
  [SMALL_STATE(565)] = 21773,
  [SMALL_STATE(566)] = 21781,
  [SMALL_STATE(567)] = 21791,
  [SMALL_STATE(568)] = 21799,
  [SMALL_STATE(569)] = 21807,
  [SMALL_STATE(570)] = 21815,
  [SMALL_STATE(571)] = 21823,
  [SMALL_STATE(572)] = 21833,
  [SMALL_STATE(573)] = 21841,
  [SMALL_STATE(574)] = 21849,
  [SMALL_STATE(575)] = 21857,
  [SMALL_STATE(576)] = 21867,
  [SMALL_STATE(577)] = 21877,
  [SMALL_STATE(578)] = 21885,
  [SMALL_STATE(579)] = 21893,
  [SMALL_STATE(580)] = 21903,
  [SMALL_STATE(581)] = 21913,
  [SMALL_STATE(582)] = 21923,
  [SMALL_STATE(583)] = 21933,
  [SMALL_STATE(584)] = 21941,
  [SMALL_STATE(585)] = 21951,
  [SMALL_STATE(586)] = 21959,
  [SMALL_STATE(587)] = 21967,
  [SMALL_STATE(588)] = 21977,
  [SMALL_STATE(589)] = 21985,
  [SMALL_STATE(590)] = 21993,
  [SMALL_STATE(591)] = 22001,
  [SMALL_STATE(592)] = 22011,
  [SMALL_STATE(593)] = 22021,
  [SMALL_STATE(594)] = 22031,
  [SMALL_STATE(595)] = 22039,
  [SMALL_STATE(596)] = 22049,
  [SMALL_STATE(597)] = 22059,
  [SMALL_STATE(598)] = 22067,
  [SMALL_STATE(599)] = 22077,
  [SMALL_STATE(600)] = 22085,
  [SMALL_STATE(601)] = 22093,
  [SMALL_STATE(602)] = 22101,
  [SMALL_STATE(603)] = 22109,
  [SMALL_STATE(604)] = 22117,
  [SMALL_STATE(605)] = 22125,
  [SMALL_STATE(606)] = 22133,
  [SMALL_STATE(607)] = 22141,
  [SMALL_STATE(608)] = 22149,
  [SMALL_STATE(609)] = 22157,
  [SMALL_STATE(610)] = 22167,
  [SMALL_STATE(611)] = 22177,
  [SMALL_STATE(612)] = 22187,
  [SMALL_STATE(613)] = 22195,
  [SMALL_STATE(614)] = 22205,
  [SMALL_STATE(615)] = 22215,
  [SMALL_STATE(616)] = 22225,
  [SMALL_STATE(617)] = 22235,
  [SMALL_STATE(618)] = 22243,
  [SMALL_STATE(619)] = 22251,
  [SMALL_STATE(620)] = 22259,
  [SMALL_STATE(621)] = 22269,
  [SMALL_STATE(622)] = 22279,
  [SMALL_STATE(623)] = 22289,
  [SMALL_STATE(624)] = 22299,
  [SMALL_STATE(625)] = 22309,
  [SMALL_STATE(626)] = 22317,
  [SMALL_STATE(627)] = 22327,
  [SMALL_STATE(628)] = 22337,
  [SMALL_STATE(629)] = 22345,
  [SMALL_STATE(630)] = 22353,
  [SMALL_STATE(631)] = 22361,
  [SMALL_STATE(632)] = 22371,
  [SMALL_STATE(633)] = 22379,
  [SMALL_STATE(634)] = 22389,
  [SMALL_STATE(635)] = 22399,
  [SMALL_STATE(636)] = 22409,
  [SMALL_STATE(637)] = 22419,
  [SMALL_STATE(638)] = 22427,
  [SMALL_STATE(639)] = 22437,
  [SMALL_STATE(640)] = 22447,
  [SMALL_STATE(641)] = 22457,
  [SMALL_STATE(642)] = 22467,
  [SMALL_STATE(643)] = 22475,
  [SMALL_STATE(644)] = 22485,
  [SMALL_STATE(645)] = 22493,
  [SMALL_STATE(646)] = 22503,
  [SMALL_STATE(647)] = 22511,
  [SMALL_STATE(648)] = 22521,
  [SMALL_STATE(649)] = 22531,
  [SMALL_STATE(650)] = 22541,
  [SMALL_STATE(651)] = 22549,
  [SMALL_STATE(652)] = 22556,
  [SMALL_STATE(653)] = 22563,
  [SMALL_STATE(654)] = 22570,
  [SMALL_STATE(655)] = 22577,
  [SMALL_STATE(656)] = 22584,
  [SMALL_STATE(657)] = 22591,
  [SMALL_STATE(658)] = 22598,
  [SMALL_STATE(659)] = 22605,
  [SMALL_STATE(660)] = 22612,
  [SMALL_STATE(661)] = 22619,
  [SMALL_STATE(662)] = 22626,
  [SMALL_STATE(663)] = 22633,
  [SMALL_STATE(664)] = 22640,
  [SMALL_STATE(665)] = 22647,
  [SMALL_STATE(666)] = 22654,
  [SMALL_STATE(667)] = 22661,
  [SMALL_STATE(668)] = 22668,
  [SMALL_STATE(669)] = 22675,
  [SMALL_STATE(670)] = 22682,
  [SMALL_STATE(671)] = 22689,
  [SMALL_STATE(672)] = 22696,
  [SMALL_STATE(673)] = 22703,
  [SMALL_STATE(674)] = 22710,
  [SMALL_STATE(675)] = 22717,
  [SMALL_STATE(676)] = 22724,
  [SMALL_STATE(677)] = 22731,
  [SMALL_STATE(678)] = 22738,
  [SMALL_STATE(679)] = 22745,
  [SMALL_STATE(680)] = 22752,
  [SMALL_STATE(681)] = 22759,
  [SMALL_STATE(682)] = 22766,
  [SMALL_STATE(683)] = 22773,
  [SMALL_STATE(684)] = 22780,
  [SMALL_STATE(685)] = 22787,
  [SMALL_STATE(686)] = 22794,
  [SMALL_STATE(687)] = 22801,
  [SMALL_STATE(688)] = 22808,
  [SMALL_STATE(689)] = 22815,
  [SMALL_STATE(690)] = 22822,
  [SMALL_STATE(691)] = 22829,
  [SMALL_STATE(692)] = 22836,
  [SMALL_STATE(693)] = 22843,
  [SMALL_STATE(694)] = 22850,
  [SMALL_STATE(695)] = 22857,
  [SMALL_STATE(696)] = 22864,
  [SMALL_STATE(697)] = 22871,
  [SMALL_STATE(698)] = 22878,
  [SMALL_STATE(699)] = 22885,
  [SMALL_STATE(700)] = 22892,
  [SMALL_STATE(701)] = 22899,
  [SMALL_STATE(702)] = 22906,
  [SMALL_STATE(703)] = 22913,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(701),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(699),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(692),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(699),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(680),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(679),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(675),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(667),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(620),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(48),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(665),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [79] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [81] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [83] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(509),
  [86] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(540),
  [89] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(215),
  [92] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(701),
  [95] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(699),
  [98] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(227),
  [101] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(692),
  [104] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(496),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(564),
  [110] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(363),
  [113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(4),
  [116] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(502),
  [119] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(39),
  [122] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(73),
  [125] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(90),
  [128] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(699),
  [131] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(680),
  [134] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(679),
  [137] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(183),
  [140] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(675),
  [143] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(471),
  [146] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(462),
  [149] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(510),
  [152] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(256),
  [155] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(667),
  [158] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(203),
  [161] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(9),
  [164] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(620),
  [167] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(31),
  [170] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(31),
  [173] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(32),
  [176] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(39),
  [179] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(48),
  [182] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(665),
  [185] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(106),
  [188] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(488),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyconddot, 1),
  [213] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyconddot, 1),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 2),
  [217] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 2),
  [219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 4),
  [221] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 4),
  [223] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 3),
  [225] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 3),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 3),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [231] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 3),
  [233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 5),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [237] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 5),
  [239] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 4),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 4),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyconddot, 2),
  [247] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyconddot, 2),
  [249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 5),
  [251] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 5),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 6),
  [255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 6),
  [257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [259] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 2),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 7),
  [263] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 7),
  [265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 8),
  [267] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 8),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 10),
  [271] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 10),
  [273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_STRING, 3),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_STRING, 3),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 1),
  [281] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 1),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [285] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dec, 1),
  [287] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dec, 1),
  [289] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_NUMBER, 1),
  [291] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_NUMBER, 1),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_STRING, 2),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_STRING, 2),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 2),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 2),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 3),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [305] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 3),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 4),
  [315] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 4),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [319] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [325] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 2),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 2),
  [329] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 1),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 1),
  [333] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 4),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 4),
  [337] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 3),
  [339] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 3),
  [341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(690),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [345] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [347] = {.entry = {.count = 1, .reusable = false}}, SHIFT(57),
  [349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(668),
  [351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [355] = {.entry = {.count = 1, .reusable = false}}, SHIFT(211),
  [357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 1),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(693),
  [361] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 1),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptcondition, 1),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [369] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunction, 2),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 2),
  [377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conjunction, 2),
  [381] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 3),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 2),
  [387] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizecond, 1),
  [393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 1),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element, 1),
  [397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelem, 1),
  [399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(627),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [405] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 2),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [413] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [419] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 1),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 3),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [435] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 2),
  [437] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 2),
  [439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 5),
  [441] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 5),
  [443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 3),
  [445] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 3),
  [447] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 4),
  [449] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 4),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [453] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [465] = {.entry = {.count = 1, .reusable = false}}, SHIFT(392),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [471] = {.entry = {.count = 1, .reusable = false}}, SHIFT(367),
  [473] = {.entry = {.count = 1, .reusable = false}}, SHIFT(289),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [483] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 2),
  [485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 2),
  [487] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 4),
  [489] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 4),
  [491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [493] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [495] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 3),
  [497] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 3),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(652),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [507] = {.entry = {.count = 1, .reusable = false}}, SHIFT(245),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [517] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 2),
  [519] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 2),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [531] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 2),
  [533] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 2),
  [535] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 3),
  [537] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 3),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [541] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [547] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 4),
  [549] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 4),
  [551] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [557] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [571] = {.entry = {.count = 1, .reusable = false}}, SHIFT(400),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [577] = {.entry = {.count = 1, .reusable = false}}, SHIFT(376),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [605] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 4),
  [607] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 4),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(677),
  [617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [629] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuple, 2),
  [631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [641] = {.entry = {.count = 1, .reusable = false}}, SHIFT(475),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [647] = {.entry = {.count = 1, .reusable = false}}, SHIFT(432),
  [649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [675] = {.entry = {.count = 1, .reusable = false}}, SHIFT(440),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [681] = {.entry = {.count = 1, .reusable = false}}, SHIFT(423),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [685] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cmp, 1),
  [687] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cmp, 1),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 4),
  [695] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 4),
  [697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [699] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 3),
  [701] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 3),
  [703] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 5),
  [705] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 5),
  [707] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dsym, 1),
  [709] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dsym, 1),
  [711] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 2),
  [713] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 2),
  [715] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 2),
  [717] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 2),
  [719] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 1),
  [721] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 1),
  [723] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 3),
  [725] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 3),
  [727] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op, 1),
  [729] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op, 1),
  [731] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_rel, 1),
  [733] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_rel, 1),
  [735] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__widentifier, 2),
  [737] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__widentifier, 2),
  [739] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 4),
  [741] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 4),
  [743] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 3),
  [745] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 3),
  [747] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntermvec, 1),
  [749] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntermvec, 3),
  [751] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 5),
  [753] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 5),
  [755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [757] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizeweight, 1),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op_list, 1),
  [761] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op_list, 1),
  [763] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizeweight, 3),
  [765] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_add_term, 3),
  [767] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_add_term, 3),
  [769] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_add_term, 1),
  [771] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_add_term, 1),
  [773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(678),
  [777] = {.entry = {.count = 1, .reusable = false}}, SHIFT(504),
  [779] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op_list, 2),
  [781] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op_list, 2),
  [783] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 2),
  [785] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 2),
  [787] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 1),
  [789] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 1),
  [791] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_literal, 3),
  [793] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_literal, 3),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [797] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 3),
  [799] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 3),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [805] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nupper, 2),
  [807] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nupper, 2),
  [809] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 4),
  [811] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 4),
  [813] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nupper, 1),
  [815] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nupper, 1),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [819] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 1),
  [821] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 1),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [825] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [833] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [837] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unaryargvec, 3),
  [839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [841] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [845] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [853] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unaryargvec, 1),
  [855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binaryargvec, 5),
  [857] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binaryargvec, 3),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [865] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_consttermvec, 3),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [869] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_consttermvec, 1),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [879] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [883] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm_nlist, 3),
  [885] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm_nlist, 1),
  [887] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm_nlist, 1),
  [889] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm_nlist, 3),
  [891] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [895] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_head, 1),
  [897] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 1),
  [899] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 1),
  [901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [903] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 2),
  [905] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 2),
  [907] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 6),
  [909] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 6),
  [911] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 7),
  [913] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 7),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [921] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 2),
  [923] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 1),
  [925] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 1),
  [927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 3),
  [929] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 1),
  [931] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 2),
  [933] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 2),
  [935] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 4),
  [937] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 4),
  [939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [943] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 1),
  [945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [947] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunction, 3),
  [949] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 4),
  [951] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 4),
  [953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nlitvec, 1),
  [955] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptcondition, 2),
  [957] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 3),
  [959] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 3),
  [961] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 5),
  [963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [965] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 1),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(685),
  [971] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 5),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [975] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nlitvec, 3),
  [977] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 3),
  [979] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 2),
  [981] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 2),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [985] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 4),
  [987] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 3),
  [989] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 3),
  [991] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 5),
  [993] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 3),
  [995] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 5),
  [997] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 5),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [1007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(703),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [1013] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 2),
  [1015] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizetuple, 2),
  [1017] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 3),
  [1019] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 2),
  [1021] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [1023] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [1025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [1027] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [1031] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 4),
  [1033] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 3),
  [1035] = {.entry = {.count = 1, .reusable = true}}, SHIFT(639),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [1039] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelem, 1),
  [1041] = {.entry = {.count = 1, .reusable = false}}, SHIFT(383),
  [1043] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 4),
  [1045] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 4),
  [1047] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 2),
  [1049] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [1051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [1053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [1055] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1061] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 2),
  [1063] = {.entry = {.count = 1, .reusable = false}}, SHIFT(483),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1071] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 5),
  [1073] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 2),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [1077] = {.entry = {.count = 1, .reusable = false}}, SHIFT(389),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1081] = {.entry = {.count = 1, .reusable = false}}, SHIFT(386),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [1085] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 3),
  [1087] = {.entry = {.count = 1, .reusable = false}}, SHIFT(443),
  [1089] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1093] = {.entry = {.count = 1, .reusable = false}}, SHIFT(384),
  [1095] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_STRING_repeat1, 2),
  [1097] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_STRING_repeat1, 2), SHIFT_REPEAT(490),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1102] = {.entry = {.count = 1, .reusable = false}}, SHIFT(442),
  [1104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1106] = {.entry = {.count = 1, .reusable = false}}, SHIFT(487),
  [1108] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 1),
  [1110] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [1112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [1114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1120] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 3),
  [1122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(659),
  [1124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [1126] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuple, 1),
  [1128] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_identifier, 1),
  [1130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [1134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(656),
  [1136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(657),
  [1138] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argvec, 3),
  [1140] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 5),
  [1142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1144] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizecond, 2),
  [1146] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizelitvec, 1),
  [1148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1152] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 4),
  [1154] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conjunction, 3),
  [1156] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelem, 2),
  [1158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizelitvec, 3),
  [1164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element, 2),
  [1166] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 4),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1170] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 6),
  [1172] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argvec, 1),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [1176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [1178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [1180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [1182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_nlist, 1),
  [1184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(702),
  [1188] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition, 7),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [1192] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nidlist, 1),
  [1194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_nlist, 3),
  [1196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(662),
  [1198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(651),
  [1200] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 13),
  [1202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 14),
  [1204] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_nlist, 1),
  [1206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1210] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 1),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [1220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element_nlist, 1),
  [1232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [1234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelemvec, 1),
  [1236] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 4),
  [1238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 8),
  [1240] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_type, 1),
  [1242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [1244] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelem, 2),
  [1246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition, 5),
  [1248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 2),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(683),
  [1254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [1256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 6),
  [1260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition_nlist, 3),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [1264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuplevec, 1),
  [1266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuplevec, 2),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [1270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 6),
  [1272] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term_definition, 4),
  [1274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 5),
  [1276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 5),
  [1278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [1282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [1284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition_nlist, 1),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(646),
  [1290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term_definition, 3),
  [1292] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nidlist, 3),
  [1294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelemvec, 3),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(674),
  [1298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [1302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [1304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element_nlist, 3),
  [1306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [1308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [1310] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nconstargvec, 1),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [1316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(687),
  [1318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [1320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [1324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 4),
  [1330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [1334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [1336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [1340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 3),
  [1342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [1346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [1348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [1350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [1354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [1356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [1358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [1360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [1362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(694),
  [1364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [1366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(696),
  [1368] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [1372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(689),
  [1374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [1378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(691),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [1386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_nlist, 3),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [1396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [1398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [1400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(619),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [1406] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_identifier, 1),
  [1408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [1410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(669),
  [1412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [1414] = {.entry = {.count = 1, .reusable = false}}, SHIFT(651),
  [1416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [1418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [1420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [1422] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_aggregatefunction, 1),
  [1424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(654),
  [1428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [1430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_clingo(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
