#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 703
#define LARGE_STATE_COUNT 4
#define SYMBOL_COUNT 168
#define ALIAS_COUNT 0
#define TOKEN_COUNT 94
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 14
#define PRODUCTION_ID_COUNT 1

enum {
  sym_comment = 1,
  sym_ADD = 2,
  sym_AND = 3,
  sym_EQ = 4,
  sym_AT = 5,
  sym_BNOT = 6,
  sym_COLON = 7,
  sym_COMMA = 8,
  sym_CONST = 9,
  sym_COUNT = 10,
  sym_CSP = 11,
  sym_CSP_ADD = 12,
  sym_CSP_SUB = 13,
  sym_CSP_MUL = 14,
  sym_CSP_LEQ = 15,
  sym_CSP_LT = 16,
  sym_CSP_GT = 17,
  sym_CSP_GEQ = 18,
  sym_CSP_EQ = 19,
  sym_CSP_NEQ = 20,
  sym_DISJOINT = 21,
  sym_DOT = 22,
  sym_DOTS = 23,
  sym_EXTERNAL = 24,
  sym_DEFINED = 25,
  sym_FALSE = 26,
  sym_GEQ = 27,
  sym_GT = 28,
  sym_IF = 29,
  sym_INCLUDE = 30,
  sym_INFIMUM = 31,
  sym_LBRACE = 32,
  sym_LBRACK = 33,
  sym_LEQ = 34,
  sym_LPAREN = 35,
  sym_LT = 36,
  sym_MAX = 37,
  sym_MAXIMIZE = 38,
  sym_MIN = 39,
  sym_MINIMIZE = 40,
  sym_MOD = 41,
  sym_MUL = 42,
  sym_NEQ = 43,
  sym_POW = 44,
  sym_QUESTION = 45,
  sym_RBRACE = 46,
  sym_RBRACK = 47,
  sym_RPAREN = 48,
  sym_SEM = 49,
  sym_SHOW = 50,
  sym_EDGE = 51,
  sym_PROJECT = 52,
  sym_HEURISTIC = 53,
  sym_SHOWSIG = 54,
  sym_SLASH = 55,
  sym_SUB = 56,
  sym_SUM = 57,
  sym_SUMP = 58,
  sym_SUPREMUM = 59,
  sym_TRUE = 60,
  sym_BLOCK = 61,
  sym_VBAR = 62,
  sym_WIF = 63,
  sym_XOR = 64,
  sym_ANY = 65,
  sym_UNARY = 66,
  sym_BINARY = 67,
  sym_LEFT = 68,
  sym_RIGHT = 69,
  sym_HEAD = 70,
  sym_BODY = 71,
  sym_DIRECTIVE = 72,
  sym_THEORY = 73,
  anon_sym_0 = 74,
  aux_sym_dec_token1 = 75,
  sym_hex = 76,
  sym_oct = 77,
  sym_bin = 78,
  sym_ANONYMOUS = 79,
  sym_identifier = 80,
  anon_sym_LPAREN = 81,
  sym_SCRIPT = 82,
  sym_CODE = 83,
  sym_VARIABLE = 84,
  sym_THEORY_OP = 85,
  sym_NOT = 86,
  sym_DEFAULT = 87,
  sym_OVERRIDE = 88,
  anon_sym_BSLASH_BSLASH = 89,
  anon_sym_EQ_EQ = 90,
  anon_sym_DQUOTE = 91,
  sym_unescaped_double_string_fragment = 92,
  sym_escape_sequence = 93,
  sym_source_file = 94,
  sym_NUMBER = 95,
  sym_dec = 96,
  sym__widentifier = 97,
  sym_constterm = 98,
  sym_consttermvec = 99,
  sym_nconstargvec = 100,
  sym_term = 101,
  sym_unaryargvec = 102,
  sym_ntermvec = 103,
  sym_ntuple = 104,
  sym_tuplevec_sem = 105,
  sym_ntuplevec = 106,
  sym_argvec = 107,
  sym_binaryargvec = 108,
  sym_cmp = 109,
  sym_atom = 110,
  sym_literal = 111,
  sym_csp_mul_term = 112,
  sym_csp_add_term = 113,
  sym_csp_rel = 114,
  sym_csp_literal = 115,
  sym_nlitvec = 116,
  sym_noptcondition = 117,
  sym_aggregatefunction = 118,
  sym_bodyaggrelem = 119,
  sym_bodyaggrelemvec = 120,
  sym_altbodyaggrelem = 121,
  sym_altbodyaggrelemvec = 122,
  sym_bodyaggregate = 123,
  sym_nupper = 124,
  sym_lubodyaggregate = 125,
  sym_headaggrelemvec = 126,
  sym_altheadaggrelemvec = 127,
  sym_headaggregate = 128,
  sym_luheadaggregate = 129,
  sym_ncspelemvec = 130,
  sym_disjoint = 131,
  sym_conjunction = 132,
  sym_dsym = 133,
  sym_disjunctionsep = 134,
  sym_disjunction = 135,
  sym_nbodycomma = 136,
  sym_bodydot = 137,
  sym_bodyconddot = 138,
  sym_head = 139,
  sym_statement = 140,
  sym_noptimizetuple = 141,
  sym_optimizeweight = 142,
  sym_optimizelitvec = 143,
  sym_noptimizecond = 144,
  sym_maxelemlist = 145,
  sym_minelemlist = 146,
  sym_nidlist = 147,
  sym_theory_op = 148,
  sym_theory_op_list = 149,
  sym_theory_term = 150,
  sym_theory_opterm = 151,
  sym_theory_opterm_nlist = 152,
  sym_theory_atom_element = 153,
  sym_theory_atom_element_nlist = 154,
  sym_theory_atom_name = 155,
  sym_theory_atom = 156,
  sym_theory_operator_nlist = 157,
  sym_theory_operator_definition = 158,
  sym_theory_operator_definition_nlist = 159,
  sym_theory_definition_identifier = 160,
  sym_theory_term_definition = 161,
  sym_theory_atom_type = 162,
  sym_theory_atom_definition = 163,
  sym_theory_definition_nlist = 164,
  sym_STRING = 165,
  aux_sym_source_file_repeat1 = 166,
  aux_sym_STRING_repeat1 = 167,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_comment] = "comment",
  [sym_ADD] = "ADD",
  [sym_AND] = "AND",
  [sym_EQ] = "EQ",
  [sym_AT] = "AT",
  [sym_BNOT] = "BNOT",
  [sym_COLON] = "COLON",
  [sym_COMMA] = "COMMA",
  [sym_CONST] = "CONST",
  [sym_COUNT] = "COUNT",
  [sym_CSP] = "CSP",
  [sym_CSP_ADD] = "CSP_ADD",
  [sym_CSP_SUB] = "CSP_SUB",
  [sym_CSP_MUL] = "CSP_MUL",
  [sym_CSP_LEQ] = "CSP_LEQ",
  [sym_CSP_LT] = "CSP_LT",
  [sym_CSP_GT] = "CSP_GT",
  [sym_CSP_GEQ] = "CSP_GEQ",
  [sym_CSP_EQ] = "CSP_EQ",
  [sym_CSP_NEQ] = "CSP_NEQ",
  [sym_DISJOINT] = "DISJOINT",
  [sym_DOT] = "DOT",
  [sym_DOTS] = "DOTS",
  [sym_EXTERNAL] = "EXTERNAL",
  [sym_DEFINED] = "DEFINED",
  [sym_FALSE] = "FALSE",
  [sym_GEQ] = "GEQ",
  [sym_GT] = "GT",
  [sym_IF] = "IF",
  [sym_INCLUDE] = "INCLUDE",
  [sym_INFIMUM] = "INFIMUM",
  [sym_LBRACE] = "LBRACE",
  [sym_LBRACK] = "LBRACK",
  [sym_LEQ] = "LEQ",
  [sym_LPAREN] = "LPAREN",
  [sym_LT] = "LT",
  [sym_MAX] = "MAX",
  [sym_MAXIMIZE] = "MAXIMIZE",
  [sym_MIN] = "MIN",
  [sym_MINIMIZE] = "MINIMIZE",
  [sym_MOD] = "MOD",
  [sym_MUL] = "MUL",
  [sym_NEQ] = "NEQ",
  [sym_POW] = "POW",
  [sym_QUESTION] = "QUESTION",
  [sym_RBRACE] = "RBRACE",
  [sym_RBRACK] = "RBRACK",
  [sym_RPAREN] = "RPAREN",
  [sym_SEM] = "SEM",
  [sym_SHOW] = "SHOW",
  [sym_EDGE] = "EDGE",
  [sym_PROJECT] = "PROJECT",
  [sym_HEURISTIC] = "HEURISTIC",
  [sym_SHOWSIG] = "SHOWSIG",
  [sym_SLASH] = "SLASH",
  [sym_SUB] = "SUB",
  [sym_SUM] = "SUM",
  [sym_SUMP] = "SUMP",
  [sym_SUPREMUM] = "SUPREMUM",
  [sym_TRUE] = "TRUE",
  [sym_BLOCK] = "BLOCK",
  [sym_VBAR] = "VBAR",
  [sym_WIF] = "WIF",
  [sym_XOR] = "XOR",
  [sym_ANY] = "ANY",
  [sym_UNARY] = "UNARY",
  [sym_BINARY] = "BINARY",
  [sym_LEFT] = "LEFT",
  [sym_RIGHT] = "RIGHT",
  [sym_HEAD] = "HEAD",
  [sym_BODY] = "BODY",
  [sym_DIRECTIVE] = "DIRECTIVE",
  [sym_THEORY] = "THEORY",
  [anon_sym_0] = "0",
  [aux_sym_dec_token1] = "dec_token1",
  [sym_hex] = "hex",
  [sym_oct] = "oct",
  [sym_bin] = "bin",
  [sym_ANONYMOUS] = "ANONYMOUS",
  [sym_identifier] = "identifier",
  [anon_sym_LPAREN] = "LPAREN",
  [sym_SCRIPT] = "SCRIPT",
  [sym_CODE] = "CODE",
  [sym_VARIABLE] = "VARIABLE",
  [sym_THEORY_OP] = "THEORY_OP",
  [sym_NOT] = "NOT",
  [sym_DEFAULT] = "DEFAULT",
  [sym_OVERRIDE] = "OVERRIDE",
  [anon_sym_BSLASH_BSLASH] = "\\\\",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_DQUOTE] = "\"",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_source_file] = "source_file",
  [sym_NUMBER] = "NUMBER",
  [sym_dec] = "dec",
  [sym__widentifier] = "_widentifier",
  [sym_constterm] = "constterm",
  [sym_consttermvec] = "consttermvec",
  [sym_nconstargvec] = "nconstargvec",
  [sym_term] = "term",
  [sym_unaryargvec] = "unaryargvec",
  [sym_ntermvec] = "ntermvec",
  [sym_ntuple] = "ntuple",
  [sym_tuplevec_sem] = "tuplevec_sem",
  [sym_ntuplevec] = "ntuplevec",
  [sym_argvec] = "argvec",
  [sym_binaryargvec] = "binaryargvec",
  [sym_cmp] = "cmp",
  [sym_atom] = "atom",
  [sym_literal] = "literal",
  [sym_csp_mul_term] = "csp_mul_term",
  [sym_csp_add_term] = "csp_add_term",
  [sym_csp_rel] = "csp_rel",
  [sym_csp_literal] = "csp_literal",
  [sym_nlitvec] = "nlitvec",
  [sym_noptcondition] = "noptcondition",
  [sym_aggregatefunction] = "aggregatefunction",
  [sym_bodyaggrelem] = "bodyaggrelem",
  [sym_bodyaggrelemvec] = "bodyaggrelemvec",
  [sym_altbodyaggrelem] = "altbodyaggrelem",
  [sym_altbodyaggrelemvec] = "altbodyaggrelemvec",
  [sym_bodyaggregate] = "bodyaggregate",
  [sym_nupper] = "nupper",
  [sym_lubodyaggregate] = "lubodyaggregate",
  [sym_headaggrelemvec] = "headaggrelemvec",
  [sym_altheadaggrelemvec] = "altheadaggrelemvec",
  [sym_headaggregate] = "headaggregate",
  [sym_luheadaggregate] = "luheadaggregate",
  [sym_ncspelemvec] = "ncspelemvec",
  [sym_disjoint] = "disjoint",
  [sym_conjunction] = "conjunction",
  [sym_dsym] = "dsym",
  [sym_disjunctionsep] = "disjunctionsep",
  [sym_disjunction] = "disjunction",
  [sym_nbodycomma] = "nbodycomma",
  [sym_bodydot] = "bodydot",
  [sym_bodyconddot] = "bodyconddot",
  [sym_head] = "head",
  [sym_statement] = "statement",
  [sym_noptimizetuple] = "noptimizetuple",
  [sym_optimizeweight] = "optimizeweight",
  [sym_optimizelitvec] = "optimizelitvec",
  [sym_noptimizecond] = "noptimizecond",
  [sym_maxelemlist] = "maxelemlist",
  [sym_minelemlist] = "minelemlist",
  [sym_nidlist] = "nidlist",
  [sym_theory_op] = "theory_op",
  [sym_theory_op_list] = "theory_op_list",
  [sym_theory_term] = "theory_term",
  [sym_theory_opterm] = "theory_opterm",
  [sym_theory_opterm_nlist] = "theory_opterm_nlist",
  [sym_theory_atom_element] = "theory_atom_element",
  [sym_theory_atom_element_nlist] = "theory_atom_element_nlist",
  [sym_theory_atom_name] = "theory_atom_name",
  [sym_theory_atom] = "theory_atom",
  [sym_theory_operator_nlist] = "theory_operator_nlist",
  [sym_theory_operator_definition] = "theory_operator_definition",
  [sym_theory_operator_definition_nlist] = "theory_operator_definition_nlist",
  [sym_theory_definition_identifier] = "theory_definition_identifier",
  [sym_theory_term_definition] = "theory_term_definition",
  [sym_theory_atom_type] = "theory_atom_type",
  [sym_theory_atom_definition] = "theory_atom_definition",
  [sym_theory_definition_nlist] = "theory_definition_nlist",
  [sym_STRING] = "STRING",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_STRING_repeat1] = "STRING_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_comment] = sym_comment,
  [sym_ADD] = sym_ADD,
  [sym_AND] = sym_AND,
  [sym_EQ] = sym_EQ,
  [sym_AT] = sym_AT,
  [sym_BNOT] = sym_BNOT,
  [sym_COLON] = sym_COLON,
  [sym_COMMA] = sym_COMMA,
  [sym_CONST] = sym_CONST,
  [sym_COUNT] = sym_COUNT,
  [sym_CSP] = sym_CSP,
  [sym_CSP_ADD] = sym_CSP_ADD,
  [sym_CSP_SUB] = sym_CSP_SUB,
  [sym_CSP_MUL] = sym_CSP_MUL,
  [sym_CSP_LEQ] = sym_CSP_LEQ,
  [sym_CSP_LT] = sym_CSP_LT,
  [sym_CSP_GT] = sym_CSP_GT,
  [sym_CSP_GEQ] = sym_CSP_GEQ,
  [sym_CSP_EQ] = sym_CSP_EQ,
  [sym_CSP_NEQ] = sym_CSP_NEQ,
  [sym_DISJOINT] = sym_DISJOINT,
  [sym_DOT] = sym_DOT,
  [sym_DOTS] = sym_DOTS,
  [sym_EXTERNAL] = sym_EXTERNAL,
  [sym_DEFINED] = sym_DEFINED,
  [sym_FALSE] = sym_FALSE,
  [sym_GEQ] = sym_GEQ,
  [sym_GT] = sym_GT,
  [sym_IF] = sym_IF,
  [sym_INCLUDE] = sym_INCLUDE,
  [sym_INFIMUM] = sym_INFIMUM,
  [sym_LBRACE] = sym_LBRACE,
  [sym_LBRACK] = sym_LBRACK,
  [sym_LEQ] = sym_LEQ,
  [sym_LPAREN] = sym_LPAREN,
  [sym_LT] = sym_LT,
  [sym_MAX] = sym_MAX,
  [sym_MAXIMIZE] = sym_MAXIMIZE,
  [sym_MIN] = sym_MIN,
  [sym_MINIMIZE] = sym_MINIMIZE,
  [sym_MOD] = sym_MOD,
  [sym_MUL] = sym_MUL,
  [sym_NEQ] = sym_NEQ,
  [sym_POW] = sym_POW,
  [sym_QUESTION] = sym_QUESTION,
  [sym_RBRACE] = sym_RBRACE,
  [sym_RBRACK] = sym_RBRACK,
  [sym_RPAREN] = sym_RPAREN,
  [sym_SEM] = sym_SEM,
  [sym_SHOW] = sym_SHOW,
  [sym_EDGE] = sym_EDGE,
  [sym_PROJECT] = sym_PROJECT,
  [sym_HEURISTIC] = sym_HEURISTIC,
  [sym_SHOWSIG] = sym_SHOWSIG,
  [sym_SLASH] = sym_SLASH,
  [sym_SUB] = sym_SUB,
  [sym_SUM] = sym_SUM,
  [sym_SUMP] = sym_SUMP,
  [sym_SUPREMUM] = sym_SUPREMUM,
  [sym_TRUE] = sym_TRUE,
  [sym_BLOCK] = sym_BLOCK,
  [sym_VBAR] = sym_VBAR,
  [sym_WIF] = sym_WIF,
  [sym_XOR] = sym_XOR,
  [sym_ANY] = sym_ANY,
  [sym_UNARY] = sym_UNARY,
  [sym_BINARY] = sym_BINARY,
  [sym_LEFT] = sym_LEFT,
  [sym_RIGHT] = sym_RIGHT,
  [sym_HEAD] = sym_HEAD,
  [sym_BODY] = sym_BODY,
  [sym_DIRECTIVE] = sym_DIRECTIVE,
  [sym_THEORY] = sym_THEORY,
  [anon_sym_0] = anon_sym_0,
  [aux_sym_dec_token1] = aux_sym_dec_token1,
  [sym_hex] = sym_hex,
  [sym_oct] = sym_oct,
  [sym_bin] = sym_bin,
  [sym_ANONYMOUS] = sym_ANONYMOUS,
  [sym_identifier] = sym_identifier,
  [anon_sym_LPAREN] = sym_LPAREN,
  [sym_SCRIPT] = sym_SCRIPT,
  [sym_CODE] = sym_CODE,
  [sym_VARIABLE] = sym_VARIABLE,
  [sym_THEORY_OP] = sym_THEORY_OP,
  [sym_NOT] = sym_NOT,
  [sym_DEFAULT] = sym_DEFAULT,
  [sym_OVERRIDE] = sym_OVERRIDE,
  [anon_sym_BSLASH_BSLASH] = anon_sym_BSLASH_BSLASH,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_source_file] = sym_source_file,
  [sym_NUMBER] = sym_NUMBER,
  [sym_dec] = sym_dec,
  [sym__widentifier] = sym__widentifier,
  [sym_constterm] = sym_constterm,
  [sym_consttermvec] = sym_consttermvec,
  [sym_nconstargvec] = sym_nconstargvec,
  [sym_term] = sym_term,
  [sym_unaryargvec] = sym_unaryargvec,
  [sym_ntermvec] = sym_ntermvec,
  [sym_ntuple] = sym_ntuple,
  [sym_tuplevec_sem] = sym_tuplevec_sem,
  [sym_ntuplevec] = sym_ntuplevec,
  [sym_argvec] = sym_argvec,
  [sym_binaryargvec] = sym_binaryargvec,
  [sym_cmp] = sym_cmp,
  [sym_atom] = sym_atom,
  [sym_literal] = sym_literal,
  [sym_csp_mul_term] = sym_csp_mul_term,
  [sym_csp_add_term] = sym_csp_add_term,
  [sym_csp_rel] = sym_csp_rel,
  [sym_csp_literal] = sym_csp_literal,
  [sym_nlitvec] = sym_nlitvec,
  [sym_noptcondition] = sym_noptcondition,
  [sym_aggregatefunction] = sym_aggregatefunction,
  [sym_bodyaggrelem] = sym_bodyaggrelem,
  [sym_bodyaggrelemvec] = sym_bodyaggrelemvec,
  [sym_altbodyaggrelem] = sym_altbodyaggrelem,
  [sym_altbodyaggrelemvec] = sym_altbodyaggrelemvec,
  [sym_bodyaggregate] = sym_bodyaggregate,
  [sym_nupper] = sym_nupper,
  [sym_lubodyaggregate] = sym_lubodyaggregate,
  [sym_headaggrelemvec] = sym_headaggrelemvec,
  [sym_altheadaggrelemvec] = sym_altheadaggrelemvec,
  [sym_headaggregate] = sym_headaggregate,
  [sym_luheadaggregate] = sym_luheadaggregate,
  [sym_ncspelemvec] = sym_ncspelemvec,
  [sym_disjoint] = sym_disjoint,
  [sym_conjunction] = sym_conjunction,
  [sym_dsym] = sym_dsym,
  [sym_disjunctionsep] = sym_disjunctionsep,
  [sym_disjunction] = sym_disjunction,
  [sym_nbodycomma] = sym_nbodycomma,
  [sym_bodydot] = sym_bodydot,
  [sym_bodyconddot] = sym_bodyconddot,
  [sym_head] = sym_head,
  [sym_statement] = sym_statement,
  [sym_noptimizetuple] = sym_noptimizetuple,
  [sym_optimizeweight] = sym_optimizeweight,
  [sym_optimizelitvec] = sym_optimizelitvec,
  [sym_noptimizecond] = sym_noptimizecond,
  [sym_maxelemlist] = sym_maxelemlist,
  [sym_minelemlist] = sym_minelemlist,
  [sym_nidlist] = sym_nidlist,
  [sym_theory_op] = sym_theory_op,
  [sym_theory_op_list] = sym_theory_op_list,
  [sym_theory_term] = sym_theory_term,
  [sym_theory_opterm] = sym_theory_opterm,
  [sym_theory_opterm_nlist] = sym_theory_opterm_nlist,
  [sym_theory_atom_element] = sym_theory_atom_element,
  [sym_theory_atom_element_nlist] = sym_theory_atom_element_nlist,
  [sym_theory_atom_name] = sym_theory_atom_name,
  [sym_theory_atom] = sym_theory_atom,
  [sym_theory_operator_nlist] = sym_theory_operator_nlist,
  [sym_theory_operator_definition] = sym_theory_operator_definition,
  [sym_theory_operator_definition_nlist] = sym_theory_operator_definition_nlist,
  [sym_theory_definition_identifier] = sym_theory_definition_identifier,
  [sym_theory_term_definition] = sym_theory_term_definition,
  [sym_theory_atom_type] = sym_theory_atom_type,
  [sym_theory_atom_definition] = sym_theory_atom_definition,
  [sym_theory_definition_nlist] = sym_theory_definition_nlist,
  [sym_STRING] = sym_STRING,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_STRING_repeat1] = aux_sym_STRING_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_ADD] = {
    .visible = true,
    .named = true,
  },
  [sym_AND] = {
    .visible = true,
    .named = true,
  },
  [sym_EQ] = {
    .visible = true,
    .named = true,
  },
  [sym_AT] = {
    .visible = true,
    .named = true,
  },
  [sym_BNOT] = {
    .visible = true,
    .named = true,
  },
  [sym_COLON] = {
    .visible = true,
    .named = true,
  },
  [sym_COMMA] = {
    .visible = true,
    .named = true,
  },
  [sym_CONST] = {
    .visible = true,
    .named = true,
  },
  [sym_COUNT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_ADD] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_SUB] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_MUL] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_LEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_LT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_GT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_GEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_EQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_NEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_DISJOINT] = {
    .visible = true,
    .named = true,
  },
  [sym_DOT] = {
    .visible = true,
    .named = true,
  },
  [sym_DOTS] = {
    .visible = true,
    .named = true,
  },
  [sym_EXTERNAL] = {
    .visible = true,
    .named = true,
  },
  [sym_DEFINED] = {
    .visible = true,
    .named = true,
  },
  [sym_FALSE] = {
    .visible = true,
    .named = true,
  },
  [sym_GEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_GT] = {
    .visible = true,
    .named = true,
  },
  [sym_IF] = {
    .visible = true,
    .named = true,
  },
  [sym_INCLUDE] = {
    .visible = true,
    .named = true,
  },
  [sym_INFIMUM] = {
    .visible = true,
    .named = true,
  },
  [sym_LBRACE] = {
    .visible = true,
    .named = true,
  },
  [sym_LBRACK] = {
    .visible = true,
    .named = true,
  },
  [sym_LEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_LPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_LT] = {
    .visible = true,
    .named = true,
  },
  [sym_MAX] = {
    .visible = true,
    .named = true,
  },
  [sym_MAXIMIZE] = {
    .visible = true,
    .named = true,
  },
  [sym_MIN] = {
    .visible = true,
    .named = true,
  },
  [sym_MINIMIZE] = {
    .visible = true,
    .named = true,
  },
  [sym_MOD] = {
    .visible = true,
    .named = true,
  },
  [sym_MUL] = {
    .visible = true,
    .named = true,
  },
  [sym_NEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_POW] = {
    .visible = true,
    .named = true,
  },
  [sym_QUESTION] = {
    .visible = true,
    .named = true,
  },
  [sym_RBRACE] = {
    .visible = true,
    .named = true,
  },
  [sym_RBRACK] = {
    .visible = true,
    .named = true,
  },
  [sym_RPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_SEM] = {
    .visible = true,
    .named = true,
  },
  [sym_SHOW] = {
    .visible = true,
    .named = true,
  },
  [sym_EDGE] = {
    .visible = true,
    .named = true,
  },
  [sym_PROJECT] = {
    .visible = true,
    .named = true,
  },
  [sym_HEURISTIC] = {
    .visible = true,
    .named = true,
  },
  [sym_SHOWSIG] = {
    .visible = true,
    .named = true,
  },
  [sym_SLASH] = {
    .visible = true,
    .named = true,
  },
  [sym_SUB] = {
    .visible = true,
    .named = true,
  },
  [sym_SUM] = {
    .visible = true,
    .named = true,
  },
  [sym_SUMP] = {
    .visible = true,
    .named = true,
  },
  [sym_SUPREMUM] = {
    .visible = true,
    .named = true,
  },
  [sym_TRUE] = {
    .visible = true,
    .named = true,
  },
  [sym_BLOCK] = {
    .visible = true,
    .named = true,
  },
  [sym_VBAR] = {
    .visible = true,
    .named = true,
  },
  [sym_WIF] = {
    .visible = true,
    .named = true,
  },
  [sym_XOR] = {
    .visible = true,
    .named = true,
  },
  [sym_ANY] = {
    .visible = true,
    .named = true,
  },
  [sym_UNARY] = {
    .visible = true,
    .named = true,
  },
  [sym_BINARY] = {
    .visible = true,
    .named = true,
  },
  [sym_LEFT] = {
    .visible = true,
    .named = true,
  },
  [sym_RIGHT] = {
    .visible = true,
    .named = true,
  },
  [sym_HEAD] = {
    .visible = true,
    .named = true,
  },
  [sym_BODY] = {
    .visible = true,
    .named = true,
  },
  [sym_DIRECTIVE] = {
    .visible = true,
    .named = true,
  },
  [sym_THEORY] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_dec_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_hex] = {
    .visible = true,
    .named = true,
  },
  [sym_oct] = {
    .visible = true,
    .named = true,
  },
  [sym_bin] = {
    .visible = true,
    .named = true,
  },
  [sym_ANONYMOUS] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_SCRIPT] = {
    .visible = true,
    .named = true,
  },
  [sym_CODE] = {
    .visible = true,
    .named = true,
  },
  [sym_VARIABLE] = {
    .visible = true,
    .named = true,
  },
  [sym_THEORY_OP] = {
    .visible = true,
    .named = true,
  },
  [sym_NOT] = {
    .visible = true,
    .named = true,
  },
  [sym_DEFAULT] = {
    .visible = true,
    .named = true,
  },
  [sym_OVERRIDE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_NUMBER] = {
    .visible = true,
    .named = true,
  },
  [sym_dec] = {
    .visible = true,
    .named = true,
  },
  [sym__widentifier] = {
    .visible = false,
    .named = true,
  },
  [sym_constterm] = {
    .visible = true,
    .named = true,
  },
  [sym_consttermvec] = {
    .visible = true,
    .named = true,
  },
  [sym_nconstargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_term] = {
    .visible = true,
    .named = true,
  },
  [sym_unaryargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_ntermvec] = {
    .visible = true,
    .named = true,
  },
  [sym_ntuple] = {
    .visible = true,
    .named = true,
  },
  [sym_tuplevec_sem] = {
    .visible = true,
    .named = true,
  },
  [sym_ntuplevec] = {
    .visible = true,
    .named = true,
  },
  [sym_argvec] = {
    .visible = true,
    .named = true,
  },
  [sym_binaryargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_cmp] = {
    .visible = true,
    .named = true,
  },
  [sym_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_mul_term] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_add_term] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_rel] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_nlitvec] = {
    .visible = true,
    .named = true,
  },
  [sym_noptcondition] = {
    .visible = true,
    .named = true,
  },
  [sym_aggregatefunction] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggrelem] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_altbodyaggrelem] = {
    .visible = true,
    .named = true,
  },
  [sym_altbodyaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_nupper] = {
    .visible = true,
    .named = true,
  },
  [sym_lubodyaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_headaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_altheadaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_headaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_luheadaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_ncspelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_disjoint] = {
    .visible = true,
    .named = true,
  },
  [sym_conjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_dsym] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunctionsep] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_nbodycomma] = {
    .visible = true,
    .named = true,
  },
  [sym_bodydot] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyconddot] = {
    .visible = true,
    .named = true,
  },
  [sym_head] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_noptimizetuple] = {
    .visible = true,
    .named = true,
  },
  [sym_optimizeweight] = {
    .visible = true,
    .named = true,
  },
  [sym_optimizelitvec] = {
    .visible = true,
    .named = true,
  },
  [sym_noptimizecond] = {
    .visible = true,
    .named = true,
  },
  [sym_maxelemlist] = {
    .visible = true,
    .named = true,
  },
  [sym_minelemlist] = {
    .visible = true,
    .named = true,
  },
  [sym_nidlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_op] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_op_list] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_term] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_opterm] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_opterm_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_element] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_element_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_name] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_definition_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_definition_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_term_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_type] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_definition_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_STRING] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_STRING_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_THEORY_OP_character_set_1(int32_t c) {
  return (c < ';'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '-' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static inline bool sym_THEORY_OP_character_set_2(int32_t c) {
  return (c < ':'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '-' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static inline bool sym_THEORY_OP_character_set_3(int32_t c) {
  return (c < ':'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '.' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(205);
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(84);
      if (lookahead == '$') ADVANCE(238);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(361);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(232);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == '\\') ADVANCE(274);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'a') ADVANCE(339);
      if (lookahead == 'b') ADVANCE(337);
      if (lookahead == 'd') ADVANCE(322);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(327);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == 'o') ADVANCE(354);
      if (lookahead == 'r') ADVANCE(334);
      if (lookahead == 'u') ADVANCE(340);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(203)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(88);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(231);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '\\') ADVANCE(274);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == '$') ADVANCE(237);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(249);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(71);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '\\') ADVANCE(273);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(361);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(231);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(77);
      if (lookahead == 'a') ADVANCE(339);
      if (lookahead == 'b') ADVANCE(337);
      if (lookahead == 'd') ADVANCE(333);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(327);
      if (lookahead == 'r') ADVANCE(334);
      if (lookahead == 'u') ADVANCE(340);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(361);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(232);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == 'd') ADVANCE(107);
      if (lookahead == 'o') ADVANCE(187);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(231);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(77);
      if (lookahead == 'a') ADVANCE(339);
      if (lookahead == 'b') ADVANCE(337);
      if (lookahead == 'd') ADVANCE(333);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(327);
      if (lookahead == 'r') ADVANCE(334);
      if (lookahead == 'u') ADVANCE(340);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(232);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == 'd') ADVANCE(107);
      if (lookahead == 'o') ADVANCE(187);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '*') ADVANCE(241);
      if (lookahead == '+') ADVANCE(239);
      if (lookahead == '-') ADVANCE(240);
      if (lookahead == '<') ADVANCE(243);
      if (lookahead == '=') ADVANCE(246);
      if (lookahead == '>') ADVANCE(244);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '_') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(371);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 9:
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(233);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == '_') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '!' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(371);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '\\') ADVANCE(180);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(382);
      if (lookahead != 0) ADVANCE(386);
      END_STATE();
    case 11:
      if (lookahead == '#') ADVANCE(31);
      if (lookahead == '%') ADVANCE(221);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(11);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '#') ADVANCE(31);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '%') ADVANCE(220);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 14:
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(33);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '%') ADVANCE(222);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 17:
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 18:
      if (lookahead == '#') ADVANCE(49);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 19:
      if (lookahead == '#') ADVANCE(50);
      if (lookahead == '%') ADVANCE(223);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 20:
      if (lookahead == '#') ADVANCE(50);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 21:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 22:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 23:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(25);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 24:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 25:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(365);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 26:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(366);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 27:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 28:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'e') ADVANCE(28);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 29:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'e') ADVANCE(28);
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 30:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 31:
      if (lookahead == '#') ADVANCE(37);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 32:
      if (lookahead == '#') ADVANCE(40);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 33:
      if (lookahead == '#') ADVANCE(22);
      if (lookahead == 'e') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0 &&
          lookahead != 'd') ADVANCE(15);
      END_STATE();
    case 34:
      if (lookahead == '#') ADVANCE(28);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(70);
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 35:
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 36:
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 37:
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 38:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 39:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 40:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 41:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 42:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 43:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(59);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 44:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 45:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 46:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 47:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(61);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 48:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 49:
      if (lookahead == '#') ADVANCE(44);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 50:
      if (lookahead == '#') ADVANCE(48);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 51:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 52:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(54);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 53:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 54:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(363);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 55:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 56:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(58);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 57:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 58:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(364);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 59:
      if (lookahead == '#') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(367);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 60:
      if (lookahead == '#') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 61:
      if (lookahead == '#') ADVANCE(45);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(368);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 62:
      if (lookahead == '#') ADVANCE(45);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 63:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(361);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(249);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(273);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      END_STATE();
    case 64:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(249);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(273);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      END_STATE();
    case 65:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(65)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          (':' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(371);
      END_STATE();
    case 66:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '.') ADVANCE(251);
      if (lookahead == ';') ADVANCE(283);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(66)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          (':' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(371);
      END_STATE();
    case 67:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == ':') ADVANCE(233);
      if (lookahead == ';') ADVANCE(283);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(67)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          ('<' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(371);
      END_STATE();
    case 68:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '.') ADVANCE(251);
      if (lookahead == ':') ADVANCE(370);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(68)
      if (sym_THEORY_OP_character_set_1(lookahead)) ADVANCE(371);
      END_STATE();
    case 69:
      if (lookahead == '%') ADVANCE(206);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 70:
      if (lookahead == '*') ADVANCE(69);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 71:
      if (lookahead == '-') ADVANCE(258);
      END_STATE();
    case 72:
      if (lookahead == '-') ADVANCE(258);
      if (lookahead == '~') ADVANCE(297);
      END_STATE();
    case 73:
      if (lookahead == '=') ADVANCE(276);
      END_STATE();
    case 74:
      if (lookahead == '=') ADVANCE(247);
      END_STATE();
    case 75:
      if (lookahead == '\\') ADVANCE(378);
      END_STATE();
    case 76:
      if (lookahead == '_') ADVANCE(76);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 77:
      if (lookahead == '_') ADVANCE(77);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 78:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(189);
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(190);
      if (lookahead == 'i') ADVANCE(140);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(135);
      END_STATE();
    case 82:
      if (lookahead == 'a') ADVANCE(129);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 84:
      if (lookahead == 'c') ADVANCE(147);
      if (lookahead == 'd') ADVANCE(95);
      if (lookahead == 'e') ADVANCE(91);
      if (lookahead == 'f') ADVANCE(78);
      if (lookahead == 'h') ADVANCE(96);
      if (lookahead == 'i') ADVANCE(138);
      if (lookahead == 'm') ADVANCE(79);
      if (lookahead == 'p') ADVANCE(157);
      if (lookahead == 's') ADVANCE(86);
      if (lookahead == 't') ADVANCE(116);
      END_STATE();
    case 85:
      if (lookahead == 'c') ADVANCE(287);
      END_STATE();
    case 86:
      if (lookahead == 'c') ADVANCE(160);
      if (lookahead == 'h') ADVANCE(149);
      if (lookahead == 'u') ADVANCE(134);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(131);
      if (lookahead == 'f') ADVANCE(261);
      END_STATE();
    case 88:
      if (lookahead == 'c') ADVANCE(151);
      if (lookahead == 'd') ADVANCE(117);
      if (lookahead == 'f') ADVANCE(78);
      if (lookahead == 'i') ADVANCE(141);
      if (lookahead == 'm') ADVANCE(80);
      if (lookahead == 's') ADVANCE(178);
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 89:
      if (lookahead == 'c') ADVANCE(151);
      if (lookahead == 'm') ADVANCE(80);
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 90:
      if (lookahead == 'c') ADVANCE(172);
      END_STATE();
    case 91:
      if (lookahead == 'd') ADVANCE(114);
      if (lookahead == 'x') ADVANCE(176);
      END_STATE();
    case 92:
      if (lookahead == 'd') ADVANCE(254);
      END_STATE();
    case 93:
      if (lookahead == 'd') ADVANCE(101);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(104);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(110);
      if (lookahead == 'i') ADVANCE(165);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(285);
      END_STATE();
    case 98:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(255);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(260);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(269);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(272);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(376);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(112);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 110:
      if (lookahead == 'f') ADVANCE(122);
      END_STATE();
    case 111:
      if (lookahead == 'f') ADVANCE(261);
      END_STATE();
    case 112:
      if (lookahead == 'f') ADVANCE(83);
      END_STATE();
    case 113:
      if (lookahead == 'g') ADVANCE(288);
      END_STATE();
    case 114:
      if (lookahead == 'g') ADVANCE(97);
      END_STATE();
    case 115:
      if (lookahead == 'g') ADVANCE(158);
      if (lookahead == 'j') ADVANCE(100);
      END_STATE();
    case 116:
      if (lookahead == 'h') ADVANCE(108);
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 117:
      if (lookahead == 'i') ADVANCE(165);
      END_STATE();
    case 118:
      if (lookahead == 'i') ADVANCE(155);
      END_STATE();
    case 119:
      if (lookahead == 'i') ADVANCE(192);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(113);
      END_STATE();
    case 121:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 122:
      if (lookahead == 'i') ADVANCE(145);
      END_STATE();
    case 123:
      if (lookahead == 'i') ADVANCE(141);
      if (lookahead == 's') ADVANCE(181);
      END_STATE();
    case 124:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 125:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 126:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 127:
      if (lookahead == 'i') ADVANCE(144);
      END_STATE();
    case 128:
      if (lookahead == 'j') ADVANCE(153);
      END_STATE();
    case 129:
      if (lookahead == 'l') ADVANCE(253);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(168);
      END_STATE();
    case 131:
      if (lookahead == 'l') ADVANCE(179);
      END_STATE();
    case 132:
      if (lookahead == 'l') ADVANCE(174);
      END_STATE();
    case 133:
      if (lookahead == 'm') ADVANCE(291);
      END_STATE();
    case 134:
      if (lookahead == 'm') ADVANCE(291);
      if (lookahead == 'p') ADVANCE(293);
      END_STATE();
    case 135:
      if (lookahead == 'm') ADVANCE(295);
      END_STATE();
    case 136:
      if (lookahead == 'm') ADVANCE(119);
      END_STATE();
    case 137:
      if (lookahead == 'm') ADVANCE(125);
      END_STATE();
    case 138:
      if (lookahead == 'n') ADVANCE(87);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(271);
      END_STATE();
    case 140:
      if (lookahead == 'n') ADVANCE(270);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(111);
      END_STATE();
    case 142:
      if (lookahead == 'n') ADVANCE(166);
      if (lookahead == 'u') ADVANCE(143);
      END_STATE();
    case 143:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 144:
      if (lookahead == 'n') ADVANCE(173);
      END_STATE();
    case 145:
      if (lookahead == 'n') ADVANCE(105);
      END_STATE();
    case 146:
      if (lookahead == 'n') ADVANCE(82);
      END_STATE();
    case 147:
      if (lookahead == 'o') ADVANCE(142);
      END_STATE();
    case 148:
      if (lookahead == 'o') ADVANCE(115);
      END_STATE();
    case 149:
      if (lookahead == 'o') ADVANCE(188);
      END_STATE();
    case 150:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 151:
      if (lookahead == 'o') ADVANCE(182);
      END_STATE();
    case 152:
      if (lookahead == 'o') ADVANCE(175);
      END_STATE();
    case 153:
      if (lookahead == 'o') ADVANCE(127);
      END_STATE();
    case 154:
      if (lookahead == 'p') ADVANCE(293);
      END_STATE();
    case 155:
      if (lookahead == 'p') ADVANCE(171);
      END_STATE();
    case 156:
      if (lookahead == 'r') ADVANCE(191);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 158:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 159:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 160:
      if (lookahead == 'r') ADVANCE(118);
      END_STATE();
    case 161:
      if (lookahead == 'r') ADVANCE(126);
      END_STATE();
    case 162:
      if (lookahead == 'r') ADVANCE(146);
      END_STATE();
    case 163:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(163);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(128);
      END_STATE();
    case 166:
      if (lookahead == 's') ADVANCE(169);
      END_STATE();
    case 167:
      if (lookahead == 's') ADVANCE(177);
      END_STATE();
    case 168:
      if (lookahead == 's') ADVANCE(99);
      END_STATE();
    case 169:
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 170:
      if (lookahead == 't') ADVANCE(236);
      END_STATE();
    case 171:
      if (lookahead == 't') ADVANCE(362);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(286);
      END_STATE();
    case 173:
      if (lookahead == 't') ADVANCE(248);
      END_STATE();
    case 174:
      if (lookahead == 't') ADVANCE(374);
      END_STATE();
    case 175:
      if (lookahead == 't') ADVANCE(372);
      END_STATE();
    case 176:
      if (lookahead == 't') ADVANCE(106);
      END_STATE();
    case 177:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 178:
      if (lookahead == 'u') ADVANCE(134);
      END_STATE();
    case 179:
      if (lookahead == 'u') ADVANCE(93);
      END_STATE();
    case 180:
      if (lookahead == 'u') ADVANCE(194);
      if (lookahead == 'x') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(389);
      if (lookahead != 0) ADVANCE(387);
      END_STATE();
    case 181:
      if (lookahead == 'u') ADVANCE(154);
      END_STATE();
    case 182:
      if (lookahead == 'u') ADVANCE(143);
      END_STATE();
    case 183:
      if (lookahead == 'u') ADVANCE(133);
      END_STATE();
    case 184:
      if (lookahead == 'u') ADVANCE(132);
      END_STATE();
    case 185:
      if (lookahead == 'u') ADVANCE(98);
      END_STATE();
    case 186:
      if (lookahead == 'u') ADVANCE(161);
      END_STATE();
    case 187:
      if (lookahead == 'v') ADVANCE(109);
      END_STATE();
    case 188:
      if (lookahead == 'w') ADVANCE(284);
      END_STATE();
    case 189:
      if (lookahead == 'x') ADVANCE(268);
      END_STATE();
    case 190:
      if (lookahead == 'x') ADVANCE(267);
      END_STATE();
    case 191:
      if (lookahead == 'y') ADVANCE(307);
      END_STATE();
    case 192:
      if (lookahead == 'z') ADVANCE(102);
      END_STATE();
    case 193:
      if (lookahead == 'z') ADVANCE(103);
      END_STATE();
    case 194:
      if (lookahead == '{') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(201);
      END_STATE();
    case 195:
      if (lookahead == '}') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(195);
      END_STATE();
    case 196:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(312);
      END_STATE();
    case 197:
      if (('1' <= lookahead && lookahead <= '7')) ADVANCE(311);
      END_STATE();
    case 198:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(310);
      END_STATE();
    case 199:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(387);
      END_STATE();
    case 200:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(195);
      END_STATE();
    case 201:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 202:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(199);
      END_STATE();
    case 203:
      if (eof) ADVANCE(205);
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(84);
      if (lookahead == '$') ADVANCE(238);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(232);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == '\\') ADVANCE(274);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'a') ADVANCE(339);
      if (lookahead == 'b') ADVANCE(337);
      if (lookahead == 'd') ADVANCE(322);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(327);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == 'o') ADVANCE(354);
      if (lookahead == 'r') ADVANCE(334);
      if (lookahead == 'u') ADVANCE(340);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(203)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 204:
      if (eof) ADVANCE(205);
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(84);
      if (lookahead == '$') ADVANCE(237);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(204)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == 'd') ADVANCE(209);
      if (lookahead == 'e') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == 'd') ADVANCE(209);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(211);
      if (lookahead == 'd') ADVANCE(209);
      if (lookahead == 'e') ADVANCE(217);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(211);
      if (lookahead == 'd') ADVANCE(209);
      if (lookahead == 'e') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(213);
      if (lookahead == 'd') ADVANCE(225);
      if (lookahead == 'e') ADVANCE(213);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(213);
      if (lookahead == 'd') ADVANCE(215);
      if (lookahead == 'e') ADVANCE(213);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(213);
      if (lookahead == 'd') ADVANCE(215);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(217);
      if (lookahead == 'd') ADVANCE(219);
      if (lookahead == 'e') ADVANCE(217);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(217);
      if (lookahead == 'd') ADVANCE(219);
      if (lookahead == 'e') ADVANCE(217);
      if (lookahead == 'n') ADVANCE(218);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(216);
      if (lookahead == 'd') ADVANCE(219);
      if (lookahead == 'n') ADVANCE(218);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(216);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(31);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '*') ADVANCE(14);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(49);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead != 0) ADVANCE(225);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(225);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_ADD);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_AND);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_EQ);
      if (lookahead == '=') ADVANCE(379);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_AT);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_BNOT);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_COLON);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_COLON);
      if (lookahead == '-') ADVANCE(258);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_COLON);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_COMMA);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_CONST);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_COUNT);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_CSP);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_CSP);
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '*') ADVANCE(241);
      if (lookahead == '+') ADVANCE(239);
      if (lookahead == '<') ADVANCE(243);
      if (lookahead == '=') ADVANCE(246);
      if (lookahead == '>') ADVANCE(244);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_CSP_ADD);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_CSP_SUB);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_CSP_MUL);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_CSP_LEQ);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_CSP_LT);
      if (lookahead == '=') ADVANCE(242);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_CSP_GT);
      if (lookahead == '=') ADVANCE(245);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_CSP_GEQ);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_CSP_EQ);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_CSP_NEQ);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_DISJOINT);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_DOT);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_DOT);
      if (lookahead == '.') ADVANCE(252);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_DOT);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_DOTS);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_EXTERNAL);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_DEFINED);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_FALSE);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_GEQ);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_GT);
      if (lookahead == '=') ADVANCE(256);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_IF);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_IF);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_INCLUDE);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_INFIMUM);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_LBRACE);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_LBRACK);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_LEQ);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_LPAREN);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_LT);
      if (lookahead == '=') ADVANCE(264);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_MAX);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_MAX);
      if (lookahead == 'i') ADVANCE(136);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_MAXIMIZE);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_MIN);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_MIN);
      if (lookahead == 'i') ADVANCE(137);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_MINIMIZE);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_MOD);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_MOD);
      if (lookahead == '\\') ADVANCE(378);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_MUL);
      if (lookahead == '*') ADVANCE(277);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_NEQ);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_POW);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_QUESTION);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_RBRACE);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_RBRACK);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_RPAREN);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_SEM);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_SEM);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_SHOW);
      if (lookahead == 's') ADVANCE(120);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_EDGE);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_PROJECT);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_HEURISTIC);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_SHOWSIG);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_SLASH);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_SUB);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_SUM);
      if (lookahead == '+') ADVANCE(292);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_SUMP);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_SUPREMUM);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_TRUE);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_BLOCK);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_VBAR);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_WIF);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_XOR);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_ANY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_UNARY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_BINARY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_LEFT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_RIGHT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_HEAD);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_BODY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_DIRECTIVE);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_THEORY);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == 'b') ADVANCE(196);
      if (lookahead == 'o') ADVANCE(197);
      if (lookahead == 'x') ADVANCE(198);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(aux_sym_dec_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(309);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_hex);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(310);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_oct);
      if (('1' <= lookahead && lookahead <= '7')) ADVANCE(311);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_bin);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(312);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_ANONYMOUS);
      if (lookahead == '_') ADVANCE(76);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(353);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(319);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(346);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(352);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(304);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(357);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(325);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(330);
      if (lookahead == 'i') ADVANCE(345);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(315);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(318);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(377);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(306);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(329);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(347);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(349);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(314);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'g') ADVANCE(332);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(350);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(345);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(331);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(321);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(355);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(341);
      if (lookahead == 'o') ADVANCE(320);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(351);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(356);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(316);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(317);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(348);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(335);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(358);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(324);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(359);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(343);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(373);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(302);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(303);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(375);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(336);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(338);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(328);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(326);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(299);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(305);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(300);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(301);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_SCRIPT);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(31);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(49);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(50);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_VARIABLE);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(369);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_THEORY_OP);
      if (lookahead == '-') ADVANCE(259);
      if (sym_THEORY_OP_character_set_3(lookahead)) ADVANCE(371);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_THEORY_OP);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_NOT);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_NOT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_DEFAULT);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_DEFAULT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_OVERRIDE);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_OVERRIDE);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_BSLASH_BSLASH);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(386);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(381);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(382);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(386);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '*') ADVANCE(383);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(384);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(383);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(384);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(384);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(381);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(386);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(387);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(388);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 204},
  [2] = {.lex_state = 204},
  [3] = {.lex_state = 204},
  [4] = {.lex_state = 204},
  [5] = {.lex_state = 204},
  [6] = {.lex_state = 204},
  [7] = {.lex_state = 204},
  [8] = {.lex_state = 204},
  [9] = {.lex_state = 204},
  [10] = {.lex_state = 204},
  [11] = {.lex_state = 204},
  [12] = {.lex_state = 204},
  [13] = {.lex_state = 204},
  [14] = {.lex_state = 204},
  [15] = {.lex_state = 204},
  [16] = {.lex_state = 204},
  [17] = {.lex_state = 204},
  [18] = {.lex_state = 204},
  [19] = {.lex_state = 204},
  [20] = {.lex_state = 204},
  [21] = {.lex_state = 204},
  [22] = {.lex_state = 204},
  [23] = {.lex_state = 204},
  [24] = {.lex_state = 204},
  [25] = {.lex_state = 204},
  [26] = {.lex_state = 204},
  [27] = {.lex_state = 204},
  [28] = {.lex_state = 204},
  [29] = {.lex_state = 1},
  [30] = {.lex_state = 1},
  [31] = {.lex_state = 3},
  [32] = {.lex_state = 3},
  [33] = {.lex_state = 1},
  [34] = {.lex_state = 1},
  [35] = {.lex_state = 3},
  [36] = {.lex_state = 3},
  [37] = {.lex_state = 3},
  [38] = {.lex_state = 3},
  [39] = {.lex_state = 3},
  [40] = {.lex_state = 3},
  [41] = {.lex_state = 3},
  [42] = {.lex_state = 3},
  [43] = {.lex_state = 3},
  [44] = {.lex_state = 3},
  [45] = {.lex_state = 3},
  [46] = {.lex_state = 3},
  [47] = {.lex_state = 4},
  [48] = {.lex_state = 4},
  [49] = {.lex_state = 4},
  [50] = {.lex_state = 4},
  [51] = {.lex_state = 3},
  [52] = {.lex_state = 3},
  [53] = {.lex_state = 204},
  [54] = {.lex_state = 3},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 204},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 3},
  [60] = {.lex_state = 3},
  [61] = {.lex_state = 204},
  [62] = {.lex_state = 204},
  [63] = {.lex_state = 204},
  [64] = {.lex_state = 1},
  [65] = {.lex_state = 204},
  [66] = {.lex_state = 204},
  [67] = {.lex_state = 204},
  [68] = {.lex_state = 204},
  [69] = {.lex_state = 1},
  [70] = {.lex_state = 1},
  [71] = {.lex_state = 204},
  [72] = {.lex_state = 204},
  [73] = {.lex_state = 204},
  [74] = {.lex_state = 2},
  [75] = {.lex_state = 2},
  [76] = {.lex_state = 2},
  [77] = {.lex_state = 204},
  [78] = {.lex_state = 204},
  [79] = {.lex_state = 204},
  [80] = {.lex_state = 204},
  [81] = {.lex_state = 204},
  [82] = {.lex_state = 204},
  [83] = {.lex_state = 204},
  [84] = {.lex_state = 204},
  [85] = {.lex_state = 204},
  [86] = {.lex_state = 1},
  [87] = {.lex_state = 1},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 1},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 204},
  [92] = {.lex_state = 204},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 204},
  [95] = {.lex_state = 204},
  [96] = {.lex_state = 9},
  [97] = {.lex_state = 3},
  [98] = {.lex_state = 9},
  [99] = {.lex_state = 3},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 4},
  [102] = {.lex_state = 1},
  [103] = {.lex_state = 1},
  [104] = {.lex_state = 204},
  [105] = {.lex_state = 4},
  [106] = {.lex_state = 204},
  [107] = {.lex_state = 1},
  [108] = {.lex_state = 204},
  [109] = {.lex_state = 4},
  [110] = {.lex_state = 4},
  [111] = {.lex_state = 4},
  [112] = {.lex_state = 4},
  [113] = {.lex_state = 9},
  [114] = {.lex_state = 1},
  [115] = {.lex_state = 4},
  [116] = {.lex_state = 4},
  [117] = {.lex_state = 204},
  [118] = {.lex_state = 1},
  [119] = {.lex_state = 1},
  [120] = {.lex_state = 4},
  [121] = {.lex_state = 4},
  [122] = {.lex_state = 204},
  [123] = {.lex_state = 2},
  [124] = {.lex_state = 1},
  [125] = {.lex_state = 4},
  [126] = {.lex_state = 4},
  [127] = {.lex_state = 4},
  [128] = {.lex_state = 4},
  [129] = {.lex_state = 204},
  [130] = {.lex_state = 4},
  [131] = {.lex_state = 2},
  [132] = {.lex_state = 2},
  [133] = {.lex_state = 4},
  [134] = {.lex_state = 1},
  [135] = {.lex_state = 1},
  [136] = {.lex_state = 4},
  [137] = {.lex_state = 4},
  [138] = {.lex_state = 4},
  [139] = {.lex_state = 4},
  [140] = {.lex_state = 8},
  [141] = {.lex_state = 1},
  [142] = {.lex_state = 8},
  [143] = {.lex_state = 2},
  [144] = {.lex_state = 8},
  [145] = {.lex_state = 1},
  [146] = {.lex_state = 1},
  [147] = {.lex_state = 1},
  [148] = {.lex_state = 2},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 2},
  [151] = {.lex_state = 8},
  [152] = {.lex_state = 8},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 3},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 8},
  [157] = {.lex_state = 8},
  [158] = {.lex_state = 8},
  [159] = {.lex_state = 2},
  [160] = {.lex_state = 8},
  [161] = {.lex_state = 8},
  [162] = {.lex_state = 3},
  [163] = {.lex_state = 2},
  [164] = {.lex_state = 8},
  [165] = {.lex_state = 8},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 8},
  [168] = {.lex_state = 1},
  [169] = {.lex_state = 8},
  [170] = {.lex_state = 2},
  [171] = {.lex_state = 8},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 8},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 1},
  [176] = {.lex_state = 4},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 2},
  [179] = {.lex_state = 8},
  [180] = {.lex_state = 2},
  [181] = {.lex_state = 8},
  [182] = {.lex_state = 2},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 8},
  [186] = {.lex_state = 1},
  [187] = {.lex_state = 3},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 2},
  [190] = {.lex_state = 2},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 3},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 8},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 8},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 8},
  [200] = {.lex_state = 1},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 8},
  [204] = {.lex_state = 8},
  [205] = {.lex_state = 8},
  [206] = {.lex_state = 8},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 1},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 8},
  [259] = {.lex_state = 8},
  [260] = {.lex_state = 8},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 8},
  [263] = {.lex_state = 8},
  [264] = {.lex_state = 8},
  [265] = {.lex_state = 8},
  [266] = {.lex_state = 204},
  [267] = {.lex_state = 204},
  [268] = {.lex_state = 204},
  [269] = {.lex_state = 204},
  [270] = {.lex_state = 8},
  [271] = {.lex_state = 204},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 1},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 1},
  [282] = {.lex_state = 204},
  [283] = {.lex_state = 204},
  [284] = {.lex_state = 204},
  [285] = {.lex_state = 1},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 204},
  [288] = {.lex_state = 1},
  [289] = {.lex_state = 8},
  [290] = {.lex_state = 1},
  [291] = {.lex_state = 2},
  [292] = {.lex_state = 3},
  [293] = {.lex_state = 3},
  [294] = {.lex_state = 4},
  [295] = {.lex_state = 4},
  [296] = {.lex_state = 4},
  [297] = {.lex_state = 3},
  [298] = {.lex_state = 3},
  [299] = {.lex_state = 8},
  [300] = {.lex_state = 4},
  [301] = {.lex_state = 8},
  [302] = {.lex_state = 3},
  [303] = {.lex_state = 4},
  [304] = {.lex_state = 3},
  [305] = {.lex_state = 3},
  [306] = {.lex_state = 3},
  [307] = {.lex_state = 63},
  [308] = {.lex_state = 63},
  [309] = {.lex_state = 4},
  [310] = {.lex_state = 3},
  [311] = {.lex_state = 2},
  [312] = {.lex_state = 2},
  [313] = {.lex_state = 2},
  [314] = {.lex_state = 2},
  [315] = {.lex_state = 2},
  [316] = {.lex_state = 2},
  [317] = {.lex_state = 2},
  [318] = {.lex_state = 204},
  [319] = {.lex_state = 2},
  [320] = {.lex_state = 4},
  [321] = {.lex_state = 1},
  [322] = {.lex_state = 2},
  [323] = {.lex_state = 1},
  [324] = {.lex_state = 204},
  [325] = {.lex_state = 2},
  [326] = {.lex_state = 2},
  [327] = {.lex_state = 1},
  [328] = {.lex_state = 204},
  [329] = {.lex_state = 204},
  [330] = {.lex_state = 3},
  [331] = {.lex_state = 1},
  [332] = {.lex_state = 3},
  [333] = {.lex_state = 204},
  [334] = {.lex_state = 204},
  [335] = {.lex_state = 204},
  [336] = {.lex_state = 1},
  [337] = {.lex_state = 204},
  [338] = {.lex_state = 204},
  [339] = {.lex_state = 2},
  [340] = {.lex_state = 2},
  [341] = {.lex_state = 204},
  [342] = {.lex_state = 204},
  [343] = {.lex_state = 204},
  [344] = {.lex_state = 1},
  [345] = {.lex_state = 204},
  [346] = {.lex_state = 204},
  [347] = {.lex_state = 204},
  [348] = {.lex_state = 204},
  [349] = {.lex_state = 3},
  [350] = {.lex_state = 2},
  [351] = {.lex_state = 2},
  [352] = {.lex_state = 3},
  [353] = {.lex_state = 3},
  [354] = {.lex_state = 3},
  [355] = {.lex_state = 1},
  [356] = {.lex_state = 1},
  [357] = {.lex_state = 1},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 65},
  [360] = {.lex_state = 67},
  [361] = {.lex_state = 65},
  [362] = {.lex_state = 67},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 67},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 66},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 65},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 66},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 65},
  [378] = {.lex_state = 65},
  [379] = {.lex_state = 65},
  [380] = {.lex_state = 1},
  [381] = {.lex_state = 66},
  [382] = {.lex_state = 65},
  [383] = {.lex_state = 68},
  [384] = {.lex_state = 65},
  [385] = {.lex_state = 66},
  [386] = {.lex_state = 67},
  [387] = {.lex_state = 65},
  [388] = {.lex_state = 67},
  [389] = {.lex_state = 1},
  [390] = {.lex_state = 65},
  [391] = {.lex_state = 65},
  [392] = {.lex_state = 1},
  [393] = {.lex_state = 1},
  [394] = {.lex_state = 4},
  [395] = {.lex_state = 1},
  [396] = {.lex_state = 1},
  [397] = {.lex_state = 67},
  [398] = {.lex_state = 65},
  [399] = {.lex_state = 67},
  [400] = {.lex_state = 65},
  [401] = {.lex_state = 67},
  [402] = {.lex_state = 65},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 65},
  [406] = {.lex_state = 67},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 1},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 67},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 65},
  [413] = {.lex_state = 67},
  [414] = {.lex_state = 65},
  [415] = {.lex_state = 68},
  [416] = {.lex_state = 1},
  [417] = {.lex_state = 67},
  [418] = {.lex_state = 67},
  [419] = {.lex_state = 67},
  [420] = {.lex_state = 65},
  [421] = {.lex_state = 67},
  [422] = {.lex_state = 65},
  [423] = {.lex_state = 66},
  [424] = {.lex_state = 65},
  [425] = {.lex_state = 68},
  [426] = {.lex_state = 66},
  [427] = {.lex_state = 1},
  [428] = {.lex_state = 68},
  [429] = {.lex_state = 1},
  [430] = {.lex_state = 1},
  [431] = {.lex_state = 0},
  [432] = {.lex_state = 1},
  [433] = {.lex_state = 1},
  [434] = {.lex_state = 1},
  [435] = {.lex_state = 1},
  [436] = {.lex_state = 0},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 68},
  [440] = {.lex_state = 65},
  [441] = {.lex_state = 66},
  [442] = {.lex_state = 66},
  [443] = {.lex_state = 66},
  [444] = {.lex_state = 66},
  [445] = {.lex_state = 66},
  [446] = {.lex_state = 66},
  [447] = {.lex_state = 1},
  [448] = {.lex_state = 66},
  [449] = {.lex_state = 66},
  [450] = {.lex_state = 66},
  [451] = {.lex_state = 66},
  [452] = {.lex_state = 66},
  [453] = {.lex_state = 10},
  [454] = {.lex_state = 10},
  [455] = {.lex_state = 1},
  [456] = {.lex_state = 10},
  [457] = {.lex_state = 1},
  [458] = {.lex_state = 10},
  [459] = {.lex_state = 1},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 10},
  [462] = {.lex_state = 1},
  [463] = {.lex_state = 10},
  [464] = {.lex_state = 1},
  [465] = {.lex_state = 10},
  [466] = {.lex_state = 10},
  [467] = {.lex_state = 1},
  [468] = {.lex_state = 1},
  [469] = {.lex_state = 1},
  [470] = {.lex_state = 1},
  [471] = {.lex_state = 10},
  [472] = {.lex_state = 3},
  [473] = {.lex_state = 10},
  [474] = {.lex_state = 10},
  [475] = {.lex_state = 10},
  [476] = {.lex_state = 1},
  [477] = {.lex_state = 3},
  [478] = {.lex_state = 65},
  [479] = {.lex_state = 1},
  [480] = {.lex_state = 1},
  [481] = {.lex_state = 1},
  [482] = {.lex_state = 68},
  [483] = {.lex_state = 68},
  [484] = {.lex_state = 68},
  [485] = {.lex_state = 68},
  [486] = {.lex_state = 68},
  [487] = {.lex_state = 68},
  [488] = {.lex_state = 68},
  [489] = {.lex_state = 68},
  [490] = {.lex_state = 68},
  [491] = {.lex_state = 68},
  [492] = {.lex_state = 1},
  [493] = {.lex_state = 68},
  [494] = {.lex_state = 10},
  [495] = {.lex_state = 1},
  [496] = {.lex_state = 68},
  [497] = {.lex_state = 1},
  [498] = {.lex_state = 1},
  [499] = {.lex_state = 1},
  [500] = {.lex_state = 2},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 3},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 65},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 1},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 1},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 1},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 0},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 1},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 3},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 1},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 1},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 1},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 1},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 1},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 4},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 1},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 1},
  [618] = {.lex_state = 1},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 204},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 1},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 1},
  [629] = {.lex_state = 1},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 1},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 1},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 204},
  [655] = {.lex_state = 1},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 204},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 1},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 1},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 1},
  [670] = {.lex_state = 204},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 1},
  [673] = {.lex_state = 1},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 1},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 204},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 1},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 11},
  [702] = {.lex_state = 1},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_ADD] = ACTIONS(1),
    [sym_AND] = ACTIONS(1),
    [sym_EQ] = ACTIONS(1),
    [sym_AT] = ACTIONS(1),
    [sym_BNOT] = ACTIONS(1),
    [sym_COLON] = ACTIONS(1),
    [sym_COMMA] = ACTIONS(1),
    [sym_CONST] = ACTIONS(1),
    [sym_COUNT] = ACTIONS(1),
    [sym_CSP] = ACTIONS(1),
    [sym_CSP_ADD] = ACTIONS(1),
    [sym_CSP_MUL] = ACTIONS(1),
    [sym_CSP_LEQ] = ACTIONS(1),
    [sym_CSP_LT] = ACTIONS(1),
    [sym_CSP_GT] = ACTIONS(1),
    [sym_CSP_GEQ] = ACTIONS(1),
    [sym_CSP_EQ] = ACTIONS(1),
    [sym_CSP_NEQ] = ACTIONS(1),
    [sym_DISJOINT] = ACTIONS(1),
    [sym_DOT] = ACTIONS(1),
    [sym_DOTS] = ACTIONS(1),
    [sym_EXTERNAL] = ACTIONS(1),
    [sym_DEFINED] = ACTIONS(1),
    [sym_FALSE] = ACTIONS(1),
    [sym_GEQ] = ACTIONS(1),
    [sym_GT] = ACTIONS(1),
    [sym_IF] = ACTIONS(1),
    [sym_INCLUDE] = ACTIONS(1),
    [sym_INFIMUM] = ACTIONS(1),
    [sym_LBRACE] = ACTIONS(1),
    [sym_LBRACK] = ACTIONS(1),
    [sym_LEQ] = ACTIONS(1),
    [sym_LPAREN] = ACTIONS(1),
    [sym_LT] = ACTIONS(1),
    [sym_MAX] = ACTIONS(1),
    [sym_MAXIMIZE] = ACTIONS(1),
    [sym_MIN] = ACTIONS(1),
    [sym_MINIMIZE] = ACTIONS(1),
    [sym_MOD] = ACTIONS(1),
    [sym_MUL] = ACTIONS(1),
    [sym_NEQ] = ACTIONS(1),
    [sym_POW] = ACTIONS(1),
    [sym_QUESTION] = ACTIONS(1),
    [sym_RBRACE] = ACTIONS(1),
    [sym_RBRACK] = ACTIONS(1),
    [sym_RPAREN] = ACTIONS(1),
    [sym_SEM] = ACTIONS(1),
    [sym_SHOW] = ACTIONS(1),
    [sym_EDGE] = ACTIONS(1),
    [sym_PROJECT] = ACTIONS(1),
    [sym_HEURISTIC] = ACTIONS(1),
    [sym_SHOWSIG] = ACTIONS(1),
    [sym_SLASH] = ACTIONS(1),
    [sym_SUB] = ACTIONS(1),
    [sym_SUM] = ACTIONS(1),
    [sym_SUMP] = ACTIONS(1),
    [sym_SUPREMUM] = ACTIONS(1),
    [sym_TRUE] = ACTIONS(1),
    [sym_BLOCK] = ACTIONS(1),
    [sym_VBAR] = ACTIONS(1),
    [sym_XOR] = ACTIONS(1),
    [sym_ANY] = ACTIONS(1),
    [sym_UNARY] = ACTIONS(1),
    [sym_BINARY] = ACTIONS(1),
    [sym_LEFT] = ACTIONS(1),
    [sym_RIGHT] = ACTIONS(1),
    [sym_HEAD] = ACTIONS(1),
    [sym_BODY] = ACTIONS(1),
    [sym_DIRECTIVE] = ACTIONS(1),
    [sym_THEORY] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [aux_sym_dec_token1] = ACTIONS(1),
    [sym_hex] = ACTIONS(1),
    [sym_oct] = ACTIONS(1),
    [sym_bin] = ACTIONS(1),
    [sym_ANONYMOUS] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [sym_SCRIPT] = ACTIONS(1),
    [sym_VARIABLE] = ACTIONS(1),
    [sym_NOT] = ACTIONS(1),
    [sym_DEFAULT] = ACTIONS(1),
    [sym_OVERRIDE] = ACTIONS(1),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(667),
    [sym_NUMBER] = STATE(44),
    [sym_dec] = STATE(29),
    [sym__widentifier] = STATE(175),
    [sym_term] = STATE(59),
    [sym_atom] = STATE(374),
    [sym_literal] = STATE(368),
    [sym_csp_mul_term] = STATE(300),
    [sym_csp_add_term] = STATE(356),
    [sym_csp_literal] = STATE(320),
    [sym_aggregatefunction] = STATE(666),
    [sym_headaggregate] = STATE(74),
    [sym_luheadaggregate] = STATE(611),
    [sym_disjoint] = STATE(613),
    [sym_disjunctionsep] = STATE(83),
    [sym_disjunction] = STATE(611),
    [sym_head] = STATE(613),
    [sym_statement] = STATE(3),
    [sym_theory_atom] = STATE(619),
    [sym_STRING] = STATE(44),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(7),
    [sym_AT] = ACTIONS(9),
    [sym_BNOT] = ACTIONS(11),
    [sym_CONST] = ACTIONS(13),
    [sym_COUNT] = ACTIONS(15),
    [sym_CSP] = ACTIONS(17),
    [sym_DISJOINT] = ACTIONS(19),
    [sym_EXTERNAL] = ACTIONS(21),
    [sym_DEFINED] = ACTIONS(23),
    [sym_FALSE] = ACTIONS(25),
    [sym_IF] = ACTIONS(27),
    [sym_INCLUDE] = ACTIONS(29),
    [sym_INFIMUM] = ACTIONS(31),
    [sym_LBRACE] = ACTIONS(33),
    [sym_LPAREN] = ACTIONS(35),
    [sym_MAX] = ACTIONS(37),
    [sym_MAXIMIZE] = ACTIONS(39),
    [sym_MIN] = ACTIONS(37),
    [sym_MINIMIZE] = ACTIONS(41),
    [sym_SHOW] = ACTIONS(43),
    [sym_EDGE] = ACTIONS(45),
    [sym_PROJECT] = ACTIONS(47),
    [sym_HEURISTIC] = ACTIONS(49),
    [sym_SHOWSIG] = ACTIONS(51),
    [sym_SUB] = ACTIONS(53),
    [sym_SUM] = ACTIONS(37),
    [sym_SUMP] = ACTIONS(15),
    [sym_SUPREMUM] = ACTIONS(31),
    [sym_TRUE] = ACTIONS(25),
    [sym_BLOCK] = ACTIONS(55),
    [sym_VBAR] = ACTIONS(57),
    [sym_WIF] = ACTIONS(59),
    [sym_THEORY] = ACTIONS(61),
    [anon_sym_0] = ACTIONS(63),
    [aux_sym_dec_token1] = ACTIONS(65),
    [sym_hex] = ACTIONS(67),
    [sym_oct] = ACTIONS(67),
    [sym_bin] = ACTIONS(67),
    [sym_ANONYMOUS] = ACTIONS(69),
    [sym_identifier] = ACTIONS(71),
    [sym_SCRIPT] = ACTIONS(73),
    [sym_VARIABLE] = ACTIONS(31),
    [sym_NOT] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
  },
  [2] = {
    [sym_NUMBER] = STATE(44),
    [sym_dec] = STATE(29),
    [sym__widentifier] = STATE(175),
    [sym_term] = STATE(59),
    [sym_atom] = STATE(374),
    [sym_literal] = STATE(368),
    [sym_csp_mul_term] = STATE(300),
    [sym_csp_add_term] = STATE(356),
    [sym_csp_literal] = STATE(320),
    [sym_aggregatefunction] = STATE(666),
    [sym_headaggregate] = STATE(74),
    [sym_luheadaggregate] = STATE(611),
    [sym_disjoint] = STATE(613),
    [sym_disjunctionsep] = STATE(83),
    [sym_disjunction] = STATE(611),
    [sym_head] = STATE(613),
    [sym_statement] = STATE(2),
    [sym_theory_atom] = STATE(619),
    [sym_STRING] = STATE(44),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(81),
    [sym_AT] = ACTIONS(84),
    [sym_BNOT] = ACTIONS(87),
    [sym_CONST] = ACTIONS(90),
    [sym_COUNT] = ACTIONS(93),
    [sym_CSP] = ACTIONS(96),
    [sym_DISJOINT] = ACTIONS(99),
    [sym_EXTERNAL] = ACTIONS(102),
    [sym_DEFINED] = ACTIONS(105),
    [sym_FALSE] = ACTIONS(108),
    [sym_IF] = ACTIONS(111),
    [sym_INCLUDE] = ACTIONS(114),
    [sym_INFIMUM] = ACTIONS(117),
    [sym_LBRACE] = ACTIONS(120),
    [sym_LPAREN] = ACTIONS(123),
    [sym_MAX] = ACTIONS(126),
    [sym_MAXIMIZE] = ACTIONS(129),
    [sym_MIN] = ACTIONS(126),
    [sym_MINIMIZE] = ACTIONS(132),
    [sym_SHOW] = ACTIONS(135),
    [sym_EDGE] = ACTIONS(138),
    [sym_PROJECT] = ACTIONS(141),
    [sym_HEURISTIC] = ACTIONS(144),
    [sym_SHOWSIG] = ACTIONS(147),
    [sym_SUB] = ACTIONS(150),
    [sym_SUM] = ACTIONS(126),
    [sym_SUMP] = ACTIONS(93),
    [sym_SUPREMUM] = ACTIONS(117),
    [sym_TRUE] = ACTIONS(108),
    [sym_BLOCK] = ACTIONS(153),
    [sym_VBAR] = ACTIONS(156),
    [sym_WIF] = ACTIONS(159),
    [sym_THEORY] = ACTIONS(162),
    [anon_sym_0] = ACTIONS(165),
    [aux_sym_dec_token1] = ACTIONS(168),
    [sym_hex] = ACTIONS(171),
    [sym_oct] = ACTIONS(171),
    [sym_bin] = ACTIONS(171),
    [sym_ANONYMOUS] = ACTIONS(174),
    [sym_identifier] = ACTIONS(177),
    [sym_SCRIPT] = ACTIONS(180),
    [sym_VARIABLE] = ACTIONS(117),
    [sym_NOT] = ACTIONS(183),
    [anon_sym_DQUOTE] = ACTIONS(186),
  },
  [3] = {
    [sym_NUMBER] = STATE(44),
    [sym_dec] = STATE(29),
    [sym__widentifier] = STATE(175),
    [sym_term] = STATE(59),
    [sym_atom] = STATE(374),
    [sym_literal] = STATE(368),
    [sym_csp_mul_term] = STATE(300),
    [sym_csp_add_term] = STATE(356),
    [sym_csp_literal] = STATE(320),
    [sym_aggregatefunction] = STATE(666),
    [sym_headaggregate] = STATE(74),
    [sym_luheadaggregate] = STATE(611),
    [sym_disjoint] = STATE(613),
    [sym_disjunctionsep] = STATE(83),
    [sym_disjunction] = STATE(611),
    [sym_head] = STATE(613),
    [sym_statement] = STATE(2),
    [sym_theory_atom] = STATE(619),
    [sym_STRING] = STATE(44),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(7),
    [sym_AT] = ACTIONS(9),
    [sym_BNOT] = ACTIONS(11),
    [sym_CONST] = ACTIONS(13),
    [sym_COUNT] = ACTIONS(15),
    [sym_CSP] = ACTIONS(17),
    [sym_DISJOINT] = ACTIONS(19),
    [sym_EXTERNAL] = ACTIONS(21),
    [sym_DEFINED] = ACTIONS(23),
    [sym_FALSE] = ACTIONS(25),
    [sym_IF] = ACTIONS(27),
    [sym_INCLUDE] = ACTIONS(29),
    [sym_INFIMUM] = ACTIONS(31),
    [sym_LBRACE] = ACTIONS(33),
    [sym_LPAREN] = ACTIONS(35),
    [sym_MAX] = ACTIONS(37),
    [sym_MAXIMIZE] = ACTIONS(39),
    [sym_MIN] = ACTIONS(37),
    [sym_MINIMIZE] = ACTIONS(41),
    [sym_SHOW] = ACTIONS(43),
    [sym_EDGE] = ACTIONS(45),
    [sym_PROJECT] = ACTIONS(47),
    [sym_HEURISTIC] = ACTIONS(49),
    [sym_SHOWSIG] = ACTIONS(51),
    [sym_SUB] = ACTIONS(53),
    [sym_SUM] = ACTIONS(37),
    [sym_SUMP] = ACTIONS(15),
    [sym_SUPREMUM] = ACTIONS(31),
    [sym_TRUE] = ACTIONS(25),
    [sym_BLOCK] = ACTIONS(55),
    [sym_VBAR] = ACTIONS(57),
    [sym_WIF] = ACTIONS(59),
    [sym_THEORY] = ACTIONS(61),
    [anon_sym_0] = ACTIONS(63),
    [aux_sym_dec_token1] = ACTIONS(65),
    [sym_hex] = ACTIONS(67),
    [sym_oct] = ACTIONS(67),
    [sym_bin] = ACTIONS(67),
    [sym_ANONYMOUS] = ACTIONS(69),
    [sym_identifier] = ACTIONS(71),
    [sym_SCRIPT] = ACTIONS(73),
    [sym_VARIABLE] = ACTIONS(31),
    [sym_NOT] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(193), 1,
      sym_DOT,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    STATE(14), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(29), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(70), 1,
      sym_bodyaggregate,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(462), 1,
      sym_literal,
    STATE(523), 1,
      sym_theory_atom,
    STATE(529), 1,
      sym_lubodyaggregate,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(644), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [125] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    ACTIONS(205), 1,
      sym_DOT,
    STATE(22), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(29), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(70), 1,
      sym_bodyaggregate,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(462), 1,
      sym_literal,
    STATE(523), 1,
      sym_theory_atom,
    STATE(529), 1,
      sym_lubodyaggregate,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(644), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [250] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    ACTIONS(207), 1,
      sym_DOT,
    STATE(15), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(29), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(70), 1,
      sym_bodyaggregate,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(462), 1,
      sym_literal,
    STATE(523), 1,
      sym_theory_atom,
    STATE(529), 1,
      sym_lubodyaggregate,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(644), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [375] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    ACTIONS(209), 1,
      sym_DOT,
    STATE(24), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(29), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(70), 1,
      sym_bodyaggregate,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(462), 1,
      sym_literal,
    STATE(523), 1,
      sym_theory_atom,
    STATE(529), 1,
      sym_lubodyaggregate,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(644), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [500] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 1,
      sym_LBRACK,
    ACTIONS(215), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(211), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [556] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    STATE(26), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(29), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(70), 1,
      sym_bodyaggregate,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(462), 1,
      sym_literal,
    STATE(523), 1,
      sym_theory_atom,
    STATE(529), 1,
      sym_lubodyaggregate,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(644), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [678] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(29), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(70), 1,
      sym_bodyaggregate,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(462), 1,
      sym_literal,
    STATE(523), 1,
      sym_theory_atom,
    STATE(529), 1,
      sym_lubodyaggregate,
    STATE(664), 1,
      sym_bodydot,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(644), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [800] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(217), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [854] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(223), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(221), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [908] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(225), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [962] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(229), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1016] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(235), 1,
      sym_LBRACK,
    ACTIONS(237), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(233), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1072] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(239), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1126] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(245), 1,
      sym_LBRACK,
    ACTIONS(247), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(243), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1182] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    STATE(23), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(29), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(70), 1,
      sym_bodyaggregate,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(462), 1,
      sym_literal,
    STATE(523), 1,
      sym_theory_atom,
    STATE(529), 1,
      sym_lubodyaggregate,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(644), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [1304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(249), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1358] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(253), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1411] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(259), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(257), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(247), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(243), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1517] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(211), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1570] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(263), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(261), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1623] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(267), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(265), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1676] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(237), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(233), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1729] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(271), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(269), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1782] = 35,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(273), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(70), 1,
      sym_bodyaggregate,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(480), 1,
      sym_literal,
    STATE(523), 1,
      sym_theory_atom,
    STATE(528), 1,
      sym_lubodyaggregate,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(571), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [1898] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(275), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [1948] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(279), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [1998] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(285), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(283), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2050] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(289), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2102] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(295), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(293), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2152] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(299), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(297), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2202] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(289), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2251] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(303), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 32,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2302] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(309), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(307), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2351] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(291), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_SUM,
    ACTIONS(289), 24,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SUMP,
      sym_VBAR,
      anon_sym_EQ_EQ,
  [2416] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2465] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2514] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(303), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 27,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2573] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(303), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_SUM,
    ACTIONS(301), 24,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SUMP,
      sym_VBAR,
      anon_sym_EQ_EQ,
  [2638] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(303), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 30,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2693] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(283), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2742] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(303), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 31,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2795] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(303), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 29,
      sym_ADD,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2852] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(325), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(327), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(285), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(283), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2906] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(329), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(331), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(285), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(283), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2960] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(335), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(303), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3011] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(339), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(303), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3062] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(329), 1,
      sym_DOT,
    ACTIONS(331), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(285), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(283), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3114] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(325), 1,
      sym_DOT,
    ACTIONS(327), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(285), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(283), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3166] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(341), 1,
      sym_DISJOINT,
    ACTIONS(345), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(70), 1,
      sym_bodyaggregate,
    STATE(104), 1,
      sym_term,
    STATE(153), 1,
      sym__widentifier,
    STATE(429), 1,
      sym_atom,
    STATE(519), 1,
      sym_lubodyaggregate,
    STATE(523), 1,
      sym_theory_atom,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(343), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3263] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 1,
      sym_DOT,
    ACTIONS(335), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(303), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3312] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 1,
      sym_DOT,
    ACTIONS(339), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(303), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3361] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(341), 1,
      sym_DISJOINT,
    ACTIONS(347), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(70), 1,
      sym_bodyaggregate,
    STATE(104), 1,
      sym_term,
    STATE(153), 1,
      sym__widentifier,
    STATE(429), 1,
      sym_atom,
    STATE(523), 1,
      sym_theory_atom,
    STATE(528), 1,
      sym_lubodyaggregate,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(343), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3458] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(349), 1,
      sym_DISJOINT,
    ACTIONS(353), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(70), 1,
      sym_bodyaggregate,
    STATE(106), 1,
      sym_term,
    STATE(153), 1,
      sym__widentifier,
    STATE(432), 1,
      sym_atom,
    STATE(505), 1,
      sym_lubodyaggregate,
    STATE(523), 1,
      sym_theory_atom,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(351), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3552] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(349), 1,
      sym_DISJOINT,
    ACTIONS(353), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(70), 1,
      sym_bodyaggregate,
    STATE(106), 1,
      sym_term,
    STATE(153), 1,
      sym__widentifier,
    STATE(432), 1,
      sym_atom,
    STATE(519), 1,
      sym_lubodyaggregate,
    STATE(523), 1,
      sym_theory_atom,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(351), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3646] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      sym_LBRACE,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    STATE(76), 1,
      sym_headaggregate,
    STATE(86), 1,
      sym_cmp,
    STATE(666), 1,
      sym_aggregatefunction,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(357), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [3723] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(87), 1,
      sym_cmp,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(357), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [3800] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(367), 1,
      sym_SEM,
    ACTIONS(369), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(175), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(320), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(403), 1,
      sym_literal,
    STATE(404), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(365), 2,
      sym_DOT,
      sym_IF,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [3892] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(369), 1,
      sym_NOT,
    ACTIONS(373), 1,
      sym_SEM,
    STATE(29), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(175), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(320), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(403), 1,
      sym_literal,
    STATE(411), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(371), 2,
      sym_DOT,
      sym_IF,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [3984] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(175), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(344), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(403), 1,
      sym_literal,
    STATE(517), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(375), 2,
      sym_DOT,
      sym_SEM,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4073] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(240), 1,
      sym_cmp,
    STATE(324), 1,
      sym_term,
    STATE(511), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(379), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [4150] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(175), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(344), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(403), 1,
      sym_literal,
    STATE(507), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(383), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4239] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(175), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(344), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(403), 1,
      sym_literal,
    STATE(514), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(385), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4328] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(175), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(344), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(403), 1,
      sym_literal,
    STATE(533), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(371), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4417] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(387), 1,
      sym_RBRACE,
    ACTIONS(389), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(492), 1,
      sym_literal,
    STATE(575), 1,
      sym_altbodyaggrelemvec,
    STATE(576), 1,
      sym_altbodyaggrelem,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4508] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(240), 1,
      sym_cmp,
    STATE(324), 1,
      sym_term,
    STATE(518), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(391), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [4585] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(240), 1,
      sym_cmp,
    STATE(324), 1,
      sym_term,
    STATE(506), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(393), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [4662] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(175), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(344), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(520), 1,
      sym_literal,
    STATE(532), 1,
      sym_optimizelitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(395), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4751] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(389), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(492), 1,
      sym_literal,
    STATE(624), 1,
      sym_altbodyaggrelem,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(397), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4840] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(389), 1,
      sym_NOT,
    ACTIONS(399), 1,
      sym_RBRACE,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(469), 1,
      sym_literal,
    STATE(634), 1,
      sym_altheadaggrelemvec,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4928] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(120), 1,
      sym_dec,
    STATE(188), 1,
      sym__widentifier,
    STATE(239), 1,
      sym_cmp,
    STATE(334), 1,
      sym_term,
    STATE(574), 1,
      sym_nupper,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(405), 2,
      sym_DOT,
      sym_IF,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [5004] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(120), 1,
      sym_dec,
    STATE(188), 1,
      sym__widentifier,
    STATE(239), 1,
      sym_cmp,
    STATE(334), 1,
      sym_term,
    STATE(572), 1,
      sym_nupper,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(425), 2,
      sym_DOT,
      sym_IF,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [5080] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(120), 1,
      sym_dec,
    STATE(188), 1,
      sym__widentifier,
    STATE(239), 1,
      sym_cmp,
    STATE(334), 1,
      sym_term,
    STATE(555), 1,
      sym_nupper,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(427), 2,
      sym_DOT,
      sym_IF,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [5156] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(389), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(479), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5238] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(389), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(476), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5320] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(175), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(344), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(407), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5402] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(389), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(468), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5484] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(389), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(457), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5566] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(389), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(153), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(331), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(434), 1,
      sym_atom,
    STATE(467), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5648] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(369), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(175), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(320), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(358), 1,
      sym_literal,
    STATE(374), 1,
      sym_atom,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5730] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(369), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(97), 1,
      sym_term,
    STATE(175), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(320), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(407), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5812] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(99), 1,
      sym_term,
    STATE(175), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(344), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(509), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5894] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      sym_LBRACE,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(75), 1,
      sym_headaggregate,
    STATE(120), 1,
      sym_dec,
    STATE(188), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(666), 1,
      sym_aggregatefunction,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [5967] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(192), 1,
      sym__widentifier,
    STATE(306), 1,
      sym_term,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [6040] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(192), 1,
      sym__widentifier,
    STATE(305), 1,
      sym_term,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [6113] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(192), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_term,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [6186] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(429), 1,
      sym_COMMA,
    ACTIONS(431), 1,
      sym_RPAREN,
    ACTIONS(433), 1,
      sym_SEM,
    STATE(29), 1,
      sym_dec,
    STATE(118), 1,
      sym_tuplevec_sem,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(516), 1,
      sym_ntermvec,
    STATE(630), 1,
      sym_ntuple,
    STATE(658), 1,
      sym_ntuplevec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6262] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(435), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [6298] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(439), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [6334] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(429), 1,
      sym_COMMA,
    ACTIONS(433), 1,
      sym_SEM,
    ACTIONS(443), 1,
      sym_RPAREN,
    STATE(29), 1,
      sym_dec,
    STATE(118), 1,
      sym_tuplevec_sem,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(516), 1,
      sym_ntermvec,
    STATE(630), 1,
      sym_ntuple,
    STATE(656), 1,
      sym_ntuplevec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6410] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(445), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [6446] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(449), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [6482] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      sym_COLON,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(463), 1,
      sym_RBRACE,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(362), 1,
      sym_theory_opterm,
    STATE(397), 1,
      sym_dec,
    STATE(421), 1,
      sym_theory_term,
    STATE(430), 1,
      sym_theory_opterm_nlist,
    STATE(551), 1,
      sym_theory_atom_element,
    STATE(645), 1,
      sym_theory_atom_element_nlist,
    ACTIONS(473), 2,
      sym_THEORY_OP,
      sym_NOT,
    STATE(406), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6555] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    STATE(215), 1,
      sym_cmp,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(357), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [6614] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      sym_COLON,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    ACTIONS(477), 1,
      sym_RBRACE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(362), 1,
      sym_theory_opterm,
    STATE(397), 1,
      sym_dec,
    STATE(421), 1,
      sym_theory_term,
    STATE(430), 1,
      sym_theory_opterm_nlist,
    STATE(551), 1,
      sym_theory_atom_element,
    STATE(632), 1,
      sym_theory_atom_element_nlist,
    ACTIONS(473), 2,
      sym_THEORY_OP,
      sym_NOT,
    STATE(406), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6687] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    STATE(221), 1,
      sym_cmp,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(357), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [6746] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(479), 1,
      sym_COLON,
    ACTIONS(481), 1,
      sym_RBRACE,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(433), 1,
      sym_ntermvec,
    STATE(545), 1,
      sym_bodyaggrelemvec,
    STATE(546), 1,
      sym_bodyaggrelem,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6816] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(285), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(283), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [6852] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(485), 21,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [6886] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(487), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(489), 21,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [6920] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(89), 1,
      sym_cmp,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [6982] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(289), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7018] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    STATE(69), 1,
      sym_bodyaggregate,
    STATE(88), 1,
      sym_cmp,
    STATE(700), 1,
      sym_aggregatefunction,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [7080] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(491), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(493), 21,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [7114] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(341), 1,
      sym_DISJOINT,
    ACTIONS(497), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(175), 1,
      sym__widentifier,
    STATE(284), 1,
      sym_term,
    STATE(373), 1,
      sym_atom,
    ACTIONS(495), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(299), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(297), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7217] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7250] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(303), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 19,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7285] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(503), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_MUL,
    ACTIONS(507), 1,
      sym_POW,
    ACTIONS(509), 1,
      sym_QUESTION,
    ACTIONS(513), 1,
      sym_XOR,
    ACTIONS(501), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(511), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(303), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(301), 11,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [7334] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      sym_COLON,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(362), 1,
      sym_theory_opterm,
    STATE(397), 1,
      sym_dec,
    STATE(421), 1,
      sym_theory_term,
    STATE(430), 1,
      sym_theory_opterm_nlist,
    STATE(567), 1,
      sym_theory_atom_element,
    ACTIONS(473), 2,
      sym_THEORY_OP,
      sym_NOT,
    STATE(406), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7401] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(349), 1,
      sym_DISJOINT,
    ACTIONS(517), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(175), 1,
      sym__widentifier,
    STATE(283), 1,
      sym_term,
    STATE(371), 1,
      sym_atom,
    ACTIONS(515), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7468] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(503), 1,
      sym_AND,
    ACTIONS(509), 1,
      sym_QUESTION,
    ACTIONS(513), 1,
      sym_XOR,
    ACTIONS(501), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(303), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 14,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [7511] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(289), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7544] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(519), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(175), 1,
      sym__widentifier,
    STATE(284), 1,
      sym_term,
    STATE(373), 1,
      sym_atom,
    ACTIONS(495), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7611] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(429), 1,
      sym_COMMA,
    ACTIONS(521), 1,
      sym_SEM,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(516), 1,
      sym_ntermvec,
    STATE(568), 1,
      sym_ntuple,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7678] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(523), 1,
      sym_COLON,
    ACTIONS(525), 1,
      sym_RBRACE,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(536), 1,
      sym_ncspelemvec,
    STATE(582), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7745] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(275), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7778] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(503), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_MUL,
    ACTIONS(507), 1,
      sym_POW,
    ACTIONS(509), 1,
      sym_QUESTION,
    ACTIONS(513), 1,
      sym_XOR,
    ACTIONS(527), 1,
      sym_CSP_MUL,
    ACTIONS(501), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(511), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(357), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [7829] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(529), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(153), 1,
      sym__widentifier,
    STATE(287), 1,
      sym_term,
    STATE(429), 1,
      sym_atom,
    ACTIONS(343), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7896] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(533), 20,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [7929] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(523), 1,
      sym_COLON,
    ACTIONS(535), 1,
      sym_RBRACE,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(581), 1,
      sym_ncspelemvec,
    STATE(582), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7996] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(503), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_MUL,
    ACTIONS(507), 1,
      sym_POW,
    ACTIONS(509), 1,
      sym_QUESTION,
    ACTIONS(513), 1,
      sym_XOR,
    ACTIONS(501), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(511), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(291), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(289), 11,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [8045] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(295), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(293), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8078] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(279), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8111] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(503), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_MUL,
    ACTIONS(507), 1,
      sym_POW,
    ACTIONS(509), 1,
      sym_QUESTION,
    ACTIONS(513), 1,
      sym_XOR,
    ACTIONS(541), 1,
      sym_CSP_MUL,
    ACTIONS(501), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(511), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(537), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(539), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [8162] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_NOT,
    STATE(29), 1,
      sym_dec,
    STATE(175), 1,
      sym__widentifier,
    STATE(287), 1,
      sym_term,
    STATE(373), 1,
      sym_atom,
    ACTIONS(495), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8229] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(513), 1,
      sym_XOR,
    ACTIONS(303), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 18,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [8266] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(547), 20,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [8299] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(551), 20,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [8332] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8365] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(553), 1,
      sym_COLON,
    ACTIONS(555), 1,
      sym_RBRACE,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(553), 1,
      sym_headaggrelemvec,
    STATE(554), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8432] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(523), 1,
      sym_COLON,
    ACTIONS(557), 1,
      sym_RBRACE,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(538), 1,
      sym_ncspelemvec,
    STATE(582), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8499] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(509), 1,
      sym_QUESTION,
    ACTIONS(513), 1,
      sym_XOR,
    ACTIONS(303), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 17,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [8538] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(283), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8571] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(503), 1,
      sym_AND,
    ACTIONS(509), 1,
      sym_QUESTION,
    ACTIONS(513), 1,
      sym_XOR,
    ACTIONS(303), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 16,
      sym_ADD,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [8612] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(309), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(307), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8645] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(567), 1,
      sym_RBRACE,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(638), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8711] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(353), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(153), 1,
      sym__widentifier,
    STATE(282), 1,
      sym_term,
    STATE(432), 1,
      sym_atom,
    ACTIONS(351), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8775] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(567), 1,
      sym_RBRACK,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(637), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8841] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      sym_CSP,
    STATE(120), 1,
      sym_dec,
    STATE(121), 1,
      sym_term,
    STATE(188), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(309), 1,
      sym_csp_add_term,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8905] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      sym_RPAREN,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(627), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8971] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(479), 1,
      sym_COLON,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(433), 1,
      sym_ntermvec,
    STATE(591), 1,
      sym_bodyaggrelem,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9035] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(517), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(175), 1,
      sym__widentifier,
    STATE(283), 1,
      sym_term,
    STATE(371), 1,
      sym_atom,
    ACTIONS(515), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9099] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(585), 1,
      sym_RPAREN,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(503), 1,
      sym_ntermvec,
    STATE(586), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9163] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(587), 1,
      sym_CSP,
    STATE(29), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    STATE(321), 1,
      sym_csp_mul_term,
    STATE(389), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9227] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(589), 1,
      sym_RPAREN,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(503), 1,
      sym_ntermvec,
    STATE(648), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9291] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(587), 1,
      sym_CSP,
    STATE(29), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    STATE(321), 1,
      sym_csp_mul_term,
    STATE(416), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9355] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_RBRACK,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(601), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9421] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_RBRACE,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(597), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9487] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(593), 1,
      sym_RPAREN,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(503), 1,
      sym_ntermvec,
    STATE(642), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9551] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(595), 1,
      sym_CSP_MUL,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(537), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(539), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [9601] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(589), 1,
      sym_RPAREN,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(503), 1,
      sym_ntermvec,
    STATE(549), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9665] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(597), 1,
      sym_RPAREN,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(556), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9731] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(599), 1,
      sym_RPAREN,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(557), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9797] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(601), 1,
      sym_RPAREN,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(616), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9863] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_csp_mul_term,
    STATE(336), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9927] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(603), 1,
      sym_RBRACK,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(562), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9993] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(603), 1,
      sym_RBRACE,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(566), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10059] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(357), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [10109] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(587), 1,
      sym_CSP,
    STATE(29), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    STATE(321), 1,
      sym_csp_mul_term,
    STATE(327), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10173] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(605), 1,
      sym_RPAREN,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(578), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10239] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(607), 1,
      sym_RPAREN,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(558), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10305] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(593), 1,
      sym_RPAREN,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(503), 1,
      sym_ntermvec,
    STATE(579), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10369] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(609), 1,
      sym_RPAREN,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(580), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10435] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(611), 1,
      sym_RBRACE,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(292), 1,
      sym_term,
    STATE(392), 1,
      sym_optimizeweight,
    STATE(565), 1,
      sym_maxelemlist,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10499] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(613), 1,
      sym_RBRACK,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(595), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10565] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(587), 1,
      sym_CSP,
    STATE(29), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    STATE(321), 1,
      sym_csp_mul_term,
    STATE(408), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10629] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(613), 1,
      sym_RBRACE,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(598), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10695] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(615), 1,
      sym_RPAREN,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(503), 1,
      sym_ntermvec,
    STATE(560), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10759] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(617), 1,
      sym_RPAREN,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(635), 1,
      sym_theory_opterm_nlist,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10825] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(517), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(175), 1,
      sym__widentifier,
    STATE(282), 1,
      sym_term,
    STATE(371), 1,
      sym_atom,
    ACTIONS(515), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10889] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(619), 1,
      sym_RPAREN,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(503), 1,
      sym_ntermvec,
    STATE(590), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10953] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(503), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_MUL,
    ACTIONS(507), 1,
      sym_POW,
    ACTIONS(509), 1,
      sym_QUESTION,
    ACTIONS(513), 1,
      sym_XOR,
    ACTIONS(501), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(511), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(621), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(623), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [11001] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(611), 1,
      sym_RBRACE,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(292), 1,
      sym_term,
    STATE(396), 1,
      sym_optimizeweight,
    STATE(534), 1,
      sym_minelemlist,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11065] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(587), 1,
      sym_CSP,
    STATE(29), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    STATE(321), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11129] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(613), 1,
      sym_RPAREN,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(387), 1,
      sym_theory_term,
    STATE(420), 1,
      sym_theory_opterm,
    STATE(424), 1,
      sym_dec,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11192] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_DOT,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(625), 1,
      sym_CSP,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(330), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11253] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(603), 1,
      sym_RPAREN,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(387), 1,
      sym_theory_term,
    STATE(405), 1,
      sym_theory_opterm,
    STATE(424), 1,
      sym_dec,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11316] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    ACTIONS(581), 1,
      sym_CSP,
    STATE(120), 1,
      sym_dec,
    STATE(121), 1,
      sym_term,
    STATE(188), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11377] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(627), 1,
      sym_COLON,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(548), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11438] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(629), 1,
      sym_COLON,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(617), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11499] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_RPAREN,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(384), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11562] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(293), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(631), 2,
      sym_RPAREN,
      sym_SEM,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11621] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(621), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(623), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [11668] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(503), 1,
      sym_ntermvec,
    STATE(647), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11729] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    ACTIONS(587), 1,
      sym_CSP,
    STATE(29), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    STATE(323), 1,
      sym_csp_mul_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11790] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(162), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11851] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(503), 1,
      sym_ntermvec,
    STATE(585), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11912] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(503), 1,
      sym_ntermvec,
    STATE(584), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11973] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(595), 1,
      sym_CSP_MUL,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(537), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(539), 9,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [12022] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(503), 1,
      sym_ntermvec,
    STATE(646), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12083] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(567), 1,
      sym_RPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(387), 1,
      sym_theory_term,
    STATE(391), 1,
      sym_theory_opterm,
    STATE(424), 1,
      sym_dec,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12146] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(633), 1,
      sym_AT,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(641), 1,
      sym_RPAREN,
    ACTIONS(643), 1,
      sym_VBAR,
    ACTIONS(645), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(198), 1,
      sym__widentifier,
    STATE(340), 1,
      sym_constterm,
    STATE(610), 1,
      sym_consttermvec,
    STATE(683), 1,
      sym_nconstargvec,
    ACTIONS(635), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(637), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(317), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12206] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(649), 1,
      sym_LBRACE,
    ACTIONS(651), 1,
      sym_LBRACK,
    ACTIONS(653), 1,
      sym_LPAREN,
    ACTIONS(655), 1,
      anon_sym_0,
    ACTIONS(657), 1,
      aux_sym_dec_token1,
    ACTIONS(661), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_DQUOTE,
    STATE(258), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(367), 1,
      sym_theory_opterm,
    STATE(442), 1,
      sym_theory_term,
    STATE(450), 1,
      sym_dec,
    STATE(441), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(647), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(659), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12266] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(633), 1,
      sym_AT,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      sym_VBAR,
    ACTIONS(645), 1,
      sym_identifier,
    ACTIONS(665), 1,
      sym_RPAREN,
    STATE(29), 1,
      sym_dec,
    STATE(198), 1,
      sym__widentifier,
    STATE(340), 1,
      sym_constterm,
    STATE(610), 1,
      sym_consttermvec,
    STATE(665), 1,
      sym_nconstargvec,
    ACTIONS(635), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(637), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(317), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12326] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(361), 1,
      sym_theory_opterm,
    STATE(387), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12386] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(337), 1,
      sym_term,
    STATE(639), 1,
      sym_unaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12444] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(669), 3,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(667), 19,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [12474] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(292), 1,
      sym_term,
    STATE(395), 1,
      sym_optimizeweight,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12532] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(673), 1,
      sym_LBRACE,
    ACTIONS(675), 1,
      sym_LBRACK,
    ACTIONS(677), 1,
      sym_LPAREN,
    ACTIONS(679), 1,
      anon_sym_0,
    ACTIONS(681), 1,
      aux_sym_dec_token1,
    ACTIONS(685), 1,
      sym_identifier,
    ACTIONS(687), 1,
      anon_sym_DQUOTE,
    STATE(259), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(415), 1,
      sym_theory_opterm,
    STATE(484), 1,
      sym_dec,
    STATE(493), 1,
      sym_theory_term,
    STATE(496), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(671), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(683), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12592] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(649), 1,
      sym_LBRACE,
    ACTIONS(651), 1,
      sym_LBRACK,
    ACTIONS(653), 1,
      sym_LPAREN,
    ACTIONS(655), 1,
      anon_sym_0,
    ACTIONS(657), 1,
      aux_sym_dec_token1,
    ACTIONS(661), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_DQUOTE,
    STATE(258), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(375), 1,
      sym_theory_opterm,
    STATE(442), 1,
      sym_theory_term,
    STATE(450), 1,
      sym_dec,
    STATE(441), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(647), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(659), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12652] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(360), 1,
      sym_theory_opterm,
    STATE(397), 1,
      sym_dec,
    STATE(421), 1,
      sym_theory_term,
    STATE(406), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12712] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(673), 1,
      sym_LBRACE,
    ACTIONS(675), 1,
      sym_LBRACK,
    ACTIONS(677), 1,
      sym_LPAREN,
    ACTIONS(679), 1,
      anon_sym_0,
    ACTIONS(681), 1,
      aux_sym_dec_token1,
    ACTIONS(685), 1,
      sym_identifier,
    ACTIONS(687), 1,
      anon_sym_DQUOTE,
    STATE(259), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(383), 1,
      sym_theory_opterm,
    STATE(484), 1,
      sym_dec,
    STATE(493), 1,
      sym_theory_term,
    STATE(496), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(671), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(683), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12772] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(347), 1,
      sym_term,
    STATE(563), 1,
      sym_binaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12830] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(292), 1,
      sym_term,
    STATE(522), 1,
      sym_optimizeweight,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12888] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(292), 1,
      sym_term,
    STATE(393), 1,
      sym_optimizeweight,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12946] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(515), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13004] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(337), 1,
      sym_term,
    STATE(622), 1,
      sym_unaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13062] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(447), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13120] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13175] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(111), 1,
      sym_term,
    STATE(120), 1,
      sym_dec,
    STATE(188), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13230] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(120), 1,
      sym_dec,
    STATE(188), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13285] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(302), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13340] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(343), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13395] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(689), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(38), 1,
      sym_term,
    STATE(149), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13450] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(120), 1,
      sym_dec,
    STATE(188), 1,
      sym__widentifier,
    STATE(295), 1,
      sym_term,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13505] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(120), 1,
      sym_dec,
    STATE(128), 1,
      sym_term,
    STATE(188), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13560] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(306), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13615] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(293), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13670] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(332), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13725] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(154), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13780] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(120), 1,
      sym_dec,
    STATE(125), 1,
      sym_term,
    STATE(188), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13835] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(691), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(38), 1,
      sym_term,
    STATE(172), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13890] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(110), 1,
      sym_term,
    STATE(120), 1,
      sym_dec,
    STATE(188), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13945] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(120), 1,
      sym_dec,
    STATE(188), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14000] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(115), 1,
      sym_term,
    STATE(120), 1,
      sym_dec,
    STATE(188), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14055] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(342), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14110] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(305), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14165] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(120), 1,
      sym_dec,
    STATE(138), 1,
      sym_term,
    STATE(188), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14220] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(120), 1,
      sym_dec,
    STATE(136), 1,
      sym_term,
    STATE(188), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14275] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(46), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14330] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(341), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14385] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(333), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14440] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(43), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14495] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(335), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14550] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(120), 1,
      sym_dec,
    STATE(188), 1,
      sym__widentifier,
    STATE(328), 1,
      sym_term,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14605] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(318), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14660] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(338), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14715] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(193), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14770] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(40), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14825] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(345), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14880] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(120), 1,
      sym_dec,
    STATE(130), 1,
      sym_term,
    STATE(188), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14935] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(346), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14990] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(41), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15045] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(329), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15100] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(120), 1,
      sym_dec,
    STATE(176), 1,
      sym_term,
    STATE(188), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15155] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(187), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15210] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(42), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15265] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym_AT,
    ACTIONS(409), 1,
      sym_LPAREN,
    ACTIONS(411), 1,
      sym_VBAR,
    ACTIONS(413), 1,
      anon_sym_0,
    ACTIONS(415), 1,
      aux_sym_dec_token1,
    ACTIONS(419), 1,
      sym_ANONYMOUS,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    STATE(112), 1,
      sym_term,
    STATE(120), 1,
      sym_dec,
    STATE(188), 1,
      sym__widentifier,
    ACTIONS(403), 2,
      sym_BNOT,
      sym_SUB,
    STATE(137), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(407), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(417), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15320] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(38), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15375] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(45), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15430] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(633), 1,
      sym_AT,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      sym_VBAR,
    ACTIONS(645), 1,
      sym_identifier,
    ACTIONS(665), 1,
      sym_RPAREN,
    STATE(29), 1,
      sym_dec,
    STATE(198), 1,
      sym__widentifier,
    STATE(340), 1,
      sym_constterm,
    STATE(606), 1,
      sym_consttermvec,
    ACTIONS(635), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(637), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(317), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15487] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(192), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15542] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(36), 1,
      sym_term,
    STATE(192), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15597] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(649), 1,
      sym_LBRACE,
    ACTIONS(651), 1,
      sym_LBRACK,
    ACTIONS(653), 1,
      sym_LPAREN,
    ACTIONS(655), 1,
      anon_sym_0,
    ACTIONS(657), 1,
      aux_sym_dec_token1,
    ACTIONS(661), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_DQUOTE,
    STATE(301), 1,
      sym_theory_op,
    STATE(445), 1,
      sym_theory_term,
    STATE(450), 1,
      sym_dec,
    STATE(441), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(647), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(659), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15651] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(673), 1,
      sym_LBRACE,
    ACTIONS(675), 1,
      sym_LBRACK,
    ACTIONS(677), 1,
      sym_LPAREN,
    ACTIONS(679), 1,
      anon_sym_0,
    ACTIONS(681), 1,
      aux_sym_dec_token1,
    ACTIONS(685), 1,
      sym_identifier,
    ACTIONS(687), 1,
      anon_sym_DQUOTE,
    STATE(301), 1,
      sym_theory_op,
    STATE(484), 1,
      sym_dec,
    STATE(490), 1,
      sym_theory_term,
    STATE(496), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(671), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(683), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15705] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    STATE(301), 1,
      sym_theory_op,
    STATE(382), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15759] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(633), 1,
      sym_AT,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      sym_VBAR,
    ACTIONS(645), 1,
      sym_identifier,
    ACTIONS(693), 1,
      sym_RPAREN,
    STATE(29), 1,
      sym_dec,
    STATE(198), 1,
      sym__widentifier,
    STATE(339), 1,
      sym_constterm,
    ACTIONS(635), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(637), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(317), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15813] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    STATE(301), 1,
      sym_theory_op,
    STATE(397), 1,
      sym_dec,
    STATE(419), 1,
      sym_theory_term,
    STATE(406), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15867] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    STATE(301), 1,
      sym_theory_op,
    STATE(397), 1,
      sym_dec,
    STATE(417), 1,
      sym_theory_term,
    STATE(406), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15921] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    STATE(301), 1,
      sym_theory_op,
    STATE(400), 1,
      sym_theory_term,
    STATE(424), 1,
      sym_dec,
    STATE(398), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15975] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(649), 1,
      sym_LBRACE,
    ACTIONS(651), 1,
      sym_LBRACK,
    ACTIONS(653), 1,
      sym_LPAREN,
    ACTIONS(655), 1,
      anon_sym_0,
    ACTIONS(657), 1,
      aux_sym_dec_token1,
    ACTIONS(661), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_DQUOTE,
    STATE(301), 1,
      sym_theory_op,
    STATE(443), 1,
      sym_theory_term,
    STATE(450), 1,
      sym_dec,
    STATE(441), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(647), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(659), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16029] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(695), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16057] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(701), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(699), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16085] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(703), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16113] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(709), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(707), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16141] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(673), 1,
      sym_LBRACE,
    ACTIONS(675), 1,
      sym_LBRACK,
    ACTIONS(677), 1,
      sym_LPAREN,
    ACTIONS(679), 1,
      anon_sym_0,
    ACTIONS(681), 1,
      aux_sym_dec_token1,
    ACTIONS(685), 1,
      sym_identifier,
    ACTIONS(687), 1,
      anon_sym_DQUOTE,
    STATE(301), 1,
      sym_theory_op,
    STATE(484), 1,
      sym_dec,
    STATE(488), 1,
      sym_theory_term,
    STATE(496), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(671), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(683), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16195] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(713), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(711), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16223] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(633), 1,
      sym_AT,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      sym_VBAR,
    ACTIONS(645), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(198), 1,
      sym__widentifier,
    STATE(316), 1,
      sym_constterm,
    ACTIONS(635), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(637), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(317), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16274] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(633), 1,
      sym_AT,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      sym_VBAR,
    ACTIONS(645), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(198), 1,
      sym__widentifier,
    STATE(314), 1,
      sym_constterm,
    ACTIONS(635), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(637), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(317), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16325] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(633), 1,
      sym_AT,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      sym_VBAR,
    ACTIONS(645), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(198), 1,
      sym__widentifier,
    STATE(322), 1,
      sym_constterm,
    ACTIONS(635), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(637), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(317), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16376] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(633), 1,
      sym_AT,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      sym_VBAR,
    ACTIONS(645), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(198), 1,
      sym__widentifier,
    STATE(315), 1,
      sym_constterm,
    ACTIONS(635), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(637), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(317), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16427] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(633), 1,
      sym_AT,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      sym_VBAR,
    ACTIONS(645), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(198), 1,
      sym__widentifier,
    STATE(319), 1,
      sym_constterm,
    ACTIONS(635), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(637), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(317), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16478] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(633), 1,
      sym_AT,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      sym_VBAR,
    ACTIONS(645), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(198), 1,
      sym__widentifier,
    STATE(325), 1,
      sym_constterm,
    ACTIONS(635), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(637), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(317), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16529] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(633), 1,
      sym_AT,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      sym_VBAR,
    ACTIONS(645), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(198), 1,
      sym__widentifier,
    STATE(339), 1,
      sym_constterm,
    ACTIONS(635), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(637), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(317), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16580] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(633), 1,
      sym_AT,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      sym_VBAR,
    ACTIONS(645), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(198), 1,
      sym__widentifier,
    STATE(351), 1,
      sym_constterm,
    ACTIONS(635), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(637), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(317), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16631] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(633), 1,
      sym_AT,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      sym_VBAR,
    ACTIONS(645), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(198), 1,
      sym__widentifier,
    STATE(350), 1,
      sym_constterm,
    ACTIONS(635), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(637), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(317), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16682] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(633), 1,
      sym_AT,
    ACTIONS(639), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      sym_VBAR,
    ACTIONS(645), 1,
      sym_identifier,
    STATE(29), 1,
      sym_dec,
    STATE(198), 1,
      sym__widentifier,
    STATE(312), 1,
      sym_constterm,
    ACTIONS(635), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(637), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(317), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16733] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    STATE(231), 1,
      sym_cmp,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [16777] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    STATE(228), 1,
      sym_cmp,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [16821] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    STATE(219), 1,
      sym_cmp,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [16865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(717), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(715), 16,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16891] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(719), 16,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16917] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    STATE(256), 1,
      sym_cmp,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [16961] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(725), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(723), 16,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16987] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(729), 3,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(727), 14,
      sym_COMMA,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_RBRACE,
      sym_SUPREMUM,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
  [17012] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(731), 15,
      sym_AT,
      sym_BNOT,
      sym_INFIMUM,
      sym_LPAREN,
      sym_RPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [17037] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(737), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(735), 15,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [17062] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(739), 1,
      sym_AT,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(741), 5,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_SEM,
  [17102] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(743), 6,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
  [17140] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(503), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_MUL,
    ACTIONS(507), 1,
      sym_POW,
    ACTIONS(509), 1,
      sym_QUESTION,
    ACTIONS(513), 1,
      sym_XOR,
    ACTIONS(501), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(511), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(745), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(747), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17180] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(503), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_MUL,
    ACTIONS(507), 1,
      sym_POW,
    ACTIONS(509), 1,
      sym_QUESTION,
    ACTIONS(513), 1,
      sym_XOR,
    ACTIONS(501), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(511), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(749), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(751), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17220] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(503), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_MUL,
    ACTIONS(507), 1,
      sym_POW,
    ACTIONS(509), 1,
      sym_QUESTION,
    ACTIONS(513), 1,
      sym_XOR,
    ACTIONS(501), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(511), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(753), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(755), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17260] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(757), 6,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
  [17298] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(759), 1,
      sym_AND,
    ACTIONS(761), 1,
      sym_RBRACE,
    STATE(695), 1,
      sym_theory_definition_identifier,
    STATE(696), 1,
      sym_theory_definition_nlist,
    STATE(539), 2,
      sym_theory_term_definition,
      sym_theory_atom_definition,
    ACTIONS(763), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [17329] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(767), 3,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(765), 12,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_SUPREMUM,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
  [17352] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(771), 12,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [17375] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(775), 3,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(773), 12,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_SUPREMUM,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
  [17398] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(777), 5,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_SEM,
  [17435] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(781), 12,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [17458] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(749), 1,
      sym_DOT,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(751), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [17497] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(745), 1,
      sym_DOT,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(747), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [17536] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(753), 1,
      sym_DOT,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(755), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [17575] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(785), 1,
      sym_MUL,
    ACTIONS(783), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17599] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(789), 1,
      sym_MUL,
    ACTIONS(787), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17623] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(791), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(793), 9,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17647] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(759), 1,
      sym_AND,
    STATE(653), 1,
      sym_theory_definition_nlist,
    STATE(695), 1,
      sym_theory_definition_identifier,
    STATE(539), 2,
      sym_theory_term_definition,
      sym_theory_atom_definition,
    ACTIONS(763), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [17675] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 1,
      sym_MUL,
    ACTIONS(797), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17696] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      sym_AND,
    ACTIONS(807), 1,
      sym_MUL,
    ACTIONS(809), 1,
      sym_POW,
    ACTIONS(811), 1,
      sym_QUESTION,
    ACTIONS(813), 1,
      sym_XOR,
    ACTIONS(801), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(805), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(787), 4,
      sym_COMMA,
      sym_DOT,
      sym_RPAREN,
      sym_VBAR,
  [17729] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(817), 1,
      sym_MUL,
    ACTIONS(815), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17750] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      sym_AND,
    ACTIONS(811), 1,
      sym_QUESTION,
    ACTIONS(813), 1,
      sym_XOR,
    ACTIONS(817), 1,
      sym_MUL,
    ACTIONS(815), 9,
      sym_ADD,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [17777] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      sym_AND,
    ACTIONS(807), 1,
      sym_MUL,
    ACTIONS(809), 1,
      sym_POW,
    ACTIONS(811), 1,
      sym_QUESTION,
    ACTIONS(813), 1,
      sym_XOR,
    ACTIONS(801), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(805), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(815), 4,
      sym_COMMA,
      sym_DOT,
      sym_RPAREN,
      sym_VBAR,
  [17810] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym_QUESTION,
    ACTIONS(813), 1,
      sym_XOR,
    ACTIONS(817), 1,
      sym_MUL,
    ACTIONS(815), 10,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [17835] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      sym_MUL,
    ACTIONS(783), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17856] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(821), 1,
      sym_DOT,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(819), 2,
      sym_COMMA,
      sym_SEM,
  [17893] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(813), 1,
      sym_XOR,
    ACTIONS(817), 1,
      sym_MUL,
    ACTIONS(815), 11,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [17916] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 1,
      sym_COLON,
    STATE(143), 1,
      sym_csp_rel,
    ACTIONS(829), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(827), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
    ACTIONS(825), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17943] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(771), 11,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [17964] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      sym_AND,
    ACTIONS(811), 1,
      sym_QUESTION,
    ACTIONS(813), 1,
      sym_XOR,
    ACTIONS(817), 1,
      sym_MUL,
    ACTIONS(801), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(815), 7,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_VBAR,
  [17993] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(781), 11,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [18014] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(833), 1,
      sym_DOT,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(831), 2,
      sym_COMMA,
      sym_SEM,
  [18051] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(817), 1,
      sym_MUL,
    ACTIONS(815), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [18072] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(789), 1,
      sym_MUL,
    ACTIONS(787), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [18093] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(835), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(793), 9,
      sym_COLON,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [18116] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(503), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_MUL,
    ACTIONS(507), 1,
      sym_POW,
    ACTIONS(509), 1,
      sym_QUESTION,
    ACTIONS(513), 1,
      sym_XOR,
    ACTIONS(819), 1,
      sym_IF,
    ACTIONS(821), 1,
      sym_DOT,
    ACTIONS(501), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(511), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18152] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(837), 1,
      sym_AT,
    ACTIONS(839), 1,
      sym_COMMA,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18188] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(841), 1,
      sym_COLON,
    ACTIONS(843), 1,
      sym_DOT,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18224] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(163), 1,
      sym_csp_rel,
    ACTIONS(829), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(827), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
    ACTIONS(825), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [18248] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(845), 1,
      sym_COLON,
    ACTIONS(847), 1,
      sym_DOT,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18284] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(849), 2,
      sym_SEM,
      sym_VBAR,
  [18318] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      sym_DOTS,
    ACTIONS(503), 1,
      sym_AND,
    ACTIONS(505), 1,
      sym_MUL,
    ACTIONS(507), 1,
      sym_POW,
    ACTIONS(509), 1,
      sym_QUESTION,
    ACTIONS(513), 1,
      sym_XOR,
    ACTIONS(831), 1,
      sym_IF,
    ACTIONS(833), 1,
      sym_DOT,
    ACTIONS(501), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(511), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18354] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(851), 2,
      sym_RPAREN,
      sym_SEM,
  [18388] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(853), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(793), 8,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [18410] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(855), 2,
      sym_SEM,
      sym_VBAR,
  [18444] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(857), 2,
      sym_RPAREN,
      sym_SEM,
  [18478] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      sym_AND,
    ACTIONS(807), 1,
      sym_MUL,
    ACTIONS(809), 1,
      sym_POW,
    ACTIONS(811), 1,
      sym_QUESTION,
    ACTIONS(813), 1,
      sym_XOR,
    ACTIONS(801), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(805), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(859), 2,
      sym_COMMA,
      sym_RPAREN,
  [18509] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      sym_AND,
    ACTIONS(807), 1,
      sym_MUL,
    ACTIONS(809), 1,
      sym_POW,
    ACTIONS(811), 1,
      sym_QUESTION,
    ACTIONS(813), 1,
      sym_XOR,
    ACTIONS(801), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(805), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(861), 2,
      sym_COMMA,
      sym_RPAREN,
  [18540] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(863), 1,
      sym_RBRACK,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18573] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(865), 1,
      sym_RBRACK,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18606] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(867), 1,
      sym_COMMA,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18639] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(159), 1,
      sym_csp_rel,
    ACTIONS(829), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(825), 4,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(827), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [18662] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(869), 1,
      sym_RBRACK,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18695] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(871), 1,
      sym_COMMA,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18728] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(873), 1,
      sym_COMMA,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18761] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(313), 1,
      sym_AND,
    ACTIONS(315), 1,
      sym_MUL,
    ACTIONS(317), 1,
      sym_POW,
    ACTIONS(319), 1,
      sym_QUESTION,
    ACTIONS(323), 1,
      sym_XOR,
    ACTIONS(875), 1,
      sym_RBRACK,
    ACTIONS(311), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(321), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18794] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(697), 1,
      sym_theory_definition_identifier,
    ACTIONS(763), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [18812] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_VBAR,
    ACTIONS(803), 1,
      sym_AND,
    ACTIONS(807), 1,
      sym_MUL,
    ACTIONS(809), 1,
      sym_POW,
    ACTIONS(811), 1,
      sym_QUESTION,
    ACTIONS(813), 1,
      sym_XOR,
    ACTIONS(801), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(805), 2,
      sym_MOD,
      sym_SLASH,
  [18842] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      sym_AND,
    ACTIONS(807), 1,
      sym_MUL,
    ACTIONS(809), 1,
      sym_POW,
    ACTIONS(811), 1,
      sym_QUESTION,
    ACTIONS(813), 1,
      sym_XOR,
    ACTIONS(877), 1,
      sym_DOT,
    ACTIONS(801), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(805), 2,
      sym_MOD,
      sym_SLASH,
  [18872] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(674), 1,
      sym_theory_definition_identifier,
    ACTIONS(763), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [18890] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(651), 1,
      sym_theory_definition_identifier,
    ACTIONS(763), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [18908] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(688), 1,
      sym_theory_definition_identifier,
    ACTIONS(763), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [18926] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(163), 1,
      sym_csp_rel,
    ACTIONS(829), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(853), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(827), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [18947] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(143), 1,
      sym_csp_rel,
    ACTIONS(829), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(853), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(827), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [18968] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(159), 1,
      sym_csp_rel,
    ACTIONS(829), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(853), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(827), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [18989] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(367), 1,
      sym_COMMA,
    ACTIONS(879), 1,
      sym_COLON,
    STATE(268), 1,
      sym_dsym,
    STATE(552), 1,
      sym_noptcondition,
    ACTIONS(365), 2,
      sym_DOT,
      sym_IF,
    ACTIONS(881), 2,
      sym_SEM,
      sym_VBAR,
  [19013] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(264), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
    ACTIONS(883), 4,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
  [19033] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(885), 2,
      sym_COLON,
      sym_SEM,
    ACTIONS(887), 2,
      sym_COMMA,
      sym_RBRACE,
  [19057] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(264), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
    ACTIONS(887), 4,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
  [19077] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(883), 2,
      sym_COMMA,
      sym_RBRACE,
    ACTIONS(889), 2,
      sym_COLON,
      sym_SEM,
  [19101] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 1,
      sym_COLON,
    ACTIONS(339), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19116] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(29), 1,
      sym_dec,
    STATE(671), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19137] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(895), 1,
      sym_LPAREN,
    ACTIONS(891), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(893), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19154] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(329), 1,
      sym_COLON,
    ACTIONS(331), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19169] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    ACTIONS(897), 1,
      sym_COMMA,
    STATE(265), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(899), 2,
      sym_DOT,
      sym_SEM,
  [19192] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      sym_COLON,
    ACTIONS(903), 1,
      sym_COMMA,
    STATE(266), 1,
      sym_dsym,
    ACTIONS(881), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(905), 2,
      sym_DOT,
      sym_IF,
  [19213] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(907), 1,
      sym_LPAREN,
    ACTIONS(893), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19228] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(29), 1,
      sym_dec,
    STATE(663), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19249] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(753), 1,
      sym_COLON,
    ACTIONS(755), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19264] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(29), 1,
      sym_dec,
    STATE(662), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(909), 1,
      sym_COLON,
    ACTIONS(911), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19300] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 1,
      sym_COLON,
    ACTIONS(825), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19315] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    ACTIONS(913), 1,
      sym_COMMA,
    STATE(265), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(915), 2,
      sym_DOT,
      sym_SEM,
  [19338] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(29), 1,
      sym_dec,
    STATE(694), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19359] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19371] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19383] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19395] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 1,
      sym_COLON,
    STATE(607), 1,
      sym_noptcondition,
    ACTIONS(835), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(925), 2,
      sym_RBRACE,
      sym_SEM,
  [19413] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    ACTIONS(927), 1,
      sym_COMMA,
    STATE(197), 1,
      sym_theory_op,
    ACTIONS(929), 2,
      sym_DOT,
      sym_SEM,
  [19433] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(931), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19445] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    STATE(270), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(899), 2,
      sym_DOT,
      sym_IF,
  [19465] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      sym_RPAREN,
    ACTIONS(933), 1,
      sym_COMMA,
    STATE(264), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
  [19485] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 1,
      sym_LPAREN,
    ACTIONS(893), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(891), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [19501] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(937), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(939), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19515] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19527] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(295), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19541] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 1,
      sym_COLON,
    STATE(589), 1,
      sym_noptcondition,
    ACTIONS(835), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(943), 2,
      sym_RBRACE,
      sym_SEM,
  [19559] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19571] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      sym_RPAREN,
    ACTIONS(945), 1,
      sym_COMMA,
    STATE(264), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
  [19591] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym_COLON,
    ACTIONS(949), 1,
      sym_COMMA,
    STATE(459), 1,
      sym_noptimizetuple,
    STATE(544), 1,
      sym_noptimizecond,
    ACTIONS(951), 2,
      sym_RBRACE,
      sym_SEM,
  [19611] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym_COLON,
    ACTIONS(949), 1,
      sym_COMMA,
    STATE(481), 1,
      sym_noptimizetuple,
    STATE(600), 1,
      sym_noptimizecond,
    ACTIONS(953), 2,
      sym_RBRACE,
      sym_SEM,
  [19631] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(955), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [19645] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym_COLON,
    ACTIONS(949), 1,
      sym_COMMA,
    STATE(455), 1,
      sym_noptimizetuple,
    STATE(604), 1,
      sym_noptimizecond,
    ACTIONS(957), 2,
      sym_RBRACE,
      sym_SEM,
  [19665] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym_COLON,
    ACTIONS(949), 1,
      sym_COMMA,
    STATE(464), 1,
      sym_noptimizetuple,
    STATE(543), 1,
      sym_noptimizecond,
    ACTIONS(959), 2,
      sym_RBRACE,
      sym_SEM,
  [19685] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(277), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19699] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(893), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19711] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(299), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19725] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19737] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(963), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19751] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(965), 1,
      sym_RBRACE,
    STATE(636), 1,
      sym_theory_operator_definition,
    STATE(649), 1,
      sym_theory_operator_definition_nlist,
    STATE(660), 1,
      sym_theory_op,
    ACTIONS(967), 2,
      sym_THEORY_OP,
      sym_NOT,
  [19771] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(969), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19783] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym_COMMA,
    STATE(271), 1,
      sym_dsym,
    ACTIONS(881), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(973), 2,
      sym_DOT,
      sym_IF,
  [19801] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(599), 1,
      sym_RPAREN,
    ACTIONS(975), 1,
      sym_COMMA,
    STATE(264), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
  [19821] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(891), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(893), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19835] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(977), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19847] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 1,
      sym_COLON,
    STATE(625), 1,
      sym_noptcondition,
    ACTIONS(835), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(979), 2,
      sym_RBRACE,
      sym_SEM,
  [19865] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym_LBRACE,
    STATE(593), 1,
      sym_theory_atom_type,
    ACTIONS(983), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [19881] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(281), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19895] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym_COMMA,
    STATE(269), 1,
      sym_dsym,
    ACTIONS(881), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(985), 2,
      sym_DOT,
      sym_IF,
  [19913] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19925] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(987), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19939] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19951] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    STATE(270), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(915), 2,
      sym_DOT,
      sym_IF,
  [19971] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 1,
      sym_COLON,
    STATE(615), 1,
      sym_noptcondition,
    ACTIONS(835), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(989), 2,
      sym_RBRACE,
      sym_SEM,
  [19989] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(991), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [20003] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(993), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [20017] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(931), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(995), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [20031] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 1,
      sym_RPAREN,
    ACTIONS(997), 1,
      sym_COMMA,
    STATE(264), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
  [20051] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(999), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [20065] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20077] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    ACTIONS(1001), 1,
      sym_COMMA,
    STATE(204), 1,
      sym_theory_op,
    ACTIONS(1003), 2,
      sym_DOT,
      sym_SEM,
  [20097] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20109] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    STATE(206), 1,
      sym_theory_op,
    ACTIONS(929), 2,
      sym_DOT,
      sym_IF,
  [20126] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(937), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20139] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(331), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20150] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    STATE(203), 1,
      sym_theory_op,
    ACTIONS(1003), 2,
      sym_DOT,
      sym_IF,
  [20167] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(911), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20178] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 1,
      sym_COLON,
    ACTIONS(1005), 1,
      sym_COMMA,
    STATE(605), 1,
      sym_noptcondition,
    ACTIONS(383), 2,
      sym_RBRACE,
      sym_SEM,
  [20195] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1007), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [20206] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20217] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 1,
      sym_COLON,
    ACTIONS(1009), 1,
      sym_COMMA,
    STATE(631), 1,
      sym_noptcondition,
    ACTIONS(385), 2,
      sym_RBRACE,
      sym_SEM,
  [20234] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(825), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20245] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(339), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20256] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(620), 1,
      sym_theory_atom_type,
    ACTIONS(983), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [20269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(559), 1,
      sym_theory_atom_type,
    ACTIONS(983), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [20282] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1011), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [20293] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(893), 1,
      sym_NOT,
    ACTIONS(1013), 1,
      sym_LPAREN,
    ACTIONS(891), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20308] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1015), 1,
      sym_RBRACE,
    STATE(587), 1,
      sym_theory_operator_nlist,
    STATE(588), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
  [20325] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(893), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(891), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20338] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(999), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20351] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(991), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20364] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(987), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(931), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(995), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20390] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(281), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20403] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_COMMA,
    ACTIONS(1017), 4,
      sym_COLON,
      sym_RBRACE,
      sym_RBRACK,
      sym_SEM,
  [20416] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(993), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20429] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(295), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20442] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(277), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20455] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(299), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20468] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(963), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20481] = 4,
    ACTIONS(1019), 1,
      sym_comment,
    ACTIONS(1021), 1,
      anon_sym_DQUOTE,
    STATE(475), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1023), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20495] = 4,
    ACTIONS(1019), 1,
      sym_comment,
    ACTIONS(1025), 1,
      anon_sym_DQUOTE,
    STATE(473), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1027), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20509] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym_COLON,
    STATE(535), 1,
      sym_noptimizecond,
    ACTIONS(1029), 2,
      sym_RBRACE,
      sym_SEM,
  [20523] = 4,
    ACTIONS(1019), 1,
      sym_comment,
    ACTIONS(1031), 1,
      anon_sym_DQUOTE,
    STATE(474), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1033), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20537] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 1,
      sym_COLON,
    STATE(640), 1,
      sym_noptcondition,
    ACTIONS(1035), 2,
      sym_RBRACE,
      sym_SEM,
  [20551] = 4,
    ACTIONS(1019), 1,
      sym_comment,
    ACTIONS(1037), 1,
      anon_sym_DQUOTE,
    STATE(494), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1039), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20565] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym_COLON,
    STATE(564), 1,
      sym_noptimizecond,
    ACTIONS(1041), 2,
      sym_RBRACE,
      sym_SEM,
  [20579] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1045), 1,
      sym_LBRACE,
    ACTIONS(1043), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [20591] = 4,
    ACTIONS(1019), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_DQUOTE,
    STATE(475), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1023), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20605] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1049), 1,
      sym_COLON,
    ACTIONS(1053), 1,
      sym_DOT,
    ACTIONS(1051), 2,
      sym_COMMA,
      sym_SEM,
  [20619] = 4,
    ACTIONS(1019), 1,
      sym_comment,
    ACTIONS(1055), 1,
      anon_sym_DQUOTE,
    STATE(461), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1057), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20633] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym_COLON,
    STATE(577), 1,
      sym_noptimizecond,
    ACTIONS(1059), 2,
      sym_RBRACE,
      sym_SEM,
  [20647] = 4,
    ACTIONS(1019), 1,
      sym_comment,
    ACTIONS(1061), 1,
      anon_sym_DQUOTE,
    STATE(475), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1023), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20661] = 4,
    ACTIONS(1019), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_DQUOTE,
    STATE(465), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1065), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20675] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 1,
      sym_COLON,
    STATE(612), 1,
      sym_noptcondition,
    ACTIONS(1067), 2,
      sym_RBRACE,
      sym_SEM,
  [20689] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 1,
      sym_COLON,
    STATE(641), 1,
      sym_noptcondition,
    ACTIONS(1069), 2,
      sym_RBRACE,
      sym_SEM,
  [20703] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 1,
      sym_COLON,
    STATE(569), 1,
      sym_noptcondition,
    ACTIONS(1071), 2,
      sym_RBRACE,
      sym_SEM,
  [20717] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1073), 1,
      sym_SUB,
    ACTIONS(1075), 1,
      sym_identifier,
    STATE(166), 1,
      sym__widentifier,
    STATE(643), 1,
      sym_atom,
  [20733] = 4,
    ACTIONS(1019), 1,
      sym_comment,
    ACTIONS(1077), 1,
      anon_sym_DQUOTE,
    STATE(453), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1079), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20747] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(1081), 1,
      sym_SLASH,
    ACTIONS(327), 2,
      sym_COLON,
      sym_DOT,
  [20761] = 4,
    ACTIONS(1019), 1,
      sym_comment,
    ACTIONS(1083), 1,
      anon_sym_DQUOTE,
    STATE(475), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1023), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20775] = 4,
    ACTIONS(1019), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DQUOTE,
    STATE(475), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1023), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20789] = 4,
    ACTIONS(1019), 1,
      sym_comment,
    ACTIONS(1087), 1,
      anon_sym_DQUOTE,
    STATE(475), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1089), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20803] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 1,
      sym_COLON,
    STATE(540), 1,
      sym_noptcondition,
    ACTIONS(1092), 2,
      sym_RBRACE,
      sym_SEM,
  [20817] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(1094), 1,
      sym_SLASH,
    ACTIONS(331), 2,
      sym_COLON,
      sym_DOT,
  [20831] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(603), 1,
      sym_theory_operator_definition,
    STATE(660), 1,
      sym_theory_op,
    ACTIONS(967), 2,
      sym_THEORY_OP,
      sym_NOT,
  [20845] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 1,
      sym_COLON,
    STATE(602), 1,
      sym_noptcondition,
    ACTIONS(1096), 2,
      sym_RBRACE,
      sym_SEM,
  [20859] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1049), 1,
      sym_COLON,
    ACTIONS(1100), 1,
      sym_DOT,
    ACTIONS(1098), 2,
      sym_COMMA,
      sym_SEM,
  [20873] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym_COLON,
    STATE(621), 1,
      sym_noptimizecond,
    ACTIONS(1102), 2,
      sym_RBRACE,
      sym_SEM,
  [20887] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      sym_NOT,
    ACTIONS(281), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20899] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 1,
      sym_NOT,
    ACTIONS(295), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20911] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 1,
      sym_NOT,
    ACTIONS(277), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20923] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 1,
      sym_NOT,
    ACTIONS(299), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20935] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_NOT,
    ACTIONS(963), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20947] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 1,
      sym_NOT,
    ACTIONS(937), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20959] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 1,
      sym_NOT,
    ACTIONS(991), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20971] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 1,
      sym_NOT,
    ACTIONS(987), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20983] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(931), 1,
      sym_NOT,
    ACTIONS(995), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20995] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      sym_NOT,
    ACTIONS(993), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21007] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 1,
      sym_COLON,
    STATE(547), 1,
      sym_noptcondition,
    ACTIONS(1104), 2,
      sym_RBRACE,
      sym_SEM,
  [21021] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_NOT,
    ACTIONS(999), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21033] = 4,
    ACTIONS(1019), 1,
      sym_comment,
    ACTIONS(1106), 1,
      anon_sym_DQUOTE,
    STATE(475), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1023), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21047] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1073), 1,
      sym_SUB,
    ACTIONS(1075), 1,
      sym_identifier,
    STATE(166), 1,
      sym__widentifier,
    STATE(512), 1,
      sym_atom,
  [21063] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(893), 1,
      sym_NOT,
    ACTIONS(891), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21075] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1108), 1,
      sym_SUB,
    ACTIONS(1110), 1,
      sym_identifier,
    STATE(166), 1,
      sym__widentifier,
    STATE(498), 1,
      sym_atom,
  [21091] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1112), 1,
      sym_COLON,
    ACTIONS(1114), 1,
      sym_DOT,
    STATE(22), 1,
      sym_bodyconddot,
  [21104] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1116), 1,
      sym_identifier,
    STATE(147), 1,
      sym__widentifier,
    STATE(531), 1,
      sym_theory_atom_name,
  [21117] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1120), 1,
      sym_identifier,
    ACTIONS(1118), 2,
      sym_CSP,
      sym_SUB,
  [21128] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1122), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [21137] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(331), 2,
      sym_COLON,
      sym_DOT,
  [21148] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_COMMA,
    ACTIONS(1124), 2,
      sym_RPAREN,
      sym_SEM,
  [21159] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(573), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
  [21170] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1128), 1,
      sym_DOT,
    ACTIONS(1126), 2,
      sym_COMMA,
      sym_SEM,
  [21181] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21190] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1130), 1,
      sym_COMMA,
    ACTIONS(1132), 2,
      sym_RBRACE,
      sym_SEM,
  [21201] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1116), 1,
      sym_identifier,
    STATE(147), 1,
      sym__widentifier,
    STATE(460), 1,
      sym_theory_atom_name,
  [21214] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1134), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21223] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 1,
      sym_RPAREN,
    ACTIONS(1136), 1,
      sym_identifier,
    STATE(541), 1,
      sym_nidlist,
  [21236] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1138), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21245] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1112), 1,
      sym_COLON,
    ACTIONS(1114), 1,
      sym_DOT,
    STATE(689), 1,
      sym_bodyconddot,
  [21258] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(1140), 1,
      sym_LT,
    STATE(678), 1,
      sym_STRING,
  [21271] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1130), 1,
      sym_COMMA,
    ACTIONS(1142), 2,
      sym_RBRACE,
      sym_SEM,
  [21282] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_COMMA,
    ACTIONS(1144), 2,
      sym_RPAREN,
      sym_SEM,
  [21293] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1146), 1,
      sym_COMMA,
    ACTIONS(1148), 2,
      sym_RPAREN,
      sym_SEM,
  [21304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1130), 1,
      sym_COMMA,
    ACTIONS(1150), 2,
      sym_DOT,
      sym_SEM,
  [21315] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(379), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21324] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1154), 1,
      sym_DOT,
    ACTIONS(1152), 2,
      sym_COMMA,
      sym_SEM,
  [21335] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1156), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21344] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 3,
      sym_COMMA,
      sym_LBRACE,
      sym_SLASH,
  [21353] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 1,
      sym_COMMA,
    ACTIONS(1160), 1,
      sym_RBRACK,
    STATE(699), 1,
      sym_noptimizetuple,
  [21366] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21375] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1162), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [21384] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1112), 1,
      sym_COLON,
    ACTIONS(1114), 1,
      sym_DOT,
    STATE(23), 1,
      sym_bodyconddot,
  [21397] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [21406] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1166), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [21415] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1100), 1,
      sym_DOT,
    ACTIONS(1098), 2,
      sym_COMMA,
      sym_SEM,
  [21426] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      sym_DOT,
    ACTIONS(1051), 2,
      sym_COMMA,
      sym_SEM,
  [21437] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_LPAREN,
    ACTIONS(327), 2,
      sym_COLON,
      sym_DOT,
  [21448] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1168), 1,
      sym_LBRACE,
    ACTIONS(1043), 2,
      sym_DOT,
      sym_IF,
  [21459] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1170), 1,
      sym_COMMA,
    ACTIONS(1172), 2,
      sym_RBRACE,
      sym_SEM,
  [21470] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1130), 1,
      sym_COMMA,
    ACTIONS(985), 2,
      sym_RBRACE,
      sym_SEM,
  [21481] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 1,
      sym_RBRACE,
    ACTIONS(1174), 1,
      sym_SEM,
  [21491] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1176), 2,
      sym_RBRACE,
      sym_SEM,
  [21499] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(557), 1,
      sym_RBRACE,
    ACTIONS(1178), 1,
      sym_SEM,
  [21509] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1180), 1,
      sym_identifier,
    STATE(191), 1,
      sym__widentifier,
  [21519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1178), 1,
      sym_SEM,
    ACTIONS(1182), 1,
      sym_RBRACE,
  [21529] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1184), 1,
      sym_RBRACE,
    ACTIONS(1186), 1,
      sym_SEM,
  [21539] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1069), 2,
      sym_RBRACE,
      sym_SEM,
  [21547] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1188), 1,
      sym_COMMA,
    ACTIONS(1190), 1,
      sym_RPAREN,
  [21557] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1192), 2,
      sym_COMMA,
      sym_RPAREN,
  [21565] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1059), 2,
      sym_RBRACE,
      sym_SEM,
  [21573] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1041), 2,
      sym_RBRACE,
      sym_SEM,
  [21581] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1194), 1,
      sym_RBRACE,
    ACTIONS(1196), 1,
      sym_SEM,
  [21591] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1198), 2,
      sym_RBRACE,
      sym_SEM,
  [21599] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1200), 2,
      sym_RBRACE,
      sym_SEM,
  [21607] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_COMMA,
    ACTIONS(1202), 1,
      sym_COLON,
  [21617] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1204), 1,
      sym_RPAREN,
    ACTIONS(1206), 1,
      sym_SEM,
  [21627] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1208), 1,
      sym_identifier,
    STATE(196), 1,
      sym__widentifier,
  [21637] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1210), 2,
      sym_RBRACE,
      sym_SEM,
  [21645] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(973), 2,
      sym_DOT,
      sym_IF,
  [21653] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1212), 1,
      sym_RBRACE,
    ACTIONS(1214), 1,
      sym_SEM,
  [21663] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_COMMA,
    ACTIONS(1216), 1,
      sym_COLON,
  [21673] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 2,
      sym_DOT,
      sym_IF,
  [21681] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1218), 1,
      sym_COMMA,
    ACTIONS(1220), 1,
      sym_RPAREN,
  [21691] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(597), 1,
      sym_RPAREN,
    ACTIONS(1218), 1,
      sym_COMMA,
  [21701] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(617), 1,
      sym_RPAREN,
    ACTIONS(1218), 1,
      sym_COMMA,
  [21711] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 2,
      sym_RBRACE,
      sym_SEM,
  [21719] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 1,
      sym_SEM,
    ACTIONS(1224), 1,
      sym_RPAREN,
  [21729] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 1,
      sym_SUB,
    ACTIONS(1120), 1,
      sym_identifier,
  [21739] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(599), 1,
      sym_RBRACK,
    ACTIONS(1218), 1,
      sym_COMMA,
  [21749] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1226), 1,
      sym_RPAREN,
    ACTIONS(1228), 1,
      sym_SEM,
  [21759] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(953), 2,
      sym_RBRACE,
      sym_SEM,
  [21767] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 1,
      sym_RBRACE,
    ACTIONS(1230), 1,
      sym_SEM,
  [21777] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(599), 1,
      sym_RBRACE,
    ACTIONS(1218), 1,
      sym_COMMA,
  [21787] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1232), 2,
      sym_RBRACE,
      sym_SEM,
  [21795] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1234), 1,
      sym_RPAREN,
    ACTIONS(1236), 1,
      sym_SEM,
  [21805] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1238), 2,
      sym_RBRACE,
      sym_SEM,
  [21813] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 2,
      sym_DEFAULT,
      sym_OVERRIDE,
  [21821] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1098), 1,
      sym_SEM,
    ACTIONS(1100), 1,
      sym_DOT,
  [21831] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 2,
      sym_DOT,
      sym_IF,
  [21839] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1244), 2,
      sym_COMMA,
      sym_RBRACE,
  [21847] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 2,
      sym_DOT,
      sym_IF,
  [21855] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 1,
      sym_RBRACE,
    ACTIONS(1246), 1,
      sym_SEM,
  [21865] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1248), 2,
      sym_RBRACE,
      sym_SEM,
  [21873] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(957), 2,
      sym_RBRACE,
      sym_SEM,
  [21881] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1218), 1,
      sym_COMMA,
    ACTIONS(1250), 1,
      sym_RPAREN,
  [21891] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(589), 1,
      sym_RPAREN,
    ACTIONS(1206), 1,
      sym_SEM,
  [21901] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(605), 1,
      sym_RPAREN,
    ACTIONS(1218), 1,
      sym_COMMA,
  [21911] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 1,
      sym_RBRACE,
    ACTIONS(1178), 1,
      sym_SEM,
  [21921] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_COMMA,
    ACTIONS(1252), 1,
      sym_COLON,
  [21931] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1254), 2,
      sym_RBRACE,
      sym_SEM,
  [21939] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 1,
      sym_SEM,
    ACTIONS(1256), 1,
      sym_RPAREN,
  [21949] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 1,
      sym_SEM,
    ACTIONS(1258), 1,
      sym_RPAREN,
  [21959] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 1,
      sym_SEM,
    ACTIONS(1260), 1,
      sym_RPAREN,
  [21969] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1262), 1,
      sym_COMMA,
    ACTIONS(1264), 1,
      sym_RBRACE,
  [21979] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1266), 2,
      sym_COMMA,
      sym_RBRACE,
  [21987] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 2,
      sym_RBRACE,
      sym_SEM,
  [21995] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 1,
      sym_SEM,
    ACTIONS(1268), 1,
      sym_RPAREN,
  [22005] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1270), 2,
      sym_RBRACE,
      sym_SEM,
  [22013] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1272), 2,
      sym_LEFT,
      sym_RIGHT,
  [22021] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1274), 2,
      sym_RBRACE,
      sym_SEM,
  [22029] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1276), 2,
      sym_RBRACE,
      sym_SEM,
  [22037] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 1,
      sym_RBRACK,
    ACTIONS(1218), 1,
      sym_COMMA,
  [22047] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1278), 2,
      sym_RBRACE,
      sym_SEM,
  [22055] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      sym_RBRACE,
    ACTIONS(1218), 1,
      sym_COMMA,
  [22065] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 1,
      sym_RBRACE,
    ACTIONS(1218), 1,
      sym_COMMA,
  [22075] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1280), 1,
      sym_UNARY,
    ACTIONS(1282), 1,
      sym_BINARY,
  [22085] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1102), 2,
      sym_RBRACE,
      sym_SEM,
  [22093] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      sym_RBRACK,
    ACTIONS(1218), 1,
      sym_COMMA,
  [22103] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1284), 2,
      sym_RBRACE,
      sym_SEM,
  [22111] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1286), 2,
      sym_RBRACE,
      sym_SEM,
  [22119] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1029), 2,
      sym_RBRACE,
      sym_SEM,
  [22127] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1132), 2,
      sym_RBRACE,
      sym_SEM,
  [22135] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_RPAREN,
    ACTIONS(1288), 1,
      sym_COMMA,
  [22145] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1290), 2,
      sym_RBRACE,
      sym_SEM,
  [22153] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1292), 2,
      sym_COMMA,
      sym_RPAREN,
  [22161] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1294), 2,
      sym_RBRACE,
      sym_SEM,
  [22169] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1296), 1,
      sym_COMMA,
    ACTIONS(1298), 1,
      sym_RPAREN,
  [22179] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 2,
      sym_DOT,
      sym_IF,
  [22187] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 2,
      sym_RBRACE,
      sym_SEM,
  [22195] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(209), 1,
      sym_DOT,
    ACTIONS(1300), 1,
      sym_IF,
  [22205] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1302), 2,
      sym_RBRACE,
      sym_SEM,
  [22213] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 2,
      sym_RBRACE,
      sym_SEM,
  [22221] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1218), 1,
      sym_COMMA,
    ACTIONS(1304), 1,
      sym_RPAREN,
  [22231] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_COMMA,
    ACTIONS(1306), 1,
      sym_COLON,
  [22241] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(335), 2,
      sym_COLON,
      sym_DOT,
  [22249] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(405), 2,
      sym_DOT,
      sym_IF,
  [22257] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1308), 2,
      sym_RBRACE,
      sym_SEM,
  [22265] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1310), 2,
      sym_RBRACE,
      sym_SEM,
  [22273] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1256), 1,
      sym_VBAR,
    ACTIONS(1312), 1,
      sym_SEM,
  [22283] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 1,
      sym_DOT,
    ACTIONS(1314), 1,
      sym_LPAREN,
  [22293] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1316), 2,
      sym_RBRACE,
      sym_SEM,
  [22301] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 2,
      sym_RBRACE,
      sym_SEM,
  [22309] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1318), 1,
      sym_identifier,
    STATE(194), 1,
      sym__widentifier,
  [22319] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      sym_RPAREN,
    ACTIONS(1218), 1,
      sym_COMMA,
  [22329] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1320), 1,
      sym_identifier,
    STATE(155), 1,
      sym__widentifier,
  [22339] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1322), 1,
      sym_identifier,
    STATE(155), 1,
      sym__widentifier,
  [22349] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 1,
      sym_SEM,
    ACTIONS(1324), 1,
      sym_RPAREN,
  [22359] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1142), 2,
      sym_RBRACE,
      sym_SEM,
  [22367] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1326), 1,
      sym_RBRACE,
    ACTIONS(1328), 1,
      sym_SEM,
  [22377] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1148), 2,
      sym_RPAREN,
      sym_SEM,
  [22385] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(555), 1,
      sym_RBRACE,
    ACTIONS(1330), 1,
      sym_SEM,
  [22395] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1218), 1,
      sym_COMMA,
    ACTIONS(1332), 1,
      sym_RPAREN,
  [22405] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1334), 2,
      sym_RBRACE,
      sym_SEM,
  [22413] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      sym_RBRACK,
    ACTIONS(1218), 1,
      sym_COMMA,
  [22423] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      sym_RBRACE,
    ACTIONS(1218), 1,
      sym_COMMA,
  [22433] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1312), 1,
      sym_SEM,
    ACTIONS(1336), 1,
      sym_VBAR,
  [22443] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1338), 2,
      sym_RBRACE,
      sym_SEM,
  [22451] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1067), 2,
      sym_RBRACE,
      sym_SEM,
  [22459] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 1,
      sym_SEM,
    ACTIONS(1340), 1,
      sym_RPAREN,
  [22469] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1342), 1,
      sym_COLON,
    ACTIONS(1344), 1,
      sym_DOT,
  [22479] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 1,
      sym_SEM,
    ACTIONS(1053), 1,
      sym_DOT,
  [22489] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1328), 1,
      sym_SEM,
    ACTIONS(1346), 1,
      sym_RBRACE,
  [22499] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 1,
      sym_SEM,
    ACTIONS(1348), 1,
      sym_RPAREN,
  [22509] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 1,
      sym_SEM,
    ACTIONS(1336), 1,
      sym_RPAREN,
  [22519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 1,
      sym_SEM,
    ACTIONS(1350), 1,
      sym_RPAREN,
  [22529] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1352), 1,
      sym_RBRACE,
    ACTIONS(1354), 1,
      sym_SEM,
  [22539] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1356), 1,
      sym_COMMA,
  [22546] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1358), 1,
      sym_COMMA,
  [22553] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1360), 1,
      sym_identifier,
  [22560] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1362), 1,
      sym_RBRACE,
  [22567] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 1,
      sym_CSP,
  [22574] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1364), 1,
      sym_identifier,
  [22581] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1336), 1,
      sym_RPAREN,
  [22588] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(595), 1,
      sym_CSP,
  [22595] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1256), 1,
      sym_RPAREN,
  [22602] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1366), 1,
      sym_EQ,
  [22609] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1368), 1,
      sym_COLON,
  [22616] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(869), 1,
      sym_RBRACK,
  [22623] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 1,
      sym_DOT,
  [22630] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1370), 1,
      sym_COLON,
  [22637] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1372), 1,
      sym_LBRACK,
  [22644] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym_RPAREN,
  [22651] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1374), 1,
      sym_LBRACE,
  [22658] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1376), 1,
      ts_builtin_sym_end,
  [22665] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1378), 1,
      sym_LBRACE,
  [22672] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1380), 1,
      sym_identifier,
  [22679] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1382), 1,
      sym_LPAREN,
  [22686] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1384), 1,
      sym_COMMA,
  [22693] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 1,
      sym_identifier,
  [22700] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1388), 1,
      sym_identifier,
  [22707] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1390), 1,
      sym_COMMA,
  [22714] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1392), 1,
      sym_LBRACE,
  [22721] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1394), 1,
      sym_identifier,
  [22728] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1081), 1,
      sym_SLASH,
  [22735] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 1,
      sym_DOT,
  [22742] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1396), 1,
      sym_LPAREN,
  [22749] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1398), 1,
      sym_COMMA,
  [22756] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1094), 1,
      sym_SLASH,
  [22763] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 1,
      sym_GT,
  [22770] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(693), 1,
      sym_RPAREN,
  [22777] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_LBRACE,
  [22784] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1402), 1,
      sym_LBRACE,
  [22791] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1404), 1,
      sym_DOT,
  [22798] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(727), 1,
      sym_COLON,
  [22805] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1406), 1,
      sym_COMMA,
  [22812] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1408), 1,
      sym_LBRACK,
  [22819] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1410), 1,
      sym_RPAREN,
  [22826] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1412), 1,
      sym_LBRACE,
  [22833] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_LBRACE,
  [22840] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 1,
      sym_COMMA,
  [22847] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1160), 1,
      sym_DOT,
  [22854] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      sym_LBRACE,
  [22861] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1190), 1,
      sym_RBRACE,
  [22868] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1420), 1,
      sym_SLASH,
  [22875] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1422), 1,
      sym_LBRACE,
  [22882] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 1,
      sym_RBRACK,
  [22889] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1424), 1,
      sym_LBRACE,
  [22896] = 2,
    ACTIONS(1019), 1,
      sym_comment,
    ACTIONS(1426), 1,
      sym_CODE,
  [22903] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1428), 1,
      sym_identifier,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(4)] = 0,
  [SMALL_STATE(5)] = 125,
  [SMALL_STATE(6)] = 250,
  [SMALL_STATE(7)] = 375,
  [SMALL_STATE(8)] = 500,
  [SMALL_STATE(9)] = 556,
  [SMALL_STATE(10)] = 678,
  [SMALL_STATE(11)] = 800,
  [SMALL_STATE(12)] = 854,
  [SMALL_STATE(13)] = 908,
  [SMALL_STATE(14)] = 962,
  [SMALL_STATE(15)] = 1016,
  [SMALL_STATE(16)] = 1072,
  [SMALL_STATE(17)] = 1126,
  [SMALL_STATE(18)] = 1182,
  [SMALL_STATE(19)] = 1304,
  [SMALL_STATE(20)] = 1358,
  [SMALL_STATE(21)] = 1411,
  [SMALL_STATE(22)] = 1464,
  [SMALL_STATE(23)] = 1517,
  [SMALL_STATE(24)] = 1570,
  [SMALL_STATE(25)] = 1623,
  [SMALL_STATE(26)] = 1676,
  [SMALL_STATE(27)] = 1729,
  [SMALL_STATE(28)] = 1782,
  [SMALL_STATE(29)] = 1898,
  [SMALL_STATE(30)] = 1948,
  [SMALL_STATE(31)] = 1998,
  [SMALL_STATE(32)] = 2050,
  [SMALL_STATE(33)] = 2102,
  [SMALL_STATE(34)] = 2152,
  [SMALL_STATE(35)] = 2202,
  [SMALL_STATE(36)] = 2251,
  [SMALL_STATE(37)] = 2302,
  [SMALL_STATE(38)] = 2351,
  [SMALL_STATE(39)] = 2416,
  [SMALL_STATE(40)] = 2465,
  [SMALL_STATE(41)] = 2514,
  [SMALL_STATE(42)] = 2573,
  [SMALL_STATE(43)] = 2638,
  [SMALL_STATE(44)] = 2693,
  [SMALL_STATE(45)] = 2742,
  [SMALL_STATE(46)] = 2795,
  [SMALL_STATE(47)] = 2852,
  [SMALL_STATE(48)] = 2906,
  [SMALL_STATE(49)] = 2960,
  [SMALL_STATE(50)] = 3011,
  [SMALL_STATE(51)] = 3062,
  [SMALL_STATE(52)] = 3114,
  [SMALL_STATE(53)] = 3166,
  [SMALL_STATE(54)] = 3263,
  [SMALL_STATE(55)] = 3312,
  [SMALL_STATE(56)] = 3361,
  [SMALL_STATE(57)] = 3458,
  [SMALL_STATE(58)] = 3552,
  [SMALL_STATE(59)] = 3646,
  [SMALL_STATE(60)] = 3723,
  [SMALL_STATE(61)] = 3800,
  [SMALL_STATE(62)] = 3892,
  [SMALL_STATE(63)] = 3984,
  [SMALL_STATE(64)] = 4073,
  [SMALL_STATE(65)] = 4150,
  [SMALL_STATE(66)] = 4239,
  [SMALL_STATE(67)] = 4328,
  [SMALL_STATE(68)] = 4417,
  [SMALL_STATE(69)] = 4508,
  [SMALL_STATE(70)] = 4585,
  [SMALL_STATE(71)] = 4662,
  [SMALL_STATE(72)] = 4751,
  [SMALL_STATE(73)] = 4840,
  [SMALL_STATE(74)] = 4928,
  [SMALL_STATE(75)] = 5004,
  [SMALL_STATE(76)] = 5080,
  [SMALL_STATE(77)] = 5156,
  [SMALL_STATE(78)] = 5238,
  [SMALL_STATE(79)] = 5320,
  [SMALL_STATE(80)] = 5402,
  [SMALL_STATE(81)] = 5484,
  [SMALL_STATE(82)] = 5566,
  [SMALL_STATE(83)] = 5648,
  [SMALL_STATE(84)] = 5730,
  [SMALL_STATE(85)] = 5812,
  [SMALL_STATE(86)] = 5894,
  [SMALL_STATE(87)] = 5967,
  [SMALL_STATE(88)] = 6040,
  [SMALL_STATE(89)] = 6113,
  [SMALL_STATE(90)] = 6186,
  [SMALL_STATE(91)] = 6262,
  [SMALL_STATE(92)] = 6298,
  [SMALL_STATE(93)] = 6334,
  [SMALL_STATE(94)] = 6410,
  [SMALL_STATE(95)] = 6446,
  [SMALL_STATE(96)] = 6482,
  [SMALL_STATE(97)] = 6555,
  [SMALL_STATE(98)] = 6614,
  [SMALL_STATE(99)] = 6687,
  [SMALL_STATE(100)] = 6746,
  [SMALL_STATE(101)] = 6816,
  [SMALL_STATE(102)] = 6852,
  [SMALL_STATE(103)] = 6886,
  [SMALL_STATE(104)] = 6920,
  [SMALL_STATE(105)] = 6982,
  [SMALL_STATE(106)] = 7018,
  [SMALL_STATE(107)] = 7080,
  [SMALL_STATE(108)] = 7114,
  [SMALL_STATE(109)] = 7184,
  [SMALL_STATE(110)] = 7217,
  [SMALL_STATE(111)] = 7250,
  [SMALL_STATE(112)] = 7285,
  [SMALL_STATE(113)] = 7334,
  [SMALL_STATE(114)] = 7401,
  [SMALL_STATE(115)] = 7468,
  [SMALL_STATE(116)] = 7511,
  [SMALL_STATE(117)] = 7544,
  [SMALL_STATE(118)] = 7611,
  [SMALL_STATE(119)] = 7678,
  [SMALL_STATE(120)] = 7745,
  [SMALL_STATE(121)] = 7778,
  [SMALL_STATE(122)] = 7829,
  [SMALL_STATE(123)] = 7896,
  [SMALL_STATE(124)] = 7929,
  [SMALL_STATE(125)] = 7996,
  [SMALL_STATE(126)] = 8045,
  [SMALL_STATE(127)] = 8078,
  [SMALL_STATE(128)] = 8111,
  [SMALL_STATE(129)] = 8162,
  [SMALL_STATE(130)] = 8229,
  [SMALL_STATE(131)] = 8266,
  [SMALL_STATE(132)] = 8299,
  [SMALL_STATE(133)] = 8332,
  [SMALL_STATE(134)] = 8365,
  [SMALL_STATE(135)] = 8432,
  [SMALL_STATE(136)] = 8499,
  [SMALL_STATE(137)] = 8538,
  [SMALL_STATE(138)] = 8571,
  [SMALL_STATE(139)] = 8612,
  [SMALL_STATE(140)] = 8645,
  [SMALL_STATE(141)] = 8711,
  [SMALL_STATE(142)] = 8775,
  [SMALL_STATE(143)] = 8841,
  [SMALL_STATE(144)] = 8905,
  [SMALL_STATE(145)] = 8971,
  [SMALL_STATE(146)] = 9035,
  [SMALL_STATE(147)] = 9099,
  [SMALL_STATE(148)] = 9163,
  [SMALL_STATE(149)] = 9227,
  [SMALL_STATE(150)] = 9291,
  [SMALL_STATE(151)] = 9355,
  [SMALL_STATE(152)] = 9421,
  [SMALL_STATE(153)] = 9487,
  [SMALL_STATE(154)] = 9551,
  [SMALL_STATE(155)] = 9601,
  [SMALL_STATE(156)] = 9665,
  [SMALL_STATE(157)] = 9731,
  [SMALL_STATE(158)] = 9797,
  [SMALL_STATE(159)] = 9863,
  [SMALL_STATE(160)] = 9927,
  [SMALL_STATE(161)] = 9993,
  [SMALL_STATE(162)] = 10059,
  [SMALL_STATE(163)] = 10109,
  [SMALL_STATE(164)] = 10173,
  [SMALL_STATE(165)] = 10239,
  [SMALL_STATE(166)] = 10305,
  [SMALL_STATE(167)] = 10369,
  [SMALL_STATE(168)] = 10435,
  [SMALL_STATE(169)] = 10499,
  [SMALL_STATE(170)] = 10565,
  [SMALL_STATE(171)] = 10629,
  [SMALL_STATE(172)] = 10695,
  [SMALL_STATE(173)] = 10759,
  [SMALL_STATE(174)] = 10825,
  [SMALL_STATE(175)] = 10889,
  [SMALL_STATE(176)] = 10953,
  [SMALL_STATE(177)] = 11001,
  [SMALL_STATE(178)] = 11065,
  [SMALL_STATE(179)] = 11129,
  [SMALL_STATE(180)] = 11192,
  [SMALL_STATE(181)] = 11253,
  [SMALL_STATE(182)] = 11316,
  [SMALL_STATE(183)] = 11377,
  [SMALL_STATE(184)] = 11438,
  [SMALL_STATE(185)] = 11499,
  [SMALL_STATE(186)] = 11562,
  [SMALL_STATE(187)] = 11621,
  [SMALL_STATE(188)] = 11668,
  [SMALL_STATE(189)] = 11729,
  [SMALL_STATE(190)] = 11790,
  [SMALL_STATE(191)] = 11851,
  [SMALL_STATE(192)] = 11912,
  [SMALL_STATE(193)] = 11973,
  [SMALL_STATE(194)] = 12022,
  [SMALL_STATE(195)] = 12083,
  [SMALL_STATE(196)] = 12146,
  [SMALL_STATE(197)] = 12206,
  [SMALL_STATE(198)] = 12266,
  [SMALL_STATE(199)] = 12326,
  [SMALL_STATE(200)] = 12386,
  [SMALL_STATE(201)] = 12444,
  [SMALL_STATE(202)] = 12474,
  [SMALL_STATE(203)] = 12532,
  [SMALL_STATE(204)] = 12592,
  [SMALL_STATE(205)] = 12652,
  [SMALL_STATE(206)] = 12712,
  [SMALL_STATE(207)] = 12772,
  [SMALL_STATE(208)] = 12830,
  [SMALL_STATE(209)] = 12888,
  [SMALL_STATE(210)] = 12946,
  [SMALL_STATE(211)] = 13004,
  [SMALL_STATE(212)] = 13062,
  [SMALL_STATE(213)] = 13120,
  [SMALL_STATE(214)] = 13175,
  [SMALL_STATE(215)] = 13230,
  [SMALL_STATE(216)] = 13285,
  [SMALL_STATE(217)] = 13340,
  [SMALL_STATE(218)] = 13395,
  [SMALL_STATE(219)] = 13450,
  [SMALL_STATE(220)] = 13505,
  [SMALL_STATE(221)] = 13560,
  [SMALL_STATE(222)] = 13615,
  [SMALL_STATE(223)] = 13670,
  [SMALL_STATE(224)] = 13725,
  [SMALL_STATE(225)] = 13780,
  [SMALL_STATE(226)] = 13835,
  [SMALL_STATE(227)] = 13890,
  [SMALL_STATE(228)] = 13945,
  [SMALL_STATE(229)] = 14000,
  [SMALL_STATE(230)] = 14055,
  [SMALL_STATE(231)] = 14110,
  [SMALL_STATE(232)] = 14165,
  [SMALL_STATE(233)] = 14220,
  [SMALL_STATE(234)] = 14275,
  [SMALL_STATE(235)] = 14330,
  [SMALL_STATE(236)] = 14385,
  [SMALL_STATE(237)] = 14440,
  [SMALL_STATE(238)] = 14495,
  [SMALL_STATE(239)] = 14550,
  [SMALL_STATE(240)] = 14605,
  [SMALL_STATE(241)] = 14660,
  [SMALL_STATE(242)] = 14715,
  [SMALL_STATE(243)] = 14770,
  [SMALL_STATE(244)] = 14825,
  [SMALL_STATE(245)] = 14880,
  [SMALL_STATE(246)] = 14935,
  [SMALL_STATE(247)] = 14990,
  [SMALL_STATE(248)] = 15045,
  [SMALL_STATE(249)] = 15100,
  [SMALL_STATE(250)] = 15155,
  [SMALL_STATE(251)] = 15210,
  [SMALL_STATE(252)] = 15265,
  [SMALL_STATE(253)] = 15320,
  [SMALL_STATE(254)] = 15375,
  [SMALL_STATE(255)] = 15430,
  [SMALL_STATE(256)] = 15487,
  [SMALL_STATE(257)] = 15542,
  [SMALL_STATE(258)] = 15597,
  [SMALL_STATE(259)] = 15651,
  [SMALL_STATE(260)] = 15705,
  [SMALL_STATE(261)] = 15759,
  [SMALL_STATE(262)] = 15813,
  [SMALL_STATE(263)] = 15867,
  [SMALL_STATE(264)] = 15921,
  [SMALL_STATE(265)] = 15975,
  [SMALL_STATE(266)] = 16029,
  [SMALL_STATE(267)] = 16057,
  [SMALL_STATE(268)] = 16085,
  [SMALL_STATE(269)] = 16113,
  [SMALL_STATE(270)] = 16141,
  [SMALL_STATE(271)] = 16195,
  [SMALL_STATE(272)] = 16223,
  [SMALL_STATE(273)] = 16274,
  [SMALL_STATE(274)] = 16325,
  [SMALL_STATE(275)] = 16376,
  [SMALL_STATE(276)] = 16427,
  [SMALL_STATE(277)] = 16478,
  [SMALL_STATE(278)] = 16529,
  [SMALL_STATE(279)] = 16580,
  [SMALL_STATE(280)] = 16631,
  [SMALL_STATE(281)] = 16682,
  [SMALL_STATE(282)] = 16733,
  [SMALL_STATE(283)] = 16777,
  [SMALL_STATE(284)] = 16821,
  [SMALL_STATE(285)] = 16865,
  [SMALL_STATE(286)] = 16891,
  [SMALL_STATE(287)] = 16917,
  [SMALL_STATE(288)] = 16961,
  [SMALL_STATE(289)] = 16987,
  [SMALL_STATE(290)] = 17012,
  [SMALL_STATE(291)] = 17037,
  [SMALL_STATE(292)] = 17062,
  [SMALL_STATE(293)] = 17102,
  [SMALL_STATE(294)] = 17140,
  [SMALL_STATE(295)] = 17180,
  [SMALL_STATE(296)] = 17220,
  [SMALL_STATE(297)] = 17260,
  [SMALL_STATE(298)] = 17298,
  [SMALL_STATE(299)] = 17329,
  [SMALL_STATE(300)] = 17352,
  [SMALL_STATE(301)] = 17375,
  [SMALL_STATE(302)] = 17398,
  [SMALL_STATE(303)] = 17435,
  [SMALL_STATE(304)] = 17458,
  [SMALL_STATE(305)] = 17497,
  [SMALL_STATE(306)] = 17536,
  [SMALL_STATE(307)] = 17575,
  [SMALL_STATE(308)] = 17599,
  [SMALL_STATE(309)] = 17623,
  [SMALL_STATE(310)] = 17647,
  [SMALL_STATE(311)] = 17675,
  [SMALL_STATE(312)] = 17696,
  [SMALL_STATE(313)] = 17729,
  [SMALL_STATE(314)] = 17750,
  [SMALL_STATE(315)] = 17777,
  [SMALL_STATE(316)] = 17810,
  [SMALL_STATE(317)] = 17835,
  [SMALL_STATE(318)] = 17856,
  [SMALL_STATE(319)] = 17893,
  [SMALL_STATE(320)] = 17916,
  [SMALL_STATE(321)] = 17943,
  [SMALL_STATE(322)] = 17964,
  [SMALL_STATE(323)] = 17993,
  [SMALL_STATE(324)] = 18014,
  [SMALL_STATE(325)] = 18051,
  [SMALL_STATE(326)] = 18072,
  [SMALL_STATE(327)] = 18093,
  [SMALL_STATE(328)] = 18116,
  [SMALL_STATE(329)] = 18152,
  [SMALL_STATE(330)] = 18188,
  [SMALL_STATE(331)] = 18224,
  [SMALL_STATE(332)] = 18248,
  [SMALL_STATE(333)] = 18284,
  [SMALL_STATE(334)] = 18318,
  [SMALL_STATE(335)] = 18354,
  [SMALL_STATE(336)] = 18388,
  [SMALL_STATE(337)] = 18410,
  [SMALL_STATE(338)] = 18444,
  [SMALL_STATE(339)] = 18478,
  [SMALL_STATE(340)] = 18509,
  [SMALL_STATE(341)] = 18540,
  [SMALL_STATE(342)] = 18573,
  [SMALL_STATE(343)] = 18606,
  [SMALL_STATE(344)] = 18639,
  [SMALL_STATE(345)] = 18662,
  [SMALL_STATE(346)] = 18695,
  [SMALL_STATE(347)] = 18728,
  [SMALL_STATE(348)] = 18761,
  [SMALL_STATE(349)] = 18794,
  [SMALL_STATE(350)] = 18812,
  [SMALL_STATE(351)] = 18842,
  [SMALL_STATE(352)] = 18872,
  [SMALL_STATE(353)] = 18890,
  [SMALL_STATE(354)] = 18908,
  [SMALL_STATE(355)] = 18926,
  [SMALL_STATE(356)] = 18947,
  [SMALL_STATE(357)] = 18968,
  [SMALL_STATE(358)] = 18989,
  [SMALL_STATE(359)] = 19013,
  [SMALL_STATE(360)] = 19033,
  [SMALL_STATE(361)] = 19057,
  [SMALL_STATE(362)] = 19077,
  [SMALL_STATE(363)] = 19101,
  [SMALL_STATE(364)] = 19116,
  [SMALL_STATE(365)] = 19137,
  [SMALL_STATE(366)] = 19154,
  [SMALL_STATE(367)] = 19169,
  [SMALL_STATE(368)] = 19192,
  [SMALL_STATE(369)] = 19213,
  [SMALL_STATE(370)] = 19228,
  [SMALL_STATE(371)] = 19249,
  [SMALL_STATE(372)] = 19264,
  [SMALL_STATE(373)] = 19285,
  [SMALL_STATE(374)] = 19300,
  [SMALL_STATE(375)] = 19315,
  [SMALL_STATE(376)] = 19338,
  [SMALL_STATE(377)] = 19359,
  [SMALL_STATE(378)] = 19371,
  [SMALL_STATE(379)] = 19383,
  [SMALL_STATE(380)] = 19395,
  [SMALL_STATE(381)] = 19413,
  [SMALL_STATE(382)] = 19433,
  [SMALL_STATE(383)] = 19445,
  [SMALL_STATE(384)] = 19465,
  [SMALL_STATE(385)] = 19485,
  [SMALL_STATE(386)] = 19501,
  [SMALL_STATE(387)] = 19515,
  [SMALL_STATE(388)] = 19527,
  [SMALL_STATE(389)] = 19541,
  [SMALL_STATE(390)] = 19559,
  [SMALL_STATE(391)] = 19571,
  [SMALL_STATE(392)] = 19591,
  [SMALL_STATE(393)] = 19611,
  [SMALL_STATE(394)] = 19631,
  [SMALL_STATE(395)] = 19645,
  [SMALL_STATE(396)] = 19665,
  [SMALL_STATE(397)] = 19685,
  [SMALL_STATE(398)] = 19699,
  [SMALL_STATE(399)] = 19711,
  [SMALL_STATE(400)] = 19725,
  [SMALL_STATE(401)] = 19737,
  [SMALL_STATE(402)] = 19751,
  [SMALL_STATE(403)] = 19771,
  [SMALL_STATE(404)] = 19783,
  [SMALL_STATE(405)] = 19801,
  [SMALL_STATE(406)] = 19821,
  [SMALL_STATE(407)] = 19835,
  [SMALL_STATE(408)] = 19847,
  [SMALL_STATE(409)] = 19865,
  [SMALL_STATE(410)] = 19881,
  [SMALL_STATE(411)] = 19895,
  [SMALL_STATE(412)] = 19913,
  [SMALL_STATE(413)] = 19925,
  [SMALL_STATE(414)] = 19939,
  [SMALL_STATE(415)] = 19951,
  [SMALL_STATE(416)] = 19971,
  [SMALL_STATE(417)] = 19989,
  [SMALL_STATE(418)] = 20003,
  [SMALL_STATE(419)] = 20017,
  [SMALL_STATE(420)] = 20031,
  [SMALL_STATE(421)] = 20051,
  [SMALL_STATE(422)] = 20065,
  [SMALL_STATE(423)] = 20077,
  [SMALL_STATE(424)] = 20097,
  [SMALL_STATE(425)] = 20109,
  [SMALL_STATE(426)] = 20126,
  [SMALL_STATE(427)] = 20139,
  [SMALL_STATE(428)] = 20150,
  [SMALL_STATE(429)] = 20167,
  [SMALL_STATE(430)] = 20178,
  [SMALL_STATE(431)] = 20195,
  [SMALL_STATE(432)] = 20206,
  [SMALL_STATE(433)] = 20217,
  [SMALL_STATE(434)] = 20234,
  [SMALL_STATE(435)] = 20245,
  [SMALL_STATE(436)] = 20256,
  [SMALL_STATE(437)] = 20269,
  [SMALL_STATE(438)] = 20282,
  [SMALL_STATE(439)] = 20293,
  [SMALL_STATE(440)] = 20308,
  [SMALL_STATE(441)] = 20325,
  [SMALL_STATE(442)] = 20338,
  [SMALL_STATE(443)] = 20351,
  [SMALL_STATE(444)] = 20364,
  [SMALL_STATE(445)] = 20377,
  [SMALL_STATE(446)] = 20390,
  [SMALL_STATE(447)] = 20403,
  [SMALL_STATE(448)] = 20416,
  [SMALL_STATE(449)] = 20429,
  [SMALL_STATE(450)] = 20442,
  [SMALL_STATE(451)] = 20455,
  [SMALL_STATE(452)] = 20468,
  [SMALL_STATE(453)] = 20481,
  [SMALL_STATE(454)] = 20495,
  [SMALL_STATE(455)] = 20509,
  [SMALL_STATE(456)] = 20523,
  [SMALL_STATE(457)] = 20537,
  [SMALL_STATE(458)] = 20551,
  [SMALL_STATE(459)] = 20565,
  [SMALL_STATE(460)] = 20579,
  [SMALL_STATE(461)] = 20591,
  [SMALL_STATE(462)] = 20605,
  [SMALL_STATE(463)] = 20619,
  [SMALL_STATE(464)] = 20633,
  [SMALL_STATE(465)] = 20647,
  [SMALL_STATE(466)] = 20661,
  [SMALL_STATE(467)] = 20675,
  [SMALL_STATE(468)] = 20689,
  [SMALL_STATE(469)] = 20703,
  [SMALL_STATE(470)] = 20717,
  [SMALL_STATE(471)] = 20733,
  [SMALL_STATE(472)] = 20747,
  [SMALL_STATE(473)] = 20761,
  [SMALL_STATE(474)] = 20775,
  [SMALL_STATE(475)] = 20789,
  [SMALL_STATE(476)] = 20803,
  [SMALL_STATE(477)] = 20817,
  [SMALL_STATE(478)] = 20831,
  [SMALL_STATE(479)] = 20845,
  [SMALL_STATE(480)] = 20859,
  [SMALL_STATE(481)] = 20873,
  [SMALL_STATE(482)] = 20887,
  [SMALL_STATE(483)] = 20899,
  [SMALL_STATE(484)] = 20911,
  [SMALL_STATE(485)] = 20923,
  [SMALL_STATE(486)] = 20935,
  [SMALL_STATE(487)] = 20947,
  [SMALL_STATE(488)] = 20959,
  [SMALL_STATE(489)] = 20971,
  [SMALL_STATE(490)] = 20983,
  [SMALL_STATE(491)] = 20995,
  [SMALL_STATE(492)] = 21007,
  [SMALL_STATE(493)] = 21021,
  [SMALL_STATE(494)] = 21033,
  [SMALL_STATE(495)] = 21047,
  [SMALL_STATE(496)] = 21063,
  [SMALL_STATE(497)] = 21075,
  [SMALL_STATE(498)] = 21091,
  [SMALL_STATE(499)] = 21104,
  [SMALL_STATE(500)] = 21117,
  [SMALL_STATE(501)] = 21128,
  [SMALL_STATE(502)] = 21137,
  [SMALL_STATE(503)] = 21148,
  [SMALL_STATE(504)] = 21159,
  [SMALL_STATE(505)] = 21170,
  [SMALL_STATE(506)] = 21181,
  [SMALL_STATE(507)] = 21190,
  [SMALL_STATE(508)] = 21201,
  [SMALL_STATE(509)] = 21214,
  [SMALL_STATE(510)] = 21223,
  [SMALL_STATE(511)] = 21236,
  [SMALL_STATE(512)] = 21245,
  [SMALL_STATE(513)] = 21258,
  [SMALL_STATE(514)] = 21271,
  [SMALL_STATE(515)] = 21282,
  [SMALL_STATE(516)] = 21293,
  [SMALL_STATE(517)] = 21304,
  [SMALL_STATE(518)] = 21315,
  [SMALL_STATE(519)] = 21324,
  [SMALL_STATE(520)] = 21335,
  [SMALL_STATE(521)] = 21344,
  [SMALL_STATE(522)] = 21353,
  [SMALL_STATE(523)] = 21366,
  [SMALL_STATE(524)] = 21375,
  [SMALL_STATE(525)] = 21384,
  [SMALL_STATE(526)] = 21397,
  [SMALL_STATE(527)] = 21406,
  [SMALL_STATE(528)] = 21415,
  [SMALL_STATE(529)] = 21426,
  [SMALL_STATE(530)] = 21437,
  [SMALL_STATE(531)] = 21448,
  [SMALL_STATE(532)] = 21459,
  [SMALL_STATE(533)] = 21470,
  [SMALL_STATE(534)] = 21481,
  [SMALL_STATE(535)] = 21491,
  [SMALL_STATE(536)] = 21499,
  [SMALL_STATE(537)] = 21509,
  [SMALL_STATE(538)] = 21519,
  [SMALL_STATE(539)] = 21529,
  [SMALL_STATE(540)] = 21539,
  [SMALL_STATE(541)] = 21547,
  [SMALL_STATE(542)] = 21557,
  [SMALL_STATE(543)] = 21565,
  [SMALL_STATE(544)] = 21573,
  [SMALL_STATE(545)] = 21581,
  [SMALL_STATE(546)] = 21591,
  [SMALL_STATE(547)] = 21599,
  [SMALL_STATE(548)] = 21607,
  [SMALL_STATE(549)] = 21617,
  [SMALL_STATE(550)] = 21627,
  [SMALL_STATE(551)] = 21637,
  [SMALL_STATE(552)] = 21645,
  [SMALL_STATE(553)] = 21653,
  [SMALL_STATE(554)] = 21663,
  [SMALL_STATE(555)] = 21673,
  [SMALL_STATE(556)] = 21681,
  [SMALL_STATE(557)] = 21691,
  [SMALL_STATE(558)] = 21701,
  [SMALL_STATE(559)] = 21711,
  [SMALL_STATE(560)] = 21719,
  [SMALL_STATE(561)] = 21729,
  [SMALL_STATE(562)] = 21739,
  [SMALL_STATE(563)] = 21749,
  [SMALL_STATE(564)] = 21759,
  [SMALL_STATE(565)] = 21767,
  [SMALL_STATE(566)] = 21777,
  [SMALL_STATE(567)] = 21787,
  [SMALL_STATE(568)] = 21795,
  [SMALL_STATE(569)] = 21805,
  [SMALL_STATE(570)] = 21813,
  [SMALL_STATE(571)] = 21821,
  [SMALL_STATE(572)] = 21831,
  [SMALL_STATE(573)] = 21839,
  [SMALL_STATE(574)] = 21847,
  [SMALL_STATE(575)] = 21855,
  [SMALL_STATE(576)] = 21865,
  [SMALL_STATE(577)] = 21873,
  [SMALL_STATE(578)] = 21881,
  [SMALL_STATE(579)] = 21891,
  [SMALL_STATE(580)] = 21901,
  [SMALL_STATE(581)] = 21911,
  [SMALL_STATE(582)] = 21921,
  [SMALL_STATE(583)] = 21931,
  [SMALL_STATE(584)] = 21939,
  [SMALL_STATE(585)] = 21949,
  [SMALL_STATE(586)] = 21959,
  [SMALL_STATE(587)] = 21969,
  [SMALL_STATE(588)] = 21979,
  [SMALL_STATE(589)] = 21987,
  [SMALL_STATE(590)] = 21995,
  [SMALL_STATE(591)] = 22005,
  [SMALL_STATE(592)] = 22013,
  [SMALL_STATE(593)] = 22021,
  [SMALL_STATE(594)] = 22029,
  [SMALL_STATE(595)] = 22037,
  [SMALL_STATE(596)] = 22047,
  [SMALL_STATE(597)] = 22055,
  [SMALL_STATE(598)] = 22065,
  [SMALL_STATE(599)] = 22075,
  [SMALL_STATE(600)] = 22085,
  [SMALL_STATE(601)] = 22093,
  [SMALL_STATE(602)] = 22103,
  [SMALL_STATE(603)] = 22111,
  [SMALL_STATE(604)] = 22119,
  [SMALL_STATE(605)] = 22127,
  [SMALL_STATE(606)] = 22135,
  [SMALL_STATE(607)] = 22145,
  [SMALL_STATE(608)] = 22153,
  [SMALL_STATE(609)] = 22161,
  [SMALL_STATE(610)] = 22169,
  [SMALL_STATE(611)] = 22179,
  [SMALL_STATE(612)] = 22187,
  [SMALL_STATE(613)] = 22195,
  [SMALL_STATE(614)] = 22205,
  [SMALL_STATE(615)] = 22213,
  [SMALL_STATE(616)] = 22221,
  [SMALL_STATE(617)] = 22231,
  [SMALL_STATE(618)] = 22241,
  [SMALL_STATE(619)] = 22249,
  [SMALL_STATE(620)] = 22257,
  [SMALL_STATE(621)] = 22265,
  [SMALL_STATE(622)] = 22273,
  [SMALL_STATE(623)] = 22283,
  [SMALL_STATE(624)] = 22293,
  [SMALL_STATE(625)] = 22301,
  [SMALL_STATE(626)] = 22309,
  [SMALL_STATE(627)] = 22319,
  [SMALL_STATE(628)] = 22329,
  [SMALL_STATE(629)] = 22339,
  [SMALL_STATE(630)] = 22349,
  [SMALL_STATE(631)] = 22359,
  [SMALL_STATE(632)] = 22367,
  [SMALL_STATE(633)] = 22377,
  [SMALL_STATE(634)] = 22385,
  [SMALL_STATE(635)] = 22395,
  [SMALL_STATE(636)] = 22405,
  [SMALL_STATE(637)] = 22413,
  [SMALL_STATE(638)] = 22423,
  [SMALL_STATE(639)] = 22433,
  [SMALL_STATE(640)] = 22443,
  [SMALL_STATE(641)] = 22451,
  [SMALL_STATE(642)] = 22459,
  [SMALL_STATE(643)] = 22469,
  [SMALL_STATE(644)] = 22479,
  [SMALL_STATE(645)] = 22489,
  [SMALL_STATE(646)] = 22499,
  [SMALL_STATE(647)] = 22509,
  [SMALL_STATE(648)] = 22519,
  [SMALL_STATE(649)] = 22529,
  [SMALL_STATE(650)] = 22539,
  [SMALL_STATE(651)] = 22546,
  [SMALL_STATE(652)] = 22553,
  [SMALL_STATE(653)] = 22560,
  [SMALL_STATE(654)] = 22567,
  [SMALL_STATE(655)] = 22574,
  [SMALL_STATE(656)] = 22581,
  [SMALL_STATE(657)] = 22588,
  [SMALL_STATE(658)] = 22595,
  [SMALL_STATE(659)] = 22602,
  [SMALL_STATE(660)] = 22609,
  [SMALL_STATE(661)] = 22616,
  [SMALL_STATE(662)] = 22623,
  [SMALL_STATE(663)] = 22630,
  [SMALL_STATE(664)] = 22637,
  [SMALL_STATE(665)] = 22644,
  [SMALL_STATE(666)] = 22651,
  [SMALL_STATE(667)] = 22658,
  [SMALL_STATE(668)] = 22665,
  [SMALL_STATE(669)] = 22672,
  [SMALL_STATE(670)] = 22679,
  [SMALL_STATE(671)] = 22686,
  [SMALL_STATE(672)] = 22693,
  [SMALL_STATE(673)] = 22700,
  [SMALL_STATE(674)] = 22707,
  [SMALL_STATE(675)] = 22714,
  [SMALL_STATE(676)] = 22721,
  [SMALL_STATE(677)] = 22728,
  [SMALL_STATE(678)] = 22735,
  [SMALL_STATE(679)] = 22742,
  [SMALL_STATE(680)] = 22749,
  [SMALL_STATE(681)] = 22756,
  [SMALL_STATE(682)] = 22763,
  [SMALL_STATE(683)] = 22770,
  [SMALL_STATE(684)] = 22777,
  [SMALL_STATE(685)] = 22784,
  [SMALL_STATE(686)] = 22791,
  [SMALL_STATE(687)] = 22798,
  [SMALL_STATE(688)] = 22805,
  [SMALL_STATE(689)] = 22812,
  [SMALL_STATE(690)] = 22819,
  [SMALL_STATE(691)] = 22826,
  [SMALL_STATE(692)] = 22833,
  [SMALL_STATE(693)] = 22840,
  [SMALL_STATE(694)] = 22847,
  [SMALL_STATE(695)] = 22854,
  [SMALL_STATE(696)] = 22861,
  [SMALL_STATE(697)] = 22868,
  [SMALL_STATE(698)] = 22875,
  [SMALL_STATE(699)] = 22882,
  [SMALL_STATE(700)] = 22889,
  [SMALL_STATE(701)] = 22896,
  [SMALL_STATE(702)] = 22903,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(676),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(698),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(691),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(698),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(685),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(684),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(679),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(673),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(672),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(47),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(670),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [79] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [81] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(499),
  [84] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(537),
  [87] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(253),
  [90] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(676),
  [93] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(698),
  [96] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(242),
  [99] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(691),
  [102] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(470),
  [105] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(561),
  [108] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(374),
  [111] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(7),
  [114] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(513),
  [117] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(44),
  [120] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(73),
  [123] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(90),
  [126] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(698),
  [129] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(685),
  [132] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(684),
  [135] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(180),
  [138] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(679),
  [141] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(497),
  [144] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(495),
  [147] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(500),
  [150] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(226),
  [153] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(673),
  [156] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(211),
  [159] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(10),
  [162] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(672),
  [165] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(34),
  [168] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(34),
  [171] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(29),
  [174] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(44),
  [177] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(47),
  [180] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(670),
  [183] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(108),
  [186] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(458),
  [189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 5),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [215] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 5),
  [217] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyconddot, 1),
  [219] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyconddot, 1),
  [221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 2),
  [223] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 2),
  [225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 3),
  [227] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 3),
  [229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyconddot, 2),
  [231] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyconddot, 2),
  [233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 4),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [237] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 4),
  [239] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 5),
  [241] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 5),
  [243] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 3),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [247] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 3),
  [249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 4),
  [251] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 4),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 8),
  [255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 8),
  [257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 10),
  [259] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 10),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [263] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 2),
  [265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 7),
  [267] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 7),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 6),
  [271] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 6),
  [273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_NUMBER, 1),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_NUMBER, 1),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_STRING, 3),
  [281] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_STRING, 3),
  [283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 1),
  [285] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 1),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [289] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 2),
  [291] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 2),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_STRING, 2),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_STRING, 2),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dec, 1),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dec, 1),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 3),
  [303] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 3),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 4),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 4),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [315] = {.entry = {.count = 1, .reusable = false}}, SHIFT(247),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [325] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 1),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 1),
  [329] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 2),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 2),
  [333] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 4),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 4),
  [337] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 3),
  [339] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 3),
  [341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(675),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [345] = {.entry = {.count = 1, .reusable = false}}, SHIFT(57),
  [347] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(692),
  [351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [355] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 1),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(657),
  [361] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 1),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunction, 2),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [369] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptcondition, 1),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conjunction, 2),
  [377] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 3),
  [381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element, 1),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelem, 1),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [389] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 2),
  [393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 1),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizecond, 1),
  [397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 2),
  [399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(626),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [405] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 1),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [413] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [419] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 3),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 2),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(633),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [435] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 3),
  [437] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 3),
  [439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 4),
  [441] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 4),
  [443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [445] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 5),
  [447] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 5),
  [449] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 2),
  [451] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 2),
  [453] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [465] = {.entry = {.count = 1, .reusable = false}}, SHIFT(399),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [471] = {.entry = {.count = 1, .reusable = false}}, SHIFT(365),
  [473] = {.entry = {.count = 1, .reusable = false}}, SHIFT(289),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [483] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 3),
  [485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 3),
  [487] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 2),
  [489] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 2),
  [491] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 4),
  [493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 4),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [497] = {.entry = {.count = 1, .reusable = false}}, SHIFT(114),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [505] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(146),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(654),
  [529] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [531] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 2),
  [533] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 2),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [537] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 2),
  [539] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 2),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [543] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [545] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 4),
  [547] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 4),
  [549] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 3),
  [551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 3),
  [553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [569] = {.entry = {.count = 1, .reusable = false}}, SHIFT(412),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [575] = {.entry = {.count = 1, .reusable = false}}, SHIFT(369),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(686),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [621] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 4),
  [623] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 4),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuple, 2),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [655] = {.entry = {.count = 1, .reusable = false}}, SHIFT(451),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [661] = {.entry = {.count = 1, .reusable = false}}, SHIFT(385),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [667] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cmp, 1),
  [669] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cmp, 1),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [679] = {.entry = {.count = 1, .reusable = false}}, SHIFT(485),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [685] = {.entry = {.count = 1, .reusable = false}}, SHIFT(439),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [695] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 2),
  [697] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 2),
  [699] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dsym, 1),
  [701] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dsym, 1),
  [703] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 3),
  [705] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 3),
  [707] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 5),
  [709] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 5),
  [711] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 4),
  [713] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 4),
  [715] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 1),
  [717] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 1),
  [719] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 2),
  [721] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 2),
  [723] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 3),
  [725] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 3),
  [727] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op, 1),
  [729] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op, 1),
  [731] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__widentifier, 2),
  [733] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__widentifier, 2),
  [735] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_rel, 1),
  [737] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_rel, 1),
  [739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [741] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizeweight, 1),
  [743] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntermvec, 3),
  [745] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 5),
  [747] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 5),
  [749] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 4),
  [751] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 4),
  [753] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 3),
  [755] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 3),
  [757] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntermvec, 1),
  [759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(694),
  [763] = {.entry = {.count = 1, .reusable = false}}, SHIFT(521),
  [765] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op_list, 1),
  [767] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op_list, 1),
  [769] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_add_term, 1),
  [771] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_add_term, 1),
  [773] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op_list, 2),
  [775] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op_list, 2),
  [777] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizeweight, 3),
  [779] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_add_term, 3),
  [781] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_add_term, 3),
  [783] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 1),
  [785] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 1),
  [787] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 2),
  [789] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 2),
  [791] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_literal, 3),
  [793] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_literal, 3),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [797] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 4),
  [799] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 4),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [807] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 3),
  [817] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 3),
  [819] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nupper, 2),
  [821] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nupper, 2),
  [823] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 1),
  [825] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 1),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [829] = {.entry = {.count = 1, .reusable = false}}, SHIFT(291),
  [831] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nupper, 1),
  [833] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nupper, 1),
  [835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [843] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [847] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [849] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unaryargvec, 3),
  [851] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binaryargvec, 5),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unaryargvec, 1),
  [857] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binaryargvec, 3),
  [859] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_consttermvec, 3),
  [861] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_consttermvec, 1),
  [863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [879] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [883] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm_nlist, 1),
  [885] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm_nlist, 3),
  [887] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm_nlist, 3),
  [889] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm_nlist, 1),
  [891] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 1),
  [893] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 1),
  [895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 7),
  [899] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 7),
  [901] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [905] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_head, 1),
  [907] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [909] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 2),
  [911] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 2),
  [913] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 6),
  [915] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 6),
  [917] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 2),
  [919] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 5),
  [921] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 3),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [925] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 5),
  [927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 5),
  [929] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 5),
  [931] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 2),
  [933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [937] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 4),
  [939] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 4),
  [941] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 1),
  [943] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 3),
  [945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [951] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 1),
  [953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 3),
  [955] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 1),
  [957] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 3),
  [959] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 1),
  [961] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 3),
  [963] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 5),
  [965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(609),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(687),
  [969] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nlitvec, 1),
  [971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [973] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunction, 3),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [977] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nlitvec, 3),
  [979] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 4),
  [981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [985] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptcondition, 2),
  [987] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 3),
  [989] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 2),
  [991] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 3),
  [993] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 2),
  [995] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 2),
  [997] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [999] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 1),
  [1001] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 4),
  [1003] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 4),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [1007] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 3),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1011] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 2),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(693),
  [1017] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizetuple, 2),
  [1019] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [1021] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [1023] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [1025] = {.entry = {.count = 1, .reusable = false}}, SHIFT(422),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [1029] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 4),
  [1031] = {.entry = {.count = 1, .reusable = false}}, SHIFT(388),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [1035] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 3),
  [1037] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [1039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [1041] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 2),
  [1043] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 2),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [1047] = {.entry = {.count = 1, .reusable = false}}, SHIFT(446),
  [1049] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [1053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1055] = {.entry = {.count = 1, .reusable = false}}, SHIFT(449),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [1059] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 2),
  [1061] = {.entry = {.count = 1, .reusable = false}}, SHIFT(482),
  [1063] = {.entry = {.count = 1, .reusable = false}}, SHIFT(483),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [1067] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 4),
  [1069] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 3),
  [1071] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 1),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(629),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1077] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [1083] = {.entry = {.count = 1, .reusable = false}}, SHIFT(414),
  [1085] = {.entry = {.count = 1, .reusable = false}}, SHIFT(410),
  [1087] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_STRING_repeat1, 2),
  [1089] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_STRING_repeat1, 2), SHIFT_REPEAT(475),
  [1092] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 2),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1096] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 5),
  [1098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [1102] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 4),
  [1104] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelem, 1),
  [1106] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [1108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(628),
  [1110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(652),
  [1120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(677),
  [1122] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 3),
  [1124] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argvec, 1),
  [1126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [1132] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element, 2),
  [1134] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizelitvec, 3),
  [1136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [1138] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 4),
  [1140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(655),
  [1142] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelem, 2),
  [1144] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argvec, 3),
  [1146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [1148] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuple, 1),
  [1150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conjunction, 3),
  [1152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1156] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizelitvec, 1),
  [1158] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_identifier, 1),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 5),
  [1164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 4),
  [1166] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 6),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [1172] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizecond, 2),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1176] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 5),
  [1178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [1180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1184] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_nlist, 1),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(702),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(662),
  [1192] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nidlist, 1),
  [1194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [1196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [1198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelemvec, 1),
  [1200] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelem, 2),
  [1202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [1204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(618),
  [1206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [1210] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element_nlist, 1),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 13),
  [1224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [1228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1232] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element_nlist, 3),
  [1234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuplevec, 2),
  [1236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 2),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(661),
  [1242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 4),
  [1244] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_nlist, 3),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 1),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [1254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition, 7),
  [1256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(680),
  [1266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_nlist, 1),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelemvec, 3),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [1274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 8),
  [1276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_type, 1),
  [1278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition, 5),
  [1280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [1282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(650),
  [1284] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 6),
  [1286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition_nlist, 3),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [1290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 6),
  [1292] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nidlist, 3),
  [1294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term_definition, 3),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1298] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nconstargvec, 1),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [1302] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term_definition, 4),
  [1304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [1306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 14),
  [1310] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 5),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [1314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [1316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 3),
  [1318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [1320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [1322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [1324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuplevec, 1),
  [1326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [1330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1334] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition_nlist, 1),
  [1336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [1338] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 4),
  [1340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [1342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [1350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(614),
  [1354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [1358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [1360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(681),
  [1362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_nlist, 3),
  [1364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(682),
  [1366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [1368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [1370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [1376] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(690),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(669),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(668),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(623),
  [1390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(659),
  [1396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [1400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [1404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [1410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(701),
  [1412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [1414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [1416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [1418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [1422] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_aggregatefunction, 1),
  [1424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [1426] = {.entry = {.count = 1, .reusable = false}}, SHIFT(662),
  [1428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_clingo(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
