#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 703
#define LARGE_STATE_COUNT 4
#define SYMBOL_COUNT 168
#define ALIAS_COUNT 0
#define TOKEN_COUNT 94
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 14
#define PRODUCTION_ID_COUNT 1

enum {
  sym_comment = 1,
  sym_ADD = 2,
  sym_AND = 3,
  sym_EQ = 4,
  sym_AT = 5,
  sym_BNOT = 6,
  sym_COLON = 7,
  sym_COMMA = 8,
  sym_CONST = 9,
  sym_COUNT = 10,
  sym_CSP = 11,
  sym_CSP_ADD = 12,
  sym_CSP_SUB = 13,
  sym_CSP_MUL = 14,
  sym_CSP_LEQ = 15,
  sym_CSP_LT = 16,
  sym_CSP_GT = 17,
  sym_CSP_GEQ = 18,
  sym_CSP_EQ = 19,
  sym_CSP_NEQ = 20,
  sym_DISJOINT = 21,
  sym_DOT = 22,
  sym_DOTS = 23,
  sym_EXTERNAL = 24,
  sym_DEFINED = 25,
  sym_FALSE = 26,
  sym_GEQ = 27,
  sym_GT = 28,
  sym_IF = 29,
  sym_INCLUDE = 30,
  sym_INFIMUM = 31,
  sym_LBRACE = 32,
  sym_LBRACK = 33,
  sym_LEQ = 34,
  sym_LPAREN = 35,
  sym_LT = 36,
  sym_MAX = 37,
  sym_MAXIMIZE = 38,
  sym_MIN = 39,
  sym_MINIMIZE = 40,
  sym_MOD = 41,
  sym_MUL = 42,
  sym_NEQ = 43,
  sym_POW = 44,
  sym_QUESTION = 45,
  sym_RBRACE = 46,
  sym_RBRACK = 47,
  sym_RPAREN = 48,
  sym_SEM = 49,
  sym_SHOW = 50,
  sym_EDGE = 51,
  sym_PROJECT = 52,
  sym_HEURISTIC = 53,
  sym_SHOWSIG = 54,
  sym_SLASH = 55,
  sym_SUB = 56,
  sym_SUM = 57,
  sym_SUMP = 58,
  sym_SUPREMUM = 59,
  sym_TRUE = 60,
  sym_BLOCK = 61,
  sym_VBAR = 62,
  sym_WIF = 63,
  sym_XOR = 64,
  sym_ANY = 65,
  sym_UNARY = 66,
  sym_BINARY = 67,
  sym_LEFT = 68,
  sym_RIGHT = 69,
  sym_HEAD = 70,
  sym_BODY = 71,
  sym_DIRECTIVE = 72,
  sym_THEORY = 73,
  anon_sym_0 = 74,
  aux_sym_dec_token1 = 75,
  sym_hex = 76,
  sym_oct = 77,
  sym_bin = 78,
  sym_ANONYMOUS = 79,
  sym_identifier = 80,
  anon_sym_LPAREN = 81,
  sym_SCRIPT = 82,
  sym_CODE = 83,
  sym_VARIABLE = 84,
  sym_THEORY_OP = 85,
  sym_NOT = 86,
  sym_DEFAULT = 87,
  sym_OVERRIDE = 88,
  anon_sym_BSLASH_BSLASH = 89,
  anon_sym_EQ_EQ = 90,
  anon_sym_DQUOTE = 91,
  sym_unescaped_double_string_fragment = 92,
  sym_escape_sequence = 93,
  sym_source_file = 94,
  sym_NUMBER = 95,
  sym_dec = 96,
  sym__widentifier = 97,
  sym_constterm = 98,
  sym_consttermvec = 99,
  sym_nconstargvec = 100,
  sym_term = 101,
  sym_unaryargvec = 102,
  sym_ntermvec = 103,
  sym_ntuple = 104,
  sym_tuplevec_sem = 105,
  sym_ntuplevec = 106,
  sym_argvec = 107,
  sym_binaryargvec = 108,
  sym_cmp = 109,
  sym_atom = 110,
  sym_literal = 111,
  sym_csp_mul_term = 112,
  sym_csp_add_term = 113,
  sym_csp_rel = 114,
  sym_csp_literal = 115,
  sym_nlitvec = 116,
  sym_noptcondition = 117,
  sym_aggregatefunction = 118,
  sym_bodyaggrelem = 119,
  sym_bodyaggrelemvec = 120,
  sym_altbodyaggrelem = 121,
  sym_altbodyaggrelemvec = 122,
  sym_bodyaggregate = 123,
  sym_nupper = 124,
  sym_lubodyaggregate = 125,
  sym_headaggrelemvec = 126,
  sym_altheadaggrelemvec = 127,
  sym_headaggregate = 128,
  sym_luheadaggregate = 129,
  sym_ncspelemvec = 130,
  sym_disjoint = 131,
  sym_conjunction = 132,
  sym_dsym = 133,
  sym_disjunctionsep = 134,
  sym_disjunction = 135,
  sym_nbodycomma = 136,
  sym_bodydot = 137,
  sym_bodyconddot = 138,
  sym_head = 139,
  sym_statement = 140,
  sym_noptimizetuple = 141,
  sym_optimizeweight = 142,
  sym_optimizelitvec = 143,
  sym_noptimizecond = 144,
  sym_maxelemlist = 145,
  sym_minelemlist = 146,
  sym_nidlist = 147,
  sym_theory_op = 148,
  sym_theory_op_list = 149,
  sym_theory_term = 150,
  sym_theory_opterm = 151,
  sym_theory_opterm_nlist = 152,
  sym_theory_atom_element = 153,
  sym_theory_atom_element_nlist = 154,
  sym_theory_atom_name = 155,
  sym_theory_atom = 156,
  sym_theory_operator_nlist = 157,
  sym_theory_operator_definition = 158,
  sym_theory_operator_definition_nlist = 159,
  sym_theory_definition_identifier = 160,
  sym_theory_term_definition = 161,
  sym_theory_atom_type = 162,
  sym_theory_atom_definition = 163,
  sym_theory_definition_nlist = 164,
  sym_STRING = 165,
  aux_sym_source_file_repeat1 = 166,
  aux_sym_STRING_repeat1 = 167,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_comment] = "comment",
  [sym_ADD] = "ADD",
  [sym_AND] = "AND",
  [sym_EQ] = "EQ",
  [sym_AT] = "AT",
  [sym_BNOT] = "BNOT",
  [sym_COLON] = "COLON",
  [sym_COMMA] = "COMMA",
  [sym_CONST] = "CONST",
  [sym_COUNT] = "COUNT",
  [sym_CSP] = "CSP",
  [sym_CSP_ADD] = "CSP_ADD",
  [sym_CSP_SUB] = "CSP_SUB",
  [sym_CSP_MUL] = "CSP_MUL",
  [sym_CSP_LEQ] = "CSP_LEQ",
  [sym_CSP_LT] = "CSP_LT",
  [sym_CSP_GT] = "CSP_GT",
  [sym_CSP_GEQ] = "CSP_GEQ",
  [sym_CSP_EQ] = "CSP_EQ",
  [sym_CSP_NEQ] = "CSP_NEQ",
  [sym_DISJOINT] = "DISJOINT",
  [sym_DOT] = "DOT",
  [sym_DOTS] = "DOTS",
  [sym_EXTERNAL] = "EXTERNAL",
  [sym_DEFINED] = "DEFINED",
  [sym_FALSE] = "FALSE",
  [sym_GEQ] = "GEQ",
  [sym_GT] = "GT",
  [sym_IF] = "IF",
  [sym_INCLUDE] = "INCLUDE",
  [sym_INFIMUM] = "INFIMUM",
  [sym_LBRACE] = "LBRACE",
  [sym_LBRACK] = "LBRACK",
  [sym_LEQ] = "LEQ",
  [sym_LPAREN] = "LPAREN",
  [sym_LT] = "LT",
  [sym_MAX] = "MAX",
  [sym_MAXIMIZE] = "MAXIMIZE",
  [sym_MIN] = "MIN",
  [sym_MINIMIZE] = "MINIMIZE",
  [sym_MOD] = "MOD",
  [sym_MUL] = "MUL",
  [sym_NEQ] = "NEQ",
  [sym_POW] = "POW",
  [sym_QUESTION] = "QUESTION",
  [sym_RBRACE] = "RBRACE",
  [sym_RBRACK] = "RBRACK",
  [sym_RPAREN] = "RPAREN",
  [sym_SEM] = "SEM",
  [sym_SHOW] = "SHOW",
  [sym_EDGE] = "EDGE",
  [sym_PROJECT] = "PROJECT",
  [sym_HEURISTIC] = "HEURISTIC",
  [sym_SHOWSIG] = "SHOWSIG",
  [sym_SLASH] = "SLASH",
  [sym_SUB] = "SUB",
  [sym_SUM] = "SUM",
  [sym_SUMP] = "SUMP",
  [sym_SUPREMUM] = "SUPREMUM",
  [sym_TRUE] = "TRUE",
  [sym_BLOCK] = "BLOCK",
  [sym_VBAR] = "VBAR",
  [sym_WIF] = "WIF",
  [sym_XOR] = "XOR",
  [sym_ANY] = "ANY",
  [sym_UNARY] = "UNARY",
  [sym_BINARY] = "BINARY",
  [sym_LEFT] = "LEFT",
  [sym_RIGHT] = "RIGHT",
  [sym_HEAD] = "HEAD",
  [sym_BODY] = "BODY",
  [sym_DIRECTIVE] = "DIRECTIVE",
  [sym_THEORY] = "THEORY",
  [anon_sym_0] = "0",
  [aux_sym_dec_token1] = "dec_token1",
  [sym_hex] = "hex",
  [sym_oct] = "oct",
  [sym_bin] = "bin",
  [sym_ANONYMOUS] = "ANONYMOUS",
  [sym_identifier] = "identifier",
  [anon_sym_LPAREN] = "LPAREN",
  [sym_SCRIPT] = "SCRIPT",
  [sym_CODE] = "CODE",
  [sym_VARIABLE] = "VARIABLE",
  [sym_THEORY_OP] = "THEORY_OP",
  [sym_NOT] = "NOT",
  [sym_DEFAULT] = "DEFAULT",
  [sym_OVERRIDE] = "OVERRIDE",
  [anon_sym_BSLASH_BSLASH] = "\\\\",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_DQUOTE] = "\"",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_source_file] = "source_file",
  [sym_NUMBER] = "NUMBER",
  [sym_dec] = "dec",
  [sym__widentifier] = "_widentifier",
  [sym_constterm] = "constterm",
  [sym_consttermvec] = "consttermvec",
  [sym_nconstargvec] = "nconstargvec",
  [sym_term] = "term",
  [sym_unaryargvec] = "unaryargvec",
  [sym_ntermvec] = "ntermvec",
  [sym_ntuple] = "ntuple",
  [sym_tuplevec_sem] = "tuplevec_sem",
  [sym_ntuplevec] = "ntuplevec",
  [sym_argvec] = "argvec",
  [sym_binaryargvec] = "binaryargvec",
  [sym_cmp] = "cmp",
  [sym_atom] = "atom",
  [sym_literal] = "literal",
  [sym_csp_mul_term] = "csp_mul_term",
  [sym_csp_add_term] = "csp_add_term",
  [sym_csp_rel] = "csp_rel",
  [sym_csp_literal] = "csp_literal",
  [sym_nlitvec] = "nlitvec",
  [sym_noptcondition] = "noptcondition",
  [sym_aggregatefunction] = "aggregatefunction",
  [sym_bodyaggrelem] = "bodyaggrelem",
  [sym_bodyaggrelemvec] = "bodyaggrelemvec",
  [sym_altbodyaggrelem] = "altbodyaggrelem",
  [sym_altbodyaggrelemvec] = "altbodyaggrelemvec",
  [sym_bodyaggregate] = "bodyaggregate",
  [sym_nupper] = "nupper",
  [sym_lubodyaggregate] = "lubodyaggregate",
  [sym_headaggrelemvec] = "headaggrelemvec",
  [sym_altheadaggrelemvec] = "altheadaggrelemvec",
  [sym_headaggregate] = "headaggregate",
  [sym_luheadaggregate] = "luheadaggregate",
  [sym_ncspelemvec] = "ncspelemvec",
  [sym_disjoint] = "disjoint",
  [sym_conjunction] = "conjunction",
  [sym_dsym] = "dsym",
  [sym_disjunctionsep] = "disjunctionsep",
  [sym_disjunction] = "disjunction",
  [sym_nbodycomma] = "nbodycomma",
  [sym_bodydot] = "bodydot",
  [sym_bodyconddot] = "bodyconddot",
  [sym_head] = "head",
  [sym_statement] = "statement",
  [sym_noptimizetuple] = "noptimizetuple",
  [sym_optimizeweight] = "optimizeweight",
  [sym_optimizelitvec] = "optimizelitvec",
  [sym_noptimizecond] = "noptimizecond",
  [sym_maxelemlist] = "maxelemlist",
  [sym_minelemlist] = "minelemlist",
  [sym_nidlist] = "nidlist",
  [sym_theory_op] = "theory_op",
  [sym_theory_op_list] = "theory_op_list",
  [sym_theory_term] = "theory_term",
  [sym_theory_opterm] = "theory_opterm",
  [sym_theory_opterm_nlist] = "theory_opterm_nlist",
  [sym_theory_atom_element] = "theory_atom_element",
  [sym_theory_atom_element_nlist] = "theory_atom_element_nlist",
  [sym_theory_atom_name] = "theory_atom_name",
  [sym_theory_atom] = "theory_atom",
  [sym_theory_operator_nlist] = "theory_operator_nlist",
  [sym_theory_operator_definition] = "theory_operator_definition",
  [sym_theory_operator_definition_nlist] = "theory_operator_definition_nlist",
  [sym_theory_definition_identifier] = "theory_definition_identifier",
  [sym_theory_term_definition] = "theory_term_definition",
  [sym_theory_atom_type] = "theory_atom_type",
  [sym_theory_atom_definition] = "theory_atom_definition",
  [sym_theory_definition_nlist] = "theory_definition_nlist",
  [sym_STRING] = "STRING",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_STRING_repeat1] = "STRING_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_comment] = sym_comment,
  [sym_ADD] = sym_ADD,
  [sym_AND] = sym_AND,
  [sym_EQ] = sym_EQ,
  [sym_AT] = sym_AT,
  [sym_BNOT] = sym_BNOT,
  [sym_COLON] = sym_COLON,
  [sym_COMMA] = sym_COMMA,
  [sym_CONST] = sym_CONST,
  [sym_COUNT] = sym_COUNT,
  [sym_CSP] = sym_CSP,
  [sym_CSP_ADD] = sym_CSP_ADD,
  [sym_CSP_SUB] = sym_CSP_SUB,
  [sym_CSP_MUL] = sym_CSP_MUL,
  [sym_CSP_LEQ] = sym_CSP_LEQ,
  [sym_CSP_LT] = sym_CSP_LT,
  [sym_CSP_GT] = sym_CSP_GT,
  [sym_CSP_GEQ] = sym_CSP_GEQ,
  [sym_CSP_EQ] = sym_CSP_EQ,
  [sym_CSP_NEQ] = sym_CSP_NEQ,
  [sym_DISJOINT] = sym_DISJOINT,
  [sym_DOT] = sym_DOT,
  [sym_DOTS] = sym_DOTS,
  [sym_EXTERNAL] = sym_EXTERNAL,
  [sym_DEFINED] = sym_DEFINED,
  [sym_FALSE] = sym_FALSE,
  [sym_GEQ] = sym_GEQ,
  [sym_GT] = sym_GT,
  [sym_IF] = sym_IF,
  [sym_INCLUDE] = sym_INCLUDE,
  [sym_INFIMUM] = sym_INFIMUM,
  [sym_LBRACE] = sym_LBRACE,
  [sym_LBRACK] = sym_LBRACK,
  [sym_LEQ] = sym_LEQ,
  [sym_LPAREN] = sym_LPAREN,
  [sym_LT] = sym_LT,
  [sym_MAX] = sym_MAX,
  [sym_MAXIMIZE] = sym_MAXIMIZE,
  [sym_MIN] = sym_MIN,
  [sym_MINIMIZE] = sym_MINIMIZE,
  [sym_MOD] = sym_MOD,
  [sym_MUL] = sym_MUL,
  [sym_NEQ] = sym_NEQ,
  [sym_POW] = sym_POW,
  [sym_QUESTION] = sym_QUESTION,
  [sym_RBRACE] = sym_RBRACE,
  [sym_RBRACK] = sym_RBRACK,
  [sym_RPAREN] = sym_RPAREN,
  [sym_SEM] = sym_SEM,
  [sym_SHOW] = sym_SHOW,
  [sym_EDGE] = sym_EDGE,
  [sym_PROJECT] = sym_PROJECT,
  [sym_HEURISTIC] = sym_HEURISTIC,
  [sym_SHOWSIG] = sym_SHOWSIG,
  [sym_SLASH] = sym_SLASH,
  [sym_SUB] = sym_SUB,
  [sym_SUM] = sym_SUM,
  [sym_SUMP] = sym_SUMP,
  [sym_SUPREMUM] = sym_SUPREMUM,
  [sym_TRUE] = sym_TRUE,
  [sym_BLOCK] = sym_BLOCK,
  [sym_VBAR] = sym_VBAR,
  [sym_WIF] = sym_WIF,
  [sym_XOR] = sym_XOR,
  [sym_ANY] = sym_ANY,
  [sym_UNARY] = sym_UNARY,
  [sym_BINARY] = sym_BINARY,
  [sym_LEFT] = sym_LEFT,
  [sym_RIGHT] = sym_RIGHT,
  [sym_HEAD] = sym_HEAD,
  [sym_BODY] = sym_BODY,
  [sym_DIRECTIVE] = sym_DIRECTIVE,
  [sym_THEORY] = sym_THEORY,
  [anon_sym_0] = anon_sym_0,
  [aux_sym_dec_token1] = aux_sym_dec_token1,
  [sym_hex] = sym_hex,
  [sym_oct] = sym_oct,
  [sym_bin] = sym_bin,
  [sym_ANONYMOUS] = sym_ANONYMOUS,
  [sym_identifier] = sym_identifier,
  [anon_sym_LPAREN] = sym_LPAREN,
  [sym_SCRIPT] = sym_SCRIPT,
  [sym_CODE] = sym_CODE,
  [sym_VARIABLE] = sym_VARIABLE,
  [sym_THEORY_OP] = sym_THEORY_OP,
  [sym_NOT] = sym_NOT,
  [sym_DEFAULT] = sym_DEFAULT,
  [sym_OVERRIDE] = sym_OVERRIDE,
  [anon_sym_BSLASH_BSLASH] = anon_sym_BSLASH_BSLASH,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_source_file] = sym_source_file,
  [sym_NUMBER] = sym_NUMBER,
  [sym_dec] = sym_dec,
  [sym__widentifier] = sym__widentifier,
  [sym_constterm] = sym_constterm,
  [sym_consttermvec] = sym_consttermvec,
  [sym_nconstargvec] = sym_nconstargvec,
  [sym_term] = sym_term,
  [sym_unaryargvec] = sym_unaryargvec,
  [sym_ntermvec] = sym_ntermvec,
  [sym_ntuple] = sym_ntuple,
  [sym_tuplevec_sem] = sym_tuplevec_sem,
  [sym_ntuplevec] = sym_ntuplevec,
  [sym_argvec] = sym_argvec,
  [sym_binaryargvec] = sym_binaryargvec,
  [sym_cmp] = sym_cmp,
  [sym_atom] = sym_atom,
  [sym_literal] = sym_literal,
  [sym_csp_mul_term] = sym_csp_mul_term,
  [sym_csp_add_term] = sym_csp_add_term,
  [sym_csp_rel] = sym_csp_rel,
  [sym_csp_literal] = sym_csp_literal,
  [sym_nlitvec] = sym_nlitvec,
  [sym_noptcondition] = sym_noptcondition,
  [sym_aggregatefunction] = sym_aggregatefunction,
  [sym_bodyaggrelem] = sym_bodyaggrelem,
  [sym_bodyaggrelemvec] = sym_bodyaggrelemvec,
  [sym_altbodyaggrelem] = sym_altbodyaggrelem,
  [sym_altbodyaggrelemvec] = sym_altbodyaggrelemvec,
  [sym_bodyaggregate] = sym_bodyaggregate,
  [sym_nupper] = sym_nupper,
  [sym_lubodyaggregate] = sym_lubodyaggregate,
  [sym_headaggrelemvec] = sym_headaggrelemvec,
  [sym_altheadaggrelemvec] = sym_altheadaggrelemvec,
  [sym_headaggregate] = sym_headaggregate,
  [sym_luheadaggregate] = sym_luheadaggregate,
  [sym_ncspelemvec] = sym_ncspelemvec,
  [sym_disjoint] = sym_disjoint,
  [sym_conjunction] = sym_conjunction,
  [sym_dsym] = sym_dsym,
  [sym_disjunctionsep] = sym_disjunctionsep,
  [sym_disjunction] = sym_disjunction,
  [sym_nbodycomma] = sym_nbodycomma,
  [sym_bodydot] = sym_bodydot,
  [sym_bodyconddot] = sym_bodyconddot,
  [sym_head] = sym_head,
  [sym_statement] = sym_statement,
  [sym_noptimizetuple] = sym_noptimizetuple,
  [sym_optimizeweight] = sym_optimizeweight,
  [sym_optimizelitvec] = sym_optimizelitvec,
  [sym_noptimizecond] = sym_noptimizecond,
  [sym_maxelemlist] = sym_maxelemlist,
  [sym_minelemlist] = sym_minelemlist,
  [sym_nidlist] = sym_nidlist,
  [sym_theory_op] = sym_theory_op,
  [sym_theory_op_list] = sym_theory_op_list,
  [sym_theory_term] = sym_theory_term,
  [sym_theory_opterm] = sym_theory_opterm,
  [sym_theory_opterm_nlist] = sym_theory_opterm_nlist,
  [sym_theory_atom_element] = sym_theory_atom_element,
  [sym_theory_atom_element_nlist] = sym_theory_atom_element_nlist,
  [sym_theory_atom_name] = sym_theory_atom_name,
  [sym_theory_atom] = sym_theory_atom,
  [sym_theory_operator_nlist] = sym_theory_operator_nlist,
  [sym_theory_operator_definition] = sym_theory_operator_definition,
  [sym_theory_operator_definition_nlist] = sym_theory_operator_definition_nlist,
  [sym_theory_definition_identifier] = sym_theory_definition_identifier,
  [sym_theory_term_definition] = sym_theory_term_definition,
  [sym_theory_atom_type] = sym_theory_atom_type,
  [sym_theory_atom_definition] = sym_theory_atom_definition,
  [sym_theory_definition_nlist] = sym_theory_definition_nlist,
  [sym_STRING] = sym_STRING,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_STRING_repeat1] = aux_sym_STRING_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_ADD] = {
    .visible = true,
    .named = true,
  },
  [sym_AND] = {
    .visible = true,
    .named = true,
  },
  [sym_EQ] = {
    .visible = true,
    .named = true,
  },
  [sym_AT] = {
    .visible = true,
    .named = true,
  },
  [sym_BNOT] = {
    .visible = true,
    .named = true,
  },
  [sym_COLON] = {
    .visible = true,
    .named = true,
  },
  [sym_COMMA] = {
    .visible = true,
    .named = true,
  },
  [sym_CONST] = {
    .visible = true,
    .named = true,
  },
  [sym_COUNT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_ADD] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_SUB] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_MUL] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_LEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_LT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_GT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_GEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_EQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_NEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_DISJOINT] = {
    .visible = true,
    .named = true,
  },
  [sym_DOT] = {
    .visible = true,
    .named = true,
  },
  [sym_DOTS] = {
    .visible = true,
    .named = true,
  },
  [sym_EXTERNAL] = {
    .visible = true,
    .named = true,
  },
  [sym_DEFINED] = {
    .visible = true,
    .named = true,
  },
  [sym_FALSE] = {
    .visible = true,
    .named = true,
  },
  [sym_GEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_GT] = {
    .visible = true,
    .named = true,
  },
  [sym_IF] = {
    .visible = true,
    .named = true,
  },
  [sym_INCLUDE] = {
    .visible = true,
    .named = true,
  },
  [sym_INFIMUM] = {
    .visible = true,
    .named = true,
  },
  [sym_LBRACE] = {
    .visible = true,
    .named = true,
  },
  [sym_LBRACK] = {
    .visible = true,
    .named = true,
  },
  [sym_LEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_LPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_LT] = {
    .visible = true,
    .named = true,
  },
  [sym_MAX] = {
    .visible = true,
    .named = true,
  },
  [sym_MAXIMIZE] = {
    .visible = true,
    .named = true,
  },
  [sym_MIN] = {
    .visible = true,
    .named = true,
  },
  [sym_MINIMIZE] = {
    .visible = true,
    .named = true,
  },
  [sym_MOD] = {
    .visible = true,
    .named = true,
  },
  [sym_MUL] = {
    .visible = true,
    .named = true,
  },
  [sym_NEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_POW] = {
    .visible = true,
    .named = true,
  },
  [sym_QUESTION] = {
    .visible = true,
    .named = true,
  },
  [sym_RBRACE] = {
    .visible = true,
    .named = true,
  },
  [sym_RBRACK] = {
    .visible = true,
    .named = true,
  },
  [sym_RPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_SEM] = {
    .visible = true,
    .named = true,
  },
  [sym_SHOW] = {
    .visible = true,
    .named = true,
  },
  [sym_EDGE] = {
    .visible = true,
    .named = true,
  },
  [sym_PROJECT] = {
    .visible = true,
    .named = true,
  },
  [sym_HEURISTIC] = {
    .visible = true,
    .named = true,
  },
  [sym_SHOWSIG] = {
    .visible = true,
    .named = true,
  },
  [sym_SLASH] = {
    .visible = true,
    .named = true,
  },
  [sym_SUB] = {
    .visible = true,
    .named = true,
  },
  [sym_SUM] = {
    .visible = true,
    .named = true,
  },
  [sym_SUMP] = {
    .visible = true,
    .named = true,
  },
  [sym_SUPREMUM] = {
    .visible = true,
    .named = true,
  },
  [sym_TRUE] = {
    .visible = true,
    .named = true,
  },
  [sym_BLOCK] = {
    .visible = true,
    .named = true,
  },
  [sym_VBAR] = {
    .visible = true,
    .named = true,
  },
  [sym_WIF] = {
    .visible = true,
    .named = true,
  },
  [sym_XOR] = {
    .visible = true,
    .named = true,
  },
  [sym_ANY] = {
    .visible = true,
    .named = true,
  },
  [sym_UNARY] = {
    .visible = true,
    .named = true,
  },
  [sym_BINARY] = {
    .visible = true,
    .named = true,
  },
  [sym_LEFT] = {
    .visible = true,
    .named = true,
  },
  [sym_RIGHT] = {
    .visible = true,
    .named = true,
  },
  [sym_HEAD] = {
    .visible = true,
    .named = true,
  },
  [sym_BODY] = {
    .visible = true,
    .named = true,
  },
  [sym_DIRECTIVE] = {
    .visible = true,
    .named = true,
  },
  [sym_THEORY] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_dec_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_hex] = {
    .visible = true,
    .named = true,
  },
  [sym_oct] = {
    .visible = true,
    .named = true,
  },
  [sym_bin] = {
    .visible = true,
    .named = true,
  },
  [sym_ANONYMOUS] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_SCRIPT] = {
    .visible = true,
    .named = true,
  },
  [sym_CODE] = {
    .visible = true,
    .named = true,
  },
  [sym_VARIABLE] = {
    .visible = true,
    .named = true,
  },
  [sym_THEORY_OP] = {
    .visible = true,
    .named = true,
  },
  [sym_NOT] = {
    .visible = true,
    .named = true,
  },
  [sym_DEFAULT] = {
    .visible = true,
    .named = true,
  },
  [sym_OVERRIDE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_NUMBER] = {
    .visible = true,
    .named = true,
  },
  [sym_dec] = {
    .visible = true,
    .named = true,
  },
  [sym__widentifier] = {
    .visible = false,
    .named = true,
  },
  [sym_constterm] = {
    .visible = true,
    .named = true,
  },
  [sym_consttermvec] = {
    .visible = true,
    .named = true,
  },
  [sym_nconstargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_term] = {
    .visible = true,
    .named = true,
  },
  [sym_unaryargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_ntermvec] = {
    .visible = true,
    .named = true,
  },
  [sym_ntuple] = {
    .visible = true,
    .named = true,
  },
  [sym_tuplevec_sem] = {
    .visible = true,
    .named = true,
  },
  [sym_ntuplevec] = {
    .visible = true,
    .named = true,
  },
  [sym_argvec] = {
    .visible = true,
    .named = true,
  },
  [sym_binaryargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_cmp] = {
    .visible = true,
    .named = true,
  },
  [sym_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_mul_term] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_add_term] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_rel] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_nlitvec] = {
    .visible = true,
    .named = true,
  },
  [sym_noptcondition] = {
    .visible = true,
    .named = true,
  },
  [sym_aggregatefunction] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggrelem] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_altbodyaggrelem] = {
    .visible = true,
    .named = true,
  },
  [sym_altbodyaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_nupper] = {
    .visible = true,
    .named = true,
  },
  [sym_lubodyaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_headaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_altheadaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_headaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_luheadaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_ncspelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_disjoint] = {
    .visible = true,
    .named = true,
  },
  [sym_conjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_dsym] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunctionsep] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_nbodycomma] = {
    .visible = true,
    .named = true,
  },
  [sym_bodydot] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyconddot] = {
    .visible = true,
    .named = true,
  },
  [sym_head] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_noptimizetuple] = {
    .visible = true,
    .named = true,
  },
  [sym_optimizeweight] = {
    .visible = true,
    .named = true,
  },
  [sym_optimizelitvec] = {
    .visible = true,
    .named = true,
  },
  [sym_noptimizecond] = {
    .visible = true,
    .named = true,
  },
  [sym_maxelemlist] = {
    .visible = true,
    .named = true,
  },
  [sym_minelemlist] = {
    .visible = true,
    .named = true,
  },
  [sym_nidlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_op] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_op_list] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_term] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_opterm] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_opterm_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_element] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_element_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_name] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_definition_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_definition_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_term_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_type] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_definition_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_STRING] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_STRING_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_THEORY_OP_character_set_1(int32_t c) {
  return (c < ';'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '-' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static inline bool sym_THEORY_OP_character_set_2(int32_t c) {
  return (c < ':'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '-' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static inline bool sym_THEORY_OP_character_set_3(int32_t c) {
  return (c < ':'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '.' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(205);
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(84);
      if (lookahead == '$') ADVANCE(238);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(361);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(232);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == '\\') ADVANCE(274);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'a') ADVANCE(339);
      if (lookahead == 'b') ADVANCE(337);
      if (lookahead == 'd') ADVANCE(322);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(327);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == 'o') ADVANCE(354);
      if (lookahead == 'r') ADVANCE(334);
      if (lookahead == 'u') ADVANCE(340);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(203)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(88);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(231);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '\\') ADVANCE(274);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == '$') ADVANCE(237);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(249);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(71);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '\\') ADVANCE(273);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(361);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(231);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(77);
      if (lookahead == 'a') ADVANCE(339);
      if (lookahead == 'b') ADVANCE(337);
      if (lookahead == 'd') ADVANCE(333);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(327);
      if (lookahead == 'r') ADVANCE(334);
      if (lookahead == 'u') ADVANCE(340);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(361);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(232);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == 'd') ADVANCE(107);
      if (lookahead == 'o') ADVANCE(187);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(231);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(77);
      if (lookahead == 'a') ADVANCE(339);
      if (lookahead == 'b') ADVANCE(337);
      if (lookahead == 'd') ADVANCE(333);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(327);
      if (lookahead == 'r') ADVANCE(334);
      if (lookahead == 'u') ADVANCE(340);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '#') ADVANCE(89);
      if (lookahead == '$') ADVANCE(7);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == ':') ADVANCE(232);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == 'd') ADVANCE(107);
      if (lookahead == 'o') ADVANCE(187);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '*') ADVANCE(241);
      if (lookahead == '+') ADVANCE(239);
      if (lookahead == '-') ADVANCE(240);
      if (lookahead == '<') ADVANCE(243);
      if (lookahead == '=') ADVANCE(246);
      if (lookahead == '>') ADVANCE(244);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '_') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(371);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 9:
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(233);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == '_') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '!' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(371);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '\\') ADVANCE(180);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(382);
      if (lookahead != 0) ADVANCE(386);
      END_STATE();
    case 11:
      if (lookahead == '#') ADVANCE(31);
      if (lookahead == '%') ADVANCE(221);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(11);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '#') ADVANCE(31);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '%') ADVANCE(220);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 14:
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(33);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '%') ADVANCE(222);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 17:
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 18:
      if (lookahead == '#') ADVANCE(49);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 19:
      if (lookahead == '#') ADVANCE(50);
      if (lookahead == '%') ADVANCE(223);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 20:
      if (lookahead == '#') ADVANCE(50);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 21:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 22:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 23:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(25);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 24:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 25:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == 'd') ADVANCE(365);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 26:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(366);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 27:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 28:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'e') ADVANCE(28);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 29:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'e') ADVANCE(28);
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 30:
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(17);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 31:
      if (lookahead == '#') ADVANCE(37);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 32:
      if (lookahead == '#') ADVANCE(40);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 33:
      if (lookahead == '#') ADVANCE(22);
      if (lookahead == 'e') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0 &&
          lookahead != 'd') ADVANCE(15);
      END_STATE();
    case 34:
      if (lookahead == '#') ADVANCE(28);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == 'd') ADVANCE(70);
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 35:
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 36:
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 37:
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 38:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 39:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 40:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 41:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 42:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 43:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(59);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 44:
      if (lookahead == '#') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 45:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 46:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 47:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(61);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 48:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 49:
      if (lookahead == '#') ADVANCE(44);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 50:
      if (lookahead == '#') ADVANCE(48);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 51:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 52:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(54);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 53:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 54:
      if (lookahead == '#') ADVANCE(35);
      if (lookahead == 'd') ADVANCE(363);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 55:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 56:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(58);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 57:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(14);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 58:
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(364);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 59:
      if (lookahead == '#') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(367);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 60:
      if (lookahead == '#') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 61:
      if (lookahead == '#') ADVANCE(45);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(368);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 62:
      if (lookahead == '#') ADVANCE(45);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == 'd') ADVANCE(20);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 63:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(361);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(249);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(273);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      END_STATE();
    case 64:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(249);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(273);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      END_STATE();
    case 65:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(65)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          (':' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(371);
      END_STATE();
    case 66:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '.') ADVANCE(251);
      if (lookahead == ';') ADVANCE(283);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(66)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          (':' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(371);
      END_STATE();
    case 67:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == ':') ADVANCE(233);
      if (lookahead == ';') ADVANCE(283);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(67)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          ('<' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(371);
      END_STATE();
    case 68:
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '.') ADVANCE(251);
      if (lookahead == ':') ADVANCE(370);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(68)
      if (sym_THEORY_OP_character_set_1(lookahead)) ADVANCE(371);
      END_STATE();
    case 69:
      if (lookahead == '%') ADVANCE(206);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 70:
      if (lookahead == '*') ADVANCE(69);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 71:
      if (lookahead == '-') ADVANCE(258);
      END_STATE();
    case 72:
      if (lookahead == '-') ADVANCE(258);
      if (lookahead == '~') ADVANCE(297);
      END_STATE();
    case 73:
      if (lookahead == '=') ADVANCE(276);
      END_STATE();
    case 74:
      if (lookahead == '=') ADVANCE(247);
      END_STATE();
    case 75:
      if (lookahead == '\\') ADVANCE(378);
      END_STATE();
    case 76:
      if (lookahead == '_') ADVANCE(76);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 77:
      if (lookahead == '_') ADVANCE(77);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 78:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(189);
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(190);
      if (lookahead == 'i') ADVANCE(140);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(135);
      END_STATE();
    case 82:
      if (lookahead == 'a') ADVANCE(129);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 84:
      if (lookahead == 'c') ADVANCE(147);
      if (lookahead == 'd') ADVANCE(95);
      if (lookahead == 'e') ADVANCE(91);
      if (lookahead == 'f') ADVANCE(78);
      if (lookahead == 'h') ADVANCE(96);
      if (lookahead == 'i') ADVANCE(138);
      if (lookahead == 'm') ADVANCE(79);
      if (lookahead == 'p') ADVANCE(157);
      if (lookahead == 's') ADVANCE(86);
      if (lookahead == 't') ADVANCE(116);
      END_STATE();
    case 85:
      if (lookahead == 'c') ADVANCE(287);
      END_STATE();
    case 86:
      if (lookahead == 'c') ADVANCE(160);
      if (lookahead == 'h') ADVANCE(149);
      if (lookahead == 'u') ADVANCE(134);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(131);
      if (lookahead == 'f') ADVANCE(261);
      END_STATE();
    case 88:
      if (lookahead == 'c') ADVANCE(151);
      if (lookahead == 'd') ADVANCE(117);
      if (lookahead == 'f') ADVANCE(78);
      if (lookahead == 'i') ADVANCE(141);
      if (lookahead == 'm') ADVANCE(80);
      if (lookahead == 's') ADVANCE(178);
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 89:
      if (lookahead == 'c') ADVANCE(151);
      if (lookahead == 'm') ADVANCE(80);
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 90:
      if (lookahead == 'c') ADVANCE(172);
      END_STATE();
    case 91:
      if (lookahead == 'd') ADVANCE(114);
      if (lookahead == 'x') ADVANCE(176);
      END_STATE();
    case 92:
      if (lookahead == 'd') ADVANCE(254);
      END_STATE();
    case 93:
      if (lookahead == 'd') ADVANCE(101);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(104);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(110);
      if (lookahead == 'i') ADVANCE(165);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(285);
      END_STATE();
    case 98:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(255);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(260);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(269);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(272);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(376);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(112);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 110:
      if (lookahead == 'f') ADVANCE(122);
      END_STATE();
    case 111:
      if (lookahead == 'f') ADVANCE(261);
      END_STATE();
    case 112:
      if (lookahead == 'f') ADVANCE(83);
      END_STATE();
    case 113:
      if (lookahead == 'g') ADVANCE(288);
      END_STATE();
    case 114:
      if (lookahead == 'g') ADVANCE(97);
      END_STATE();
    case 115:
      if (lookahead == 'g') ADVANCE(158);
      if (lookahead == 'j') ADVANCE(100);
      END_STATE();
    case 116:
      if (lookahead == 'h') ADVANCE(108);
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 117:
      if (lookahead == 'i') ADVANCE(165);
      END_STATE();
    case 118:
      if (lookahead == 'i') ADVANCE(155);
      END_STATE();
    case 119:
      if (lookahead == 'i') ADVANCE(192);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(113);
      END_STATE();
    case 121:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 122:
      if (lookahead == 'i') ADVANCE(145);
      END_STATE();
    case 123:
      if (lookahead == 'i') ADVANCE(141);
      if (lookahead == 's') ADVANCE(181);
      END_STATE();
    case 124:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 125:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 126:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 127:
      if (lookahead == 'i') ADVANCE(144);
      END_STATE();
    case 128:
      if (lookahead == 'j') ADVANCE(153);
      END_STATE();
    case 129:
      if (lookahead == 'l') ADVANCE(253);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(168);
      END_STATE();
    case 131:
      if (lookahead == 'l') ADVANCE(179);
      END_STATE();
    case 132:
      if (lookahead == 'l') ADVANCE(174);
      END_STATE();
    case 133:
      if (lookahead == 'm') ADVANCE(291);
      END_STATE();
    case 134:
      if (lookahead == 'm') ADVANCE(291);
      if (lookahead == 'p') ADVANCE(293);
      END_STATE();
    case 135:
      if (lookahead == 'm') ADVANCE(295);
      END_STATE();
    case 136:
      if (lookahead == 'm') ADVANCE(119);
      END_STATE();
    case 137:
      if (lookahead == 'm') ADVANCE(125);
      END_STATE();
    case 138:
      if (lookahead == 'n') ADVANCE(87);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(271);
      END_STATE();
    case 140:
      if (lookahead == 'n') ADVANCE(270);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(111);
      END_STATE();
    case 142:
      if (lookahead == 'n') ADVANCE(166);
      if (lookahead == 'u') ADVANCE(143);
      END_STATE();
    case 143:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 144:
      if (lookahead == 'n') ADVANCE(173);
      END_STATE();
    case 145:
      if (lookahead == 'n') ADVANCE(105);
      END_STATE();
    case 146:
      if (lookahead == 'n') ADVANCE(82);
      END_STATE();
    case 147:
      if (lookahead == 'o') ADVANCE(142);
      END_STATE();
    case 148:
      if (lookahead == 'o') ADVANCE(115);
      END_STATE();
    case 149:
      if (lookahead == 'o') ADVANCE(188);
      END_STATE();
    case 150:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 151:
      if (lookahead == 'o') ADVANCE(182);
      END_STATE();
    case 152:
      if (lookahead == 'o') ADVANCE(175);
      END_STATE();
    case 153:
      if (lookahead == 'o') ADVANCE(127);
      END_STATE();
    case 154:
      if (lookahead == 'p') ADVANCE(293);
      END_STATE();
    case 155:
      if (lookahead == 'p') ADVANCE(171);
      END_STATE();
    case 156:
      if (lookahead == 'r') ADVANCE(191);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 158:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 159:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 160:
      if (lookahead == 'r') ADVANCE(118);
      END_STATE();
    case 161:
      if (lookahead == 'r') ADVANCE(126);
      END_STATE();
    case 162:
      if (lookahead == 'r') ADVANCE(146);
      END_STATE();
    case 163:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(163);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(128);
      END_STATE();
    case 166:
      if (lookahead == 's') ADVANCE(169);
      END_STATE();
    case 167:
      if (lookahead == 's') ADVANCE(177);
      END_STATE();
    case 168:
      if (lookahead == 's') ADVANCE(99);
      END_STATE();
    case 169:
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 170:
      if (lookahead == 't') ADVANCE(236);
      END_STATE();
    case 171:
      if (lookahead == 't') ADVANCE(362);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(286);
      END_STATE();
    case 173:
      if (lookahead == 't') ADVANCE(248);
      END_STATE();
    case 174:
      if (lookahead == 't') ADVANCE(374);
      END_STATE();
    case 175:
      if (lookahead == 't') ADVANCE(372);
      END_STATE();
    case 176:
      if (lookahead == 't') ADVANCE(106);
      END_STATE();
    case 177:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 178:
      if (lookahead == 'u') ADVANCE(134);
      END_STATE();
    case 179:
      if (lookahead == 'u') ADVANCE(93);
      END_STATE();
    case 180:
      if (lookahead == 'u') ADVANCE(194);
      if (lookahead == 'x') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(389);
      if (lookahead != 0) ADVANCE(387);
      END_STATE();
    case 181:
      if (lookahead == 'u') ADVANCE(154);
      END_STATE();
    case 182:
      if (lookahead == 'u') ADVANCE(143);
      END_STATE();
    case 183:
      if (lookahead == 'u') ADVANCE(133);
      END_STATE();
    case 184:
      if (lookahead == 'u') ADVANCE(132);
      END_STATE();
    case 185:
      if (lookahead == 'u') ADVANCE(98);
      END_STATE();
    case 186:
      if (lookahead == 'u') ADVANCE(161);
      END_STATE();
    case 187:
      if (lookahead == 'v') ADVANCE(109);
      END_STATE();
    case 188:
      if (lookahead == 'w') ADVANCE(284);
      END_STATE();
    case 189:
      if (lookahead == 'x') ADVANCE(268);
      END_STATE();
    case 190:
      if (lookahead == 'x') ADVANCE(267);
      END_STATE();
    case 191:
      if (lookahead == 'y') ADVANCE(307);
      END_STATE();
    case 192:
      if (lookahead == 'z') ADVANCE(102);
      END_STATE();
    case 193:
      if (lookahead == 'z') ADVANCE(103);
      END_STATE();
    case 194:
      if (lookahead == '{') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(201);
      END_STATE();
    case 195:
      if (lookahead == '}') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(195);
      END_STATE();
    case 196:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(312);
      END_STATE();
    case 197:
      if (('1' <= lookahead && lookahead <= '7')) ADVANCE(311);
      END_STATE();
    case 198:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(310);
      END_STATE();
    case 199:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(387);
      END_STATE();
    case 200:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(195);
      END_STATE();
    case 201:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 202:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(199);
      END_STATE();
    case 203:
      if (eof) ADVANCE(205);
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(84);
      if (lookahead == '$') ADVANCE(238);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(232);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == '\\') ADVANCE(274);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'a') ADVANCE(339);
      if (lookahead == 'b') ADVANCE(337);
      if (lookahead == 'd') ADVANCE(322);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(327);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == 'o') ADVANCE(354);
      if (lookahead == 'r') ADVANCE(334);
      if (lookahead == 'u') ADVANCE(340);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(203)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '\'' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 204:
      if (eof) ADVANCE(205);
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '#') ADVANCE(84);
      if (lookahead == '$') ADVANCE(237);
      if (lookahead == '%') ADVANCE(224);
      if (lookahead == '&') ADVANCE(227);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(281);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '+') ADVANCE(226);
      if (lookahead == ',') ADVANCE(234);
      if (lookahead == '-') ADVANCE(290);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '0') ADVANCE(308);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(282);
      if (lookahead == '<') ADVANCE(266);
      if (lookahead == '=') ADVANCE(228);
      if (lookahead == '>') ADVANCE(257);
      if (lookahead == '?') ADVANCE(278);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(263);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == ']') ADVANCE(280);
      if (lookahead == '^') ADVANCE(298);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'n') ADVANCE(342);
      if (lookahead == '{') ADVANCE(262);
      if (lookahead == '|') ADVANCE(296);
      if (lookahead == '}') ADVANCE(279);
      if (lookahead == '~') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(204)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(309);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == 'd') ADVANCE(209);
      if (lookahead == 'e') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == 'd') ADVANCE(209);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(211);
      if (lookahead == 'd') ADVANCE(209);
      if (lookahead == 'e') ADVANCE(217);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(12);
      if (lookahead == '#') ADVANCE(211);
      if (lookahead == 'd') ADVANCE(209);
      if (lookahead == 'e') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(213);
      if (lookahead == 'd') ADVANCE(225);
      if (lookahead == 'e') ADVANCE(213);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(213);
      if (lookahead == 'd') ADVANCE(215);
      if (lookahead == 'e') ADVANCE(213);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(213);
      if (lookahead == 'd') ADVANCE(215);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(15);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(217);
      if (lookahead == 'd') ADVANCE(219);
      if (lookahead == 'e') ADVANCE(217);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(217);
      if (lookahead == 'd') ADVANCE(219);
      if (lookahead == 'e') ADVANCE(217);
      if (lookahead == 'n') ADVANCE(218);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(216);
      if (lookahead == 'd') ADVANCE(219);
      if (lookahead == 'n') ADVANCE(218);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '#') ADVANCE(216);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(31);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '*') ADVANCE(14);
      if (lookahead != 0) ADVANCE(209);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(49);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead != 0) ADVANCE(225);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(225);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_ADD);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_AND);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_EQ);
      if (lookahead == '=') ADVANCE(379);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_AT);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_BNOT);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_COLON);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_COLON);
      if (lookahead == '-') ADVANCE(258);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_COLON);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_COMMA);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_CONST);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_COUNT);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_CSP);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_CSP);
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '*') ADVANCE(241);
      if (lookahead == '+') ADVANCE(239);
      if (lookahead == '<') ADVANCE(243);
      if (lookahead == '=') ADVANCE(246);
      if (lookahead == '>') ADVANCE(244);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_CSP_ADD);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_CSP_SUB);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_CSP_MUL);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_CSP_LEQ);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_CSP_LT);
      if (lookahead == '=') ADVANCE(242);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_CSP_GT);
      if (lookahead == '=') ADVANCE(245);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_CSP_GEQ);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_CSP_EQ);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_CSP_NEQ);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_DISJOINT);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_DOT);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_DOT);
      if (lookahead == '.') ADVANCE(252);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_DOT);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_DOTS);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_EXTERNAL);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_DEFINED);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_FALSE);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_GEQ);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_GT);
      if (lookahead == '=') ADVANCE(256);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_IF);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_IF);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_INCLUDE);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_INFIMUM);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_LBRACE);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_LBRACK);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_LEQ);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_LPAREN);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_LT);
      if (lookahead == '=') ADVANCE(264);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_MAX);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_MAX);
      if (lookahead == 'i') ADVANCE(136);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_MAXIMIZE);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_MIN);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_MIN);
      if (lookahead == 'i') ADVANCE(137);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_MINIMIZE);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_MOD);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_MOD);
      if (lookahead == '\\') ADVANCE(378);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_MUL);
      if (lookahead == '*') ADVANCE(277);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_NEQ);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_POW);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_QUESTION);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_RBRACE);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_RBRACK);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_RPAREN);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_SEM);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_SEM);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_SHOW);
      if (lookahead == 's') ADVANCE(120);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_EDGE);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_PROJECT);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_HEURISTIC);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_SHOWSIG);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_SLASH);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_SUB);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_SUM);
      if (lookahead == '+') ADVANCE(292);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_SUMP);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_SUPREMUM);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_TRUE);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_BLOCK);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_VBAR);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_WIF);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_XOR);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_ANY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_UNARY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_BINARY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_LEFT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_RIGHT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_HEAD);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_BODY);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_DIRECTIVE);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_THEORY);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == 'b') ADVANCE(196);
      if (lookahead == 'o') ADVANCE(197);
      if (lookahead == 'x') ADVANCE(198);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(aux_sym_dec_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(309);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_hex);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(310);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_oct);
      if (('1' <= lookahead && lookahead <= '7')) ADVANCE(311);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_bin);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(312);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_ANONYMOUS);
      if (lookahead == '_') ADVANCE(76);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(369);
      if (lookahead == '\'' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(353);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(319);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(346);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(352);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(304);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(357);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(325);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(330);
      if (lookahead == 'i') ADVANCE(345);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(315);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(318);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(377);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(306);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(329);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(347);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(349);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(314);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'g') ADVANCE(332);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(350);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(345);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(331);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(321);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(355);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(341);
      if (lookahead == 'o') ADVANCE(320);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(351);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(356);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(316);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(317);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(348);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(335);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(358);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(324);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(359);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(343);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(373);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(302);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(303);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(375);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(336);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(338);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(328);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(326);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(299);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(305);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(300);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(301);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_SCRIPT);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(31);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(49);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(50);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_VARIABLE);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(369);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_THEORY_OP);
      if (lookahead == '-') ADVANCE(259);
      if (sym_THEORY_OP_character_set_3(lookahead)) ADVANCE(371);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_THEORY_OP);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(371);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_NOT);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_NOT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_DEFAULT);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_DEFAULT);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_OVERRIDE);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_OVERRIDE);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_BSLASH_BSLASH);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(386);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(381);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(382);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(386);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '*') ADVANCE(383);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(384);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(383);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(384);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(384);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(381);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(386);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(387);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(388);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 204},
  [2] = {.lex_state = 204},
  [3] = {.lex_state = 204},
  [4] = {.lex_state = 204},
  [5] = {.lex_state = 204},
  [6] = {.lex_state = 204},
  [7] = {.lex_state = 204},
  [8] = {.lex_state = 204},
  [9] = {.lex_state = 204},
  [10] = {.lex_state = 204},
  [11] = {.lex_state = 204},
  [12] = {.lex_state = 204},
  [13] = {.lex_state = 204},
  [14] = {.lex_state = 204},
  [15] = {.lex_state = 204},
  [16] = {.lex_state = 204},
  [17] = {.lex_state = 204},
  [18] = {.lex_state = 204},
  [19] = {.lex_state = 204},
  [20] = {.lex_state = 204},
  [21] = {.lex_state = 204},
  [22] = {.lex_state = 204},
  [23] = {.lex_state = 204},
  [24] = {.lex_state = 204},
  [25] = {.lex_state = 204},
  [26] = {.lex_state = 204},
  [27] = {.lex_state = 204},
  [28] = {.lex_state = 204},
  [29] = {.lex_state = 3},
  [30] = {.lex_state = 1},
  [31] = {.lex_state = 1},
  [32] = {.lex_state = 3},
  [33] = {.lex_state = 1},
  [34] = {.lex_state = 1},
  [35] = {.lex_state = 3},
  [36] = {.lex_state = 3},
  [37] = {.lex_state = 3},
  [38] = {.lex_state = 3},
  [39] = {.lex_state = 3},
  [40] = {.lex_state = 3},
  [41] = {.lex_state = 3},
  [42] = {.lex_state = 3},
  [43] = {.lex_state = 3},
  [44] = {.lex_state = 3},
  [45] = {.lex_state = 3},
  [46] = {.lex_state = 3},
  [47] = {.lex_state = 4},
  [48] = {.lex_state = 4},
  [49] = {.lex_state = 4},
  [50] = {.lex_state = 4},
  [51] = {.lex_state = 3},
  [52] = {.lex_state = 3},
  [53] = {.lex_state = 3},
  [54] = {.lex_state = 3},
  [55] = {.lex_state = 204},
  [56] = {.lex_state = 204},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 3},
  [60] = {.lex_state = 3},
  [61] = {.lex_state = 204},
  [62] = {.lex_state = 204},
  [63] = {.lex_state = 204},
  [64] = {.lex_state = 204},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 204},
  [67] = {.lex_state = 204},
  [68] = {.lex_state = 204},
  [69] = {.lex_state = 204},
  [70] = {.lex_state = 204},
  [71] = {.lex_state = 1},
  [72] = {.lex_state = 1},
  [73] = {.lex_state = 2},
  [74] = {.lex_state = 204},
  [75] = {.lex_state = 2},
  [76] = {.lex_state = 2},
  [77] = {.lex_state = 204},
  [78] = {.lex_state = 204},
  [79] = {.lex_state = 204},
  [80] = {.lex_state = 204},
  [81] = {.lex_state = 204},
  [82] = {.lex_state = 204},
  [83] = {.lex_state = 204},
  [84] = {.lex_state = 204},
  [85] = {.lex_state = 204},
  [86] = {.lex_state = 1},
  [87] = {.lex_state = 1},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 1},
  [90] = {.lex_state = 204},
  [91] = {.lex_state = 204},
  [92] = {.lex_state = 1},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 204},
  [95] = {.lex_state = 204},
  [96] = {.lex_state = 3},
  [97] = {.lex_state = 9},
  [98] = {.lex_state = 3},
  [99] = {.lex_state = 9},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 4},
  [102] = {.lex_state = 4},
  [103] = {.lex_state = 204},
  [104] = {.lex_state = 1},
  [105] = {.lex_state = 1},
  [106] = {.lex_state = 1},
  [107] = {.lex_state = 204},
  [108] = {.lex_state = 204},
  [109] = {.lex_state = 4},
  [110] = {.lex_state = 4},
  [111] = {.lex_state = 1},
  [112] = {.lex_state = 1},
  [113] = {.lex_state = 2},
  [114] = {.lex_state = 9},
  [115] = {.lex_state = 4},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 4},
  [118] = {.lex_state = 2},
  [119] = {.lex_state = 204},
  [120] = {.lex_state = 204},
  [121] = {.lex_state = 1},
  [122] = {.lex_state = 4},
  [123] = {.lex_state = 4},
  [124] = {.lex_state = 4},
  [125] = {.lex_state = 4},
  [126] = {.lex_state = 4},
  [127] = {.lex_state = 4},
  [128] = {.lex_state = 204},
  [129] = {.lex_state = 4},
  [130] = {.lex_state = 2},
  [131] = {.lex_state = 4},
  [132] = {.lex_state = 4},
  [133] = {.lex_state = 4},
  [134] = {.lex_state = 1},
  [135] = {.lex_state = 4},
  [136] = {.lex_state = 4},
  [137] = {.lex_state = 4},
  [138] = {.lex_state = 4},
  [139] = {.lex_state = 1},
  [140] = {.lex_state = 8},
  [141] = {.lex_state = 2},
  [142] = {.lex_state = 8},
  [143] = {.lex_state = 8},
  [144] = {.lex_state = 1},
  [145] = {.lex_state = 8},
  [146] = {.lex_state = 2},
  [147] = {.lex_state = 8},
  [148] = {.lex_state = 8},
  [149] = {.lex_state = 3},
  [150] = {.lex_state = 1},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 8},
  [153] = {.lex_state = 2},
  [154] = {.lex_state = 1},
  [155] = {.lex_state = 2},
  [156] = {.lex_state = 2},
  [157] = {.lex_state = 3},
  [158] = {.lex_state = 1},
  [159] = {.lex_state = 8},
  [160] = {.lex_state = 8},
  [161] = {.lex_state = 8},
  [162] = {.lex_state = 1},
  [163] = {.lex_state = 8},
  [164] = {.lex_state = 4},
  [165] = {.lex_state = 1},
  [166] = {.lex_state = 2},
  [167] = {.lex_state = 1},
  [168] = {.lex_state = 8},
  [169] = {.lex_state = 2},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 1},
  [172] = {.lex_state = 8},
  [173] = {.lex_state = 1},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 8},
  [176] = {.lex_state = 8},
  [177] = {.lex_state = 8},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 2},
  [180] = {.lex_state = 8},
  [181] = {.lex_state = 8},
  [182] = {.lex_state = 3},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 2},
  [185] = {.lex_state = 2},
  [186] = {.lex_state = 8},
  [187] = {.lex_state = 1},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 1},
  [190] = {.lex_state = 8},
  [191] = {.lex_state = 2},
  [192] = {.lex_state = 3},
  [193] = {.lex_state = 1},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 8},
  [197] = {.lex_state = 8},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 1},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 8},
  [209] = {.lex_state = 8},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 8},
  [212] = {.lex_state = 8},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 1},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 8},
  [259] = {.lex_state = 204},
  [260] = {.lex_state = 204},
  [261] = {.lex_state = 8},
  [262] = {.lex_state = 8},
  [263] = {.lex_state = 1},
  [264] = {.lex_state = 8},
  [265] = {.lex_state = 204},
  [266] = {.lex_state = 8},
  [267] = {.lex_state = 204},
  [268] = {.lex_state = 8},
  [269] = {.lex_state = 8},
  [270] = {.lex_state = 8},
  [271] = {.lex_state = 204},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 1},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 1},
  [282] = {.lex_state = 204},
  [283] = {.lex_state = 204},
  [284] = {.lex_state = 204},
  [285] = {.lex_state = 1},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 204},
  [288] = {.lex_state = 1},
  [289] = {.lex_state = 8},
  [290] = {.lex_state = 1},
  [291] = {.lex_state = 2},
  [292] = {.lex_state = 3},
  [293] = {.lex_state = 4},
  [294] = {.lex_state = 4},
  [295] = {.lex_state = 3},
  [296] = {.lex_state = 3},
  [297] = {.lex_state = 4},
  [298] = {.lex_state = 3},
  [299] = {.lex_state = 8},
  [300] = {.lex_state = 3},
  [301] = {.lex_state = 3},
  [302] = {.lex_state = 3},
  [303] = {.lex_state = 4},
  [304] = {.lex_state = 4},
  [305] = {.lex_state = 3},
  [306] = {.lex_state = 8},
  [307] = {.lex_state = 63},
  [308] = {.lex_state = 3},
  [309] = {.lex_state = 63},
  [310] = {.lex_state = 4},
  [311] = {.lex_state = 2},
  [312] = {.lex_state = 2},
  [313] = {.lex_state = 3},
  [314] = {.lex_state = 3},
  [315] = {.lex_state = 2},
  [316] = {.lex_state = 2},
  [317] = {.lex_state = 2},
  [318] = {.lex_state = 2},
  [319] = {.lex_state = 2},
  [320] = {.lex_state = 4},
  [321] = {.lex_state = 2},
  [322] = {.lex_state = 3},
  [323] = {.lex_state = 2},
  [324] = {.lex_state = 2},
  [325] = {.lex_state = 2},
  [326] = {.lex_state = 204},
  [327] = {.lex_state = 204},
  [328] = {.lex_state = 3},
  [329] = {.lex_state = 204},
  [330] = {.lex_state = 204},
  [331] = {.lex_state = 204},
  [332] = {.lex_state = 3},
  [333] = {.lex_state = 204},
  [334] = {.lex_state = 204},
  [335] = {.lex_state = 3},
  [336] = {.lex_state = 204},
  [337] = {.lex_state = 3},
  [338] = {.lex_state = 204},
  [339] = {.lex_state = 204},
  [340] = {.lex_state = 204},
  [341] = {.lex_state = 2},
  [342] = {.lex_state = 204},
  [343] = {.lex_state = 204},
  [344] = {.lex_state = 204},
  [345] = {.lex_state = 3},
  [346] = {.lex_state = 204},
  [347] = {.lex_state = 204},
  [348] = {.lex_state = 2},
  [349] = {.lex_state = 2},
  [350] = {.lex_state = 3},
  [351] = {.lex_state = 3},
  [352] = {.lex_state = 3},
  [353] = {.lex_state = 3},
  [354] = {.lex_state = 2},
  [355] = {.lex_state = 3},
  [356] = {.lex_state = 3},
  [357] = {.lex_state = 3},
  [358] = {.lex_state = 65},
  [359] = {.lex_state = 65},
  [360] = {.lex_state = 67},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 67},
  [363] = {.lex_state = 66},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 65},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 67},
  [373] = {.lex_state = 66},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 67},
  [379] = {.lex_state = 67},
  [380] = {.lex_state = 65},
  [381] = {.lex_state = 66},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 65},
  [384] = {.lex_state = 67},
  [385] = {.lex_state = 65},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 67},
  [388] = {.lex_state = 3},
  [389] = {.lex_state = 3},
  [390] = {.lex_state = 67},
  [391] = {.lex_state = 3},
  [392] = {.lex_state = 66},
  [393] = {.lex_state = 67},
  [394] = {.lex_state = 65},
  [395] = {.lex_state = 65},
  [396] = {.lex_state = 65},
  [397] = {.lex_state = 3},
  [398] = {.lex_state = 68},
  [399] = {.lex_state = 65},
  [400] = {.lex_state = 3},
  [401] = {.lex_state = 65},
  [402] = {.lex_state = 65},
  [403] = {.lex_state = 65},
  [404] = {.lex_state = 65},
  [405] = {.lex_state = 65},
  [406] = {.lex_state = 67},
  [407] = {.lex_state = 65},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 4},
  [410] = {.lex_state = 65},
  [411] = {.lex_state = 67},
  [412] = {.lex_state = 67},
  [413] = {.lex_state = 65},
  [414] = {.lex_state = 68},
  [415] = {.lex_state = 3},
  [416] = {.lex_state = 67},
  [417] = {.lex_state = 3},
  [418] = {.lex_state = 66},
  [419] = {.lex_state = 65},
  [420] = {.lex_state = 0},
  [421] = {.lex_state = 65},
  [422] = {.lex_state = 67},
  [423] = {.lex_state = 67},
  [424] = {.lex_state = 3},
  [425] = {.lex_state = 66},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 3},
  [428] = {.lex_state = 0},
  [429] = {.lex_state = 3},
  [430] = {.lex_state = 66},
  [431] = {.lex_state = 3},
  [432] = {.lex_state = 0},
  [433] = {.lex_state = 68},
  [434] = {.lex_state = 66},
  [435] = {.lex_state = 66},
  [436] = {.lex_state = 66},
  [437] = {.lex_state = 3},
  [438] = {.lex_state = 66},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 66},
  [441] = {.lex_state = 3},
  [442] = {.lex_state = 68},
  [443] = {.lex_state = 66},
  [444] = {.lex_state = 66},
  [445] = {.lex_state = 66},
  [446] = {.lex_state = 3},
  [447] = {.lex_state = 3},
  [448] = {.lex_state = 65},
  [449] = {.lex_state = 68},
  [450] = {.lex_state = 66},
  [451] = {.lex_state = 66},
  [452] = {.lex_state = 3},
  [453] = {.lex_state = 68},
  [454] = {.lex_state = 3},
  [455] = {.lex_state = 1},
  [456] = {.lex_state = 3},
  [457] = {.lex_state = 1},
  [458] = {.lex_state = 3},
  [459] = {.lex_state = 3},
  [460] = {.lex_state = 1},
  [461] = {.lex_state = 3},
  [462] = {.lex_state = 3},
  [463] = {.lex_state = 3},
  [464] = {.lex_state = 0},
  [465] = {.lex_state = 68},
  [466] = {.lex_state = 68},
  [467] = {.lex_state = 68},
  [468] = {.lex_state = 68},
  [469] = {.lex_state = 68},
  [470] = {.lex_state = 68},
  [471] = {.lex_state = 10},
  [472] = {.lex_state = 68},
  [473] = {.lex_state = 68},
  [474] = {.lex_state = 68},
  [475] = {.lex_state = 68},
  [476] = {.lex_state = 68},
  [477] = {.lex_state = 65},
  [478] = {.lex_state = 3},
  [479] = {.lex_state = 3},
  [480] = {.lex_state = 3},
  [481] = {.lex_state = 3},
  [482] = {.lex_state = 10},
  [483] = {.lex_state = 3},
  [484] = {.lex_state = 10},
  [485] = {.lex_state = 10},
  [486] = {.lex_state = 10},
  [487] = {.lex_state = 10},
  [488] = {.lex_state = 3},
  [489] = {.lex_state = 10},
  [490] = {.lex_state = 3},
  [491] = {.lex_state = 3},
  [492] = {.lex_state = 10},
  [493] = {.lex_state = 10},
  [494] = {.lex_state = 10},
  [495] = {.lex_state = 10},
  [496] = {.lex_state = 10},
  [497] = {.lex_state = 10},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 1},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 0},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 0},
  [509] = {.lex_state = 3},
  [510] = {.lex_state = 0},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 3},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 3},
  [516] = {.lex_state = 3},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 3},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 65},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 2},
  [529] = {.lex_state = 1},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 1},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 1},
  [548] = {.lex_state = 0},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 4},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 204},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 3},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 3},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 3},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 1},
  [607] = {.lex_state = 3},
  [608] = {.lex_state = 3},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 1},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 1},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 1},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 1},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 3},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 1},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 11},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 204},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 1},
  [672] = {.lex_state = 1},
  [673] = {.lex_state = 1},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 1},
  [677] = {.lex_state = 204},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 204},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 1},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 3},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 3},
  [686] = {.lex_state = 3},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 1},
  [695] = {.lex_state = 204},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_ADD] = ACTIONS(1),
    [sym_AND] = ACTIONS(1),
    [sym_EQ] = ACTIONS(1),
    [sym_AT] = ACTIONS(1),
    [sym_BNOT] = ACTIONS(1),
    [sym_COLON] = ACTIONS(1),
    [sym_COMMA] = ACTIONS(1),
    [sym_CONST] = ACTIONS(1),
    [sym_COUNT] = ACTIONS(1),
    [sym_CSP] = ACTIONS(1),
    [sym_CSP_ADD] = ACTIONS(1),
    [sym_CSP_MUL] = ACTIONS(1),
    [sym_CSP_LEQ] = ACTIONS(1),
    [sym_CSP_LT] = ACTIONS(1),
    [sym_CSP_GT] = ACTIONS(1),
    [sym_CSP_GEQ] = ACTIONS(1),
    [sym_CSP_EQ] = ACTIONS(1),
    [sym_CSP_NEQ] = ACTIONS(1),
    [sym_DISJOINT] = ACTIONS(1),
    [sym_DOT] = ACTIONS(1),
    [sym_DOTS] = ACTIONS(1),
    [sym_EXTERNAL] = ACTIONS(1),
    [sym_DEFINED] = ACTIONS(1),
    [sym_FALSE] = ACTIONS(1),
    [sym_GEQ] = ACTIONS(1),
    [sym_GT] = ACTIONS(1),
    [sym_IF] = ACTIONS(1),
    [sym_INCLUDE] = ACTIONS(1),
    [sym_INFIMUM] = ACTIONS(1),
    [sym_LBRACE] = ACTIONS(1),
    [sym_LBRACK] = ACTIONS(1),
    [sym_LEQ] = ACTIONS(1),
    [sym_LPAREN] = ACTIONS(1),
    [sym_LT] = ACTIONS(1),
    [sym_MAX] = ACTIONS(1),
    [sym_MAXIMIZE] = ACTIONS(1),
    [sym_MIN] = ACTIONS(1),
    [sym_MINIMIZE] = ACTIONS(1),
    [sym_MOD] = ACTIONS(1),
    [sym_MUL] = ACTIONS(1),
    [sym_NEQ] = ACTIONS(1),
    [sym_POW] = ACTIONS(1),
    [sym_QUESTION] = ACTIONS(1),
    [sym_RBRACE] = ACTIONS(1),
    [sym_RBRACK] = ACTIONS(1),
    [sym_RPAREN] = ACTIONS(1),
    [sym_SEM] = ACTIONS(1),
    [sym_SHOW] = ACTIONS(1),
    [sym_EDGE] = ACTIONS(1),
    [sym_PROJECT] = ACTIONS(1),
    [sym_HEURISTIC] = ACTIONS(1),
    [sym_SHOWSIG] = ACTIONS(1),
    [sym_SLASH] = ACTIONS(1),
    [sym_SUB] = ACTIONS(1),
    [sym_SUM] = ACTIONS(1),
    [sym_SUMP] = ACTIONS(1),
    [sym_SUPREMUM] = ACTIONS(1),
    [sym_TRUE] = ACTIONS(1),
    [sym_BLOCK] = ACTIONS(1),
    [sym_VBAR] = ACTIONS(1),
    [sym_XOR] = ACTIONS(1),
    [sym_ANY] = ACTIONS(1),
    [sym_UNARY] = ACTIONS(1),
    [sym_BINARY] = ACTIONS(1),
    [sym_LEFT] = ACTIONS(1),
    [sym_RIGHT] = ACTIONS(1),
    [sym_HEAD] = ACTIONS(1),
    [sym_BODY] = ACTIONS(1),
    [sym_DIRECTIVE] = ACTIONS(1),
    [sym_THEORY] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [aux_sym_dec_token1] = ACTIONS(1),
    [sym_hex] = ACTIONS(1),
    [sym_oct] = ACTIONS(1),
    [sym_bin] = ACTIONS(1),
    [sym_ANONYMOUS] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [sym_SCRIPT] = ACTIONS(1),
    [sym_VARIABLE] = ACTIONS(1),
    [sym_NOT] = ACTIONS(1),
    [sym_DEFAULT] = ACTIONS(1),
    [sym_OVERRIDE] = ACTIONS(1),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(666),
    [sym_NUMBER] = STATE(43),
    [sym_dec] = STATE(31),
    [sym__widentifier] = STATE(167),
    [sym_term] = STATE(59),
    [sym_atom] = STATE(374),
    [sym_literal] = STATE(369),
    [sym_csp_mul_term] = STATE(304),
    [sym_csp_add_term] = STATE(356),
    [sym_csp_literal] = STATE(320),
    [sym_aggregatefunction] = STATE(669),
    [sym_headaggregate] = STATE(73),
    [sym_luheadaggregate] = STATE(598),
    [sym_disjoint] = STATE(570),
    [sym_disjunctionsep] = STATE(78),
    [sym_disjunction] = STATE(598),
    [sym_head] = STATE(570),
    [sym_statement] = STATE(2),
    [sym_theory_atom] = STATE(556),
    [sym_STRING] = STATE(43),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(7),
    [sym_AT] = ACTIONS(9),
    [sym_BNOT] = ACTIONS(11),
    [sym_CONST] = ACTIONS(13),
    [sym_COUNT] = ACTIONS(15),
    [sym_CSP] = ACTIONS(17),
    [sym_DISJOINT] = ACTIONS(19),
    [sym_EXTERNAL] = ACTIONS(21),
    [sym_DEFINED] = ACTIONS(23),
    [sym_FALSE] = ACTIONS(25),
    [sym_IF] = ACTIONS(27),
    [sym_INCLUDE] = ACTIONS(29),
    [sym_INFIMUM] = ACTIONS(31),
    [sym_LBRACE] = ACTIONS(33),
    [sym_LPAREN] = ACTIONS(35),
    [sym_MAX] = ACTIONS(37),
    [sym_MAXIMIZE] = ACTIONS(39),
    [sym_MIN] = ACTIONS(37),
    [sym_MINIMIZE] = ACTIONS(41),
    [sym_SHOW] = ACTIONS(43),
    [sym_EDGE] = ACTIONS(45),
    [sym_PROJECT] = ACTIONS(47),
    [sym_HEURISTIC] = ACTIONS(49),
    [sym_SHOWSIG] = ACTIONS(51),
    [sym_SUB] = ACTIONS(53),
    [sym_SUM] = ACTIONS(37),
    [sym_SUMP] = ACTIONS(15),
    [sym_SUPREMUM] = ACTIONS(31),
    [sym_TRUE] = ACTIONS(25),
    [sym_BLOCK] = ACTIONS(55),
    [sym_VBAR] = ACTIONS(57),
    [sym_WIF] = ACTIONS(59),
    [sym_THEORY] = ACTIONS(61),
    [anon_sym_0] = ACTIONS(63),
    [aux_sym_dec_token1] = ACTIONS(65),
    [sym_hex] = ACTIONS(67),
    [sym_oct] = ACTIONS(67),
    [sym_bin] = ACTIONS(67),
    [sym_ANONYMOUS] = ACTIONS(69),
    [sym_identifier] = ACTIONS(71),
    [sym_SCRIPT] = ACTIONS(73),
    [sym_VARIABLE] = ACTIONS(31),
    [sym_NOT] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
  },
  [2] = {
    [sym_NUMBER] = STATE(43),
    [sym_dec] = STATE(31),
    [sym__widentifier] = STATE(167),
    [sym_term] = STATE(59),
    [sym_atom] = STATE(374),
    [sym_literal] = STATE(369),
    [sym_csp_mul_term] = STATE(304),
    [sym_csp_add_term] = STATE(356),
    [sym_csp_literal] = STATE(320),
    [sym_aggregatefunction] = STATE(669),
    [sym_headaggregate] = STATE(73),
    [sym_luheadaggregate] = STATE(598),
    [sym_disjoint] = STATE(570),
    [sym_disjunctionsep] = STATE(78),
    [sym_disjunction] = STATE(598),
    [sym_head] = STATE(570),
    [sym_statement] = STATE(3),
    [sym_theory_atom] = STATE(556),
    [sym_STRING] = STATE(43),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(7),
    [sym_AT] = ACTIONS(9),
    [sym_BNOT] = ACTIONS(11),
    [sym_CONST] = ACTIONS(13),
    [sym_COUNT] = ACTIONS(15),
    [sym_CSP] = ACTIONS(17),
    [sym_DISJOINT] = ACTIONS(19),
    [sym_EXTERNAL] = ACTIONS(21),
    [sym_DEFINED] = ACTIONS(23),
    [sym_FALSE] = ACTIONS(25),
    [sym_IF] = ACTIONS(27),
    [sym_INCLUDE] = ACTIONS(29),
    [sym_INFIMUM] = ACTIONS(31),
    [sym_LBRACE] = ACTIONS(33),
    [sym_LPAREN] = ACTIONS(35),
    [sym_MAX] = ACTIONS(37),
    [sym_MAXIMIZE] = ACTIONS(39),
    [sym_MIN] = ACTIONS(37),
    [sym_MINIMIZE] = ACTIONS(41),
    [sym_SHOW] = ACTIONS(43),
    [sym_EDGE] = ACTIONS(45),
    [sym_PROJECT] = ACTIONS(47),
    [sym_HEURISTIC] = ACTIONS(49),
    [sym_SHOWSIG] = ACTIONS(51),
    [sym_SUB] = ACTIONS(53),
    [sym_SUM] = ACTIONS(37),
    [sym_SUMP] = ACTIONS(15),
    [sym_SUPREMUM] = ACTIONS(31),
    [sym_TRUE] = ACTIONS(25),
    [sym_BLOCK] = ACTIONS(55),
    [sym_VBAR] = ACTIONS(57),
    [sym_WIF] = ACTIONS(59),
    [sym_THEORY] = ACTIONS(61),
    [anon_sym_0] = ACTIONS(63),
    [aux_sym_dec_token1] = ACTIONS(65),
    [sym_hex] = ACTIONS(67),
    [sym_oct] = ACTIONS(67),
    [sym_bin] = ACTIONS(67),
    [sym_ANONYMOUS] = ACTIONS(69),
    [sym_identifier] = ACTIONS(71),
    [sym_SCRIPT] = ACTIONS(73),
    [sym_VARIABLE] = ACTIONS(31),
    [sym_NOT] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
  },
  [3] = {
    [sym_NUMBER] = STATE(43),
    [sym_dec] = STATE(31),
    [sym__widentifier] = STATE(167),
    [sym_term] = STATE(59),
    [sym_atom] = STATE(374),
    [sym_literal] = STATE(369),
    [sym_csp_mul_term] = STATE(304),
    [sym_csp_add_term] = STATE(356),
    [sym_csp_literal] = STATE(320),
    [sym_aggregatefunction] = STATE(669),
    [sym_headaggregate] = STATE(73),
    [sym_luheadaggregate] = STATE(598),
    [sym_disjoint] = STATE(570),
    [sym_disjunctionsep] = STATE(78),
    [sym_disjunction] = STATE(598),
    [sym_head] = STATE(570),
    [sym_statement] = STATE(3),
    [sym_theory_atom] = STATE(556),
    [sym_STRING] = STATE(43),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(83),
    [sym_AT] = ACTIONS(86),
    [sym_BNOT] = ACTIONS(89),
    [sym_CONST] = ACTIONS(92),
    [sym_COUNT] = ACTIONS(95),
    [sym_CSP] = ACTIONS(98),
    [sym_DISJOINT] = ACTIONS(101),
    [sym_EXTERNAL] = ACTIONS(104),
    [sym_DEFINED] = ACTIONS(107),
    [sym_FALSE] = ACTIONS(110),
    [sym_IF] = ACTIONS(113),
    [sym_INCLUDE] = ACTIONS(116),
    [sym_INFIMUM] = ACTIONS(119),
    [sym_LBRACE] = ACTIONS(122),
    [sym_LPAREN] = ACTIONS(125),
    [sym_MAX] = ACTIONS(128),
    [sym_MAXIMIZE] = ACTIONS(131),
    [sym_MIN] = ACTIONS(128),
    [sym_MINIMIZE] = ACTIONS(134),
    [sym_SHOW] = ACTIONS(137),
    [sym_EDGE] = ACTIONS(140),
    [sym_PROJECT] = ACTIONS(143),
    [sym_HEURISTIC] = ACTIONS(146),
    [sym_SHOWSIG] = ACTIONS(149),
    [sym_SUB] = ACTIONS(152),
    [sym_SUM] = ACTIONS(128),
    [sym_SUMP] = ACTIONS(95),
    [sym_SUPREMUM] = ACTIONS(119),
    [sym_TRUE] = ACTIONS(110),
    [sym_BLOCK] = ACTIONS(155),
    [sym_VBAR] = ACTIONS(158),
    [sym_WIF] = ACTIONS(161),
    [sym_THEORY] = ACTIONS(164),
    [anon_sym_0] = ACTIONS(167),
    [aux_sym_dec_token1] = ACTIONS(170),
    [sym_hex] = ACTIONS(173),
    [sym_oct] = ACTIONS(173),
    [sym_bin] = ACTIONS(173),
    [sym_ANONYMOUS] = ACTIONS(176),
    [sym_identifier] = ACTIONS(179),
    [sym_SCRIPT] = ACTIONS(182),
    [sym_VARIABLE] = ACTIONS(119),
    [sym_NOT] = ACTIONS(185),
    [anon_sym_DQUOTE] = ACTIONS(188),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(193), 1,
      sym_DOT,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    STATE(25), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(31), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(481), 1,
      sym_literal,
    STATE(524), 1,
      sym_theory_atom,
    STATE(533), 1,
      sym_lubodyaggregate,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(544), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [125] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    ACTIONS(205), 1,
      sym_DOT,
    STATE(15), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(31), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(481), 1,
      sym_literal,
    STATE(524), 1,
      sym_theory_atom,
    STATE(533), 1,
      sym_lubodyaggregate,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(544), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [250] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    ACTIONS(207), 1,
      sym_DOT,
    STATE(12), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(31), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(481), 1,
      sym_literal,
    STATE(524), 1,
      sym_theory_atom,
    STATE(533), 1,
      sym_lubodyaggregate,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(544), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [375] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    ACTIONS(209), 1,
      sym_DOT,
    STATE(27), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(31), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(481), 1,
      sym_literal,
    STATE(524), 1,
      sym_theory_atom,
    STATE(533), 1,
      sym_lubodyaggregate,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(544), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [500] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(211), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [554] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(215), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [608] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      sym_LBRACK,
    ACTIONS(223), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(219), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [664] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(225), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [718] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(229), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [772] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    STATE(20), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(31), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(481), 1,
      sym_literal,
    STATE(524), 1,
      sym_theory_atom,
    STATE(533), 1,
      sym_lubodyaggregate,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(544), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(235), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(233), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [948] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym_LBRACK,
    ACTIONS(241), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(237), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1004] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(245), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(243), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1058] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(31), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(481), 1,
      sym_literal,
    STATE(524), 1,
      sym_theory_atom,
    STATE(533), 1,
      sym_lubodyaggregate,
    STATE(663), 1,
      sym_bodydot,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(544), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [1180] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_NOT,
    STATE(23), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(31), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(481), 1,
      sym_literal,
    STATE(524), 1,
      sym_theory_atom,
    STATE(533), 1,
      sym_lubodyaggregate,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(544), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [1302] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      sym_LBRACK,
    ACTIONS(251), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(247), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1358] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(237), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1411] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(253), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(259), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(257), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1517] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(247), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1570] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(263), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(261), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1623] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(223), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(219), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1676] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(267), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(265), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1729] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(271), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(269), 37,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [1782] = 35,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(273), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(60), 1,
      sym_term,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(454), 1,
      sym_literal,
    STATE(519), 1,
      sym_lubodyaggregate,
    STATE(524), 1,
      sym_theory_atom,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(576), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [1898] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(277), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(275), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [1950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(281), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2000] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(285), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2050] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(289), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2102] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(295), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(293), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2152] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(299), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(297), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2202] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(289), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2251] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(303), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 31,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(309), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2353] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2402] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(291), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_SUM,
    ACTIONS(289), 24,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SUMP,
      sym_VBAR,
      anon_sym_EQ_EQ,
  [2467] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(303), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 32,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2518] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(303), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_SUM,
    ACTIONS(301), 24,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SUMP,
      sym_VBAR,
      anon_sym_EQ_EQ,
  [2583] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(303), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 27,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2642] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(275), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2691] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2740] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(303), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 30,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2795] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(303), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 29,
      sym_ADD,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2852] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(325), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(327), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(277), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(275), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2906] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(329), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(331), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(277), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(275), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2960] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(335), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(303), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3011] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(339), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(303), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3062] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(329), 1,
      sym_DOT,
    ACTIONS(331), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(277), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(275), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3114] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(325), 1,
      sym_DOT,
    ACTIONS(327), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(277), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(275), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3166] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 1,
      sym_DOT,
    ACTIONS(335), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(303), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3215] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 1,
      sym_DOT,
    ACTIONS(339), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(303), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(301), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3264] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(341), 1,
      sym_DISJOINT,
    ACTIONS(345), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(103), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(437), 1,
      sym_atom,
    STATE(519), 1,
      sym_lubodyaggregate,
    STATE(524), 1,
      sym_theory_atom,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(343), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3361] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(341), 1,
      sym_DISJOINT,
    ACTIONS(347), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(103), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(437), 1,
      sym_atom,
    STATE(501), 1,
      sym_lubodyaggregate,
    STATE(524), 1,
      sym_theory_atom,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(343), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3458] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(349), 1,
      sym_DISJOINT,
    ACTIONS(353), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(107), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(452), 1,
      sym_atom,
    STATE(498), 1,
      sym_lubodyaggregate,
    STATE(524), 1,
      sym_theory_atom,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(351), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3552] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_AND,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(349), 1,
      sym_DISJOINT,
    ACTIONS(353), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(72), 1,
      sym_bodyaggregate,
    STATE(107), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(452), 1,
      sym_atom,
    STATE(501), 1,
      sym_lubodyaggregate,
    STATE(524), 1,
      sym_theory_atom,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(351), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3646] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      sym_LBRACE,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    STATE(76), 1,
      sym_headaggregate,
    STATE(88), 1,
      sym_cmp,
    STATE(669), 1,
      sym_aggregatefunction,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(357), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [3723] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    STATE(65), 1,
      sym_bodyaggregate,
    STATE(89), 1,
      sym_cmp,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(357), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [3800] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(367), 1,
      sym_SEM,
    ACTIONS(369), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(98), 1,
      sym_term,
    STATE(167), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(320), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(382), 1,
      sym_literal,
    STATE(420), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(365), 2,
      sym_DOT,
      sym_IF,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [3892] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(369), 1,
      sym_NOT,
    ACTIONS(373), 1,
      sym_SEM,
    STATE(31), 1,
      sym_dec,
    STATE(98), 1,
      sym_term,
    STATE(167), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(320), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(382), 1,
      sym_literal,
    STATE(386), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(371), 2,
      sym_DOT,
      sym_IF,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [3984] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(167), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(345), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(382), 1,
      sym_literal,
    STATE(520), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(375), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4073] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(167), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(345), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(507), 1,
      sym_literal,
    STATE(508), 1,
      sym_optimizelitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(379), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4162] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(227), 1,
      sym_cmp,
    STATE(327), 1,
      sym_term,
    STATE(503), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(381), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [4239] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(167), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(345), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(382), 1,
      sym_literal,
    STATE(504), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(385), 2,
      sym_DOT,
      sym_SEM,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4328] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(167), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(345), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(382), 1,
      sym_literal,
    STATE(505), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(371), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4417] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(387), 1,
      sym_RBRACE,
    ACTIONS(389), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(480), 1,
      sym_literal,
    STATE(625), 1,
      sym_altbodyaggrelemvec,
    STATE(627), 1,
      sym_altbodyaggrelem,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4508] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(167), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(345), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(382), 1,
      sym_literal,
    STATE(499), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(391), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4597] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(389), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(480), 1,
      sym_literal,
    STATE(604), 1,
      sym_altbodyaggrelem,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(393), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4686] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(227), 1,
      sym_cmp,
    STATE(327), 1,
      sym_term,
    STATE(522), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(395), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [4763] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(227), 1,
      sym_cmp,
    STATE(327), 1,
      sym_term,
    STATE(530), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(397), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [4840] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(127), 1,
      sym_dec,
    STATE(194), 1,
      sym__widentifier,
    STATE(245), 1,
      sym_cmp,
    STATE(329), 1,
      sym_term,
    STATE(603), 1,
      sym_nupper,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(403), 2,
      sym_DOT,
      sym_IF,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [4916] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(389), 1,
      sym_NOT,
    ACTIONS(423), 1,
      sym_RBRACE,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(490), 1,
      sym_literal,
    STATE(552), 1,
      sym_altheadaggrelemvec,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5004] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(127), 1,
      sym_dec,
    STATE(194), 1,
      sym__widentifier,
    STATE(245), 1,
      sym_cmp,
    STATE(329), 1,
      sym_term,
    STATE(624), 1,
      sym_nupper,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(425), 2,
      sym_DOT,
      sym_IF,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [5080] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(127), 1,
      sym_dec,
    STATE(194), 1,
      sym__widentifier,
    STATE(245), 1,
      sym_cmp,
    STATE(329), 1,
      sym_term,
    STATE(572), 1,
      sym_nupper,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(427), 2,
      sym_DOT,
      sym_IF,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [5156] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(389), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(479), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5238] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(369), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(98), 1,
      sym_term,
    STATE(167), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(320), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(361), 1,
      sym_literal,
    STATE(374), 1,
      sym_atom,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5320] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(369), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(98), 1,
      sym_term,
    STATE(167), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(320), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(408), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5402] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(389), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(456), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5484] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(167), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(345), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(408), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5566] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(389), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(491), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5648] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(167), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(345), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(374), 1,
      sym_atom,
    STATE(527), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5730] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(389), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(459), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5812] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(389), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(96), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(429), 1,
      sym_atom,
    STATE(478), 1,
      sym_literal,
    ACTIONS(195), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5894] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(71), 1,
      sym_bodyaggregate,
    STATE(187), 1,
      sym__widentifier,
    STATE(305), 1,
      sym_term,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [5967] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(71), 1,
      sym_bodyaggregate,
    STATE(187), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_term,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [6040] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      sym_LBRACE,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(75), 1,
      sym_headaggregate,
    STATE(127), 1,
      sym_dec,
    STATE(194), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    STATE(669), 1,
      sym_aggregatefunction,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [6113] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(71), 1,
      sym_bodyaggregate,
    STATE(187), 1,
      sym__widentifier,
    STATE(302), 1,
      sym_term,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [6186] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(431), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(429), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [6222] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(433), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [6258] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(437), 1,
      sym_COMMA,
    ACTIONS(439), 1,
      sym_RPAREN,
    ACTIONS(441), 1,
      sym_SEM,
    STATE(31), 1,
      sym_dec,
    STATE(134), 1,
      sym_tuplevec_sem,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(531), 1,
      sym_ntermvec,
    STATE(574), 1,
      sym_ntuple,
    STATE(693), 1,
      sym_ntuplevec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6334] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(437), 1,
      sym_COMMA,
    ACTIONS(441), 1,
      sym_SEM,
    ACTIONS(443), 1,
      sym_RPAREN,
    STATE(31), 1,
      sym_dec,
    STATE(134), 1,
      sym_tuplevec_sem,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(531), 1,
      sym_ntermvec,
    STATE(574), 1,
      sym_ntuple,
    STATE(654), 1,
      sym_ntuplevec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6410] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(445), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [6446] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(449), 23,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [6482] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    STATE(246), 1,
      sym_cmp,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(357), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [6541] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      sym_COLON,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(463), 1,
      sym_RBRACE,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    STATE(266), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(362), 1,
      sym_theory_opterm,
    STATE(406), 1,
      sym_theory_term,
    STATE(411), 1,
      sym_dec,
    STATE(447), 1,
      sym_theory_opterm_nlist,
    STATE(614), 1,
      sym_theory_atom_element,
    STATE(616), 1,
      sym_theory_atom_element_nlist,
    ACTIONS(473), 2,
      sym_THEORY_OP,
      sym_NOT,
    STATE(379), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6614] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    STATE(229), 1,
      sym_cmp,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(357), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [6673] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      sym_COLON,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    ACTIONS(477), 1,
      sym_RBRACE,
    STATE(266), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(362), 1,
      sym_theory_opterm,
    STATE(406), 1,
      sym_theory_term,
    STATE(411), 1,
      sym_dec,
    STATE(447), 1,
      sym_theory_opterm_nlist,
    STATE(614), 1,
      sym_theory_atom_element,
    STATE(638), 1,
      sym_theory_atom_element_nlist,
    ACTIONS(473), 2,
      sym_THEORY_OP,
      sym_NOT,
    STATE(379), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6746] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(479), 1,
      sym_COLON,
    ACTIONS(481), 1,
      sym_RBRACE,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(441), 1,
      sym_ntermvec,
    STATE(549), 1,
      sym_bodyaggrelem,
    STATE(551), 1,
      sym_bodyaggrelemvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6816] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(277), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(275), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [6852] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(291), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(289), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [6888] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    STATE(65), 1,
      sym_bodyaggregate,
    STATE(86), 1,
      sym_cmp,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [6950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(485), 21,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [6984] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(487), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(489), 21,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [7018] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(491), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(493), 21,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [7052] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(197), 1,
      sym_LBRACE,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    STATE(65), 1,
      sym_bodyaggregate,
    STATE(87), 1,
      sym_cmp,
    STATE(670), 1,
      sym_aggregatefunction,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [7114] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(341), 1,
      sym_DISJOINT,
    ACTIONS(497), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(167), 1,
      sym__widentifier,
    STATE(287), 1,
      sym_term,
    STATE(365), 1,
      sym_atom,
    ACTIONS(495), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(289), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7217] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(299), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(297), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7250] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(499), 1,
      sym_COLON,
    ACTIONS(501), 1,
      sym_RBRACE,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(645), 1,
      sym_ntermvec,
    STATE(649), 1,
      sym_ncspelemvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7317] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(499), 1,
      sym_COLON,
    ACTIONS(503), 1,
      sym_RBRACE,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(589), 1,
      sym_ncspelemvec,
    STATE(645), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7384] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(507), 20,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [7417] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      sym_COLON,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    STATE(266), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(362), 1,
      sym_theory_opterm,
    STATE(406), 1,
      sym_theory_term,
    STATE(411), 1,
      sym_dec,
    STATE(447), 1,
      sym_theory_opterm_nlist,
    STATE(582), 1,
      sym_theory_atom_element,
    ACTIONS(473), 2,
      sym_THEORY_OP,
      sym_NOT,
    STATE(379), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7484] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(275), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7517] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(349), 1,
      sym_DISJOINT,
    ACTIONS(511), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(167), 1,
      sym__widentifier,
    STATE(283), 1,
      sym_term,
    STATE(367), 1,
      sym_atom,
    ACTIONS(509), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7584] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_AND,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(519), 1,
      sym_MUL,
    ACTIONS(521), 1,
      sym_POW,
    ACTIONS(523), 1,
      sym_QUESTION,
    ACTIONS(527), 1,
      sym_XOR,
    ACTIONS(513), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(525), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(291), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(289), 11,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [7633] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(531), 20,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [7666] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(533), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(167), 1,
      sym__widentifier,
    STATE(287), 1,
      sym_term,
    STATE(365), 1,
      sym_atom,
    ACTIONS(495), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7733] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(201), 1,
      sym_identifier,
    ACTIONS(535), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(174), 1,
      sym__widentifier,
    STATE(284), 1,
      sym_term,
    STATE(437), 1,
      sym_atom,
    ACTIONS(343), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7800] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(499), 1,
      sym_COLON,
    ACTIONS(537), 1,
      sym_RBRACE,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(633), 1,
      sym_ncspelemvec,
    STATE(645), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7900] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_AND,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(523), 1,
      sym_QUESTION,
    ACTIONS(527), 1,
      sym_XOR,
    ACTIONS(303), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 16,
      sym_ADD,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [7941] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(523), 1,
      sym_QUESTION,
    ACTIONS(527), 1,
      sym_XOR,
    ACTIONS(303), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 17,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [7980] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8013] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(527), 1,
      sym_XOR,
    ACTIONS(303), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 18,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [8050] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(285), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8083] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(539), 1,
      sym_NOT,
    STATE(31), 1,
      sym_dec,
    STATE(167), 1,
      sym__widentifier,
    STATE(284), 1,
      sym_term,
    STATE(365), 1,
      sym_atom,
    ACTIONS(495), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8150] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(281), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8183] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(543), 20,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
  [8216] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_AND,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(519), 1,
      sym_MUL,
    ACTIONS(521), 1,
      sym_POW,
    ACTIONS(523), 1,
      sym_QUESTION,
    ACTIONS(527), 1,
      sym_XOR,
    ACTIONS(545), 1,
      sym_CSP_MUL,
    ACTIONS(513), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(525), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(357), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [8267] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_AND,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(519), 1,
      sym_MUL,
    ACTIONS(521), 1,
      sym_POW,
    ACTIONS(523), 1,
      sym_QUESTION,
    ACTIONS(527), 1,
      sym_XOR,
    ACTIONS(513), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(525), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(303), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(301), 11,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [8316] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_AND,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(519), 1,
      sym_MUL,
    ACTIONS(521), 1,
      sym_POW,
    ACTIONS(523), 1,
      sym_QUESTION,
    ACTIONS(527), 1,
      sym_XOR,
    ACTIONS(551), 1,
      sym_CSP_MUL,
    ACTIONS(513), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(525), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(547), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(549), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [8367] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(437), 1,
      sym_COMMA,
    ACTIONS(553), 1,
      sym_SEM,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(531), 1,
      sym_ntermvec,
    STATE(565), 1,
      sym_ntuple,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8434] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_AND,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(523), 1,
      sym_QUESTION,
    ACTIONS(527), 1,
      sym_XOR,
    ACTIONS(513), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(303), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 14,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [8477] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(303), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(301), 19,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8512] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(309), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8545] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(295), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(293), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8578] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(555), 1,
      sym_COLON,
    ACTIONS(557), 1,
      sym_RBRACE,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(585), 1,
      sym_ntermvec,
    STATE(586), 1,
      sym_headaggrelemvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8645] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(567), 1,
      sym_RBRACE,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(636), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8711] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(581), 1,
      sym_CSP,
    STATE(31), 1,
      sym_dec,
    STATE(157), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(322), 1,
      sym_csp_mul_term,
    STATE(388), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8775] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(583), 1,
      sym_RPAREN,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(577), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8841] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      sym_RBRACE,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(562), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8907] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(587), 1,
      sym_RPAREN,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(506), 1,
      sym_ntermvec,
    STATE(629), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8971] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      sym_RBRACK,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(557), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9037] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(581), 1,
      sym_CSP,
    STATE(31), 1,
      sym_dec,
    STATE(157), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(314), 1,
      sym_csp_add_term,
    STATE(322), 1,
      sym_csp_mul_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9101] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(589), 1,
      sym_RBRACK,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(583), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9167] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(589), 1,
      sym_RBRACE,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(590), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9233] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(591), 1,
      sym_CSP_MUL,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(547), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(549), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [9283] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(511), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(167), 1,
      sym__widentifier,
    STATE(283), 1,
      sym_term,
    STATE(367), 1,
      sym_atom,
    ACTIONS(509), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9347] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(593), 1,
      sym_LBRACE,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(295), 1,
      sym_term,
    STATE(415), 1,
      sym_optimizeweight,
    STATE(622), 1,
      sym_maxelemlist,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9411] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(595), 1,
      sym_RPAREN,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(579), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9477] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(597), 1,
      sym_CSP,
    STATE(127), 1,
      sym_dec,
    STATE(131), 1,
      sym_term,
    STATE(194), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(310), 1,
      sym_csp_add_term,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9541] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(511), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(167), 1,
      sym__widentifier,
    STATE(282), 1,
      sym_term,
    STATE(367), 1,
      sym_atom,
    ACTIONS(509), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9605] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(581), 1,
      sym_CSP,
    STATE(31), 1,
      sym_dec,
    STATE(157), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(322), 1,
      sym_csp_mul_term,
    STATE(400), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9669] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(157), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_csp_mul_term,
    STATE(328), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9733] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(359), 1,
      sym_CSP_MUL,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(361), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(357), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [9783] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(599), 1,
      sym_RPAREN,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(506), 1,
      sym_ntermvec,
    STATE(550), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9847] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(601), 1,
      sym_RPAREN,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(610), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9913] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(603), 1,
      sym_RPAREN,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(617), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9979] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(605), 1,
      sym_RPAREN,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(538), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10045] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym_SUB,
    ACTIONS(353), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(174), 1,
      sym__widentifier,
    STATE(282), 1,
      sym_term,
    STATE(452), 1,
      sym_atom,
    ACTIONS(351), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10109] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(567), 1,
      sym_RBRACK,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(635), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10175] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_AND,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(519), 1,
      sym_MUL,
    ACTIONS(521), 1,
      sym_POW,
    ACTIONS(523), 1,
      sym_QUESTION,
    ACTIONS(527), 1,
      sym_XOR,
    ACTIONS(513), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(525), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(607), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(609), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [10223] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(479), 1,
      sym_COLON,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(441), 1,
      sym_ntermvec,
    STATE(571), 1,
      sym_bodyaggrelem,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10287] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(581), 1,
      sym_CSP,
    STATE(31), 1,
      sym_dec,
    STATE(157), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(322), 1,
      sym_csp_mul_term,
    STATE(389), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10351] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(611), 1,
      sym_RPAREN,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(506), 1,
      sym_ntermvec,
    STATE(567), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10415] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(613), 1,
      sym_RPAREN,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(546), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10481] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(581), 1,
      sym_CSP,
    STATE(31), 1,
      sym_dec,
    STATE(157), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(322), 1,
      sym_csp_mul_term,
    STATE(391), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10545] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(615), 1,
      sym_RPAREN,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(506), 1,
      sym_ntermvec,
    STATE(644), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10609] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(617), 1,
      sym_RPAREN,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(506), 1,
      sym_ntermvec,
    STATE(632), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10673] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(619), 1,
      sym_RBRACE,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(620), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10739] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(617), 1,
      sym_RPAREN,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(506), 1,
      sym_ntermvec,
    STATE(648), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10803] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(615), 1,
      sym_RPAREN,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(506), 1,
      sym_ntermvec,
    STATE(642), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10867] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(621), 1,
      sym_RPAREN,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(584), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10933] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(619), 1,
      sym_RBRACK,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(535), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10999] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(623), 1,
      sym_RPAREN,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(548), 1,
      sym_theory_opterm_nlist,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11065] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(625), 1,
      sym_RBRACE,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(295), 1,
      sym_term,
    STATE(417), 1,
      sym_optimizeweight,
    STATE(558), 1,
      sym_minelemlist,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11129] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(157), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11190] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(585), 1,
      sym_RPAREN,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(383), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11253] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(619), 1,
      sym_RPAREN,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(385), 1,
      sym_theory_term,
    STATE(399), 1,
      sym_theory_opterm,
    STATE(401), 1,
      sym_dec,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11316] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(591), 1,
      sym_CSP_MUL,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(547), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(549), 9,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [11365] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(506), 1,
      sym_ntermvec,
    STATE(646), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11426] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(581), 1,
      sym_CSP,
    STATE(31), 1,
      sym_dec,
    STATE(157), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(313), 1,
      sym_csp_mul_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11487] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(597), 1,
      sym_CSP,
    STATE(127), 1,
      sym_dec,
    STATE(131), 1,
      sym_term,
    STATE(194), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_csp_mul_term,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11548] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(589), 1,
      sym_RPAREN,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(385), 1,
      sym_theory_term,
    STATE(394), 1,
      sym_theory_opterm,
    STATE(401), 1,
      sym_dec,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11611] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(506), 1,
      sym_ntermvec,
    STATE(534), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11672] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(506), 1,
      sym_ntermvec,
    STATE(634), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11733] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(627), 1,
      sym_COLON,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(608), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11794] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(567), 1,
      sym_RPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(405), 1,
      sym_theory_opterm,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11857] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_DOT,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(629), 1,
      sym_CSP,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(335), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11918] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(607), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(609), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [11965] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(292), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(631), 2,
      sym_RPAREN,
      sym_SEM,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12024] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(506), 1,
      sym_ntermvec,
    STATE(647), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12085] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(633), 1,
      sym_COLON,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(587), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12146] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(637), 1,
      sym_LBRACE,
    ACTIONS(639), 1,
      sym_LBRACK,
    ACTIONS(641), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      anon_sym_0,
    ACTIONS(645), 1,
      aux_sym_dec_token1,
    ACTIONS(649), 1,
      sym_identifier,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    STATE(269), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(398), 1,
      sym_theory_opterm,
    STATE(465), 1,
      sym_theory_term,
    STATE(474), 1,
      sym_dec,
    STATE(453), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(635), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(647), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12206] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(655), 1,
      sym_LBRACE,
    ACTIONS(657), 1,
      sym_LBRACK,
    ACTIONS(659), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      anon_sym_0,
    ACTIONS(663), 1,
      aux_sym_dec_token1,
    ACTIONS(667), 1,
      sym_identifier,
    ACTIONS(669), 1,
      anon_sym_DQUOTE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(373), 1,
      sym_theory_opterm,
    STATE(436), 1,
      sym_dec,
    STATE(443), 1,
      sym_theory_term,
    STATE(440), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(653), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(665), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12266] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(295), 1,
      sym_term,
    STATE(510), 1,
      sym_optimizeweight,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12324] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(295), 1,
      sym_term,
    STATE(424), 1,
      sym_optimizeweight,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12382] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(333), 1,
      sym_term,
    STATE(639), 1,
      sym_unaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12440] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(673), 3,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(671), 19,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [12470] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(333), 1,
      sym_term,
    STATE(591), 1,
      sym_unaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12528] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      sym_AT,
    ACTIONS(681), 1,
      sym_LPAREN,
    ACTIONS(683), 1,
      sym_RPAREN,
    ACTIONS(685), 1,
      sym_VBAR,
    ACTIONS(687), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(206), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_constterm,
    STATE(612), 1,
      sym_consttermvec,
    STATE(680), 1,
      sym_nconstargvec,
    ACTIONS(677), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(679), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(315), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12588] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(340), 1,
      sym_term,
    STATE(553), 1,
      sym_binaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12646] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(427), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12704] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      sym_AT,
    ACTIONS(681), 1,
      sym_LPAREN,
    ACTIONS(685), 1,
      sym_VBAR,
    ACTIONS(687), 1,
      sym_identifier,
    ACTIONS(689), 1,
      sym_RPAREN,
    STATE(31), 1,
      sym_dec,
    STATE(206), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_constterm,
    STATE(612), 1,
      sym_consttermvec,
    STATE(662), 1,
      sym_nconstargvec,
    ACTIONS(677), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(679), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(315), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12764] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(518), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12822] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(655), 1,
      sym_LBRACE,
    ACTIONS(657), 1,
      sym_LBRACK,
    ACTIONS(659), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      anon_sym_0,
    ACTIONS(663), 1,
      aux_sym_dec_token1,
    ACTIONS(667), 1,
      sym_identifier,
    ACTIONS(669), 1,
      anon_sym_DQUOTE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(363), 1,
      sym_theory_opterm,
    STATE(436), 1,
      sym_dec,
    STATE(443), 1,
      sym_theory_term,
    STATE(440), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(653), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(665), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12882] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(358), 1,
      sym_theory_opterm,
    STATE(385), 1,
      sym_theory_term,
    STATE(401), 1,
      sym_dec,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12942] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(295), 1,
      sym_term,
    STATE(397), 1,
      sym_optimizeweight,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13000] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(637), 1,
      sym_LBRACE,
    ACTIONS(639), 1,
      sym_LBRACK,
    ACTIONS(641), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      anon_sym_0,
    ACTIONS(645), 1,
      aux_sym_dec_token1,
    ACTIONS(649), 1,
      sym_identifier,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    STATE(269), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(414), 1,
      sym_theory_opterm,
    STATE(465), 1,
      sym_theory_term,
    STATE(474), 1,
      sym_dec,
    STATE(453), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(635), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(647), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13060] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    STATE(266), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    STATE(360), 1,
      sym_theory_opterm,
    STATE(406), 1,
      sym_theory_term,
    STATE(411), 1,
      sym_dec,
    STATE(379), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13120] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(117), 1,
      sym_term,
    STATE(127), 1,
      sym_dec,
    STATE(194), 1,
      sym__widentifier,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13175] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(691), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(39), 1,
      sym_term,
    STATE(158), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13230] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(127), 1,
      sym_dec,
    STATE(135), 1,
      sym_term,
    STATE(194), 1,
      sym__widentifier,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13285] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(125), 1,
      sym_term,
    STATE(127), 1,
      sym_dec,
    STATE(194), 1,
      sym__widentifier,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13340] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(46), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13395] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(124), 1,
      sym_term,
    STATE(127), 1,
      sym_dec,
    STATE(194), 1,
      sym__widentifier,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13450] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(123), 1,
      sym_term,
    STATE(127), 1,
      sym_dec,
    STATE(194), 1,
      sym__widentifier,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13505] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(338), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13560] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(127), 1,
      sym_dec,
    STATE(194), 1,
      sym__widentifier,
    STATE(293), 1,
      sym_term,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13615] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(331), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13670] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(127), 1,
      sym_dec,
    STATE(132), 1,
      sym_term,
    STATE(194), 1,
      sym__widentifier,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13725] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(292), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13780] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(126), 1,
      sym_term,
    STATE(127), 1,
      sym_dec,
    STATE(194), 1,
      sym__widentifier,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13835] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(127), 1,
      sym_dec,
    STATE(136), 1,
      sym_term,
    STATE(194), 1,
      sym__widentifier,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13890] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(326), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13945] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(127), 1,
      sym_dec,
    STATE(164), 1,
      sym_term,
    STATE(194), 1,
      sym__widentifier,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14000] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(127), 1,
      sym_dec,
    STATE(194), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14055] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(41), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14110] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(346), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14165] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(45), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14220] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(343), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14275] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(342), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14330] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(336), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14385] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      sym_AT,
    ACTIONS(681), 1,
      sym_LPAREN,
    ACTIONS(685), 1,
      sym_VBAR,
    ACTIONS(687), 1,
      sym_identifier,
    ACTIONS(689), 1,
      sym_RPAREN,
    STATE(31), 1,
      sym_dec,
    STATE(206), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_constterm,
    STATE(613), 1,
      sym_consttermvec,
    ACTIONS(677), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(679), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(315), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14442] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(36), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14497] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(305), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14552] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(339), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14607] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(40), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14662] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(344), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14717] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(298), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14772] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(334), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14827] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(149), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14882] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(127), 1,
      sym_dec,
    STATE(194), 1,
      sym__widentifier,
    STATE(330), 1,
      sym_term,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14937] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(302), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14992] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(182), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15047] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(347), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15102] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15157] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(42), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15212] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(127), 1,
      sym_dec,
    STATE(194), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15267] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(192), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15322] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(39), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15377] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(337), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15432] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(44), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15487] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      sym_AT,
    ACTIONS(407), 1,
      sym_LPAREN,
    ACTIONS(409), 1,
      sym_VBAR,
    ACTIONS(411), 1,
      anon_sym_0,
    ACTIONS(413), 1,
      aux_sym_dec_token1,
    ACTIONS(417), 1,
      sym_ANONYMOUS,
    ACTIONS(419), 1,
      sym_identifier,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    STATE(127), 1,
      sym_dec,
    STATE(133), 1,
      sym_term,
    STATE(194), 1,
      sym__widentifier,
    ACTIONS(401), 2,
      sym_BNOT,
      sym_SUB,
    STATE(115), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(405), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(415), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15542] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(693), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(39), 1,
      sym_term,
    STATE(173), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(43), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15597] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    STATE(299), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_dec,
    STATE(410), 1,
      sym_theory_term,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15651] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(695), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [15679] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(701), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(699), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [15707] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(655), 1,
      sym_LBRACE,
    ACTIONS(657), 1,
      sym_LBRACK,
    ACTIONS(659), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      anon_sym_0,
    ACTIONS(663), 1,
      aux_sym_dec_token1,
    ACTIONS(667), 1,
      sym_identifier,
    ACTIONS(669), 1,
      anon_sym_DQUOTE,
    STATE(299), 1,
      sym_theory_op,
    STATE(436), 1,
      sym_dec,
    STATE(451), 1,
      sym_theory_term,
    STATE(440), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(653), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(665), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15761] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(655), 1,
      sym_LBRACE,
    ACTIONS(657), 1,
      sym_LBRACK,
    ACTIONS(659), 1,
      sym_LPAREN,
    ACTIONS(661), 1,
      anon_sym_0,
    ACTIONS(663), 1,
      aux_sym_dec_token1,
    ACTIONS(667), 1,
      sym_identifier,
    ACTIONS(669), 1,
      anon_sym_DQUOTE,
    STATE(299), 1,
      sym_theory_op,
    STATE(436), 1,
      sym_dec,
    STATE(445), 1,
      sym_theory_term,
    STATE(440), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(653), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(665), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15815] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      sym_AT,
    ACTIONS(681), 1,
      sym_LPAREN,
    ACTIONS(685), 1,
      sym_VBAR,
    ACTIONS(687), 1,
      sym_identifier,
    ACTIONS(703), 1,
      sym_RPAREN,
    STATE(31), 1,
      sym_dec,
    STATE(206), 1,
      sym__widentifier,
    STATE(341), 1,
      sym_constterm,
    ACTIONS(677), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(679), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(315), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15869] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    STATE(299), 1,
      sym_theory_op,
    STATE(411), 1,
      sym_dec,
    STATE(416), 1,
      sym_theory_term,
    STATE(379), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15923] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(707), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(705), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [15951] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym_LBRACE,
    ACTIONS(459), 1,
      sym_LBRACK,
    ACTIONS(461), 1,
      sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_0,
    ACTIONS(467), 1,
      aux_sym_dec_token1,
    ACTIONS(471), 1,
      sym_identifier,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(475), 1,
      anon_sym_DQUOTE,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    STATE(299), 1,
      sym_theory_op,
    STATE(390), 1,
      sym_theory_term,
    STATE(411), 1,
      sym_dec,
    STATE(379), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(455), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(469), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16005] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(709), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16033] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(561), 1,
      sym_LBRACE,
    ACTIONS(563), 1,
      sym_LBRACK,
    ACTIONS(565), 1,
      sym_LPAREN,
    ACTIONS(569), 1,
      anon_sym_0,
    ACTIONS(571), 1,
      aux_sym_dec_token1,
    ACTIONS(575), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    STATE(299), 1,
      sym_theory_op,
    STATE(401), 1,
      sym_dec,
    STATE(419), 1,
      sym_theory_term,
    STATE(380), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(559), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(573), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16087] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(637), 1,
      sym_LBRACE,
    ACTIONS(639), 1,
      sym_LBRACK,
    ACTIONS(641), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      anon_sym_0,
    ACTIONS(645), 1,
      aux_sym_dec_token1,
    ACTIONS(649), 1,
      sym_identifier,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    STATE(299), 1,
      sym_theory_op,
    STATE(467), 1,
      sym_theory_term,
    STATE(474), 1,
      sym_dec,
    STATE(453), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(635), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(647), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16141] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_NOT,
    ACTIONS(577), 1,
      sym_THEORY_OP,
    ACTIONS(637), 1,
      sym_LBRACE,
    ACTIONS(639), 1,
      sym_LBRACK,
    ACTIONS(641), 1,
      sym_LPAREN,
    ACTIONS(643), 1,
      anon_sym_0,
    ACTIONS(645), 1,
      aux_sym_dec_token1,
    ACTIONS(649), 1,
      sym_identifier,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    STATE(299), 1,
      sym_theory_op,
    STATE(469), 1,
      sym_theory_term,
    STATE(474), 1,
      sym_dec,
    STATE(453), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(635), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(647), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16195] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(715), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(713), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16223] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      sym_AT,
    ACTIONS(681), 1,
      sym_LPAREN,
    ACTIONS(685), 1,
      sym_VBAR,
    ACTIONS(687), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(206), 1,
      sym__widentifier,
    STATE(354), 1,
      sym_constterm,
    ACTIONS(677), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(679), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(315), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16274] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      sym_AT,
    ACTIONS(681), 1,
      sym_LPAREN,
    ACTIONS(685), 1,
      sym_VBAR,
    ACTIONS(687), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(206), 1,
      sym__widentifier,
    STATE(312), 1,
      sym_constterm,
    ACTIONS(677), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(679), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(315), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16325] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      sym_AT,
    ACTIONS(681), 1,
      sym_LPAREN,
    ACTIONS(685), 1,
      sym_VBAR,
    ACTIONS(687), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(206), 1,
      sym__widentifier,
    STATE(349), 1,
      sym_constterm,
    ACTIONS(677), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(679), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(315), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16376] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      sym_AT,
    ACTIONS(681), 1,
      sym_LPAREN,
    ACTIONS(685), 1,
      sym_VBAR,
    ACTIONS(687), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(206), 1,
      sym__widentifier,
    STATE(323), 1,
      sym_constterm,
    ACTIONS(677), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(679), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(315), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16427] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      sym_AT,
    ACTIONS(681), 1,
      sym_LPAREN,
    ACTIONS(685), 1,
      sym_VBAR,
    ACTIONS(687), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(206), 1,
      sym__widentifier,
    STATE(321), 1,
      sym_constterm,
    ACTIONS(677), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(679), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(315), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16478] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      sym_AT,
    ACTIONS(681), 1,
      sym_LPAREN,
    ACTIONS(685), 1,
      sym_VBAR,
    ACTIONS(687), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(206), 1,
      sym__widentifier,
    STATE(317), 1,
      sym_constterm,
    ACTIONS(677), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(679), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(315), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16529] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      sym_AT,
    ACTIONS(681), 1,
      sym_LPAREN,
    ACTIONS(685), 1,
      sym_VBAR,
    ACTIONS(687), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(206), 1,
      sym__widentifier,
    STATE(318), 1,
      sym_constterm,
    ACTIONS(677), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(679), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(315), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16580] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      sym_AT,
    ACTIONS(681), 1,
      sym_LPAREN,
    ACTIONS(685), 1,
      sym_VBAR,
    ACTIONS(687), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(206), 1,
      sym__widentifier,
    STATE(319), 1,
      sym_constterm,
    ACTIONS(677), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(679), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(315), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16631] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      sym_AT,
    ACTIONS(681), 1,
      sym_LPAREN,
    ACTIONS(685), 1,
      sym_VBAR,
    ACTIONS(687), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(206), 1,
      sym__widentifier,
    STATE(341), 1,
      sym_constterm,
    ACTIONS(677), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(679), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(315), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16682] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      sym_AT,
    ACTIONS(681), 1,
      sym_LPAREN,
    ACTIONS(685), 1,
      sym_VBAR,
    ACTIONS(687), 1,
      sym_identifier,
    STATE(31), 1,
      sym_dec,
    STATE(206), 1,
      sym__widentifier,
    STATE(311), 1,
      sym_constterm,
    ACTIONS(677), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(679), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(315), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16733] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    STATE(249), 1,
      sym_cmp,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [16777] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    STATE(251), 1,
      sym_cmp,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [16821] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    STATE(238), 1,
      sym_cmp,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [16865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(719), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(717), 16,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16891] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(723), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(721), 16,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16917] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    STATE(221), 1,
      sym_cmp,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(355), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(363), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [16961] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(727), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(725), 16,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [16987] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(731), 3,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(729), 14,
      sym_COMMA,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_RBRACE,
      sym_SUPREMUM,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
  [17012] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(733), 15,
      sym_AT,
      sym_BNOT,
      sym_INFIMUM,
      sym_LPAREN,
      sym_RPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [17037] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(739), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(737), 15,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
  [17062] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(741), 6,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
  [17100] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_AND,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(519), 1,
      sym_MUL,
    ACTIONS(521), 1,
      sym_POW,
    ACTIONS(523), 1,
      sym_QUESTION,
    ACTIONS(527), 1,
      sym_XOR,
    ACTIONS(513), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(525), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(743), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(745), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17140] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_AND,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(519), 1,
      sym_MUL,
    ACTIONS(521), 1,
      sym_POW,
    ACTIONS(523), 1,
      sym_QUESTION,
    ACTIONS(527), 1,
      sym_XOR,
    ACTIONS(513), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(525), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(747), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(749), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17180] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(751), 1,
      sym_AT,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(753), 5,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_SEM,
  [17220] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(755), 6,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
  [17258] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_AND,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(519), 1,
      sym_MUL,
    ACTIONS(521), 1,
      sym_POW,
    ACTIONS(523), 1,
      sym_QUESTION,
    ACTIONS(527), 1,
      sym_XOR,
    ACTIONS(513), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(525), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(757), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(759), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17298] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(761), 5,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_SEM,
  [17335] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(765), 3,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(763), 12,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_SUPREMUM,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
  [17358] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(767), 1,
      sym_AND,
    ACTIONS(769), 1,
      sym_RBRACE,
    STATE(653), 1,
      sym_theory_definition_nlist,
    STATE(678), 1,
      sym_theory_definition_identifier,
    STATE(641), 2,
      sym_theory_term_definition,
      sym_theory_atom_definition,
    ACTIONS(771), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [17389] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(747), 1,
      sym_DOT,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(749), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [17428] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(757), 1,
      sym_DOT,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(759), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [17467] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(773), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(775), 12,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [17490] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(777), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(779), 12,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [17513] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(743), 1,
      sym_DOT,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(745), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [17552] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(783), 3,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(781), 12,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_SUPREMUM,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
  [17575] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(787), 1,
      sym_MUL,
    ACTIONS(785), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17599] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(767), 1,
      sym_AND,
    STATE(678), 1,
      sym_theory_definition_identifier,
    STATE(688), 1,
      sym_theory_definition_nlist,
    STATE(641), 2,
      sym_theory_term_definition,
      sym_theory_atom_definition,
    ACTIONS(771), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [17627] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      sym_MUL,
    ACTIONS(789), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17651] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(793), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(795), 9,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17675] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(801), 1,
      sym_AND,
    ACTIONS(803), 1,
      sym_MUL,
    ACTIONS(805), 1,
      sym_QUESTION,
    ACTIONS(807), 1,
      sym_XOR,
    ACTIONS(799), 9,
      sym_ADD,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [17702] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      sym_MUL,
    ACTIONS(805), 1,
      sym_QUESTION,
    ACTIONS(807), 1,
      sym_XOR,
    ACTIONS(799), 10,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [17727] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(773), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(775), 11,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [17748] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(793), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(809), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(795), 9,
      sym_COLON,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [17771] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 1,
      sym_MUL,
    ACTIONS(789), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17792] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      sym_MUL,
    ACTIONS(799), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [17813] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(801), 1,
      sym_AND,
    ACTIONS(803), 1,
      sym_MUL,
    ACTIONS(805), 1,
      sym_QUESTION,
    ACTIONS(807), 1,
      sym_XOR,
    ACTIONS(811), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(799), 7,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_VBAR,
  [17842] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(801), 1,
      sym_AND,
    ACTIONS(805), 1,
      sym_QUESTION,
    ACTIONS(807), 1,
      sym_XOR,
    ACTIONS(815), 1,
      sym_MUL,
    ACTIONS(817), 1,
      sym_POW,
    ACTIONS(811), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(813), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(799), 4,
      sym_COMMA,
      sym_DOT,
      sym_RPAREN,
      sym_VBAR,
  [17875] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      sym_MUL,
    ACTIONS(807), 1,
      sym_XOR,
    ACTIONS(799), 11,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [17898] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 1,
      sym_COLON,
    STATE(153), 1,
      sym_csp_rel,
    ACTIONS(825), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(823), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
    ACTIONS(821), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17925] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(801), 1,
      sym_AND,
    ACTIONS(805), 1,
      sym_QUESTION,
    ACTIONS(807), 1,
      sym_XOR,
    ACTIONS(815), 1,
      sym_MUL,
    ACTIONS(817), 1,
      sym_POW,
    ACTIONS(811), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(813), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(785), 4,
      sym_COMMA,
      sym_DOT,
      sym_RPAREN,
      sym_VBAR,
  [17958] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(777), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(779), 11,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [17979] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      sym_MUL,
    ACTIONS(799), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [18000] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(787), 1,
      sym_MUL,
    ACTIONS(785), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [18021] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(829), 1,
      sym_MUL,
    ACTIONS(827), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [18042] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(833), 1,
      sym_DOT,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(831), 2,
      sym_COMMA,
      sym_SEM,
  [18079] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(837), 1,
      sym_DOT,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(835), 2,
      sym_COMMA,
      sym_SEM,
  [18116] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(793), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(839), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(795), 8,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [18138] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_AND,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(519), 1,
      sym_MUL,
    ACTIONS(521), 1,
      sym_POW,
    ACTIONS(523), 1,
      sym_QUESTION,
    ACTIONS(527), 1,
      sym_XOR,
    ACTIONS(835), 1,
      sym_IF,
    ACTIONS(837), 1,
      sym_DOT,
    ACTIONS(513), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(525), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18174] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      sym_AND,
    ACTIONS(517), 1,
      sym_DOTS,
    ACTIONS(519), 1,
      sym_MUL,
    ACTIONS(521), 1,
      sym_POW,
    ACTIONS(523), 1,
      sym_QUESTION,
    ACTIONS(527), 1,
      sym_XOR,
    ACTIONS(831), 1,
      sym_IF,
    ACTIONS(833), 1,
      sym_DOT,
    ACTIONS(513), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(525), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18210] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(841), 2,
      sym_SEM,
      sym_VBAR,
  [18244] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(146), 1,
      sym_csp_rel,
    ACTIONS(825), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(823), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
    ACTIONS(821), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [18268] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(843), 2,
      sym_SEM,
      sym_VBAR,
  [18302] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(845), 1,
      sym_AT,
    ACTIONS(847), 1,
      sym_COMMA,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18338] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(849), 1,
      sym_COLON,
    ACTIONS(851), 1,
      sym_DOT,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18374] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(853), 2,
      sym_RPAREN,
      sym_SEM,
  [18408] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(855), 1,
      sym_COLON,
    ACTIONS(857), 1,
      sym_DOT,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18444] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(859), 2,
      sym_RPAREN,
      sym_SEM,
  [18478] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(861), 1,
      sym_COMMA,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18511] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(863), 1,
      sym_COMMA,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18544] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(801), 1,
      sym_AND,
    ACTIONS(805), 1,
      sym_QUESTION,
    ACTIONS(807), 1,
      sym_XOR,
    ACTIONS(815), 1,
      sym_MUL,
    ACTIONS(817), 1,
      sym_POW,
    ACTIONS(811), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(813), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(865), 2,
      sym_COMMA,
      sym_RPAREN,
  [18575] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(867), 1,
      sym_COMMA,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18608] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(869), 1,
      sym_RBRACK,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18641] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(871), 1,
      sym_RBRACK,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18674] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(156), 1,
      sym_csp_rel,
    ACTIONS(825), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(821), 4,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(823), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [18697] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(873), 1,
      sym_RBRACK,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18730] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      sym_DOTS,
    ACTIONS(307), 1,
      sym_XOR,
    ACTIONS(315), 1,
      sym_AND,
    ACTIONS(317), 1,
      sym_MUL,
    ACTIONS(319), 1,
      sym_POW,
    ACTIONS(321), 1,
      sym_QUESTION,
    ACTIONS(875), 1,
      sym_RBRACK,
    ACTIONS(313), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(323), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18763] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(801), 1,
      sym_AND,
    ACTIONS(805), 1,
      sym_QUESTION,
    ACTIONS(807), 1,
      sym_XOR,
    ACTIONS(815), 1,
      sym_MUL,
    ACTIONS(817), 1,
      sym_POW,
    ACTIONS(811), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(813), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(877), 2,
      sym_COMMA,
      sym_RPAREN,
  [18794] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(801), 1,
      sym_AND,
    ACTIONS(805), 1,
      sym_QUESTION,
    ACTIONS(807), 1,
      sym_XOR,
    ACTIONS(815), 1,
      sym_MUL,
    ACTIONS(817), 1,
      sym_POW,
    ACTIONS(879), 1,
      sym_DOT,
    ACTIONS(811), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(813), 2,
      sym_MOD,
      sym_SLASH,
  [18824] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(701), 1,
      sym_theory_definition_identifier,
    ACTIONS(771), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [18842] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(652), 1,
      sym_theory_definition_identifier,
    ACTIONS(771), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [18860] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(696), 1,
      sym_theory_definition_identifier,
    ACTIONS(771), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [18878] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(675), 1,
      sym_theory_definition_identifier,
    ACTIONS(771), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [18896] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(683), 1,
      sym_VBAR,
    ACTIONS(801), 1,
      sym_AND,
    ACTIONS(805), 1,
      sym_QUESTION,
    ACTIONS(807), 1,
      sym_XOR,
    ACTIONS(815), 1,
      sym_MUL,
    ACTIONS(817), 1,
      sym_POW,
    ACTIONS(811), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(813), 2,
      sym_MOD,
      sym_SLASH,
  [18926] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(146), 1,
      sym_csp_rel,
    ACTIONS(825), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(839), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(823), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [18947] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(153), 1,
      sym_csp_rel,
    ACTIONS(825), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(839), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(823), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [18968] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(156), 1,
      sym_csp_rel,
    ACTIONS(825), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(839), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(823), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [18989] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(258), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
    ACTIONS(881), 4,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
  [19009] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(258), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
    ACTIONS(883), 4,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
  [19029] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    STATE(264), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    ACTIONS(881), 2,
      sym_COMMA,
      sym_RBRACE,
    ACTIONS(885), 2,
      sym_COLON,
      sym_SEM,
  [19053] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(367), 1,
      sym_COMMA,
    ACTIONS(887), 1,
      sym_COLON,
    STATE(260), 1,
      sym_dsym,
    STATE(605), 1,
      sym_noptcondition,
    ACTIONS(365), 2,
      sym_DOT,
      sym_IF,
    ACTIONS(889), 2,
      sym_SEM,
      sym_VBAR,
  [19077] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    STATE(264), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    ACTIONS(883), 2,
      sym_COMMA,
      sym_RBRACE,
    ACTIONS(891), 2,
      sym_COLON,
      sym_SEM,
  [19101] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    ACTIONS(893), 1,
      sym_COMMA,
    STATE(261), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    ACTIONS(895), 2,
      sym_DOT,
      sym_SEM,
  [19124] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(31), 1,
      sym_dec,
    STATE(686), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19145] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 1,
      sym_COLON,
    ACTIONS(899), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19160] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(903), 1,
      sym_LPAREN,
    ACTIONS(901), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19175] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(757), 1,
      sym_COLON,
    ACTIONS(759), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19190] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(325), 1,
      sym_COLON,
    ACTIONS(327), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19205] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 1,
      sym_COLON,
    ACTIONS(907), 1,
      sym_COMMA,
    STATE(265), 1,
      sym_dsym,
    ACTIONS(889), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(909), 2,
      sym_DOT,
      sym_IF,
  [19226] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(31), 1,
      sym_dec,
    STATE(665), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19247] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(31), 1,
      sym_dec,
    STATE(650), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19268] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym_LPAREN,
    ACTIONS(901), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(911), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19285] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    ACTIONS(915), 1,
      sym_COMMA,
    STATE(261), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    ACTIONS(917), 2,
      sym_DOT,
      sym_SEM,
  [19308] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 1,
      sym_COLON,
    ACTIONS(821), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19323] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(31), 1,
      sym_dec,
    STATE(664), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19344] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 1,
      sym_COLON,
    ACTIONS(339), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19359] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_LBRACE,
    STATE(623), 1,
      sym_theory_atom_type,
    ACTIONS(921), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [19375] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(283), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19389] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(911), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19403] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19415] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    ACTIONS(923), 1,
      sym_COMMA,
    STATE(197), 1,
      sym_theory_op,
    ACTIONS(925), 2,
      sym_DOT,
      sym_SEM,
  [19435] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(927), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19447] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 1,
      sym_RPAREN,
    ACTIONS(929), 1,
      sym_COMMA,
    STATE(258), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
  [19467] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(931), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(933), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19481] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19493] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(937), 1,
      sym_COMMA,
    STATE(267), 1,
      sym_dsym,
    ACTIONS(889), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(939), 2,
      sym_DOT,
      sym_IF,
  [19511] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(299), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19525] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_COLON,
    STATE(581), 1,
      sym_noptcondition,
    ACTIONS(809), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(943), 2,
      sym_RBRACE,
      sym_SEM,
  [19543] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_COLON,
    STATE(609), 1,
      sym_noptcondition,
    ACTIONS(809), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(945), 2,
      sym_RBRACE,
      sym_SEM,
  [19561] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(949), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19575] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_COLON,
    STATE(541), 1,
      sym_noptcondition,
    ACTIONS(809), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(951), 2,
      sym_RBRACE,
      sym_SEM,
  [19593] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(953), 1,
      sym_LPAREN,
    ACTIONS(901), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(911), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [19609] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(955), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(957), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19623] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(595), 1,
      sym_RPAREN,
    ACTIONS(959), 1,
      sym_COMMA,
    STATE(258), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
  [19643] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19655] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19667] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 1,
      sym_COLON,
    ACTIONS(963), 1,
      sym_COMMA,
    STATE(461), 1,
      sym_noptimizetuple,
    STATE(568), 1,
      sym_noptimizecond,
    ACTIONS(965), 2,
      sym_RBRACE,
      sym_SEM,
  [19687] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    STATE(270), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    ACTIONS(895), 2,
      sym_DOT,
      sym_IF,
  [19707] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(621), 1,
      sym_RPAREN,
    ACTIONS(967), 1,
      sym_COMMA,
    STATE(258), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
  [19727] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_COLON,
    STATE(555), 1,
      sym_noptcondition,
    ACTIONS(809), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(969), 2,
      sym_RBRACE,
      sym_SEM,
  [19745] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19757] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19769] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(957), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19781] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym_RBRACE,
    STATE(559), 1,
      sym_theory_operator_definition_nlist,
    STATE(561), 1,
      sym_theory_operator_definition,
    STATE(685), 1,
      sym_theory_op,
    ACTIONS(973), 2,
      sym_THEORY_OP,
      sym_NOT,
  [19801] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(603), 1,
      sym_RPAREN,
    ACTIONS(975), 1,
      sym_COMMA,
    STATE(258), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
  [19821] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(977), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19835] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19847] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19859] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(983), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [19873] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(985), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(287), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19899] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(987), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(989), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19913] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19925] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    STATE(270), 1,
      sym_theory_op_list,
    STATE(306), 1,
      sym_theory_op,
    ACTIONS(917), 2,
      sym_DOT,
      sym_IF,
  [19945] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 1,
      sym_COLON,
    ACTIONS(963), 1,
      sym_COMMA,
    STATE(463), 1,
      sym_noptimizetuple,
    STATE(560), 1,
      sym_noptimizecond,
    ACTIONS(991), 2,
      sym_RBRACE,
      sym_SEM,
  [19965] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(985), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(993), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [19979] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 1,
      sym_COLON,
    ACTIONS(963), 1,
      sym_COMMA,
    STATE(488), 1,
      sym_noptimizetuple,
    STATE(596), 1,
      sym_noptimizecond,
    ACTIONS(995), 2,
      sym_RBRACE,
      sym_SEM,
  [19999] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    ACTIONS(997), 1,
      sym_COMMA,
    STATE(208), 1,
      sym_theory_op,
    ACTIONS(999), 2,
      sym_DOT,
      sym_SEM,
  [20019] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20031] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(937), 1,
      sym_COMMA,
    STATE(271), 1,
      sym_dsym,
    ACTIONS(889), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(1001), 2,
      sym_DOT,
      sym_IF,
  [20049] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(933), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20061] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(295), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [20075] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(1003), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [20089] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 1,
      sym_COLON,
    ACTIONS(963), 1,
      sym_COMMA,
    STATE(462), 1,
      sym_noptimizetuple,
    STATE(594), 1,
      sym_noptimizecond,
    ACTIONS(1005), 2,
      sym_RBRACE,
      sym_SEM,
  [20109] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(283), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20122] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(543), 1,
      sym_theory_atom_type,
    ACTIONS(921), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [20135] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_COMMA,
    ACTIONS(1007), 4,
      sym_COLON,
      sym_RBRACE,
      sym_RBRACK,
      sym_SEM,
  [20148] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1011), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [20159] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20170] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(1003), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20183] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(327), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20194] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(542), 1,
      sym_theory_atom_type,
    ACTIONS(921), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [20207] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      sym_NOT,
    ACTIONS(1013), 1,
      sym_LPAREN,
    ACTIONS(911), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20222] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(295), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20235] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(299), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20248] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(287), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20261] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20272] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(957), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(955), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20285] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1015), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [20296] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(911), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20309] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_COLON,
    ACTIONS(1009), 1,
      sym_COMMA,
    STATE(600), 1,
      sym_noptcondition,
    ACTIONS(391), 2,
      sym_RBRACE,
      sym_SEM,
  [20326] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    STATE(211), 1,
      sym_theory_op,
    ACTIONS(925), 2,
      sym_DOT,
      sym_IF,
  [20343] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(977), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20356] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(933), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(931), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20369] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(947), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20382] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(339), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20393] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_COLON,
    ACTIONS(1017), 1,
      sym_COMMA,
    STATE(615), 1,
      sym_noptcondition,
    ACTIONS(375), 2,
      sym_RBRACE,
      sym_SEM,
  [20410] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1019), 1,
      sym_RBRACE,
    STATE(536), 1,
      sym_theory_operator_nlist,
    STATE(619), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
  [20427] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      sym_THEORY_OP,
    ACTIONS(577), 1,
      sym_NOT,
    STATE(196), 1,
      sym_theory_op,
    ACTIONS(999), 2,
      sym_DOT,
      sym_IF,
  [20444] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(987), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20457] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(985), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(993), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20470] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(759), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20481] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      sym_NOT,
    ACTIONS(911), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20493] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1021), 1,
      sym_COLON,
    ACTIONS(1025), 1,
      sym_DOT,
    ACTIONS(1023), 2,
      sym_COMMA,
      sym_SEM,
  [20507] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1027), 1,
      sym_SUB,
    ACTIONS(1029), 1,
      sym_identifier,
    STATE(170), 1,
      sym__widentifier,
    STATE(512), 1,
      sym_atom,
  [20523] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_COLON,
    STATE(601), 1,
      sym_noptcondition,
    ACTIONS(1031), 2,
      sym_RBRACE,
      sym_SEM,
  [20537] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1027), 1,
      sym_SUB,
    ACTIONS(1029), 1,
      sym_identifier,
    STATE(170), 1,
      sym__widentifier,
    STATE(597), 1,
      sym_atom,
  [20553] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(1033), 1,
      sym_SLASH,
    ACTIONS(327), 2,
      sym_COLON,
      sym_DOT,
  [20567] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_COLON,
    STATE(575), 1,
      sym_noptcondition,
    ACTIONS(1035), 2,
      sym_RBRACE,
      sym_SEM,
  [20581] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1037), 1,
      sym_SUB,
    ACTIONS(1039), 1,
      sym_identifier,
    STATE(170), 1,
      sym__widentifier,
    STATE(516), 1,
      sym_atom,
  [20597] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 1,
      sym_COLON,
    STATE(545), 1,
      sym_noptimizecond,
    ACTIONS(1041), 2,
      sym_RBRACE,
      sym_SEM,
  [20611] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 1,
      sym_COLON,
    STATE(569), 1,
      sym_noptimizecond,
    ACTIONS(1043), 2,
      sym_RBRACE,
      sym_SEM,
  [20625] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 1,
      sym_COLON,
    STATE(592), 1,
      sym_noptimizecond,
    ACTIONS(1045), 2,
      sym_RBRACE,
      sym_SEM,
  [20639] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1049), 1,
      sym_LBRACE,
    ACTIONS(1047), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [20651] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 1,
      sym_NOT,
    ACTIONS(977), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20663] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(933), 1,
      sym_NOT,
    ACTIONS(931), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20675] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 1,
      sym_NOT,
    ACTIONS(947), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20687] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 1,
      sym_NOT,
    ACTIONS(987), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20699] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(985), 1,
      sym_NOT,
    ACTIONS(993), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20711] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 1,
      sym_NOT,
    ACTIONS(1003), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20723] = 4,
    ACTIONS(1051), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_DQUOTE,
    STATE(493), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1055), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20737] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(957), 1,
      sym_NOT,
    ACTIONS(955), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20749] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 1,
      sym_NOT,
    ACTIONS(283), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20761] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 1,
      sym_NOT,
    ACTIONS(287), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20773] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 1,
      sym_NOT,
    ACTIONS(299), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 1,
      sym_NOT,
    ACTIONS(295), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20797] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(611), 1,
      sym_theory_operator_definition,
    STATE(685), 1,
      sym_theory_op,
    ACTIONS(973), 2,
      sym_THEORY_OP,
      sym_NOT,
  [20811] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_COLON,
    STATE(588), 1,
      sym_noptcondition,
    ACTIONS(1057), 2,
      sym_RBRACE,
      sym_SEM,
  [20825] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_COLON,
    STATE(631), 1,
      sym_noptcondition,
    ACTIONS(1059), 2,
      sym_RBRACE,
      sym_SEM,
  [20839] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_COLON,
    STATE(539), 1,
      sym_noptcondition,
    ACTIONS(1061), 2,
      sym_RBRACE,
      sym_SEM,
  [20853] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1021), 1,
      sym_COLON,
    ACTIONS(1065), 1,
      sym_DOT,
    ACTIONS(1063), 2,
      sym_COMMA,
      sym_SEM,
  [20867] = 4,
    ACTIONS(1051), 1,
      sym_comment,
    ACTIONS(1067), 1,
      anon_sym_DQUOTE,
    STATE(484), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1069), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20881] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(1071), 1,
      sym_SLASH,
    ACTIONS(331), 2,
      sym_COLON,
      sym_DOT,
  [20895] = 4,
    ACTIONS(1051), 1,
      sym_comment,
    ACTIONS(1073), 1,
      anon_sym_DQUOTE,
    STATE(485), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1075), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20909] = 4,
    ACTIONS(1051), 1,
      sym_comment,
    ACTIONS(1077), 1,
      anon_sym_DQUOTE,
    STATE(485), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1079), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20923] = 4,
    ACTIONS(1051), 1,
      sym_comment,
    ACTIONS(1082), 1,
      anon_sym_DQUOTE,
    STATE(487), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1084), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20937] = 4,
    ACTIONS(1051), 1,
      sym_comment,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    STATE(485), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1075), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20951] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 1,
      sym_COLON,
    STATE(593), 1,
      sym_noptimizecond,
    ACTIONS(1088), 2,
      sym_RBRACE,
      sym_SEM,
  [20965] = 4,
    ACTIONS(1051), 1,
      sym_comment,
    ACTIONS(1090), 1,
      anon_sym_DQUOTE,
    STATE(492), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1092), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [20979] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_COLON,
    STATE(573), 1,
      sym_noptcondition,
    ACTIONS(1094), 2,
      sym_RBRACE,
      sym_SEM,
  [20993] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym_COLON,
    STATE(595), 1,
      sym_noptcondition,
    ACTIONS(1096), 2,
      sym_RBRACE,
      sym_SEM,
  [21007] = 4,
    ACTIONS(1051), 1,
      sym_comment,
    ACTIONS(1098), 1,
      anon_sym_DQUOTE,
    STATE(485), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1075), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21021] = 4,
    ACTIONS(1051), 1,
      sym_comment,
    ACTIONS(1100), 1,
      anon_sym_DQUOTE,
    STATE(485), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1075), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21035] = 4,
    ACTIONS(1051), 1,
      sym_comment,
    ACTIONS(1102), 1,
      anon_sym_DQUOTE,
    STATE(495), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1104), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21049] = 4,
    ACTIONS(1051), 1,
      sym_comment,
    ACTIONS(1106), 1,
      anon_sym_DQUOTE,
    STATE(485), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1075), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21063] = 4,
    ACTIONS(1051), 1,
      sym_comment,
    ACTIONS(1108), 1,
      anon_sym_DQUOTE,
    STATE(497), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1110), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21077] = 4,
    ACTIONS(1051), 1,
      sym_comment,
    ACTIONS(1112), 1,
      anon_sym_DQUOTE,
    STATE(485), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1075), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21091] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1116), 1,
      sym_DOT,
    ACTIONS(1114), 2,
      sym_COMMA,
      sym_SEM,
  [21102] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 1,
      sym_COMMA,
    ACTIONS(1120), 2,
      sym_RBRACE,
      sym_SEM,
  [21113] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1122), 1,
      sym_identifier,
    STATE(144), 1,
      sym__widentifier,
    STATE(464), 1,
      sym_theory_atom_name,
  [21126] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      sym_DOT,
    ACTIONS(1124), 2,
      sym_COMMA,
      sym_SEM,
  [21137] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1128), 1,
      sym_LBRACE,
    ACTIONS(1047), 2,
      sym_DOT,
      sym_IF,
  [21148] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(395), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21157] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 1,
      sym_COMMA,
    ACTIONS(1130), 2,
      sym_DOT,
      sym_SEM,
  [21168] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 1,
      sym_COMMA,
    ACTIONS(939), 2,
      sym_RBRACE,
      sym_SEM,
  [21179] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_COMMA,
    ACTIONS(1132), 2,
      sym_RPAREN,
      sym_SEM,
  [21190] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1134), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21199] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1136), 1,
      sym_COMMA,
    ACTIONS(1138), 2,
      sym_RBRACE,
      sym_SEM,
  [21210] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1140), 1,
      sym_COLON,
    ACTIONS(1142), 1,
      sym_DOT,
    STATE(23), 1,
      sym_bodyconddot,
  [21223] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(963), 1,
      sym_COMMA,
    ACTIONS(1144), 1,
      sym_RBRACK,
    STATE(674), 1,
      sym_noptimizetuple,
  [21236] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1146), 3,
      sym_COMMA,
      sym_LBRACE,
      sym_SLASH,
  [21245] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1140), 1,
      sym_COLON,
    ACTIONS(1142), 1,
      sym_DOT,
    STATE(690), 1,
      sym_bodyconddot,
  [21258] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1148), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [21267] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1150), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [21276] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(327), 2,
      sym_COLON,
      sym_DOT,
  [21287] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1140), 1,
      sym_COLON,
    ACTIONS(1142), 1,
      sym_DOT,
    STATE(25), 1,
      sym_bodyconddot,
  [21300] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1152), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [21309] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_COMMA,
    ACTIONS(1154), 2,
      sym_RPAREN,
      sym_SEM,
  [21320] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1025), 1,
      sym_DOT,
    ACTIONS(1023), 2,
      sym_COMMA,
      sym_SEM,
  [21331] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 1,
      sym_COMMA,
    ACTIONS(1156), 2,
      sym_RBRACE,
      sym_SEM,
  [21342] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_LPAREN,
    ACTIONS(331), 2,
      sym_COLON,
      sym_DOT,
  [21353] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21362] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(1160), 1,
      sym_LT,
    STATE(651), 1,
      sym_STRING,
  [21375] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21384] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1162), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [21393] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(540), 1,
      sym_theory_op,
    ACTIONS(577), 2,
      sym_THEORY_OP,
      sym_NOT,
  [21404] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [21413] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1168), 1,
      sym_identifier,
    ACTIONS(1166), 2,
      sym_CSP,
      sym_SUB,
  [21424] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1122), 1,
      sym_identifier,
    STATE(144), 1,
      sym__widentifier,
    STATE(502), 1,
      sym_theory_atom_name,
  [21437] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21446] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1170), 1,
      sym_COMMA,
    ACTIONS(1172), 2,
      sym_RPAREN,
      sym_SEM,
  [21457] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym_RPAREN,
    ACTIONS(1174), 1,
      sym_identifier,
    STATE(602), 1,
      sym_nidlist,
  [21470] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1065), 1,
      sym_DOT,
    ACTIONS(1063), 2,
      sym_COMMA,
      sym_SEM,
  [21481] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1176), 1,
      sym_RPAREN,
    ACTIONS(1178), 1,
      sym_SEM,
  [21491] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(621), 1,
      sym_RBRACK,
    ACTIONS(1180), 1,
      sym_COMMA,
  [21501] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_COMMA,
    ACTIONS(1184), 1,
      sym_RBRACE,
  [21511] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 2,
      sym_RBRACE,
      sym_SEM,
  [21519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1180), 1,
      sym_COMMA,
    ACTIONS(1188), 1,
      sym_RPAREN,
  [21529] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1190), 2,
      sym_RBRACE,
      sym_SEM,
  [21537] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1192), 2,
      sym_COMMA,
      sym_RBRACE,
  [21545] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 2,
      sym_RBRACE,
      sym_SEM,
  [21553] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1194), 2,
      sym_RBRACE,
      sym_SEM,
  [21561] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1196), 2,
      sym_RBRACE,
      sym_SEM,
  [21569] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1063), 1,
      sym_SEM,
    ACTIONS(1065), 1,
      sym_DOT,
  [21579] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1198), 2,
      sym_RBRACE,
      sym_SEM,
  [21587] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1180), 1,
      sym_COMMA,
    ACTIONS(1200), 1,
      sym_RPAREN,
  [21597] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1166), 1,
      sym_SUB,
    ACTIONS(1168), 1,
      sym_identifier,
  [21607] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(613), 1,
      sym_RPAREN,
    ACTIONS(1180), 1,
      sym_COMMA,
  [21617] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1202), 2,
      sym_RBRACE,
      sym_SEM,
  [21625] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1178), 1,
      sym_SEM,
    ACTIONS(1204), 1,
      sym_RPAREN,
  [21635] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 1,
      sym_RBRACE,
    ACTIONS(1208), 1,
      sym_SEM,
  [21645] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(557), 1,
      sym_RBRACE,
    ACTIONS(1210), 1,
      sym_SEM,
  [21655] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1212), 1,
      sym_RPAREN,
    ACTIONS(1214), 1,
      sym_SEM,
  [21665] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1172), 2,
      sym_RPAREN,
      sym_SEM,
  [21673] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(951), 2,
      sym_RBRACE,
      sym_SEM,
  [21681] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 2,
      sym_DOT,
      sym_IF,
  [21689] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 1,
      sym_RBRACK,
    ACTIONS(1180), 1,
      sym_COMMA,
  [21699] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym_RBRACE,
    ACTIONS(1216), 1,
      sym_SEM,
  [21709] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1218), 1,
      sym_RBRACE,
    ACTIONS(1220), 1,
      sym_SEM,
  [21719] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1045), 2,
      sym_RBRACE,
      sym_SEM,
  [21727] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 2,
      sym_RBRACE,
      sym_SEM,
  [21735] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 1,
      sym_RBRACE,
    ACTIONS(1180), 1,
      sym_COMMA,
  [21745] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1224), 2,
      sym_RBRACE,
      sym_SEM,
  [21753] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1226), 2,
      sym_RBRACE,
      sym_SEM,
  [21761] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1228), 1,
      sym_RPAREN,
    ACTIONS(1230), 1,
      sym_SEM,
  [21771] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1232), 2,
      sym_COMMA,
      sym_RPAREN,
  [21779] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1178), 1,
      sym_SEM,
    ACTIONS(1234), 1,
      sym_RPAREN,
  [21789] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1041), 2,
      sym_RBRACE,
      sym_SEM,
  [21797] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1236), 2,
      sym_RBRACE,
      sym_SEM,
  [21805] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(209), 1,
      sym_DOT,
    ACTIONS(1238), 1,
      sym_IF,
  [21815] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1240), 2,
      sym_RBRACE,
      sym_SEM,
  [21823] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 2,
      sym_DOT,
      sym_IF,
  [21831] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 2,
      sym_RBRACE,
      sym_SEM,
  [21839] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 1,
      sym_SEM,
    ACTIONS(1244), 1,
      sym_RPAREN,
  [21849] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1059), 2,
      sym_RBRACE,
      sym_SEM,
  [21857] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1023), 1,
      sym_SEM,
    ACTIONS(1025), 1,
      sym_DOT,
  [21867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1180), 1,
      sym_COMMA,
    ACTIONS(1246), 1,
      sym_RPAREN,
  [21877] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1248), 2,
      sym_DEFAULT,
      sym_OVERRIDE,
  [21885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      sym_RPAREN,
    ACTIONS(1180), 1,
      sym_COMMA,
  [21895] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      sym_DOT,
    ACTIONS(1250), 1,
      sym_LPAREN,
  [21905] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1252), 2,
      sym_RBRACE,
      sym_SEM,
  [21913] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1254), 2,
      sym_RBRACE,
      sym_SEM,
  [21921] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(595), 1,
      sym_RBRACK,
    ACTIONS(1180), 1,
      sym_COMMA,
  [21931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(605), 1,
      sym_RPAREN,
    ACTIONS(1180), 1,
      sym_COMMA,
  [21941] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_COMMA,
    ACTIONS(1256), 1,
      sym_COLON,
  [21951] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1258), 1,
      sym_RBRACE,
    ACTIONS(1260), 1,
      sym_SEM,
  [21961] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_COMMA,
    ACTIONS(1262), 1,
      sym_COLON,
  [21971] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1031), 2,
      sym_RBRACE,
      sym_SEM,
  [21979] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1264), 1,
      sym_RBRACE,
    ACTIONS(1266), 1,
      sym_SEM,
  [21989] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(595), 1,
      sym_RBRACE,
    ACTIONS(1180), 1,
      sym_COMMA,
  [21999] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1176), 1,
      sym_VBAR,
    ACTIONS(1268), 1,
      sym_SEM,
  [22009] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1005), 2,
      sym_RBRACE,
      sym_SEM,
  [22017] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(965), 2,
      sym_RBRACE,
      sym_SEM,
  [22025] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1043), 2,
      sym_RBRACE,
      sym_SEM,
  [22033] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1270), 2,
      sym_RBRACE,
      sym_SEM,
  [22041] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1088), 2,
      sym_RBRACE,
      sym_SEM,
  [22049] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1272), 1,
      sym_COLON,
    ACTIONS(1274), 1,
      sym_DOT,
  [22059] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(909), 2,
      sym_DOT,
      sym_IF,
  [22067] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1276), 2,
      sym_COMMA,
      sym_RPAREN,
  [22075] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1120), 2,
      sym_RBRACE,
      sym_SEM,
  [22083] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1035), 2,
      sym_RBRACE,
      sym_SEM,
  [22091] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1278), 1,
      sym_COMMA,
    ACTIONS(1280), 1,
      sym_RPAREN,
  [22101] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 2,
      sym_DOT,
      sym_IF,
  [22109] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1282), 2,
      sym_RBRACE,
      sym_SEM,
  [22117] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 2,
      sym_DOT,
      sym_IF,
  [22125] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1284), 1,
      sym_identifier,
    STATE(171), 1,
      sym__widentifier,
  [22135] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(335), 2,
      sym_COLON,
      sym_DOT,
  [22143] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_COMMA,
    ACTIONS(1286), 1,
      sym_COLON,
  [22153] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(969), 2,
      sym_RBRACE,
      sym_SEM,
  [22161] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1180), 1,
      sym_COMMA,
    ACTIONS(1288), 1,
      sym_RPAREN,
  [22171] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1290), 2,
      sym_RBRACE,
      sym_SEM,
  [22179] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1292), 1,
      sym_COMMA,
    ACTIONS(1294), 1,
      sym_RPAREN,
  [22189] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(683), 1,
      sym_RPAREN,
    ACTIONS(1296), 1,
      sym_COMMA,
  [22199] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1298), 2,
      sym_RBRACE,
      sym_SEM,
  [22207] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1156), 2,
      sym_RBRACE,
      sym_SEM,
  [22215] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1300), 1,
      sym_RBRACE,
    ACTIONS(1302), 1,
      sym_SEM,
  [22225] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      sym_RPAREN,
    ACTIONS(1180), 1,
      sym_COMMA,
  [22235] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1304), 1,
      sym_identifier,
    STATE(203), 1,
      sym__widentifier,
  [22245] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1306), 2,
      sym_COMMA,
      sym_RBRACE,
  [22253] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(621), 1,
      sym_RBRACE,
    ACTIONS(1180), 1,
      sym_COMMA,
  [22263] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1308), 2,
      sym_LEFT,
      sym_RIGHT,
  [22271] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      sym_RBRACE,
    ACTIONS(1310), 1,
      sym_SEM,
  [22281] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1312), 2,
      sym_RBRACE,
      sym_SEM,
  [22289] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1314), 2,
      sym_DOT,
      sym_IF,
  [22297] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 1,
      sym_RBRACE,
    ACTIONS(1316), 1,
      sym_SEM,
  [22307] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1318), 1,
      sym_identifier,
    STATE(183), 1,
      sym__widentifier,
  [22317] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1320), 2,
      sym_RBRACE,
      sym_SEM,
  [22325] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1322), 2,
      sym_RBRACE,
      sym_SEM,
  [22333] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1178), 1,
      sym_SEM,
    ACTIONS(1324), 1,
      sym_RPAREN,
  [22343] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1326), 1,
      sym_identifier,
    STATE(171), 1,
      sym__widentifier,
  [22353] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1328), 2,
      sym_RBRACE,
      sym_SEM,
  [22361] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1178), 1,
      sym_SEM,
    ACTIONS(1330), 1,
      sym_RPAREN,
  [22371] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      sym_RBRACE,
    ACTIONS(1266), 1,
      sym_SEM,
  [22381] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1178), 1,
      sym_SEM,
    ACTIONS(1332), 1,
      sym_RPAREN,
  [22391] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(603), 1,
      sym_RBRACK,
    ACTIONS(1180), 1,
      sym_COMMA,
  [22401] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(603), 1,
      sym_RBRACE,
    ACTIONS(1180), 1,
      sym_COMMA,
  [22411] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1334), 1,
      sym_identifier,
    STATE(188), 1,
      sym__widentifier,
  [22421] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1302), 1,
      sym_SEM,
    ACTIONS(1336), 1,
      sym_RBRACE,
  [22431] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1268), 1,
      sym_SEM,
    ACTIONS(1338), 1,
      sym_VBAR,
  [22441] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1340), 2,
      sym_RBRACE,
      sym_SEM,
  [22449] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1342), 1,
      sym_RBRACE,
    ACTIONS(1344), 1,
      sym_SEM,
  [22459] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1178), 1,
      sym_SEM,
    ACTIONS(1346), 1,
      sym_RPAREN,
  [22469] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1348), 1,
      sym_UNARY,
    ACTIONS(1350), 1,
      sym_BINARY,
  [22479] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(617), 1,
      sym_RPAREN,
    ACTIONS(1178), 1,
      sym_SEM,
  [22489] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_COMMA,
    ACTIONS(1352), 1,
      sym_COLON,
  [22499] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1178), 1,
      sym_SEM,
    ACTIONS(1354), 1,
      sym_RPAREN,
  [22509] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1178), 1,
      sym_SEM,
    ACTIONS(1338), 1,
      sym_RPAREN,
  [22519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1178), 1,
      sym_SEM,
    ACTIONS(1356), 1,
      sym_RPAREN,
  [22529] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_RBRACE,
    ACTIONS(1266), 1,
      sym_SEM,
  [22539] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1144), 1,
      sym_DOT,
  [22546] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 1,
      sym_DOT,
  [22553] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1358), 1,
      sym_COMMA,
  [22560] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1280), 1,
      sym_RBRACE,
  [22567] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1338), 1,
      sym_RPAREN,
  [22574] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1360), 1,
      sym_identifier,
  [22581] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1033), 1,
      sym_SLASH,
  [22588] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1362), 1,
      sym_LBRACE,
  [22595] = 2,
    ACTIONS(1051), 1,
      sym_comment,
    ACTIONS(1364), 1,
      sym_CODE,
  [22602] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1366), 1,
      sym_COMMA,
  [22609] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1368), 1,
      sym_LBRACE,
  [22616] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1370), 1,
      sym_COMMA,
  [22623] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(683), 1,
      sym_RPAREN,
  [22630] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1372), 1,
      sym_LBRACK,
  [22637] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1374), 1,
      sym_COMMA,
  [22644] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(871), 1,
      sym_DOT,
  [22651] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1376), 1,
      ts_builtin_sym_end,
  [22658] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1378), 1,
      sym_LPAREN,
  [22665] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      sym_RBRACE,
  [22672] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1380), 1,
      sym_LBRACE,
  [22679] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1382), 1,
      sym_LBRACE,
  [22686] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1384), 1,
      sym_identifier,
  [22693] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 1,
      sym_identifier,
  [22700] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1388), 1,
      sym_identifier,
  [22707] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(871), 1,
      sym_RBRACK,
  [22714] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1390), 1,
      sym_SLASH,
  [22721] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1392), 1,
      sym_identifier,
  [22728] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(551), 1,
      sym_CSP,
  [22735] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1394), 1,
      sym_LBRACE,
  [22742] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(591), 1,
      sym_CSP,
  [22749] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 1,
      sym_RPAREN,
  [22756] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1396), 1,
      sym_identifier,
  [22763] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym_GT,
  [22770] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(729), 1,
      sym_COLON,
  [22777] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1071), 1,
      sym_SLASH,
  [22784] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1398), 1,
      sym_COLON,
  [22791] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_COLON,
  [22798] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1402), 1,
      sym_DOT,
  [22805] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1404), 1,
      sym_RBRACE,
  [22812] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1406), 1,
      sym_LBRACE,
  [22819] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1408), 1,
      sym_LBRACK,
  [22826] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1410), 1,
      sym_RPAREN,
  [22833] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1412), 1,
      sym_LBRACE,
  [22840] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1176), 1,
      sym_RPAREN,
  [22847] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_identifier,
  [22854] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 1,
      sym_LPAREN,
  [22861] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      sym_COMMA,
  [22868] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(869), 1,
      sym_RBRACK,
  [22875] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1420), 1,
      sym_LBRACE,
  [22882] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1422), 1,
      sym_EQ,
  [22889] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1424), 1,
      sym_LBRACE,
  [22896] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1426), 1,
      sym_COMMA,
  [22903] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1428), 1,
      sym_COMMA,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(4)] = 0,
  [SMALL_STATE(5)] = 125,
  [SMALL_STATE(6)] = 250,
  [SMALL_STATE(7)] = 375,
  [SMALL_STATE(8)] = 500,
  [SMALL_STATE(9)] = 554,
  [SMALL_STATE(10)] = 608,
  [SMALL_STATE(11)] = 664,
  [SMALL_STATE(12)] = 718,
  [SMALL_STATE(13)] = 772,
  [SMALL_STATE(14)] = 894,
  [SMALL_STATE(15)] = 948,
  [SMALL_STATE(16)] = 1004,
  [SMALL_STATE(17)] = 1058,
  [SMALL_STATE(18)] = 1180,
  [SMALL_STATE(19)] = 1302,
  [SMALL_STATE(20)] = 1358,
  [SMALL_STATE(21)] = 1411,
  [SMALL_STATE(22)] = 1464,
  [SMALL_STATE(23)] = 1517,
  [SMALL_STATE(24)] = 1570,
  [SMALL_STATE(25)] = 1623,
  [SMALL_STATE(26)] = 1676,
  [SMALL_STATE(27)] = 1729,
  [SMALL_STATE(28)] = 1782,
  [SMALL_STATE(29)] = 1898,
  [SMALL_STATE(30)] = 1950,
  [SMALL_STATE(31)] = 2000,
  [SMALL_STATE(32)] = 2050,
  [SMALL_STATE(33)] = 2102,
  [SMALL_STATE(34)] = 2152,
  [SMALL_STATE(35)] = 2202,
  [SMALL_STATE(36)] = 2251,
  [SMALL_STATE(37)] = 2304,
  [SMALL_STATE(38)] = 2353,
  [SMALL_STATE(39)] = 2402,
  [SMALL_STATE(40)] = 2467,
  [SMALL_STATE(41)] = 2518,
  [SMALL_STATE(42)] = 2583,
  [SMALL_STATE(43)] = 2642,
  [SMALL_STATE(44)] = 2691,
  [SMALL_STATE(45)] = 2740,
  [SMALL_STATE(46)] = 2795,
  [SMALL_STATE(47)] = 2852,
  [SMALL_STATE(48)] = 2906,
  [SMALL_STATE(49)] = 2960,
  [SMALL_STATE(50)] = 3011,
  [SMALL_STATE(51)] = 3062,
  [SMALL_STATE(52)] = 3114,
  [SMALL_STATE(53)] = 3166,
  [SMALL_STATE(54)] = 3215,
  [SMALL_STATE(55)] = 3264,
  [SMALL_STATE(56)] = 3361,
  [SMALL_STATE(57)] = 3458,
  [SMALL_STATE(58)] = 3552,
  [SMALL_STATE(59)] = 3646,
  [SMALL_STATE(60)] = 3723,
  [SMALL_STATE(61)] = 3800,
  [SMALL_STATE(62)] = 3892,
  [SMALL_STATE(63)] = 3984,
  [SMALL_STATE(64)] = 4073,
  [SMALL_STATE(65)] = 4162,
  [SMALL_STATE(66)] = 4239,
  [SMALL_STATE(67)] = 4328,
  [SMALL_STATE(68)] = 4417,
  [SMALL_STATE(69)] = 4508,
  [SMALL_STATE(70)] = 4597,
  [SMALL_STATE(71)] = 4686,
  [SMALL_STATE(72)] = 4763,
  [SMALL_STATE(73)] = 4840,
  [SMALL_STATE(74)] = 4916,
  [SMALL_STATE(75)] = 5004,
  [SMALL_STATE(76)] = 5080,
  [SMALL_STATE(77)] = 5156,
  [SMALL_STATE(78)] = 5238,
  [SMALL_STATE(79)] = 5320,
  [SMALL_STATE(80)] = 5402,
  [SMALL_STATE(81)] = 5484,
  [SMALL_STATE(82)] = 5566,
  [SMALL_STATE(83)] = 5648,
  [SMALL_STATE(84)] = 5730,
  [SMALL_STATE(85)] = 5812,
  [SMALL_STATE(86)] = 5894,
  [SMALL_STATE(87)] = 5967,
  [SMALL_STATE(88)] = 6040,
  [SMALL_STATE(89)] = 6113,
  [SMALL_STATE(90)] = 6186,
  [SMALL_STATE(91)] = 6222,
  [SMALL_STATE(92)] = 6258,
  [SMALL_STATE(93)] = 6334,
  [SMALL_STATE(94)] = 6410,
  [SMALL_STATE(95)] = 6446,
  [SMALL_STATE(96)] = 6482,
  [SMALL_STATE(97)] = 6541,
  [SMALL_STATE(98)] = 6614,
  [SMALL_STATE(99)] = 6673,
  [SMALL_STATE(100)] = 6746,
  [SMALL_STATE(101)] = 6816,
  [SMALL_STATE(102)] = 6852,
  [SMALL_STATE(103)] = 6888,
  [SMALL_STATE(104)] = 6950,
  [SMALL_STATE(105)] = 6984,
  [SMALL_STATE(106)] = 7018,
  [SMALL_STATE(107)] = 7052,
  [SMALL_STATE(108)] = 7114,
  [SMALL_STATE(109)] = 7184,
  [SMALL_STATE(110)] = 7217,
  [SMALL_STATE(111)] = 7250,
  [SMALL_STATE(112)] = 7317,
  [SMALL_STATE(113)] = 7384,
  [SMALL_STATE(114)] = 7417,
  [SMALL_STATE(115)] = 7484,
  [SMALL_STATE(116)] = 7517,
  [SMALL_STATE(117)] = 7584,
  [SMALL_STATE(118)] = 7633,
  [SMALL_STATE(119)] = 7666,
  [SMALL_STATE(120)] = 7733,
  [SMALL_STATE(121)] = 7800,
  [SMALL_STATE(122)] = 7867,
  [SMALL_STATE(123)] = 7900,
  [SMALL_STATE(124)] = 7941,
  [SMALL_STATE(125)] = 7980,
  [SMALL_STATE(126)] = 8013,
  [SMALL_STATE(127)] = 8050,
  [SMALL_STATE(128)] = 8083,
  [SMALL_STATE(129)] = 8150,
  [SMALL_STATE(130)] = 8183,
  [SMALL_STATE(131)] = 8216,
  [SMALL_STATE(132)] = 8267,
  [SMALL_STATE(133)] = 8316,
  [SMALL_STATE(134)] = 8367,
  [SMALL_STATE(135)] = 8434,
  [SMALL_STATE(136)] = 8477,
  [SMALL_STATE(137)] = 8512,
  [SMALL_STATE(138)] = 8545,
  [SMALL_STATE(139)] = 8578,
  [SMALL_STATE(140)] = 8645,
  [SMALL_STATE(141)] = 8711,
  [SMALL_STATE(142)] = 8775,
  [SMALL_STATE(143)] = 8841,
  [SMALL_STATE(144)] = 8907,
  [SMALL_STATE(145)] = 8971,
  [SMALL_STATE(146)] = 9037,
  [SMALL_STATE(147)] = 9101,
  [SMALL_STATE(148)] = 9167,
  [SMALL_STATE(149)] = 9233,
  [SMALL_STATE(150)] = 9283,
  [SMALL_STATE(151)] = 9347,
  [SMALL_STATE(152)] = 9411,
  [SMALL_STATE(153)] = 9477,
  [SMALL_STATE(154)] = 9541,
  [SMALL_STATE(155)] = 9605,
  [SMALL_STATE(156)] = 9669,
  [SMALL_STATE(157)] = 9733,
  [SMALL_STATE(158)] = 9783,
  [SMALL_STATE(159)] = 9847,
  [SMALL_STATE(160)] = 9913,
  [SMALL_STATE(161)] = 9979,
  [SMALL_STATE(162)] = 10045,
  [SMALL_STATE(163)] = 10109,
  [SMALL_STATE(164)] = 10175,
  [SMALL_STATE(165)] = 10223,
  [SMALL_STATE(166)] = 10287,
  [SMALL_STATE(167)] = 10351,
  [SMALL_STATE(168)] = 10415,
  [SMALL_STATE(169)] = 10481,
  [SMALL_STATE(170)] = 10545,
  [SMALL_STATE(171)] = 10609,
  [SMALL_STATE(172)] = 10673,
  [SMALL_STATE(173)] = 10739,
  [SMALL_STATE(174)] = 10803,
  [SMALL_STATE(175)] = 10867,
  [SMALL_STATE(176)] = 10933,
  [SMALL_STATE(177)] = 10999,
  [SMALL_STATE(178)] = 11065,
  [SMALL_STATE(179)] = 11129,
  [SMALL_STATE(180)] = 11190,
  [SMALL_STATE(181)] = 11253,
  [SMALL_STATE(182)] = 11316,
  [SMALL_STATE(183)] = 11365,
  [SMALL_STATE(184)] = 11426,
  [SMALL_STATE(185)] = 11487,
  [SMALL_STATE(186)] = 11548,
  [SMALL_STATE(187)] = 11611,
  [SMALL_STATE(188)] = 11672,
  [SMALL_STATE(189)] = 11733,
  [SMALL_STATE(190)] = 11794,
  [SMALL_STATE(191)] = 11857,
  [SMALL_STATE(192)] = 11918,
  [SMALL_STATE(193)] = 11965,
  [SMALL_STATE(194)] = 12024,
  [SMALL_STATE(195)] = 12085,
  [SMALL_STATE(196)] = 12146,
  [SMALL_STATE(197)] = 12206,
  [SMALL_STATE(198)] = 12266,
  [SMALL_STATE(199)] = 12324,
  [SMALL_STATE(200)] = 12382,
  [SMALL_STATE(201)] = 12440,
  [SMALL_STATE(202)] = 12470,
  [SMALL_STATE(203)] = 12528,
  [SMALL_STATE(204)] = 12588,
  [SMALL_STATE(205)] = 12646,
  [SMALL_STATE(206)] = 12704,
  [SMALL_STATE(207)] = 12764,
  [SMALL_STATE(208)] = 12822,
  [SMALL_STATE(209)] = 12882,
  [SMALL_STATE(210)] = 12942,
  [SMALL_STATE(211)] = 13000,
  [SMALL_STATE(212)] = 13060,
  [SMALL_STATE(213)] = 13120,
  [SMALL_STATE(214)] = 13175,
  [SMALL_STATE(215)] = 13230,
  [SMALL_STATE(216)] = 13285,
  [SMALL_STATE(217)] = 13340,
  [SMALL_STATE(218)] = 13395,
  [SMALL_STATE(219)] = 13450,
  [SMALL_STATE(220)] = 13505,
  [SMALL_STATE(221)] = 13560,
  [SMALL_STATE(222)] = 13615,
  [SMALL_STATE(223)] = 13670,
  [SMALL_STATE(224)] = 13725,
  [SMALL_STATE(225)] = 13780,
  [SMALL_STATE(226)] = 13835,
  [SMALL_STATE(227)] = 13890,
  [SMALL_STATE(228)] = 13945,
  [SMALL_STATE(229)] = 14000,
  [SMALL_STATE(230)] = 14055,
  [SMALL_STATE(231)] = 14110,
  [SMALL_STATE(232)] = 14165,
  [SMALL_STATE(233)] = 14220,
  [SMALL_STATE(234)] = 14275,
  [SMALL_STATE(235)] = 14330,
  [SMALL_STATE(236)] = 14385,
  [SMALL_STATE(237)] = 14442,
  [SMALL_STATE(238)] = 14497,
  [SMALL_STATE(239)] = 14552,
  [SMALL_STATE(240)] = 14607,
  [SMALL_STATE(241)] = 14662,
  [SMALL_STATE(242)] = 14717,
  [SMALL_STATE(243)] = 14772,
  [SMALL_STATE(244)] = 14827,
  [SMALL_STATE(245)] = 14882,
  [SMALL_STATE(246)] = 14937,
  [SMALL_STATE(247)] = 14992,
  [SMALL_STATE(248)] = 15047,
  [SMALL_STATE(249)] = 15102,
  [SMALL_STATE(250)] = 15157,
  [SMALL_STATE(251)] = 15212,
  [SMALL_STATE(252)] = 15267,
  [SMALL_STATE(253)] = 15322,
  [SMALL_STATE(254)] = 15377,
  [SMALL_STATE(255)] = 15432,
  [SMALL_STATE(256)] = 15487,
  [SMALL_STATE(257)] = 15542,
  [SMALL_STATE(258)] = 15597,
  [SMALL_STATE(259)] = 15651,
  [SMALL_STATE(260)] = 15679,
  [SMALL_STATE(261)] = 15707,
  [SMALL_STATE(262)] = 15761,
  [SMALL_STATE(263)] = 15815,
  [SMALL_STATE(264)] = 15869,
  [SMALL_STATE(265)] = 15923,
  [SMALL_STATE(266)] = 15951,
  [SMALL_STATE(267)] = 16005,
  [SMALL_STATE(268)] = 16033,
  [SMALL_STATE(269)] = 16087,
  [SMALL_STATE(270)] = 16141,
  [SMALL_STATE(271)] = 16195,
  [SMALL_STATE(272)] = 16223,
  [SMALL_STATE(273)] = 16274,
  [SMALL_STATE(274)] = 16325,
  [SMALL_STATE(275)] = 16376,
  [SMALL_STATE(276)] = 16427,
  [SMALL_STATE(277)] = 16478,
  [SMALL_STATE(278)] = 16529,
  [SMALL_STATE(279)] = 16580,
  [SMALL_STATE(280)] = 16631,
  [SMALL_STATE(281)] = 16682,
  [SMALL_STATE(282)] = 16733,
  [SMALL_STATE(283)] = 16777,
  [SMALL_STATE(284)] = 16821,
  [SMALL_STATE(285)] = 16865,
  [SMALL_STATE(286)] = 16891,
  [SMALL_STATE(287)] = 16917,
  [SMALL_STATE(288)] = 16961,
  [SMALL_STATE(289)] = 16987,
  [SMALL_STATE(290)] = 17012,
  [SMALL_STATE(291)] = 17037,
  [SMALL_STATE(292)] = 17062,
  [SMALL_STATE(293)] = 17100,
  [SMALL_STATE(294)] = 17140,
  [SMALL_STATE(295)] = 17180,
  [SMALL_STATE(296)] = 17220,
  [SMALL_STATE(297)] = 17258,
  [SMALL_STATE(298)] = 17298,
  [SMALL_STATE(299)] = 17335,
  [SMALL_STATE(300)] = 17358,
  [SMALL_STATE(301)] = 17389,
  [SMALL_STATE(302)] = 17428,
  [SMALL_STATE(303)] = 17467,
  [SMALL_STATE(304)] = 17490,
  [SMALL_STATE(305)] = 17513,
  [SMALL_STATE(306)] = 17552,
  [SMALL_STATE(307)] = 17575,
  [SMALL_STATE(308)] = 17599,
  [SMALL_STATE(309)] = 17627,
  [SMALL_STATE(310)] = 17651,
  [SMALL_STATE(311)] = 17675,
  [SMALL_STATE(312)] = 17702,
  [SMALL_STATE(313)] = 17727,
  [SMALL_STATE(314)] = 17748,
  [SMALL_STATE(315)] = 17771,
  [SMALL_STATE(316)] = 17792,
  [SMALL_STATE(317)] = 17813,
  [SMALL_STATE(318)] = 17842,
  [SMALL_STATE(319)] = 17875,
  [SMALL_STATE(320)] = 17898,
  [SMALL_STATE(321)] = 17925,
  [SMALL_STATE(322)] = 17958,
  [SMALL_STATE(323)] = 17979,
  [SMALL_STATE(324)] = 18000,
  [SMALL_STATE(325)] = 18021,
  [SMALL_STATE(326)] = 18042,
  [SMALL_STATE(327)] = 18079,
  [SMALL_STATE(328)] = 18116,
  [SMALL_STATE(329)] = 18138,
  [SMALL_STATE(330)] = 18174,
  [SMALL_STATE(331)] = 18210,
  [SMALL_STATE(332)] = 18244,
  [SMALL_STATE(333)] = 18268,
  [SMALL_STATE(334)] = 18302,
  [SMALL_STATE(335)] = 18338,
  [SMALL_STATE(336)] = 18374,
  [SMALL_STATE(337)] = 18408,
  [SMALL_STATE(338)] = 18444,
  [SMALL_STATE(339)] = 18478,
  [SMALL_STATE(340)] = 18511,
  [SMALL_STATE(341)] = 18544,
  [SMALL_STATE(342)] = 18575,
  [SMALL_STATE(343)] = 18608,
  [SMALL_STATE(344)] = 18641,
  [SMALL_STATE(345)] = 18674,
  [SMALL_STATE(346)] = 18697,
  [SMALL_STATE(347)] = 18730,
  [SMALL_STATE(348)] = 18763,
  [SMALL_STATE(349)] = 18794,
  [SMALL_STATE(350)] = 18824,
  [SMALL_STATE(351)] = 18842,
  [SMALL_STATE(352)] = 18860,
  [SMALL_STATE(353)] = 18878,
  [SMALL_STATE(354)] = 18896,
  [SMALL_STATE(355)] = 18926,
  [SMALL_STATE(356)] = 18947,
  [SMALL_STATE(357)] = 18968,
  [SMALL_STATE(358)] = 18989,
  [SMALL_STATE(359)] = 19009,
  [SMALL_STATE(360)] = 19029,
  [SMALL_STATE(361)] = 19053,
  [SMALL_STATE(362)] = 19077,
  [SMALL_STATE(363)] = 19101,
  [SMALL_STATE(364)] = 19124,
  [SMALL_STATE(365)] = 19145,
  [SMALL_STATE(366)] = 19160,
  [SMALL_STATE(367)] = 19175,
  [SMALL_STATE(368)] = 19190,
  [SMALL_STATE(369)] = 19205,
  [SMALL_STATE(370)] = 19226,
  [SMALL_STATE(371)] = 19247,
  [SMALL_STATE(372)] = 19268,
  [SMALL_STATE(373)] = 19285,
  [SMALL_STATE(374)] = 19308,
  [SMALL_STATE(375)] = 19323,
  [SMALL_STATE(376)] = 19344,
  [SMALL_STATE(377)] = 19359,
  [SMALL_STATE(378)] = 19375,
  [SMALL_STATE(379)] = 19389,
  [SMALL_STATE(380)] = 19403,
  [SMALL_STATE(381)] = 19415,
  [SMALL_STATE(382)] = 19435,
  [SMALL_STATE(383)] = 19447,
  [SMALL_STATE(384)] = 19467,
  [SMALL_STATE(385)] = 19481,
  [SMALL_STATE(386)] = 19493,
  [SMALL_STATE(387)] = 19511,
  [SMALL_STATE(388)] = 19525,
  [SMALL_STATE(389)] = 19543,
  [SMALL_STATE(390)] = 19561,
  [SMALL_STATE(391)] = 19575,
  [SMALL_STATE(392)] = 19593,
  [SMALL_STATE(393)] = 19609,
  [SMALL_STATE(394)] = 19623,
  [SMALL_STATE(395)] = 19643,
  [SMALL_STATE(396)] = 19655,
  [SMALL_STATE(397)] = 19667,
  [SMALL_STATE(398)] = 19687,
  [SMALL_STATE(399)] = 19707,
  [SMALL_STATE(400)] = 19727,
  [SMALL_STATE(401)] = 19745,
  [SMALL_STATE(402)] = 19757,
  [SMALL_STATE(403)] = 19769,
  [SMALL_STATE(404)] = 19781,
  [SMALL_STATE(405)] = 19801,
  [SMALL_STATE(406)] = 19821,
  [SMALL_STATE(407)] = 19835,
  [SMALL_STATE(408)] = 19847,
  [SMALL_STATE(409)] = 19859,
  [SMALL_STATE(410)] = 19873,
  [SMALL_STATE(411)] = 19885,
  [SMALL_STATE(412)] = 19899,
  [SMALL_STATE(413)] = 19913,
  [SMALL_STATE(414)] = 19925,
  [SMALL_STATE(415)] = 19945,
  [SMALL_STATE(416)] = 19965,
  [SMALL_STATE(417)] = 19979,
  [SMALL_STATE(418)] = 19999,
  [SMALL_STATE(419)] = 20019,
  [SMALL_STATE(420)] = 20031,
  [SMALL_STATE(421)] = 20049,
  [SMALL_STATE(422)] = 20061,
  [SMALL_STATE(423)] = 20075,
  [SMALL_STATE(424)] = 20089,
  [SMALL_STATE(425)] = 20109,
  [SMALL_STATE(426)] = 20122,
  [SMALL_STATE(427)] = 20135,
  [SMALL_STATE(428)] = 20148,
  [SMALL_STATE(429)] = 20159,
  [SMALL_STATE(430)] = 20170,
  [SMALL_STATE(431)] = 20183,
  [SMALL_STATE(432)] = 20194,
  [SMALL_STATE(433)] = 20207,
  [SMALL_STATE(434)] = 20222,
  [SMALL_STATE(435)] = 20235,
  [SMALL_STATE(436)] = 20248,
  [SMALL_STATE(437)] = 20261,
  [SMALL_STATE(438)] = 20272,
  [SMALL_STATE(439)] = 20285,
  [SMALL_STATE(440)] = 20296,
  [SMALL_STATE(441)] = 20309,
  [SMALL_STATE(442)] = 20326,
  [SMALL_STATE(443)] = 20343,
  [SMALL_STATE(444)] = 20356,
  [SMALL_STATE(445)] = 20369,
  [SMALL_STATE(446)] = 20382,
  [SMALL_STATE(447)] = 20393,
  [SMALL_STATE(448)] = 20410,
  [SMALL_STATE(449)] = 20427,
  [SMALL_STATE(450)] = 20444,
  [SMALL_STATE(451)] = 20457,
  [SMALL_STATE(452)] = 20470,
  [SMALL_STATE(453)] = 20481,
  [SMALL_STATE(454)] = 20493,
  [SMALL_STATE(455)] = 20507,
  [SMALL_STATE(456)] = 20523,
  [SMALL_STATE(457)] = 20537,
  [SMALL_STATE(458)] = 20553,
  [SMALL_STATE(459)] = 20567,
  [SMALL_STATE(460)] = 20581,
  [SMALL_STATE(461)] = 20597,
  [SMALL_STATE(462)] = 20611,
  [SMALL_STATE(463)] = 20625,
  [SMALL_STATE(464)] = 20639,
  [SMALL_STATE(465)] = 20651,
  [SMALL_STATE(466)] = 20663,
  [SMALL_STATE(467)] = 20675,
  [SMALL_STATE(468)] = 20687,
  [SMALL_STATE(469)] = 20699,
  [SMALL_STATE(470)] = 20711,
  [SMALL_STATE(471)] = 20723,
  [SMALL_STATE(472)] = 20737,
  [SMALL_STATE(473)] = 20749,
  [SMALL_STATE(474)] = 20761,
  [SMALL_STATE(475)] = 20773,
  [SMALL_STATE(476)] = 20785,
  [SMALL_STATE(477)] = 20797,
  [SMALL_STATE(478)] = 20811,
  [SMALL_STATE(479)] = 20825,
  [SMALL_STATE(480)] = 20839,
  [SMALL_STATE(481)] = 20853,
  [SMALL_STATE(482)] = 20867,
  [SMALL_STATE(483)] = 20881,
  [SMALL_STATE(484)] = 20895,
  [SMALL_STATE(485)] = 20909,
  [SMALL_STATE(486)] = 20923,
  [SMALL_STATE(487)] = 20937,
  [SMALL_STATE(488)] = 20951,
  [SMALL_STATE(489)] = 20965,
  [SMALL_STATE(490)] = 20979,
  [SMALL_STATE(491)] = 20993,
  [SMALL_STATE(492)] = 21007,
  [SMALL_STATE(493)] = 21021,
  [SMALL_STATE(494)] = 21035,
  [SMALL_STATE(495)] = 21049,
  [SMALL_STATE(496)] = 21063,
  [SMALL_STATE(497)] = 21077,
  [SMALL_STATE(498)] = 21091,
  [SMALL_STATE(499)] = 21102,
  [SMALL_STATE(500)] = 21113,
  [SMALL_STATE(501)] = 21126,
  [SMALL_STATE(502)] = 21137,
  [SMALL_STATE(503)] = 21148,
  [SMALL_STATE(504)] = 21157,
  [SMALL_STATE(505)] = 21168,
  [SMALL_STATE(506)] = 21179,
  [SMALL_STATE(507)] = 21190,
  [SMALL_STATE(508)] = 21199,
  [SMALL_STATE(509)] = 21210,
  [SMALL_STATE(510)] = 21223,
  [SMALL_STATE(511)] = 21236,
  [SMALL_STATE(512)] = 21245,
  [SMALL_STATE(513)] = 21258,
  [SMALL_STATE(514)] = 21267,
  [SMALL_STATE(515)] = 21276,
  [SMALL_STATE(516)] = 21287,
  [SMALL_STATE(517)] = 21300,
  [SMALL_STATE(518)] = 21309,
  [SMALL_STATE(519)] = 21320,
  [SMALL_STATE(520)] = 21331,
  [SMALL_STATE(521)] = 21342,
  [SMALL_STATE(522)] = 21353,
  [SMALL_STATE(523)] = 21362,
  [SMALL_STATE(524)] = 21375,
  [SMALL_STATE(525)] = 21384,
  [SMALL_STATE(526)] = 21393,
  [SMALL_STATE(527)] = 21404,
  [SMALL_STATE(528)] = 21413,
  [SMALL_STATE(529)] = 21424,
  [SMALL_STATE(530)] = 21437,
  [SMALL_STATE(531)] = 21446,
  [SMALL_STATE(532)] = 21457,
  [SMALL_STATE(533)] = 21470,
  [SMALL_STATE(534)] = 21481,
  [SMALL_STATE(535)] = 21491,
  [SMALL_STATE(536)] = 21501,
  [SMALL_STATE(537)] = 21511,
  [SMALL_STATE(538)] = 21519,
  [SMALL_STATE(539)] = 21529,
  [SMALL_STATE(540)] = 21537,
  [SMALL_STATE(541)] = 21545,
  [SMALL_STATE(542)] = 21553,
  [SMALL_STATE(543)] = 21561,
  [SMALL_STATE(544)] = 21569,
  [SMALL_STATE(545)] = 21579,
  [SMALL_STATE(546)] = 21587,
  [SMALL_STATE(547)] = 21597,
  [SMALL_STATE(548)] = 21607,
  [SMALL_STATE(549)] = 21617,
  [SMALL_STATE(550)] = 21625,
  [SMALL_STATE(551)] = 21635,
  [SMALL_STATE(552)] = 21645,
  [SMALL_STATE(553)] = 21655,
  [SMALL_STATE(554)] = 21665,
  [SMALL_STATE(555)] = 21673,
  [SMALL_STATE(556)] = 21681,
  [SMALL_STATE(557)] = 21689,
  [SMALL_STATE(558)] = 21699,
  [SMALL_STATE(559)] = 21709,
  [SMALL_STATE(560)] = 21719,
  [SMALL_STATE(561)] = 21727,
  [SMALL_STATE(562)] = 21735,
  [SMALL_STATE(563)] = 21745,
  [SMALL_STATE(564)] = 21753,
  [SMALL_STATE(565)] = 21761,
  [SMALL_STATE(566)] = 21771,
  [SMALL_STATE(567)] = 21779,
  [SMALL_STATE(568)] = 21789,
  [SMALL_STATE(569)] = 21797,
  [SMALL_STATE(570)] = 21805,
  [SMALL_STATE(571)] = 21815,
  [SMALL_STATE(572)] = 21823,
  [SMALL_STATE(573)] = 21831,
  [SMALL_STATE(574)] = 21839,
  [SMALL_STATE(575)] = 21849,
  [SMALL_STATE(576)] = 21857,
  [SMALL_STATE(577)] = 21867,
  [SMALL_STATE(578)] = 21877,
  [SMALL_STATE(579)] = 21885,
  [SMALL_STATE(580)] = 21895,
  [SMALL_STATE(581)] = 21905,
  [SMALL_STATE(582)] = 21913,
  [SMALL_STATE(583)] = 21921,
  [SMALL_STATE(584)] = 21931,
  [SMALL_STATE(585)] = 21941,
  [SMALL_STATE(586)] = 21951,
  [SMALL_STATE(587)] = 21961,
  [SMALL_STATE(588)] = 21971,
  [SMALL_STATE(589)] = 21979,
  [SMALL_STATE(590)] = 21989,
  [SMALL_STATE(591)] = 21999,
  [SMALL_STATE(592)] = 22009,
  [SMALL_STATE(593)] = 22017,
  [SMALL_STATE(594)] = 22025,
  [SMALL_STATE(595)] = 22033,
  [SMALL_STATE(596)] = 22041,
  [SMALL_STATE(597)] = 22049,
  [SMALL_STATE(598)] = 22059,
  [SMALL_STATE(599)] = 22067,
  [SMALL_STATE(600)] = 22075,
  [SMALL_STATE(601)] = 22083,
  [SMALL_STATE(602)] = 22091,
  [SMALL_STATE(603)] = 22101,
  [SMALL_STATE(604)] = 22109,
  [SMALL_STATE(605)] = 22117,
  [SMALL_STATE(606)] = 22125,
  [SMALL_STATE(607)] = 22135,
  [SMALL_STATE(608)] = 22143,
  [SMALL_STATE(609)] = 22153,
  [SMALL_STATE(610)] = 22161,
  [SMALL_STATE(611)] = 22171,
  [SMALL_STATE(612)] = 22179,
  [SMALL_STATE(613)] = 22189,
  [SMALL_STATE(614)] = 22199,
  [SMALL_STATE(615)] = 22207,
  [SMALL_STATE(616)] = 22215,
  [SMALL_STATE(617)] = 22225,
  [SMALL_STATE(618)] = 22235,
  [SMALL_STATE(619)] = 22245,
  [SMALL_STATE(620)] = 22253,
  [SMALL_STATE(621)] = 22263,
  [SMALL_STATE(622)] = 22271,
  [SMALL_STATE(623)] = 22281,
  [SMALL_STATE(624)] = 22289,
  [SMALL_STATE(625)] = 22297,
  [SMALL_STATE(626)] = 22307,
  [SMALL_STATE(627)] = 22317,
  [SMALL_STATE(628)] = 22325,
  [SMALL_STATE(629)] = 22333,
  [SMALL_STATE(630)] = 22343,
  [SMALL_STATE(631)] = 22353,
  [SMALL_STATE(632)] = 22361,
  [SMALL_STATE(633)] = 22371,
  [SMALL_STATE(634)] = 22381,
  [SMALL_STATE(635)] = 22391,
  [SMALL_STATE(636)] = 22401,
  [SMALL_STATE(637)] = 22411,
  [SMALL_STATE(638)] = 22421,
  [SMALL_STATE(639)] = 22431,
  [SMALL_STATE(640)] = 22441,
  [SMALL_STATE(641)] = 22449,
  [SMALL_STATE(642)] = 22459,
  [SMALL_STATE(643)] = 22469,
  [SMALL_STATE(644)] = 22479,
  [SMALL_STATE(645)] = 22489,
  [SMALL_STATE(646)] = 22499,
  [SMALL_STATE(647)] = 22509,
  [SMALL_STATE(648)] = 22519,
  [SMALL_STATE(649)] = 22529,
  [SMALL_STATE(650)] = 22539,
  [SMALL_STATE(651)] = 22546,
  [SMALL_STATE(652)] = 22553,
  [SMALL_STATE(653)] = 22560,
  [SMALL_STATE(654)] = 22567,
  [SMALL_STATE(655)] = 22574,
  [SMALL_STATE(656)] = 22581,
  [SMALL_STATE(657)] = 22588,
  [SMALL_STATE(658)] = 22595,
  [SMALL_STATE(659)] = 22602,
  [SMALL_STATE(660)] = 22609,
  [SMALL_STATE(661)] = 22616,
  [SMALL_STATE(662)] = 22623,
  [SMALL_STATE(663)] = 22630,
  [SMALL_STATE(664)] = 22637,
  [SMALL_STATE(665)] = 22644,
  [SMALL_STATE(666)] = 22651,
  [SMALL_STATE(667)] = 22658,
  [SMALL_STATE(668)] = 22665,
  [SMALL_STATE(669)] = 22672,
  [SMALL_STATE(670)] = 22679,
  [SMALL_STATE(671)] = 22686,
  [SMALL_STATE(672)] = 22693,
  [SMALL_STATE(673)] = 22700,
  [SMALL_STATE(674)] = 22707,
  [SMALL_STATE(675)] = 22714,
  [SMALL_STATE(676)] = 22721,
  [SMALL_STATE(677)] = 22728,
  [SMALL_STATE(678)] = 22735,
  [SMALL_STATE(679)] = 22742,
  [SMALL_STATE(680)] = 22749,
  [SMALL_STATE(681)] = 22756,
  [SMALL_STATE(682)] = 22763,
  [SMALL_STATE(683)] = 22770,
  [SMALL_STATE(684)] = 22777,
  [SMALL_STATE(685)] = 22784,
  [SMALL_STATE(686)] = 22791,
  [SMALL_STATE(687)] = 22798,
  [SMALL_STATE(688)] = 22805,
  [SMALL_STATE(689)] = 22812,
  [SMALL_STATE(690)] = 22819,
  [SMALL_STATE(691)] = 22826,
  [SMALL_STATE(692)] = 22833,
  [SMALL_STATE(693)] = 22840,
  [SMALL_STATE(694)] = 22847,
  [SMALL_STATE(695)] = 22854,
  [SMALL_STATE(696)] = 22861,
  [SMALL_STATE(697)] = 22868,
  [SMALL_STATE(698)] = 22875,
  [SMALL_STATE(699)] = 22882,
  [SMALL_STATE(700)] = 22889,
  [SMALL_STATE(701)] = 22896,
  [SMALL_STATE(702)] = 22903,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(637),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(655),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(660),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(689),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(660),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(700),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(695),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(672),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(671),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(48),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(667),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [79] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [81] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [83] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(529),
  [86] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(637),
  [89] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(253),
  [92] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(655),
  [95] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(660),
  [98] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(247),
  [101] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(689),
  [104] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(457),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(547),
  [110] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(374),
  [113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(7),
  [116] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(523),
  [119] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(43),
  [122] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(74),
  [125] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(92),
  [128] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(660),
  [131] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(151),
  [134] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(700),
  [137] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(191),
  [140] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(695),
  [143] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(460),
  [146] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(455),
  [149] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(528),
  [152] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(214),
  [155] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(672),
  [158] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(202),
  [161] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(17),
  [164] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(671),
  [167] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(30),
  [170] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(30),
  [173] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(31),
  [176] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(43),
  [179] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(48),
  [182] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(667),
  [185] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(108),
  [188] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(471),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(55),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyconddot, 1),
  [213] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyconddot, 1),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 5),
  [217] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 5),
  [219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 3),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [223] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 3),
  [225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 2),
  [227] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 2),
  [229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyconddot, 2),
  [231] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyconddot, 2),
  [233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 3),
  [235] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 3),
  [237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 4),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [241] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 4),
  [243] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 4),
  [245] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 4),
  [247] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 5),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [251] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 5),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 7),
  [255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 7),
  [257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 8),
  [259] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 8),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 6),
  [263] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 6),
  [265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 10),
  [267] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 10),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [271] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 2),
  [273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 1),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 1),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dec, 1),
  [283] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dec, 1),
  [285] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_NUMBER, 1),
  [287] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_NUMBER, 1),
  [289] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 2),
  [291] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 2),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_STRING, 3),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_STRING, 3),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_STRING, 2),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_STRING, 2),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 3),
  [303] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 3),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 4),
  [311] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 4),
  [313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [317] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [325] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 2),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 2),
  [329] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 1),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 1),
  [333] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 4),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 4),
  [337] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 3),
  [339] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 3),
  [341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(698),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [345] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [347] = {.entry = {.count = 1, .reusable = false}}, SHIFT(57),
  [349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(692),
  [351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [355] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 1),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(679),
  [361] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 1),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunction, 2),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [369] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptcondition, 1),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element, 1),
  [377] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizecond, 1),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 2),
  [383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conjunction, 2),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [389] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelem, 1),
  [393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 2),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 3),
  [397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 1),
  [399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(626),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 1),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [411] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [417] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 3),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 2),
  [429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 3),
  [431] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 3),
  [433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 2),
  [435] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 2),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [445] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 5),
  [447] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 5),
  [449] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 4),
  [451] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 4),
  [453] = {.entry = {.count = 1, .reusable = false}}, SHIFT(63),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [465] = {.entry = {.count = 1, .reusable = false}}, SHIFT(378),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [471] = {.entry = {.count = 1, .reusable = false}}, SHIFT(372),
  [473] = {.entry = {.count = 1, .reusable = false}}, SHIFT(289),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [483] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 4),
  [485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 4),
  [487] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 2),
  [489] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 2),
  [491] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 3),
  [493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 3),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [497] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [505] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 4),
  [507] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 4),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(215),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [529] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 2),
  [531] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 2),
  [533] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [535] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [539] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [541] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 3),
  [543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 3),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(677),
  [547] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 2),
  [549] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 2),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [569] = {.entry = {.count = 1, .reusable = false}}, SHIFT(402),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [575] = {.entry = {.count = 1, .reusable = false}}, SHIFT(366),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(668),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [607] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 4),
  [609] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 4),
  [611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(687),
  [627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuple, 2),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [643] = {.entry = {.count = 1, .reusable = false}}, SHIFT(473),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [649] = {.entry = {.count = 1, .reusable = false}}, SHIFT(433),
  [651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [661] = {.entry = {.count = 1, .reusable = false}}, SHIFT(425),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [667] = {.entry = {.count = 1, .reusable = false}}, SHIFT(392),
  [669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [671] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cmp, 1),
  [673] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cmp, 1),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(618),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [695] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dsym, 1),
  [697] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dsym, 1),
  [699] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 3),
  [701] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 3),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [705] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 2),
  [707] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 2),
  [709] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 5),
  [711] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 5),
  [713] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 4),
  [715] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 4),
  [717] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 2),
  [719] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 2),
  [721] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 1),
  [723] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 1),
  [725] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 3),
  [727] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 3),
  [729] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op, 1),
  [731] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op, 1),
  [733] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__widentifier, 2),
  [735] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__widentifier, 2),
  [737] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_rel, 1),
  [739] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_rel, 1),
  [741] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntermvec, 3),
  [743] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 4),
  [745] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 4),
  [747] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 5),
  [749] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 5),
  [751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [753] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizeweight, 1),
  [755] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntermvec, 1),
  [757] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 3),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 3),
  [761] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizeweight, 3),
  [763] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op_list, 2),
  [765] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op_list, 2),
  [767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(650),
  [771] = {.entry = {.count = 1, .reusable = false}}, SHIFT(511),
  [773] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_add_term, 3),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_add_term, 3),
  [777] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_add_term, 1),
  [779] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_add_term, 1),
  [781] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op_list, 1),
  [783] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op_list, 1),
  [785] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 2),
  [787] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 2),
  [789] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 1),
  [791] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 1),
  [793] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_literal, 3),
  [795] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_literal, 3),
  [797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [799] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 3),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [803] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 3),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [815] = {.entry = {.count = 1, .reusable = false}}, SHIFT(277),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [819] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 1),
  [821] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 1),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [825] = {.entry = {.count = 1, .reusable = false}}, SHIFT(291),
  [827] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 4),
  [829] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 4),
  [831] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nupper, 2),
  [833] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nupper, 2),
  [835] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nupper, 1),
  [837] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nupper, 1),
  [839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [841] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unaryargvec, 3),
  [843] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unaryargvec, 1),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [851] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [853] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binaryargvec, 5),
  [855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [857] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [859] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binaryargvec, 3),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [865] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_consttermvec, 3),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [877] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_consttermvec, 1),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [881] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm_nlist, 3),
  [883] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm_nlist, 1),
  [885] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm_nlist, 3),
  [887] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [891] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm_nlist, 1),
  [893] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 7),
  [895] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 7),
  [897] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 2),
  [899] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 2),
  [901] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 1),
  [903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [905] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [907] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [909] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_head, 1),
  [911] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 1),
  [913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [915] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 6),
  [917] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 6),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(628),
  [923] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 4),
  [925] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 4),
  [927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nlitvec, 1),
  [929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [931] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 2),
  [933] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 2),
  [935] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 1),
  [937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [939] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptcondition, 2),
  [941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [943] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 5),
  [945] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 2),
  [947] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 2),
  [949] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 2),
  [951] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 4),
  [953] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [955] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 5),
  [957] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 5),
  [959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [965] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 3),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [969] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 3),
  [971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(683),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [977] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 1),
  [979] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 4),
  [981] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nlitvec, 3),
  [983] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 1),
  [985] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 3),
  [987] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 3),
  [989] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 3),
  [991] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 1),
  [993] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 3),
  [995] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 1),
  [997] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 5),
  [999] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 5),
  [1001] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunction, 3),
  [1003] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 4),
  [1005] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 3),
  [1007] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizetuple, 2),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [1011] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 2),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [1015] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 3),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(661),
  [1021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1023] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [1031] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 3),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [1035] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 4),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(630),
  [1039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1041] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 4),
  [1043] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 4),
  [1045] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 2),
  [1047] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 2),
  [1049] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1051] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [1053] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [1055] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1057] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 2),
  [1059] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 5),
  [1061] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelem, 1),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1067] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [1071] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [1073] = {.entry = {.count = 1, .reusable = false}}, SHIFT(138),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [1077] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_STRING_repeat1, 2),
  [1079] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_STRING_repeat1, 2), SHIFT_REPEAT(485),
  [1082] = {.entry = {.count = 1, .reusable = false}}, SHIFT(387),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [1086] = {.entry = {.count = 1, .reusable = false}}, SHIFT(422),
  [1088] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 2),
  [1090] = {.entry = {.count = 1, .reusable = false}}, SHIFT(396),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1094] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 1),
  [1096] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 3),
  [1098] = {.entry = {.count = 1, .reusable = false}}, SHIFT(395),
  [1100] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [1102] = {.entry = {.count = 1, .reusable = false}}, SHIFT(475),
  [1104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [1106] = {.entry = {.count = 1, .reusable = false}}, SHIFT(476),
  [1108] = {.entry = {.count = 1, .reusable = false}}, SHIFT(435),
  [1110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1112] = {.entry = {.count = 1, .reusable = false}}, SHIFT(434),
  [1114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1120] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelem, 2),
  [1122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [1126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1130] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conjunction, 3),
  [1132] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argvec, 1),
  [1134] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizelitvec, 1),
  [1136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1138] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizecond, 2),
  [1140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [1142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1146] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_identifier, 1),
  [1148] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 6),
  [1150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 3),
  [1152] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 4),
  [1154] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argvec, 3),
  [1156] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element, 2),
  [1158] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 4),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(694),
  [1162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 5),
  [1164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizelitvec, 3),
  [1166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(681),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(684),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [1172] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuple, 1),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [1176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [1184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(702),
  [1186] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition, 7),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [1190] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelem, 2),
  [1192] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_nlist, 3),
  [1194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 13),
  [1196] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 14),
  [1198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 5),
  [1200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [1202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelemvec, 1),
  [1204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [1210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [1220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [1222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition_nlist, 1),
  [1224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term_definition, 4),
  [1226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term_definition, 3),
  [1228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuplevec, 2),
  [1230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1232] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nidlist, 3),
  [1234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1236] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 5),
  [1238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1240] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelemvec, 3),
  [1242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 2),
  [1244] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuplevec, 1),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(697),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [1252] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 6),
  [1254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element_nlist, 3),
  [1256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [1260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 4),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [1274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nidlist, 1),
  [1278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(673),
  [1280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(665),
  [1282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 3),
  [1284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [1290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition_nlist, 3),
  [1292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nconstargvec, 1),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [1298] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element_nlist, 1),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [1302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [1306] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_nlist, 1),
  [1308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 8),
  [1314] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 4),
  [1316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [1320] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 1),
  [1322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_type, 1),
  [1324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 6),
  [1330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [1338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [1340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition, 5),
  [1342] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_nlist, 1),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [1346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(640),
  [1350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(659),
  [1352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [1356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [1360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(699),
  [1362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [1364] = {.entry = {.count = 1, .reusable = false}}, SHIFT(665),
  [1366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(621),
  [1368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_aggregatefunction, 1),
  [1370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [1374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(643),
  [1376] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(676),
  [1380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(657),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [1390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(691),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [1396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(656),
  [1398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [1400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1404] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_nlist, 3),
  [1406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [1408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [1410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(658),
  [1412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [1414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(682),
  [1416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [1420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [1424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_clingo(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
