#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 716
#define LARGE_STATE_COUNT 4
#define SYMBOL_COUNT 171
#define ALIAS_COUNT 0
#define TOKEN_COUNT 96
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 14
#define PRODUCTION_ID_COUNT 1

enum {
  sym_comment = 1,
  sym_ADD = 2,
  sym_AND = 3,
  sym_EQ = 4,
  sym_AT = 5,
  sym_BNOT = 6,
  sym_COLON = 7,
  sym_COMMA = 8,
  sym_CONST = 9,
  sym_COUNT = 10,
  sym_CSP = 11,
  sym_CSP_ADD = 12,
  sym_CSP_SUB = 13,
  sym_CSP_MUL = 14,
  sym_CSP_LEQ = 15,
  sym_CSP_LT = 16,
  sym_CSP_GT = 17,
  sym_CSP_GEQ = 18,
  sym_CSP_EQ = 19,
  sym_CSP_NEQ = 20,
  sym_DISJOINT = 21,
  sym_DOT = 22,
  sym_DOTS = 23,
  sym_EXTERNAL = 24,
  sym_DEFINED = 25,
  sym_FALSE = 26,
  sym_GEQ = 27,
  sym_GT = 28,
  sym_IF = 29,
  sym_INCLUDE = 30,
  sym_INFIMUM = 31,
  sym_LBRACE = 32,
  sym_LBRACK = 33,
  sym_LEQ = 34,
  sym_LPAREN = 35,
  sym_LT = 36,
  sym_MAX = 37,
  sym_MAXIMIZE = 38,
  sym_MIN = 39,
  sym_MINIMIZE = 40,
  sym_MOD = 41,
  sym_MUL = 42,
  sym_NEQ = 43,
  sym_POW = 44,
  sym_QUESTION = 45,
  sym_RBRACE = 46,
  sym_RBRACK = 47,
  sym_RPAREN = 48,
  sym_SEM = 49,
  sym_SHOW = 50,
  sym_EDGE = 51,
  sym_PROJECT = 52,
  sym_HEURISTIC = 53,
  sym_SHOWSIG = 54,
  sym_SLASH = 55,
  sym_SUB = 56,
  sym_SUM = 57,
  sym_SUMP = 58,
  sym_SUPREMUM = 59,
  sym_TRUE = 60,
  sym_BLOCK = 61,
  sym_VBAR = 62,
  sym_WIF = 63,
  sym_XOR = 64,
  sym_ANY = 65,
  sym_UNARY = 66,
  sym_BINARY = 67,
  sym_LEFT = 68,
  sym_RIGHT = 69,
  sym_HEAD = 70,
  sym_BODY = 71,
  sym_DIRECTIVE = 72,
  sym_THEORY = 73,
  anon_sym_0 = 74,
  aux_sym_dec_token1 = 75,
  sym_hex = 76,
  sym_oct = 77,
  sym_bin = 78,
  sym_ANONYMOUS = 79,
  sym_identifier = 80,
  anon_sym_LPAREN = 81,
  sym_SCRIPT = 82,
  sym_CODE = 83,
  sym_VARIABLE = 84,
  sym_THEORY_OP = 85,
  sym_NOT = 86,
  sym_DEFAULT = 87,
  sym_OVERRIDE = 88,
  anon_sym_BSLASH_BSLASH = 89,
  anon_sym_EQ_EQ = 90,
  anon_sym_DQUOTE = 91,
  anon_sym_SQUOTE = 92,
  sym_unescaped_double_string_fragment = 93,
  sym_unescaped_single_string_fragment = 94,
  sym_escape_sequence = 95,
  sym_source_file = 96,
  sym_NUMBER = 97,
  sym_dec = 98,
  sym__widentifier = 99,
  sym_constterm = 100,
  sym_consttermvec = 101,
  sym_nconstargvec = 102,
  sym_term = 103,
  sym_unaryargvec = 104,
  sym_ntermvec = 105,
  sym_ntuple = 106,
  sym_tuplevec_sem = 107,
  sym_ntuplevec = 108,
  sym_argvec = 109,
  sym_binaryargvec = 110,
  sym_cmp = 111,
  sym_atom = 112,
  sym_literal = 113,
  sym_csp_mul_term = 114,
  sym_csp_add_term = 115,
  sym_csp_rel = 116,
  sym_csp_literal = 117,
  sym_nlitvec = 118,
  sym_noptcondition = 119,
  sym_aggregatefunction = 120,
  sym_bodyaggrelem = 121,
  sym_bodyaggrelemvec = 122,
  sym_altbodyaggrelem = 123,
  sym_altbodyaggrelemvec = 124,
  sym_bodyaggregate = 125,
  sym_nupper = 126,
  sym_lubodyaggregate = 127,
  sym_headaggrelemvec = 128,
  sym_altheadaggrelemvec = 129,
  sym_headaggregate = 130,
  sym_luheadaggregate = 131,
  sym_ncspelemvec = 132,
  sym_disjoint = 133,
  sym_conjunction = 134,
  sym_dsym = 135,
  sym_disjunctionsep = 136,
  sym_disjunction = 137,
  sym_nbodycomma = 138,
  sym_bodydot = 139,
  sym_bodyconddot = 140,
  sym_head = 141,
  sym_statement = 142,
  sym_noptimizetuple = 143,
  sym_optimizeweight = 144,
  sym_optimizelitvec = 145,
  sym_noptimizecond = 146,
  sym_maxelemlist = 147,
  sym_minelemlist = 148,
  sym_nidlist = 149,
  sym_theory_op = 150,
  sym_theory_op_list = 151,
  sym_theory_term = 152,
  sym_theory_opterm = 153,
  sym_theory_opterm_nlist = 154,
  sym_theory_atom_element = 155,
  sym_theory_atom_element_nlist = 156,
  sym_theory_atom_name = 157,
  sym_theory_atom = 158,
  sym_theory_operator_nlist = 159,
  sym_theory_operator_definition = 160,
  sym_theory_operator_definition_nlist = 161,
  sym_theory_definition_identifier = 162,
  sym_theory_term_definition = 163,
  sym_theory_atom_type = 164,
  sym_theory_atom_definition = 165,
  sym_theory_definition_nlist = 166,
  sym_STRING = 167,
  aux_sym_source_file_repeat1 = 168,
  aux_sym_STRING_repeat1 = 169,
  aux_sym_STRING_repeat2 = 170,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_comment] = "comment",
  [sym_ADD] = "ADD",
  [sym_AND] = "AND",
  [sym_EQ] = "EQ",
  [sym_AT] = "AT",
  [sym_BNOT] = "BNOT",
  [sym_COLON] = "COLON",
  [sym_COMMA] = "COMMA",
  [sym_CONST] = "CONST",
  [sym_COUNT] = "COUNT",
  [sym_CSP] = "CSP",
  [sym_CSP_ADD] = "CSP_ADD",
  [sym_CSP_SUB] = "CSP_SUB",
  [sym_CSP_MUL] = "CSP_MUL",
  [sym_CSP_LEQ] = "CSP_LEQ",
  [sym_CSP_LT] = "CSP_LT",
  [sym_CSP_GT] = "CSP_GT",
  [sym_CSP_GEQ] = "CSP_GEQ",
  [sym_CSP_EQ] = "CSP_EQ",
  [sym_CSP_NEQ] = "CSP_NEQ",
  [sym_DISJOINT] = "DISJOINT",
  [sym_DOT] = "DOT",
  [sym_DOTS] = "DOTS",
  [sym_EXTERNAL] = "EXTERNAL",
  [sym_DEFINED] = "DEFINED",
  [sym_FALSE] = "FALSE",
  [sym_GEQ] = "GEQ",
  [sym_GT] = "GT",
  [sym_IF] = "IF",
  [sym_INCLUDE] = "INCLUDE",
  [sym_INFIMUM] = "INFIMUM",
  [sym_LBRACE] = "LBRACE",
  [sym_LBRACK] = "LBRACK",
  [sym_LEQ] = "LEQ",
  [sym_LPAREN] = "LPAREN",
  [sym_LT] = "LT",
  [sym_MAX] = "MAX",
  [sym_MAXIMIZE] = "MAXIMIZE",
  [sym_MIN] = "MIN",
  [sym_MINIMIZE] = "MINIMIZE",
  [sym_MOD] = "MOD",
  [sym_MUL] = "MUL",
  [sym_NEQ] = "NEQ",
  [sym_POW] = "POW",
  [sym_QUESTION] = "QUESTION",
  [sym_RBRACE] = "RBRACE",
  [sym_RBRACK] = "RBRACK",
  [sym_RPAREN] = "RPAREN",
  [sym_SEM] = "SEM",
  [sym_SHOW] = "SHOW",
  [sym_EDGE] = "EDGE",
  [sym_PROJECT] = "PROJECT",
  [sym_HEURISTIC] = "HEURISTIC",
  [sym_SHOWSIG] = "SHOWSIG",
  [sym_SLASH] = "SLASH",
  [sym_SUB] = "SUB",
  [sym_SUM] = "SUM",
  [sym_SUMP] = "SUMP",
  [sym_SUPREMUM] = "SUPREMUM",
  [sym_TRUE] = "TRUE",
  [sym_BLOCK] = "BLOCK",
  [sym_VBAR] = "VBAR",
  [sym_WIF] = "WIF",
  [sym_XOR] = "XOR",
  [sym_ANY] = "ANY",
  [sym_UNARY] = "UNARY",
  [sym_BINARY] = "BINARY",
  [sym_LEFT] = "LEFT",
  [sym_RIGHT] = "RIGHT",
  [sym_HEAD] = "HEAD",
  [sym_BODY] = "BODY",
  [sym_DIRECTIVE] = "DIRECTIVE",
  [sym_THEORY] = "THEORY",
  [anon_sym_0] = "0",
  [aux_sym_dec_token1] = "dec_token1",
  [sym_hex] = "hex",
  [sym_oct] = "oct",
  [sym_bin] = "bin",
  [sym_ANONYMOUS] = "ANONYMOUS",
  [sym_identifier] = "identifier",
  [anon_sym_LPAREN] = "LPAREN",
  [sym_SCRIPT] = "SCRIPT",
  [sym_CODE] = "CODE",
  [sym_VARIABLE] = "VARIABLE",
  [sym_THEORY_OP] = "THEORY_OP",
  [sym_NOT] = "NOT",
  [sym_DEFAULT] = "DEFAULT",
  [sym_OVERRIDE] = "OVERRIDE",
  [anon_sym_BSLASH_BSLASH] = "\\\\",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_source_file] = "source_file",
  [sym_NUMBER] = "NUMBER",
  [sym_dec] = "dec",
  [sym__widentifier] = "_widentifier",
  [sym_constterm] = "constterm",
  [sym_consttermvec] = "consttermvec",
  [sym_nconstargvec] = "nconstargvec",
  [sym_term] = "term",
  [sym_unaryargvec] = "unaryargvec",
  [sym_ntermvec] = "ntermvec",
  [sym_ntuple] = "ntuple",
  [sym_tuplevec_sem] = "tuplevec_sem",
  [sym_ntuplevec] = "ntuplevec",
  [sym_argvec] = "argvec",
  [sym_binaryargvec] = "binaryargvec",
  [sym_cmp] = "cmp",
  [sym_atom] = "atom",
  [sym_literal] = "literal",
  [sym_csp_mul_term] = "csp_mul_term",
  [sym_csp_add_term] = "csp_add_term",
  [sym_csp_rel] = "csp_rel",
  [sym_csp_literal] = "csp_literal",
  [sym_nlitvec] = "nlitvec",
  [sym_noptcondition] = "noptcondition",
  [sym_aggregatefunction] = "aggregatefunction",
  [sym_bodyaggrelem] = "bodyaggrelem",
  [sym_bodyaggrelemvec] = "bodyaggrelemvec",
  [sym_altbodyaggrelem] = "altbodyaggrelem",
  [sym_altbodyaggrelemvec] = "altbodyaggrelemvec",
  [sym_bodyaggregate] = "bodyaggregate",
  [sym_nupper] = "nupper",
  [sym_lubodyaggregate] = "lubodyaggregate",
  [sym_headaggrelemvec] = "headaggrelemvec",
  [sym_altheadaggrelemvec] = "altheadaggrelemvec",
  [sym_headaggregate] = "headaggregate",
  [sym_luheadaggregate] = "luheadaggregate",
  [sym_ncspelemvec] = "ncspelemvec",
  [sym_disjoint] = "disjoint",
  [sym_conjunction] = "conjunction",
  [sym_dsym] = "dsym",
  [sym_disjunctionsep] = "disjunctionsep",
  [sym_disjunction] = "disjunction",
  [sym_nbodycomma] = "nbodycomma",
  [sym_bodydot] = "bodydot",
  [sym_bodyconddot] = "bodyconddot",
  [sym_head] = "head",
  [sym_statement] = "statement",
  [sym_noptimizetuple] = "noptimizetuple",
  [sym_optimizeweight] = "optimizeweight",
  [sym_optimizelitvec] = "optimizelitvec",
  [sym_noptimizecond] = "noptimizecond",
  [sym_maxelemlist] = "maxelemlist",
  [sym_minelemlist] = "minelemlist",
  [sym_nidlist] = "nidlist",
  [sym_theory_op] = "theory_op",
  [sym_theory_op_list] = "theory_op_list",
  [sym_theory_term] = "theory_term",
  [sym_theory_opterm] = "theory_opterm",
  [sym_theory_opterm_nlist] = "theory_opterm_nlist",
  [sym_theory_atom_element] = "theory_atom_element",
  [sym_theory_atom_element_nlist] = "theory_atom_element_nlist",
  [sym_theory_atom_name] = "theory_atom_name",
  [sym_theory_atom] = "theory_atom",
  [sym_theory_operator_nlist] = "theory_operator_nlist",
  [sym_theory_operator_definition] = "theory_operator_definition",
  [sym_theory_operator_definition_nlist] = "theory_operator_definition_nlist",
  [sym_theory_definition_identifier] = "theory_definition_identifier",
  [sym_theory_term_definition] = "theory_term_definition",
  [sym_theory_atom_type] = "theory_atom_type",
  [sym_theory_atom_definition] = "theory_atom_definition",
  [sym_theory_definition_nlist] = "theory_definition_nlist",
  [sym_STRING] = "STRING",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_STRING_repeat1] = "STRING_repeat1",
  [aux_sym_STRING_repeat2] = "STRING_repeat2",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_comment] = sym_comment,
  [sym_ADD] = sym_ADD,
  [sym_AND] = sym_AND,
  [sym_EQ] = sym_EQ,
  [sym_AT] = sym_AT,
  [sym_BNOT] = sym_BNOT,
  [sym_COLON] = sym_COLON,
  [sym_COMMA] = sym_COMMA,
  [sym_CONST] = sym_CONST,
  [sym_COUNT] = sym_COUNT,
  [sym_CSP] = sym_CSP,
  [sym_CSP_ADD] = sym_CSP_ADD,
  [sym_CSP_SUB] = sym_CSP_SUB,
  [sym_CSP_MUL] = sym_CSP_MUL,
  [sym_CSP_LEQ] = sym_CSP_LEQ,
  [sym_CSP_LT] = sym_CSP_LT,
  [sym_CSP_GT] = sym_CSP_GT,
  [sym_CSP_GEQ] = sym_CSP_GEQ,
  [sym_CSP_EQ] = sym_CSP_EQ,
  [sym_CSP_NEQ] = sym_CSP_NEQ,
  [sym_DISJOINT] = sym_DISJOINT,
  [sym_DOT] = sym_DOT,
  [sym_DOTS] = sym_DOTS,
  [sym_EXTERNAL] = sym_EXTERNAL,
  [sym_DEFINED] = sym_DEFINED,
  [sym_FALSE] = sym_FALSE,
  [sym_GEQ] = sym_GEQ,
  [sym_GT] = sym_GT,
  [sym_IF] = sym_IF,
  [sym_INCLUDE] = sym_INCLUDE,
  [sym_INFIMUM] = sym_INFIMUM,
  [sym_LBRACE] = sym_LBRACE,
  [sym_LBRACK] = sym_LBRACK,
  [sym_LEQ] = sym_LEQ,
  [sym_LPAREN] = sym_LPAREN,
  [sym_LT] = sym_LT,
  [sym_MAX] = sym_MAX,
  [sym_MAXIMIZE] = sym_MAXIMIZE,
  [sym_MIN] = sym_MIN,
  [sym_MINIMIZE] = sym_MINIMIZE,
  [sym_MOD] = sym_MOD,
  [sym_MUL] = sym_MUL,
  [sym_NEQ] = sym_NEQ,
  [sym_POW] = sym_POW,
  [sym_QUESTION] = sym_QUESTION,
  [sym_RBRACE] = sym_RBRACE,
  [sym_RBRACK] = sym_RBRACK,
  [sym_RPAREN] = sym_RPAREN,
  [sym_SEM] = sym_SEM,
  [sym_SHOW] = sym_SHOW,
  [sym_EDGE] = sym_EDGE,
  [sym_PROJECT] = sym_PROJECT,
  [sym_HEURISTIC] = sym_HEURISTIC,
  [sym_SHOWSIG] = sym_SHOWSIG,
  [sym_SLASH] = sym_SLASH,
  [sym_SUB] = sym_SUB,
  [sym_SUM] = sym_SUM,
  [sym_SUMP] = sym_SUMP,
  [sym_SUPREMUM] = sym_SUPREMUM,
  [sym_TRUE] = sym_TRUE,
  [sym_BLOCK] = sym_BLOCK,
  [sym_VBAR] = sym_VBAR,
  [sym_WIF] = sym_WIF,
  [sym_XOR] = sym_XOR,
  [sym_ANY] = sym_ANY,
  [sym_UNARY] = sym_UNARY,
  [sym_BINARY] = sym_BINARY,
  [sym_LEFT] = sym_LEFT,
  [sym_RIGHT] = sym_RIGHT,
  [sym_HEAD] = sym_HEAD,
  [sym_BODY] = sym_BODY,
  [sym_DIRECTIVE] = sym_DIRECTIVE,
  [sym_THEORY] = sym_THEORY,
  [anon_sym_0] = anon_sym_0,
  [aux_sym_dec_token1] = aux_sym_dec_token1,
  [sym_hex] = sym_hex,
  [sym_oct] = sym_oct,
  [sym_bin] = sym_bin,
  [sym_ANONYMOUS] = sym_ANONYMOUS,
  [sym_identifier] = sym_identifier,
  [anon_sym_LPAREN] = sym_LPAREN,
  [sym_SCRIPT] = sym_SCRIPT,
  [sym_CODE] = sym_CODE,
  [sym_VARIABLE] = sym_VARIABLE,
  [sym_THEORY_OP] = sym_THEORY_OP,
  [sym_NOT] = sym_NOT,
  [sym_DEFAULT] = sym_DEFAULT,
  [sym_OVERRIDE] = sym_OVERRIDE,
  [anon_sym_BSLASH_BSLASH] = anon_sym_BSLASH_BSLASH,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_unescaped_single_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_source_file] = sym_source_file,
  [sym_NUMBER] = sym_NUMBER,
  [sym_dec] = sym_dec,
  [sym__widentifier] = sym__widentifier,
  [sym_constterm] = sym_constterm,
  [sym_consttermvec] = sym_consttermvec,
  [sym_nconstargvec] = sym_nconstargvec,
  [sym_term] = sym_term,
  [sym_unaryargvec] = sym_unaryargvec,
  [sym_ntermvec] = sym_ntermvec,
  [sym_ntuple] = sym_ntuple,
  [sym_tuplevec_sem] = sym_tuplevec_sem,
  [sym_ntuplevec] = sym_ntuplevec,
  [sym_argvec] = sym_argvec,
  [sym_binaryargvec] = sym_binaryargvec,
  [sym_cmp] = sym_cmp,
  [sym_atom] = sym_atom,
  [sym_literal] = sym_literal,
  [sym_csp_mul_term] = sym_csp_mul_term,
  [sym_csp_add_term] = sym_csp_add_term,
  [sym_csp_rel] = sym_csp_rel,
  [sym_csp_literal] = sym_csp_literal,
  [sym_nlitvec] = sym_nlitvec,
  [sym_noptcondition] = sym_noptcondition,
  [sym_aggregatefunction] = sym_aggregatefunction,
  [sym_bodyaggrelem] = sym_bodyaggrelem,
  [sym_bodyaggrelemvec] = sym_bodyaggrelemvec,
  [sym_altbodyaggrelem] = sym_altbodyaggrelem,
  [sym_altbodyaggrelemvec] = sym_altbodyaggrelemvec,
  [sym_bodyaggregate] = sym_bodyaggregate,
  [sym_nupper] = sym_nupper,
  [sym_lubodyaggregate] = sym_lubodyaggregate,
  [sym_headaggrelemvec] = sym_headaggrelemvec,
  [sym_altheadaggrelemvec] = sym_altheadaggrelemvec,
  [sym_headaggregate] = sym_headaggregate,
  [sym_luheadaggregate] = sym_luheadaggregate,
  [sym_ncspelemvec] = sym_ncspelemvec,
  [sym_disjoint] = sym_disjoint,
  [sym_conjunction] = sym_conjunction,
  [sym_dsym] = sym_dsym,
  [sym_disjunctionsep] = sym_disjunctionsep,
  [sym_disjunction] = sym_disjunction,
  [sym_nbodycomma] = sym_nbodycomma,
  [sym_bodydot] = sym_bodydot,
  [sym_bodyconddot] = sym_bodyconddot,
  [sym_head] = sym_head,
  [sym_statement] = sym_statement,
  [sym_noptimizetuple] = sym_noptimizetuple,
  [sym_optimizeweight] = sym_optimizeweight,
  [sym_optimizelitvec] = sym_optimizelitvec,
  [sym_noptimizecond] = sym_noptimizecond,
  [sym_maxelemlist] = sym_maxelemlist,
  [sym_minelemlist] = sym_minelemlist,
  [sym_nidlist] = sym_nidlist,
  [sym_theory_op] = sym_theory_op,
  [sym_theory_op_list] = sym_theory_op_list,
  [sym_theory_term] = sym_theory_term,
  [sym_theory_opterm] = sym_theory_opterm,
  [sym_theory_opterm_nlist] = sym_theory_opterm_nlist,
  [sym_theory_atom_element] = sym_theory_atom_element,
  [sym_theory_atom_element_nlist] = sym_theory_atom_element_nlist,
  [sym_theory_atom_name] = sym_theory_atom_name,
  [sym_theory_atom] = sym_theory_atom,
  [sym_theory_operator_nlist] = sym_theory_operator_nlist,
  [sym_theory_operator_definition] = sym_theory_operator_definition,
  [sym_theory_operator_definition_nlist] = sym_theory_operator_definition_nlist,
  [sym_theory_definition_identifier] = sym_theory_definition_identifier,
  [sym_theory_term_definition] = sym_theory_term_definition,
  [sym_theory_atom_type] = sym_theory_atom_type,
  [sym_theory_atom_definition] = sym_theory_atom_definition,
  [sym_theory_definition_nlist] = sym_theory_definition_nlist,
  [sym_STRING] = sym_STRING,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_STRING_repeat1] = aux_sym_STRING_repeat1,
  [aux_sym_STRING_repeat2] = aux_sym_STRING_repeat2,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_ADD] = {
    .visible = true,
    .named = true,
  },
  [sym_AND] = {
    .visible = true,
    .named = true,
  },
  [sym_EQ] = {
    .visible = true,
    .named = true,
  },
  [sym_AT] = {
    .visible = true,
    .named = true,
  },
  [sym_BNOT] = {
    .visible = true,
    .named = true,
  },
  [sym_COLON] = {
    .visible = true,
    .named = true,
  },
  [sym_COMMA] = {
    .visible = true,
    .named = true,
  },
  [sym_CONST] = {
    .visible = true,
    .named = true,
  },
  [sym_COUNT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_ADD] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_SUB] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_MUL] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_LEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_LT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_GT] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_GEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_EQ] = {
    .visible = true,
    .named = true,
  },
  [sym_CSP_NEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_DISJOINT] = {
    .visible = true,
    .named = true,
  },
  [sym_DOT] = {
    .visible = true,
    .named = true,
  },
  [sym_DOTS] = {
    .visible = true,
    .named = true,
  },
  [sym_EXTERNAL] = {
    .visible = true,
    .named = true,
  },
  [sym_DEFINED] = {
    .visible = true,
    .named = true,
  },
  [sym_FALSE] = {
    .visible = true,
    .named = true,
  },
  [sym_GEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_GT] = {
    .visible = true,
    .named = true,
  },
  [sym_IF] = {
    .visible = true,
    .named = true,
  },
  [sym_INCLUDE] = {
    .visible = true,
    .named = true,
  },
  [sym_INFIMUM] = {
    .visible = true,
    .named = true,
  },
  [sym_LBRACE] = {
    .visible = true,
    .named = true,
  },
  [sym_LBRACK] = {
    .visible = true,
    .named = true,
  },
  [sym_LEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_LPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_LT] = {
    .visible = true,
    .named = true,
  },
  [sym_MAX] = {
    .visible = true,
    .named = true,
  },
  [sym_MAXIMIZE] = {
    .visible = true,
    .named = true,
  },
  [sym_MIN] = {
    .visible = true,
    .named = true,
  },
  [sym_MINIMIZE] = {
    .visible = true,
    .named = true,
  },
  [sym_MOD] = {
    .visible = true,
    .named = true,
  },
  [sym_MUL] = {
    .visible = true,
    .named = true,
  },
  [sym_NEQ] = {
    .visible = true,
    .named = true,
  },
  [sym_POW] = {
    .visible = true,
    .named = true,
  },
  [sym_QUESTION] = {
    .visible = true,
    .named = true,
  },
  [sym_RBRACE] = {
    .visible = true,
    .named = true,
  },
  [sym_RBRACK] = {
    .visible = true,
    .named = true,
  },
  [sym_RPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_SEM] = {
    .visible = true,
    .named = true,
  },
  [sym_SHOW] = {
    .visible = true,
    .named = true,
  },
  [sym_EDGE] = {
    .visible = true,
    .named = true,
  },
  [sym_PROJECT] = {
    .visible = true,
    .named = true,
  },
  [sym_HEURISTIC] = {
    .visible = true,
    .named = true,
  },
  [sym_SHOWSIG] = {
    .visible = true,
    .named = true,
  },
  [sym_SLASH] = {
    .visible = true,
    .named = true,
  },
  [sym_SUB] = {
    .visible = true,
    .named = true,
  },
  [sym_SUM] = {
    .visible = true,
    .named = true,
  },
  [sym_SUMP] = {
    .visible = true,
    .named = true,
  },
  [sym_SUPREMUM] = {
    .visible = true,
    .named = true,
  },
  [sym_TRUE] = {
    .visible = true,
    .named = true,
  },
  [sym_BLOCK] = {
    .visible = true,
    .named = true,
  },
  [sym_VBAR] = {
    .visible = true,
    .named = true,
  },
  [sym_WIF] = {
    .visible = true,
    .named = true,
  },
  [sym_XOR] = {
    .visible = true,
    .named = true,
  },
  [sym_ANY] = {
    .visible = true,
    .named = true,
  },
  [sym_UNARY] = {
    .visible = true,
    .named = true,
  },
  [sym_BINARY] = {
    .visible = true,
    .named = true,
  },
  [sym_LEFT] = {
    .visible = true,
    .named = true,
  },
  [sym_RIGHT] = {
    .visible = true,
    .named = true,
  },
  [sym_HEAD] = {
    .visible = true,
    .named = true,
  },
  [sym_BODY] = {
    .visible = true,
    .named = true,
  },
  [sym_DIRECTIVE] = {
    .visible = true,
    .named = true,
  },
  [sym_THEORY] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_dec_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_hex] = {
    .visible = true,
    .named = true,
  },
  [sym_oct] = {
    .visible = true,
    .named = true,
  },
  [sym_bin] = {
    .visible = true,
    .named = true,
  },
  [sym_ANONYMOUS] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = true,
  },
  [sym_SCRIPT] = {
    .visible = true,
    .named = true,
  },
  [sym_CODE] = {
    .visible = true,
    .named = true,
  },
  [sym_VARIABLE] = {
    .visible = true,
    .named = true,
  },
  [sym_THEORY_OP] = {
    .visible = true,
    .named = true,
  },
  [sym_NOT] = {
    .visible = true,
    .named = true,
  },
  [sym_DEFAULT] = {
    .visible = true,
    .named = true,
  },
  [sym_OVERRIDE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_NUMBER] = {
    .visible = true,
    .named = true,
  },
  [sym_dec] = {
    .visible = true,
    .named = true,
  },
  [sym__widentifier] = {
    .visible = false,
    .named = true,
  },
  [sym_constterm] = {
    .visible = true,
    .named = true,
  },
  [sym_consttermvec] = {
    .visible = true,
    .named = true,
  },
  [sym_nconstargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_term] = {
    .visible = true,
    .named = true,
  },
  [sym_unaryargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_ntermvec] = {
    .visible = true,
    .named = true,
  },
  [sym_ntuple] = {
    .visible = true,
    .named = true,
  },
  [sym_tuplevec_sem] = {
    .visible = true,
    .named = true,
  },
  [sym_ntuplevec] = {
    .visible = true,
    .named = true,
  },
  [sym_argvec] = {
    .visible = true,
    .named = true,
  },
  [sym_binaryargvec] = {
    .visible = true,
    .named = true,
  },
  [sym_cmp] = {
    .visible = true,
    .named = true,
  },
  [sym_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_mul_term] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_add_term] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_rel] = {
    .visible = true,
    .named = true,
  },
  [sym_csp_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_nlitvec] = {
    .visible = true,
    .named = true,
  },
  [sym_noptcondition] = {
    .visible = true,
    .named = true,
  },
  [sym_aggregatefunction] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggrelem] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_altbodyaggrelem] = {
    .visible = true,
    .named = true,
  },
  [sym_altbodyaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_nupper] = {
    .visible = true,
    .named = true,
  },
  [sym_lubodyaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_headaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_altheadaggrelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_headaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_luheadaggregate] = {
    .visible = true,
    .named = true,
  },
  [sym_ncspelemvec] = {
    .visible = true,
    .named = true,
  },
  [sym_disjoint] = {
    .visible = true,
    .named = true,
  },
  [sym_conjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_dsym] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunctionsep] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_nbodycomma] = {
    .visible = true,
    .named = true,
  },
  [sym_bodydot] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyconddot] = {
    .visible = true,
    .named = true,
  },
  [sym_head] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_noptimizetuple] = {
    .visible = true,
    .named = true,
  },
  [sym_optimizeweight] = {
    .visible = true,
    .named = true,
  },
  [sym_optimizelitvec] = {
    .visible = true,
    .named = true,
  },
  [sym_noptimizecond] = {
    .visible = true,
    .named = true,
  },
  [sym_maxelemlist] = {
    .visible = true,
    .named = true,
  },
  [sym_minelemlist] = {
    .visible = true,
    .named = true,
  },
  [sym_nidlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_op] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_op_list] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_term] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_opterm] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_opterm_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_element] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_element_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_name] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_operator_definition_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_definition_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_term_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_type] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_atom_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_theory_definition_nlist] = {
    .visible = true,
    .named = true,
  },
  [sym_STRING] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_STRING_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_STRING_repeat2] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_THEORY_OP_character_set_1(int32_t c) {
  return (c < ';'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '-' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static inline bool sym_THEORY_OP_character_set_2(int32_t c) {
  return (c < ':'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '-' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static inline bool sym_THEORY_OP_character_set_3(int32_t c) {
  return (c < ':'
    ? (c < '*'
      ? (c < '&'
        ? c == '!'
        : c <= '&')
      : (c <= '+' || (c >= '.' && c <= '/')))
    : (c <= '@' || (c < '|'
      ? (c < '^'
        ? c == '\\'
        : c <= '^')
      : (c <= '|' || c == '~'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(231);
      if (lookahead == '!') ADVANCE(99);
      if (lookahead == '"') ADVANCE(399);
      if (lookahead == '#') ADVANCE(110);
      if (lookahead == '$') ADVANCE(254);
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == '(') ADVANCE(377);
      if (lookahead == ')') ADVANCE(297);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(266);
      if (lookahead == '/') ADVANCE(305);
      if (lookahead == '0') ADVANCE(324);
      if (lookahead == ':') ADVANCE(248);
      if (lookahead == ';') ADVANCE(298);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == '>') ADVANCE(273);
      if (lookahead == '?') ADVANCE(294);
      if (lookahead == '@') ADVANCE(245);
      if (lookahead == '[') ADVANCE(279);
      if (lookahead == '\\') ADVANCE(290);
      if (lookahead == ']') ADVANCE(296);
      if (lookahead == '^') ADVANCE(314);
      if (lookahead == '_') ADVANCE(329);
      if (lookahead == 'a') ADVANCE(355);
      if (lookahead == 'b') ADVANCE(353);
      if (lookahead == 'd') ADVANCE(338);
      if (lookahead == 'h') ADVANCE(339);
      if (lookahead == 'l') ADVANCE(343);
      if (lookahead == 'n') ADVANCE(358);
      if (lookahead == 'o') ADVANCE(370);
      if (lookahead == 'r') ADVANCE(350);
      if (lookahead == 'u') ADVANCE(356);
      if (lookahead == '{') ADVANCE(278);
      if (lookahead == '|') ADVANCE(312);
      if (lookahead == '}') ADVANCE(295);
      if (lookahead == '~') ADVANCE(246);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(229)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('c' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(388);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(37);
      if (lookahead == ' ') ADVANCE(233);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(37);
      if (lookahead == ' ') ADVANCE(233);
      if (lookahead == '#') ADVANCE(5);
      if (lookahead == 'd') ADVANCE(1);
      if (lookahead == 'e') ADVANCE(19);
      if (lookahead == 'n') ADVANCE(8);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(37);
      if (lookahead == ' ') ADVANCE(233);
      if (lookahead == '#') ADVANCE(4);
      if (lookahead == 'd') ADVANCE(1);
      if (lookahead == 'e') ADVANCE(19);
      if (lookahead == 'n') ADVANCE(8);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(37);
      if (lookahead == ' ') ADVANCE(233);
      if (lookahead == '#') ADVANCE(4);
      if (lookahead == 'd') ADVANCE(1);
      if (lookahead == 'e') ADVANCE(7);
      if (lookahead == 'n') ADVANCE(8);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(37);
      if (lookahead == ' ') ADVANCE(233);
      if (lookahead == '#') ADVANCE(4);
      if (lookahead == 'd') ADVANCE(1);
      if (lookahead == 'e') ADVANCE(6);
      if (lookahead == 'n') ADVANCE(8);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(37);
      if (lookahead == ' ') ADVANCE(233);
      if (lookahead == '#') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(1);
      if (lookahead == 'e') ADVANCE(6);
      if (lookahead == 'n') ADVANCE(8);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(37);
      if (lookahead == ' ') ADVANCE(233);
      if (lookahead == '#') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(1);
      if (lookahead == 'e') ADVANCE(6);
      if (lookahead == 'n') ADVANCE(9);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(37);
      if (lookahead == ' ') ADVANCE(233);
      if (lookahead == '#') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(1);
      if (lookahead == 'n') ADVANCE(8);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(37);
      if (lookahead == ' ') ADVANCE(233);
      if (lookahead == '#') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(379);
      if (lookahead == 'n') ADVANCE(8);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 10:
      if (lookahead == '\n') ADVANCE(40);
      if (lookahead == ' ') ADVANCE(234);
      if (lookahead == '#') ADVANCE(10);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(12);
      if (lookahead == 'n') ADVANCE(13);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 11:
      if (lookahead == '\n') ADVANCE(40);
      if (lookahead == ' ') ADVANCE(234);
      if (lookahead == '#') ADVANCE(10);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(11);
      if (lookahead == 'n') ADVANCE(13);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 12:
      if (lookahead == '\n') ADVANCE(40);
      if (lookahead == ' ') ADVANCE(234);
      if (lookahead == '#') ADVANCE(10);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(11);
      if (lookahead == 'n') ADVANCE(14);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 13:
      if (lookahead == '\n') ADVANCE(40);
      if (lookahead == ' ') ADVANCE(234);
      if (lookahead == '#') ADVANCE(10);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'n') ADVANCE(13);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 14:
      if (lookahead == '\n') ADVANCE(40);
      if (lookahead == ' ') ADVANCE(234);
      if (lookahead == '#') ADVANCE(10);
      if (lookahead == 'd') ADVANCE(380);
      if (lookahead == 'n') ADVANCE(13);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 15:
      if (lookahead == '\n') ADVANCE(40);
      if (lookahead == ' ') ADVANCE(234);
      if (lookahead == '#') ADVANCE(16);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 16:
      if (lookahead == '\n') ADVANCE(40);
      if (lookahead == ' ') ADVANCE(234);
      if (lookahead == '#') ADVANCE(11);
      if (lookahead == 'd') ADVANCE(25);
      if (lookahead == 'e') ADVANCE(12);
      if (lookahead == 'n') ADVANCE(13);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 17:
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == ' ') ADVANCE(235);
      if (lookahead == '#') ADVANCE(18);
      if (lookahead == 'd') ADVANCE(22);
      if (lookahead == 'e') ADVANCE(19);
      if (lookahead == 'n') ADVANCE(13);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 18:
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == ' ') ADVANCE(235);
      if (lookahead == '#') ADVANCE(18);
      if (lookahead == 'd') ADVANCE(22);
      if (lookahead == 'e') ADVANCE(19);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 19:
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == ' ') ADVANCE(235);
      if (lookahead == '#') ADVANCE(18);
      if (lookahead == 'd') ADVANCE(22);
      if (lookahead == 'e') ADVANCE(20);
      if (lookahead == 'n') ADVANCE(23);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 20:
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == ' ') ADVANCE(235);
      if (lookahead == '#') ADVANCE(18);
      if (lookahead == 'd') ADVANCE(22);
      if (lookahead == 'e') ADVANCE(20);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 21:
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == ' ') ADVANCE(235);
      if (lookahead == '#') ADVANCE(20);
      if (lookahead == 'd') ADVANCE(22);
      if (lookahead == 'e') ADVANCE(19);
      if (lookahead == 'n') ADVANCE(13);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 22:
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == ' ') ADVANCE(235);
      if (lookahead == '#') ADVANCE(21);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 23:
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == ' ') ADVANCE(235);
      if (lookahead == '#') ADVANCE(17);
      if (lookahead == 'd') ADVANCE(381);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 24:
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == ' ') ADVANCE(235);
      if (lookahead == '#') ADVANCE(17);
      if (lookahead == 'd') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 25:
      if (lookahead == ' ') ADVANCE(236);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(25);
      END_STATE();
    case 26:
      if (lookahead == '!') ADVANCE(99);
      if (lookahead == '"') ADVANCE(399);
      if (lookahead == '#') ADVANCE(114);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == '(') ADVANCE(281);
      if (lookahead == ')') ADVANCE(297);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(266);
      if (lookahead == '/') ADVANCE(305);
      if (lookahead == '0') ADVANCE(324);
      if (lookahead == ':') ADVANCE(247);
      if (lookahead == ';') ADVANCE(298);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == '>') ADVANCE(273);
      if (lookahead == '?') ADVANCE(294);
      if (lookahead == '@') ADVANCE(245);
      if (lookahead == '\\') ADVANCE(290);
      if (lookahead == ']') ADVANCE(296);
      if (lookahead == '^') ADVANCE(314);
      if (lookahead == '_') ADVANCE(329);
      if (lookahead == '{') ADVANCE(278);
      if (lookahead == '|') ADVANCE(312);
      if (lookahead == '}') ADVANCE(295);
      if (lookahead == '~') ADVANCE(246);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(388);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 27:
      if (lookahead == '!') ADVANCE(99);
      if (lookahead == '"') ADVANCE(399);
      if (lookahead == '#') ADVANCE(149);
      if (lookahead == '$') ADVANCE(253);
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == '(') ADVANCE(281);
      if (lookahead == ')') ADVANCE(297);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(265);
      if (lookahead == '/') ADVANCE(305);
      if (lookahead == '0') ADVANCE(324);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == '>') ADVANCE(273);
      if (lookahead == '?') ADVANCE(294);
      if (lookahead == '@') ADVANCE(245);
      if (lookahead == '\\') ADVANCE(289);
      if (lookahead == '^') ADVANCE(314);
      if (lookahead == '_') ADVANCE(329);
      if (lookahead == '|') ADVANCE(312);
      if (lookahead == '~') ADVANCE(246);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(388);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 28:
      if (lookahead == '!') ADVANCE(99);
      if (lookahead == '#') ADVANCE(115);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '(') ADVANCE(377);
      if (lookahead == ')') ADVANCE(297);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(266);
      if (lookahead == '/') ADVANCE(305);
      if (lookahead == ':') ADVANCE(247);
      if (lookahead == ';') ADVANCE(298);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == '>') ADVANCE(273);
      if (lookahead == '?') ADVANCE(294);
      if (lookahead == '@') ADVANCE(245);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == ']') ADVANCE(296);
      if (lookahead == '^') ADVANCE(314);
      if (lookahead == '_') ADVANCE(103);
      if (lookahead == 'a') ADVANCE(355);
      if (lookahead == 'b') ADVANCE(353);
      if (lookahead == 'd') ADVANCE(349);
      if (lookahead == 'h') ADVANCE(339);
      if (lookahead == 'l') ADVANCE(343);
      if (lookahead == 'r') ADVANCE(350);
      if (lookahead == 'u') ADVANCE(356);
      if (lookahead == '{') ADVANCE(278);
      if (lookahead == '|') ADVANCE(312);
      if (lookahead == '}') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (('c' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 29:
      if (lookahead == '!') ADVANCE(99);
      if (lookahead == '#') ADVANCE(115);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '(') ADVANCE(377);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(266);
      if (lookahead == '/') ADVANCE(305);
      if (lookahead == ':') ADVANCE(248);
      if (lookahead == ';') ADVANCE(298);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == '>') ADVANCE(273);
      if (lookahead == '?') ADVANCE(294);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == '^') ADVANCE(314);
      if (lookahead == 'd') ADVANCE(133);
      if (lookahead == 'o') ADVANCE(213);
      if (lookahead == '{') ADVANCE(278);
      if (lookahead == '|') ADVANCE(312);
      if (lookahead == '}') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      END_STATE();
    case 30:
      if (lookahead == '!') ADVANCE(99);
      if (lookahead == '#') ADVANCE(115);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == ')') ADVANCE(297);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(266);
      if (lookahead == '/') ADVANCE(305);
      if (lookahead == ':') ADVANCE(247);
      if (lookahead == ';') ADVANCE(298);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == '>') ADVANCE(273);
      if (lookahead == '?') ADVANCE(294);
      if (lookahead == '@') ADVANCE(245);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == ']') ADVANCE(296);
      if (lookahead == '^') ADVANCE(314);
      if (lookahead == '_') ADVANCE(103);
      if (lookahead == 'a') ADVANCE(355);
      if (lookahead == 'b') ADVANCE(353);
      if (lookahead == 'd') ADVANCE(349);
      if (lookahead == 'h') ADVANCE(339);
      if (lookahead == 'l') ADVANCE(343);
      if (lookahead == 'r') ADVANCE(350);
      if (lookahead == 'u') ADVANCE(356);
      if (lookahead == '{') ADVANCE(278);
      if (lookahead == '|') ADVANCE(312);
      if (lookahead == '}') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (('c' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 31:
      if (lookahead == '!') ADVANCE(99);
      if (lookahead == '#') ADVANCE(115);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(266);
      if (lookahead == '/') ADVANCE(305);
      if (lookahead == ':') ADVANCE(248);
      if (lookahead == ';') ADVANCE(298);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == '>') ADVANCE(273);
      if (lookahead == '?') ADVANCE(294);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == '^') ADVANCE(314);
      if (lookahead == 'd') ADVANCE(133);
      if (lookahead == 'o') ADVANCE(213);
      if (lookahead == '{') ADVANCE(278);
      if (lookahead == '|') ADVANCE(312);
      if (lookahead == '}') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      END_STATE();
    case 32:
      if (lookahead == '!') ADVANCE(100);
      if (lookahead == '*') ADVANCE(257);
      if (lookahead == '+') ADVANCE(255);
      if (lookahead == '-') ADVANCE(256);
      if (lookahead == '<') ADVANCE(259);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == '>') ADVANCE(260);
      END_STATE();
    case 33:
      if (lookahead == '"') ADVANCE(399);
      if (lookahead == '#') ADVANCE(149);
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == '(') ADVANCE(281);
      if (lookahead == ')') ADVANCE(297);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '0') ADVANCE(324);
      if (lookahead == '[') ADVANCE(279);
      if (lookahead == ']') ADVANCE(296);
      if (lookahead == '_') ADVANCE(102);
      if (lookahead == 'n') ADVANCE(358);
      if (lookahead == '{') ADVANCE(278);
      if (lookahead == '}') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (lookahead == '!' ||
          ('&' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(390);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(388);
      END_STATE();
    case 34:
      if (lookahead == '"') ADVANCE(399);
      if (lookahead == '#') ADVANCE(149);
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == '(') ADVANCE(281);
      if (lookahead == '0') ADVANCE(324);
      if (lookahead == ':') ADVANCE(249);
      if (lookahead == '[') ADVANCE(279);
      if (lookahead == '_') ADVANCE(102);
      if (lookahead == 'n') ADVANCE(358);
      if (lookahead == '{') ADVANCE(278);
      if (lookahead == '}') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (lookahead == '!' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(390);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(388);
      END_STATE();
    case 35:
      if (lookahead == '"') ADVANCE(399);
      if (lookahead == '%') ADVANCE(405);
      if (lookahead == '\\') ADVANCE(206);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(402);
      if (lookahead != 0) ADVANCE(406);
      END_STATE();
    case 36:
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '%') ADVANCE(238);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(36);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 37:
      if (lookahead == '#') ADVANCE(56);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 38:
      if (lookahead == '#') ADVANCE(57);
      if (lookahead == '%') ADVANCE(237);
      if (lookahead == '*') ADVANCE(38);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 39:
      if (lookahead == '#') ADVANCE(57);
      if (lookahead == '*') ADVANCE(38);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 40:
      if (lookahead == '#') ADVANCE(58);
      if (lookahead != 0) ADVANCE(40);
      END_STATE();
    case 41:
      if (lookahead == '#') ADVANCE(59);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '*') ADVANCE(41);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 42:
      if (lookahead == '#') ADVANCE(59);
      if (lookahead == '*') ADVANCE(41);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 43:
      if (lookahead == '#') ADVANCE(74);
      if (lookahead != 0) ADVANCE(43);
      END_STATE();
    case 44:
      if (lookahead == '#') ADVANCE(75);
      if (lookahead == '%') ADVANCE(240);
      if (lookahead == '*') ADVANCE(44);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 45:
      if (lookahead == '#') ADVANCE(75);
      if (lookahead == '*') ADVANCE(44);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 46:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(40);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(49);
      if (lookahead != 0) ADVANCE(40);
      END_STATE();
    case 47:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(40);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(49);
      if (lookahead != 0) ADVANCE(40);
      END_STATE();
    case 48:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(40);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(50);
      if (lookahead != 0) ADVANCE(40);
      END_STATE();
    case 49:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(40);
      if (lookahead == 'n') ADVANCE(49);
      if (lookahead != 0) ADVANCE(40);
      END_STATE();
    case 50:
      if (lookahead == '#') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(384);
      if (lookahead == 'n') ADVANCE(49);
      if (lookahead != 0) ADVANCE(40);
      END_STATE();
    case 51:
      if (lookahead == '#') ADVANCE(52);
      if (lookahead == '*') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(385);
      if (lookahead == 'n') ADVANCE(55);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 52:
      if (lookahead == '#') ADVANCE(52);
      if (lookahead == '*') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(42);
      if (lookahead == 'e') ADVANCE(54);
      if (lookahead == 'n') ADVANCE(55);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 53:
      if (lookahead == '#') ADVANCE(52);
      if (lookahead == '*') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(42);
      if (lookahead == 'e') ADVANCE(53);
      if (lookahead == 'n') ADVANCE(55);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 54:
      if (lookahead == '#') ADVANCE(52);
      if (lookahead == '*') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(42);
      if (lookahead == 'e') ADVANCE(53);
      if (lookahead == 'n') ADVANCE(51);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 55:
      if (lookahead == '#') ADVANCE(52);
      if (lookahead == '*') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(42);
      if (lookahead == 'n') ADVANCE(55);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 56:
      if (lookahead == '#') ADVANCE(62);
      if (lookahead == 'd') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(68);
      if (lookahead == 'n') ADVANCE(78);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 57:
      if (lookahead == '#') ADVANCE(65);
      if (lookahead == '*') ADVANCE(38);
      if (lookahead == 'd') ADVANCE(39);
      if (lookahead == 'e') ADVANCE(72);
      if (lookahead == 'n') ADVANCE(82);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 58:
      if (lookahead == '#') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(49);
      if (lookahead != 0 &&
          lookahead != 'd') ADVANCE(40);
      END_STATE();
    case 59:
      if (lookahead == '#') ADVANCE(53);
      if (lookahead == '*') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(96);
      if (lookahead == 'e') ADVANCE(54);
      if (lookahead == 'n') ADVANCE(55);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 60:
      if (lookahead == '#') ADVANCE(61);
      if (lookahead == 'd') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(68);
      if (lookahead == 'n') ADVANCE(78);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 61:
      if (lookahead == '#') ADVANCE(61);
      if (lookahead == 'd') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'n') ADVANCE(78);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 62:
      if (lookahead == '#') ADVANCE(61);
      if (lookahead == 'd') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(78);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 63:
      if (lookahead == '#') ADVANCE(64);
      if (lookahead == '*') ADVANCE(38);
      if (lookahead == 'd') ADVANCE(39);
      if (lookahead == 'e') ADVANCE(72);
      if (lookahead == 'n') ADVANCE(82);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 64:
      if (lookahead == '#') ADVANCE(64);
      if (lookahead == '*') ADVANCE(38);
      if (lookahead == 'd') ADVANCE(39);
      if (lookahead == 'e') ADVANCE(81);
      if (lookahead == 'n') ADVANCE(82);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 65:
      if (lookahead == '#') ADVANCE(64);
      if (lookahead == '*') ADVANCE(38);
      if (lookahead == 'd') ADVANCE(39);
      if (lookahead == 'e') ADVANCE(80);
      if (lookahead == 'n') ADVANCE(82);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 66:
      if (lookahead == '#') ADVANCE(67);
      if (lookahead == 'd') ADVANCE(43);
      if (lookahead == 'e') ADVANCE(68);
      if (lookahead == 'n') ADVANCE(49);
      if (lookahead != 0) ADVANCE(43);
      END_STATE();
    case 67:
      if (lookahead == '#') ADVANCE(67);
      if (lookahead == 'd') ADVANCE(43);
      if (lookahead == 'e') ADVANCE(68);
      if (lookahead == 'n') ADVANCE(85);
      if (lookahead != 0) ADVANCE(43);
      END_STATE();
    case 68:
      if (lookahead == '#') ADVANCE(67);
      if (lookahead == 'd') ADVANCE(43);
      if (lookahead == 'e') ADVANCE(69);
      if (lookahead == 'n') ADVANCE(84);
      if (lookahead != 0) ADVANCE(43);
      END_STATE();
    case 69:
      if (lookahead == '#') ADVANCE(67);
      if (lookahead == 'd') ADVANCE(43);
      if (lookahead == 'e') ADVANCE(69);
      if (lookahead == 'n') ADVANCE(85);
      if (lookahead != 0) ADVANCE(43);
      END_STATE();
    case 70:
      if (lookahead == '#') ADVANCE(71);
      if (lookahead == '*') ADVANCE(44);
      if (lookahead == 'd') ADVANCE(45);
      if (lookahead == 'e') ADVANCE(72);
      if (lookahead == 'n') ADVANCE(55);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 71:
      if (lookahead == '#') ADVANCE(71);
      if (lookahead == '*') ADVANCE(44);
      if (lookahead == 'd') ADVANCE(45);
      if (lookahead == 'e') ADVANCE(72);
      if (lookahead == 'n') ADVANCE(87);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 72:
      if (lookahead == '#') ADVANCE(71);
      if (lookahead == '*') ADVANCE(44);
      if (lookahead == 'd') ADVANCE(45);
      if (lookahead == 'e') ADVANCE(73);
      if (lookahead == 'n') ADVANCE(86);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 73:
      if (lookahead == '#') ADVANCE(71);
      if (lookahead == '*') ADVANCE(44);
      if (lookahead == 'd') ADVANCE(45);
      if (lookahead == 'e') ADVANCE(73);
      if (lookahead == 'n') ADVANCE(87);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 74:
      if (lookahead == '#') ADVANCE(69);
      if (lookahead == 'd') ADVANCE(43);
      if (lookahead == 'e') ADVANCE(68);
      if (lookahead == 'n') ADVANCE(49);
      if (lookahead != 0) ADVANCE(43);
      END_STATE();
    case 75:
      if (lookahead == '#') ADVANCE(73);
      if (lookahead == '*') ADVANCE(44);
      if (lookahead == 'd') ADVANCE(45);
      if (lookahead == 'e') ADVANCE(72);
      if (lookahead == 'n') ADVANCE(55);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 76:
      if (lookahead == '#') ADVANCE(60);
      if (lookahead == 'd') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(78);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 77:
      if (lookahead == '#') ADVANCE(60);
      if (lookahead == 'd') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(79);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 78:
      if (lookahead == '#') ADVANCE(60);
      if (lookahead == 'd') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(78);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 79:
      if (lookahead == '#') ADVANCE(60);
      if (lookahead == 'd') ADVANCE(382);
      if (lookahead == 'n') ADVANCE(78);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 80:
      if (lookahead == '#') ADVANCE(63);
      if (lookahead == '*') ADVANCE(38);
      if (lookahead == 'd') ADVANCE(39);
      if (lookahead == 'e') ADVANCE(80);
      if (lookahead == 'n') ADVANCE(82);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 81:
      if (lookahead == '#') ADVANCE(63);
      if (lookahead == '*') ADVANCE(38);
      if (lookahead == 'd') ADVANCE(39);
      if (lookahead == 'e') ADVANCE(80);
      if (lookahead == 'n') ADVANCE(83);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 82:
      if (lookahead == '#') ADVANCE(63);
      if (lookahead == '*') ADVANCE(38);
      if (lookahead == 'd') ADVANCE(39);
      if (lookahead == 'n') ADVANCE(82);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 83:
      if (lookahead == '#') ADVANCE(63);
      if (lookahead == '*') ADVANCE(38);
      if (lookahead == 'd') ADVANCE(383);
      if (lookahead == 'n') ADVANCE(82);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 84:
      if (lookahead == '#') ADVANCE(66);
      if (lookahead == 'd') ADVANCE(386);
      if (lookahead == 'n') ADVANCE(85);
      if (lookahead != 0) ADVANCE(43);
      END_STATE();
    case 85:
      if (lookahead == '#') ADVANCE(66);
      if (lookahead == 'd') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(85);
      if (lookahead != 0) ADVANCE(43);
      END_STATE();
    case 86:
      if (lookahead == '#') ADVANCE(70);
      if (lookahead == '*') ADVANCE(44);
      if (lookahead == 'd') ADVANCE(387);
      if (lookahead == 'n') ADVANCE(87);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 87:
      if (lookahead == '#') ADVANCE(70);
      if (lookahead == '*') ADVANCE(44);
      if (lookahead == 'd') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(87);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 88:
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '(') ADVANCE(377);
      if (lookahead == ')') ADVANCE(297);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(265);
      if (lookahead == '/') ADVANCE(305);
      if (lookahead == '?') ADVANCE(294);
      if (lookahead == '\\') ADVANCE(289);
      if (lookahead == '^') ADVANCE(314);
      if (lookahead == '|') ADVANCE(312);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(89)
      END_STATE();
    case 89:
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == ')') ADVANCE(297);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(265);
      if (lookahead == '/') ADVANCE(305);
      if (lookahead == '?') ADVANCE(294);
      if (lookahead == '\\') ADVANCE(289);
      if (lookahead == '^') ADVANCE(314);
      if (lookahead == '|') ADVANCE(312);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(89)
      END_STATE();
    case 90:
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '(') ADVANCE(281);
      if (lookahead == ')') ADVANCE(297);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == ']') ADVANCE(296);
      if (lookahead == 'n') ADVANCE(178);
      if (lookahead == '}') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(90)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          (':' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(390);
      END_STATE();
    case 91:
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '(') ADVANCE(281);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '.') ADVANCE(267);
      if (lookahead == ';') ADVANCE(299);
      if (lookahead == 'n') ADVANCE(178);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(91)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          (':' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(390);
      END_STATE();
    case 92:
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '(') ADVANCE(281);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == ':') ADVANCE(249);
      if (lookahead == ';') ADVANCE(299);
      if (lookahead == 'n') ADVANCE(178);
      if (lookahead == '}') ADVANCE(295);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(92)
      if (lookahead == '!' ||
          lookahead == '&' ||
          ('*' <= lookahead && lookahead <= '/') ||
          ('<' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(390);
      END_STATE();
    case 93:
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '(') ADVANCE(281);
      if (lookahead == '.') ADVANCE(267);
      if (lookahead == ':') ADVANCE(389);
      if (lookahead == 'n') ADVANCE(178);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(93)
      if (sym_THEORY_OP_character_set_1(lookahead)) ADVANCE(390);
      END_STATE();
    case 94:
      if (lookahead == '%') ADVANCE(232);
      if (lookahead == '*') ADVANCE(94);
      if (lookahead != 0) ADVANCE(96);
      END_STATE();
    case 95:
      if (lookahead == '%') ADVANCE(411);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == '\\') ADVANCE(206);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(408);
      if (lookahead != 0) ADVANCE(412);
      END_STATE();
    case 96:
      if (lookahead == '*') ADVANCE(94);
      if (lookahead != 0) ADVANCE(96);
      END_STATE();
    case 97:
      if (lookahead == '-') ADVANCE(274);
      END_STATE();
    case 98:
      if (lookahead == '-') ADVANCE(274);
      if (lookahead == '~') ADVANCE(313);
      END_STATE();
    case 99:
      if (lookahead == '=') ADVANCE(292);
      END_STATE();
    case 100:
      if (lookahead == '=') ADVANCE(263);
      END_STATE();
    case 101:
      if (lookahead == '\\') ADVANCE(397);
      END_STATE();
    case 102:
      if (lookahead == '_') ADVANCE(102);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(388);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 103:
      if (lookahead == '_') ADVANCE(103);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 104:
      if (lookahead == 'a') ADVANCE(156);
      END_STATE();
    case 105:
      if (lookahead == 'a') ADVANCE(215);
      if (lookahead == 'i') ADVANCE(165);
      END_STATE();
    case 106:
      if (lookahead == 'a') ADVANCE(216);
      if (lookahead == 'i') ADVANCE(166);
      END_STATE();
    case 107:
      if (lookahead == 'a') ADVANCE(161);
      END_STATE();
    case 108:
      if (lookahead == 'a') ADVANCE(155);
      END_STATE();
    case 109:
      if (lookahead == 'a') ADVANCE(210);
      END_STATE();
    case 110:
      if (lookahead == 'c') ADVANCE(173);
      if (lookahead == 'd') ADVANCE(121);
      if (lookahead == 'e') ADVANCE(117);
      if (lookahead == 'f') ADVANCE(104);
      if (lookahead == 'h') ADVANCE(122);
      if (lookahead == 'i') ADVANCE(164);
      if (lookahead == 'm') ADVANCE(105);
      if (lookahead == 'p') ADVANCE(183);
      if (lookahead == 's') ADVANCE(112);
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 111:
      if (lookahead == 'c') ADVANCE(303);
      END_STATE();
    case 112:
      if (lookahead == 'c') ADVANCE(186);
      if (lookahead == 'h') ADVANCE(175);
      if (lookahead == 'u') ADVANCE(160);
      END_STATE();
    case 113:
      if (lookahead == 'c') ADVANCE(157);
      if (lookahead == 'f') ADVANCE(277);
      END_STATE();
    case 114:
      if (lookahead == 'c') ADVANCE(177);
      if (lookahead == 'd') ADVANCE(143);
      if (lookahead == 'f') ADVANCE(104);
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == 'm') ADVANCE(106);
      if (lookahead == 's') ADVANCE(204);
      if (lookahead == 't') ADVANCE(185);
      END_STATE();
    case 115:
      if (lookahead == 'c') ADVANCE(177);
      if (lookahead == 'm') ADVANCE(106);
      if (lookahead == 's') ADVANCE(209);
      END_STATE();
    case 116:
      if (lookahead == 'c') ADVANCE(198);
      END_STATE();
    case 117:
      if (lookahead == 'd') ADVANCE(140);
      if (lookahead == 'x') ADVANCE(202);
      END_STATE();
    case 118:
      if (lookahead == 'd') ADVANCE(270);
      END_STATE();
    case 119:
      if (lookahead == 'd') ADVANCE(127);
      END_STATE();
    case 120:
      if (lookahead == 'd') ADVANCE(130);
      END_STATE();
    case 121:
      if (lookahead == 'e') ADVANCE(136);
      if (lookahead == 'i') ADVANCE(191);
      END_STATE();
    case 122:
      if (lookahead == 'e') ADVANCE(212);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(301);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(310);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(271);
      END_STATE();
    case 126:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(276);
      END_STATE();
    case 128:
      if (lookahead == 'e') ADVANCE(285);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(288);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(395);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 133:
      if (lookahead == 'e') ADVANCE(138);
      END_STATE();
    case 134:
      if (lookahead == 'e') ADVANCE(176);
      END_STATE();
    case 135:
      if (lookahead == 'e') ADVANCE(190);
      END_STATE();
    case 136:
      if (lookahead == 'f') ADVANCE(148);
      END_STATE();
    case 137:
      if (lookahead == 'f') ADVANCE(277);
      END_STATE();
    case 138:
      if (lookahead == 'f') ADVANCE(109);
      END_STATE();
    case 139:
      if (lookahead == 'g') ADVANCE(304);
      END_STATE();
    case 140:
      if (lookahead == 'g') ADVANCE(123);
      END_STATE();
    case 141:
      if (lookahead == 'g') ADVANCE(184);
      if (lookahead == 'j') ADVANCE(126);
      END_STATE();
    case 142:
      if (lookahead == 'h') ADVANCE(134);
      if (lookahead == 'r') ADVANCE(211);
      END_STATE();
    case 143:
      if (lookahead == 'i') ADVANCE(191);
      END_STATE();
    case 144:
      if (lookahead == 'i') ADVANCE(181);
      END_STATE();
    case 145:
      if (lookahead == 'i') ADVANCE(218);
      END_STATE();
    case 146:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(111);
      END_STATE();
    case 148:
      if (lookahead == 'i') ADVANCE(171);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == 's') ADVANCE(207);
      END_STATE();
    case 150:
      if (lookahead == 'i') ADVANCE(120);
      END_STATE();
    case 151:
      if (lookahead == 'i') ADVANCE(219);
      END_STATE();
    case 152:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 153:
      if (lookahead == 'i') ADVANCE(170);
      END_STATE();
    case 154:
      if (lookahead == 'j') ADVANCE(179);
      END_STATE();
    case 155:
      if (lookahead == 'l') ADVANCE(269);
      END_STATE();
    case 156:
      if (lookahead == 'l') ADVANCE(194);
      END_STATE();
    case 157:
      if (lookahead == 'l') ADVANCE(205);
      END_STATE();
    case 158:
      if (lookahead == 'l') ADVANCE(200);
      END_STATE();
    case 159:
      if (lookahead == 'm') ADVANCE(307);
      END_STATE();
    case 160:
      if (lookahead == 'm') ADVANCE(307);
      if (lookahead == 'p') ADVANCE(309);
      END_STATE();
    case 161:
      if (lookahead == 'm') ADVANCE(311);
      END_STATE();
    case 162:
      if (lookahead == 'm') ADVANCE(145);
      END_STATE();
    case 163:
      if (lookahead == 'm') ADVANCE(151);
      END_STATE();
    case 164:
      if (lookahead == 'n') ADVANCE(113);
      END_STATE();
    case 165:
      if (lookahead == 'n') ADVANCE(287);
      END_STATE();
    case 166:
      if (lookahead == 'n') ADVANCE(286);
      END_STATE();
    case 167:
      if (lookahead == 'n') ADVANCE(137);
      END_STATE();
    case 168:
      if (lookahead == 'n') ADVANCE(192);
      if (lookahead == 'u') ADVANCE(169);
      END_STATE();
    case 169:
      if (lookahead == 'n') ADVANCE(196);
      END_STATE();
    case 170:
      if (lookahead == 'n') ADVANCE(199);
      END_STATE();
    case 171:
      if (lookahead == 'n') ADVANCE(131);
      END_STATE();
    case 172:
      if (lookahead == 'n') ADVANCE(108);
      END_STATE();
    case 173:
      if (lookahead == 'o') ADVANCE(168);
      END_STATE();
    case 174:
      if (lookahead == 'o') ADVANCE(141);
      END_STATE();
    case 175:
      if (lookahead == 'o') ADVANCE(214);
      END_STATE();
    case 176:
      if (lookahead == 'o') ADVANCE(182);
      END_STATE();
    case 177:
      if (lookahead == 'o') ADVANCE(208);
      END_STATE();
    case 178:
      if (lookahead == 'o') ADVANCE(201);
      END_STATE();
    case 179:
      if (lookahead == 'o') ADVANCE(153);
      END_STATE();
    case 180:
      if (lookahead == 'p') ADVANCE(309);
      END_STATE();
    case 181:
      if (lookahead == 'p') ADVANCE(197);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(217);
      END_STATE();
    case 183:
      if (lookahead == 'r') ADVANCE(174);
      END_STATE();
    case 184:
      if (lookahead == 'r') ADVANCE(107);
      END_STATE();
    case 185:
      if (lookahead == 'r') ADVANCE(211);
      END_STATE();
    case 186:
      if (lookahead == 'r') ADVANCE(144);
      END_STATE();
    case 187:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 188:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 189:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 190:
      if (lookahead == 'r') ADVANCE(189);
      END_STATE();
    case 191:
      if (lookahead == 's') ADVANCE(154);
      END_STATE();
    case 192:
      if (lookahead == 's') ADVANCE(195);
      END_STATE();
    case 193:
      if (lookahead == 's') ADVANCE(203);
      END_STATE();
    case 194:
      if (lookahead == 's') ADVANCE(125);
      END_STATE();
    case 195:
      if (lookahead == 't') ADVANCE(251);
      END_STATE();
    case 196:
      if (lookahead == 't') ADVANCE(252);
      END_STATE();
    case 197:
      if (lookahead == 't') ADVANCE(378);
      END_STATE();
    case 198:
      if (lookahead == 't') ADVANCE(302);
      END_STATE();
    case 199:
      if (lookahead == 't') ADVANCE(264);
      END_STATE();
    case 200:
      if (lookahead == 't') ADVANCE(393);
      END_STATE();
    case 201:
      if (lookahead == 't') ADVANCE(391);
      END_STATE();
    case 202:
      if (lookahead == 't') ADVANCE(132);
      END_STATE();
    case 203:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 204:
      if (lookahead == 'u') ADVANCE(160);
      END_STATE();
    case 205:
      if (lookahead == 'u') ADVANCE(119);
      END_STATE();
    case 206:
      if (lookahead == 'u') ADVANCE(220);
      if (lookahead == 'x') ADVANCE(228);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(415);
      if (lookahead != 0) ADVANCE(413);
      END_STATE();
    case 207:
      if (lookahead == 'u') ADVANCE(180);
      END_STATE();
    case 208:
      if (lookahead == 'u') ADVANCE(169);
      END_STATE();
    case 209:
      if (lookahead == 'u') ADVANCE(159);
      END_STATE();
    case 210:
      if (lookahead == 'u') ADVANCE(158);
      END_STATE();
    case 211:
      if (lookahead == 'u') ADVANCE(124);
      END_STATE();
    case 212:
      if (lookahead == 'u') ADVANCE(187);
      END_STATE();
    case 213:
      if (lookahead == 'v') ADVANCE(135);
      END_STATE();
    case 214:
      if (lookahead == 'w') ADVANCE(300);
      END_STATE();
    case 215:
      if (lookahead == 'x') ADVANCE(284);
      END_STATE();
    case 216:
      if (lookahead == 'x') ADVANCE(283);
      END_STATE();
    case 217:
      if (lookahead == 'y') ADVANCE(323);
      END_STATE();
    case 218:
      if (lookahead == 'z') ADVANCE(128);
      END_STATE();
    case 219:
      if (lookahead == 'z') ADVANCE(129);
      END_STATE();
    case 220:
      if (lookahead == '{') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(227);
      END_STATE();
    case 221:
      if (lookahead == '}') ADVANCE(413);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(221);
      END_STATE();
    case 222:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(328);
      END_STATE();
    case 223:
      if (('1' <= lookahead && lookahead <= '7')) ADVANCE(327);
      END_STATE();
    case 224:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(326);
      END_STATE();
    case 225:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(413);
      END_STATE();
    case 226:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(221);
      END_STATE();
    case 227:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(228);
      END_STATE();
    case 228:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(225);
      END_STATE();
    case 229:
      if (eof) ADVANCE(231);
      if (lookahead == '!') ADVANCE(99);
      if (lookahead == '"') ADVANCE(399);
      if (lookahead == '#') ADVANCE(110);
      if (lookahead == '$') ADVANCE(254);
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == '(') ADVANCE(281);
      if (lookahead == ')') ADVANCE(297);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(266);
      if (lookahead == '/') ADVANCE(305);
      if (lookahead == '0') ADVANCE(324);
      if (lookahead == ':') ADVANCE(248);
      if (lookahead == ';') ADVANCE(298);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == '>') ADVANCE(273);
      if (lookahead == '?') ADVANCE(294);
      if (lookahead == '@') ADVANCE(245);
      if (lookahead == '[') ADVANCE(279);
      if (lookahead == '\\') ADVANCE(290);
      if (lookahead == ']') ADVANCE(296);
      if (lookahead == '^') ADVANCE(314);
      if (lookahead == '_') ADVANCE(329);
      if (lookahead == 'a') ADVANCE(355);
      if (lookahead == 'b') ADVANCE(353);
      if (lookahead == 'd') ADVANCE(338);
      if (lookahead == 'h') ADVANCE(339);
      if (lookahead == 'l') ADVANCE(343);
      if (lookahead == 'n') ADVANCE(358);
      if (lookahead == 'o') ADVANCE(370);
      if (lookahead == 'r') ADVANCE(350);
      if (lookahead == 'u') ADVANCE(356);
      if (lookahead == '{') ADVANCE(278);
      if (lookahead == '|') ADVANCE(312);
      if (lookahead == '}') ADVANCE(295);
      if (lookahead == '~') ADVANCE(246);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(229)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('c' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(388);
      END_STATE();
    case 230:
      if (eof) ADVANCE(231);
      if (lookahead == '!') ADVANCE(99);
      if (lookahead == '"') ADVANCE(399);
      if (lookahead == '#') ADVANCE(110);
      if (lookahead == '$') ADVANCE(253);
      if (lookahead == '%') ADVANCE(241);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == '(') ADVANCE(281);
      if (lookahead == ')') ADVANCE(297);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(266);
      if (lookahead == '/') ADVANCE(305);
      if (lookahead == '0') ADVANCE(324);
      if (lookahead == ':') ADVANCE(98);
      if (lookahead == ';') ADVANCE(298);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == '>') ADVANCE(273);
      if (lookahead == '?') ADVANCE(294);
      if (lookahead == '@') ADVANCE(245);
      if (lookahead == '[') ADVANCE(279);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == ']') ADVANCE(296);
      if (lookahead == '^') ADVANCE(314);
      if (lookahead == '_') ADVANCE(329);
      if (lookahead == 'n') ADVANCE(358);
      if (lookahead == '{') ADVANCE(278);
      if (lookahead == '|') ADVANCE(312);
      if (lookahead == '}') ADVANCE(295);
      if (lookahead == '~') ADVANCE(246);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(230)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(388);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(37);
      if (lookahead == ' ') ADVANCE(233);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(40);
      if (lookahead == ' ') ADVANCE(234);
      if (lookahead == '#') ADVANCE(16);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == ' ') ADVANCE(235);
      if (lookahead == '#') ADVANCE(21);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == ' ') ADVANCE(236);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(25);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '*') ADVANCE(39);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(58);
      if (lookahead != 0) ADVANCE(40);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(74);
      if (lookahead != 0) ADVANCE(43);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead != 0) ADVANCE(25);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_ADD);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_AND);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_EQ);
      if (lookahead == '=') ADVANCE(398);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_AT);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_BNOT);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_COLON);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_COLON);
      if (lookahead == '-') ADVANCE(274);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_COLON);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(390);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_COMMA);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_CONST);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_COUNT);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_CSP);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_CSP);
      if (lookahead == '!') ADVANCE(100);
      if (lookahead == '*') ADVANCE(257);
      if (lookahead == '+') ADVANCE(255);
      if (lookahead == '<') ADVANCE(259);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == '>') ADVANCE(260);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_CSP_ADD);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_CSP_SUB);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_CSP_MUL);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_CSP_LEQ);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_CSP_LT);
      if (lookahead == '=') ADVANCE(258);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_CSP_GT);
      if (lookahead == '=') ADVANCE(261);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_CSP_GEQ);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_CSP_EQ);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_CSP_NEQ);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_DISJOINT);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_DOT);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_DOT);
      if (lookahead == '.') ADVANCE(268);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_DOT);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(390);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_DOTS);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_EXTERNAL);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_DEFINED);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_FALSE);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_GEQ);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_GT);
      if (lookahead == '=') ADVANCE(272);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_IF);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_IF);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(390);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_INCLUDE);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_INFIMUM);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_LBRACE);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_LBRACK);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_LEQ);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_LPAREN);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_LT);
      if (lookahead == '=') ADVANCE(280);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_MAX);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_MAX);
      if (lookahead == 'i') ADVANCE(162);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_MAXIMIZE);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_MIN);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_MIN);
      if (lookahead == 'i') ADVANCE(163);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_MINIMIZE);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_MOD);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_MOD);
      if (lookahead == '\\') ADVANCE(397);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_MUL);
      if (lookahead == '*') ADVANCE(293);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_NEQ);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_POW);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_QUESTION);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_RBRACE);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_RBRACK);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_RPAREN);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_SEM);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_SEM);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(390);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_SHOW);
      if (lookahead == 's') ADVANCE(146);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_EDGE);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_PROJECT);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_HEURISTIC);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_SHOWSIG);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_SLASH);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_SUB);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_SUM);
      if (lookahead == '+') ADVANCE(308);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_SUMP);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_SUPREMUM);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_TRUE);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_BLOCK);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_VBAR);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_WIF);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_XOR);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_ANY);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_UNARY);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_BINARY);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_LEFT);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_RIGHT);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_HEAD);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_BODY);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_DIRECTIVE);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_THEORY);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == 'b') ADVANCE(222);
      if (lookahead == 'o') ADVANCE(223);
      if (lookahead == 'x') ADVANCE(224);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(aux_sym_dec_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_hex);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(326);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_oct);
      if (('1' <= lookahead && lookahead <= '7')) ADVANCE(327);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_bin);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(328);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_ANONYMOUS);
      if (lookahead == '_') ADVANCE(102);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(388);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(369);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(335);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(360);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(362);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(368);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(320);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(346);
      if (lookahead == 'i') ADVANCE(361);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(334);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(396);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(322);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(330);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'g') ADVANCE(348);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(366);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(361);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(347);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(371);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(357);
      if (lookahead == 'o') ADVANCE(336);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(367);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(332);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(333);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(364);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(351);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(340);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(375);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(392);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(318);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(319);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(394);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(352);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(354);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(344);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(342);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(315);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(321);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(316);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(317);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_SCRIPT);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '\n') ADVANCE(37);
      if (lookahead == ' ') ADVANCE(233);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '\n') ADVANCE(40);
      if (lookahead == ' ') ADVANCE(234);
      if (lookahead == '#') ADVANCE(16);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '\n') ADVANCE(43);
      if (lookahead == ' ') ADVANCE(235);
      if (lookahead == '#') ADVANCE(21);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(57);
      if (lookahead == '*') ADVANCE(38);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(58);
      if (lookahead != 0) ADVANCE(40);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(59);
      if (lookahead == '*') ADVANCE(41);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(74);
      if (lookahead != 0) ADVANCE(43);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_CODE);
      if (lookahead == '#') ADVANCE(75);
      if (lookahead == '*') ADVANCE(44);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_VARIABLE);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(388);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_THEORY_OP);
      if (lookahead == '-') ADVANCE(275);
      if (sym_THEORY_OP_character_set_3(lookahead)) ADVANCE(390);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_THEORY_OP);
      if (sym_THEORY_OP_character_set_2(lookahead)) ADVANCE(390);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_NOT);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_NOT);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_DEFAULT);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_DEFAULT);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_OVERRIDE);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_OVERRIDE);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(376);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_BSLASH_BSLASH);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(406);
      if (lookahead == ' ') ADVANCE(401);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(401);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '%') ADVANCE(405);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(402);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(406);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '%') ADVANCE(406);
      if (lookahead == '*') ADVANCE(403);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(404);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(403);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(404);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(404);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(401);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(406);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '\n') ADVANCE(412);
      if (lookahead == ' ') ADVANCE(407);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(407);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '%') ADVANCE(411);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(408);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(412);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '%') ADVANCE(412);
      if (lookahead == '*') ADVANCE(409);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(410);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(409);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(410);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(410);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(407);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(412);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(413);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(414);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 230},
  [2] = {.lex_state = 230},
  [3] = {.lex_state = 230},
  [4] = {.lex_state = 230},
  [5] = {.lex_state = 230},
  [6] = {.lex_state = 230},
  [7] = {.lex_state = 230},
  [8] = {.lex_state = 230},
  [9] = {.lex_state = 230},
  [10] = {.lex_state = 230},
  [11] = {.lex_state = 230},
  [12] = {.lex_state = 230},
  [13] = {.lex_state = 230},
  [14] = {.lex_state = 230},
  [15] = {.lex_state = 230},
  [16] = {.lex_state = 230},
  [17] = {.lex_state = 230},
  [18] = {.lex_state = 230},
  [19] = {.lex_state = 230},
  [20] = {.lex_state = 230},
  [21] = {.lex_state = 230},
  [22] = {.lex_state = 230},
  [23] = {.lex_state = 230},
  [24] = {.lex_state = 230},
  [25] = {.lex_state = 230},
  [26] = {.lex_state = 230},
  [27] = {.lex_state = 230},
  [28] = {.lex_state = 230},
  [29] = {.lex_state = 28},
  [30] = {.lex_state = 28},
  [31] = {.lex_state = 26},
  [32] = {.lex_state = 26},
  [33] = {.lex_state = 26},
  [34] = {.lex_state = 26},
  [35] = {.lex_state = 28},
  [36] = {.lex_state = 28},
  [37] = {.lex_state = 28},
  [38] = {.lex_state = 28},
  [39] = {.lex_state = 28},
  [40] = {.lex_state = 28},
  [41] = {.lex_state = 28},
  [42] = {.lex_state = 28},
  [43] = {.lex_state = 28},
  [44] = {.lex_state = 28},
  [45] = {.lex_state = 28},
  [46] = {.lex_state = 28},
  [47] = {.lex_state = 29},
  [48] = {.lex_state = 29},
  [49] = {.lex_state = 29},
  [50] = {.lex_state = 29},
  [51] = {.lex_state = 230},
  [52] = {.lex_state = 230},
  [53] = {.lex_state = 28},
  [54] = {.lex_state = 28},
  [55] = {.lex_state = 28},
  [56] = {.lex_state = 26},
  [57] = {.lex_state = 28},
  [58] = {.lex_state = 26},
  [59] = {.lex_state = 28},
  [60] = {.lex_state = 230},
  [61] = {.lex_state = 230},
  [62] = {.lex_state = 28},
  [63] = {.lex_state = 230},
  [64] = {.lex_state = 26},
  [65] = {.lex_state = 230},
  [66] = {.lex_state = 26},
  [67] = {.lex_state = 26},
  [68] = {.lex_state = 230},
  [69] = {.lex_state = 230},
  [70] = {.lex_state = 230},
  [71] = {.lex_state = 230},
  [72] = {.lex_state = 230},
  [73] = {.lex_state = 27},
  [74] = {.lex_state = 27},
  [75] = {.lex_state = 27},
  [76] = {.lex_state = 230},
  [77] = {.lex_state = 230},
  [78] = {.lex_state = 230},
  [79] = {.lex_state = 230},
  [80] = {.lex_state = 230},
  [81] = {.lex_state = 230},
  [82] = {.lex_state = 230},
  [83] = {.lex_state = 230},
  [84] = {.lex_state = 230},
  [85] = {.lex_state = 230},
  [86] = {.lex_state = 26},
  [87] = {.lex_state = 26},
  [88] = {.lex_state = 26},
  [89] = {.lex_state = 26},
  [90] = {.lex_state = 26},
  [91] = {.lex_state = 230},
  [92] = {.lex_state = 26},
  [93] = {.lex_state = 230},
  [94] = {.lex_state = 230},
  [95] = {.lex_state = 230},
  [96] = {.lex_state = 34},
  [97] = {.lex_state = 34},
  [98] = {.lex_state = 26},
  [99] = {.lex_state = 26},
  [100] = {.lex_state = 28},
  [101] = {.lex_state = 26},
  [102] = {.lex_state = 26},
  [103] = {.lex_state = 28},
  [104] = {.lex_state = 230},
  [105] = {.lex_state = 230},
  [106] = {.lex_state = 26},
  [107] = {.lex_state = 26},
  [108] = {.lex_state = 27},
  [109] = {.lex_state = 230},
  [110] = {.lex_state = 29},
  [111] = {.lex_state = 29},
  [112] = {.lex_state = 230},
  [113] = {.lex_state = 26},
  [114] = {.lex_state = 34},
  [115] = {.lex_state = 230},
  [116] = {.lex_state = 26},
  [117] = {.lex_state = 26},
  [118] = {.lex_state = 27},
  [119] = {.lex_state = 26},
  [120] = {.lex_state = 230},
  [121] = {.lex_state = 27},
  [122] = {.lex_state = 29},
  [123] = {.lex_state = 27},
  [124] = {.lex_state = 26},
  [125] = {.lex_state = 29},
  [126] = {.lex_state = 33},
  [127] = {.lex_state = 26},
  [128] = {.lex_state = 29},
  [129] = {.lex_state = 33},
  [130] = {.lex_state = 27},
  [131] = {.lex_state = 27},
  [132] = {.lex_state = 33},
  [133] = {.lex_state = 26},
  [134] = {.lex_state = 33},
  [135] = {.lex_state = 33},
  [136] = {.lex_state = 33},
  [137] = {.lex_state = 33},
  [138] = {.lex_state = 29},
  [139] = {.lex_state = 29},
  [140] = {.lex_state = 26},
  [141] = {.lex_state = 33},
  [142] = {.lex_state = 27},
  [143] = {.lex_state = 29},
  [144] = {.lex_state = 29},
  [145] = {.lex_state = 29},
  [146] = {.lex_state = 29},
  [147] = {.lex_state = 29},
  [148] = {.lex_state = 29},
  [149] = {.lex_state = 33},
  [150] = {.lex_state = 29},
  [151] = {.lex_state = 29},
  [152] = {.lex_state = 33},
  [153] = {.lex_state = 26},
  [154] = {.lex_state = 29},
  [155] = {.lex_state = 27},
  [156] = {.lex_state = 29},
  [157] = {.lex_state = 26},
  [158] = {.lex_state = 33},
  [159] = {.lex_state = 26},
  [160] = {.lex_state = 26},
  [161] = {.lex_state = 27},
  [162] = {.lex_state = 27},
  [163] = {.lex_state = 29},
  [164] = {.lex_state = 26},
  [165] = {.lex_state = 29},
  [166] = {.lex_state = 26},
  [167] = {.lex_state = 26},
  [168] = {.lex_state = 33},
  [169] = {.lex_state = 33},
  [170] = {.lex_state = 29},
  [171] = {.lex_state = 33},
  [172] = {.lex_state = 33},
  [173] = {.lex_state = 26},
  [174] = {.lex_state = 26},
  [175] = {.lex_state = 33},
  [176] = {.lex_state = 27},
  [177] = {.lex_state = 28},
  [178] = {.lex_state = 33},
  [179] = {.lex_state = 26},
  [180] = {.lex_state = 27},
  [181] = {.lex_state = 28},
  [182] = {.lex_state = 27},
  [183] = {.lex_state = 33},
  [184] = {.lex_state = 27},
  [185] = {.lex_state = 26},
  [186] = {.lex_state = 26},
  [187] = {.lex_state = 26},
  [188] = {.lex_state = 33},
  [189] = {.lex_state = 33},
  [190] = {.lex_state = 26},
  [191] = {.lex_state = 26},
  [192] = {.lex_state = 26},
  [193] = {.lex_state = 29},
  [194] = {.lex_state = 26},
  [195] = {.lex_state = 26},
  [196] = {.lex_state = 33},
  [197] = {.lex_state = 26},
  [198] = {.lex_state = 26},
  [199] = {.lex_state = 33},
  [200] = {.lex_state = 33},
  [201] = {.lex_state = 26},
  [202] = {.lex_state = 26},
  [203] = {.lex_state = 28},
  [204] = {.lex_state = 33},
  [205] = {.lex_state = 26},
  [206] = {.lex_state = 26},
  [207] = {.lex_state = 26},
  [208] = {.lex_state = 33},
  [209] = {.lex_state = 26},
  [210] = {.lex_state = 28},
  [211] = {.lex_state = 26},
  [212] = {.lex_state = 33},
  [213] = {.lex_state = 26},
  [214] = {.lex_state = 26},
  [215] = {.lex_state = 26},
  [216] = {.lex_state = 26},
  [217] = {.lex_state = 26},
  [218] = {.lex_state = 26},
  [219] = {.lex_state = 26},
  [220] = {.lex_state = 26},
  [221] = {.lex_state = 26},
  [222] = {.lex_state = 26},
  [223] = {.lex_state = 26},
  [224] = {.lex_state = 26},
  [225] = {.lex_state = 26},
  [226] = {.lex_state = 26},
  [227] = {.lex_state = 26},
  [228] = {.lex_state = 26},
  [229] = {.lex_state = 26},
  [230] = {.lex_state = 26},
  [231] = {.lex_state = 26},
  [232] = {.lex_state = 26},
  [233] = {.lex_state = 26},
  [234] = {.lex_state = 26},
  [235] = {.lex_state = 26},
  [236] = {.lex_state = 26},
  [237] = {.lex_state = 26},
  [238] = {.lex_state = 26},
  [239] = {.lex_state = 26},
  [240] = {.lex_state = 26},
  [241] = {.lex_state = 26},
  [242] = {.lex_state = 26},
  [243] = {.lex_state = 26},
  [244] = {.lex_state = 26},
  [245] = {.lex_state = 26},
  [246] = {.lex_state = 26},
  [247] = {.lex_state = 26},
  [248] = {.lex_state = 26},
  [249] = {.lex_state = 26},
  [250] = {.lex_state = 26},
  [251] = {.lex_state = 26},
  [252] = {.lex_state = 26},
  [253] = {.lex_state = 26},
  [254] = {.lex_state = 26},
  [255] = {.lex_state = 26},
  [256] = {.lex_state = 26},
  [257] = {.lex_state = 26},
  [258] = {.lex_state = 33},
  [259] = {.lex_state = 33},
  [260] = {.lex_state = 33},
  [261] = {.lex_state = 230},
  [262] = {.lex_state = 33},
  [263] = {.lex_state = 33},
  [264] = {.lex_state = 230},
  [265] = {.lex_state = 33},
  [266] = {.lex_state = 230},
  [267] = {.lex_state = 230},
  [268] = {.lex_state = 33},
  [269] = {.lex_state = 230},
  [270] = {.lex_state = 33},
  [271] = {.lex_state = 26},
  [272] = {.lex_state = 26},
  [273] = {.lex_state = 26},
  [274] = {.lex_state = 26},
  [275] = {.lex_state = 26},
  [276] = {.lex_state = 26},
  [277] = {.lex_state = 26},
  [278] = {.lex_state = 26},
  [279] = {.lex_state = 26},
  [280] = {.lex_state = 26},
  [281] = {.lex_state = 26},
  [282] = {.lex_state = 26},
  [283] = {.lex_state = 26},
  [284] = {.lex_state = 26},
  [285] = {.lex_state = 27},
  [286] = {.lex_state = 230},
  [287] = {.lex_state = 230},
  [288] = {.lex_state = 230},
  [289] = {.lex_state = 26},
  [290] = {.lex_state = 33},
  [291] = {.lex_state = 230},
  [292] = {.lex_state = 29},
  [293] = {.lex_state = 33},
  [294] = {.lex_state = 29},
  [295] = {.lex_state = 29},
  [296] = {.lex_state = 28},
  [297] = {.lex_state = 28},
  [298] = {.lex_state = 28},
  [299] = {.lex_state = 33},
  [300] = {.lex_state = 28},
  [301] = {.lex_state = 29},
  [302] = {.lex_state = 28},
  [303] = {.lex_state = 28},
  [304] = {.lex_state = 28},
  [305] = {.lex_state = 29},
  [306] = {.lex_state = 28},
  [307] = {.lex_state = 29},
  [308] = {.lex_state = 88},
  [309] = {.lex_state = 88},
  [310] = {.lex_state = 28},
  [311] = {.lex_state = 27},
  [312] = {.lex_state = 27},
  [313] = {.lex_state = 27},
  [314] = {.lex_state = 27},
  [315] = {.lex_state = 29},
  [316] = {.lex_state = 28},
  [317] = {.lex_state = 230},
  [318] = {.lex_state = 28},
  [319] = {.lex_state = 27},
  [320] = {.lex_state = 28},
  [321] = {.lex_state = 27},
  [322] = {.lex_state = 27},
  [323] = {.lex_state = 230},
  [324] = {.lex_state = 27},
  [325] = {.lex_state = 27},
  [326] = {.lex_state = 27},
  [327] = {.lex_state = 27},
  [328] = {.lex_state = 230},
  [329] = {.lex_state = 230},
  [330] = {.lex_state = 28},
  [331] = {.lex_state = 230},
  [332] = {.lex_state = 28},
  [333] = {.lex_state = 230},
  [334] = {.lex_state = 230},
  [335] = {.lex_state = 28},
  [336] = {.lex_state = 230},
  [337] = {.lex_state = 28},
  [338] = {.lex_state = 230},
  [339] = {.lex_state = 230},
  [340] = {.lex_state = 27},
  [341] = {.lex_state = 27},
  [342] = {.lex_state = 230},
  [343] = {.lex_state = 28},
  [344] = {.lex_state = 230},
  [345] = {.lex_state = 230},
  [346] = {.lex_state = 230},
  [347] = {.lex_state = 230},
  [348] = {.lex_state = 230},
  [349] = {.lex_state = 27},
  [350] = {.lex_state = 28},
  [351] = {.lex_state = 28},
  [352] = {.lex_state = 28},
  [353] = {.lex_state = 28},
  [354] = {.lex_state = 27},
  [355] = {.lex_state = 28},
  [356] = {.lex_state = 28},
  [357] = {.lex_state = 28},
  [358] = {.lex_state = 90},
  [359] = {.lex_state = 90},
  [360] = {.lex_state = 92},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 92},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 91},
  [366] = {.lex_state = 92},
  [367] = {.lex_state = 91},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 90},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 92},
  [378] = {.lex_state = 90},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 28},
  [381] = {.lex_state = 92},
  [382] = {.lex_state = 90},
  [383] = {.lex_state = 92},
  [384] = {.lex_state = 28},
  [385] = {.lex_state = 92},
  [386] = {.lex_state = 90},
  [387] = {.lex_state = 28},
  [388] = {.lex_state = 90},
  [389] = {.lex_state = 92},
  [390] = {.lex_state = 28},
  [391] = {.lex_state = 28},
  [392] = {.lex_state = 91},
  [393] = {.lex_state = 92},
  [394] = {.lex_state = 91},
  [395] = {.lex_state = 29},
  [396] = {.lex_state = 90},
  [397] = {.lex_state = 92},
  [398] = {.lex_state = 92},
  [399] = {.lex_state = 90},
  [400] = {.lex_state = 90},
  [401] = {.lex_state = 28},
  [402] = {.lex_state = 90},
  [403] = {.lex_state = 90},
  [404] = {.lex_state = 93},
  [405] = {.lex_state = 90},
  [406] = {.lex_state = 90},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 90},
  [409] = {.lex_state = 92},
  [410] = {.lex_state = 90},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 90},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 28},
  [416] = {.lex_state = 28},
  [417] = {.lex_state = 92},
  [418] = {.lex_state = 92},
  [419] = {.lex_state = 90},
  [420] = {.lex_state = 93},
  [421] = {.lex_state = 90},
  [422] = {.lex_state = 92},
  [423] = {.lex_state = 90},
  [424] = {.lex_state = 91},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 93},
  [427] = {.lex_state = 91},
  [428] = {.lex_state = 91},
  [429] = {.lex_state = 91},
  [430] = {.lex_state = 28},
  [431] = {.lex_state = 91},
  [432] = {.lex_state = 91},
  [433] = {.lex_state = 91},
  [434] = {.lex_state = 91},
  [435] = {.lex_state = 91},
  [436] = {.lex_state = 90},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 91},
  [440] = {.lex_state = 91},
  [441] = {.lex_state = 28},
  [442] = {.lex_state = 93},
  [443] = {.lex_state = 93},
  [444] = {.lex_state = 91},
  [445] = {.lex_state = 28},
  [446] = {.lex_state = 28},
  [447] = {.lex_state = 28},
  [448] = {.lex_state = 28},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 91},
  [451] = {.lex_state = 28},
  [452] = {.lex_state = 28},
  [453] = {.lex_state = 35},
  [454] = {.lex_state = 28},
  [455] = {.lex_state = 28},
  [456] = {.lex_state = 35},
  [457] = {.lex_state = 95},
  [458] = {.lex_state = 28},
  [459] = {.lex_state = 95},
  [460] = {.lex_state = 28},
  [461] = {.lex_state = 35},
  [462] = {.lex_state = 28},
  [463] = {.lex_state = 35},
  [464] = {.lex_state = 35},
  [465] = {.lex_state = 26},
  [466] = {.lex_state = 95},
  [467] = {.lex_state = 95},
  [468] = {.lex_state = 28},
  [469] = {.lex_state = 35},
  [470] = {.lex_state = 93},
  [471] = {.lex_state = 95},
  [472] = {.lex_state = 93},
  [473] = {.lex_state = 93},
  [474] = {.lex_state = 93},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 93},
  [477] = {.lex_state = 90},
  [478] = {.lex_state = 28},
  [479] = {.lex_state = 93},
  [480] = {.lex_state = 95},
  [481] = {.lex_state = 93},
  [482] = {.lex_state = 93},
  [483] = {.lex_state = 93},
  [484] = {.lex_state = 26},
  [485] = {.lex_state = 95},
  [486] = {.lex_state = 35},
  [487] = {.lex_state = 93},
  [488] = {.lex_state = 93},
  [489] = {.lex_state = 93},
  [490] = {.lex_state = 95},
  [491] = {.lex_state = 95},
  [492] = {.lex_state = 28},
  [493] = {.lex_state = 28},
  [494] = {.lex_state = 26},
  [495] = {.lex_state = 35},
  [496] = {.lex_state = 28},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 35},
  [499] = {.lex_state = 28},
  [500] = {.lex_state = 28},
  [501] = {.lex_state = 28},
  [502] = {.lex_state = 35},
  [503] = {.lex_state = 95},
  [504] = {.lex_state = 95},
  [505] = {.lex_state = 28},
  [506] = {.lex_state = 35},
  [507] = {.lex_state = 28},
  [508] = {.lex_state = 35},
  [509] = {.lex_state = 95},
  [510] = {.lex_state = 35},
  [511] = {.lex_state = 95},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 26},
  [515] = {.lex_state = 26},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 28},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 27},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 28},
  [523] = {.lex_state = 28},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 28},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 26},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 28},
  [540] = {.lex_state = 90},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 0},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 26},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 28},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 26},
  [582] = {.lex_state = 28},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 29},
  [587] = {.lex_state = 28},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 28},
  [605] = {.lex_state = 28},
  [606] = {.lex_state = 26},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 26},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 26},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 230},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 28},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 26},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 26},
  [666] = {.lex_state = 230},
  [667] = {.lex_state = 26},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 26},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 36},
  [680] = {.lex_state = 230},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 230},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 26},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 230},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 26},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 28},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 28},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 26},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 28},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 26},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_ADD] = ACTIONS(1),
    [sym_AND] = ACTIONS(1),
    [sym_EQ] = ACTIONS(1),
    [sym_AT] = ACTIONS(1),
    [sym_BNOT] = ACTIONS(1),
    [sym_COLON] = ACTIONS(1),
    [sym_COMMA] = ACTIONS(1),
    [sym_CONST] = ACTIONS(1),
    [sym_COUNT] = ACTIONS(1),
    [sym_CSP] = ACTIONS(1),
    [sym_CSP_ADD] = ACTIONS(1),
    [sym_CSP_MUL] = ACTIONS(1),
    [sym_CSP_LEQ] = ACTIONS(1),
    [sym_CSP_LT] = ACTIONS(1),
    [sym_CSP_GT] = ACTIONS(1),
    [sym_CSP_GEQ] = ACTIONS(1),
    [sym_CSP_EQ] = ACTIONS(1),
    [sym_CSP_NEQ] = ACTIONS(1),
    [sym_DISJOINT] = ACTIONS(1),
    [sym_DOT] = ACTIONS(1),
    [sym_DOTS] = ACTIONS(1),
    [sym_EXTERNAL] = ACTIONS(1),
    [sym_DEFINED] = ACTIONS(1),
    [sym_FALSE] = ACTIONS(1),
    [sym_GEQ] = ACTIONS(1),
    [sym_GT] = ACTIONS(1),
    [sym_IF] = ACTIONS(1),
    [sym_INCLUDE] = ACTIONS(1),
    [sym_INFIMUM] = ACTIONS(1),
    [sym_LBRACE] = ACTIONS(1),
    [sym_LBRACK] = ACTIONS(1),
    [sym_LEQ] = ACTIONS(1),
    [sym_LPAREN] = ACTIONS(1),
    [sym_LT] = ACTIONS(1),
    [sym_MAX] = ACTIONS(1),
    [sym_MAXIMIZE] = ACTIONS(1),
    [sym_MIN] = ACTIONS(1),
    [sym_MINIMIZE] = ACTIONS(1),
    [sym_MOD] = ACTIONS(1),
    [sym_MUL] = ACTIONS(1),
    [sym_NEQ] = ACTIONS(1),
    [sym_POW] = ACTIONS(1),
    [sym_QUESTION] = ACTIONS(1),
    [sym_RBRACE] = ACTIONS(1),
    [sym_RBRACK] = ACTIONS(1),
    [sym_RPAREN] = ACTIONS(1),
    [sym_SEM] = ACTIONS(1),
    [sym_SHOW] = ACTIONS(1),
    [sym_EDGE] = ACTIONS(1),
    [sym_PROJECT] = ACTIONS(1),
    [sym_HEURISTIC] = ACTIONS(1),
    [sym_SHOWSIG] = ACTIONS(1),
    [sym_SLASH] = ACTIONS(1),
    [sym_SUB] = ACTIONS(1),
    [sym_SUM] = ACTIONS(1),
    [sym_SUMP] = ACTIONS(1),
    [sym_SUPREMUM] = ACTIONS(1),
    [sym_TRUE] = ACTIONS(1),
    [sym_BLOCK] = ACTIONS(1),
    [sym_VBAR] = ACTIONS(1),
    [sym_XOR] = ACTIONS(1),
    [sym_ANY] = ACTIONS(1),
    [sym_UNARY] = ACTIONS(1),
    [sym_BINARY] = ACTIONS(1),
    [sym_LEFT] = ACTIONS(1),
    [sym_RIGHT] = ACTIONS(1),
    [sym_HEAD] = ACTIONS(1),
    [sym_BODY] = ACTIONS(1),
    [sym_DIRECTIVE] = ACTIONS(1),
    [sym_THEORY] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [aux_sym_dec_token1] = ACTIONS(1),
    [sym_hex] = ACTIONS(1),
    [sym_oct] = ACTIONS(1),
    [sym_bin] = ACTIONS(1),
    [sym_ANONYMOUS] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [sym_SCRIPT] = ACTIONS(1),
    [sym_VARIABLE] = ACTIONS(1),
    [sym_NOT] = ACTIONS(1),
    [sym_DEFAULT] = ACTIONS(1),
    [sym_OVERRIDE] = ACTIONS(1),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(713),
    [sym_NUMBER] = STATE(44),
    [sym_dec] = STATE(32),
    [sym__widentifier] = STATE(174),
    [sym_term] = STATE(59),
    [sym_atom] = STATE(370),
    [sym_literal] = STATE(364),
    [sym_csp_mul_term] = STATE(301),
    [sym_csp_add_term] = STATE(356),
    [sym_csp_literal] = STATE(315),
    [sym_aggregatefunction] = STATE(669),
    [sym_headaggregate] = STATE(73),
    [sym_luheadaggregate] = STATE(640),
    [sym_disjoint] = STATE(639),
    [sym_disjunctionsep] = STATE(78),
    [sym_disjunction] = STATE(640),
    [sym_head] = STATE(639),
    [sym_statement] = STATE(2),
    [sym_theory_atom] = STATE(636),
    [sym_STRING] = STATE(44),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(7),
    [sym_AT] = ACTIONS(9),
    [sym_BNOT] = ACTIONS(11),
    [sym_CONST] = ACTIONS(13),
    [sym_COUNT] = ACTIONS(15),
    [sym_CSP] = ACTIONS(17),
    [sym_DISJOINT] = ACTIONS(19),
    [sym_EXTERNAL] = ACTIONS(21),
    [sym_DEFINED] = ACTIONS(23),
    [sym_FALSE] = ACTIONS(25),
    [sym_IF] = ACTIONS(27),
    [sym_INCLUDE] = ACTIONS(29),
    [sym_INFIMUM] = ACTIONS(31),
    [sym_LBRACE] = ACTIONS(33),
    [sym_LPAREN] = ACTIONS(35),
    [sym_MAX] = ACTIONS(37),
    [sym_MAXIMIZE] = ACTIONS(39),
    [sym_MIN] = ACTIONS(37),
    [sym_MINIMIZE] = ACTIONS(41),
    [sym_SHOW] = ACTIONS(43),
    [sym_EDGE] = ACTIONS(45),
    [sym_PROJECT] = ACTIONS(47),
    [sym_HEURISTIC] = ACTIONS(49),
    [sym_SHOWSIG] = ACTIONS(51),
    [sym_SUB] = ACTIONS(53),
    [sym_SUM] = ACTIONS(37),
    [sym_SUMP] = ACTIONS(15),
    [sym_SUPREMUM] = ACTIONS(31),
    [sym_TRUE] = ACTIONS(25),
    [sym_BLOCK] = ACTIONS(55),
    [sym_VBAR] = ACTIONS(57),
    [sym_WIF] = ACTIONS(59),
    [sym_THEORY] = ACTIONS(61),
    [anon_sym_0] = ACTIONS(63),
    [aux_sym_dec_token1] = ACTIONS(65),
    [sym_hex] = ACTIONS(67),
    [sym_oct] = ACTIONS(67),
    [sym_bin] = ACTIONS(67),
    [sym_ANONYMOUS] = ACTIONS(69),
    [sym_identifier] = ACTIONS(71),
    [sym_SCRIPT] = ACTIONS(73),
    [sym_VARIABLE] = ACTIONS(31),
    [sym_NOT] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
  },
  [2] = {
    [sym_NUMBER] = STATE(44),
    [sym_dec] = STATE(32),
    [sym__widentifier] = STATE(174),
    [sym_term] = STATE(59),
    [sym_atom] = STATE(370),
    [sym_literal] = STATE(364),
    [sym_csp_mul_term] = STATE(301),
    [sym_csp_add_term] = STATE(356),
    [sym_csp_literal] = STATE(315),
    [sym_aggregatefunction] = STATE(669),
    [sym_headaggregate] = STATE(73),
    [sym_luheadaggregate] = STATE(640),
    [sym_disjoint] = STATE(639),
    [sym_disjunctionsep] = STATE(78),
    [sym_disjunction] = STATE(640),
    [sym_head] = STATE(639),
    [sym_statement] = STATE(3),
    [sym_theory_atom] = STATE(636),
    [sym_STRING] = STATE(44),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(7),
    [sym_AT] = ACTIONS(9),
    [sym_BNOT] = ACTIONS(11),
    [sym_CONST] = ACTIONS(13),
    [sym_COUNT] = ACTIONS(15),
    [sym_CSP] = ACTIONS(17),
    [sym_DISJOINT] = ACTIONS(19),
    [sym_EXTERNAL] = ACTIONS(21),
    [sym_DEFINED] = ACTIONS(23),
    [sym_FALSE] = ACTIONS(25),
    [sym_IF] = ACTIONS(27),
    [sym_INCLUDE] = ACTIONS(29),
    [sym_INFIMUM] = ACTIONS(31),
    [sym_LBRACE] = ACTIONS(33),
    [sym_LPAREN] = ACTIONS(35),
    [sym_MAX] = ACTIONS(37),
    [sym_MAXIMIZE] = ACTIONS(39),
    [sym_MIN] = ACTIONS(37),
    [sym_MINIMIZE] = ACTIONS(41),
    [sym_SHOW] = ACTIONS(43),
    [sym_EDGE] = ACTIONS(45),
    [sym_PROJECT] = ACTIONS(47),
    [sym_HEURISTIC] = ACTIONS(49),
    [sym_SHOWSIG] = ACTIONS(51),
    [sym_SUB] = ACTIONS(53),
    [sym_SUM] = ACTIONS(37),
    [sym_SUMP] = ACTIONS(15),
    [sym_SUPREMUM] = ACTIONS(31),
    [sym_TRUE] = ACTIONS(25),
    [sym_BLOCK] = ACTIONS(55),
    [sym_VBAR] = ACTIONS(57),
    [sym_WIF] = ACTIONS(59),
    [sym_THEORY] = ACTIONS(61),
    [anon_sym_0] = ACTIONS(63),
    [aux_sym_dec_token1] = ACTIONS(65),
    [sym_hex] = ACTIONS(67),
    [sym_oct] = ACTIONS(67),
    [sym_bin] = ACTIONS(67),
    [sym_ANONYMOUS] = ACTIONS(69),
    [sym_identifier] = ACTIONS(71),
    [sym_SCRIPT] = ACTIONS(73),
    [sym_VARIABLE] = ACTIONS(31),
    [sym_NOT] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
  },
  [3] = {
    [sym_NUMBER] = STATE(44),
    [sym_dec] = STATE(32),
    [sym__widentifier] = STATE(174),
    [sym_term] = STATE(59),
    [sym_atom] = STATE(370),
    [sym_literal] = STATE(364),
    [sym_csp_mul_term] = STATE(301),
    [sym_csp_add_term] = STATE(356),
    [sym_csp_literal] = STATE(315),
    [sym_aggregatefunction] = STATE(669),
    [sym_headaggregate] = STATE(73),
    [sym_luheadaggregate] = STATE(640),
    [sym_disjoint] = STATE(639),
    [sym_disjunctionsep] = STATE(78),
    [sym_disjunction] = STATE(640),
    [sym_head] = STATE(639),
    [sym_statement] = STATE(3),
    [sym_theory_atom] = STATE(636),
    [sym_STRING] = STATE(44),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [sym_AND] = ACTIONS(85),
    [sym_AT] = ACTIONS(88),
    [sym_BNOT] = ACTIONS(91),
    [sym_CONST] = ACTIONS(94),
    [sym_COUNT] = ACTIONS(97),
    [sym_CSP] = ACTIONS(100),
    [sym_DISJOINT] = ACTIONS(103),
    [sym_EXTERNAL] = ACTIONS(106),
    [sym_DEFINED] = ACTIONS(109),
    [sym_FALSE] = ACTIONS(112),
    [sym_IF] = ACTIONS(115),
    [sym_INCLUDE] = ACTIONS(118),
    [sym_INFIMUM] = ACTIONS(121),
    [sym_LBRACE] = ACTIONS(124),
    [sym_LPAREN] = ACTIONS(127),
    [sym_MAX] = ACTIONS(130),
    [sym_MAXIMIZE] = ACTIONS(133),
    [sym_MIN] = ACTIONS(130),
    [sym_MINIMIZE] = ACTIONS(136),
    [sym_SHOW] = ACTIONS(139),
    [sym_EDGE] = ACTIONS(142),
    [sym_PROJECT] = ACTIONS(145),
    [sym_HEURISTIC] = ACTIONS(148),
    [sym_SHOWSIG] = ACTIONS(151),
    [sym_SUB] = ACTIONS(154),
    [sym_SUM] = ACTIONS(130),
    [sym_SUMP] = ACTIONS(97),
    [sym_SUPREMUM] = ACTIONS(121),
    [sym_TRUE] = ACTIONS(112),
    [sym_BLOCK] = ACTIONS(157),
    [sym_VBAR] = ACTIONS(160),
    [sym_WIF] = ACTIONS(163),
    [sym_THEORY] = ACTIONS(166),
    [anon_sym_0] = ACTIONS(169),
    [aux_sym_dec_token1] = ACTIONS(172),
    [sym_hex] = ACTIONS(175),
    [sym_oct] = ACTIONS(175),
    [sym_bin] = ACTIONS(175),
    [sym_ANONYMOUS] = ACTIONS(178),
    [sym_identifier] = ACTIONS(181),
    [sym_SCRIPT] = ACTIONS(184),
    [sym_VARIABLE] = ACTIONS(121),
    [sym_NOT] = ACTIONS(187),
    [anon_sym_DQUOTE] = ACTIONS(190),
    [anon_sym_SQUOTE] = ACTIONS(193),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(196), 1,
      sym_AND,
    ACTIONS(198), 1,
      sym_DOT,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(208), 1,
      sym_NOT,
    STATE(22), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(32), 1,
      sym_dec,
    STATE(62), 1,
      sym_term,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(454), 1,
      sym_literal,
    STATE(513), 1,
      sym_theory_atom,
    STATE(536), 1,
      sym_lubodyaggregate,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(568), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [128] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(196), 1,
      sym_AND,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(208), 1,
      sym_NOT,
    ACTIONS(210), 1,
      sym_DOT,
    STATE(11), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(32), 1,
      sym_dec,
    STATE(62), 1,
      sym_term,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(454), 1,
      sym_literal,
    STATE(513), 1,
      sym_theory_atom,
    STATE(536), 1,
      sym_lubodyaggregate,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(568), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [256] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(196), 1,
      sym_AND,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(208), 1,
      sym_NOT,
    ACTIONS(212), 1,
      sym_DOT,
    STATE(19), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(32), 1,
      sym_dec,
    STATE(62), 1,
      sym_term,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(454), 1,
      sym_literal,
    STATE(513), 1,
      sym_theory_atom,
    STATE(536), 1,
      sym_lubodyaggregate,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(568), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [384] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(196), 1,
      sym_AND,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(208), 1,
      sym_NOT,
    ACTIONS(214), 1,
      sym_DOT,
    STATE(23), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(32), 1,
      sym_dec,
    STATE(62), 1,
      sym_term,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(454), 1,
      sym_literal,
    STATE(513), 1,
      sym_theory_atom,
    STATE(536), 1,
      sym_lubodyaggregate,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(568), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [512] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(218), 1,
      sym_LBRACK,
    ACTIONS(220), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(216), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [569] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(196), 1,
      sym_AND,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(208), 1,
      sym_NOT,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(32), 1,
      sym_dec,
    STATE(62), 1,
      sym_term,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(454), 1,
      sym_literal,
    STATE(513), 1,
      sym_theory_atom,
    STATE(536), 1,
      sym_lubodyaggregate,
    STATE(696), 1,
      sym_bodydot,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(568), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [694] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(196), 1,
      sym_AND,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(208), 1,
      sym_NOT,
    STATE(24), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(32), 1,
      sym_dec,
    STATE(62), 1,
      sym_term,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(454), 1,
      sym_literal,
    STATE(513), 1,
      sym_theory_atom,
    STATE(536), 1,
      sym_lubodyaggregate,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(568), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [819] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(224), 1,
      sym_LBRACK,
    ACTIONS(226), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(222), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [876] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(228), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [931] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 1,
      sym_LBRACK,
    ACTIONS(236), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(232), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [988] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(240), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(238), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [1043] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(242), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [1098] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(248), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(246), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [1153] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(250), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [1208] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(196), 1,
      sym_AND,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(208), 1,
      sym_NOT,
    STATE(25), 1,
      sym_bodydot,
    STATE(28), 1,
      sym_nbodycomma,
    STATE(32), 1,
      sym_dec,
    STATE(62), 1,
      sym_term,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(454), 1,
      sym_literal,
    STATE(513), 1,
      sym_theory_atom,
    STATE(536), 1,
      sym_lubodyaggregate,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(568), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [1333] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(256), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(254), 39,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [1388] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(258), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [1442] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(264), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(262), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [1496] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(266), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [1550] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(232), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [1604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(226), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(222), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [1658] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(220), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(216), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [1712] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(272), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(270), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [1766] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(276), 8,
      sym_MAX,
      sym_MIN,
      sym_SHOW,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(274), 38,
      ts_builtin_sym_end,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_CONST,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_EXTERNAL,
      sym_DEFINED,
      sym_FALSE,
      sym_IF,
      sym_INCLUDE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAXIMIZE,
      sym_MINIMIZE,
      sym_EDGE,
      sym_PROJECT,
      sym_HEURISTIC,
      sym_SHOWSIG,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_BLOCK,
      sym_VBAR,
      sym_WIF,
      sym_THEORY,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_SCRIPT,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [1820] = 36,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(19), 1,
      sym_DISJOINT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(196), 1,
      sym_AND,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(278), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(62), 1,
      sym_term,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(500), 1,
      sym_literal,
    STATE(513), 1,
      sym_theory_atom,
    STATE(517), 1,
      sym_lubodyaggregate,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    STATE(615), 2,
      sym_disjoint,
      sym_conjunction,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [1939] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(282), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(280), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [1991] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(288), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(286), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2043] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(290), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2093] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(294), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2143] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(298), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2193] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(304), 9,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MOD,
      sym_MUL,
      sym_SUM,
    ACTIONS(302), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2243] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(310), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_SUM,
    ACTIONS(312), 24,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SUMP,
      sym_VBAR,
      anon_sym_EQ_EQ,
  [2308] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(310), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(312), 32,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2359] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(310), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(312), 30,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2414] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(310), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(312), 29,
      sym_ADD,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2471] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(288), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_SUM,
    ACTIONS(286), 24,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SUMP,
      sym_VBAR,
      anon_sym_EQ_EQ,
  [2536] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(310), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(312), 27,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2595] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(310), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(312), 31,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2648] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(328), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(326), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2697] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(312), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2746] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(282), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(280), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2795] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(286), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2844] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 8,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(312), 33,
      sym_ADD,
      sym_AND,
      sym_AT,
      sym_COLON,
      sym_COMMA,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2893] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(330), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(332), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(282), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(280), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [2947] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(334), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(336), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(282), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(280), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3001] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(338), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(340), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(310), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(312), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3052] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(344), 5,
      sym_COMMA,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
    ACTIONS(310), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(312), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3103] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(196), 1,
      sym_AND,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(346), 1,
      sym_DISJOINT,
    ACTIONS(350), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(112), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    STATE(430), 1,
      sym_atom,
    STATE(513), 1,
      sym_theory_atom,
    STATE(521), 1,
      sym_lubodyaggregate,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(348), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3203] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(196), 1,
      sym_AND,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(346), 1,
      sym_DISJOINT,
    ACTIONS(352), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(112), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    STATE(430), 1,
      sym_atom,
    STATE(513), 1,
      sym_theory_atom,
    STATE(517), 1,
      sym_lubodyaggregate,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(348), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3303] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(334), 1,
      sym_DOT,
    ACTIONS(336), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(282), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(280), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3355] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(330), 1,
      sym_DOT,
    ACTIONS(332), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(282), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(280), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3407] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_DOT,
    ACTIONS(344), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(310), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(312), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3456] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(196), 1,
      sym_AND,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(354), 1,
      sym_DISJOINT,
    ACTIONS(358), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(105), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    STATE(452), 1,
      sym_atom,
    STATE(513), 1,
      sym_theory_atom,
    STATE(521), 1,
      sym_lubodyaggregate,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(356), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3553] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(338), 1,
      sym_DOT,
    ACTIONS(340), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(310), 7,
      sym_EQ,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_GT,
      sym_LT,
      sym_MUL,
      sym_SUM,
    ACTIONS(312), 25,
      sym_ADD,
      sym_AND,
      sym_COUNT,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_GEQ,
      sym_LBRACE,
      sym_LEQ,
      sym_MAX,
      sym_MIN,
      sym_NEQ,
      sym_POW,
      sym_QUESTION,
      sym_SLASH,
      sym_SUB,
      sym_SUMP,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
      anon_sym_EQ_EQ,
  [3602] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(196), 1,
      sym_AND,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(354), 1,
      sym_DISJOINT,
    ACTIONS(358), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(64), 1,
      sym_bodyaggregate,
    STATE(105), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    STATE(452), 1,
      sym_atom,
    STATE(513), 1,
      sym_theory_atom,
    STATE(535), 1,
      sym_lubodyaggregate,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(356), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [3699] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      sym_LBRACE,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(364), 1,
      sym_CSP_MUL,
    STATE(74), 1,
      sym_headaggregate,
    STATE(86), 1,
      sym_cmp,
    STATE(669), 1,
      sym_aggregatefunction,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(366), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(362), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [3776] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(372), 1,
      sym_SEM,
    ACTIONS(374), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(100), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(315), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(370), 1,
      sym_atom,
    STATE(407), 1,
      sym_literal,
    STATE(411), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(370), 2,
      sym_DOT,
      sym_IF,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [3871] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(374), 1,
      sym_NOT,
    ACTIONS(378), 1,
      sym_SEM,
    STATE(32), 1,
      sym_dec,
    STATE(100), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(315), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(370), 1,
      sym_atom,
    STATE(407), 1,
      sym_literal,
    STATE(414), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(376), 2,
      sym_DOT,
      sym_IF,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [3966] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(364), 1,
      sym_CSP_MUL,
    STATE(66), 1,
      sym_bodyaggregate,
    STATE(89), 1,
      sym_cmp,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(366), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(362), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [4043] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(493), 1,
      sym_literal,
    STATE(602), 1,
      sym_altbodyaggrelem,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(380), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4135] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(220), 1,
      sym_cmp,
    STATE(317), 1,
      sym_term,
    STATE(516), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(384), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [4215] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(390), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(343), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(370), 1,
      sym_atom,
    STATE(407), 1,
      sym_literal,
    STATE(526), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(388), 2,
      sym_DOT,
      sym_SEM,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4307] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(220), 1,
      sym_cmp,
    STATE(317), 1,
      sym_term,
    STATE(525), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(392), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [4387] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(220), 1,
      sym_cmp,
    STATE(317), 1,
      sym_term,
    STATE(545), 1,
      sym_nupper,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(394), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [4467] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(390), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(343), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(370), 1,
      sym_atom,
    STATE(407), 1,
      sym_literal,
    STATE(543), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(396), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4559] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(390), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(343), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(370), 1,
      sym_atom,
    STATE(407), 1,
      sym_literal,
    STATE(546), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(398), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4651] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_NOT,
    ACTIONS(400), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(493), 1,
      sym_literal,
    STATE(621), 1,
      sym_altbodyaggrelemvec,
    STATE(627), 1,
      sym_altbodyaggrelem,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4745] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(390), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(343), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(370), 1,
      sym_atom,
    STATE(528), 1,
      sym_literal,
    STATE(529), 1,
      sym_optimizelitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(402), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4837] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(390), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(343), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(370), 1,
      sym_atom,
    STATE(407), 1,
      sym_literal,
    STATE(527), 1,
      sym_nlitvec,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    ACTIONS(370), 2,
      sym_RBRACE,
      sym_SEM,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [4929] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(190), 1,
      sym__widentifier,
    STATE(242), 1,
      sym_cmp,
    STATE(329), 1,
      sym_term,
    STATE(603), 1,
      sym_nupper,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(408), 2,
      sym_DOT,
      sym_IF,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [5008] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(190), 1,
      sym__widentifier,
    STATE(242), 1,
      sym_cmp,
    STATE(329), 1,
      sym_term,
    STATE(580), 1,
      sym_nupper,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(430), 2,
      sym_DOT,
      sym_IF,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [5087] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(190), 1,
      sym__widentifier,
    STATE(242), 1,
      sym_cmp,
    STATE(329), 1,
      sym_term,
    STATE(616), 1,
      sym_nupper,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(432), 2,
      sym_DOT,
      sym_IF,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [5166] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_NOT,
    ACTIONS(434), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(460), 1,
      sym_literal,
    STATE(564), 1,
      sym_altheadaggrelemvec,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5257] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(390), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(343), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(370), 1,
      sym_atom,
    STATE(544), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5342] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(374), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(100), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(315), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(361), 1,
      sym_literal,
    STATE(370), 1,
      sym_atom,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5427] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(374), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(100), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(315), 1,
      sym_csp_literal,
    STATE(356), 1,
      sym_csp_add_term,
    STATE(370), 1,
      sym_atom,
    STATE(413), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5512] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(455), 1,
      sym_literal,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5597] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(390), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(174), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(343), 1,
      sym_csp_literal,
    STATE(357), 1,
      sym_csp_add_term,
    STATE(370), 1,
      sym_atom,
    STATE(413), 1,
      sym_literal,
    ACTIONS(25), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5682] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(478), 1,
      sym_literal,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5767] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(462), 1,
      sym_literal,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5852] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(499), 1,
      sym_literal,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [5937] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(103), 1,
      sym_term,
    STATE(166), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(332), 1,
      sym_csp_literal,
    STATE(355), 1,
      sym_csp_add_term,
    STATE(445), 1,
      sym_atom,
    STATE(505), 1,
      sym_literal,
    ACTIONS(200), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6022] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      sym_LBRACE,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(75), 1,
      sym_headaggregate,
    STATE(122), 1,
      sym_dec,
    STATE(190), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    STATE(669), 1,
      sym_aggregatefunction,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [6098] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(67), 1,
      sym_bodyaggregate,
    STATE(187), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_term,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [6174] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(67), 1,
      sym_bodyaggregate,
    STATE(187), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_term,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [6250] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(67), 1,
      sym_bodyaggregate,
    STATE(187), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_term,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
  [6326] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(436), 1,
      sym_COMMA,
    ACTIONS(438), 1,
      sym_RPAREN,
    ACTIONS(440), 1,
      sym_SEM,
    STATE(32), 1,
      sym_dec,
    STATE(106), 1,
      sym_tuplevec_sem,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(542), 1,
      sym_ntermvec,
    STATE(553), 1,
      sym_ntuple,
    STATE(672), 1,
      sym_ntuplevec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6405] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(444), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(442), 24,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [6442] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(436), 1,
      sym_COMMA,
    ACTIONS(440), 1,
      sym_SEM,
    ACTIONS(446), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(106), 1,
      sym_tuplevec_sem,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(542), 1,
      sym_ntermvec,
    STATE(553), 1,
      sym_ntuple,
    STATE(714), 1,
      sym_ntuplevec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6521] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(450), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(448), 24,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [6558] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(454), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(452), 24,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [6595] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(458), 5,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(456), 24,
      sym_AND,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_CSP,
      sym_DISJOINT,
      sym_FALSE,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [6632] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 1,
      sym_COLON,
    ACTIONS(464), 1,
      sym_LBRACE,
    ACTIONS(466), 1,
      sym_LBRACK,
    ACTIONS(468), 1,
      sym_LPAREN,
    ACTIONS(470), 1,
      sym_RBRACE,
    ACTIONS(472), 1,
      anon_sym_0,
    ACTIONS(474), 1,
      aux_sym_dec_token1,
    ACTIONS(478), 1,
      sym_identifier,
    ACTIONS(482), 1,
      anon_sym_DQUOTE,
    ACTIONS(484), 1,
      anon_sym_SQUOTE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(360), 1,
      sym_theory_opterm,
    STATE(397), 1,
      sym_dec,
    STATE(409), 1,
      sym_theory_term,
    STATE(448), 1,
      sym_theory_opterm_nlist,
    STATE(590), 1,
      sym_theory_atom_element,
    STATE(658), 1,
      sym_theory_atom_element_nlist,
    ACTIONS(480), 2,
      sym_THEORY_OP,
      sym_NOT,
    STATE(417), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(462), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(476), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6708] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 1,
      sym_COLON,
    ACTIONS(464), 1,
      sym_LBRACE,
    ACTIONS(466), 1,
      sym_LBRACK,
    ACTIONS(468), 1,
      sym_LPAREN,
    ACTIONS(472), 1,
      anon_sym_0,
    ACTIONS(474), 1,
      aux_sym_dec_token1,
    ACTIONS(478), 1,
      sym_identifier,
    ACTIONS(482), 1,
      anon_sym_DQUOTE,
    ACTIONS(484), 1,
      anon_sym_SQUOTE,
    ACTIONS(486), 1,
      sym_RBRACE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(360), 1,
      sym_theory_opterm,
    STATE(397), 1,
      sym_dec,
    STATE(409), 1,
      sym_theory_term,
    STATE(448), 1,
      sym_theory_opterm_nlist,
    STATE(590), 1,
      sym_theory_atom_element,
    STATE(596), 1,
      sym_theory_atom_element_nlist,
    ACTIONS(480), 2,
      sym_THEORY_OP,
      sym_NOT,
    STATE(417), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(462), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(476), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6784] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(490), 22,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [6819] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(492), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(494), 22,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [6854] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(364), 1,
      sym_CSP_MUL,
    STATE(249), 1,
      sym_cmp,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(366), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(362), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [6913] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(496), 1,
      sym_COLON,
    ACTIONS(498), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(451), 1,
      sym_ntermvec,
    STATE(646), 1,
      sym_bodyaggrelemvec,
    STATE(649), 1,
      sym_bodyaggrelem,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [6986] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(502), 22,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_DOT,
      sym_GEQ,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [7021] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(364), 1,
      sym_CSP_MUL,
    STATE(217), 1,
      sym_cmp,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(366), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
    ACTIONS(362), 6,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [7080] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(346), 1,
      sym_DISJOINT,
    ACTIONS(506), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(174), 1,
      sym__widentifier,
    STATE(291), 1,
      sym_term,
    STATE(368), 1,
      sym_atom,
    ACTIONS(504), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7153] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    STATE(66), 1,
      sym_bodyaggregate,
    STATE(88), 1,
      sym_cmp,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [7215] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(436), 1,
      sym_COMMA,
    ACTIONS(508), 1,
      sym_SEM,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(542), 1,
      sym_ntermvec,
    STATE(555), 1,
      sym_ntuple,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7285] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(510), 1,
      sym_COLON,
    ACTIONS(512), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(617), 1,
      sym_ncspelemvec,
    STATE(656), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7355] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(514), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(516), 21,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [7389] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(518), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(174), 1,
      sym__widentifier,
    STATE(287), 1,
      sym_term,
    STATE(368), 1,
      sym_atom,
    ACTIONS(504), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7459] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(288), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(286), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7495] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(282), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(280), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [7531] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      sym_SUM,
    ACTIONS(202), 1,
      sym_LBRACE,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    STATE(66), 1,
      sym_bodyaggregate,
    STATE(87), 1,
      sym_cmp,
    STATE(703), 1,
      sym_aggregatefunction,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(15), 4,
      sym_COUNT,
      sym_MAX,
      sym_MIN,
      sym_SUMP,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [7593] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(510), 1,
      sym_COLON,
    ACTIONS(520), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(656), 1,
      sym_ntermvec,
    STATE(659), 1,
      sym_ncspelemvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7663] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 1,
      sym_COLON,
    ACTIONS(464), 1,
      sym_LBRACE,
    ACTIONS(466), 1,
      sym_LBRACK,
    ACTIONS(468), 1,
      sym_LPAREN,
    ACTIONS(472), 1,
      anon_sym_0,
    ACTIONS(474), 1,
      aux_sym_dec_token1,
    ACTIONS(478), 1,
      sym_identifier,
    ACTIONS(482), 1,
      anon_sym_DQUOTE,
    ACTIONS(484), 1,
      anon_sym_SQUOTE,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(360), 1,
      sym_theory_opterm,
    STATE(397), 1,
      sym_dec,
    STATE(409), 1,
      sym_theory_term,
    STATE(448), 1,
      sym_theory_opterm_nlist,
    STATE(589), 1,
      sym_theory_atom_element,
    ACTIONS(480), 2,
      sym_THEORY_OP,
      sym_NOT,
    STATE(417), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(462), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(476), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7733] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(206), 1,
      sym_identifier,
    ACTIONS(522), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(287), 1,
      sym_term,
    STATE(430), 1,
      sym_atom,
    ACTIONS(348), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7803] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(354), 1,
      sym_DISJOINT,
    ACTIONS(526), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(174), 1,
      sym__widentifier,
    STATE(286), 1,
      sym_term,
    STATE(376), 1,
      sym_atom,
    ACTIONS(524), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7873] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(510), 1,
      sym_COLON,
    ACTIONS(528), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(593), 1,
      sym_ncspelemvec,
    STATE(656), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [7943] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(530), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(532), 21,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [7977] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(534), 1,
      sym_COLON,
    ACTIONS(536), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(582), 1,
      sym_ntermvec,
    STATE(584), 1,
      sym_headaggrelemvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8047] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(71), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(538), 1,
      sym_NOT,
    STATE(32), 1,
      sym_dec,
    STATE(174), 1,
      sym__widentifier,
    STATE(291), 1,
      sym_term,
    STATE(368), 1,
      sym_atom,
    ACTIONS(504), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8117] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(540), 5,
      sym_EQ,
      sym_GT,
      sym_LT,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(542), 21,
      sym_AT,
      sym_BNOT,
      sym_DOT,
      sym_GEQ,
      sym_IF,
      sym_INFIMUM,
      sym_LEQ,
      sym_LPAREN,
      sym_NEQ,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_EQ_EQ,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [8151] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(296), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(294), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8184] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(544), 1,
      sym_CSP,
    STATE(32), 1,
      sym_dec,
    STATE(177), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(320), 1,
      sym_csp_mul_term,
    STATE(380), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8251] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(546), 1,
      sym_RBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(298), 1,
      sym_term,
    STATE(387), 1,
      sym_optimizeweight,
    STATE(561), 1,
      sym_minelemlist,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8318] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      sym_AND,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(554), 1,
      sym_MUL,
    ACTIONS(556), 1,
      sym_POW,
    ACTIONS(558), 1,
      sym_QUESTION,
    ACTIONS(562), 1,
      sym_XOR,
    ACTIONS(548), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(560), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(288), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(286), 11,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [8367] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(572), 1,
      sym_RPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(570), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8436] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(496), 1,
      sym_COLON,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(451), 1,
      sym_ntermvec,
    STATE(583), 1,
      sym_bodyaggrelem,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8503] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(286), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [8536] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(588), 1,
      sym_RPAREN,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(573), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8605] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(544), 1,
      sym_CSP,
    STATE(32), 1,
      sym_dec,
    STATE(177), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(318), 1,
      sym_csp_add_term,
    STATE(320), 1,
      sym_csp_mul_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8672] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(544), 1,
      sym_CSP,
    STATE(32), 1,
      sym_dec,
    STATE(177), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(320), 1,
      sym_csp_mul_term,
    STATE(415), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8739] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(590), 1,
      sym_RBRACK,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(576), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8808] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(526), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(174), 1,
      sym__widentifier,
    STATE(286), 1,
      sym_term,
    STATE(376), 1,
      sym_atom,
    ACTIONS(524), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8875] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(590), 1,
      sym_RBRACE,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(579), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [8944] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(592), 1,
      sym_RPAREN,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(594), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9013] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(594), 1,
      sym_RPAREN,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(591), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9082] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(596), 1,
      sym_RPAREN,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(595), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9151] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(312), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [9184] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      sym_AND,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(558), 1,
      sym_QUESTION,
    ACTIONS(562), 1,
      sym_XOR,
    ACTIONS(310), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(312), 16,
      sym_ADD,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [9225] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(598), 1,
      sym_LBRACE,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(298), 1,
      sym_term,
    STATE(416), 1,
      sym_optimizeweight,
    STATE(650), 1,
      sym_maxelemlist,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9292] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(600), 1,
      sym_RBRACK,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(547), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9361] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    ACTIONS(602), 1,
      sym_CSP,
    STATE(122), 1,
      sym_dec,
    STATE(150), 1,
      sym_term,
    STATE(190), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(307), 1,
      sym_csp_add_term,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9428] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(558), 1,
      sym_QUESTION,
    ACTIONS(562), 1,
      sym_XOR,
    ACTIONS(310), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(312), 17,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [9467] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(310), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(312), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [9500] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      sym_AND,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(558), 1,
      sym_QUESTION,
    ACTIONS(562), 1,
      sym_XOR,
    ACTIONS(548), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(310), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(312), 14,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_SEM,
      sym_SLASH,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [9543] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      sym_AND,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(554), 1,
      sym_MUL,
    ACTIONS(556), 1,
      sym_POW,
    ACTIONS(558), 1,
      sym_QUESTION,
    ACTIONS(562), 1,
      sym_XOR,
    ACTIONS(548), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(560), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(310), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(312), 11,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [9592] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(562), 1,
      sym_XOR,
    ACTIONS(310), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(312), 18,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      anon_sym_BSLASH_BSLASH,
  [9629] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(310), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(312), 19,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [9664] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(604), 1,
      sym_RBRACK,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(608), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9733] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      sym_AND,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(554), 1,
      sym_MUL,
    ACTIONS(556), 1,
      sym_POW,
    ACTIONS(558), 1,
      sym_QUESTION,
    ACTIONS(562), 1,
      sym_XOR,
    ACTIONS(606), 1,
      sym_CSP_MUL,
    ACTIONS(548), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(560), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(366), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(362), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [9784] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(328), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(326), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [9817] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(604), 1,
      sym_RBRACE,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(613), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9886] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(538), 1,
      sym_ntermvec,
    STATE(642), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [9953] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(282), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(280), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [9986] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(544), 1,
      sym_CSP,
    STATE(32), 1,
      sym_dec,
    STATE(177), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(320), 1,
      sym_csp_mul_term,
    STATE(384), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10053] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(292), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(290), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [10086] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(53), 1,
      sym_SUB,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(526), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(174), 1,
      sym__widentifier,
    STATE(288), 1,
      sym_term,
    STATE(376), 1,
      sym_atom,
    ACTIONS(524), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10153] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(600), 1,
      sym_RBRACE,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(614), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10222] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(610), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(538), 1,
      sym_ntermvec,
    STATE(567), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10289] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(612), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(538), 1,
      sym_ntermvec,
    STATE(637), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10356] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(177), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(301), 1,
      sym_csp_mul_term,
    STATE(330), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10423] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(544), 1,
      sym_CSP,
    STATE(32), 1,
      sym_dec,
    STATE(177), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(320), 1,
      sym_csp_mul_term,
    STATE(390), 1,
      sym_csp_add_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10490] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(300), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(298), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [10523] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(614), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(538), 1,
      sym_ntermvec,
    STATE(548), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10590] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(304), 5,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
      sym_MUL,
    ACTIONS(302), 20,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_MUL,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOTS,
      sym_IF,
      sym_POW,
      sym_QUESTION,
      sym_SEM,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
      anon_sym_BSLASH_BSLASH,
  [10623] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(608), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(538), 1,
      sym_ntermvec,
    STATE(647), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10690] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(11), 1,
      sym_BNOT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(204), 1,
      sym_SUB,
    ACTIONS(358), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(166), 1,
      sym__widentifier,
    STATE(288), 1,
      sym_term,
    STATE(452), 1,
      sym_atom,
    ACTIONS(356), 2,
      sym_FALSE,
      sym_TRUE,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10757] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(616), 1,
      sym_RPAREN,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(562), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10826] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(618), 1,
      sym_RPAREN,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(645), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [10895] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      sym_AND,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(554), 1,
      sym_MUL,
    ACTIONS(556), 1,
      sym_POW,
    ACTIONS(558), 1,
      sym_QUESTION,
    ACTIONS(562), 1,
      sym_XOR,
    ACTIONS(624), 1,
      sym_CSP_MUL,
    ACTIONS(548), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(560), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(620), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(622), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [10946] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(626), 1,
      sym_RPAREN,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(648), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11015] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(628), 1,
      sym_RBRACK,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(661), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11084] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(612), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(538), 1,
      sym_ntermvec,
    STATE(653), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11151] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(630), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(538), 1,
      sym_ntermvec,
    STATE(601), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11218] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(628), 1,
      sym_RBRACE,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(359), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(660), 1,
      sym_theory_opterm_nlist,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11287] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(198), 1,
      sym_DOT,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(632), 1,
      sym_CSP,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(337), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11351] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(364), 1,
      sym_CSP_MUL,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(366), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(362), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [11401] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(628), 1,
      sym_RPAREN,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(412), 1,
      sym_theory_opterm,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11467] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(538), 1,
      sym_ntermvec,
    STATE(651), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11531] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(544), 1,
      sym_CSP,
    STATE(32), 1,
      sym_dec,
    STATE(177), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(316), 1,
      sym_csp_mul_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11595] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(634), 1,
      sym_CSP_MUL,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(620), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(622), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [11645] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    ACTIONS(602), 1,
      sym_CSP,
    STATE(122), 1,
      sym_dec,
    STATE(150), 1,
      sym_term,
    STATE(190), 1,
      sym__widentifier,
    STATE(305), 1,
      sym_csp_mul_term,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11709] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(590), 1,
      sym_RPAREN,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(386), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11775] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(17), 1,
      sym_CSP,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(177), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    STATE(305), 1,
      sym_csp_mul_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11839] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(636), 1,
      sym_COLON,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(605), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11903] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(538), 1,
      sym_ntermvec,
    STATE(633), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [11967] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(538), 1,
      sym_ntermvec,
    STATE(644), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12031] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(600), 1,
      sym_RPAREN,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(400), 1,
      sym_dec,
    STATE(402), 1,
      sym_theory_opterm,
    STATE(403), 1,
      sym_theory_term,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12097] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    ACTIONS(604), 1,
      sym_RPAREN,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(382), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12163] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(538), 1,
      sym_ntermvec,
    STATE(652), 1,
      sym_argvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12227] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(638), 2,
      sym_RPAREN,
      sym_SEM,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12289] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    ACTIONS(640), 1,
      sym_COLON,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(559), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12353] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      sym_AND,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(554), 1,
      sym_MUL,
    ACTIONS(556), 1,
      sym_POW,
    ACTIONS(558), 1,
      sym_QUESTION,
    ACTIONS(562), 1,
      sym_XOR,
    ACTIONS(548), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(560), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(642), 4,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(644), 10,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [12401] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(348), 1,
      sym_term,
    STATE(566), 1,
      sym_binaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12462] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(646), 1,
      sym_AT,
    ACTIONS(652), 1,
      sym_LPAREN,
    ACTIONS(654), 1,
      sym_RPAREN,
    ACTIONS(656), 1,
      sym_VBAR,
    ACTIONS(658), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(195), 1,
      sym__widentifier,
    STATE(341), 1,
      sym_constterm,
    STATE(609), 1,
      sym_consttermvec,
    STATE(683), 1,
      sym_nconstargvec,
    ACTIONS(648), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(650), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(313), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12525] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(662), 1,
      sym_LBRACE,
    ACTIONS(664), 1,
      sym_LBRACK,
    ACTIONS(666), 1,
      sym_LPAREN,
    ACTIONS(668), 1,
      anon_sym_0,
    ACTIONS(670), 1,
      aux_sym_dec_token1,
    ACTIONS(674), 1,
      sym_identifier,
    ACTIONS(676), 1,
      anon_sym_DQUOTE,
    ACTIONS(678), 1,
      anon_sym_SQUOTE,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(367), 1,
      sym_theory_opterm,
    STATE(432), 1,
      sym_dec,
    STATE(440), 1,
      sym_theory_term,
    STATE(444), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(660), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(672), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12588] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(331), 1,
      sym_term,
    STATE(643), 1,
      sym_unaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12649] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(447), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12710] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    STATE(263), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(358), 1,
      sym_theory_opterm,
    STATE(400), 1,
      sym_dec,
    STATE(403), 1,
      sym_theory_term,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12773] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(682), 1,
      sym_LBRACE,
    ACTIONS(684), 1,
      sym_LBRACK,
    ACTIONS(686), 1,
      sym_LPAREN,
    ACTIONS(688), 1,
      anon_sym_0,
    ACTIONS(690), 1,
      aux_sym_dec_token1,
    ACTIONS(694), 1,
      sym_identifier,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      anon_sym_SQUOTE,
    STATE(258), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(420), 1,
      sym_theory_opterm,
    STATE(472), 1,
      sym_theory_term,
    STATE(487), 1,
      sym_dec,
    STATE(470), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(680), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(692), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12836] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(298), 1,
      sym_term,
    STATE(391), 1,
      sym_optimizeweight,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12897] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(298), 1,
      sym_term,
    STATE(401), 1,
      sym_optimizeweight,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [12958] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(634), 1,
      sym_CSP_MUL,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(620), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(622), 9,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [13007] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      sym_LBRACE,
    ACTIONS(466), 1,
      sym_LBRACK,
    ACTIONS(468), 1,
      sym_LPAREN,
    ACTIONS(472), 1,
      anon_sym_0,
    ACTIONS(474), 1,
      aux_sym_dec_token1,
    ACTIONS(478), 1,
      sym_identifier,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(482), 1,
      anon_sym_DQUOTE,
    ACTIONS(484), 1,
      anon_sym_SQUOTE,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    STATE(262), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(362), 1,
      sym_theory_opterm,
    STATE(397), 1,
      sym_dec,
    STATE(409), 1,
      sym_theory_term,
    STATE(417), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(462), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(476), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13070] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(646), 1,
      sym_AT,
    ACTIONS(652), 1,
      sym_LPAREN,
    ACTIONS(656), 1,
      sym_VBAR,
    ACTIONS(658), 1,
      sym_identifier,
    ACTIONS(700), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(195), 1,
      sym__widentifier,
    STATE(341), 1,
      sym_constterm,
    STATE(609), 1,
      sym_consttermvec,
    STATE(706), 1,
      sym_nconstargvec,
    ACTIONS(648), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(650), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(313), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13133] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(704), 3,
      sym_SUM,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(702), 20,
      sym_AT,
      sym_BNOT,
      sym_COUNT,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LPAREN,
      sym_MAX,
      sym_MIN,
      sym_SUB,
      sym_SUMP,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [13164] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(296), 1,
      sym_term,
    STATE(512), 1,
      sym_ntermvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13225] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(662), 1,
      sym_LBRACE,
    ACTIONS(664), 1,
      sym_LBRACK,
    ACTIONS(666), 1,
      sym_LPAREN,
    ACTIONS(668), 1,
      anon_sym_0,
    ACTIONS(670), 1,
      aux_sym_dec_token1,
    ACTIONS(674), 1,
      sym_identifier,
    ACTIONS(676), 1,
      anon_sym_DQUOTE,
    ACTIONS(678), 1,
      anon_sym_SQUOTE,
    STATE(268), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(365), 1,
      sym_theory_opterm,
    STATE(432), 1,
      sym_dec,
    STATE(440), 1,
      sym_theory_term,
    STATE(444), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(660), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(672), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13288] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(298), 1,
      sym_term,
    STATE(533), 1,
      sym_optimizeweight,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13349] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(642), 3,
      sym_CSP_LT,
      sym_CSP_GT,
      sym_DOT,
    ACTIONS(644), 10,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_RBRACE,
      sym_SEM,
  [13396] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(331), 1,
      sym_term,
    STATE(611), 1,
      sym_unaryargvec,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13457] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(682), 1,
      sym_LBRACE,
    ACTIONS(684), 1,
      sym_LBRACK,
    ACTIONS(686), 1,
      sym_LPAREN,
    ACTIONS(688), 1,
      anon_sym_0,
    ACTIONS(690), 1,
      aux_sym_dec_token1,
    ACTIONS(694), 1,
      sym_identifier,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      anon_sym_SQUOTE,
    STATE(258), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    STATE(404), 1,
      sym_theory_opterm,
    STATE(472), 1,
      sym_theory_term,
    STATE(487), 1,
      sym_dec,
    STATE(470), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(680), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(692), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13520] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(145), 1,
      sym_term,
    STATE(190), 1,
      sym__widentifier,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13578] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(35), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13636] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(39), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13694] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(334), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13752] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(303), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13810] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(190), 1,
      sym__widentifier,
    STATE(193), 1,
      sym_term,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13868] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(344), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13926] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(323), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [13984] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(148), 1,
      sym_term,
    STATE(190), 1,
      sym__widentifier,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14042] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(306), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14100] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(147), 1,
      sym_term,
    STATE(190), 1,
      sym__widentifier,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14158] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(146), 1,
      sym_term,
    STATE(190), 1,
      sym__widentifier,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14216] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(144), 1,
      sym_term,
    STATE(190), 1,
      sym__widentifier,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14274] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(143), 1,
      sym_term,
    STATE(190), 1,
      sym__widentifier,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14332] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(139), 1,
      sym_term,
    STATE(190), 1,
      sym__widentifier,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14390] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(125), 1,
      sym_term,
    STATE(190), 1,
      sym__widentifier,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14448] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(335), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14506] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(347), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14564] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(333), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14622] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(300), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14680] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(170), 1,
      sym_term,
    STATE(190), 1,
      sym__widentifier,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14738] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(203), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14796] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(336), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14854] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(210), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14912] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(342), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [14970] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(339), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15028] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(328), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15086] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(706), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(39), 1,
      sym_term,
    STATE(173), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15144] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(190), 1,
      sym__widentifier,
    STATE(292), 1,
      sym_term,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15202] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(190), 1,
      sym__widentifier,
    STATE(338), 1,
      sym_term,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15260] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(304), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15318] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(297), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15376] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(190), 1,
      sym__widentifier,
    STATE(295), 1,
      sym_term,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15434] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(708), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(39), 1,
      sym_term,
    STATE(159), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15492] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(36), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15550] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(346), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15608] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym_AT,
    ACTIONS(412), 1,
      sym_LPAREN,
    ACTIONS(414), 1,
      sym_VBAR,
    ACTIONS(416), 1,
      anon_sym_0,
    ACTIONS(418), 1,
      aux_sym_dec_token1,
    ACTIONS(422), 1,
      sym_ANONYMOUS,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(428), 1,
      anon_sym_SQUOTE,
    STATE(122), 1,
      sym_dec,
    STATE(190), 1,
      sym__widentifier,
    STATE(294), 1,
      sym_term,
    ACTIONS(406), 2,
      sym_BNOT,
      sym_SUB,
    STATE(154), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(410), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(420), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15666] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(181), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15724] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(41), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15782] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(40), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15840] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(43), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15898] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(646), 1,
      sym_AT,
    ACTIONS(652), 1,
      sym_LPAREN,
    ACTIONS(654), 1,
      sym_RPAREN,
    ACTIONS(656), 1,
      sym_VBAR,
    ACTIONS(658), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(195), 1,
      sym__widentifier,
    STATE(341), 1,
      sym_constterm,
    STATE(610), 1,
      sym_consttermvec,
    ACTIONS(648), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(650), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(313), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [15958] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(187), 1,
      sym__widentifier,
    STATE(345), 1,
      sym_term,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16016] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(37), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16074] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_AT,
    ACTIONS(35), 1,
      sym_LPAREN,
    ACTIONS(57), 1,
      sym_VBAR,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(69), 1,
      sym_ANONYMOUS,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(386), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(38), 1,
      sym_term,
    STATE(187), 1,
      sym__widentifier,
    ACTIONS(11), 2,
      sym_BNOT,
      sym_SUB,
    STATE(44), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(31), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16132] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(682), 1,
      sym_LBRACE,
    ACTIONS(684), 1,
      sym_LBRACK,
    ACTIONS(686), 1,
      sym_LPAREN,
    ACTIONS(688), 1,
      anon_sym_0,
    ACTIONS(690), 1,
      aux_sym_dec_token1,
    ACTIONS(694), 1,
      sym_identifier,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      anon_sym_SQUOTE,
    STATE(293), 1,
      sym_theory_op,
    STATE(474), 1,
      sym_theory_term,
    STATE(487), 1,
      sym_dec,
    STATE(470), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(680), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(692), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16189] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      sym_LBRACE,
    ACTIONS(466), 1,
      sym_LBRACK,
    ACTIONS(468), 1,
      sym_LPAREN,
    ACTIONS(472), 1,
      anon_sym_0,
    ACTIONS(474), 1,
      aux_sym_dec_token1,
    ACTIONS(478), 1,
      sym_identifier,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(482), 1,
      anon_sym_DQUOTE,
    ACTIONS(484), 1,
      anon_sym_SQUOTE,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    STATE(293), 1,
      sym_theory_op,
    STATE(397), 1,
      sym_dec,
    STATE(422), 1,
      sym_theory_term,
    STATE(417), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(462), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(476), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16246] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(662), 1,
      sym_LBRACE,
    ACTIONS(664), 1,
      sym_LBRACK,
    ACTIONS(666), 1,
      sym_LPAREN,
    ACTIONS(668), 1,
      anon_sym_0,
    ACTIONS(670), 1,
      aux_sym_dec_token1,
    ACTIONS(674), 1,
      sym_identifier,
    ACTIONS(676), 1,
      anon_sym_DQUOTE,
    ACTIONS(678), 1,
      anon_sym_SQUOTE,
    STATE(293), 1,
      sym_theory_op,
    STATE(427), 1,
      sym_theory_term,
    STATE(432), 1,
      sym_dec,
    STATE(444), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(660), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(672), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16303] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(710), 17,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [16332] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      sym_LBRACE,
    ACTIONS(466), 1,
      sym_LBRACK,
    ACTIONS(468), 1,
      sym_LPAREN,
    ACTIONS(472), 1,
      anon_sym_0,
    ACTIONS(474), 1,
      aux_sym_dec_token1,
    ACTIONS(478), 1,
      sym_identifier,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(482), 1,
      anon_sym_DQUOTE,
    ACTIONS(484), 1,
      anon_sym_SQUOTE,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    STATE(293), 1,
      sym_theory_op,
    STATE(397), 1,
      sym_dec,
    STATE(398), 1,
      sym_theory_term,
    STATE(417), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(462), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(476), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16389] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    STATE(293), 1,
      sym_theory_op,
    STATE(400), 1,
      sym_dec,
    STATE(423), 1,
      sym_theory_term,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16446] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(714), 17,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [16475] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(682), 1,
      sym_LBRACE,
    ACTIONS(684), 1,
      sym_LBRACK,
    ACTIONS(686), 1,
      sym_LPAREN,
    ACTIONS(688), 1,
      anon_sym_0,
    ACTIONS(690), 1,
      aux_sym_dec_token1,
    ACTIONS(694), 1,
      sym_identifier,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      anon_sym_SQUOTE,
    STATE(293), 1,
      sym_theory_op,
    STATE(479), 1,
      sym_theory_term,
    STATE(487), 1,
      sym_dec,
    STATE(470), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(680), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(692), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16532] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(720), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(718), 17,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [16561] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(722), 17,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [16590] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(662), 1,
      sym_LBRACE,
    ACTIONS(664), 1,
      sym_LBRACK,
    ACTIONS(666), 1,
      sym_LPAREN,
    ACTIONS(668), 1,
      anon_sym_0,
    ACTIONS(670), 1,
      aux_sym_dec_token1,
    ACTIONS(674), 1,
      sym_identifier,
    ACTIONS(676), 1,
      anon_sym_DQUOTE,
    ACTIONS(678), 1,
      anon_sym_SQUOTE,
    STATE(293), 1,
      sym_theory_op,
    STATE(432), 1,
      sym_dec,
    STATE(434), 1,
      sym_theory_term,
    STATE(444), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(660), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(672), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16647] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 4,
      anon_sym_0,
      sym_ANONYMOUS,
      sym_identifier,
      sym_NOT,
    ACTIONS(726), 17,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_FALSE,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_TRUE,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [16676] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_NOT,
    ACTIONS(566), 1,
      sym_LBRACE,
    ACTIONS(568), 1,
      sym_LBRACK,
    ACTIONS(570), 1,
      sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_0,
    ACTIONS(576), 1,
      aux_sym_dec_token1,
    ACTIONS(580), 1,
      sym_identifier,
    ACTIONS(582), 1,
      sym_THEORY_OP,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_SQUOTE,
    STATE(293), 1,
      sym_theory_op,
    STATE(378), 1,
      sym_theory_term,
    STATE(400), 1,
      sym_dec,
    STATE(388), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(564), 3,
      sym_INFIMUM,
      sym_SUPREMUM,
      sym_VARIABLE,
    ACTIONS(578), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16733] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(646), 1,
      sym_AT,
    ACTIONS(652), 1,
      sym_LPAREN,
    ACTIONS(656), 1,
      sym_VBAR,
    ACTIONS(658), 1,
      sym_identifier,
    ACTIONS(730), 1,
      sym_RPAREN,
    STATE(32), 1,
      sym_dec,
    STATE(195), 1,
      sym__widentifier,
    STATE(340), 1,
      sym_constterm,
    ACTIONS(648), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(650), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(313), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16790] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(646), 1,
      sym_AT,
    ACTIONS(652), 1,
      sym_LPAREN,
    ACTIONS(656), 1,
      sym_VBAR,
    ACTIONS(658), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(195), 1,
      sym__widentifier,
    STATE(349), 1,
      sym_constterm,
    ACTIONS(648), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(650), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(313), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16844] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(646), 1,
      sym_AT,
    ACTIONS(652), 1,
      sym_LPAREN,
    ACTIONS(656), 1,
      sym_VBAR,
    ACTIONS(658), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(195), 1,
      sym__widentifier,
    STATE(311), 1,
      sym_constterm,
    ACTIONS(648), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(650), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(313), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16898] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(646), 1,
      sym_AT,
    ACTIONS(652), 1,
      sym_LPAREN,
    ACTIONS(656), 1,
      sym_VBAR,
    ACTIONS(658), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(195), 1,
      sym__widentifier,
    STATE(325), 1,
      sym_constterm,
    ACTIONS(648), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(650), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(313), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [16952] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(646), 1,
      sym_AT,
    ACTIONS(652), 1,
      sym_LPAREN,
    ACTIONS(656), 1,
      sym_VBAR,
    ACTIONS(658), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(195), 1,
      sym__widentifier,
    STATE(327), 1,
      sym_constterm,
    ACTIONS(648), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(650), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(313), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [17006] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(646), 1,
      sym_AT,
    ACTIONS(652), 1,
      sym_LPAREN,
    ACTIONS(656), 1,
      sym_VBAR,
    ACTIONS(658), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(195), 1,
      sym__widentifier,
    STATE(322), 1,
      sym_constterm,
    ACTIONS(648), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(650), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(313), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [17060] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(646), 1,
      sym_AT,
    ACTIONS(652), 1,
      sym_LPAREN,
    ACTIONS(656), 1,
      sym_VBAR,
    ACTIONS(658), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(195), 1,
      sym__widentifier,
    STATE(326), 1,
      sym_constterm,
    ACTIONS(648), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(650), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(313), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [17114] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(646), 1,
      sym_AT,
    ACTIONS(652), 1,
      sym_LPAREN,
    ACTIONS(656), 1,
      sym_VBAR,
    ACTIONS(658), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(195), 1,
      sym__widentifier,
    STATE(354), 1,
      sym_constterm,
    ACTIONS(648), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(650), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(313), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [17168] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(646), 1,
      sym_AT,
    ACTIONS(652), 1,
      sym_LPAREN,
    ACTIONS(656), 1,
      sym_VBAR,
    ACTIONS(658), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(195), 1,
      sym__widentifier,
    STATE(340), 1,
      sym_constterm,
    ACTIONS(648), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(650), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(313), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [17222] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(646), 1,
      sym_AT,
    ACTIONS(652), 1,
      sym_LPAREN,
    ACTIONS(656), 1,
      sym_VBAR,
    ACTIONS(658), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(195), 1,
      sym__widentifier,
    STATE(324), 1,
      sym_constterm,
    ACTIONS(648), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(650), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(313), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [17276] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(646), 1,
      sym_AT,
    ACTIONS(652), 1,
      sym_LPAREN,
    ACTIONS(656), 1,
      sym_VBAR,
    ACTIONS(658), 1,
      sym_identifier,
    STATE(32), 1,
      sym_dec,
    STATE(195), 1,
      sym__widentifier,
    STATE(319), 1,
      sym_constterm,
    ACTIONS(648), 2,
      sym_BNOT,
      sym_SUB,
    ACTIONS(650), 2,
      sym_INFIMUM,
      sym_SUPREMUM,
    STATE(313), 2,
      sym_NUMBER,
      sym_STRING,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [17330] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(732), 17,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [17357] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(736), 17,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [17384] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(742), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(740), 17,
      sym_AT,
      sym_BNOT,
      sym_COMMA,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SEM,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [17411] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(746), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(744), 16,
      sym_AT,
      sym_BNOT,
      sym_CSP,
      sym_INFIMUM,
      sym_LPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [17437] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    STATE(245), 1,
      sym_cmp,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [17481] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    STATE(232), 1,
      sym_cmp,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [17525] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    STATE(243), 1,
      sym_cmp,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [17569] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 2,
      anon_sym_0,
      sym_ANONYMOUS,
    ACTIONS(748), 16,
      sym_AT,
      sym_BNOT,
      sym_INFIMUM,
      sym_LPAREN,
      sym_RPAREN,
      sym_SUB,
      sym_SUPREMUM,
      sym_VBAR,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_identifier,
      sym_VARIABLE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [17595] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 3,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(752), 15,
      sym_COMMA,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_RBRACE,
      sym_SUPREMUM,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [17621] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    STATE(241), 1,
      sym_cmp,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(360), 3,
      sym_EQ,
      sym_GT,
      sym_LT,
    ACTIONS(368), 4,
      sym_GEQ,
      sym_LEQ,
      sym_NEQ,
      anon_sym_EQ_EQ,
  [17665] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      sym_AND,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(554), 1,
      sym_MUL,
    ACTIONS(556), 1,
      sym_POW,
    ACTIONS(558), 1,
      sym_QUESTION,
    ACTIONS(562), 1,
      sym_XOR,
    ACTIONS(548), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(560), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(756), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(758), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17705] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 3,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(760), 13,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_SUPREMUM,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [17729] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      sym_AND,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(554), 1,
      sym_MUL,
    ACTIONS(556), 1,
      sym_POW,
    ACTIONS(558), 1,
      sym_QUESTION,
    ACTIONS(562), 1,
      sym_XOR,
    ACTIONS(548), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(560), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(764), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(766), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17769] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      sym_AND,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(554), 1,
      sym_MUL,
    ACTIONS(556), 1,
      sym_POW,
    ACTIONS(558), 1,
      sym_QUESTION,
    ACTIONS(562), 1,
      sym_XOR,
    ACTIONS(548), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(560), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(768), 2,
      sym_COLON,
      sym_DOT,
    ACTIONS(770), 4,
      sym_COMMA,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [17809] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(772), 6,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
  [17847] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(774), 6,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_SEM,
  [17885] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(776), 1,
      sym_AT,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(778), 5,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_SEM,
  [17925] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(782), 3,
      anon_sym_0,
      sym_identifier,
      sym_NOT,
    ACTIONS(780), 13,
      sym_INFIMUM,
      sym_LBRACE,
      sym_LBRACK,
      sym_LPAREN,
      sym_SUPREMUM,
      aux_sym_dec_token1,
      sym_hex,
      sym_oct,
      sym_bin,
      sym_VARIABLE,
      sym_THEORY_OP,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
  [17949] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(756), 1,
      sym_DOT,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(758), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [17988] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(784), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(786), 12,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [18011] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 1,
      sym_AND,
    ACTIONS(790), 1,
      sym_RBRACE,
    STATE(677), 1,
      sym_theory_definition_identifier,
    STATE(678), 1,
      sym_theory_definition_nlist,
    STATE(620), 2,
      sym_theory_term_definition,
      sym_theory_atom_definition,
    ACTIONS(792), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [18042] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(764), 1,
      sym_DOT,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(766), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [18081] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(768), 1,
      sym_DOT,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(770), 4,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [18120] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(796), 12,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [18143] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(798), 5,
      sym_COLON,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_SEM,
  [18180] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(804), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(800), 3,
      sym_COLON,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(802), 9,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [18204] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(808), 1,
      sym_MUL,
    ACTIONS(806), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [18228] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(812), 1,
      sym_MUL,
    ACTIONS(810), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [18252] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 1,
      sym_AND,
    STATE(677), 1,
      sym_theory_definition_identifier,
    STATE(702), 1,
      sym_theory_definition_nlist,
    STATE(620), 2,
      sym_theory_term_definition,
      sym_theory_atom_definition,
    ACTIONS(792), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [18280] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 1,
      sym_MUL,
    ACTIONS(818), 1,
      sym_XOR,
    ACTIONS(814), 11,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [18303] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 1,
      sym_MUL,
    ACTIONS(814), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [18324] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(812), 1,
      sym_MUL,
    ACTIONS(810), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [18345] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(808), 1,
      sym_MUL,
    ACTIONS(806), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [18366] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 1,
      sym_COLON,
    STATE(142), 1,
      sym_csp_rel,
    ACTIONS(826), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(824), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
    ACTIONS(822), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_SEM,
      sym_VBAR,
  [18393] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(796), 11,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [18414] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(830), 1,
      sym_DOT,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(828), 2,
      sym_COMMA,
      sym_SEM,
  [18451] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(800), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(832), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(802), 9,
      sym_COLON,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [18474] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      sym_XOR,
    ACTIONS(836), 1,
      sym_AND,
    ACTIONS(840), 1,
      sym_MUL,
    ACTIONS(842), 1,
      sym_POW,
    ACTIONS(844), 1,
      sym_QUESTION,
    ACTIONS(834), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(838), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(806), 4,
      sym_COMMA,
      sym_DOT,
      sym_RPAREN,
      sym_VBAR,
  [18507] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(784), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(786), 11,
      sym_COLON,
      sym_COMMA,
      sym_CSP_ADD,
      sym_CSP_SUB,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [18528] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      sym_MUL,
    ACTIONS(846), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [18549] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 1,
      sym_MUL,
    ACTIONS(818), 1,
      sym_XOR,
    ACTIONS(844), 1,
      sym_QUESTION,
    ACTIONS(814), 10,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [18574] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(852), 1,
      sym_DOT,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(850), 2,
      sym_COMMA,
      sym_SEM,
  [18611] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 1,
      sym_MUL,
    ACTIONS(814), 12,
      sym_ADD,
      sym_AND,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_QUESTION,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
      sym_XOR,
  [18632] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      sym_XOR,
    ACTIONS(836), 1,
      sym_AND,
    ACTIONS(840), 1,
      sym_MUL,
    ACTIONS(842), 1,
      sym_POW,
    ACTIONS(844), 1,
      sym_QUESTION,
    ACTIONS(834), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(838), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(814), 4,
      sym_COMMA,
      sym_DOT,
      sym_RPAREN,
      sym_VBAR,
  [18665] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 1,
      sym_MUL,
    ACTIONS(818), 1,
      sym_XOR,
    ACTIONS(836), 1,
      sym_AND,
    ACTIONS(844), 1,
      sym_QUESTION,
    ACTIONS(814), 9,
      sym_ADD,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_SUB,
      sym_VBAR,
  [18692] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 1,
      sym_MUL,
    ACTIONS(818), 1,
      sym_XOR,
    ACTIONS(836), 1,
      sym_AND,
    ACTIONS(844), 1,
      sym_QUESTION,
    ACTIONS(834), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(814), 7,
      sym_COMMA,
      sym_DOT,
      sym_MOD,
      sym_POW,
      sym_RPAREN,
      sym_SLASH,
      sym_VBAR,
  [18721] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(854), 2,
      sym_RPAREN,
      sym_SEM,
  [18755] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      sym_AND,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(554), 1,
      sym_MUL,
    ACTIONS(556), 1,
      sym_POW,
    ACTIONS(558), 1,
      sym_QUESTION,
    ACTIONS(562), 1,
      sym_XOR,
    ACTIONS(828), 1,
      sym_IF,
    ACTIONS(830), 1,
      sym_DOT,
    ACTIONS(548), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(560), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18791] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(800), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(856), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(802), 8,
      sym_COMMA,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [18813] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(858), 2,
      sym_SEM,
      sym_VBAR,
  [18847] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(130), 1,
      sym_csp_rel,
    ACTIONS(826), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(824), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
    ACTIONS(822), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [18871] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(860), 2,
      sym_RPAREN,
      sym_SEM,
  [18905] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(862), 1,
      sym_AT,
    ACTIONS(864), 1,
      sym_COMMA,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18941] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(866), 1,
      sym_COLON,
    ACTIONS(868), 1,
      sym_DOT,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [18977] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
    ACTIONS(870), 2,
      sym_SEM,
      sym_VBAR,
  [19011] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(872), 1,
      sym_COLON,
    ACTIONS(874), 1,
      sym_DOT,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [19047] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      sym_AND,
    ACTIONS(552), 1,
      sym_DOTS,
    ACTIONS(554), 1,
      sym_MUL,
    ACTIONS(556), 1,
      sym_POW,
    ACTIONS(558), 1,
      sym_QUESTION,
    ACTIONS(562), 1,
      sym_XOR,
    ACTIONS(850), 1,
      sym_IF,
    ACTIONS(852), 1,
      sym_DOT,
    ACTIONS(548), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(560), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [19083] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(876), 1,
      sym_COMMA,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [19116] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      sym_XOR,
    ACTIONS(836), 1,
      sym_AND,
    ACTIONS(840), 1,
      sym_MUL,
    ACTIONS(842), 1,
      sym_POW,
    ACTIONS(844), 1,
      sym_QUESTION,
    ACTIONS(834), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(838), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(878), 2,
      sym_COMMA,
      sym_RPAREN,
  [19147] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      sym_XOR,
    ACTIONS(836), 1,
      sym_AND,
    ACTIONS(840), 1,
      sym_MUL,
    ACTIONS(842), 1,
      sym_POW,
    ACTIONS(844), 1,
      sym_QUESTION,
    ACTIONS(834), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(838), 2,
      sym_MOD,
      sym_SLASH,
    ACTIONS(880), 2,
      sym_COMMA,
      sym_RPAREN,
  [19178] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(882), 1,
      sym_RBRACK,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [19211] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(161), 1,
      sym_csp_rel,
    ACTIONS(826), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(822), 4,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
    ACTIONS(824), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [19234] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(884), 1,
      sym_COMMA,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [19267] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(886), 1,
      sym_RBRACK,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [19300] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(888), 1,
      sym_RBRACK,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [19333] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(890), 1,
      sym_RBRACK,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [19366] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      sym_AND,
    ACTIONS(314), 1,
      sym_DOTS,
    ACTIONS(316), 1,
      sym_MUL,
    ACTIONS(318), 1,
      sym_POW,
    ACTIONS(320), 1,
      sym_QUESTION,
    ACTIONS(324), 1,
      sym_XOR,
    ACTIONS(892), 1,
      sym_COMMA,
    ACTIONS(306), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(322), 2,
      sym_SLASH,
      anon_sym_BSLASH_BSLASH,
  [19399] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      sym_VBAR,
    ACTIONS(818), 1,
      sym_XOR,
    ACTIONS(836), 1,
      sym_AND,
    ACTIONS(840), 1,
      sym_MUL,
    ACTIONS(842), 1,
      sym_POW,
    ACTIONS(844), 1,
      sym_QUESTION,
    ACTIONS(834), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(838), 2,
      sym_MOD,
      sym_SLASH,
  [19429] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(691), 1,
      sym_theory_definition_identifier,
    ACTIONS(792), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [19447] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(688), 1,
      sym_theory_definition_identifier,
    ACTIONS(792), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [19465] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(682), 1,
      sym_theory_definition_identifier,
    ACTIONS(792), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [19483] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(710), 1,
      sym_theory_definition_identifier,
    ACTIONS(792), 9,
      sym_ANY,
      sym_UNARY,
      sym_BINARY,
      sym_LEFT,
      sym_RIGHT,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
      sym_identifier,
  [19501] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      sym_XOR,
    ACTIONS(836), 1,
      sym_AND,
    ACTIONS(840), 1,
      sym_MUL,
    ACTIONS(842), 1,
      sym_POW,
    ACTIONS(844), 1,
      sym_QUESTION,
    ACTIONS(894), 1,
      sym_DOT,
    ACTIONS(834), 2,
      sym_ADD,
      sym_SUB,
    ACTIONS(838), 2,
      sym_MOD,
      sym_SLASH,
  [19531] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(130), 1,
      sym_csp_rel,
    ACTIONS(826), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(856), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(824), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [19552] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(142), 1,
      sym_csp_rel,
    ACTIONS(826), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(856), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(824), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [19573] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(161), 1,
      sym_csp_rel,
    ACTIONS(826), 2,
      sym_CSP_LT,
      sym_CSP_GT,
    ACTIONS(856), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(824), 4,
      sym_CSP_LEQ,
      sym_CSP_GEQ,
      sym_CSP_EQ,
      sym_CSP_NEQ,
  [19594] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(270), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(582), 2,
      sym_THEORY_OP,
      sym_NOT,
    ACTIONS(896), 4,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
  [19614] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(270), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(582), 2,
      sym_THEORY_OP,
      sym_NOT,
    ACTIONS(898), 4,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
  [19634] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_THEORY_OP,
    ACTIONS(582), 1,
      sym_NOT,
    STATE(259), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(898), 2,
      sym_COMMA,
      sym_RBRACE,
    ACTIONS(900), 2,
      sym_COLON,
      sym_SEM,
  [19658] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 1,
      sym_COMMA,
    ACTIONS(902), 1,
      sym_COLON,
    STATE(266), 1,
      sym_dsym,
    STATE(588), 1,
      sym_noptcondition,
    ACTIONS(376), 2,
      sym_DOT,
      sym_IF,
    ACTIONS(904), 2,
      sym_SEM,
      sym_VBAR,
  [19682] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_THEORY_OP,
    ACTIONS(582), 1,
      sym_NOT,
    STATE(259), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(896), 2,
      sym_COMMA,
      sym_RBRACE,
    ACTIONS(906), 2,
      sym_COLON,
      sym_SEM,
  [19706] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(32), 1,
      sym_dec,
    STATE(673), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19727] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 1,
      sym_COLON,
    ACTIONS(910), 1,
      sym_COMMA,
    STATE(269), 1,
      sym_dsym,
    ACTIONS(904), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(912), 2,
      sym_DOT,
      sym_IF,
  [19748] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_THEORY_OP,
    ACTIONS(582), 1,
      sym_NOT,
    ACTIONS(914), 1,
      sym_COMMA,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(916), 2,
      sym_DOT,
      sym_SEM,
  [19771] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 1,
      sym_LPAREN,
    ACTIONS(918), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(920), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19788] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_THEORY_OP,
    ACTIONS(582), 1,
      sym_NOT,
    ACTIONS(924), 1,
      sym_COMMA,
    STATE(260), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(926), 2,
      sym_DOT,
      sym_SEM,
  [19811] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 1,
      sym_COLON,
    ACTIONS(930), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19826] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_COLON,
    ACTIONS(344), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 1,
      sym_COLON,
    ACTIONS(822), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19856] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(32), 1,
      sym_dec,
    STATE(685), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19877] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(32), 1,
      sym_dec,
    STATE(708), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19898] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      sym_LPAREN,
    ACTIONS(920), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19913] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      anon_sym_0,
    ACTIONS(65), 1,
      aux_sym_dec_token1,
    STATE(32), 1,
      sym_dec,
    STATE(715), 1,
      sym_NUMBER,
    ACTIONS(67), 3,
      sym_hex,
      sym_oct,
      sym_bin,
  [19934] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(334), 1,
      sym_COLON,
    ACTIONS(336), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19949] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 1,
      sym_COLON,
    ACTIONS(766), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [19964] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(936), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [19978] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(938), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [19990] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 1,
      sym_LBRACE,
    STATE(628), 1,
      sym_theory_atom_type,
    ACTIONS(942), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [20006] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      sym_COLON,
    STATE(585), 1,
      sym_noptcondition,
    ACTIONS(832), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(946), 2,
      sym_RBRACE,
      sym_SEM,
  [20024] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(950), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [20038] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 1,
      sym_RPAREN,
    ACTIONS(952), 1,
      sym_COMMA,
    STATE(270), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(582), 2,
      sym_THEORY_OP,
      sym_NOT,
  [20058] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(954), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(956), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [20072] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      sym_COLON,
    STATE(607), 1,
      sym_noptcondition,
    ACTIONS(832), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(958), 2,
      sym_RBRACE,
      sym_SEM,
  [20090] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(304), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [20104] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(588), 1,
      sym_RPAREN,
    ACTIONS(960), 1,
      sym_COMMA,
    STATE(270), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(582), 2,
      sym_THEORY_OP,
      sym_NOT,
  [20124] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 1,
      sym_COLON,
    ACTIONS(964), 1,
      sym_COMMA,
    STATE(501), 1,
      sym_noptimizetuple,
    STATE(634), 1,
      sym_noptimizecond,
    ACTIONS(966), 2,
      sym_RBRACE,
      sym_SEM,
  [20144] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20156] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(290), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(292), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [20170] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      sym_COLON,
    STATE(552), 1,
      sym_noptcondition,
    ACTIONS(832), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(968), 2,
      sym_RBRACE,
      sym_SEM,
  [20188] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 1,
      sym_COLON,
    ACTIONS(964), 1,
      sym_COMMA,
    STATE(468), 1,
      sym_noptimizetuple,
    STATE(598), 1,
      sym_noptimizecond,
    ACTIONS(970), 2,
      sym_RBRACE,
      sym_SEM,
  [20208] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_THEORY_OP,
    ACTIONS(582), 1,
      sym_NOT,
    ACTIONS(972), 1,
      sym_COMMA,
    STATE(196), 1,
      sym_theory_op,
    ACTIONS(974), 2,
      sym_DOT,
      sym_SEM,
  [20228] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(298), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(300), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [20242] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 1,
      sym_LPAREN,
    ACTIONS(920), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(918), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20258] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(978), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [20272] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20284] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(296), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [20298] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(982), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [20312] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(298), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20324] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20336] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 1,
      sym_COLON,
    ACTIONS(964), 1,
      sym_COMMA,
    STATE(458), 1,
      sym_noptimizetuple,
    STATE(577), 1,
      sym_noptimizecond,
    ACTIONS(984), 2,
      sym_RBRACE,
      sym_SEM,
  [20356] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(594), 1,
      sym_RPAREN,
    ACTIONS(986), 1,
      sym_COMMA,
    STATE(270), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(582), 2,
      sym_THEORY_OP,
      sym_NOT,
  [20376] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20388] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_THEORY_OP,
    ACTIONS(582), 1,
      sym_NOT,
    STATE(265), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(916), 2,
      sym_DOT,
      sym_IF,
  [20408] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(290), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20420] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(950), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20432] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(990), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [20444] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 1,
      sym_RBRACE,
    STATE(571), 1,
      sym_theory_operator_definition_nlist,
    STATE(572), 1,
      sym_theory_operator_definition,
    STATE(701), 1,
      sym_theory_op,
    ACTIONS(994), 2,
      sym_THEORY_OP,
      sym_NOT,
  [20464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(996), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [20478] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20490] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(998), 1,
      sym_COMMA,
    STATE(267), 1,
      sym_dsym,
    ACTIONS(904), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(1000), 2,
      sym_DOT,
      sym_IF,
  [20508] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(626), 1,
      sym_RPAREN,
    ACTIONS(1002), 1,
      sym_COMMA,
    STATE(270), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(582), 2,
      sym_THEORY_OP,
      sym_NOT,
  [20528] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 6,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_RBRACE,
      sym_SEM,
      sym_VBAR,
  [20540] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(998), 1,
      sym_COMMA,
    STATE(261), 1,
      sym_dsym,
    ACTIONS(904), 2,
      sym_SEM,
      sym_VBAR,
    ACTIONS(1006), 2,
      sym_DOT,
      sym_IF,
  [20558] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      sym_COLON,
    STATE(560), 1,
      sym_noptcondition,
    ACTIONS(832), 2,
      sym_CSP_ADD,
      sym_CSP_SUB,
    ACTIONS(1008), 2,
      sym_RBRACE,
      sym_SEM,
  [20576] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 1,
      sym_COLON,
    ACTIONS(964), 1,
      sym_COMMA,
    STATE(507), 1,
      sym_noptimizetuple,
    STATE(557), 1,
      sym_noptimizecond,
    ACTIONS(1010), 2,
      sym_RBRACE,
      sym_SEM,
  [20596] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(918), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(920), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [20610] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
    ACTIONS(1014), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
  [20624] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20636] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_THEORY_OP,
    ACTIONS(582), 1,
      sym_NOT,
    STATE(265), 1,
      sym_theory_op_list,
    STATE(299), 1,
      sym_theory_op,
    ACTIONS(926), 2,
      sym_DOT,
      sym_IF,
  [20656] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20668] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(938), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_NOT,
    ACTIONS(1016), 3,
      sym_COLON,
      sym_SEM,
      sym_THEORY_OP,
  [20682] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 6,
      sym_COMMA,
      sym_RBRACE,
      sym_RBRACK,
      sym_RPAREN,
      sym_THEORY_OP,
      sym_NOT,
  [20694] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_THEORY_OP,
    ACTIONS(582), 1,
      sym_NOT,
    ACTIONS(1018), 1,
      sym_COMMA,
    STATE(208), 1,
      sym_theory_op,
    ACTIONS(1020), 2,
      sym_DOT,
      sym_SEM,
  [20714] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1022), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [20725] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_THEORY_OP,
    ACTIONS(582), 1,
      sym_NOT,
    STATE(200), 1,
      sym_theory_op,
    ACTIONS(974), 2,
      sym_DOT,
      sym_IF,
  [20742] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(938), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(1016), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20755] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(954), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20768] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(950), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(948), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20781] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20792] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(290), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(292), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20805] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(296), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20818] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(298), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(300), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20831] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(980), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20844] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(934), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20857] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      sym_RBRACE,
    STATE(549), 1,
      sym_theory_operator_nlist,
    STATE(632), 1,
      sym_theory_op,
    ACTIONS(582), 2,
      sym_THEORY_OP,
      sym_NOT,
  [20874] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(622), 1,
      sym_theory_atom_type,
    ACTIONS(942), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [20887] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1026), 5,
      sym_COMMA,
      sym_DOT,
      sym_IF,
      sym_LBRACE,
      sym_SEM,
  [20898] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(1012), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20911] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(996), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20924] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(344), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20935] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      sym_THEORY_OP,
    ACTIONS(582), 1,
      sym_NOT,
    STATE(212), 1,
      sym_theory_op,
    ACTIONS(1020), 2,
      sym_DOT,
      sym_IF,
  [20952] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 1,
      sym_NOT,
    ACTIONS(1028), 1,
      sym_LPAREN,
    ACTIONS(918), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [20967] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(918), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [20980] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [20991] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [21002] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      sym_COMMA,
    ACTIONS(1030), 4,
      sym_COLON,
      sym_RBRACE,
      sym_RBRACK,
      sym_SEM,
  [21015] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      sym_COLON,
    ACTIONS(1034), 1,
      sym_COMMA,
    STATE(612), 1,
      sym_noptcondition,
    ACTIONS(398), 2,
      sym_RBRACE,
      sym_SEM,
  [21032] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(569), 1,
      sym_theory_atom_type,
    ACTIONS(942), 4,
      sym_ANY,
      sym_HEAD,
      sym_BODY,
      sym_DIRECTIVE,
  [21045] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 2,
      sym_COMMA,
      sym_NOT,
    ACTIONS(304), 3,
      sym_DOT,
      sym_SEM,
      sym_THEORY_OP,
  [21058] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      sym_COLON,
    ACTIONS(1032), 1,
      sym_COMMA,
    STATE(600), 1,
      sym_noptcondition,
    ACTIONS(396), 2,
      sym_RBRACE,
      sym_SEM,
  [21075] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 5,
      sym_COLON,
      sym_COMMA,
      sym_DOT,
      sym_RBRACE,
      sym_SEM,
  [21086] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1038), 1,
      anon_sym_DQUOTE,
    STATE(486), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1040), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21100] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1042), 1,
      sym_COLON,
    ACTIONS(1046), 1,
      sym_DOT,
    ACTIONS(1044), 2,
      sym_COMMA,
      sym_SEM,
  [21114] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      sym_COLON,
    STATE(565), 1,
      sym_noptcondition,
    ACTIONS(1048), 2,
      sym_RBRACE,
      sym_SEM,
  [21128] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1050), 1,
      anon_sym_DQUOTE,
    STATE(461), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1052), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21142] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1054), 1,
      anon_sym_SQUOTE,
    STATE(457), 1,
      aux_sym_STRING_repeat2,
    ACTIONS(1056), 2,
      sym_unescaped_single_string_fragment,
      sym_escape_sequence,
  [21156] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 1,
      sym_COLON,
    STATE(623), 1,
      sym_noptimizecond,
    ACTIONS(1059), 2,
      sym_RBRACE,
      sym_SEM,
  [21170] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1061), 1,
      anon_sym_SQUOTE,
    STATE(466), 1,
      aux_sym_STRING_repeat2,
    ACTIONS(1063), 2,
      sym_unescaped_single_string_fragment,
      sym_escape_sequence,
  [21184] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      sym_COLON,
    STATE(554), 1,
      sym_noptcondition,
    ACTIONS(1065), 2,
      sym_RBRACE,
      sym_SEM,
  [21198] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1067), 1,
      anon_sym_DQUOTE,
    STATE(461), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1069), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21212] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      sym_COLON,
    STATE(558), 1,
      sym_noptcondition,
    ACTIONS(1072), 2,
      sym_RBRACE,
      sym_SEM,
  [21226] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1074), 1,
      anon_sym_DQUOTE,
    STATE(498), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1076), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21240] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1061), 1,
      anon_sym_DQUOTE,
    STATE(456), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1078), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21254] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1080), 1,
      sym_SUB,
    ACTIONS(1082), 1,
      sym_identifier,
    STATE(153), 1,
      sym__widentifier,
    STATE(587), 1,
      sym_atom,
  [21270] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1050), 1,
      anon_sym_SQUOTE,
    STATE(457), 1,
      aux_sym_STRING_repeat2,
    ACTIONS(1084), 2,
      sym_unescaped_single_string_fragment,
      sym_escape_sequence,
  [21284] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1086), 1,
      anon_sym_SQUOTE,
    STATE(457), 1,
      aux_sym_STRING_repeat2,
    ACTIONS(1084), 2,
      sym_unescaped_single_string_fragment,
      sym_escape_sequence,
  [21298] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 1,
      sym_COLON,
    STATE(578), 1,
      sym_noptimizecond,
    ACTIONS(1088), 2,
      sym_RBRACE,
      sym_SEM,
  [21312] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1090), 1,
      anon_sym_DQUOTE,
    STATE(461), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1052), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21326] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 1,
      sym_NOT,
    ACTIONS(918), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21338] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1090), 1,
      anon_sym_SQUOTE,
    STATE(457), 1,
      aux_sym_STRING_repeat2,
    ACTIONS(1084), 2,
      sym_unescaped_single_string_fragment,
      sym_escape_sequence,
  [21352] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 1,
      sym_NOT,
    ACTIONS(996), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21364] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 1,
      sym_NOT,
    ACTIONS(934), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21376] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 1,
      sym_NOT,
    ACTIONS(980), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21388] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1094), 1,
      sym_LBRACE,
    ACTIONS(1092), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21400] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      sym_NOT,
    ACTIONS(1012), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21412] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(618), 1,
      sym_theory_operator_definition,
    STATE(701), 1,
      sym_theory_op,
    ACTIONS(994), 2,
      sym_THEORY_OP,
      sym_NOT,
  [21426] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      sym_COLON,
    STATE(619), 1,
      sym_noptcondition,
    ACTIONS(1096), 2,
      sym_RBRACE,
      sym_SEM,
  [21440] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(938), 1,
      sym_NOT,
    ACTIONS(1016), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21452] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1074), 1,
      anon_sym_SQUOTE,
    STATE(504), 1,
      aux_sym_STRING_repeat2,
    ACTIONS(1098), 2,
      sym_unescaped_single_string_fragment,
      sym_escape_sequence,
  [21466] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 1,
      sym_NOT,
    ACTIONS(954), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21478] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(950), 1,
      sym_NOT,
    ACTIONS(948), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21490] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(290), 1,
      sym_NOT,
    ACTIONS(292), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21502] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1100), 1,
      sym_SUB,
    ACTIONS(1102), 1,
      sym_identifier,
    STATE(153), 1,
      sym__widentifier,
    STATE(518), 1,
      sym_atom,
  [21518] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1104), 1,
      anon_sym_SQUOTE,
    STATE(457), 1,
      aux_sym_STRING_repeat2,
    ACTIONS(1084), 2,
      sym_unescaped_single_string_fragment,
      sym_escape_sequence,
  [21532] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1104), 1,
      anon_sym_DQUOTE,
    STATE(461), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1052), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21546] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      sym_NOT,
    ACTIONS(296), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21558] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(298), 1,
      sym_NOT,
    ACTIONS(300), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21570] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      sym_NOT,
    ACTIONS(304), 3,
      sym_DOT,
      sym_IF,
      sym_THEORY_OP,
  [21582] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1038), 1,
      anon_sym_SQUOTE,
    STATE(485), 1,
      aux_sym_STRING_repeat2,
    ACTIONS(1106), 2,
      sym_unescaped_single_string_fragment,
      sym_escape_sequence,
  [21596] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1108), 1,
      anon_sym_SQUOTE,
    STATE(471), 1,
      aux_sym_STRING_repeat2,
    ACTIONS(1110), 2,
      sym_unescaped_single_string_fragment,
      sym_escape_sequence,
  [21610] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(1112), 1,
      sym_SLASH,
    ACTIONS(332), 2,
      sym_COLON,
      sym_DOT,
  [21624] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      sym_COLON,
    STATE(641), 1,
      sym_noptcondition,
    ACTIONS(1114), 2,
      sym_RBRACE,
      sym_SEM,
  [21638] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1080), 1,
      sym_SUB,
    ACTIONS(1082), 1,
      sym_identifier,
    STATE(153), 1,
      sym__widentifier,
    STATE(523), 1,
      sym_atom,
  [21654] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1108), 1,
      anon_sym_DQUOTE,
    STATE(469), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1116), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21668] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(1118), 1,
      sym_SLASH,
    ACTIONS(336), 2,
      sym_COLON,
      sym_DOT,
  [21682] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      anon_sym_DQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(1120), 1,
      sym_LT,
    STATE(664), 1,
      sym_STRING,
  [21698] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1122), 1,
      anon_sym_DQUOTE,
    STATE(461), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1052), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21712] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      sym_COLON,
    STATE(592), 1,
      sym_noptcondition,
    ACTIONS(1124), 2,
      sym_RBRACE,
      sym_SEM,
  [21726] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1042), 1,
      sym_COLON,
    ACTIONS(1128), 1,
      sym_DOT,
    ACTIONS(1126), 2,
      sym_COMMA,
      sym_SEM,
  [21740] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 1,
      sym_COLON,
    STATE(597), 1,
      sym_noptimizecond,
    ACTIONS(1130), 2,
      sym_RBRACE,
      sym_SEM,
  [21754] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1132), 1,
      anon_sym_DQUOTE,
    STATE(508), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1134), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21768] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1132), 1,
      anon_sym_SQUOTE,
    STATE(467), 1,
      aux_sym_STRING_repeat2,
    ACTIONS(1136), 2,
      sym_unescaped_single_string_fragment,
      sym_escape_sequence,
  [21782] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1122), 1,
      anon_sym_SQUOTE,
    STATE(457), 1,
      aux_sym_STRING_repeat2,
    ACTIONS(1084), 2,
      sym_unescaped_single_string_fragment,
      sym_escape_sequence,
  [21796] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      sym_COLON,
    STATE(599), 1,
      sym_noptcondition,
    ACTIONS(1138), 2,
      sym_RBRACE,
      sym_SEM,
  [21810] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1140), 1,
      anon_sym_DQUOTE,
    STATE(510), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1142), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21824] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 1,
      sym_COLON,
    STATE(635), 1,
      sym_noptimizecond,
    ACTIONS(1144), 2,
      sym_RBRACE,
      sym_SEM,
  [21838] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1086), 1,
      anon_sym_DQUOTE,
    STATE(461), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1052), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21852] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1140), 1,
      anon_sym_SQUOTE,
    STATE(511), 1,
      aux_sym_STRING_repeat2,
    ACTIONS(1146), 2,
      sym_unescaped_single_string_fragment,
      sym_escape_sequence,
  [21866] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1148), 1,
      anon_sym_DQUOTE,
    STATE(461), 1,
      aux_sym_STRING_repeat1,
    ACTIONS(1052), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [21880] = 4,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1148), 1,
      anon_sym_SQUOTE,
    STATE(457), 1,
      aux_sym_STRING_repeat2,
    ACTIONS(1084), 2,
      sym_unescaped_single_string_fragment,
      sym_escape_sequence,
  [21894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      sym_COMMA,
    ACTIONS(1150), 2,
      sym_RPAREN,
      sym_SEM,
  [21905] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21914] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1152), 1,
      sym_identifier,
    STATE(164), 1,
      sym__widentifier,
    STATE(475), 1,
      sym_theory_atom_name,
  [21927] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 1,
      sym_RPAREN,
    ACTIONS(1154), 1,
      sym_identifier,
    STATE(624), 1,
      sym_nidlist,
  [21940] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(392), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [21949] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1128), 1,
      sym_DOT,
    ACTIONS(1126), 2,
      sym_COMMA,
      sym_SEM,
  [21960] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1156), 1,
      sym_COLON,
    ACTIONS(1158), 1,
      sym_DOT,
    STATE(23), 1,
      sym_bodyconddot,
  [21973] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1160), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [21982] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      sym_identifier,
    ACTIONS(1162), 2,
      sym_CSP,
      sym_SUB,
  [21993] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1168), 1,
      sym_DOT,
    ACTIONS(1166), 2,
      sym_COMMA,
      sym_SEM,
  [22004] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(336), 2,
      sym_COLON,
      sym_DOT,
  [22015] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1156), 1,
      sym_COLON,
    ACTIONS(1158), 1,
      sym_DOT,
    STATE(705), 1,
      sym_bodyconddot,
  [22028] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1170), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [22037] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(394), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [22046] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1172), 1,
      sym_COMMA,
    ACTIONS(1174), 2,
      sym_DOT,
      sym_SEM,
  [22057] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1172), 1,
      sym_COMMA,
    ACTIONS(1000), 2,
      sym_RBRACE,
      sym_SEM,
  [22068] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1176), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [22077] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1178), 1,
      sym_COMMA,
    ACTIONS(1180), 2,
      sym_RBRACE,
      sym_SEM,
  [22088] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1156), 1,
      sym_COLON,
    ACTIONS(1158), 1,
      sym_DOT,
    STATE(25), 1,
      sym_bodyconddot,
  [22101] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1182), 1,
      sym_LBRACE,
    ACTIONS(1092), 2,
      sym_DOT,
      sym_IF,
  [22112] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1152), 1,
      sym_identifier,
    STATE(164), 1,
      sym__widentifier,
    STATE(531), 1,
      sym_theory_atom_name,
  [22125] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(964), 1,
      sym_COMMA,
    ACTIONS(1184), 1,
      sym_RBRACK,
    STATE(687), 1,
      sym_noptimizetuple,
  [22138] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 3,
      sym_COMMA,
      sym_LBRACE,
      sym_SLASH,
  [22147] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1190), 1,
      sym_DOT,
    ACTIONS(1188), 2,
      sym_COMMA,
      sym_SEM,
  [22158] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1046), 1,
      sym_DOT,
    ACTIONS(1044), 2,
      sym_COMMA,
      sym_SEM,
  [22169] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1192), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [22178] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      sym_COMMA,
    ACTIONS(1194), 2,
      sym_RPAREN,
      sym_SEM,
  [22189] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_LPAREN,
    ACTIONS(332), 2,
      sym_COLON,
      sym_DOT,
  [22200] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(556), 1,
      sym_theory_op,
    ACTIONS(582), 2,
      sym_THEORY_OP,
      sym_NOT,
  [22211] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1196), 3,
      sym_DOT,
      sym_IF,
      sym_SEM,
  [22220] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1198), 1,
      sym_COMMA,
    ACTIONS(1200), 2,
      sym_RPAREN,
      sym_SEM,
  [22231] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1172), 1,
      sym_COMMA,
    ACTIONS(1202), 2,
      sym_RBRACE,
      sym_SEM,
  [22242] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1204), 3,
      sym_COMMA,
      sym_RBRACE,
      sym_SEM,
  [22251] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 3,
      sym_COMMA,
      sym_DOT,
      sym_SEM,
  [22260] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1172), 1,
      sym_COMMA,
    ACTIONS(1208), 2,
      sym_RBRACE,
      sym_SEM,
  [22271] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(594), 1,
      sym_RBRACK,
    ACTIONS(1210), 1,
      sym_COMMA,
  [22281] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1212), 1,
      sym_RPAREN,
    ACTIONS(1214), 1,
      sym_SEM,
  [22291] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1216), 1,
      sym_COMMA,
    ACTIONS(1218), 1,
      sym_RBRACE,
  [22301] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1220), 1,
      sym_identifier,
    STATE(186), 1,
      sym__widentifier,
  [22311] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 2,
      sym_RBRACE,
      sym_SEM,
  [22319] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1224), 2,
      sym_RBRACE,
      sym_SEM,
  [22327] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(508), 1,
      sym_SEM,
    ACTIONS(1226), 1,
      sym_RPAREN,
  [22337] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1228), 2,
      sym_RBRACE,
      sym_SEM,
  [22345] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1230), 1,
      sym_RPAREN,
    ACTIONS(1232), 1,
      sym_SEM,
  [22355] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1234), 2,
      sym_COMMA,
      sym_RBRACE,
  [22363] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1144), 2,
      sym_RBRACE,
      sym_SEM,
  [22371] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 2,
      sym_RBRACE,
      sym_SEM,
  [22379] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      sym_COMMA,
    ACTIONS(1236), 1,
      sym_COLON,
  [22389] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 2,
      sym_RBRACE,
      sym_SEM,
  [22397] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 1,
      sym_RBRACE,
    ACTIONS(1238), 1,
      sym_SEM,
  [22407] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1210), 1,
      sym_COMMA,
    ACTIONS(1240), 1,
      sym_RPAREN,
  [22417] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1200), 2,
      sym_RPAREN,
      sym_SEM,
  [22425] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      sym_RBRACE,
    ACTIONS(1242), 1,
      sym_SEM,
  [22435] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1072), 2,
      sym_RBRACE,
      sym_SEM,
  [22443] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1244), 1,
      sym_RPAREN,
    ACTIONS(1246), 1,
      sym_SEM,
  [22453] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1214), 1,
      sym_SEM,
    ACTIONS(1248), 1,
      sym_RPAREN,
  [22463] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_SEM,
    ACTIONS(1046), 1,
      sym_DOT,
  [22473] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1250), 2,
      sym_RBRACE,
      sym_SEM,
  [22481] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1210), 1,
      sym_COMMA,
    ACTIONS(1252), 1,
      sym_RPAREN,
  [22491] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1254), 1,
      sym_RBRACE,
    ACTIONS(1256), 1,
      sym_SEM,
  [22501] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1258), 2,
      sym_RBRACE,
      sym_SEM,
  [22509] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      sym_RPAREN,
    ACTIONS(1210), 1,
      sym_COMMA,
  [22519] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1260), 2,
      sym_RBRACE,
      sym_SEM,
  [22527] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1262), 2,
      sym_COMMA,
      sym_RPAREN,
  [22535] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(588), 1,
      sym_RBRACK,
    ACTIONS(1210), 1,
      sym_COMMA,
  [22545] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1059), 2,
      sym_RBRACE,
      sym_SEM,
  [22553] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1264), 2,
      sym_RBRACE,
      sym_SEM,
  [22561] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(588), 1,
      sym_RBRACE,
    ACTIONS(1210), 1,
      sym_COMMA,
  [22571] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(432), 2,
      sym_DOT,
      sym_IF,
  [22579] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1162), 1,
      sym_SUB,
    ACTIONS(1164), 1,
      sym_identifier,
  [22589] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      sym_COMMA,
    ACTIONS(1266), 1,
      sym_COLON,
  [22599] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1268), 2,
      sym_RBRACE,
      sym_SEM,
  [22607] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1270), 1,
      sym_RBRACE,
    ACTIONS(1272), 1,
      sym_SEM,
  [22617] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 2,
      sym_RBRACE,
      sym_SEM,
  [22625] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1274), 2,
      sym_DEFAULT,
      sym_OVERRIDE,
  [22633] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1276), 1,
      sym_COLON,
    ACTIONS(1278), 1,
      sym_DOT,
  [22643] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1006), 2,
      sym_DOT,
      sym_IF,
  [22651] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1280), 2,
      sym_RBRACE,
      sym_SEM,
  [22659] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1282), 2,
      sym_RBRACE,
      sym_SEM,
  [22667] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(616), 1,
      sym_RPAREN,
    ACTIONS(1210), 1,
      sym_COMMA,
  [22677] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 2,
      sym_RBRACE,
      sym_SEM,
  [22685] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1284), 1,
      sym_RBRACE,
    ACTIONS(1286), 1,
      sym_SEM,
  [22695] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1210), 1,
      sym_COMMA,
    ACTIONS(1288), 1,
      sym_RPAREN,
  [22705] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(592), 1,
      sym_RPAREN,
    ACTIONS(1210), 1,
      sym_COMMA,
  [22715] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1290), 1,
      sym_RBRACE,
    ACTIONS(1292), 1,
      sym_SEM,
  [22725] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 2,
      sym_RBRACE,
      sym_SEM,
  [22733] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1088), 2,
      sym_RBRACE,
      sym_SEM,
  [22741] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1294), 2,
      sym_RBRACE,
      sym_SEM,
  [22749] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1202), 2,
      sym_RBRACE,
      sym_SEM,
  [22757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1214), 1,
      sym_SEM,
    ACTIONS(1296), 1,
      sym_RPAREN,
  [22767] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1298), 2,
      sym_RBRACE,
      sym_SEM,
  [22775] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(430), 2,
      sym_DOT,
      sym_IF,
  [22783] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(340), 2,
      sym_COLON,
      sym_DOT,
  [22791] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      sym_COMMA,
    ACTIONS(1300), 1,
      sym_COLON,
  [22801] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1302), 1,
      sym_identifier,
    STATE(205), 1,
      sym__widentifier,
  [22811] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(946), 2,
      sym_RBRACE,
      sym_SEM,
  [22819] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 1,
      sym_RBRACK,
    ACTIONS(1210), 1,
      sym_COMMA,
  [22829] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1304), 1,
      sym_COMMA,
    ACTIONS(1306), 1,
      sym_RPAREN,
  [22839] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      sym_RPAREN,
    ACTIONS(1308), 1,
      sym_COMMA,
  [22849] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1310), 1,
      sym_SEM,
    ACTIONS(1312), 1,
      sym_VBAR,
  [22859] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1208), 2,
      sym_RBRACE,
      sym_SEM,
  [22867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 1,
      sym_RBRACE,
    ACTIONS(1210), 1,
      sym_COMMA,
  [22877] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(594), 1,
      sym_RBRACE,
    ACTIONS(1210), 1,
      sym_COMMA,
  [22887] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 1,
      sym_SEM,
    ACTIONS(1128), 1,
      sym_DOT,
  [22897] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1314), 2,
      sym_DOT,
      sym_IF,
  [22905] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(528), 1,
      sym_RBRACE,
    ACTIONS(1286), 1,
      sym_SEM,
  [22915] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1316), 2,
      sym_RBRACE,
      sym_SEM,
  [22923] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1318), 2,
      sym_RBRACE,
      sym_SEM,
  [22931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1320), 1,
      sym_RBRACE,
    ACTIONS(1322), 1,
      sym_SEM,
  [22941] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      sym_RBRACE,
    ACTIONS(1324), 1,
      sym_SEM,
  [22951] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1326), 2,
      sym_RBRACE,
      sym_SEM,
  [22959] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1328), 2,
      sym_RBRACE,
      sym_SEM,
  [22967] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1330), 1,
      sym_COMMA,
    ACTIONS(1332), 1,
      sym_RPAREN,
  [22977] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1334), 2,
      sym_LEFT,
      sym_RIGHT,
  [22985] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1336), 1,
      sym_identifier,
    STATE(160), 1,
      sym__widentifier,
  [22995] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1338), 2,
      sym_RBRACE,
      sym_SEM,
  [23003] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1340), 2,
      sym_RBRACE,
      sym_SEM,
  [23011] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1342), 1,
      sym_identifier,
    STATE(179), 1,
      sym__widentifier,
  [23021] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1344), 2,
      sym_COMMA,
      sym_RPAREN,
  [23029] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1346), 2,
      sym_RBRACE,
      sym_SEM,
  [23037] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1348), 2,
      sym_COMMA,
      sym_RBRACE,
  [23045] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1214), 1,
      sym_SEM,
    ACTIONS(1350), 1,
      sym_RPAREN,
  [23055] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1130), 2,
      sym_RBRACE,
      sym_SEM,
  [23063] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(970), 2,
      sym_RBRACE,
      sym_SEM,
  [23071] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 2,
      sym_DOT,
      sym_IF,
  [23079] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1214), 1,
      sym_SEM,
    ACTIONS(1352), 1,
      sym_RPAREN,
  [23089] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(214), 1,
      sym_DOT,
    ACTIONS(1354), 1,
      sym_LPAREN,
  [23099] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(198), 1,
      sym_DOT,
    ACTIONS(1356), 1,
      sym_IF,
  [23109] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 2,
      sym_DOT,
      sym_IF,
  [23117] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1358), 2,
      sym_RBRACE,
      sym_SEM,
  [23125] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(612), 1,
      sym_RPAREN,
    ACTIONS(1214), 1,
      sym_SEM,
  [23135] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1310), 1,
      sym_SEM,
    ACTIONS(1360), 1,
      sym_VBAR,
  [23145] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1214), 1,
      sym_SEM,
    ACTIONS(1312), 1,
      sym_RPAREN,
  [23155] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1210), 1,
      sym_COMMA,
    ACTIONS(1362), 1,
      sym_RPAREN,
  [23165] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1364), 1,
      sym_RBRACE,
    ACTIONS(1366), 1,
      sym_SEM,
  [23175] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1214), 1,
      sym_SEM,
    ACTIONS(1368), 1,
      sym_RPAREN,
  [23185] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 1,
      sym_RPAREN,
    ACTIONS(1210), 1,
      sym_COMMA,
  [23195] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1370), 2,
      sym_RBRACE,
      sym_SEM,
  [23203] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(546), 1,
      sym_RBRACE,
    ACTIONS(1372), 1,
      sym_SEM,
  [23213] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1214), 1,
      sym_SEM,
    ACTIONS(1374), 1,
      sym_RPAREN,
  [23223] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1214), 1,
      sym_SEM,
    ACTIONS(1360), 1,
      sym_RPAREN,
  [23233] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1214), 1,
      sym_SEM,
    ACTIONS(1376), 1,
      sym_RPAREN,
  [23243] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1378), 2,
      sym_RBRACE,
      sym_SEM,
  [23251] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1380), 2,
      sym_RBRACE,
      sym_SEM,
  [23259] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      sym_COMMA,
    ACTIONS(1382), 1,
      sym_COLON,
  [23269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1384), 1,
      sym_UNARY,
    ACTIONS(1386), 1,
      sym_BINARY,
  [23279] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1292), 1,
      sym_SEM,
    ACTIONS(1388), 1,
      sym_RBRACE,
  [23289] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      sym_RBRACE,
    ACTIONS(1286), 1,
      sym_SEM,
  [23299] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(626), 1,
      sym_RBRACE,
    ACTIONS(1210), 1,
      sym_COMMA,
  [23309] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(626), 1,
      sym_RBRACK,
    ACTIONS(1210), 1,
      sym_COMMA,
  [23319] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1390), 1,
      sym_identifier,
    STATE(160), 1,
      sym__widentifier,
  [23329] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1392), 1,
      sym_LBRACE,
  [23336] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(214), 1,
      sym_DOT,
  [23343] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1394), 1,
      sym_identifier,
  [23350] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(624), 1,
      sym_CSP,
  [23357] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1396), 1,
      sym_identifier,
  [23364] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1398), 1,
      sym_COMMA,
  [23371] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_LBRACE,
  [23378] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1402), 1,
      sym_identifier,
  [23385] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 1,
      sym_SLASH,
  [23392] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1360), 1,
      sym_RPAREN,
  [23399] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1184), 1,
      sym_DOT,
  [23406] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(546), 1,
      sym_RBRACE,
  [23413] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1404), 1,
      sym_EQ,
  [23420] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1406), 1,
      sym_COMMA,
  [23427] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1408), 1,
      sym_LBRACE,
  [23434] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1332), 1,
      sym_RBRACE,
  [23441] = 2,
    ACTIONS(1036), 1,
      sym_comment,
    ACTIONS(1332), 1,
      sym_CODE,
  [23448] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1410), 1,
      sym_LPAREN,
  [23455] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1412), 1,
      sym_LBRACE,
  [23462] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1414), 1,
      sym_COMMA,
  [23469] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      sym_RPAREN,
  [23476] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(634), 1,
      sym_CSP,
  [23483] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      sym_DOT,
  [23490] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 1,
      sym_identifier,
  [23497] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 1,
      sym_RBRACK,
  [23504] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      sym_SLASH,
  [23511] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 1,
      sym_GT,
  [23518] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1420), 1,
      sym_LPAREN,
  [23525] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1422), 1,
      sym_COMMA,
  [23532] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1424), 1,
      sym_LBRACE,
  [23539] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1426), 1,
      sym_identifier,
  [23546] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1112), 1,
      sym_SLASH,
  [23553] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1428), 1,
      sym_LBRACE,
  [23560] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1430), 1,
      sym_LBRACK,
  [23567] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 1,
      sym_COLON,
  [23574] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1432), 1,
      sym_LBRACE,
  [23581] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1434), 1,
      sym_RPAREN,
  [23588] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1436), 1,
      sym_LBRACE,
  [23595] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1438), 1,
      sym_COLON,
  [23602] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1440), 1,
      sym_RBRACE,
  [23609] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1442), 1,
      sym_LBRACE,
  [23616] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1444), 1,
      sym_identifier,
  [23623] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1446), 1,
      sym_LBRACK,
  [23630] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      sym_RPAREN,
  [23637] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 1,
      sym_RBRACK,
  [23644] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1448), 1,
      sym_COLON,
  [23651] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1450), 1,
      sym_DOT,
  [23658] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1452), 1,
      sym_COMMA,
  [23665] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1454), 1,
      sym_identifier,
  [23672] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1456), 1,
      sym_COMMA,
  [23679] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1458), 1,
      ts_builtin_sym_end,
  [23686] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1312), 1,
      sym_RPAREN,
  [23693] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1460), 1,
      sym_COMMA,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(4)] = 0,
  [SMALL_STATE(5)] = 128,
  [SMALL_STATE(6)] = 256,
  [SMALL_STATE(7)] = 384,
  [SMALL_STATE(8)] = 512,
  [SMALL_STATE(9)] = 569,
  [SMALL_STATE(10)] = 694,
  [SMALL_STATE(11)] = 819,
  [SMALL_STATE(12)] = 876,
  [SMALL_STATE(13)] = 931,
  [SMALL_STATE(14)] = 988,
  [SMALL_STATE(15)] = 1043,
  [SMALL_STATE(16)] = 1098,
  [SMALL_STATE(17)] = 1153,
  [SMALL_STATE(18)] = 1208,
  [SMALL_STATE(19)] = 1333,
  [SMALL_STATE(20)] = 1388,
  [SMALL_STATE(21)] = 1442,
  [SMALL_STATE(22)] = 1496,
  [SMALL_STATE(23)] = 1550,
  [SMALL_STATE(24)] = 1604,
  [SMALL_STATE(25)] = 1658,
  [SMALL_STATE(26)] = 1712,
  [SMALL_STATE(27)] = 1766,
  [SMALL_STATE(28)] = 1820,
  [SMALL_STATE(29)] = 1939,
  [SMALL_STATE(30)] = 1991,
  [SMALL_STATE(31)] = 2043,
  [SMALL_STATE(32)] = 2093,
  [SMALL_STATE(33)] = 2143,
  [SMALL_STATE(34)] = 2193,
  [SMALL_STATE(35)] = 2243,
  [SMALL_STATE(36)] = 2308,
  [SMALL_STATE(37)] = 2359,
  [SMALL_STATE(38)] = 2414,
  [SMALL_STATE(39)] = 2471,
  [SMALL_STATE(40)] = 2536,
  [SMALL_STATE(41)] = 2595,
  [SMALL_STATE(42)] = 2648,
  [SMALL_STATE(43)] = 2697,
  [SMALL_STATE(44)] = 2746,
  [SMALL_STATE(45)] = 2795,
  [SMALL_STATE(46)] = 2844,
  [SMALL_STATE(47)] = 2893,
  [SMALL_STATE(48)] = 2947,
  [SMALL_STATE(49)] = 3001,
  [SMALL_STATE(50)] = 3052,
  [SMALL_STATE(51)] = 3103,
  [SMALL_STATE(52)] = 3203,
  [SMALL_STATE(53)] = 3303,
  [SMALL_STATE(54)] = 3355,
  [SMALL_STATE(55)] = 3407,
  [SMALL_STATE(56)] = 3456,
  [SMALL_STATE(57)] = 3553,
  [SMALL_STATE(58)] = 3602,
  [SMALL_STATE(59)] = 3699,
  [SMALL_STATE(60)] = 3776,
  [SMALL_STATE(61)] = 3871,
  [SMALL_STATE(62)] = 3966,
  [SMALL_STATE(63)] = 4043,
  [SMALL_STATE(64)] = 4135,
  [SMALL_STATE(65)] = 4215,
  [SMALL_STATE(66)] = 4307,
  [SMALL_STATE(67)] = 4387,
  [SMALL_STATE(68)] = 4467,
  [SMALL_STATE(69)] = 4559,
  [SMALL_STATE(70)] = 4651,
  [SMALL_STATE(71)] = 4745,
  [SMALL_STATE(72)] = 4837,
  [SMALL_STATE(73)] = 4929,
  [SMALL_STATE(74)] = 5008,
  [SMALL_STATE(75)] = 5087,
  [SMALL_STATE(76)] = 5166,
  [SMALL_STATE(77)] = 5257,
  [SMALL_STATE(78)] = 5342,
  [SMALL_STATE(79)] = 5427,
  [SMALL_STATE(80)] = 5512,
  [SMALL_STATE(81)] = 5597,
  [SMALL_STATE(82)] = 5682,
  [SMALL_STATE(83)] = 5767,
  [SMALL_STATE(84)] = 5852,
  [SMALL_STATE(85)] = 5937,
  [SMALL_STATE(86)] = 6022,
  [SMALL_STATE(87)] = 6098,
  [SMALL_STATE(88)] = 6174,
  [SMALL_STATE(89)] = 6250,
  [SMALL_STATE(90)] = 6326,
  [SMALL_STATE(91)] = 6405,
  [SMALL_STATE(92)] = 6442,
  [SMALL_STATE(93)] = 6521,
  [SMALL_STATE(94)] = 6558,
  [SMALL_STATE(95)] = 6595,
  [SMALL_STATE(96)] = 6632,
  [SMALL_STATE(97)] = 6708,
  [SMALL_STATE(98)] = 6784,
  [SMALL_STATE(99)] = 6819,
  [SMALL_STATE(100)] = 6854,
  [SMALL_STATE(101)] = 6913,
  [SMALL_STATE(102)] = 6986,
  [SMALL_STATE(103)] = 7021,
  [SMALL_STATE(104)] = 7080,
  [SMALL_STATE(105)] = 7153,
  [SMALL_STATE(106)] = 7215,
  [SMALL_STATE(107)] = 7285,
  [SMALL_STATE(108)] = 7355,
  [SMALL_STATE(109)] = 7389,
  [SMALL_STATE(110)] = 7459,
  [SMALL_STATE(111)] = 7495,
  [SMALL_STATE(112)] = 7531,
  [SMALL_STATE(113)] = 7593,
  [SMALL_STATE(114)] = 7663,
  [SMALL_STATE(115)] = 7733,
  [SMALL_STATE(116)] = 7803,
  [SMALL_STATE(117)] = 7873,
  [SMALL_STATE(118)] = 7943,
  [SMALL_STATE(119)] = 7977,
  [SMALL_STATE(120)] = 8047,
  [SMALL_STATE(121)] = 8117,
  [SMALL_STATE(122)] = 8151,
  [SMALL_STATE(123)] = 8184,
  [SMALL_STATE(124)] = 8251,
  [SMALL_STATE(125)] = 8318,
  [SMALL_STATE(126)] = 8367,
  [SMALL_STATE(127)] = 8436,
  [SMALL_STATE(128)] = 8503,
  [SMALL_STATE(129)] = 8536,
  [SMALL_STATE(130)] = 8605,
  [SMALL_STATE(131)] = 8672,
  [SMALL_STATE(132)] = 8739,
  [SMALL_STATE(133)] = 8808,
  [SMALL_STATE(134)] = 8875,
  [SMALL_STATE(135)] = 8944,
  [SMALL_STATE(136)] = 9013,
  [SMALL_STATE(137)] = 9082,
  [SMALL_STATE(138)] = 9151,
  [SMALL_STATE(139)] = 9184,
  [SMALL_STATE(140)] = 9225,
  [SMALL_STATE(141)] = 9292,
  [SMALL_STATE(142)] = 9361,
  [SMALL_STATE(143)] = 9428,
  [SMALL_STATE(144)] = 9467,
  [SMALL_STATE(145)] = 9500,
  [SMALL_STATE(146)] = 9543,
  [SMALL_STATE(147)] = 9592,
  [SMALL_STATE(148)] = 9629,
  [SMALL_STATE(149)] = 9664,
  [SMALL_STATE(150)] = 9733,
  [SMALL_STATE(151)] = 9784,
  [SMALL_STATE(152)] = 9817,
  [SMALL_STATE(153)] = 9886,
  [SMALL_STATE(154)] = 9953,
  [SMALL_STATE(155)] = 9986,
  [SMALL_STATE(156)] = 10053,
  [SMALL_STATE(157)] = 10086,
  [SMALL_STATE(158)] = 10153,
  [SMALL_STATE(159)] = 10222,
  [SMALL_STATE(160)] = 10289,
  [SMALL_STATE(161)] = 10356,
  [SMALL_STATE(162)] = 10423,
  [SMALL_STATE(163)] = 10490,
  [SMALL_STATE(164)] = 10523,
  [SMALL_STATE(165)] = 10590,
  [SMALL_STATE(166)] = 10623,
  [SMALL_STATE(167)] = 10690,
  [SMALL_STATE(168)] = 10757,
  [SMALL_STATE(169)] = 10826,
  [SMALL_STATE(170)] = 10895,
  [SMALL_STATE(171)] = 10946,
  [SMALL_STATE(172)] = 11015,
  [SMALL_STATE(173)] = 11084,
  [SMALL_STATE(174)] = 11151,
  [SMALL_STATE(175)] = 11218,
  [SMALL_STATE(176)] = 11287,
  [SMALL_STATE(177)] = 11351,
  [SMALL_STATE(178)] = 11401,
  [SMALL_STATE(179)] = 11467,
  [SMALL_STATE(180)] = 11531,
  [SMALL_STATE(181)] = 11595,
  [SMALL_STATE(182)] = 11645,
  [SMALL_STATE(183)] = 11709,
  [SMALL_STATE(184)] = 11775,
  [SMALL_STATE(185)] = 11839,
  [SMALL_STATE(186)] = 11903,
  [SMALL_STATE(187)] = 11967,
  [SMALL_STATE(188)] = 12031,
  [SMALL_STATE(189)] = 12097,
  [SMALL_STATE(190)] = 12163,
  [SMALL_STATE(191)] = 12227,
  [SMALL_STATE(192)] = 12289,
  [SMALL_STATE(193)] = 12353,
  [SMALL_STATE(194)] = 12401,
  [SMALL_STATE(195)] = 12462,
  [SMALL_STATE(196)] = 12525,
  [SMALL_STATE(197)] = 12588,
  [SMALL_STATE(198)] = 12649,
  [SMALL_STATE(199)] = 12710,
  [SMALL_STATE(200)] = 12773,
  [SMALL_STATE(201)] = 12836,
  [SMALL_STATE(202)] = 12897,
  [SMALL_STATE(203)] = 12958,
  [SMALL_STATE(204)] = 13007,
  [SMALL_STATE(205)] = 13070,
  [SMALL_STATE(206)] = 13133,
  [SMALL_STATE(207)] = 13164,
  [SMALL_STATE(208)] = 13225,
  [SMALL_STATE(209)] = 13288,
  [SMALL_STATE(210)] = 13349,
  [SMALL_STATE(211)] = 13396,
  [SMALL_STATE(212)] = 13457,
  [SMALL_STATE(213)] = 13520,
  [SMALL_STATE(214)] = 13578,
  [SMALL_STATE(215)] = 13636,
  [SMALL_STATE(216)] = 13694,
  [SMALL_STATE(217)] = 13752,
  [SMALL_STATE(218)] = 13810,
  [SMALL_STATE(219)] = 13868,
  [SMALL_STATE(220)] = 13926,
  [SMALL_STATE(221)] = 13984,
  [SMALL_STATE(222)] = 14042,
  [SMALL_STATE(223)] = 14100,
  [SMALL_STATE(224)] = 14158,
  [SMALL_STATE(225)] = 14216,
  [SMALL_STATE(226)] = 14274,
  [SMALL_STATE(227)] = 14332,
  [SMALL_STATE(228)] = 14390,
  [SMALL_STATE(229)] = 14448,
  [SMALL_STATE(230)] = 14506,
  [SMALL_STATE(231)] = 14564,
  [SMALL_STATE(232)] = 14622,
  [SMALL_STATE(233)] = 14680,
  [SMALL_STATE(234)] = 14738,
  [SMALL_STATE(235)] = 14796,
  [SMALL_STATE(236)] = 14854,
  [SMALL_STATE(237)] = 14912,
  [SMALL_STATE(238)] = 14970,
  [SMALL_STATE(239)] = 15028,
  [SMALL_STATE(240)] = 15086,
  [SMALL_STATE(241)] = 15144,
  [SMALL_STATE(242)] = 15202,
  [SMALL_STATE(243)] = 15260,
  [SMALL_STATE(244)] = 15318,
  [SMALL_STATE(245)] = 15376,
  [SMALL_STATE(246)] = 15434,
  [SMALL_STATE(247)] = 15492,
  [SMALL_STATE(248)] = 15550,
  [SMALL_STATE(249)] = 15608,
  [SMALL_STATE(250)] = 15666,
  [SMALL_STATE(251)] = 15724,
  [SMALL_STATE(252)] = 15782,
  [SMALL_STATE(253)] = 15840,
  [SMALL_STATE(254)] = 15898,
  [SMALL_STATE(255)] = 15958,
  [SMALL_STATE(256)] = 16016,
  [SMALL_STATE(257)] = 16074,
  [SMALL_STATE(258)] = 16132,
  [SMALL_STATE(259)] = 16189,
  [SMALL_STATE(260)] = 16246,
  [SMALL_STATE(261)] = 16303,
  [SMALL_STATE(262)] = 16332,
  [SMALL_STATE(263)] = 16389,
  [SMALL_STATE(264)] = 16446,
  [SMALL_STATE(265)] = 16475,
  [SMALL_STATE(266)] = 16532,
  [SMALL_STATE(267)] = 16561,
  [SMALL_STATE(268)] = 16590,
  [SMALL_STATE(269)] = 16647,
  [SMALL_STATE(270)] = 16676,
  [SMALL_STATE(271)] = 16733,
  [SMALL_STATE(272)] = 16790,
  [SMALL_STATE(273)] = 16844,
  [SMALL_STATE(274)] = 16898,
  [SMALL_STATE(275)] = 16952,
  [SMALL_STATE(276)] = 17006,
  [SMALL_STATE(277)] = 17060,
  [SMALL_STATE(278)] = 17114,
  [SMALL_STATE(279)] = 17168,
  [SMALL_STATE(280)] = 17222,
  [SMALL_STATE(281)] = 17276,
  [SMALL_STATE(282)] = 17330,
  [SMALL_STATE(283)] = 17357,
  [SMALL_STATE(284)] = 17384,
  [SMALL_STATE(285)] = 17411,
  [SMALL_STATE(286)] = 17437,
  [SMALL_STATE(287)] = 17481,
  [SMALL_STATE(288)] = 17525,
  [SMALL_STATE(289)] = 17569,
  [SMALL_STATE(290)] = 17595,
  [SMALL_STATE(291)] = 17621,
  [SMALL_STATE(292)] = 17665,
  [SMALL_STATE(293)] = 17705,
  [SMALL_STATE(294)] = 17729,
  [SMALL_STATE(295)] = 17769,
  [SMALL_STATE(296)] = 17809,
  [SMALL_STATE(297)] = 17847,
  [SMALL_STATE(298)] = 17885,
  [SMALL_STATE(299)] = 17925,
  [SMALL_STATE(300)] = 17949,
  [SMALL_STATE(301)] = 17988,
  [SMALL_STATE(302)] = 18011,
  [SMALL_STATE(303)] = 18042,
  [SMALL_STATE(304)] = 18081,
  [SMALL_STATE(305)] = 18120,
  [SMALL_STATE(306)] = 18143,
  [SMALL_STATE(307)] = 18180,
  [SMALL_STATE(308)] = 18204,
  [SMALL_STATE(309)] = 18228,
  [SMALL_STATE(310)] = 18252,
  [SMALL_STATE(311)] = 18280,
  [SMALL_STATE(312)] = 18303,
  [SMALL_STATE(313)] = 18324,
  [SMALL_STATE(314)] = 18345,
  [SMALL_STATE(315)] = 18366,
  [SMALL_STATE(316)] = 18393,
  [SMALL_STATE(317)] = 18414,
  [SMALL_STATE(318)] = 18451,
  [SMALL_STATE(319)] = 18474,
  [SMALL_STATE(320)] = 18507,
  [SMALL_STATE(321)] = 18528,
  [SMALL_STATE(322)] = 18549,
  [SMALL_STATE(323)] = 18574,
  [SMALL_STATE(324)] = 18611,
  [SMALL_STATE(325)] = 18632,
  [SMALL_STATE(326)] = 18665,
  [SMALL_STATE(327)] = 18692,
  [SMALL_STATE(328)] = 18721,
  [SMALL_STATE(329)] = 18755,
  [SMALL_STATE(330)] = 18791,
  [SMALL_STATE(331)] = 18813,
  [SMALL_STATE(332)] = 18847,
  [SMALL_STATE(333)] = 18871,
  [SMALL_STATE(334)] = 18905,
  [SMALL_STATE(335)] = 18941,
  [SMALL_STATE(336)] = 18977,
  [SMALL_STATE(337)] = 19011,
  [SMALL_STATE(338)] = 19047,
  [SMALL_STATE(339)] = 19083,
  [SMALL_STATE(340)] = 19116,
  [SMALL_STATE(341)] = 19147,
  [SMALL_STATE(342)] = 19178,
  [SMALL_STATE(343)] = 19211,
  [SMALL_STATE(344)] = 19234,
  [SMALL_STATE(345)] = 19267,
  [SMALL_STATE(346)] = 19300,
  [SMALL_STATE(347)] = 19333,
  [SMALL_STATE(348)] = 19366,
  [SMALL_STATE(349)] = 19399,
  [SMALL_STATE(350)] = 19429,
  [SMALL_STATE(351)] = 19447,
  [SMALL_STATE(352)] = 19465,
  [SMALL_STATE(353)] = 19483,
  [SMALL_STATE(354)] = 19501,
  [SMALL_STATE(355)] = 19531,
  [SMALL_STATE(356)] = 19552,
  [SMALL_STATE(357)] = 19573,
  [SMALL_STATE(358)] = 19594,
  [SMALL_STATE(359)] = 19614,
  [SMALL_STATE(360)] = 19634,
  [SMALL_STATE(361)] = 19658,
  [SMALL_STATE(362)] = 19682,
  [SMALL_STATE(363)] = 19706,
  [SMALL_STATE(364)] = 19727,
  [SMALL_STATE(365)] = 19748,
  [SMALL_STATE(366)] = 19771,
  [SMALL_STATE(367)] = 19788,
  [SMALL_STATE(368)] = 19811,
  [SMALL_STATE(369)] = 19826,
  [SMALL_STATE(370)] = 19841,
  [SMALL_STATE(371)] = 19856,
  [SMALL_STATE(372)] = 19877,
  [SMALL_STATE(373)] = 19898,
  [SMALL_STATE(374)] = 19913,
  [SMALL_STATE(375)] = 19934,
  [SMALL_STATE(376)] = 19949,
  [SMALL_STATE(377)] = 19964,
  [SMALL_STATE(378)] = 19978,
  [SMALL_STATE(379)] = 19990,
  [SMALL_STATE(380)] = 20006,
  [SMALL_STATE(381)] = 20024,
  [SMALL_STATE(382)] = 20038,
  [SMALL_STATE(383)] = 20058,
  [SMALL_STATE(384)] = 20072,
  [SMALL_STATE(385)] = 20090,
  [SMALL_STATE(386)] = 20104,
  [SMALL_STATE(387)] = 20124,
  [SMALL_STATE(388)] = 20144,
  [SMALL_STATE(389)] = 20156,
  [SMALL_STATE(390)] = 20170,
  [SMALL_STATE(391)] = 20188,
  [SMALL_STATE(392)] = 20208,
  [SMALL_STATE(393)] = 20228,
  [SMALL_STATE(394)] = 20242,
  [SMALL_STATE(395)] = 20258,
  [SMALL_STATE(396)] = 20272,
  [SMALL_STATE(397)] = 20284,
  [SMALL_STATE(398)] = 20298,
  [SMALL_STATE(399)] = 20312,
  [SMALL_STATE(400)] = 20324,
  [SMALL_STATE(401)] = 20336,
  [SMALL_STATE(402)] = 20356,
  [SMALL_STATE(403)] = 20376,
  [SMALL_STATE(404)] = 20388,
  [SMALL_STATE(405)] = 20408,
  [SMALL_STATE(406)] = 20420,
  [SMALL_STATE(407)] = 20432,
  [SMALL_STATE(408)] = 20444,
  [SMALL_STATE(409)] = 20464,
  [SMALL_STATE(410)] = 20478,
  [SMALL_STATE(411)] = 20490,
  [SMALL_STATE(412)] = 20508,
  [SMALL_STATE(413)] = 20528,
  [SMALL_STATE(414)] = 20540,
  [SMALL_STATE(415)] = 20558,
  [SMALL_STATE(416)] = 20576,
  [SMALL_STATE(417)] = 20596,
  [SMALL_STATE(418)] = 20610,
  [SMALL_STATE(419)] = 20624,
  [SMALL_STATE(420)] = 20636,
  [SMALL_STATE(421)] = 20656,
  [SMALL_STATE(422)] = 20668,
  [SMALL_STATE(423)] = 20682,
  [SMALL_STATE(424)] = 20694,
  [SMALL_STATE(425)] = 20714,
  [SMALL_STATE(426)] = 20725,
  [SMALL_STATE(427)] = 20742,
  [SMALL_STATE(428)] = 20755,
  [SMALL_STATE(429)] = 20768,
  [SMALL_STATE(430)] = 20781,
  [SMALL_STATE(431)] = 20792,
  [SMALL_STATE(432)] = 20805,
  [SMALL_STATE(433)] = 20818,
  [SMALL_STATE(434)] = 20831,
  [SMALL_STATE(435)] = 20844,
  [SMALL_STATE(436)] = 20857,
  [SMALL_STATE(437)] = 20874,
  [SMALL_STATE(438)] = 20887,
  [SMALL_STATE(439)] = 20898,
  [SMALL_STATE(440)] = 20911,
  [SMALL_STATE(441)] = 20924,
  [SMALL_STATE(442)] = 20935,
  [SMALL_STATE(443)] = 20952,
  [SMALL_STATE(444)] = 20967,
  [SMALL_STATE(445)] = 20980,
  [SMALL_STATE(446)] = 20991,
  [SMALL_STATE(447)] = 21002,
  [SMALL_STATE(448)] = 21015,
  [SMALL_STATE(449)] = 21032,
  [SMALL_STATE(450)] = 21045,
  [SMALL_STATE(451)] = 21058,
  [SMALL_STATE(452)] = 21075,
  [SMALL_STATE(453)] = 21086,
  [SMALL_STATE(454)] = 21100,
  [SMALL_STATE(455)] = 21114,
  [SMALL_STATE(456)] = 21128,
  [SMALL_STATE(457)] = 21142,
  [SMALL_STATE(458)] = 21156,
  [SMALL_STATE(459)] = 21170,
  [SMALL_STATE(460)] = 21184,
  [SMALL_STATE(461)] = 21198,
  [SMALL_STATE(462)] = 21212,
  [SMALL_STATE(463)] = 21226,
  [SMALL_STATE(464)] = 21240,
  [SMALL_STATE(465)] = 21254,
  [SMALL_STATE(466)] = 21270,
  [SMALL_STATE(467)] = 21284,
  [SMALL_STATE(468)] = 21298,
  [SMALL_STATE(469)] = 21312,
  [SMALL_STATE(470)] = 21326,
  [SMALL_STATE(471)] = 21338,
  [SMALL_STATE(472)] = 21352,
  [SMALL_STATE(473)] = 21364,
  [SMALL_STATE(474)] = 21376,
  [SMALL_STATE(475)] = 21388,
  [SMALL_STATE(476)] = 21400,
  [SMALL_STATE(477)] = 21412,
  [SMALL_STATE(478)] = 21426,
  [SMALL_STATE(479)] = 21440,
  [SMALL_STATE(480)] = 21452,
  [SMALL_STATE(481)] = 21466,
  [SMALL_STATE(482)] = 21478,
  [SMALL_STATE(483)] = 21490,
  [SMALL_STATE(484)] = 21502,
  [SMALL_STATE(485)] = 21518,
  [SMALL_STATE(486)] = 21532,
  [SMALL_STATE(487)] = 21546,
  [SMALL_STATE(488)] = 21558,
  [SMALL_STATE(489)] = 21570,
  [SMALL_STATE(490)] = 21582,
  [SMALL_STATE(491)] = 21596,
  [SMALL_STATE(492)] = 21610,
  [SMALL_STATE(493)] = 21624,
  [SMALL_STATE(494)] = 21638,
  [SMALL_STATE(495)] = 21654,
  [SMALL_STATE(496)] = 21668,
  [SMALL_STATE(497)] = 21682,
  [SMALL_STATE(498)] = 21698,
  [SMALL_STATE(499)] = 21712,
  [SMALL_STATE(500)] = 21726,
  [SMALL_STATE(501)] = 21740,
  [SMALL_STATE(502)] = 21754,
  [SMALL_STATE(503)] = 21768,
  [SMALL_STATE(504)] = 21782,
  [SMALL_STATE(505)] = 21796,
  [SMALL_STATE(506)] = 21810,
  [SMALL_STATE(507)] = 21824,
  [SMALL_STATE(508)] = 21838,
  [SMALL_STATE(509)] = 21852,
  [SMALL_STATE(510)] = 21866,
  [SMALL_STATE(511)] = 21880,
  [SMALL_STATE(512)] = 21894,
  [SMALL_STATE(513)] = 21905,
  [SMALL_STATE(514)] = 21914,
  [SMALL_STATE(515)] = 21927,
  [SMALL_STATE(516)] = 21940,
  [SMALL_STATE(517)] = 21949,
  [SMALL_STATE(518)] = 21960,
  [SMALL_STATE(519)] = 21973,
  [SMALL_STATE(520)] = 21982,
  [SMALL_STATE(521)] = 21993,
  [SMALL_STATE(522)] = 22004,
  [SMALL_STATE(523)] = 22015,
  [SMALL_STATE(524)] = 22028,
  [SMALL_STATE(525)] = 22037,
  [SMALL_STATE(526)] = 22046,
  [SMALL_STATE(527)] = 22057,
  [SMALL_STATE(528)] = 22068,
  [SMALL_STATE(529)] = 22077,
  [SMALL_STATE(530)] = 22088,
  [SMALL_STATE(531)] = 22101,
  [SMALL_STATE(532)] = 22112,
  [SMALL_STATE(533)] = 22125,
  [SMALL_STATE(534)] = 22138,
  [SMALL_STATE(535)] = 22147,
  [SMALL_STATE(536)] = 22158,
  [SMALL_STATE(537)] = 22169,
  [SMALL_STATE(538)] = 22178,
  [SMALL_STATE(539)] = 22189,
  [SMALL_STATE(540)] = 22200,
  [SMALL_STATE(541)] = 22211,
  [SMALL_STATE(542)] = 22220,
  [SMALL_STATE(543)] = 22231,
  [SMALL_STATE(544)] = 22242,
  [SMALL_STATE(545)] = 22251,
  [SMALL_STATE(546)] = 22260,
  [SMALL_STATE(547)] = 22271,
  [SMALL_STATE(548)] = 22281,
  [SMALL_STATE(549)] = 22291,
  [SMALL_STATE(550)] = 22301,
  [SMALL_STATE(551)] = 22311,
  [SMALL_STATE(552)] = 22319,
  [SMALL_STATE(553)] = 22327,
  [SMALL_STATE(554)] = 22337,
  [SMALL_STATE(555)] = 22345,
  [SMALL_STATE(556)] = 22355,
  [SMALL_STATE(557)] = 22363,
  [SMALL_STATE(558)] = 22371,
  [SMALL_STATE(559)] = 22379,
  [SMALL_STATE(560)] = 22389,
  [SMALL_STATE(561)] = 22397,
  [SMALL_STATE(562)] = 22407,
  [SMALL_STATE(563)] = 22417,
  [SMALL_STATE(564)] = 22425,
  [SMALL_STATE(565)] = 22435,
  [SMALL_STATE(566)] = 22443,
  [SMALL_STATE(567)] = 22453,
  [SMALL_STATE(568)] = 22463,
  [SMALL_STATE(569)] = 22473,
  [SMALL_STATE(570)] = 22481,
  [SMALL_STATE(571)] = 22491,
  [SMALL_STATE(572)] = 22501,
  [SMALL_STATE(573)] = 22509,
  [SMALL_STATE(574)] = 22519,
  [SMALL_STATE(575)] = 22527,
  [SMALL_STATE(576)] = 22535,
  [SMALL_STATE(577)] = 22545,
  [SMALL_STATE(578)] = 22553,
  [SMALL_STATE(579)] = 22561,
  [SMALL_STATE(580)] = 22571,
  [SMALL_STATE(581)] = 22579,
  [SMALL_STATE(582)] = 22589,
  [SMALL_STATE(583)] = 22599,
  [SMALL_STATE(584)] = 22607,
  [SMALL_STATE(585)] = 22617,
  [SMALL_STATE(586)] = 22625,
  [SMALL_STATE(587)] = 22633,
  [SMALL_STATE(588)] = 22643,
  [SMALL_STATE(589)] = 22651,
  [SMALL_STATE(590)] = 22659,
  [SMALL_STATE(591)] = 22667,
  [SMALL_STATE(592)] = 22677,
  [SMALL_STATE(593)] = 22685,
  [SMALL_STATE(594)] = 22695,
  [SMALL_STATE(595)] = 22705,
  [SMALL_STATE(596)] = 22715,
  [SMALL_STATE(597)] = 22725,
  [SMALL_STATE(598)] = 22733,
  [SMALL_STATE(599)] = 22741,
  [SMALL_STATE(600)] = 22749,
  [SMALL_STATE(601)] = 22757,
  [SMALL_STATE(602)] = 22767,
  [SMALL_STATE(603)] = 22775,
  [SMALL_STATE(604)] = 22783,
  [SMALL_STATE(605)] = 22791,
  [SMALL_STATE(606)] = 22801,
  [SMALL_STATE(607)] = 22811,
  [SMALL_STATE(608)] = 22819,
  [SMALL_STATE(609)] = 22829,
  [SMALL_STATE(610)] = 22839,
  [SMALL_STATE(611)] = 22849,
  [SMALL_STATE(612)] = 22859,
  [SMALL_STATE(613)] = 22867,
  [SMALL_STATE(614)] = 22877,
  [SMALL_STATE(615)] = 22887,
  [SMALL_STATE(616)] = 22897,
  [SMALL_STATE(617)] = 22905,
  [SMALL_STATE(618)] = 22915,
  [SMALL_STATE(619)] = 22923,
  [SMALL_STATE(620)] = 22931,
  [SMALL_STATE(621)] = 22941,
  [SMALL_STATE(622)] = 22951,
  [SMALL_STATE(623)] = 22959,
  [SMALL_STATE(624)] = 22967,
  [SMALL_STATE(625)] = 22977,
  [SMALL_STATE(626)] = 22985,
  [SMALL_STATE(627)] = 22995,
  [SMALL_STATE(628)] = 23003,
  [SMALL_STATE(629)] = 23011,
  [SMALL_STATE(630)] = 23021,
  [SMALL_STATE(631)] = 23029,
  [SMALL_STATE(632)] = 23037,
  [SMALL_STATE(633)] = 23045,
  [SMALL_STATE(634)] = 23055,
  [SMALL_STATE(635)] = 23063,
  [SMALL_STATE(636)] = 23071,
  [SMALL_STATE(637)] = 23079,
  [SMALL_STATE(638)] = 23089,
  [SMALL_STATE(639)] = 23099,
  [SMALL_STATE(640)] = 23109,
  [SMALL_STATE(641)] = 23117,
  [SMALL_STATE(642)] = 23125,
  [SMALL_STATE(643)] = 23135,
  [SMALL_STATE(644)] = 23145,
  [SMALL_STATE(645)] = 23155,
  [SMALL_STATE(646)] = 23165,
  [SMALL_STATE(647)] = 23175,
  [SMALL_STATE(648)] = 23185,
  [SMALL_STATE(649)] = 23195,
  [SMALL_STATE(650)] = 23203,
  [SMALL_STATE(651)] = 23213,
  [SMALL_STATE(652)] = 23223,
  [SMALL_STATE(653)] = 23233,
  [SMALL_STATE(654)] = 23243,
  [SMALL_STATE(655)] = 23251,
  [SMALL_STATE(656)] = 23259,
  [SMALL_STATE(657)] = 23269,
  [SMALL_STATE(658)] = 23279,
  [SMALL_STATE(659)] = 23289,
  [SMALL_STATE(660)] = 23299,
  [SMALL_STATE(661)] = 23309,
  [SMALL_STATE(662)] = 23319,
  [SMALL_STATE(663)] = 23329,
  [SMALL_STATE(664)] = 23336,
  [SMALL_STATE(665)] = 23343,
  [SMALL_STATE(666)] = 23350,
  [SMALL_STATE(667)] = 23357,
  [SMALL_STATE(668)] = 23364,
  [SMALL_STATE(669)] = 23371,
  [SMALL_STATE(670)] = 23378,
  [SMALL_STATE(671)] = 23385,
  [SMALL_STATE(672)] = 23392,
  [SMALL_STATE(673)] = 23399,
  [SMALL_STATE(674)] = 23406,
  [SMALL_STATE(675)] = 23413,
  [SMALL_STATE(676)] = 23420,
  [SMALL_STATE(677)] = 23427,
  [SMALL_STATE(678)] = 23434,
  [SMALL_STATE(679)] = 23441,
  [SMALL_STATE(680)] = 23448,
  [SMALL_STATE(681)] = 23455,
  [SMALL_STATE(682)] = 23462,
  [SMALL_STATE(683)] = 23469,
  [SMALL_STATE(684)] = 23476,
  [SMALL_STATE(685)] = 23483,
  [SMALL_STATE(686)] = 23490,
  [SMALL_STATE(687)] = 23497,
  [SMALL_STATE(688)] = 23504,
  [SMALL_STATE(689)] = 23511,
  [SMALL_STATE(690)] = 23518,
  [SMALL_STATE(691)] = 23525,
  [SMALL_STATE(692)] = 23532,
  [SMALL_STATE(693)] = 23539,
  [SMALL_STATE(694)] = 23546,
  [SMALL_STATE(695)] = 23553,
  [SMALL_STATE(696)] = 23560,
  [SMALL_STATE(697)] = 23567,
  [SMALL_STATE(698)] = 23574,
  [SMALL_STATE(699)] = 23581,
  [SMALL_STATE(700)] = 23588,
  [SMALL_STATE(701)] = 23595,
  [SMALL_STATE(702)] = 23602,
  [SMALL_STATE(703)] = 23609,
  [SMALL_STATE(704)] = 23616,
  [SMALL_STATE(705)] = 23623,
  [SMALL_STATE(706)] = 23630,
  [SMALL_STATE(707)] = 23637,
  [SMALL_STATE(708)] = 23644,
  [SMALL_STATE(709)] = 23651,
  [SMALL_STATE(710)] = 23658,
  [SMALL_STATE(711)] = 23665,
  [SMALL_STATE(712)] = 23672,
  [SMALL_STATE(713)] = 23679,
  [SMALL_STATE(714)] = 23686,
  [SMALL_STATE(715)] = 23693,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(711),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(700),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(695),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(700),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(681),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(680),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(667),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(665),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(47),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(690),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [81] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [83] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [85] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(532),
  [88] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(550),
  [91] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(215),
  [94] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(711),
  [97] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(700),
  [100] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(234),
  [103] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(695),
  [106] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(465),
  [109] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(581),
  [112] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(370),
  [115] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(4),
  [118] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(497),
  [121] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(44),
  [124] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(76),
  [127] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(92),
  [130] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(700),
  [133] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(140),
  [136] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(681),
  [139] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(176),
  [142] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(680),
  [145] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(484),
  [148] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(494),
  [151] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(520),
  [154] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(246),
  [157] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(667),
  [160] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(211),
  [163] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(9),
  [166] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(665),
  [169] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(31),
  [172] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(31),
  [175] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(32),
  [178] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(44),
  [181] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(47),
  [184] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(690),
  [187] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(104),
  [190] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(495),
  [193] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(491),
  [196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [206] = {.entry = {.count = 1, .reusable = false}}, SHIFT(54),
  [208] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [216] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 5),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [220] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 5),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 4),
  [224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [226] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 4),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyconddot, 1),
  [230] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyconddot, 1),
  [232] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 3),
  [234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [236] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 3),
  [238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 4),
  [240] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 4),
  [242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 5),
  [244] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 5),
  [246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 2),
  [248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 2),
  [250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodydot, 3),
  [252] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodydot, 3),
  [254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyconddot, 2),
  [256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyconddot, 2),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 7),
  [260] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 7),
  [262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 8),
  [264] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 8),
  [266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [268] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 2),
  [270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 6),
  [272] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 6),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 10),
  [276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 10),
  [278] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 1),
  [282] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 1),
  [284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 2),
  [288] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 2),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dec, 1),
  [292] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dec, 1),
  [294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_NUMBER, 1),
  [296] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_NUMBER, 1),
  [298] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_STRING, 2),
  [300] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_STRING, 2),
  [302] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_STRING, 3),
  [304] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_STRING, 3),
  [306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [310] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 3),
  [312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 3),
  [314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [316] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 4),
  [328] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 4),
  [330] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 1),
  [332] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 1),
  [334] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 2),
  [336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 2),
  [338] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 4),
  [340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 4),
  [342] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_atom, 3),
  [344] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atom, 3),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(663),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [350] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [352] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(698),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [360] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 1),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(684),
  [366] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 1),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [370] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptcondition, 1),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [374] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunction, 2),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 2),
  [382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 1),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [388] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conjunction, 2),
  [390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 2),
  [394] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 3),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelem, 1),
  [398] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element, 1),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [402] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizecond, 1),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(629),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [408] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 1),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [416] = {.entry = {.count = 1, .reusable = false}}, SHIFT(156),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [422] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [430] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 2),
  [432] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 3),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [442] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 4),
  [444] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 4),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [448] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 5),
  [450] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 5),
  [452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 3),
  [454] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 3),
  [456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nbodycomma, 2),
  [458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nbodycomma, 2),
  [460] = {.entry = {.count = 1, .reusable = false}}, SHIFT(69),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [472] = {.entry = {.count = 1, .reusable = false}}, SHIFT(389),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [478] = {.entry = {.count = 1, .reusable = false}}, SHIFT(366),
  [480] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [488] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 4),
  [490] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 4),
  [492] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 2),
  [494] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 2),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [500] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bodyaggregate, 3),
  [502] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggregate, 3),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [506] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [514] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 3),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 3),
  [518] = {.entry = {.count = 1, .reusable = false}}, SHIFT(157),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [522] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [530] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 4),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 4),
  [534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [538] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [540] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headaggregate, 2),
  [542] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggregate, 2),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(709),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [554] = {.entry = {.count = 1, .reusable = false}}, SHIFT(213),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [574] = {.entry = {.count = 1, .reusable = false}}, SHIFT(405),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [580] = {.entry = {.count = 1, .reusable = false}}, SHIFT(373),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(674),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(666),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [620] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 2),
  [622] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 2),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [638] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuple, 2),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [642] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_mul_term, 4),
  [644] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_mul_term, 4),
  [646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [668] = {.entry = {.count = 1, .reusable = false}}, SHIFT(431),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [674] = {.entry = {.count = 1, .reusable = false}}, SHIFT(394),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [688] = {.entry = {.count = 1, .reusable = false}}, SHIFT(483),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [694] = {.entry = {.count = 1, .reusable = false}}, SHIFT(443),
  [696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [702] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cmp, 1),
  [704] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cmp, 1),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [710] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 4),
  [712] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 4),
  [714] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dsym, 1),
  [716] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dsym, 1),
  [718] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 3),
  [720] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 3),
  [722] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 5),
  [724] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 5),
  [726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunctionsep, 2),
  [728] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunctionsep, 2),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [732] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 2),
  [734] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 2),
  [736] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 3),
  [738] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 3),
  [740] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuplevec_sem, 1),
  [742] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuplevec_sem, 1),
  [744] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_rel, 1),
  [746] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_rel, 1),
  [748] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__widentifier, 2),
  [750] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__widentifier, 2),
  [752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op, 1),
  [754] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op, 1),
  [756] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 4),
  [758] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 4),
  [760] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op_list, 2),
  [762] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op_list, 2),
  [764] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 3),
  [766] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 3),
  [768] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 5),
  [770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 5),
  [772] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntermvec, 1),
  [774] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntermvec, 3),
  [776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizeweight, 1),
  [780] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_op_list, 1),
  [782] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_op_list, 1),
  [784] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_add_term, 1),
  [786] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_add_term, 1),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(673),
  [792] = {.entry = {.count = 1, .reusable = false}}, SHIFT(534),
  [794] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_add_term, 3),
  [796] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_add_term, 3),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizeweight, 3),
  [800] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_csp_literal, 3),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_csp_literal, 3),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [806] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 2),
  [808] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 2),
  [810] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 1),
  [812] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 1),
  [814] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 3),
  [816] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 3),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [820] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 1),
  [822] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 1),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [826] = {.entry = {.count = 1, .reusable = false}}, SHIFT(285),
  [828] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nupper, 1),
  [830] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nupper, 1),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [840] = {.entry = {.count = 1, .reusable = false}}, SHIFT(275),
  [842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [846] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 4),
  [848] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constterm, 4),
  [850] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nupper, 2),
  [852] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nupper, 2),
  [854] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binaryargvec, 5),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [858] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unaryargvec, 1),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binaryargvec, 3),
  [862] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [866] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [868] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [870] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unaryargvec, 3),
  [872] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [874] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [876] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [878] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_consttermvec, 3),
  [880] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_consttermvec, 1),
  [882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [888] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [890] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [892] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [894] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [896] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm_nlist, 3),
  [898] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm_nlist, 1),
  [900] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm_nlist, 1),
  [902] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [904] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [906] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm_nlist, 3),
  [908] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [910] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [912] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_head, 1),
  [914] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 7),
  [916] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 7),
  [918] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 1),
  [920] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 1),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [924] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 6),
  [926] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 6),
  [928] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 2),
  [930] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 2),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [934] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 2),
  [936] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 2),
  [938] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 3),
  [940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(631),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [946] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 3),
  [948] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 5),
  [950] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 5),
  [952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [954] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 4),
  [956] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 4),
  [958] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 2),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [962] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [964] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [966] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 1),
  [968] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 5),
  [970] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 3),
  [972] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 4),
  [974] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 4),
  [976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [978] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 1),
  [980] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 2),
  [982] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 2),
  [984] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 3),
  [986] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [988] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_opterm, 1),
  [990] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nlitvec, 1),
  [992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(697),
  [996] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 1),
  [998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [1000] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptcondition, 2),
  [1002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [1004] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nlitvec, 3),
  [1006] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunction, 3),
  [1008] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 4),
  [1010] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 1),
  [1012] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_term, 3),
  [1014] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term, 3),
  [1016] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_opterm, 3),
  [1018] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 5),
  [1020] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_theory_atom, 5),
  [1022] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 2),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(676),
  [1026] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_name, 3),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [1030] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizetuple, 2),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [1034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1036] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [1038] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1048] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 3),
  [1050] = {.entry = {.count = 1, .reusable = false}}, SHIFT(396),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [1054] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_STRING_repeat2, 2),
  [1056] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_STRING_repeat2, 2), SHIFT_REPEAT(457),
  [1059] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 4),
  [1061] = {.entry = {.count = 1, .reusable = false}}, SHIFT(399),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [1065] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 1),
  [1067] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_STRING_repeat1, 2),
  [1069] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_STRING_repeat1, 2), SHIFT_REPEAT(461),
  [1072] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 4),
  [1074] = {.entry = {.count = 1, .reusable = false}}, SHIFT(488),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(626),
  [1082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1086] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [1088] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 4),
  [1090] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [1092] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom, 2),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [1096] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 5),
  [1098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(662),
  [1102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1104] = {.entry = {.count = 1, .reusable = false}}, SHIFT(385),
  [1106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [1108] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [1110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [1114] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelem, 1),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [1120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(704),
  [1122] = {.entry = {.count = 1, .reusable = false}}, SHIFT(489),
  [1124] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 2),
  [1126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1130] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 2),
  [1132] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [1134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [1136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [1138] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 3),
  [1140] = {.entry = {.count = 1, .reusable = false}}, SHIFT(433),
  [1142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [1144] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 2),
  [1146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [1148] = {.entry = {.count = 1, .reusable = false}}, SHIFT(450),
  [1150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argvec, 3),
  [1152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [1154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(630),
  [1156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [1158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 4),
  [1162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(693),
  [1164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(694),
  [1166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1170] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 3),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1174] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conjunction, 3),
  [1176] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizelitvec, 1),
  [1178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [1180] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_noptimizecond, 2),
  [1182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [1186] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_identifier, 1),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1192] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 6),
  [1194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argvec, 1),
  [1196] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjoint, 5),
  [1198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [1200] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuple, 1),
  [1202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelem, 2),
  [1204] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optimizelitvec, 3),
  [1206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lubodyaggregate, 4),
  [1208] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element, 2),
  [1210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(712),
  [1220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition, 7),
  [1224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ncspelemvec, 6),
  [1226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuplevec, 1),
  [1228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 2),
  [1230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ntuplevec, 2),
  [1232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [1234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_nlist, 3),
  [1236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [1238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [1244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [1248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 14),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [1254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(655),
  [1256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [1258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition_nlist, 1),
  [1260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term_definition, 3),
  [1262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nidlist, 3),
  [1264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_maxelemlist, 5),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1268] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelemvec, 3),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [1274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(707),
  [1276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [1278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [1280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element_nlist, 3),
  [1282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_element_nlist, 1),
  [1284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [1290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altheadaggrelemvec, 4),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1298] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 3),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [1302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [1304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [1306] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nconstargvec, 1),
  [1308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [1310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1314] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_luheadaggregate, 4),
  [1316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition_nlist, 3),
  [1318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headaggrelemvec, 6),
  [1320] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_nlist, 1),
  [1322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 13),
  [1328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_minelemlist, 5),
  [1330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(686),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(685),
  [1334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [1336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1338] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelemvec, 1),
  [1340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_definition, 8),
  [1342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [1344] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nidlist, 1),
  [1346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_atom_type, 1),
  [1348] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_nlist, 1),
  [1350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(604),
  [1354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_altbodyaggrelem, 2),
  [1360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [1362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [1364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [1368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [1370] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bodyaggrelemvec, 1),
  [1372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [1374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_operator_definition, 5),
  [1380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_term_definition, 4),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(654),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(668),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(692),
  [1396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(638),
  [1398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(625),
  [1400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(699),
  [1404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [1408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [1412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [1414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [1416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [1418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(670),
  [1422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [1424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [1426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(671),
  [1428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [1430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [1434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(679),
  [1436] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_aggregatefunction, 1),
  [1438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [1440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_theory_definition_nlist, 3),
  [1442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(689),
  [1446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [1454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(675),
  [1456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1458] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(657),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_clingo(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
