#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 362
#define LARGE_STATE_COUNT 14
#define SYMBOL_COUNT 177
#define ALIAS_COUNT 0
#define TOKEN_COUNT 125
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 1

enum {
  sym_end_tok = 1,
  sym_for_tok = 2,
  sym_next_tok = 3,
  sym_data_tok = 4,
  sym_input_tok = 5,
  sym_del_tok = 6,
  sym_dim_tok = 7,
  sym_read_tok = 8,
  sym_gr_tok = 9,
  sym_text_tok = 10,
  sym_prn_tok = 11,
  sym_inn_tok = 12,
  sym_call_tok = 13,
  sym_plot_tok = 14,
  sym_hlin_tok = 15,
  sym_vlin_tok = 16,
  sym_hgr2_tok = 17,
  sym_hgr_tok = 18,
  sym_hcoloreq_tok = 19,
  sym_hplot_tok = 20,
  sym_draw_tok = 21,
  sym_xdraw_tok = 22,
  sym_htab_tok = 23,
  sym_home_tok = 24,
  sym_roteq_tok = 25,
  sym_scaleeq_tok = 26,
  sym_shload_tok = 27,
  sym_trace_tok = 28,
  sym_notrace_tok = 29,
  sym_normal_tok = 30,
  sym_inverse_tok = 31,
  sym_flash_tok = 32,
  sym_coloreq_tok = 33,
  sym_pop_tok = 34,
  sym_vtab_tok = 35,
  sym_himem_tok = 36,
  sym_lomem_tok = 37,
  sym_onerr_tok = 38,
  sym_resume_tok = 39,
  sym_recall_tok = 40,
  sym_store_tok = 41,
  sym_speedeq_tok = 42,
  sym_let_tok = 43,
  sym_goto_tok = 44,
  sym_run_tok = 45,
  sym_if_tok = 46,
  sym_restore_tok = 47,
  sym_amp_tok = 48,
  sym_gosub_tok = 49,
  sym_return_tok = 50,
  sym_rem_tok = 51,
  sym_stop_tok = 52,
  sym_on_tok = 53,
  sym_wait_tok = 54,
  sym_load_tok = 55,
  sym_save_tok = 56,
  sym_def_tok = 57,
  sym_poke_tok = 58,
  sym_print_tok = 59,
  sym_cont_tok = 60,
  sym_list_tok = 61,
  sym_clear_tok = 62,
  sym_get_tok = 63,
  sym_new_tok = 64,
  sym_tabp_tok = 65,
  sym_to_tok = 66,
  sym_fn_tok = 67,
  sym_spcp_tok = 68,
  sym_then_tok = 69,
  sym_at_tok = 70,
  sym_not_tok = 71,
  sym_step_tok = 72,
  sym_plus_tok = 73,
  sym_minus_tok = 74,
  sym_times_tok = 75,
  sym_div_tok = 76,
  sym_pow_tok = 77,
  sym_and_tok = 78,
  sym_or_tok = 79,
  sym_gtr_tok = 80,
  sym_eq_tok = 81,
  sym_less_tok = 82,
  sym_sgn_tok = 83,
  sym_int_tok = 84,
  sym_abs_tok = 85,
  sym_usr_tok = 86,
  sym_fre_tok = 87,
  sym_scrnp_tok = 88,
  sym_pdl_tok = 89,
  sym_pos_tok = 90,
  sym_sqr_tok = 91,
  sym_rnd_tok = 92,
  sym_log_tok = 93,
  sym_exp_tok = 94,
  sym_cos_tok = 95,
  sym_sin_tok = 96,
  sym_tan_tok = 97,
  sym_atn_tok = 98,
  sym_peek_tok = 99,
  sym_len_tok = 100,
  sym_str_tok = 101,
  sym_val_tok = 102,
  sym_asc_tok = 103,
  sym_chr_tok = 104,
  sym_left_tok = 105,
  sym_right_tok = 106,
  sym_mid_tok = 107,
  anon_sym_COMMA = 108,
  anon_sym_LPAREN = 109,
  anon_sym_RPAREN = 110,
  anon_sym_SEMI = 111,
  sym_comment_text = 112,
  anon_sym_COLON = 113,
  sym_linenum = 114,
  aux_sym__newline_token1 = 115,
  sym_integer = 116,
  sym_literal = 117,
  sym_real = 118,
  sym_string = 119,
  sym_terminal_string = 120,
  sym_real_data_item = 121,
  anon_sym_PERCENT = 122,
  anon_sym_DOLLAR = 123,
  sym__ext_name = 124,
  sym_source_file = 125,
  sym_statement = 126,
  sym_terminal_statement = 127,
  sym_assignment = 128,
  sym_fcall = 129,
  sym_sfcall = 130,
  sym_line = 131,
  sym__newline = 132,
  sym__empty_line = 133,
  sym__expr = 134,
  sym__aexpr = 135,
  sym_unary_aexpr = 136,
  sym_binary_aexpr = 137,
  sym__parenthesized_aexpr = 138,
  sym__relop = 139,
  sym__sexpr = 140,
  sym_binary_sexpr = 141,
  sym__parenthesized_sexpr = 142,
  sym__sop = 143,
  sym__var = 144,
  sym__avar = 145,
  sym_intvar = 146,
  sym_realvar = 147,
  sym_svar = 148,
  sym_subscript = 149,
  sym__dim_item = 150,
  sym__data_item = 151,
  sym_fn_name = 152,
  sym_real_scalar = 153,
  sym__real_scalar = 154,
  sym_int_scalar = 155,
  sym__int_scalar = 156,
  sym__string_scalar = 157,
  sym_real_array = 158,
  sym__real_array = 159,
  sym_int_array = 160,
  sym__int_array = 161,
  sym_string_array = 162,
  sym__string_array = 163,
  sym__name = 164,
  aux_sym_source_file_repeat1 = 165,
  aux_sym_statement_repeat1 = 166,
  aux_sym_statement_repeat2 = 167,
  aux_sym_statement_repeat3 = 168,
  aux_sym_statement_repeat4 = 169,
  aux_sym_statement_repeat5 = 170,
  aux_sym_statement_repeat6 = 171,
  aux_sym_statement_repeat7 = 172,
  aux_sym_statement_repeat8 = 173,
  aux_sym_line_repeat1 = 174,
  aux_sym_line_repeat2 = 175,
  aux_sym_subscript_repeat1 = 176,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_end_tok] = "end_tok",
  [sym_for_tok] = "for_tok",
  [sym_next_tok] = "next_tok",
  [sym_data_tok] = "data_tok",
  [sym_input_tok] = "input_tok",
  [sym_del_tok] = "del_tok",
  [sym_dim_tok] = "dim_tok",
  [sym_read_tok] = "read_tok",
  [sym_gr_tok] = "gr_tok",
  [sym_text_tok] = "text_tok",
  [sym_prn_tok] = "prn_tok",
  [sym_inn_tok] = "inn_tok",
  [sym_call_tok] = "call_tok",
  [sym_plot_tok] = "plot_tok",
  [sym_hlin_tok] = "hlin_tok",
  [sym_vlin_tok] = "vlin_tok",
  [sym_hgr2_tok] = "hgr2_tok",
  [sym_hgr_tok] = "hgr_tok",
  [sym_hcoloreq_tok] = "hcoloreq_tok",
  [sym_hplot_tok] = "hplot_tok",
  [sym_draw_tok] = "draw_tok",
  [sym_xdraw_tok] = "xdraw_tok",
  [sym_htab_tok] = "htab_tok",
  [sym_home_tok] = "home_tok",
  [sym_roteq_tok] = "roteq_tok",
  [sym_scaleeq_tok] = "scaleeq_tok",
  [sym_shload_tok] = "shload_tok",
  [sym_trace_tok] = "trace_tok",
  [sym_notrace_tok] = "notrace_tok",
  [sym_normal_tok] = "normal_tok",
  [sym_inverse_tok] = "inverse_tok",
  [sym_flash_tok] = "flash_tok",
  [sym_coloreq_tok] = "coloreq_tok",
  [sym_pop_tok] = "pop_tok",
  [sym_vtab_tok] = "vtab_tok",
  [sym_himem_tok] = "himem_tok",
  [sym_lomem_tok] = "lomem_tok",
  [sym_onerr_tok] = "onerr_tok",
  [sym_resume_tok] = "resume_tok",
  [sym_recall_tok] = "recall_tok",
  [sym_store_tok] = "store_tok",
  [sym_speedeq_tok] = "speedeq_tok",
  [sym_let_tok] = "let_tok",
  [sym_goto_tok] = "goto_tok",
  [sym_run_tok] = "run_tok",
  [sym_if_tok] = "if_tok",
  [sym_restore_tok] = "restore_tok",
  [sym_amp_tok] = "amp_tok",
  [sym_gosub_tok] = "gosub_tok",
  [sym_return_tok] = "return_tok",
  [sym_rem_tok] = "rem_tok",
  [sym_stop_tok] = "stop_tok",
  [sym_on_tok] = "on_tok",
  [sym_wait_tok] = "wait_tok",
  [sym_load_tok] = "load_tok",
  [sym_save_tok] = "save_tok",
  [sym_def_tok] = "def_tok",
  [sym_poke_tok] = "poke_tok",
  [sym_print_tok] = "print_tok",
  [sym_cont_tok] = "cont_tok",
  [sym_list_tok] = "list_tok",
  [sym_clear_tok] = "clear_tok",
  [sym_get_tok] = "get_tok",
  [sym_new_tok] = "new_tok",
  [sym_tabp_tok] = "tabp_tok",
  [sym_to_tok] = "to_tok",
  [sym_fn_tok] = "fn_tok",
  [sym_spcp_tok] = "spcp_tok",
  [sym_then_tok] = "then_tok",
  [sym_at_tok] = "at_tok",
  [sym_not_tok] = "not_tok",
  [sym_step_tok] = "step_tok",
  [sym_plus_tok] = "plus_tok",
  [sym_minus_tok] = "minus_tok",
  [sym_times_tok] = "times_tok",
  [sym_div_tok] = "div_tok",
  [sym_pow_tok] = "pow_tok",
  [sym_and_tok] = "and_tok",
  [sym_or_tok] = "or_tok",
  [sym_gtr_tok] = "gtr_tok",
  [sym_eq_tok] = "eq_tok",
  [sym_less_tok] = "less_tok",
  [sym_sgn_tok] = "sgn_tok",
  [sym_int_tok] = "int_tok",
  [sym_abs_tok] = "abs_tok",
  [sym_usr_tok] = "usr_tok",
  [sym_fre_tok] = "fre_tok",
  [sym_scrnp_tok] = "scrnp_tok",
  [sym_pdl_tok] = "pdl_tok",
  [sym_pos_tok] = "pos_tok",
  [sym_sqr_tok] = "sqr_tok",
  [sym_rnd_tok] = "rnd_tok",
  [sym_log_tok] = "log_tok",
  [sym_exp_tok] = "exp_tok",
  [sym_cos_tok] = "cos_tok",
  [sym_sin_tok] = "sin_tok",
  [sym_tan_tok] = "tan_tok",
  [sym_atn_tok] = "atn_tok",
  [sym_peek_tok] = "peek_tok",
  [sym_len_tok] = "len_tok",
  [sym_str_tok] = "str_tok",
  [sym_val_tok] = "val_tok",
  [sym_asc_tok] = "asc_tok",
  [sym_chr_tok] = "chr_tok",
  [sym_left_tok] = "left_tok",
  [sym_right_tok] = "right_tok",
  [sym_mid_tok] = "mid_tok",
  [anon_sym_COMMA] = ",",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SEMI] = ";",
  [sym_comment_text] = "comment_text",
  [anon_sym_COLON] = ":",
  [sym_linenum] = "linenum",
  [aux_sym__newline_token1] = "_newline_token1",
  [sym_integer] = "integer",
  [sym_literal] = "literal",
  [sym_real] = "real",
  [sym_string] = "string",
  [sym_terminal_string] = "terminal_string",
  [sym_real_data_item] = "real_data_item",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOLLAR] = "$",
  [sym__ext_name] = "_ext_name",
  [sym_source_file] = "source_file",
  [sym_statement] = "statement",
  [sym_terminal_statement] = "terminal_statement",
  [sym_assignment] = "assignment",
  [sym_fcall] = "fcall",
  [sym_sfcall] = "sfcall",
  [sym_line] = "line",
  [sym__newline] = "_newline",
  [sym__empty_line] = "_empty_line",
  [sym__expr] = "_expr",
  [sym__aexpr] = "_aexpr",
  [sym_unary_aexpr] = "unary_aexpr",
  [sym_binary_aexpr] = "binary_aexpr",
  [sym__parenthesized_aexpr] = "_parenthesized_aexpr",
  [sym__relop] = "_relop",
  [sym__sexpr] = "_sexpr",
  [sym_binary_sexpr] = "binary_sexpr",
  [sym__parenthesized_sexpr] = "_parenthesized_sexpr",
  [sym__sop] = "_sop",
  [sym__var] = "_var",
  [sym__avar] = "_avar",
  [sym_intvar] = "intvar",
  [sym_realvar] = "realvar",
  [sym_svar] = "svar",
  [sym_subscript] = "subscript",
  [sym__dim_item] = "_dim_item",
  [sym__data_item] = "_data_item",
  [sym_fn_name] = "fn_name",
  [sym_real_scalar] = "real_scalar",
  [sym__real_scalar] = "_real_scalar",
  [sym_int_scalar] = "int_scalar",
  [sym__int_scalar] = "_int_scalar",
  [sym__string_scalar] = "_string_scalar",
  [sym_real_array] = "real_array",
  [sym__real_array] = "_real_array",
  [sym_int_array] = "int_array",
  [sym__int_array] = "_int_array",
  [sym_string_array] = "string_array",
  [sym__string_array] = "_string_array",
  [sym__name] = "_name",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_statement_repeat1] = "statement_repeat1",
  [aux_sym_statement_repeat2] = "statement_repeat2",
  [aux_sym_statement_repeat3] = "statement_repeat3",
  [aux_sym_statement_repeat4] = "statement_repeat4",
  [aux_sym_statement_repeat5] = "statement_repeat5",
  [aux_sym_statement_repeat6] = "statement_repeat6",
  [aux_sym_statement_repeat7] = "statement_repeat7",
  [aux_sym_statement_repeat8] = "statement_repeat8",
  [aux_sym_line_repeat1] = "line_repeat1",
  [aux_sym_line_repeat2] = "line_repeat2",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_end_tok] = sym_end_tok,
  [sym_for_tok] = sym_for_tok,
  [sym_next_tok] = sym_next_tok,
  [sym_data_tok] = sym_data_tok,
  [sym_input_tok] = sym_input_tok,
  [sym_del_tok] = sym_del_tok,
  [sym_dim_tok] = sym_dim_tok,
  [sym_read_tok] = sym_read_tok,
  [sym_gr_tok] = sym_gr_tok,
  [sym_text_tok] = sym_text_tok,
  [sym_prn_tok] = sym_prn_tok,
  [sym_inn_tok] = sym_inn_tok,
  [sym_call_tok] = sym_call_tok,
  [sym_plot_tok] = sym_plot_tok,
  [sym_hlin_tok] = sym_hlin_tok,
  [sym_vlin_tok] = sym_vlin_tok,
  [sym_hgr2_tok] = sym_hgr2_tok,
  [sym_hgr_tok] = sym_hgr_tok,
  [sym_hcoloreq_tok] = sym_hcoloreq_tok,
  [sym_hplot_tok] = sym_hplot_tok,
  [sym_draw_tok] = sym_draw_tok,
  [sym_xdraw_tok] = sym_xdraw_tok,
  [sym_htab_tok] = sym_htab_tok,
  [sym_home_tok] = sym_home_tok,
  [sym_roteq_tok] = sym_roteq_tok,
  [sym_scaleeq_tok] = sym_scaleeq_tok,
  [sym_shload_tok] = sym_shload_tok,
  [sym_trace_tok] = sym_trace_tok,
  [sym_notrace_tok] = sym_notrace_tok,
  [sym_normal_tok] = sym_normal_tok,
  [sym_inverse_tok] = sym_inverse_tok,
  [sym_flash_tok] = sym_flash_tok,
  [sym_coloreq_tok] = sym_coloreq_tok,
  [sym_pop_tok] = sym_pop_tok,
  [sym_vtab_tok] = sym_vtab_tok,
  [sym_himem_tok] = sym_himem_tok,
  [sym_lomem_tok] = sym_lomem_tok,
  [sym_onerr_tok] = sym_onerr_tok,
  [sym_resume_tok] = sym_resume_tok,
  [sym_recall_tok] = sym_recall_tok,
  [sym_store_tok] = sym_store_tok,
  [sym_speedeq_tok] = sym_speedeq_tok,
  [sym_let_tok] = sym_let_tok,
  [sym_goto_tok] = sym_goto_tok,
  [sym_run_tok] = sym_run_tok,
  [sym_if_tok] = sym_if_tok,
  [sym_restore_tok] = sym_restore_tok,
  [sym_amp_tok] = sym_amp_tok,
  [sym_gosub_tok] = sym_gosub_tok,
  [sym_return_tok] = sym_return_tok,
  [sym_rem_tok] = sym_rem_tok,
  [sym_stop_tok] = sym_stop_tok,
  [sym_on_tok] = sym_on_tok,
  [sym_wait_tok] = sym_wait_tok,
  [sym_load_tok] = sym_load_tok,
  [sym_save_tok] = sym_save_tok,
  [sym_def_tok] = sym_def_tok,
  [sym_poke_tok] = sym_poke_tok,
  [sym_print_tok] = sym_print_tok,
  [sym_cont_tok] = sym_cont_tok,
  [sym_list_tok] = sym_list_tok,
  [sym_clear_tok] = sym_clear_tok,
  [sym_get_tok] = sym_get_tok,
  [sym_new_tok] = sym_new_tok,
  [sym_tabp_tok] = sym_tabp_tok,
  [sym_to_tok] = sym_to_tok,
  [sym_fn_tok] = sym_fn_tok,
  [sym_spcp_tok] = sym_spcp_tok,
  [sym_then_tok] = sym_then_tok,
  [sym_at_tok] = sym_at_tok,
  [sym_not_tok] = sym_not_tok,
  [sym_step_tok] = sym_step_tok,
  [sym_plus_tok] = sym_plus_tok,
  [sym_minus_tok] = sym_minus_tok,
  [sym_times_tok] = sym_times_tok,
  [sym_div_tok] = sym_div_tok,
  [sym_pow_tok] = sym_pow_tok,
  [sym_and_tok] = sym_and_tok,
  [sym_or_tok] = sym_or_tok,
  [sym_gtr_tok] = sym_gtr_tok,
  [sym_eq_tok] = sym_eq_tok,
  [sym_less_tok] = sym_less_tok,
  [sym_sgn_tok] = sym_sgn_tok,
  [sym_int_tok] = sym_int_tok,
  [sym_abs_tok] = sym_abs_tok,
  [sym_usr_tok] = sym_usr_tok,
  [sym_fre_tok] = sym_fre_tok,
  [sym_scrnp_tok] = sym_scrnp_tok,
  [sym_pdl_tok] = sym_pdl_tok,
  [sym_pos_tok] = sym_pos_tok,
  [sym_sqr_tok] = sym_sqr_tok,
  [sym_rnd_tok] = sym_rnd_tok,
  [sym_log_tok] = sym_log_tok,
  [sym_exp_tok] = sym_exp_tok,
  [sym_cos_tok] = sym_cos_tok,
  [sym_sin_tok] = sym_sin_tok,
  [sym_tan_tok] = sym_tan_tok,
  [sym_atn_tok] = sym_atn_tok,
  [sym_peek_tok] = sym_peek_tok,
  [sym_len_tok] = sym_len_tok,
  [sym_str_tok] = sym_str_tok,
  [sym_val_tok] = sym_val_tok,
  [sym_asc_tok] = sym_asc_tok,
  [sym_chr_tok] = sym_chr_tok,
  [sym_left_tok] = sym_left_tok,
  [sym_right_tok] = sym_right_tok,
  [sym_mid_tok] = sym_mid_tok,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [sym_comment_text] = sym_comment_text,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_linenum] = sym_linenum,
  [aux_sym__newline_token1] = aux_sym__newline_token1,
  [sym_integer] = sym_integer,
  [sym_literal] = sym_literal,
  [sym_real] = sym_real,
  [sym_string] = sym_string,
  [sym_terminal_string] = sym_terminal_string,
  [sym_real_data_item] = sym_real_data_item,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym__ext_name] = sym__ext_name,
  [sym_source_file] = sym_source_file,
  [sym_statement] = sym_statement,
  [sym_terminal_statement] = sym_terminal_statement,
  [sym_assignment] = sym_assignment,
  [sym_fcall] = sym_fcall,
  [sym_sfcall] = sym_sfcall,
  [sym_line] = sym_line,
  [sym__newline] = sym__newline,
  [sym__empty_line] = sym__empty_line,
  [sym__expr] = sym__expr,
  [sym__aexpr] = sym__aexpr,
  [sym_unary_aexpr] = sym_unary_aexpr,
  [sym_binary_aexpr] = sym_binary_aexpr,
  [sym__parenthesized_aexpr] = sym__parenthesized_aexpr,
  [sym__relop] = sym__relop,
  [sym__sexpr] = sym__sexpr,
  [sym_binary_sexpr] = sym_binary_sexpr,
  [sym__parenthesized_sexpr] = sym__parenthesized_sexpr,
  [sym__sop] = sym__sop,
  [sym__var] = sym__var,
  [sym__avar] = sym__avar,
  [sym_intvar] = sym_intvar,
  [sym_realvar] = sym_realvar,
  [sym_svar] = sym_svar,
  [sym_subscript] = sym_subscript,
  [sym__dim_item] = sym__dim_item,
  [sym__data_item] = sym__data_item,
  [sym_fn_name] = sym_fn_name,
  [sym_real_scalar] = sym_real_scalar,
  [sym__real_scalar] = sym__real_scalar,
  [sym_int_scalar] = sym_int_scalar,
  [sym__int_scalar] = sym__int_scalar,
  [sym__string_scalar] = sym__string_scalar,
  [sym_real_array] = sym_real_array,
  [sym__real_array] = sym__real_array,
  [sym_int_array] = sym_int_array,
  [sym__int_array] = sym__int_array,
  [sym_string_array] = sym_string_array,
  [sym__string_array] = sym__string_array,
  [sym__name] = sym__name,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_statement_repeat1] = aux_sym_statement_repeat1,
  [aux_sym_statement_repeat2] = aux_sym_statement_repeat2,
  [aux_sym_statement_repeat3] = aux_sym_statement_repeat3,
  [aux_sym_statement_repeat4] = aux_sym_statement_repeat4,
  [aux_sym_statement_repeat5] = aux_sym_statement_repeat5,
  [aux_sym_statement_repeat6] = aux_sym_statement_repeat6,
  [aux_sym_statement_repeat7] = aux_sym_statement_repeat7,
  [aux_sym_statement_repeat8] = aux_sym_statement_repeat8,
  [aux_sym_line_repeat1] = aux_sym_line_repeat1,
  [aux_sym_line_repeat2] = aux_sym_line_repeat2,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_end_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_for_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_next_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_data_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_input_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_del_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_dim_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_read_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_gr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_text_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_prn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_inn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_call_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_plot_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hlin_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_vlin_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hgr2_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hgr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hcoloreq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hplot_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_draw_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_xdraw_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_htab_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_home_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_roteq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_scaleeq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_shload_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_trace_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_notrace_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_inverse_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_flash_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_coloreq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_pop_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_vtab_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_himem_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_lomem_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_onerr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_resume_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_recall_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_store_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_speedeq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_let_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_run_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_if_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_restore_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_amp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_gosub_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_return_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_rem_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_stop_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_on_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_wait_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_load_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_save_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_def_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_poke_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_print_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_cont_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_list_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_clear_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_get_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_new_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_tabp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_to_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_spcp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_then_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_at_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_not_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_step_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_minus_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_times_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_div_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_pow_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_and_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_or_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_gtr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_eq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_less_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_sgn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_int_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_abs_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_usr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_fre_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_scrnp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_pdl_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_pos_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_sqr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_rnd_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_log_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_exp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_cos_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_sin_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_tan_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_atn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_peek_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_len_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_str_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_val_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_asc_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_chr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_left_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_right_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_mid_tok] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [sym_comment_text] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_linenum] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__newline_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_real] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_terminal_string] = {
    .visible = true,
    .named = true,
  },
  [sym_real_data_item] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym__ext_name] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_terminal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_fcall] = {
    .visible = true,
    .named = true,
  },
  [sym_sfcall] = {
    .visible = true,
    .named = true,
  },
  [sym_line] = {
    .visible = true,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__empty_line] = {
    .visible = false,
    .named = true,
  },
  [sym__expr] = {
    .visible = false,
    .named = true,
  },
  [sym__aexpr] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_aexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_aexpr] = {
    .visible = true,
    .named = true,
  },
  [sym__parenthesized_aexpr] = {
    .visible = false,
    .named = true,
  },
  [sym__relop] = {
    .visible = false,
    .named = true,
  },
  [sym__sexpr] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_sexpr] = {
    .visible = true,
    .named = true,
  },
  [sym__parenthesized_sexpr] = {
    .visible = false,
    .named = true,
  },
  [sym__sop] = {
    .visible = false,
    .named = true,
  },
  [sym__var] = {
    .visible = false,
    .named = true,
  },
  [sym__avar] = {
    .visible = false,
    .named = true,
  },
  [sym_intvar] = {
    .visible = true,
    .named = true,
  },
  [sym_realvar] = {
    .visible = true,
    .named = true,
  },
  [sym_svar] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym__dim_item] = {
    .visible = false,
    .named = true,
  },
  [sym__data_item] = {
    .visible = false,
    .named = true,
  },
  [sym_fn_name] = {
    .visible = true,
    .named = true,
  },
  [sym_real_scalar] = {
    .visible = true,
    .named = true,
  },
  [sym__real_scalar] = {
    .visible = false,
    .named = true,
  },
  [sym_int_scalar] = {
    .visible = true,
    .named = true,
  },
  [sym__int_scalar] = {
    .visible = false,
    .named = true,
  },
  [sym__string_scalar] = {
    .visible = false,
    .named = true,
  },
  [sym_real_array] = {
    .visible = true,
    .named = true,
  },
  [sym__real_array] = {
    .visible = false,
    .named = true,
  },
  [sym_int_array] = {
    .visible = true,
    .named = true,
  },
  [sym__int_array] = {
    .visible = false,
    .named = true,
  },
  [sym_string_array] = {
    .visible = true,
    .named = true,
  },
  [sym__string_array] = {
    .visible = false,
    .named = true,
  },
  [sym__name] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat7] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat8] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_line_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(239);
      if (lookahead == '\n') ADVANCE(361);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == ' ') ADVANCE(2);
      if (lookahead == '"') ADVANCE(377);
      if (lookahead == '$') ADVANCE(383);
      if (lookahead == '%') ADVANCE(382);
      if (lookahead == '&') ADVANCE(287);
      if (lookahead == '(') ADVANCE(350);
      if (lookahead == ')') ADVANCE(351);
      if (lookahead == '*') ADVANCE(316);
      if (lookahead == '+') ADVANCE(380);
      if (lookahead == ',') ADVANCE(349);
      if (lookahead == '-') ADVANCE(380);
      if (lookahead == '/') ADVANCE(317);
      if (lookahead == ':') ADVANCE(357);
      if (lookahead == ';') ADVANCE(352);
      if (lookahead == '<') ADVANCE(323);
      if (lookahead == '=') ADVANCE(322);
      if (lookahead == '>') ADVANCE(321);
      if (lookahead == '?') ADVANCE(298);
      if (lookahead == '^') ADVANCE(318);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(7);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(8);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(9);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(379);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(10);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(11);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(12);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(13);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(14);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(15);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(16);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(17);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(18);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(19);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(20);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(21);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(22);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(23);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(24);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(362);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(361);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(361);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == ' ') ADVANCE(2);
      if (lookahead == '"') ADVANCE(377);
      if (lookahead == '$') ADVANCE(383);
      if (lookahead == '%') ADVANCE(382);
      if (lookahead == '&') ADVANCE(287);
      if (lookahead == '(') ADVANCE(350);
      if (lookahead == ')') ADVANCE(351);
      if (lookahead == '*') ADVANCE(316);
      if (lookahead == '+') ADVANCE(380);
      if (lookahead == ',') ADVANCE(349);
      if (lookahead == '-') ADVANCE(380);
      if (lookahead == '/') ADVANCE(317);
      if (lookahead == ':') ADVANCE(357);
      if (lookahead == ';') ADVANCE(352);
      if (lookahead == '<') ADVANCE(323);
      if (lookahead == '=') ADVANCE(322);
      if (lookahead == '>') ADVANCE(321);
      if (lookahead == '?') ADVANCE(298);
      if (lookahead == '^') ADVANCE(318);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(7);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(8);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(9);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(379);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(10);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(11);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(12);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(13);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(14);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(15);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(16);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(17);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(18);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(19);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(20);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(21);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(22);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(23);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(24);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(362);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(361);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == ' ') ADVANCE(3);
      if (lookahead == '"') ADVANCE(377);
      if (lookahead == '$') ADVANCE(383);
      if (lookahead == '%') ADVANCE(382);
      if (lookahead == '&') ADVANCE(287);
      if (lookahead == '(') ADVANCE(350);
      if (lookahead == ')') ADVANCE(351);
      if (lookahead == '*') ADVANCE(316);
      if (lookahead == '+') ADVANCE(312);
      if (lookahead == ',') ADVANCE(349);
      if (lookahead == '-') ADVANCE(314);
      if (lookahead == '/') ADVANCE(317);
      if (lookahead == ':') ADVANCE(357);
      if (lookahead == ';') ADVANCE(352);
      if (lookahead == '<') ADVANCE(323);
      if (lookahead == '=') ADVANCE(322);
      if (lookahead == '>') ADVANCE(321);
      if (lookahead == '?') ADVANCE(298);
      if (lookahead == '^') ADVANCE(318);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(65);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(66);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(9);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(191);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(67);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(11);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(12);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(87);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(88);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(221);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(17);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(68);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(69);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(70);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(71);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(24);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(360);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(361);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == ' ') ADVANCE(4);
      if (lookahead == '"') ADVANCE(377);
      if (lookahead == '$') ADVANCE(383);
      if (lookahead == '%') ADVANCE(382);
      if (lookahead == '(') ADVANCE(350);
      if (lookahead == '*') ADVANCE(316);
      if (lookahead == '+') ADVANCE(313);
      if (lookahead == ',') ADVANCE(349);
      if (lookahead == '-') ADVANCE(315);
      if (lookahead == '.') ADVANCE(374);
      if (lookahead == '/') ADVANCE(317);
      if (lookahead == ':') ADVANCE(357);
      if (lookahead == ';') ADVANCE(352);
      if (lookahead == '<') ADVANCE(323);
      if (lookahead == '=') ADVANCE(322);
      if (lookahead == '>') ADVANCE(321);
      if (lookahead == '^') ADVANCE(318);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(85);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(77);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(105);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(91);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(231);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(117);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(15);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(234);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(212);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(78);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(79);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(80);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(81);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(22);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(364);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(361);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == ' ') ADVANCE(5);
      if (lookahead == '"') ADVANCE(377);
      if (lookahead == ',') ADVANCE(349);
      if (lookahead == '.') ADVANCE(375);
      if (lookahead == ':') ADVANCE(357);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(381);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(379);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(365);
      if ((1 <= lookahead && lookahead <= '~')) ADVANCE(369);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(361);
      if (lookahead == '\r') ADVANCE(353);
      if (lookahead == ' ') ADVANCE(354);
      if (lookahead == ':') ADVANCE(358);
      if (lookahead != 0) ADVANCE(356);
      END_STATE();
    case 7:
      if (lookahead == ' ') ADVANCE(7);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(92);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(94);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(27);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(309);
      END_STATE();
    case 8:
      if (lookahead == ' ') ADVANCE(8);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(28);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(29);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(95);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 9:
      if (lookahead == ' ') ADVANCE(9);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(31);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(33);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 10:
      if (lookahead == ' ') ADVANCE(10);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(119);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(306);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(98);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(121);
      END_STATE();
    case 11:
      if (lookahead == ' ') ADVANCE(11);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(99);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(34);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(248);
      END_STATE();
    case 12:
      if (lookahead == ' ') ADVANCE(12);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(35);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(124);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(100);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(89);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(227);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(97);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(135);
      END_STATE();
    case 13:
      if (lookahead == ' ') ADVANCE(13);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(285);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(36);
      END_STATE();
    case 14:
      if (lookahead == ' ') ADVANCE(14);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(118);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(38);
      END_STATE();
    case 15:
      if (lookahead == ' ') ADVANCE(15);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(120);
      END_STATE();
    case 16:
      if (lookahead == ' ') ADVANCE(16);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(39);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 17:
      if (lookahead == ' ') ADVANCE(17);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(292);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(320);
      END_STATE();
    case 18:
      if (lookahead == ' ') ADVANCE(18);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(123);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(137);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(101);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(41);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(42);
      END_STATE();
    case 19:
      if (lookahead == ' ') ADVANCE(19);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(43);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(44);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(136);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(125);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 20:
      if (lookahead == ' ') ADVANCE(20);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(46);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(47);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(104);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(226);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(128);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(139);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(86);
      END_STATE();
    case 21:
      if (lookahead == ' ') ADVANCE(21);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(49);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(50);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(149);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(305);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(147);
      END_STATE();
    case 22:
      if (lookahead == ' ') ADVANCE(22);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(151);
      END_STATE();
    case 23:
      if (lookahead == ' ') ADVANCE(23);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(138);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(224);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(159);
      END_STATE();
    case 24:
      if (lookahead == ' ') ADVANCE(24);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(116);
      END_STATE();
    case 25:
      if (lookahead == ' ') ADVANCE(25);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(163);
      END_STATE();
    case 26:
      if (lookahead == ' ') ADVANCE(26);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(379);
      END_STATE();
    case 27:
      if (lookahead == ' ') ADVANCE(27);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(344);
      END_STATE();
    case 28:
      if (lookahead == ' ') ADVANCE(28);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(150);
      END_STATE();
    case 29:
      if (lookahead == ' ') ADVANCE(29);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(52);
      END_STATE();
    case 30:
      if (lookahead == ' ') ADVANCE(30);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(127);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(140);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(336);
      END_STATE();
    case 31:
      if (lookahead == ' ') ADVANCE(31);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(174);
      END_STATE();
    case 32:
      if (lookahead == ' ') ADVANCE(32);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(296);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(245);
      END_STATE();
    case 33:
      if (lookahead == ' ') ADVANCE(33);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(246);
      END_STATE();
    case 34:
      if (lookahead == ' ') ADVANCE(34);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(54);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(142);
      END_STATE();
    case 35:
      if (lookahead == ' ') ADVANCE(35);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(232);
      END_STATE();
    case 36:
      if (lookahead == ' ') ADVANCE(36);
      if (lookahead == '#') ADVANCE(251);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(108);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(325);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(176);
      END_STATE();
    case 37:
      if (lookahead == ' ') ADVANCE(37);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(152);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(341);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(282);
      END_STATE();
    case 38:
      if (lookahead == ' ') ADVANCE(38);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(148);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(334);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(183);
      END_STATE();
    case 39:
      if (lookahead == ' ') ADVANCE(39);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(303);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(172);
      END_STATE();
    case 40:
      if (lookahead == ' ') ADVANCE(40);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(126);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(310);
      END_STATE();
    case 41:
      if (lookahead == ' ') ADVANCE(41);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(193);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(273);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(331);
      END_STATE();
    case 42:
      if (lookahead == ' ') ADVANCE(42);
      if (lookahead == '#') ADVANCE(250);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(155);
      END_STATE();
    case 43:
      if (lookahead == ' ') ADVANCE(43);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(160);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(181);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(290);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(57);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(130);
      END_STATE();
    case 44:
      if (lookahead == ' ') ADVANCE(44);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(58);
      END_STATE();
    case 45:
      if (lookahead == ' ') ADVANCE(45);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(284);
      END_STATE();
    case 46:
      if (lookahead == ' ') ADVANCE(46);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(197);
      END_STATE();
    case 47:
      if (lookahead == ' ') ADVANCE(47);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(162);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(165);
      END_STATE();
    case 48:
      if (lookahead == ' ') ADVANCE(48);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(60);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(201);
      END_STATE();
    case 49:
      if (lookahead == ' ') ADVANCE(49);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(338);
      END_STATE();
    case 50:
      if (lookahead == ' ') ADVANCE(50);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(185);
      END_STATE();
    case 51:
      if (lookahead == ' ') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(363);
      END_STATE();
    case 52:
      if (lookahead == ' ') ADVANCE(52);
      if (lookahead == '$') ADVANCE(345);
      END_STATE();
    case 53:
      if (lookahead == ' ') ADVANCE(53);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(260);
      END_STATE();
    case 54:
      if (lookahead == ' ') ADVANCE(54);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(131);
      END_STATE();
    case 55:
      if (lookahead == ' ') ADVANCE(55);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(262);
      END_STATE();
    case 56:
      if (lookahead == ' ') ADVANCE(56);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(340);
      END_STATE();
    case 57:
      if (lookahead == ' ') ADVANCE(57);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(235);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(233);
      END_STATE();
    case 58:
      if (lookahead == ' ') ADVANCE(58);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(207);
      END_STATE();
    case 59:
      if (lookahead == ' ') ADVANCE(59);
      if (lookahead == '=') ADVANCE(264);
      END_STATE();
    case 60:
      if (lookahead == ' ') ADVANCE(60);
      if (lookahead == '(') ADVANCE(307);
      END_STATE();
    case 61:
      if (lookahead == ' ') ADVANCE(61);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(311);
      END_STATE();
    case 62:
      if (lookahead == ' ') ADVANCE(62);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(291);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(208);
      END_STATE();
    case 63:
      if (lookahead == ' ') ADVANCE(63);
      if (lookahead == '2') ADVANCE(256);
      END_STATE();
    case 64:
      if (lookahead == ' ') ADVANCE(64);
      if (lookahead == ':') ADVANCE(275);
      END_STATE();
    case 65:
      if (lookahead == ' ') ADVANCE(65);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(94);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(309);
      END_STATE();
    case 66:
      if (lookahead == ' ') ADVANCE(66);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(28);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(95);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 67:
      if (lookahead == ' ') ADVANCE(67);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(119);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(98);
      END_STATE();
    case 68:
      if (lookahead == ' ') ADVANCE(68);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(101);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(76);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(42);
      END_STATE();
    case 69:
      if (lookahead == ' ') ADVANCE(69);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(43);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(125);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 70:
      if (lookahead == ' ') ADVANCE(70);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(46);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(200);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(226);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(219);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(90);
      END_STATE();
    case 71:
      if (lookahead == ' ') ADVANCE(71);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(50);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(149);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(305);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(147);
      END_STATE();
    case 72:
      if (lookahead == ' ') ADVANCE(72);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(224);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(159);
      END_STATE();
    case 73:
      if (lookahead == ' ') ADVANCE(73);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(127);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(140);
      END_STATE();
    case 74:
      if (lookahead == ' ') ADVANCE(74);
      if (lookahead == '#') ADVANCE(251);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(108);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(176);
      END_STATE();
    case 75:
      if (lookahead == ' ') ADVANCE(75);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(148);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(183);
      END_STATE();
    case 76:
      if (lookahead == ' ') ADVANCE(76);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(193);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(273);
      END_STATE();
    case 77:
      if (lookahead == ' ') ADVANCE(77);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(29);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(158);
      END_STATE();
    case 78:
      if (lookahead == ' ') ADVANCE(78);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(123);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(137);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(166);
      END_STATE();
    case 79:
      if (lookahead == ' ') ADVANCE(79);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(44);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 80:
      if (lookahead == ' ') ADVANCE(80);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(215);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(104);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(128);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(122);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(139);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(223);
      END_STATE();
    case 81:
      if (lookahead == ' ') ADVANCE(81);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(49);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(305);
      END_STATE();
    case 82:
      if (lookahead == ' ') ADVANCE(82);
      if (lookahead == '.') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(236);
      END_STATE();
    case 83:
      if (lookahead == ' ') ADVANCE(83);
      if (lookahead == '.') ADVANCE(374);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(371);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(364);
      END_STATE();
    case 84:
      if (lookahead == ' ') ADVANCE(355);
      if (lookahead == ':') ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(356);
      END_STATE();
    case 85:
      if (lookahead == ' ') ADVANCE(85);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(92);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(94);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(27);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(237);
      END_STATE();
    case 86:
      if (lookahead == ' ') ADVANCE(86);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(61);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(62);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(129);
      END_STATE();
    case 87:
      if (lookahead == ' ') ADVANCE(87);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(285);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 88:
      if (lookahead == ' ') ADVANCE(88);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(210);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(118);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 89:
      if (lookahead == ' ') ADVANCE(89);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(143);
      END_STATE();
    case 90:
      if (lookahead == ' ') ADVANCE(90);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(61);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(62);
      END_STATE();
    case 91:
      if (lookahead == ' ') ADVANCE(91);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(306);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(121);
      END_STATE();
    case 92:
      if (lookahead == ' ') ADVANCE(92);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(326);
      END_STATE();
    case 93:
      if (lookahead == ' ') ADVANCE(93);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(53);
      END_STATE();
    case 94:
      if (lookahead == ' ') ADVANCE(94);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(319);
      END_STATE();
    case 95:
      if (lookahead == ' ') ADVANCE(95);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 96:
      if (lookahead == ' ') ADVANCE(96);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(211);
      END_STATE();
    case 97:
      if (lookahead == ' ') ADVANCE(97);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(228);
      END_STATE();
    case 98:
      if (lookahead == ' ') ADVANCE(98);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(241);
      END_STATE();
    case 99:
      if (lookahead == ' ') ADVANCE(99);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(302);
      END_STATE();
    case 100:
      if (lookahead == ' ') ADVANCE(100);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(161);
      END_STATE();
    case 101:
      if (lookahead == ' ') ADVANCE(101);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(179);
      END_STATE();
    case 102:
      if (lookahead == ' ') ADVANCE(102);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(126);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(209);
      END_STATE();
    case 103:
      if (lookahead == ' ') ADVANCE(103);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(334);
      END_STATE();
    case 104:
      if (lookahead == ' ') ADVANCE(104);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(324);
      END_STATE();
    case 105:
      if (lookahead == ' ') ADVANCE(105);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(113);
      END_STATE();
    case 106:
      if (lookahead == ' ') ADVANCE(106);
      if (lookahead == '$') ADVANCE(348);
      END_STATE();
    case 107:
      if (lookahead == ' ') ADVANCE(107);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(261);
      END_STATE();
    case 108:
      if (lookahead == ' ') ADVANCE(108);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(199);
      END_STATE();
    case 109:
      if (lookahead == ' ') ADVANCE(109);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(274);
      END_STATE();
    case 110:
      if (lookahead == ' ') ADVANCE(110);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(271);
      END_STATE();
    case 111:
      if (lookahead == ' ') ADVANCE(111);
      if (lookahead == '=') ADVANCE(272);
      END_STATE();
    case 112:
      if (lookahead == ' ') ADVANCE(112);
      if (lookahead == '(') ADVANCE(304);
      END_STATE();
    case 113:
      if (lookahead == ' ') ADVANCE(113);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(335);
      END_STATE();
    case 114:
      if (lookahead == ' ') ADVANCE(114);
      if (lookahead == ':') ADVANCE(276);
      END_STATE();
    case 115:
      if (lookahead == ' ') ADVANCE(115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(152);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(341);
      END_STATE();
    case 116:
      if (lookahead == ' ') ADVANCE(116);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(190);
      END_STATE();
    case 117:
      if (lookahead == ' ') ADVANCE(117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(115);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(103);
      END_STATE();
    case 118:
      if (lookahead == ' ') ADVANCE(118);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(164);
      END_STATE();
    case 119:
      if (lookahead == ' ') ADVANCE(119);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(134);
      END_STATE();
    case 120:
      if (lookahead == ' ') ADVANCE(120);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(106);
      END_STATE();
    case 121:
      if (lookahead == ' ') ADVANCE(121);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(328);
      END_STATE();
    case 122:
      if (lookahead == ' ') ADVANCE(122);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(60);
      END_STATE();
    case 123:
      if (lookahead == ' ') ADVANCE(123);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(330);
      END_STATE();
    case 124:
      if (lookahead == ' ') ADVANCE(124);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(257);
      END_STATE();
    case 125:
      if (lookahead == ' ') ADVANCE(125);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(59);
      END_STATE();
    case 126:
      if (lookahead == ' ') ADVANCE(126);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(192);
      END_STATE();
    case 127:
      if (lookahead == ' ') ADVANCE(127);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(184);
      END_STATE();
    case 128:
      if (lookahead == ' ') ADVANCE(128);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(337);
      END_STATE();
    case 129:
      if (lookahead == ' ') ADVANCE(129);
      if (lookahead == '$') ADVANCE(342);
      END_STATE();
    case 130:
      if (lookahead == ' ') ADVANCE(130);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(198);
      END_STATE();
    case 131:
      if (lookahead == ' ') ADVANCE(131);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(288);
      END_STATE();
    case 132:
      if (lookahead == ' ') ADVANCE(132);
      if (lookahead == '=') ADVANCE(265);
      END_STATE();
    case 133:
      if (lookahead == ' ') ADVANCE(133);
      if (lookahead == '(') ADVANCE(329);
      END_STATE();
    case 134:
      if (lookahead == ' ') ADVANCE(134);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(110);
      END_STATE();
    case 135:
      if (lookahead == ' ') ADVANCE(135);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 136:
      if (lookahead == ' ') ADVANCE(136);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(333);
      END_STATE();
    case 137:
      if (lookahead == ' ') ADVANCE(137);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 138:
      if (lookahead == ' ') ADVANCE(138);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(343);
      END_STATE();
    case 139:
      if (lookahead == ' ') ADVANCE(139);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(332);
      END_STATE();
    case 140:
      if (lookahead == ' ') ADVANCE(140);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(299);
      END_STATE();
    case 141:
      if (lookahead == ' ') ADVANCE(141);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(64);
      END_STATE();
    case 142:
      if (lookahead == ' ') ADVANCE(142);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(283);
      END_STATE();
    case 143:
      if (lookahead == ' ') ADVANCE(143);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(254);
      END_STATE();
    case 144:
      if (lookahead == ' ') ADVANCE(144);
      if (lookahead == '$') ADVANCE(346);
      END_STATE();
    case 145:
      if (lookahead == ' ') ADVANCE(145);
      if (lookahead == '=') ADVANCE(281);
      END_STATE();
    case 146:
      if (lookahead == ' ') ADVANCE(146);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(217);
      END_STATE();
    case 147:
      if (lookahead == ' ') ADVANCE(147);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(96);
      END_STATE();
    case 148:
      if (lookahead == ' ') ADVANCE(148);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(294);
      END_STATE();
    case 149:
      if (lookahead == ' ') ADVANCE(149);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 150:
      if (lookahead == ' ') ADVANCE(150);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(252);
      END_STATE();
    case 151:
      if (lookahead == ' ') ADVANCE(151);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(327);
      END_STATE();
    case 152:
      if (lookahead == ' ') ADVANCE(152);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(144);
      END_STATE();
    case 153:
      if (lookahead == ' ') ADVANCE(153);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(114);
      END_STATE();
    case 154:
      if (lookahead == ' ') ADVANCE(154);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(196);
      END_STATE();
    case 155:
      if (lookahead == ' ') ADVANCE(155);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(203);
      END_STATE();
    case 156:
      if (lookahead == ' ') ADVANCE(156);
      if (lookahead == '$') ADVANCE(347);
      END_STATE();
    case 157:
      if (lookahead == ' ') ADVANCE(157);
      if (lookahead == '=') ADVANCE(258);
      END_STATE();
    case 158:
      if (lookahead == ' ') ADVANCE(158);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(336);
      END_STATE();
    case 159:
      if (lookahead == ' ') ADVANCE(159);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(109);
      END_STATE();
    case 160:
      if (lookahead == ' ') ADVANCE(160);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(247);
      END_STATE();
    case 161:
      if (lookahead == ' ') ADVANCE(161);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(141);
      END_STATE();
    case 162:
      if (lookahead == ' ') ADVANCE(162);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(205);
      END_STATE();
    case 163:
      if (lookahead == ' ') ADVANCE(163);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(187);
      END_STATE();
    case 164:
      if (lookahead == ' ') ADVANCE(164);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(300);
      END_STATE();
    case 165:
      if (lookahead == ' ') ADVANCE(165);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(133);
      END_STATE();
    case 166:
      if (lookahead == ' ') ADVANCE(166);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(331);
      END_STATE();
    case 167:
      if (lookahead == ' ') ADVANCE(167);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(178);
      END_STATE();
    case 168:
      if (lookahead == ' ') ADVANCE(168);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(145);
      END_STATE();
    case 169:
      if (lookahead == ' ') ADVANCE(169);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(263);
      END_STATE();
    case 170:
      if (lookahead == ' ') ADVANCE(170);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(269);
      END_STATE();
    case 171:
      if (lookahead == ' ') ADVANCE(171);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(194);
      END_STATE();
    case 172:
      if (lookahead == ' ') ADVANCE(172);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(242);
      END_STATE();
    case 173:
      if (lookahead == ' ') ADVANCE(173);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(308);
      END_STATE();
    case 174:
      if (lookahead == ' ') ADVANCE(174);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(243);
      END_STATE();
    case 175:
      if (lookahead == ' ') ADVANCE(175);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(266);
      END_STATE();
    case 176:
      if (lookahead == ' ') ADVANCE(176);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(189);
      END_STATE();
    case 177:
      if (lookahead == ' ') ADVANCE(177);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(279);
      END_STATE();
    case 178:
      if (lookahead == ' ') ADVANCE(178);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(301);
      END_STATE();
    case 179:
      if (lookahead == ' ') ADVANCE(179);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(253);
      END_STATE();
    case 180:
      if (lookahead == ' ') ADVANCE(180);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(255);
      END_STATE();
    case 181:
      if (lookahead == ' ') ADVANCE(181);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(222);
      END_STATE();
    case 182:
      if (lookahead == ' ') ADVANCE(182);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(240);
      END_STATE();
    case 183:
      if (lookahead == ' ') ADVANCE(183);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(153);
      END_STATE();
    case 184:
      if (lookahead == ' ') ADVANCE(184);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(111);
      END_STATE();
    case 185:
      if (lookahead == ' ') ADVANCE(185);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(249);
      END_STATE();
    case 186:
      if (lookahead == ' ') ADVANCE(186);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(289);
      END_STATE();
    case 187:
      if (lookahead == ' ') ADVANCE(187);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(107);
      END_STATE();
    case 188:
      if (lookahead == ' ') ADVANCE(188);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 189:
      if (lookahead == ' ') ADVANCE(189);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(146);
      END_STATE();
    case 190:
      if (lookahead == ' ') ADVANCE(190);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(293);
      END_STATE();
    case 191:
      if (lookahead == ' ') ADVANCE(191);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(182);
      END_STATE();
    case 192:
      if (lookahead == ' ') ADVANCE(192);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(170);
      END_STATE();
    case 193:
      if (lookahead == ' ') ADVANCE(193);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(297);
      END_STATE();
    case 194:
      if (lookahead == ' ') ADVANCE(194);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(277);
      END_STATE();
    case 195:
      if (lookahead == ' ') ADVANCE(195);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(259);
      END_STATE();
    case 196:
      if (lookahead == ' ') ADVANCE(196);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(175);
      END_STATE();
    case 197:
      if (lookahead == ' ') ADVANCE(197);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(295);
      END_STATE();
    case 198:
      if (lookahead == ' ') ADVANCE(198);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(186);
      END_STATE();
    case 199:
      if (lookahead == ' ') ADVANCE(199);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(244);
      END_STATE();
    case 200:
      if (lookahead == ' ') ADVANCE(200);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(162);
      END_STATE();
    case 201:
      if (lookahead == ' ') ADVANCE(201);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(168);
      END_STATE();
    case 202:
      if (lookahead == ' ') ADVANCE(202);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(157);
      END_STATE();
    case 203:
      if (lookahead == ' ') ADVANCE(203);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(298);
      END_STATE();
    case 204:
      if (lookahead == ' ') ADVANCE(204);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(138);
      END_STATE();
    case 205:
      if (lookahead == ' ') ADVANCE(205);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 206:
      if (lookahead == ' ') ADVANCE(206);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(218);
      END_STATE();
    case 207:
      if (lookahead == ' ') ADVANCE(207);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(156);
      END_STATE();
    case 208:
      if (lookahead == ' ') ADVANCE(208);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(280);
      END_STATE();
    case 209:
      if (lookahead == ' ') ADVANCE(209);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(230);
      END_STATE();
    case 210:
      if (lookahead == ' ') ADVANCE(210);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(282);
      END_STATE();
    case 211:
      if (lookahead == ' ') ADVANCE(211);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(267);
      END_STATE();
    case 212:
      if (lookahead == ' ') ADVANCE(212);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(320);
      END_STATE();
    case 213:
      if (lookahead == ' ') ADVANCE(213);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(325);
      END_STATE();
    case 214:
      if (lookahead == ' ') ADVANCE(214);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(278);
      END_STATE();
    case 215:
      if (lookahead == ' ') ADVANCE(215);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(165);
      END_STATE();
    case 216:
      if (lookahead == ' ') ADVANCE(216);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(310);
      END_STATE();
    case 217:
      if (lookahead == ' ') ADVANCE(217);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(270);
      END_STATE();
    case 218:
      if (lookahead == ' ') ADVANCE(218);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(286);
      END_STATE();
    case 219:
      if (lookahead == ' ') ADVANCE(219);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(201);
      END_STATE();
    case 220:
      if (lookahead == ' ') ADVANCE(220);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(268);
      END_STATE();
    case 221:
      if (lookahead == ' ') ADVANCE(221);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(39);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 222:
      if (lookahead == ' ') ADVANCE(222);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(177);
      END_STATE();
    case 223:
      if (lookahead == ' ') ADVANCE(223);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(129);
      END_STATE();
    case 224:
      if (lookahead == ' ') ADVANCE(224);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(180);
      END_STATE();
    case 225:
      if (lookahead == ' ') ADVANCE(225);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(220);
      END_STATE();
    case 226:
      if (lookahead == ' ') ADVANCE(226);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(154);
      END_STATE();
    case 227:
      if (lookahead == ' ') ADVANCE(227);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(169);
      END_STATE();
    case 228:
      if (lookahead == ' ') ADVANCE(228);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(195);
      END_STATE();
    case 229:
      if (lookahead == ' ') ADVANCE(229);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(202);
      END_STATE();
    case 230:
      if (lookahead == ' ') ADVANCE(230);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(225);
      END_STATE();
    case 231:
      if (lookahead == ' ') ADVANCE(231);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(213);
      END_STATE();
    case 232:
      if (lookahead == ' ') ADVANCE(232);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(229);
      END_STATE();
    case 233:
      if (lookahead == ' ') ADVANCE(233);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(214);
      END_STATE();
    case 234:
      if (lookahead == ' ') ADVANCE(234);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(216);
      END_STATE();
    case 235:
      if (lookahead == ' ') ADVANCE(235);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(206);
      END_STATE();
    case 236:
      if (lookahead == '.') ADVANCE(374);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(371);
      if (lookahead == ' ' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(236);
      END_STATE();
    case 237:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(339);
      END_STATE();
    case 238:
      if (eof) ADVANCE(239);
      if (lookahead == '\n') ADVANCE(361);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == ' ') ADVANCE(3);
      if (lookahead == '"') ADVANCE(377);
      if (lookahead == '$') ADVANCE(383);
      if (lookahead == '%') ADVANCE(382);
      if (lookahead == '&') ADVANCE(287);
      if (lookahead == '(') ADVANCE(350);
      if (lookahead == ')') ADVANCE(351);
      if (lookahead == '*') ADVANCE(316);
      if (lookahead == '+') ADVANCE(312);
      if (lookahead == ',') ADVANCE(349);
      if (lookahead == '-') ADVANCE(314);
      if (lookahead == '/') ADVANCE(317);
      if (lookahead == ':') ADVANCE(357);
      if (lookahead == ';') ADVANCE(352);
      if (lookahead == '<') ADVANCE(323);
      if (lookahead == '=') ADVANCE(322);
      if (lookahead == '>') ADVANCE(321);
      if (lookahead == '?') ADVANCE(298);
      if (lookahead == '^') ADVANCE(318);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(65);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(66);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(9);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(191);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(67);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(11);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(12);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(87);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(88);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(221);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(17);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(68);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(69);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(70);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(71);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(24);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(360);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_end_tok);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_for_tok);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_next_tok);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_data_tok);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_input_tok);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_del_tok);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_dim_tok);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_read_tok);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_gr_tok);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_text_tok);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_prn_tok);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_inn_tok);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_call_tok);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_plot_tok);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_hlin_tok);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_vlin_tok);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_hgr2_tok);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_hgr_tok);
      if (lookahead == ' ') ADVANCE(63);
      if (lookahead == '2') ADVANCE(256);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_hcoloreq_tok);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_hplot_tok);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_draw_tok);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_xdraw_tok);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_htab_tok);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_home_tok);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_roteq_tok);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_scaleeq_tok);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_shload_tok);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_trace_tok);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_notrace_tok);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_normal_tok);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_inverse_tok);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_flash_tok);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_coloreq_tok);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_pop_tok);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_vtab_tok);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_himem_tok);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_lomem_tok);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_onerr_tok);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_resume_tok);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_recall_tok);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_store_tok);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_speedeq_tok);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_let_tok);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_goto_tok);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_run_tok);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_if_tok);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_restore_tok);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_amp_tok);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_gosub_tok);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_return_tok);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_rem_tok);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_stop_tok);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_on_tok);
      if (lookahead == ' ') ADVANCE(188);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_wait_tok);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_load_tok);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_save_tok);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_def_tok);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_poke_tok);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_print_tok);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_cont_tok);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_list_tok);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_clear_tok);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_get_tok);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_new_tok);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_tabp_tok);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_to_tok);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_fn_tok);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_spcp_tok);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_then_tok);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_at_tok);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_not_tok);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_step_tok);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_plus_tok);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_plus_tok);
      if (lookahead == ' ') ADVANCE(82);
      if (lookahead == '.') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(364);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_minus_tok);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_minus_tok);
      if (lookahead == ' ') ADVANCE(82);
      if (lookahead == '.') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(364);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_times_tok);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_div_tok);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_pow_tok);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_and_tok);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_or_tok);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_gtr_tok);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_eq_tok);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_less_tok);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_sgn_tok);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_int_tok);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_abs_tok);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_usr_tok);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_fre_tok);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_scrnp_tok);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_pdl_tok);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_pos_tok);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_sqr_tok);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_rnd_tok);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_log_tok);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_exp_tok);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_cos_tok);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_sin_tok);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_tan_tok);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_atn_tok);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_peek_tok);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_len_tok);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_str_tok);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_val_tok);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_asc_tok);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_chr_tok);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_left_tok);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_right_tok);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_mid_tok);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_comment_text);
      if (lookahead == '\n') ADVANCE(361);
      if (lookahead != 0) ADVANCE(356);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_comment_text);
      if (lookahead == '\r') ADVANCE(353);
      if (lookahead == ' ') ADVANCE(354);
      if (lookahead == ':') ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(356);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_comment_text);
      if (lookahead == ' ') ADVANCE(355);
      if (lookahead == ':') ADVANCE(358);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(356);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_comment_text);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(356);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(356);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_linenum);
      if (lookahead == ' ') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(362);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_linenum);
      if (lookahead == ' ' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(360);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(aux_sym__newline_token1);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == ' ') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(362);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == ' ') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(363);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == ' ') ADVANCE(83);
      if (lookahead == '.') ADVANCE(374);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(371);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(364);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == ' ') ADVANCE(367);
      if (lookahead == '.') ADVANCE(375);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(371);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(365);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_literal);
      if (lookahead == ' ') ADVANCE(366);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '+') ||
          lookahead == '-' ||
          lookahead == '/' ||
          (';' <= lookahead && lookahead <= 'D') ||
          ('F' <= lookahead && lookahead <= 'd') ||
          ('f' <= lookahead && lookahead <= '~')) ADVANCE(369);
      if (lookahead == '.') ADVANCE(375);
      if (('E' <= lookahead && lookahead <= 'e')) ADVANCE(379);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(368);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_literal);
      if (lookahead == ' ') ADVANCE(367);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '+') ||
          lookahead == '-' ||
          lookahead == '/' ||
          (';' <= lookahead && lookahead <= 'D') ||
          ('F' <= lookahead && lookahead <= 'd') ||
          ('f' <= lookahead && lookahead <= '~')) ADVANCE(369);
      if (lookahead == '.') ADVANCE(375);
      if (('E' <= lookahead && lookahead <= 'e')) ADVANCE(371);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(365);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_literal);
      if (lookahead == ' ' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(368);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '+') ||
          lookahead == '-' ||
          lookahead == '/' ||
          (';' <= lookahead && lookahead <= 'D') ||
          ('F' <= lookahead && lookahead <= 'd') ||
          ('f' <= lookahead && lookahead <= '~')) ADVANCE(369);
      if (lookahead == '.') ADVANCE(375);
      if (('E' <= lookahead && lookahead <= 'e')) ADVANCE(371);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_literal);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '+') ||
          ('-' <= lookahead && lookahead <= '9') ||
          (';' <= lookahead && lookahead <= '~')) ADVANCE(369);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_real);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_real);
      if (lookahead == ' ') ADVANCE(371);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(373);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_real);
      if (lookahead == ' ') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(373);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_real);
      if (lookahead == ' ') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(370);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_real);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(371);
      if (lookahead == ' ' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(374);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_real);
      if (lookahead == ' ' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(371);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_terminal_string);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '!') ||
          ('#' <= lookahead && lookahead <= '~')) ADVANCE(377);
      if (lookahead == '"') ADVANCE(376);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_real_data_item);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_real_data_item);
      if (lookahead == ' ') ADVANCE(379);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(378);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_real_data_item);
      if (lookahead == ' ') ADVANCE(26);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(379);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(363);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_real_data_item);
      if (lookahead == ' ') ADVANCE(366);
      if (lookahead == '.') ADVANCE(375);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(379);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(365);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 238},
  [2] = {.lex_state = 238, .external_lex_state = 1},
  [3] = {.lex_state = 238, .external_lex_state = 1},
  [4] = {.lex_state = 238, .external_lex_state = 1},
  [5] = {.lex_state = 238, .external_lex_state = 1},
  [6] = {.lex_state = 238, .external_lex_state = 1},
  [7] = {.lex_state = 238, .external_lex_state = 1},
  [8] = {.lex_state = 238, .external_lex_state = 1},
  [9] = {.lex_state = 238, .external_lex_state = 1},
  [10] = {.lex_state = 238, .external_lex_state = 1},
  [11] = {.lex_state = 238, .external_lex_state = 1},
  [12] = {.lex_state = 238, .external_lex_state = 1},
  [13] = {.lex_state = 238, .external_lex_state = 1},
  [14] = {.lex_state = 4, .external_lex_state = 1},
  [15] = {.lex_state = 4, .external_lex_state = 1},
  [16] = {.lex_state = 4, .external_lex_state = 1},
  [17] = {.lex_state = 4, .external_lex_state = 1},
  [18] = {.lex_state = 4, .external_lex_state = 1},
  [19] = {.lex_state = 4, .external_lex_state = 1},
  [20] = {.lex_state = 4, .external_lex_state = 1},
  [21] = {.lex_state = 4, .external_lex_state = 1},
  [22] = {.lex_state = 4, .external_lex_state = 1},
  [23] = {.lex_state = 4, .external_lex_state = 1},
  [24] = {.lex_state = 4, .external_lex_state = 1},
  [25] = {.lex_state = 4, .external_lex_state = 1},
  [26] = {.lex_state = 4, .external_lex_state = 1},
  [27] = {.lex_state = 4, .external_lex_state = 1},
  [28] = {.lex_state = 4, .external_lex_state = 1},
  [29] = {.lex_state = 4, .external_lex_state = 1},
  [30] = {.lex_state = 4, .external_lex_state = 1},
  [31] = {.lex_state = 4, .external_lex_state = 1},
  [32] = {.lex_state = 4, .external_lex_state = 1},
  [33] = {.lex_state = 4, .external_lex_state = 1},
  [34] = {.lex_state = 4, .external_lex_state = 1},
  [35] = {.lex_state = 4, .external_lex_state = 1},
  [36] = {.lex_state = 4, .external_lex_state = 1},
  [37] = {.lex_state = 4, .external_lex_state = 1},
  [38] = {.lex_state = 4, .external_lex_state = 1},
  [39] = {.lex_state = 4, .external_lex_state = 1},
  [40] = {.lex_state = 4, .external_lex_state = 1},
  [41] = {.lex_state = 4, .external_lex_state = 1},
  [42] = {.lex_state = 4, .external_lex_state = 1},
  [43] = {.lex_state = 4, .external_lex_state = 1},
  [44] = {.lex_state = 4, .external_lex_state = 1},
  [45] = {.lex_state = 4, .external_lex_state = 1},
  [46] = {.lex_state = 4, .external_lex_state = 1},
  [47] = {.lex_state = 4, .external_lex_state = 1},
  [48] = {.lex_state = 4, .external_lex_state = 1},
  [49] = {.lex_state = 4, .external_lex_state = 1},
  [50] = {.lex_state = 4, .external_lex_state = 1},
  [51] = {.lex_state = 4, .external_lex_state = 1},
  [52] = {.lex_state = 4, .external_lex_state = 1},
  [53] = {.lex_state = 4, .external_lex_state = 1},
  [54] = {.lex_state = 4, .external_lex_state = 1},
  [55] = {.lex_state = 4, .external_lex_state = 1},
  [56] = {.lex_state = 4, .external_lex_state = 1},
  [57] = {.lex_state = 4, .external_lex_state = 1},
  [58] = {.lex_state = 4, .external_lex_state = 1},
  [59] = {.lex_state = 4, .external_lex_state = 1},
  [60] = {.lex_state = 4, .external_lex_state = 1},
  [61] = {.lex_state = 4, .external_lex_state = 1},
  [62] = {.lex_state = 4, .external_lex_state = 1},
  [63] = {.lex_state = 4, .external_lex_state = 1},
  [64] = {.lex_state = 4, .external_lex_state = 1},
  [65] = {.lex_state = 4, .external_lex_state = 1},
  [66] = {.lex_state = 4, .external_lex_state = 1},
  [67] = {.lex_state = 4, .external_lex_state = 1},
  [68] = {.lex_state = 4, .external_lex_state = 1},
  [69] = {.lex_state = 4, .external_lex_state = 1},
  [70] = {.lex_state = 4, .external_lex_state = 1},
  [71] = {.lex_state = 4, .external_lex_state = 1},
  [72] = {.lex_state = 4, .external_lex_state = 1},
  [73] = {.lex_state = 4, .external_lex_state = 1},
  [74] = {.lex_state = 4, .external_lex_state = 1},
  [75] = {.lex_state = 4, .external_lex_state = 1},
  [76] = {.lex_state = 4, .external_lex_state = 1},
  [77] = {.lex_state = 4, .external_lex_state = 1},
  [78] = {.lex_state = 4, .external_lex_state = 1},
  [79] = {.lex_state = 4, .external_lex_state = 1},
  [80] = {.lex_state = 4, .external_lex_state = 1},
  [81] = {.lex_state = 4, .external_lex_state = 1},
  [82] = {.lex_state = 4, .external_lex_state = 1},
  [83] = {.lex_state = 4, .external_lex_state = 1},
  [84] = {.lex_state = 4, .external_lex_state = 1},
  [85] = {.lex_state = 4, .external_lex_state = 1},
  [86] = {.lex_state = 4, .external_lex_state = 1},
  [87] = {.lex_state = 4, .external_lex_state = 1},
  [88] = {.lex_state = 4, .external_lex_state = 1},
  [89] = {.lex_state = 4, .external_lex_state = 1},
  [90] = {.lex_state = 4, .external_lex_state = 1},
  [91] = {.lex_state = 4, .external_lex_state = 1},
  [92] = {.lex_state = 4, .external_lex_state = 1},
  [93] = {.lex_state = 4, .external_lex_state = 1},
  [94] = {.lex_state = 4, .external_lex_state = 1},
  [95] = {.lex_state = 4, .external_lex_state = 1},
  [96] = {.lex_state = 4, .external_lex_state = 1},
  [97] = {.lex_state = 4, .external_lex_state = 1},
  [98] = {.lex_state = 4, .external_lex_state = 1},
  [99] = {.lex_state = 4, .external_lex_state = 1},
  [100] = {.lex_state = 4, .external_lex_state = 1},
  [101] = {.lex_state = 4, .external_lex_state = 1},
  [102] = {.lex_state = 4, .external_lex_state = 1},
  [103] = {.lex_state = 4, .external_lex_state = 1},
  [104] = {.lex_state = 4, .external_lex_state = 1},
  [105] = {.lex_state = 4, .external_lex_state = 1},
  [106] = {.lex_state = 4, .external_lex_state = 1},
  [107] = {.lex_state = 4, .external_lex_state = 1},
  [108] = {.lex_state = 4, .external_lex_state = 1},
  [109] = {.lex_state = 4, .external_lex_state = 1},
  [110] = {.lex_state = 4, .external_lex_state = 1},
  [111] = {.lex_state = 4, .external_lex_state = 1},
  [112] = {.lex_state = 4, .external_lex_state = 1},
  [113] = {.lex_state = 4, .external_lex_state = 1},
  [114] = {.lex_state = 4, .external_lex_state = 1},
  [115] = {.lex_state = 4, .external_lex_state = 1},
  [116] = {.lex_state = 4, .external_lex_state = 1},
  [117] = {.lex_state = 4, .external_lex_state = 1},
  [118] = {.lex_state = 4, .external_lex_state = 1},
  [119] = {.lex_state = 4, .external_lex_state = 1},
  [120] = {.lex_state = 4, .external_lex_state = 1},
  [121] = {.lex_state = 238},
  [122] = {.lex_state = 0, .external_lex_state = 1},
  [123] = {.lex_state = 238},
  [124] = {.lex_state = 238},
  [125] = {.lex_state = 238},
  [126] = {.lex_state = 238},
  [127] = {.lex_state = 238},
  [128] = {.lex_state = 238},
  [129] = {.lex_state = 238},
  [130] = {.lex_state = 238},
  [131] = {.lex_state = 238},
  [132] = {.lex_state = 238},
  [133] = {.lex_state = 238},
  [134] = {.lex_state = 238},
  [135] = {.lex_state = 238},
  [136] = {.lex_state = 238},
  [137] = {.lex_state = 238},
  [138] = {.lex_state = 238},
  [139] = {.lex_state = 238},
  [140] = {.lex_state = 238},
  [141] = {.lex_state = 238},
  [142] = {.lex_state = 238},
  [143] = {.lex_state = 238},
  [144] = {.lex_state = 238},
  [145] = {.lex_state = 238},
  [146] = {.lex_state = 238},
  [147] = {.lex_state = 238},
  [148] = {.lex_state = 238},
  [149] = {.lex_state = 238},
  [150] = {.lex_state = 238},
  [151] = {.lex_state = 0, .external_lex_state = 1},
  [152] = {.lex_state = 0, .external_lex_state = 1},
  [153] = {.lex_state = 0, .external_lex_state = 1},
  [154] = {.lex_state = 0, .external_lex_state = 1},
  [155] = {.lex_state = 0, .external_lex_state = 1},
  [156] = {.lex_state = 0, .external_lex_state = 1},
  [157] = {.lex_state = 0, .external_lex_state = 1},
  [158] = {.lex_state = 0, .external_lex_state = 1},
  [159] = {.lex_state = 0, .external_lex_state = 1},
  [160] = {.lex_state = 0, .external_lex_state = 1},
  [161] = {.lex_state = 0, .external_lex_state = 1},
  [162] = {.lex_state = 0, .external_lex_state = 1},
  [163] = {.lex_state = 0, .external_lex_state = 1},
  [164] = {.lex_state = 0, .external_lex_state = 1},
  [165] = {.lex_state = 238},
  [166] = {.lex_state = 238},
  [167] = {.lex_state = 238},
  [168] = {.lex_state = 238},
  [169] = {.lex_state = 238},
  [170] = {.lex_state = 238},
  [171] = {.lex_state = 238},
  [172] = {.lex_state = 238},
  [173] = {.lex_state = 238},
  [174] = {.lex_state = 238},
  [175] = {.lex_state = 238},
  [176] = {.lex_state = 238},
  [177] = {.lex_state = 238},
  [178] = {.lex_state = 238},
  [179] = {.lex_state = 0, .external_lex_state = 1},
  [180] = {.lex_state = 238},
  [181] = {.lex_state = 238},
  [182] = {.lex_state = 238},
  [183] = {.lex_state = 0, .external_lex_state = 1},
  [184] = {.lex_state = 0, .external_lex_state = 1},
  [185] = {.lex_state = 238},
  [186] = {.lex_state = 238},
  [187] = {.lex_state = 238},
  [188] = {.lex_state = 238},
  [189] = {.lex_state = 238},
  [190] = {.lex_state = 238},
  [191] = {.lex_state = 238},
  [192] = {.lex_state = 238},
  [193] = {.lex_state = 238},
  [194] = {.lex_state = 238},
  [195] = {.lex_state = 238},
  [196] = {.lex_state = 238},
  [197] = {.lex_state = 238},
  [198] = {.lex_state = 238},
  [199] = {.lex_state = 238},
  [200] = {.lex_state = 238},
  [201] = {.lex_state = 238},
  [202] = {.lex_state = 238},
  [203] = {.lex_state = 238},
  [204] = {.lex_state = 238},
  [205] = {.lex_state = 238},
  [206] = {.lex_state = 238},
  [207] = {.lex_state = 238},
  [208] = {.lex_state = 238},
  [209] = {.lex_state = 238},
  [210] = {.lex_state = 238},
  [211] = {.lex_state = 0, .external_lex_state = 1},
  [212] = {.lex_state = 238},
  [213] = {.lex_state = 238},
  [214] = {.lex_state = 238},
  [215] = {.lex_state = 0, .external_lex_state = 1},
  [216] = {.lex_state = 5},
  [217] = {.lex_state = 238},
  [218] = {.lex_state = 5},
  [219] = {.lex_state = 5},
  [220] = {.lex_state = 0, .external_lex_state = 1},
  [221] = {.lex_state = 238},
  [222] = {.lex_state = 238},
  [223] = {.lex_state = 238},
  [224] = {.lex_state = 238},
  [225] = {.lex_state = 238},
  [226] = {.lex_state = 0},
  [227] = {.lex_state = 0, .external_lex_state = 1},
  [228] = {.lex_state = 238},
  [229] = {.lex_state = 0, .external_lex_state = 1},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 0},
  [232] = {.lex_state = 0},
  [233] = {.lex_state = 0},
  [234] = {.lex_state = 238},
  [235] = {.lex_state = 238},
  [236] = {.lex_state = 0},
  [237] = {.lex_state = 0},
  [238] = {.lex_state = 0},
  [239] = {.lex_state = 0},
  [240] = {.lex_state = 238},
  [241] = {.lex_state = 0},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 238},
  [244] = {.lex_state = 0},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 0},
  [247] = {.lex_state = 0},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0, .external_lex_state = 1},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 0},
  [256] = {.lex_state = 0},
  [257] = {.lex_state = 0},
  [258] = {.lex_state = 0},
  [259] = {.lex_state = 0},
  [260] = {.lex_state = 0},
  [261] = {.lex_state = 238},
  [262] = {.lex_state = 238},
  [263] = {.lex_state = 238},
  [264] = {.lex_state = 238},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 0, .external_lex_state = 1},
  [268] = {.lex_state = 0},
  [269] = {.lex_state = 238},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 238},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 238},
  [274] = {.lex_state = 0},
  [275] = {.lex_state = 238},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 238},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 238},
  [280] = {.lex_state = 0, .external_lex_state = 1},
  [281] = {.lex_state = 6},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 238},
  [284] = {.lex_state = 0, .external_lex_state = 1},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 238},
  [287] = {.lex_state = 0, .external_lex_state = 1},
  [288] = {.lex_state = 0},
  [289] = {.lex_state = 238},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 0},
  [292] = {.lex_state = 238},
  [293] = {.lex_state = 0},
  [294] = {.lex_state = 238},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 0, .external_lex_state = 1},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 238},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 238},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 84},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 0},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 238},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 0},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 238},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 238},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 238},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0, .external_lex_state = 1},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 238},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0, .external_lex_state = 1},
  [359] = {.lex_state = 238},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 0},
};

enum {
  ts_external_token__ext_name = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__ext_name] = sym__ext_name,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__ext_name] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_end_tok] = ACTIONS(1),
    [sym_for_tok] = ACTIONS(1),
    [sym_next_tok] = ACTIONS(1),
    [sym_data_tok] = ACTIONS(1),
    [sym_input_tok] = ACTIONS(1),
    [sym_del_tok] = ACTIONS(1),
    [sym_dim_tok] = ACTIONS(1),
    [sym_read_tok] = ACTIONS(1),
    [sym_gr_tok] = ACTIONS(1),
    [sym_text_tok] = ACTIONS(1),
    [sym_prn_tok] = ACTIONS(1),
    [sym_inn_tok] = ACTIONS(1),
    [sym_call_tok] = ACTIONS(1),
    [sym_plot_tok] = ACTIONS(1),
    [sym_hlin_tok] = ACTIONS(1),
    [sym_vlin_tok] = ACTIONS(1),
    [sym_hgr2_tok] = ACTIONS(1),
    [sym_hgr_tok] = ACTIONS(1),
    [sym_hcoloreq_tok] = ACTIONS(1),
    [sym_hplot_tok] = ACTIONS(1),
    [sym_draw_tok] = ACTIONS(1),
    [sym_xdraw_tok] = ACTIONS(1),
    [sym_htab_tok] = ACTIONS(1),
    [sym_home_tok] = ACTIONS(1),
    [sym_roteq_tok] = ACTIONS(1),
    [sym_scaleeq_tok] = ACTIONS(1),
    [sym_shload_tok] = ACTIONS(1),
    [sym_trace_tok] = ACTIONS(1),
    [sym_normal_tok] = ACTIONS(1),
    [sym_inverse_tok] = ACTIONS(1),
    [sym_flash_tok] = ACTIONS(1),
    [sym_coloreq_tok] = ACTIONS(1),
    [sym_pop_tok] = ACTIONS(1),
    [sym_vtab_tok] = ACTIONS(1),
    [sym_himem_tok] = ACTIONS(1),
    [sym_lomem_tok] = ACTIONS(1),
    [sym_onerr_tok] = ACTIONS(1),
    [sym_resume_tok] = ACTIONS(1),
    [sym_recall_tok] = ACTIONS(1),
    [sym_store_tok] = ACTIONS(1),
    [sym_speedeq_tok] = ACTIONS(1),
    [sym_let_tok] = ACTIONS(1),
    [sym_goto_tok] = ACTIONS(1),
    [sym_run_tok] = ACTIONS(1),
    [sym_if_tok] = ACTIONS(1),
    [sym_restore_tok] = ACTIONS(1),
    [sym_amp_tok] = ACTIONS(1),
    [sym_gosub_tok] = ACTIONS(1),
    [sym_return_tok] = ACTIONS(1),
    [sym_rem_tok] = ACTIONS(1),
    [sym_stop_tok] = ACTIONS(1),
    [sym_on_tok] = ACTIONS(1),
    [sym_wait_tok] = ACTIONS(1),
    [sym_load_tok] = ACTIONS(1),
    [sym_save_tok] = ACTIONS(1),
    [sym_def_tok] = ACTIONS(1),
    [sym_poke_tok] = ACTIONS(1),
    [sym_print_tok] = ACTIONS(1),
    [sym_cont_tok] = ACTIONS(1),
    [sym_list_tok] = ACTIONS(1),
    [sym_clear_tok] = ACTIONS(1),
    [sym_get_tok] = ACTIONS(1),
    [sym_new_tok] = ACTIONS(1),
    [sym_tabp_tok] = ACTIONS(1),
    [sym_to_tok] = ACTIONS(1),
    [sym_fn_tok] = ACTIONS(1),
    [sym_spcp_tok] = ACTIONS(1),
    [sym_then_tok] = ACTIONS(1),
    [sym_at_tok] = ACTIONS(1),
    [sym_not_tok] = ACTIONS(1),
    [sym_step_tok] = ACTIONS(1),
    [sym_plus_tok] = ACTIONS(1),
    [sym_minus_tok] = ACTIONS(1),
    [sym_times_tok] = ACTIONS(1),
    [sym_div_tok] = ACTIONS(1),
    [sym_pow_tok] = ACTIONS(1),
    [sym_and_tok] = ACTIONS(1),
    [sym_or_tok] = ACTIONS(1),
    [sym_gtr_tok] = ACTIONS(1),
    [sym_eq_tok] = ACTIONS(1),
    [sym_less_tok] = ACTIONS(1),
    [sym_sgn_tok] = ACTIONS(1),
    [sym_int_tok] = ACTIONS(1),
    [sym_abs_tok] = ACTIONS(1),
    [sym_usr_tok] = ACTIONS(1),
    [sym_fre_tok] = ACTIONS(1),
    [sym_scrnp_tok] = ACTIONS(1),
    [sym_pdl_tok] = ACTIONS(1),
    [sym_pos_tok] = ACTIONS(1),
    [sym_sqr_tok] = ACTIONS(1),
    [sym_rnd_tok] = ACTIONS(1),
    [sym_log_tok] = ACTIONS(1),
    [sym_exp_tok] = ACTIONS(1),
    [sym_cos_tok] = ACTIONS(1),
    [sym_sin_tok] = ACTIONS(1),
    [sym_tan_tok] = ACTIONS(1),
    [sym_peek_tok] = ACTIONS(1),
    [sym_len_tok] = ACTIONS(1),
    [sym_str_tok] = ACTIONS(1),
    [sym_val_tok] = ACTIONS(1),
    [sym_asc_tok] = ACTIONS(1),
    [sym_chr_tok] = ACTIONS(1),
    [sym_left_tok] = ACTIONS(1),
    [sym_right_tok] = ACTIONS(1),
    [sym_mid_tok] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_linenum] = ACTIONS(1),
    [aux_sym__newline_token1] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [sym_terminal_string] = ACTIONS(1),
    [sym_real_data_item] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym__ext_name] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(338),
    [sym_line] = STATE(224),
    [sym__empty_line] = STATE(224),
    [aux_sym_source_file_repeat1] = STATE(224),
    [ts_builtin_sym_end] = ACTIONS(3),
    [sym_linenum] = ACTIONS(5),
    [aux_sym__newline_token1] = ACTIONS(7),
  },
  [2] = {
    [sym_statement] = STATE(255),
    [sym_terminal_statement] = STATE(319),
    [sym_assignment] = STATE(304),
    [sym__avar] = STATE(333),
    [sym_intvar] = STATE(333),
    [sym_realvar] = STATE(333),
    [sym_svar] = STATE(334),
    [sym__real_scalar] = STATE(148),
    [sym__int_scalar] = STATE(149),
    [sym__string_scalar] = STATE(131),
    [sym__real_array] = STATE(148),
    [sym__int_array] = STATE(149),
    [sym__string_array] = STATE(131),
    [sym__name] = STATE(121),
    [aux_sym_line_repeat1] = STATE(3),
    [aux_sym_line_repeat2] = STATE(6),
    [sym_end_tok] = ACTIONS(9),
    [sym_for_tok] = ACTIONS(11),
    [sym_next_tok] = ACTIONS(13),
    [sym_data_tok] = ACTIONS(15),
    [sym_input_tok] = ACTIONS(17),
    [sym_del_tok] = ACTIONS(19),
    [sym_dim_tok] = ACTIONS(21),
    [sym_read_tok] = ACTIONS(23),
    [sym_gr_tok] = ACTIONS(9),
    [sym_text_tok] = ACTIONS(9),
    [sym_prn_tok] = ACTIONS(25),
    [sym_inn_tok] = ACTIONS(25),
    [sym_call_tok] = ACTIONS(27),
    [sym_plot_tok] = ACTIONS(29),
    [sym_hlin_tok] = ACTIONS(31),
    [sym_vlin_tok] = ACTIONS(31),
    [sym_hgr2_tok] = ACTIONS(9),
    [sym_hgr_tok] = ACTIONS(33),
    [sym_hcoloreq_tok] = ACTIONS(25),
    [sym_hplot_tok] = ACTIONS(35),
    [sym_draw_tok] = ACTIONS(37),
    [sym_xdraw_tok] = ACTIONS(37),
    [sym_htab_tok] = ACTIONS(25),
    [sym_home_tok] = ACTIONS(9),
    [sym_roteq_tok] = ACTIONS(25),
    [sym_scaleeq_tok] = ACTIONS(25),
    [sym_shload_tok] = ACTIONS(9),
    [sym_trace_tok] = ACTIONS(9),
    [sym_notrace_tok] = ACTIONS(9),
    [sym_normal_tok] = ACTIONS(9),
    [sym_inverse_tok] = ACTIONS(9),
    [sym_flash_tok] = ACTIONS(9),
    [sym_coloreq_tok] = ACTIONS(25),
    [sym_pop_tok] = ACTIONS(9),
    [sym_vtab_tok] = ACTIONS(25),
    [sym_himem_tok] = ACTIONS(25),
    [sym_lomem_tok] = ACTIONS(25),
    [sym_onerr_tok] = ACTIONS(39),
    [sym_resume_tok] = ACTIONS(9),
    [sym_recall_tok] = ACTIONS(41),
    [sym_store_tok] = ACTIONS(41),
    [sym_speedeq_tok] = ACTIONS(25),
    [sym_let_tok] = ACTIONS(43),
    [sym_goto_tok] = ACTIONS(45),
    [sym_run_tok] = ACTIONS(47),
    [sym_if_tok] = ACTIONS(49),
    [sym_restore_tok] = ACTIONS(9),
    [sym_amp_tok] = ACTIONS(51),
    [sym_gosub_tok] = ACTIONS(45),
    [sym_return_tok] = ACTIONS(9),
    [sym_rem_tok] = ACTIONS(53),
    [sym_stop_tok] = ACTIONS(9),
    [sym_on_tok] = ACTIONS(55),
    [sym_wait_tok] = ACTIONS(57),
    [sym_load_tok] = ACTIONS(9),
    [sym_save_tok] = ACTIONS(9),
    [sym_def_tok] = ACTIONS(59),
    [sym_poke_tok] = ACTIONS(29),
    [sym_print_tok] = ACTIONS(61),
    [sym_cont_tok] = ACTIONS(9),
    [sym_list_tok] = ACTIONS(63),
    [sym_clear_tok] = ACTIONS(9),
    [sym_get_tok] = ACTIONS(23),
    [sym_new_tok] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(65),
    [sym__ext_name] = ACTIONS(67),
  },
  [3] = {
    [sym_statement] = STATE(241),
    [sym_terminal_statement] = STATE(302),
    [sym_assignment] = STATE(304),
    [sym__avar] = STATE(333),
    [sym_intvar] = STATE(333),
    [sym_realvar] = STATE(333),
    [sym_svar] = STATE(334),
    [sym__real_scalar] = STATE(148),
    [sym__int_scalar] = STATE(149),
    [sym__string_scalar] = STATE(131),
    [sym__real_array] = STATE(148),
    [sym__int_array] = STATE(149),
    [sym__string_array] = STATE(131),
    [sym__name] = STATE(121),
    [aux_sym_line_repeat1] = STATE(12),
    [aux_sym_line_repeat2] = STATE(4),
    [sym_end_tok] = ACTIONS(9),
    [sym_for_tok] = ACTIONS(11),
    [sym_next_tok] = ACTIONS(13),
    [sym_data_tok] = ACTIONS(15),
    [sym_input_tok] = ACTIONS(17),
    [sym_del_tok] = ACTIONS(19),
    [sym_dim_tok] = ACTIONS(21),
    [sym_read_tok] = ACTIONS(23),
    [sym_gr_tok] = ACTIONS(9),
    [sym_text_tok] = ACTIONS(9),
    [sym_prn_tok] = ACTIONS(25),
    [sym_inn_tok] = ACTIONS(25),
    [sym_call_tok] = ACTIONS(27),
    [sym_plot_tok] = ACTIONS(29),
    [sym_hlin_tok] = ACTIONS(31),
    [sym_vlin_tok] = ACTIONS(31),
    [sym_hgr2_tok] = ACTIONS(9),
    [sym_hgr_tok] = ACTIONS(33),
    [sym_hcoloreq_tok] = ACTIONS(25),
    [sym_hplot_tok] = ACTIONS(35),
    [sym_draw_tok] = ACTIONS(37),
    [sym_xdraw_tok] = ACTIONS(37),
    [sym_htab_tok] = ACTIONS(25),
    [sym_home_tok] = ACTIONS(9),
    [sym_roteq_tok] = ACTIONS(25),
    [sym_scaleeq_tok] = ACTIONS(25),
    [sym_shload_tok] = ACTIONS(9),
    [sym_trace_tok] = ACTIONS(9),
    [sym_notrace_tok] = ACTIONS(9),
    [sym_normal_tok] = ACTIONS(9),
    [sym_inverse_tok] = ACTIONS(9),
    [sym_flash_tok] = ACTIONS(9),
    [sym_coloreq_tok] = ACTIONS(25),
    [sym_pop_tok] = ACTIONS(9),
    [sym_vtab_tok] = ACTIONS(25),
    [sym_himem_tok] = ACTIONS(25),
    [sym_lomem_tok] = ACTIONS(25),
    [sym_onerr_tok] = ACTIONS(39),
    [sym_resume_tok] = ACTIONS(9),
    [sym_recall_tok] = ACTIONS(41),
    [sym_store_tok] = ACTIONS(41),
    [sym_speedeq_tok] = ACTIONS(25),
    [sym_let_tok] = ACTIONS(43),
    [sym_goto_tok] = ACTIONS(45),
    [sym_run_tok] = ACTIONS(47),
    [sym_if_tok] = ACTIONS(49),
    [sym_restore_tok] = ACTIONS(9),
    [sym_amp_tok] = ACTIONS(51),
    [sym_gosub_tok] = ACTIONS(45),
    [sym_return_tok] = ACTIONS(9),
    [sym_rem_tok] = ACTIONS(53),
    [sym_stop_tok] = ACTIONS(9),
    [sym_on_tok] = ACTIONS(55),
    [sym_wait_tok] = ACTIONS(57),
    [sym_load_tok] = ACTIONS(9),
    [sym_save_tok] = ACTIONS(9),
    [sym_def_tok] = ACTIONS(59),
    [sym_poke_tok] = ACTIONS(29),
    [sym_print_tok] = ACTIONS(61),
    [sym_cont_tok] = ACTIONS(9),
    [sym_list_tok] = ACTIONS(63),
    [sym_clear_tok] = ACTIONS(9),
    [sym_get_tok] = ACTIONS(23),
    [sym_new_tok] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(69),
    [sym__ext_name] = ACTIONS(67),
  },
  [4] = {
    [sym_statement] = STATE(259),
    [sym_terminal_statement] = STATE(305),
    [sym_assignment] = STATE(304),
    [sym__avar] = STATE(333),
    [sym_intvar] = STATE(333),
    [sym_realvar] = STATE(333),
    [sym_svar] = STATE(334),
    [sym__real_scalar] = STATE(148),
    [sym__int_scalar] = STATE(149),
    [sym__string_scalar] = STATE(131),
    [sym__real_array] = STATE(148),
    [sym__int_array] = STATE(149),
    [sym__string_array] = STATE(131),
    [sym__name] = STATE(121),
    [aux_sym_line_repeat2] = STATE(7),
    [sym_end_tok] = ACTIONS(9),
    [sym_for_tok] = ACTIONS(11),
    [sym_next_tok] = ACTIONS(13),
    [sym_data_tok] = ACTIONS(15),
    [sym_input_tok] = ACTIONS(17),
    [sym_del_tok] = ACTIONS(19),
    [sym_dim_tok] = ACTIONS(21),
    [sym_read_tok] = ACTIONS(23),
    [sym_gr_tok] = ACTIONS(9),
    [sym_text_tok] = ACTIONS(9),
    [sym_prn_tok] = ACTIONS(25),
    [sym_inn_tok] = ACTIONS(25),
    [sym_call_tok] = ACTIONS(27),
    [sym_plot_tok] = ACTIONS(29),
    [sym_hlin_tok] = ACTIONS(31),
    [sym_vlin_tok] = ACTIONS(31),
    [sym_hgr2_tok] = ACTIONS(9),
    [sym_hgr_tok] = ACTIONS(33),
    [sym_hcoloreq_tok] = ACTIONS(25),
    [sym_hplot_tok] = ACTIONS(35),
    [sym_draw_tok] = ACTIONS(37),
    [sym_xdraw_tok] = ACTIONS(37),
    [sym_htab_tok] = ACTIONS(25),
    [sym_home_tok] = ACTIONS(9),
    [sym_roteq_tok] = ACTIONS(25),
    [sym_scaleeq_tok] = ACTIONS(25),
    [sym_shload_tok] = ACTIONS(9),
    [sym_trace_tok] = ACTIONS(9),
    [sym_notrace_tok] = ACTIONS(9),
    [sym_normal_tok] = ACTIONS(9),
    [sym_inverse_tok] = ACTIONS(9),
    [sym_flash_tok] = ACTIONS(9),
    [sym_coloreq_tok] = ACTIONS(25),
    [sym_pop_tok] = ACTIONS(9),
    [sym_vtab_tok] = ACTIONS(25),
    [sym_himem_tok] = ACTIONS(25),
    [sym_lomem_tok] = ACTIONS(25),
    [sym_onerr_tok] = ACTIONS(39),
    [sym_resume_tok] = ACTIONS(9),
    [sym_recall_tok] = ACTIONS(41),
    [sym_store_tok] = ACTIONS(41),
    [sym_speedeq_tok] = ACTIONS(25),
    [sym_let_tok] = ACTIONS(43),
    [sym_goto_tok] = ACTIONS(45),
    [sym_run_tok] = ACTIONS(47),
    [sym_if_tok] = ACTIONS(49),
    [sym_restore_tok] = ACTIONS(9),
    [sym_amp_tok] = ACTIONS(51),
    [sym_gosub_tok] = ACTIONS(45),
    [sym_return_tok] = ACTIONS(9),
    [sym_rem_tok] = ACTIONS(53),
    [sym_stop_tok] = ACTIONS(9),
    [sym_on_tok] = ACTIONS(55),
    [sym_wait_tok] = ACTIONS(57),
    [sym_load_tok] = ACTIONS(9),
    [sym_save_tok] = ACTIONS(9),
    [sym_def_tok] = ACTIONS(59),
    [sym_poke_tok] = ACTIONS(29),
    [sym_print_tok] = ACTIONS(61),
    [sym_cont_tok] = ACTIONS(9),
    [sym_list_tok] = ACTIONS(63),
    [sym_clear_tok] = ACTIONS(9),
    [sym_get_tok] = ACTIONS(23),
    [sym_new_tok] = ACTIONS(9),
    [sym__ext_name] = ACTIONS(67),
  },
  [5] = {
    [sym_statement] = STATE(309),
    [sym_terminal_statement] = STATE(347),
    [sym_assignment] = STATE(304),
    [sym__avar] = STATE(333),
    [sym_intvar] = STATE(333),
    [sym_realvar] = STATE(333),
    [sym_svar] = STATE(334),
    [sym__real_scalar] = STATE(148),
    [sym__int_scalar] = STATE(149),
    [sym__string_scalar] = STATE(131),
    [sym__real_array] = STATE(148),
    [sym__int_array] = STATE(149),
    [sym__string_array] = STATE(131),
    [sym__name] = STATE(121),
    [sym_end_tok] = ACTIONS(9),
    [sym_for_tok] = ACTIONS(11),
    [sym_next_tok] = ACTIONS(13),
    [sym_data_tok] = ACTIONS(15),
    [sym_input_tok] = ACTIONS(17),
    [sym_del_tok] = ACTIONS(19),
    [sym_dim_tok] = ACTIONS(21),
    [sym_read_tok] = ACTIONS(23),
    [sym_gr_tok] = ACTIONS(9),
    [sym_text_tok] = ACTIONS(9),
    [sym_prn_tok] = ACTIONS(25),
    [sym_inn_tok] = ACTIONS(25),
    [sym_call_tok] = ACTIONS(27),
    [sym_plot_tok] = ACTIONS(29),
    [sym_hlin_tok] = ACTIONS(31),
    [sym_vlin_tok] = ACTIONS(31),
    [sym_hgr2_tok] = ACTIONS(9),
    [sym_hgr_tok] = ACTIONS(33),
    [sym_hcoloreq_tok] = ACTIONS(25),
    [sym_hplot_tok] = ACTIONS(35),
    [sym_draw_tok] = ACTIONS(37),
    [sym_xdraw_tok] = ACTIONS(37),
    [sym_htab_tok] = ACTIONS(25),
    [sym_home_tok] = ACTIONS(9),
    [sym_roteq_tok] = ACTIONS(25),
    [sym_scaleeq_tok] = ACTIONS(25),
    [sym_shload_tok] = ACTIONS(9),
    [sym_trace_tok] = ACTIONS(9),
    [sym_notrace_tok] = ACTIONS(9),
    [sym_normal_tok] = ACTIONS(9),
    [sym_inverse_tok] = ACTIONS(9),
    [sym_flash_tok] = ACTIONS(9),
    [sym_coloreq_tok] = ACTIONS(25),
    [sym_pop_tok] = ACTIONS(9),
    [sym_vtab_tok] = ACTIONS(25),
    [sym_himem_tok] = ACTIONS(25),
    [sym_lomem_tok] = ACTIONS(25),
    [sym_onerr_tok] = ACTIONS(39),
    [sym_resume_tok] = ACTIONS(9),
    [sym_recall_tok] = ACTIONS(41),
    [sym_store_tok] = ACTIONS(41),
    [sym_speedeq_tok] = ACTIONS(25),
    [sym_let_tok] = ACTIONS(43),
    [sym_goto_tok] = ACTIONS(45),
    [sym_run_tok] = ACTIONS(47),
    [sym_if_tok] = ACTIONS(49),
    [sym_restore_tok] = ACTIONS(9),
    [sym_amp_tok] = ACTIONS(51),
    [sym_gosub_tok] = ACTIONS(45),
    [sym_return_tok] = ACTIONS(9),
    [sym_rem_tok] = ACTIONS(53),
    [sym_stop_tok] = ACTIONS(9),
    [sym_on_tok] = ACTIONS(55),
    [sym_wait_tok] = ACTIONS(57),
    [sym_load_tok] = ACTIONS(9),
    [sym_save_tok] = ACTIONS(9),
    [sym_def_tok] = ACTIONS(59),
    [sym_poke_tok] = ACTIONS(29),
    [sym_print_tok] = ACTIONS(61),
    [sym_cont_tok] = ACTIONS(9),
    [sym_list_tok] = ACTIONS(63),
    [sym_clear_tok] = ACTIONS(9),
    [sym_get_tok] = ACTIONS(23),
    [sym_new_tok] = ACTIONS(9),
    [sym_linenum] = ACTIONS(71),
    [sym__ext_name] = ACTIONS(67),
  },
  [6] = {
    [sym_statement] = STATE(241),
    [sym_terminal_statement] = STATE(302),
    [sym_assignment] = STATE(304),
    [sym__avar] = STATE(333),
    [sym_intvar] = STATE(333),
    [sym_realvar] = STATE(333),
    [sym_svar] = STATE(334),
    [sym__real_scalar] = STATE(148),
    [sym__int_scalar] = STATE(149),
    [sym__string_scalar] = STATE(131),
    [sym__real_array] = STATE(148),
    [sym__int_array] = STATE(149),
    [sym__string_array] = STATE(131),
    [sym__name] = STATE(121),
    [aux_sym_line_repeat2] = STATE(7),
    [sym_end_tok] = ACTIONS(9),
    [sym_for_tok] = ACTIONS(11),
    [sym_next_tok] = ACTIONS(13),
    [sym_data_tok] = ACTIONS(15),
    [sym_input_tok] = ACTIONS(17),
    [sym_del_tok] = ACTIONS(19),
    [sym_dim_tok] = ACTIONS(21),
    [sym_read_tok] = ACTIONS(23),
    [sym_gr_tok] = ACTIONS(9),
    [sym_text_tok] = ACTIONS(9),
    [sym_prn_tok] = ACTIONS(25),
    [sym_inn_tok] = ACTIONS(25),
    [sym_call_tok] = ACTIONS(27),
    [sym_plot_tok] = ACTIONS(29),
    [sym_hlin_tok] = ACTIONS(31),
    [sym_vlin_tok] = ACTIONS(31),
    [sym_hgr2_tok] = ACTIONS(9),
    [sym_hgr_tok] = ACTIONS(33),
    [sym_hcoloreq_tok] = ACTIONS(25),
    [sym_hplot_tok] = ACTIONS(35),
    [sym_draw_tok] = ACTIONS(37),
    [sym_xdraw_tok] = ACTIONS(37),
    [sym_htab_tok] = ACTIONS(25),
    [sym_home_tok] = ACTIONS(9),
    [sym_roteq_tok] = ACTIONS(25),
    [sym_scaleeq_tok] = ACTIONS(25),
    [sym_shload_tok] = ACTIONS(9),
    [sym_trace_tok] = ACTIONS(9),
    [sym_notrace_tok] = ACTIONS(9),
    [sym_normal_tok] = ACTIONS(9),
    [sym_inverse_tok] = ACTIONS(9),
    [sym_flash_tok] = ACTIONS(9),
    [sym_coloreq_tok] = ACTIONS(25),
    [sym_pop_tok] = ACTIONS(9),
    [sym_vtab_tok] = ACTIONS(25),
    [sym_himem_tok] = ACTIONS(25),
    [sym_lomem_tok] = ACTIONS(25),
    [sym_onerr_tok] = ACTIONS(39),
    [sym_resume_tok] = ACTIONS(9),
    [sym_recall_tok] = ACTIONS(41),
    [sym_store_tok] = ACTIONS(41),
    [sym_speedeq_tok] = ACTIONS(25),
    [sym_let_tok] = ACTIONS(43),
    [sym_goto_tok] = ACTIONS(45),
    [sym_run_tok] = ACTIONS(47),
    [sym_if_tok] = ACTIONS(49),
    [sym_restore_tok] = ACTIONS(9),
    [sym_amp_tok] = ACTIONS(51),
    [sym_gosub_tok] = ACTIONS(45),
    [sym_return_tok] = ACTIONS(9),
    [sym_rem_tok] = ACTIONS(53),
    [sym_stop_tok] = ACTIONS(9),
    [sym_on_tok] = ACTIONS(55),
    [sym_wait_tok] = ACTIONS(57),
    [sym_load_tok] = ACTIONS(9),
    [sym_save_tok] = ACTIONS(9),
    [sym_def_tok] = ACTIONS(59),
    [sym_poke_tok] = ACTIONS(29),
    [sym_print_tok] = ACTIONS(61),
    [sym_cont_tok] = ACTIONS(9),
    [sym_list_tok] = ACTIONS(63),
    [sym_clear_tok] = ACTIONS(9),
    [sym_get_tok] = ACTIONS(23),
    [sym_new_tok] = ACTIONS(9),
    [sym__ext_name] = ACTIONS(67),
  },
  [7] = {
    [sym_statement] = STATE(308),
    [sym_assignment] = STATE(304),
    [sym__avar] = STATE(333),
    [sym_intvar] = STATE(333),
    [sym_realvar] = STATE(333),
    [sym_svar] = STATE(334),
    [sym__real_scalar] = STATE(148),
    [sym__int_scalar] = STATE(149),
    [sym__string_scalar] = STATE(131),
    [sym__real_array] = STATE(148),
    [sym__int_array] = STATE(149),
    [sym__string_array] = STATE(131),
    [sym__name] = STATE(121),
    [aux_sym_line_repeat2] = STATE(7),
    [sym_end_tok] = ACTIONS(73),
    [sym_for_tok] = ACTIONS(76),
    [sym_next_tok] = ACTIONS(79),
    [sym_data_tok] = ACTIONS(82),
    [sym_input_tok] = ACTIONS(85),
    [sym_del_tok] = ACTIONS(88),
    [sym_dim_tok] = ACTIONS(91),
    [sym_read_tok] = ACTIONS(94),
    [sym_gr_tok] = ACTIONS(73),
    [sym_text_tok] = ACTIONS(73),
    [sym_prn_tok] = ACTIONS(97),
    [sym_inn_tok] = ACTIONS(97),
    [sym_call_tok] = ACTIONS(100),
    [sym_plot_tok] = ACTIONS(103),
    [sym_hlin_tok] = ACTIONS(106),
    [sym_vlin_tok] = ACTIONS(106),
    [sym_hgr2_tok] = ACTIONS(73),
    [sym_hgr_tok] = ACTIONS(109),
    [sym_hcoloreq_tok] = ACTIONS(97),
    [sym_hplot_tok] = ACTIONS(112),
    [sym_draw_tok] = ACTIONS(115),
    [sym_xdraw_tok] = ACTIONS(115),
    [sym_htab_tok] = ACTIONS(97),
    [sym_home_tok] = ACTIONS(73),
    [sym_roteq_tok] = ACTIONS(97),
    [sym_scaleeq_tok] = ACTIONS(97),
    [sym_shload_tok] = ACTIONS(73),
    [sym_trace_tok] = ACTIONS(73),
    [sym_notrace_tok] = ACTIONS(73),
    [sym_normal_tok] = ACTIONS(73),
    [sym_inverse_tok] = ACTIONS(73),
    [sym_flash_tok] = ACTIONS(73),
    [sym_coloreq_tok] = ACTIONS(97),
    [sym_pop_tok] = ACTIONS(73),
    [sym_vtab_tok] = ACTIONS(97),
    [sym_himem_tok] = ACTIONS(97),
    [sym_lomem_tok] = ACTIONS(97),
    [sym_onerr_tok] = ACTIONS(118),
    [sym_resume_tok] = ACTIONS(73),
    [sym_recall_tok] = ACTIONS(121),
    [sym_store_tok] = ACTIONS(121),
    [sym_speedeq_tok] = ACTIONS(97),
    [sym_let_tok] = ACTIONS(124),
    [sym_goto_tok] = ACTIONS(127),
    [sym_run_tok] = ACTIONS(130),
    [sym_if_tok] = ACTIONS(133),
    [sym_restore_tok] = ACTIONS(73),
    [sym_amp_tok] = ACTIONS(136),
    [sym_gosub_tok] = ACTIONS(127),
    [sym_return_tok] = ACTIONS(73),
    [sym_rem_tok] = ACTIONS(139),
    [sym_stop_tok] = ACTIONS(73),
    [sym_on_tok] = ACTIONS(142),
    [sym_wait_tok] = ACTIONS(145),
    [sym_load_tok] = ACTIONS(73),
    [sym_save_tok] = ACTIONS(73),
    [sym_def_tok] = ACTIONS(148),
    [sym_poke_tok] = ACTIONS(103),
    [sym_print_tok] = ACTIONS(151),
    [sym_cont_tok] = ACTIONS(73),
    [sym_list_tok] = ACTIONS(154),
    [sym_clear_tok] = ACTIONS(73),
    [sym_get_tok] = ACTIONS(94),
    [sym_new_tok] = ACTIONS(73),
    [sym__ext_name] = ACTIONS(157),
  },
  [8] = {
    [sym_statement] = STATE(309),
    [sym_assignment] = STATE(304),
    [sym__avar] = STATE(333),
    [sym_intvar] = STATE(333),
    [sym_realvar] = STATE(333),
    [sym_svar] = STATE(334),
    [sym__real_scalar] = STATE(148),
    [sym__int_scalar] = STATE(149),
    [sym__string_scalar] = STATE(131),
    [sym__real_array] = STATE(148),
    [sym__int_array] = STATE(149),
    [sym__string_array] = STATE(131),
    [sym__name] = STATE(121),
    [sym_end_tok] = ACTIONS(9),
    [sym_for_tok] = ACTIONS(11),
    [sym_next_tok] = ACTIONS(13),
    [sym_data_tok] = ACTIONS(160),
    [sym_input_tok] = ACTIONS(17),
    [sym_del_tok] = ACTIONS(19),
    [sym_dim_tok] = ACTIONS(21),
    [sym_read_tok] = ACTIONS(23),
    [sym_gr_tok] = ACTIONS(9),
    [sym_text_tok] = ACTIONS(9),
    [sym_prn_tok] = ACTIONS(25),
    [sym_inn_tok] = ACTIONS(25),
    [sym_call_tok] = ACTIONS(162),
    [sym_plot_tok] = ACTIONS(29),
    [sym_hlin_tok] = ACTIONS(31),
    [sym_vlin_tok] = ACTIONS(31),
    [sym_hgr2_tok] = ACTIONS(9),
    [sym_hgr_tok] = ACTIONS(33),
    [sym_hcoloreq_tok] = ACTIONS(25),
    [sym_hplot_tok] = ACTIONS(35),
    [sym_draw_tok] = ACTIONS(37),
    [sym_xdraw_tok] = ACTIONS(37),
    [sym_htab_tok] = ACTIONS(25),
    [sym_home_tok] = ACTIONS(9),
    [sym_roteq_tok] = ACTIONS(25),
    [sym_scaleeq_tok] = ACTIONS(25),
    [sym_shload_tok] = ACTIONS(9),
    [sym_trace_tok] = ACTIONS(9),
    [sym_notrace_tok] = ACTIONS(9),
    [sym_normal_tok] = ACTIONS(9),
    [sym_inverse_tok] = ACTIONS(9),
    [sym_flash_tok] = ACTIONS(9),
    [sym_coloreq_tok] = ACTIONS(25),
    [sym_pop_tok] = ACTIONS(9),
    [sym_vtab_tok] = ACTIONS(25),
    [sym_himem_tok] = ACTIONS(25),
    [sym_lomem_tok] = ACTIONS(25),
    [sym_onerr_tok] = ACTIONS(39),
    [sym_resume_tok] = ACTIONS(9),
    [sym_recall_tok] = ACTIONS(41),
    [sym_store_tok] = ACTIONS(41),
    [sym_speedeq_tok] = ACTIONS(25),
    [sym_let_tok] = ACTIONS(43),
    [sym_goto_tok] = ACTIONS(45),
    [sym_run_tok] = ACTIONS(47),
    [sym_if_tok] = ACTIONS(164),
    [sym_restore_tok] = ACTIONS(9),
    [sym_amp_tok] = ACTIONS(166),
    [sym_gosub_tok] = ACTIONS(45),
    [sym_return_tok] = ACTIONS(9),
    [sym_rem_tok] = ACTIONS(168),
    [sym_stop_tok] = ACTIONS(9),
    [sym_on_tok] = ACTIONS(55),
    [sym_wait_tok] = ACTIONS(57),
    [sym_load_tok] = ACTIONS(9),
    [sym_save_tok] = ACTIONS(9),
    [sym_def_tok] = ACTIONS(59),
    [sym_poke_tok] = ACTIONS(29),
    [sym_print_tok] = ACTIONS(170),
    [sym_cont_tok] = ACTIONS(9),
    [sym_list_tok] = ACTIONS(63),
    [sym_clear_tok] = ACTIONS(9),
    [sym_get_tok] = ACTIONS(23),
    [sym_new_tok] = ACTIONS(9),
    [sym_linenum] = ACTIONS(71),
    [sym__ext_name] = ACTIONS(67),
  },
  [9] = {
    [sym__newline] = STATE(269),
    [aux_sym_line_repeat1] = STATE(12),
    [sym_end_tok] = ACTIONS(172),
    [sym_for_tok] = ACTIONS(172),
    [sym_next_tok] = ACTIONS(172),
    [sym_data_tok] = ACTIONS(172),
    [sym_input_tok] = ACTIONS(172),
    [sym_del_tok] = ACTIONS(172),
    [sym_dim_tok] = ACTIONS(172),
    [sym_read_tok] = ACTIONS(172),
    [sym_gr_tok] = ACTIONS(172),
    [sym_text_tok] = ACTIONS(172),
    [sym_prn_tok] = ACTIONS(172),
    [sym_inn_tok] = ACTIONS(172),
    [sym_call_tok] = ACTIONS(172),
    [sym_plot_tok] = ACTIONS(172),
    [sym_hlin_tok] = ACTIONS(172),
    [sym_vlin_tok] = ACTIONS(172),
    [sym_hgr2_tok] = ACTIONS(172),
    [sym_hgr_tok] = ACTIONS(174),
    [sym_hcoloreq_tok] = ACTIONS(172),
    [sym_hplot_tok] = ACTIONS(172),
    [sym_draw_tok] = ACTIONS(172),
    [sym_xdraw_tok] = ACTIONS(172),
    [sym_htab_tok] = ACTIONS(172),
    [sym_home_tok] = ACTIONS(172),
    [sym_roteq_tok] = ACTIONS(172),
    [sym_scaleeq_tok] = ACTIONS(172),
    [sym_shload_tok] = ACTIONS(172),
    [sym_trace_tok] = ACTIONS(172),
    [sym_notrace_tok] = ACTIONS(172),
    [sym_normal_tok] = ACTIONS(172),
    [sym_inverse_tok] = ACTIONS(172),
    [sym_flash_tok] = ACTIONS(172),
    [sym_coloreq_tok] = ACTIONS(172),
    [sym_pop_tok] = ACTIONS(172),
    [sym_vtab_tok] = ACTIONS(172),
    [sym_himem_tok] = ACTIONS(172),
    [sym_lomem_tok] = ACTIONS(172),
    [sym_onerr_tok] = ACTIONS(172),
    [sym_resume_tok] = ACTIONS(172),
    [sym_recall_tok] = ACTIONS(172),
    [sym_store_tok] = ACTIONS(172),
    [sym_speedeq_tok] = ACTIONS(172),
    [sym_let_tok] = ACTIONS(172),
    [sym_goto_tok] = ACTIONS(172),
    [sym_run_tok] = ACTIONS(172),
    [sym_if_tok] = ACTIONS(172),
    [sym_restore_tok] = ACTIONS(172),
    [sym_amp_tok] = ACTIONS(172),
    [sym_gosub_tok] = ACTIONS(172),
    [sym_return_tok] = ACTIONS(172),
    [sym_rem_tok] = ACTIONS(172),
    [sym_stop_tok] = ACTIONS(172),
    [sym_on_tok] = ACTIONS(174),
    [sym_wait_tok] = ACTIONS(172),
    [sym_load_tok] = ACTIONS(172),
    [sym_save_tok] = ACTIONS(172),
    [sym_def_tok] = ACTIONS(172),
    [sym_poke_tok] = ACTIONS(172),
    [sym_print_tok] = ACTIONS(172),
    [sym_cont_tok] = ACTIONS(172),
    [sym_list_tok] = ACTIONS(172),
    [sym_clear_tok] = ACTIONS(172),
    [sym_get_tok] = ACTIONS(172),
    [sym_new_tok] = ACTIONS(172),
    [anon_sym_COLON] = ACTIONS(69),
    [aux_sym__newline_token1] = ACTIONS(176),
    [sym__ext_name] = ACTIONS(172),
  },
  [10] = {
    [sym__newline] = STATE(273),
    [aux_sym_line_repeat1] = STATE(12),
    [sym_end_tok] = ACTIONS(172),
    [sym_for_tok] = ACTIONS(172),
    [sym_next_tok] = ACTIONS(172),
    [sym_data_tok] = ACTIONS(172),
    [sym_input_tok] = ACTIONS(172),
    [sym_del_tok] = ACTIONS(172),
    [sym_dim_tok] = ACTIONS(172),
    [sym_read_tok] = ACTIONS(172),
    [sym_gr_tok] = ACTIONS(172),
    [sym_text_tok] = ACTIONS(172),
    [sym_prn_tok] = ACTIONS(172),
    [sym_inn_tok] = ACTIONS(172),
    [sym_call_tok] = ACTIONS(172),
    [sym_plot_tok] = ACTIONS(172),
    [sym_hlin_tok] = ACTIONS(172),
    [sym_vlin_tok] = ACTIONS(172),
    [sym_hgr2_tok] = ACTIONS(172),
    [sym_hgr_tok] = ACTIONS(174),
    [sym_hcoloreq_tok] = ACTIONS(172),
    [sym_hplot_tok] = ACTIONS(172),
    [sym_draw_tok] = ACTIONS(172),
    [sym_xdraw_tok] = ACTIONS(172),
    [sym_htab_tok] = ACTIONS(172),
    [sym_home_tok] = ACTIONS(172),
    [sym_roteq_tok] = ACTIONS(172),
    [sym_scaleeq_tok] = ACTIONS(172),
    [sym_shload_tok] = ACTIONS(172),
    [sym_trace_tok] = ACTIONS(172),
    [sym_notrace_tok] = ACTIONS(172),
    [sym_normal_tok] = ACTIONS(172),
    [sym_inverse_tok] = ACTIONS(172),
    [sym_flash_tok] = ACTIONS(172),
    [sym_coloreq_tok] = ACTIONS(172),
    [sym_pop_tok] = ACTIONS(172),
    [sym_vtab_tok] = ACTIONS(172),
    [sym_himem_tok] = ACTIONS(172),
    [sym_lomem_tok] = ACTIONS(172),
    [sym_onerr_tok] = ACTIONS(172),
    [sym_resume_tok] = ACTIONS(172),
    [sym_recall_tok] = ACTIONS(172),
    [sym_store_tok] = ACTIONS(172),
    [sym_speedeq_tok] = ACTIONS(172),
    [sym_let_tok] = ACTIONS(172),
    [sym_goto_tok] = ACTIONS(172),
    [sym_run_tok] = ACTIONS(172),
    [sym_if_tok] = ACTIONS(172),
    [sym_restore_tok] = ACTIONS(172),
    [sym_amp_tok] = ACTIONS(172),
    [sym_gosub_tok] = ACTIONS(172),
    [sym_return_tok] = ACTIONS(172),
    [sym_rem_tok] = ACTIONS(172),
    [sym_stop_tok] = ACTIONS(172),
    [sym_on_tok] = ACTIONS(174),
    [sym_wait_tok] = ACTIONS(172),
    [sym_load_tok] = ACTIONS(172),
    [sym_save_tok] = ACTIONS(172),
    [sym_def_tok] = ACTIONS(172),
    [sym_poke_tok] = ACTIONS(172),
    [sym_print_tok] = ACTIONS(172),
    [sym_cont_tok] = ACTIONS(172),
    [sym_list_tok] = ACTIONS(172),
    [sym_clear_tok] = ACTIONS(172),
    [sym_get_tok] = ACTIONS(172),
    [sym_new_tok] = ACTIONS(172),
    [anon_sym_COLON] = ACTIONS(69),
    [aux_sym__newline_token1] = ACTIONS(178),
    [sym__ext_name] = ACTIONS(172),
  },
  [11] = {
    [sym__newline] = STATE(294),
    [aux_sym_line_repeat1] = STATE(12),
    [sym_end_tok] = ACTIONS(172),
    [sym_for_tok] = ACTIONS(172),
    [sym_next_tok] = ACTIONS(172),
    [sym_data_tok] = ACTIONS(172),
    [sym_input_tok] = ACTIONS(172),
    [sym_del_tok] = ACTIONS(172),
    [sym_dim_tok] = ACTIONS(172),
    [sym_read_tok] = ACTIONS(172),
    [sym_gr_tok] = ACTIONS(172),
    [sym_text_tok] = ACTIONS(172),
    [sym_prn_tok] = ACTIONS(172),
    [sym_inn_tok] = ACTIONS(172),
    [sym_call_tok] = ACTIONS(172),
    [sym_plot_tok] = ACTIONS(172),
    [sym_hlin_tok] = ACTIONS(172),
    [sym_vlin_tok] = ACTIONS(172),
    [sym_hgr2_tok] = ACTIONS(172),
    [sym_hgr_tok] = ACTIONS(174),
    [sym_hcoloreq_tok] = ACTIONS(172),
    [sym_hplot_tok] = ACTIONS(172),
    [sym_draw_tok] = ACTIONS(172),
    [sym_xdraw_tok] = ACTIONS(172),
    [sym_htab_tok] = ACTIONS(172),
    [sym_home_tok] = ACTIONS(172),
    [sym_roteq_tok] = ACTIONS(172),
    [sym_scaleeq_tok] = ACTIONS(172),
    [sym_shload_tok] = ACTIONS(172),
    [sym_trace_tok] = ACTIONS(172),
    [sym_notrace_tok] = ACTIONS(172),
    [sym_normal_tok] = ACTIONS(172),
    [sym_inverse_tok] = ACTIONS(172),
    [sym_flash_tok] = ACTIONS(172),
    [sym_coloreq_tok] = ACTIONS(172),
    [sym_pop_tok] = ACTIONS(172),
    [sym_vtab_tok] = ACTIONS(172),
    [sym_himem_tok] = ACTIONS(172),
    [sym_lomem_tok] = ACTIONS(172),
    [sym_onerr_tok] = ACTIONS(172),
    [sym_resume_tok] = ACTIONS(172),
    [sym_recall_tok] = ACTIONS(172),
    [sym_store_tok] = ACTIONS(172),
    [sym_speedeq_tok] = ACTIONS(172),
    [sym_let_tok] = ACTIONS(172),
    [sym_goto_tok] = ACTIONS(172),
    [sym_run_tok] = ACTIONS(172),
    [sym_if_tok] = ACTIONS(172),
    [sym_restore_tok] = ACTIONS(172),
    [sym_amp_tok] = ACTIONS(172),
    [sym_gosub_tok] = ACTIONS(172),
    [sym_return_tok] = ACTIONS(172),
    [sym_rem_tok] = ACTIONS(172),
    [sym_stop_tok] = ACTIONS(172),
    [sym_on_tok] = ACTIONS(174),
    [sym_wait_tok] = ACTIONS(172),
    [sym_load_tok] = ACTIONS(172),
    [sym_save_tok] = ACTIONS(172),
    [sym_def_tok] = ACTIONS(172),
    [sym_poke_tok] = ACTIONS(172),
    [sym_print_tok] = ACTIONS(172),
    [sym_cont_tok] = ACTIONS(172),
    [sym_list_tok] = ACTIONS(172),
    [sym_clear_tok] = ACTIONS(172),
    [sym_get_tok] = ACTIONS(172),
    [sym_new_tok] = ACTIONS(172),
    [anon_sym_COLON] = ACTIONS(69),
    [aux_sym__newline_token1] = ACTIONS(180),
    [sym__ext_name] = ACTIONS(172),
  },
  [12] = {
    [aux_sym_line_repeat1] = STATE(12),
    [sym_end_tok] = ACTIONS(182),
    [sym_for_tok] = ACTIONS(182),
    [sym_next_tok] = ACTIONS(182),
    [sym_data_tok] = ACTIONS(182),
    [sym_input_tok] = ACTIONS(182),
    [sym_del_tok] = ACTIONS(182),
    [sym_dim_tok] = ACTIONS(182),
    [sym_read_tok] = ACTIONS(182),
    [sym_gr_tok] = ACTIONS(182),
    [sym_text_tok] = ACTIONS(182),
    [sym_prn_tok] = ACTIONS(182),
    [sym_inn_tok] = ACTIONS(182),
    [sym_call_tok] = ACTIONS(182),
    [sym_plot_tok] = ACTIONS(182),
    [sym_hlin_tok] = ACTIONS(182),
    [sym_vlin_tok] = ACTIONS(182),
    [sym_hgr2_tok] = ACTIONS(182),
    [sym_hgr_tok] = ACTIONS(184),
    [sym_hcoloreq_tok] = ACTIONS(182),
    [sym_hplot_tok] = ACTIONS(182),
    [sym_draw_tok] = ACTIONS(182),
    [sym_xdraw_tok] = ACTIONS(182),
    [sym_htab_tok] = ACTIONS(182),
    [sym_home_tok] = ACTIONS(182),
    [sym_roteq_tok] = ACTIONS(182),
    [sym_scaleeq_tok] = ACTIONS(182),
    [sym_shload_tok] = ACTIONS(182),
    [sym_trace_tok] = ACTIONS(182),
    [sym_notrace_tok] = ACTIONS(182),
    [sym_normal_tok] = ACTIONS(182),
    [sym_inverse_tok] = ACTIONS(182),
    [sym_flash_tok] = ACTIONS(182),
    [sym_coloreq_tok] = ACTIONS(182),
    [sym_pop_tok] = ACTIONS(182),
    [sym_vtab_tok] = ACTIONS(182),
    [sym_himem_tok] = ACTIONS(182),
    [sym_lomem_tok] = ACTIONS(182),
    [sym_onerr_tok] = ACTIONS(182),
    [sym_resume_tok] = ACTIONS(182),
    [sym_recall_tok] = ACTIONS(182),
    [sym_store_tok] = ACTIONS(182),
    [sym_speedeq_tok] = ACTIONS(182),
    [sym_let_tok] = ACTIONS(182),
    [sym_goto_tok] = ACTIONS(182),
    [sym_run_tok] = ACTIONS(182),
    [sym_if_tok] = ACTIONS(182),
    [sym_restore_tok] = ACTIONS(182),
    [sym_amp_tok] = ACTIONS(182),
    [sym_gosub_tok] = ACTIONS(182),
    [sym_return_tok] = ACTIONS(182),
    [sym_rem_tok] = ACTIONS(182),
    [sym_stop_tok] = ACTIONS(182),
    [sym_on_tok] = ACTIONS(184),
    [sym_wait_tok] = ACTIONS(182),
    [sym_load_tok] = ACTIONS(182),
    [sym_save_tok] = ACTIONS(182),
    [sym_def_tok] = ACTIONS(182),
    [sym_poke_tok] = ACTIONS(182),
    [sym_print_tok] = ACTIONS(182),
    [sym_cont_tok] = ACTIONS(182),
    [sym_list_tok] = ACTIONS(182),
    [sym_clear_tok] = ACTIONS(182),
    [sym_get_tok] = ACTIONS(182),
    [sym_new_tok] = ACTIONS(182),
    [anon_sym_COLON] = ACTIONS(186),
    [aux_sym__newline_token1] = ACTIONS(182),
    [sym__ext_name] = ACTIONS(182),
  },
  [13] = {
    [aux_sym_line_repeat1] = STATE(12),
    [sym_end_tok] = ACTIONS(172),
    [sym_for_tok] = ACTIONS(172),
    [sym_next_tok] = ACTIONS(172),
    [sym_data_tok] = ACTIONS(172),
    [sym_input_tok] = ACTIONS(172),
    [sym_del_tok] = ACTIONS(172),
    [sym_dim_tok] = ACTIONS(172),
    [sym_read_tok] = ACTIONS(172),
    [sym_gr_tok] = ACTIONS(172),
    [sym_text_tok] = ACTIONS(172),
    [sym_prn_tok] = ACTIONS(172),
    [sym_inn_tok] = ACTIONS(172),
    [sym_call_tok] = ACTIONS(172),
    [sym_plot_tok] = ACTIONS(172),
    [sym_hlin_tok] = ACTIONS(172),
    [sym_vlin_tok] = ACTIONS(172),
    [sym_hgr2_tok] = ACTIONS(172),
    [sym_hgr_tok] = ACTIONS(174),
    [sym_hcoloreq_tok] = ACTIONS(172),
    [sym_hplot_tok] = ACTIONS(172),
    [sym_draw_tok] = ACTIONS(172),
    [sym_xdraw_tok] = ACTIONS(172),
    [sym_htab_tok] = ACTIONS(172),
    [sym_home_tok] = ACTIONS(172),
    [sym_roteq_tok] = ACTIONS(172),
    [sym_scaleeq_tok] = ACTIONS(172),
    [sym_shload_tok] = ACTIONS(172),
    [sym_trace_tok] = ACTIONS(172),
    [sym_notrace_tok] = ACTIONS(172),
    [sym_normal_tok] = ACTIONS(172),
    [sym_inverse_tok] = ACTIONS(172),
    [sym_flash_tok] = ACTIONS(172),
    [sym_coloreq_tok] = ACTIONS(172),
    [sym_pop_tok] = ACTIONS(172),
    [sym_vtab_tok] = ACTIONS(172),
    [sym_himem_tok] = ACTIONS(172),
    [sym_lomem_tok] = ACTIONS(172),
    [sym_onerr_tok] = ACTIONS(172),
    [sym_resume_tok] = ACTIONS(172),
    [sym_recall_tok] = ACTIONS(172),
    [sym_store_tok] = ACTIONS(172),
    [sym_speedeq_tok] = ACTIONS(172),
    [sym_let_tok] = ACTIONS(172),
    [sym_goto_tok] = ACTIONS(172),
    [sym_run_tok] = ACTIONS(172),
    [sym_if_tok] = ACTIONS(172),
    [sym_restore_tok] = ACTIONS(172),
    [sym_amp_tok] = ACTIONS(172),
    [sym_gosub_tok] = ACTIONS(172),
    [sym_return_tok] = ACTIONS(172),
    [sym_rem_tok] = ACTIONS(172),
    [sym_stop_tok] = ACTIONS(172),
    [sym_on_tok] = ACTIONS(174),
    [sym_wait_tok] = ACTIONS(172),
    [sym_load_tok] = ACTIONS(172),
    [sym_save_tok] = ACTIONS(172),
    [sym_def_tok] = ACTIONS(172),
    [sym_poke_tok] = ACTIONS(172),
    [sym_print_tok] = ACTIONS(172),
    [sym_cont_tok] = ACTIONS(172),
    [sym_list_tok] = ACTIONS(172),
    [sym_clear_tok] = ACTIONS(172),
    [sym_get_tok] = ACTIONS(172),
    [sym_new_tok] = ACTIONS(172),
    [anon_sym_COLON] = ACTIONS(69),
    [sym__ext_name] = ACTIONS(172),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 26,
    ACTIONS(191), 1,
      sym_fn_tok,
    ACTIONS(193), 1,
      sym_not_tok,
    ACTIONS(201), 1,
      sym_scrnp_tok,
    ACTIONS(209), 1,
      sym_mid_tok,
    ACTIONS(213), 1,
      anon_sym_LPAREN,
    ACTIONS(217), 1,
      sym_integer,
    ACTIONS(219), 1,
      sym_real,
    ACTIONS(221), 1,
      sym_string,
    ACTIONS(223), 1,
      sym_terminal_string,
    ACTIONS(225), 1,
      sym__ext_name,
    STATE(85), 1,
      sym__name,
    ACTIONS(189), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(195), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(199), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(205), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(207), 2,
      sym_left_tok,
      sym_right_tok,
    ACTIONS(211), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(215), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
    STATE(16), 2,
      sym__expr,
      aux_sym_statement_repeat7,
    STATE(104), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(105), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(106), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(203), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(116), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(88), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(197), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [116] = 26,
    ACTIONS(191), 1,
      sym_fn_tok,
    ACTIONS(193), 1,
      sym_not_tok,
    ACTIONS(201), 1,
      sym_scrnp_tok,
    ACTIONS(209), 1,
      sym_mid_tok,
    ACTIONS(213), 1,
      anon_sym_LPAREN,
    ACTIONS(217), 1,
      sym_integer,
    ACTIONS(219), 1,
      sym_real,
    ACTIONS(221), 1,
      sym_string,
    ACTIONS(225), 1,
      sym__ext_name,
    ACTIONS(231), 1,
      sym_terminal_string,
    STATE(85), 1,
      sym__name,
    ACTIONS(189), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(195), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(199), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(205), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(207), 2,
      sym_left_tok,
      sym_right_tok,
    ACTIONS(227), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(229), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
    STATE(14), 2,
      sym__expr,
      aux_sym_statement_repeat7,
    STATE(104), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(105), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(106), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(203), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(116), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(88), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(197), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [232] = 26,
    ACTIONS(236), 1,
      sym_fn_tok,
    ACTIONS(239), 1,
      sym_not_tok,
    ACTIONS(251), 1,
      sym_scrnp_tok,
    ACTIONS(263), 1,
      sym_mid_tok,
    ACTIONS(269), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym_integer,
    ACTIONS(277), 1,
      sym_real,
    ACTIONS(280), 1,
      sym_string,
    ACTIONS(283), 1,
      sym_terminal_string,
    ACTIONS(285), 1,
      sym__ext_name,
    STATE(85), 1,
      sym__name,
    ACTIONS(233), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(242), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(248), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(257), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(260), 2,
      sym_left_tok,
      sym_right_tok,
    ACTIONS(266), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(272), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
    STATE(16), 2,
      sym__expr,
      aux_sym_statement_repeat7,
    STATE(104), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(105), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(106), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(116), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(88), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(245), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [348] = 25,
    ACTIONS(191), 1,
      sym_fn_tok,
    ACTIONS(193), 1,
      sym_not_tok,
    ACTIONS(201), 1,
      sym_scrnp_tok,
    ACTIONS(209), 1,
      sym_mid_tok,
    ACTIONS(213), 1,
      anon_sym_LPAREN,
    ACTIONS(215), 1,
      anon_sym_COLON,
    ACTIONS(217), 1,
      sym_integer,
    ACTIONS(219), 1,
      sym_real,
    ACTIONS(221), 1,
      sym_string,
    ACTIONS(225), 1,
      sym__ext_name,
    STATE(85), 1,
      sym__name,
    ACTIONS(189), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(195), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(199), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(205), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(207), 2,
      sym_left_tok,
      sym_right_tok,
    ACTIONS(211), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    STATE(16), 2,
      sym__expr,
      aux_sym_statement_repeat7,
    STATE(104), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(105), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(106), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(203), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(116), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(88), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(197), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [460] = 25,
    ACTIONS(191), 1,
      sym_fn_tok,
    ACTIONS(193), 1,
      sym_not_tok,
    ACTIONS(201), 1,
      sym_scrnp_tok,
    ACTIONS(209), 1,
      sym_mid_tok,
    ACTIONS(213), 1,
      anon_sym_LPAREN,
    ACTIONS(217), 1,
      sym_integer,
    ACTIONS(219), 1,
      sym_real,
    ACTIONS(221), 1,
      sym_string,
    ACTIONS(225), 1,
      sym__ext_name,
    ACTIONS(229), 1,
      anon_sym_COLON,
    STATE(85), 1,
      sym__name,
    ACTIONS(189), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(195), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(199), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(205), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(207), 2,
      sym_left_tok,
      sym_right_tok,
    ACTIONS(288), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    STATE(17), 2,
      sym__expr,
      aux_sym_statement_repeat7,
    STATE(104), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(105), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(106), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(203), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(116), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(88), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(197), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [572] = 23,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(314), 1,
      sym_integer,
    ACTIONS(316), 1,
      sym_real,
    ACTIONS(318), 1,
      sym_string,
    STATE(121), 1,
      sym__name,
    STATE(285), 1,
      sym__expr,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(217), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(165), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [676] = 23,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(314), 1,
      sym_integer,
    ACTIONS(316), 1,
      sym_real,
    ACTIONS(318), 1,
      sym_string,
    STATE(121), 1,
      sym__name,
    STATE(328), 1,
      sym__expr,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(217), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(165), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [780] = 23,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      sym_to_tok,
    ACTIONS(322), 1,
      sym_integer,
    ACTIONS(324), 1,
      sym_real,
    ACTIONS(326), 1,
      sym_string,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(194), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [884] = 23,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(314), 1,
      sym_integer,
    ACTIONS(316), 1,
      sym_real,
    ACTIONS(318), 1,
      sym_string,
    STATE(121), 1,
      sym__name,
    STATE(310), 1,
      sym__expr,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(217), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(165), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [988] = 23,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(314), 1,
      sym_integer,
    ACTIONS(316), 1,
      sym_real,
    ACTIONS(318), 1,
      sym_string,
    STATE(121), 1,
      sym__name,
    STATE(345), 1,
      sym__expr,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(217), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(165), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1092] = 23,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(314), 1,
      sym_integer,
    ACTIONS(316), 1,
      sym_real,
    ACTIONS(318), 1,
      sym_string,
    STATE(121), 1,
      sym__name,
    STATE(316), 1,
      sym__expr,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(217), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(165), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1196] = 23,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(314), 1,
      sym_integer,
    ACTIONS(316), 1,
      sym_real,
    ACTIONS(318), 1,
      sym_string,
    STATE(121), 1,
      sym__name,
    STATE(303), 1,
      sym__expr,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(217), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(165), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1300] = 22,
    ACTIONS(191), 1,
      sym_fn_tok,
    ACTIONS(193), 1,
      sym_not_tok,
    ACTIONS(201), 1,
      sym_scrnp_tok,
    ACTIONS(225), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(328), 1,
      anon_sym_LPAREN,
    ACTIONS(330), 1,
      sym_integer,
    ACTIONS(332), 1,
      sym_real,
    ACTIONS(334), 1,
      sym_string,
    STATE(86), 1,
      sym__name,
    ACTIONS(195), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(199), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(105), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(106), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(203), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(225), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(93), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(197), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1401] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(336), 1,
      sym_integer,
    ACTIONS(338), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(174), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1502] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(340), 1,
      sym_integer,
    ACTIONS(342), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(172), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1603] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(344), 1,
      sym_integer,
    ACTIONS(346), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(202), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1704] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(348), 1,
      sym_integer,
    ACTIONS(350), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(199), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1805] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(352), 1,
      sym_integer,
    ACTIONS(354), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(170), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1906] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      sym_integer,
    ACTIONS(358), 1,
      sym_real,
    ACTIONS(360), 1,
      sym_string,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(222), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(195), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2007] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(362), 1,
      sym_integer,
    ACTIONS(364), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(208), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2108] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(366), 1,
      sym_integer,
    ACTIONS(368), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(191), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2209] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(370), 1,
      sym_integer,
    ACTIONS(372), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(186), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2310] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(374), 1,
      sym_integer,
    ACTIONS(376), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(189), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2411] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(378), 1,
      sym_integer,
    ACTIONS(380), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(182), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2512] = 22,
    ACTIONS(191), 1,
      sym_fn_tok,
    ACTIONS(193), 1,
      sym_not_tok,
    ACTIONS(201), 1,
      sym_scrnp_tok,
    ACTIONS(225), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(328), 1,
      anon_sym_LPAREN,
    ACTIONS(334), 1,
      sym_string,
    ACTIONS(382), 1,
      sym_integer,
    ACTIONS(384), 1,
      sym_real,
    STATE(86), 1,
      sym__name,
    ACTIONS(195), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(199), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(105), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(106), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(203), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(225), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(91), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(197), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2613] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(386), 1,
      sym_integer,
    ACTIONS(388), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(169), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2714] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(390), 1,
      sym_integer,
    ACTIONS(392), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(171), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2815] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(394), 1,
      sym_integer,
    ACTIONS(396), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(167), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2916] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(398), 1,
      sym_integer,
    ACTIONS(400), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(178), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3017] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(402), 1,
      sym_integer,
    ACTIONS(404), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(212), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3118] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(406), 1,
      sym_integer,
    ACTIONS(408), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(166), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3219] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(410), 1,
      sym_integer,
    ACTIONS(412), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(213), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3320] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(414), 1,
      sym_integer,
    ACTIONS(416), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(175), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3421] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(418), 1,
      sym_integer,
    ACTIONS(420), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(128), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3522] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(422), 1,
      sym_integer,
    ACTIONS(424), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(136), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3623] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(426), 1,
      sym_integer,
    ACTIONS(428), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(203), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3724] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      sym_integer,
    ACTIONS(358), 1,
      sym_real,
    ACTIONS(430), 1,
      sym_string,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(221), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(195), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3825] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(432), 1,
      sym_integer,
    ACTIONS(434), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(206), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3926] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(436), 1,
      sym_integer,
    ACTIONS(438), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(176), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4027] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(440), 1,
      sym_integer,
    ACTIONS(442), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(198), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4128] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(444), 1,
      sym_integer,
    ACTIONS(446), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(173), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4229] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(448), 1,
      sym_integer,
    ACTIONS(450), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(180), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4330] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(452), 1,
      sym_integer,
    ACTIONS(454), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(205), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4431] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(456), 1,
      sym_integer,
    ACTIONS(458), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(142), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4532] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(460), 1,
      sym_integer,
    ACTIONS(462), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(143), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4633] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(464), 1,
      sym_integer,
    ACTIONS(466), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(204), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4734] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(468), 1,
      sym_integer,
    ACTIONS(470), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(141), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4835] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(472), 1,
      sym_integer,
    ACTIONS(474), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(138), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4936] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(476), 1,
      sym_integer,
    ACTIONS(478), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(201), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5037] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(480), 1,
      sym_integer,
    ACTIONS(482), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(193), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5138] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(484), 1,
      sym_integer,
    ACTIONS(486), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(192), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5239] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(488), 1,
      sym_integer,
    ACTIONS(490), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(132), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5340] = 22,
    ACTIONS(191), 1,
      sym_fn_tok,
    ACTIONS(193), 1,
      sym_not_tok,
    ACTIONS(201), 1,
      sym_scrnp_tok,
    ACTIONS(225), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(328), 1,
      anon_sym_LPAREN,
    ACTIONS(334), 1,
      sym_string,
    ACTIONS(492), 1,
      sym_integer,
    ACTIONS(494), 1,
      sym_real,
    STATE(86), 1,
      sym__name,
    ACTIONS(195), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(199), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(105), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(106), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(203), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(225), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(98), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(197), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5441] = 22,
    ACTIONS(191), 1,
      sym_fn_tok,
    ACTIONS(193), 1,
      sym_not_tok,
    ACTIONS(201), 1,
      sym_scrnp_tok,
    ACTIONS(225), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(328), 1,
      anon_sym_LPAREN,
    ACTIONS(334), 1,
      sym_string,
    ACTIONS(496), 1,
      sym_integer,
    ACTIONS(498), 1,
      sym_real,
    STATE(86), 1,
      sym__name,
    ACTIONS(195), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(199), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(105), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(106), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(203), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(225), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(97), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(197), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5542] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(500), 1,
      sym_integer,
    ACTIONS(502), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(209), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5643] = 22,
    ACTIONS(191), 1,
      sym_fn_tok,
    ACTIONS(193), 1,
      sym_not_tok,
    ACTIONS(201), 1,
      sym_scrnp_tok,
    ACTIONS(225), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(328), 1,
      anon_sym_LPAREN,
    ACTIONS(334), 1,
      sym_string,
    ACTIONS(504), 1,
      sym_integer,
    ACTIONS(506), 1,
      sym_real,
    STATE(86), 1,
      sym__name,
    ACTIONS(195), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(199), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(105), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(106), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(203), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(225), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(96), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(197), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5744] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_string,
    ACTIONS(508), 1,
      sym_integer,
    ACTIONS(510), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(221), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(210), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5845] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(512), 1,
      sym_integer,
    ACTIONS(514), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(214), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5946] = 22,
    ACTIONS(191), 1,
      sym_fn_tok,
    ACTIONS(193), 1,
      sym_not_tok,
    ACTIONS(201), 1,
      sym_scrnp_tok,
    ACTIONS(225), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(328), 1,
      anon_sym_LPAREN,
    ACTIONS(334), 1,
      sym_string,
    ACTIONS(516), 1,
      sym_integer,
    ACTIONS(518), 1,
      sym_real,
    STATE(86), 1,
      sym__name,
    ACTIONS(195), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(199), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(105), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(106), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(203), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(225), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(95), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(197), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6047] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(520), 1,
      sym_integer,
    ACTIONS(522), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(200), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6148] = 22,
    ACTIONS(191), 1,
      sym_fn_tok,
    ACTIONS(193), 1,
      sym_not_tok,
    ACTIONS(201), 1,
      sym_scrnp_tok,
    ACTIONS(225), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(328), 1,
      anon_sym_LPAREN,
    ACTIONS(334), 1,
      sym_string,
    ACTIONS(524), 1,
      sym_integer,
    ACTIONS(526), 1,
      sym_real,
    STATE(86), 1,
      sym__name,
    ACTIONS(195), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(199), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(105), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(106), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(203), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(225), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(94), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(197), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6249] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(528), 1,
      sym_integer,
    ACTIONS(530), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(196), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6350] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(532), 1,
      sym_integer,
    ACTIONS(534), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(190), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6451] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(536), 1,
      sym_integer,
    ACTIONS(538), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(177), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6552] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(540), 1,
      sym_integer,
    ACTIONS(542), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(185), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6653] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(544), 1,
      sym_integer,
    ACTIONS(546), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(187), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6754] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(548), 1,
      sym_integer,
    ACTIONS(550), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(197), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6855] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(552), 1,
      sym_integer,
    ACTIONS(554), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(188), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6956] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(556), 1,
      sym_integer,
    ACTIONS(558), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(181), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [7057] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(560), 1,
      sym_integer,
    ACTIONS(562), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(168), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [7158] = 22,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(292), 1,
      sym_fn_tok,
    ACTIONS(294), 1,
      sym_not_tok,
    ACTIONS(302), 1,
      sym_scrnp_tok,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(312), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_string,
    ACTIONS(564), 1,
      sym_integer,
    ACTIONS(566), 1,
      sym_real,
    STATE(121), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(296), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(300), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(304), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(223), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(207), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(298), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [7259] = 6,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_PERCENT,
    ACTIONS(576), 1,
      anon_sym_DOLLAR,
    STATE(101), 1,
      sym_subscript,
    ACTIONS(570), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(568), 44,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [7324] = 6,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_PERCENT,
    ACTIONS(578), 1,
      anon_sym_DOLLAR,
    STATE(101), 1,
      sym_subscript,
    ACTIONS(570), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(568), 44,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [7389] = 2,
    ACTIONS(582), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(580), 47,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
  [7445] = 11,
    ACTIONS(590), 1,
      sym_pow_tok,
    ACTIONS(592), 1,
      sym_and_tok,
    ACTIONS(594), 1,
      sym_or_tok,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    STATE(66), 1,
      sym__relop,
    ACTIONS(586), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(588), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(602), 2,
      sym_integer,
      sym_terminal_string,
    ACTIONS(584), 37,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [7518] = 4,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    STATE(108), 1,
      sym_subscript,
    ACTIONS(606), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(604), 44,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [7577] = 4,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    STATE(109), 1,
      sym_subscript,
    ACTIONS(610), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(608), 44,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [7636] = 3,
    STATE(66), 1,
      sym__relop,
    ACTIONS(614), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(612), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [7693] = 3,
    STATE(161), 1,
      sym__sop,
    ACTIONS(618), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(616), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [7750] = 5,
    ACTIONS(590), 1,
      sym_pow_tok,
    STATE(66), 1,
      sym__relop,
    ACTIONS(588), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(622), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(620), 42,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [7811] = 4,
    ACTIONS(590), 1,
      sym_pow_tok,
    STATE(66), 1,
      sym__relop,
    ACTIONS(622), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(620), 44,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [7870] = 3,
    STATE(66), 1,
      sym__relop,
    ACTIONS(622), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(620), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [7927] = 9,
    ACTIONS(590), 1,
      sym_pow_tok,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    STATE(66), 1,
      sym__relop,
    ACTIONS(586), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(588), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(622), 2,
      sym_integer,
      sym_terminal_string,
    ACTIONS(620), 39,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_and_tok,
      sym_or_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [7996] = 10,
    ACTIONS(590), 1,
      sym_pow_tok,
    ACTIONS(592), 1,
      sym_and_tok,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    STATE(66), 1,
      sym__relop,
    ACTIONS(586), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(588), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(622), 2,
      sym_integer,
      sym_terminal_string,
    ACTIONS(620), 38,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_or_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8067] = 6,
    ACTIONS(590), 1,
      sym_pow_tok,
    STATE(66), 1,
      sym__relop,
    ACTIONS(586), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(588), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(622), 2,
      sym_integer,
      sym_terminal_string,
    ACTIONS(620), 42,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8130] = 3,
    STATE(161), 1,
      sym__sop,
    ACTIONS(622), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(620), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8187] = 2,
    ACTIONS(626), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(624), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8241] = 2,
    ACTIONS(630), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(628), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8295] = 2,
    ACTIONS(634), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(632), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8349] = 2,
    ACTIONS(638), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(636), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8403] = 2,
    ACTIONS(642), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(640), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8457] = 2,
    ACTIONS(646), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(644), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8511] = 2,
    ACTIONS(650), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(648), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8565] = 2,
    ACTIONS(654), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(652), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8619] = 2,
    ACTIONS(658), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(656), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8673] = 2,
    ACTIONS(662), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(660), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8727] = 2,
    ACTIONS(666), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(664), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8781] = 2,
    ACTIONS(670), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(668), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8835] = 2,
    ACTIONS(674), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(672), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8889] = 2,
    ACTIONS(678), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(676), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8943] = 2,
    ACTIONS(682), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(680), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [8997] = 2,
    ACTIONS(686), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(684), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [9051] = 8,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(688), 1,
      sym_plus_tok,
    STATE(151), 1,
      sym__relop,
    STATE(161), 1,
      sym__sop,
    ACTIONS(602), 3,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(584), 37,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_real,
      sym_string,
  [9114] = 3,
    ACTIONS(694), 2,
      sym_eq_tok,
      sym_less_tok,
    ACTIONS(692), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(690), 33,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      sym_real,
      sym_string,
  [9159] = 3,
    ACTIONS(694), 2,
      sym_gtr_tok,
      sym_less_tok,
    ACTIONS(692), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(690), 33,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      sym_real,
      sym_string,
  [9204] = 3,
    ACTIONS(694), 2,
      sym_gtr_tok,
      sym_eq_tok,
    ACTIONS(692), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(690), 33,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      sym_real,
      sym_string,
  [9249] = 2,
    ACTIONS(698), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(696), 33,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      sym_real,
      sym_string,
  [9290] = 6,
    ACTIONS(570), 1,
      sym_terminal_string,
    ACTIONS(578), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      anon_sym_LPAREN,
    ACTIONS(702), 1,
      anon_sym_PERCENT,
    STATE(146), 1,
      sym_subscript,
    ACTIONS(568), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9329] = 14,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(704), 1,
      anon_sym_LPAREN,
    ACTIONS(706), 1,
      sym_string,
    STATE(121), 1,
      sym__name,
    STATE(234), 1,
      sym_svar,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(254), 4,
      sym__var,
      sym__avar,
      sym_intvar,
      sym_realvar,
    STATE(292), 4,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
  [9384] = 2,
    ACTIONS(582), 1,
      sym_terminal_string,
    ACTIONS(580), 24,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
  [9414] = 4,
    ACTIONS(610), 1,
      sym_terminal_string,
    ACTIONS(700), 1,
      anon_sym_LPAREN,
    STATE(129), 1,
      sym_subscript,
    ACTIONS(608), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9448] = 3,
    ACTIONS(618), 1,
      sym_terminal_string,
    STATE(155), 1,
      sym__sop,
    ACTIONS(616), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9479] = 4,
    ACTIONS(606), 1,
      sym_terminal_string,
    ACTIONS(700), 1,
      anon_sym_LPAREN,
    STATE(147), 1,
      sym_subscript,
    ACTIONS(604), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9512] = 3,
    ACTIONS(622), 1,
      sym_terminal_string,
    STATE(155), 1,
      sym__sop,
    ACTIONS(620), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9542] = 6,
    ACTIONS(622), 1,
      sym_terminal_string,
    ACTIONS(712), 1,
      sym_pow_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(620), 16,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9578] = 2,
    ACTIONS(662), 1,
      sym_terminal_string,
    ACTIONS(660), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9606] = 2,
    ACTIONS(670), 1,
      sym_terminal_string,
    ACTIONS(668), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9634] = 2,
    ACTIONS(642), 1,
      sym_terminal_string,
    ACTIONS(640), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9662] = 3,
    ACTIONS(614), 1,
      sym_terminal_string,
    STATE(47), 1,
      sym__relop,
    ACTIONS(612), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9692] = 2,
    ACTIONS(634), 1,
      sym_terminal_string,
    ACTIONS(632), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9720] = 2,
    ACTIONS(638), 1,
      sym_terminal_string,
    ACTIONS(636), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9748] = 2,
    ACTIONS(626), 1,
      sym_terminal_string,
    ACTIONS(624), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9776] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(622), 1,
      sym_terminal_string,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(620), 12,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_or_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9820] = 2,
    ACTIONS(686), 1,
      sym_terminal_string,
    ACTIONS(684), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9848] = 5,
    ACTIONS(622), 1,
      sym_terminal_string,
    ACTIONS(712), 1,
      sym_pow_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(620), 18,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9882] = 2,
    ACTIONS(678), 1,
      sym_terminal_string,
    ACTIONS(676), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9910] = 2,
    ACTIONS(666), 1,
      sym_terminal_string,
    ACTIONS(664), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9938] = 4,
    ACTIONS(622), 1,
      sym_terminal_string,
    ACTIONS(712), 1,
      sym_pow_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(620), 20,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [9970] = 9,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(622), 1,
      sym_terminal_string,
    ACTIONS(712), 1,
      sym_pow_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(620), 13,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_and_tok,
      sym_or_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [10012] = 3,
    ACTIONS(622), 1,
      sym_terminal_string,
    STATE(47), 1,
      sym__relop,
    ACTIONS(620), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [10042] = 2,
    ACTIONS(654), 1,
      sym_terminal_string,
    ACTIONS(652), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [10069] = 2,
    ACTIONS(682), 1,
      sym_terminal_string,
    ACTIONS(680), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [10096] = 2,
    ACTIONS(630), 1,
      sym_terminal_string,
    ACTIONS(628), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [10123] = 2,
    ACTIONS(658), 1,
      sym_terminal_string,
    ACTIONS(656), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [10150] = 2,
    ACTIONS(650), 1,
      sym_terminal_string,
    ACTIONS(648), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [10177] = 2,
    ACTIONS(646), 1,
      sym_terminal_string,
    ACTIONS(644), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [10204] = 2,
    ACTIONS(674), 1,
      sym_terminal_string,
    ACTIONS(672), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_string,
  [10231] = 10,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(209), 1,
      sym_mid_tok,
    ACTIONS(716), 1,
      anon_sym_LPAREN,
    ACTIONS(718), 1,
      sym_string,
    STATE(340), 1,
      sym__name,
    ACTIONS(189), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(205), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(207), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(104), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(99), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10270] = 10,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(704), 1,
      anon_sym_LPAREN,
    ACTIONS(720), 1,
      sym_string,
    STATE(327), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(298), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10309] = 10,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(704), 1,
      anon_sym_LPAREN,
    ACTIONS(722), 1,
      sym_string,
    STATE(327), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(283), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10348] = 10,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(704), 1,
      anon_sym_LPAREN,
    ACTIONS(724), 1,
      sym_string,
    STATE(327), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(271), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10387] = 10,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(704), 1,
      anon_sym_LPAREN,
    ACTIONS(726), 1,
      sym_string,
    STATE(327), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(125), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10426] = 10,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(704), 1,
      anon_sym_LPAREN,
    ACTIONS(728), 1,
      sym_string,
    STATE(327), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(243), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10465] = 10,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(704), 1,
      anon_sym_LPAREN,
    ACTIONS(730), 1,
      sym_string,
    STATE(327), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(263), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10504] = 10,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(704), 1,
      anon_sym_LPAREN,
    ACTIONS(732), 1,
      sym_string,
    STATE(327), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(286), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10543] = 10,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(704), 1,
      anon_sym_LPAREN,
    ACTIONS(734), 1,
      sym_string,
    STATE(327), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(264), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10582] = 10,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(704), 1,
      anon_sym_LPAREN,
    ACTIONS(736), 1,
      sym_string,
    STATE(327), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(261), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10621] = 10,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(209), 1,
      sym_mid_tok,
    ACTIONS(716), 1,
      anon_sym_LPAREN,
    ACTIONS(738), 1,
      sym_string,
    STATE(340), 1,
      sym__name,
    ACTIONS(189), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(205), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(207), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(104), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(92), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10660] = 10,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(704), 1,
      anon_sym_LPAREN,
    ACTIONS(740), 1,
      sym_string,
    STATE(327), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(127), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10699] = 10,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(704), 1,
      anon_sym_LPAREN,
    ACTIONS(742), 1,
      sym_string,
    STATE(327), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(262), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10738] = 10,
    ACTIONS(67), 1,
      sym__ext_name,
    ACTIONS(310), 1,
      sym_mid_tok,
    ACTIONS(704), 1,
      anon_sym_LPAREN,
    ACTIONS(744), 1,
      sym_string,
    STATE(327), 1,
      sym__name,
    ACTIONS(290), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(306), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(308), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(301), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10777] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(584), 4,
      sym_goto_tok,
      sym_then_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [10813] = 12,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(748), 1,
      sym_to_tok,
    STATE(47), 1,
      sym__relop,
    STATE(244), 1,
      aux_sym_statement_repeat4,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(750), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [10853] = 12,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(748), 1,
      sym_to_tok,
    STATE(47), 1,
      sym__relop,
    STATE(260), 1,
      aux_sym_statement_repeat4,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(752), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [10893] = 12,
    ACTIONS(223), 1,
      sym_terminal_string,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(754), 1,
      sym_string,
    STATE(47), 1,
      sym__relop,
    ACTIONS(215), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [10933] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(756), 3,
      sym_to_tok,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [10968] = 12,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(760), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    STATE(272), 1,
      aux_sym_subscript_repeat1,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11007] = 11,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(762), 1,
      anon_sym_COMMA,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(750), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [11044] = 11,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(764), 1,
      sym_at_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(215), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11081] = 12,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(766), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    STATE(295), 1,
      aux_sym_subscript_repeat1,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11120] = 11,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(768), 1,
      sym_step_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(770), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [11157] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(750), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [11191] = 11,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(772), 1,
      anon_sym_COMMA,
    ACTIONS(774), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11227] = 11,
    ACTIONS(215), 1,
      anon_sym_COLON,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(754), 1,
      sym_string,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11263] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(776), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [11297] = 6,
    ACTIONS(67), 1,
      sym__ext_name,
    STATE(121), 1,
      sym__name,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(254), 5,
      sym__var,
      sym__avar,
      sym_intvar,
      sym_realvar,
      sym_svar,
  [11323] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(778), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [11357] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(215), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11391] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(780), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [11425] = 6,
    ACTIONS(67), 1,
      sym__ext_name,
    STATE(121), 1,
      sym__name,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(290), 5,
      sym__var,
      sym__avar,
      sym_intvar,
      sym_realvar,
      sym_svar,
  [11451] = 6,
    ACTIONS(67), 1,
      sym__ext_name,
    STATE(121), 1,
      sym__name,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(246), 5,
      sym__var,
      sym__avar,
      sym_intvar,
      sym_realvar,
      sym_svar,
  [11477] = 11,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(782), 1,
      anon_sym_COMMA,
    ACTIONS(784), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11513] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(786), 2,
      sym_goto_tok,
      sym_gosub_tok,
  [11547] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(770), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [11581] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(788), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [11615] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(790), 1,
      anon_sym_COMMA,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11648] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(792), 1,
      anon_sym_COMMA,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11681] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(794), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11714] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(796), 1,
      anon_sym_COMMA,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11747] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(798), 1,
      anon_sym_COMMA,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11780] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(800), 1,
      anon_sym_COMMA,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11813] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(802), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11846] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(804), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11879] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(806), 1,
      anon_sym_COMMA,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11912] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(808), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11945] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(810), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [11978] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(784), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [12011] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(812), 1,
      anon_sym_COMMA,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [12044] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(814), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [12077] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(816), 1,
      sym_to_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [12110] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(818), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [12143] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(774), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [12176] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(820), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [12209] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(822), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [12242] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(824), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [12275] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(826), 1,
      anon_sym_COMMA,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [12308] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(828), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [12341] = 7,
    ACTIONS(67), 1,
      sym__ext_name,
    STATE(121), 1,
      sym__name,
    STATE(324), 1,
      sym_svar,
    STATE(131), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(330), 3,
      sym__avar,
      sym_intvar,
      sym_realvar,
  [12368] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(762), 1,
      anon_sym_COMMA,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [12401] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(762), 1,
      sym_at_tok,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [12434] = 10,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(712), 1,
      sym_pow_tok,
    ACTIONS(714), 1,
      sym_and_tok,
    ACTIONS(746), 1,
      sym_or_tok,
    ACTIONS(830), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__relop,
    ACTIONS(708), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(710), 2,
      sym_times_tok,
      sym_div_tok,
  [12467] = 6,
    ACTIONS(67), 1,
      sym__ext_name,
    STATE(226), 1,
      sym__name,
    ACTIONS(229), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(236), 3,
      sym__avar,
      sym_intvar,
      sym_realvar,
  [12491] = 7,
    ACTIONS(231), 1,
      sym_terminal_string,
    ACTIONS(832), 1,
      anon_sym_COMMA,
    STATE(231), 1,
      sym__data_item,
    STATE(232), 1,
      aux_sym_statement_repeat1,
    ACTIONS(229), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
    ACTIONS(836), 2,
      sym_real,
      sym_string,
    ACTIONS(834), 3,
      sym_integer,
      sym_literal,
      sym_real_data_item,
  [12517] = 7,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(838), 1,
      sym_plus_tok,
    STATE(155), 1,
      sym__sop,
    STATE(162), 1,
      sym__relop,
    ACTIONS(584), 4,
      sym_goto_tok,
      sym_then_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [12542] = 5,
    ACTIONS(846), 1,
      sym_terminal_string,
    STATE(248), 1,
      sym__data_item,
    ACTIONS(844), 2,
      sym_real,
      sym_string,
    ACTIONS(840), 3,
      anon_sym_COMMA,
      anon_sym_COLON,
      aux_sym__newline_token1,
    ACTIONS(842), 3,
      sym_integer,
      sym_literal,
      sym_real_data_item,
  [12563] = 6,
    ACTIONS(229), 1,
      anon_sym_COLON,
    ACTIONS(832), 1,
      anon_sym_COMMA,
    STATE(291), 1,
      aux_sym_statement_repeat1,
    STATE(293), 1,
      sym__data_item,
    ACTIONS(850), 2,
      sym_real,
      sym_string,
    ACTIONS(848), 3,
      sym_integer,
      sym_literal,
      sym_real_data_item,
  [12585] = 5,
    ACTIONS(67), 1,
      sym__ext_name,
    STATE(226), 1,
      sym__name,
    STATE(148), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(149), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(276), 3,
      sym__avar,
      sym_intvar,
      sym_realvar,
  [12605] = 7,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(838), 1,
      sym_plus_tok,
    ACTIONS(852), 1,
      anon_sym_RPAREN,
    STATE(155), 1,
      sym__sop,
    STATE(162), 1,
      sym__relop,
  [12627] = 7,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(838), 1,
      sym_plus_tok,
    ACTIONS(854), 1,
      anon_sym_RPAREN,
    STATE(155), 1,
      sym__sop,
    STATE(162), 1,
      sym__relop,
  [12649] = 6,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(838), 1,
      sym_plus_tok,
    STATE(155), 1,
      sym__sop,
    STATE(162), 1,
      sym__relop,
  [12668] = 4,
    ACTIONS(5), 1,
      sym_linenum,
    ACTIONS(856), 1,
      ts_builtin_sym_end,
    ACTIONS(858), 1,
      aux_sym__newline_token1,
    STATE(228), 3,
      sym_line,
      sym__empty_line,
      aux_sym_source_file_repeat1,
  [12683] = 6,
    ACTIONS(596), 1,
      sym_gtr_tok,
    ACTIONS(598), 1,
      sym_eq_tok,
    ACTIONS(600), 1,
      sym_less_tok,
    ACTIONS(838), 1,
      sym_plus_tok,
    STATE(151), 1,
      sym__relop,
    STATE(155), 1,
      sym__sop,
  [12702] = 4,
    ACTIONS(700), 1,
      anon_sym_LPAREN,
    ACTIONS(702), 1,
      anon_sym_PERCENT,
    STATE(146), 1,
      sym_subscript,
    ACTIONS(568), 3,
      anon_sym_COMMA,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12717] = 3,
    ACTIONS(67), 1,
      sym__ext_name,
    STATE(250), 1,
      sym__name,
    STATE(299), 4,
      sym__dim_item,
      sym_real_array,
      sym_int_array,
      sym_string_array,
  [12730] = 4,
    ACTIONS(860), 1,
      ts_builtin_sym_end,
    ACTIONS(862), 1,
      sym_linenum,
    ACTIONS(865), 1,
      aux_sym__newline_token1,
    STATE(228), 3,
      sym_line,
      sym__empty_line,
      aux_sym_source_file_repeat1,
  [12745] = 3,
    ACTIONS(67), 1,
      sym__ext_name,
    STATE(250), 1,
      sym__name,
    STATE(252), 4,
      sym__dim_item,
      sym_real_array,
      sym_int_array,
      sym_string_array,
  [12758] = 3,
    ACTIONS(868), 1,
      anon_sym_COMMA,
    STATE(230), 1,
      aux_sym_statement_repeat1,
    ACTIONS(871), 3,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_terminal_string,
  [12770] = 4,
    ACTIONS(832), 1,
      anon_sym_COMMA,
    ACTIONS(873), 1,
      sym_terminal_string,
    STATE(233), 1,
      aux_sym_statement_repeat1,
    ACTIONS(215), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12784] = 4,
    ACTIONS(832), 1,
      anon_sym_COMMA,
    ACTIONS(873), 1,
      sym_terminal_string,
    STATE(230), 1,
      aux_sym_statement_repeat1,
    ACTIONS(215), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12798] = 4,
    ACTIONS(832), 1,
      anon_sym_COMMA,
    ACTIONS(877), 1,
      sym_terminal_string,
    STATE(230), 1,
      aux_sym_statement_repeat1,
    ACTIONS(875), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12812] = 2,
    ACTIONS(879), 2,
      sym_plus_tok,
      anon_sym_SEMI,
    ACTIONS(881), 3,
      anon_sym_COMMA,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12822] = 3,
    ACTIONS(885), 1,
      sym_linenum,
    ACTIONS(229), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
    ACTIONS(883), 2,
      sym_minus_tok,
      anon_sym_COMMA,
  [12834] = 3,
    ACTIONS(887), 1,
      anon_sym_COMMA,
    STATE(247), 1,
      aux_sym_statement_repeat5,
    ACTIONS(215), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12845] = 3,
    ACTIONS(889), 1,
      anon_sym_COMMA,
    STATE(256), 1,
      aux_sym_statement_repeat6,
    ACTIONS(752), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12856] = 3,
    ACTIONS(891), 1,
      sym_to_tok,
    STATE(238), 1,
      aux_sym_statement_repeat4,
    ACTIONS(894), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12867] = 3,
    ACTIONS(896), 1,
      anon_sym_COMMA,
    STATE(242), 1,
      aux_sym_statement_repeat3,
    ACTIONS(752), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12878] = 2,
    ACTIONS(215), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
    ACTIONS(898), 2,
      sym_minus_tok,
      anon_sym_COMMA,
  [12887] = 4,
    ACTIONS(178), 1,
      aux_sym__newline_token1,
    ACTIONS(900), 1,
      anon_sym_COLON,
    STATE(11), 1,
      aux_sym_line_repeat1,
    STATE(273), 1,
      sym__newline,
  [12900] = 3,
    ACTIONS(902), 1,
      anon_sym_COMMA,
    STATE(242), 1,
      aux_sym_statement_repeat3,
    ACTIONS(905), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12911] = 3,
    ACTIONS(838), 1,
      sym_plus_tok,
    STATE(155), 1,
      sym__sop,
    ACTIONS(776), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12922] = 3,
    ACTIONS(748), 1,
      sym_to_tok,
    STATE(238), 1,
      aux_sym_statement_repeat4,
    ACTIONS(752), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12933] = 3,
    ACTIONS(907), 1,
      anon_sym_COMMA,
    STATE(245), 1,
      aux_sym_statement_repeat5,
    ACTIONS(910), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12944] = 3,
    ACTIONS(896), 1,
      anon_sym_COMMA,
    STATE(239), 1,
      aux_sym_statement_repeat3,
    ACTIONS(750), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12955] = 3,
    ACTIONS(887), 1,
      anon_sym_COMMA,
    STATE(245), 1,
      aux_sym_statement_repeat5,
    ACTIONS(875), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12966] = 1,
    ACTIONS(871), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      aux_sym__newline_token1,
      sym_terminal_string,
  [12973] = 3,
    ACTIONS(912), 1,
      anon_sym_COMMA,
    STATE(249), 1,
      aux_sym_statement_repeat2,
    ACTIONS(915), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [12984] = 4,
    ACTIONS(700), 1,
      anon_sym_LPAREN,
    ACTIONS(917), 1,
      anon_sym_PERCENT,
    ACTIONS(919), 1,
      anon_sym_DOLLAR,
    STATE(278), 1,
      sym_subscript,
  [12997] = 3,
    ACTIONS(921), 1,
      anon_sym_COMMA,
    STATE(249), 1,
      aux_sym_statement_repeat2,
    ACTIONS(875), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13008] = 3,
    ACTIONS(921), 1,
      anon_sym_COMMA,
    STATE(251), 1,
      aux_sym_statement_repeat2,
    ACTIONS(215), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13019] = 3,
    ACTIONS(67), 1,
      sym__ext_name,
    STATE(282), 1,
      sym__name,
    STATE(315), 2,
      sym_real_scalar,
      sym_int_scalar,
  [13030] = 3,
    ACTIONS(896), 1,
      anon_sym_COMMA,
    STATE(257), 1,
      aux_sym_statement_repeat3,
    ACTIONS(215), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13041] = 4,
    ACTIONS(923), 1,
      anon_sym_COLON,
    ACTIONS(925), 1,
      aux_sym__newline_token1,
    STATE(10), 1,
      aux_sym_line_repeat1,
    STATE(277), 1,
      sym__newline,
  [13054] = 3,
    ACTIONS(927), 1,
      anon_sym_COMMA,
    STATE(256), 1,
      aux_sym_statement_repeat6,
    ACTIONS(930), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13065] = 3,
    ACTIONS(896), 1,
      anon_sym_COMMA,
    STATE(242), 1,
      aux_sym_statement_repeat3,
    ACTIONS(875), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13076] = 3,
    ACTIONS(889), 1,
      anon_sym_COMMA,
    STATE(237), 1,
      aux_sym_statement_repeat6,
    ACTIONS(750), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13087] = 4,
    ACTIONS(180), 1,
      aux_sym__newline_token1,
    ACTIONS(932), 1,
      anon_sym_COLON,
    STATE(9), 1,
      aux_sym_line_repeat1,
    STATE(294), 1,
      sym__newline,
  [13100] = 3,
    ACTIONS(748), 1,
      sym_to_tok,
    STATE(238), 1,
      aux_sym_statement_repeat4,
    ACTIONS(770), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13111] = 3,
    ACTIONS(838), 1,
      sym_plus_tok,
    STATE(155), 1,
      sym__sop,
    ACTIONS(778), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13122] = 3,
    ACTIONS(838), 1,
      sym_plus_tok,
    ACTIONS(934), 1,
      anon_sym_COMMA,
    STATE(155), 1,
      sym__sop,
  [13132] = 3,
    ACTIONS(838), 1,
      sym_plus_tok,
    ACTIONS(936), 1,
      anon_sym_COMMA,
    STATE(155), 1,
      sym__sop,
  [13142] = 3,
    ACTIONS(838), 1,
      sym_plus_tok,
    ACTIONS(852), 1,
      anon_sym_RPAREN,
    STATE(155), 1,
      sym__sop,
  [13152] = 1,
    ACTIONS(930), 3,
      anon_sym_COMMA,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13158] = 1,
    ACTIONS(938), 3,
      anon_sym_COMMA,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13164] = 3,
    ACTIONS(67), 1,
      sym__ext_name,
    STATE(313), 1,
      sym__name,
    STATE(336), 1,
      sym_real_scalar,
  [13174] = 3,
    ACTIONS(832), 1,
      anon_sym_COMMA,
    ACTIONS(875), 1,
      anon_sym_COLON,
    STATE(230), 1,
      aux_sym_statement_repeat1,
  [13184] = 1,
    ACTIONS(940), 3,
      ts_builtin_sym_end,
      sym_linenum,
      aux_sym__newline_token1,
  [13190] = 3,
    ACTIONS(780), 1,
      anon_sym_RPAREN,
    ACTIONS(942), 1,
      anon_sym_COMMA,
    STATE(270), 1,
      aux_sym_subscript_repeat1,
  [13200] = 3,
    ACTIONS(814), 1,
      anon_sym_RPAREN,
    ACTIONS(838), 1,
      sym_plus_tok,
    STATE(155), 1,
      sym__sop,
  [13210] = 3,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(945), 1,
      anon_sym_RPAREN,
    STATE(270), 1,
      aux_sym_subscript_repeat1,
  [13220] = 1,
    ACTIONS(947), 3,
      ts_builtin_sym_end,
      sym_linenum,
      aux_sym__newline_token1,
  [13226] = 3,
    ACTIONS(949), 1,
      anon_sym_COMMA,
    ACTIONS(952), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      aux_sym_statement_repeat8,
  [13236] = 2,
    ACTIONS(71), 1,
      sym_linenum,
    ACTIONS(875), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13244] = 1,
    ACTIONS(910), 3,
      anon_sym_COMMA,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13250] = 1,
    ACTIONS(954), 3,
      ts_builtin_sym_end,
      sym_linenum,
      aux_sym__newline_token1,
  [13256] = 1,
    ACTIONS(956), 3,
      anon_sym_COMMA,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13262] = 2,
    ACTIONS(754), 1,
      sym_linenum,
    ACTIONS(215), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13270] = 3,
    ACTIONS(67), 1,
      sym__ext_name,
    STATE(321), 1,
      sym__name,
    STATE(356), 1,
      sym_fn_name,
  [13280] = 2,
    ACTIONS(958), 1,
      sym_comment_text,
    ACTIONS(960), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13288] = 2,
    ACTIONS(964), 1,
      anon_sym_PERCENT,
    ACTIONS(962), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13296] = 3,
    ACTIONS(838), 1,
      sym_plus_tok,
    ACTIONS(966), 1,
      anon_sym_COMMA,
    STATE(155), 1,
      sym__sop,
  [13306] = 3,
    ACTIONS(67), 1,
      sym__ext_name,
    STATE(321), 1,
      sym__name,
    STATE(352), 1,
      sym_fn_name,
  [13316] = 3,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
    ACTIONS(968), 1,
      anon_sym_COMMA,
    STATE(297), 1,
      aux_sym_statement_repeat8,
  [13326] = 3,
    ACTIONS(838), 1,
      sym_plus_tok,
    ACTIONS(970), 1,
      anon_sym_COMMA,
    STATE(155), 1,
      sym__sop,
  [13336] = 3,
    ACTIONS(67), 1,
      sym__ext_name,
    STATE(321), 1,
      sym__name,
    STATE(337), 1,
      sym_fn_name,
  [13346] = 3,
    ACTIONS(231), 1,
      sym_terminal_string,
    ACTIONS(972), 1,
      anon_sym_LPAREN,
    ACTIONS(974), 1,
      sym_string,
  [13356] = 2,
    ACTIONS(974), 1,
      sym_linenum,
    ACTIONS(229), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13364] = 1,
    ACTIONS(905), 3,
      anon_sym_COMMA,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13370] = 3,
    ACTIONS(215), 1,
      anon_sym_COLON,
    ACTIONS(832), 1,
      anon_sym_COMMA,
    STATE(230), 1,
      aux_sym_statement_repeat1,
  [13380] = 3,
    ACTIONS(838), 1,
      sym_plus_tok,
    ACTIONS(976), 1,
      anon_sym_SEMI,
    STATE(155), 1,
      sym__sop,
  [13390] = 3,
    ACTIONS(215), 1,
      anon_sym_COLON,
    ACTIONS(832), 1,
      anon_sym_COMMA,
    STATE(268), 1,
      aux_sym_statement_repeat1,
  [13400] = 1,
    ACTIONS(978), 3,
      ts_builtin_sym_end,
      sym_linenum,
      aux_sym__newline_token1,
  [13406] = 3,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(980), 1,
      anon_sym_RPAREN,
    STATE(270), 1,
      aux_sym_subscript_repeat1,
  [13416] = 3,
    ACTIONS(67), 1,
      sym__ext_name,
    STATE(313), 1,
      sym__name,
    STATE(320), 1,
      sym_real_scalar,
  [13426] = 3,
    ACTIONS(968), 1,
      anon_sym_COMMA,
    ACTIONS(982), 1,
      anon_sym_RPAREN,
    STATE(274), 1,
      aux_sym_statement_repeat8,
  [13436] = 3,
    ACTIONS(830), 1,
      anon_sym_RPAREN,
    ACTIONS(838), 1,
      sym_plus_tok,
    STATE(155), 1,
      sym__sop,
  [13446] = 1,
    ACTIONS(915), 3,
      anon_sym_COMMA,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13452] = 1,
    ACTIONS(984), 3,
      anon_sym_COMMA,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13458] = 3,
    ACTIONS(838), 1,
      sym_plus_tok,
    ACTIONS(854), 1,
      anon_sym_RPAREN,
    STATE(155), 1,
      sym__sop,
  [13468] = 2,
    ACTIONS(178), 1,
      aux_sym__newline_token1,
    STATE(273), 1,
      sym__newline,
  [13475] = 2,
    ACTIONS(986), 1,
      sym_goto_tok,
    ACTIONS(988), 1,
      sym_then_tok,
  [13482] = 1,
    ACTIONS(229), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13487] = 2,
    ACTIONS(180), 1,
      aux_sym__newline_token1,
    STATE(294), 1,
      sym__newline,
  [13494] = 2,
    ACTIONS(972), 1,
      anon_sym_LPAREN,
    ACTIONS(974), 1,
      sym_string,
  [13501] = 2,
    ACTIONS(958), 1,
      sym_comment_text,
    ACTIONS(960), 1,
      anon_sym_COLON,
  [13508] = 2,
    ACTIONS(990), 1,
      anon_sym_COLON,
    STATE(13), 1,
      aux_sym_line_repeat1,
  [13515] = 1,
    ACTIONS(750), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13520] = 2,
    ACTIONS(986), 1,
      sym_goto_tok,
    ACTIONS(992), 1,
      sym_then_tok,
  [13527] = 1,
    ACTIONS(875), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13532] = 2,
    ACTIONS(700), 1,
      anon_sym_LPAREN,
    STATE(300), 1,
      sym_subscript,
  [13539] = 1,
    ACTIONS(962), 2,
      sym_eq_tok,
      anon_sym_RPAREN,
  [13544] = 2,
    ACTIONS(700), 1,
      anon_sym_LPAREN,
    STATE(266), 1,
      sym_subscript,
  [13551] = 1,
    ACTIONS(215), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13556] = 1,
    ACTIONS(952), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [13561] = 1,
    ACTIONS(752), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13566] = 1,
    ACTIONS(994), 2,
      anon_sym_COLON,
      aux_sym__newline_token1,
  [13571] = 2,
    ACTIONS(925), 1,
      aux_sym__newline_token1,
    STATE(277), 1,
      sym__newline,
  [13578] = 1,
    ACTIONS(996), 1,
      anon_sym_RPAREN,
  [13582] = 1,
    ACTIONS(998), 1,
      anon_sym_LPAREN,
  [13586] = 1,
    ACTIONS(754), 1,
      sym_linenum,
  [13590] = 1,
    ACTIONS(986), 1,
      anon_sym_COMMA,
  [13594] = 1,
    ACTIONS(1000), 1,
      sym_eq_tok,
  [13598] = 1,
    ACTIONS(1002), 1,
      aux_sym__newline_token1,
  [13602] = 1,
    ACTIONS(768), 1,
      sym_eq_tok,
  [13606] = 1,
    ACTIONS(578), 1,
      anon_sym_DOLLAR,
  [13610] = 1,
    ACTIONS(814), 1,
      anon_sym_RPAREN,
  [13614] = 1,
    ACTIONS(71), 1,
      sym_linenum,
  [13618] = 1,
    ACTIONS(1004), 1,
      sym_eq_tok,
  [13622] = 1,
    ACTIONS(1006), 1,
      sym_linenum,
  [13626] = 1,
    ACTIONS(1008), 1,
      anon_sym_LPAREN,
  [13630] = 1,
    ACTIONS(1010), 1,
      sym_eq_tok,
  [13634] = 1,
    ACTIONS(1012), 1,
      sym_eq_tok,
  [13638] = 1,
    ACTIONS(1014), 1,
      sym_fn_tok,
  [13642] = 1,
    ACTIONS(1016), 1,
      sym_eq_tok,
  [13646] = 1,
    ACTIONS(826), 1,
      anon_sym_LPAREN,
  [13650] = 1,
    ACTIONS(1018), 1,
      ts_builtin_sym_end,
  [13654] = 1,
    ACTIONS(974), 1,
      sym_linenum,
  [13658] = 1,
    ACTIONS(576), 1,
      anon_sym_DOLLAR,
  [13662] = 1,
    ACTIONS(1020), 1,
      sym__ext_name,
  [13666] = 1,
    ACTIONS(1022), 1,
      sym_goto_tok,
  [13670] = 1,
    ACTIONS(1024), 1,
      anon_sym_LPAREN,
  [13674] = 1,
    ACTIONS(1026), 1,
      sym_linenum,
  [13678] = 1,
    ACTIONS(830), 1,
      anon_sym_RPAREN,
  [13682] = 1,
    ACTIONS(1028), 1,
      anon_sym_LPAREN,
  [13686] = 1,
    ACTIONS(1030), 1,
      aux_sym__newline_token1,
  [13690] = 1,
    ACTIONS(1032), 1,
      anon_sym_LPAREN,
  [13694] = 1,
    ACTIONS(1034), 1,
      anon_sym_LPAREN,
  [13698] = 1,
    ACTIONS(1036), 1,
      anon_sym_LPAREN,
  [13702] = 1,
    ACTIONS(1038), 1,
      anon_sym_LPAREN,
  [13706] = 1,
    ACTIONS(812), 1,
      anon_sym_LPAREN,
  [13710] = 1,
    ACTIONS(1040), 1,
      aux_sym__newline_token1,
  [13714] = 1,
    ACTIONS(1042), 1,
      anon_sym_LPAREN,
  [13718] = 1,
    ACTIONS(1044), 1,
      anon_sym_LPAREN,
  [13722] = 1,
    ACTIONS(1046), 1,
      anon_sym_LPAREN,
  [13726] = 1,
    ACTIONS(1048), 1,
      anon_sym_LPAREN,
  [13730] = 1,
    ACTIONS(1050), 1,
      sym__ext_name,
  [13734] = 1,
    ACTIONS(1052), 1,
      sym_linenum,
  [13738] = 1,
    ACTIONS(1054), 1,
      anon_sym_LPAREN,
  [13742] = 1,
    ACTIONS(1056), 1,
      anon_sym_LPAREN,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(14)] = 0,
  [SMALL_STATE(15)] = 116,
  [SMALL_STATE(16)] = 232,
  [SMALL_STATE(17)] = 348,
  [SMALL_STATE(18)] = 460,
  [SMALL_STATE(19)] = 572,
  [SMALL_STATE(20)] = 676,
  [SMALL_STATE(21)] = 780,
  [SMALL_STATE(22)] = 884,
  [SMALL_STATE(23)] = 988,
  [SMALL_STATE(24)] = 1092,
  [SMALL_STATE(25)] = 1196,
  [SMALL_STATE(26)] = 1300,
  [SMALL_STATE(27)] = 1401,
  [SMALL_STATE(28)] = 1502,
  [SMALL_STATE(29)] = 1603,
  [SMALL_STATE(30)] = 1704,
  [SMALL_STATE(31)] = 1805,
  [SMALL_STATE(32)] = 1906,
  [SMALL_STATE(33)] = 2007,
  [SMALL_STATE(34)] = 2108,
  [SMALL_STATE(35)] = 2209,
  [SMALL_STATE(36)] = 2310,
  [SMALL_STATE(37)] = 2411,
  [SMALL_STATE(38)] = 2512,
  [SMALL_STATE(39)] = 2613,
  [SMALL_STATE(40)] = 2714,
  [SMALL_STATE(41)] = 2815,
  [SMALL_STATE(42)] = 2916,
  [SMALL_STATE(43)] = 3017,
  [SMALL_STATE(44)] = 3118,
  [SMALL_STATE(45)] = 3219,
  [SMALL_STATE(46)] = 3320,
  [SMALL_STATE(47)] = 3421,
  [SMALL_STATE(48)] = 3522,
  [SMALL_STATE(49)] = 3623,
  [SMALL_STATE(50)] = 3724,
  [SMALL_STATE(51)] = 3825,
  [SMALL_STATE(52)] = 3926,
  [SMALL_STATE(53)] = 4027,
  [SMALL_STATE(54)] = 4128,
  [SMALL_STATE(55)] = 4229,
  [SMALL_STATE(56)] = 4330,
  [SMALL_STATE(57)] = 4431,
  [SMALL_STATE(58)] = 4532,
  [SMALL_STATE(59)] = 4633,
  [SMALL_STATE(60)] = 4734,
  [SMALL_STATE(61)] = 4835,
  [SMALL_STATE(62)] = 4936,
  [SMALL_STATE(63)] = 5037,
  [SMALL_STATE(64)] = 5138,
  [SMALL_STATE(65)] = 5239,
  [SMALL_STATE(66)] = 5340,
  [SMALL_STATE(67)] = 5441,
  [SMALL_STATE(68)] = 5542,
  [SMALL_STATE(69)] = 5643,
  [SMALL_STATE(70)] = 5744,
  [SMALL_STATE(71)] = 5845,
  [SMALL_STATE(72)] = 5946,
  [SMALL_STATE(73)] = 6047,
  [SMALL_STATE(74)] = 6148,
  [SMALL_STATE(75)] = 6249,
  [SMALL_STATE(76)] = 6350,
  [SMALL_STATE(77)] = 6451,
  [SMALL_STATE(78)] = 6552,
  [SMALL_STATE(79)] = 6653,
  [SMALL_STATE(80)] = 6754,
  [SMALL_STATE(81)] = 6855,
  [SMALL_STATE(82)] = 6956,
  [SMALL_STATE(83)] = 7057,
  [SMALL_STATE(84)] = 7158,
  [SMALL_STATE(85)] = 7259,
  [SMALL_STATE(86)] = 7324,
  [SMALL_STATE(87)] = 7389,
  [SMALL_STATE(88)] = 7445,
  [SMALL_STATE(89)] = 7518,
  [SMALL_STATE(90)] = 7577,
  [SMALL_STATE(91)] = 7636,
  [SMALL_STATE(92)] = 7693,
  [SMALL_STATE(93)] = 7750,
  [SMALL_STATE(94)] = 7811,
  [SMALL_STATE(95)] = 7870,
  [SMALL_STATE(96)] = 7927,
  [SMALL_STATE(97)] = 7996,
  [SMALL_STATE(98)] = 8067,
  [SMALL_STATE(99)] = 8130,
  [SMALL_STATE(100)] = 8187,
  [SMALL_STATE(101)] = 8241,
  [SMALL_STATE(102)] = 8295,
  [SMALL_STATE(103)] = 8349,
  [SMALL_STATE(104)] = 8403,
  [SMALL_STATE(105)] = 8457,
  [SMALL_STATE(106)] = 8511,
  [SMALL_STATE(107)] = 8565,
  [SMALL_STATE(108)] = 8619,
  [SMALL_STATE(109)] = 8673,
  [SMALL_STATE(110)] = 8727,
  [SMALL_STATE(111)] = 8781,
  [SMALL_STATE(112)] = 8835,
  [SMALL_STATE(113)] = 8889,
  [SMALL_STATE(114)] = 8943,
  [SMALL_STATE(115)] = 8997,
  [SMALL_STATE(116)] = 9051,
  [SMALL_STATE(117)] = 9114,
  [SMALL_STATE(118)] = 9159,
  [SMALL_STATE(119)] = 9204,
  [SMALL_STATE(120)] = 9249,
  [SMALL_STATE(121)] = 9290,
  [SMALL_STATE(122)] = 9329,
  [SMALL_STATE(123)] = 9384,
  [SMALL_STATE(124)] = 9414,
  [SMALL_STATE(125)] = 9448,
  [SMALL_STATE(126)] = 9479,
  [SMALL_STATE(127)] = 9512,
  [SMALL_STATE(128)] = 9542,
  [SMALL_STATE(129)] = 9578,
  [SMALL_STATE(130)] = 9606,
  [SMALL_STATE(131)] = 9634,
  [SMALL_STATE(132)] = 9662,
  [SMALL_STATE(133)] = 9692,
  [SMALL_STATE(134)] = 9720,
  [SMALL_STATE(135)] = 9748,
  [SMALL_STATE(136)] = 9776,
  [SMALL_STATE(137)] = 9820,
  [SMALL_STATE(138)] = 9848,
  [SMALL_STATE(139)] = 9882,
  [SMALL_STATE(140)] = 9910,
  [SMALL_STATE(141)] = 9938,
  [SMALL_STATE(142)] = 9970,
  [SMALL_STATE(143)] = 10012,
  [SMALL_STATE(144)] = 10042,
  [SMALL_STATE(145)] = 10069,
  [SMALL_STATE(146)] = 10096,
  [SMALL_STATE(147)] = 10123,
  [SMALL_STATE(148)] = 10150,
  [SMALL_STATE(149)] = 10177,
  [SMALL_STATE(150)] = 10204,
  [SMALL_STATE(151)] = 10231,
  [SMALL_STATE(152)] = 10270,
  [SMALL_STATE(153)] = 10309,
  [SMALL_STATE(154)] = 10348,
  [SMALL_STATE(155)] = 10387,
  [SMALL_STATE(156)] = 10426,
  [SMALL_STATE(157)] = 10465,
  [SMALL_STATE(158)] = 10504,
  [SMALL_STATE(159)] = 10543,
  [SMALL_STATE(160)] = 10582,
  [SMALL_STATE(161)] = 10621,
  [SMALL_STATE(162)] = 10660,
  [SMALL_STATE(163)] = 10699,
  [SMALL_STATE(164)] = 10738,
  [SMALL_STATE(165)] = 10777,
  [SMALL_STATE(166)] = 10813,
  [SMALL_STATE(167)] = 10853,
  [SMALL_STATE(168)] = 10893,
  [SMALL_STATE(169)] = 10933,
  [SMALL_STATE(170)] = 10968,
  [SMALL_STATE(171)] = 11007,
  [SMALL_STATE(172)] = 11044,
  [SMALL_STATE(173)] = 11081,
  [SMALL_STATE(174)] = 11120,
  [SMALL_STATE(175)] = 11157,
  [SMALL_STATE(176)] = 11191,
  [SMALL_STATE(177)] = 11227,
  [SMALL_STATE(178)] = 11263,
  [SMALL_STATE(179)] = 11297,
  [SMALL_STATE(180)] = 11323,
  [SMALL_STATE(181)] = 11357,
  [SMALL_STATE(182)] = 11391,
  [SMALL_STATE(183)] = 11425,
  [SMALL_STATE(184)] = 11451,
  [SMALL_STATE(185)] = 11477,
  [SMALL_STATE(186)] = 11513,
  [SMALL_STATE(187)] = 11547,
  [SMALL_STATE(188)] = 11581,
  [SMALL_STATE(189)] = 11615,
  [SMALL_STATE(190)] = 11648,
  [SMALL_STATE(191)] = 11681,
  [SMALL_STATE(192)] = 11714,
  [SMALL_STATE(193)] = 11747,
  [SMALL_STATE(194)] = 11780,
  [SMALL_STATE(195)] = 11813,
  [SMALL_STATE(196)] = 11846,
  [SMALL_STATE(197)] = 11879,
  [SMALL_STATE(198)] = 11912,
  [SMALL_STATE(199)] = 11945,
  [SMALL_STATE(200)] = 11978,
  [SMALL_STATE(201)] = 12011,
  [SMALL_STATE(202)] = 12044,
  [SMALL_STATE(203)] = 12077,
  [SMALL_STATE(204)] = 12110,
  [SMALL_STATE(205)] = 12143,
  [SMALL_STATE(206)] = 12176,
  [SMALL_STATE(207)] = 12209,
  [SMALL_STATE(208)] = 12242,
  [SMALL_STATE(209)] = 12275,
  [SMALL_STATE(210)] = 12308,
  [SMALL_STATE(211)] = 12341,
  [SMALL_STATE(212)] = 12368,
  [SMALL_STATE(213)] = 12401,
  [SMALL_STATE(214)] = 12434,
  [SMALL_STATE(215)] = 12467,
  [SMALL_STATE(216)] = 12491,
  [SMALL_STATE(217)] = 12517,
  [SMALL_STATE(218)] = 12542,
  [SMALL_STATE(219)] = 12563,
  [SMALL_STATE(220)] = 12585,
  [SMALL_STATE(221)] = 12605,
  [SMALL_STATE(222)] = 12627,
  [SMALL_STATE(223)] = 12649,
  [SMALL_STATE(224)] = 12668,
  [SMALL_STATE(225)] = 12683,
  [SMALL_STATE(226)] = 12702,
  [SMALL_STATE(227)] = 12717,
  [SMALL_STATE(228)] = 12730,
  [SMALL_STATE(229)] = 12745,
  [SMALL_STATE(230)] = 12758,
  [SMALL_STATE(231)] = 12770,
  [SMALL_STATE(232)] = 12784,
  [SMALL_STATE(233)] = 12798,
  [SMALL_STATE(234)] = 12812,
  [SMALL_STATE(235)] = 12822,
  [SMALL_STATE(236)] = 12834,
  [SMALL_STATE(237)] = 12845,
  [SMALL_STATE(238)] = 12856,
  [SMALL_STATE(239)] = 12867,
  [SMALL_STATE(240)] = 12878,
  [SMALL_STATE(241)] = 12887,
  [SMALL_STATE(242)] = 12900,
  [SMALL_STATE(243)] = 12911,
  [SMALL_STATE(244)] = 12922,
  [SMALL_STATE(245)] = 12933,
  [SMALL_STATE(246)] = 12944,
  [SMALL_STATE(247)] = 12955,
  [SMALL_STATE(248)] = 12966,
  [SMALL_STATE(249)] = 12973,
  [SMALL_STATE(250)] = 12984,
  [SMALL_STATE(251)] = 12997,
  [SMALL_STATE(252)] = 13008,
  [SMALL_STATE(253)] = 13019,
  [SMALL_STATE(254)] = 13030,
  [SMALL_STATE(255)] = 13041,
  [SMALL_STATE(256)] = 13054,
  [SMALL_STATE(257)] = 13065,
  [SMALL_STATE(258)] = 13076,
  [SMALL_STATE(259)] = 13087,
  [SMALL_STATE(260)] = 13100,
  [SMALL_STATE(261)] = 13111,
  [SMALL_STATE(262)] = 13122,
  [SMALL_STATE(263)] = 13132,
  [SMALL_STATE(264)] = 13142,
  [SMALL_STATE(265)] = 13152,
  [SMALL_STATE(266)] = 13158,
  [SMALL_STATE(267)] = 13164,
  [SMALL_STATE(268)] = 13174,
  [SMALL_STATE(269)] = 13184,
  [SMALL_STATE(270)] = 13190,
  [SMALL_STATE(271)] = 13200,
  [SMALL_STATE(272)] = 13210,
  [SMALL_STATE(273)] = 13220,
  [SMALL_STATE(274)] = 13226,
  [SMALL_STATE(275)] = 13236,
  [SMALL_STATE(276)] = 13244,
  [SMALL_STATE(277)] = 13250,
  [SMALL_STATE(278)] = 13256,
  [SMALL_STATE(279)] = 13262,
  [SMALL_STATE(280)] = 13270,
  [SMALL_STATE(281)] = 13280,
  [SMALL_STATE(282)] = 13288,
  [SMALL_STATE(283)] = 13296,
  [SMALL_STATE(284)] = 13306,
  [SMALL_STATE(285)] = 13316,
  [SMALL_STATE(286)] = 13326,
  [SMALL_STATE(287)] = 13336,
  [SMALL_STATE(288)] = 13346,
  [SMALL_STATE(289)] = 13356,
  [SMALL_STATE(290)] = 13364,
  [SMALL_STATE(291)] = 13370,
  [SMALL_STATE(292)] = 13380,
  [SMALL_STATE(293)] = 13390,
  [SMALL_STATE(294)] = 13400,
  [SMALL_STATE(295)] = 13406,
  [SMALL_STATE(296)] = 13416,
  [SMALL_STATE(297)] = 13426,
  [SMALL_STATE(298)] = 13436,
  [SMALL_STATE(299)] = 13446,
  [SMALL_STATE(300)] = 13452,
  [SMALL_STATE(301)] = 13458,
  [SMALL_STATE(302)] = 13468,
  [SMALL_STATE(303)] = 13475,
  [SMALL_STATE(304)] = 13482,
  [SMALL_STATE(305)] = 13487,
  [SMALL_STATE(306)] = 13494,
  [SMALL_STATE(307)] = 13501,
  [SMALL_STATE(308)] = 13508,
  [SMALL_STATE(309)] = 13515,
  [SMALL_STATE(310)] = 13520,
  [SMALL_STATE(311)] = 13527,
  [SMALL_STATE(312)] = 13532,
  [SMALL_STATE(313)] = 13539,
  [SMALL_STATE(314)] = 13544,
  [SMALL_STATE(315)] = 13551,
  [SMALL_STATE(316)] = 13556,
  [SMALL_STATE(317)] = 13561,
  [SMALL_STATE(318)] = 13566,
  [SMALL_STATE(319)] = 13571,
  [SMALL_STATE(320)] = 13578,
  [SMALL_STATE(321)] = 13582,
  [SMALL_STATE(322)] = 13586,
  [SMALL_STATE(323)] = 13590,
  [SMALL_STATE(324)] = 13594,
  [SMALL_STATE(325)] = 13598,
  [SMALL_STATE(326)] = 13602,
  [SMALL_STATE(327)] = 13606,
  [SMALL_STATE(328)] = 13610,
  [SMALL_STATE(329)] = 13614,
  [SMALL_STATE(330)] = 13618,
  [SMALL_STATE(331)] = 13622,
  [SMALL_STATE(332)] = 13626,
  [SMALL_STATE(333)] = 13630,
  [SMALL_STATE(334)] = 13634,
  [SMALL_STATE(335)] = 13638,
  [SMALL_STATE(336)] = 13642,
  [SMALL_STATE(337)] = 13646,
  [SMALL_STATE(338)] = 13650,
  [SMALL_STATE(339)] = 13654,
  [SMALL_STATE(340)] = 13658,
  [SMALL_STATE(341)] = 13662,
  [SMALL_STATE(342)] = 13666,
  [SMALL_STATE(343)] = 13670,
  [SMALL_STATE(344)] = 13674,
  [SMALL_STATE(345)] = 13678,
  [SMALL_STATE(346)] = 13682,
  [SMALL_STATE(347)] = 13686,
  [SMALL_STATE(348)] = 13690,
  [SMALL_STATE(349)] = 13694,
  [SMALL_STATE(350)] = 13698,
  [SMALL_STATE(351)] = 13702,
  [SMALL_STATE(352)] = 13706,
  [SMALL_STATE(353)] = 13710,
  [SMALL_STATE(354)] = 13714,
  [SMALL_STATE(355)] = 13718,
  [SMALL_STATE(356)] = 13722,
  [SMALL_STATE(357)] = 13726,
  [SMALL_STATE(358)] = 13730,
  [SMALL_STATE(359)] = 13734,
  [SMALL_STATE(360)] = 13738,
  [SMALL_STATE(361)] = 13742,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [73] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(304),
  [76] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(267),
  [79] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(215),
  [82] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(219),
  [85] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(122),
  [88] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(344),
  [91] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(229),
  [94] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(179),
  [97] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(82),
  [100] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(77),
  [103] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(64),
  [106] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(63),
  [109] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(304),
  [112] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(21),
  [115] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(28),
  [118] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(342),
  [121] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(253),
  [124] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(211),
  [127] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(339),
  [130] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(289),
  [133] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(22),
  [136] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(306),
  [139] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(307),
  [142] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(35),
  [145] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(36),
  [148] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(335),
  [151] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(18),
  [154] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(235),
  [157] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2), SHIFT_REPEAT(358),
  [160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [172] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_line_repeat2, 2),
  [174] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_line_repeat2, 2),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2),
  [184] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_line_repeat1, 2),
  [186] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(12),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [217] = {.entry = {.count = 1, .reusable = false}}, SHIFT(88),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [223] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1),
  [231] = {.entry = {.count = 1, .reusable = false}}, SHIFT(353),
  [233] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(34),
  [236] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(284),
  [239] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(38),
  [242] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(38),
  [245] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(349),
  [248] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(350),
  [251] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(62),
  [254] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(351),
  [257] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(348),
  [260] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(360),
  [263] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(361),
  [266] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(16),
  [269] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(32),
  [272] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2),
  [274] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(88),
  [277] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(88),
  [280] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(116),
  [283] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_statement_repeat7, 2),
  [285] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(341),
  [288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [296] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [314] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [322] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [330] = {.entry = {.count = 1, .reusable = false}}, SHIFT(93),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [336] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [340] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [344] = {.entry = {.count = 1, .reusable = false}}, SHIFT(202),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [348] = {.entry = {.count = 1, .reusable = false}}, SHIFT(199),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [352] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [356] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [362] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [366] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [370] = {.entry = {.count = 1, .reusable = false}}, SHIFT(186),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [374] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [378] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [386] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [394] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [398] = {.entry = {.count = 1, .reusable = false}}, SHIFT(178),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [402] = {.entry = {.count = 1, .reusable = false}}, SHIFT(212),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [406] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [410] = {.entry = {.count = 1, .reusable = false}}, SHIFT(213),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [414] = {.entry = {.count = 1, .reusable = false}}, SHIFT(175),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [418] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [422] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [426] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [432] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [436] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [440] = {.entry = {.count = 1, .reusable = false}}, SHIFT(198),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [444] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [448] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [452] = {.entry = {.count = 1, .reusable = false}}, SHIFT(205),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [456] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [460] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [464] = {.entry = {.count = 1, .reusable = false}}, SHIFT(204),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [468] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [472] = {.entry = {.count = 1, .reusable = false}}, SHIFT(138),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [476] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [480] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [484] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [488] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [492] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [496] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [500] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [504] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [508] = {.entry = {.count = 1, .reusable = false}}, SHIFT(210),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [512] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [516] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [520] = {.entry = {.count = 1, .reusable = false}}, SHIFT(200),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [524] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [528] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [532] = {.entry = {.count = 1, .reusable = false}}, SHIFT(190),
  [534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [536] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [540] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [544] = {.entry = {.count = 1, .reusable = false}}, SHIFT(187),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [548] = {.entry = {.count = 1, .reusable = false}}, SHIFT(197),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [552] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [556] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [560] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [564] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [568] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__real_scalar, 1),
  [570] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__real_scalar, 1),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__name, 2),
  [582] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__name, 2),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr, 1),
  [586] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [602] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expr, 1),
  [604] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__int_scalar, 2),
  [606] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__int_scalar, 2),
  [608] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string_scalar, 2),
  [610] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string_scalar, 2),
  [612] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_aexpr, 2),
  [614] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_aexpr, 2),
  [616] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_sexpr, 3),
  [618] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_sexpr, 3),
  [620] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_aexpr, 3),
  [622] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_aexpr, 3),
  [624] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sfcall, 4),
  [626] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sfcall, 4),
  [628] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__real_array, 2),
  [630] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__real_array, 2),
  [632] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sfcall, 8),
  [634] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sfcall, 8),
  [636] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sfcall, 6),
  [638] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sfcall, 6),
  [640] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_svar, 1),
  [642] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_svar, 1),
  [644] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_intvar, 1),
  [646] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_intvar, 1),
  [648] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_realvar, 1),
  [650] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_realvar, 1),
  [652] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fcall, 5),
  [654] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fcall, 5),
  [656] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__int_array, 3),
  [658] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__int_array, 3),
  [660] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string_array, 3),
  [662] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string_array, 3),
  [664] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sfcall, 3),
  [666] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sfcall, 3),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parenthesized_sexpr, 3),
  [670] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__parenthesized_sexpr, 3),
  [672] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parenthesized_aexpr, 3),
  [674] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__parenthesized_aexpr, 3),
  [676] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript, 4),
  [678] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript, 4),
  [680] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fcall, 4),
  [682] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fcall, 4),
  [684] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript, 3),
  [686] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript, 3),
  [688] = {.entry = {.count = 1, .reusable = false}}, SHIFT(161),
  [690] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__relop, 1),
  [692] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__relop, 1),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [696] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__relop, 2),
  [698] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__relop, 2),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 4),
  [752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 5),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat4, 4),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 6),
  [772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [776] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 4),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 3),
  [780] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_subscript_repeat1, 2),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [788] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 8),
  [790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [822] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [834] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [840] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat1, 1),
  [842] = {.entry = {.count = 1, .reusable = false}}, SHIFT(248),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [846] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_statement_repeat1, 1),
  [848] = {.entry = {.count = 1, .reusable = false}}, SHIFT(293),
  [850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [856] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [862] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(2),
  [865] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(228),
  [868] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat1, 2), SHIFT_REPEAT(218),
  [871] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat1, 2),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [875] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 3),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [879] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__sexpr, 1),
  [881] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__var, 1),
  [883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [891] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat4, 2), SHIFT_REPEAT(80),
  [894] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat4, 2),
  [896] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [898] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [900] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [902] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat3, 2), SHIFT_REPEAT(183),
  [905] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat3, 2),
  [907] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat5, 2), SHIFT_REPEAT(220),
  [910] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat5, 2),
  [912] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat2, 2), SHIFT_REPEAT(227),
  [915] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat2, 2),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [927] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat6, 2), SHIFT_REPEAT(331),
  [930] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat6, 2),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [934] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [936] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [938] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_int_array, 3),
  [940] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line, 6),
  [942] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_subscript_repeat1, 2), SHIFT_REPEAT(37),
  [945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [947] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line, 4),
  [949] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat8, 2), SHIFT_REPEAT(24),
  [952] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat8, 2),
  [954] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line, 3),
  [956] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_real_array, 2),
  [958] = {.entry = {.count = 1, .reusable = false}}, SHIFT(315),
  [960] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1),
  [962] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_real_scalar, 1),
  [964] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [966] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [968] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [970] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [972] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [974] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [978] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line, 5),
  [980] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [982] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [984] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_array, 3),
  [986] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [988] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [994] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_int_scalar, 2),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [998] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_name, 1),
  [1000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1002] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_terminal_statement, 3),
  [1004] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1006] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [1008] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [1010] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [1012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1018] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [1022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1030] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_terminal_statement, 4),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1040] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_terminal_statement, 2),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_applesoft_external_scanner_create(void);
void tree_sitter_applesoft_external_scanner_destroy(void *);
bool tree_sitter_applesoft_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_applesoft_external_scanner_serialize(void *, char *);
void tree_sitter_applesoft_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_applesoft(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_applesoft_external_scanner_create,
      tree_sitter_applesoft_external_scanner_destroy,
      tree_sitter_applesoft_external_scanner_scan,
      tree_sitter_applesoft_external_scanner_serialize,
      tree_sitter_applesoft_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
