#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 356
#define LARGE_STATE_COUNT 8
#define SYMBOL_COUNT 176
#define ALIAS_COUNT 0
#define TOKEN_COUNT 127
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 1

enum {
  sym_end_tok = 1,
  sym_for_tok = 2,
  sym_next_tok = 3,
  sym_data_tok = 4,
  sym_input_tok = 5,
  sym_del_tok = 6,
  sym_dim_tok = 7,
  sym_read_tok = 8,
  sym_gr_tok = 9,
  sym_text_tok = 10,
  sym_prn_tok = 11,
  sym_inn_tok = 12,
  sym_call_tok = 13,
  sym_plot_tok = 14,
  sym_hlin_tok = 15,
  sym_vlin_tok = 16,
  sym_hgr2_tok = 17,
  sym_hgr_tok = 18,
  sym_hcoloreq_tok = 19,
  sym_hplot_tok = 20,
  sym_draw_tok = 21,
  sym_xdraw_tok = 22,
  sym_htab_tok = 23,
  sym_home_tok = 24,
  sym_roteq_tok = 25,
  sym_scaleeq_tok = 26,
  sym_shload_tok = 27,
  sym_trace_tok = 28,
  sym_notrace_tok = 29,
  sym_normal_tok = 30,
  sym_inverse_tok = 31,
  sym_flash_tok = 32,
  sym_coloreq_tok = 33,
  sym_pop_tok = 34,
  sym_vtab_tok = 35,
  sym_himem_tok = 36,
  sym_lomem_tok = 37,
  sym_onerr_tok = 38,
  sym_resume_tok = 39,
  sym_recall_tok = 40,
  sym_store_tok = 41,
  sym_speedeq_tok = 42,
  sym_let_tok = 43,
  sym_goto_tok = 44,
  sym_run_tok = 45,
  sym_if_tok = 46,
  sym_restore_tok = 47,
  sym_amp_tok = 48,
  sym_gosub_tok = 49,
  sym_return_tok = 50,
  sym_rem_tok = 51,
  sym_stop_tok = 52,
  sym_on_tok = 53,
  sym_wait_tok = 54,
  sym_load_tok = 55,
  sym_save_tok = 56,
  sym_def_tok = 57,
  sym_poke_tok = 58,
  sym_print_tok = 59,
  sym_cont_tok = 60,
  sym_list_tok = 61,
  sym_clear_tok = 62,
  sym_get_tok = 63,
  sym_new_tok = 64,
  sym_tabp_tok = 65,
  sym_to_tok = 66,
  sym_fn_tok = 67,
  sym_spcp_tok = 68,
  sym_then_tok = 69,
  sym_at_tok = 70,
  sym_not_tok = 71,
  sym_step_tok = 72,
  sym_plus_tok = 73,
  sym_minus_tok = 74,
  sym_times_tok = 75,
  sym_div_tok = 76,
  sym_pow_tok = 77,
  sym_and_tok = 78,
  sym_or_tok = 79,
  sym_gtr_tok = 80,
  sym_eq_tok = 81,
  sym_less_tok = 82,
  sym_sgn_tok = 83,
  sym_int_tok = 84,
  sym_abs_tok = 85,
  sym_usr_tok = 86,
  sym_fre_tok = 87,
  sym_scrnp_tok = 88,
  sym_pdl_tok = 89,
  sym_pos_tok = 90,
  sym_sqr_tok = 91,
  sym_rnd_tok = 92,
  sym_log_tok = 93,
  sym_exp_tok = 94,
  sym_cos_tok = 95,
  sym_sin_tok = 96,
  sym_tan_tok = 97,
  sym_atn_tok = 98,
  sym_peek_tok = 99,
  sym_len_tok = 100,
  sym_str_tok = 101,
  sym_val_tok = 102,
  sym_asc_tok = 103,
  sym_chr_tok = 104,
  sym_left_tok = 105,
  sym_right_tok = 106,
  sym_mid_tok = 107,
  anon_sym_COMMA = 108,
  anon_sym_LPAREN = 109,
  anon_sym_RPAREN = 110,
  anon_sym_SEMI = 111,
  sym_comment_text = 112,
  anon_sym_COLON = 113,
  anon_sym_LF = 114,
  anon_sym_CR_LF = 115,
  sym__empty_line = 116,
  sym_linenum = 117,
  sym_integer = 118,
  sym_literal = 119,
  sym_real = 120,
  sym_string = 121,
  sym_terminal_string = 122,
  sym_real_data_item = 123,
  anon_sym_PERCENT = 124,
  anon_sym_DOLLAR = 125,
  sym__ext_name = 126,
  sym_source_file = 127,
  sym_statement = 128,
  sym_terminal_statement = 129,
  sym_assignment = 130,
  sym_fcall = 131,
  sym_sfcall = 132,
  sym_line = 133,
  sym__expr = 134,
  sym__aexpr = 135,
  sym_unary_aexpr = 136,
  sym_binary_aexpr = 137,
  sym__parenthesized_aexpr = 138,
  sym__relop = 139,
  sym__sexpr = 140,
  sym_binary_sexpr = 141,
  sym__parenthesized_sexpr = 142,
  sym__sop = 143,
  sym__var = 144,
  sym__avar = 145,
  sym_intvar = 146,
  sym_realvar = 147,
  sym_svar = 148,
  sym_subscript = 149,
  sym__dim_item = 150,
  sym__data_item = 151,
  sym_fn_name = 152,
  sym_real_scalar = 153,
  sym__real_scalar = 154,
  sym_int_scalar = 155,
  sym__int_scalar = 156,
  sym__string_scalar = 157,
  sym_real_array = 158,
  sym__real_array = 159,
  sym_int_array = 160,
  sym__int_array = 161,
  sym_string_array = 162,
  sym__string_array = 163,
  sym__name = 164,
  aux_sym_source_file_repeat1 = 165,
  aux_sym_statement_repeat1 = 166,
  aux_sym_statement_repeat2 = 167,
  aux_sym_statement_repeat3 = 168,
  aux_sym_statement_repeat4 = 169,
  aux_sym_statement_repeat5 = 170,
  aux_sym_statement_repeat6 = 171,
  aux_sym_statement_repeat7 = 172,
  aux_sym_statement_repeat8 = 173,
  aux_sym_line_repeat1 = 174,
  aux_sym_subscript_repeat1 = 175,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_end_tok] = "end_tok",
  [sym_for_tok] = "for_tok",
  [sym_next_tok] = "next_tok",
  [sym_data_tok] = "data_tok",
  [sym_input_tok] = "input_tok",
  [sym_del_tok] = "del_tok",
  [sym_dim_tok] = "dim_tok",
  [sym_read_tok] = "read_tok",
  [sym_gr_tok] = "gr_tok",
  [sym_text_tok] = "text_tok",
  [sym_prn_tok] = "prn_tok",
  [sym_inn_tok] = "inn_tok",
  [sym_call_tok] = "call_tok",
  [sym_plot_tok] = "plot_tok",
  [sym_hlin_tok] = "hlin_tok",
  [sym_vlin_tok] = "vlin_tok",
  [sym_hgr2_tok] = "hgr2_tok",
  [sym_hgr_tok] = "hgr_tok",
  [sym_hcoloreq_tok] = "hcoloreq_tok",
  [sym_hplot_tok] = "hplot_tok",
  [sym_draw_tok] = "draw_tok",
  [sym_xdraw_tok] = "xdraw_tok",
  [sym_htab_tok] = "htab_tok",
  [sym_home_tok] = "home_tok",
  [sym_roteq_tok] = "roteq_tok",
  [sym_scaleeq_tok] = "scaleeq_tok",
  [sym_shload_tok] = "shload_tok",
  [sym_trace_tok] = "trace_tok",
  [sym_notrace_tok] = "notrace_tok",
  [sym_normal_tok] = "normal_tok",
  [sym_inverse_tok] = "inverse_tok",
  [sym_flash_tok] = "flash_tok",
  [sym_coloreq_tok] = "coloreq_tok",
  [sym_pop_tok] = "pop_tok",
  [sym_vtab_tok] = "vtab_tok",
  [sym_himem_tok] = "himem_tok",
  [sym_lomem_tok] = "lomem_tok",
  [sym_onerr_tok] = "onerr_tok",
  [sym_resume_tok] = "resume_tok",
  [sym_recall_tok] = "recall_tok",
  [sym_store_tok] = "store_tok",
  [sym_speedeq_tok] = "speedeq_tok",
  [sym_let_tok] = "let_tok",
  [sym_goto_tok] = "goto_tok",
  [sym_run_tok] = "run_tok",
  [sym_if_tok] = "if_tok",
  [sym_restore_tok] = "restore_tok",
  [sym_amp_tok] = "amp_tok",
  [sym_gosub_tok] = "gosub_tok",
  [sym_return_tok] = "return_tok",
  [sym_rem_tok] = "rem_tok",
  [sym_stop_tok] = "stop_tok",
  [sym_on_tok] = "on_tok",
  [sym_wait_tok] = "wait_tok",
  [sym_load_tok] = "load_tok",
  [sym_save_tok] = "save_tok",
  [sym_def_tok] = "def_tok",
  [sym_poke_tok] = "poke_tok",
  [sym_print_tok] = "print_tok",
  [sym_cont_tok] = "cont_tok",
  [sym_list_tok] = "list_tok",
  [sym_clear_tok] = "clear_tok",
  [sym_get_tok] = "get_tok",
  [sym_new_tok] = "new_tok",
  [sym_tabp_tok] = "tabp_tok",
  [sym_to_tok] = "to_tok",
  [sym_fn_tok] = "fn_tok",
  [sym_spcp_tok] = "spcp_tok",
  [sym_then_tok] = "then_tok",
  [sym_at_tok] = "at_tok",
  [sym_not_tok] = "not_tok",
  [sym_step_tok] = "step_tok",
  [sym_plus_tok] = "plus_tok",
  [sym_minus_tok] = "minus_tok",
  [sym_times_tok] = "times_tok",
  [sym_div_tok] = "div_tok",
  [sym_pow_tok] = "pow_tok",
  [sym_and_tok] = "and_tok",
  [sym_or_tok] = "or_tok",
  [sym_gtr_tok] = "gtr_tok",
  [sym_eq_tok] = "eq_tok",
  [sym_less_tok] = "less_tok",
  [sym_sgn_tok] = "sgn_tok",
  [sym_int_tok] = "int_tok",
  [sym_abs_tok] = "abs_tok",
  [sym_usr_tok] = "usr_tok",
  [sym_fre_tok] = "fre_tok",
  [sym_scrnp_tok] = "scrnp_tok",
  [sym_pdl_tok] = "pdl_tok",
  [sym_pos_tok] = "pos_tok",
  [sym_sqr_tok] = "sqr_tok",
  [sym_rnd_tok] = "rnd_tok",
  [sym_log_tok] = "log_tok",
  [sym_exp_tok] = "exp_tok",
  [sym_cos_tok] = "cos_tok",
  [sym_sin_tok] = "sin_tok",
  [sym_tan_tok] = "tan_tok",
  [sym_atn_tok] = "atn_tok",
  [sym_peek_tok] = "peek_tok",
  [sym_len_tok] = "len_tok",
  [sym_str_tok] = "str_tok",
  [sym_val_tok] = "val_tok",
  [sym_asc_tok] = "asc_tok",
  [sym_chr_tok] = "chr_tok",
  [sym_left_tok] = "left_tok",
  [sym_right_tok] = "right_tok",
  [sym_mid_tok] = "mid_tok",
  [anon_sym_COMMA] = ",",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SEMI] = ";",
  [sym_comment_text] = "comment_text",
  [anon_sym_COLON] = ":",
  [anon_sym_LF] = "\n",
  [anon_sym_CR_LF] = "\r\n",
  [sym__empty_line] = "_empty_line",
  [sym_linenum] = "linenum",
  [sym_integer] = "integer",
  [sym_literal] = "literal",
  [sym_real] = "real",
  [sym_string] = "string",
  [sym_terminal_string] = "terminal_string",
  [sym_real_data_item] = "real_data_item",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOLLAR] = "$",
  [sym__ext_name] = "_ext_name",
  [sym_source_file] = "source_file",
  [sym_statement] = "statement",
  [sym_terminal_statement] = "terminal_statement",
  [sym_assignment] = "assignment",
  [sym_fcall] = "fcall",
  [sym_sfcall] = "sfcall",
  [sym_line] = "line",
  [sym__expr] = "_expr",
  [sym__aexpr] = "_aexpr",
  [sym_unary_aexpr] = "unary_aexpr",
  [sym_binary_aexpr] = "binary_aexpr",
  [sym__parenthesized_aexpr] = "_parenthesized_aexpr",
  [sym__relop] = "_relop",
  [sym__sexpr] = "_sexpr",
  [sym_binary_sexpr] = "binary_sexpr",
  [sym__parenthesized_sexpr] = "_parenthesized_sexpr",
  [sym__sop] = "_sop",
  [sym__var] = "_var",
  [sym__avar] = "_avar",
  [sym_intvar] = "intvar",
  [sym_realvar] = "realvar",
  [sym_svar] = "svar",
  [sym_subscript] = "subscript",
  [sym__dim_item] = "_dim_item",
  [sym__data_item] = "_data_item",
  [sym_fn_name] = "fn_name",
  [sym_real_scalar] = "real_scalar",
  [sym__real_scalar] = "_real_scalar",
  [sym_int_scalar] = "int_scalar",
  [sym__int_scalar] = "_int_scalar",
  [sym__string_scalar] = "_string_scalar",
  [sym_real_array] = "real_array",
  [sym__real_array] = "_real_array",
  [sym_int_array] = "int_array",
  [sym__int_array] = "_int_array",
  [sym_string_array] = "string_array",
  [sym__string_array] = "_string_array",
  [sym__name] = "_name",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_statement_repeat1] = "statement_repeat1",
  [aux_sym_statement_repeat2] = "statement_repeat2",
  [aux_sym_statement_repeat3] = "statement_repeat3",
  [aux_sym_statement_repeat4] = "statement_repeat4",
  [aux_sym_statement_repeat5] = "statement_repeat5",
  [aux_sym_statement_repeat6] = "statement_repeat6",
  [aux_sym_statement_repeat7] = "statement_repeat7",
  [aux_sym_statement_repeat8] = "statement_repeat8",
  [aux_sym_line_repeat1] = "line_repeat1",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_end_tok] = sym_end_tok,
  [sym_for_tok] = sym_for_tok,
  [sym_next_tok] = sym_next_tok,
  [sym_data_tok] = sym_data_tok,
  [sym_input_tok] = sym_input_tok,
  [sym_del_tok] = sym_del_tok,
  [sym_dim_tok] = sym_dim_tok,
  [sym_read_tok] = sym_read_tok,
  [sym_gr_tok] = sym_gr_tok,
  [sym_text_tok] = sym_text_tok,
  [sym_prn_tok] = sym_prn_tok,
  [sym_inn_tok] = sym_inn_tok,
  [sym_call_tok] = sym_call_tok,
  [sym_plot_tok] = sym_plot_tok,
  [sym_hlin_tok] = sym_hlin_tok,
  [sym_vlin_tok] = sym_vlin_tok,
  [sym_hgr2_tok] = sym_hgr2_tok,
  [sym_hgr_tok] = sym_hgr_tok,
  [sym_hcoloreq_tok] = sym_hcoloreq_tok,
  [sym_hplot_tok] = sym_hplot_tok,
  [sym_draw_tok] = sym_draw_tok,
  [sym_xdraw_tok] = sym_xdraw_tok,
  [sym_htab_tok] = sym_htab_tok,
  [sym_home_tok] = sym_home_tok,
  [sym_roteq_tok] = sym_roteq_tok,
  [sym_scaleeq_tok] = sym_scaleeq_tok,
  [sym_shload_tok] = sym_shload_tok,
  [sym_trace_tok] = sym_trace_tok,
  [sym_notrace_tok] = sym_notrace_tok,
  [sym_normal_tok] = sym_normal_tok,
  [sym_inverse_tok] = sym_inverse_tok,
  [sym_flash_tok] = sym_flash_tok,
  [sym_coloreq_tok] = sym_coloreq_tok,
  [sym_pop_tok] = sym_pop_tok,
  [sym_vtab_tok] = sym_vtab_tok,
  [sym_himem_tok] = sym_himem_tok,
  [sym_lomem_tok] = sym_lomem_tok,
  [sym_onerr_tok] = sym_onerr_tok,
  [sym_resume_tok] = sym_resume_tok,
  [sym_recall_tok] = sym_recall_tok,
  [sym_store_tok] = sym_store_tok,
  [sym_speedeq_tok] = sym_speedeq_tok,
  [sym_let_tok] = sym_let_tok,
  [sym_goto_tok] = sym_goto_tok,
  [sym_run_tok] = sym_run_tok,
  [sym_if_tok] = sym_if_tok,
  [sym_restore_tok] = sym_restore_tok,
  [sym_amp_tok] = sym_amp_tok,
  [sym_gosub_tok] = sym_gosub_tok,
  [sym_return_tok] = sym_return_tok,
  [sym_rem_tok] = sym_rem_tok,
  [sym_stop_tok] = sym_stop_tok,
  [sym_on_tok] = sym_on_tok,
  [sym_wait_tok] = sym_wait_tok,
  [sym_load_tok] = sym_load_tok,
  [sym_save_tok] = sym_save_tok,
  [sym_def_tok] = sym_def_tok,
  [sym_poke_tok] = sym_poke_tok,
  [sym_print_tok] = sym_print_tok,
  [sym_cont_tok] = sym_cont_tok,
  [sym_list_tok] = sym_list_tok,
  [sym_clear_tok] = sym_clear_tok,
  [sym_get_tok] = sym_get_tok,
  [sym_new_tok] = sym_new_tok,
  [sym_tabp_tok] = sym_tabp_tok,
  [sym_to_tok] = sym_to_tok,
  [sym_fn_tok] = sym_fn_tok,
  [sym_spcp_tok] = sym_spcp_tok,
  [sym_then_tok] = sym_then_tok,
  [sym_at_tok] = sym_at_tok,
  [sym_not_tok] = sym_not_tok,
  [sym_step_tok] = sym_step_tok,
  [sym_plus_tok] = sym_plus_tok,
  [sym_minus_tok] = sym_minus_tok,
  [sym_times_tok] = sym_times_tok,
  [sym_div_tok] = sym_div_tok,
  [sym_pow_tok] = sym_pow_tok,
  [sym_and_tok] = sym_and_tok,
  [sym_or_tok] = sym_or_tok,
  [sym_gtr_tok] = sym_gtr_tok,
  [sym_eq_tok] = sym_eq_tok,
  [sym_less_tok] = sym_less_tok,
  [sym_sgn_tok] = sym_sgn_tok,
  [sym_int_tok] = sym_int_tok,
  [sym_abs_tok] = sym_abs_tok,
  [sym_usr_tok] = sym_usr_tok,
  [sym_fre_tok] = sym_fre_tok,
  [sym_scrnp_tok] = sym_scrnp_tok,
  [sym_pdl_tok] = sym_pdl_tok,
  [sym_pos_tok] = sym_pos_tok,
  [sym_sqr_tok] = sym_sqr_tok,
  [sym_rnd_tok] = sym_rnd_tok,
  [sym_log_tok] = sym_log_tok,
  [sym_exp_tok] = sym_exp_tok,
  [sym_cos_tok] = sym_cos_tok,
  [sym_sin_tok] = sym_sin_tok,
  [sym_tan_tok] = sym_tan_tok,
  [sym_atn_tok] = sym_atn_tok,
  [sym_peek_tok] = sym_peek_tok,
  [sym_len_tok] = sym_len_tok,
  [sym_str_tok] = sym_str_tok,
  [sym_val_tok] = sym_val_tok,
  [sym_asc_tok] = sym_asc_tok,
  [sym_chr_tok] = sym_chr_tok,
  [sym_left_tok] = sym_left_tok,
  [sym_right_tok] = sym_right_tok,
  [sym_mid_tok] = sym_mid_tok,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [sym_comment_text] = sym_comment_text,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR_LF] = anon_sym_CR_LF,
  [sym__empty_line] = sym__empty_line,
  [sym_linenum] = sym_linenum,
  [sym_integer] = sym_integer,
  [sym_literal] = sym_literal,
  [sym_real] = sym_real,
  [sym_string] = sym_string,
  [sym_terminal_string] = sym_terminal_string,
  [sym_real_data_item] = sym_real_data_item,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym__ext_name] = sym__ext_name,
  [sym_source_file] = sym_source_file,
  [sym_statement] = sym_statement,
  [sym_terminal_statement] = sym_terminal_statement,
  [sym_assignment] = sym_assignment,
  [sym_fcall] = sym_fcall,
  [sym_sfcall] = sym_sfcall,
  [sym_line] = sym_line,
  [sym__expr] = sym__expr,
  [sym__aexpr] = sym__aexpr,
  [sym_unary_aexpr] = sym_unary_aexpr,
  [sym_binary_aexpr] = sym_binary_aexpr,
  [sym__parenthesized_aexpr] = sym__parenthesized_aexpr,
  [sym__relop] = sym__relop,
  [sym__sexpr] = sym__sexpr,
  [sym_binary_sexpr] = sym_binary_sexpr,
  [sym__parenthesized_sexpr] = sym__parenthesized_sexpr,
  [sym__sop] = sym__sop,
  [sym__var] = sym__var,
  [sym__avar] = sym__avar,
  [sym_intvar] = sym_intvar,
  [sym_realvar] = sym_realvar,
  [sym_svar] = sym_svar,
  [sym_subscript] = sym_subscript,
  [sym__dim_item] = sym__dim_item,
  [sym__data_item] = sym__data_item,
  [sym_fn_name] = sym_fn_name,
  [sym_real_scalar] = sym_real_scalar,
  [sym__real_scalar] = sym__real_scalar,
  [sym_int_scalar] = sym_int_scalar,
  [sym__int_scalar] = sym__int_scalar,
  [sym__string_scalar] = sym__string_scalar,
  [sym_real_array] = sym_real_array,
  [sym__real_array] = sym__real_array,
  [sym_int_array] = sym_int_array,
  [sym__int_array] = sym__int_array,
  [sym_string_array] = sym_string_array,
  [sym__string_array] = sym__string_array,
  [sym__name] = sym__name,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_statement_repeat1] = aux_sym_statement_repeat1,
  [aux_sym_statement_repeat2] = aux_sym_statement_repeat2,
  [aux_sym_statement_repeat3] = aux_sym_statement_repeat3,
  [aux_sym_statement_repeat4] = aux_sym_statement_repeat4,
  [aux_sym_statement_repeat5] = aux_sym_statement_repeat5,
  [aux_sym_statement_repeat6] = aux_sym_statement_repeat6,
  [aux_sym_statement_repeat7] = aux_sym_statement_repeat7,
  [aux_sym_statement_repeat8] = aux_sym_statement_repeat8,
  [aux_sym_line_repeat1] = aux_sym_line_repeat1,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_end_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_for_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_next_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_data_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_input_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_del_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_dim_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_read_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_gr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_text_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_prn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_inn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_call_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_plot_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hlin_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_vlin_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hgr2_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hgr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hcoloreq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hplot_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_draw_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_xdraw_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_htab_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_home_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_roteq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_scaleeq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_shload_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_trace_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_notrace_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_inverse_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_flash_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_coloreq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_pop_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_vtab_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_himem_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_lomem_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_onerr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_resume_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_recall_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_store_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_speedeq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_let_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_run_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_if_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_restore_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_amp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_gosub_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_return_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_rem_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_stop_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_on_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_wait_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_load_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_save_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_def_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_poke_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_print_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_cont_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_list_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_clear_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_get_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_new_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_tabp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_to_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_spcp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_then_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_at_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_not_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_step_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_minus_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_times_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_div_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_pow_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_and_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_or_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_gtr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_eq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_less_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_sgn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_int_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_abs_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_usr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_fre_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_scrnp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_pdl_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_pos_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_sqr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_rnd_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_log_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_exp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_cos_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_sin_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_tan_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_atn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_peek_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_len_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_str_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_val_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_asc_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_chr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_left_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_right_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_mid_tok] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [sym_comment_text] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR_LF] = {
    .visible = true,
    .named = false,
  },
  [sym__empty_line] = {
    .visible = false,
    .named = true,
  },
  [sym_linenum] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_real] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_terminal_string] = {
    .visible = true,
    .named = true,
  },
  [sym_real_data_item] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym__ext_name] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_terminal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_fcall] = {
    .visible = true,
    .named = true,
  },
  [sym_sfcall] = {
    .visible = true,
    .named = true,
  },
  [sym_line] = {
    .visible = true,
    .named = true,
  },
  [sym__expr] = {
    .visible = false,
    .named = true,
  },
  [sym__aexpr] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_aexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_aexpr] = {
    .visible = true,
    .named = true,
  },
  [sym__parenthesized_aexpr] = {
    .visible = false,
    .named = true,
  },
  [sym__relop] = {
    .visible = false,
    .named = true,
  },
  [sym__sexpr] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_sexpr] = {
    .visible = true,
    .named = true,
  },
  [sym__parenthesized_sexpr] = {
    .visible = false,
    .named = true,
  },
  [sym__sop] = {
    .visible = false,
    .named = true,
  },
  [sym__var] = {
    .visible = false,
    .named = true,
  },
  [sym__avar] = {
    .visible = false,
    .named = true,
  },
  [sym_intvar] = {
    .visible = true,
    .named = true,
  },
  [sym_realvar] = {
    .visible = true,
    .named = true,
  },
  [sym_svar] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym__dim_item] = {
    .visible = false,
    .named = true,
  },
  [sym__data_item] = {
    .visible = false,
    .named = true,
  },
  [sym_fn_name] = {
    .visible = true,
    .named = true,
  },
  [sym_real_scalar] = {
    .visible = true,
    .named = true,
  },
  [sym__real_scalar] = {
    .visible = false,
    .named = true,
  },
  [sym_int_scalar] = {
    .visible = true,
    .named = true,
  },
  [sym__int_scalar] = {
    .visible = false,
    .named = true,
  },
  [sym__string_scalar] = {
    .visible = false,
    .named = true,
  },
  [sym_real_array] = {
    .visible = true,
    .named = true,
  },
  [sym__real_array] = {
    .visible = false,
    .named = true,
  },
  [sym_int_array] = {
    .visible = true,
    .named = true,
  },
  [sym__int_array] = {
    .visible = false,
    .named = true,
  },
  [sym_string_array] = {
    .visible = true,
    .named = true,
  },
  [sym__string_array] = {
    .visible = false,
    .named = true,
  },
  [sym__name] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat7] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat8] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(247);
      if (lookahead == '\n') ADVANCE(367);
      if (lookahead == '\r') ADVANCE(5);
      if (lookahead == ' ') ADVANCE(1);
      if (lookahead == '"') ADVANCE(391);
      if (lookahead == '$') ADVANCE(397);
      if (lookahead == '%') ADVANCE(396);
      if (lookahead == '&') ADVANCE(295);
      if (lookahead == '(') ADVANCE(358);
      if (lookahead == ')') ADVANCE(359);
      if (lookahead == '*') ADVANCE(324);
      if (lookahead == '+') ADVANCE(394);
      if (lookahead == ',') ADVANCE(357);
      if (lookahead == '-') ADVANCE(394);
      if (lookahead == '/') ADVANCE(325);
      if (lookahead == ':') ADVANCE(365);
      if (lookahead == ';') ADVANCE(360);
      if (lookahead == '<') ADVANCE(331);
      if (lookahead == '=') ADVANCE(330);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '?') ADVANCE(306);
      if (lookahead == '^') ADVANCE(326);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(8);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(9);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(10);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(393);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(11);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(12);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(13);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(14);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(15);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(16);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(17);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(18);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(19);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(20);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(21);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(22);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(23);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(24);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(25);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(372);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(367);
      if (lookahead == '\r') ADVANCE(5);
      if (lookahead == ' ') ADVANCE(1);
      if (lookahead == '"') ADVANCE(391);
      if (lookahead == '$') ADVANCE(397);
      if (lookahead == '%') ADVANCE(396);
      if (lookahead == '&') ADVANCE(295);
      if (lookahead == '(') ADVANCE(358);
      if (lookahead == ')') ADVANCE(359);
      if (lookahead == '*') ADVANCE(324);
      if (lookahead == '+') ADVANCE(394);
      if (lookahead == ',') ADVANCE(357);
      if (lookahead == '-') ADVANCE(394);
      if (lookahead == '/') ADVANCE(325);
      if (lookahead == ':') ADVANCE(365);
      if (lookahead == ';') ADVANCE(360);
      if (lookahead == '<') ADVANCE(331);
      if (lookahead == '=') ADVANCE(330);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '?') ADVANCE(306);
      if (lookahead == '^') ADVANCE(326);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(8);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(9);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(10);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(393);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(11);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(12);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(13);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(14);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(15);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(16);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(17);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(18);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(19);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(20);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(21);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(22);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(23);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(24);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(25);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(372);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(367);
      if (lookahead == '\r') ADVANCE(5);
      if (lookahead == ' ') ADVANCE(2);
      if (lookahead == '"') ADVANCE(391);
      if (lookahead == '$') ADVANCE(397);
      if (lookahead == '%') ADVANCE(396);
      if (lookahead == '(') ADVANCE(358);
      if (lookahead == '*') ADVANCE(324);
      if (lookahead == '+') ADVANCE(321);
      if (lookahead == ',') ADVANCE(357);
      if (lookahead == '-') ADVANCE(323);
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == '/') ADVANCE(325);
      if (lookahead == ':') ADVANCE(365);
      if (lookahead == ';') ADVANCE(360);
      if (lookahead == '<') ADVANCE(331);
      if (lookahead == '=') ADVANCE(330);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '^') ADVANCE(326);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(87);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(78);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(107);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(93);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(238);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(92);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(16);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(241);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(217);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(79);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(80);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(81);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(82);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(23);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(374);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(367);
      if (lookahead == '\r') ADVANCE(5);
      if (lookahead == ' ') ADVANCE(3);
      if (lookahead == '"') ADVANCE(391);
      if (lookahead == '$') ADVANCE(397);
      if (lookahead == '%') ADVANCE(396);
      if (lookahead == '(') ADVANCE(358);
      if (lookahead == ')') ADVANCE(359);
      if (lookahead == '*') ADVANCE(324);
      if (lookahead == '+') ADVANCE(320);
      if (lookahead == ',') ADVANCE(357);
      if (lookahead == '-') ADVANCE(322);
      if (lookahead == '/') ADVANCE(325);
      if (lookahead == ':') ADVANCE(365);
      if (lookahead == ';') ADVANCE(360);
      if (lookahead == '<') ADVANCE(331);
      if (lookahead == '=') ADVANCE(330);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '^') ADVANCE(326);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(66);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(177);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(217);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(223);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(371);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(367);
      if (lookahead == '\r') ADVANCE(361);
      if (lookahead == ' ') ADVANCE(362);
      if (lookahead == ':') ADVANCE(366);
      if (lookahead != 0) ADVANCE(364);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(368);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(369);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(369);
      if (lookahead == '\r') ADVANCE(6);
      if (lookahead == ' ') ADVANCE(7);
      if (lookahead == '&') ADVANCE(295);
      if (lookahead == ')') ADVANCE(359);
      if (lookahead == '*') ADVANCE(324);
      if (lookahead == '+') ADVANCE(320);
      if (lookahead == ',') ADVANCE(357);
      if (lookahead == '-') ADVANCE(322);
      if (lookahead == '/') ADVANCE(325);
      if (lookahead == ';') ADVANCE(360);
      if (lookahead == '<') ADVANCE(331);
      if (lookahead == '=') ADVANCE(330);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '?') ADVANCE(306);
      if (lookahead == '^') ADVANCE(326);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(66);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(67);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(10);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(196);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(68);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(12);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(13);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(89);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(90);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(228);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(18);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(69);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(70);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(71);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(72);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(73);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(25);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(371);
      END_STATE();
    case 8:
      if (lookahead == ' ') ADVANCE(8);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(94);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(96);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(28);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(317);
      END_STATE();
    case 9:
      if (lookahead == ' ') ADVANCE(9);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(29);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(30);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(97);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 10:
      if (lookahead == ' ') ADVANCE(10);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(32);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(33);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(34);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(95);
      END_STATE();
    case 11:
      if (lookahead == ' ') ADVANCE(11);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(122);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(314);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(100);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 12:
      if (lookahead == ' ') ADVANCE(12);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(101);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(35);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(256);
      END_STATE();
    case 13:
      if (lookahead == ' ') ADVANCE(13);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(36);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(102);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(91);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(234);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(99);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(138);
      END_STATE();
    case 14:
      if (lookahead == ' ') ADVANCE(14);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(293);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 15:
      if (lookahead == ' ') ADVANCE(15);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(38);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(121);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(39);
      END_STATE();
    case 16:
      if (lookahead == ' ') ADVANCE(16);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(123);
      END_STATE();
    case 17:
      if (lookahead == ' ') ADVANCE(17);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 18:
      if (lookahead == ' ') ADVANCE(18);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(300);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(328);
      END_STATE();
    case 19:
      if (lookahead == ' ') ADVANCE(19);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(126);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(140);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(103);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(42);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(43);
      END_STATE();
    case 20:
      if (lookahead == ' ') ADVANCE(20);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(44);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(45);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(139);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(128);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(46);
      END_STATE();
    case 21:
      if (lookahead == ' ') ADVANCE(21);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(47);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(48);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(106);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(233);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(131);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(49);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(142);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(88);
      END_STATE();
    case 22:
      if (lookahead == ' ') ADVANCE(22);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(50);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(51);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(152);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(313);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 23:
      if (lookahead == ' ') ADVANCE(23);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(154);
      END_STATE();
    case 24:
      if (lookahead == ' ') ADVANCE(24);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(231);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(162);
      END_STATE();
    case 25:
      if (lookahead == ' ') ADVANCE(25);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 26:
      if (lookahead == ' ') ADVANCE(26);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(166);
      END_STATE();
    case 27:
      if (lookahead == ' ') ADVANCE(27);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(393);
      END_STATE();
    case 28:
      if (lookahead == ' ') ADVANCE(28);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(352);
      END_STATE();
    case 29:
      if (lookahead == ' ') ADVANCE(29);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(153);
      END_STATE();
    case 30:
      if (lookahead == ' ') ADVANCE(30);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(53);
      END_STATE();
    case 31:
      if (lookahead == ' ') ADVANCE(31);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(130);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(143);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(344);
      END_STATE();
    case 32:
      if (lookahead == ' ') ADVANCE(32);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(179);
      END_STATE();
    case 33:
      if (lookahead == ' ') ADVANCE(33);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(304);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(253);
      END_STATE();
    case 34:
      if (lookahead == ' ') ADVANCE(34);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(254);
      END_STATE();
    case 35:
      if (lookahead == ' ') ADVANCE(35);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(55);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(145);
      END_STATE();
    case 36:
      if (lookahead == ' ') ADVANCE(36);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(239);
      END_STATE();
    case 37:
      if (lookahead == ' ') ADVANCE(37);
      if (lookahead == '#') ADVANCE(259);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(110);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(333);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(181);
      END_STATE();
    case 38:
      if (lookahead == ' ') ADVANCE(38);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(155);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(349);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(290);
      END_STATE();
    case 39:
      if (lookahead == ' ') ADVANCE(39);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(151);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(342);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(188);
      END_STATE();
    case 40:
      if (lookahead == ' ') ADVANCE(40);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(311);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(176);
      END_STATE();
    case 41:
      if (lookahead == ' ') ADVANCE(41);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(129);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(318);
      END_STATE();
    case 42:
      if (lookahead == ' ') ADVANCE(42);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(198);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(281);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(339);
      END_STATE();
    case 43:
      if (lookahead == ' ') ADVANCE(43);
      if (lookahead == '#') ADVANCE(258);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(158);
      END_STATE();
    case 44:
      if (lookahead == ' ') ADVANCE(44);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(163);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(186);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(298);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(58);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(133);
      END_STATE();
    case 45:
      if (lookahead == ' ') ADVANCE(45);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(59);
      END_STATE();
    case 46:
      if (lookahead == ' ') ADVANCE(46);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(292);
      END_STATE();
    case 47:
      if (lookahead == ' ') ADVANCE(47);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(202);
      END_STATE();
    case 48:
      if (lookahead == ' ') ADVANCE(48);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(165);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(169);
      END_STATE();
    case 49:
      if (lookahead == ' ') ADVANCE(49);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(61);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(206);
      END_STATE();
    case 50:
      if (lookahead == ' ') ADVANCE(50);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(114);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(346);
      END_STATE();
    case 51:
      if (lookahead == ' ') ADVANCE(51);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(190);
      END_STATE();
    case 52:
      if (lookahead == ' ') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(373);
      END_STATE();
    case 53:
      if (lookahead == ' ') ADVANCE(53);
      if (lookahead == '$') ADVANCE(353);
      END_STATE();
    case 54:
      if (lookahead == ' ') ADVANCE(54);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(268);
      END_STATE();
    case 55:
      if (lookahead == ' ') ADVANCE(55);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(134);
      END_STATE();
    case 56:
      if (lookahead == ' ') ADVANCE(56);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(270);
      END_STATE();
    case 57:
      if (lookahead == ' ') ADVANCE(57);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(348);
      END_STATE();
    case 58:
      if (lookahead == ' ') ADVANCE(58);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(242);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(240);
      END_STATE();
    case 59:
      if (lookahead == ' ') ADVANCE(59);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(212);
      END_STATE();
    case 60:
      if (lookahead == ' ') ADVANCE(60);
      if (lookahead == '=') ADVANCE(272);
      END_STATE();
    case 61:
      if (lookahead == ' ') ADVANCE(61);
      if (lookahead == '(') ADVANCE(315);
      END_STATE();
    case 62:
      if (lookahead == ' ') ADVANCE(62);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(319);
      END_STATE();
    case 63:
      if (lookahead == ' ') ADVANCE(63);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(299);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(213);
      END_STATE();
    case 64:
      if (lookahead == ' ') ADVANCE(64);
      if (lookahead == '2') ADVANCE(264);
      END_STATE();
    case 65:
      if (lookahead == ' ') ADVANCE(65);
      if (lookahead == ':') ADVANCE(283);
      END_STATE();
    case 66:
      if (lookahead == ' ') ADVANCE(66);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(96);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(317);
      END_STATE();
    case 67:
      if (lookahead == ' ') ADVANCE(67);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(29);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(97);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 68:
      if (lookahead == ' ') ADVANCE(68);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(122);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(100);
      END_STATE();
    case 69:
      if (lookahead == ' ') ADVANCE(69);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(103);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(77);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(43);
      END_STATE();
    case 70:
      if (lookahead == ' ') ADVANCE(70);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(44);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(128);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(46);
      END_STATE();
    case 71:
      if (lookahead == ' ') ADVANCE(71);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(47);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(205);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(233);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(225);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(168);
      END_STATE();
    case 72:
      if (lookahead == ' ') ADVANCE(72);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(51);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(152);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(313);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 73:
      if (lookahead == ' ') ADVANCE(73);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(231);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(162);
      END_STATE();
    case 74:
      if (lookahead == ' ') ADVANCE(74);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(130);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(143);
      END_STATE();
    case 75:
      if (lookahead == ' ') ADVANCE(75);
      if (lookahead == '#') ADVANCE(259);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(110);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(181);
      END_STATE();
    case 76:
      if (lookahead == ' ') ADVANCE(76);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(151);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(188);
      END_STATE();
    case 77:
      if (lookahead == ' ') ADVANCE(77);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(198);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(281);
      END_STATE();
    case 78:
      if (lookahead == ' ') ADVANCE(78);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(30);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(161);
      END_STATE();
    case 79:
      if (lookahead == ' ') ADVANCE(79);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(126);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(140);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(170);
      END_STATE();
    case 80:
      if (lookahead == ' ') ADVANCE(80);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(45);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(139);
      END_STATE();
    case 81:
      if (lookahead == ' ') ADVANCE(81);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(220);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(106);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(131);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(125);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(142);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(230);
      END_STATE();
    case 82:
      if (lookahead == ' ') ADVANCE(82);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(50);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(313);
      END_STATE();
    case 83:
      if (lookahead == ' ') ADVANCE(83);
      if (lookahead == '.') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(243);
      END_STATE();
    case 84:
      if (lookahead == ' ') ADVANCE(84);
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(374);
      END_STATE();
    case 85:
      if (lookahead == ' ') ADVANCE(376);
      if (lookahead == '"') ADVANCE(391);
      if (lookahead == '.') ADVANCE(388);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(395);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '*') ||
          ('/' <= lookahead && lookahead <= '~')) ADVANCE(382);
      END_STATE();
    case 86:
      if (lookahead == ' ') ADVANCE(363);
      if (lookahead == ':') ADVANCE(366);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(364);
      END_STATE();
    case 87:
      if (lookahead == ' ') ADVANCE(87);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(94);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(96);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(28);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(244);
      END_STATE();
    case 88:
      if (lookahead == ' ') ADVANCE(88);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(62);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(63);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(132);
      END_STATE();
    case 89:
      if (lookahead == ' ') ADVANCE(89);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(293);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(75);
      END_STATE();
    case 90:
      if (lookahead == ' ') ADVANCE(90);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(215);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(121);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(76);
      END_STATE();
    case 91:
      if (lookahead == ' ') ADVANCE(91);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(146);
      END_STATE();
    case 92:
      if (lookahead == ' ') ADVANCE(92);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(119);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(105);
      END_STATE();
    case 93:
      if (lookahead == ' ') ADVANCE(93);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(314);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 94:
      if (lookahead == ' ') ADVANCE(94);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(334);
      END_STATE();
    case 95:
      if (lookahead == ' ') ADVANCE(95);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(54);
      END_STATE();
    case 96:
      if (lookahead == ' ') ADVANCE(96);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(327);
      END_STATE();
    case 97:
      if (lookahead == ' ') ADVANCE(97);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 98:
      if (lookahead == ' ') ADVANCE(98);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(216);
      END_STATE();
    case 99:
      if (lookahead == ' ') ADVANCE(99);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(235);
      END_STATE();
    case 100:
      if (lookahead == ' ') ADVANCE(100);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(249);
      END_STATE();
    case 101:
      if (lookahead == ' ') ADVANCE(101);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(310);
      END_STATE();
    case 102:
      if (lookahead == ' ') ADVANCE(102);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(164);
      END_STATE();
    case 103:
      if (lookahead == ' ') ADVANCE(103);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(184);
      END_STATE();
    case 104:
      if (lookahead == ' ') ADVANCE(104);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(129);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(214);
      END_STATE();
    case 105:
      if (lookahead == ' ') ADVANCE(105);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(342);
      END_STATE();
    case 106:
      if (lookahead == ' ') ADVANCE(106);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(332);
      END_STATE();
    case 107:
      if (lookahead == ' ') ADVANCE(107);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(115);
      END_STATE();
    case 108:
      if (lookahead == ' ') ADVANCE(108);
      if (lookahead == '$') ADVANCE(356);
      END_STATE();
    case 109:
      if (lookahead == ' ') ADVANCE(109);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(269);
      END_STATE();
    case 110:
      if (lookahead == ' ') ADVANCE(110);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(204);
      END_STATE();
    case 111:
      if (lookahead == ' ') ADVANCE(111);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(282);
      END_STATE();
    case 112:
      if (lookahead == ' ') ADVANCE(112);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(279);
      END_STATE();
    case 113:
      if (lookahead == ' ') ADVANCE(113);
      if (lookahead == '=') ADVANCE(280);
      END_STATE();
    case 114:
      if (lookahead == ' ') ADVANCE(114);
      if (lookahead == '(') ADVANCE(312);
      END_STATE();
    case 115:
      if (lookahead == ' ') ADVANCE(115);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(343);
      END_STATE();
    case 116:
      if (lookahead == ' ') ADVANCE(116);
      if (lookahead == ':') ADVANCE(284);
      END_STATE();
    case 117:
      if (lookahead == ' ') ADVANCE(117);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(152);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(313);
      END_STATE();
    case 118:
      if (lookahead == ' ') ADVANCE(378);
      if (lookahead == '"') ADVANCE(245);
      if (lookahead == '.') ADVANCE(388);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(395);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '*') ||
          ('/' <= lookahead && lookahead <= '~')) ADVANCE(382);
      END_STATE();
    case 119:
      if (lookahead == ' ') ADVANCE(119);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(155);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(349);
      END_STATE();
    case 120:
      if (lookahead == ' ') ADVANCE(120);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(195);
      END_STATE();
    case 121:
      if (lookahead == ' ') ADVANCE(121);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(167);
      END_STATE();
    case 122:
      if (lookahead == ' ') ADVANCE(122);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(137);
      END_STATE();
    case 123:
      if (lookahead == ' ') ADVANCE(123);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(108);
      END_STATE();
    case 124:
      if (lookahead == ' ') ADVANCE(124);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(336);
      END_STATE();
    case 125:
      if (lookahead == ' ') ADVANCE(125);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(61);
      END_STATE();
    case 126:
      if (lookahead == ' ') ADVANCE(126);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(338);
      END_STATE();
    case 127:
      if (lookahead == ' ') ADVANCE(127);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(265);
      END_STATE();
    case 128:
      if (lookahead == ' ') ADVANCE(128);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(60);
      END_STATE();
    case 129:
      if (lookahead == ' ') ADVANCE(129);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(197);
      END_STATE();
    case 130:
      if (lookahead == ' ') ADVANCE(130);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(189);
      END_STATE();
    case 131:
      if (lookahead == ' ') ADVANCE(131);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(345);
      END_STATE();
    case 132:
      if (lookahead == ' ') ADVANCE(132);
      if (lookahead == '$') ADVANCE(350);
      END_STATE();
    case 133:
      if (lookahead == ' ') ADVANCE(133);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(203);
      END_STATE();
    case 134:
      if (lookahead == ' ') ADVANCE(134);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(296);
      END_STATE();
    case 135:
      if (lookahead == ' ') ADVANCE(135);
      if (lookahead == '=') ADVANCE(273);
      END_STATE();
    case 136:
      if (lookahead == ' ') ADVANCE(136);
      if (lookahead == '(') ADVANCE(337);
      END_STATE();
    case 137:
      if (lookahead == ' ') ADVANCE(137);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(112);
      END_STATE();
    case 138:
      if (lookahead == ' ') ADVANCE(138);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(56);
      END_STATE();
    case 139:
      if (lookahead == ' ') ADVANCE(139);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(341);
      END_STATE();
    case 140:
      if (lookahead == ' ') ADVANCE(140);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(57);
      END_STATE();
    case 141:
      if (lookahead == ' ') ADVANCE(141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(351);
      END_STATE();
    case 142:
      if (lookahead == ' ') ADVANCE(142);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(340);
      END_STATE();
    case 143:
      if (lookahead == ' ') ADVANCE(143);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(307);
      END_STATE();
    case 144:
      if (lookahead == ' ') ADVANCE(144);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(65);
      END_STATE();
    case 145:
      if (lookahead == ' ') ADVANCE(145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(291);
      END_STATE();
    case 146:
      if (lookahead == ' ') ADVANCE(146);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(262);
      END_STATE();
    case 147:
      if (lookahead == ' ') ADVANCE(147);
      if (lookahead == '$') ADVANCE(354);
      END_STATE();
    case 148:
      if (lookahead == ' ') ADVANCE(148);
      if (lookahead == '=') ADVANCE(289);
      END_STATE();
    case 149:
      if (lookahead == ' ') ADVANCE(149);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(222);
      END_STATE();
    case 150:
      if (lookahead == ' ') ADVANCE(150);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(98);
      END_STATE();
    case 151:
      if (lookahead == ' ') ADVANCE(151);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(302);
      END_STATE();
    case 152:
      if (lookahead == ' ') ADVANCE(152);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(178);
      END_STATE();
    case 153:
      if (lookahead == ' ') ADVANCE(153);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(260);
      END_STATE();
    case 154:
      if (lookahead == ' ') ADVANCE(154);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(335);
      END_STATE();
    case 155:
      if (lookahead == ' ') ADVANCE(155);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(147);
      END_STATE();
    case 156:
      if (lookahead == ' ') ADVANCE(156);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(116);
      END_STATE();
    case 157:
      if (lookahead == ' ') ADVANCE(157);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(201);
      END_STATE();
    case 158:
      if (lookahead == ' ') ADVANCE(158);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(208);
      END_STATE();
    case 159:
      if (lookahead == ' ') ADVANCE(159);
      if (lookahead == '$') ADVANCE(355);
      END_STATE();
    case 160:
      if (lookahead == ' ') ADVANCE(160);
      if (lookahead == '=') ADVANCE(266);
      END_STATE();
    case 161:
      if (lookahead == ' ') ADVANCE(161);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(344);
      END_STATE();
    case 162:
      if (lookahead == ' ') ADVANCE(162);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(111);
      END_STATE();
    case 163:
      if (lookahead == ' ') ADVANCE(163);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(255);
      END_STATE();
    case 164:
      if (lookahead == ' ') ADVANCE(164);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(144);
      END_STATE();
    case 165:
      if (lookahead == ' ') ADVANCE(165);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(210);
      END_STATE();
    case 166:
      if (lookahead == ' ') ADVANCE(166);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(192);
      END_STATE();
    case 167:
      if (lookahead == ' ') ADVANCE(167);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(308);
      END_STATE();
    case 168:
      if (lookahead == ' ') ADVANCE(168);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 169:
      if (lookahead == ' ') ADVANCE(169);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 170:
      if (lookahead == ' ') ADVANCE(170);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(339);
      END_STATE();
    case 171:
      if (lookahead == ' ') ADVANCE(171);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(183);
      END_STATE();
    case 172:
      if (lookahead == ' ') ADVANCE(172);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(148);
      END_STATE();
    case 173:
      if (lookahead == ' ') ADVANCE(173);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(271);
      END_STATE();
    case 174:
      if (lookahead == ' ') ADVANCE(174);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(277);
      END_STATE();
    case 175:
      if (lookahead == ' ') ADVANCE(175);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(199);
      END_STATE();
    case 176:
      if (lookahead == ' ') ADVANCE(176);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(250);
      END_STATE();
    case 177:
      if (lookahead == ' ') ADVANCE(177);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(35);
      END_STATE();
    case 178:
      if (lookahead == ' ') ADVANCE(178);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(316);
      END_STATE();
    case 179:
      if (lookahead == ' ') ADVANCE(179);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(251);
      END_STATE();
    case 180:
      if (lookahead == ' ') ADVANCE(180);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(274);
      END_STATE();
    case 181:
      if (lookahead == ' ') ADVANCE(181);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(194);
      END_STATE();
    case 182:
      if (lookahead == ' ') ADVANCE(182);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(287);
      END_STATE();
    case 183:
      if (lookahead == ' ') ADVANCE(183);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(309);
      END_STATE();
    case 184:
      if (lookahead == ' ') ADVANCE(184);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(261);
      END_STATE();
    case 185:
      if (lookahead == ' ') ADVANCE(185);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(263);
      END_STATE();
    case 186:
      if (lookahead == ' ') ADVANCE(186);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(229);
      END_STATE();
    case 187:
      if (lookahead == ' ') ADVANCE(187);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(248);
      END_STATE();
    case 188:
      if (lookahead == ' ') ADVANCE(188);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(156);
      END_STATE();
    case 189:
      if (lookahead == ' ') ADVANCE(189);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(113);
      END_STATE();
    case 190:
      if (lookahead == ' ') ADVANCE(190);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(257);
      END_STATE();
    case 191:
      if (lookahead == ' ') ADVANCE(191);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(297);
      END_STATE();
    case 192:
      if (lookahead == ' ') ADVANCE(192);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(109);
      END_STATE();
    case 193:
      if (lookahead == ' ') ADVANCE(193);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 194:
      if (lookahead == ' ') ADVANCE(194);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(149);
      END_STATE();
    case 195:
      if (lookahead == ' ') ADVANCE(195);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(301);
      END_STATE();
    case 196:
      if (lookahead == ' ') ADVANCE(196);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(187);
      END_STATE();
    case 197:
      if (lookahead == ' ') ADVANCE(197);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(174);
      END_STATE();
    case 198:
      if (lookahead == ' ') ADVANCE(198);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(305);
      END_STATE();
    case 199:
      if (lookahead == ' ') ADVANCE(199);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(285);
      END_STATE();
    case 200:
      if (lookahead == ' ') ADVANCE(200);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(267);
      END_STATE();
    case 201:
      if (lookahead == ' ') ADVANCE(201);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(180);
      END_STATE();
    case 202:
      if (lookahead == ' ') ADVANCE(202);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(303);
      END_STATE();
    case 203:
      if (lookahead == ' ') ADVANCE(203);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(191);
      END_STATE();
    case 204:
      if (lookahead == ' ') ADVANCE(204);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(252);
      END_STATE();
    case 205:
      if (lookahead == ' ') ADVANCE(205);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(165);
      END_STATE();
    case 206:
      if (lookahead == ' ') ADVANCE(206);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(172);
      END_STATE();
    case 207:
      if (lookahead == ' ') ADVANCE(207);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(160);
      END_STATE();
    case 208:
      if (lookahead == ' ') ADVANCE(208);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(306);
      END_STATE();
    case 209:
      if (lookahead == ' ') ADVANCE(209);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(141);
      END_STATE();
    case 210:
      if (lookahead == ' ') ADVANCE(210);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 211:
      if (lookahead == ' ') ADVANCE(211);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(224);
      END_STATE();
    case 212:
      if (lookahead == ' ') ADVANCE(212);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(159);
      END_STATE();
    case 213:
      if (lookahead == ' ') ADVANCE(213);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(288);
      END_STATE();
    case 214:
      if (lookahead == ' ') ADVANCE(214);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(237);
      END_STATE();
    case 215:
      if (lookahead == ' ') ADVANCE(215);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(290);
      END_STATE();
    case 216:
      if (lookahead == ' ') ADVANCE(216);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(275);
      END_STATE();
    case 217:
      if (lookahead == ' ') ADVANCE(217);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(328);
      END_STATE();
    case 218:
      if (lookahead == ' ') ADVANCE(218);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(333);
      END_STATE();
    case 219:
      if (lookahead == ' ') ADVANCE(219);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(286);
      END_STATE();
    case 220:
      if (lookahead == ' ') ADVANCE(220);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(169);
      END_STATE();
    case 221:
      if (lookahead == ' ') ADVANCE(221);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(318);
      END_STATE();
    case 222:
      if (lookahead == ' ') ADVANCE(222);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(278);
      END_STATE();
    case 223:
      if (lookahead == ' ') ADVANCE(223);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(227);
      END_STATE();
    case 224:
      if (lookahead == ' ') ADVANCE(224);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 225:
      if (lookahead == ' ') ADVANCE(225);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(206);
      END_STATE();
    case 226:
      if (lookahead == ' ') ADVANCE(226);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(276);
      END_STATE();
    case 227:
      if (lookahead == ' ') ADVANCE(227);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(62);
      END_STATE();
    case 228:
      if (lookahead == ' ') ADVANCE(228);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(104);
      END_STATE();
    case 229:
      if (lookahead == ' ') ADVANCE(229);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(182);
      END_STATE();
    case 230:
      if (lookahead == ' ') ADVANCE(230);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(132);
      END_STATE();
    case 231:
      if (lookahead == ' ') ADVANCE(231);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(185);
      END_STATE();
    case 232:
      if (lookahead == ' ') ADVANCE(232);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(226);
      END_STATE();
    case 233:
      if (lookahead == ' ') ADVANCE(233);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(157);
      END_STATE();
    case 234:
      if (lookahead == ' ') ADVANCE(234);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(173);
      END_STATE();
    case 235:
      if (lookahead == ' ') ADVANCE(235);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(200);
      END_STATE();
    case 236:
      if (lookahead == ' ') ADVANCE(236);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(207);
      END_STATE();
    case 237:
      if (lookahead == ' ') ADVANCE(237);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(232);
      END_STATE();
    case 238:
      if (lookahead == ' ') ADVANCE(238);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(218);
      END_STATE();
    case 239:
      if (lookahead == ' ') ADVANCE(239);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(236);
      END_STATE();
    case 240:
      if (lookahead == ' ') ADVANCE(240);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(219);
      END_STATE();
    case 241:
      if (lookahead == ' ') ADVANCE(241);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(221);
      END_STATE();
    case 242:
      if (lookahead == ' ') ADVANCE(242);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(211);
      END_STATE();
    case 243:
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(384);
      if (lookahead == ' ' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(243);
      END_STATE();
    case 244:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(347);
      END_STATE();
    case 245:
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '!') ||
          ('#' <= lookahead && lookahead <= '~')) ADVANCE(245);
      if (lookahead == '"') ADVANCE(389);
      END_STATE();
    case 246:
      if (eof) ADVANCE(247);
      if (lookahead == '\n') ADVANCE(369);
      if (lookahead == '\r') ADVANCE(6);
      if (lookahead == ' ') ADVANCE(7);
      if (lookahead == '&') ADVANCE(295);
      if (lookahead == ')') ADVANCE(359);
      if (lookahead == '*') ADVANCE(324);
      if (lookahead == '+') ADVANCE(320);
      if (lookahead == ',') ADVANCE(357);
      if (lookahead == '-') ADVANCE(322);
      if (lookahead == '/') ADVANCE(325);
      if (lookahead == ';') ADVANCE(360);
      if (lookahead == '<') ADVANCE(331);
      if (lookahead == '=') ADVANCE(330);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '?') ADVANCE(306);
      if (lookahead == '^') ADVANCE(326);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(66);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(67);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(10);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(196);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(68);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(12);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(13);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(89);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(90);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(228);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(18);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(69);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(70);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(71);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(72);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(73);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(25);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(371);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_end_tok);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_for_tok);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_next_tok);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_data_tok);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_input_tok);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_del_tok);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_dim_tok);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_read_tok);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_gr_tok);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_text_tok);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_prn_tok);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_inn_tok);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_call_tok);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_plot_tok);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_hlin_tok);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_vlin_tok);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_hgr2_tok);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_hgr_tok);
      if (lookahead == ' ') ADVANCE(64);
      if (lookahead == '2') ADVANCE(264);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_hcoloreq_tok);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_hplot_tok);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_draw_tok);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_xdraw_tok);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_htab_tok);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_home_tok);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_roteq_tok);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_scaleeq_tok);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_shload_tok);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_trace_tok);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_notrace_tok);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_normal_tok);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_inverse_tok);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_flash_tok);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_coloreq_tok);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_pop_tok);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_vtab_tok);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_himem_tok);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_lomem_tok);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_onerr_tok);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_resume_tok);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_recall_tok);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_store_tok);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_speedeq_tok);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_let_tok);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_goto_tok);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_run_tok);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_if_tok);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_restore_tok);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_amp_tok);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_gosub_tok);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_return_tok);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_rem_tok);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_stop_tok);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_on_tok);
      if (lookahead == ' ') ADVANCE(193);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_wait_tok);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_load_tok);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_save_tok);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_def_tok);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_poke_tok);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_print_tok);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_cont_tok);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_list_tok);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_clear_tok);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_get_tok);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_new_tok);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_tabp_tok);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_to_tok);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_fn_tok);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_spcp_tok);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_then_tok);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_at_tok);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_not_tok);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_step_tok);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_plus_tok);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_plus_tok);
      if (lookahead == ' ') ADVANCE(83);
      if (lookahead == '.') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(374);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_minus_tok);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_minus_tok);
      if (lookahead == ' ') ADVANCE(83);
      if (lookahead == '.') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(374);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_times_tok);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_div_tok);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_pow_tok);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_and_tok);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_or_tok);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_gtr_tok);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_eq_tok);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_less_tok);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_sgn_tok);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_int_tok);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_abs_tok);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_usr_tok);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_fre_tok);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_scrnp_tok);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_pdl_tok);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_pos_tok);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_sqr_tok);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_rnd_tok);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_log_tok);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_exp_tok);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_cos_tok);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_sin_tok);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_tan_tok);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_atn_tok);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_peek_tok);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_len_tok);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_str_tok);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_val_tok);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_asc_tok);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_chr_tok);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_left_tok);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_right_tok);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_mid_tok);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_comment_text);
      if (lookahead == '\n') ADVANCE(368);
      if (lookahead != 0) ADVANCE(364);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_comment_text);
      if (lookahead == '\r') ADVANCE(361);
      if (lookahead == ' ') ADVANCE(362);
      if (lookahead == ':') ADVANCE(366);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(364);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_comment_text);
      if (lookahead == ' ') ADVANCE(363);
      if (lookahead == ':') ADVANCE(366);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(364);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_comment_text);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(364);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(364);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_LF);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_CR_LF);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym__empty_line);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_linenum);
      if (lookahead == ' ') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(372);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_linenum);
      if (lookahead == ' ' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(371);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == ' ') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(372);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == ' ') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(373);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == ' ') ADVANCE(84);
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(374);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == ' ') ADVANCE(379);
      if (lookahead == '.') ADVANCE(388);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_literal);
      if (lookahead == ' ') ADVANCE(376);
      if (lookahead == '"') ADVANCE(390);
      if (lookahead == '.') ADVANCE(388);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(395);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '*') ||
          ('/' <= lookahead && lookahead <= '~')) ADVANCE(382);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_literal);
      if (lookahead == ' ') ADVANCE(377);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '+') ||
          lookahead == '-' ||
          lookahead == '/' ||
          (':' <= lookahead && lookahead <= 'D') ||
          ('F' <= lookahead && lookahead <= 'd') ||
          ('f' <= lookahead && lookahead <= '~')) ADVANCE(382);
      if (lookahead == '.') ADVANCE(388);
      if (('E' <= lookahead && lookahead <= 'e')) ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(380);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_literal);
      if (lookahead == ' ') ADVANCE(378);
      if (lookahead == '"') ADVANCE(381);
      if (lookahead == '.') ADVANCE(388);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(395);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '*') ||
          ('/' <= lookahead && lookahead <= '~')) ADVANCE(382);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_literal);
      if (lookahead == ' ') ADVANCE(379);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '+') ||
          lookahead == '-' ||
          lookahead == '/' ||
          (':' <= lookahead && lookahead <= 'D') ||
          ('F' <= lookahead && lookahead <= 'd') ||
          ('f' <= lookahead && lookahead <= '~')) ADVANCE(382);
      if (lookahead == '.') ADVANCE(388);
      if (('E' <= lookahead && lookahead <= 'e')) ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_literal);
      if (lookahead == ' ' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(380);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '+') ||
          lookahead == '-' ||
          ('/' <= lookahead && lookahead <= 'D') ||
          ('F' <= lookahead && lookahead <= 'd') ||
          ('f' <= lookahead && lookahead <= '~')) ADVANCE(382);
      if (lookahead == '.') ADVANCE(388);
      if (('E' <= lookahead && lookahead <= 'e')) ADVANCE(384);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_literal);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '!') ||
          ('#' <= lookahead && lookahead <= '+') ||
          ('-' <= lookahead && lookahead <= '~')) ADVANCE(381);
      if (lookahead == '"') ADVANCE(389);
      if (lookahead == ',') ADVANCE(245);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_literal);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '+') ||
          ('-' <= lookahead && lookahead <= '~')) ADVANCE(382);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_real);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_real);
      if (lookahead == ' ') ADVANCE(384);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(385);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(386);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_real);
      if (lookahead == ' ') ADVANCE(385);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(386);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_real);
      if (lookahead == ' ') ADVANCE(386);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(383);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_real);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(384);
      if (lookahead == ' ' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(387);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_real);
      if (lookahead == ' ' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(388);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(384);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_terminal_string);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '!') ||
          ('#' <= lookahead && lookahead <= '+') ||
          ('-' <= lookahead && lookahead <= '~')) ADVANCE(390);
      if (lookahead == '"') ADVANCE(389);
      if (lookahead == ',') ADVANCE(391);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_terminal_string);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= '!') ||
          ('#' <= lookahead && lookahead <= '~')) ADVANCE(391);
      if (lookahead == '"') ADVANCE(389);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_real_data_item);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_real_data_item);
      if (lookahead == ' ') ADVANCE(393);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(392);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_real_data_item);
      if (lookahead == ' ') ADVANCE(27);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(373);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_real_data_item);
      if (lookahead == ' ') ADVANCE(377);
      if (lookahead == '.') ADVANCE(388);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 246},
  [2] = {.lex_state = 246, .external_lex_state = 1},
  [3] = {.lex_state = 246, .external_lex_state = 1},
  [4] = {.lex_state = 246, .external_lex_state = 1},
  [5] = {.lex_state = 246, .external_lex_state = 1},
  [6] = {.lex_state = 246, .external_lex_state = 1},
  [7] = {.lex_state = 246, .external_lex_state = 1},
  [8] = {.lex_state = 2, .external_lex_state = 1},
  [9] = {.lex_state = 2, .external_lex_state = 1},
  [10] = {.lex_state = 2, .external_lex_state = 1},
  [11] = {.lex_state = 2, .external_lex_state = 1},
  [12] = {.lex_state = 2, .external_lex_state = 1},
  [13] = {.lex_state = 2, .external_lex_state = 1},
  [14] = {.lex_state = 2, .external_lex_state = 1},
  [15] = {.lex_state = 2, .external_lex_state = 1},
  [16] = {.lex_state = 2, .external_lex_state = 1},
  [17] = {.lex_state = 2, .external_lex_state = 1},
  [18] = {.lex_state = 2, .external_lex_state = 1},
  [19] = {.lex_state = 2, .external_lex_state = 1},
  [20] = {.lex_state = 2, .external_lex_state = 1},
  [21] = {.lex_state = 2, .external_lex_state = 1},
  [22] = {.lex_state = 2, .external_lex_state = 1},
  [23] = {.lex_state = 2, .external_lex_state = 1},
  [24] = {.lex_state = 2, .external_lex_state = 1},
  [25] = {.lex_state = 2, .external_lex_state = 1},
  [26] = {.lex_state = 2, .external_lex_state = 1},
  [27] = {.lex_state = 2, .external_lex_state = 1},
  [28] = {.lex_state = 2, .external_lex_state = 1},
  [29] = {.lex_state = 2, .external_lex_state = 1},
  [30] = {.lex_state = 2, .external_lex_state = 1},
  [31] = {.lex_state = 2, .external_lex_state = 1},
  [32] = {.lex_state = 2, .external_lex_state = 1},
  [33] = {.lex_state = 2, .external_lex_state = 1},
  [34] = {.lex_state = 2, .external_lex_state = 1},
  [35] = {.lex_state = 2, .external_lex_state = 1},
  [36] = {.lex_state = 2, .external_lex_state = 1},
  [37] = {.lex_state = 2, .external_lex_state = 1},
  [38] = {.lex_state = 2, .external_lex_state = 1},
  [39] = {.lex_state = 2, .external_lex_state = 1},
  [40] = {.lex_state = 2, .external_lex_state = 1},
  [41] = {.lex_state = 2, .external_lex_state = 1},
  [42] = {.lex_state = 2, .external_lex_state = 1},
  [43] = {.lex_state = 2, .external_lex_state = 1},
  [44] = {.lex_state = 2, .external_lex_state = 1},
  [45] = {.lex_state = 2, .external_lex_state = 1},
  [46] = {.lex_state = 2, .external_lex_state = 1},
  [47] = {.lex_state = 2, .external_lex_state = 1},
  [48] = {.lex_state = 2, .external_lex_state = 1},
  [49] = {.lex_state = 2, .external_lex_state = 1},
  [50] = {.lex_state = 2, .external_lex_state = 1},
  [51] = {.lex_state = 2, .external_lex_state = 1},
  [52] = {.lex_state = 2, .external_lex_state = 1},
  [53] = {.lex_state = 2, .external_lex_state = 1},
  [54] = {.lex_state = 2, .external_lex_state = 1},
  [55] = {.lex_state = 2, .external_lex_state = 1},
  [56] = {.lex_state = 2, .external_lex_state = 1},
  [57] = {.lex_state = 2, .external_lex_state = 1},
  [58] = {.lex_state = 2, .external_lex_state = 1},
  [59] = {.lex_state = 2, .external_lex_state = 1},
  [60] = {.lex_state = 2, .external_lex_state = 1},
  [61] = {.lex_state = 2, .external_lex_state = 1},
  [62] = {.lex_state = 2, .external_lex_state = 1},
  [63] = {.lex_state = 2, .external_lex_state = 1},
  [64] = {.lex_state = 2, .external_lex_state = 1},
  [65] = {.lex_state = 2, .external_lex_state = 1},
  [66] = {.lex_state = 2, .external_lex_state = 1},
  [67] = {.lex_state = 2, .external_lex_state = 1},
  [68] = {.lex_state = 2, .external_lex_state = 1},
  [69] = {.lex_state = 2, .external_lex_state = 1},
  [70] = {.lex_state = 2, .external_lex_state = 1},
  [71] = {.lex_state = 2, .external_lex_state = 1},
  [72] = {.lex_state = 2, .external_lex_state = 1},
  [73] = {.lex_state = 2, .external_lex_state = 1},
  [74] = {.lex_state = 2, .external_lex_state = 1},
  [75] = {.lex_state = 2, .external_lex_state = 1},
  [76] = {.lex_state = 2, .external_lex_state = 1},
  [77] = {.lex_state = 2, .external_lex_state = 1},
  [78] = {.lex_state = 2, .external_lex_state = 1},
  [79] = {.lex_state = 2, .external_lex_state = 1},
  [80] = {.lex_state = 2, .external_lex_state = 1},
  [81] = {.lex_state = 2, .external_lex_state = 1},
  [82] = {.lex_state = 2, .external_lex_state = 1},
  [83] = {.lex_state = 2, .external_lex_state = 1},
  [84] = {.lex_state = 2, .external_lex_state = 1},
  [85] = {.lex_state = 2, .external_lex_state = 1},
  [86] = {.lex_state = 2, .external_lex_state = 1},
  [87] = {.lex_state = 2, .external_lex_state = 1},
  [88] = {.lex_state = 2, .external_lex_state = 1},
  [89] = {.lex_state = 2, .external_lex_state = 1},
  [90] = {.lex_state = 2, .external_lex_state = 1},
  [91] = {.lex_state = 2, .external_lex_state = 1},
  [92] = {.lex_state = 2, .external_lex_state = 1},
  [93] = {.lex_state = 2, .external_lex_state = 1},
  [94] = {.lex_state = 2, .external_lex_state = 1},
  [95] = {.lex_state = 2, .external_lex_state = 1},
  [96] = {.lex_state = 2, .external_lex_state = 1},
  [97] = {.lex_state = 2, .external_lex_state = 1},
  [98] = {.lex_state = 2, .external_lex_state = 1},
  [99] = {.lex_state = 2, .external_lex_state = 1},
  [100] = {.lex_state = 2, .external_lex_state = 1},
  [101] = {.lex_state = 2, .external_lex_state = 1},
  [102] = {.lex_state = 2, .external_lex_state = 1},
  [103] = {.lex_state = 2, .external_lex_state = 1},
  [104] = {.lex_state = 2, .external_lex_state = 1},
  [105] = {.lex_state = 2, .external_lex_state = 1},
  [106] = {.lex_state = 2, .external_lex_state = 1},
  [107] = {.lex_state = 2, .external_lex_state = 1},
  [108] = {.lex_state = 2, .external_lex_state = 1},
  [109] = {.lex_state = 2, .external_lex_state = 1},
  [110] = {.lex_state = 2, .external_lex_state = 1},
  [111] = {.lex_state = 2, .external_lex_state = 1},
  [112] = {.lex_state = 2, .external_lex_state = 1},
  [113] = {.lex_state = 2, .external_lex_state = 1},
  [114] = {.lex_state = 2, .external_lex_state = 1},
  [115] = {.lex_state = 2, .external_lex_state = 1},
  [116] = {.lex_state = 2, .external_lex_state = 1},
  [117] = {.lex_state = 3},
  [118] = {.lex_state = 3},
  [119] = {.lex_state = 3},
  [120] = {.lex_state = 0, .external_lex_state = 1},
  [121] = {.lex_state = 3},
  [122] = {.lex_state = 3},
  [123] = {.lex_state = 3},
  [124] = {.lex_state = 3},
  [125] = {.lex_state = 3},
  [126] = {.lex_state = 3},
  [127] = {.lex_state = 3},
  [128] = {.lex_state = 3},
  [129] = {.lex_state = 3},
  [130] = {.lex_state = 3},
  [131] = {.lex_state = 3},
  [132] = {.lex_state = 3},
  [133] = {.lex_state = 3},
  [134] = {.lex_state = 3},
  [135] = {.lex_state = 3},
  [136] = {.lex_state = 3},
  [137] = {.lex_state = 3},
  [138] = {.lex_state = 3},
  [139] = {.lex_state = 3},
  [140] = {.lex_state = 3},
  [141] = {.lex_state = 3},
  [142] = {.lex_state = 3},
  [143] = {.lex_state = 3},
  [144] = {.lex_state = 3},
  [145] = {.lex_state = 3},
  [146] = {.lex_state = 3},
  [147] = {.lex_state = 0, .external_lex_state = 1},
  [148] = {.lex_state = 0, .external_lex_state = 1},
  [149] = {.lex_state = 0, .external_lex_state = 1},
  [150] = {.lex_state = 0, .external_lex_state = 1},
  [151] = {.lex_state = 0, .external_lex_state = 1},
  [152] = {.lex_state = 0, .external_lex_state = 1},
  [153] = {.lex_state = 0, .external_lex_state = 1},
  [154] = {.lex_state = 0, .external_lex_state = 1},
  [155] = {.lex_state = 0, .external_lex_state = 1},
  [156] = {.lex_state = 0, .external_lex_state = 1},
  [157] = {.lex_state = 0, .external_lex_state = 1},
  [158] = {.lex_state = 0, .external_lex_state = 1},
  [159] = {.lex_state = 0, .external_lex_state = 1},
  [160] = {.lex_state = 0, .external_lex_state = 1},
  [161] = {.lex_state = 3},
  [162] = {.lex_state = 3},
  [163] = {.lex_state = 3},
  [164] = {.lex_state = 3},
  [165] = {.lex_state = 3},
  [166] = {.lex_state = 246},
  [167] = {.lex_state = 3},
  [168] = {.lex_state = 3},
  [169] = {.lex_state = 3},
  [170] = {.lex_state = 3},
  [171] = {.lex_state = 246},
  [172] = {.lex_state = 246},
  [173] = {.lex_state = 3},
  [174] = {.lex_state = 3},
  [175] = {.lex_state = 3},
  [176] = {.lex_state = 3},
  [177] = {.lex_state = 3},
  [178] = {.lex_state = 246},
  [179] = {.lex_state = 246},
  [180] = {.lex_state = 0, .external_lex_state = 1},
  [181] = {.lex_state = 0, .external_lex_state = 1},
  [182] = {.lex_state = 0, .external_lex_state = 1},
  [183] = {.lex_state = 246},
  [184] = {.lex_state = 246},
  [185] = {.lex_state = 246},
  [186] = {.lex_state = 246},
  [187] = {.lex_state = 2, .external_lex_state = 1},
  [188] = {.lex_state = 246},
  [189] = {.lex_state = 246},
  [190] = {.lex_state = 246},
  [191] = {.lex_state = 246},
  [192] = {.lex_state = 246},
  [193] = {.lex_state = 246},
  [194] = {.lex_state = 246},
  [195] = {.lex_state = 246},
  [196] = {.lex_state = 246},
  [197] = {.lex_state = 246},
  [198] = {.lex_state = 246},
  [199] = {.lex_state = 246},
  [200] = {.lex_state = 0, .external_lex_state = 1},
  [201] = {.lex_state = 246},
  [202] = {.lex_state = 246},
  [203] = {.lex_state = 246},
  [204] = {.lex_state = 246},
  [205] = {.lex_state = 246},
  [206] = {.lex_state = 246},
  [207] = {.lex_state = 246},
  [208] = {.lex_state = 246},
  [209] = {.lex_state = 246},
  [210] = {.lex_state = 246},
  [211] = {.lex_state = 246},
  [212] = {.lex_state = 246},
  [213] = {.lex_state = 0, .external_lex_state = 1},
  [214] = {.lex_state = 85},
  [215] = {.lex_state = 85},
  [216] = {.lex_state = 85},
  [217] = {.lex_state = 246},
  [218] = {.lex_state = 246},
  [219] = {.lex_state = 118},
  [220] = {.lex_state = 118},
  [221] = {.lex_state = 118},
  [222] = {.lex_state = 2},
  [223] = {.lex_state = 3},
  [224] = {.lex_state = 3},
  [225] = {.lex_state = 246},
  [226] = {.lex_state = 85},
  [227] = {.lex_state = 246},
  [228] = {.lex_state = 0, .external_lex_state = 1},
  [229] = {.lex_state = 0, .external_lex_state = 1},
  [230] = {.lex_state = 2},
  [231] = {.lex_state = 2},
  [232] = {.lex_state = 3},
  [233] = {.lex_state = 2},
  [234] = {.lex_state = 2},
  [235] = {.lex_state = 118},
  [236] = {.lex_state = 2},
  [237] = {.lex_state = 246},
  [238] = {.lex_state = 2},
  [239] = {.lex_state = 2},
  [240] = {.lex_state = 2},
  [241] = {.lex_state = 2},
  [242] = {.lex_state = 3},
  [243] = {.lex_state = 2},
  [244] = {.lex_state = 3},
  [245] = {.lex_state = 246},
  [246] = {.lex_state = 2},
  [247] = {.lex_state = 2},
  [248] = {.lex_state = 2},
  [249] = {.lex_state = 2},
  [250] = {.lex_state = 2},
  [251] = {.lex_state = 2},
  [252] = {.lex_state = 2},
  [253] = {.lex_state = 2},
  [254] = {.lex_state = 2},
  [255] = {.lex_state = 0, .external_lex_state = 1},
  [256] = {.lex_state = 2},
  [257] = {.lex_state = 3},
  [258] = {.lex_state = 2},
  [259] = {.lex_state = 2},
  [260] = {.lex_state = 2},
  [261] = {.lex_state = 2},
  [262] = {.lex_state = 2},
  [263] = {.lex_state = 2},
  [264] = {.lex_state = 3},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 4},
  [267] = {.lex_state = 2},
  [268] = {.lex_state = 2},
  [269] = {.lex_state = 3},
  [270] = {.lex_state = 2},
  [271] = {.lex_state = 246},
  [272] = {.lex_state = 2},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 0, .external_lex_state = 1},
  [275] = {.lex_state = 2},
  [276] = {.lex_state = 2},
  [277] = {.lex_state = 246},
  [278] = {.lex_state = 246},
  [279] = {.lex_state = 246},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 2},
  [284] = {.lex_state = 2},
  [285] = {.lex_state = 0, .external_lex_state = 1},
  [286] = {.lex_state = 2},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 0, .external_lex_state = 1},
  [289] = {.lex_state = 2},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 246},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 246},
  [294] = {.lex_state = 2},
  [295] = {.lex_state = 246},
  [296] = {.lex_state = 246},
  [297] = {.lex_state = 246},
  [298] = {.lex_state = 246},
  [299] = {.lex_state = 0, .external_lex_state = 1},
  [300] = {.lex_state = 0, .external_lex_state = 1},
  [301] = {.lex_state = 246},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 2},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 2},
  [309] = {.lex_state = 86},
  [310] = {.lex_state = 2},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 2},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 246},
  [316] = {.lex_state = 246},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 246},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 0},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 0, .external_lex_state = 1},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 246},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 246},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 246},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0, .external_lex_state = 1},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
};

enum {
  ts_external_token__ext_name = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__ext_name] = sym__ext_name,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__ext_name] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_end_tok] = ACTIONS(1),
    [sym_for_tok] = ACTIONS(1),
    [sym_next_tok] = ACTIONS(1),
    [sym_data_tok] = ACTIONS(1),
    [sym_input_tok] = ACTIONS(1),
    [sym_del_tok] = ACTIONS(1),
    [sym_dim_tok] = ACTIONS(1),
    [sym_read_tok] = ACTIONS(1),
    [sym_gr_tok] = ACTIONS(1),
    [sym_text_tok] = ACTIONS(1),
    [sym_prn_tok] = ACTIONS(1),
    [sym_inn_tok] = ACTIONS(1),
    [sym_call_tok] = ACTIONS(1),
    [sym_plot_tok] = ACTIONS(1),
    [sym_hlin_tok] = ACTIONS(1),
    [sym_vlin_tok] = ACTIONS(1),
    [sym_hgr2_tok] = ACTIONS(1),
    [sym_hgr_tok] = ACTIONS(1),
    [sym_hcoloreq_tok] = ACTIONS(1),
    [sym_hplot_tok] = ACTIONS(1),
    [sym_draw_tok] = ACTIONS(1),
    [sym_xdraw_tok] = ACTIONS(1),
    [sym_htab_tok] = ACTIONS(1),
    [sym_home_tok] = ACTIONS(1),
    [sym_roteq_tok] = ACTIONS(1),
    [sym_scaleeq_tok] = ACTIONS(1),
    [sym_shload_tok] = ACTIONS(1),
    [sym_trace_tok] = ACTIONS(1),
    [sym_normal_tok] = ACTIONS(1),
    [sym_inverse_tok] = ACTIONS(1),
    [sym_flash_tok] = ACTIONS(1),
    [sym_coloreq_tok] = ACTIONS(1),
    [sym_pop_tok] = ACTIONS(1),
    [sym_vtab_tok] = ACTIONS(1),
    [sym_himem_tok] = ACTIONS(1),
    [sym_lomem_tok] = ACTIONS(1),
    [sym_onerr_tok] = ACTIONS(1),
    [sym_resume_tok] = ACTIONS(1),
    [sym_recall_tok] = ACTIONS(1),
    [sym_store_tok] = ACTIONS(1),
    [sym_speedeq_tok] = ACTIONS(1),
    [sym_let_tok] = ACTIONS(1),
    [sym_goto_tok] = ACTIONS(1),
    [sym_run_tok] = ACTIONS(1),
    [sym_if_tok] = ACTIONS(1),
    [sym_restore_tok] = ACTIONS(1),
    [sym_amp_tok] = ACTIONS(1),
    [sym_gosub_tok] = ACTIONS(1),
    [sym_return_tok] = ACTIONS(1),
    [sym_rem_tok] = ACTIONS(1),
    [sym_stop_tok] = ACTIONS(1),
    [sym_on_tok] = ACTIONS(1),
    [sym_wait_tok] = ACTIONS(1),
    [sym_load_tok] = ACTIONS(1),
    [sym_save_tok] = ACTIONS(1),
    [sym_def_tok] = ACTIONS(1),
    [sym_poke_tok] = ACTIONS(1),
    [sym_print_tok] = ACTIONS(1),
    [sym_cont_tok] = ACTIONS(1),
    [sym_list_tok] = ACTIONS(1),
    [sym_clear_tok] = ACTIONS(1),
    [sym_get_tok] = ACTIONS(1),
    [sym_new_tok] = ACTIONS(1),
    [sym_tabp_tok] = ACTIONS(1),
    [sym_to_tok] = ACTIONS(1),
    [sym_fn_tok] = ACTIONS(1),
    [sym_spcp_tok] = ACTIONS(1),
    [sym_then_tok] = ACTIONS(1),
    [sym_at_tok] = ACTIONS(1),
    [sym_not_tok] = ACTIONS(1),
    [sym_step_tok] = ACTIONS(1),
    [sym_plus_tok] = ACTIONS(1),
    [sym_minus_tok] = ACTIONS(1),
    [sym_times_tok] = ACTIONS(1),
    [sym_div_tok] = ACTIONS(1),
    [sym_pow_tok] = ACTIONS(1),
    [sym_and_tok] = ACTIONS(1),
    [sym_or_tok] = ACTIONS(1),
    [sym_gtr_tok] = ACTIONS(1),
    [sym_eq_tok] = ACTIONS(1),
    [sym_less_tok] = ACTIONS(1),
    [sym_sgn_tok] = ACTIONS(1),
    [sym_int_tok] = ACTIONS(1),
    [sym_abs_tok] = ACTIONS(1),
    [sym_usr_tok] = ACTIONS(1),
    [sym_fre_tok] = ACTIONS(1),
    [sym_scrnp_tok] = ACTIONS(1),
    [sym_pdl_tok] = ACTIONS(1),
    [sym_pos_tok] = ACTIONS(1),
    [sym_sqr_tok] = ACTIONS(1),
    [sym_rnd_tok] = ACTIONS(1),
    [sym_log_tok] = ACTIONS(1),
    [sym_exp_tok] = ACTIONS(1),
    [sym_cos_tok] = ACTIONS(1),
    [sym_sin_tok] = ACTIONS(1),
    [sym_tan_tok] = ACTIONS(1),
    [sym_peek_tok] = ACTIONS(1),
    [sym_len_tok] = ACTIONS(1),
    [sym_str_tok] = ACTIONS(1),
    [sym_val_tok] = ACTIONS(1),
    [sym_asc_tok] = ACTIONS(1),
    [sym_chr_tok] = ACTIONS(1),
    [sym_left_tok] = ACTIONS(1),
    [sym_right_tok] = ACTIONS(1),
    [sym_mid_tok] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LF] = ACTIONS(1),
    [anon_sym_CR_LF] = ACTIONS(1),
    [sym__empty_line] = ACTIONS(1),
    [sym_linenum] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [sym_terminal_string] = ACTIONS(1),
    [sym_real_data_item] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym__ext_name] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(339),
    [sym_line] = STATE(245),
    [aux_sym_source_file_repeat1] = STATE(245),
    [ts_builtin_sym_end] = ACTIONS(3),
    [sym__empty_line] = ACTIONS(5),
    [sym_linenum] = ACTIONS(7),
  },
  [2] = {
    [sym_statement] = STATE(289),
    [sym_terminal_statement] = STATE(303),
    [sym_assignment] = STATE(286),
    [sym__avar] = STATE(323),
    [sym_intvar] = STATE(323),
    [sym_realvar] = STATE(323),
    [sym_svar] = STATE(322),
    [sym__real_scalar] = STATE(142),
    [sym__int_scalar] = STATE(141),
    [sym__string_scalar] = STATE(128),
    [sym__real_array] = STATE(142),
    [sym__int_array] = STATE(141),
    [sym__string_array] = STATE(128),
    [sym__name] = STATE(117),
    [aux_sym_line_repeat1] = STATE(3),
    [sym_end_tok] = ACTIONS(9),
    [sym_for_tok] = ACTIONS(11),
    [sym_next_tok] = ACTIONS(13),
    [sym_data_tok] = ACTIONS(15),
    [sym_input_tok] = ACTIONS(17),
    [sym_del_tok] = ACTIONS(19),
    [sym_dim_tok] = ACTIONS(21),
    [sym_read_tok] = ACTIONS(23),
    [sym_gr_tok] = ACTIONS(9),
    [sym_text_tok] = ACTIONS(9),
    [sym_prn_tok] = ACTIONS(25),
    [sym_inn_tok] = ACTIONS(25),
    [sym_call_tok] = ACTIONS(27),
    [sym_plot_tok] = ACTIONS(29),
    [sym_hlin_tok] = ACTIONS(31),
    [sym_vlin_tok] = ACTIONS(31),
    [sym_hgr2_tok] = ACTIONS(9),
    [sym_hgr_tok] = ACTIONS(33),
    [sym_hcoloreq_tok] = ACTIONS(25),
    [sym_hplot_tok] = ACTIONS(35),
    [sym_draw_tok] = ACTIONS(37),
    [sym_xdraw_tok] = ACTIONS(37),
    [sym_htab_tok] = ACTIONS(25),
    [sym_home_tok] = ACTIONS(9),
    [sym_roteq_tok] = ACTIONS(25),
    [sym_scaleeq_tok] = ACTIONS(25),
    [sym_shload_tok] = ACTIONS(9),
    [sym_trace_tok] = ACTIONS(9),
    [sym_notrace_tok] = ACTIONS(9),
    [sym_normal_tok] = ACTIONS(9),
    [sym_inverse_tok] = ACTIONS(9),
    [sym_flash_tok] = ACTIONS(9),
    [sym_coloreq_tok] = ACTIONS(25),
    [sym_pop_tok] = ACTIONS(9),
    [sym_vtab_tok] = ACTIONS(25),
    [sym_himem_tok] = ACTIONS(25),
    [sym_lomem_tok] = ACTIONS(25),
    [sym_onerr_tok] = ACTIONS(39),
    [sym_resume_tok] = ACTIONS(9),
    [sym_recall_tok] = ACTIONS(41),
    [sym_store_tok] = ACTIONS(41),
    [sym_speedeq_tok] = ACTIONS(25),
    [sym_let_tok] = ACTIONS(43),
    [sym_goto_tok] = ACTIONS(45),
    [sym_run_tok] = ACTIONS(47),
    [sym_if_tok] = ACTIONS(49),
    [sym_restore_tok] = ACTIONS(9),
    [sym_amp_tok] = ACTIONS(51),
    [sym_gosub_tok] = ACTIONS(45),
    [sym_return_tok] = ACTIONS(9),
    [sym_rem_tok] = ACTIONS(53),
    [sym_stop_tok] = ACTIONS(9),
    [sym_on_tok] = ACTIONS(55),
    [sym_wait_tok] = ACTIONS(57),
    [sym_load_tok] = ACTIONS(9),
    [sym_save_tok] = ACTIONS(9),
    [sym_def_tok] = ACTIONS(59),
    [sym_poke_tok] = ACTIONS(29),
    [sym_print_tok] = ACTIONS(61),
    [sym_cont_tok] = ACTIONS(9),
    [sym_list_tok] = ACTIONS(63),
    [sym_clear_tok] = ACTIONS(9),
    [sym_get_tok] = ACTIONS(23),
    [sym_new_tok] = ACTIONS(9),
    [sym__ext_name] = ACTIONS(65),
  },
  [3] = {
    [sym_statement] = STATE(275),
    [sym_terminal_statement] = STATE(308),
    [sym_assignment] = STATE(286),
    [sym__avar] = STATE(323),
    [sym_intvar] = STATE(323),
    [sym_realvar] = STATE(323),
    [sym_svar] = STATE(322),
    [sym__real_scalar] = STATE(142),
    [sym__int_scalar] = STATE(141),
    [sym__string_scalar] = STATE(128),
    [sym__real_array] = STATE(142),
    [sym__int_array] = STATE(141),
    [sym__string_array] = STATE(128),
    [sym__name] = STATE(117),
    [aux_sym_line_repeat1] = STATE(4),
    [sym_end_tok] = ACTIONS(9),
    [sym_for_tok] = ACTIONS(11),
    [sym_next_tok] = ACTIONS(13),
    [sym_data_tok] = ACTIONS(15),
    [sym_input_tok] = ACTIONS(17),
    [sym_del_tok] = ACTIONS(19),
    [sym_dim_tok] = ACTIONS(21),
    [sym_read_tok] = ACTIONS(23),
    [sym_gr_tok] = ACTIONS(9),
    [sym_text_tok] = ACTIONS(9),
    [sym_prn_tok] = ACTIONS(25),
    [sym_inn_tok] = ACTIONS(25),
    [sym_call_tok] = ACTIONS(27),
    [sym_plot_tok] = ACTIONS(29),
    [sym_hlin_tok] = ACTIONS(31),
    [sym_vlin_tok] = ACTIONS(31),
    [sym_hgr2_tok] = ACTIONS(9),
    [sym_hgr_tok] = ACTIONS(33),
    [sym_hcoloreq_tok] = ACTIONS(25),
    [sym_hplot_tok] = ACTIONS(35),
    [sym_draw_tok] = ACTIONS(37),
    [sym_xdraw_tok] = ACTIONS(37),
    [sym_htab_tok] = ACTIONS(25),
    [sym_home_tok] = ACTIONS(9),
    [sym_roteq_tok] = ACTIONS(25),
    [sym_scaleeq_tok] = ACTIONS(25),
    [sym_shload_tok] = ACTIONS(9),
    [sym_trace_tok] = ACTIONS(9),
    [sym_notrace_tok] = ACTIONS(9),
    [sym_normal_tok] = ACTIONS(9),
    [sym_inverse_tok] = ACTIONS(9),
    [sym_flash_tok] = ACTIONS(9),
    [sym_coloreq_tok] = ACTIONS(25),
    [sym_pop_tok] = ACTIONS(9),
    [sym_vtab_tok] = ACTIONS(25),
    [sym_himem_tok] = ACTIONS(25),
    [sym_lomem_tok] = ACTIONS(25),
    [sym_onerr_tok] = ACTIONS(39),
    [sym_resume_tok] = ACTIONS(9),
    [sym_recall_tok] = ACTIONS(41),
    [sym_store_tok] = ACTIONS(41),
    [sym_speedeq_tok] = ACTIONS(25),
    [sym_let_tok] = ACTIONS(43),
    [sym_goto_tok] = ACTIONS(45),
    [sym_run_tok] = ACTIONS(47),
    [sym_if_tok] = ACTIONS(49),
    [sym_restore_tok] = ACTIONS(9),
    [sym_amp_tok] = ACTIONS(51),
    [sym_gosub_tok] = ACTIONS(45),
    [sym_return_tok] = ACTIONS(9),
    [sym_rem_tok] = ACTIONS(53),
    [sym_stop_tok] = ACTIONS(9),
    [sym_on_tok] = ACTIONS(55),
    [sym_wait_tok] = ACTIONS(57),
    [sym_load_tok] = ACTIONS(9),
    [sym_save_tok] = ACTIONS(9),
    [sym_def_tok] = ACTIONS(59),
    [sym_poke_tok] = ACTIONS(29),
    [sym_print_tok] = ACTIONS(61),
    [sym_cont_tok] = ACTIONS(9),
    [sym_list_tok] = ACTIONS(63),
    [sym_clear_tok] = ACTIONS(9),
    [sym_get_tok] = ACTIONS(23),
    [sym_new_tok] = ACTIONS(9),
    [sym__ext_name] = ACTIONS(65),
  },
  [4] = {
    [sym_statement] = STATE(351),
    [sym_assignment] = STATE(286),
    [sym__avar] = STATE(323),
    [sym_intvar] = STATE(323),
    [sym_realvar] = STATE(323),
    [sym_svar] = STATE(322),
    [sym__real_scalar] = STATE(142),
    [sym__int_scalar] = STATE(141),
    [sym__string_scalar] = STATE(128),
    [sym__real_array] = STATE(142),
    [sym__int_array] = STATE(141),
    [sym__string_array] = STATE(128),
    [sym__name] = STATE(117),
    [aux_sym_line_repeat1] = STATE(4),
    [sym_end_tok] = ACTIONS(67),
    [sym_for_tok] = ACTIONS(70),
    [sym_next_tok] = ACTIONS(73),
    [sym_data_tok] = ACTIONS(76),
    [sym_input_tok] = ACTIONS(79),
    [sym_del_tok] = ACTIONS(82),
    [sym_dim_tok] = ACTIONS(85),
    [sym_read_tok] = ACTIONS(88),
    [sym_gr_tok] = ACTIONS(67),
    [sym_text_tok] = ACTIONS(67),
    [sym_prn_tok] = ACTIONS(91),
    [sym_inn_tok] = ACTIONS(91),
    [sym_call_tok] = ACTIONS(94),
    [sym_plot_tok] = ACTIONS(97),
    [sym_hlin_tok] = ACTIONS(100),
    [sym_vlin_tok] = ACTIONS(100),
    [sym_hgr2_tok] = ACTIONS(67),
    [sym_hgr_tok] = ACTIONS(103),
    [sym_hcoloreq_tok] = ACTIONS(91),
    [sym_hplot_tok] = ACTIONS(106),
    [sym_draw_tok] = ACTIONS(109),
    [sym_xdraw_tok] = ACTIONS(109),
    [sym_htab_tok] = ACTIONS(91),
    [sym_home_tok] = ACTIONS(67),
    [sym_roteq_tok] = ACTIONS(91),
    [sym_scaleeq_tok] = ACTIONS(91),
    [sym_shload_tok] = ACTIONS(67),
    [sym_trace_tok] = ACTIONS(67),
    [sym_notrace_tok] = ACTIONS(67),
    [sym_normal_tok] = ACTIONS(67),
    [sym_inverse_tok] = ACTIONS(67),
    [sym_flash_tok] = ACTIONS(67),
    [sym_coloreq_tok] = ACTIONS(91),
    [sym_pop_tok] = ACTIONS(67),
    [sym_vtab_tok] = ACTIONS(91),
    [sym_himem_tok] = ACTIONS(91),
    [sym_lomem_tok] = ACTIONS(91),
    [sym_onerr_tok] = ACTIONS(112),
    [sym_resume_tok] = ACTIONS(67),
    [sym_recall_tok] = ACTIONS(115),
    [sym_store_tok] = ACTIONS(115),
    [sym_speedeq_tok] = ACTIONS(91),
    [sym_let_tok] = ACTIONS(118),
    [sym_goto_tok] = ACTIONS(121),
    [sym_run_tok] = ACTIONS(124),
    [sym_if_tok] = ACTIONS(127),
    [sym_restore_tok] = ACTIONS(67),
    [sym_amp_tok] = ACTIONS(130),
    [sym_gosub_tok] = ACTIONS(121),
    [sym_return_tok] = ACTIONS(67),
    [sym_rem_tok] = ACTIONS(133),
    [sym_stop_tok] = ACTIONS(67),
    [sym_on_tok] = ACTIONS(136),
    [sym_wait_tok] = ACTIONS(139),
    [sym_load_tok] = ACTIONS(67),
    [sym_save_tok] = ACTIONS(67),
    [sym_def_tok] = ACTIONS(142),
    [sym_poke_tok] = ACTIONS(97),
    [sym_print_tok] = ACTIONS(145),
    [sym_cont_tok] = ACTIONS(67),
    [sym_list_tok] = ACTIONS(148),
    [sym_clear_tok] = ACTIONS(67),
    [sym_get_tok] = ACTIONS(88),
    [sym_new_tok] = ACTIONS(67),
    [sym__ext_name] = ACTIONS(151),
  },
  [5] = {
    [sym_statement] = STATE(294),
    [sym_assignment] = STATE(286),
    [sym__avar] = STATE(323),
    [sym_intvar] = STATE(323),
    [sym_realvar] = STATE(323),
    [sym_svar] = STATE(322),
    [sym__real_scalar] = STATE(142),
    [sym__int_scalar] = STATE(141),
    [sym__string_scalar] = STATE(128),
    [sym__real_array] = STATE(142),
    [sym__int_array] = STATE(141),
    [sym__string_array] = STATE(128),
    [sym__name] = STATE(117),
    [sym_end_tok] = ACTIONS(9),
    [sym_for_tok] = ACTIONS(11),
    [sym_next_tok] = ACTIONS(13),
    [sym_data_tok] = ACTIONS(154),
    [sym_input_tok] = ACTIONS(17),
    [sym_del_tok] = ACTIONS(19),
    [sym_dim_tok] = ACTIONS(21),
    [sym_read_tok] = ACTIONS(23),
    [sym_gr_tok] = ACTIONS(9),
    [sym_text_tok] = ACTIONS(9),
    [sym_prn_tok] = ACTIONS(25),
    [sym_inn_tok] = ACTIONS(25),
    [sym_call_tok] = ACTIONS(156),
    [sym_plot_tok] = ACTIONS(29),
    [sym_hlin_tok] = ACTIONS(31),
    [sym_vlin_tok] = ACTIONS(31),
    [sym_hgr2_tok] = ACTIONS(9),
    [sym_hgr_tok] = ACTIONS(33),
    [sym_hcoloreq_tok] = ACTIONS(25),
    [sym_hplot_tok] = ACTIONS(35),
    [sym_draw_tok] = ACTIONS(37),
    [sym_xdraw_tok] = ACTIONS(37),
    [sym_htab_tok] = ACTIONS(25),
    [sym_home_tok] = ACTIONS(9),
    [sym_roteq_tok] = ACTIONS(25),
    [sym_scaleeq_tok] = ACTIONS(25),
    [sym_shload_tok] = ACTIONS(9),
    [sym_trace_tok] = ACTIONS(9),
    [sym_notrace_tok] = ACTIONS(9),
    [sym_normal_tok] = ACTIONS(9),
    [sym_inverse_tok] = ACTIONS(9),
    [sym_flash_tok] = ACTIONS(9),
    [sym_coloreq_tok] = ACTIONS(25),
    [sym_pop_tok] = ACTIONS(9),
    [sym_vtab_tok] = ACTIONS(25),
    [sym_himem_tok] = ACTIONS(25),
    [sym_lomem_tok] = ACTIONS(25),
    [sym_onerr_tok] = ACTIONS(39),
    [sym_resume_tok] = ACTIONS(9),
    [sym_recall_tok] = ACTIONS(41),
    [sym_store_tok] = ACTIONS(41),
    [sym_speedeq_tok] = ACTIONS(25),
    [sym_let_tok] = ACTIONS(43),
    [sym_goto_tok] = ACTIONS(45),
    [sym_run_tok] = ACTIONS(47),
    [sym_if_tok] = ACTIONS(49),
    [sym_restore_tok] = ACTIONS(9),
    [sym_amp_tok] = ACTIONS(158),
    [sym_gosub_tok] = ACTIONS(45),
    [sym_return_tok] = ACTIONS(9),
    [sym_rem_tok] = ACTIONS(53),
    [sym_stop_tok] = ACTIONS(9),
    [sym_on_tok] = ACTIONS(55),
    [sym_wait_tok] = ACTIONS(57),
    [sym_load_tok] = ACTIONS(9),
    [sym_save_tok] = ACTIONS(9),
    [sym_def_tok] = ACTIONS(59),
    [sym_poke_tok] = ACTIONS(29),
    [sym_print_tok] = ACTIONS(160),
    [sym_cont_tok] = ACTIONS(9),
    [sym_list_tok] = ACTIONS(63),
    [sym_clear_tok] = ACTIONS(9),
    [sym_get_tok] = ACTIONS(23),
    [sym_new_tok] = ACTIONS(9),
    [sym_linenum] = ACTIONS(162),
    [sym__ext_name] = ACTIONS(65),
  },
  [6] = {
    [sym_statement] = STATE(294),
    [sym_assignment] = STATE(286),
    [sym__avar] = STATE(323),
    [sym_intvar] = STATE(323),
    [sym_realvar] = STATE(323),
    [sym_svar] = STATE(322),
    [sym__real_scalar] = STATE(142),
    [sym__int_scalar] = STATE(141),
    [sym__string_scalar] = STATE(128),
    [sym__real_array] = STATE(142),
    [sym__int_array] = STATE(141),
    [sym__string_array] = STATE(128),
    [sym__name] = STATE(117),
    [sym_end_tok] = ACTIONS(9),
    [sym_for_tok] = ACTIONS(11),
    [sym_next_tok] = ACTIONS(13),
    [sym_data_tok] = ACTIONS(154),
    [sym_input_tok] = ACTIONS(17),
    [sym_del_tok] = ACTIONS(19),
    [sym_dim_tok] = ACTIONS(21),
    [sym_read_tok] = ACTIONS(23),
    [sym_gr_tok] = ACTIONS(9),
    [sym_text_tok] = ACTIONS(9),
    [sym_prn_tok] = ACTIONS(25),
    [sym_inn_tok] = ACTIONS(25),
    [sym_call_tok] = ACTIONS(156),
    [sym_plot_tok] = ACTIONS(29),
    [sym_hlin_tok] = ACTIONS(31),
    [sym_vlin_tok] = ACTIONS(31),
    [sym_hgr2_tok] = ACTIONS(9),
    [sym_hgr_tok] = ACTIONS(33),
    [sym_hcoloreq_tok] = ACTIONS(25),
    [sym_hplot_tok] = ACTIONS(35),
    [sym_draw_tok] = ACTIONS(37),
    [sym_xdraw_tok] = ACTIONS(37),
    [sym_htab_tok] = ACTIONS(25),
    [sym_home_tok] = ACTIONS(9),
    [sym_roteq_tok] = ACTIONS(25),
    [sym_scaleeq_tok] = ACTIONS(25),
    [sym_shload_tok] = ACTIONS(9),
    [sym_trace_tok] = ACTIONS(9),
    [sym_notrace_tok] = ACTIONS(9),
    [sym_normal_tok] = ACTIONS(9),
    [sym_inverse_tok] = ACTIONS(9),
    [sym_flash_tok] = ACTIONS(9),
    [sym_coloreq_tok] = ACTIONS(25),
    [sym_pop_tok] = ACTIONS(9),
    [sym_vtab_tok] = ACTIONS(25),
    [sym_himem_tok] = ACTIONS(25),
    [sym_lomem_tok] = ACTIONS(25),
    [sym_onerr_tok] = ACTIONS(39),
    [sym_resume_tok] = ACTIONS(9),
    [sym_recall_tok] = ACTIONS(41),
    [sym_store_tok] = ACTIONS(41),
    [sym_speedeq_tok] = ACTIONS(25),
    [sym_let_tok] = ACTIONS(43),
    [sym_goto_tok] = ACTIONS(45),
    [sym_run_tok] = ACTIONS(47),
    [sym_if_tok] = ACTIONS(164),
    [sym_restore_tok] = ACTIONS(9),
    [sym_amp_tok] = ACTIONS(158),
    [sym_gosub_tok] = ACTIONS(45),
    [sym_return_tok] = ACTIONS(9),
    [sym_rem_tok] = ACTIONS(166),
    [sym_stop_tok] = ACTIONS(9),
    [sym_on_tok] = ACTIONS(55),
    [sym_wait_tok] = ACTIONS(57),
    [sym_load_tok] = ACTIONS(9),
    [sym_save_tok] = ACTIONS(9),
    [sym_def_tok] = ACTIONS(59),
    [sym_poke_tok] = ACTIONS(29),
    [sym_print_tok] = ACTIONS(160),
    [sym_cont_tok] = ACTIONS(9),
    [sym_list_tok] = ACTIONS(63),
    [sym_clear_tok] = ACTIONS(9),
    [sym_get_tok] = ACTIONS(23),
    [sym_new_tok] = ACTIONS(9),
    [sym_linenum] = ACTIONS(162),
    [sym__ext_name] = ACTIONS(65),
  },
  [7] = {
    [sym_end_tok] = ACTIONS(168),
    [sym_for_tok] = ACTIONS(168),
    [sym_next_tok] = ACTIONS(168),
    [sym_data_tok] = ACTIONS(168),
    [sym_input_tok] = ACTIONS(168),
    [sym_del_tok] = ACTIONS(168),
    [sym_dim_tok] = ACTIONS(168),
    [sym_read_tok] = ACTIONS(168),
    [sym_gr_tok] = ACTIONS(168),
    [sym_text_tok] = ACTIONS(168),
    [sym_prn_tok] = ACTIONS(168),
    [sym_inn_tok] = ACTIONS(168),
    [sym_call_tok] = ACTIONS(168),
    [sym_plot_tok] = ACTIONS(168),
    [sym_hlin_tok] = ACTIONS(168),
    [sym_vlin_tok] = ACTIONS(168),
    [sym_hgr2_tok] = ACTIONS(168),
    [sym_hgr_tok] = ACTIONS(170),
    [sym_hcoloreq_tok] = ACTIONS(168),
    [sym_hplot_tok] = ACTIONS(168),
    [sym_draw_tok] = ACTIONS(168),
    [sym_xdraw_tok] = ACTIONS(168),
    [sym_htab_tok] = ACTIONS(168),
    [sym_home_tok] = ACTIONS(168),
    [sym_roteq_tok] = ACTIONS(168),
    [sym_scaleeq_tok] = ACTIONS(168),
    [sym_shload_tok] = ACTIONS(168),
    [sym_trace_tok] = ACTIONS(168),
    [sym_notrace_tok] = ACTIONS(168),
    [sym_normal_tok] = ACTIONS(168),
    [sym_inverse_tok] = ACTIONS(168),
    [sym_flash_tok] = ACTIONS(168),
    [sym_coloreq_tok] = ACTIONS(168),
    [sym_pop_tok] = ACTIONS(168),
    [sym_vtab_tok] = ACTIONS(168),
    [sym_himem_tok] = ACTIONS(168),
    [sym_lomem_tok] = ACTIONS(168),
    [sym_onerr_tok] = ACTIONS(168),
    [sym_resume_tok] = ACTIONS(168),
    [sym_recall_tok] = ACTIONS(168),
    [sym_store_tok] = ACTIONS(168),
    [sym_speedeq_tok] = ACTIONS(168),
    [sym_let_tok] = ACTIONS(168),
    [sym_goto_tok] = ACTIONS(168),
    [sym_run_tok] = ACTIONS(168),
    [sym_if_tok] = ACTIONS(168),
    [sym_restore_tok] = ACTIONS(168),
    [sym_amp_tok] = ACTIONS(168),
    [sym_gosub_tok] = ACTIONS(168),
    [sym_return_tok] = ACTIONS(168),
    [sym_rem_tok] = ACTIONS(168),
    [sym_stop_tok] = ACTIONS(168),
    [sym_on_tok] = ACTIONS(170),
    [sym_wait_tok] = ACTIONS(168),
    [sym_load_tok] = ACTIONS(168),
    [sym_save_tok] = ACTIONS(168),
    [sym_def_tok] = ACTIONS(168),
    [sym_poke_tok] = ACTIONS(168),
    [sym_print_tok] = ACTIONS(168),
    [sym_cont_tok] = ACTIONS(168),
    [sym_list_tok] = ACTIONS(168),
    [sym_clear_tok] = ACTIONS(168),
    [sym_get_tok] = ACTIONS(168),
    [sym_new_tok] = ACTIONS(168),
    [sym__ext_name] = ACTIONS(168),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 26,
    ACTIONS(174), 1,
      sym_fn_tok,
    ACTIONS(176), 1,
      sym_not_tok,
    ACTIONS(184), 1,
      sym_scrnp_tok,
    ACTIONS(192), 1,
      sym_mid_tok,
    ACTIONS(194), 1,
      anon_sym_LPAREN,
    ACTIONS(198), 1,
      sym_integer,
    ACTIONS(200), 1,
      sym_real,
    ACTIONS(202), 1,
      sym_string,
    ACTIONS(204), 1,
      sym_terminal_string,
    ACTIONS(206), 1,
      sym__ext_name,
    STATE(9), 1,
      aux_sym_statement_repeat7,
    STATE(79), 1,
      sym__name,
    STATE(111), 1,
      sym__expr,
    ACTIONS(172), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(178), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(182), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(188), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(190), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(96), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(100), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(102), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(186), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    ACTIONS(196), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
    STATE(110), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(85), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(180), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [115] = 26,
    ACTIONS(211), 1,
      sym_fn_tok,
    ACTIONS(214), 1,
      sym_not_tok,
    ACTIONS(226), 1,
      sym_scrnp_tok,
    ACTIONS(238), 1,
      sym_mid_tok,
    ACTIONS(241), 1,
      anon_sym_LPAREN,
    ACTIONS(246), 1,
      sym_integer,
    ACTIONS(249), 1,
      sym_real,
    ACTIONS(252), 1,
      sym_string,
    ACTIONS(255), 1,
      sym_terminal_string,
    ACTIONS(257), 1,
      sym__ext_name,
    STATE(9), 1,
      aux_sym_statement_repeat7,
    STATE(79), 1,
      sym__name,
    STATE(111), 1,
      sym__expr,
    ACTIONS(208), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(217), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(223), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(232), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(235), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(96), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(100), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(102), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(229), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    ACTIONS(244), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
    STATE(110), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(85), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(220), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [230] = 26,
    ACTIONS(174), 1,
      sym_fn_tok,
    ACTIONS(176), 1,
      sym_not_tok,
    ACTIONS(184), 1,
      sym_scrnp_tok,
    ACTIONS(192), 1,
      sym_mid_tok,
    ACTIONS(194), 1,
      anon_sym_LPAREN,
    ACTIONS(198), 1,
      sym_integer,
    ACTIONS(200), 1,
      sym_real,
    ACTIONS(202), 1,
      sym_string,
    ACTIONS(206), 1,
      sym__ext_name,
    ACTIONS(262), 1,
      sym_terminal_string,
    STATE(8), 1,
      aux_sym_statement_repeat7,
    STATE(79), 1,
      sym__name,
    STATE(111), 1,
      sym__expr,
    ACTIONS(172), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(178), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(182), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(188), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(190), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(96), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(100), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(102), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(186), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    ACTIONS(260), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
    STATE(110), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(85), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(180), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [345] = 25,
    ACTIONS(174), 1,
      sym_fn_tok,
    ACTIONS(176), 1,
      sym_not_tok,
    ACTIONS(184), 1,
      sym_scrnp_tok,
    ACTIONS(192), 1,
      sym_mid_tok,
    ACTIONS(194), 1,
      anon_sym_LPAREN,
    ACTIONS(198), 1,
      sym_integer,
    ACTIONS(200), 1,
      sym_real,
    ACTIONS(202), 1,
      sym_string,
    ACTIONS(206), 1,
      sym__ext_name,
    STATE(12), 1,
      aux_sym_statement_repeat7,
    STATE(79), 1,
      sym__name,
    STATE(111), 1,
      sym__expr,
    ACTIONS(172), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(178), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(182), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(188), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(190), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(96), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(100), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(102), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(186), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    ACTIONS(260), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
    STATE(110), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(85), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(180), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [457] = 25,
    ACTIONS(174), 1,
      sym_fn_tok,
    ACTIONS(176), 1,
      sym_not_tok,
    ACTIONS(184), 1,
      sym_scrnp_tok,
    ACTIONS(192), 1,
      sym_mid_tok,
    ACTIONS(194), 1,
      anon_sym_LPAREN,
    ACTIONS(198), 1,
      sym_integer,
    ACTIONS(200), 1,
      sym_real,
    ACTIONS(202), 1,
      sym_string,
    ACTIONS(206), 1,
      sym__ext_name,
    STATE(9), 1,
      aux_sym_statement_repeat7,
    STATE(79), 1,
      sym__name,
    STATE(111), 1,
      sym__expr,
    ACTIONS(172), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(178), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(182), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(188), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(190), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(96), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(100), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(102), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(186), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    ACTIONS(196), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
    STATE(110), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(85), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(180), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [569] = 23,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(288), 1,
      sym_integer,
    ACTIONS(290), 1,
      sym_real,
    ACTIONS(292), 1,
      sym_string,
    STATE(117), 1,
      sym__name,
    STATE(305), 1,
      sym__expr,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(166), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [673] = 23,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(288), 1,
      sym_integer,
    ACTIONS(290), 1,
      sym_real,
    ACTIONS(292), 1,
      sym_string,
    STATE(117), 1,
      sym__name,
    STATE(349), 1,
      sym__expr,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(166), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [777] = 23,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(288), 1,
      sym_integer,
    ACTIONS(290), 1,
      sym_real,
    ACTIONS(292), 1,
      sym_string,
    STATE(117), 1,
      sym__name,
    STATE(324), 1,
      sym__expr,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(166), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [881] = 23,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(288), 1,
      sym_integer,
    ACTIONS(290), 1,
      sym_real,
    ACTIONS(292), 1,
      sym_string,
    STATE(117), 1,
      sym__name,
    STATE(281), 1,
      sym__expr,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(166), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [985] = 23,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(288), 1,
      sym_integer,
    ACTIONS(290), 1,
      sym_real,
    ACTIONS(292), 1,
      sym_string,
    STATE(117), 1,
      sym__name,
    STATE(306), 1,
      sym__expr,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(166), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1089] = 23,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(288), 1,
      sym_integer,
    ACTIONS(290), 1,
      sym_real,
    ACTIONS(292), 1,
      sym_string,
    STATE(117), 1,
      sym__name,
    STATE(302), 1,
      sym__expr,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(166), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1193] = 23,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(294), 1,
      sym_to_tok,
    ACTIONS(296), 1,
      sym_integer,
    ACTIONS(298), 1,
      sym_real,
    ACTIONS(300), 1,
      sym_string,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(186), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1297] = 22,
    ACTIONS(174), 1,
      sym_fn_tok,
    ACTIONS(176), 1,
      sym_not_tok,
    ACTIONS(184), 1,
      sym_scrnp_tok,
    ACTIONS(206), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(302), 1,
      anon_sym_LPAREN,
    ACTIONS(304), 1,
      sym_integer,
    ACTIONS(306), 1,
      sym_real,
    ACTIONS(308), 1,
      sym_string,
    STATE(80), 1,
      sym__name,
    ACTIONS(178), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(182), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(100), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(102), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(186), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(225), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(91), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(180), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1398] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(310), 1,
      sym_integer,
    ACTIONS(312), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(189), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1499] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(314), 1,
      sym_integer,
    ACTIONS(316), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(206), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1600] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(318), 1,
      sym_integer,
    ACTIONS(320), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(207), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1701] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(322), 1,
      sym_integer,
    ACTIONS(324), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(167), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1802] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(326), 1,
      sym_integer,
    ACTIONS(328), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(201), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1903] = 22,
    ACTIONS(174), 1,
      sym_fn_tok,
    ACTIONS(176), 1,
      sym_not_tok,
    ACTIONS(184), 1,
      sym_scrnp_tok,
    ACTIONS(206), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(302), 1,
      anon_sym_LPAREN,
    ACTIONS(308), 1,
      sym_string,
    ACTIONS(330), 1,
      sym_integer,
    ACTIONS(332), 1,
      sym_real,
    STATE(80), 1,
      sym__name,
    ACTIONS(178), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(182), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(100), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(102), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(186), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(225), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(90), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(180), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2004] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(334), 1,
      sym_integer,
    ACTIONS(336), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(202), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2105] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(338), 1,
      sym_integer,
    ACTIONS(340), 1,
      sym_real,
    ACTIONS(342), 1,
      sym_string,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(217), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(197), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2206] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(344), 1,
      sym_integer,
    ACTIONS(346), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(124), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2307] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(348), 1,
      sym_integer,
    ACTIONS(350), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(129), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2408] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(352), 1,
      sym_integer,
    ACTIONS(354), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(178), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2509] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(356), 1,
      sym_integer,
    ACTIONS(358), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(196), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2610] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(360), 1,
      sym_integer,
    ACTIONS(362), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(131), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2711] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(364), 1,
      sym_integer,
    ACTIONS(366), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(134), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2812] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(368), 1,
      sym_integer,
    ACTIONS(370), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(185), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2913] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(372), 1,
      sym_integer,
    ACTIONS(374), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(191), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3014] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(376), 1,
      sym_integer,
    ACTIONS(378), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(135), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3115] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(380), 1,
      sym_integer,
    ACTIONS(382), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(137), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3216] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(384), 1,
      sym_integer,
    ACTIONS(386), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(176), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3317] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(388), 1,
      sym_integer,
    ACTIONS(390), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(203), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3418] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(392), 1,
      sym_integer,
    ACTIONS(394), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(163), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3519] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(396), 1,
      sym_integer,
    ACTIONS(398), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(171), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3620] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(400), 1,
      sym_integer,
    ACTIONS(402), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(199), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3721] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(404), 1,
      sym_integer,
    ACTIONS(406), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(170), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3822] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(408), 1,
      sym_integer,
    ACTIONS(410), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(175), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3923] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(412), 1,
      sym_integer,
    ACTIONS(414), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(179), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4024] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(416), 1,
      sym_integer,
    ACTIONS(418), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(190), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4125] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(420), 1,
      sym_integer,
    ACTIONS(422), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(169), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4226] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(424), 1,
      sym_integer,
    ACTIONS(426), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(183), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4327] = 22,
    ACTIONS(174), 1,
      sym_fn_tok,
    ACTIONS(176), 1,
      sym_not_tok,
    ACTIONS(184), 1,
      sym_scrnp_tok,
    ACTIONS(206), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(302), 1,
      anon_sym_LPAREN,
    ACTIONS(308), 1,
      sym_string,
    ACTIONS(428), 1,
      sym_integer,
    ACTIONS(430), 1,
      sym_real,
    STATE(80), 1,
      sym__name,
    ACTIONS(178), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(182), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(100), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(102), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(186), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(225), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(86), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(180), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4428] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(432), 1,
      sym_integer,
    ACTIONS(434), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(195), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4529] = 22,
    ACTIONS(174), 1,
      sym_fn_tok,
    ACTIONS(176), 1,
      sym_not_tok,
    ACTIONS(184), 1,
      sym_scrnp_tok,
    ACTIONS(206), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(302), 1,
      anon_sym_LPAREN,
    ACTIONS(308), 1,
      sym_string,
    ACTIONS(436), 1,
      sym_integer,
    ACTIONS(438), 1,
      sym_real,
    STATE(80), 1,
      sym__name,
    ACTIONS(178), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(182), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(100), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(102), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(186), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(225), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(82), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(180), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4630] = 22,
    ACTIONS(174), 1,
      sym_fn_tok,
    ACTIONS(176), 1,
      sym_not_tok,
    ACTIONS(184), 1,
      sym_scrnp_tok,
    ACTIONS(206), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(302), 1,
      anon_sym_LPAREN,
    ACTIONS(308), 1,
      sym_string,
    ACTIONS(440), 1,
      sym_integer,
    ACTIONS(442), 1,
      sym_real,
    STATE(80), 1,
      sym__name,
    ACTIONS(178), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(182), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(100), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(102), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(186), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(225), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(89), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(180), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4731] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(444), 1,
      sym_integer,
    ACTIONS(446), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(204), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4832] = 22,
    ACTIONS(174), 1,
      sym_fn_tok,
    ACTIONS(176), 1,
      sym_not_tok,
    ACTIONS(184), 1,
      sym_scrnp_tok,
    ACTIONS(206), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(302), 1,
      anon_sym_LPAREN,
    ACTIONS(308), 1,
      sym_string,
    ACTIONS(448), 1,
      sym_integer,
    ACTIONS(450), 1,
      sym_real,
    STATE(80), 1,
      sym__name,
    ACTIONS(178), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(182), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(100), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(102), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(186), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(225), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(92), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(180), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4933] = 22,
    ACTIONS(174), 1,
      sym_fn_tok,
    ACTIONS(176), 1,
      sym_not_tok,
    ACTIONS(184), 1,
      sym_scrnp_tok,
    ACTIONS(206), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(302), 1,
      anon_sym_LPAREN,
    ACTIONS(308), 1,
      sym_string,
    ACTIONS(452), 1,
      sym_integer,
    ACTIONS(454), 1,
      sym_real,
    STATE(80), 1,
      sym__name,
    ACTIONS(178), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(182), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(100), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(102), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(186), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(225), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(93), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(180), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5034] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(456), 1,
      sym_integer,
    ACTIONS(458), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(188), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5135] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(460), 1,
      sym_integer,
    ACTIONS(462), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(192), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5236] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(464), 1,
      sym_integer,
    ACTIONS(466), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(168), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5337] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(468), 1,
      sym_integer,
    ACTIONS(470), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(172), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5438] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(338), 1,
      sym_integer,
    ACTIONS(340), 1,
      sym_real,
    ACTIONS(472), 1,
      sym_string,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(218), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(197), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5539] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(474), 1,
      sym_integer,
    ACTIONS(476), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(208), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5640] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(478), 1,
      sym_integer,
    ACTIONS(480), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(130), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5741] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(482), 1,
      sym_integer,
    ACTIONS(484), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(162), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5842] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(486), 1,
      sym_integer,
    ACTIONS(488), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(161), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5943] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(490), 1,
      sym_integer,
    ACTIONS(492), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(193), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6044] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(494), 1,
      sym_integer,
    ACTIONS(496), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(174), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6145] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(342), 1,
      sym_string,
    ACTIONS(498), 1,
      sym_integer,
    ACTIONS(500), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(217), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(198), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6246] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(502), 1,
      sym_integer,
    ACTIONS(504), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(165), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6347] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(506), 1,
      sym_integer,
    ACTIONS(508), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(205), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6448] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(510), 1,
      sym_integer,
    ACTIONS(512), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(173), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6549] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(514), 1,
      sym_integer,
    ACTIONS(516), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(211), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6650] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(518), 1,
      sym_integer,
    ACTIONS(520), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(210), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6751] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(522), 1,
      sym_integer,
    ACTIONS(524), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(177), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6852] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(526), 1,
      sym_integer,
    ACTIONS(528), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(184), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6953] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(530), 1,
      sym_integer,
    ACTIONS(532), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(209), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [7054] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(534), 1,
      sym_integer,
    ACTIONS(536), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(164), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [7155] = 22,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(266), 1,
      sym_fn_tok,
    ACTIONS(268), 1,
      sym_not_tok,
    ACTIONS(276), 1,
      sym_scrnp_tok,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_string,
    ACTIONS(538), 1,
      sym_integer,
    ACTIONS(540), 1,
      sym_real,
    STATE(117), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(270), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(274), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(278), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(194), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(272), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [7256] = 6,
    ACTIONS(546), 1,
      anon_sym_LPAREN,
    ACTIONS(548), 1,
      anon_sym_PERCENT,
    ACTIONS(550), 1,
      anon_sym_DOLLAR,
    STATE(99), 1,
      sym_subscript,
    ACTIONS(544), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(542), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7322] = 6,
    ACTIONS(546), 1,
      anon_sym_LPAREN,
    ACTIONS(548), 1,
      anon_sym_PERCENT,
    ACTIONS(552), 1,
      anon_sym_DOLLAR,
    STATE(99), 1,
      sym_subscript,
    ACTIONS(544), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(542), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7388] = 2,
    ACTIONS(556), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(554), 48,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
  [7445] = 10,
    ACTIONS(564), 1,
      sym_pow_tok,
    ACTIONS(566), 1,
      sym_and_tok,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    STATE(50), 1,
      sym__relop,
    ACTIONS(560), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(562), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(574), 2,
      sym_integer,
      sym_terminal_string,
    ACTIONS(558), 39,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_or_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7517] = 3,
    STATE(150), 1,
      sym__sop,
    ACTIONS(578), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(576), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7575] = 3,
    STATE(150), 1,
      sym__sop,
    ACTIONS(574), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(558), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7633] = 11,
    ACTIONS(564), 1,
      sym_pow_tok,
    ACTIONS(566), 1,
      sym_and_tok,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(582), 1,
      sym_or_tok,
    STATE(50), 1,
      sym__relop,
    ACTIONS(560), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(562), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(584), 2,
      sym_integer,
      sym_terminal_string,
    ACTIONS(580), 38,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7707] = 6,
    ACTIONS(564), 1,
      sym_pow_tok,
    STATE(50), 1,
      sym__relop,
    ACTIONS(560), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(562), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(574), 2,
      sym_integer,
      sym_terminal_string,
    ACTIONS(558), 43,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7771] = 4,
    ACTIONS(546), 1,
      anon_sym_LPAREN,
    STATE(98), 1,
      sym_subscript,
    ACTIONS(588), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(586), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7831] = 4,
    ACTIONS(546), 1,
      anon_sym_LPAREN,
    STATE(97), 1,
      sym_subscript,
    ACTIONS(592), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(590), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7891] = 9,
    ACTIONS(564), 1,
      sym_pow_tok,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    STATE(50), 1,
      sym__relop,
    ACTIONS(560), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(562), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(574), 2,
      sym_integer,
      sym_terminal_string,
    ACTIONS(558), 40,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_and_tok,
      sym_or_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7961] = 3,
    STATE(50), 1,
      sym__relop,
    ACTIONS(596), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(594), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8019] = 3,
    STATE(50), 1,
      sym__relop,
    ACTIONS(574), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(558), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8077] = 4,
    ACTIONS(564), 1,
      sym_pow_tok,
    STATE(50), 1,
      sym__relop,
    ACTIONS(574), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(558), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8137] = 5,
    ACTIONS(564), 1,
      sym_pow_tok,
    STATE(50), 1,
      sym__relop,
    ACTIONS(562), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(574), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(558), 43,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8199] = 2,
    ACTIONS(600), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(598), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8254] = 2,
    ACTIONS(604), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(602), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8309] = 2,
    ACTIONS(608), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(606), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8364] = 2,
    ACTIONS(612), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(610), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8419] = 2,
    ACTIONS(616), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(614), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8474] = 2,
    ACTIONS(620), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(618), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8529] = 2,
    ACTIONS(624), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(622), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8584] = 2,
    ACTIONS(628), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(626), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8639] = 2,
    ACTIONS(632), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(630), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8694] = 2,
    ACTIONS(636), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(634), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8749] = 2,
    ACTIONS(640), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(638), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8804] = 2,
    ACTIONS(644), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(642), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8859] = 2,
    ACTIONS(648), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(646), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8914] = 2,
    ACTIONS(652), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(650), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8969] = 2,
    ACTIONS(656), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(654), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [9024] = 2,
    ACTIONS(660), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(658), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [9079] = 8,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_plus_tok,
    STATE(150), 1,
      sym__sop,
    STATE(157), 1,
      sym__relop,
    ACTIONS(584), 3,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(580), 38,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [9143] = 3,
    ACTIONS(668), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(666), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(664), 36,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [9192] = 2,
    ACTIONS(255), 4,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
      sym_terminal_string,
    ACTIONS(244), 36,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [9237] = 3,
    ACTIONS(674), 2,
      sym_gtr_tok,
      sym_eq_tok,
    ACTIONS(672), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(670), 33,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      sym_real,
      sym_string,
  [9282] = 3,
    ACTIONS(674), 2,
      sym_gtr_tok,
      sym_less_tok,
    ACTIONS(672), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(670), 33,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      sym_real,
      sym_string,
  [9327] = 3,
    ACTIONS(674), 2,
      sym_eq_tok,
      sym_less_tok,
    ACTIONS(672), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(670), 33,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      sym_real,
      sym_string,
  [9372] = 2,
    ACTIONS(678), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(676), 33,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      sym_real,
      sym_string,
  [9413] = 6,
    ACTIONS(544), 1,
      sym_terminal_string,
    ACTIONS(552), 1,
      anon_sym_DOLLAR,
    ACTIONS(680), 1,
      anon_sym_LPAREN,
    ACTIONS(682), 1,
      anon_sym_PERCENT,
    STATE(140), 1,
      sym_subscript,
    ACTIONS(542), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9453] = 4,
    ACTIONS(592), 1,
      sym_terminal_string,
    ACTIONS(680), 1,
      anon_sym_LPAREN,
    STATE(125), 1,
      sym_subscript,
    ACTIONS(590), 23,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9488] = 2,
    ACTIONS(556), 1,
      sym_terminal_string,
    ACTIONS(554), 25,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
  [9519] = 14,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(686), 1,
      sym_string,
    STATE(117), 1,
      sym__name,
    STATE(223), 1,
      sym_svar,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(243), 4,
      sym__var,
      sym__avar,
      sym_intvar,
      sym_realvar,
    STATE(278), 4,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
  [9574] = 3,
    ACTIONS(578), 1,
      sym_terminal_string,
    STATE(158), 1,
      sym__sop,
    ACTIONS(576), 23,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9606] = 4,
    ACTIONS(588), 1,
      sym_terminal_string,
    ACTIONS(680), 1,
      anon_sym_LPAREN,
    STATE(143), 1,
      sym_subscript,
    ACTIONS(586), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9640] = 2,
    ACTIONS(640), 1,
      sym_terminal_string,
    ACTIONS(638), 23,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9669] = 5,
    ACTIONS(574), 1,
      sym_terminal_string,
    ACTIONS(690), 1,
      sym_pow_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(558), 19,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9704] = 2,
    ACTIONS(612), 1,
      sym_terminal_string,
    ACTIONS(610), 23,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9733] = 2,
    ACTIONS(656), 1,
      sym_terminal_string,
    ACTIONS(654), 23,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9762] = 2,
    ACTIONS(600), 1,
      sym_terminal_string,
    ACTIONS(598), 23,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9791] = 2,
    ACTIONS(608), 1,
      sym_terminal_string,
    ACTIONS(606), 23,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9820] = 4,
    ACTIONS(574), 1,
      sym_terminal_string,
    ACTIONS(690), 1,
      sym_pow_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(558), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9853] = 3,
    ACTIONS(596), 1,
      sym_terminal_string,
    STATE(38), 1,
      sym__relop,
    ACTIONS(594), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9884] = 3,
    ACTIONS(574), 1,
      sym_terminal_string,
    STATE(38), 1,
      sym__relop,
    ACTIONS(558), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9915] = 2,
    ACTIONS(636), 1,
      sym_terminal_string,
    ACTIONS(634), 23,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9944] = 2,
    ACTIONS(648), 1,
      sym_terminal_string,
    ACTIONS(646), 23,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [9973] = 9,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(574), 1,
      sym_terminal_string,
    ACTIONS(690), 1,
      sym_pow_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(558), 14,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_and_tok,
      sym_or_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [10016] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(574), 1,
      sym_terminal_string,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(558), 13,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_or_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [10061] = 2,
    ACTIONS(604), 1,
      sym_terminal_string,
    ACTIONS(602), 23,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [10090] = 6,
    ACTIONS(574), 1,
      sym_terminal_string,
    ACTIONS(690), 1,
      sym_pow_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(558), 17,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [10127] = 2,
    ACTIONS(660), 1,
      sym_terminal_string,
    ACTIONS(658), 23,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [10156] = 3,
    ACTIONS(574), 1,
      sym_terminal_string,
    STATE(158), 1,
      sym__sop,
    ACTIONS(558), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [10187] = 2,
    ACTIONS(620), 1,
      sym_terminal_string,
    ACTIONS(618), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [10215] = 2,
    ACTIONS(632), 1,
      sym_terminal_string,
    ACTIONS(630), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [10243] = 2,
    ACTIONS(624), 1,
      sym_terminal_string,
    ACTIONS(622), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [10271] = 2,
    ACTIONS(616), 1,
      sym_terminal_string,
    ACTIONS(614), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [10299] = 2,
    ACTIONS(628), 1,
      sym_terminal_string,
    ACTIONS(626), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [10327] = 2,
    ACTIONS(644), 1,
      sym_terminal_string,
    ACTIONS(642), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [10355] = 2,
    ACTIONS(652), 1,
      sym_terminal_string,
    ACTIONS(650), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_string,
  [10383] = 10,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      sym_string,
    STATE(352), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(139), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10422] = 10,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      sym_string,
    STATE(352), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(271), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10461] = 10,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      sym_string,
    STATE(352), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(298), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10500] = 10,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(192), 1,
      sym_mid_tok,
    ACTIONS(702), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      sym_string,
    STATE(335), 1,
      sym__name,
    ACTIONS(172), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(188), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(190), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(96), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(83), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10539] = 10,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(706), 1,
      sym_string,
    STATE(352), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(295), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10578] = 10,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(708), 1,
      sym_string,
    STATE(352), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(244), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10617] = 10,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(710), 1,
      sym_string,
    STATE(352), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(242), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10656] = 10,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(712), 1,
      sym_string,
    STATE(352), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(277), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10695] = 10,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(714), 1,
      sym_string,
    STATE(352), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(293), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10734] = 10,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(716), 1,
      sym_string,
    STATE(352), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(291), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10773] = 10,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(192), 1,
      sym_mid_tok,
    ACTIONS(702), 1,
      anon_sym_LPAREN,
    ACTIONS(718), 1,
      sym_string,
    STATE(335), 1,
      sym__name,
    ACTIONS(172), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(188), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(190), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(96), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(84), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10812] = 10,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(720), 1,
      sym_string,
    STATE(352), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(121), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10851] = 10,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(722), 1,
      sym_string,
    STATE(352), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(296), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10890] = 10,
    ACTIONS(65), 1,
      sym__ext_name,
    ACTIONS(284), 1,
      sym_mid_tok,
    ACTIONS(684), 1,
      anon_sym_LPAREN,
    ACTIONS(724), 1,
      sym_string,
    STATE(352), 1,
      sym__name,
    ACTIONS(264), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(280), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(282), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(297), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10929] = 12,
    ACTIONS(204), 1,
      sym_terminal_string,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(728), 1,
      sym_string,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(196), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [10970] = 12,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(730), 1,
      sym_to_tok,
    STATE(38), 1,
      sym__relop,
    STATE(246), 1,
      aux_sym_statement_repeat4,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(732), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [11011] = 12,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(730), 1,
      sym_to_tok,
    STATE(38), 1,
      sym__relop,
    STATE(233), 1,
      aux_sym_statement_repeat4,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(734), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [11052] = 11,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(736), 1,
      sym_step_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(738), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [11090] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(740), 4,
      sym_to_tok,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [11126] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(580), 4,
      sym_goto_tok,
      sym_then_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [11162] = 11,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(742), 1,
      sym_at_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(196), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [11200] = 11,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(728), 1,
      sym_string,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(196), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [11238] = 11,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(744), 1,
      anon_sym_COMMA,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(734), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [11276] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(746), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [11311] = 12,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(748), 1,
      anon_sym_COMMA,
    ACTIONS(750), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    STATE(287), 1,
      aux_sym_subscript_repeat1,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [11350] = 12,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(748), 1,
      anon_sym_COMMA,
    ACTIONS(752), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    STATE(273), 1,
      aux_sym_subscript_repeat1,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [11389] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(754), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [11424] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(196), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [11459] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(756), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [11494] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(734), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [11529] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(738), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [11564] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(758), 2,
      sym_goto_tok,
      sym_gosub_tok,
  [11598] = 11,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [11634] = 6,
    ACTIONS(65), 1,
      sym__ext_name,
    STATE(117), 1,
      sym__name,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(243), 5,
      sym__var,
      sym__avar,
      sym_intvar,
      sym_realvar,
      sym_svar,
  [11660] = 6,
    ACTIONS(65), 1,
      sym__ext_name,
    STATE(117), 1,
      sym__name,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(256), 5,
      sym__var,
      sym__avar,
      sym_intvar,
      sym_realvar,
      sym_svar,
  [11686] = 6,
    ACTIONS(65), 1,
      sym__ext_name,
    STATE(117), 1,
      sym__name,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(241), 5,
      sym__var,
      sym__avar,
      sym_intvar,
      sym_realvar,
      sym_svar,
  [11712] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(764), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [11746] = 11,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(766), 1,
      anon_sym_COMMA,
    ACTIONS(768), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [11782] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(770), 1,
      sym_to_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [11815] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(772), 1,
      anon_sym_COMMA,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [11848] = 6,
    ACTIONS(65), 1,
      sym__ext_name,
    STATE(222), 1,
      sym__name,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(260), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
    STATE(236), 3,
      sym__avar,
      sym_intvar,
      sym_realvar,
  [11873] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(774), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [11906] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(776), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [11939] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(762), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [11972] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(778), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12005] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(780), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12038] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(782), 1,
      anon_sym_COMMA,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12071] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(784), 1,
      anon_sym_COMMA,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12104] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(786), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12137] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(788), 1,
      anon_sym_COMMA,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12170] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(790), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12203] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(792), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12236] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(744), 1,
      anon_sym_COMMA,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12269] = 7,
    ACTIONS(65), 1,
      sym__ext_name,
    STATE(117), 1,
      sym__name,
    STATE(347), 1,
      sym_svar,
    STATE(128), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(340), 3,
      sym__avar,
      sym_intvar,
      sym_realvar,
  [12296] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(794), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12329] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(796), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12362] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(744), 1,
      sym_at_tok,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12395] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(798), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12428] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(800), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12461] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(802), 1,
      anon_sym_COMMA,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12494] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(804), 1,
      anon_sym_COMMA,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12527] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(806), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12560] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(768), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12593] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(808), 1,
      anon_sym_COMMA,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12626] = 10,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(690), 1,
      sym_pow_tok,
    ACTIONS(694), 1,
      sym_and_tok,
    ACTIONS(726), 1,
      sym_or_tok,
    ACTIONS(810), 1,
      anon_sym_COMMA,
    STATE(38), 1,
      sym__relop,
    ACTIONS(688), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(692), 2,
      sym_plus_tok,
      sym_minus_tok,
  [12659] = 7,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(812), 1,
      sym_plus_tok,
    STATE(147), 1,
      sym__relop,
    STATE(158), 1,
      sym__sop,
    ACTIONS(580), 4,
      sym_goto_tok,
      sym_then_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [12684] = 5,
    ACTIONS(65), 1,
      sym__ext_name,
    STATE(222), 1,
      sym__name,
    STATE(141), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(142), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(261), 3,
      sym__avar,
      sym_intvar,
      sym_realvar,
  [12704] = 4,
    ACTIONS(817), 1,
      sym_terminal_string,
    STATE(214), 1,
      aux_sym_statement_repeat1,
    STATE(350), 1,
      sym__data_item,
    ACTIONS(814), 5,
      sym_integer,
      sym_literal,
      sym_real,
      sym_string,
      sym_real_data_item,
  [12721] = 4,
    ACTIONS(204), 1,
      sym_terminal_string,
    STATE(214), 1,
      aux_sym_statement_repeat1,
    STATE(270), 1,
      sym__data_item,
    ACTIONS(819), 5,
      sym_integer,
      sym_literal,
      sym_real,
      sym_string,
      sym_real_data_item,
  [12738] = 4,
    ACTIONS(262), 1,
      sym_terminal_string,
    STATE(215), 1,
      aux_sym_statement_repeat1,
    STATE(258), 1,
      sym__data_item,
    ACTIONS(821), 5,
      sym_integer,
      sym_literal,
      sym_real,
      sym_string,
      sym_real_data_item,
  [12755] = 7,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(812), 1,
      sym_plus_tok,
    ACTIONS(823), 1,
      anon_sym_RPAREN,
    STATE(147), 1,
      sym__relop,
    STATE(158), 1,
      sym__sop,
  [12777] = 7,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(812), 1,
      sym_plus_tok,
    ACTIONS(825), 1,
      anon_sym_RPAREN,
    STATE(147), 1,
      sym__relop,
    STATE(158), 1,
      sym__sop,
  [12799] = 3,
    STATE(221), 1,
      aux_sym_statement_repeat1,
    STATE(268), 1,
      sym__data_item,
    ACTIONS(827), 5,
      sym_integer,
      sym_literal,
      sym_real,
      sym_string,
      sym_real_data_item,
  [12813] = 3,
    STATE(219), 1,
      aux_sym_statement_repeat1,
    STATE(259), 1,
      sym__data_item,
    ACTIONS(829), 5,
      sym_integer,
      sym_literal,
      sym_real,
      sym_string,
      sym_real_data_item,
  [12827] = 3,
    STATE(221), 1,
      aux_sym_statement_repeat1,
    STATE(320), 1,
      sym__data_item,
    ACTIONS(831), 5,
      sym_integer,
      sym_literal,
      sym_real,
      sym_string,
      sym_real_data_item,
  [12841] = 4,
    ACTIONS(680), 1,
      anon_sym_LPAREN,
    ACTIONS(682), 1,
      anon_sym_PERCENT,
    STATE(140), 1,
      sym_subscript,
    ACTIONS(542), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12857] = 2,
    ACTIONS(834), 2,
      sym_plus_tok,
      anon_sym_SEMI,
    ACTIONS(836), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12868] = 3,
    ACTIONS(840), 1,
      sym_linenum,
    ACTIONS(838), 2,
      sym_minus_tok,
      anon_sym_COMMA,
    ACTIONS(260), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12881] = 6,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(812), 1,
      sym_plus_tok,
    STATE(157), 1,
      sym__relop,
    STATE(158), 1,
      sym__sop,
  [12900] = 1,
    ACTIONS(817), 6,
      sym_integer,
      sym_literal,
      sym_real,
      sym_string,
      sym_terminal_string,
      sym_real_data_item,
  [12909] = 6,
    ACTIONS(568), 1,
      sym_gtr_tok,
    ACTIONS(570), 1,
      sym_eq_tok,
    ACTIONS(572), 1,
      sym_less_tok,
    ACTIONS(812), 1,
      sym_plus_tok,
    STATE(147), 1,
      sym__relop,
    STATE(158), 1,
      sym__sop,
  [12928] = 3,
    ACTIONS(65), 1,
      sym__ext_name,
    STATE(265), 1,
      sym__name,
    STATE(254), 4,
      sym__dim_item,
      sym_real_array,
      sym_int_array,
      sym_string_array,
  [12941] = 3,
    ACTIONS(65), 1,
      sym__ext_name,
    STATE(265), 1,
      sym__name,
    STATE(239), 4,
      sym__dim_item,
      sym_real_array,
      sym_int_array,
      sym_string_array,
  [12954] = 3,
    ACTIONS(842), 1,
      anon_sym_COMMA,
    STATE(230), 1,
      aux_sym_statement_repeat6,
    ACTIONS(845), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12966] = 3,
    ACTIONS(847), 1,
      anon_sym_COMMA,
    STATE(252), 1,
      aux_sym_statement_repeat3,
    ACTIONS(732), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12978] = 2,
    ACTIONS(849), 2,
      sym_minus_tok,
      anon_sym_COMMA,
    ACTIONS(196), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12988] = 3,
    ACTIONS(730), 1,
      sym_to_tok,
    STATE(248), 1,
      aux_sym_statement_repeat4,
    ACTIONS(732), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13000] = 3,
    ACTIONS(847), 1,
      anon_sym_COMMA,
    STATE(252), 1,
      aux_sym_statement_repeat3,
    ACTIONS(851), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13012] = 1,
    ACTIONS(817), 5,
      sym_integer,
      sym_literal,
      sym_real,
      sym_string,
      sym_real_data_item,
  [13020] = 3,
    ACTIONS(853), 1,
      anon_sym_COMMA,
    STATE(249), 1,
      aux_sym_statement_repeat5,
    ACTIONS(196), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13032] = 4,
    ACTIONS(855), 1,
      ts_builtin_sym_end,
    ACTIONS(857), 1,
      sym__empty_line,
    ACTIONS(860), 1,
      sym_linenum,
    STATE(237), 2,
      sym_line,
      aux_sym_source_file_repeat1,
  [13046] = 3,
    ACTIONS(863), 1,
      anon_sym_COMMA,
    STATE(230), 1,
      aux_sym_statement_repeat6,
    ACTIONS(732), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13058] = 3,
    ACTIONS(865), 1,
      anon_sym_COMMA,
    STATE(251), 1,
      aux_sym_statement_repeat2,
    ACTIONS(196), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13070] = 3,
    ACTIONS(863), 1,
      anon_sym_COMMA,
    STATE(238), 1,
      aux_sym_statement_repeat6,
    ACTIONS(734), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13082] = 3,
    ACTIONS(847), 1,
      anon_sym_COMMA,
    STATE(231), 1,
      aux_sym_statement_repeat3,
    ACTIONS(734), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13094] = 3,
    ACTIONS(812), 1,
      sym_plus_tok,
    STATE(158), 1,
      sym__sop,
    ACTIONS(756), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13106] = 3,
    ACTIONS(847), 1,
      anon_sym_COMMA,
    STATE(234), 1,
      aux_sym_statement_repeat3,
    ACTIONS(196), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13118] = 3,
    ACTIONS(812), 1,
      sym_plus_tok,
    STATE(158), 1,
      sym__sop,
    ACTIONS(746), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13130] = 4,
    ACTIONS(7), 1,
      sym_linenum,
    ACTIONS(867), 1,
      ts_builtin_sym_end,
    ACTIONS(869), 1,
      sym__empty_line,
    STATE(237), 2,
      sym_line,
      aux_sym_source_file_repeat1,
  [13144] = 3,
    ACTIONS(730), 1,
      sym_to_tok,
    STATE(248), 1,
      aux_sym_statement_repeat4,
    ACTIONS(738), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13156] = 3,
    ACTIONS(871), 1,
      anon_sym_COMMA,
    STATE(247), 1,
      aux_sym_statement_repeat5,
    ACTIONS(874), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13168] = 3,
    ACTIONS(876), 1,
      sym_to_tok,
    STATE(248), 1,
      aux_sym_statement_repeat4,
    ACTIONS(879), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13180] = 3,
    ACTIONS(853), 1,
      anon_sym_COMMA,
    STATE(247), 1,
      aux_sym_statement_repeat5,
    ACTIONS(851), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13192] = 3,
    ACTIONS(881), 1,
      anon_sym_COMMA,
    STATE(250), 1,
      aux_sym_statement_repeat2,
    ACTIONS(884), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13204] = 3,
    ACTIONS(865), 1,
      anon_sym_COMMA,
    STATE(250), 1,
      aux_sym_statement_repeat2,
    ACTIONS(851), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13216] = 3,
    ACTIONS(886), 1,
      anon_sym_COMMA,
    STATE(252), 1,
      aux_sym_statement_repeat3,
    ACTIONS(889), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13228] = 1,
    ACTIONS(891), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13235] = 1,
    ACTIONS(884), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13242] = 3,
    ACTIONS(65), 1,
      sym__ext_name,
    STATE(267), 1,
      sym__name,
    STATE(284), 2,
      sym_real_scalar,
      sym_int_scalar,
  [13253] = 1,
    ACTIONS(889), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13260] = 2,
    ACTIONS(893), 1,
      sym_linenum,
    ACTIONS(260), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13269] = 2,
    ACTIONS(895), 1,
      anon_sym_COMMA,
    ACTIONS(196), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13278] = 2,
    ACTIONS(897), 1,
      anon_sym_COMMA,
    ACTIONS(196), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13287] = 1,
    ACTIONS(845), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13294] = 1,
    ACTIONS(874), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13301] = 1,
    ACTIONS(899), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13308] = 1,
    ACTIONS(901), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13315] = 2,
    ACTIONS(162), 1,
      sym_linenum,
    ACTIONS(851), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13324] = 4,
    ACTIONS(680), 1,
      anon_sym_LPAREN,
    ACTIONS(903), 1,
      anon_sym_PERCENT,
    ACTIONS(905), 1,
      anon_sym_DOLLAR,
    STATE(253), 1,
      sym_subscript,
  [13337] = 2,
    ACTIONS(907), 1,
      sym_comment_text,
    ACTIONS(909), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13346] = 2,
    ACTIONS(913), 1,
      anon_sym_PERCENT,
    ACTIONS(911), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13355] = 2,
    ACTIONS(897), 1,
      anon_sym_COMMA,
    ACTIONS(851), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13364] = 2,
    ACTIONS(728), 1,
      sym_linenum,
    ACTIONS(196), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13373] = 2,
    ACTIONS(895), 1,
      anon_sym_COMMA,
    ACTIONS(851), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13382] = 3,
    ACTIONS(812), 1,
      sym_plus_tok,
    ACTIONS(915), 1,
      anon_sym_COMMA,
    STATE(158), 1,
      sym__sop,
  [13392] = 1,
    ACTIONS(851), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13398] = 3,
    ACTIONS(748), 1,
      anon_sym_COMMA,
    ACTIONS(917), 1,
      anon_sym_RPAREN,
    STATE(280), 1,
      aux_sym_subscript_repeat1,
  [13408] = 3,
    ACTIONS(65), 1,
      sym__ext_name,
    STATE(314), 1,
      sym__name,
    STATE(321), 1,
      sym_fn_name,
  [13418] = 2,
    ACTIONS(919), 1,
      anon_sym_COLON,
    ACTIONS(921), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13426] = 1,
    ACTIONS(923), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13432] = 3,
    ACTIONS(812), 1,
      sym_plus_tok,
    ACTIONS(823), 1,
      anon_sym_RPAREN,
    STATE(158), 1,
      sym__sop,
  [13442] = 3,
    ACTIONS(812), 1,
      sym_plus_tok,
    ACTIONS(925), 1,
      anon_sym_SEMI,
    STATE(158), 1,
      sym__sop,
  [13452] = 1,
    ACTIONS(927), 3,
      ts_builtin_sym_end,
      sym__empty_line,
      sym_linenum,
  [13458] = 3,
    ACTIONS(764), 1,
      anon_sym_RPAREN,
    ACTIONS(929), 1,
      anon_sym_COMMA,
    STATE(280), 1,
      aux_sym_subscript_repeat1,
  [13468] = 3,
    ACTIONS(162), 1,
      anon_sym_RPAREN,
    ACTIONS(932), 1,
      anon_sym_COMMA,
    STATE(290), 1,
      aux_sym_statement_repeat8,
  [13478] = 3,
    ACTIONS(934), 1,
      anon_sym_COMMA,
    ACTIONS(937), 1,
      anon_sym_RPAREN,
    STATE(282), 1,
      aux_sym_statement_repeat8,
  [13488] = 1,
    ACTIONS(732), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13494] = 1,
    ACTIONS(196), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13500] = 3,
    ACTIONS(65), 1,
      sym__ext_name,
    STATE(307), 1,
      sym__name,
    STATE(337), 1,
      sym_real_scalar,
  [13510] = 1,
    ACTIONS(260), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13516] = 3,
    ACTIONS(748), 1,
      anon_sym_COMMA,
    ACTIONS(939), 1,
      anon_sym_RPAREN,
    STATE(280), 1,
      aux_sym_subscript_repeat1,
  [13526] = 3,
    ACTIONS(65), 1,
      sym__ext_name,
    STATE(307), 1,
      sym__name,
    STATE(333), 1,
      sym_real_scalar,
  [13536] = 2,
    ACTIONS(919), 1,
      anon_sym_COLON,
    ACTIONS(941), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13544] = 3,
    ACTIONS(932), 1,
      anon_sym_COMMA,
    ACTIONS(943), 1,
      anon_sym_RPAREN,
    STATE(282), 1,
      aux_sym_statement_repeat8,
  [13554] = 3,
    ACTIONS(798), 1,
      anon_sym_RPAREN,
    ACTIONS(812), 1,
      sym_plus_tok,
    STATE(158), 1,
      sym__sop,
  [13564] = 3,
    ACTIONS(262), 1,
      sym_terminal_string,
    ACTIONS(893), 1,
      sym_string,
    ACTIONS(945), 1,
      anon_sym_LPAREN,
  [13574] = 3,
    ACTIONS(774), 1,
      anon_sym_RPAREN,
    ACTIONS(812), 1,
      sym_plus_tok,
    STATE(158), 1,
      sym__sop,
  [13584] = 1,
    ACTIONS(734), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13590] = 3,
    ACTIONS(812), 1,
      sym_plus_tok,
    ACTIONS(947), 1,
      anon_sym_COMMA,
    STATE(158), 1,
      sym__sop,
  [13600] = 3,
    ACTIONS(812), 1,
      sym_plus_tok,
    ACTIONS(949), 1,
      anon_sym_COMMA,
    STATE(158), 1,
      sym__sop,
  [13610] = 3,
    ACTIONS(812), 1,
      sym_plus_tok,
    ACTIONS(825), 1,
      anon_sym_RPAREN,
    STATE(158), 1,
      sym__sop,
  [13620] = 3,
    ACTIONS(812), 1,
      sym_plus_tok,
    ACTIONS(951), 1,
      anon_sym_COMMA,
    STATE(158), 1,
      sym__sop,
  [13630] = 3,
    ACTIONS(65), 1,
      sym__ext_name,
    STATE(314), 1,
      sym__name,
    STATE(346), 1,
      sym_fn_name,
  [13640] = 3,
    ACTIONS(65), 1,
      sym__ext_name,
    STATE(314), 1,
      sym__name,
    STATE(325), 1,
      sym_fn_name,
  [13650] = 1,
    ACTIONS(953), 3,
      ts_builtin_sym_end,
      sym__empty_line,
      sym_linenum,
  [13656] = 2,
    ACTIONS(955), 1,
      sym_goto_tok,
    ACTIONS(957), 1,
      sym_then_tok,
  [13663] = 1,
    ACTIONS(941), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13668] = 2,
    ACTIONS(893), 1,
      sym_string,
    ACTIONS(945), 1,
      anon_sym_LPAREN,
  [13675] = 2,
    ACTIONS(955), 1,
      sym_goto_tok,
    ACTIONS(959), 1,
      sym_then_tok,
  [13682] = 1,
    ACTIONS(937), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [13687] = 1,
    ACTIONS(911), 2,
      sym_eq_tok,
      anon_sym_RPAREN,
  [13692] = 1,
    ACTIONS(921), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13697] = 2,
    ACTIONS(907), 1,
      sym_comment_text,
    ACTIONS(909), 1,
      anon_sym_COLON,
  [13704] = 1,
    ACTIONS(961), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13709] = 2,
    ACTIONS(680), 1,
      anon_sym_LPAREN,
    STATE(262), 1,
      sym_subscript,
  [13716] = 1,
    ACTIONS(963), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [13721] = 2,
    ACTIONS(680), 1,
      anon_sym_LPAREN,
    STATE(263), 1,
      sym_subscript,
  [13728] = 1,
    ACTIONS(965), 1,
      anon_sym_LPAREN,
  [13732] = 1,
    ACTIONS(162), 1,
      sym_linenum,
  [13736] = 1,
    ACTIONS(893), 1,
      sym_linenum,
  [13740] = 1,
    ACTIONS(955), 1,
      anon_sym_COMMA,
  [13744] = 1,
    ACTIONS(967), 1,
      sym_linenum,
  [13748] = 1,
    ACTIONS(969), 1,
      anon_sym_LPAREN,
  [13752] = 1,
    ACTIONS(897), 1,
      anon_sym_COMMA,
  [13756] = 1,
    ACTIONS(782), 1,
      anon_sym_LPAREN,
  [13760] = 1,
    ACTIONS(971), 1,
      sym_eq_tok,
  [13764] = 1,
    ACTIONS(973), 1,
      sym_eq_tok,
  [13768] = 1,
    ACTIONS(774), 1,
      anon_sym_RPAREN,
  [13772] = 1,
    ACTIONS(975), 1,
      anon_sym_LPAREN,
  [13776] = 1,
    ACTIONS(977), 1,
      anon_sym_LPAREN,
  [13780] = 1,
    ACTIONS(979), 1,
      anon_sym_LPAREN,
  [13784] = 1,
    ACTIONS(981), 1,
      anon_sym_LPAREN,
  [13788] = 1,
    ACTIONS(983), 1,
      anon_sym_LPAREN,
  [13792] = 1,
    ACTIONS(985), 1,
      sym__ext_name,
  [13796] = 1,
    ACTIONS(987), 1,
      sym_goto_tok,
  [13800] = 1,
    ACTIONS(736), 1,
      sym_eq_tok,
  [13804] = 1,
    ACTIONS(989), 1,
      anon_sym_RPAREN,
  [13808] = 1,
    ACTIONS(991), 1,
      sym_linenum,
  [13812] = 1,
    ACTIONS(550), 1,
      anon_sym_DOLLAR,
  [13816] = 1,
    ACTIONS(993), 1,
      sym_linenum,
  [13820] = 1,
    ACTIONS(995), 1,
      sym_eq_tok,
  [13824] = 1,
    ACTIONS(728), 1,
      sym_linenum,
  [13828] = 1,
    ACTIONS(997), 1,
      ts_builtin_sym_end,
  [13832] = 1,
    ACTIONS(999), 1,
      sym_eq_tok,
  [13836] = 1,
    ACTIONS(1001), 1,
      sym__ext_name,
  [13840] = 1,
    ACTIONS(1003), 1,
      anon_sym_LPAREN,
  [13844] = 1,
    ACTIONS(1005), 1,
      anon_sym_LPAREN,
  [13848] = 1,
    ACTIONS(1007), 1,
      anon_sym_LPAREN,
  [13852] = 1,
    ACTIONS(1009), 1,
      anon_sym_LPAREN,
  [13856] = 1,
    ACTIONS(784), 1,
      anon_sym_LPAREN,
  [13860] = 1,
    ACTIONS(1011), 1,
      sym_eq_tok,
  [13864] = 1,
    ACTIONS(1013), 1,
      anon_sym_LPAREN,
  [13868] = 1,
    ACTIONS(798), 1,
      anon_sym_RPAREN,
  [13872] = 1,
    ACTIONS(895), 1,
      anon_sym_COMMA,
  [13876] = 1,
    ACTIONS(919), 1,
      anon_sym_COLON,
  [13880] = 1,
    ACTIONS(552), 1,
      anon_sym_DOLLAR,
  [13884] = 1,
    ACTIONS(1015), 1,
      sym_fn_tok,
  [13888] = 1,
    ACTIONS(1017), 1,
      anon_sym_LPAREN,
  [13892] = 1,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(8)] = 0,
  [SMALL_STATE(9)] = 115,
  [SMALL_STATE(10)] = 230,
  [SMALL_STATE(11)] = 345,
  [SMALL_STATE(12)] = 457,
  [SMALL_STATE(13)] = 569,
  [SMALL_STATE(14)] = 673,
  [SMALL_STATE(15)] = 777,
  [SMALL_STATE(16)] = 881,
  [SMALL_STATE(17)] = 985,
  [SMALL_STATE(18)] = 1089,
  [SMALL_STATE(19)] = 1193,
  [SMALL_STATE(20)] = 1297,
  [SMALL_STATE(21)] = 1398,
  [SMALL_STATE(22)] = 1499,
  [SMALL_STATE(23)] = 1600,
  [SMALL_STATE(24)] = 1701,
  [SMALL_STATE(25)] = 1802,
  [SMALL_STATE(26)] = 1903,
  [SMALL_STATE(27)] = 2004,
  [SMALL_STATE(28)] = 2105,
  [SMALL_STATE(29)] = 2206,
  [SMALL_STATE(30)] = 2307,
  [SMALL_STATE(31)] = 2408,
  [SMALL_STATE(32)] = 2509,
  [SMALL_STATE(33)] = 2610,
  [SMALL_STATE(34)] = 2711,
  [SMALL_STATE(35)] = 2812,
  [SMALL_STATE(36)] = 2913,
  [SMALL_STATE(37)] = 3014,
  [SMALL_STATE(38)] = 3115,
  [SMALL_STATE(39)] = 3216,
  [SMALL_STATE(40)] = 3317,
  [SMALL_STATE(41)] = 3418,
  [SMALL_STATE(42)] = 3519,
  [SMALL_STATE(43)] = 3620,
  [SMALL_STATE(44)] = 3721,
  [SMALL_STATE(45)] = 3822,
  [SMALL_STATE(46)] = 3923,
  [SMALL_STATE(47)] = 4024,
  [SMALL_STATE(48)] = 4125,
  [SMALL_STATE(49)] = 4226,
  [SMALL_STATE(50)] = 4327,
  [SMALL_STATE(51)] = 4428,
  [SMALL_STATE(52)] = 4529,
  [SMALL_STATE(53)] = 4630,
  [SMALL_STATE(54)] = 4731,
  [SMALL_STATE(55)] = 4832,
  [SMALL_STATE(56)] = 4933,
  [SMALL_STATE(57)] = 5034,
  [SMALL_STATE(58)] = 5135,
  [SMALL_STATE(59)] = 5236,
  [SMALL_STATE(60)] = 5337,
  [SMALL_STATE(61)] = 5438,
  [SMALL_STATE(62)] = 5539,
  [SMALL_STATE(63)] = 5640,
  [SMALL_STATE(64)] = 5741,
  [SMALL_STATE(65)] = 5842,
  [SMALL_STATE(66)] = 5943,
  [SMALL_STATE(67)] = 6044,
  [SMALL_STATE(68)] = 6145,
  [SMALL_STATE(69)] = 6246,
  [SMALL_STATE(70)] = 6347,
  [SMALL_STATE(71)] = 6448,
  [SMALL_STATE(72)] = 6549,
  [SMALL_STATE(73)] = 6650,
  [SMALL_STATE(74)] = 6751,
  [SMALL_STATE(75)] = 6852,
  [SMALL_STATE(76)] = 6953,
  [SMALL_STATE(77)] = 7054,
  [SMALL_STATE(78)] = 7155,
  [SMALL_STATE(79)] = 7256,
  [SMALL_STATE(80)] = 7322,
  [SMALL_STATE(81)] = 7388,
  [SMALL_STATE(82)] = 7445,
  [SMALL_STATE(83)] = 7517,
  [SMALL_STATE(84)] = 7575,
  [SMALL_STATE(85)] = 7633,
  [SMALL_STATE(86)] = 7707,
  [SMALL_STATE(87)] = 7771,
  [SMALL_STATE(88)] = 7831,
  [SMALL_STATE(89)] = 7891,
  [SMALL_STATE(90)] = 7961,
  [SMALL_STATE(91)] = 8019,
  [SMALL_STATE(92)] = 8077,
  [SMALL_STATE(93)] = 8137,
  [SMALL_STATE(94)] = 8199,
  [SMALL_STATE(95)] = 8254,
  [SMALL_STATE(96)] = 8309,
  [SMALL_STATE(97)] = 8364,
  [SMALL_STATE(98)] = 8419,
  [SMALL_STATE(99)] = 8474,
  [SMALL_STATE(100)] = 8529,
  [SMALL_STATE(101)] = 8584,
  [SMALL_STATE(102)] = 8639,
  [SMALL_STATE(103)] = 8694,
  [SMALL_STATE(104)] = 8749,
  [SMALL_STATE(105)] = 8804,
  [SMALL_STATE(106)] = 8859,
  [SMALL_STATE(107)] = 8914,
  [SMALL_STATE(108)] = 8969,
  [SMALL_STATE(109)] = 9024,
  [SMALL_STATE(110)] = 9079,
  [SMALL_STATE(111)] = 9143,
  [SMALL_STATE(112)] = 9192,
  [SMALL_STATE(113)] = 9237,
  [SMALL_STATE(114)] = 9282,
  [SMALL_STATE(115)] = 9327,
  [SMALL_STATE(116)] = 9372,
  [SMALL_STATE(117)] = 9413,
  [SMALL_STATE(118)] = 9453,
  [SMALL_STATE(119)] = 9488,
  [SMALL_STATE(120)] = 9519,
  [SMALL_STATE(121)] = 9574,
  [SMALL_STATE(122)] = 9606,
  [SMALL_STATE(123)] = 9640,
  [SMALL_STATE(124)] = 9669,
  [SMALL_STATE(125)] = 9704,
  [SMALL_STATE(126)] = 9733,
  [SMALL_STATE(127)] = 9762,
  [SMALL_STATE(128)] = 9791,
  [SMALL_STATE(129)] = 9820,
  [SMALL_STATE(130)] = 9853,
  [SMALL_STATE(131)] = 9884,
  [SMALL_STATE(132)] = 9915,
  [SMALL_STATE(133)] = 9944,
  [SMALL_STATE(134)] = 9973,
  [SMALL_STATE(135)] = 10016,
  [SMALL_STATE(136)] = 10061,
  [SMALL_STATE(137)] = 10090,
  [SMALL_STATE(138)] = 10127,
  [SMALL_STATE(139)] = 10156,
  [SMALL_STATE(140)] = 10187,
  [SMALL_STATE(141)] = 10215,
  [SMALL_STATE(142)] = 10243,
  [SMALL_STATE(143)] = 10271,
  [SMALL_STATE(144)] = 10299,
  [SMALL_STATE(145)] = 10327,
  [SMALL_STATE(146)] = 10355,
  [SMALL_STATE(147)] = 10383,
  [SMALL_STATE(148)] = 10422,
  [SMALL_STATE(149)] = 10461,
  [SMALL_STATE(150)] = 10500,
  [SMALL_STATE(151)] = 10539,
  [SMALL_STATE(152)] = 10578,
  [SMALL_STATE(153)] = 10617,
  [SMALL_STATE(154)] = 10656,
  [SMALL_STATE(155)] = 10695,
  [SMALL_STATE(156)] = 10734,
  [SMALL_STATE(157)] = 10773,
  [SMALL_STATE(158)] = 10812,
  [SMALL_STATE(159)] = 10851,
  [SMALL_STATE(160)] = 10890,
  [SMALL_STATE(161)] = 10929,
  [SMALL_STATE(162)] = 10970,
  [SMALL_STATE(163)] = 11011,
  [SMALL_STATE(164)] = 11052,
  [SMALL_STATE(165)] = 11090,
  [SMALL_STATE(166)] = 11126,
  [SMALL_STATE(167)] = 11162,
  [SMALL_STATE(168)] = 11200,
  [SMALL_STATE(169)] = 11238,
  [SMALL_STATE(170)] = 11276,
  [SMALL_STATE(171)] = 11311,
  [SMALL_STATE(172)] = 11350,
  [SMALL_STATE(173)] = 11389,
  [SMALL_STATE(174)] = 11424,
  [SMALL_STATE(175)] = 11459,
  [SMALL_STATE(176)] = 11494,
  [SMALL_STATE(177)] = 11529,
  [SMALL_STATE(178)] = 11564,
  [SMALL_STATE(179)] = 11598,
  [SMALL_STATE(180)] = 11634,
  [SMALL_STATE(181)] = 11660,
  [SMALL_STATE(182)] = 11686,
  [SMALL_STATE(183)] = 11712,
  [SMALL_STATE(184)] = 11746,
  [SMALL_STATE(185)] = 11782,
  [SMALL_STATE(186)] = 11815,
  [SMALL_STATE(187)] = 11848,
  [SMALL_STATE(188)] = 11873,
  [SMALL_STATE(189)] = 11906,
  [SMALL_STATE(190)] = 11939,
  [SMALL_STATE(191)] = 11972,
  [SMALL_STATE(192)] = 12005,
  [SMALL_STATE(193)] = 12038,
  [SMALL_STATE(194)] = 12071,
  [SMALL_STATE(195)] = 12104,
  [SMALL_STATE(196)] = 12137,
  [SMALL_STATE(197)] = 12170,
  [SMALL_STATE(198)] = 12203,
  [SMALL_STATE(199)] = 12236,
  [SMALL_STATE(200)] = 12269,
  [SMALL_STATE(201)] = 12296,
  [SMALL_STATE(202)] = 12329,
  [SMALL_STATE(203)] = 12362,
  [SMALL_STATE(204)] = 12395,
  [SMALL_STATE(205)] = 12428,
  [SMALL_STATE(206)] = 12461,
  [SMALL_STATE(207)] = 12494,
  [SMALL_STATE(208)] = 12527,
  [SMALL_STATE(209)] = 12560,
  [SMALL_STATE(210)] = 12593,
  [SMALL_STATE(211)] = 12626,
  [SMALL_STATE(212)] = 12659,
  [SMALL_STATE(213)] = 12684,
  [SMALL_STATE(214)] = 12704,
  [SMALL_STATE(215)] = 12721,
  [SMALL_STATE(216)] = 12738,
  [SMALL_STATE(217)] = 12755,
  [SMALL_STATE(218)] = 12777,
  [SMALL_STATE(219)] = 12799,
  [SMALL_STATE(220)] = 12813,
  [SMALL_STATE(221)] = 12827,
  [SMALL_STATE(222)] = 12841,
  [SMALL_STATE(223)] = 12857,
  [SMALL_STATE(224)] = 12868,
  [SMALL_STATE(225)] = 12881,
  [SMALL_STATE(226)] = 12900,
  [SMALL_STATE(227)] = 12909,
  [SMALL_STATE(228)] = 12928,
  [SMALL_STATE(229)] = 12941,
  [SMALL_STATE(230)] = 12954,
  [SMALL_STATE(231)] = 12966,
  [SMALL_STATE(232)] = 12978,
  [SMALL_STATE(233)] = 12988,
  [SMALL_STATE(234)] = 13000,
  [SMALL_STATE(235)] = 13012,
  [SMALL_STATE(236)] = 13020,
  [SMALL_STATE(237)] = 13032,
  [SMALL_STATE(238)] = 13046,
  [SMALL_STATE(239)] = 13058,
  [SMALL_STATE(240)] = 13070,
  [SMALL_STATE(241)] = 13082,
  [SMALL_STATE(242)] = 13094,
  [SMALL_STATE(243)] = 13106,
  [SMALL_STATE(244)] = 13118,
  [SMALL_STATE(245)] = 13130,
  [SMALL_STATE(246)] = 13144,
  [SMALL_STATE(247)] = 13156,
  [SMALL_STATE(248)] = 13168,
  [SMALL_STATE(249)] = 13180,
  [SMALL_STATE(250)] = 13192,
  [SMALL_STATE(251)] = 13204,
  [SMALL_STATE(252)] = 13216,
  [SMALL_STATE(253)] = 13228,
  [SMALL_STATE(254)] = 13235,
  [SMALL_STATE(255)] = 13242,
  [SMALL_STATE(256)] = 13253,
  [SMALL_STATE(257)] = 13260,
  [SMALL_STATE(258)] = 13269,
  [SMALL_STATE(259)] = 13278,
  [SMALL_STATE(260)] = 13287,
  [SMALL_STATE(261)] = 13294,
  [SMALL_STATE(262)] = 13301,
  [SMALL_STATE(263)] = 13308,
  [SMALL_STATE(264)] = 13315,
  [SMALL_STATE(265)] = 13324,
  [SMALL_STATE(266)] = 13337,
  [SMALL_STATE(267)] = 13346,
  [SMALL_STATE(268)] = 13355,
  [SMALL_STATE(269)] = 13364,
  [SMALL_STATE(270)] = 13373,
  [SMALL_STATE(271)] = 13382,
  [SMALL_STATE(272)] = 13392,
  [SMALL_STATE(273)] = 13398,
  [SMALL_STATE(274)] = 13408,
  [SMALL_STATE(275)] = 13418,
  [SMALL_STATE(276)] = 13426,
  [SMALL_STATE(277)] = 13432,
  [SMALL_STATE(278)] = 13442,
  [SMALL_STATE(279)] = 13452,
  [SMALL_STATE(280)] = 13458,
  [SMALL_STATE(281)] = 13468,
  [SMALL_STATE(282)] = 13478,
  [SMALL_STATE(283)] = 13488,
  [SMALL_STATE(284)] = 13494,
  [SMALL_STATE(285)] = 13500,
  [SMALL_STATE(286)] = 13510,
  [SMALL_STATE(287)] = 13516,
  [SMALL_STATE(288)] = 13526,
  [SMALL_STATE(289)] = 13536,
  [SMALL_STATE(290)] = 13544,
  [SMALL_STATE(291)] = 13554,
  [SMALL_STATE(292)] = 13564,
  [SMALL_STATE(293)] = 13574,
  [SMALL_STATE(294)] = 13584,
  [SMALL_STATE(295)] = 13590,
  [SMALL_STATE(296)] = 13600,
  [SMALL_STATE(297)] = 13610,
  [SMALL_STATE(298)] = 13620,
  [SMALL_STATE(299)] = 13630,
  [SMALL_STATE(300)] = 13640,
  [SMALL_STATE(301)] = 13650,
  [SMALL_STATE(302)] = 13656,
  [SMALL_STATE(303)] = 13663,
  [SMALL_STATE(304)] = 13668,
  [SMALL_STATE(305)] = 13675,
  [SMALL_STATE(306)] = 13682,
  [SMALL_STATE(307)] = 13687,
  [SMALL_STATE(308)] = 13692,
  [SMALL_STATE(309)] = 13697,
  [SMALL_STATE(310)] = 13704,
  [SMALL_STATE(311)] = 13709,
  [SMALL_STATE(312)] = 13716,
  [SMALL_STATE(313)] = 13721,
  [SMALL_STATE(314)] = 13728,
  [SMALL_STATE(315)] = 13732,
  [SMALL_STATE(316)] = 13736,
  [SMALL_STATE(317)] = 13740,
  [SMALL_STATE(318)] = 13744,
  [SMALL_STATE(319)] = 13748,
  [SMALL_STATE(320)] = 13752,
  [SMALL_STATE(321)] = 13756,
  [SMALL_STATE(322)] = 13760,
  [SMALL_STATE(323)] = 13764,
  [SMALL_STATE(324)] = 13768,
  [SMALL_STATE(325)] = 13772,
  [SMALL_STATE(326)] = 13776,
  [SMALL_STATE(327)] = 13780,
  [SMALL_STATE(328)] = 13784,
  [SMALL_STATE(329)] = 13788,
  [SMALL_STATE(330)] = 13792,
  [SMALL_STATE(331)] = 13796,
  [SMALL_STATE(332)] = 13800,
  [SMALL_STATE(333)] = 13804,
  [SMALL_STATE(334)] = 13808,
  [SMALL_STATE(335)] = 13812,
  [SMALL_STATE(336)] = 13816,
  [SMALL_STATE(337)] = 13820,
  [SMALL_STATE(338)] = 13824,
  [SMALL_STATE(339)] = 13828,
  [SMALL_STATE(340)] = 13832,
  [SMALL_STATE(341)] = 13836,
  [SMALL_STATE(342)] = 13840,
  [SMALL_STATE(343)] = 13844,
  [SMALL_STATE(344)] = 13848,
  [SMALL_STATE(345)] = 13852,
  [SMALL_STATE(346)] = 13856,
  [SMALL_STATE(347)] = 13860,
  [SMALL_STATE(348)] = 13864,
  [SMALL_STATE(349)] = 13868,
  [SMALL_STATE(350)] = 13872,
  [SMALL_STATE(351)] = 13876,
  [SMALL_STATE(352)] = 13880,
  [SMALL_STATE(353)] = 13884,
  [SMALL_STATE(354)] = 13888,
  [SMALL_STATE(355)] = 13892,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(286),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [67] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(286),
  [70] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(285),
  [73] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(187),
  [76] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(220),
  [79] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(120),
  [82] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(334),
  [85] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(229),
  [88] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(180),
  [91] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(67),
  [94] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(59),
  [97] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(22),
  [100] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(23),
  [103] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(286),
  [106] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(19),
  [109] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(24),
  [112] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(331),
  [115] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(255),
  [118] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(200),
  [121] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(316),
  [124] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(257),
  [127] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(18),
  [130] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(304),
  [133] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(309),
  [136] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(31),
  [139] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(32),
  [142] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(353),
  [145] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(11),
  [148] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(224),
  [151] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(341),
  [154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [168] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2),
  [170] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_line_repeat1, 2),
  [172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [178] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [196] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [198] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [204] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [208] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(25),
  [211] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(299),
  [214] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(26),
  [217] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(26),
  [220] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(343),
  [223] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(344),
  [226] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(78),
  [229] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(345),
  [232] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(342),
  [235] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(354),
  [238] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(355),
  [241] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(61),
  [244] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2),
  [246] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(85),
  [249] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(85),
  [252] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(110),
  [255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_statement_repeat7, 2),
  [257] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(330),
  [260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1),
  [262] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [270] = {.entry = {.count = 1, .reusable = false}}, SHIFT(63),
  [272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [288] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [296] = {.entry = {.count = 1, .reusable = false}}, SHIFT(186),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [304] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [310] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [314] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [318] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [322] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [326] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [330] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [334] = {.entry = {.count = 1, .reusable = false}}, SHIFT(202),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [338] = {.entry = {.count = 1, .reusable = false}}, SHIFT(197),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [344] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [348] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [352] = {.entry = {.count = 1, .reusable = false}}, SHIFT(178),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [356] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [360] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [364] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [368] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [372] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [376] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [380] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [384] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [392] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [400] = {.entry = {.count = 1, .reusable = false}}, SHIFT(199),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [404] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [408] = {.entry = {.count = 1, .reusable = false}}, SHIFT(175),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [412] = {.entry = {.count = 1, .reusable = false}}, SHIFT(179),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [416] = {.entry = {.count = 1, .reusable = false}}, SHIFT(190),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [420] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [424] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [428] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [432] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [436] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [440] = {.entry = {.count = 1, .reusable = false}}, SHIFT(89),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [444] = {.entry = {.count = 1, .reusable = false}}, SHIFT(204),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [448] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [452] = {.entry = {.count = 1, .reusable = false}}, SHIFT(93),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [456] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [460] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [464] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [468] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [474] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [478] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [482] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [486] = {.entry = {.count = 1, .reusable = false}}, SHIFT(161),
  [488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [490] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [494] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(198),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [502] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [506] = {.entry = {.count = 1, .reusable = false}}, SHIFT(205),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [510] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [514] = {.entry = {.count = 1, .reusable = false}}, SHIFT(211),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [518] = {.entry = {.count = 1, .reusable = false}}, SHIFT(210),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [522] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [526] = {.entry = {.count = 1, .reusable = false}}, SHIFT(184),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [530] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [534] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [538] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [542] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__real_scalar, 1),
  [544] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__real_scalar, 1),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [554] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__name, 2),
  [556] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__name, 2),
  [558] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_aexpr, 3),
  [560] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [574] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_aexpr, 3),
  [576] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_sexpr, 3),
  [578] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_sexpr, 3),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr, 1),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [584] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expr, 1),
  [586] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__int_scalar, 2),
  [588] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__int_scalar, 2),
  [590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string_scalar, 2),
  [592] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string_scalar, 2),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_aexpr, 2),
  [596] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_aexpr, 2),
  [598] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parenthesized_sexpr, 3),
  [600] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__parenthesized_sexpr, 3),
  [602] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sfcall, 3),
  [604] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sfcall, 3),
  [606] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_svar, 1),
  [608] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_svar, 1),
  [610] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string_array, 3),
  [612] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string_array, 3),
  [614] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__int_array, 3),
  [616] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__int_array, 3),
  [618] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__real_array, 2),
  [620] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__real_array, 2),
  [622] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_realvar, 1),
  [624] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_realvar, 1),
  [626] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parenthesized_aexpr, 3),
  [628] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__parenthesized_aexpr, 3),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_intvar, 1),
  [632] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_intvar, 1),
  [634] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript, 3),
  [636] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript, 3),
  [638] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sfcall, 4),
  [640] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sfcall, 4),
  [642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fcall, 4),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fcall, 4),
  [646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript, 4),
  [648] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript, 4),
  [650] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fcall, 5),
  [652] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fcall, 5),
  [654] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sfcall, 6),
  [656] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sfcall, 6),
  [658] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sfcall, 8),
  [660] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sfcall, 8),
  [662] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [664] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 1),
  [666] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_statement_repeat7, 1),
  [668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [670] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__relop, 1),
  [672] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__relop, 1),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [676] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__relop, 2),
  [678] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__relop, 2),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [732] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 5),
  [734] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 4),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [738] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 6),
  [740] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat4, 4),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [746] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 3),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [754] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 8),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 4),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [764] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_subscript_repeat1, 2),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [814] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_repeat1, 2), SHIFT_REPEAT(350),
  [817] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_statement_repeat1, 2),
  [819] = {.entry = {.count = 1, .reusable = false}}, SHIFT(270),
  [821] = {.entry = {.count = 1, .reusable = false}}, SHIFT(258),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [827] = {.entry = {.count = 1, .reusable = false}}, SHIFT(268),
  [829] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [831] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_repeat1, 2), SHIFT_REPEAT(320),
  [834] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__sexpr, 1),
  [836] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__var, 1),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [842] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat6, 2), SHIFT_REPEAT(336),
  [845] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat6, 2),
  [847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [851] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 3),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [857] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(237),
  [860] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(2),
  [863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [867] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [871] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat5, 2), SHIFT_REPEAT(213),
  [874] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat5, 2),
  [876] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat4, 2), SHIFT_REPEAT(73),
  [879] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat4, 2),
  [881] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat2, 2), SHIFT_REPEAT(228),
  [884] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat2, 2),
  [886] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat3, 2), SHIFT_REPEAT(181),
  [889] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat3, 2),
  [891] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_real_array, 2),
  [893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [899] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_int_array, 3),
  [901] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_array, 3),
  [903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [905] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [907] = {.entry = {.count = 1, .reusable = false}}, SHIFT(284),
  [909] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1),
  [911] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_real_scalar, 1),
  [913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [923] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_int_scalar, 2),
  [925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line, 3),
  [929] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_subscript_repeat1, 2), SHIFT_REPEAT(49),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [934] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat8, 2), SHIFT_REPEAT(17),
  [937] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat8, 2),
  [939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line, 4),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [961] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_terminal_statement, 3),
  [963] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_terminal_statement, 2),
  [965] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_name, 1),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [997] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [1019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_applesoft_external_scanner_create(void);
void tree_sitter_applesoft_external_scanner_destroy(void *);
bool tree_sitter_applesoft_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_applesoft_external_scanner_serialize(void *, char *);
void tree_sitter_applesoft_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_applesoft(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_applesoft_external_scanner_create,
      tree_sitter_applesoft_external_scanner_destroy,
      tree_sitter_applesoft_external_scanner_scan,
      tree_sitter_applesoft_external_scanner_serialize,
      tree_sitter_applesoft_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
