#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 323
#define LARGE_STATE_COUNT 7
#define SYMBOL_COUNT 170
#define ALIAS_COUNT 0
#define TOKEN_COUNT 126
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 1

enum {
  sym_end_tok = 1,
  sym_for_tok = 2,
  sym_next_tok = 3,
  sym_data_tok = 4,
  sym_input_tok = 5,
  sym_del_tok = 6,
  sym_dim_tok = 7,
  sym_read_tok = 8,
  sym_gr_tok = 9,
  sym_text_tok = 10,
  sym_prn_tok = 11,
  sym_inn_tok = 12,
  sym_call_tok = 13,
  sym_plot_tok = 14,
  sym_hlin_tok = 15,
  sym_vlin_tok = 16,
  sym_hgr2_tok = 17,
  sym_hgr_tok = 18,
  sym_hcoloreq_tok = 19,
  sym_hplot_tok = 20,
  sym_draw_tok = 21,
  sym_xdraw_tok = 22,
  sym_htab_tok = 23,
  sym_home_tok = 24,
  sym_roteq_tok = 25,
  sym_scaleeq_tok = 26,
  sym_shload_tok = 27,
  sym_trace_tok = 28,
  sym_notrace_tok = 29,
  sym_normal_tok = 30,
  sym_inverse_tok = 31,
  sym_flash_tok = 32,
  sym_coloreq_tok = 33,
  sym_pop_tok = 34,
  sym_vtab_tok = 35,
  sym_himem_tok = 36,
  sym_lomem_tok = 37,
  sym_onerr_tok = 38,
  sym_resume_tok = 39,
  sym_recall_tok = 40,
  sym_store_tok = 41,
  sym_speedeq_tok = 42,
  sym_let_tok = 43,
  sym_goto_tok = 44,
  sym_run_tok = 45,
  sym_if_tok = 46,
  sym_restore_tok = 47,
  sym_amp_tok = 48,
  sym_gosub_tok = 49,
  sym_return_tok = 50,
  sym_rem_tok = 51,
  sym_stop_tok = 52,
  sym_on_tok = 53,
  sym_wait_tok = 54,
  sym_load_tok = 55,
  sym_save_tok = 56,
  sym_def_tok = 57,
  sym_poke_tok = 58,
  sym_print_tok = 59,
  sym_cont_tok = 60,
  sym_list_tok = 61,
  sym_clear_tok = 62,
  sym_get_tok = 63,
  sym_new_tok = 64,
  sym_tabp_tok = 65,
  sym_to_tok = 66,
  sym_fn_tok = 67,
  sym_spcp_tok = 68,
  sym_then_tok = 69,
  sym_at_tok = 70,
  sym_not_tok = 71,
  sym_step_tok = 72,
  sym_plus_tok = 73,
  sym_minus_tok = 74,
  sym_times_tok = 75,
  sym_div_tok = 76,
  sym_pow_tok = 77,
  sym_and_tok = 78,
  sym_or_tok = 79,
  sym_gtr_tok = 80,
  sym_eq_tok = 81,
  sym_less_tok = 82,
  sym_sgn_tok = 83,
  sym_int_tok = 84,
  sym_abs_tok = 85,
  sym_usr_tok = 86,
  sym_fre_tok = 87,
  sym_scrnp_tok = 88,
  sym_pdl_tok = 89,
  sym_pos_tok = 90,
  sym_sqr_tok = 91,
  sym_rnd_tok = 92,
  sym_log_tok = 93,
  sym_exp_tok = 94,
  sym_cos_tok = 95,
  sym_sin_tok = 96,
  sym_tan_tok = 97,
  sym_atn_tok = 98,
  sym_peek_tok = 99,
  sym_len_tok = 100,
  sym_str_tok = 101,
  sym_val_tok = 102,
  sym_asc_tok = 103,
  sym_chr_tok = 104,
  sym_left_tok = 105,
  sym_right_tok = 106,
  sym_mid_tok = 107,
  anon_sym_COMMA = 108,
  anon_sym_LPAREN = 109,
  anon_sym_RPAREN = 110,
  anon_sym_SEMI = 111,
  sym_comment_text = 112,
  anon_sym_COLON = 113,
  anon_sym_LF = 114,
  anon_sym_CR_LF = 115,
  sym__empty_line = 116,
  sym_linenum = 117,
  sym_integer = 118,
  sym_literal = 119,
  sym_real = 120,
  sym_real_data_item = 121,
  sym_string = 122,
  anon_sym_PERCENT = 123,
  anon_sym_DOLLAR = 124,
  sym__ext_name = 125,
  sym_source_file = 126,
  sym_statement = 127,
  sym_assignment = 128,
  sym_fcall = 129,
  sym_sfcall = 130,
  sym_line = 131,
  sym__expr = 132,
  sym__aexpr = 133,
  sym_unary_aexpr = 134,
  sym_binary_aexpr = 135,
  sym__parenthesized_aexpr = 136,
  sym__relop = 137,
  sym__sexpr = 138,
  sym_binary_sexpr = 139,
  sym__parenthesized_sexpr = 140,
  sym__sop = 141,
  sym__var = 142,
  sym__avar = 143,
  sym_intvar = 144,
  sym_realvar = 145,
  sym_svar = 146,
  sym_subscript = 147,
  sym__dim_item = 148,
  sym__data_item = 149,
  sym__name = 150,
  sym_fn_name = 151,
  sym_real_scalar = 152,
  sym__real_scalar = 153,
  sym_int_scalar = 154,
  sym__int_scalar = 155,
  sym__string_scalar = 156,
  sym__real_array = 157,
  sym__int_array = 158,
  sym__string_array = 159,
  aux_sym_source_file_repeat1 = 160,
  aux_sym_statement_repeat1 = 161,
  aux_sym_statement_repeat2 = 162,
  aux_sym_statement_repeat3 = 163,
  aux_sym_statement_repeat4 = 164,
  aux_sym_statement_repeat5 = 165,
  aux_sym_statement_repeat6 = 166,
  aux_sym_statement_repeat7 = 167,
  aux_sym_line_repeat1 = 168,
  aux_sym_subscript_repeat1 = 169,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_end_tok] = "end_tok",
  [sym_for_tok] = "for_tok",
  [sym_next_tok] = "next_tok",
  [sym_data_tok] = "data_tok",
  [sym_input_tok] = "input_tok",
  [sym_del_tok] = "del_tok",
  [sym_dim_tok] = "dim_tok",
  [sym_read_tok] = "read_tok",
  [sym_gr_tok] = "gr_tok",
  [sym_text_tok] = "text_tok",
  [sym_prn_tok] = "prn_tok",
  [sym_inn_tok] = "inn_tok",
  [sym_call_tok] = "call_tok",
  [sym_plot_tok] = "plot_tok",
  [sym_hlin_tok] = "hlin_tok",
  [sym_vlin_tok] = "vlin_tok",
  [sym_hgr2_tok] = "hgr2_tok",
  [sym_hgr_tok] = "hgr_tok",
  [sym_hcoloreq_tok] = "hcoloreq_tok",
  [sym_hplot_tok] = "hplot_tok",
  [sym_draw_tok] = "draw_tok",
  [sym_xdraw_tok] = "xdraw_tok",
  [sym_htab_tok] = "htab_tok",
  [sym_home_tok] = "home_tok",
  [sym_roteq_tok] = "roteq_tok",
  [sym_scaleeq_tok] = "scaleeq_tok",
  [sym_shload_tok] = "shload_tok",
  [sym_trace_tok] = "trace_tok",
  [sym_notrace_tok] = "notrace_tok",
  [sym_normal_tok] = "normal_tok",
  [sym_inverse_tok] = "inverse_tok",
  [sym_flash_tok] = "flash_tok",
  [sym_coloreq_tok] = "coloreq_tok",
  [sym_pop_tok] = "pop_tok",
  [sym_vtab_tok] = "vtab_tok",
  [sym_himem_tok] = "himem_tok",
  [sym_lomem_tok] = "lomem_tok",
  [sym_onerr_tok] = "onerr_tok",
  [sym_resume_tok] = "resume_tok",
  [sym_recall_tok] = "recall_tok",
  [sym_store_tok] = "store_tok",
  [sym_speedeq_tok] = "speedeq_tok",
  [sym_let_tok] = "let_tok",
  [sym_goto_tok] = "goto_tok",
  [sym_run_tok] = "run_tok",
  [sym_if_tok] = "if_tok",
  [sym_restore_tok] = "restore_tok",
  [sym_amp_tok] = "amp_tok",
  [sym_gosub_tok] = "gosub_tok",
  [sym_return_tok] = "return_tok",
  [sym_rem_tok] = "rem_tok",
  [sym_stop_tok] = "stop_tok",
  [sym_on_tok] = "on_tok",
  [sym_wait_tok] = "wait_tok",
  [sym_load_tok] = "load_tok",
  [sym_save_tok] = "save_tok",
  [sym_def_tok] = "def_tok",
  [sym_poke_tok] = "poke_tok",
  [sym_print_tok] = "print_tok",
  [sym_cont_tok] = "cont_tok",
  [sym_list_tok] = "list_tok",
  [sym_clear_tok] = "clear_tok",
  [sym_get_tok] = "get_tok",
  [sym_new_tok] = "new_tok",
  [sym_tabp_tok] = "tabp_tok",
  [sym_to_tok] = "to_tok",
  [sym_fn_tok] = "fn_tok",
  [sym_spcp_tok] = "spcp_tok",
  [sym_then_tok] = "then_tok",
  [sym_at_tok] = "at_tok",
  [sym_not_tok] = "not_tok",
  [sym_step_tok] = "step_tok",
  [sym_plus_tok] = "plus_tok",
  [sym_minus_tok] = "minus_tok",
  [sym_times_tok] = "times_tok",
  [sym_div_tok] = "div_tok",
  [sym_pow_tok] = "pow_tok",
  [sym_and_tok] = "and_tok",
  [sym_or_tok] = "or_tok",
  [sym_gtr_tok] = "gtr_tok",
  [sym_eq_tok] = "eq_tok",
  [sym_less_tok] = "less_tok",
  [sym_sgn_tok] = "sgn_tok",
  [sym_int_tok] = "int_tok",
  [sym_abs_tok] = "abs_tok",
  [sym_usr_tok] = "usr_tok",
  [sym_fre_tok] = "fre_tok",
  [sym_scrnp_tok] = "scrnp_tok",
  [sym_pdl_tok] = "pdl_tok",
  [sym_pos_tok] = "pos_tok",
  [sym_sqr_tok] = "sqr_tok",
  [sym_rnd_tok] = "rnd_tok",
  [sym_log_tok] = "log_tok",
  [sym_exp_tok] = "exp_tok",
  [sym_cos_tok] = "cos_tok",
  [sym_sin_tok] = "sin_tok",
  [sym_tan_tok] = "tan_tok",
  [sym_atn_tok] = "atn_tok",
  [sym_peek_tok] = "peek_tok",
  [sym_len_tok] = "len_tok",
  [sym_str_tok] = "str_tok",
  [sym_val_tok] = "val_tok",
  [sym_asc_tok] = "asc_tok",
  [sym_chr_tok] = "chr_tok",
  [sym_left_tok] = "left_tok",
  [sym_right_tok] = "right_tok",
  [sym_mid_tok] = "mid_tok",
  [anon_sym_COMMA] = ",",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SEMI] = ";",
  [sym_comment_text] = "comment_text",
  [anon_sym_COLON] = ":",
  [anon_sym_LF] = "\n",
  [anon_sym_CR_LF] = "\r\n",
  [sym__empty_line] = "_empty_line",
  [sym_linenum] = "linenum",
  [sym_integer] = "integer",
  [sym_literal] = "literal",
  [sym_real] = "real",
  [sym_real_data_item] = "real_data_item",
  [sym_string] = "string",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOLLAR] = "$",
  [sym__ext_name] = "_ext_name",
  [sym_source_file] = "source_file",
  [sym_statement] = "statement",
  [sym_assignment] = "assignment",
  [sym_fcall] = "fcall",
  [sym_sfcall] = "sfcall",
  [sym_line] = "line",
  [sym__expr] = "_expr",
  [sym__aexpr] = "_aexpr",
  [sym_unary_aexpr] = "unary_aexpr",
  [sym_binary_aexpr] = "binary_aexpr",
  [sym__parenthesized_aexpr] = "_parenthesized_aexpr",
  [sym__relop] = "_relop",
  [sym__sexpr] = "_sexpr",
  [sym_binary_sexpr] = "binary_sexpr",
  [sym__parenthesized_sexpr] = "_parenthesized_sexpr",
  [sym__sop] = "_sop",
  [sym__var] = "_var",
  [sym__avar] = "_avar",
  [sym_intvar] = "intvar",
  [sym_realvar] = "realvar",
  [sym_svar] = "svar",
  [sym_subscript] = "subscript",
  [sym__dim_item] = "_dim_item",
  [sym__data_item] = "_data_item",
  [sym__name] = "_name",
  [sym_fn_name] = "fn_name",
  [sym_real_scalar] = "real_scalar",
  [sym__real_scalar] = "_real_scalar",
  [sym_int_scalar] = "int_scalar",
  [sym__int_scalar] = "_int_scalar",
  [sym__string_scalar] = "_string_scalar",
  [sym__real_array] = "_real_array",
  [sym__int_array] = "_int_array",
  [sym__string_array] = "_string_array",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_statement_repeat1] = "statement_repeat1",
  [aux_sym_statement_repeat2] = "statement_repeat2",
  [aux_sym_statement_repeat3] = "statement_repeat3",
  [aux_sym_statement_repeat4] = "statement_repeat4",
  [aux_sym_statement_repeat5] = "statement_repeat5",
  [aux_sym_statement_repeat6] = "statement_repeat6",
  [aux_sym_statement_repeat7] = "statement_repeat7",
  [aux_sym_line_repeat1] = "line_repeat1",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_end_tok] = sym_end_tok,
  [sym_for_tok] = sym_for_tok,
  [sym_next_tok] = sym_next_tok,
  [sym_data_tok] = sym_data_tok,
  [sym_input_tok] = sym_input_tok,
  [sym_del_tok] = sym_del_tok,
  [sym_dim_tok] = sym_dim_tok,
  [sym_read_tok] = sym_read_tok,
  [sym_gr_tok] = sym_gr_tok,
  [sym_text_tok] = sym_text_tok,
  [sym_prn_tok] = sym_prn_tok,
  [sym_inn_tok] = sym_inn_tok,
  [sym_call_tok] = sym_call_tok,
  [sym_plot_tok] = sym_plot_tok,
  [sym_hlin_tok] = sym_hlin_tok,
  [sym_vlin_tok] = sym_vlin_tok,
  [sym_hgr2_tok] = sym_hgr2_tok,
  [sym_hgr_tok] = sym_hgr_tok,
  [sym_hcoloreq_tok] = sym_hcoloreq_tok,
  [sym_hplot_tok] = sym_hplot_tok,
  [sym_draw_tok] = sym_draw_tok,
  [sym_xdraw_tok] = sym_xdraw_tok,
  [sym_htab_tok] = sym_htab_tok,
  [sym_home_tok] = sym_home_tok,
  [sym_roteq_tok] = sym_roteq_tok,
  [sym_scaleeq_tok] = sym_scaleeq_tok,
  [sym_shload_tok] = sym_shload_tok,
  [sym_trace_tok] = sym_trace_tok,
  [sym_notrace_tok] = sym_notrace_tok,
  [sym_normal_tok] = sym_normal_tok,
  [sym_inverse_tok] = sym_inverse_tok,
  [sym_flash_tok] = sym_flash_tok,
  [sym_coloreq_tok] = sym_coloreq_tok,
  [sym_pop_tok] = sym_pop_tok,
  [sym_vtab_tok] = sym_vtab_tok,
  [sym_himem_tok] = sym_himem_tok,
  [sym_lomem_tok] = sym_lomem_tok,
  [sym_onerr_tok] = sym_onerr_tok,
  [sym_resume_tok] = sym_resume_tok,
  [sym_recall_tok] = sym_recall_tok,
  [sym_store_tok] = sym_store_tok,
  [sym_speedeq_tok] = sym_speedeq_tok,
  [sym_let_tok] = sym_let_tok,
  [sym_goto_tok] = sym_goto_tok,
  [sym_run_tok] = sym_run_tok,
  [sym_if_tok] = sym_if_tok,
  [sym_restore_tok] = sym_restore_tok,
  [sym_amp_tok] = sym_amp_tok,
  [sym_gosub_tok] = sym_gosub_tok,
  [sym_return_tok] = sym_return_tok,
  [sym_rem_tok] = sym_rem_tok,
  [sym_stop_tok] = sym_stop_tok,
  [sym_on_tok] = sym_on_tok,
  [sym_wait_tok] = sym_wait_tok,
  [sym_load_tok] = sym_load_tok,
  [sym_save_tok] = sym_save_tok,
  [sym_def_tok] = sym_def_tok,
  [sym_poke_tok] = sym_poke_tok,
  [sym_print_tok] = sym_print_tok,
  [sym_cont_tok] = sym_cont_tok,
  [sym_list_tok] = sym_list_tok,
  [sym_clear_tok] = sym_clear_tok,
  [sym_get_tok] = sym_get_tok,
  [sym_new_tok] = sym_new_tok,
  [sym_tabp_tok] = sym_tabp_tok,
  [sym_to_tok] = sym_to_tok,
  [sym_fn_tok] = sym_fn_tok,
  [sym_spcp_tok] = sym_spcp_tok,
  [sym_then_tok] = sym_then_tok,
  [sym_at_tok] = sym_at_tok,
  [sym_not_tok] = sym_not_tok,
  [sym_step_tok] = sym_step_tok,
  [sym_plus_tok] = sym_plus_tok,
  [sym_minus_tok] = sym_minus_tok,
  [sym_times_tok] = sym_times_tok,
  [sym_div_tok] = sym_div_tok,
  [sym_pow_tok] = sym_pow_tok,
  [sym_and_tok] = sym_and_tok,
  [sym_or_tok] = sym_or_tok,
  [sym_gtr_tok] = sym_gtr_tok,
  [sym_eq_tok] = sym_eq_tok,
  [sym_less_tok] = sym_less_tok,
  [sym_sgn_tok] = sym_sgn_tok,
  [sym_int_tok] = sym_int_tok,
  [sym_abs_tok] = sym_abs_tok,
  [sym_usr_tok] = sym_usr_tok,
  [sym_fre_tok] = sym_fre_tok,
  [sym_scrnp_tok] = sym_scrnp_tok,
  [sym_pdl_tok] = sym_pdl_tok,
  [sym_pos_tok] = sym_pos_tok,
  [sym_sqr_tok] = sym_sqr_tok,
  [sym_rnd_tok] = sym_rnd_tok,
  [sym_log_tok] = sym_log_tok,
  [sym_exp_tok] = sym_exp_tok,
  [sym_cos_tok] = sym_cos_tok,
  [sym_sin_tok] = sym_sin_tok,
  [sym_tan_tok] = sym_tan_tok,
  [sym_atn_tok] = sym_atn_tok,
  [sym_peek_tok] = sym_peek_tok,
  [sym_len_tok] = sym_len_tok,
  [sym_str_tok] = sym_str_tok,
  [sym_val_tok] = sym_val_tok,
  [sym_asc_tok] = sym_asc_tok,
  [sym_chr_tok] = sym_chr_tok,
  [sym_left_tok] = sym_left_tok,
  [sym_right_tok] = sym_right_tok,
  [sym_mid_tok] = sym_mid_tok,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [sym_comment_text] = sym_comment_text,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR_LF] = anon_sym_CR_LF,
  [sym__empty_line] = sym__empty_line,
  [sym_linenum] = sym_linenum,
  [sym_integer] = sym_integer,
  [sym_literal] = sym_literal,
  [sym_real] = sym_real,
  [sym_real_data_item] = sym_real_data_item,
  [sym_string] = sym_string,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym__ext_name] = sym__ext_name,
  [sym_source_file] = sym_source_file,
  [sym_statement] = sym_statement,
  [sym_assignment] = sym_assignment,
  [sym_fcall] = sym_fcall,
  [sym_sfcall] = sym_sfcall,
  [sym_line] = sym_line,
  [sym__expr] = sym__expr,
  [sym__aexpr] = sym__aexpr,
  [sym_unary_aexpr] = sym_unary_aexpr,
  [sym_binary_aexpr] = sym_binary_aexpr,
  [sym__parenthesized_aexpr] = sym__parenthesized_aexpr,
  [sym__relop] = sym__relop,
  [sym__sexpr] = sym__sexpr,
  [sym_binary_sexpr] = sym_binary_sexpr,
  [sym__parenthesized_sexpr] = sym__parenthesized_sexpr,
  [sym__sop] = sym__sop,
  [sym__var] = sym__var,
  [sym__avar] = sym__avar,
  [sym_intvar] = sym_intvar,
  [sym_realvar] = sym_realvar,
  [sym_svar] = sym_svar,
  [sym_subscript] = sym_subscript,
  [sym__dim_item] = sym__dim_item,
  [sym__data_item] = sym__data_item,
  [sym__name] = sym__name,
  [sym_fn_name] = sym_fn_name,
  [sym_real_scalar] = sym_real_scalar,
  [sym__real_scalar] = sym__real_scalar,
  [sym_int_scalar] = sym_int_scalar,
  [sym__int_scalar] = sym__int_scalar,
  [sym__string_scalar] = sym__string_scalar,
  [sym__real_array] = sym__real_array,
  [sym__int_array] = sym__int_array,
  [sym__string_array] = sym__string_array,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_statement_repeat1] = aux_sym_statement_repeat1,
  [aux_sym_statement_repeat2] = aux_sym_statement_repeat2,
  [aux_sym_statement_repeat3] = aux_sym_statement_repeat3,
  [aux_sym_statement_repeat4] = aux_sym_statement_repeat4,
  [aux_sym_statement_repeat5] = aux_sym_statement_repeat5,
  [aux_sym_statement_repeat6] = aux_sym_statement_repeat6,
  [aux_sym_statement_repeat7] = aux_sym_statement_repeat7,
  [aux_sym_line_repeat1] = aux_sym_line_repeat1,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_end_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_for_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_next_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_data_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_input_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_del_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_dim_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_read_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_gr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_text_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_prn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_inn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_call_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_plot_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hlin_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_vlin_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hgr2_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hgr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hcoloreq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_hplot_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_draw_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_xdraw_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_htab_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_home_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_roteq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_scaleeq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_shload_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_trace_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_notrace_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_inverse_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_flash_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_coloreq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_pop_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_vtab_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_himem_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_lomem_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_onerr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_resume_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_recall_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_store_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_speedeq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_let_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_run_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_if_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_restore_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_amp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_gosub_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_return_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_rem_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_stop_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_on_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_wait_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_load_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_save_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_def_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_poke_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_print_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_cont_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_list_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_clear_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_get_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_new_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_tabp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_to_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_spcp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_then_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_at_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_not_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_step_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_minus_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_times_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_div_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_pow_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_and_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_or_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_gtr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_eq_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_less_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_sgn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_int_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_abs_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_usr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_fre_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_scrnp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_pdl_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_pos_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_sqr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_rnd_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_log_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_exp_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_cos_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_sin_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_tan_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_atn_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_peek_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_len_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_str_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_val_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_asc_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_chr_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_left_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_right_tok] = {
    .visible = true,
    .named = true,
  },
  [sym_mid_tok] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [sym_comment_text] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR_LF] = {
    .visible = true,
    .named = false,
  },
  [sym__empty_line] = {
    .visible = false,
    .named = true,
  },
  [sym_linenum] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_real] = {
    .visible = true,
    .named = true,
  },
  [sym_real_data_item] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym__ext_name] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_fcall] = {
    .visible = true,
    .named = true,
  },
  [sym_sfcall] = {
    .visible = true,
    .named = true,
  },
  [sym_line] = {
    .visible = true,
    .named = true,
  },
  [sym__expr] = {
    .visible = false,
    .named = true,
  },
  [sym__aexpr] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_aexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_aexpr] = {
    .visible = true,
    .named = true,
  },
  [sym__parenthesized_aexpr] = {
    .visible = false,
    .named = true,
  },
  [sym__relop] = {
    .visible = false,
    .named = true,
  },
  [sym__sexpr] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_sexpr] = {
    .visible = true,
    .named = true,
  },
  [sym__parenthesized_sexpr] = {
    .visible = false,
    .named = true,
  },
  [sym__sop] = {
    .visible = false,
    .named = true,
  },
  [sym__var] = {
    .visible = false,
    .named = true,
  },
  [sym__avar] = {
    .visible = false,
    .named = true,
  },
  [sym_intvar] = {
    .visible = true,
    .named = true,
  },
  [sym_realvar] = {
    .visible = true,
    .named = true,
  },
  [sym_svar] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym__dim_item] = {
    .visible = false,
    .named = true,
  },
  [sym__data_item] = {
    .visible = false,
    .named = true,
  },
  [sym__name] = {
    .visible = false,
    .named = true,
  },
  [sym_fn_name] = {
    .visible = true,
    .named = true,
  },
  [sym_real_scalar] = {
    .visible = true,
    .named = true,
  },
  [sym__real_scalar] = {
    .visible = false,
    .named = true,
  },
  [sym_int_scalar] = {
    .visible = true,
    .named = true,
  },
  [sym__int_scalar] = {
    .visible = false,
    .named = true,
  },
  [sym__string_scalar] = {
    .visible = false,
    .named = true,
  },
  [sym__real_array] = {
    .visible = false,
    .named = true,
  },
  [sym__int_array] = {
    .visible = false,
    .named = true,
  },
  [sym__string_array] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat7] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(248);
      if (lookahead == '\n') ADVANCE(368);
      if (lookahead == '\r') ADVANCE(5);
      if (lookahead == ' ') ADVANCE(1);
      if (lookahead == '"') ADVANCE(244);
      if (lookahead == '$') ADVANCE(394);
      if (lookahead == '%') ADVANCE(393);
      if (lookahead == '&') ADVANCE(296);
      if (lookahead == '(') ADVANCE(359);
      if (lookahead == ')') ADVANCE(360);
      if (lookahead == '*') ADVANCE(325);
      if (lookahead == '+') ADVANCE(390);
      if (lookahead == ',') ADVANCE(358);
      if (lookahead == '-') ADVANCE(390);
      if (lookahead == '/') ADVANCE(326);
      if (lookahead == ':') ADVANCE(366);
      if (lookahead == ';') ADVANCE(361);
      if (lookahead == '<') ADVANCE(332);
      if (lookahead == '=') ADVANCE(331);
      if (lookahead == '>') ADVANCE(330);
      if (lookahead == 'E') ADVANCE(389);
      if (lookahead == '^') ADVANCE(327);
      if (lookahead == 'e') ADVANCE(8);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(9);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(10);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(11);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(12);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(13);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(14);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(15);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(16);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(17);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(18);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(19);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(20);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(21);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(22);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(23);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(24);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(25);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(26);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(373);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(368);
      if (lookahead == '\r') ADVANCE(5);
      if (lookahead == ' ') ADVANCE(1);
      if (lookahead == '"') ADVANCE(244);
      if (lookahead == '$') ADVANCE(394);
      if (lookahead == '%') ADVANCE(393);
      if (lookahead == '&') ADVANCE(296);
      if (lookahead == '(') ADVANCE(359);
      if (lookahead == ')') ADVANCE(360);
      if (lookahead == '*') ADVANCE(325);
      if (lookahead == '+') ADVANCE(390);
      if (lookahead == ',') ADVANCE(358);
      if (lookahead == '-') ADVANCE(390);
      if (lookahead == '/') ADVANCE(326);
      if (lookahead == ':') ADVANCE(366);
      if (lookahead == ';') ADVANCE(361);
      if (lookahead == '<') ADVANCE(332);
      if (lookahead == '=') ADVANCE(331);
      if (lookahead == '>') ADVANCE(330);
      if (lookahead == 'E') ADVANCE(389);
      if (lookahead == '^') ADVANCE(327);
      if (lookahead == 'e') ADVANCE(8);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(9);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(10);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(11);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(12);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(13);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(14);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(15);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(16);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(17);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(18);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(19);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(20);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(21);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(22);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(23);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(24);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(25);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(26);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(373);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(368);
      if (lookahead == '\r') ADVANCE(5);
      if (lookahead == ' ') ADVANCE(2);
      if (lookahead == '"') ADVANCE(244);
      if (lookahead == '$') ADVANCE(394);
      if (lookahead == '%') ADVANCE(393);
      if (lookahead == '(') ADVANCE(359);
      if (lookahead == '*') ADVANCE(325);
      if (lookahead == '+') ADVANCE(322);
      if (lookahead == ',') ADVANCE(358);
      if (lookahead == '-') ADVANCE(324);
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == '/') ADVANCE(326);
      if (lookahead == ':') ADVANCE(366);
      if (lookahead == ';') ADVANCE(361);
      if (lookahead == '<') ADVANCE(332);
      if (lookahead == '=') ADVANCE(331);
      if (lookahead == '>') ADVANCE(330);
      if (lookahead == 'A') ADVANCE(80);
      if (lookahead == '^') ADVANCE(327);
      if (lookahead == 'a') ADVANCE(81);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(82);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(111);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(96);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(239);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(95);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(17);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(242);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(218);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(83);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(84);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(85);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(86);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(24);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(211);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(368);
      if (lookahead == '\r') ADVANCE(5);
      if (lookahead == ' ') ADVANCE(3);
      if (lookahead == '$') ADVANCE(394);
      if (lookahead == '%') ADVANCE(393);
      if (lookahead == '(') ADVANCE(359);
      if (lookahead == ')') ADVANCE(360);
      if (lookahead == '*') ADVANCE(325);
      if (lookahead == '+') ADVANCE(321);
      if (lookahead == ',') ADVANCE(358);
      if (lookahead == '-') ADVANCE(323);
      if (lookahead == '/') ADVANCE(326);
      if (lookahead == ':') ADVANCE(366);
      if (lookahead == ';') ADVANCE(361);
      if (lookahead == '<') ADVANCE(332);
      if (lookahead == '=') ADVANCE(331);
      if (lookahead == '>') ADVANCE(330);
      if (lookahead == '^') ADVANCE(327);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(68);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(179);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(218);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(225);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(372);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(368);
      if (lookahead == '\r') ADVANCE(362);
      if (lookahead == ' ') ADVANCE(363);
      if (lookahead == ':') ADVANCE(367);
      if (lookahead != 0) ADVANCE(365);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(369);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(370);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(370);
      if (lookahead == '\r') ADVANCE(6);
      if (lookahead == ' ') ADVANCE(7);
      if (lookahead == ')') ADVANCE(360);
      if (lookahead == '*') ADVANCE(325);
      if (lookahead == '+') ADVANCE(321);
      if (lookahead == ',') ADVANCE(358);
      if (lookahead == '-') ADVANCE(323);
      if (lookahead == '/') ADVANCE(326);
      if (lookahead == ';') ADVANCE(361);
      if (lookahead == '<') ADVANCE(332);
      if (lookahead == '=') ADVANCE(331);
      if (lookahead == '>') ADVANCE(330);
      if (lookahead == '^') ADVANCE(327);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(68);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(69);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(11);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(198);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(70);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(13);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(14);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(92);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(93);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(229);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(19);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(71);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(72);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(73);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(74);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(75);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(26);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(372);
      END_STATE();
    case 8:
      if (lookahead == ' ') ADVANCE(8);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(99);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(29);
      END_STATE();
    case 9:
      if (lookahead == ' ') ADVANCE(9);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(97);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(125);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(30);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(318);
      END_STATE();
    case 10:
      if (lookahead == ' ') ADVANCE(10);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(31);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(32);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(33);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(34);
      END_STATE();
    case 11:
      if (lookahead == ' ') ADVANCE(11);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(35);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(36);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(37);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(98);
      END_STATE();
    case 12:
      if (lookahead == ' ') ADVANCE(12);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(124);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(315);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(103);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(104);
      END_STATE();
    case 13:
      if (lookahead == ' ') ADVANCE(13);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(105);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(38);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(257);
      END_STATE();
    case 14:
      if (lookahead == ' ') ADVANCE(14);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(39);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(128);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(106);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(94);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(235);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(102);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(140);
      END_STATE();
    case 15:
      if (lookahead == ' ') ADVANCE(15);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(294);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(40);
      END_STATE();
    case 16:
      if (lookahead == ' ') ADVANCE(16);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(41);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(123);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(42);
      END_STATE();
    case 17:
      if (lookahead == ' ') ADVANCE(17);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(141);
      END_STATE();
    case 18:
      if (lookahead == ' ') ADVANCE(18);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(43);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(44);
      END_STATE();
    case 19:
      if (lookahead == ' ') ADVANCE(19);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(301);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(329);
      END_STATE();
    case 20:
      if (lookahead == ' ') ADVANCE(20);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(127);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(129);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(107);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(45);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(46);
      END_STATE();
    case 21:
      if (lookahead == ' ') ADVANCE(21);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(47);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(48);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(153);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(130);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 22:
      if (lookahead == ' ') ADVANCE(22);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(50);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(51);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(110);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(234);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(133);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(52);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(143);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(91);
      END_STATE();
    case 23:
      if (lookahead == ' ') ADVANCE(23);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(53);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(54);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(314);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 24:
      if (lookahead == ' ') ADVANCE(24);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(155);
      END_STATE();
    case 25:
      if (lookahead == ' ') ADVANCE(25);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(142);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(232);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(164);
      END_STATE();
    case 26:
      if (lookahead == ' ') ADVANCE(26);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(122);
      END_STATE();
    case 27:
      if (lookahead == ' ') ADVANCE(27);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(167);
      END_STATE();
    case 28:
      if (lookahead == ' ') ADVANCE(28);
      if (lookahead == 'E') ADVANCE(389);
      END_STATE();
    case 29:
      if (lookahead == ' ') ADVANCE(29);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(344);
      END_STATE();
    case 30:
      if (lookahead == ' ') ADVANCE(30);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(353);
      END_STATE();
    case 31:
      if (lookahead == ' ') ADVANCE(31);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(154);
      END_STATE();
    case 32:
      if (lookahead == ' ') ADVANCE(32);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(56);
      END_STATE();
    case 33:
      if (lookahead == ' ') ADVANCE(33);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 34:
      if (lookahead == ' ') ADVANCE(34);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(132);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(145);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(345);
      END_STATE();
    case 35:
      if (lookahead == ' ') ADVANCE(35);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(181);
      END_STATE();
    case 36:
      if (lookahead == ' ') ADVANCE(36);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(305);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(254);
      END_STATE();
    case 37:
      if (lookahead == ' ') ADVANCE(37);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(255);
      END_STATE();
    case 38:
      if (lookahead == ' ') ADVANCE(38);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(58);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(147);
      END_STATE();
    case 39:
      if (lookahead == ' ') ADVANCE(39);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(240);
      END_STATE();
    case 40:
      if (lookahead == ' ') ADVANCE(40);
      if (lookahead == '#') ADVANCE(260);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(114);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(334);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(177);
      END_STATE();
    case 41:
      if (lookahead == ' ') ADVANCE(41);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(157);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(350);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(291);
      END_STATE();
    case 42:
      if (lookahead == ' ') ADVANCE(42);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(165);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(343);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(185);
      END_STATE();
    case 43:
      if (lookahead == ' ') ADVANCE(43);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(312);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(178);
      END_STATE();
    case 44:
      if (lookahead == ' ') ADVANCE(44);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(131);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(319);
      END_STATE();
    case 45:
      if (lookahead == ' ') ADVANCE(45);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(196);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(282);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(340);
      END_STATE();
    case 46:
      if (lookahead == ' ') ADVANCE(46);
      if (lookahead == '#') ADVANCE(259);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(160);
      END_STATE();
    case 47:
      if (lookahead == ' ') ADVANCE(47);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(174);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(188);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(299);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(61);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(135);
      END_STATE();
    case 48:
      if (lookahead == ' ') ADVANCE(48);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(62);
      END_STATE();
    case 49:
      if (lookahead == ' ') ADVANCE(49);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(293);
      END_STATE();
    case 50:
      if (lookahead == ' ') ADVANCE(50);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(201);
      END_STATE();
    case 51:
      if (lookahead == ' ') ADVANCE(51);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(166);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(171);
      END_STATE();
    case 52:
      if (lookahead == ' ') ADVANCE(52);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(64);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(205);
      END_STATE();
    case 53:
      if (lookahead == ' ') ADVANCE(53);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(118);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(347);
      END_STATE();
    case 54:
      if (lookahead == ' ') ADVANCE(54);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(192);
      END_STATE();
    case 55:
      if (lookahead == ' ') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(374);
      END_STATE();
    case 56:
      if (lookahead == ' ') ADVANCE(56);
      if (lookahead == '$') ADVANCE(354);
      END_STATE();
    case 57:
      if (lookahead == ' ') ADVANCE(57);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(269);
      END_STATE();
    case 58:
      if (lookahead == ' ') ADVANCE(58);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(136);
      END_STATE();
    case 59:
      if (lookahead == ' ') ADVANCE(59);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(271);
      END_STATE();
    case 60:
      if (lookahead == ' ') ADVANCE(60);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(349);
      END_STATE();
    case 61:
      if (lookahead == ' ') ADVANCE(61);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(243);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(241);
      END_STATE();
    case 62:
      if (lookahead == ' ') ADVANCE(62);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(214);
      END_STATE();
    case 63:
      if (lookahead == ' ') ADVANCE(63);
      if (lookahead == '=') ADVANCE(273);
      END_STATE();
    case 64:
      if (lookahead == ' ') ADVANCE(64);
      if (lookahead == '(') ADVANCE(316);
      END_STATE();
    case 65:
      if (lookahead == ' ') ADVANCE(65);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(300);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(213);
      END_STATE();
    case 66:
      if (lookahead == ' ') ADVANCE(66);
      if (lookahead == '2') ADVANCE(265);
      END_STATE();
    case 67:
      if (lookahead == ' ') ADVANCE(67);
      if (lookahead == ':') ADVANCE(284);
      END_STATE();
    case 68:
      if (lookahead == ' ') ADVANCE(68);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(125);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(318);
      END_STATE();
    case 69:
      if (lookahead == ' ') ADVANCE(69);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(31);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(33);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(76);
      END_STATE();
    case 70:
      if (lookahead == ' ') ADVANCE(70);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(124);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(103);
      END_STATE();
    case 71:
      if (lookahead == ' ') ADVANCE(71);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(107);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(79);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(46);
      END_STATE();
    case 72:
      if (lookahead == ' ') ADVANCE(72);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(47);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(130);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 73:
      if (lookahead == ' ') ADVANCE(73);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(50);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(207);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(234);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(226);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(170);
      END_STATE();
    case 74:
      if (lookahead == ' ') ADVANCE(74);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(54);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(314);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 75:
      if (lookahead == ' ') ADVANCE(75);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(232);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(164);
      END_STATE();
    case 76:
      if (lookahead == ' ') ADVANCE(76);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(132);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(145);
      END_STATE();
    case 77:
      if (lookahead == ' ') ADVANCE(77);
      if (lookahead == '#') ADVANCE(260);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(114);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(177);
      END_STATE();
    case 78:
      if (lookahead == ' ') ADVANCE(78);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(165);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(185);
      END_STATE();
    case 79:
      if (lookahead == ' ') ADVANCE(79);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(196);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(282);
      END_STATE();
    case 80:
      if (lookahead == ' ') ADVANCE(80);
      if (lookahead == 'T') ADVANCE(246);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(97);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(125);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(30);
      END_STATE();
    case 81:
      if (lookahead == ' ') ADVANCE(81);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(97);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(125);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(30);
      END_STATE();
    case 82:
      if (lookahead == ' ') ADVANCE(82);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(32);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(163);
      END_STATE();
    case 83:
      if (lookahead == ' ') ADVANCE(83);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(127);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(129);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(172);
      END_STATE();
    case 84:
      if (lookahead == ' ') ADVANCE(84);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(48);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(153);
      END_STATE();
    case 85:
      if (lookahead == ' ') ADVANCE(85);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(221);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(110);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(133);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(126);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(143);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(231);
      END_STATE();
    case 86:
      if (lookahead == ' ') ADVANCE(86);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(53);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(314);
      END_STATE();
    case 87:
      if (lookahead == ' ') ADVANCE(87);
      if (lookahead == '.') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(245);
      END_STATE();
    case 88:
      if (lookahead == ' ') ADVANCE(88);
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == 'E') ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      END_STATE();
    case 89:
      if (lookahead == ' ') ADVANCE(377);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == 'E') ADVANCE(389);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(391);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(376);
      if (('!' <= lookahead && lookahead <= '*') ||
          ('/' <= lookahead && lookahead <= '~')) ADVANCE(382);
      END_STATE();
    case 90:
      if (lookahead == ' ') ADVANCE(364);
      if (lookahead == ':') ADVANCE(367);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(365);
      END_STATE();
    case 91:
      if (lookahead == ' ') ADVANCE(91);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(100);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(65);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(134);
      END_STATE();
    case 92:
      if (lookahead == ' ') ADVANCE(92);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(294);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 93:
      if (lookahead == ' ') ADVANCE(93);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(217);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(123);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(78);
      END_STATE();
    case 94:
      if (lookahead == ' ') ADVANCE(94);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(148);
      END_STATE();
    case 95:
      if (lookahead == ' ') ADVANCE(95);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(121);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(109);
      END_STATE();
    case 96:
      if (lookahead == ' ') ADVANCE(96);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(315);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(104);
      END_STATE();
    case 97:
      if (lookahead == ' ') ADVANCE(97);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(335);
      END_STATE();
    case 98:
      if (lookahead == ' ') ADVANCE(98);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(57);
      END_STATE();
    case 99:
      if (lookahead == ' ') ADVANCE(99);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(249);
      END_STATE();
    case 100:
      if (lookahead == ' ') ADVANCE(100);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(320);
      END_STATE();
    case 101:
      if (lookahead == ' ') ADVANCE(101);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(216);
      END_STATE();
    case 102:
      if (lookahead == ' ') ADVANCE(102);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(236);
      END_STATE();
    case 103:
      if (lookahead == ' ') ADVANCE(103);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(250);
      END_STATE();
    case 104:
      if (lookahead == ' ') ADVANCE(104);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(337);
      END_STATE();
    case 105:
      if (lookahead == ' ') ADVANCE(105);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(311);
      END_STATE();
    case 106:
      if (lookahead == ' ') ADVANCE(106);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(156);
      END_STATE();
    case 107:
      if (lookahead == ' ') ADVANCE(107);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(186);
      END_STATE();
    case 108:
      if (lookahead == ' ') ADVANCE(108);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(131);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(215);
      END_STATE();
    case 109:
      if (lookahead == ' ') ADVANCE(109);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(343);
      END_STATE();
    case 110:
      if (lookahead == ' ') ADVANCE(110);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(333);
      END_STATE();
    case 111:
      if (lookahead == ' ') ADVANCE(111);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(29);
      END_STATE();
    case 112:
      if (lookahead == ' ') ADVANCE(112);
      if (lookahead == '$') ADVANCE(357);
      END_STATE();
    case 113:
      if (lookahead == ' ') ADVANCE(113);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(270);
      END_STATE();
    case 114:
      if (lookahead == ' ') ADVANCE(114);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(206);
      END_STATE();
    case 115:
      if (lookahead == ' ') ADVANCE(115);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(283);
      END_STATE();
    case 116:
      if (lookahead == ' ') ADVANCE(116);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(280);
      END_STATE();
    case 117:
      if (lookahead == ' ') ADVANCE(117);
      if (lookahead == '=') ADVANCE(281);
      END_STATE();
    case 118:
      if (lookahead == ' ') ADVANCE(118);
      if (lookahead == '(') ADVANCE(313);
      END_STATE();
    case 119:
      if (lookahead == ' ') ADVANCE(119);
      if (lookahead == ':') ADVANCE(285);
      END_STATE();
    case 120:
      if (lookahead == ' ') ADVANCE(120);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(314);
      END_STATE();
    case 121:
      if (lookahead == ' ') ADVANCE(121);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(157);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(350);
      END_STATE();
    case 122:
      if (lookahead == ' ') ADVANCE(122);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(197);
      END_STATE();
    case 123:
      if (lookahead == ' ') ADVANCE(123);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(169);
      END_STATE();
    case 124:
      if (lookahead == ' ') ADVANCE(124);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(139);
      END_STATE();
    case 125:
      if (lookahead == ' ') ADVANCE(125);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(328);
      END_STATE();
    case 126:
      if (lookahead == ' ') ADVANCE(126);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(64);
      END_STATE();
    case 127:
      if (lookahead == ' ') ADVANCE(127);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(339);
      END_STATE();
    case 128:
      if (lookahead == ' ') ADVANCE(128);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(266);
      END_STATE();
    case 129:
      if (lookahead == ' ') ADVANCE(129);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 130:
      if (lookahead == ' ') ADVANCE(130);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(63);
      END_STATE();
    case 131:
      if (lookahead == ' ') ADVANCE(131);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(199);
      END_STATE();
    case 132:
      if (lookahead == ' ') ADVANCE(132);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(190);
      END_STATE();
    case 133:
      if (lookahead == ' ') ADVANCE(133);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(346);
      END_STATE();
    case 134:
      if (lookahead == ' ') ADVANCE(134);
      if (lookahead == '$') ADVANCE(351);
      END_STATE();
    case 135:
      if (lookahead == ' ') ADVANCE(135);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(204);
      END_STATE();
    case 136:
      if (lookahead == ' ') ADVANCE(136);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(297);
      END_STATE();
    case 137:
      if (lookahead == ' ') ADVANCE(137);
      if (lookahead == '=') ADVANCE(274);
      END_STATE();
    case 138:
      if (lookahead == ' ') ADVANCE(138);
      if (lookahead == '(') ADVANCE(338);
      END_STATE();
    case 139:
      if (lookahead == ' ') ADVANCE(139);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(116);
      END_STATE();
    case 140:
      if (lookahead == ' ') ADVANCE(140);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(59);
      END_STATE();
    case 141:
      if (lookahead == ' ') ADVANCE(141);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(112);
      END_STATE();
    case 142:
      if (lookahead == ' ') ADVANCE(142);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(352);
      END_STATE();
    case 143:
      if (lookahead == ' ') ADVANCE(143);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(341);
      END_STATE();
    case 144:
      if (lookahead == ' ') ADVANCE(144);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 145:
      if (lookahead == ' ') ADVANCE(145);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(308);
      END_STATE();
    case 146:
      if (lookahead == ' ') ADVANCE(146);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(67);
      END_STATE();
    case 147:
      if (lookahead == ' ') ADVANCE(147);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(292);
      END_STATE();
    case 148:
      if (lookahead == ' ') ADVANCE(148);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(263);
      END_STATE();
    case 149:
      if (lookahead == ' ') ADVANCE(149);
      if (lookahead == '$') ADVANCE(355);
      END_STATE();
    case 150:
      if (lookahead == ' ') ADVANCE(150);
      if (lookahead == '=') ADVANCE(290);
      END_STATE();
    case 151:
      if (lookahead == ' ') ADVANCE(151);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(222);
      END_STATE();
    case 152:
      if (lookahead == ' ') ADVANCE(152);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 153:
      if (lookahead == ' ') ADVANCE(153);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(342);
      END_STATE();
    case 154:
      if (lookahead == ' ') ADVANCE(154);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(261);
      END_STATE();
    case 155:
      if (lookahead == ' ') ADVANCE(155);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(336);
      END_STATE();
    case 156:
      if (lookahead == ' ') ADVANCE(156);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(146);
      END_STATE();
    case 157:
      if (lookahead == ' ') ADVANCE(157);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(149);
      END_STATE();
    case 158:
      if (lookahead == ' ') ADVANCE(158);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(119);
      END_STATE();
    case 159:
      if (lookahead == ' ') ADVANCE(159);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(203);
      END_STATE();
    case 160:
      if (lookahead == ' ') ADVANCE(160);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(210);
      END_STATE();
    case 161:
      if (lookahead == ' ') ADVANCE(161);
      if (lookahead == '$') ADVANCE(356);
      END_STATE();
    case 162:
      if (lookahead == ' ') ADVANCE(162);
      if (lookahead == '=') ADVANCE(267);
      END_STATE();
    case 163:
      if (lookahead == ' ') ADVANCE(163);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(345);
      END_STATE();
    case 164:
      if (lookahead == ' ') ADVANCE(164);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(115);
      END_STATE();
    case 165:
      if (lookahead == ' ') ADVANCE(165);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(303);
      END_STATE();
    case 166:
      if (lookahead == ' ') ADVANCE(166);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(209);
      END_STATE();
    case 167:
      if (lookahead == ' ') ADVANCE(167);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(194);
      END_STATE();
    case 168:
      if (lookahead == ' ') ADVANCE(168);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(272);
      END_STATE();
    case 169:
      if (lookahead == ' ') ADVANCE(169);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(309);
      END_STATE();
    case 170:
      if (lookahead == ' ') ADVANCE(170);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(65);
      END_STATE();
    case 171:
      if (lookahead == ' ') ADVANCE(171);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(138);
      END_STATE();
    case 172:
      if (lookahead == ' ') ADVANCE(172);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(340);
      END_STATE();
    case 173:
      if (lookahead == ' ') ADVANCE(173);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 174:
      if (lookahead == ' ') ADVANCE(174);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(256);
      END_STATE();
    case 175:
      if (lookahead == ' ') ADVANCE(175);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(278);
      END_STATE();
    case 176:
      if (lookahead == ' ') ADVANCE(176);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(200);
      END_STATE();
    case 177:
      if (lookahead == ' ') ADVANCE(177);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(195);
      END_STATE();
    case 178:
      if (lookahead == ' ') ADVANCE(178);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(251);
      END_STATE();
    case 179:
      if (lookahead == ' ') ADVANCE(179);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(38);
      END_STATE();
    case 180:
      if (lookahead == ' ') ADVANCE(180);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(317);
      END_STATE();
    case 181:
      if (lookahead == ' ') ADVANCE(181);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(252);
      END_STATE();
    case 182:
      if (lookahead == ' ') ADVANCE(182);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(150);
      END_STATE();
    case 183:
      if (lookahead == ' ') ADVANCE(183);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(288);
      END_STATE();
    case 184:
      if (lookahead == ' ') ADVANCE(184);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(310);
      END_STATE();
    case 185:
      if (lookahead == ' ') ADVANCE(185);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 186:
      if (lookahead == ' ') ADVANCE(186);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(262);
      END_STATE();
    case 187:
      if (lookahead == ' ') ADVANCE(187);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(264);
      END_STATE();
    case 188:
      if (lookahead == ' ') ADVANCE(188);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(230);
      END_STATE();
    case 189:
      if (lookahead == ' ') ADVANCE(189);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(275);
      END_STATE();
    case 190:
      if (lookahead == ' ') ADVANCE(190);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 191:
      if (lookahead == ' ') ADVANCE(191);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(176);
      END_STATE();
    case 192:
      if (lookahead == ' ') ADVANCE(192);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(258);
      END_STATE();
    case 193:
      if (lookahead == ' ') ADVANCE(193);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(298);
      END_STATE();
    case 194:
      if (lookahead == ' ') ADVANCE(194);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 195:
      if (lookahead == ' ') ADVANCE(195);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(151);
      END_STATE();
    case 196:
      if (lookahead == ' ') ADVANCE(196);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(306);
      END_STATE();
    case 197:
      if (lookahead == ' ') ADVANCE(197);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(302);
      END_STATE();
    case 198:
      if (lookahead == ' ') ADVANCE(198);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(99);
      END_STATE();
    case 199:
      if (lookahead == ' ') ADVANCE(199);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(175);
      END_STATE();
    case 200:
      if (lookahead == ' ') ADVANCE(200);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(286);
      END_STATE();
    case 201:
      if (lookahead == ' ') ADVANCE(201);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(304);
      END_STATE();
    case 202:
      if (lookahead == ' ') ADVANCE(202);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(268);
      END_STATE();
    case 203:
      if (lookahead == ' ') ADVANCE(203);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(189);
      END_STATE();
    case 204:
      if (lookahead == ' ') ADVANCE(204);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(193);
      END_STATE();
    case 205:
      if (lookahead == ' ') ADVANCE(205);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 206:
      if (lookahead == ' ') ADVANCE(206);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(253);
      END_STATE();
    case 207:
      if (lookahead == ' ') ADVANCE(207);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(166);
      END_STATE();
    case 208:
      if (lookahead == ' ') ADVANCE(208);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(162);
      END_STATE();
    case 209:
      if (lookahead == ' ') ADVANCE(209);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(137);
      END_STATE();
    case 210:
      if (lookahead == ' ') ADVANCE(210);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(307);
      END_STATE();
    case 211:
      if (lookahead == ' ') ADVANCE(211);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(142);
      END_STATE();
    case 212:
      if (lookahead == ' ') ADVANCE(212);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(224);
      END_STATE();
    case 213:
      if (lookahead == ' ') ADVANCE(213);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(289);
      END_STATE();
    case 214:
      if (lookahead == ' ') ADVANCE(214);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(161);
      END_STATE();
    case 215:
      if (lookahead == ' ') ADVANCE(215);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(238);
      END_STATE();
    case 216:
      if (lookahead == ' ') ADVANCE(216);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(276);
      END_STATE();
    case 217:
      if (lookahead == ' ') ADVANCE(217);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(291);
      END_STATE();
    case 218:
      if (lookahead == ' ') ADVANCE(218);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(329);
      END_STATE();
    case 219:
      if (lookahead == ' ') ADVANCE(219);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(287);
      END_STATE();
    case 220:
      if (lookahead == ' ') ADVANCE(220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(334);
      END_STATE();
    case 221:
      if (lookahead == ' ') ADVANCE(221);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(171);
      END_STATE();
    case 222:
      if (lookahead == ' ') ADVANCE(222);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(279);
      END_STATE();
    case 223:
      if (lookahead == ' ') ADVANCE(223);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(319);
      END_STATE();
    case 224:
      if (lookahead == ' ') ADVANCE(224);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(295);
      END_STATE();
    case 225:
      if (lookahead == ' ') ADVANCE(225);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(228);
      END_STATE();
    case 226:
      if (lookahead == ' ') ADVANCE(226);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(205);
      END_STATE();
    case 227:
      if (lookahead == ' ') ADVANCE(227);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(277);
      END_STATE();
    case 228:
      if (lookahead == ' ') ADVANCE(228);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 229:
      if (lookahead == ' ') ADVANCE(229);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(43);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(108);
      END_STATE();
    case 230:
      if (lookahead == ' ') ADVANCE(230);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(183);
      END_STATE();
    case 231:
      if (lookahead == ' ') ADVANCE(231);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(134);
      END_STATE();
    case 232:
      if (lookahead == ' ') ADVANCE(232);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(187);
      END_STATE();
    case 233:
      if (lookahead == ' ') ADVANCE(233);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(227);
      END_STATE();
    case 234:
      if (lookahead == ' ') ADVANCE(234);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(159);
      END_STATE();
    case 235:
      if (lookahead == ' ') ADVANCE(235);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(168);
      END_STATE();
    case 236:
      if (lookahead == ' ') ADVANCE(236);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(202);
      END_STATE();
    case 237:
      if (lookahead == ' ') ADVANCE(237);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(208);
      END_STATE();
    case 238:
      if (lookahead == ' ') ADVANCE(238);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(233);
      END_STATE();
    case 239:
      if (lookahead == ' ') ADVANCE(239);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(220);
      END_STATE();
    case 240:
      if (lookahead == ' ') ADVANCE(240);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(237);
      END_STATE();
    case 241:
      if (lookahead == ' ') ADVANCE(241);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(219);
      END_STATE();
    case 242:
      if (lookahead == ' ') ADVANCE(242);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(223);
      END_STATE();
    case 243:
      if (lookahead == ' ') ADVANCE(243);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(212);
      END_STATE();
    case 244:
      if (lookahead == '"') ADVANCE(392);
      if ((' ' <= lookahead && lookahead <= '~')) ADVANCE(244);
      END_STATE();
    case 245:
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == 'E') ADVANCE(384);
      if (lookahead == ' ' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(245);
      END_STATE();
    case 246:
      if (lookahead == 'N') ADVANCE(348);
      END_STATE();
    case 247:
      if (eof) ADVANCE(248);
      if (lookahead == '\n') ADVANCE(370);
      if (lookahead == '\r') ADVANCE(6);
      if (lookahead == ' ') ADVANCE(7);
      if (lookahead == ')') ADVANCE(360);
      if (lookahead == '*') ADVANCE(325);
      if (lookahead == '+') ADVANCE(321);
      if (lookahead == ',') ADVANCE(358);
      if (lookahead == '-') ADVANCE(323);
      if (lookahead == '/') ADVANCE(326);
      if (lookahead == ';') ADVANCE(361);
      if (lookahead == '<') ADVANCE(332);
      if (lookahead == '=') ADVANCE(331);
      if (lookahead == '>') ADVANCE(330);
      if (lookahead == '^') ADVANCE(327);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(68);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(69);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(11);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(198);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(70);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(13);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(14);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(92);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(93);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(229);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(19);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(71);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(72);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(73);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(74);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(75);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(26);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(372);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_end_tok);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_for_tok);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_next_tok);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_data_tok);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_input_tok);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_del_tok);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_dim_tok);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_read_tok);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_gr_tok);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_text_tok);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_prn_tok);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_inn_tok);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_call_tok);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_plot_tok);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_hlin_tok);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_vlin_tok);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_hgr2_tok);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_hgr_tok);
      if (lookahead == ' ') ADVANCE(66);
      if (lookahead == '2') ADVANCE(265);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_hcoloreq_tok);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_hplot_tok);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_draw_tok);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_xdraw_tok);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_htab_tok);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_home_tok);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_roteq_tok);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_scaleeq_tok);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_shload_tok);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_trace_tok);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_notrace_tok);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_normal_tok);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_inverse_tok);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_flash_tok);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_coloreq_tok);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_pop_tok);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_vtab_tok);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_himem_tok);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_lomem_tok);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_onerr_tok);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_resume_tok);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_recall_tok);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_store_tok);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_speedeq_tok);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_let_tok);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_goto_tok);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_run_tok);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_if_tok);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_restore_tok);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_amp_tok);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_gosub_tok);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_return_tok);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_rem_tok);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_stop_tok);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_on_tok);
      if (lookahead == ' ') ADVANCE(191);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(176);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_wait_tok);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_load_tok);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_save_tok);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_def_tok);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_poke_tok);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_print_tok);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_cont_tok);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_list_tok);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_clear_tok);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_get_tok);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_new_tok);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_tabp_tok);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_to_tok);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_fn_tok);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_spcp_tok);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_then_tok);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_at_tok);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_not_tok);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_step_tok);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_plus_tok);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_plus_tok);
      if (lookahead == ' ') ADVANCE(87);
      if (lookahead == '.') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_minus_tok);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_minus_tok);
      if (lookahead == ' ') ADVANCE(87);
      if (lookahead == '.') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_times_tok);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_div_tok);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_pow_tok);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_and_tok);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_or_tok);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_gtr_tok);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_eq_tok);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_less_tok);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_sgn_tok);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_int_tok);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_abs_tok);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_usr_tok);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_fre_tok);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_scrnp_tok);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_pdl_tok);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_pos_tok);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_sqr_tok);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_rnd_tok);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_log_tok);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_exp_tok);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_cos_tok);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_sin_tok);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_tan_tok);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_atn_tok);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_peek_tok);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_len_tok);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_str_tok);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_val_tok);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_asc_tok);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_chr_tok);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_left_tok);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_right_tok);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_mid_tok);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_comment_text);
      if (lookahead == '\n') ADVANCE(369);
      if (lookahead != 0) ADVANCE(365);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_comment_text);
      if (lookahead == '\r') ADVANCE(362);
      if (lookahead == ' ') ADVANCE(363);
      if (lookahead == ':') ADVANCE(367);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(365);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_comment_text);
      if (lookahead == ' ') ADVANCE(364);
      if (lookahead == ':') ADVANCE(367);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(365);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_comment_text);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(365);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(365);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_LF);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_CR_LF);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym__empty_line);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_linenum);
      if (lookahead == ' ') ADVANCE(371);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(373);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_linenum);
      if (lookahead == ' ' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(372);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == ' ') ADVANCE(371);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(373);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == ' ') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(374);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == ' ') ADVANCE(88);
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == 'E') ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == ' ') ADVANCE(379);
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == 'E') ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(376);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_literal);
      if (lookahead == ' ') ADVANCE(377);
      if (lookahead == '"') ADVANCE(380);
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == 'E') ADVANCE(389);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(391);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(376);
      if (('!' <= lookahead && lookahead <= '*') ||
          ('/' <= lookahead && lookahead <= '~')) ADVANCE(382);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_literal);
      if (lookahead == ' ') ADVANCE(378);
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == 'E') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(381);
      if (('!' <= lookahead && lookahead <= '+') ||
          ('-' <= lookahead && lookahead <= '~')) ADVANCE(382);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_literal);
      if (lookahead == ' ') ADVANCE(379);
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == 'E') ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(376);
      if (('!' <= lookahead && lookahead <= '+') ||
          ('-' <= lookahead && lookahead <= '~')) ADVANCE(382);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_literal);
      if (lookahead == '"') ADVANCE(392);
      if (lookahead == ',') ADVANCE(244);
      if ((' ' <= lookahead && lookahead <= '~')) ADVANCE(380);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_literal);
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == 'E') ADVANCE(384);
      if (lookahead == ' ' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(381);
      if (('!' <= lookahead && lookahead <= '+') ||
          ('-' <= lookahead && lookahead <= '~')) ADVANCE(382);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_literal);
      if ((' ' <= lookahead && lookahead <= '+') ||
          ('-' <= lookahead && lookahead <= '~')) ADVANCE(382);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_real);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_real);
      if (lookahead == ' ') ADVANCE(384);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(385);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(386);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_real);
      if (lookahead == ' ') ADVANCE(385);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(386);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_real);
      if (lookahead == ' ') ADVANCE(386);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(383);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_real);
      if (lookahead == 'E') ADVANCE(384);
      if (lookahead == ' ' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(387);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_real_data_item);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_real_data_item);
      if (lookahead == ' ') ADVANCE(389);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(388);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_real_data_item);
      if (lookahead == ' ') ADVANCE(28);
      if (lookahead == 'E') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(374);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_real_data_item);
      if (lookahead == ' ') ADVANCE(378);
      if (lookahead == '.') ADVANCE(387);
      if (lookahead == 'E') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(376);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 247},
  [2] = {.lex_state = 247, .external_lex_state = 1},
  [3] = {.lex_state = 247, .external_lex_state = 1},
  [4] = {.lex_state = 247, .external_lex_state = 1},
  [5] = {.lex_state = 247, .external_lex_state = 1},
  [6] = {.lex_state = 247, .external_lex_state = 1},
  [7] = {.lex_state = 247, .external_lex_state = 1},
  [8] = {.lex_state = 2, .external_lex_state = 1},
  [9] = {.lex_state = 2, .external_lex_state = 1},
  [10] = {.lex_state = 2, .external_lex_state = 1},
  [11] = {.lex_state = 2, .external_lex_state = 1},
  [12] = {.lex_state = 2, .external_lex_state = 1},
  [13] = {.lex_state = 2, .external_lex_state = 1},
  [14] = {.lex_state = 2, .external_lex_state = 1},
  [15] = {.lex_state = 2, .external_lex_state = 1},
  [16] = {.lex_state = 2, .external_lex_state = 1},
  [17] = {.lex_state = 2, .external_lex_state = 1},
  [18] = {.lex_state = 2, .external_lex_state = 1},
  [19] = {.lex_state = 2, .external_lex_state = 1},
  [20] = {.lex_state = 2, .external_lex_state = 1},
  [21] = {.lex_state = 2, .external_lex_state = 1},
  [22] = {.lex_state = 2, .external_lex_state = 1},
  [23] = {.lex_state = 2, .external_lex_state = 1},
  [24] = {.lex_state = 2, .external_lex_state = 1},
  [25] = {.lex_state = 2, .external_lex_state = 1},
  [26] = {.lex_state = 2, .external_lex_state = 1},
  [27] = {.lex_state = 2, .external_lex_state = 1},
  [28] = {.lex_state = 2, .external_lex_state = 1},
  [29] = {.lex_state = 2, .external_lex_state = 1},
  [30] = {.lex_state = 2, .external_lex_state = 1},
  [31] = {.lex_state = 2, .external_lex_state = 1},
  [32] = {.lex_state = 2, .external_lex_state = 1},
  [33] = {.lex_state = 2, .external_lex_state = 1},
  [34] = {.lex_state = 2, .external_lex_state = 1},
  [35] = {.lex_state = 2, .external_lex_state = 1},
  [36] = {.lex_state = 2, .external_lex_state = 1},
  [37] = {.lex_state = 2, .external_lex_state = 1},
  [38] = {.lex_state = 2, .external_lex_state = 1},
  [39] = {.lex_state = 2, .external_lex_state = 1},
  [40] = {.lex_state = 2, .external_lex_state = 1},
  [41] = {.lex_state = 2, .external_lex_state = 1},
  [42] = {.lex_state = 2, .external_lex_state = 1},
  [43] = {.lex_state = 2, .external_lex_state = 1},
  [44] = {.lex_state = 2, .external_lex_state = 1},
  [45] = {.lex_state = 2, .external_lex_state = 1},
  [46] = {.lex_state = 2, .external_lex_state = 1},
  [47] = {.lex_state = 2, .external_lex_state = 1},
  [48] = {.lex_state = 2, .external_lex_state = 1},
  [49] = {.lex_state = 2, .external_lex_state = 1},
  [50] = {.lex_state = 2, .external_lex_state = 1},
  [51] = {.lex_state = 2, .external_lex_state = 1},
  [52] = {.lex_state = 2, .external_lex_state = 1},
  [53] = {.lex_state = 2, .external_lex_state = 1},
  [54] = {.lex_state = 2, .external_lex_state = 1},
  [55] = {.lex_state = 2, .external_lex_state = 1},
  [56] = {.lex_state = 2, .external_lex_state = 1},
  [57] = {.lex_state = 2, .external_lex_state = 1},
  [58] = {.lex_state = 2, .external_lex_state = 1},
  [59] = {.lex_state = 2, .external_lex_state = 1},
  [60] = {.lex_state = 2, .external_lex_state = 1},
  [61] = {.lex_state = 2, .external_lex_state = 1},
  [62] = {.lex_state = 2, .external_lex_state = 1},
  [63] = {.lex_state = 2, .external_lex_state = 1},
  [64] = {.lex_state = 2, .external_lex_state = 1},
  [65] = {.lex_state = 2, .external_lex_state = 1},
  [66] = {.lex_state = 2, .external_lex_state = 1},
  [67] = {.lex_state = 2, .external_lex_state = 1},
  [68] = {.lex_state = 2, .external_lex_state = 1},
  [69] = {.lex_state = 2, .external_lex_state = 1},
  [70] = {.lex_state = 2, .external_lex_state = 1},
  [71] = {.lex_state = 2, .external_lex_state = 1},
  [72] = {.lex_state = 2, .external_lex_state = 1},
  [73] = {.lex_state = 2, .external_lex_state = 1},
  [74] = {.lex_state = 2, .external_lex_state = 1},
  [75] = {.lex_state = 2, .external_lex_state = 1},
  [76] = {.lex_state = 2, .external_lex_state = 1},
  [77] = {.lex_state = 2, .external_lex_state = 1},
  [78] = {.lex_state = 2, .external_lex_state = 1},
  [79] = {.lex_state = 2, .external_lex_state = 1},
  [80] = {.lex_state = 2, .external_lex_state = 1},
  [81] = {.lex_state = 2, .external_lex_state = 1},
  [82] = {.lex_state = 2, .external_lex_state = 1},
  [83] = {.lex_state = 2, .external_lex_state = 1},
  [84] = {.lex_state = 2, .external_lex_state = 1},
  [85] = {.lex_state = 2, .external_lex_state = 1},
  [86] = {.lex_state = 2, .external_lex_state = 1},
  [87] = {.lex_state = 2, .external_lex_state = 1},
  [88] = {.lex_state = 2, .external_lex_state = 1},
  [89] = {.lex_state = 2, .external_lex_state = 1},
  [90] = {.lex_state = 2, .external_lex_state = 1},
  [91] = {.lex_state = 2, .external_lex_state = 1},
  [92] = {.lex_state = 2, .external_lex_state = 1},
  [93] = {.lex_state = 2, .external_lex_state = 1},
  [94] = {.lex_state = 2, .external_lex_state = 1},
  [95] = {.lex_state = 2, .external_lex_state = 1},
  [96] = {.lex_state = 2, .external_lex_state = 1},
  [97] = {.lex_state = 2, .external_lex_state = 1},
  [98] = {.lex_state = 2, .external_lex_state = 1},
  [99] = {.lex_state = 2, .external_lex_state = 1},
  [100] = {.lex_state = 2, .external_lex_state = 1},
  [101] = {.lex_state = 2, .external_lex_state = 1},
  [102] = {.lex_state = 2, .external_lex_state = 1},
  [103] = {.lex_state = 2, .external_lex_state = 1},
  [104] = {.lex_state = 2, .external_lex_state = 1},
  [105] = {.lex_state = 2, .external_lex_state = 1},
  [106] = {.lex_state = 2, .external_lex_state = 1},
  [107] = {.lex_state = 2, .external_lex_state = 1},
  [108] = {.lex_state = 2, .external_lex_state = 1},
  [109] = {.lex_state = 2, .external_lex_state = 1},
  [110] = {.lex_state = 2, .external_lex_state = 1},
  [111] = {.lex_state = 0, .external_lex_state = 1},
  [112] = {.lex_state = 3},
  [113] = {.lex_state = 3},
  [114] = {.lex_state = 3},
  [115] = {.lex_state = 3},
  [116] = {.lex_state = 3},
  [117] = {.lex_state = 3},
  [118] = {.lex_state = 3},
  [119] = {.lex_state = 3},
  [120] = {.lex_state = 3},
  [121] = {.lex_state = 3},
  [122] = {.lex_state = 3},
  [123] = {.lex_state = 3},
  [124] = {.lex_state = 3},
  [125] = {.lex_state = 3},
  [126] = {.lex_state = 3},
  [127] = {.lex_state = 3},
  [128] = {.lex_state = 3},
  [129] = {.lex_state = 3},
  [130] = {.lex_state = 3},
  [131] = {.lex_state = 3},
  [132] = {.lex_state = 3},
  [133] = {.lex_state = 3},
  [134] = {.lex_state = 3},
  [135] = {.lex_state = 3},
  [136] = {.lex_state = 3},
  [137] = {.lex_state = 3},
  [138] = {.lex_state = 3},
  [139] = {.lex_state = 3},
  [140] = {.lex_state = 3},
  [141] = {.lex_state = 0, .external_lex_state = 1},
  [142] = {.lex_state = 0, .external_lex_state = 1},
  [143] = {.lex_state = 0, .external_lex_state = 1},
  [144] = {.lex_state = 0, .external_lex_state = 1},
  [145] = {.lex_state = 0, .external_lex_state = 1},
  [146] = {.lex_state = 0, .external_lex_state = 1},
  [147] = {.lex_state = 0, .external_lex_state = 1},
  [148] = {.lex_state = 0, .external_lex_state = 1},
  [149] = {.lex_state = 0, .external_lex_state = 1},
  [150] = {.lex_state = 0, .external_lex_state = 1},
  [151] = {.lex_state = 0, .external_lex_state = 1},
  [152] = {.lex_state = 0, .external_lex_state = 1},
  [153] = {.lex_state = 0, .external_lex_state = 1},
  [154] = {.lex_state = 0, .external_lex_state = 1},
  [155] = {.lex_state = 3},
  [156] = {.lex_state = 3},
  [157] = {.lex_state = 3},
  [158] = {.lex_state = 3},
  [159] = {.lex_state = 3},
  [160] = {.lex_state = 3},
  [161] = {.lex_state = 3},
  [162] = {.lex_state = 247},
  [163] = {.lex_state = 3},
  [164] = {.lex_state = 247},
  [165] = {.lex_state = 247},
  [166] = {.lex_state = 3},
  [167] = {.lex_state = 3},
  [168] = {.lex_state = 3},
  [169] = {.lex_state = 3},
  [170] = {.lex_state = 247},
  [171] = {.lex_state = 0, .external_lex_state = 1},
  [172] = {.lex_state = 247},
  [173] = {.lex_state = 0, .external_lex_state = 1},
  [174] = {.lex_state = 247},
  [175] = {.lex_state = 0, .external_lex_state = 1},
  [176] = {.lex_state = 247},
  [177] = {.lex_state = 247},
  [178] = {.lex_state = 0, .external_lex_state = 1},
  [179] = {.lex_state = 247},
  [180] = {.lex_state = 247},
  [181] = {.lex_state = 247},
  [182] = {.lex_state = 247},
  [183] = {.lex_state = 247},
  [184] = {.lex_state = 247},
  [185] = {.lex_state = 247},
  [186] = {.lex_state = 247},
  [187] = {.lex_state = 2, .external_lex_state = 1},
  [188] = {.lex_state = 247},
  [189] = {.lex_state = 247},
  [190] = {.lex_state = 247},
  [191] = {.lex_state = 247},
  [192] = {.lex_state = 247},
  [193] = {.lex_state = 247},
  [194] = {.lex_state = 0, .external_lex_state = 1},
  [195] = {.lex_state = 247},
  [196] = {.lex_state = 247},
  [197] = {.lex_state = 247},
  [198] = {.lex_state = 247},
  [199] = {.lex_state = 247},
  [200] = {.lex_state = 247},
  [201] = {.lex_state = 247},
  [202] = {.lex_state = 247},
  [203] = {.lex_state = 247},
  [204] = {.lex_state = 0, .external_lex_state = 1},
  [205] = {.lex_state = 247},
  [206] = {.lex_state = 247},
  [207] = {.lex_state = 0, .external_lex_state = 1},
  [208] = {.lex_state = 2},
  [209] = {.lex_state = 247},
  [210] = {.lex_state = 247},
  [211] = {.lex_state = 89},
  [212] = {.lex_state = 247},
  [213] = {.lex_state = 3},
  [214] = {.lex_state = 3},
  [215] = {.lex_state = 89},
  [216] = {.lex_state = 247},
  [217] = {.lex_state = 2},
  [218] = {.lex_state = 2},
  [219] = {.lex_state = 247},
  [220] = {.lex_state = 2},
  [221] = {.lex_state = 2},
  [222] = {.lex_state = 2},
  [223] = {.lex_state = 2},
  [224] = {.lex_state = 2},
  [225] = {.lex_state = 2},
  [226] = {.lex_state = 2},
  [227] = {.lex_state = 3},
  [228] = {.lex_state = 2},
  [229] = {.lex_state = 3},
  [230] = {.lex_state = 2},
  [231] = {.lex_state = 2},
  [232] = {.lex_state = 2},
  [233] = {.lex_state = 247},
  [234] = {.lex_state = 2},
  [235] = {.lex_state = 2},
  [236] = {.lex_state = 2},
  [237] = {.lex_state = 2},
  [238] = {.lex_state = 2},
  [239] = {.lex_state = 3},
  [240] = {.lex_state = 2},
  [241] = {.lex_state = 2},
  [242] = {.lex_state = 3},
  [243] = {.lex_state = 2},
  [244] = {.lex_state = 2},
  [245] = {.lex_state = 2},
  [246] = {.lex_state = 3},
  [247] = {.lex_state = 3},
  [248] = {.lex_state = 4},
  [249] = {.lex_state = 2},
  [250] = {.lex_state = 2},
  [251] = {.lex_state = 0, .external_lex_state = 1},
  [252] = {.lex_state = 2},
  [253] = {.lex_state = 2},
  [254] = {.lex_state = 0, .external_lex_state = 1},
  [255] = {.lex_state = 2},
  [256] = {.lex_state = 2},
  [257] = {.lex_state = 0, .external_lex_state = 1},
  [258] = {.lex_state = 2},
  [259] = {.lex_state = 247},
  [260] = {.lex_state = 247},
  [261] = {.lex_state = 247},
  [262] = {.lex_state = 0, .external_lex_state = 1},
  [263] = {.lex_state = 0, .external_lex_state = 1},
  [264] = {.lex_state = 0, .external_lex_state = 1},
  [265] = {.lex_state = 247},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 247},
  [268] = {.lex_state = 247},
  [269] = {.lex_state = 247},
  [270] = {.lex_state = 2},
  [271] = {.lex_state = 0},
  [272] = {.lex_state = 2},
  [273] = {.lex_state = 247},
  [274] = {.lex_state = 247},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 247},
  [277] = {.lex_state = 2},
  [278] = {.lex_state = 247},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 90},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 0},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 0, .external_lex_state = 1},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 0},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 0},
  [294] = {.lex_state = 247},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 247},
  [300] = {.lex_state = 247},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 247},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 247},
  [318] = {.lex_state = 0},
  [319] = {.lex_state = 0, .external_lex_state = 1},
  [320] = {.lex_state = 247},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
};

enum {
  ts_external_token__ext_name = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__ext_name] = sym__ext_name,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__ext_name] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_end_tok] = ACTIONS(1),
    [sym_for_tok] = ACTIONS(1),
    [sym_next_tok] = ACTIONS(1),
    [sym_data_tok] = ACTIONS(1),
    [sym_input_tok] = ACTIONS(1),
    [sym_del_tok] = ACTIONS(1),
    [sym_dim_tok] = ACTIONS(1),
    [sym_read_tok] = ACTIONS(1),
    [sym_gr_tok] = ACTIONS(1),
    [sym_text_tok] = ACTIONS(1),
    [sym_prn_tok] = ACTIONS(1),
    [sym_inn_tok] = ACTIONS(1),
    [sym_call_tok] = ACTIONS(1),
    [sym_plot_tok] = ACTIONS(1),
    [sym_hlin_tok] = ACTIONS(1),
    [sym_vlin_tok] = ACTIONS(1),
    [sym_hgr2_tok] = ACTIONS(1),
    [sym_hgr_tok] = ACTIONS(1),
    [sym_hcoloreq_tok] = ACTIONS(1),
    [sym_hplot_tok] = ACTIONS(1),
    [sym_draw_tok] = ACTIONS(1),
    [sym_xdraw_tok] = ACTIONS(1),
    [sym_htab_tok] = ACTIONS(1),
    [sym_home_tok] = ACTIONS(1),
    [sym_roteq_tok] = ACTIONS(1),
    [sym_scaleeq_tok] = ACTIONS(1),
    [sym_shload_tok] = ACTIONS(1),
    [sym_trace_tok] = ACTIONS(1),
    [sym_normal_tok] = ACTIONS(1),
    [sym_inverse_tok] = ACTIONS(1),
    [sym_flash_tok] = ACTIONS(1),
    [sym_coloreq_tok] = ACTIONS(1),
    [sym_pop_tok] = ACTIONS(1),
    [sym_vtab_tok] = ACTIONS(1),
    [sym_himem_tok] = ACTIONS(1),
    [sym_lomem_tok] = ACTIONS(1),
    [sym_onerr_tok] = ACTIONS(1),
    [sym_resume_tok] = ACTIONS(1),
    [sym_recall_tok] = ACTIONS(1),
    [sym_store_tok] = ACTIONS(1),
    [sym_speedeq_tok] = ACTIONS(1),
    [sym_let_tok] = ACTIONS(1),
    [sym_goto_tok] = ACTIONS(1),
    [sym_run_tok] = ACTIONS(1),
    [sym_if_tok] = ACTIONS(1),
    [sym_restore_tok] = ACTIONS(1),
    [sym_amp_tok] = ACTIONS(1),
    [sym_gosub_tok] = ACTIONS(1),
    [sym_return_tok] = ACTIONS(1),
    [sym_rem_tok] = ACTIONS(1),
    [sym_stop_tok] = ACTIONS(1),
    [sym_on_tok] = ACTIONS(1),
    [sym_wait_tok] = ACTIONS(1),
    [sym_load_tok] = ACTIONS(1),
    [sym_save_tok] = ACTIONS(1),
    [sym_def_tok] = ACTIONS(1),
    [sym_poke_tok] = ACTIONS(1),
    [sym_print_tok] = ACTIONS(1),
    [sym_cont_tok] = ACTIONS(1),
    [sym_list_tok] = ACTIONS(1),
    [sym_clear_tok] = ACTIONS(1),
    [sym_get_tok] = ACTIONS(1),
    [sym_new_tok] = ACTIONS(1),
    [sym_tabp_tok] = ACTIONS(1),
    [sym_to_tok] = ACTIONS(1),
    [sym_fn_tok] = ACTIONS(1),
    [sym_spcp_tok] = ACTIONS(1),
    [sym_then_tok] = ACTIONS(1),
    [sym_at_tok] = ACTIONS(1),
    [sym_not_tok] = ACTIONS(1),
    [sym_step_tok] = ACTIONS(1),
    [sym_plus_tok] = ACTIONS(1),
    [sym_minus_tok] = ACTIONS(1),
    [sym_times_tok] = ACTIONS(1),
    [sym_div_tok] = ACTIONS(1),
    [sym_pow_tok] = ACTIONS(1),
    [sym_and_tok] = ACTIONS(1),
    [sym_or_tok] = ACTIONS(1),
    [sym_gtr_tok] = ACTIONS(1),
    [sym_eq_tok] = ACTIONS(1),
    [sym_less_tok] = ACTIONS(1),
    [sym_sgn_tok] = ACTIONS(1),
    [sym_int_tok] = ACTIONS(1),
    [sym_abs_tok] = ACTIONS(1),
    [sym_usr_tok] = ACTIONS(1),
    [sym_fre_tok] = ACTIONS(1),
    [sym_scrnp_tok] = ACTIONS(1),
    [sym_pdl_tok] = ACTIONS(1),
    [sym_pos_tok] = ACTIONS(1),
    [sym_sqr_tok] = ACTIONS(1),
    [sym_rnd_tok] = ACTIONS(1),
    [sym_log_tok] = ACTIONS(1),
    [sym_exp_tok] = ACTIONS(1),
    [sym_cos_tok] = ACTIONS(1),
    [sym_sin_tok] = ACTIONS(1),
    [sym_tan_tok] = ACTIONS(1),
    [sym_peek_tok] = ACTIONS(1),
    [sym_len_tok] = ACTIONS(1),
    [sym_str_tok] = ACTIONS(1),
    [sym_val_tok] = ACTIONS(1),
    [sym_asc_tok] = ACTIONS(1),
    [sym_chr_tok] = ACTIONS(1),
    [sym_left_tok] = ACTIONS(1),
    [sym_right_tok] = ACTIONS(1),
    [sym_mid_tok] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LF] = ACTIONS(1),
    [anon_sym_CR_LF] = ACTIONS(1),
    [sym__empty_line] = ACTIONS(1),
    [sym_linenum] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_real_data_item] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym__ext_name] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(287),
    [sym_line] = STATE(219),
    [aux_sym_source_file_repeat1] = STATE(219),
    [ts_builtin_sym_end] = ACTIONS(3),
    [sym__empty_line] = ACTIONS(5),
    [sym_linenum] = ACTIONS(7),
  },
  [2] = {
    [sym_statement] = STATE(272),
    [sym_assignment] = STATE(256),
    [sym__avar] = STATE(293),
    [sym_intvar] = STATE(293),
    [sym_realvar] = STATE(293),
    [sym_svar] = STATE(286),
    [sym__name] = STATE(112),
    [sym__real_scalar] = STATE(138),
    [sym__int_scalar] = STATE(139),
    [sym__string_scalar] = STATE(117),
    [sym__real_array] = STATE(138),
    [sym__int_array] = STATE(139),
    [sym__string_array] = STATE(117),
    [aux_sym_line_repeat1] = STATE(5),
    [sym_end_tok] = ACTIONS(9),
    [sym_for_tok] = ACTIONS(11),
    [sym_next_tok] = ACTIONS(13),
    [sym_data_tok] = ACTIONS(15),
    [sym_input_tok] = ACTIONS(17),
    [sym_del_tok] = ACTIONS(19),
    [sym_dim_tok] = ACTIONS(21),
    [sym_read_tok] = ACTIONS(23),
    [sym_gr_tok] = ACTIONS(9),
    [sym_text_tok] = ACTIONS(9),
    [sym_prn_tok] = ACTIONS(25),
    [sym_inn_tok] = ACTIONS(25),
    [sym_call_tok] = ACTIONS(25),
    [sym_plot_tok] = ACTIONS(27),
    [sym_hlin_tok] = ACTIONS(29),
    [sym_vlin_tok] = ACTIONS(29),
    [sym_hgr2_tok] = ACTIONS(9),
    [sym_hgr_tok] = ACTIONS(31),
    [sym_hcoloreq_tok] = ACTIONS(25),
    [sym_hplot_tok] = ACTIONS(33),
    [sym_draw_tok] = ACTIONS(35),
    [sym_xdraw_tok] = ACTIONS(35),
    [sym_htab_tok] = ACTIONS(25),
    [sym_home_tok] = ACTIONS(9),
    [sym_roteq_tok] = ACTIONS(25),
    [sym_scaleeq_tok] = ACTIONS(25),
    [sym_shload_tok] = ACTIONS(9),
    [sym_trace_tok] = ACTIONS(9),
    [sym_notrace_tok] = ACTIONS(9),
    [sym_normal_tok] = ACTIONS(9),
    [sym_inverse_tok] = ACTIONS(9),
    [sym_flash_tok] = ACTIONS(9),
    [sym_coloreq_tok] = ACTIONS(25),
    [sym_pop_tok] = ACTIONS(9),
    [sym_vtab_tok] = ACTIONS(25),
    [sym_himem_tok] = ACTIONS(25),
    [sym_lomem_tok] = ACTIONS(25),
    [sym_onerr_tok] = ACTIONS(37),
    [sym_resume_tok] = ACTIONS(9),
    [sym_recall_tok] = ACTIONS(39),
    [sym_store_tok] = ACTIONS(39),
    [sym_speedeq_tok] = ACTIONS(25),
    [sym_let_tok] = ACTIONS(41),
    [sym_goto_tok] = ACTIONS(43),
    [sym_run_tok] = ACTIONS(45),
    [sym_if_tok] = ACTIONS(47),
    [sym_restore_tok] = ACTIONS(9),
    [sym_gosub_tok] = ACTIONS(43),
    [sym_return_tok] = ACTIONS(9),
    [sym_rem_tok] = ACTIONS(49),
    [sym_stop_tok] = ACTIONS(9),
    [sym_on_tok] = ACTIONS(51),
    [sym_wait_tok] = ACTIONS(53),
    [sym_load_tok] = ACTIONS(9),
    [sym_save_tok] = ACTIONS(9),
    [sym_def_tok] = ACTIONS(55),
    [sym_poke_tok] = ACTIONS(27),
    [sym_print_tok] = ACTIONS(57),
    [sym_cont_tok] = ACTIONS(9),
    [sym_list_tok] = ACTIONS(59),
    [sym_clear_tok] = ACTIONS(9),
    [sym_get_tok] = ACTIONS(23),
    [sym_new_tok] = ACTIONS(9),
    [sym__ext_name] = ACTIONS(61),
  },
  [3] = {
    [sym_statement] = STATE(270),
    [sym_assignment] = STATE(256),
    [sym__avar] = STATE(293),
    [sym_intvar] = STATE(293),
    [sym_realvar] = STATE(293),
    [sym_svar] = STATE(286),
    [sym__name] = STATE(112),
    [sym__real_scalar] = STATE(138),
    [sym__int_scalar] = STATE(139),
    [sym__string_scalar] = STATE(117),
    [sym__real_array] = STATE(138),
    [sym__int_array] = STATE(139),
    [sym__string_array] = STATE(117),
    [aux_sym_line_repeat1] = STATE(2),
    [sym_end_tok] = ACTIONS(9),
    [sym_for_tok] = ACTIONS(11),
    [sym_next_tok] = ACTIONS(13),
    [sym_data_tok] = ACTIONS(15),
    [sym_input_tok] = ACTIONS(17),
    [sym_del_tok] = ACTIONS(19),
    [sym_dim_tok] = ACTIONS(21),
    [sym_read_tok] = ACTIONS(23),
    [sym_gr_tok] = ACTIONS(9),
    [sym_text_tok] = ACTIONS(9),
    [sym_prn_tok] = ACTIONS(25),
    [sym_inn_tok] = ACTIONS(25),
    [sym_call_tok] = ACTIONS(25),
    [sym_plot_tok] = ACTIONS(27),
    [sym_hlin_tok] = ACTIONS(29),
    [sym_vlin_tok] = ACTIONS(29),
    [sym_hgr2_tok] = ACTIONS(9),
    [sym_hgr_tok] = ACTIONS(31),
    [sym_hcoloreq_tok] = ACTIONS(25),
    [sym_hplot_tok] = ACTIONS(33),
    [sym_draw_tok] = ACTIONS(35),
    [sym_xdraw_tok] = ACTIONS(35),
    [sym_htab_tok] = ACTIONS(25),
    [sym_home_tok] = ACTIONS(9),
    [sym_roteq_tok] = ACTIONS(25),
    [sym_scaleeq_tok] = ACTIONS(25),
    [sym_shload_tok] = ACTIONS(9),
    [sym_trace_tok] = ACTIONS(9),
    [sym_notrace_tok] = ACTIONS(9),
    [sym_normal_tok] = ACTIONS(9),
    [sym_inverse_tok] = ACTIONS(9),
    [sym_flash_tok] = ACTIONS(9),
    [sym_coloreq_tok] = ACTIONS(25),
    [sym_pop_tok] = ACTIONS(9),
    [sym_vtab_tok] = ACTIONS(25),
    [sym_himem_tok] = ACTIONS(25),
    [sym_lomem_tok] = ACTIONS(25),
    [sym_onerr_tok] = ACTIONS(37),
    [sym_resume_tok] = ACTIONS(9),
    [sym_recall_tok] = ACTIONS(39),
    [sym_store_tok] = ACTIONS(39),
    [sym_speedeq_tok] = ACTIONS(25),
    [sym_let_tok] = ACTIONS(41),
    [sym_goto_tok] = ACTIONS(43),
    [sym_run_tok] = ACTIONS(45),
    [sym_if_tok] = ACTIONS(47),
    [sym_restore_tok] = ACTIONS(9),
    [sym_gosub_tok] = ACTIONS(43),
    [sym_return_tok] = ACTIONS(9),
    [sym_rem_tok] = ACTIONS(49),
    [sym_stop_tok] = ACTIONS(9),
    [sym_on_tok] = ACTIONS(51),
    [sym_wait_tok] = ACTIONS(53),
    [sym_load_tok] = ACTIONS(9),
    [sym_save_tok] = ACTIONS(9),
    [sym_def_tok] = ACTIONS(55),
    [sym_poke_tok] = ACTIONS(27),
    [sym_print_tok] = ACTIONS(57),
    [sym_cont_tok] = ACTIONS(9),
    [sym_list_tok] = ACTIONS(59),
    [sym_clear_tok] = ACTIONS(9),
    [sym_get_tok] = ACTIONS(23),
    [sym_new_tok] = ACTIONS(9),
    [sym__ext_name] = ACTIONS(61),
  },
  [4] = {
    [sym_statement] = STATE(255),
    [sym_assignment] = STATE(256),
    [sym__avar] = STATE(293),
    [sym_intvar] = STATE(293),
    [sym_realvar] = STATE(293),
    [sym_svar] = STATE(286),
    [sym__name] = STATE(112),
    [sym__real_scalar] = STATE(138),
    [sym__int_scalar] = STATE(139),
    [sym__string_scalar] = STATE(117),
    [sym__real_array] = STATE(138),
    [sym__int_array] = STATE(139),
    [sym__string_array] = STATE(117),
    [sym_end_tok] = ACTIONS(9),
    [sym_for_tok] = ACTIONS(11),
    [sym_next_tok] = ACTIONS(13),
    [sym_data_tok] = ACTIONS(15),
    [sym_input_tok] = ACTIONS(17),
    [sym_del_tok] = ACTIONS(19),
    [sym_dim_tok] = ACTIONS(21),
    [sym_read_tok] = ACTIONS(23),
    [sym_gr_tok] = ACTIONS(9),
    [sym_text_tok] = ACTIONS(9),
    [sym_prn_tok] = ACTIONS(25),
    [sym_inn_tok] = ACTIONS(25),
    [sym_call_tok] = ACTIONS(25),
    [sym_plot_tok] = ACTIONS(27),
    [sym_hlin_tok] = ACTIONS(29),
    [sym_vlin_tok] = ACTIONS(29),
    [sym_hgr2_tok] = ACTIONS(9),
    [sym_hgr_tok] = ACTIONS(31),
    [sym_hcoloreq_tok] = ACTIONS(25),
    [sym_hplot_tok] = ACTIONS(33),
    [sym_draw_tok] = ACTIONS(35),
    [sym_xdraw_tok] = ACTIONS(35),
    [sym_htab_tok] = ACTIONS(25),
    [sym_home_tok] = ACTIONS(9),
    [sym_roteq_tok] = ACTIONS(25),
    [sym_scaleeq_tok] = ACTIONS(25),
    [sym_shload_tok] = ACTIONS(9),
    [sym_trace_tok] = ACTIONS(9),
    [sym_notrace_tok] = ACTIONS(9),
    [sym_normal_tok] = ACTIONS(9),
    [sym_inverse_tok] = ACTIONS(9),
    [sym_flash_tok] = ACTIONS(9),
    [sym_coloreq_tok] = ACTIONS(25),
    [sym_pop_tok] = ACTIONS(9),
    [sym_vtab_tok] = ACTIONS(25),
    [sym_himem_tok] = ACTIONS(25),
    [sym_lomem_tok] = ACTIONS(25),
    [sym_onerr_tok] = ACTIONS(37),
    [sym_resume_tok] = ACTIONS(9),
    [sym_recall_tok] = ACTIONS(39),
    [sym_store_tok] = ACTIONS(39),
    [sym_speedeq_tok] = ACTIONS(25),
    [sym_let_tok] = ACTIONS(41),
    [sym_goto_tok] = ACTIONS(43),
    [sym_run_tok] = ACTIONS(45),
    [sym_if_tok] = ACTIONS(47),
    [sym_restore_tok] = ACTIONS(9),
    [sym_gosub_tok] = ACTIONS(43),
    [sym_return_tok] = ACTIONS(9),
    [sym_rem_tok] = ACTIONS(49),
    [sym_stop_tok] = ACTIONS(9),
    [sym_on_tok] = ACTIONS(51),
    [sym_wait_tok] = ACTIONS(53),
    [sym_load_tok] = ACTIONS(9),
    [sym_save_tok] = ACTIONS(9),
    [sym_def_tok] = ACTIONS(55),
    [sym_poke_tok] = ACTIONS(27),
    [sym_print_tok] = ACTIONS(57),
    [sym_cont_tok] = ACTIONS(9),
    [sym_list_tok] = ACTIONS(59),
    [sym_clear_tok] = ACTIONS(9),
    [sym_get_tok] = ACTIONS(23),
    [sym_new_tok] = ACTIONS(9),
    [sym_linenum] = ACTIONS(63),
    [sym__ext_name] = ACTIONS(61),
  },
  [5] = {
    [sym_statement] = STATE(284),
    [sym_assignment] = STATE(256),
    [sym__avar] = STATE(293),
    [sym_intvar] = STATE(293),
    [sym_realvar] = STATE(293),
    [sym_svar] = STATE(286),
    [sym__name] = STATE(112),
    [sym__real_scalar] = STATE(138),
    [sym__int_scalar] = STATE(139),
    [sym__string_scalar] = STATE(117),
    [sym__real_array] = STATE(138),
    [sym__int_array] = STATE(139),
    [sym__string_array] = STATE(117),
    [aux_sym_line_repeat1] = STATE(5),
    [sym_end_tok] = ACTIONS(65),
    [sym_for_tok] = ACTIONS(68),
    [sym_next_tok] = ACTIONS(71),
    [sym_data_tok] = ACTIONS(74),
    [sym_input_tok] = ACTIONS(77),
    [sym_del_tok] = ACTIONS(80),
    [sym_dim_tok] = ACTIONS(83),
    [sym_read_tok] = ACTIONS(86),
    [sym_gr_tok] = ACTIONS(65),
    [sym_text_tok] = ACTIONS(65),
    [sym_prn_tok] = ACTIONS(89),
    [sym_inn_tok] = ACTIONS(89),
    [sym_call_tok] = ACTIONS(89),
    [sym_plot_tok] = ACTIONS(92),
    [sym_hlin_tok] = ACTIONS(95),
    [sym_vlin_tok] = ACTIONS(95),
    [sym_hgr2_tok] = ACTIONS(65),
    [sym_hgr_tok] = ACTIONS(98),
    [sym_hcoloreq_tok] = ACTIONS(89),
    [sym_hplot_tok] = ACTIONS(101),
    [sym_draw_tok] = ACTIONS(104),
    [sym_xdraw_tok] = ACTIONS(104),
    [sym_htab_tok] = ACTIONS(89),
    [sym_home_tok] = ACTIONS(65),
    [sym_roteq_tok] = ACTIONS(89),
    [sym_scaleeq_tok] = ACTIONS(89),
    [sym_shload_tok] = ACTIONS(65),
    [sym_trace_tok] = ACTIONS(65),
    [sym_notrace_tok] = ACTIONS(65),
    [sym_normal_tok] = ACTIONS(65),
    [sym_inverse_tok] = ACTIONS(65),
    [sym_flash_tok] = ACTIONS(65),
    [sym_coloreq_tok] = ACTIONS(89),
    [sym_pop_tok] = ACTIONS(65),
    [sym_vtab_tok] = ACTIONS(89),
    [sym_himem_tok] = ACTIONS(89),
    [sym_lomem_tok] = ACTIONS(89),
    [sym_onerr_tok] = ACTIONS(107),
    [sym_resume_tok] = ACTIONS(65),
    [sym_recall_tok] = ACTIONS(110),
    [sym_store_tok] = ACTIONS(110),
    [sym_speedeq_tok] = ACTIONS(89),
    [sym_let_tok] = ACTIONS(113),
    [sym_goto_tok] = ACTIONS(116),
    [sym_run_tok] = ACTIONS(119),
    [sym_if_tok] = ACTIONS(122),
    [sym_restore_tok] = ACTIONS(65),
    [sym_gosub_tok] = ACTIONS(116),
    [sym_return_tok] = ACTIONS(65),
    [sym_rem_tok] = ACTIONS(125),
    [sym_stop_tok] = ACTIONS(65),
    [sym_on_tok] = ACTIONS(128),
    [sym_wait_tok] = ACTIONS(131),
    [sym_load_tok] = ACTIONS(65),
    [sym_save_tok] = ACTIONS(65),
    [sym_def_tok] = ACTIONS(134),
    [sym_poke_tok] = ACTIONS(92),
    [sym_print_tok] = ACTIONS(137),
    [sym_cont_tok] = ACTIONS(65),
    [sym_list_tok] = ACTIONS(140),
    [sym_clear_tok] = ACTIONS(65),
    [sym_get_tok] = ACTIONS(86),
    [sym_new_tok] = ACTIONS(65),
    [sym__ext_name] = ACTIONS(143),
  },
  [6] = {
    [sym_statement] = STATE(255),
    [sym_assignment] = STATE(256),
    [sym__avar] = STATE(293),
    [sym_intvar] = STATE(293),
    [sym_realvar] = STATE(293),
    [sym_svar] = STATE(286),
    [sym__name] = STATE(112),
    [sym__real_scalar] = STATE(138),
    [sym__int_scalar] = STATE(139),
    [sym__string_scalar] = STATE(117),
    [sym__real_array] = STATE(138),
    [sym__int_array] = STATE(139),
    [sym__string_array] = STATE(117),
    [sym_end_tok] = ACTIONS(9),
    [sym_for_tok] = ACTIONS(11),
    [sym_next_tok] = ACTIONS(13),
    [sym_data_tok] = ACTIONS(15),
    [sym_input_tok] = ACTIONS(17),
    [sym_del_tok] = ACTIONS(19),
    [sym_dim_tok] = ACTIONS(21),
    [sym_read_tok] = ACTIONS(23),
    [sym_gr_tok] = ACTIONS(9),
    [sym_text_tok] = ACTIONS(9),
    [sym_prn_tok] = ACTIONS(25),
    [sym_inn_tok] = ACTIONS(25),
    [sym_call_tok] = ACTIONS(25),
    [sym_plot_tok] = ACTIONS(27),
    [sym_hlin_tok] = ACTIONS(29),
    [sym_vlin_tok] = ACTIONS(29),
    [sym_hgr2_tok] = ACTIONS(9),
    [sym_hgr_tok] = ACTIONS(31),
    [sym_hcoloreq_tok] = ACTIONS(25),
    [sym_hplot_tok] = ACTIONS(33),
    [sym_draw_tok] = ACTIONS(35),
    [sym_xdraw_tok] = ACTIONS(35),
    [sym_htab_tok] = ACTIONS(25),
    [sym_home_tok] = ACTIONS(9),
    [sym_roteq_tok] = ACTIONS(25),
    [sym_scaleeq_tok] = ACTIONS(25),
    [sym_shload_tok] = ACTIONS(9),
    [sym_trace_tok] = ACTIONS(9),
    [sym_notrace_tok] = ACTIONS(9),
    [sym_normal_tok] = ACTIONS(9),
    [sym_inverse_tok] = ACTIONS(9),
    [sym_flash_tok] = ACTIONS(9),
    [sym_coloreq_tok] = ACTIONS(25),
    [sym_pop_tok] = ACTIONS(9),
    [sym_vtab_tok] = ACTIONS(25),
    [sym_himem_tok] = ACTIONS(25),
    [sym_lomem_tok] = ACTIONS(25),
    [sym_onerr_tok] = ACTIONS(37),
    [sym_resume_tok] = ACTIONS(9),
    [sym_recall_tok] = ACTIONS(39),
    [sym_store_tok] = ACTIONS(39),
    [sym_speedeq_tok] = ACTIONS(25),
    [sym_let_tok] = ACTIONS(41),
    [sym_goto_tok] = ACTIONS(43),
    [sym_run_tok] = ACTIONS(45),
    [sym_if_tok] = ACTIONS(146),
    [sym_restore_tok] = ACTIONS(9),
    [sym_gosub_tok] = ACTIONS(43),
    [sym_return_tok] = ACTIONS(9),
    [sym_rem_tok] = ACTIONS(148),
    [sym_stop_tok] = ACTIONS(9),
    [sym_on_tok] = ACTIONS(51),
    [sym_wait_tok] = ACTIONS(53),
    [sym_load_tok] = ACTIONS(9),
    [sym_save_tok] = ACTIONS(9),
    [sym_def_tok] = ACTIONS(55),
    [sym_poke_tok] = ACTIONS(27),
    [sym_print_tok] = ACTIONS(57),
    [sym_cont_tok] = ACTIONS(9),
    [sym_list_tok] = ACTIONS(59),
    [sym_clear_tok] = ACTIONS(9),
    [sym_get_tok] = ACTIONS(23),
    [sym_new_tok] = ACTIONS(9),
    [sym_linenum] = ACTIONS(63),
    [sym__ext_name] = ACTIONS(61),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 2,
    ACTIONS(152), 2,
      sym_hgr_tok,
      sym_on_tok,
    ACTIONS(150), 62,
      sym__ext_name,
      sym_end_tok,
      sym_for_tok,
      sym_next_tok,
      sym_data_tok,
      sym_input_tok,
      sym_del_tok,
      sym_dim_tok,
      sym_read_tok,
      sym_gr_tok,
      sym_text_tok,
      sym_prn_tok,
      sym_inn_tok,
      sym_call_tok,
      sym_plot_tok,
      sym_hlin_tok,
      sym_vlin_tok,
      sym_hgr2_tok,
      sym_hcoloreq_tok,
      sym_hplot_tok,
      sym_draw_tok,
      sym_xdraw_tok,
      sym_htab_tok,
      sym_home_tok,
      sym_roteq_tok,
      sym_scaleeq_tok,
      sym_shload_tok,
      sym_trace_tok,
      sym_notrace_tok,
      sym_normal_tok,
      sym_inverse_tok,
      sym_flash_tok,
      sym_coloreq_tok,
      sym_pop_tok,
      sym_vtab_tok,
      sym_himem_tok,
      sym_lomem_tok,
      sym_onerr_tok,
      sym_resume_tok,
      sym_recall_tok,
      sym_store_tok,
      sym_speedeq_tok,
      sym_let_tok,
      sym_goto_tok,
      sym_run_tok,
      sym_if_tok,
      sym_restore_tok,
      sym_gosub_tok,
      sym_return_tok,
      sym_rem_tok,
      sym_stop_tok,
      sym_wait_tok,
      sym_load_tok,
      sym_save_tok,
      sym_def_tok,
      sym_poke_tok,
      sym_print_tok,
      sym_cont_tok,
      sym_list_tok,
      sym_clear_tok,
      sym_get_tok,
      sym_new_tok,
  [69] = 25,
    ACTIONS(157), 1,
      sym_fn_tok,
    ACTIONS(160), 1,
      sym_not_tok,
    ACTIONS(172), 1,
      sym_scrnp_tok,
    ACTIONS(184), 1,
      sym_mid_tok,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(192), 1,
      sym_integer,
    ACTIONS(195), 1,
      sym_real,
    ACTIONS(198), 1,
      sym_string,
    ACTIONS(201), 1,
      sym__ext_name,
    STATE(8), 1,
      aux_sym_statement_repeat7,
    STATE(73), 1,
      sym__name,
    STATE(105), 1,
      sym__expr,
    ACTIONS(154), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(163), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(169), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(178), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(181), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(97), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(98), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(102), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(175), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    ACTIONS(190), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
    STATE(104), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(85), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(166), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [181] = 25,
    ACTIONS(206), 1,
      sym_fn_tok,
    ACTIONS(208), 1,
      sym_not_tok,
    ACTIONS(216), 1,
      sym_scrnp_tok,
    ACTIONS(224), 1,
      sym_mid_tok,
    ACTIONS(226), 1,
      anon_sym_LPAREN,
    ACTIONS(230), 1,
      sym_integer,
    ACTIONS(232), 1,
      sym_real,
    ACTIONS(234), 1,
      sym_string,
    ACTIONS(236), 1,
      sym__ext_name,
    STATE(8), 1,
      aux_sym_statement_repeat7,
    STATE(73), 1,
      sym__name,
    STATE(105), 1,
      sym__expr,
    ACTIONS(204), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(210), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(214), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(220), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(222), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(97), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(98), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(102), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(218), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    ACTIONS(228), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
    STATE(104), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(85), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(212), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [293] = 25,
    ACTIONS(206), 1,
      sym_fn_tok,
    ACTIONS(208), 1,
      sym_not_tok,
    ACTIONS(216), 1,
      sym_scrnp_tok,
    ACTIONS(224), 1,
      sym_mid_tok,
    ACTIONS(226), 1,
      anon_sym_LPAREN,
    ACTIONS(230), 1,
      sym_integer,
    ACTIONS(232), 1,
      sym_real,
    ACTIONS(234), 1,
      sym_string,
    ACTIONS(236), 1,
      sym__ext_name,
    STATE(9), 1,
      aux_sym_statement_repeat7,
    STATE(73), 1,
      sym__name,
    STATE(105), 1,
      sym__expr,
    ACTIONS(204), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(210), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(214), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(220), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(222), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(97), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(98), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(102), 2,
      sym__real_scalar,
      sym__real_array,
    ACTIONS(218), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    ACTIONS(238), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
    STATE(104), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(85), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(212), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [405] = 23,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      sym_integer,
    ACTIONS(266), 1,
      sym_real,
    ACTIONS(268), 1,
      sym_string,
    STATE(112), 1,
      sym__name,
    STATE(314), 1,
      sym__expr,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(206), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(164), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [509] = 23,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(270), 1,
      sym_to_tok,
    ACTIONS(272), 1,
      sym_integer,
    ACTIONS(274), 1,
      sym_real,
    ACTIONS(276), 1,
      sym_string,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(180), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [613] = 23,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      sym_integer,
    ACTIONS(266), 1,
      sym_real,
    ACTIONS(268), 1,
      sym_string,
    STATE(112), 1,
      sym__name,
    STATE(281), 1,
      sym__expr,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(206), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(164), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [717] = 23,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      sym_integer,
    ACTIONS(266), 1,
      sym_real,
    ACTIONS(268), 1,
      sym_string,
    STATE(112), 1,
      sym__name,
    STATE(289), 1,
      sym__expr,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(206), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(164), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [821] = 23,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      sym_integer,
    ACTIONS(266), 1,
      sym_real,
    ACTIONS(268), 1,
      sym_string,
    STATE(112), 1,
      sym__name,
    STATE(280), 1,
      sym__expr,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(206), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(164), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [925] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(278), 1,
      sym_integer,
    ACTIONS(280), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(189), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1026] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(282), 1,
      sym_integer,
    ACTIONS(284), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(166), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1127] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(286), 1,
      sym_integer,
    ACTIONS(288), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(200), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1228] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(290), 1,
      sym_integer,
    ACTIONS(292), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(156), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1329] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(294), 1,
      sym_integer,
    ACTIONS(296), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(203), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1430] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(298), 1,
      sym_integer,
    ACTIONS(300), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(163), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1531] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(302), 1,
      sym_integer,
    ACTIONS(304), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(182), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1632] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(306), 1,
      sym_integer,
    ACTIONS(308), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(179), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1733] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(310), 1,
      sym_integer,
    ACTIONS(312), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(158), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1834] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(314), 1,
      sym_integer,
    ACTIONS(316), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(199), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [1935] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(318), 1,
      sym_integer,
    ACTIONS(320), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(197), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2036] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(322), 1,
      sym_integer,
    ACTIONS(324), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(162), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2137] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_integer,
    ACTIONS(328), 1,
      sym_real,
    ACTIONS(330), 1,
      sym_string,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(209), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(192), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2238] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(332), 1,
      sym_integer,
    ACTIONS(334), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(176), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2339] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(336), 1,
      sym_integer,
    ACTIONS(338), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(174), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2440] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(340), 1,
      sym_integer,
    ACTIONS(342), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(177), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2541] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(344), 1,
      sym_integer,
    ACTIONS(346), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(185), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2642] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(348), 1,
      sym_integer,
    ACTIONS(350), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(159), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2743] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(352), 1,
      sym_integer,
    ACTIONS(354), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(198), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2844] = 22,
    ACTIONS(206), 1,
      sym_fn_tok,
    ACTIONS(208), 1,
      sym_not_tok,
    ACTIONS(216), 1,
      sym_scrnp_tok,
    ACTIONS(236), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(356), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      sym_integer,
    ACTIONS(360), 1,
      sym_real,
    ACTIONS(362), 1,
      sym_string,
    STATE(74), 1,
      sym__name,
    ACTIONS(210), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(214), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(98), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(102), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(218), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(216), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(86), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(212), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [2945] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(364), 1,
      sym_integer,
    ACTIONS(366), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(172), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3046] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(368), 1,
      sym_integer,
    ACTIONS(370), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(169), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3147] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(372), 1,
      sym_integer,
    ACTIONS(374), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(196), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3248] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(376), 1,
      sym_integer,
    ACTIONS(378), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(160), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3349] = 22,
    ACTIONS(206), 1,
      sym_fn_tok,
    ACTIONS(208), 1,
      sym_not_tok,
    ACTIONS(216), 1,
      sym_scrnp_tok,
    ACTIONS(236), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(356), 1,
      anon_sym_LPAREN,
    ACTIONS(362), 1,
      sym_string,
    ACTIONS(380), 1,
      sym_integer,
    ACTIONS(382), 1,
      sym_real,
    STATE(74), 1,
      sym__name,
    ACTIONS(210), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(214), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(98), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(102), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(218), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(216), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(76), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(212), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3450] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(384), 1,
      sym_integer,
    ACTIONS(386), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(183), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3551] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(388), 1,
      sym_integer,
    ACTIONS(390), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(168), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3652] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(392), 1,
      sym_integer,
    ACTIONS(394), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(190), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3753] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(396), 1,
      sym_integer,
    ACTIONS(398), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(155), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3854] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(400), 1,
      sym_integer,
    ACTIONS(402), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(201), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [3955] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(404), 1,
      sym_integer,
    ACTIONS(406), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(118), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4056] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(408), 1,
      sym_integer,
    ACTIONS(410), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(181), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4157] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(412), 1,
      sym_integer,
    ACTIONS(414), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(120), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4258] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(416), 1,
      sym_integer,
    ACTIONS(418), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(123), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4359] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(420), 1,
      sym_integer,
    ACTIONS(422), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(131), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4460] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(424), 1,
      sym_integer,
    ACTIONS(426), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(130), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4561] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(428), 1,
      sym_integer,
    ACTIONS(430), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(132), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4662] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(432), 1,
      sym_integer,
    ACTIONS(434), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(161), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4763] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      sym_integer,
    ACTIONS(328), 1,
      sym_real,
    ACTIONS(436), 1,
      sym_string,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(210), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(192), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4864] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(438), 1,
      sym_integer,
    ACTIONS(440), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(186), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [4965] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(442), 1,
      sym_integer,
    ACTIONS(444), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(184), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5066] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(446), 1,
      sym_integer,
    ACTIONS(448), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(157), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5167] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(450), 1,
      sym_integer,
    ACTIONS(452), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(119), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5268] = 22,
    ACTIONS(206), 1,
      sym_fn_tok,
    ACTIONS(208), 1,
      sym_not_tok,
    ACTIONS(216), 1,
      sym_scrnp_tok,
    ACTIONS(236), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(356), 1,
      anon_sym_LPAREN,
    ACTIONS(362), 1,
      sym_string,
    ACTIONS(454), 1,
      sym_integer,
    ACTIONS(456), 1,
      sym_real,
    STATE(74), 1,
      sym__name,
    ACTIONS(210), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(214), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(98), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(102), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(218), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(216), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(82), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(212), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5369] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(458), 1,
      sym_integer,
    ACTIONS(460), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(195), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5470] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(462), 1,
      sym_integer,
    ACTIONS(464), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(188), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5571] = 22,
    ACTIONS(206), 1,
      sym_fn_tok,
    ACTIONS(208), 1,
      sym_not_tok,
    ACTIONS(216), 1,
      sym_scrnp_tok,
    ACTIONS(236), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(356), 1,
      anon_sym_LPAREN,
    ACTIONS(362), 1,
      sym_string,
    ACTIONS(466), 1,
      sym_integer,
    ACTIONS(468), 1,
      sym_real,
    STATE(74), 1,
      sym__name,
    ACTIONS(210), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(214), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(98), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(102), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(218), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(216), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(81), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(212), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5672] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(436), 1,
      sym_string,
    ACTIONS(470), 1,
      sym_integer,
    ACTIONS(472), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(210), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(191), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5773] = 22,
    ACTIONS(206), 1,
      sym_fn_tok,
    ACTIONS(208), 1,
      sym_not_tok,
    ACTIONS(216), 1,
      sym_scrnp_tok,
    ACTIONS(236), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(356), 1,
      anon_sym_LPAREN,
    ACTIONS(362), 1,
      sym_string,
    ACTIONS(474), 1,
      sym_integer,
    ACTIONS(476), 1,
      sym_real,
    STATE(74), 1,
      sym__name,
    ACTIONS(210), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(214), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(98), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(102), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(218), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(216), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(83), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(212), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5874] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(478), 1,
      sym_integer,
    ACTIONS(480), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(165), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [5975] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(482), 1,
      sym_integer,
    ACTIONS(484), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(170), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6076] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(486), 1,
      sym_integer,
    ACTIONS(488), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(205), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6177] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(490), 1,
      sym_integer,
    ACTIONS(492), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(193), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6278] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(494), 1,
      sym_integer,
    ACTIONS(496), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(167), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6379] = 22,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(242), 1,
      sym_fn_tok,
    ACTIONS(244), 1,
      sym_not_tok,
    ACTIONS(252), 1,
      sym_scrnp_tok,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym_string,
    ACTIONS(498), 1,
      sym_integer,
    ACTIONS(500), 1,
      sym_real,
    STATE(112), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(246), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(250), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(254), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(212), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(202), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(248), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6480] = 22,
    ACTIONS(206), 1,
      sym_fn_tok,
    ACTIONS(208), 1,
      sym_not_tok,
    ACTIONS(216), 1,
      sym_scrnp_tok,
    ACTIONS(236), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(356), 1,
      anon_sym_LPAREN,
    ACTIONS(362), 1,
      sym_string,
    ACTIONS(502), 1,
      sym_integer,
    ACTIONS(504), 1,
      sym_real,
    STATE(74), 1,
      sym__name,
    ACTIONS(210), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(214), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(98), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(102), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(218), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(216), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(79), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(212), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6581] = 22,
    ACTIONS(206), 1,
      sym_fn_tok,
    ACTIONS(208), 1,
      sym_not_tok,
    ACTIONS(216), 1,
      sym_scrnp_tok,
    ACTIONS(236), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(356), 1,
      anon_sym_LPAREN,
    ACTIONS(362), 1,
      sym_string,
    ACTIONS(506), 1,
      sym_integer,
    ACTIONS(508), 1,
      sym_real,
    STATE(74), 1,
      sym__name,
    ACTIONS(210), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(214), 2,
      sym_fre_tok,
      sym_pos_tok,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(98), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(102), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    ACTIONS(218), 3,
      sym_len_tok,
      sym_val_tok,
      sym_asc_tok,
    STATE(216), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
    STATE(80), 8,
      sym_fcall,
      sym__aexpr,
      sym_unary_aexpr,
      sym_binary_aexpr,
      sym__parenthesized_aexpr,
      sym__avar,
      sym_intvar,
      sym_realvar,
    ACTIONS(212), 14,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_pdl_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
  [6682] = 6,
    ACTIONS(514), 1,
      anon_sym_LPAREN,
    ACTIONS(516), 1,
      anon_sym_PERCENT,
    ACTIONS(518), 1,
      anon_sym_DOLLAR,
    STATE(91), 1,
      sym_subscript,
    ACTIONS(512), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(510), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [6747] = 6,
    ACTIONS(514), 1,
      anon_sym_LPAREN,
    ACTIONS(516), 1,
      anon_sym_PERCENT,
    ACTIONS(520), 1,
      anon_sym_DOLLAR,
    STATE(91), 1,
      sym_subscript,
    ACTIONS(512), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(510), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [6812] = 2,
    ACTIONS(524), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(522), 48,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
  [6868] = 4,
    ACTIONS(530), 1,
      sym_pow_tok,
    STATE(71), 1,
      sym__relop,
    ACTIONS(528), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(526), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [6927] = 4,
    ACTIONS(514), 1,
      anon_sym_LPAREN,
    STATE(100), 1,
      sym_subscript,
    ACTIONS(534), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(532), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [6986] = 3,
    STATE(148), 1,
      sym__sop,
    ACTIONS(528), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(526), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7043] = 6,
    ACTIONS(528), 1,
      sym_integer,
    ACTIONS(530), 1,
      sym_pow_tok,
    STATE(71), 1,
      sym__relop,
    ACTIONS(536), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(538), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(526), 43,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7106] = 10,
    ACTIONS(528), 1,
      sym_integer,
    ACTIONS(530), 1,
      sym_pow_tok,
    ACTIONS(540), 1,
      sym_and_tok,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    STATE(71), 1,
      sym__relop,
    ACTIONS(536), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(538), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(526), 39,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_or_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7177] = 9,
    ACTIONS(528), 1,
      sym_integer,
    ACTIONS(530), 1,
      sym_pow_tok,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    STATE(71), 1,
      sym__relop,
    ACTIONS(536), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(538), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(526), 40,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_and_tok,
      sym_or_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7246] = 3,
    STATE(71), 1,
      sym__relop,
    ACTIONS(528), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(526), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7303] = 5,
    ACTIONS(530), 1,
      sym_pow_tok,
    STATE(71), 1,
      sym__relop,
    ACTIONS(538), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(528), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(526), 43,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7364] = 3,
    STATE(148), 1,
      sym__sop,
    ACTIONS(550), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(548), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7421] = 11,
    ACTIONS(530), 1,
      sym_pow_tok,
    ACTIONS(540), 1,
      sym_and_tok,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(554), 1,
      sym_or_tok,
    ACTIONS(556), 1,
      sym_integer,
    STATE(71), 1,
      sym__relop,
    ACTIONS(536), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(538), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(552), 38,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7494] = 3,
    STATE(71), 1,
      sym__relop,
    ACTIONS(560), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(558), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7551] = 4,
    ACTIONS(514), 1,
      anon_sym_LPAREN,
    STATE(101), 1,
      sym_subscript,
    ACTIONS(564), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(562), 45,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7610] = 2,
    ACTIONS(568), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(566), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7664] = 2,
    ACTIONS(572), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(570), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7718] = 2,
    ACTIONS(576), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(574), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7772] = 2,
    ACTIONS(580), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(578), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7826] = 2,
    ACTIONS(584), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(582), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7880] = 2,
    ACTIONS(588), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(586), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7934] = 2,
    ACTIONS(592), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(590), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [7988] = 2,
    ACTIONS(596), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(594), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8042] = 2,
    ACTIONS(600), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(598), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8096] = 2,
    ACTIONS(604), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(602), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8150] = 2,
    ACTIONS(608), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(606), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8204] = 2,
    ACTIONS(612), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(610), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8258] = 2,
    ACTIONS(616), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(614), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8312] = 2,
    ACTIONS(620), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(618), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8366] = 2,
    ACTIONS(624), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(622), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8420] = 2,
    ACTIONS(628), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(626), 46,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8474] = 8,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(630), 1,
      sym_plus_tok,
    STATE(146), 1,
      sym__relop,
    STATE(148), 1,
      sym__sop,
    ACTIONS(556), 2,
      sym_minus_tok,
      sym_integer,
    ACTIONS(552), 38,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8537] = 3,
    ACTIONS(636), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(634), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(632), 36,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8585] = 2,
    ACTIONS(638), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(190), 36,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      sym_real,
      sym_string,
  [8629] = 3,
    ACTIONS(644), 2,
      sym_eq_tok,
      sym_less_tok,
    ACTIONS(642), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(640), 33,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      sym_real,
      sym_string,
  [8674] = 3,
    ACTIONS(644), 2,
      sym_gtr_tok,
      sym_less_tok,
    ACTIONS(642), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(640), 33,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      sym_real,
      sym_string,
  [8719] = 3,
    ACTIONS(644), 2,
      sym_gtr_tok,
      sym_eq_tok,
    ACTIONS(642), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(640), 33,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      sym_real,
      sym_string,
  [8764] = 2,
    ACTIONS(648), 3,
      sym_plus_tok,
      sym_minus_tok,
      sym_integer,
    ACTIONS(646), 33,
      sym__ext_name,
      sym_tabp_tok,
      sym_fn_tok,
      sym_spcp_tok,
      sym_not_tok,
      sym_sgn_tok,
      sym_int_tok,
      sym_abs_tok,
      sym_usr_tok,
      sym_fre_tok,
      sym_scrnp_tok,
      sym_pdl_tok,
      sym_pos_tok,
      sym_sqr_tok,
      sym_rnd_tok,
      sym_log_tok,
      sym_exp_tok,
      sym_cos_tok,
      sym_sin_tok,
      sym_tan_tok,
      sym_atn_tok,
      sym_peek_tok,
      sym_len_tok,
      sym_str_tok,
      sym_val_tok,
      sym_asc_tok,
      sym_chr_tok,
      sym_left_tok,
      sym_right_tok,
      sym_mid_tok,
      anon_sym_LPAREN,
      sym_real,
      sym_string,
  [8805] = 14,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(650), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      sym_string,
    STATE(112), 1,
      sym__name,
    STATE(213), 1,
      sym_svar,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(238), 4,
      sym__var,
      sym__avar,
      sym_intvar,
      sym_realvar,
    STATE(268), 4,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
  [8860] = 5,
    ACTIONS(520), 1,
      anon_sym_DOLLAR,
    ACTIONS(654), 1,
      anon_sym_LPAREN,
    ACTIONS(656), 1,
      anon_sym_PERCENT,
    STATE(137), 1,
      sym_subscript,
    ACTIONS(510), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [8896] = 3,
    ACTIONS(654), 1,
      anon_sym_LPAREN,
    STATE(126), 1,
      sym_subscript,
    ACTIONS(562), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [8927] = 1,
    ACTIONS(522), 24,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
  [8954] = 2,
    STATE(151), 1,
      sym__sop,
    ACTIONS(548), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [8982] = 3,
    ACTIONS(654), 1,
      anon_sym_LPAREN,
    STATE(134), 1,
      sym_subscript,
    ACTIONS(532), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9012] = 1,
    ACTIONS(602), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9037] = 5,
    ACTIONS(662), 1,
      sym_pow_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(526), 16,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9070] = 2,
    STATE(46), 1,
      sym__relop,
    ACTIONS(558), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9097] = 9,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(526), 12,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_or_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9138] = 1,
    ACTIONS(598), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9163] = 2,
    STATE(151), 1,
      sym__sop,
    ACTIONS(526), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9190] = 8,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(526), 13,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_and_tok,
      sym_or_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9229] = 1,
    ACTIONS(582), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9254] = 1,
    ACTIONS(566), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9279] = 1,
    ACTIONS(618), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9304] = 1,
    ACTIONS(594), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9329] = 1,
    ACTIONS(570), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9354] = 1,
    ACTIONS(626), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9379] = 3,
    ACTIONS(662), 1,
      sym_pow_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(526), 20,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9408] = 2,
    STATE(46), 1,
      sym__relop,
    ACTIONS(526), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9435] = 4,
    ACTIONS(662), 1,
      sym_pow_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(526), 18,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9466] = 1,
    ACTIONS(610), 22,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9491] = 1,
    ACTIONS(614), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9515] = 1,
    ACTIONS(590), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9539] = 1,
    ACTIONS(586), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9563] = 1,
    ACTIONS(578), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9587] = 1,
    ACTIONS(622), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9611] = 1,
    ACTIONS(606), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9635] = 1,
    ACTIONS(574), 21,
      sym_goto_tok,
      sym_gosub_tok,
      sym_to_tok,
      sym_then_tok,
      sym_at_tok,
      sym_step_tok,
      sym_plus_tok,
      sym_minus_tok,
      sym_times_tok,
      sym_div_tok,
      sym_pow_tok,
      sym_and_tok,
      sym_or_tok,
      sym_gtr_tok,
      sym_eq_tok,
      sym_less_tok,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [9659] = 10,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(650), 1,
      anon_sym_LPAREN,
    ACTIONS(666), 1,
      sym_string,
    STATE(291), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(227), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [9698] = 10,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(650), 1,
      anon_sym_LPAREN,
    ACTIONS(668), 1,
      sym_string,
    STATE(291), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(278), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [9737] = 10,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(650), 1,
      anon_sym_LPAREN,
    ACTIONS(670), 1,
      sym_string,
    STATE(291), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(265), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [9776] = 10,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(650), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      sym_string,
    STATE(291), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(122), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [9815] = 10,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(650), 1,
      anon_sym_LPAREN,
    ACTIONS(674), 1,
      sym_string,
    STATE(291), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(261), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [9854] = 10,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(224), 1,
      sym_mid_tok,
    ACTIONS(676), 1,
      anon_sym_LPAREN,
    ACTIONS(678), 1,
      sym_string,
    STATE(304), 1,
      sym__name,
    ACTIONS(204), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(220), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(222), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(97), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(78), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [9893] = 10,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(650), 1,
      anon_sym_LPAREN,
    ACTIONS(680), 1,
      sym_string,
    STATE(291), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(273), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [9932] = 10,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(224), 1,
      sym_mid_tok,
    ACTIONS(676), 1,
      anon_sym_LPAREN,
    ACTIONS(682), 1,
      sym_string,
    STATE(304), 1,
      sym__name,
    ACTIONS(204), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(220), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(222), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(97), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(84), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [9971] = 10,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(650), 1,
      anon_sym_LPAREN,
    ACTIONS(684), 1,
      sym_string,
    STATE(291), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(239), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10010] = 10,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(650), 1,
      anon_sym_LPAREN,
    ACTIONS(686), 1,
      sym_string,
    STATE(291), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(260), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10049] = 10,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(650), 1,
      anon_sym_LPAREN,
    ACTIONS(688), 1,
      sym_string,
    STATE(291), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(115), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10088] = 10,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(650), 1,
      anon_sym_LPAREN,
    ACTIONS(690), 1,
      sym_string,
    STATE(291), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(259), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10127] = 10,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(650), 1,
      anon_sym_LPAREN,
    ACTIONS(692), 1,
      sym_string,
    STATE(291), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(274), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10166] = 10,
    ACTIONS(61), 1,
      sym__ext_name,
    ACTIONS(260), 1,
      sym_mid_tok,
    ACTIONS(650), 1,
      anon_sym_LPAREN,
    ACTIONS(694), 1,
      sym_string,
    STATE(291), 1,
      sym__name,
    ACTIONS(240), 2,
      sym_tabp_tok,
      sym_spcp_tok,
    ACTIONS(256), 2,
      sym_str_tok,
      sym_chr_tok,
    ACTIONS(258), 2,
      sym_left_tok,
      sym_right_tok,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(276), 5,
      sym_sfcall,
      sym__sexpr,
      sym_binary_sexpr,
      sym__parenthesized_sexpr,
      sym_svar,
  [10205] = 12,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(696), 1,
      sym_to_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    STATE(46), 1,
      sym__relop,
    STATE(224), 1,
      aux_sym_statement_repeat4,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(700), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [10246] = 12,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(696), 1,
      sym_to_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    STATE(46), 1,
      sym__relop,
    STATE(221), 1,
      aux_sym_statement_repeat4,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(702), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [10287] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(704), 4,
      sym_to_tok,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [10323] = 11,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(706), 1,
      sym_at_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(228), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [10361] = 11,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(708), 1,
      sym_step_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(710), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [10399] = 11,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(712), 1,
      anon_sym_COMMA,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(700), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [10437] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(714), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [10472] = 12,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(716), 1,
      anon_sym_COMMA,
    ACTIONS(718), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    STATE(275), 1,
      aux_sym_subscript_repeat1,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [10511] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(228), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [10546] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(552), 3,
      sym_goto_tok,
      sym_then_tok,
      anon_sym_RPAREN,
  [10581] = 12,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(716), 1,
      anon_sym_COMMA,
    ACTIONS(720), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    STATE(266), 1,
      aux_sym_subscript_repeat1,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [10620] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(700), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [10655] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(722), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [10690] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(724), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [10725] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(710), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [10760] = 11,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(726), 1,
      anon_sym_COMMA,
    ACTIONS(728), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [10796] = 6,
    ACTIONS(61), 1,
      sym__ext_name,
    STATE(112), 1,
      sym__name,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(220), 5,
      sym__var,
      sym__avar,
      sym_intvar,
      sym_realvar,
      sym_svar,
  [10822] = 11,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(730), 1,
      anon_sym_COMMA,
    ACTIONS(732), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [10858] = 6,
    ACTIONS(61), 1,
      sym__ext_name,
    STATE(112), 1,
      sym__name,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(243), 5,
      sym__var,
      sym__avar,
      sym_intvar,
      sym_realvar,
      sym_svar,
  [10884] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(734), 2,
      sym_goto_tok,
      sym_gosub_tok,
  [10918] = 6,
    ACTIONS(61), 1,
      sym__ext_name,
    STATE(112), 1,
      sym__name,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(238), 5,
      sym__var,
      sym__avar,
      sym_intvar,
      sym_realvar,
      sym_svar,
  [10944] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
    ACTIONS(736), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [10978] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(738), 1,
      anon_sym_COMMA,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11011] = 6,
    ACTIONS(61), 1,
      sym__ext_name,
    STATE(112), 1,
      sym__name,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(245), 4,
      sym_intvar,
      sym_realvar,
      sym_svar,
      sym__dim_item,
  [11036] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(740), 1,
      anon_sym_COMMA,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11069] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(742), 1,
      anon_sym_COMMA,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11102] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(744), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11135] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(746), 1,
      anon_sym_COMMA,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11168] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(748), 1,
      anon_sym_COMMA,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11201] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(750), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11234] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(752), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11267] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(754), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11300] = 6,
    ACTIONS(61), 1,
      sym__ext_name,
    STATE(208), 1,
      sym__name,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    ACTIONS(238), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
    STATE(218), 3,
      sym__avar,
      sym_intvar,
      sym_realvar,
  [11325] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(756), 1,
      anon_sym_COMMA,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11358] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(712), 1,
      sym_at_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11391] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(712), 1,
      anon_sym_COMMA,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11424] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(758), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11457] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(760), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11490] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(762), 1,
      anon_sym_COMMA,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11523] = 6,
    ACTIONS(61), 1,
      sym__ext_name,
    STATE(112), 1,
      sym__name,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(231), 4,
      sym_intvar,
      sym_realvar,
      sym_svar,
      sym__dim_item,
  [11548] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(764), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11581] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(766), 1,
      anon_sym_COMMA,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11614] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(768), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11647] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(732), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11680] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(770), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11713] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(772), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11746] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(774), 1,
      sym_to_tok,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11779] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(728), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11812] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(776), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11845] = 7,
    ACTIONS(61), 1,
      sym__ext_name,
    STATE(112), 1,
      sym__name,
    STATE(318), 1,
      sym_svar,
    STATE(117), 2,
      sym__string_scalar,
      sym__string_array,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(301), 3,
      sym__avar,
      sym_intvar,
      sym_realvar,
  [11872] = 10,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(662), 1,
      sym_pow_tok,
    ACTIONS(664), 1,
      sym_and_tok,
    ACTIONS(698), 1,
      sym_or_tok,
    ACTIONS(778), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__relop,
    ACTIONS(658), 2,
      sym_plus_tok,
      sym_minus_tok,
    ACTIONS(660), 2,
      sym_times_tok,
      sym_div_tok,
  [11905] = 7,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(780), 1,
      sym_plus_tok,
    STATE(144), 1,
      sym__relop,
    STATE(151), 1,
      sym__sop,
    ACTIONS(552), 3,
      sym_goto_tok,
      sym_then_tok,
      anon_sym_RPAREN,
  [11929] = 5,
    ACTIONS(61), 1,
      sym__ext_name,
    STATE(208), 1,
      sym__name,
    STATE(138), 2,
      sym__real_scalar,
      sym__real_array,
    STATE(139), 2,
      sym__int_scalar,
      sym__int_array,
    STATE(244), 3,
      sym__avar,
      sym_intvar,
      sym_realvar,
  [11949] = 4,
    ACTIONS(654), 1,
      anon_sym_LPAREN,
    ACTIONS(656), 1,
      anon_sym_PERCENT,
    STATE(137), 1,
      sym_subscript,
    ACTIONS(510), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [11965] = 7,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(780), 1,
      sym_plus_tok,
    ACTIONS(782), 1,
      anon_sym_RPAREN,
    STATE(144), 1,
      sym__relop,
    STATE(151), 1,
      sym__sop,
  [11987] = 7,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(780), 1,
      sym_plus_tok,
    ACTIONS(784), 1,
      anon_sym_RPAREN,
    STATE(144), 1,
      sym__relop,
    STATE(151), 1,
      sym__sop,
  [12009] = 2,
    STATE(237), 1,
      sym__data_item,
    ACTIONS(786), 5,
      sym_integer,
      sym_literal,
      sym_real,
      sym_real_data_item,
      sym_string,
  [12020] = 6,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(780), 1,
      sym_plus_tok,
    STATE(144), 1,
      sym__relop,
    STATE(151), 1,
      sym__sop,
  [12039] = 2,
    ACTIONS(788), 2,
      sym_plus_tok,
      anon_sym_SEMI,
    ACTIONS(790), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12050] = 3,
    ACTIONS(794), 1,
      sym_linenum,
    ACTIONS(792), 2,
      sym_minus_tok,
      anon_sym_COMMA,
    ACTIONS(238), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12063] = 2,
    STATE(252), 1,
      sym__data_item,
    ACTIONS(796), 5,
      sym_integer,
      sym_literal,
      sym_real,
      sym_real_data_item,
      sym_string,
  [12074] = 6,
    ACTIONS(542), 1,
      sym_gtr_tok,
    ACTIONS(544), 1,
      sym_eq_tok,
    ACTIONS(546), 1,
      sym_less_tok,
    ACTIONS(780), 1,
      sym_plus_tok,
    STATE(146), 1,
      sym__relop,
    STATE(151), 1,
      sym__sop,
  [12093] = 3,
    ACTIONS(798), 1,
      anon_sym_COMMA,
    STATE(222), 1,
      aux_sym_statement_repeat1,
    ACTIONS(800), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12105] = 3,
    ACTIONS(802), 1,
      anon_sym_COMMA,
    STATE(241), 1,
      aux_sym_statement_repeat5,
    ACTIONS(228), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12117] = 4,
    ACTIONS(7), 1,
      sym_linenum,
    ACTIONS(804), 1,
      ts_builtin_sym_end,
    ACTIONS(806), 1,
      sym__empty_line,
    STATE(233), 2,
      sym_line,
      aux_sym_source_file_repeat1,
  [12131] = 3,
    ACTIONS(808), 1,
      anon_sym_COMMA,
    STATE(240), 1,
      aux_sym_statement_repeat3,
    ACTIONS(700), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12143] = 3,
    ACTIONS(696), 1,
      sym_to_tok,
    STATE(223), 1,
      aux_sym_statement_repeat4,
    ACTIONS(710), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12155] = 3,
    ACTIONS(810), 1,
      anon_sym_COMMA,
    STATE(222), 1,
      aux_sym_statement_repeat1,
    ACTIONS(813), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12167] = 3,
    ACTIONS(815), 1,
      sym_to_tok,
    STATE(223), 1,
      aux_sym_statement_repeat4,
    ACTIONS(818), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12179] = 3,
    ACTIONS(696), 1,
      sym_to_tok,
    STATE(223), 1,
      aux_sym_statement_repeat4,
    ACTIONS(702), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12191] = 3,
    ACTIONS(820), 1,
      anon_sym_COMMA,
    STATE(225), 1,
      aux_sym_statement_repeat6,
    ACTIONS(823), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12203] = 3,
    ACTIONS(825), 1,
      anon_sym_COMMA,
    STATE(236), 1,
      aux_sym_statement_repeat6,
    ACTIONS(700), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12215] = 3,
    ACTIONS(780), 1,
      sym_plus_tok,
    STATE(151), 1,
      sym__sop,
    ACTIONS(724), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12227] = 3,
    ACTIONS(827), 1,
      anon_sym_COMMA,
    STATE(228), 1,
      aux_sym_statement_repeat2,
    ACTIONS(830), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12239] = 2,
    ACTIONS(832), 2,
      sym_minus_tok,
      anon_sym_COMMA,
    ACTIONS(228), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12249] = 3,
    ACTIONS(834), 1,
      anon_sym_COMMA,
    STATE(228), 1,
      aux_sym_statement_repeat2,
    ACTIONS(800), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12261] = 3,
    ACTIONS(834), 1,
      anon_sym_COMMA,
    STATE(230), 1,
      aux_sym_statement_repeat2,
    ACTIONS(228), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12273] = 3,
    ACTIONS(836), 1,
      anon_sym_COMMA,
    STATE(232), 1,
      aux_sym_statement_repeat3,
    ACTIONS(839), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12285] = 4,
    ACTIONS(841), 1,
      ts_builtin_sym_end,
    ACTIONS(843), 1,
      sym__empty_line,
    ACTIONS(846), 1,
      sym_linenum,
    STATE(233), 2,
      sym_line,
      aux_sym_source_file_repeat1,
  [12299] = 3,
    ACTIONS(849), 1,
      anon_sym_COMMA,
    STATE(234), 1,
      aux_sym_statement_repeat5,
    ACTIONS(852), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12311] = 3,
    ACTIONS(808), 1,
      anon_sym_COMMA,
    STATE(232), 1,
      aux_sym_statement_repeat3,
    ACTIONS(800), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12323] = 3,
    ACTIONS(825), 1,
      anon_sym_COMMA,
    STATE(225), 1,
      aux_sym_statement_repeat6,
    ACTIONS(702), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12335] = 3,
    ACTIONS(798), 1,
      anon_sym_COMMA,
    STATE(217), 1,
      aux_sym_statement_repeat1,
    ACTIONS(228), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12347] = 3,
    ACTIONS(808), 1,
      anon_sym_COMMA,
    STATE(235), 1,
      aux_sym_statement_repeat3,
    ACTIONS(228), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12359] = 3,
    ACTIONS(780), 1,
      sym_plus_tok,
    STATE(151), 1,
      sym__sop,
    ACTIONS(722), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12371] = 3,
    ACTIONS(808), 1,
      anon_sym_COMMA,
    STATE(232), 1,
      aux_sym_statement_repeat3,
    ACTIONS(702), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12383] = 3,
    ACTIONS(802), 1,
      anon_sym_COMMA,
    STATE(234), 1,
      aux_sym_statement_repeat5,
    ACTIONS(800), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12395] = 2,
    ACTIONS(854), 1,
      sym_linenum,
    ACTIONS(238), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12404] = 1,
    ACTIONS(839), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12411] = 1,
    ACTIONS(852), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12418] = 1,
    ACTIONS(830), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12425] = 2,
    ACTIONS(63), 1,
      sym_linenum,
    ACTIONS(800), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12434] = 2,
    ACTIONS(856), 1,
      sym_linenum,
    ACTIONS(228), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12443] = 2,
    ACTIONS(858), 1,
      sym_comment_text,
    ACTIONS(860), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12452] = 1,
    ACTIONS(823), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12459] = 2,
    ACTIONS(864), 1,
      anon_sym_PERCENT,
    ACTIONS(862), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12468] = 3,
    ACTIONS(61), 1,
      sym__ext_name,
    STATE(250), 1,
      sym__name,
    STATE(258), 2,
      sym_real_scalar,
      sym_int_scalar,
  [12479] = 1,
    ACTIONS(813), 4,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12486] = 1,
    ACTIONS(866), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12492] = 3,
    ACTIONS(61), 1,
      sym__ext_name,
    STATE(279), 1,
      sym__name,
    STATE(298), 1,
      sym_real_scalar,
  [12502] = 1,
    ACTIONS(700), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12508] = 1,
    ACTIONS(238), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12514] = 3,
    ACTIONS(61), 1,
      sym__ext_name,
    STATE(306), 1,
      sym__name,
    STATE(313), 1,
      sym_fn_name,
  [12524] = 1,
    ACTIONS(228), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12530] = 3,
    ACTIONS(780), 1,
      sym_plus_tok,
    ACTIONS(868), 1,
      anon_sym_COMMA,
    STATE(151), 1,
      sym__sop,
  [12540] = 3,
    ACTIONS(780), 1,
      sym_plus_tok,
    ACTIONS(870), 1,
      anon_sym_COMMA,
    STATE(151), 1,
      sym__sop,
  [12550] = 3,
    ACTIONS(780), 1,
      sym_plus_tok,
    ACTIONS(872), 1,
      anon_sym_COMMA,
    STATE(151), 1,
      sym__sop,
  [12560] = 3,
    ACTIONS(61), 1,
      sym__ext_name,
    STATE(279), 1,
      sym__name,
    STATE(290), 1,
      sym_real_scalar,
  [12570] = 3,
    ACTIONS(61), 1,
      sym__ext_name,
    STATE(302), 1,
      sym_fn_name,
    STATE(306), 1,
      sym__name,
  [12580] = 3,
    ACTIONS(61), 1,
      sym__ext_name,
    STATE(296), 1,
      sym_fn_name,
    STATE(306), 1,
      sym__name,
  [12590] = 3,
    ACTIONS(754), 1,
      anon_sym_RPAREN,
    ACTIONS(780), 1,
      sym_plus_tok,
    STATE(151), 1,
      sym__sop,
  [12600] = 3,
    ACTIONS(716), 1,
      anon_sym_COMMA,
    ACTIONS(874), 1,
      anon_sym_RPAREN,
    STATE(271), 1,
      aux_sym_subscript_repeat1,
  [12610] = 1,
    ACTIONS(876), 3,
      ts_builtin_sym_end,
      sym__empty_line,
      sym_linenum,
  [12616] = 3,
    ACTIONS(780), 1,
      sym_plus_tok,
    ACTIONS(878), 1,
      anon_sym_SEMI,
    STATE(151), 1,
      sym__sop,
  [12626] = 1,
    ACTIONS(880), 3,
      ts_builtin_sym_end,
      sym__empty_line,
      sym_linenum,
  [12632] = 2,
    ACTIONS(882), 1,
      anon_sym_COLON,
    ACTIONS(884), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12640] = 3,
    ACTIONS(736), 1,
      anon_sym_RPAREN,
    ACTIONS(886), 1,
      anon_sym_COMMA,
    STATE(271), 1,
      aux_sym_subscript_repeat1,
  [12650] = 2,
    ACTIONS(882), 1,
      anon_sym_COLON,
    ACTIONS(889), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12658] = 3,
    ACTIONS(780), 1,
      sym_plus_tok,
    ACTIONS(784), 1,
      anon_sym_RPAREN,
    STATE(151), 1,
      sym__sop,
  [12668] = 3,
    ACTIONS(780), 1,
      sym_plus_tok,
    ACTIONS(891), 1,
      anon_sym_COMMA,
    STATE(151), 1,
      sym__sop,
  [12678] = 3,
    ACTIONS(716), 1,
      anon_sym_COMMA,
    ACTIONS(893), 1,
      anon_sym_RPAREN,
    STATE(271), 1,
      aux_sym_subscript_repeat1,
  [12688] = 3,
    ACTIONS(770), 1,
      anon_sym_RPAREN,
    ACTIONS(780), 1,
      sym_plus_tok,
    STATE(151), 1,
      sym__sop,
  [12698] = 1,
    ACTIONS(800), 3,
      anon_sym_COLON,
      anon_sym_LF,
      anon_sym_CR_LF,
  [12704] = 3,
    ACTIONS(780), 1,
      sym_plus_tok,
    ACTIONS(782), 1,
      anon_sym_RPAREN,
    STATE(151), 1,
      sym__sop,
  [12714] = 1,
    ACTIONS(862), 2,
      sym_eq_tok,
      anon_sym_RPAREN,
  [12719] = 2,
    ACTIONS(895), 1,
      sym_goto_tok,
    ACTIONS(897), 1,
      sym_then_tok,
  [12726] = 2,
    ACTIONS(895), 1,
      sym_goto_tok,
    ACTIONS(899), 1,
      sym_then_tok,
  [12733] = 2,
    ACTIONS(858), 1,
      sym_comment_text,
    ACTIONS(860), 1,
      anon_sym_COLON,
  [12740] = 1,
    ACTIONS(901), 1,
      anon_sym_LPAREN,
  [12744] = 1,
    ACTIONS(882), 1,
      anon_sym_COLON,
  [12748] = 1,
    ACTIONS(708), 1,
      sym_eq_tok,
  [12752] = 1,
    ACTIONS(903), 1,
      sym_eq_tok,
  [12756] = 1,
    ACTIONS(905), 1,
      ts_builtin_sym_end,
  [12760] = 1,
    ACTIONS(907), 1,
      sym__ext_name,
  [12764] = 1,
    ACTIONS(770), 1,
      anon_sym_RPAREN,
  [12768] = 1,
    ACTIONS(909), 1,
      sym_eq_tok,
  [12772] = 1,
    ACTIONS(520), 1,
      anon_sym_DOLLAR,
  [12776] = 1,
    ACTIONS(911), 1,
      anon_sym_LPAREN,
  [12780] = 1,
    ACTIONS(913), 1,
      sym_eq_tok,
  [12784] = 1,
    ACTIONS(915), 1,
      sym_linenum,
  [12788] = 1,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
  [12792] = 1,
    ACTIONS(919), 1,
      anon_sym_LPAREN,
  [12796] = 1,
    ACTIONS(921), 1,
      sym_goto_tok,
  [12800] = 1,
    ACTIONS(923), 1,
      anon_sym_RPAREN,
  [12804] = 1,
    ACTIONS(925), 1,
      sym_linenum,
  [12808] = 1,
    ACTIONS(854), 1,
      sym_linenum,
  [12812] = 1,
    ACTIONS(927), 1,
      sym_eq_tok,
  [12816] = 1,
    ACTIONS(756), 1,
      anon_sym_LPAREN,
  [12820] = 1,
    ACTIONS(929), 1,
      sym_fn_tok,
  [12824] = 1,
    ACTIONS(518), 1,
      anon_sym_DOLLAR,
  [12828] = 1,
    ACTIONS(931), 1,
      sym_linenum,
  [12832] = 1,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
  [12836] = 1,
    ACTIONS(895), 1,
      anon_sym_COMMA,
  [12840] = 1,
    ACTIONS(935), 1,
      anon_sym_LPAREN,
  [12844] = 1,
    ACTIONS(937), 1,
      anon_sym_LPAREN,
  [12848] = 1,
    ACTIONS(939), 1,
      anon_sym_LPAREN,
  [12852] = 1,
    ACTIONS(941), 1,
      anon_sym_LPAREN,
  [12856] = 1,
    ACTIONS(943), 1,
      anon_sym_LPAREN,
  [12860] = 1,
    ACTIONS(748), 1,
      anon_sym_LPAREN,
  [12864] = 1,
    ACTIONS(754), 1,
      anon_sym_RPAREN,
  [12868] = 1,
    ACTIONS(945), 1,
      anon_sym_LPAREN,
  [12872] = 1,
    ACTIONS(947), 1,
      anon_sym_LPAREN,
  [12876] = 1,
    ACTIONS(63), 1,
      sym_linenum,
  [12880] = 1,
    ACTIONS(949), 1,
      sym_eq_tok,
  [12884] = 1,
    ACTIONS(951), 1,
      sym__ext_name,
  [12888] = 1,
    ACTIONS(856), 1,
      sym_linenum,
  [12892] = 1,
    ACTIONS(953), 1,
      anon_sym_LPAREN,
  [12896] = 1,
    ACTIONS(955), 1,
      anon_sym_LPAREN,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(7)] = 0,
  [SMALL_STATE(8)] = 69,
  [SMALL_STATE(9)] = 181,
  [SMALL_STATE(10)] = 293,
  [SMALL_STATE(11)] = 405,
  [SMALL_STATE(12)] = 509,
  [SMALL_STATE(13)] = 613,
  [SMALL_STATE(14)] = 717,
  [SMALL_STATE(15)] = 821,
  [SMALL_STATE(16)] = 925,
  [SMALL_STATE(17)] = 1026,
  [SMALL_STATE(18)] = 1127,
  [SMALL_STATE(19)] = 1228,
  [SMALL_STATE(20)] = 1329,
  [SMALL_STATE(21)] = 1430,
  [SMALL_STATE(22)] = 1531,
  [SMALL_STATE(23)] = 1632,
  [SMALL_STATE(24)] = 1733,
  [SMALL_STATE(25)] = 1834,
  [SMALL_STATE(26)] = 1935,
  [SMALL_STATE(27)] = 2036,
  [SMALL_STATE(28)] = 2137,
  [SMALL_STATE(29)] = 2238,
  [SMALL_STATE(30)] = 2339,
  [SMALL_STATE(31)] = 2440,
  [SMALL_STATE(32)] = 2541,
  [SMALL_STATE(33)] = 2642,
  [SMALL_STATE(34)] = 2743,
  [SMALL_STATE(35)] = 2844,
  [SMALL_STATE(36)] = 2945,
  [SMALL_STATE(37)] = 3046,
  [SMALL_STATE(38)] = 3147,
  [SMALL_STATE(39)] = 3248,
  [SMALL_STATE(40)] = 3349,
  [SMALL_STATE(41)] = 3450,
  [SMALL_STATE(42)] = 3551,
  [SMALL_STATE(43)] = 3652,
  [SMALL_STATE(44)] = 3753,
  [SMALL_STATE(45)] = 3854,
  [SMALL_STATE(46)] = 3955,
  [SMALL_STATE(47)] = 4056,
  [SMALL_STATE(48)] = 4157,
  [SMALL_STATE(49)] = 4258,
  [SMALL_STATE(50)] = 4359,
  [SMALL_STATE(51)] = 4460,
  [SMALL_STATE(52)] = 4561,
  [SMALL_STATE(53)] = 4662,
  [SMALL_STATE(54)] = 4763,
  [SMALL_STATE(55)] = 4864,
  [SMALL_STATE(56)] = 4965,
  [SMALL_STATE(57)] = 5066,
  [SMALL_STATE(58)] = 5167,
  [SMALL_STATE(59)] = 5268,
  [SMALL_STATE(60)] = 5369,
  [SMALL_STATE(61)] = 5470,
  [SMALL_STATE(62)] = 5571,
  [SMALL_STATE(63)] = 5672,
  [SMALL_STATE(64)] = 5773,
  [SMALL_STATE(65)] = 5874,
  [SMALL_STATE(66)] = 5975,
  [SMALL_STATE(67)] = 6076,
  [SMALL_STATE(68)] = 6177,
  [SMALL_STATE(69)] = 6278,
  [SMALL_STATE(70)] = 6379,
  [SMALL_STATE(71)] = 6480,
  [SMALL_STATE(72)] = 6581,
  [SMALL_STATE(73)] = 6682,
  [SMALL_STATE(74)] = 6747,
  [SMALL_STATE(75)] = 6812,
  [SMALL_STATE(76)] = 6868,
  [SMALL_STATE(77)] = 6927,
  [SMALL_STATE(78)] = 6986,
  [SMALL_STATE(79)] = 7043,
  [SMALL_STATE(80)] = 7106,
  [SMALL_STATE(81)] = 7177,
  [SMALL_STATE(82)] = 7246,
  [SMALL_STATE(83)] = 7303,
  [SMALL_STATE(84)] = 7364,
  [SMALL_STATE(85)] = 7421,
  [SMALL_STATE(86)] = 7494,
  [SMALL_STATE(87)] = 7551,
  [SMALL_STATE(88)] = 7610,
  [SMALL_STATE(89)] = 7664,
  [SMALL_STATE(90)] = 7718,
  [SMALL_STATE(91)] = 7772,
  [SMALL_STATE(92)] = 7826,
  [SMALL_STATE(93)] = 7880,
  [SMALL_STATE(94)] = 7934,
  [SMALL_STATE(95)] = 7988,
  [SMALL_STATE(96)] = 8042,
  [SMALL_STATE(97)] = 8096,
  [SMALL_STATE(98)] = 8150,
  [SMALL_STATE(99)] = 8204,
  [SMALL_STATE(100)] = 8258,
  [SMALL_STATE(101)] = 8312,
  [SMALL_STATE(102)] = 8366,
  [SMALL_STATE(103)] = 8420,
  [SMALL_STATE(104)] = 8474,
  [SMALL_STATE(105)] = 8537,
  [SMALL_STATE(106)] = 8585,
  [SMALL_STATE(107)] = 8629,
  [SMALL_STATE(108)] = 8674,
  [SMALL_STATE(109)] = 8719,
  [SMALL_STATE(110)] = 8764,
  [SMALL_STATE(111)] = 8805,
  [SMALL_STATE(112)] = 8860,
  [SMALL_STATE(113)] = 8896,
  [SMALL_STATE(114)] = 8927,
  [SMALL_STATE(115)] = 8954,
  [SMALL_STATE(116)] = 8982,
  [SMALL_STATE(117)] = 9012,
  [SMALL_STATE(118)] = 9037,
  [SMALL_STATE(119)] = 9070,
  [SMALL_STATE(120)] = 9097,
  [SMALL_STATE(121)] = 9138,
  [SMALL_STATE(122)] = 9163,
  [SMALL_STATE(123)] = 9190,
  [SMALL_STATE(124)] = 9229,
  [SMALL_STATE(125)] = 9254,
  [SMALL_STATE(126)] = 9279,
  [SMALL_STATE(127)] = 9304,
  [SMALL_STATE(128)] = 9329,
  [SMALL_STATE(129)] = 9354,
  [SMALL_STATE(130)] = 9379,
  [SMALL_STATE(131)] = 9408,
  [SMALL_STATE(132)] = 9435,
  [SMALL_STATE(133)] = 9466,
  [SMALL_STATE(134)] = 9491,
  [SMALL_STATE(135)] = 9515,
  [SMALL_STATE(136)] = 9539,
  [SMALL_STATE(137)] = 9563,
  [SMALL_STATE(138)] = 9587,
  [SMALL_STATE(139)] = 9611,
  [SMALL_STATE(140)] = 9635,
  [SMALL_STATE(141)] = 9659,
  [SMALL_STATE(142)] = 9698,
  [SMALL_STATE(143)] = 9737,
  [SMALL_STATE(144)] = 9776,
  [SMALL_STATE(145)] = 9815,
  [SMALL_STATE(146)] = 9854,
  [SMALL_STATE(147)] = 9893,
  [SMALL_STATE(148)] = 9932,
  [SMALL_STATE(149)] = 9971,
  [SMALL_STATE(150)] = 10010,
  [SMALL_STATE(151)] = 10049,
  [SMALL_STATE(152)] = 10088,
  [SMALL_STATE(153)] = 10127,
  [SMALL_STATE(154)] = 10166,
  [SMALL_STATE(155)] = 10205,
  [SMALL_STATE(156)] = 10246,
  [SMALL_STATE(157)] = 10287,
  [SMALL_STATE(158)] = 10323,
  [SMALL_STATE(159)] = 10361,
  [SMALL_STATE(160)] = 10399,
  [SMALL_STATE(161)] = 10437,
  [SMALL_STATE(162)] = 10472,
  [SMALL_STATE(163)] = 10511,
  [SMALL_STATE(164)] = 10546,
  [SMALL_STATE(165)] = 10581,
  [SMALL_STATE(166)] = 10620,
  [SMALL_STATE(167)] = 10655,
  [SMALL_STATE(168)] = 10690,
  [SMALL_STATE(169)] = 10725,
  [SMALL_STATE(170)] = 10760,
  [SMALL_STATE(171)] = 10796,
  [SMALL_STATE(172)] = 10822,
  [SMALL_STATE(173)] = 10858,
  [SMALL_STATE(174)] = 10884,
  [SMALL_STATE(175)] = 10918,
  [SMALL_STATE(176)] = 10944,
  [SMALL_STATE(177)] = 10978,
  [SMALL_STATE(178)] = 11011,
  [SMALL_STATE(179)] = 11036,
  [SMALL_STATE(180)] = 11069,
  [SMALL_STATE(181)] = 11102,
  [SMALL_STATE(182)] = 11135,
  [SMALL_STATE(183)] = 11168,
  [SMALL_STATE(184)] = 11201,
  [SMALL_STATE(185)] = 11234,
  [SMALL_STATE(186)] = 11267,
  [SMALL_STATE(187)] = 11300,
  [SMALL_STATE(188)] = 11325,
  [SMALL_STATE(189)] = 11358,
  [SMALL_STATE(190)] = 11391,
  [SMALL_STATE(191)] = 11424,
  [SMALL_STATE(192)] = 11457,
  [SMALL_STATE(193)] = 11490,
  [SMALL_STATE(194)] = 11523,
  [SMALL_STATE(195)] = 11548,
  [SMALL_STATE(196)] = 11581,
  [SMALL_STATE(197)] = 11614,
  [SMALL_STATE(198)] = 11647,
  [SMALL_STATE(199)] = 11680,
  [SMALL_STATE(200)] = 11713,
  [SMALL_STATE(201)] = 11746,
  [SMALL_STATE(202)] = 11779,
  [SMALL_STATE(203)] = 11812,
  [SMALL_STATE(204)] = 11845,
  [SMALL_STATE(205)] = 11872,
  [SMALL_STATE(206)] = 11905,
  [SMALL_STATE(207)] = 11929,
  [SMALL_STATE(208)] = 11949,
  [SMALL_STATE(209)] = 11965,
  [SMALL_STATE(210)] = 11987,
  [SMALL_STATE(211)] = 12009,
  [SMALL_STATE(212)] = 12020,
  [SMALL_STATE(213)] = 12039,
  [SMALL_STATE(214)] = 12050,
  [SMALL_STATE(215)] = 12063,
  [SMALL_STATE(216)] = 12074,
  [SMALL_STATE(217)] = 12093,
  [SMALL_STATE(218)] = 12105,
  [SMALL_STATE(219)] = 12117,
  [SMALL_STATE(220)] = 12131,
  [SMALL_STATE(221)] = 12143,
  [SMALL_STATE(222)] = 12155,
  [SMALL_STATE(223)] = 12167,
  [SMALL_STATE(224)] = 12179,
  [SMALL_STATE(225)] = 12191,
  [SMALL_STATE(226)] = 12203,
  [SMALL_STATE(227)] = 12215,
  [SMALL_STATE(228)] = 12227,
  [SMALL_STATE(229)] = 12239,
  [SMALL_STATE(230)] = 12249,
  [SMALL_STATE(231)] = 12261,
  [SMALL_STATE(232)] = 12273,
  [SMALL_STATE(233)] = 12285,
  [SMALL_STATE(234)] = 12299,
  [SMALL_STATE(235)] = 12311,
  [SMALL_STATE(236)] = 12323,
  [SMALL_STATE(237)] = 12335,
  [SMALL_STATE(238)] = 12347,
  [SMALL_STATE(239)] = 12359,
  [SMALL_STATE(240)] = 12371,
  [SMALL_STATE(241)] = 12383,
  [SMALL_STATE(242)] = 12395,
  [SMALL_STATE(243)] = 12404,
  [SMALL_STATE(244)] = 12411,
  [SMALL_STATE(245)] = 12418,
  [SMALL_STATE(246)] = 12425,
  [SMALL_STATE(247)] = 12434,
  [SMALL_STATE(248)] = 12443,
  [SMALL_STATE(249)] = 12452,
  [SMALL_STATE(250)] = 12459,
  [SMALL_STATE(251)] = 12468,
  [SMALL_STATE(252)] = 12479,
  [SMALL_STATE(253)] = 12486,
  [SMALL_STATE(254)] = 12492,
  [SMALL_STATE(255)] = 12502,
  [SMALL_STATE(256)] = 12508,
  [SMALL_STATE(257)] = 12514,
  [SMALL_STATE(258)] = 12524,
  [SMALL_STATE(259)] = 12530,
  [SMALL_STATE(260)] = 12540,
  [SMALL_STATE(261)] = 12550,
  [SMALL_STATE(262)] = 12560,
  [SMALL_STATE(263)] = 12570,
  [SMALL_STATE(264)] = 12580,
  [SMALL_STATE(265)] = 12590,
  [SMALL_STATE(266)] = 12600,
  [SMALL_STATE(267)] = 12610,
  [SMALL_STATE(268)] = 12616,
  [SMALL_STATE(269)] = 12626,
  [SMALL_STATE(270)] = 12632,
  [SMALL_STATE(271)] = 12640,
  [SMALL_STATE(272)] = 12650,
  [SMALL_STATE(273)] = 12658,
  [SMALL_STATE(274)] = 12668,
  [SMALL_STATE(275)] = 12678,
  [SMALL_STATE(276)] = 12688,
  [SMALL_STATE(277)] = 12698,
  [SMALL_STATE(278)] = 12704,
  [SMALL_STATE(279)] = 12714,
  [SMALL_STATE(280)] = 12719,
  [SMALL_STATE(281)] = 12726,
  [SMALL_STATE(282)] = 12733,
  [SMALL_STATE(283)] = 12740,
  [SMALL_STATE(284)] = 12744,
  [SMALL_STATE(285)] = 12748,
  [SMALL_STATE(286)] = 12752,
  [SMALL_STATE(287)] = 12756,
  [SMALL_STATE(288)] = 12760,
  [SMALL_STATE(289)] = 12764,
  [SMALL_STATE(290)] = 12768,
  [SMALL_STATE(291)] = 12772,
  [SMALL_STATE(292)] = 12776,
  [SMALL_STATE(293)] = 12780,
  [SMALL_STATE(294)] = 12784,
  [SMALL_STATE(295)] = 12788,
  [SMALL_STATE(296)] = 12792,
  [SMALL_STATE(297)] = 12796,
  [SMALL_STATE(298)] = 12800,
  [SMALL_STATE(299)] = 12804,
  [SMALL_STATE(300)] = 12808,
  [SMALL_STATE(301)] = 12812,
  [SMALL_STATE(302)] = 12816,
  [SMALL_STATE(303)] = 12820,
  [SMALL_STATE(304)] = 12824,
  [SMALL_STATE(305)] = 12828,
  [SMALL_STATE(306)] = 12832,
  [SMALL_STATE(307)] = 12836,
  [SMALL_STATE(308)] = 12840,
  [SMALL_STATE(309)] = 12844,
  [SMALL_STATE(310)] = 12848,
  [SMALL_STATE(311)] = 12852,
  [SMALL_STATE(312)] = 12856,
  [SMALL_STATE(313)] = 12860,
  [SMALL_STATE(314)] = 12864,
  [SMALL_STATE(315)] = 12868,
  [SMALL_STATE(316)] = 12872,
  [SMALL_STATE(317)] = 12876,
  [SMALL_STATE(318)] = 12880,
  [SMALL_STATE(319)] = 12884,
  [SMALL_STATE(320)] = 12888,
  [SMALL_STATE(321)] = 12892,
  [SMALL_STATE(322)] = 12896,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(256),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [65] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(256),
  [68] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(262),
  [71] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(187),
  [74] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(211),
  [77] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(111),
  [80] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(305),
  [83] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(194),
  [86] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(175),
  [89] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(21),
  [92] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(22),
  [95] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(23),
  [98] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(256),
  [101] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(12),
  [104] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(24),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(297),
  [110] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(251),
  [113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(204),
  [116] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(300),
  [119] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(242),
  [122] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(15),
  [125] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(282),
  [128] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(30),
  [131] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(31),
  [134] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(303),
  [137] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(10),
  [140] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(214),
  [143] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(319),
  [146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2),
  [152] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_line_repeat1, 2),
  [154] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(32),
  [157] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(257),
  [160] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(35),
  [163] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(35),
  [166] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(310),
  [169] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(311),
  [172] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(41),
  [175] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(312),
  [178] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(309),
  [181] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(321),
  [184] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(322),
  [187] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(28),
  [190] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2),
  [192] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(85),
  [195] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(85),
  [198] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(104),
  [201] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 2), SHIFT_REPEAT(288),
  [204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [210] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [230] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [246] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [264] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [272] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [278] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [282] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [286] = {.entry = {.count = 1, .reusable = false}}, SHIFT(200),
  [288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [290] = {.entry = {.count = 1, .reusable = false}}, SHIFT(156),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [294] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [298] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [302] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [306] = {.entry = {.count = 1, .reusable = false}}, SHIFT(179),
  [308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [310] = {.entry = {.count = 1, .reusable = false}}, SHIFT(158),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [314] = {.entry = {.count = 1, .reusable = false}}, SHIFT(199),
  [316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [318] = {.entry = {.count = 1, .reusable = false}}, SHIFT(197),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [322] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [326] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [332] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [336] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [340] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [344] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [348] = {.entry = {.count = 1, .reusable = false}}, SHIFT(159),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [352] = {.entry = {.count = 1, .reusable = false}}, SHIFT(198),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [358] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [364] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [368] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [372] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [376] = {.entry = {.count = 1, .reusable = false}}, SHIFT(160),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [380] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [384] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [392] = {.entry = {.count = 1, .reusable = false}}, SHIFT(190),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [400] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [404] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [408] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [412] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [416] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [420] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [424] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [428] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [432] = {.entry = {.count = 1, .reusable = false}}, SHIFT(161),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [438] = {.entry = {.count = 1, .reusable = false}}, SHIFT(186),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [442] = {.entry = {.count = 1, .reusable = false}}, SHIFT(184),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [446] = {.entry = {.count = 1, .reusable = false}}, SHIFT(157),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [450] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [454] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [458] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [462] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [466] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [470] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [474] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [478] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [482] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [486] = {.entry = {.count = 1, .reusable = false}}, SHIFT(205),
  [488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [490] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [494] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(202),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [502] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [506] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [510] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__real_scalar, 1),
  [512] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__real_scalar, 1),
  [514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [522] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__name, 2),
  [524] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__name, 2),
  [526] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_aexpr, 3),
  [528] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_aexpr, 3),
  [530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__int_scalar, 2),
  [534] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__int_scalar, 2),
  [536] = {.entry = {.count = 1, .reusable = false}}, SHIFT(64),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [548] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_sexpr, 3),
  [550] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_sexpr, 3),
  [552] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr, 1),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [556] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expr, 1),
  [558] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_aexpr, 2),
  [560] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_aexpr, 2),
  [562] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string_scalar, 2),
  [564] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string_scalar, 2),
  [566] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sfcall, 8),
  [568] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sfcall, 8),
  [570] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript, 3),
  [572] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript, 3),
  [574] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fcall, 5),
  [576] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fcall, 5),
  [578] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__real_array, 2),
  [580] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__real_array, 2),
  [582] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript, 4),
  [584] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript, 4),
  [586] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parenthesized_aexpr, 3),
  [588] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__parenthesized_aexpr, 3),
  [590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fcall, 4),
  [592] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fcall, 4),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sfcall, 4),
  [596] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sfcall, 4),
  [598] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sfcall, 6),
  [600] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sfcall, 6),
  [602] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_svar, 1),
  [604] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_svar, 1),
  [606] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_intvar, 1),
  [608] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_intvar, 1),
  [610] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parenthesized_sexpr, 3),
  [612] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__parenthesized_sexpr, 3),
  [614] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__int_array, 3),
  [616] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__int_array, 3),
  [618] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string_array, 3),
  [620] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string_array, 3),
  [622] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_realvar, 1),
  [624] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_realvar, 1),
  [626] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sfcall, 3),
  [628] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sfcall, 3),
  [630] = {.entry = {.count = 1, .reusable = false}}, SHIFT(148),
  [632] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat7, 1),
  [634] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_statement_repeat7, 1),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [638] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_statement_repeat7, 2),
  [640] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__relop, 1),
  [642] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__relop, 1),
  [644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__relop, 2),
  [648] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__relop, 2),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [700] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 4),
  [702] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 5),
  [704] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat4, 4),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [710] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 6),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [714] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 8),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [722] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 3),
  [724] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 4),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [736] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_subscript_repeat1, 2),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [786] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [788] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__sexpr, 1),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__var, 1),
  [792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [796] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 3),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [804] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [810] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat1, 2), SHIFT_REPEAT(215),
  [813] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat1, 2),
  [815] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat4, 2), SHIFT_REPEAT(38),
  [818] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat4, 2),
  [820] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat6, 2), SHIFT_REPEAT(299),
  [823] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat6, 2),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [827] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat2, 2), SHIFT_REPEAT(178),
  [830] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat2, 2),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [836] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat3, 2), SHIFT_REPEAT(173),
  [839] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat3, 2),
  [841] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [843] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(233),
  [846] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(3),
  [849] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat5, 2), SHIFT_REPEAT(207),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat5, 2),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [858] = {.entry = {.count = 1, .reusable = false}}, SHIFT(258),
  [860] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1),
  [862] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_real_scalar, 1),
  [864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [866] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_int_scalar, 2),
  [868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [870] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [872] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [874] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [876] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line, 3),
  [878] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [880] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line, 4),
  [882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [886] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_subscript_repeat1, 2), SHIFT_REPEAT(29),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [899] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [905] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [907] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [933] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_name, 1),
  [935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [953] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_applesoft_external_scanner_create(void);
void tree_sitter_applesoft_external_scanner_destroy(void *);
bool tree_sitter_applesoft_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_applesoft_external_scanner_serialize(void *, char *);
void tree_sitter_applesoft_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_applesoft(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_applesoft_external_scanner_create,
      tree_sitter_applesoft_external_scanner_destroy,
      tree_sitter_applesoft_external_scanner_scan,
      tree_sitter_applesoft_external_scanner_serialize,
      tree_sitter_applesoft_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
