#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1055
#define LARGE_STATE_COUNT 79
#define SYMBOL_COUNT 303
#define ALIAS_COUNT 1
#define TOKEN_COUNT 141
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 43
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 170

enum {
  sym_identifier = 1,
  sym_decimal_integer_literal = 2,
  sym_decimal_floating_point_literal = 3,
  sym_true = 4,
  sym_false = 5,
  sym_string_literal = 6,
  sym_null_literal = 7,
  anon_sym_LBRACK = 8,
  anon_sym_RBRACK = 9,
  aux_sym_sosl_find_clause_token1 = 10,
  aux_sym_sosl_in_clause_token1 = 11,
  aux_sym_sosl_in_clause_token2 = 12,
  aux_sym_sosl_in_clause_token3 = 13,
  aux_sym_sosl_in_clause_token4 = 14,
  aux_sym_sosl_in_clause_token5 = 15,
  aux_sym_sosl_in_clause_token6 = 16,
  aux_sym_sosl_in_clause_token7 = 17,
  aux_sym_sosl_returning_clause_token1 = 18,
  anon_sym_COMMA = 19,
  anon_sym_COLON = 20,
  aux_sym_select_clause_token1 = 21,
  anon_sym_LPAREN = 22,
  anon_sym_RPAREN = 23,
  aux_sym_from_clause_token1 = 24,
  aux_sym_where_clause_token1 = 25,
  anon_sym_EQ = 26,
  anon_sym_BANG_EQ = 27,
  aux_sym_field_expression_token1 = 28,
  aux_sym_complex_field_expression_token1 = 29,
  aux_sym_complex_field_expression_token2 = 30,
  aux_sym_typeof_clause_token1 = 31,
  aux_sym_typeof_clause_token2 = 32,
  aux_sym_typeof_clause_else_branch_token1 = 33,
  aux_sym_typeof_clause_branch_token1 = 34,
  aux_sym_typeof_clause_branch_token2 = 35,
  anon_sym_DOT = 36,
  aux_sym_order_by_clause_token1 = 37,
  aux_sym_order_by_clause_token2 = 38,
  aux_sym_order_by_clause_token3 = 39,
  aux_sym_order_by_clause_token4 = 40,
  aux_sym_order_by_clause_token5 = 41,
  aux_sym_order_by_clause_token6 = 42,
  aux_sym_order_by_clause_token7 = 43,
  aux_sym_limit_clause_token1 = 44,
  aux_sym_offset_clause_token1 = 45,
  aux_sym_group_by_clause_token1 = 46,
  aux_sym_group_by_clause_token2 = 47,
  aux_sym_having_clause_token1 = 48,
  aux_sym_dml_insert_statement_token1 = 49,
  anon_sym_SEMI = 50,
  aux_sym_dml_update_statement_token1 = 51,
  aux_sym_dml_upsert_statement_token1 = 52,
  aux_sym_dml_delete_statement_token1 = 53,
  aux_sym_dml_undelete_statemetn_token1 = 54,
  anon_sym_AMP = 55,
  anon_sym_PLUS_EQ = 56,
  anon_sym_DASH_EQ = 57,
  anon_sym_STAR_EQ = 58,
  anon_sym_SLASH_EQ = 59,
  anon_sym_AMP_EQ = 60,
  anon_sym_PIPE_EQ = 61,
  anon_sym_CARET_EQ = 62,
  anon_sym_PERCENT_EQ = 63,
  anon_sym_LT_LT_EQ = 64,
  anon_sym_GT_GT_EQ = 65,
  anon_sym_GT_GT_GT_EQ = 66,
  anon_sym_GT = 67,
  anon_sym_LT = 68,
  anon_sym_GT_EQ = 69,
  anon_sym_LT_EQ = 70,
  anon_sym_EQ_EQ = 71,
  anon_sym_EQ_EQ_EQ = 72,
  anon_sym_AMP_AMP = 73,
  anon_sym_PIPE_PIPE = 74,
  anon_sym_PLUS = 75,
  anon_sym_DASH = 76,
  anon_sym_STAR = 77,
  anon_sym_SLASH = 78,
  anon_sym_PIPE = 79,
  anon_sym_CARET = 80,
  anon_sym_PERCENT = 81,
  anon_sym_LT_LT = 82,
  anon_sym_GT_GT = 83,
  anon_sym_GT_GT_GT = 84,
  aux_sym_instanceof_expression_token1 = 85,
  anon_sym_QMARK = 86,
  anon_sym_BANG = 87,
  anon_sym_TILDE = 88,
  anon_sym_PLUS_PLUS = 89,
  anon_sym_DASH_DASH = 90,
  anon_sym_new = 91,
  anon_sym_class = 92,
  anon_sym_extends = 93,
  aux_sym_switch_expression_token1 = 94,
  aux_sym_switch_expression_token2 = 95,
  anon_sym_LBRACE = 96,
  anon_sym_RBRACE = 97,
  aux_sym_switch_block_statement_group_token1 = 98,
  aux_sym_default_switch_statement_group_token1 = 99,
  aux_sym_do_statement_token1 = 100,
  aux_sym_do_statement_token2 = 101,
  aux_sym_break_statement_token1 = 102,
  aux_sym_continue_statement_token1 = 103,
  aux_sym_return_statement_token1 = 104,
  aux_sym_throw_statement_token1 = 105,
  aux_sym_try_statement_token1 = 106,
  aux_sym_catch_clause_token1 = 107,
  aux_sym_finally_clause_token1 = 108,
  aux_sym_if_statement_token1 = 109,
  aux_sym_for_statement_token1 = 110,
  anon_sym_AT = 111,
  aux_sym_enum_declaration_token1 = 112,
  aux_sym_class_declaration_token1 = 113,
  aux_sym_access_modifiers_token1 = 114,
  aux_sym_access_modifiers_token2 = 115,
  aux_sym_access_modifiers_token3 = 116,
  aux_sym_access_modifiers_token4 = 117,
  aux_sym_modifiers_token1 = 118,
  aux_sym_modifiers_token2 = 119,
  aux_sym_modifiers_token3 = 120,
  aux_sym_modifiers_token4 = 121,
  aux_sym_modifiers_token5 = 122,
  aux_sym_modifiers_token6 = 123,
  aux_sym_modifiers_token7 = 124,
  anon_sym_implements = 125,
  anon_sym_default = 126,
  aux_sym_interface_declaration_token1 = 127,
  aux_sym_extends_interfaces_token1 = 128,
  aux_sym_integral_type_token1 = 129,
  aux_sym_integral_type_token2 = 130,
  aux_sym_floating_point_type_token1 = 131,
  aux_sym_floating_point_type_token2 = 132,
  sym_boolean_type = 133,
  sym_void_type = 134,
  anon_sym_open = 135,
  anon_sym_module = 136,
  sym_this = 137,
  sym_super = 138,
  sym_line_comment = 139,
  sym_block_comment = 140,
  sym_program = 141,
  sym__literal = 142,
  sym_expression = 143,
  sym_database_query = 144,
  sym_sosl_query = 145,
  sym_sosl_find_clause = 146,
  sym_sosl_in_clause = 147,
  sym_sosl_returning_clause = 148,
  sym_sosl_entity_definition = 149,
  sym__query_value_reference = 150,
  sym_soql_query = 151,
  sym_select_clause = 152,
  sym_aggregation_function = 153,
  sym_queried_value = 154,
  sym_from_clause = 155,
  sym_from_clause_source = 156,
  sym_where_clause = 157,
  sym_field_expression = 158,
  sym__field_expression_wrapper = 159,
  sym_complex_field_expression = 160,
  sym_typeof_clause = 161,
  sym_typeof_clause_else_branch = 162,
  sym_typeof_clause_branch = 163,
  sym_field_name = 164,
  sym_order_by_clause = 165,
  sym_limit_clause = 166,
  sym_offset_clause = 167,
  sym_group_by_clause = 168,
  sym_having_clause = 169,
  sym_dml_statement = 170,
  sym_dml_insert_statement = 171,
  sym_dml_update_statement = 172,
  sym_dml_upsert_statement = 173,
  sym_dml_delete_statement = 174,
  sym_dml_undelete_statemetn = 175,
  sym_cast_expression = 176,
  sym_assignment_expression = 177,
  sym_binary_expression = 178,
  sym_instanceof_expression = 179,
  sym_ternary_expression = 180,
  sym_unary_expression = 181,
  sym_update_expression = 182,
  sym_primary_expression = 183,
  sym_array_creation_expression = 184,
  sym_dimensions_expr = 185,
  sym_parenthesized_expression = 186,
  sym_class_literal = 187,
  sym_object_creation_expression = 188,
  sym__unqualified_object_creation_expression = 189,
  sym_field_access = 190,
  sym_array_access = 191,
  sym_method_invocation = 192,
  sym_argument_list = 193,
  sym_type_arguments = 194,
  sym_wildcard = 195,
  sym__wildcard_bounds = 196,
  sym_dimensions = 197,
  sym_switch_expression = 198,
  sym_switch_block = 199,
  sym_switch_block_statement_group = 200,
  sym_default_switch_statement_group = 201,
  sym_sobject_switch_statement_group = 202,
  sym_statement = 203,
  sym_block = 204,
  sym_expression_statement = 205,
  sym_do_statement = 206,
  sym_break_statement = 207,
  sym_continue_statement = 208,
  sym_return_statement = 209,
  sym_throw_statement = 210,
  sym_try_statement = 211,
  sym_catch_clause = 212,
  sym_catch_formal_parameter = 213,
  sym_catch_type = 214,
  sym_finally_clause = 215,
  sym_if_statement = 216,
  sym_while_statement = 217,
  sym_for_statement = 218,
  sym_enhanced_for_statement = 219,
  sym__annotation = 220,
  sym_marker_annotation = 221,
  sym_annotation = 222,
  sym_annotation_argument_list = 223,
  sym_element_value_pair = 224,
  sym__element_value = 225,
  sym_element_value_array_initializer = 226,
  sym_declaration = 227,
  sym_enum_declaration = 228,
  sym_enum_body = 229,
  sym_enum_body_declarations = 230,
  sym_enum_constant = 231,
  sym_class_declaration = 232,
  sym_access_modifiers = 233,
  sym_modifiers = 234,
  sym_type_parameters = 235,
  sym_type_parameter = 236,
  sym_type_bound = 237,
  sym_superclass = 238,
  sym_super_interfaces = 239,
  sym_interface_type_list = 240,
  sym_class_body = 241,
  sym_static_initializer = 242,
  sym_constructor_declaration = 243,
  sym__constructor_declarator = 244,
  sym_constructor_body = 245,
  sym_explicit_constructor_invocation = 246,
  sym_scoped_identifier = 247,
  sym_field_declaration = 248,
  sym_interface_declaration = 249,
  sym_extends_interfaces = 250,
  sym_interface_body = 251,
  sym_constant_declaration = 252,
  sym__variable_declarator_list = 253,
  sym_variable_declarator = 254,
  sym__variable_declarator_id = 255,
  sym_array_initializer = 256,
  sym__type = 257,
  sym__unannotated_type = 258,
  sym_annotated_type = 259,
  sym_scoped_type_identifier = 260,
  sym_generic_type = 261,
  sym_array_type = 262,
  sym_integral_type = 263,
  sym_floating_point_type = 264,
  sym__method_header = 265,
  sym__method_declarator = 266,
  sym_formal_parameters = 267,
  sym_formal_parameter = 268,
  sym_receiver_parameter = 269,
  sym_local_variable_declaration = 270,
  sym_method_declaration = 271,
  aux_sym_program_repeat1 = 272,
  aux_sym_sosl_returning_clause_repeat1 = 273,
  aux_sym_select_clause_repeat1 = 274,
  aux_sym_from_clause_repeat1 = 275,
  aux_sym_typeof_clause_repeat1 = 276,
  aux_sym_typeof_clause_else_branch_repeat1 = 277,
  aux_sym_field_name_repeat1 = 278,
  aux_sym_order_by_clause_repeat1 = 279,
  aux_sym_cast_expression_repeat1 = 280,
  aux_sym_array_creation_expression_repeat1 = 281,
  aux_sym_argument_list_repeat1 = 282,
  aux_sym_type_arguments_repeat1 = 283,
  aux_sym_wildcard_repeat1 = 284,
  aux_sym_dimensions_repeat1 = 285,
  aux_sym_switch_block_repeat1 = 286,
  aux_sym_try_statement_repeat1 = 287,
  aux_sym_catch_type_repeat1 = 288,
  aux_sym_for_statement_repeat1 = 289,
  aux_sym_for_statement_repeat2 = 290,
  aux_sym_annotation_argument_list_repeat1 = 291,
  aux_sym_element_value_array_initializer_repeat1 = 292,
  aux_sym_enum_body_repeat1 = 293,
  aux_sym_enum_body_declarations_repeat1 = 294,
  aux_sym_modifiers_repeat1 = 295,
  aux_sym_type_parameters_repeat1 = 296,
  aux_sym_type_bound_repeat1 = 297,
  aux_sym_interface_type_list_repeat1 = 298,
  aux_sym_interface_body_repeat1 = 299,
  aux_sym__variable_declarator_list_repeat1 = 300,
  aux_sym_array_initializer_repeat1 = 301,
  aux_sym_formal_parameters_repeat1 = 302,
  alias_sym_type_identifier = 303,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_decimal_integer_literal] = "decimal_integer_literal",
  [sym_decimal_floating_point_literal] = "decimal_floating_point_literal",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_string_literal] = "string_literal",
  [sym_null_literal] = "null_literal",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [aux_sym_sosl_find_clause_token1] = "sosl_find_clause_token1",
  [aux_sym_sosl_in_clause_token1] = "sosl_in_clause_token1",
  [aux_sym_sosl_in_clause_token2] = "sosl_in_clause_token2",
  [aux_sym_sosl_in_clause_token3] = "sosl_in_clause_token3",
  [aux_sym_sosl_in_clause_token4] = "sosl_in_clause_token4",
  [aux_sym_sosl_in_clause_token5] = "sosl_in_clause_token5",
  [aux_sym_sosl_in_clause_token6] = "sosl_in_clause_token6",
  [aux_sym_sosl_in_clause_token7] = "sosl_in_clause_token7",
  [aux_sym_sosl_returning_clause_token1] = "sosl_returning_clause_token1",
  [anon_sym_COMMA] = ",",
  [anon_sym_COLON] = ":",
  [aux_sym_select_clause_token1] = "select_clause_token1",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [aux_sym_from_clause_token1] = "from_clause_token1",
  [aux_sym_where_clause_token1] = "where_clause_token1",
  [anon_sym_EQ] = "=",
  [anon_sym_BANG_EQ] = "!=",
  [aux_sym_field_expression_token1] = "field_expression_token1",
  [aux_sym_complex_field_expression_token1] = "complex_field_expression_token1",
  [aux_sym_complex_field_expression_token2] = "complex_field_expression_token2",
  [aux_sym_typeof_clause_token1] = "typeof_clause_token1",
  [aux_sym_typeof_clause_token2] = "typeof_clause_token2",
  [aux_sym_typeof_clause_else_branch_token1] = "typeof_clause_else_branch_token1",
  [aux_sym_typeof_clause_branch_token1] = "typeof_clause_branch_token1",
  [aux_sym_typeof_clause_branch_token2] = "typeof_clause_branch_token2",
  [anon_sym_DOT] = ".",
  [aux_sym_order_by_clause_token1] = "order_by_clause_token1",
  [aux_sym_order_by_clause_token2] = "order_by_clause_token2",
  [aux_sym_order_by_clause_token3] = "order_by_clause_token3",
  [aux_sym_order_by_clause_token4] = "order_by_clause_token4",
  [aux_sym_order_by_clause_token5] = "order_by_clause_token5",
  [aux_sym_order_by_clause_token6] = "order_by_clause_token6",
  [aux_sym_order_by_clause_token7] = "order_by_clause_token7",
  [aux_sym_limit_clause_token1] = "limit_clause_token1",
  [aux_sym_offset_clause_token1] = "offset_clause_token1",
  [aux_sym_group_by_clause_token1] = "group_by_clause_token1",
  [aux_sym_group_by_clause_token2] = "group_by_clause_token2",
  [aux_sym_having_clause_token1] = "having_clause_token1",
  [aux_sym_dml_insert_statement_token1] = "dml_insert_statement_token1",
  [anon_sym_SEMI] = ";",
  [aux_sym_dml_update_statement_token1] = "dml_update_statement_token1",
  [aux_sym_dml_upsert_statement_token1] = "dml_upsert_statement_token1",
  [aux_sym_dml_delete_statement_token1] = "dml_delete_statement_token1",
  [aux_sym_dml_undelete_statemetn_token1] = "dml_undelete_statemetn_token1",
  [anon_sym_AMP] = "&",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [aux_sym_instanceof_expression_token1] = "instanceof_expression_token1",
  [anon_sym_QMARK] = "\?",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_new] = "new",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [aux_sym_switch_expression_token1] = "switch_expression_token1",
  [aux_sym_switch_expression_token2] = "switch_expression_token2",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [aux_sym_switch_block_statement_group_token1] = "switch_block_statement_group_token1",
  [aux_sym_default_switch_statement_group_token1] = "default_switch_statement_group_token1",
  [aux_sym_do_statement_token1] = "do_statement_token1",
  [aux_sym_do_statement_token2] = "do_statement_token2",
  [aux_sym_break_statement_token1] = "break_statement_token1",
  [aux_sym_continue_statement_token1] = "continue_statement_token1",
  [aux_sym_return_statement_token1] = "return_statement_token1",
  [aux_sym_throw_statement_token1] = "throw_statement_token1",
  [aux_sym_try_statement_token1] = "try_statement_token1",
  [aux_sym_catch_clause_token1] = "catch_clause_token1",
  [aux_sym_finally_clause_token1] = "finally_clause_token1",
  [aux_sym_if_statement_token1] = "if_statement_token1",
  [aux_sym_for_statement_token1] = "for_statement_token1",
  [anon_sym_AT] = "@",
  [aux_sym_enum_declaration_token1] = "enum_declaration_token1",
  [aux_sym_class_declaration_token1] = "class_declaration_token1",
  [aux_sym_access_modifiers_token1] = "access_modifiers_token1",
  [aux_sym_access_modifiers_token2] = "access_modifiers_token2",
  [aux_sym_access_modifiers_token3] = "access_modifiers_token3",
  [aux_sym_access_modifiers_token4] = "access_modifiers_token4",
  [aux_sym_modifiers_token1] = "modifiers_token1",
  [aux_sym_modifiers_token2] = "modifiers_token2",
  [aux_sym_modifiers_token3] = "modifiers_token3",
  [aux_sym_modifiers_token4] = "modifiers_token4",
  [aux_sym_modifiers_token5] = "modifiers_token5",
  [aux_sym_modifiers_token6] = "modifiers_token6",
  [aux_sym_modifiers_token7] = "modifiers_token7",
  [anon_sym_implements] = "implements",
  [anon_sym_default] = "default",
  [aux_sym_interface_declaration_token1] = "interface_declaration_token1",
  [aux_sym_extends_interfaces_token1] = "extends_interfaces_token1",
  [aux_sym_integral_type_token1] = "integral_type_token1",
  [aux_sym_integral_type_token2] = "integral_type_token2",
  [aux_sym_floating_point_type_token1] = "floating_point_type_token1",
  [aux_sym_floating_point_type_token2] = "floating_point_type_token2",
  [sym_boolean_type] = "boolean_type",
  [sym_void_type] = "void_type",
  [anon_sym_open] = "identifier",
  [anon_sym_module] = "identifier",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_line_comment] = "line_comment",
  [sym_block_comment] = "block_comment",
  [sym_program] = "program",
  [sym__literal] = "_literal",
  [sym_expression] = "expression",
  [sym_database_query] = "database_query",
  [sym_sosl_query] = "sosl_query",
  [sym_sosl_find_clause] = "sosl_find_clause",
  [sym_sosl_in_clause] = "sosl_in_clause",
  [sym_sosl_returning_clause] = "sosl_returning_clause",
  [sym_sosl_entity_definition] = "sosl_entity_definition",
  [sym__query_value_reference] = "_query_value_reference",
  [sym_soql_query] = "soql_query",
  [sym_select_clause] = "select_clause",
  [sym_aggregation_function] = "aggregation_function",
  [sym_queried_value] = "queried_value",
  [sym_from_clause] = "from_clause",
  [sym_from_clause_source] = "from_clause_source",
  [sym_where_clause] = "where_clause",
  [sym_field_expression] = "field_expression",
  [sym__field_expression_wrapper] = "_field_expression_wrapper",
  [sym_complex_field_expression] = "complex_field_expression",
  [sym_typeof_clause] = "typeof_clause",
  [sym_typeof_clause_else_branch] = "typeof_clause_else_branch",
  [sym_typeof_clause_branch] = "typeof_clause_branch",
  [sym_field_name] = "field_name",
  [sym_order_by_clause] = "order_by_clause",
  [sym_limit_clause] = "limit_clause",
  [sym_offset_clause] = "offset_clause",
  [sym_group_by_clause] = "group_by_clause",
  [sym_having_clause] = "having_clause",
  [sym_dml_statement] = "dml_statement",
  [sym_dml_insert_statement] = "dml_insert_statement",
  [sym_dml_update_statement] = "dml_update_statement",
  [sym_dml_upsert_statement] = "dml_upsert_statement",
  [sym_dml_delete_statement] = "dml_delete_statement",
  [sym_dml_undelete_statemetn] = "dml_undelete_statemetn",
  [sym_cast_expression] = "cast_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_instanceof_expression] = "instanceof_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_primary_expression] = "primary_expression",
  [sym_array_creation_expression] = "array_creation_expression",
  [sym_dimensions_expr] = "dimensions_expr",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_class_literal] = "class_literal",
  [sym_object_creation_expression] = "object_creation_expression",
  [sym__unqualified_object_creation_expression] = "_unqualified_object_creation_expression",
  [sym_field_access] = "field_access",
  [sym_array_access] = "array_access",
  [sym_method_invocation] = "method_invocation",
  [sym_argument_list] = "argument_list",
  [sym_type_arguments] = "type_arguments",
  [sym_wildcard] = "wildcard",
  [sym__wildcard_bounds] = "_wildcard_bounds",
  [sym_dimensions] = "dimensions",
  [sym_switch_expression] = "switch_expression",
  [sym_switch_block] = "switch_block",
  [sym_switch_block_statement_group] = "switch_block_statement_group",
  [sym_default_switch_statement_group] = "default_switch_statement_group",
  [sym_sobject_switch_statement_group] = "sobject_switch_statement_group",
  [sym_statement] = "statement",
  [sym_block] = "block",
  [sym_expression_statement] = "expression_statement",
  [sym_do_statement] = "do_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_catch_formal_parameter] = "catch_formal_parameter",
  [sym_catch_type] = "catch_type",
  [sym_finally_clause] = "finally_clause",
  [sym_if_statement] = "if_statement",
  [sym_while_statement] = "while_statement",
  [sym_for_statement] = "for_statement",
  [sym_enhanced_for_statement] = "enhanced_for_statement",
  [sym__annotation] = "_annotation",
  [sym_marker_annotation] = "marker_annotation",
  [sym_annotation] = "annotation",
  [sym_annotation_argument_list] = "annotation_argument_list",
  [sym_element_value_pair] = "element_value_pair",
  [sym__element_value] = "_element_value",
  [sym_element_value_array_initializer] = "element_value_array_initializer",
  [sym_declaration] = "declaration",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_body_declarations] = "enum_body_declarations",
  [sym_enum_constant] = "enum_constant",
  [sym_class_declaration] = "class_declaration",
  [sym_access_modifiers] = "access_modifiers",
  [sym_modifiers] = "modifiers",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_bound] = "type_bound",
  [sym_superclass] = "superclass",
  [sym_super_interfaces] = "super_interfaces",
  [sym_interface_type_list] = "interface_type_list",
  [sym_class_body] = "class_body",
  [sym_static_initializer] = "static_initializer",
  [sym_constructor_declaration] = "constructor_declaration",
  [sym__constructor_declarator] = "_constructor_declarator",
  [sym_constructor_body] = "constructor_body",
  [sym_explicit_constructor_invocation] = "explicit_constructor_invocation",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_field_declaration] = "field_declaration",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_interfaces] = "extends_interfaces",
  [sym_interface_body] = "interface_body",
  [sym_constant_declaration] = "constant_declaration",
  [sym__variable_declarator_list] = "_variable_declarator_list",
  [sym_variable_declarator] = "variable_declarator",
  [sym__variable_declarator_id] = "_variable_declarator_id",
  [sym_array_initializer] = "array_initializer",
  [sym__type] = "_type",
  [sym__unannotated_type] = "_unannotated_type",
  [sym_annotated_type] = "annotated_type",
  [sym_scoped_type_identifier] = "scoped_type_identifier",
  [sym_generic_type] = "generic_type",
  [sym_array_type] = "array_type",
  [sym_integral_type] = "integral_type",
  [sym_floating_point_type] = "floating_point_type",
  [sym__method_header] = "_method_header",
  [sym__method_declarator] = "_method_declarator",
  [sym_formal_parameters] = "formal_parameters",
  [sym_formal_parameter] = "formal_parameter",
  [sym_receiver_parameter] = "receiver_parameter",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym_method_declaration] = "method_declaration",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_sosl_returning_clause_repeat1] = "sosl_returning_clause_repeat1",
  [aux_sym_select_clause_repeat1] = "select_clause_repeat1",
  [aux_sym_from_clause_repeat1] = "from_clause_repeat1",
  [aux_sym_typeof_clause_repeat1] = "typeof_clause_repeat1",
  [aux_sym_typeof_clause_else_branch_repeat1] = "typeof_clause_else_branch_repeat1",
  [aux_sym_field_name_repeat1] = "field_name_repeat1",
  [aux_sym_order_by_clause_repeat1] = "order_by_clause_repeat1",
  [aux_sym_cast_expression_repeat1] = "cast_expression_repeat1",
  [aux_sym_array_creation_expression_repeat1] = "array_creation_expression_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_wildcard_repeat1] = "wildcard_repeat1",
  [aux_sym_dimensions_repeat1] = "dimensions_repeat1",
  [aux_sym_switch_block_repeat1] = "switch_block_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_catch_type_repeat1] = "catch_type_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_for_statement_repeat2] = "for_statement_repeat2",
  [aux_sym_annotation_argument_list_repeat1] = "annotation_argument_list_repeat1",
  [aux_sym_element_value_array_initializer_repeat1] = "element_value_array_initializer_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_enum_body_declarations_repeat1] = "enum_body_declarations_repeat1",
  [aux_sym_modifiers_repeat1] = "modifiers_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_type_bound_repeat1] = "type_bound_repeat1",
  [aux_sym_interface_type_list_repeat1] = "interface_type_list_repeat1",
  [aux_sym_interface_body_repeat1] = "interface_body_repeat1",
  [aux_sym__variable_declarator_list_repeat1] = "_variable_declarator_list_repeat1",
  [aux_sym_array_initializer_repeat1] = "array_initializer_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_decimal_integer_literal] = sym_decimal_integer_literal,
  [sym_decimal_floating_point_literal] = sym_decimal_floating_point_literal,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_string_literal] = sym_string_literal,
  [sym_null_literal] = sym_null_literal,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [aux_sym_sosl_find_clause_token1] = aux_sym_sosl_find_clause_token1,
  [aux_sym_sosl_in_clause_token1] = aux_sym_sosl_in_clause_token1,
  [aux_sym_sosl_in_clause_token2] = aux_sym_sosl_in_clause_token2,
  [aux_sym_sosl_in_clause_token3] = aux_sym_sosl_in_clause_token3,
  [aux_sym_sosl_in_clause_token4] = aux_sym_sosl_in_clause_token4,
  [aux_sym_sosl_in_clause_token5] = aux_sym_sosl_in_clause_token5,
  [aux_sym_sosl_in_clause_token6] = aux_sym_sosl_in_clause_token6,
  [aux_sym_sosl_in_clause_token7] = aux_sym_sosl_in_clause_token7,
  [aux_sym_sosl_returning_clause_token1] = aux_sym_sosl_returning_clause_token1,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_COLON] = anon_sym_COLON,
  [aux_sym_select_clause_token1] = aux_sym_select_clause_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_from_clause_token1] = aux_sym_from_clause_token1,
  [aux_sym_where_clause_token1] = aux_sym_where_clause_token1,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [aux_sym_field_expression_token1] = aux_sym_field_expression_token1,
  [aux_sym_complex_field_expression_token1] = aux_sym_complex_field_expression_token1,
  [aux_sym_complex_field_expression_token2] = aux_sym_complex_field_expression_token2,
  [aux_sym_typeof_clause_token1] = aux_sym_typeof_clause_token1,
  [aux_sym_typeof_clause_token2] = aux_sym_typeof_clause_token2,
  [aux_sym_typeof_clause_else_branch_token1] = aux_sym_typeof_clause_else_branch_token1,
  [aux_sym_typeof_clause_branch_token1] = aux_sym_typeof_clause_branch_token1,
  [aux_sym_typeof_clause_branch_token2] = aux_sym_typeof_clause_branch_token2,
  [anon_sym_DOT] = anon_sym_DOT,
  [aux_sym_order_by_clause_token1] = aux_sym_order_by_clause_token1,
  [aux_sym_order_by_clause_token2] = aux_sym_order_by_clause_token2,
  [aux_sym_order_by_clause_token3] = aux_sym_order_by_clause_token3,
  [aux_sym_order_by_clause_token4] = aux_sym_order_by_clause_token4,
  [aux_sym_order_by_clause_token5] = aux_sym_order_by_clause_token5,
  [aux_sym_order_by_clause_token6] = aux_sym_order_by_clause_token6,
  [aux_sym_order_by_clause_token7] = aux_sym_order_by_clause_token7,
  [aux_sym_limit_clause_token1] = aux_sym_limit_clause_token1,
  [aux_sym_offset_clause_token1] = aux_sym_offset_clause_token1,
  [aux_sym_group_by_clause_token1] = aux_sym_group_by_clause_token1,
  [aux_sym_group_by_clause_token2] = aux_sym_group_by_clause_token2,
  [aux_sym_having_clause_token1] = aux_sym_having_clause_token1,
  [aux_sym_dml_insert_statement_token1] = aux_sym_dml_insert_statement_token1,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [aux_sym_dml_update_statement_token1] = aux_sym_dml_update_statement_token1,
  [aux_sym_dml_upsert_statement_token1] = aux_sym_dml_upsert_statement_token1,
  [aux_sym_dml_delete_statement_token1] = aux_sym_dml_delete_statement_token1,
  [aux_sym_dml_undelete_statemetn_token1] = aux_sym_dml_undelete_statemetn_token1,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [aux_sym_instanceof_expression_token1] = aux_sym_instanceof_expression_token1,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [aux_sym_switch_expression_token1] = aux_sym_switch_expression_token1,
  [aux_sym_switch_expression_token2] = aux_sym_switch_expression_token2,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [aux_sym_switch_block_statement_group_token1] = aux_sym_switch_block_statement_group_token1,
  [aux_sym_default_switch_statement_group_token1] = aux_sym_default_switch_statement_group_token1,
  [aux_sym_do_statement_token1] = aux_sym_do_statement_token1,
  [aux_sym_do_statement_token2] = aux_sym_do_statement_token2,
  [aux_sym_break_statement_token1] = aux_sym_break_statement_token1,
  [aux_sym_continue_statement_token1] = aux_sym_continue_statement_token1,
  [aux_sym_return_statement_token1] = aux_sym_return_statement_token1,
  [aux_sym_throw_statement_token1] = aux_sym_throw_statement_token1,
  [aux_sym_try_statement_token1] = aux_sym_try_statement_token1,
  [aux_sym_catch_clause_token1] = aux_sym_catch_clause_token1,
  [aux_sym_finally_clause_token1] = aux_sym_finally_clause_token1,
  [aux_sym_if_statement_token1] = aux_sym_if_statement_token1,
  [aux_sym_for_statement_token1] = aux_sym_for_statement_token1,
  [anon_sym_AT] = anon_sym_AT,
  [aux_sym_enum_declaration_token1] = aux_sym_enum_declaration_token1,
  [aux_sym_class_declaration_token1] = aux_sym_class_declaration_token1,
  [aux_sym_access_modifiers_token1] = aux_sym_access_modifiers_token1,
  [aux_sym_access_modifiers_token2] = aux_sym_access_modifiers_token2,
  [aux_sym_access_modifiers_token3] = aux_sym_access_modifiers_token3,
  [aux_sym_access_modifiers_token4] = aux_sym_access_modifiers_token4,
  [aux_sym_modifiers_token1] = aux_sym_modifiers_token1,
  [aux_sym_modifiers_token2] = aux_sym_modifiers_token2,
  [aux_sym_modifiers_token3] = aux_sym_modifiers_token3,
  [aux_sym_modifiers_token4] = aux_sym_modifiers_token4,
  [aux_sym_modifiers_token5] = aux_sym_modifiers_token5,
  [aux_sym_modifiers_token6] = aux_sym_modifiers_token6,
  [aux_sym_modifiers_token7] = aux_sym_modifiers_token7,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_default] = anon_sym_default,
  [aux_sym_interface_declaration_token1] = aux_sym_interface_declaration_token1,
  [aux_sym_extends_interfaces_token1] = aux_sym_extends_interfaces_token1,
  [aux_sym_integral_type_token1] = aux_sym_integral_type_token1,
  [aux_sym_integral_type_token2] = aux_sym_integral_type_token2,
  [aux_sym_floating_point_type_token1] = aux_sym_floating_point_type_token1,
  [aux_sym_floating_point_type_token2] = aux_sym_floating_point_type_token2,
  [sym_boolean_type] = sym_boolean_type,
  [sym_void_type] = sym_void_type,
  [anon_sym_open] = sym_identifier,
  [anon_sym_module] = sym_identifier,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_line_comment] = sym_line_comment,
  [sym_block_comment] = sym_block_comment,
  [sym_program] = sym_program,
  [sym__literal] = sym__literal,
  [sym_expression] = sym_expression,
  [sym_database_query] = sym_database_query,
  [sym_sosl_query] = sym_sosl_query,
  [sym_sosl_find_clause] = sym_sosl_find_clause,
  [sym_sosl_in_clause] = sym_sosl_in_clause,
  [sym_sosl_returning_clause] = sym_sosl_returning_clause,
  [sym_sosl_entity_definition] = sym_sosl_entity_definition,
  [sym__query_value_reference] = sym__query_value_reference,
  [sym_soql_query] = sym_soql_query,
  [sym_select_clause] = sym_select_clause,
  [sym_aggregation_function] = sym_aggregation_function,
  [sym_queried_value] = sym_queried_value,
  [sym_from_clause] = sym_from_clause,
  [sym_from_clause_source] = sym_from_clause_source,
  [sym_where_clause] = sym_where_clause,
  [sym_field_expression] = sym_field_expression,
  [sym__field_expression_wrapper] = sym__field_expression_wrapper,
  [sym_complex_field_expression] = sym_complex_field_expression,
  [sym_typeof_clause] = sym_typeof_clause,
  [sym_typeof_clause_else_branch] = sym_typeof_clause_else_branch,
  [sym_typeof_clause_branch] = sym_typeof_clause_branch,
  [sym_field_name] = sym_field_name,
  [sym_order_by_clause] = sym_order_by_clause,
  [sym_limit_clause] = sym_limit_clause,
  [sym_offset_clause] = sym_offset_clause,
  [sym_group_by_clause] = sym_group_by_clause,
  [sym_having_clause] = sym_having_clause,
  [sym_dml_statement] = sym_dml_statement,
  [sym_dml_insert_statement] = sym_dml_insert_statement,
  [sym_dml_update_statement] = sym_dml_update_statement,
  [sym_dml_upsert_statement] = sym_dml_upsert_statement,
  [sym_dml_delete_statement] = sym_dml_delete_statement,
  [sym_dml_undelete_statemetn] = sym_dml_undelete_statemetn,
  [sym_cast_expression] = sym_cast_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_instanceof_expression] = sym_instanceof_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_array_creation_expression] = sym_array_creation_expression,
  [sym_dimensions_expr] = sym_dimensions_expr,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_class_literal] = sym_class_literal,
  [sym_object_creation_expression] = sym_object_creation_expression,
  [sym__unqualified_object_creation_expression] = sym__unqualified_object_creation_expression,
  [sym_field_access] = sym_field_access,
  [sym_array_access] = sym_array_access,
  [sym_method_invocation] = sym_method_invocation,
  [sym_argument_list] = sym_argument_list,
  [sym_type_arguments] = sym_type_arguments,
  [sym_wildcard] = sym_wildcard,
  [sym__wildcard_bounds] = sym__wildcard_bounds,
  [sym_dimensions] = sym_dimensions,
  [sym_switch_expression] = sym_switch_expression,
  [sym_switch_block] = sym_switch_block,
  [sym_switch_block_statement_group] = sym_switch_block_statement_group,
  [sym_default_switch_statement_group] = sym_default_switch_statement_group,
  [sym_sobject_switch_statement_group] = sym_sobject_switch_statement_group,
  [sym_statement] = sym_statement,
  [sym_block] = sym_block,
  [sym_expression_statement] = sym_expression_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_catch_formal_parameter] = sym_catch_formal_parameter,
  [sym_catch_type] = sym_catch_type,
  [sym_finally_clause] = sym_finally_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_enhanced_for_statement] = sym_enhanced_for_statement,
  [sym__annotation] = sym__annotation,
  [sym_marker_annotation] = sym_marker_annotation,
  [sym_annotation] = sym_annotation,
  [sym_annotation_argument_list] = sym_annotation_argument_list,
  [sym_element_value_pair] = sym_element_value_pair,
  [sym__element_value] = sym__element_value,
  [sym_element_value_array_initializer] = sym_element_value_array_initializer,
  [sym_declaration] = sym_declaration,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_body_declarations] = sym_enum_body_declarations,
  [sym_enum_constant] = sym_enum_constant,
  [sym_class_declaration] = sym_class_declaration,
  [sym_access_modifiers] = sym_access_modifiers,
  [sym_modifiers] = sym_modifiers,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_bound] = sym_type_bound,
  [sym_superclass] = sym_superclass,
  [sym_super_interfaces] = sym_super_interfaces,
  [sym_interface_type_list] = sym_interface_type_list,
  [sym_class_body] = sym_class_body,
  [sym_static_initializer] = sym_static_initializer,
  [sym_constructor_declaration] = sym_constructor_declaration,
  [sym__constructor_declarator] = sym__constructor_declarator,
  [sym_constructor_body] = sym_constructor_body,
  [sym_explicit_constructor_invocation] = sym_explicit_constructor_invocation,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_field_declaration] = sym_field_declaration,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_interfaces] = sym_extends_interfaces,
  [sym_interface_body] = sym_interface_body,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym__variable_declarator_list] = sym__variable_declarator_list,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym__variable_declarator_id] = sym__variable_declarator_id,
  [sym_array_initializer] = sym_array_initializer,
  [sym__type] = sym__type,
  [sym__unannotated_type] = sym__unannotated_type,
  [sym_annotated_type] = sym_annotated_type,
  [sym_scoped_type_identifier] = sym_scoped_type_identifier,
  [sym_generic_type] = sym_generic_type,
  [sym_array_type] = sym_array_type,
  [sym_integral_type] = sym_integral_type,
  [sym_floating_point_type] = sym_floating_point_type,
  [sym__method_header] = sym__method_header,
  [sym__method_declarator] = sym__method_declarator,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_formal_parameter] = sym_formal_parameter,
  [sym_receiver_parameter] = sym_receiver_parameter,
  [sym_local_variable_declaration] = sym_local_variable_declaration,
  [sym_method_declaration] = sym_method_declaration,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_sosl_returning_clause_repeat1] = aux_sym_sosl_returning_clause_repeat1,
  [aux_sym_select_clause_repeat1] = aux_sym_select_clause_repeat1,
  [aux_sym_from_clause_repeat1] = aux_sym_from_clause_repeat1,
  [aux_sym_typeof_clause_repeat1] = aux_sym_typeof_clause_repeat1,
  [aux_sym_typeof_clause_else_branch_repeat1] = aux_sym_typeof_clause_else_branch_repeat1,
  [aux_sym_field_name_repeat1] = aux_sym_field_name_repeat1,
  [aux_sym_order_by_clause_repeat1] = aux_sym_order_by_clause_repeat1,
  [aux_sym_cast_expression_repeat1] = aux_sym_cast_expression_repeat1,
  [aux_sym_array_creation_expression_repeat1] = aux_sym_array_creation_expression_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_wildcard_repeat1] = aux_sym_wildcard_repeat1,
  [aux_sym_dimensions_repeat1] = aux_sym_dimensions_repeat1,
  [aux_sym_switch_block_repeat1] = aux_sym_switch_block_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_catch_type_repeat1] = aux_sym_catch_type_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_for_statement_repeat2] = aux_sym_for_statement_repeat2,
  [aux_sym_annotation_argument_list_repeat1] = aux_sym_annotation_argument_list_repeat1,
  [aux_sym_element_value_array_initializer_repeat1] = aux_sym_element_value_array_initializer_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_enum_body_declarations_repeat1] = aux_sym_enum_body_declarations_repeat1,
  [aux_sym_modifiers_repeat1] = aux_sym_modifiers_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_type_bound_repeat1] = aux_sym_type_bound_repeat1,
  [aux_sym_interface_type_list_repeat1] = aux_sym_interface_type_list_repeat1,
  [aux_sym_interface_body_repeat1] = aux_sym_interface_body_repeat1,
  [aux_sym__variable_declarator_list_repeat1] = aux_sym__variable_declarator_list_repeat1,
  [aux_sym_array_initializer_repeat1] = aux_sym_array_initializer_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_null_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sosl_find_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sosl_in_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sosl_in_clause_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sosl_in_clause_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sosl_in_clause_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sosl_in_clause_token5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sosl_in_clause_token6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sosl_in_clause_token7] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sosl_returning_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_select_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_from_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_where_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_field_expression_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_complex_field_expression_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_complex_field_expression_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_typeof_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_typeof_clause_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_typeof_clause_else_branch_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_typeof_clause_branch_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_typeof_clause_branch_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_order_by_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_order_by_clause_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_order_by_clause_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_order_by_clause_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_order_by_clause_token5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_order_by_clause_token6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_order_by_clause_token7] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_limit_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_offset_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_group_by_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_group_by_clause_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_having_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dml_insert_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_dml_update_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dml_upsert_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dml_delete_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dml_undelete_statemetn_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_instanceof_expression_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_switch_expression_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_expression_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_switch_block_statement_group_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_default_switch_statement_group_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_do_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_do_statement_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_break_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_continue_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_return_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_throw_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_catch_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_finally_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_enum_declaration_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_declaration_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_access_modifiers_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_access_modifiers_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_access_modifiers_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_access_modifiers_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_token5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_token6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_token7] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_interface_declaration_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_interfaces_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_integral_type_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_integral_type_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_floating_point_type_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_floating_point_type_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_boolean_type] = {
    .visible = true,
    .named = true,
  },
  [sym_void_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_database_query] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_sosl_query] = {
    .visible = true,
    .named = true,
  },
  [sym_sosl_find_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_sosl_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_sosl_returning_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_sosl_entity_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__query_value_reference] = {
    .visible = false,
    .named = true,
  },
  [sym_soql_query] = {
    .visible = true,
    .named = true,
  },
  [sym_select_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_aggregation_function] = {
    .visible = true,
    .named = true,
  },
  [sym_queried_value] = {
    .visible = true,
    .named = true,
  },
  [sym_from_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_from_clause_source] = {
    .visible = true,
    .named = true,
  },
  [sym_where_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__field_expression_wrapper] = {
    .visible = false,
    .named = true,
  },
  [sym_complex_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_typeof_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_typeof_clause_else_branch] = {
    .visible = true,
    .named = true,
  },
  [sym_typeof_clause_branch] = {
    .visible = true,
    .named = true,
  },
  [sym_field_name] = {
    .visible = true,
    .named = true,
  },
  [sym_order_by_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_limit_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_offset_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_group_by_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_having_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_dml_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_dml_insert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_dml_update_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_dml_upsert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_dml_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_dml_undelete_statemetn] = {
    .visible = true,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instanceof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_array_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dimensions_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_object_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__unqualified_object_creation_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym_array_access] = {
    .visible = true,
    .named = true,
  },
  [sym_method_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym__wildcard_bounds] = {
    .visible = false,
    .named = true,
  },
  [sym_dimensions] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block_statement_group] = {
    .visible = true,
    .named = true,
  },
  [sym_default_switch_statement_group] = {
    .visible = true,
    .named = true,
  },
  [sym_sobject_switch_statement_group] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_type] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_enhanced_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_marker_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_element_value_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__element_value] = {
    .visible = false,
    .named = true,
  },
  [sym_element_value_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body_declarations] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_access_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_superclass] = {
    .visible = true,
    .named = true,
  },
  [sym_super_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_static_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_body] = {
    .visible = true,
    .named = true,
  },
  [sym_explicit_constructor_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_list] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_id] = {
    .visible = false,
    .named = true,
  },
  [sym_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__unannotated_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_annotated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_integral_type] = {
    .visible = true,
    .named = true,
  },
  [sym_floating_point_type] = {
    .visible = true,
    .named = true,
  },
  [sym__method_header] = {
    .visible = false,
    .named = true,
  },
  [sym__method_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_receiver_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sosl_returning_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_select_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_from_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_typeof_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_typeof_clause_else_branch_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_order_by_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cast_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_creation_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_wildcard_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_catch_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_element_value_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_bound_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_declarator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_aggr_function = 1,
  field_alias = 2,
  field_alternative = 3,
  field_arguments = 4,
  field_array = 5,
  field_body = 6,
  field_code = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constructor = 10,
  field_declarator = 11,
  field_dimensions = 12,
  field_element = 13,
  field_field = 14,
  field_index = 15,
  field_init = 16,
  field_interfaces = 17,
  field_key = 18,
  field_left = 19,
  field_limit = 20,
  field_name = 21,
  field_null_order = 22,
  field_object = 23,
  field_object_type = 24,
  field_offset = 25,
  field_operand = 26,
  field_operator = 27,
  field_order = 28,
  field_parameters = 29,
  field_relationship_name = 30,
  field_relationship_query = 31,
  field_right = 32,
  field_scope = 33,
  field_search_query = 34,
  field_sobject = 35,
  field_sobject_type = 36,
  field_superclass = 37,
  field_type = 38,
  field_type_arguments = 39,
  field_type_parameters = 40,
  field_update = 41,
  field_value = 42,
  field_var_name = 43,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_aggr_function] = "aggr_function",
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_array] = "array",
  [field_body] = "body",
  [field_code] = "code",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declarator] = "declarator",
  [field_dimensions] = "dimensions",
  [field_element] = "element",
  [field_field] = "field",
  [field_index] = "index",
  [field_init] = "init",
  [field_interfaces] = "interfaces",
  [field_key] = "key",
  [field_left] = "left",
  [field_limit] = "limit",
  [field_name] = "name",
  [field_null_order] = "null_order",
  [field_object] = "object",
  [field_object_type] = "object_type",
  [field_offset] = "offset",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_order] = "order",
  [field_parameters] = "parameters",
  [field_relationship_name] = "relationship_name",
  [field_relationship_query] = "relationship_query",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_search_query] = "search_query",
  [field_sobject] = "sobject",
  [field_sobject_type] = "sobject_type",
  [field_superclass] = "superclass",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
  [field_var_name] = "var_name",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 3},
  [3] = {.index = 3, .length = 2},
  [4] = {.index = 5, .length = 1},
  [5] = {.index = 6, .length = 2},
  [6] = {.index = 8, .length = 1},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 1},
  [9] = {.index = 12, .length = 2},
  [10] = {.index = 14, .length = 1},
  [11] = {.index = 15, .length = 1},
  [12] = {.index = 16, .length = 1},
  [13] = {.index = 17, .length = 2},
  [14] = {.index = 19, .length = 2},
  [15] = {.index = 17, .length = 2},
  [16] = {.index = 19, .length = 2},
  [17] = {.index = 21, .length = 2},
  [18] = {.index = 23, .length = 1},
  [19] = {.index = 24, .length = 2},
  [20] = {.index = 26, .length = 2},
  [21] = {.index = 28, .length = 2},
  [22] = {.index = 30, .length = 3},
  [23] = {.index = 33, .length = 2},
  [25] = {.index = 35, .length = 2},
  [26] = {.index = 37, .length = 3},
  [27] = {.index = 40, .length = 2},
  [28] = {.index = 42, .length = 2},
  [29] = {.index = 44, .length = 2},
  [31] = {.index = 46, .length = 2},
  [32] = {.index = 48, .length = 1},
  [33] = {.index = 49, .length = 1},
  [34] = {.index = 50, .length = 1},
  [35] = {.index = 51, .length = 2},
  [36] = {.index = 53, .length = 1},
  [37] = {.index = 54, .length = 2},
  [38] = {.index = 56, .length = 2},
  [39] = {.index = 58, .length = 3},
  [40] = {.index = 61, .length = 3},
  [41] = {.index = 58, .length = 3},
  [42] = {.index = 61, .length = 3},
  [43] = {.index = 64, .length = 3},
  [44] = {.index = 64, .length = 3},
  [45] = {.index = 67, .length = 2},
  [46] = {.index = 69, .length = 2},
  [47] = {.index = 71, .length = 3},
  [48] = {.index = 74, .length = 3},
  [49] = {.index = 77, .length = 3},
  [50] = {.index = 80, .length = 2},
  [51] = {.index = 82, .length = 3},
  [53] = {.index = 85, .length = 2},
  [54] = {.index = 87, .length = 2},
  [55] = {.index = 89, .length = 2},
  [56] = {.index = 91, .length = 1},
  [57] = {.index = 92, .length = 2},
  [58] = {.index = 94, .length = 3},
  [60] = {.index = 97, .length = 2},
  [61] = {.index = 99, .length = 2},
  [62] = {.index = 101, .length = 1},
  [63] = {.index = 102, .length = 1},
  [64] = {.index = 103, .length = 3},
  [65] = {.index = 106, .length = 2},
  [66] = {.index = 108, .length = 3},
  [67] = {.index = 111, .length = 1},
  [68] = {.index = 112, .length = 2},
  [69] = {.index = 114, .length = 2},
  [71] = {.index = 116, .length = 2},
  [72] = {.index = 118, .length = 4},
  [73] = {.index = 122, .length = 4},
  [74] = {.index = 126, .length = 5},
  [75] = {.index = 131, .length = 6},
  [76] = {.index = 137, .length = 4},
  [77] = {.index = 141, .length = 4},
  [78] = {.index = 145, .length = 4},
  [79] = {.index = 149, .length = 3},
  [80] = {.index = 152, .length = 2},
  [81] = {.index = 154, .length = 4},
  [82] = {.index = 158, .length = 3},
  [83] = {.index = 161, .length = 3},
  [84] = {.index = 164, .length = 3},
  [85] = {.index = 167, .length = 3},
  [86] = {.index = 170, .length = 2},
  [87] = {.index = 172, .length = 2},
  [88] = {.index = 174, .length = 1},
  [89] = {.index = 175, .length = 1},
  [90] = {.index = 176, .length = 2},
  [91] = {.index = 178, .length = 1},
  [92] = {.index = 179, .length = 2},
  [93] = {.index = 181, .length = 2},
  [94] = {.index = 183, .length = 3},
  [95] = {.index = 186, .length = 4},
  [96] = {.index = 190, .length = 5},
  [97] = {.index = 195, .length = 6},
  [98] = {.index = 201, .length = 3},
  [99] = {.index = 204, .length = 5},
  [100] = {.index = 209, .length = 5},
  [101] = {.index = 214, .length = 3},
  [102] = {.index = 217, .length = 4},
  [103] = {.index = 221, .length = 4},
  [104] = {.index = 225, .length = 4},
  [105] = {.index = 229, .length = 3},
  [106] = {.index = 232, .length = 3},
  [107] = {.index = 235, .length = 3},
  [108] = {.index = 238, .length = 3},
  [109] = {.index = 241, .length = 2},
  [110] = {.index = 243, .length = 3},
  [111] = {.index = 246, .length = 2},
  [112] = {.index = 248, .length = 2},
  [113] = {.index = 250, .length = 1},
  [114] = {.index = 251, .length = 1},
  [115] = {.index = 252, .length = 2},
  [116] = {.index = 254, .length = 1},
  [117] = {.index = 255, .length = 2},
  [118] = {.index = 257, .length = 2},
  [119] = {.index = 259, .length = 2},
  [120] = {.index = 261, .length = 2},
  [121] = {.index = 263, .length = 3},
  [122] = {.index = 266, .length = 3},
  [123] = {.index = 269, .length = 3},
  [124] = {.index = 272, .length = 3},
  [125] = {.index = 275, .length = 5},
  [126] = {.index = 280, .length = 3},
  [127] = {.index = 283, .length = 4},
  [128] = {.index = 287, .length = 5},
  [129] = {.index = 292, .length = 4},
  [130] = {.index = 296, .length = 4},
  [131] = {.index = 300, .length = 4},
  [132] = {.index = 304, .length = 1},
  [133] = {.index = 305, .length = 1},
  [134] = {.index = 306, .length = 3},
  [135] = {.index = 309, .length = 3},
  [136] = {.index = 312, .length = 2},
  [137] = {.index = 314, .length = 3},
  [138] = {.index = 317, .length = 2},
  [139] = {.index = 319, .length = 3},
  [140] = {.index = 322, .length = 3},
  [141] = {.index = 325, .length = 3},
  [142] = {.index = 328, .length = 3},
  [143] = {.index = 331, .length = 3},
  [144] = {.index = 334, .length = 5},
  [145] = {.index = 339, .length = 4},
  [146] = {.index = 343, .length = 4},
  [147] = {.index = 347, .length = 3},
  [148] = {.index = 350, .length = 2},
  [149] = {.index = 352, .length = 5},
  [150] = {.index = 357, .length = 2},
  [151] = {.index = 359, .length = 4},
  [152] = {.index = 363, .length = 4},
  [153] = {.index = 367, .length = 4},
  [154] = {.index = 371, .length = 4},
  [155] = {.index = 375, .length = 4},
  [156] = {.index = 379, .length = 4},
  [157] = {.index = 383, .length = 4},
  [158] = {.index = 387, .length = 5},
  [159] = {.index = 392, .length = 5},
  [160] = {.index = 397, .length = 3},
  [161] = {.index = 400, .length = 3},
  [162] = {.index = 403, .length = 5},
  [163] = {.index = 408, .length = 5},
  [164] = {.index = 413, .length = 5},
  [165] = {.index = 418, .length = 5},
  [166] = {.index = 423, .length = 3},
  [167] = {.index = 426, .length = 4},
  [168] = {.index = 430, .length = 6},
  [169] = {.index = 436, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_arguments, 0, .inherited = true},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_name, 1},
  [6] =
    {field_arguments, 1},
    {field_name, 0},
  [8] =
    {field_name, 0},
  [9] =
    {field_dimensions, 1},
    {field_element, 0},
  [11] =
    {field_declarator, 0},
  [12] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [14] =
    {field_search_query, 1},
  [15] =
    {field_relationship_query, 1},
  [16] =
    {field_value, 1},
  [17] =
    {field_arguments, 2},
    {field_type, 1},
  [19] =
    {field_dimensions, 2},
    {field_type, 1},
  [21] =
    {field_body, 2},
    {field_condition, 1},
  [23] =
    {field_body, 1},
  [24] =
    {field_condition, 1},
    {field_consequence, 2},
  [26] =
    {field_arguments, 2},
    {field_name, 1},
  [28] =
    {field_body, 2},
    {field_name, 1},
  [30] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [33] =
    {field_field, 2},
    {field_object, 0},
  [35] =
    {field_left, 0},
    {field_right, 2},
  [37] =
    {field_arguments, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
  [40] =
    {field_dimensions, 1},
    {field_name, 0},
  [42] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0},
  [44] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [46] =
    {field_relationship_query, 1},
    {field_relationship_query, 2, .inherited = true},
  [48] =
    {field_relationship_query, 2, .inherited = true},
  [49] =
    {field_sobject, 0},
  [50] =
    {field_relationship_name, 0},
  [51] =
    {field_type, 1},
    {field_value, 3},
  [53] =
    {field_type, 1},
  [54] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [56] =
    {field_field, 2},
    {field_value, 1},
  [58] =
    {field_dimensions, 2},
    {field_type, 1},
    {field_value, 3},
  [61] =
    {field_dimensions, 2},
    {field_dimensions, 3},
    {field_type, 1},
  [64] =
    {field_arguments, 3},
    {field_type, 2},
    {field_type_arguments, 1},
  [67] =
    {field_body, 3},
    {field_condition, 2},
  [69] =
    {field_name, 2},
    {field_scope, 0},
  [71] =
    {field_body, 3},
    {field_interfaces, 2},
    {field_name, 1},
  [74] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [77] =
    {field_body, 3},
    {field_name, 1},
    {field_superclass, 2},
  [80] =
    {field_body, 3},
    {field_name, 1},
  [82] =
    {field_arguments, 3},
    {field_name, 2},
    {field_object, 0},
  [85] =
    {field_array, 0},
    {field_index, 2},
  [87] =
    {field_body, 3},
    {field_name, 2},
  [89] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1},
  [91] =
    {field_declarator, 1},
  [92] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [94] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_value, 2},
  [97] =
    {field_relationship_query, 0, .inherited = true},
    {field_relationship_query, 1, .inherited = true},
  [99] =
    {field_alias, 1},
    {field_relationship_name, 0},
  [101] =
    {field_limit, 1},
  [102] =
    {field_offset, 1},
  [103] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [106] =
    {field_body, 1},
    {field_condition, 3},
  [108] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [111] =
    {field_init, 1},
  [112] =
    {field_init, 0, .inherited = true},
    {field_init, 1, .inherited = true},
  [114] =
    {field_body, 1},
    {field_name, 0},
  [116] =
    {field_name, 0},
    {field_parameters, 1},
  [118] =
    {field_body, 1},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [122] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0},
  [126] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [131] =
    {field_body, 1},
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [137] =
    {field_body, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [141] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [145] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_superclass, 2},
  [149] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [152] =
    {field_field, 4},
    {field_object, 0},
  [154] =
    {field_arguments, 4},
    {field_name, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [158] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [161] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [164] =
    {field_body, 4},
    {field_name, 2},
    {field_superclass, 3},
  [167] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 2},
  [170] =
    {field_body, 4},
    {field_name, 2},
  [172] =
    {field_body, 4},
    {field_name, 3},
  [174] =
    {field_aggr_function, 0},
  [175] =
    {field_field, 2},
  [176] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [178] =
    {field_body, 5},
  [179] =
    {field_body, 5},
    {field_init, 2},
  [181] =
    {field_key, 0},
    {field_value, 2},
  [183] =
    {field_arguments, 1},
    {field_body, 2},
    {field_name, 0},
  [186] =
    {field_body, 2},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [190] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [195] =
    {field_body, 2},
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [201] =
    {field_name, 1},
    {field_parameters, 2},
    {field_type_parameters, 0},
  [204] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1},
    {field_type_parameters, 0},
  [209] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [214] =
    {field_arguments, 5},
    {field_name, 4},
    {field_object, 0},
  [217] =
    {field_body, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [221] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [225] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_superclass, 3},
  [229] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [232] =
    {field_body, 5},
    {field_name, 3},
    {field_type_parameters, 4},
  [235] =
    {field_body, 5},
    {field_name, 3},
    {field_superclass, 4},
  [238] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 3},
  [241] =
    {field_aggr_function, 0},
    {field_alias, 4},
  [243] =
    {field_field, 0},
    {field_operator, 1},
    {field_value, 2},
  [246] =
    {field_field, 2},
    {field_order, 3},
  [248] =
    {field_field, 2},
    {field_field, 3, .inherited = true},
  [250] =
    {field_condition, 1},
  [251] =
    {field_body, 4},
  [252] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [254] =
    {field_update, 1},
  [255] =
    {field_body, 6},
    {field_update, 4},
  [257] =
    {field_update, 0, .inherited = true},
    {field_update, 1, .inherited = true},
  [259] =
    {field_body, 6},
    {field_condition, 3},
  [261] =
    {field_body, 6},
    {field_init, 2},
  [263] =
    {field_body, 6},
    {field_init, 2},
    {field_update, 4},
  [266] =
    {field_body, 6},
    {field_condition, 3},
    {field_init, 2},
  [269] =
    {field_arguments, 2},
    {field_body, 3},
    {field_name, 1},
  [272] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
  [275] =
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_parameters, 3, .inherited = true},
    {field_type, 2},
    {field_type_parameters, 0},
  [280] =
    {field_dimensions, 2},
    {field_name, 0},
    {field_parameters, 1},
  [283] =
    {field_arguments, 6},
    {field_name, 5},
    {field_object, 0},
    {field_type_arguments, 4},
  [287] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [292] =
    {field_body, 6},
    {field_name, 3},
    {field_superclass, 5},
    {field_type_parameters, 4},
  [296] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 3},
    {field_type_parameters, 4},
  [300] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 3},
    {field_superclass, 4},
  [304] =
    {field_object_type, 1},
  [305] =
    {field_field, 1},
  [306] =
    {field_field, 2},
    {field_field, 4, .inherited = true},
    {field_order, 3},
  [309] =
    {field_field, 2},
    {field_null_order, 3},
    {field_null_order, 4},
  [312] =
    {field_field, 0, .inherited = true},
    {field_field, 1, .inherited = true},
  [314] =
    {field_code, 3},
    {field_sobject_type, 1},
    {field_var_name, 2},
  [317] =
    {field_condition, 1},
    {field_condition, 2},
  [319] =
    {field_body, 7},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [322] =
    {field_body, 7},
    {field_condition, 3},
    {field_update, 5},
  [325] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 5},
  [328] =
    {field_body, 7},
    {field_condition, 4},
    {field_init, 2},
  [331] =
    {field_body, 7},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [334] =
    {field_body, 7},
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_type, 2},
    {field_value, 5},
  [339] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [343] =
    {field_body, 7},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
  [347] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
  [350] =
    {field_arguments, 1},
    {field_constructor, 0},
  [352] =
    {field_body, 7},
    {field_interfaces, 6},
    {field_name, 3},
    {field_superclass, 5},
    {field_type_parameters, 4},
  [357] =
    {field_field, 1},
    {field_order, 2},
  [359] =
    {field_field, 2},
    {field_null_order, 4},
    {field_null_order, 5},
    {field_order, 3},
  [363] =
    {field_field, 2},
    {field_field, 5, .inherited = true},
    {field_null_order, 3},
    {field_null_order, 4},
  [367] =
    {field_body, 8},
    {field_condition, 3},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [371] =
    {field_body, 8},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [375] =
    {field_body, 8},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
  [379] =
    {field_body, 8},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
  [383] =
    {field_body, 8},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [387] =
    {field_body, 8},
    {field_dimensions, 4, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_type, 3},
    {field_value, 6},
  [392] =
    {field_body, 8},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [397] =
    {field_arguments, 2},
    {field_constructor, 1},
    {field_type_arguments, 0},
  [400] =
    {field_field, 1},
    {field_null_order, 2},
    {field_null_order, 3},
  [403] =
    {field_field, 2},
    {field_field, 6, .inherited = true},
    {field_null_order, 4},
    {field_null_order, 5},
    {field_order, 3},
  [408] =
    {field_body, 9},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [413] =
    {field_body, 9},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [418] =
    {field_body, 9},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
  [423] =
    {field_arguments, 3},
    {field_constructor, 2},
    {field_object, 0},
  [426] =
    {field_field, 1},
    {field_null_order, 3},
    {field_null_order, 4},
    {field_order, 2},
  [430] =
    {field_body, 10},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
    {field_update, 8, .inherited = true},
  [436] =
    {field_arguments, 4},
    {field_constructor, 3},
    {field_object, 0},
    {field_type_arguments, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [15] = {
    [1] = alias_sym_type_identifier,
  },
  [16] = {
    [1] = alias_sym_type_identifier,
  },
  [24] = {
    [0] = alias_sym_type_identifier,
    [2] = alias_sym_type_identifier,
  },
  [30] = {
    [2] = alias_sym_type_identifier,
  },
  [41] = {
    [1] = alias_sym_type_identifier,
  },
  [42] = {
    [1] = alias_sym_type_identifier,
  },
  [44] = {
    [2] = alias_sym_type_identifier,
  },
  [52] = {
    [0] = alias_sym_type_identifier,
    [3] = alias_sym_type_identifier,
  },
  [59] = {
    [3] = alias_sym_type_identifier,
  },
  [70] = {
    [1] = alias_sym_type_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 6688
    ? (c < 2984
      ? (c < 2365
        ? (c < 1376
          ? (c < 880
            ? (c < 192
              ? (c < 170
                ? (c < '_'
                  ? (c >= '$' && c <= 'Z')
                  : (c <= '_' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 736
                ? (c < 248
                  ? (c >= 216 && c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 750
                  ? c == 748
                  : c <= 750)))))
            : (c <= 884 || (c < 910
              ? (c < 902
                ? (c < 890
                  ? (c >= 886 && c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 908
                  ? (c >= 904 && c <= 906)
                  : c <= 908)))
              : (c <= 929 || (c < 1162
                ? (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : c <= 1153)
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2208
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2228 || (c < 2308
                  ? (c >= 2230 && c <= 2247)
                  : c <= 2361)))))))))
        : (c <= 2365 || (c < 2703
          ? (c < 2544
            ? (c < 2474
              ? (c < 2437
                ? (c < 2392
                  ? c == 2384
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2451
                  ? (c >= 2447 && c <= 2448)
                  : c <= 2472)))
              : (c <= 2480 || (c < 2510
                ? (c < 2486
                  ? c == 2482
                  : (c <= 2489 || c == 2493))
                : (c <= 2510 || (c < 2527
                  ? (c >= 2524 && c <= 2525)
                  : c <= 2529)))))
            : (c <= 2545 || (c < 2613
              ? (c < 2579
                ? (c < 2565
                  ? c == 2556
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2610
                  ? (c >= 2602 && c <= 2608)
                  : c <= 2611)))
              : (c <= 2614 || (c < 2654
                ? (c < 2649
                  ? (c >= 2616 && c <= 2617)
                  : c <= 2652)
                : (c <= 2654 || (c < 2693
                  ? (c >= 2674 && c <= 2676)
                  : c <= 2701)))))))
          : (c <= 2705 || (c < 2869
            ? (c < 2784
              ? (c < 2741
                ? (c < 2730
                  ? (c >= 2707 && c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2768
                  ? c == 2749
                  : c <= 2768)))
              : (c <= 2785 || (c < 2835
                ? (c < 2821
                  ? c == 2809
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))
                : (c <= 2856 || (c < 2866
                  ? (c >= 2858 && c <= 2864)
                  : c <= 2867)))))
            : (c <= 2873 || (c < 2958
              ? (c < 2929
                ? (c < 2908
                  ? c == 2877
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2929 || (c < 2949
                  ? c == 2947
                  : c <= 2954)))
              : (c <= 2960 || (c < 2972
                ? (c < 2969
                  ? (c >= 2962 && c <= 2965)
                  : c <= 2970)
                : (c <= 2972 || (c < 2979
                  ? (c >= 2974 && c <= 2975)
                  : c <= 2980)))))))))))
      : (c <= 2986 || (c < 4186
        ? (c < 3450
          ? (c < 3242
            ? (c < 3133
              ? (c < 3086
                ? (c < 3024
                  ? (c >= 2990 && c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))
                : (c <= 3088 || (c < 3114
                  ? (c >= 3090 && c <= 3112)
                  : c <= 3129)))
              : (c <= 3133 || (c < 3205
                ? (c < 3168
                  ? (c >= 3160 && c <= 3162)
                  : (c <= 3169 || c == 3200))
                : (c <= 3212 || (c < 3218
                  ? (c >= 3214 && c <= 3216)
                  : c <= 3240)))))
            : (c <= 3251 || (c < 3342
              ? (c < 3296
                ? (c < 3261
                  ? (c >= 3253 && c <= 3257)
                  : (c <= 3261 || c == 3294))
                : (c <= 3297 || (c < 3332
                  ? (c >= 3313 && c <= 3314)
                  : c <= 3340)))
              : (c <= 3344 || (c < 3406
                ? (c < 3389
                  ? (c >= 3346 && c <= 3386)
                  : c <= 3389)
                : (c <= 3406 || (c < 3423
                  ? (c >= 3412 && c <= 3414)
                  : c <= 3425)))))))
          : (c <= 3455 || (c < 3751
            ? (c < 3634
              ? (c < 3517
                ? (c < 3482
                  ? (c >= 3461 && c <= 3478)
                  : (c <= 3505 || (c >= 3507 && c <= 3515)))
                : (c <= 3517 || (c < 3585
                  ? (c >= 3520 && c <= 3526)
                  : c <= 3632)))
              : (c <= 3635 || (c < 3718
                ? (c < 3713
                  ? (c >= 3648 && c <= 3654)
                  : (c <= 3714 || c == 3716))
                : (c <= 3722 || (c < 3749
                  ? (c >= 3724 && c <= 3747)
                  : c <= 3749)))))
            : (c <= 3760 || (c < 3904
              ? (c < 3782
                ? (c < 3773
                  ? (c >= 3762 && c <= 3763)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))
                : (c <= 3782 || (c < 3840
                  ? (c >= 3804 && c <= 3807)
                  : c <= 3840)))
              : (c <= 3911 || (c < 4096
                ? (c < 3976
                  ? (c >= 3913 && c <= 3948)
                  : c <= 3980)
                : (c <= 4138 || (c < 4176
                  ? c == 4159
                  : c <= 4181)))))))))
        : (c <= 4189 || (c < 5024
          ? (c < 4698
            ? (c < 4295
              ? (c < 4213
                ? (c < 4197
                  ? c == 4193
                  : (c <= 4198 || (c >= 4206 && c <= 4208)))
                : (c <= 4225 || (c < 4256
                  ? c == 4238
                  : c <= 4293)))
              : (c <= 4295 || (c < 4682
                ? (c < 4304
                  ? c == 4301
                  : (c <= 4346 || (c >= 4348 && c <= 4680)))
                : (c <= 4685 || (c < 4696
                  ? (c >= 4688 && c <= 4694)
                  : c <= 4696)))))
            : (c <= 4701 || (c < 4802
              ? (c < 4786
                ? (c < 4746
                  ? (c >= 4704 && c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))
                : (c <= 4789 || (c < 4800
                  ? (c >= 4792 && c <= 4798)
                  : c <= 4800)))
              : (c <= 4805 || (c < 4882
                ? (c < 4824
                  ? (c >= 4808 && c <= 4822)
                  : c <= 4880)
                : (c <= 4885 || (c < 4992
                  ? (c >= 4888 && c <= 4954)
                  : c <= 5007)))))))
          : (c <= 5109 || (c < 6103
            ? (c < 5888
              ? (c < 5761
                ? (c < 5121
                  ? (c >= 5112 && c <= 5117)
                  : (c <= 5740 || (c >= 5743 && c <= 5759)))
                : (c <= 5786 || (c < 5873
                  ? (c >= 5792 && c <= 5866)
                  : c <= 5880)))
              : (c <= 5900 || (c < 5984
                ? (c < 5920
                  ? (c >= 5902 && c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6016
                  ? (c >= 5998 && c <= 6000)
                  : c <= 6067)))))
            : (c <= 6103 || (c < 6400
              ? (c < 6279
                ? (c < 6176
                  ? c == 6108
                  : (c <= 6264 || (c >= 6272 && c <= 6276)))
                : (c <= 6312 || (c < 6320
                  ? c == 6314
                  : c <= 6389)))
              : (c <= 6430 || (c < 6528
                ? (c < 6512
                  ? (c >= 6480 && c <= 6509)
                  : c <= 6516)
                : (c <= 6571 || (c < 6656
                  ? (c >= 6576 && c <= 6601)
                  : c <= 6678)))))))))))))
    : (c <= 6740 || (c < 43259
      ? (c < 11264
        ? (c < 8064
          ? (c < 7406
            ? (c < 7168
              ? (c < 7043
                ? (c < 6917
                  ? c == 6823
                  : (c <= 6963 || (c >= 6981 && c <= 6987)))
                : (c <= 7072 || (c < 7098
                  ? (c >= 7086 && c <= 7087)
                  : c <= 7141)))
              : (c <= 7203 || (c < 7312
                ? (c < 7258
                  ? (c >= 7245 && c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))
                : (c <= 7354 || (c < 7401
                  ? (c >= 7357 && c <= 7359)
                  : c <= 7404)))))
            : (c <= 7411 || (c < 8008
              ? (c < 7680
                ? (c < 7418
                  ? (c >= 7413 && c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))
                : (c <= 7957 || (c < 7968
                  ? (c >= 7960 && c <= 7965)
                  : c <= 8005)))
              : (c <= 8013 || (c < 8027
                ? (c < 8025
                  ? (c >= 8016 && c <= 8023)
                  : c <= 8025)
                : (c <= 8027 || (c < 8031
                  ? c == 8029
                  : c <= 8061)))))))
          : (c <= 8116 || (c < 8455
            ? (c < 8160
              ? (c < 8134
                ? (c < 8126
                  ? (c >= 8118 && c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))
                : (c <= 8140 || (c < 8150
                  ? (c >= 8144 && c <= 8147)
                  : c <= 8155)))
              : (c <= 8172 || (c < 8319
                ? (c < 8182
                  ? (c >= 8178 && c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8450
                  ? (c >= 8336 && c <= 8348)
                  : c <= 8450)))))
            : (c <= 8455 || (c < 8490
              ? (c < 8484
                ? (c < 8469
                  ? (c >= 8458 && c <= 8467)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8488
                  ? c == 8486
                  : c <= 8488)))
              : (c <= 8493 || (c < 8517
                ? (c < 8508
                  ? (c >= 8495 && c <= 8505)
                  : c <= 8511)
                : (c <= 8521 || (c < 8579
                  ? c == 8526
                  : c <= 8580)))))))))
        : (c <= 11310 || (c < 12549
          ? (c < 11704
            ? (c < 11565
              ? (c < 11506
                ? (c < 11360
                  ? (c >= 11312 && c <= 11358)
                  : (c <= 11492 || (c >= 11499 && c <= 11502)))
                : (c <= 11507 || (c < 11559
                  ? (c >= 11520 && c <= 11557)
                  : c <= 11559)))
              : (c <= 11565 || (c < 11680
                ? (c < 11631
                  ? (c >= 11568 && c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))
                : (c <= 11686 || (c < 11696
                  ? (c >= 11688 && c <= 11694)
                  : c <= 11702)))))
            : (c <= 11710 || (c < 12337
              ? (c < 11736
                ? (c < 11720
                  ? (c >= 11712 && c <= 11718)
                  : (c <= 11726 || (c >= 11728 && c <= 11734)))
                : (c <= 11742 || (c < 12293
                  ? c == 11823
                  : c <= 12294)))
              : (c <= 12341 || (c < 12445
                ? (c < 12353
                  ? (c >= 12347 && c <= 12348)
                  : c <= 12438)
                : (c <= 12447 || (c < 12540
                  ? (c >= 12449 && c <= 12538)
                  : c <= 12543)))))))
          : (c <= 12591 || (c < 42623
            ? (c < 40956
              ? (c < 13312
                ? (c < 12704
                  ? (c >= 12593 && c <= 12686)
                  : (c <= 12735 || (c >= 12784 && c <= 12799)))
                : (c <= 13312 || (c < 19968
                  ? c == 19903
                  : c <= 19968)))
              : (c <= 40956 || (c < 42512
                ? (c < 42192
                  ? (c >= 40960 && c <= 42124)
                  : (c <= 42237 || (c >= 42240 && c <= 42508)))
                : (c <= 42527 || (c < 42560
                  ? (c >= 42538 && c <= 42539)
                  : c <= 42606)))))
            : (c <= 42653 || (c < 43011
              ? (c < 42891
                ? (c < 42775
                  ? (c >= 42656 && c <= 42725)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))
                : (c <= 42943 || (c < 42997
                  ? (c >= 42946 && c <= 42954)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67828
            ? (c < 67639
              ? (c < 67584
                ? (c < 67392
                  ? (c >= 67072 && c <= 67382)
                  : (c <= 67413 || (c >= 67424 && c <= 67431)))
                : (c <= 67589 || (c < 67594
                  ? c == 67592
                  : c <= 67637)))
              : (c <= 67640 || (c < 67680
                ? (c < 67647
                  ? c == 67644
                  : c <= 67669)
                : (c <= 67702 || (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)))))
            : (c <= 67829 || (c < 68117
              ? (c < 68030
                ? (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : (c <= 67897 || (c >= 67968 && c <= 68023)))
                : (c <= 68031 || (c < 68112
                  ? c == 68096
                  : c <= 68115)))
              : (c <= 68119 || (c < 68224
                ? (c < 68192
                  ? (c >= 68121 && c <= 68149)
                  : c <= 68220)
                : (c <= 68252 || (c < 68297
                  ? (c >= 68288 && c <= 68295)
                  : c <= 68309)))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1369
          ? (c < 750
            ? (c < 186
              ? (c < 'a'
                ? (c < 'A'
                  ? c == '$'
                  : (c <= 'Z' || c == '_'))
                : (c <= 'z' || (c < 181
                  ? c == 170
                  : c <= 181)))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1015
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : c <= 1013)
                : (c <= 1153 || (c < 1329
                  ? (c >= 1162 && c <= 1327)
                  : c <= 1366)))))))
          : (c <= 1369 || (c < 1869
            ? (c < 1749
              ? (c < 1568
                ? (c < 1488
                  ? (c >= 1376 && c <= 1416)
                  : (c <= 1514 || (c >= 1519 && c <= 1522)))
                : (c <= 1610 || (c < 1649
                  ? (c >= 1646 && c <= 1647)
                  : c <= 1747)))
              : (c <= 1749 || (c < 1791
                ? (c < 1774
                  ? (c >= 1765 && c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1810
                  ? c == 1808
                  : c <= 1839)))))
            : (c <= 1957 || (c < 2084
              ? (c < 2042
                ? (c < 1994
                  ? c == 1969
                  : (c <= 2026 || (c >= 2036 && c <= 2037)))
                : (c <= 2042 || (c < 2074
                  ? (c >= 2048 && c <= 2069)
                  : c <= 2074)))
              : (c <= 2084 || (c < 2144
                ? (c < 2112
                  ? c == 2088
                  : c <= 2136)
                : (c <= 2154 || (c < 2230
                  ? (c >= 2208 && c <= 2228)
                  : c <= 2247)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4176
        ? (c < 3423
          ? (c < 3218
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3200
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || (c >= 3168 && c <= 3169)))
                : (c <= 3200 || (c < 3214
                  ? (c >= 3205 && c <= 3212)
                  : c <= 3216)))))
            : (c <= 3240 || (c < 3332
              ? (c < 3294
                ? (c < 3253
                  ? (c >= 3242 && c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3313
                  ? (c >= 3296 && c <= 3297)
                  : c <= 3314)))
              : (c <= 3340 || (c < 3389
                ? (c < 3346
                  ? (c >= 3342 && c <= 3344)
                  : c <= 3386)
                : (c <= 3389 || (c < 3412
                  ? c == 3406
                  : c <= 3414)))))))
          : (c <= 3425 || (c < 3749
            ? (c < 3585
              ? (c < 3507
                ? (c < 3461
                  ? (c >= 3450 && c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3520
                  ? c == 3517
                  : c <= 3526)))
              : (c <= 3632 || (c < 3716
                ? (c < 3648
                  ? (c >= 3634 && c <= 3635)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3724
                  ? (c >= 3718 && c <= 3722)
                  : c <= 3747)))))
            : (c <= 3749 || (c < 3840
              ? (c < 3776
                ? (c < 3762
                  ? (c >= 3751 && c <= 3760)
                  : (c <= 3763 || c == 3773))
                : (c <= 3780 || (c < 3804
                  ? c == 3782
                  : c <= 3807)))
              : (c <= 3840 || (c < 3976
                ? (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : c <= 3948)
                : (c <= 3980 || (c < 4159
                  ? (c >= 4096 && c <= 4138)
                  : c <= 4159)))))))))
        : (c <= 4181 || (c < 4992
          ? (c < 4696
            ? (c < 4256
              ? (c < 4206
                ? (c < 4193
                  ? (c >= 4186 && c <= 4189)
                  : (c <= 4193 || (c >= 4197 && c <= 4198)))
                : (c <= 4208 || (c < 4238
                  ? (c >= 4213 && c <= 4225)
                  : c <= 4238)))
              : (c <= 4293 || (c < 4348
                ? (c < 4301
                  ? c == 4295
                  : (c <= 4301 || (c >= 4304 && c <= 4346)))
                : (c <= 4680 || (c < 4688
                  ? (c >= 4682 && c <= 4685)
                  : c <= 4694)))))
            : (c <= 4696 || (c < 4800
              ? (c < 4752
                ? (c < 4704
                  ? (c >= 4698 && c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4792
                  ? (c >= 4786 && c <= 4789)
                  : c <= 4798)))
              : (c <= 4800 || (c < 4824
                ? (c < 4808
                  ? (c >= 4802 && c <= 4805)
                  : c <= 4822)
                : (c <= 4880 || (c < 4888
                  ? (c >= 4882 && c <= 4885)
                  : c <= 4954)))))))
          : (c <= 5007 || (c < 6016
            ? (c < 5873
              ? (c < 5743
                ? (c < 5112
                  ? (c >= 5024 && c <= 5109)
                  : (c <= 5117 || (c >= 5121 && c <= 5740)))
                : (c <= 5759 || (c < 5792
                  ? (c >= 5761 && c <= 5786)
                  : c <= 5866)))
              : (c <= 5880 || (c < 5952
                ? (c < 5902
                  ? (c >= 5888 && c <= 5900)
                  : (c <= 5905 || (c >= 5920 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43250
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6987 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12540
          ? (c < 11696
            ? (c < 11559
              ? (c < 11499
                ? (c < 11312
                  ? (c >= 11264 && c <= 11310)
                  : (c <= 11358 || (c >= 11360 && c <= 11492)))
                : (c <= 11502 || (c < 11520
                  ? (c >= 11506 && c <= 11507)
                  : c <= 11557)))
              : (c <= 11559 || (c < 11648
                ? (c < 11568
                  ? c == 11565
                  : (c <= 11623 || c == 11631))
                : (c <= 11670 || (c < 11688
                  ? (c >= 11680 && c <= 11686)
                  : c <= 11694)))))
            : (c <= 11702 || (c < 12293
              ? (c < 11728
                ? (c < 11712
                  ? (c >= 11704 && c <= 11710)
                  : (c <= 11718 || (c >= 11720 && c <= 11726)))
                : (c <= 11734 || (c < 11823
                  ? (c >= 11736 && c <= 11742)
                  : c <= 11823)))
              : (c <= 12294 || (c < 12353
                ? (c < 12347
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)
                : (c <= 12438 || (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : c <= 12538)))))))
          : (c <= 12543 || (c < 42560
            ? (c < 19968
              ? (c < 12784
                ? (c < 12593
                  ? (c >= 12549 && c <= 12591)
                  : (c <= 12686 || (c >= 12704 && c <= 12735)))
                : (c <= 12799 || (c < 19903
                  ? c == 13312
                  : c <= 19903)))
              : (c <= 19968 || (c < 42240
                ? (c < 40960
                  ? c == 40956
                  : (c <= 42124 || (c >= 42192 && c <= 42237)))
                : (c <= 42508 || (c < 42538
                  ? (c >= 42512 && c <= 42527)
                  : c <= 42539)))))
            : (c <= 42606 || (c < 42997
              ? (c < 42786
                ? (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : (c <= 42725 || (c >= 42775 && c <= 42783)))
                : (c <= 42888 || (c < 42946
                  ? (c >= 42891 && c <= 42943)
                  : c <= 42954)))
              : (c <= 43009 || (c < 43020
                ? (c < 43015
                  ? (c >= 43011 && c <= 43013)
                  : c <= 43018)
                : (c <= 43042 || (c < 43138
                  ? (c >= 43072 && c <= 43123)
                  : c <= 43187)))))))))))
      : (c <= 43255 || (c < 65142
        ? (c < 43793
          ? (c < 43616
            ? (c < 43471
              ? (c < 43312
                ? (c < 43261
                  ? c == 43259
                  : (c <= 43262 || (c >= 43274 && c <= 43301)))
                : (c <= 43334 || (c < 43396
                  ? (c >= 43360 && c <= 43388)
                  : c <= 43442)))
              : (c <= 43471 || (c < 43520
                ? (c < 43494
                  ? (c >= 43488 && c <= 43492)
                  : (c <= 43503 || (c >= 43514 && c <= 43518)))
                : (c <= 43560 || (c < 43588
                  ? (c >= 43584 && c <= 43586)
                  : c <= 43595)))))
            : (c <= 43638 || (c < 43714
              ? (c < 43701
                ? (c < 43646
                  ? c == 43642
                  : (c <= 43695 || c == 43697))
                : (c <= 43702 || (c < 43712
                  ? (c >= 43705 && c <= 43709)
                  : c <= 43712)))
              : (c <= 43714 || (c < 43762
                ? (c < 43744
                  ? (c >= 43739 && c <= 43741)
                  : c <= 43754)
                : (c <= 43764 || (c < 43785
                  ? (c >= 43777 && c <= 43782)
                  : c <= 43790)))))))
          : (c <= 43798 || (c < 64285
            ? (c < 55203
              ? (c < 43868
                ? (c < 43816
                  ? (c >= 43808 && c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))
                : (c <= 43881 || (c < 44032
                  ? (c >= 43888 && c <= 44002)
                  : c <= 44032)))
              : (c <= 55203 || (c < 64112
                ? (c < 55243
                  ? (c >= 55216 && c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))
                : (c <= 64217 || (c < 64275
                  ? (c >= 64256 && c <= 64262)
                  : c <= 64279)))))
            : (c <= 64285 || (c < 64326
              ? (c < 64318
                ? (c < 64298
                  ? (c >= 64287 && c <= 64296)
                  : (c <= 64310 || (c >= 64312 && c <= 64316)))
                : (c <= 64318 || (c < 64323
                  ? (c >= 64320 && c <= 64321)
                  : c <= 64324)))
              : (c <= 64433 || (c < 64914
                ? (c < 64848
                  ? (c >= 64467 && c <= 64829)
                  : c <= 64911)
                : (c <= 64967 || (c < 65136
                  ? (c >= 65008 && c <= 65019)
                  : c <= 65140)))))))))
        : (c <= 65276 || (c < 66816
          ? (c < 65664
            ? (c < 65498
              ? (c < 65474
                ? (c < 65345
                  ? (c >= 65313 && c <= 65338)
                  : (c <= 65370 || (c >= 65382 && c <= 65470)))
                : (c <= 65479 || (c < 65490
                  ? (c >= 65482 && c <= 65487)
                  : c <= 65495)))
              : (c <= 65500 || (c < 65596
                ? (c < 65549
                  ? (c >= 65536 && c <= 65547)
                  : (c <= 65574 || (c >= 65576 && c <= 65594)))
                : (c <= 65597 || (c < 65616
                  ? (c >= 65599 && c <= 65613)
                  : c <= 65629)))))
            : (c <= 65786 || (c < 66432
              ? (c < 66349
                ? (c < 66208
                  ? (c >= 66176 && c <= 66204)
                  : (c <= 66256 || (c >= 66304 && c <= 66335)))
                : (c <= 66368 || (c < 66384
                  ? (c >= 66370 && c <= 66377)
                  : c <= 66421)))
              : (c <= 66461 || (c < 66560
                ? (c < 66504
                  ? (c >= 66464 && c <= 66499)
                  : c <= 66511)
                : (c <= 66717 || (c < 66776
                  ? (c >= 66736 && c <= 66771)
                  : c <= 66811)))))))
          : (c <= 66855 || (c < 67828
            ? (c < 67594
              ? (c < 67424
                ? (c < 67072
                  ? (c >= 66864 && c <= 66915)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : c <= 67592)))
              : (c <= 67637 || (c < 67680
                ? (c < 67644
                  ? (c >= 67639 && c <= 67640)
                  : (c <= 67644 || (c >= 67647 && c <= 67669)))
                : (c <= 67702 || (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)))))
            : (c <= 67829 || (c < 68117
              ? (c < 68030
                ? (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : (c <= 67897 || (c >= 67968 && c <= 68023)))
                : (c <= 68031 || (c < 68112
                  ? c == 68096
                  : c <= 68115)))
              : (c <= 68119 || (c < 68224
                ? (c < 68192
                  ? (c >= 68121 && c <= 68149)
                  : c <= 68220)
                : (c <= 68252 || (c < 68297
                  ? (c >= 68288 && c <= 68295)
                  : c <= 68309)))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 6400
    ? (c < 2984
      ? (c < 2384
        ? (c < 1376
          ? (c < 750
            ? (c < 186
              ? (c < '_'
                ? (c < '0'
                  ? c == '$'
                  : (c <= '9' || (c >= 'A' && c <= 'Z')))
                : (c <= '_' || (c < 170
                  ? (c >= 'a' && c <= 'z')
                  : (c <= 170 || c == 181))))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1162
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1749
              ? (c < 1632
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1641 || (c < 1649
                  ? (c >= 1646 && c <= 1647)
                  : c <= 1747)))
              : (c <= 1749 || (c < 1808
                ? (c < 1774
                  ? (c >= 1765 && c <= 1766)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1984 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2230
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : (c <= 2154 || (c >= 2208 && c <= 2228)))
                : (c <= 2247 || (c < 2365
                  ? (c >= 2308 && c <= 2361)
                  : c <= 2365)))))))))
        : (c <= 2384 || (c < 2707
          ? (c < 2556
            ? (c < 2482
              ? (c < 2437
                ? (c < 2406
                  ? (c >= 2392 && c <= 2401)
                  : (c <= 2415 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2451
                  ? (c >= 2447 && c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))
              : (c <= 2482 || (c < 2524
                ? (c < 2493
                  ? (c >= 2486 && c <= 2489)
                  : (c <= 2493 || c == 2510))
                : (c <= 2525 || (c < 2534
                  ? (c >= 2527 && c <= 2529)
                  : c <= 2545)))))
            : (c <= 2556 || (c < 2616
              ? (c < 2602
                ? (c < 2575
                  ? (c >= 2565 && c <= 2570)
                  : (c <= 2576 || (c >= 2579 && c <= 2600)))
                : (c <= 2608 || (c < 2613
                  ? (c >= 2610 && c <= 2611)
                  : c <= 2614)))
              : (c <= 2617 || (c < 2674
                ? (c < 2654
                  ? (c >= 2649 && c <= 2652)
                  : (c <= 2654 || (c >= 2662 && c <= 2671)))
                : (c <= 2676 || (c < 2703
                  ? (c >= 2693 && c <= 2701)
                  : c <= 2705)))))))
          : (c <= 2728 || (c < 2869
            ? (c < 2790
              ? (c < 2749
                ? (c < 2738
                  ? (c >= 2730 && c <= 2736)
                  : (c <= 2739 || (c >= 2741 && c <= 2745)))
                : (c <= 2749 || (c < 2784
                  ? c == 2768
                  : c <= 2785)))
              : (c <= 2799 || (c < 2835
                ? (c < 2821
                  ? c == 2809
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))
                : (c <= 2856 || (c < 2866
                  ? (c >= 2858 && c <= 2864)
                  : c <= 2867)))))
            : (c <= 2873 || (c < 2949
              ? (c < 2918
                ? (c < 2908
                  ? c == 2877
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2927 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2972
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : (c <= 2965 || (c >= 2969 && c <= 2970)))
                : (c <= 2972 || (c < 2979
                  ? (c >= 2974 && c <= 2975)
                  : c <= 2980)))))))))))
      : (c <= 2986 || (c < 3913
        ? (c < 3423
          ? (c < 3218
            ? (c < 3133
              ? (c < 3077
                ? (c < 3024
                  ? (c >= 2990 && c <= 3001)
                  : (c <= 3024 || (c >= 3046 && c <= 3055)))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : (c <= 3112 || (c >= 3114 && c <= 3129)))))
              : (c <= 3133 || (c < 3200
                ? (c < 3168
                  ? (c >= 3160 && c <= 3162)
                  : (c <= 3169 || (c >= 3174 && c <= 3183)))
                : (c <= 3200 || (c < 3214
                  ? (c >= 3205 && c <= 3212)
                  : c <= 3216)))))
            : (c <= 3240 || (c < 3313
              ? (c < 3294
                ? (c < 3253
                  ? (c >= 3242 && c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3302
                  ? (c >= 3296 && c <= 3297)
                  : c <= 3311)))
              : (c <= 3314 || (c < 3389
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : (c <= 3344 || (c >= 3346 && c <= 3386)))
                : (c <= 3389 || (c < 3412
                  ? c == 3406
                  : c <= 3414)))))))
          : (c <= 3425 || (c < 3716
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3430 && c <= 3439)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3648
                ? (c < 3585
                  ? (c >= 3558 && c <= 3567)
                  : (c <= 3632 || (c >= 3634 && c <= 3635)))
                : (c <= 3654 || (c < 3713
                  ? (c >= 3664 && c <= 3673)
                  : c <= 3714)))))
            : (c <= 3716 || (c < 3776
              ? (c < 3751
                ? (c < 3724
                  ? (c >= 3718 && c <= 3722)
                  : (c <= 3747 || c == 3749))
                : (c <= 3760 || (c < 3773
                  ? (c >= 3762 && c <= 3763)
                  : c <= 3773)))
              : (c <= 3780 || (c < 3840
                ? (c < 3792
                  ? c == 3782
                  : (c <= 3801 || (c >= 3804 && c <= 3807)))
                : (c <= 3840 || (c < 3904
                  ? (c >= 3872 && c <= 3881)
                  : c <= 3911)))))))))
        : (c <= 3948 || (c < 4808
          ? (c < 4301
            ? (c < 4197
              ? (c < 4176
                ? (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : (c <= 4138 || (c >= 4159 && c <= 4169)))
                : (c <= 4181 || (c < 4193
                  ? (c >= 4186 && c <= 4189)
                  : c <= 4193)))
              : (c <= 4198 || (c < 4240
                ? (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : (c <= 4225 || c == 4238))
                : (c <= 4249 || (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : c <= 4295)))))
            : (c <= 4301 || (c < 4704
              ? (c < 4688
                ? (c < 4348
                  ? (c >= 4304 && c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))
                : (c <= 4694 || (c < 4698
                  ? c == 4696
                  : c <= 4701)))
              : (c <= 4744 || (c < 4792
                ? (c < 4752
                  ? (c >= 4746 && c <= 4749)
                  : (c <= 4784 || (c >= 4786 && c <= 4789)))
                : (c <= 4798 || (c < 4802
                  ? c == 4800
                  : c <= 4805)))))))
          : (c <= 4822 || (c < 5920
            ? (c < 5121
              ? (c < 4992
                ? (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : (c <= 4885 || (c >= 4888 && c <= 4954)))
                : (c <= 5007 || (c < 5112
                  ? (c >= 5024 && c <= 5109)
                  : c <= 5117)))
              : (c <= 5740 || (c < 5873
                ? (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : (c <= 5786 || (c >= 5792 && c <= 5866)))
                : (c <= 5880 || (c < 5902
                  ? (c >= 5888 && c <= 5900)
                  : c <= 5905)))))
            : (c <= 5937 || (c < 6112
              ? (c < 6016
                ? (c < 5984
                  ? (c >= 5952 && c <= 5969)
                  : (c <= 5996 || (c >= 5998 && c <= 6000)))
                : (c <= 6067 || (c < 6108
                  ? c == 6103
                  : c <= 6108)))
              : (c <= 6121 || (c < 6279
                ? (c < 6176
                  ? (c >= 6160 && c <= 6169)
                  : (c <= 6264 || (c >= 6272 && c <= 6276)))
                : (c <= 6312 || (c < 6320
                  ? c == 6314
                  : c <= 6389)))))))))))))
    : (c <= 6430 || (c < 43138
      ? (c < 8490
        ? (c < 7968
          ? (c < 7086
            ? (c < 6784
              ? (c < 6576
                ? (c < 6512
                  ? (c >= 6470 && c <= 6509)
                  : (c <= 6516 || (c >= 6528 && c <= 6571)))
                : (c <= 6601 || (c < 6656
                  ? (c >= 6608 && c <= 6617)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6793 || (c < 6981
                ? (c < 6823
                  ? (c >= 6800 && c <= 6809)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6987 || (c < 7043
                  ? (c >= 6992 && c <= 7001)
                  : c <= 7072)))))
            : (c <= 7141 || (c < 7401
              ? (c < 7296
                ? (c < 7232
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7241 || (c >= 7245 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))
              : (c <= 7404 || (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))))))
          : (c <= 8005 || (c < 8160
            ? (c < 8064
              ? (c < 8027
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : (c <= 8023 || c == 8025))
                : (c <= 8027 || (c < 8031
                  ? c == 8029
                  : c <= 8061)))
              : (c <= 8116 || (c < 8134
                ? (c < 8126
                  ? (c >= 8118 && c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))
                : (c <= 8140 || (c < 8150
                  ? (c >= 8144 && c <= 8147)
                  : c <= 8155)))))
            : (c <= 8172 || (c < 8455
              ? (c < 8319
                ? (c < 8182
                  ? (c >= 8178 && c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8450
                  ? (c >= 8336 && c <= 8348)
                  : c <= 8450)))
              : (c <= 8455 || (c < 8484
                ? (c < 8469
                  ? (c >= 8458 && c <= 8467)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8488
                  ? c == 8486
                  : c <= 8488)))))))))
        : (c <= 8493 || (c < 12353
          ? (c < 11631
            ? (c < 11360
              ? (c < 8526
                ? (c < 8508
                  ? (c >= 8495 && c <= 8505)
                  : (c <= 8511 || (c >= 8517 && c <= 8521)))
                : (c <= 8526 || (c < 11264
                  ? (c >= 8579 && c <= 8580)
                  : (c <= 11310 || (c >= 11312 && c <= 11358)))))
              : (c <= 11492 || (c < 11559
                ? (c < 11506
                  ? (c >= 11499 && c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11568
                  ? c == 11565
                  : c <= 11623)))))
            : (c <= 11631 || (c < 11720
              ? (c < 11696
                ? (c < 11680
                  ? (c >= 11648 && c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))
                : (c <= 11702 || (c < 11712
                  ? (c >= 11704 && c <= 11710)
                  : c <= 11718)))
              : (c <= 11726 || (c < 12293
                ? (c < 11736
                  ? (c >= 11728 && c <= 11734)
                  : (c <= 11742 || c == 11823))
                : (c <= 12294 || (c < 12347
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)))))))
          : (c <= 12438 || (c < 42240
            ? (c < 12784
              ? (c < 12549
                ? (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : (c <= 12538 || (c >= 12540 && c <= 12543)))
                : (c <= 12591 || (c < 12704
                  ? (c >= 12593 && c <= 12686)
                  : c <= 12735)))
              : (c <= 12799 || (c < 40956
                ? (c < 19903
                  ? c == 13312
                  : (c <= 19903 || c == 19968))
                : (c <= 40956 || (c < 42192
                  ? (c >= 40960 && c <= 42124)
                  : c <= 42237)))))
            : (c <= 42508 || (c < 42891
              ? (c < 42656
                ? (c < 42560
                  ? (c >= 42512 && c <= 42539)
                  : (c <= 42606 || (c >= 42623 && c <= 42653)))
                : (c <= 42725 || (c < 42786
                  ? (c >= 42775 && c <= 42783)
                  : c <= 42888)))
              : (c <= 42943 || (c < 43015
                ? (c < 42997
                  ? (c >= 42946 && c <= 42954)
                  : (c <= 43009 || (c >= 43011 && c <= 43013)))
                : (c <= 43018 || (c < 43072
                  ? (c >= 43020 && c <= 43042)
                  : c <= 43123)))))))))))
      : (c <= 43187 || (c < 65142
        ? (c < 43793
          ? (c < 43600
            ? (c < 43396
              ? (c < 43261
                ? (c < 43250
                  ? (c >= 43216 && c <= 43225)
                  : (c <= 43255 || c == 43259))
                : (c <= 43262 || (c < 43312
                  ? (c >= 43264 && c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))))
              : (c <= 43442 || (c < 43520
                ? (c < 43488
                  ? (c >= 43471 && c <= 43481)
                  : (c <= 43492 || (c >= 43494 && c <= 43518)))
                : (c <= 43560 || (c < 43588
                  ? (c >= 43584 && c <= 43586)
                  : c <= 43595)))))
            : (c <= 43609 || (c < 43712
              ? (c < 43697
                ? (c < 43642
                  ? (c >= 43616 && c <= 43638)
                  : (c <= 43642 || (c >= 43646 && c <= 43695)))
                : (c <= 43697 || (c < 43705
                  ? (c >= 43701 && c <= 43702)
                  : c <= 43709)))
              : (c <= 43712 || (c < 43762
                ? (c < 43739
                  ? c == 43714
                  : (c <= 43741 || (c >= 43744 && c <= 43754)))
                : (c <= 43764 || (c < 43785
                  ? (c >= 43777 && c <= 43782)
                  : c <= 43790)))))))
          : (c <= 43798 || (c < 64275
            ? (c < 44032
              ? (c < 43868
                ? (c < 43816
                  ? (c >= 43808 && c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))
                : (c <= 43881 || (c < 44016
                  ? (c >= 43888 && c <= 44002)
                  : c <= 44025)))
              : (c <= 44032 || (c < 63744
                ? (c < 55216
                  ? c == 55203
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64256
                  ? (c >= 64112 && c <= 64217)
                  : c <= 64262)))))
            : (c <= 64279 || (c < 64323
              ? (c < 64312
                ? (c < 64287
                  ? c == 64285
                  : (c <= 64296 || (c >= 64298 && c <= 64310)))
                : (c <= 64316 || (c < 64320
                  ? c == 64318
                  : c <= 64321)))
              : (c <= 64324 || (c < 64914
                ? (c < 64467
                  ? (c >= 64326 && c <= 64433)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))
                : (c <= 64967 || (c < 65136
                  ? (c >= 65008 && c <= 65019)
                  : c <= 65140)))))))))
        : (c <= 65276 || (c < 66776
          ? (c < 65616
            ? (c < 65490
              ? (c < 65382
                ? (c < 65313
                  ? (c >= 65296 && c <= 65305)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))
                : (c <= 65470 || (c < 65482
                  ? (c >= 65474 && c <= 65479)
                  : c <= 65487)))
              : (c <= 65495 || (c < 65576
                ? (c < 65536
                  ? (c >= 65498 && c <= 65500)
                  : (c <= 65547 || (c >= 65549 && c <= 65574)))
                : (c <= 65594 || (c < 65599
                  ? (c >= 65596 && c <= 65597)
                  : c <= 65613)))))
            : (c <= 65629 || (c < 66384
              ? (c < 66304
                ? (c < 66176
                  ? (c >= 65664 && c <= 65786)
                  : (c <= 66204 || (c >= 66208 && c <= 66256)))
                : (c <= 66335 || (c < 66370
                  ? (c >= 66349 && c <= 66368)
                  : c <= 66377)))
              : (c <= 66421 || (c < 66560
                ? (c < 66464
                  ? (c >= 66432 && c <= 66461)
                  : (c <= 66499 || (c >= 66504 && c <= 66511)))
                : (c <= 66717 || (c < 66736
                  ? (c >= 66720 && c <= 66729)
                  : c <= 66771)))))))
          : (c <= 66811 || (c < 67808
            ? (c < 67592
              ? (c < 67392
                ? (c < 66864
                  ? (c >= 66816 && c <= 66855)
                  : (c <= 66915 || (c >= 67072 && c <= 67382)))
                : (c <= 67413 || (c < 67584
                  ? (c >= 67424 && c <= 67431)
                  : c <= 67589)))
              : (c <= 67592 || (c < 67647
                ? (c < 67639
                  ? (c >= 67594 && c <= 67637)
                  : (c <= 67640 || c == 67644))
                : (c <= 67669 || (c < 67712
                  ? (c >= 67680 && c <= 67702)
                  : c <= 67742)))))
            : (c <= 67826 || (c < 68112
              ? (c < 67968
                ? (c < 67840
                  ? (c >= 67828 && c <= 67829)
                  : (c <= 67861 || (c >= 67872 && c <= 67897)))
                : (c <= 68023 || (c < 68096
                  ? (c >= 68030 && c <= 68031)
                  : c <= 68096)))
              : (c <= 68115 || (c < 68224
                ? (c < 68121
                  ? (c >= 68117 && c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))
                : (c <= 68252 || (c < 68297
                  ? (c >= 68288 && c <= 68295)
                  : c <= 68309)))))))))))))));
}

static inline bool sym_identifier_character_set_4(int32_t c) {
  return (c < 6400
    ? (c < 2984
      ? (c < 2384
        ? (c < 1376
          ? (c < 750
            ? (c < 186
              ? (c < '_'
                ? (c < '0'
                  ? c == '$'
                  : (c <= '9' || (c >= 'B' && c <= 'Z')))
                : (c <= '_' || (c < 170
                  ? (c >= 'b' && c <= 'z')
                  : (c <= 170 || c == 181))))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1162
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1749
              ? (c < 1632
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1641 || (c < 1649
                  ? (c >= 1646 && c <= 1647)
                  : c <= 1747)))
              : (c <= 1749 || (c < 1808
                ? (c < 1774
                  ? (c >= 1765 && c <= 1766)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1984 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2230
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : (c <= 2154 || (c >= 2208 && c <= 2228)))
                : (c <= 2247 || (c < 2365
                  ? (c >= 2308 && c <= 2361)
                  : c <= 2365)))))))))
        : (c <= 2384 || (c < 2707
          ? (c < 2556
            ? (c < 2482
              ? (c < 2437
                ? (c < 2406
                  ? (c >= 2392 && c <= 2401)
                  : (c <= 2415 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2451
                  ? (c >= 2447 && c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))
              : (c <= 2482 || (c < 2524
                ? (c < 2493
                  ? (c >= 2486 && c <= 2489)
                  : (c <= 2493 || c == 2510))
                : (c <= 2525 || (c < 2534
                  ? (c >= 2527 && c <= 2529)
                  : c <= 2545)))))
            : (c <= 2556 || (c < 2616
              ? (c < 2602
                ? (c < 2575
                  ? (c >= 2565 && c <= 2570)
                  : (c <= 2576 || (c >= 2579 && c <= 2600)))
                : (c <= 2608 || (c < 2613
                  ? (c >= 2610 && c <= 2611)
                  : c <= 2614)))
              : (c <= 2617 || (c < 2674
                ? (c < 2654
                  ? (c >= 2649 && c <= 2652)
                  : (c <= 2654 || (c >= 2662 && c <= 2671)))
                : (c <= 2676 || (c < 2703
                  ? (c >= 2693 && c <= 2701)
                  : c <= 2705)))))))
          : (c <= 2728 || (c < 2869
            ? (c < 2790
              ? (c < 2749
                ? (c < 2738
                  ? (c >= 2730 && c <= 2736)
                  : (c <= 2739 || (c >= 2741 && c <= 2745)))
                : (c <= 2749 || (c < 2784
                  ? c == 2768
                  : c <= 2785)))
              : (c <= 2799 || (c < 2835
                ? (c < 2821
                  ? c == 2809
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))
                : (c <= 2856 || (c < 2866
                  ? (c >= 2858 && c <= 2864)
                  : c <= 2867)))))
            : (c <= 2873 || (c < 2949
              ? (c < 2918
                ? (c < 2908
                  ? c == 2877
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2927 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2972
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : (c <= 2965 || (c >= 2969 && c <= 2970)))
                : (c <= 2972 || (c < 2979
                  ? (c >= 2974 && c <= 2975)
                  : c <= 2980)))))))))))
      : (c <= 2986 || (c < 3913
        ? (c < 3423
          ? (c < 3218
            ? (c < 3133
              ? (c < 3077
                ? (c < 3024
                  ? (c >= 2990 && c <= 3001)
                  : (c <= 3024 || (c >= 3046 && c <= 3055)))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : (c <= 3112 || (c >= 3114 && c <= 3129)))))
              : (c <= 3133 || (c < 3200
                ? (c < 3168
                  ? (c >= 3160 && c <= 3162)
                  : (c <= 3169 || (c >= 3174 && c <= 3183)))
                : (c <= 3200 || (c < 3214
                  ? (c >= 3205 && c <= 3212)
                  : c <= 3216)))))
            : (c <= 3240 || (c < 3313
              ? (c < 3294
                ? (c < 3253
                  ? (c >= 3242 && c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3302
                  ? (c >= 3296 && c <= 3297)
                  : c <= 3311)))
              : (c <= 3314 || (c < 3389
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : (c <= 3344 || (c >= 3346 && c <= 3386)))
                : (c <= 3389 || (c < 3412
                  ? c == 3406
                  : c <= 3414)))))))
          : (c <= 3425 || (c < 3716
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3430 && c <= 3439)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3648
                ? (c < 3585
                  ? (c >= 3558 && c <= 3567)
                  : (c <= 3632 || (c >= 3634 && c <= 3635)))
                : (c <= 3654 || (c < 3713
                  ? (c >= 3664 && c <= 3673)
                  : c <= 3714)))))
            : (c <= 3716 || (c < 3776
              ? (c < 3751
                ? (c < 3724
                  ? (c >= 3718 && c <= 3722)
                  : (c <= 3747 || c == 3749))
                : (c <= 3760 || (c < 3773
                  ? (c >= 3762 && c <= 3763)
                  : c <= 3773)))
              : (c <= 3780 || (c < 3840
                ? (c < 3792
                  ? c == 3782
                  : (c <= 3801 || (c >= 3804 && c <= 3807)))
                : (c <= 3840 || (c < 3904
                  ? (c >= 3872 && c <= 3881)
                  : c <= 3911)))))))))
        : (c <= 3948 || (c < 4808
          ? (c < 4301
            ? (c < 4197
              ? (c < 4176
                ? (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : (c <= 4138 || (c >= 4159 && c <= 4169)))
                : (c <= 4181 || (c < 4193
                  ? (c >= 4186 && c <= 4189)
                  : c <= 4193)))
              : (c <= 4198 || (c < 4240
                ? (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : (c <= 4225 || c == 4238))
                : (c <= 4249 || (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : c <= 4295)))))
            : (c <= 4301 || (c < 4704
              ? (c < 4688
                ? (c < 4348
                  ? (c >= 4304 && c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))
                : (c <= 4694 || (c < 4698
                  ? c == 4696
                  : c <= 4701)))
              : (c <= 4744 || (c < 4792
                ? (c < 4752
                  ? (c >= 4746 && c <= 4749)
                  : (c <= 4784 || (c >= 4786 && c <= 4789)))
                : (c <= 4798 || (c < 4802
                  ? c == 4800
                  : c <= 4805)))))))
          : (c <= 4822 || (c < 5920
            ? (c < 5121
              ? (c < 4992
                ? (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : (c <= 4885 || (c >= 4888 && c <= 4954)))
                : (c <= 5007 || (c < 5112
                  ? (c >= 5024 && c <= 5109)
                  : c <= 5117)))
              : (c <= 5740 || (c < 5873
                ? (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : (c <= 5786 || (c >= 5792 && c <= 5866)))
                : (c <= 5880 || (c < 5902
                  ? (c >= 5888 && c <= 5900)
                  : c <= 5905)))))
            : (c <= 5937 || (c < 6112
              ? (c < 6016
                ? (c < 5984
                  ? (c >= 5952 && c <= 5969)
                  : (c <= 5996 || (c >= 5998 && c <= 6000)))
                : (c <= 6067 || (c < 6108
                  ? c == 6103
                  : c <= 6108)))
              : (c <= 6121 || (c < 6279
                ? (c < 6176
                  ? (c >= 6160 && c <= 6169)
                  : (c <= 6264 || (c >= 6272 && c <= 6276)))
                : (c <= 6312 || (c < 6320
                  ? c == 6314
                  : c <= 6389)))))))))))))
    : (c <= 6430 || (c < 43138
      ? (c < 8490
        ? (c < 7968
          ? (c < 7086
            ? (c < 6784
              ? (c < 6576
                ? (c < 6512
                  ? (c >= 6470 && c <= 6509)
                  : (c <= 6516 || (c >= 6528 && c <= 6571)))
                : (c <= 6601 || (c < 6656
                  ? (c >= 6608 && c <= 6617)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6793 || (c < 6981
                ? (c < 6823
                  ? (c >= 6800 && c <= 6809)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6987 || (c < 7043
                  ? (c >= 6992 && c <= 7001)
                  : c <= 7072)))))
            : (c <= 7141 || (c < 7401
              ? (c < 7296
                ? (c < 7232
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7241 || (c >= 7245 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))
              : (c <= 7404 || (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))))))
          : (c <= 8005 || (c < 8160
            ? (c < 8064
              ? (c < 8027
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : (c <= 8023 || c == 8025))
                : (c <= 8027 || (c < 8031
                  ? c == 8029
                  : c <= 8061)))
              : (c <= 8116 || (c < 8134
                ? (c < 8126
                  ? (c >= 8118 && c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))
                : (c <= 8140 || (c < 8150
                  ? (c >= 8144 && c <= 8147)
                  : c <= 8155)))))
            : (c <= 8172 || (c < 8455
              ? (c < 8319
                ? (c < 8182
                  ? (c >= 8178 && c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8450
                  ? (c >= 8336 && c <= 8348)
                  : c <= 8450)))
              : (c <= 8455 || (c < 8484
                ? (c < 8469
                  ? (c >= 8458 && c <= 8467)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8488
                  ? c == 8486
                  : c <= 8488)))))))))
        : (c <= 8493 || (c < 12353
          ? (c < 11631
            ? (c < 11360
              ? (c < 8526
                ? (c < 8508
                  ? (c >= 8495 && c <= 8505)
                  : (c <= 8511 || (c >= 8517 && c <= 8521)))
                : (c <= 8526 || (c < 11264
                  ? (c >= 8579 && c <= 8580)
                  : (c <= 11310 || (c >= 11312 && c <= 11358)))))
              : (c <= 11492 || (c < 11559
                ? (c < 11506
                  ? (c >= 11499 && c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11568
                  ? c == 11565
                  : c <= 11623)))))
            : (c <= 11631 || (c < 11720
              ? (c < 11696
                ? (c < 11680
                  ? (c >= 11648 && c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))
                : (c <= 11702 || (c < 11712
                  ? (c >= 11704 && c <= 11710)
                  : c <= 11718)))
              : (c <= 11726 || (c < 12293
                ? (c < 11736
                  ? (c >= 11728 && c <= 11734)
                  : (c <= 11742 || c == 11823))
                : (c <= 12294 || (c < 12347
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)))))))
          : (c <= 12438 || (c < 42240
            ? (c < 12784
              ? (c < 12549
                ? (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : (c <= 12538 || (c >= 12540 && c <= 12543)))
                : (c <= 12591 || (c < 12704
                  ? (c >= 12593 && c <= 12686)
                  : c <= 12735)))
              : (c <= 12799 || (c < 40956
                ? (c < 19903
                  ? c == 13312
                  : (c <= 19903 || c == 19968))
                : (c <= 40956 || (c < 42192
                  ? (c >= 40960 && c <= 42124)
                  : c <= 42237)))))
            : (c <= 42508 || (c < 42891
              ? (c < 42656
                ? (c < 42560
                  ? (c >= 42512 && c <= 42539)
                  : (c <= 42606 || (c >= 42623 && c <= 42653)))
                : (c <= 42725 || (c < 42786
                  ? (c >= 42775 && c <= 42783)
                  : c <= 42888)))
              : (c <= 42943 || (c < 43015
                ? (c < 42997
                  ? (c >= 42946 && c <= 42954)
                  : (c <= 43009 || (c >= 43011 && c <= 43013)))
                : (c <= 43018 || (c < 43072
                  ? (c >= 43020 && c <= 43042)
                  : c <= 43123)))))))))))
      : (c <= 43187 || (c < 65142
        ? (c < 43793
          ? (c < 43600
            ? (c < 43396
              ? (c < 43261
                ? (c < 43250
                  ? (c >= 43216 && c <= 43225)
                  : (c <= 43255 || c == 43259))
                : (c <= 43262 || (c < 43312
                  ? (c >= 43264 && c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))))
              : (c <= 43442 || (c < 43520
                ? (c < 43488
                  ? (c >= 43471 && c <= 43481)
                  : (c <= 43492 || (c >= 43494 && c <= 43518)))
                : (c <= 43560 || (c < 43588
                  ? (c >= 43584 && c <= 43586)
                  : c <= 43595)))))
            : (c <= 43609 || (c < 43712
              ? (c < 43697
                ? (c < 43642
                  ? (c >= 43616 && c <= 43638)
                  : (c <= 43642 || (c >= 43646 && c <= 43695)))
                : (c <= 43697 || (c < 43705
                  ? (c >= 43701 && c <= 43702)
                  : c <= 43709)))
              : (c <= 43712 || (c < 43762
                ? (c < 43739
                  ? c == 43714
                  : (c <= 43741 || (c >= 43744 && c <= 43754)))
                : (c <= 43764 || (c < 43785
                  ? (c >= 43777 && c <= 43782)
                  : c <= 43790)))))))
          : (c <= 43798 || (c < 64275
            ? (c < 44032
              ? (c < 43868
                ? (c < 43816
                  ? (c >= 43808 && c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))
                : (c <= 43881 || (c < 44016
                  ? (c >= 43888 && c <= 44002)
                  : c <= 44025)))
              : (c <= 44032 || (c < 63744
                ? (c < 55216
                  ? c == 55203
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64256
                  ? (c >= 64112 && c <= 64217)
                  : c <= 64262)))))
            : (c <= 64279 || (c < 64323
              ? (c < 64312
                ? (c < 64287
                  ? c == 64285
                  : (c <= 64296 || (c >= 64298 && c <= 64310)))
                : (c <= 64316 || (c < 64320
                  ? c == 64318
                  : c <= 64321)))
              : (c <= 64324 || (c < 64914
                ? (c < 64467
                  ? (c >= 64326 && c <= 64433)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))
                : (c <= 64967 || (c < 65136
                  ? (c >= 65008 && c <= 65019)
                  : c <= 65140)))))))))
        : (c <= 65276 || (c < 66776
          ? (c < 65616
            ? (c < 65490
              ? (c < 65382
                ? (c < 65313
                  ? (c >= 65296 && c <= 65305)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))
                : (c <= 65470 || (c < 65482
                  ? (c >= 65474 && c <= 65479)
                  : c <= 65487)))
              : (c <= 65495 || (c < 65576
                ? (c < 65536
                  ? (c >= 65498 && c <= 65500)
                  : (c <= 65547 || (c >= 65549 && c <= 65574)))
                : (c <= 65594 || (c < 65599
                  ? (c >= 65596 && c <= 65597)
                  : c <= 65613)))))
            : (c <= 65629 || (c < 66384
              ? (c < 66304
                ? (c < 66176
                  ? (c >= 65664 && c <= 65786)
                  : (c <= 66204 || (c >= 66208 && c <= 66256)))
                : (c <= 66335 || (c < 66370
                  ? (c >= 66349 && c <= 66368)
                  : c <= 66377)))
              : (c <= 66421 || (c < 66560
                ? (c < 66464
                  ? (c >= 66432 && c <= 66461)
                  : (c <= 66499 || (c >= 66504 && c <= 66511)))
                : (c <= 66717 || (c < 66736
                  ? (c >= 66720 && c <= 66729)
                  : c <= 66771)))))))
          : (c <= 66811 || (c < 67808
            ? (c < 67592
              ? (c < 67392
                ? (c < 66864
                  ? (c >= 66816 && c <= 66855)
                  : (c <= 66915 || (c >= 67072 && c <= 67382)))
                : (c <= 67413 || (c < 67584
                  ? (c >= 67424 && c <= 67431)
                  : c <= 67589)))
              : (c <= 67592 || (c < 67647
                ? (c < 67639
                  ? (c >= 67594 && c <= 67637)
                  : (c <= 67640 || c == 67644))
                : (c <= 67669 || (c < 67712
                  ? (c >= 67680 && c <= 67702)
                  : c <= 67742)))))
            : (c <= 67826 || (c < 68112
              ? (c < 67968
                ? (c < 67840
                  ? (c >= 67828 && c <= 67829)
                  : (c <= 67861 || (c >= 67872 && c <= 67897)))
                : (c <= 68023 || (c < 68096
                  ? (c >= 68030 && c <= 68031)
                  : c <= 68096)))
              : (c <= 68115 || (c < 68224
                ? (c < 68121
                  ? (c >= 68117 && c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))
                : (c <= 68252 || (c < 68297
                  ? (c >= 68288 && c <= 68295)
                  : c <= 68309)))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(109);
      if (lookahead == '%') ADVANCE(100);
      if (lookahead == '&') ADVANCE(62);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(50);
      if (lookahead == ')') ADVANCE(51);
      if (lookahead == '*') ADVANCE(91);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(48);
      if (lookahead == '-') ADVANCE(89);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == ';') ADVANCE(59);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(75);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '@') ADVANCE(118);
      if (lookahead == 'B') ADVANCE(123);
      if (lookahead == '[') ADVANCE(46);
      if (lookahead == ']') ADVANCE(47);
      if (lookahead == '^') ADVANCE(98);
      if (lookahead == '{') ADVANCE(113);
      if (lookahead == '|') ADVANCE(95);
      if (lookahead == '}') ADVANCE(114);
      if (lookahead == '~') ADVANCE(110);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(132);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(127);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(142);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(143);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(108);
      if (lookahead == '&') ADVANCE(60);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(50);
      if (lookahead == ')') ADVANCE(51);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(48);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(33);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == ';') ADVANCE(59);
      if (lookahead == '<') ADVANCE(77);
      if (lookahead == '>') ADVANCE(74);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '@') ADVANCE(118);
      if (lookahead == '[') ADVANCE(46);
      if (lookahead == ']') ADVANCE(47);
      if (lookahead == '{') ADVANCE(113);
      if (lookahead == '|') ADVANCE(94);
      if (lookahead == '}') ADVANCE(114);
      if (lookahead == '~') ADVANCE(110);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(143);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(108);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(50);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(33);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '[') ADVANCE(46);
      if (lookahead == '~') ADVANCE(110);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(127);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(143);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(13);
      if (lookahead == '%') ADVANCE(100);
      if (lookahead == '&') ADVANCE(62);
      if (lookahead == '(') ADVANCE(50);
      if (lookahead == ')') ADVANCE(51);
      if (lookahead == '*') ADVANCE(91);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(48);
      if (lookahead == '-') ADVANCE(89);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == ';') ADVANCE(59);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(75);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '@') ADVANCE(118);
      if (lookahead == '[') ADVANCE(46);
      if (lookahead == ']') ADVANCE(47);
      if (lookahead == '^') ADVANCE(98);
      if (lookahead == '{') ADVANCE(113);
      if (lookahead == '|') ADVANCE(95);
      if (lookahead == '}') ADVANCE(114);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(143);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(13);
      if (lookahead == '%') ADVANCE(99);
      if (lookahead == '&') ADVANCE(61);
      if (lookahead == '(') ADVANCE(50);
      if (lookahead == ')') ADVANCE(51);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(48);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == ';') ADVANCE(59);
      if (lookahead == '<') ADVANCE(79);
      if (lookahead == '=') ADVANCE(14);
      if (lookahead == '>') ADVANCE(76);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '[') ADVANCE(46);
      if (lookahead == ']') ADVANCE(47);
      if (lookahead == '^') ADVANCE(97);
      if (lookahead == '{') ADVANCE(113);
      if (lookahead == '|') ADVANCE(96);
      if (lookahead == '}') ADVANCE(114);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(143);
      END_STATE();
    case 5:
      if (lookahead == '&') ADVANCE(60);
      if (lookahead == '(') ADVANCE(50);
      if (lookahead == ')') ADVANCE(51);
      if (lookahead == ',') ADVANCE(48);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == ';') ADVANCE(59);
      if (lookahead == '<') ADVANCE(77);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(74);
      if (lookahead == '[') ADVANCE(46);
      if (lookahead == '{') ADVANCE(113);
      if (lookahead == '|') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(143);
      END_STATE();
    case 6:
      if (lookahead == '\'') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '(') ADVANCE(50);
      if (lookahead == ')') ADVANCE(51);
      if (lookahead == ',') ADVANCE(48);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '<') ADVANCE(77);
      if (lookahead == '@') ADVANCE(118);
      if (lookahead == '}') ADVANCE(114);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(132);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(143);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(144);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead == '/') ADVANCE(145);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 11:
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '<') ADVANCE(77);
      if (lookahead == 'B') ADVANCE(15);
      if (lookahead == '{') ADVANCE(113);
      if (lookahead == '}') ADVANCE(114);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(25);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      END_STATE();
    case 12:
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '}') ADVANCE(114);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(143);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(54);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(82);
      END_STATE();
    case 15:
      if (lookahead == 'Y') ADVANCE(57);
      END_STATE();
    case 16:
      if (lookahead == '_') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      END_STATE();
    case 17:
      if (lookahead == '_') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      END_STATE();
    case 18:
      if (lookahead == '_') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      END_STATE();
    case 19:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      END_STATE();
    case 20:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(30);
      END_STATE();
    case 21:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(29);
      END_STATE();
    case 22:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(26);
      END_STATE();
    case 23:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      END_STATE();
    case 24:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(22);
      END_STATE();
    case 25:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(20);
      END_STATE();
    case 26:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(115);
      END_STATE();
    case 27:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(21);
      END_STATE();
    case 28:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(119);
      END_STATE();
    case 29:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(121);
      END_STATE();
    case 30:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(28);
      END_STATE();
    case 31:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(23);
      END_STATE();
    case 32:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(31);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      END_STATE();
    case 35:
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 36:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(109);
      if (lookahead == '%') ADVANCE(99);
      if (lookahead == '&') ADVANCE(61);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(50);
      if (lookahead == ')') ADVANCE(51);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(48);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == ';') ADVANCE(59);
      if (lookahead == '<') ADVANCE(79);
      if (lookahead == '=') ADVANCE(14);
      if (lookahead == '>') ADVANCE(76);
      if (lookahead == '?') ADVANCE(107);
      if (lookahead == '@') ADVANCE(118);
      if (lookahead == '[') ADVANCE(46);
      if (lookahead == ']') ADVANCE(47);
      if (lookahead == '^') ADVANCE(97);
      if (lookahead == '{') ADVANCE(113);
      if (lookahead == '|') ADVANCE(96);
      if (lookahead == '}') ADVANCE(114);
      if (lookahead == '~') ADVANCE(110);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(132);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(36)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(143);
      END_STATE();
    case 37:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(108);
      if (lookahead == '&') ADVANCE(60);
      if (lookahead == '\'') ADVANCE(6);
      if (lookahead == '(') ADVANCE(50);
      if (lookahead == ')') ADVANCE(51);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(48);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(33);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ';') ADVANCE(59);
      if (lookahead == '<') ADVANCE(77);
      if (lookahead == '>') ADVANCE(74);
      if (lookahead == '@') ADVANCE(118);
      if (lookahead == '[') ADVANCE(46);
      if (lookahead == '{') ADVANCE(113);
      if (lookahead == '}') ADVANCE(114);
      if (lookahead == '~') ADVANCE(110);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(132);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(37)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(143);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(44);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(39);
      if (lookahead == '_') ADVANCE(16);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(19);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(17);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(18);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_string_literal);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(82);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(aux_sym_group_by_clause_token2);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(aux_sym_group_by_clause_token2);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(84);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(84);
      if (lookahead == '=') ADVANCE(67);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(103);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(104);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(102);
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(101);
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(83);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(111);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(111);
      if (lookahead == '=') ADVANCE(63);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(112);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(112);
      if (lookahead == '=') ADVANCE(64);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(65);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(144);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == '=') ADVANCE(66);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '|') ADVANCE(85);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(85);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(69);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(70);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(71);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(72);
      if (lookahead == '>') ADVANCE(106);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(105);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(73);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(54);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(aux_sym_switch_block_statement_group_token1);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym_switch_block_statement_group_token1);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_default_switch_statement_group_token1);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_class_declaration_token1);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym_class_declaration_token1);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_extends_interfaces_token1);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_extends_interfaces_token1);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'Y') ADVANCE(58);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(138);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(143);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(141);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(143);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(137);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(130);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(134);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(135);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(125);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(128);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(124);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(139);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(116);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(126);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(120);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(122);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(136);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(117);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(129);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(133);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(140);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_block_comment);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'A') ADVANCE(1);
      if (lookahead == 'C') ADVANCE(2);
      if (lookahead == 'D') ADVANCE(3);
      if (lookahead == 'E') ADVANCE(4);
      if (lookahead == 'F') ADVANCE(5);
      if (lookahead == 'G') ADVANCE(6);
      if (lookahead == 'I') ADVANCE(7);
      if (lookahead == 'N') ADVANCE(8);
      if (lookahead == 'O') ADVANCE(9);
      if (lookahead == 'S') ADVANCE(10);
      if (lookahead == 'T') ADVANCE(11);
      if (lookahead == 'W') ADVANCE(12);
      if (lookahead == 'a') ADVANCE(13);
      if (lookahead == 'c') ADVANCE(14);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(16);
      if (lookahead == 'f') ADVANCE(17);
      if (lookahead == 'g') ADVANCE(18);
      if (lookahead == 'i') ADVANCE(19);
      if (lookahead == 'm') ADVANCE(20);
      if (lookahead == 'n') ADVANCE(21);
      if (lookahead == 'o') ADVANCE(22);
      if (lookahead == 's') ADVANCE(23);
      if (lookahead == 't') ADVANCE(24);
      if (lookahead == 'w') ADVANCE(25);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(26);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(27);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(28);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(29);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(30);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(31);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(32);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'N') ADVANCE(33);
      if (lookahead == 'S') ADVANCE(34);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(35);
      END_STATE();
    case 2:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(36);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 3:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(38);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(39);
      END_STATE();
    case 4:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(40);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(41);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(42);
      END_STATE();
    case 5:
      if (lookahead == 'R') ADVANCE(43);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(44);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(45);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(46);
      END_STATE();
    case 6:
      if (lookahead == 'R') ADVANCE(47);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(48);
      END_STATE();
    case 7:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(49);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(50);
      END_STATE();
    case 8:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(51);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 9:
      if (lookahead == 'R') ADVANCE(53);
      if (lookahead == 'r') ADVANCE(54);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(55);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(56);
      END_STATE();
    case 10:
      if (lookahead == 'E') ADVANCE(57);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(58);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(59);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(60);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(61);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(62);
      END_STATE();
    case 11:
      if (lookahead == 'H') ADVANCE(63);
      if (lookahead == 'h') ADVANCE(64);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(65);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(66);
      END_STATE();
    case 12:
      if (lookahead == 'H') ADVANCE(67);
      if (lookahead == 'h') ADVANCE(68);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(69);
      END_STATE();
    case 13:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(35);
      END_STATE();
    case 14:
      if (lookahead == 'l') ADVANCE(70);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(36);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 15:
      if (lookahead == 'E') ADVANCE(38);
      if (lookahead == 'e') ADVANCE(71);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(39);
      END_STATE();
    case 16:
      if (lookahead == 'x') ADVANCE(72);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(40);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(41);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(42);
      END_STATE();
    case 17:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(44);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(45);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(46);
      END_STATE();
    case 18:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(48);
      END_STATE();
    case 19:
      if (lookahead == 'm') ADVANCE(73);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(49);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(50);
      END_STATE();
    case 20:
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(75);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(51);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 22:
      if (lookahead == 'p') ADVANCE(76);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(55);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(56);
      END_STATE();
    case 23:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(58);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(59);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(60);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(61);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(62);
      END_STATE();
    case 24:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(64);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(65);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(66);
      END_STATE();
    case 25:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(68);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(69);
      END_STATE();
    case 26:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(77);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(78);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(79);
      END_STATE();
    case 27:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(80);
      END_STATE();
    case 28:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(81);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(82);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(83);
      END_STATE();
    case 29:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(84);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(85);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(86);
      END_STATE();
    case 30:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(87);
      END_STATE();
    case 31:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(88);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(89);
      END_STATE();
    case 32:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(90);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(91);
      END_STATE();
    case 33:
      if (lookahead == 'D') ADVANCE(92);
      END_STATE();
    case 34:
      if (lookahead == 'C') ADVANCE(93);
      END_STATE();
    case 35:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(94);
      END_STATE();
    case 36:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(95);
      END_STATE();
    case 37:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(96);
      END_STATE();
    case 38:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(97);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(98);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(99);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(aux_sym_do_statement_token1);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(100);
      END_STATE();
    case 40:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(101);
      END_STATE();
    case 41:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(102);
      END_STATE();
    case 42:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(103);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(104);
      END_STATE();
    case 43:
      if (lookahead == 'O') ADVANCE(105);
      END_STATE();
    case 44:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(106);
      END_STATE();
    case 45:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(107);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(108);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(109);
      END_STATE();
    case 46:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(110);
      END_STATE();
    case 47:
      if (lookahead == 'O') ADVANCE(111);
      END_STATE();
    case 48:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(112);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(aux_sym_if_statement_token1);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(aux_sym_sosl_in_clause_token1);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(113);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(114);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(115);
      END_STATE();
    case 51:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(116);
      END_STATE();
    case 52:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(aux_sym_complex_field_expression_token1);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(118);
      END_STATE();
    case 54:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(118);
      END_STATE();
    case 55:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(119);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(aux_sym_switch_expression_token2);
      END_STATE();
    case 57:
      if (lookahead == 'L') ADVANCE(120);
      END_STATE();
    case 58:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(121);
      END_STATE();
    case 59:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(122);
      END_STATE();
    case 60:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(123);
      END_STATE();
    case 61:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(124);
      END_STATE();
    case 62:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(125);
      END_STATE();
    case 63:
      if (lookahead == 'E') ADVANCE(126);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(127);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 64:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(127);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 65:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(129);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(130);
      END_STATE();
    case 66:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(131);
      END_STATE();
    case 67:
      if (lookahead == 'E') ADVANCE(132);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(133);
      END_STATE();
    case 68:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(133);
      END_STATE();
    case 69:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(134);
      END_STATE();
    case 70:
      if (lookahead == 'a') ADVANCE(135);
      END_STATE();
    case 71:
      if (lookahead == 'f') ADVANCE(136);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(97);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(98);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(99);
      END_STATE();
    case 72:
      if (lookahead == 't') ADVANCE(137);
      END_STATE();
    case 73:
      if (lookahead == 'p') ADVANCE(138);
      END_STATE();
    case 74:
      if (lookahead == 'd') ADVANCE(139);
      END_STATE();
    case 75:
      if (lookahead == 'w') ADVANCE(140);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(141);
      END_STATE();
    case 77:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(142);
      END_STATE();
    case 78:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(143);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(aux_sym_order_by_clause_token2);
      END_STATE();
    case 80:
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(144);
      END_STATE();
    case 81:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(145);
      END_STATE();
    case 82:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(146);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(147);
      END_STATE();
    case 83:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 84:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(149);
      END_STATE();
    case 85:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(150);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(151);
      END_STATE();
    case 86:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(152);
      END_STATE();
    case 87:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(153);
      END_STATE();
    case 88:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(154);
      END_STATE();
    case 89:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(155);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(156);
      END_STATE();
    case 90:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(157);
      END_STATE();
    case 91:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(158);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym_complex_field_expression_token2);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_order_by_clause_token3);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym_sosl_in_clause_token2);
      END_STATE();
    case 95:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(159);
      END_STATE();
    case 96:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(160);
      END_STATE();
    case 97:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(161);
      END_STATE();
    case 98:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 99:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(163);
      END_STATE();
    case 100:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(164);
      END_STATE();
    case 101:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 102:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(166);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(aux_sym_typeof_clause_token2);
      END_STATE();
    case 104:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(167);
      END_STATE();
    case 105:
      if (lookahead == 'M') ADVANCE(168);
      END_STATE();
    case 106:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(169);
      END_STATE();
    case 107:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(170);
      END_STATE();
    case 108:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(171);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(172);
      END_STATE();
    case 109:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(173);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(aux_sym_for_statement_token1);
      END_STATE();
    case 111:
      if (lookahead == 'U') ADVANCE(174);
      END_STATE();
    case 112:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(175);
      END_STATE();
    case 113:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(176);
      END_STATE();
    case 114:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(177);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(178);
      END_STATE();
    case 115:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(179);
      END_STATE();
    case 116:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 117:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 118:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 119:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(183);
      END_STATE();
    case 120:
      if (lookahead == 'E') ADVANCE(184);
      END_STATE();
    case 121:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 122:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 123:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(187);
      END_STATE();
    case 124:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 125:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(189);
      END_STATE();
    case 126:
      if (lookahead == 'N') ADVANCE(190);
      END_STATE();
    case 127:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(191);
      END_STATE();
    case 128:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(192);
      END_STATE();
    case 129:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(193);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_try_statement_token1);
      END_STATE();
    case 131:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(194);
      END_STATE();
    case 132:
      if (lookahead == 'N') ADVANCE(195);
      if (lookahead == 'R') ADVANCE(196);
      END_STATE();
    case 133:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(197);
      END_STATE();
    case 134:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(198);
      END_STATE();
    case 135:
      if (lookahead == 's') ADVANCE(199);
      END_STATE();
    case 136:
      if (lookahead == 'a') ADVANCE(200);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(201);
      END_STATE();
    case 138:
      if (lookahead == 'l') ADVANCE(202);
      END_STATE();
    case 139:
      if (lookahead == 'u') ADVANCE(203);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(204);
      END_STATE();
    case 142:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(205);
      END_STATE();
    case 143:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(206);
      END_STATE();
    case 144:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(207);
      END_STATE();
    case 145:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(208);
      END_STATE();
    case 146:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(209);
      END_STATE();
    case 147:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(210);
      END_STATE();
    case 148:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(211);
      END_STATE();
    case 149:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(212);
      END_STATE();
    case 150:
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(213);
      END_STATE();
    case 151:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(214);
      END_STATE();
    case 152:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(215);
      END_STATE();
    case 153:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(216);
      END_STATE();
    case 154:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 155:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(218);
      END_STATE();
    case 156:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(219);
      END_STATE();
    case 157:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(220);
      END_STATE();
    case 158:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(221);
      END_STATE();
    case 159:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(222);
      END_STATE();
    case 160:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(223);
      END_STATE();
    case 161:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(224);
      END_STATE();
    case 162:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(225);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_order_by_clause_token4);
      END_STATE();
    case 164:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(226);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym_typeof_clause_else_branch_token1);
      END_STATE();
    case 166:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(227);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym_enum_declaration_token1);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym_from_clause_token1);
      END_STATE();
    case 169:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(228);
      END_STATE();
    case 170:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(229);
      END_STATE();
    case 171:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(230);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym_sosl_find_clause_token1);
      END_STATE();
    case 173:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(231);
      END_STATE();
    case 174:
      if (lookahead == 'P') ADVANCE(232);
      END_STATE();
    case 175:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(233);
      END_STATE();
    case 176:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(234);
      END_STATE();
    case 177:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(235);
      END_STATE();
    case 178:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(236);
      END_STATE();
    case 179:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(237);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(238);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(aux_sym_sosl_in_clause_token4);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_null_literal);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(239);
      END_STATE();
    case 182:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(240);
      END_STATE();
    case 183:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 184:
      if (lookahead == 'C') ADVANCE(242);
      END_STATE();
    case 185:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(243);
      END_STATE();
    case 186:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(244);
      END_STATE();
    case 187:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(245);
      END_STATE();
    case 188:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(246);
      END_STATE();
    case 189:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(247);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym_typeof_clause_branch_token2);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 192:
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(248);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 194:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(249);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym_typeof_clause_branch_token1);
      END_STATE();
    case 196:
      if (lookahead == 'E') ADVANCE(250);
      END_STATE();
    case 197:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(251);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(aux_sym_access_modifiers_token1);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(252);
      END_STATE();
    case 199:
      if (lookahead == 's') ADVANCE(253);
      END_STATE();
    case 200:
      if (lookahead == 'u') ADVANCE(254);
      END_STATE();
    case 201:
      if (lookahead == 'n') ADVANCE(255);
      END_STATE();
    case 202:
      if (lookahead == 'e') ADVANCE(256);
      END_STATE();
    case 203:
      if (lookahead == 'l') ADVANCE(257);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_open);
      END_STATE();
    case 205:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(258);
      END_STATE();
    case 206:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(259);
      END_STATE();
    case 207:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(260);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(aux_sym_order_by_clause_token7);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(aux_sym_field_expression_token1);
      END_STATE();
    case 210:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(261);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(aux_sym_integral_type_token2);
      END_STATE();
    case 212:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 213:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(263);
      END_STATE();
    case 214:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(264);
      END_STATE();
    case 215:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(265);
      END_STATE();
    case 216:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(266);
      END_STATE();
    case 217:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(267);
      END_STATE();
    case 218:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(268);
      END_STATE();
    case 219:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(269);
      END_STATE();
    case 220:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(270);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_void_type);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(aux_sym_catch_clause_token1);
      END_STATE();
    case 223:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(271);
      END_STATE();
    case 224:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(272);
      END_STATE();
    case 225:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 226:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(274);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(aux_sym_sosl_in_clause_token3);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 229:
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(275);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(aux_sym_modifiers_token7);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(276);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(aux_sym_order_by_clause_token6);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(aux_sym_group_by_clause_token1);
      END_STATE();
    case 233:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(277);
      END_STATE();
    case 234:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(278);
      END_STATE();
    case 235:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(279);
      END_STATE();
    case 236:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(280);
      END_STATE();
    case 237:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(281);
      END_STATE();
    case 238:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(282);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(aux_sym_order_by_clause_token5);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(aux_sym_order_by_clause_token1);
      END_STATE();
    case 241:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(283);
      END_STATE();
    case 242:
      if (lookahead == 'T') ADVANCE(284);
      END_STATE();
    case 243:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(285);
      END_STATE();
    case 244:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(286);
      END_STATE();
    case 245:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(287);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 247:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(288);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(aux_sym_throw_statement_token1);
      END_STATE();
    case 249:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(289);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(aux_sym_where_clause_token1);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(aux_sym_do_statement_token2);
      END_STATE();
    case 252:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(290);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 254:
      if (lookahead == 'l') ADVANCE(291);
      END_STATE();
    case 255:
      if (lookahead == 'd') ADVANCE(292);
      END_STATE();
    case 256:
      if (lookahead == 'm') ADVANCE(293);
      END_STATE();
    case 257:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 258:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(295);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(aux_sym_break_statement_token1);
      END_STATE();
    case 260:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(296);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(aux_sym_limit_clause_token1);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(aux_sym_sosl_in_clause_token5);
      END_STATE();
    case 263:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(297);
      END_STATE();
    case 264:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(298);
      END_STATE();
    case 265:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(299);
      END_STATE();
    case 266:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(300);
      END_STATE();
    case 267:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(301);
      END_STATE();
    case 268:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(302);
      END_STATE();
    case 269:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(303);
      END_STATE();
    case 270:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(304);
      END_STATE();
    case 271:
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(305);
      END_STATE();
    case 272:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(306);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(aux_sym_dml_delete_statement_token1);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(aux_sym_floating_point_type_token1);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(aux_sym_sosl_in_clause_token7);
      END_STATE();
    case 276:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(307);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(aux_sym_modifiers_token4);
      END_STATE();
    case 278:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(308);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(aux_sym_dml_insert_statement_token1);
      END_STATE();
    case 280:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(309);
      END_STATE();
    case 281:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(310);
      END_STATE();
    case 282:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(311);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(aux_sym_offset_clause_token1);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(aux_sym_select_clause_token1);
      END_STATE();
    case 285:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(312);
      END_STATE();
    case 286:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(313);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(aux_sym_modifiers_token6);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(aux_sym_switch_expression_token1);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(aux_sym_typeof_clause_token1);
      END_STATE();
    case 290:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(314);
      END_STATE();
    case 291:
      if (lookahead == 't') ADVANCE(315);
      END_STATE();
    case 292:
      if (lookahead == 's') ADVANCE(316);
      END_STATE();
    case 293:
      if (lookahead == 'e') ADVANCE(317);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 295:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(318);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(aux_sym_having_clause_token1);
      END_STATE();
    case 297:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(319);
      END_STATE();
    case 298:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(320);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(aux_sym_modifiers_token1);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(aux_sym_return_statement_token1);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(321);
      END_STATE();
    case 301:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(322);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(aux_sym_dml_update_statement_token1);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(aux_sym_dml_upsert_statement_token1);
      END_STATE();
    case 304:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(323);
      END_STATE();
    case 305:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(324);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(aux_sym_floating_point_type_token2);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(aux_sym_finally_clause_token1);
      END_STATE();
    case 308:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(325);
      END_STATE();
    case 309:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(326);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(aux_sym_integral_type_token1);
      END_STATE();
    case 311:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(327);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(aux_sym_access_modifiers_token4);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(aux_sym_sosl_in_clause_token6);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(aux_sym_access_modifiers_token2);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 317:
      if (lookahead == 'n') ADVANCE(328);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_boolean_type);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(aux_sym_modifiers_token3);
      END_STATE();
    case 320:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(329);
      END_STATE();
    case 321:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(330);
      END_STATE();
    case 322:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(331);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(aux_sym_modifiers_token5);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(aux_sym_continue_statement_token1);
      END_STATE();
    case 325:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(332);
      END_STATE();
    case 326:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(333);
      END_STATE();
    case 327:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(334);
      END_STATE();
    case 328:
      if (lookahead == 't') ADVANCE(335);
      END_STATE();
    case 329:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(336);
      END_STATE();
    case 330:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(337);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(aux_sym_dml_undelete_statemetn_token1);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(aux_sym_access_modifiers_token3);
      END_STATE();
    case 333:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(338);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(aux_sym_interface_declaration_token1);
      END_STATE();
    case 335:
      if (lookahead == 's') ADVANCE(339);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(aux_sym_modifiers_token2);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(aux_sym_sosl_returning_clause_token1);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(aux_sym_instanceof_expression_token1);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 37},
  [2] = {.lex_state = 37},
  [3] = {.lex_state = 37},
  [4] = {.lex_state = 37},
  [5] = {.lex_state = 37},
  [6] = {.lex_state = 37},
  [7] = {.lex_state = 37},
  [8] = {.lex_state = 37},
  [9] = {.lex_state = 37},
  [10] = {.lex_state = 37},
  [11] = {.lex_state = 37},
  [12] = {.lex_state = 37},
  [13] = {.lex_state = 37},
  [14] = {.lex_state = 37},
  [15] = {.lex_state = 37},
  [16] = {.lex_state = 37},
  [17] = {.lex_state = 37},
  [18] = {.lex_state = 37},
  [19] = {.lex_state = 37},
  [20] = {.lex_state = 37},
  [21] = {.lex_state = 37},
  [22] = {.lex_state = 37},
  [23] = {.lex_state = 37},
  [24] = {.lex_state = 37},
  [25] = {.lex_state = 37},
  [26] = {.lex_state = 37},
  [27] = {.lex_state = 37},
  [28] = {.lex_state = 37},
  [29] = {.lex_state = 37},
  [30] = {.lex_state = 37},
  [31] = {.lex_state = 37},
  [32] = {.lex_state = 37},
  [33] = {.lex_state = 37},
  [34] = {.lex_state = 37},
  [35] = {.lex_state = 37},
  [36] = {.lex_state = 37},
  [37] = {.lex_state = 37},
  [38] = {.lex_state = 37},
  [39] = {.lex_state = 37},
  [40] = {.lex_state = 37},
  [41] = {.lex_state = 37},
  [42] = {.lex_state = 37},
  [43] = {.lex_state = 37},
  [44] = {.lex_state = 37},
  [45] = {.lex_state = 37},
  [46] = {.lex_state = 37},
  [47] = {.lex_state = 37},
  [48] = {.lex_state = 37},
  [49] = {.lex_state = 37},
  [50] = {.lex_state = 37},
  [51] = {.lex_state = 37},
  [52] = {.lex_state = 37},
  [53] = {.lex_state = 37},
  [54] = {.lex_state = 37},
  [55] = {.lex_state = 37},
  [56] = {.lex_state = 37},
  [57] = {.lex_state = 37},
  [58] = {.lex_state = 37},
  [59] = {.lex_state = 37},
  [60] = {.lex_state = 37},
  [61] = {.lex_state = 37},
  [62] = {.lex_state = 37},
  [63] = {.lex_state = 37},
  [64] = {.lex_state = 37},
  [65] = {.lex_state = 37},
  [66] = {.lex_state = 37},
  [67] = {.lex_state = 37},
  [68] = {.lex_state = 37},
  [69] = {.lex_state = 37},
  [70] = {.lex_state = 37},
  [71] = {.lex_state = 37},
  [72] = {.lex_state = 37},
  [73] = {.lex_state = 36},
  [74] = {.lex_state = 36},
  [75] = {.lex_state = 1},
  [76] = {.lex_state = 1},
  [77] = {.lex_state = 37},
  [78] = {.lex_state = 37},
  [79] = {.lex_state = 1},
  [80] = {.lex_state = 1},
  [81] = {.lex_state = 1},
  [82] = {.lex_state = 37},
  [83] = {.lex_state = 37},
  [84] = {.lex_state = 37},
  [85] = {.lex_state = 37},
  [86] = {.lex_state = 37},
  [87] = {.lex_state = 37},
  [88] = {.lex_state = 37},
  [89] = {.lex_state = 37},
  [90] = {.lex_state = 37},
  [91] = {.lex_state = 37},
  [92] = {.lex_state = 37},
  [93] = {.lex_state = 37},
  [94] = {.lex_state = 37},
  [95] = {.lex_state = 37},
  [96] = {.lex_state = 37},
  [97] = {.lex_state = 37},
  [98] = {.lex_state = 37},
  [99] = {.lex_state = 37},
  [100] = {.lex_state = 37},
  [101] = {.lex_state = 37},
  [102] = {.lex_state = 37},
  [103] = {.lex_state = 37},
  [104] = {.lex_state = 37},
  [105] = {.lex_state = 37},
  [106] = {.lex_state = 1},
  [107] = {.lex_state = 37},
  [108] = {.lex_state = 37},
  [109] = {.lex_state = 37},
  [110] = {.lex_state = 37},
  [111] = {.lex_state = 37},
  [112] = {.lex_state = 37},
  [113] = {.lex_state = 37},
  [114] = {.lex_state = 37},
  [115] = {.lex_state = 37},
  [116] = {.lex_state = 37},
  [117] = {.lex_state = 37},
  [118] = {.lex_state = 37},
  [119] = {.lex_state = 37},
  [120] = {.lex_state = 37},
  [121] = {.lex_state = 37},
  [122] = {.lex_state = 37},
  [123] = {.lex_state = 1},
  [124] = {.lex_state = 37},
  [125] = {.lex_state = 37},
  [126] = {.lex_state = 37},
  [127] = {.lex_state = 37},
  [128] = {.lex_state = 37},
  [129] = {.lex_state = 37},
  [130] = {.lex_state = 37},
  [131] = {.lex_state = 37},
  [132] = {.lex_state = 1},
  [133] = {.lex_state = 1},
  [134] = {.lex_state = 1},
  [135] = {.lex_state = 1},
  [136] = {.lex_state = 1},
  [137] = {.lex_state = 37},
  [138] = {.lex_state = 37},
  [139] = {.lex_state = 37},
  [140] = {.lex_state = 37},
  [141] = {.lex_state = 37},
  [142] = {.lex_state = 37},
  [143] = {.lex_state = 37},
  [144] = {.lex_state = 37},
  [145] = {.lex_state = 37},
  [146] = {.lex_state = 37},
  [147] = {.lex_state = 37},
  [148] = {.lex_state = 37},
  [149] = {.lex_state = 37},
  [150] = {.lex_state = 37},
  [151] = {.lex_state = 37},
  [152] = {.lex_state = 37},
  [153] = {.lex_state = 37},
  [154] = {.lex_state = 37},
  [155] = {.lex_state = 37},
  [156] = {.lex_state = 37},
  [157] = {.lex_state = 37},
  [158] = {.lex_state = 37},
  [159] = {.lex_state = 37},
  [160] = {.lex_state = 37},
  [161] = {.lex_state = 37},
  [162] = {.lex_state = 37},
  [163] = {.lex_state = 37},
  [164] = {.lex_state = 37},
  [165] = {.lex_state = 37},
  [166] = {.lex_state = 37},
  [167] = {.lex_state = 37},
  [168] = {.lex_state = 37},
  [169] = {.lex_state = 37},
  [170] = {.lex_state = 37},
  [171] = {.lex_state = 37},
  [172] = {.lex_state = 37},
  [173] = {.lex_state = 37},
  [174] = {.lex_state = 37},
  [175] = {.lex_state = 37},
  [176] = {.lex_state = 37},
  [177] = {.lex_state = 37},
  [178] = {.lex_state = 37},
  [179] = {.lex_state = 37},
  [180] = {.lex_state = 37},
  [181] = {.lex_state = 37},
  [182] = {.lex_state = 37},
  [183] = {.lex_state = 37},
  [184] = {.lex_state = 37},
  [185] = {.lex_state = 37},
  [186] = {.lex_state = 37},
  [187] = {.lex_state = 37},
  [188] = {.lex_state = 37},
  [189] = {.lex_state = 37},
  [190] = {.lex_state = 37},
  [191] = {.lex_state = 37},
  [192] = {.lex_state = 37},
  [193] = {.lex_state = 3},
  [194] = {.lex_state = 37},
  [195] = {.lex_state = 37},
  [196] = {.lex_state = 37},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 3},
  [199] = {.lex_state = 3},
  [200] = {.lex_state = 37},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 37},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 3},
  [205] = {.lex_state = 3},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 3},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 2},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 1},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 1},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 1},
  [263] = {.lex_state = 1},
  [264] = {.lex_state = 1},
  [265] = {.lex_state = 1},
  [266] = {.lex_state = 1},
  [267] = {.lex_state = 1},
  [268] = {.lex_state = 1},
  [269] = {.lex_state = 1},
  [270] = {.lex_state = 1},
  [271] = {.lex_state = 1},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 1},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 1},
  [282] = {.lex_state = 1},
  [283] = {.lex_state = 1},
  [284] = {.lex_state = 1},
  [285] = {.lex_state = 1},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 1},
  [289] = {.lex_state = 1},
  [290] = {.lex_state = 3},
  [291] = {.lex_state = 37},
  [292] = {.lex_state = 37},
  [293] = {.lex_state = 37},
  [294] = {.lex_state = 37},
  [295] = {.lex_state = 37},
  [296] = {.lex_state = 37},
  [297] = {.lex_state = 37},
  [298] = {.lex_state = 4},
  [299] = {.lex_state = 4},
  [300] = {.lex_state = 4},
  [301] = {.lex_state = 4},
  [302] = {.lex_state = 37},
  [303] = {.lex_state = 4},
  [304] = {.lex_state = 37},
  [305] = {.lex_state = 4},
  [306] = {.lex_state = 4},
  [307] = {.lex_state = 4},
  [308] = {.lex_state = 4},
  [309] = {.lex_state = 4},
  [310] = {.lex_state = 37},
  [311] = {.lex_state = 3},
  [312] = {.lex_state = 4},
  [313] = {.lex_state = 4},
  [314] = {.lex_state = 3},
  [315] = {.lex_state = 4},
  [316] = {.lex_state = 4},
  [317] = {.lex_state = 4},
  [318] = {.lex_state = 4},
  [319] = {.lex_state = 4},
  [320] = {.lex_state = 4},
  [321] = {.lex_state = 4},
  [322] = {.lex_state = 4},
  [323] = {.lex_state = 4},
  [324] = {.lex_state = 4},
  [325] = {.lex_state = 4},
  [326] = {.lex_state = 4},
  [327] = {.lex_state = 4},
  [328] = {.lex_state = 4},
  [329] = {.lex_state = 4},
  [330] = {.lex_state = 4},
  [331] = {.lex_state = 4},
  [332] = {.lex_state = 4},
  [333] = {.lex_state = 4},
  [334] = {.lex_state = 4},
  [335] = {.lex_state = 4},
  [336] = {.lex_state = 4},
  [337] = {.lex_state = 4},
  [338] = {.lex_state = 4},
  [339] = {.lex_state = 4},
  [340] = {.lex_state = 4},
  [341] = {.lex_state = 4},
  [342] = {.lex_state = 4},
  [343] = {.lex_state = 4},
  [344] = {.lex_state = 4},
  [345] = {.lex_state = 4},
  [346] = {.lex_state = 4},
  [347] = {.lex_state = 4},
  [348] = {.lex_state = 4},
  [349] = {.lex_state = 3},
  [350] = {.lex_state = 4},
  [351] = {.lex_state = 4},
  [352] = {.lex_state = 4},
  [353] = {.lex_state = 4},
  [354] = {.lex_state = 3},
  [355] = {.lex_state = 4},
  [356] = {.lex_state = 4},
  [357] = {.lex_state = 4},
  [358] = {.lex_state = 4},
  [359] = {.lex_state = 4},
  [360] = {.lex_state = 4},
  [361] = {.lex_state = 4},
  [362] = {.lex_state = 4},
  [363] = {.lex_state = 4},
  [364] = {.lex_state = 4},
  [365] = {.lex_state = 4},
  [366] = {.lex_state = 4},
  [367] = {.lex_state = 4},
  [368] = {.lex_state = 4},
  [369] = {.lex_state = 4},
  [370] = {.lex_state = 4},
  [371] = {.lex_state = 4},
  [372] = {.lex_state = 4},
  [373] = {.lex_state = 4},
  [374] = {.lex_state = 4},
  [375] = {.lex_state = 4},
  [376] = {.lex_state = 4},
  [377] = {.lex_state = 4},
  [378] = {.lex_state = 3},
  [379] = {.lex_state = 4},
  [380] = {.lex_state = 4},
  [381] = {.lex_state = 1},
  [382] = {.lex_state = 1},
  [383] = {.lex_state = 1},
  [384] = {.lex_state = 4},
  [385] = {.lex_state = 4},
  [386] = {.lex_state = 4},
  [387] = {.lex_state = 4},
  [388] = {.lex_state = 4},
  [389] = {.lex_state = 4},
  [390] = {.lex_state = 4},
  [391] = {.lex_state = 4},
  [392] = {.lex_state = 4},
  [393] = {.lex_state = 4},
  [394] = {.lex_state = 4},
  [395] = {.lex_state = 4},
  [396] = {.lex_state = 4},
  [397] = {.lex_state = 4},
  [398] = {.lex_state = 4},
  [399] = {.lex_state = 4},
  [400] = {.lex_state = 4},
  [401] = {.lex_state = 4},
  [402] = {.lex_state = 1},
  [403] = {.lex_state = 4},
  [404] = {.lex_state = 4},
  [405] = {.lex_state = 1},
  [406] = {.lex_state = 7},
  [407] = {.lex_state = 1},
  [408] = {.lex_state = 4},
  [409] = {.lex_state = 1},
  [410] = {.lex_state = 4},
  [411] = {.lex_state = 4},
  [412] = {.lex_state = 1},
  [413] = {.lex_state = 4},
  [414] = {.lex_state = 4},
  [415] = {.lex_state = 4},
  [416] = {.lex_state = 4},
  [417] = {.lex_state = 4},
  [418] = {.lex_state = 4},
  [419] = {.lex_state = 4},
  [420] = {.lex_state = 4},
  [421] = {.lex_state = 4},
  [422] = {.lex_state = 4},
  [423] = {.lex_state = 4},
  [424] = {.lex_state = 4},
  [425] = {.lex_state = 4},
  [426] = {.lex_state = 4},
  [427] = {.lex_state = 4},
  [428] = {.lex_state = 4},
  [429] = {.lex_state = 1},
  [430] = {.lex_state = 4},
  [431] = {.lex_state = 1},
  [432] = {.lex_state = 4},
  [433] = {.lex_state = 4},
  [434] = {.lex_state = 7},
  [435] = {.lex_state = 4},
  [436] = {.lex_state = 4},
  [437] = {.lex_state = 4},
  [438] = {.lex_state = 4},
  [439] = {.lex_state = 4},
  [440] = {.lex_state = 4},
  [441] = {.lex_state = 4},
  [442] = {.lex_state = 4},
  [443] = {.lex_state = 37},
  [444] = {.lex_state = 4},
  [445] = {.lex_state = 37},
  [446] = {.lex_state = 4},
  [447] = {.lex_state = 4},
  [448] = {.lex_state = 4},
  [449] = {.lex_state = 4},
  [450] = {.lex_state = 4},
  [451] = {.lex_state = 4},
  [452] = {.lex_state = 4},
  [453] = {.lex_state = 4},
  [454] = {.lex_state = 4},
  [455] = {.lex_state = 4},
  [456] = {.lex_state = 4},
  [457] = {.lex_state = 37},
  [458] = {.lex_state = 4},
  [459] = {.lex_state = 4},
  [460] = {.lex_state = 4},
  [461] = {.lex_state = 37},
  [462] = {.lex_state = 4},
  [463] = {.lex_state = 4},
  [464] = {.lex_state = 4},
  [465] = {.lex_state = 37},
  [466] = {.lex_state = 4},
  [467] = {.lex_state = 4},
  [468] = {.lex_state = 4},
  [469] = {.lex_state = 4},
  [470] = {.lex_state = 4},
  [471] = {.lex_state = 4},
  [472] = {.lex_state = 4},
  [473] = {.lex_state = 4},
  [474] = {.lex_state = 37},
  [475] = {.lex_state = 37},
  [476] = {.lex_state = 4},
  [477] = {.lex_state = 37},
  [478] = {.lex_state = 37},
  [479] = {.lex_state = 4},
  [480] = {.lex_state = 4},
  [481] = {.lex_state = 4},
  [482] = {.lex_state = 4},
  [483] = {.lex_state = 4},
  [484] = {.lex_state = 4},
  [485] = {.lex_state = 37},
  [486] = {.lex_state = 37},
  [487] = {.lex_state = 4},
  [488] = {.lex_state = 37},
  [489] = {.lex_state = 37},
  [490] = {.lex_state = 37},
  [491] = {.lex_state = 37},
  [492] = {.lex_state = 4},
  [493] = {.lex_state = 37},
  [494] = {.lex_state = 37},
  [495] = {.lex_state = 37},
  [496] = {.lex_state = 3},
  [497] = {.lex_state = 37},
  [498] = {.lex_state = 37},
  [499] = {.lex_state = 3},
  [500] = {.lex_state = 37},
  [501] = {.lex_state = 37},
  [502] = {.lex_state = 3},
  [503] = {.lex_state = 3},
  [504] = {.lex_state = 1},
  [505] = {.lex_state = 37},
  [506] = {.lex_state = 1},
  [507] = {.lex_state = 1},
  [508] = {.lex_state = 5},
  [509] = {.lex_state = 5},
  [510] = {.lex_state = 5},
  [511] = {.lex_state = 1},
  [512] = {.lex_state = 1},
  [513] = {.lex_state = 37},
  [514] = {.lex_state = 1},
  [515] = {.lex_state = 1},
  [516] = {.lex_state = 1},
  [517] = {.lex_state = 1},
  [518] = {.lex_state = 1},
  [519] = {.lex_state = 1},
  [520] = {.lex_state = 1},
  [521] = {.lex_state = 1},
  [522] = {.lex_state = 3},
  [523] = {.lex_state = 1},
  [524] = {.lex_state = 1},
  [525] = {.lex_state = 1},
  [526] = {.lex_state = 1},
  [527] = {.lex_state = 1},
  [528] = {.lex_state = 1},
  [529] = {.lex_state = 1},
  [530] = {.lex_state = 1},
  [531] = {.lex_state = 3},
  [532] = {.lex_state = 1},
  [533] = {.lex_state = 1},
  [534] = {.lex_state = 5},
  [535] = {.lex_state = 5},
  [536] = {.lex_state = 1},
  [537] = {.lex_state = 1},
  [538] = {.lex_state = 1},
  [539] = {.lex_state = 5},
  [540] = {.lex_state = 1},
  [541] = {.lex_state = 1},
  [542] = {.lex_state = 1},
  [543] = {.lex_state = 5},
  [544] = {.lex_state = 5},
  [545] = {.lex_state = 5},
  [546] = {.lex_state = 5},
  [547] = {.lex_state = 5},
  [548] = {.lex_state = 1},
  [549] = {.lex_state = 5},
  [550] = {.lex_state = 5},
  [551] = {.lex_state = 5},
  [552] = {.lex_state = 1},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 5},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 5},
  [557] = {.lex_state = 1},
  [558] = {.lex_state = 1},
  [559] = {.lex_state = 1},
  [560] = {.lex_state = 1},
  [561] = {.lex_state = 1},
  [562] = {.lex_state = 5},
  [563] = {.lex_state = 1},
  [564] = {.lex_state = 1},
  [565] = {.lex_state = 5},
  [566] = {.lex_state = 1},
  [567] = {.lex_state = 1},
  [568] = {.lex_state = 1},
  [569] = {.lex_state = 1},
  [570] = {.lex_state = 5},
  [571] = {.lex_state = 1},
  [572] = {.lex_state = 1},
  [573] = {.lex_state = 1},
  [574] = {.lex_state = 1},
  [575] = {.lex_state = 1},
  [576] = {.lex_state = 1},
  [577] = {.lex_state = 3},
  [578] = {.lex_state = 3},
  [579] = {.lex_state = 3},
  [580] = {.lex_state = 3},
  [581] = {.lex_state = 3},
  [582] = {.lex_state = 1},
  [583] = {.lex_state = 1},
  [584] = {.lex_state = 3},
  [585] = {.lex_state = 3},
  [586] = {.lex_state = 3},
  [587] = {.lex_state = 3},
  [588] = {.lex_state = 3},
  [589] = {.lex_state = 3},
  [590] = {.lex_state = 1},
  [591] = {.lex_state = 1},
  [592] = {.lex_state = 1},
  [593] = {.lex_state = 1},
  [594] = {.lex_state = 1},
  [595] = {.lex_state = 1},
  [596] = {.lex_state = 3},
  [597] = {.lex_state = 1},
  [598] = {.lex_state = 1},
  [599] = {.lex_state = 1},
  [600] = {.lex_state = 1},
  [601] = {.lex_state = 1},
  [602] = {.lex_state = 1},
  [603] = {.lex_state = 1},
  [604] = {.lex_state = 1},
  [605] = {.lex_state = 1},
  [606] = {.lex_state = 1},
  [607] = {.lex_state = 1},
  [608] = {.lex_state = 3},
  [609] = {.lex_state = 1},
  [610] = {.lex_state = 3},
  [611] = {.lex_state = 1},
  [612] = {.lex_state = 1},
  [613] = {.lex_state = 1},
  [614] = {.lex_state = 1},
  [615] = {.lex_state = 3},
  [616] = {.lex_state = 1},
  [617] = {.lex_state = 3},
  [618] = {.lex_state = 3},
  [619] = {.lex_state = 3},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 3},
  [622] = {.lex_state = 3},
  [623] = {.lex_state = 1},
  [624] = {.lex_state = 3},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 1},
  [627] = {.lex_state = 3},
  [628] = {.lex_state = 1},
  [629] = {.lex_state = 1},
  [630] = {.lex_state = 1},
  [631] = {.lex_state = 1},
  [632] = {.lex_state = 1},
  [633] = {.lex_state = 1},
  [634] = {.lex_state = 1},
  [635] = {.lex_state = 1},
  [636] = {.lex_state = 1},
  [637] = {.lex_state = 1},
  [638] = {.lex_state = 1},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 1},
  [641] = {.lex_state = 1},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 1},
  [645] = {.lex_state = 1},
  [646] = {.lex_state = 3},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 1},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 1},
  [651] = {.lex_state = 1},
  [652] = {.lex_state = 1},
  [653] = {.lex_state = 1},
  [654] = {.lex_state = 1},
  [655] = {.lex_state = 1},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 1},
  [658] = {.lex_state = 1},
  [659] = {.lex_state = 1},
  [660] = {.lex_state = 1},
  [661] = {.lex_state = 1},
  [662] = {.lex_state = 11},
  [663] = {.lex_state = 1},
  [664] = {.lex_state = 11},
  [665] = {.lex_state = 11},
  [666] = {.lex_state = 12},
  [667] = {.lex_state = 1},
  [668] = {.lex_state = 11},
  [669] = {.lex_state = 1},
  [670] = {.lex_state = 1},
  [671] = {.lex_state = 1},
  [672] = {.lex_state = 3},
  [673] = {.lex_state = 1},
  [674] = {.lex_state = 1},
  [675] = {.lex_state = 1},
  [676] = {.lex_state = 1},
  [677] = {.lex_state = 1},
  [678] = {.lex_state = 1},
  [679] = {.lex_state = 12},
  [680] = {.lex_state = 1},
  [681] = {.lex_state = 1},
  [682] = {.lex_state = 1},
  [683] = {.lex_state = 1},
  [684] = {.lex_state = 1},
  [685] = {.lex_state = 3},
  [686] = {.lex_state = 1},
  [687] = {.lex_state = 1},
  [688] = {.lex_state = 1},
  [689] = {.lex_state = 1},
  [690] = {.lex_state = 1},
  [691] = {.lex_state = 1},
  [692] = {.lex_state = 1},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 3},
  [695] = {.lex_state = 11},
  [696] = {.lex_state = 1},
  [697] = {.lex_state = 1},
  [698] = {.lex_state = 1},
  [699] = {.lex_state = 1},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 3},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 1},
  [706] = {.lex_state = 1},
  [707] = {.lex_state = 3},
  [708] = {.lex_state = 1},
  [709] = {.lex_state = 3},
  [710] = {.lex_state = 3},
  [711] = {.lex_state = 1},
  [712] = {.lex_state = 1},
  [713] = {.lex_state = 1},
  [714] = {.lex_state = 1},
  [715] = {.lex_state = 3},
  [716] = {.lex_state = 1},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 1},
  [719] = {.lex_state = 3},
  [720] = {.lex_state = 3},
  [721] = {.lex_state = 1},
  [722] = {.lex_state = 1},
  [723] = {.lex_state = 1},
  [724] = {.lex_state = 1},
  [725] = {.lex_state = 3},
  [726] = {.lex_state = 1},
  [727] = {.lex_state = 1},
  [728] = {.lex_state = 1},
  [729] = {.lex_state = 1},
  [730] = {.lex_state = 1},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 11},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 1},
  [736] = {.lex_state = 1},
  [737] = {.lex_state = 1},
  [738] = {.lex_state = 1},
  [739] = {.lex_state = 1},
  [740] = {.lex_state = 1},
  [741] = {.lex_state = 37},
  [742] = {.lex_state = 1},
  [743] = {.lex_state = 37},
  [744] = {.lex_state = 1},
  [745] = {.lex_state = 3},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 1},
  [748] = {.lex_state = 1},
  [749] = {.lex_state = 1},
  [750] = {.lex_state = 1},
  [751] = {.lex_state = 11},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 1},
  [754] = {.lex_state = 37},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 1},
  [757] = {.lex_state = 1},
  [758] = {.lex_state = 1},
  [759] = {.lex_state = 1},
  [760] = {.lex_state = 1},
  [761] = {.lex_state = 1},
  [762] = {.lex_state = 1},
  [763] = {.lex_state = 1},
  [764] = {.lex_state = 1},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 3},
  [767] = {.lex_state = 1},
  [768] = {.lex_state = 1},
  [769] = {.lex_state = 1},
  [770] = {.lex_state = 1},
  [771] = {.lex_state = 1},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 37},
  [778] = {.lex_state = 3},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 3},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 3},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 1},
  [799] = {.lex_state = 1},
  [800] = {.lex_state = 1},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 1},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 0},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 37},
  [812] = {.lex_state = 3},
  [813] = {.lex_state = 1},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 1},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 1},
  [819] = {.lex_state = 1},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 37},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 37},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 3},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 3},
  [834] = {.lex_state = 1},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 1},
  [837] = {.lex_state = 1},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 3},
  [841] = {.lex_state = 37},
  [842] = {.lex_state = 37},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 3},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 37},
  [859] = {.lex_state = 37},
  [860] = {.lex_state = 37},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 1},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 1},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 37},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 37},
  [872] = {.lex_state = 37},
  [873] = {.lex_state = 1},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 11},
  [877] = {.lex_state = 1},
  [878] = {.lex_state = 11},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 1},
  [881] = {.lex_state = 1},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 1},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 11},
  [889] = {.lex_state = 1},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 1},
  [897] = {.lex_state = 37},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 37},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 1},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 1},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 1},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 1},
  [912] = {.lex_state = 1},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 37},
  [917] = {.lex_state = 37},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 37},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 11},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 1},
  [924] = {.lex_state = 1},
  [925] = {.lex_state = 1},
  [926] = {.lex_state = 1},
  [927] = {.lex_state = 1},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 1},
  [932] = {.lex_state = 1},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 1},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 1},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 1},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 11},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 1},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 1},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 37},
  [966] = {.lex_state = 1},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 1},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 1},
  [972] = {.lex_state = 1},
  [973] = {.lex_state = 1},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 1},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 1},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 1},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 3},
  [988] = {.lex_state = 1},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 1},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 1},
  [996] = {.lex_state = 1},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 1},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 11},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 1},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 11},
  [1021] = {.lex_state = 1},
  [1022] = {.lex_state = 1},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 1},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 11},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 1},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 1},
  [1037] = {.lex_state = 1},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 11},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 3},
  [1043] = {.lex_state = 1},
  [1044] = {.lex_state = 1},
  [1045] = {.lex_state = 1},
  [1046] = {.lex_state = 1},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 1},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 1},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_decimal_integer_literal] = ACTIONS(1),
    [sym_decimal_floating_point_literal] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_string_literal] = ACTIONS(1),
    [sym_null_literal] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [aux_sym_sosl_find_clause_token1] = ACTIONS(1),
    [aux_sym_sosl_in_clause_token1] = ACTIONS(1),
    [aux_sym_sosl_in_clause_token2] = ACTIONS(1),
    [aux_sym_sosl_in_clause_token3] = ACTIONS(1),
    [aux_sym_sosl_in_clause_token4] = ACTIONS(1),
    [aux_sym_sosl_in_clause_token5] = ACTIONS(1),
    [aux_sym_sosl_in_clause_token6] = ACTIONS(1),
    [aux_sym_sosl_in_clause_token7] = ACTIONS(1),
    [aux_sym_sosl_returning_clause_token1] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [aux_sym_select_clause_token1] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [aux_sym_from_clause_token1] = ACTIONS(1),
    [aux_sym_where_clause_token1] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [aux_sym_field_expression_token1] = ACTIONS(1),
    [aux_sym_complex_field_expression_token1] = ACTIONS(1),
    [aux_sym_complex_field_expression_token2] = ACTIONS(1),
    [aux_sym_typeof_clause_token1] = ACTIONS(1),
    [aux_sym_typeof_clause_token2] = ACTIONS(1),
    [aux_sym_typeof_clause_else_branch_token1] = ACTIONS(1),
    [aux_sym_typeof_clause_branch_token1] = ACTIONS(1),
    [aux_sym_typeof_clause_branch_token2] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [aux_sym_order_by_clause_token1] = ACTIONS(1),
    [aux_sym_order_by_clause_token2] = ACTIONS(1),
    [aux_sym_order_by_clause_token3] = ACTIONS(1),
    [aux_sym_order_by_clause_token4] = ACTIONS(1),
    [aux_sym_order_by_clause_token5] = ACTIONS(1),
    [aux_sym_order_by_clause_token6] = ACTIONS(1),
    [aux_sym_order_by_clause_token7] = ACTIONS(1),
    [aux_sym_limit_clause_token1] = ACTIONS(1),
    [aux_sym_offset_clause_token1] = ACTIONS(1),
    [aux_sym_group_by_clause_token1] = ACTIONS(1),
    [aux_sym_group_by_clause_token2] = ACTIONS(1),
    [aux_sym_having_clause_token1] = ACTIONS(1),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [aux_sym_dml_update_statement_token1] = ACTIONS(1),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(1),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(1),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [aux_sym_instanceof_expression_token1] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [aux_sym_switch_expression_token1] = ACTIONS(1),
    [aux_sym_switch_expression_token2] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [aux_sym_switch_block_statement_group_token1] = ACTIONS(1),
    [aux_sym_default_switch_statement_group_token1] = ACTIONS(1),
    [aux_sym_do_statement_token1] = ACTIONS(1),
    [aux_sym_do_statement_token2] = ACTIONS(1),
    [aux_sym_break_statement_token1] = ACTIONS(1),
    [aux_sym_continue_statement_token1] = ACTIONS(1),
    [aux_sym_return_statement_token1] = ACTIONS(1),
    [aux_sym_throw_statement_token1] = ACTIONS(1),
    [aux_sym_try_statement_token1] = ACTIONS(1),
    [aux_sym_catch_clause_token1] = ACTIONS(1),
    [aux_sym_finally_clause_token1] = ACTIONS(1),
    [aux_sym_if_statement_token1] = ACTIONS(1),
    [aux_sym_for_statement_token1] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [aux_sym_enum_declaration_token1] = ACTIONS(1),
    [aux_sym_class_declaration_token1] = ACTIONS(1),
    [aux_sym_access_modifiers_token1] = ACTIONS(1),
    [aux_sym_access_modifiers_token2] = ACTIONS(1),
    [aux_sym_access_modifiers_token3] = ACTIONS(1),
    [aux_sym_access_modifiers_token4] = ACTIONS(1),
    [aux_sym_modifiers_token1] = ACTIONS(1),
    [aux_sym_modifiers_token2] = ACTIONS(1),
    [aux_sym_modifiers_token3] = ACTIONS(1),
    [aux_sym_modifiers_token4] = ACTIONS(1),
    [aux_sym_modifiers_token5] = ACTIONS(1),
    [aux_sym_modifiers_token6] = ACTIONS(1),
    [aux_sym_modifiers_token7] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [aux_sym_interface_declaration_token1] = ACTIONS(1),
    [aux_sym_extends_interfaces_token1] = ACTIONS(1),
    [aux_sym_integral_type_token1] = ACTIONS(1),
    [aux_sym_integral_type_token2] = ACTIONS(1),
    [aux_sym_floating_point_type_token1] = ACTIONS(1),
    [aux_sym_floating_point_type_token2] = ACTIONS(1),
    [sym_boolean_type] = ACTIONS(1),
    [sym_void_type] = ACTIONS(1),
    [anon_sym_open] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_program] = STATE(1041),
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(11),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(433),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_type_arguments] = STATE(943),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(8),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_explicit_constructor_invocation] = STATE(7),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_program_repeat1] = STATE(8),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_LT] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(83),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(85),
    [sym_super] = ACTIONS(87),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(3),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_program_repeat1] = STATE(3),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [ts_builtin_sym_end] = ACTIONS(89),
    [sym_identifier] = ACTIONS(91),
    [sym_decimal_integer_literal] = ACTIONS(94),
    [sym_decimal_floating_point_literal] = ACTIONS(97),
    [sym_true] = ACTIONS(94),
    [sym_false] = ACTIONS(94),
    [sym_string_literal] = ACTIONS(97),
    [sym_null_literal] = ACTIONS(94),
    [anon_sym_LBRACK] = ACTIONS(100),
    [anon_sym_LPAREN] = ACTIONS(103),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(106),
    [aux_sym_dml_update_statement_token1] = ACTIONS(109),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(112),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(115),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(118),
    [anon_sym_PLUS] = ACTIONS(121),
    [anon_sym_DASH] = ACTIONS(121),
    [anon_sym_BANG] = ACTIONS(124),
    [anon_sym_TILDE] = ACTIONS(124),
    [anon_sym_PLUS_PLUS] = ACTIONS(127),
    [anon_sym_DASH_DASH] = ACTIONS(127),
    [anon_sym_new] = ACTIONS(130),
    [aux_sym_switch_expression_token1] = ACTIONS(133),
    [anon_sym_LBRACE] = ACTIONS(136),
    [anon_sym_RBRACE] = ACTIONS(89),
    [aux_sym_do_statement_token1] = ACTIONS(139),
    [aux_sym_do_statement_token2] = ACTIONS(142),
    [aux_sym_break_statement_token1] = ACTIONS(145),
    [aux_sym_continue_statement_token1] = ACTIONS(148),
    [aux_sym_return_statement_token1] = ACTIONS(151),
    [aux_sym_throw_statement_token1] = ACTIONS(154),
    [aux_sym_try_statement_token1] = ACTIONS(157),
    [aux_sym_if_statement_token1] = ACTIONS(160),
    [aux_sym_for_statement_token1] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(166),
    [aux_sym_enum_declaration_token1] = ACTIONS(169),
    [aux_sym_class_declaration_token1] = ACTIONS(172),
    [aux_sym_access_modifiers_token1] = ACTIONS(175),
    [aux_sym_access_modifiers_token2] = ACTIONS(175),
    [aux_sym_access_modifiers_token3] = ACTIONS(175),
    [aux_sym_modifiers_token1] = ACTIONS(178),
    [aux_sym_modifiers_token2] = ACTIONS(178),
    [aux_sym_modifiers_token3] = ACTIONS(178),
    [aux_sym_modifiers_token4] = ACTIONS(178),
    [aux_sym_modifiers_token5] = ACTIONS(178),
    [aux_sym_modifiers_token6] = ACTIONS(178),
    [aux_sym_modifiers_token7] = ACTIONS(178),
    [aux_sym_interface_declaration_token1] = ACTIONS(181),
    [aux_sym_integral_type_token1] = ACTIONS(184),
    [aux_sym_integral_type_token2] = ACTIONS(184),
    [aux_sym_floating_point_type_token1] = ACTIONS(187),
    [aux_sym_floating_point_type_token2] = ACTIONS(187),
    [sym_boolean_type] = ACTIONS(190),
    [sym_void_type] = ACTIONS(190),
    [anon_sym_open] = ACTIONS(193),
    [anon_sym_module] = ACTIONS(193),
    [sym_this] = ACTIONS(196),
    [sym_super] = ACTIONS(199),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(5),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_program_repeat1] = STATE(5),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(202),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(3),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_program_repeat1] = STATE(3),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(204),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(9),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(206),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(13),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(208),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(3),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_program_repeat1] = STATE(3),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(208),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(3),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_program_repeat1] = STATE(3),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(210),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(12),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(212),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(3),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_program_repeat1] = STATE(3),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [ts_builtin_sym_end] = ACTIONS(214),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(3),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_program_repeat1] = STATE(3),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(216),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(3),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_program_repeat1] = STATE(3),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(218),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(192),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(173),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(1030),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(912),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(137),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(146),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(150),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [21] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(153),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(166),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(155),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(189),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(167),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(151),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(155),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(142),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [29] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(147),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(145),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(142),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(187),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(144),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(143),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(180),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(162),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(156),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(141),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(184),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(150),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(190),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(183),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(170),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(168),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [45] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(166),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [46] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(181),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [47] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(156),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [48] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(149),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [49] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(162),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [50] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(149),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [51] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(192),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [52] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(180),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [53] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(146),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [54] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(143),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [55] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(144),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(171),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [57] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(145),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(141),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [59] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(170),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(167),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [61] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(147),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [62] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(171),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [63] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(184),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [64] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(173),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [65] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(151),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [66] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(190),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [67] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(183),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [68] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(187),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [69] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(181),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(220),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(222),
    [aux_sym_if_statement_token1] = ACTIONS(224),
    [aux_sym_for_statement_token1] = ACTIONS(226),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [70] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(137),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [71] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(153),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [72] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(479),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_dml_statement] = STATE(178),
    [sym_dml_insert_statement] = STATE(176),
    [sym_dml_update_statement] = STATE(176),
    [sym_dml_upsert_statement] = STATE(176),
    [sym_dml_delete_statement] = STATE(176),
    [sym_dml_undelete_statemetn] = STATE(176),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym_switch_expression] = STATE(178),
    [sym_statement] = STATE(168),
    [sym_block] = STATE(178),
    [sym_expression_statement] = STATE(178),
    [sym_do_statement] = STATE(178),
    [sym_break_statement] = STATE(178),
    [sym_continue_statement] = STATE(178),
    [sym_return_statement] = STATE(178),
    [sym_throw_statement] = STATE(178),
    [sym_try_statement] = STATE(178),
    [sym_if_statement] = STATE(178),
    [sym_while_statement] = STATE(178),
    [sym_for_statement] = STATE(178),
    [sym_enhanced_for_statement] = STATE(178),
    [sym__annotation] = STATE(445),
    [sym_marker_annotation] = STATE(445),
    [sym_annotation] = STATE(445),
    [sym_declaration] = STATE(178),
    [sym_enum_declaration] = STATE(163),
    [sym_class_declaration] = STATE(163),
    [sym_access_modifiers] = STATE(1040),
    [sym_modifiers] = STATE(513),
    [sym_interface_declaration] = STATE(163),
    [sym__unannotated_type] = STATE(588),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(178),
    [aux_sym_modifiers_repeat1] = STATE(445),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(17),
    [aux_sym_dml_update_statement_token1] = ACTIONS(19),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(21),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(23),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [aux_sym_switch_expression_token1] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [aux_sym_do_statement_token1] = ACTIONS(39),
    [aux_sym_do_statement_token2] = ACTIONS(41),
    [aux_sym_break_statement_token1] = ACTIONS(43),
    [aux_sym_continue_statement_token1] = ACTIONS(45),
    [aux_sym_return_statement_token1] = ACTIONS(47),
    [aux_sym_throw_statement_token1] = ACTIONS(49),
    [aux_sym_try_statement_token1] = ACTIONS(51),
    [aux_sym_if_statement_token1] = ACTIONS(53),
    [aux_sym_for_statement_token1] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [aux_sym_enum_declaration_token1] = ACTIONS(59),
    [aux_sym_class_declaration_token1] = ACTIONS(61),
    [aux_sym_access_modifiers_token1] = ACTIONS(63),
    [aux_sym_access_modifiers_token2] = ACTIONS(63),
    [aux_sym_access_modifiers_token3] = ACTIONS(63),
    [aux_sym_modifiers_token1] = ACTIONS(65),
    [aux_sym_modifiers_token2] = ACTIONS(65),
    [aux_sym_modifiers_token3] = ACTIONS(65),
    [aux_sym_modifiers_token4] = ACTIONS(65),
    [aux_sym_modifiers_token5] = ACTIONS(65),
    [aux_sym_modifiers_token6] = ACTIONS(65),
    [aux_sym_modifiers_token7] = ACTIONS(65),
    [aux_sym_interface_declaration_token1] = ACTIONS(67),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [73] = {
    [ts_builtin_sym_end] = ACTIONS(228),
    [sym_identifier] = ACTIONS(230),
    [sym_decimal_integer_literal] = ACTIONS(230),
    [sym_decimal_floating_point_literal] = ACTIONS(228),
    [sym_true] = ACTIONS(230),
    [sym_false] = ACTIONS(230),
    [sym_string_literal] = ACTIONS(228),
    [sym_null_literal] = ACTIONS(230),
    [anon_sym_LBRACK] = ACTIONS(228),
    [anon_sym_RBRACK] = ACTIONS(228),
    [anon_sym_COMMA] = ACTIONS(228),
    [anon_sym_COLON] = ACTIONS(228),
    [anon_sym_LPAREN] = ACTIONS(228),
    [anon_sym_RPAREN] = ACTIONS(228),
    [anon_sym_BANG_EQ] = ACTIONS(228),
    [aux_sym_complex_field_expression_token1] = ACTIONS(230),
    [aux_sym_complex_field_expression_token2] = ACTIONS(230),
    [aux_sym_typeof_clause_else_branch_token1] = ACTIONS(230),
    [anon_sym_DOT] = ACTIONS(230),
    [aux_sym_order_by_clause_token1] = ACTIONS(230),
    [aux_sym_limit_clause_token1] = ACTIONS(230),
    [aux_sym_offset_clause_token1] = ACTIONS(230),
    [aux_sym_group_by_clause_token1] = ACTIONS(230),
    [aux_sym_having_clause_token1] = ACTIONS(230),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(230),
    [anon_sym_SEMI] = ACTIONS(228),
    [aux_sym_dml_update_statement_token1] = ACTIONS(230),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(230),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(230),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(230),
    [anon_sym_AMP] = ACTIONS(230),
    [anon_sym_GT] = ACTIONS(230),
    [anon_sym_LT] = ACTIONS(230),
    [anon_sym_GT_EQ] = ACTIONS(228),
    [anon_sym_LT_EQ] = ACTIONS(228),
    [anon_sym_EQ_EQ] = ACTIONS(230),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(228),
    [anon_sym_AMP_AMP] = ACTIONS(228),
    [anon_sym_PIPE_PIPE] = ACTIONS(228),
    [anon_sym_PLUS] = ACTIONS(230),
    [anon_sym_DASH] = ACTIONS(230),
    [anon_sym_STAR] = ACTIONS(228),
    [anon_sym_SLASH] = ACTIONS(230),
    [anon_sym_PIPE] = ACTIONS(230),
    [anon_sym_CARET] = ACTIONS(228),
    [anon_sym_PERCENT] = ACTIONS(228),
    [anon_sym_LT_LT] = ACTIONS(228),
    [anon_sym_GT_GT] = ACTIONS(230),
    [anon_sym_GT_GT_GT] = ACTIONS(228),
    [aux_sym_instanceof_expression_token1] = ACTIONS(230),
    [anon_sym_QMARK] = ACTIONS(228),
    [anon_sym_BANG] = ACTIONS(230),
    [anon_sym_TILDE] = ACTIONS(228),
    [anon_sym_PLUS_PLUS] = ACTIONS(228),
    [anon_sym_DASH_DASH] = ACTIONS(228),
    [anon_sym_new] = ACTIONS(230),
    [aux_sym_switch_expression_token1] = ACTIONS(230),
    [anon_sym_LBRACE] = ACTIONS(228),
    [anon_sym_RBRACE] = ACTIONS(228),
    [aux_sym_do_statement_token1] = ACTIONS(230),
    [aux_sym_do_statement_token2] = ACTIONS(230),
    [aux_sym_break_statement_token1] = ACTIONS(230),
    [aux_sym_continue_statement_token1] = ACTIONS(230),
    [aux_sym_return_statement_token1] = ACTIONS(230),
    [aux_sym_throw_statement_token1] = ACTIONS(230),
    [aux_sym_try_statement_token1] = ACTIONS(230),
    [aux_sym_if_statement_token1] = ACTIONS(230),
    [aux_sym_for_statement_token1] = ACTIONS(230),
    [anon_sym_AT] = ACTIONS(228),
    [aux_sym_enum_declaration_token1] = ACTIONS(230),
    [aux_sym_class_declaration_token1] = ACTIONS(230),
    [aux_sym_access_modifiers_token1] = ACTIONS(230),
    [aux_sym_access_modifiers_token2] = ACTIONS(230),
    [aux_sym_access_modifiers_token3] = ACTIONS(230),
    [aux_sym_modifiers_token1] = ACTIONS(230),
    [aux_sym_modifiers_token2] = ACTIONS(230),
    [aux_sym_modifiers_token3] = ACTIONS(230),
    [aux_sym_modifiers_token4] = ACTIONS(230),
    [aux_sym_modifiers_token5] = ACTIONS(230),
    [aux_sym_modifiers_token6] = ACTIONS(230),
    [aux_sym_modifiers_token7] = ACTIONS(230),
    [aux_sym_interface_declaration_token1] = ACTIONS(230),
    [aux_sym_integral_type_token1] = ACTIONS(230),
    [aux_sym_integral_type_token2] = ACTIONS(230),
    [aux_sym_floating_point_type_token1] = ACTIONS(230),
    [aux_sym_floating_point_type_token2] = ACTIONS(230),
    [sym_boolean_type] = ACTIONS(230),
    [sym_void_type] = ACTIONS(230),
    [anon_sym_open] = ACTIONS(230),
    [anon_sym_module] = ACTIONS(230),
    [sym_this] = ACTIONS(230),
    [sym_super] = ACTIONS(230),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [74] = {
    [ts_builtin_sym_end] = ACTIONS(232),
    [sym_identifier] = ACTIONS(234),
    [sym_decimal_integer_literal] = ACTIONS(234),
    [sym_decimal_floating_point_literal] = ACTIONS(232),
    [sym_true] = ACTIONS(234),
    [sym_false] = ACTIONS(234),
    [sym_string_literal] = ACTIONS(232),
    [sym_null_literal] = ACTIONS(234),
    [anon_sym_LBRACK] = ACTIONS(232),
    [anon_sym_RBRACK] = ACTIONS(232),
    [anon_sym_COMMA] = ACTIONS(232),
    [anon_sym_COLON] = ACTIONS(232),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(232),
    [anon_sym_BANG_EQ] = ACTIONS(232),
    [aux_sym_complex_field_expression_token1] = ACTIONS(234),
    [aux_sym_complex_field_expression_token2] = ACTIONS(234),
    [aux_sym_typeof_clause_else_branch_token1] = ACTIONS(234),
    [anon_sym_DOT] = ACTIONS(234),
    [aux_sym_order_by_clause_token1] = ACTIONS(234),
    [aux_sym_limit_clause_token1] = ACTIONS(234),
    [aux_sym_offset_clause_token1] = ACTIONS(234),
    [aux_sym_group_by_clause_token1] = ACTIONS(234),
    [aux_sym_having_clause_token1] = ACTIONS(234),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(234),
    [anon_sym_SEMI] = ACTIONS(232),
    [aux_sym_dml_update_statement_token1] = ACTIONS(234),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(234),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(234),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(234),
    [anon_sym_AMP] = ACTIONS(234),
    [anon_sym_GT] = ACTIONS(234),
    [anon_sym_LT] = ACTIONS(234),
    [anon_sym_GT_EQ] = ACTIONS(232),
    [anon_sym_LT_EQ] = ACTIONS(232),
    [anon_sym_EQ_EQ] = ACTIONS(234),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(232),
    [anon_sym_AMP_AMP] = ACTIONS(232),
    [anon_sym_PIPE_PIPE] = ACTIONS(232),
    [anon_sym_PLUS] = ACTIONS(234),
    [anon_sym_DASH] = ACTIONS(234),
    [anon_sym_STAR] = ACTIONS(232),
    [anon_sym_SLASH] = ACTIONS(234),
    [anon_sym_PIPE] = ACTIONS(234),
    [anon_sym_CARET] = ACTIONS(232),
    [anon_sym_PERCENT] = ACTIONS(232),
    [anon_sym_LT_LT] = ACTIONS(232),
    [anon_sym_GT_GT] = ACTIONS(234),
    [anon_sym_GT_GT_GT] = ACTIONS(232),
    [aux_sym_instanceof_expression_token1] = ACTIONS(234),
    [anon_sym_QMARK] = ACTIONS(232),
    [anon_sym_BANG] = ACTIONS(234),
    [anon_sym_TILDE] = ACTIONS(232),
    [anon_sym_PLUS_PLUS] = ACTIONS(232),
    [anon_sym_DASH_DASH] = ACTIONS(232),
    [anon_sym_new] = ACTIONS(234),
    [aux_sym_switch_expression_token1] = ACTIONS(234),
    [anon_sym_LBRACE] = ACTIONS(232),
    [anon_sym_RBRACE] = ACTIONS(232),
    [aux_sym_do_statement_token1] = ACTIONS(234),
    [aux_sym_do_statement_token2] = ACTIONS(234),
    [aux_sym_break_statement_token1] = ACTIONS(234),
    [aux_sym_continue_statement_token1] = ACTIONS(234),
    [aux_sym_return_statement_token1] = ACTIONS(234),
    [aux_sym_throw_statement_token1] = ACTIONS(234),
    [aux_sym_try_statement_token1] = ACTIONS(234),
    [aux_sym_if_statement_token1] = ACTIONS(234),
    [aux_sym_for_statement_token1] = ACTIONS(234),
    [anon_sym_AT] = ACTIONS(232),
    [aux_sym_enum_declaration_token1] = ACTIONS(234),
    [aux_sym_class_declaration_token1] = ACTIONS(234),
    [aux_sym_access_modifiers_token1] = ACTIONS(234),
    [aux_sym_access_modifiers_token2] = ACTIONS(234),
    [aux_sym_access_modifiers_token3] = ACTIONS(234),
    [aux_sym_modifiers_token1] = ACTIONS(234),
    [aux_sym_modifiers_token2] = ACTIONS(234),
    [aux_sym_modifiers_token3] = ACTIONS(234),
    [aux_sym_modifiers_token4] = ACTIONS(234),
    [aux_sym_modifiers_token5] = ACTIONS(234),
    [aux_sym_modifiers_token6] = ACTIONS(234),
    [aux_sym_modifiers_token7] = ACTIONS(234),
    [aux_sym_interface_declaration_token1] = ACTIONS(234),
    [aux_sym_integral_type_token1] = ACTIONS(234),
    [aux_sym_integral_type_token2] = ACTIONS(234),
    [aux_sym_floating_point_type_token1] = ACTIONS(234),
    [aux_sym_floating_point_type_token2] = ACTIONS(234),
    [sym_boolean_type] = ACTIONS(234),
    [sym_void_type] = ACTIONS(234),
    [anon_sym_open] = ACTIONS(234),
    [anon_sym_module] = ACTIONS(234),
    [sym_this] = ACTIONS(234),
    [sym_super] = ACTIONS(234),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [75] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(423),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym__annotation] = STATE(523),
    [sym_marker_annotation] = STATE(523),
    [sym_annotation] = STATE(523),
    [sym_modifiers] = STATE(568),
    [sym__unannotated_type] = STATE(589),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(215),
    [aux_sym_modifiers_repeat1] = STATE(523),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_SEMI] = ACTIONS(236),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(238),
    [aux_sym_modifiers_token1] = ACTIONS(240),
    [aux_sym_modifiers_token2] = ACTIONS(240),
    [aux_sym_modifiers_token3] = ACTIONS(240),
    [aux_sym_modifiers_token4] = ACTIONS(240),
    [aux_sym_modifiers_token5] = ACTIONS(240),
    [aux_sym_modifiers_token6] = ACTIONS(240),
    [aux_sym_modifiers_token7] = ACTIONS(240),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [76] = {
    [sym__literal] = STATE(325),
    [sym_expression] = STATE(411),
    [sym_database_query] = STATE(325),
    [sym_sosl_query] = STATE(316),
    [sym_soql_query] = STATE(316),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_primary_expression] = STATE(375),
    [sym_array_creation_expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(325),
    [sym_class_literal] = STATE(325),
    [sym_object_creation_expression] = STATE(325),
    [sym__unqualified_object_creation_expression] = STATE(315),
    [sym_field_access] = STATE(290),
    [sym_array_access] = STATE(290),
    [sym_method_invocation] = STATE(325),
    [sym__annotation] = STATE(523),
    [sym_marker_annotation] = STATE(523),
    [sym_annotation] = STATE(523),
    [sym_modifiers] = STATE(559),
    [sym__unannotated_type] = STATE(581),
    [sym_scoped_type_identifier] = STATE(596),
    [sym_generic_type] = STATE(646),
    [sym_array_type] = STATE(570),
    [sym_integral_type] = STATE(570),
    [sym_floating_point_type] = STATE(570),
    [sym_local_variable_declaration] = STATE(230),
    [aux_sym_modifiers_repeat1] = STATE(523),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_SEMI] = ACTIONS(242),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_PLUS_PLUS] = ACTIONS(31),
    [anon_sym_DASH_DASH] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(238),
    [aux_sym_modifiers_token1] = ACTIONS(240),
    [aux_sym_modifiers_token2] = ACTIONS(240),
    [aux_sym_modifiers_token3] = ACTIONS(240),
    [aux_sym_modifiers_token4] = ACTIONS(240),
    [aux_sym_modifiers_token5] = ACTIONS(240),
    [aux_sym_modifiers_token6] = ACTIONS(240),
    [aux_sym_modifiers_token7] = ACTIONS(240),
    [aux_sym_integral_type_token1] = ACTIONS(69),
    [aux_sym_integral_type_token2] = ACTIONS(69),
    [aux_sym_floating_point_type_token1] = ACTIONS(71),
    [aux_sym_floating_point_type_token2] = ACTIONS(71),
    [sym_boolean_type] = ACTIONS(73),
    [sym_void_type] = ACTIONS(73),
    [anon_sym_open] = ACTIONS(75),
    [anon_sym_module] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [77] = {
    [sym_catch_clause] = STATE(78),
    [sym_finally_clause] = STATE(158),
    [aux_sym_try_statement_repeat1] = STATE(78),
    [ts_builtin_sym_end] = ACTIONS(244),
    [sym_identifier] = ACTIONS(246),
    [sym_decimal_integer_literal] = ACTIONS(246),
    [sym_decimal_floating_point_literal] = ACTIONS(244),
    [sym_true] = ACTIONS(246),
    [sym_false] = ACTIONS(246),
    [sym_string_literal] = ACTIONS(244),
    [sym_null_literal] = ACTIONS(246),
    [anon_sym_LBRACK] = ACTIONS(244),
    [anon_sym_LPAREN] = ACTIONS(244),
    [aux_sym_typeof_clause_else_branch_token1] = ACTIONS(246),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(246),
    [aux_sym_dml_update_statement_token1] = ACTIONS(246),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(246),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(246),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(246),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(244),
    [anon_sym_TILDE] = ACTIONS(244),
    [anon_sym_PLUS_PLUS] = ACTIONS(244),
    [anon_sym_DASH_DASH] = ACTIONS(244),
    [anon_sym_new] = ACTIONS(246),
    [aux_sym_switch_expression_token1] = ACTIONS(246),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_RBRACE] = ACTIONS(244),
    [aux_sym_do_statement_token1] = ACTIONS(246),
    [aux_sym_do_statement_token2] = ACTIONS(246),
    [aux_sym_break_statement_token1] = ACTIONS(246),
    [aux_sym_continue_statement_token1] = ACTIONS(246),
    [aux_sym_return_statement_token1] = ACTIONS(246),
    [aux_sym_throw_statement_token1] = ACTIONS(246),
    [aux_sym_try_statement_token1] = ACTIONS(246),
    [aux_sym_catch_clause_token1] = ACTIONS(248),
    [aux_sym_finally_clause_token1] = ACTIONS(250),
    [aux_sym_if_statement_token1] = ACTIONS(246),
    [aux_sym_for_statement_token1] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(244),
    [aux_sym_enum_declaration_token1] = ACTIONS(246),
    [aux_sym_class_declaration_token1] = ACTIONS(246),
    [aux_sym_access_modifiers_token1] = ACTIONS(246),
    [aux_sym_access_modifiers_token2] = ACTIONS(246),
    [aux_sym_access_modifiers_token3] = ACTIONS(246),
    [aux_sym_modifiers_token1] = ACTIONS(246),
    [aux_sym_modifiers_token2] = ACTIONS(246),
    [aux_sym_modifiers_token3] = ACTIONS(246),
    [aux_sym_modifiers_token4] = ACTIONS(246),
    [aux_sym_modifiers_token5] = ACTIONS(246),
    [aux_sym_modifiers_token6] = ACTIONS(246),
    [aux_sym_modifiers_token7] = ACTIONS(246),
    [aux_sym_interface_declaration_token1] = ACTIONS(246),
    [aux_sym_integral_type_token1] = ACTIONS(246),
    [aux_sym_integral_type_token2] = ACTIONS(246),
    [aux_sym_floating_point_type_token1] = ACTIONS(246),
    [aux_sym_floating_point_type_token2] = ACTIONS(246),
    [sym_boolean_type] = ACTIONS(246),
    [sym_void_type] = ACTIONS(246),
    [anon_sym_open] = ACTIONS(246),
    [anon_sym_module] = ACTIONS(246),
    [sym_this] = ACTIONS(246),
    [sym_super] = ACTIONS(246),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [78] = {
    [sym_catch_clause] = STATE(78),
    [aux_sym_try_statement_repeat1] = STATE(78),
    [ts_builtin_sym_end] = ACTIONS(252),
    [sym_identifier] = ACTIONS(254),
    [sym_decimal_integer_literal] = ACTIONS(254),
    [sym_decimal_floating_point_literal] = ACTIONS(252),
    [sym_true] = ACTIONS(254),
    [sym_false] = ACTIONS(254),
    [sym_string_literal] = ACTIONS(252),
    [sym_null_literal] = ACTIONS(254),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_LPAREN] = ACTIONS(252),
    [aux_sym_typeof_clause_else_branch_token1] = ACTIONS(254),
    [aux_sym_dml_insert_statement_token1] = ACTIONS(254),
    [aux_sym_dml_update_statement_token1] = ACTIONS(254),
    [aux_sym_dml_upsert_statement_token1] = ACTIONS(254),
    [aux_sym_dml_delete_statement_token1] = ACTIONS(254),
    [aux_sym_dml_undelete_statemetn_token1] = ACTIONS(254),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(252),
    [anon_sym_TILDE] = ACTIONS(252),
    [anon_sym_PLUS_PLUS] = ACTIONS(252),
    [anon_sym_DASH_DASH] = ACTIONS(252),
    [anon_sym_new] = ACTIONS(254),
    [aux_sym_switch_expression_token1] = ACTIONS(254),
    [anon_sym_LBRACE] = ACTIONS(252),
    [anon_sym_RBRACE] = ACTIONS(252),
    [aux_sym_do_statement_token1] = ACTIONS(254),
    [aux_sym_do_statement_token2] = ACTIONS(254),
    [aux_sym_break_statement_token1] = ACTIONS(254),
    [aux_sym_continue_statement_token1] = ACTIONS(254),
    [aux_sym_return_statement_token1] = ACTIONS(254),
    [aux_sym_throw_statement_token1] = ACTIONS(254),
    [aux_sym_try_statement_token1] = ACTIONS(254),
    [aux_sym_catch_clause_token1] = ACTIONS(256),
    [aux_sym_finally_clause_token1] = ACTIONS(254),
    [aux_sym_if_statement_token1] = ACTIONS(254),
    [aux_sym_for_statement_token1] = ACTIONS(254),
    [anon_sym_AT] = ACTIONS(252),
    [aux_sym_enum_declaration_token1] = ACTIONS(254),
    [aux_sym_class_declaration_token1] = ACTIONS(254),
    [aux_sym_access_modifiers_token1] = ACTIONS(254),
    [aux_sym_access_modifiers_token2] = ACTIONS(254),
    [aux_sym_access_modifiers_token3] = ACTIONS(254),
    [aux_sym_modifiers_token1] = ACTIONS(254),
    [aux_sym_modifiers_token2] = ACTIONS(254),
    [aux_sym_modifiers_token3] = ACTIONS(254),
    [aux_sym_modifiers_token4] = ACTIONS(254),
    [aux_sym_modifiers_token5] = ACTIONS(254),
    [aux_sym_modifiers_token6] = ACTIONS(254),
    [aux_sym_modifiers_token7] = ACTIONS(254),
    [aux_sym_interface_declaration_token1] = ACTIONS(254),
    [aux_sym_integral_type_token1] = ACTIONS(254),
    [aux_sym_integral_type_token2] = ACTIONS(254),
    [aux_sym_floating_point_type_token1] = ACTIONS(254),
    [aux_sym_floating_point_type_token2] = ACTIONS(254),
    [sym_boolean_type] = ACTIONS(254),
    [sym_void_type] = ACTIONS(254),
    [anon_sym_open] = ACTIONS(254),
    [anon_sym_module] = ACTIONS(254),
    [sym_this] = ACTIONS(254),
    [sym_super] = ACTIONS(254),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 32,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(259), 1,
      sym_identifier,
    ACTIONS(261), 1,
      anon_sym_RPAREN,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(436), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    STATE(868), 1,
      sym_element_value_pair,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(1032), 5,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      sym__element_value,
      sym_element_value_array_initializer,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [129] = 32,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(259), 1,
      sym_identifier,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(265), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(436), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    STATE(825), 1,
      sym_element_value_pair,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(983), 5,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      sym__element_value,
      sym_element_value_array_initializer,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [258] = 32,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(267), 1,
      anon_sym_COMMA,
    ACTIONS(269), 1,
      anon_sym_RBRACE,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(436), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(852), 5,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      sym__element_value,
      sym_element_value_array_initializer,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [387] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(271), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(273), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [457] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(275), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(277), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [527] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(279), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(281), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [597] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(283), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(285), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [667] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(287), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(289), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [737] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(291), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(293), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [807] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(295), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(297), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [877] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(299), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(301), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [947] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(303), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(305), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1017] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(307), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(309), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1087] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(311), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(313), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1157] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(315), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(317), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1227] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(319), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(321), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1297] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(323), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(325), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1367] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(327), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(329), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1437] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(331), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(333), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1507] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(335), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(337), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1577] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(339), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(341), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1647] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(343), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(345), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1717] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(347), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(349), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1787] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(351), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(353), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1857] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(355), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(357), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1927] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(359), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(361), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [1997] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(363), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(365), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [2067] = 31,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(367), 1,
      anon_sym_RBRACE,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(436), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(922), 5,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      sym__element_value,
      sym_element_value_array_initializer,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [2193] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(369), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(371), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [2263] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(373), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(375), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [2333] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(377), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(379), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [2403] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(381), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(383), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [2473] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(385), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(387), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [2543] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(389), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(391), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [2613] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(393), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(395), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [2683] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(311), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(313), 49,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_catch_clause_token1,
      aux_sym_finally_clause_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [2753] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(389), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(391), 49,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_catch_clause_token1,
      aux_sym_finally_clause_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [2823] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(397), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(399), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [2893] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(401), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(403), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [2963] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(405), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(407), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [3033] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(409), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(411), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [3103] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(413), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(415), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [3173] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(417), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(419), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [3243] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(421), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(423), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [3313] = 31,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(425), 1,
      anon_sym_RBRACE,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(436), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(922), 5,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      sym__element_value,
      sym_element_value_array_initializer,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [3439] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(427), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(429), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [3509] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(431), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(433), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [3579] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(435), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(437), 49,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_catch_clause_token1,
      aux_sym_finally_clause_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [3649] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(439), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(441), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [3719] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(443), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(445), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [3789] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(447), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(449), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [3859] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(451), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(453), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [3929] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(455), 14,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(457), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [3999] = 30,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(440), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(904), 5,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      sym__element_value,
      sym_element_value_array_initializer,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [4122] = 30,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(436), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(922), 5,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      sym__element_value,
      sym_element_value_array_initializer,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [4245] = 31,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(238), 1,
      anon_sym_AT,
    ACTIONS(459), 1,
      sym_identifier,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(468), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(684), 1,
      sym_annotated_type,
    STATE(685), 1,
      sym__unannotated_type,
    STATE(773), 1,
      sym__type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(532), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_wildcard_repeat1,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [4370] = 31,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(238), 1,
      anon_sym_AT,
    ACTIONS(459), 1,
      sym_identifier,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(468), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(684), 1,
      sym_annotated_type,
    STATE(685), 1,
      sym__unannotated_type,
    STATE(821), 1,
      sym__type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(532), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_wildcard_repeat1,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [4495] = 30,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(57), 1,
      anon_sym_AT,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(436), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(904), 5,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      sym__element_value,
      sym_element_value_array_initializer,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [4618] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(461), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(463), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [4686] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(465), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(467), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [4754] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(469), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(471), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [4822] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(473), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(475), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [4890] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(477), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(479), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [4958] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(481), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(483), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5026] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(485), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(487), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5094] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(489), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(491), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5162] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(493), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(495), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5230] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(497), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(499), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5298] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(501), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(503), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5366] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(505), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(507), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5434] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(509), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(511), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5502] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(513), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(515), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5570] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(517), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(519), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5638] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(521), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(523), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5706] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(525), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(527), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5774] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(529), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(531), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5842] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(533), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(535), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5910] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(537), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(539), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [5978] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(541), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(543), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6046] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(545), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(547), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6114] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(549), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(551), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6182] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(553), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(555), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6250] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(557), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(559), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6318] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(561), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(563), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6386] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(565), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(567), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6454] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(569), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(571), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6522] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(573), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(575), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6590] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(577), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(579), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6658] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(581), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(583), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6726] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(585), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(587), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6794] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(589), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(591), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6862] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(593), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(595), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6930] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(597), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(599), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [6998] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(601), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(603), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [7066] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(605), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(607), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [7134] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(609), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(611), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [7202] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(613), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(615), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [7270] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(617), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(619), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [7338] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(621), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(623), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [7406] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(625), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(627), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [7474] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(629), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(631), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [7542] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(633), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(635), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [7610] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(637), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(639), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [7678] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(641), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(643), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [7746] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(645), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(647), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [7814] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(649), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(651), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [7882] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(653), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(655), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [7950] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(657), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(659), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [8018] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(661), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(663), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [8086] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(665), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(667), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [8154] = 4,
    ACTIONS(673), 1,
      aux_sym_typeof_clause_else_branch_token1,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(669), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(671), 46,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [8224] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(675), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(677), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [8292] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(244), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(246), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [8360] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(679), 12,
      ts_builtin_sym_end,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(681), 47,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_typeof_clause_else_branch_token1,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [8428] = 12,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(690), 1,
      anon_sym_LPAREN,
    ACTIONS(692), 1,
      anon_sym_EQ,
    ACTIONS(696), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LT,
    STATE(340), 1,
      sym_argument_list,
    STATE(551), 1,
      sym_type_arguments,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(683), 3,
      anon_sym_open,
      anon_sym_module,
      sym_identifier,
    ACTIONS(700), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(688), 16,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_BANG_EQ,
      anon_sym_SEMI,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(694), 21,
      aux_sym_complex_field_expression_token1,
      aux_sym_complex_field_expression_token2,
      aux_sym_order_by_clause_token1,
      aux_sym_limit_clause_token1,
      aux_sym_offset_clause_token1,
      aux_sym_group_by_clause_token1,
      aux_sym_having_clause_token1,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      aux_sym_instanceof_expression_token1,
  [8513] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(707), 11,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(705), 46,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [8579] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(711), 11,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(709), 46,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [8645] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(715), 11,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(713), 46,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [8711] = 31,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(717), 1,
      anon_sym_COMMA,
    ACTIONS(719), 1,
      anon_sym_LBRACE,
    ACTIONS(721), 1,
      anon_sym_RBRACE,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(410), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    STATE(847), 1,
      sym_array_initializer,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [8833] = 5,
    ACTIONS(690), 1,
      anon_sym_LPAREN,
    STATE(318), 1,
      sym_argument_list,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(723), 26,
      aux_sym_sosl_in_clause_token1,
      aux_sym_sosl_returning_clause_token1,
      anon_sym_EQ,
      aux_sym_complex_field_expression_token1,
      aux_sym_complex_field_expression_token2,
      aux_sym_order_by_clause_token1,
      aux_sym_limit_clause_token1,
      aux_sym_offset_clause_token1,
      aux_sym_group_by_clause_token1,
      aux_sym_having_clause_token1,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      aux_sym_instanceof_expression_token1,
      sym_identifier,
    ACTIONS(725), 29,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_BANG_EQ,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [8903] = 5,
    ACTIONS(690), 1,
      anon_sym_LPAREN,
    STATE(326), 1,
      sym_argument_list,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(727), 26,
      aux_sym_sosl_in_clause_token1,
      aux_sym_sosl_returning_clause_token1,
      anon_sym_EQ,
      aux_sym_complex_field_expression_token1,
      aux_sym_complex_field_expression_token2,
      aux_sym_order_by_clause_token1,
      aux_sym_limit_clause_token1,
      aux_sym_offset_clause_token1,
      aux_sym_group_by_clause_token1,
      aux_sym_having_clause_token1,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      aux_sym_instanceof_expression_token1,
      sym_identifier,
    ACTIONS(729), 29,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_BANG_EQ,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [8973] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(733), 11,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(731), 46,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [9039] = 30,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(719), 1,
      anon_sym_LBRACE,
    ACTIONS(735), 1,
      anon_sym_RBRACE,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(438), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    STATE(970), 1,
      sym_array_initializer,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [9158] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(739), 10,
      sym_decimal_floating_point_literal,
      sym_string_literal,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_AT,
    ACTIONS(737), 46,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      aux_sym_dml_insert_statement_token1,
      aux_sym_dml_update_statement_token1,
      aux_sym_dml_upsert_statement_token1,
      aux_sym_dml_delete_statement_token1,
      aux_sym_dml_undelete_statemetn_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      aux_sym_switch_expression_token1,
      aux_sym_do_statement_token1,
      aux_sym_do_statement_token2,
      aux_sym_break_statement_token1,
      aux_sym_continue_statement_token1,
      aux_sym_return_statement_token1,
      aux_sym_throw_statement_token1,
      aux_sym_try_statement_token1,
      aux_sym_if_statement_token1,
      aux_sym_for_statement_token1,
      aux_sym_enum_declaration_token1,
      aux_sym_class_declaration_token1,
      aux_sym_access_modifiers_token1,
      aux_sym_access_modifiers_token2,
      aux_sym_access_modifiers_token3,
      aux_sym_modifiers_token1,
      aux_sym_modifiers_token2,
      aux_sym_modifiers_token3,
      aux_sym_modifiers_token4,
      aux_sym_modifiers_token5,
      aux_sym_modifiers_token6,
      aux_sym_modifiers_token7,
      aux_sym_interface_declaration_token1,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
      sym_boolean_type,
      sym_void_type,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_super,
      sym_identifier,
  [9223] = 30,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(719), 1,
      anon_sym_LBRACE,
    ACTIONS(741), 1,
      anon_sym_RBRACE,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(438), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    STATE(970), 1,
      sym_array_initializer,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [9342] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(743), 26,
      aux_sym_sosl_in_clause_token1,
      aux_sym_sosl_returning_clause_token1,
      anon_sym_EQ,
      aux_sym_complex_field_expression_token1,
      aux_sym_complex_field_expression_token2,
      aux_sym_order_by_clause_token1,
      aux_sym_limit_clause_token1,
      aux_sym_offset_clause_token1,
      aux_sym_group_by_clause_token1,
      aux_sym_having_clause_token1,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      aux_sym_instanceof_expression_token1,
      sym_identifier,
    ACTIONS(745), 29,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_BANG_EQ,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [9406] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(727), 26,
      aux_sym_sosl_in_clause_token1,
      aux_sym_sosl_returning_clause_token1,
      anon_sym_EQ,
      aux_sym_complex_field_expression_token1,
      aux_sym_complex_field_expression_token2,
      aux_sym_order_by_clause_token1,
      aux_sym_limit_clause_token1,
      aux_sym_offset_clause_token1,
      aux_sym_group_by_clause_token1,
      aux_sym_having_clause_token1,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      aux_sym_instanceof_expression_token1,
      sym_identifier,
    ACTIONS(729), 29,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_BANG_EQ,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [9470] = 29,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(719), 1,
      anon_sym_LBRACE,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(439), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    STATE(937), 1,
      sym_array_initializer,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [9586] = 29,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(719), 1,
      anon_sym_LBRACE,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(438), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    STATE(970), 1,
      sym_array_initializer,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [9702] = 3,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(723), 26,
      aux_sym_sosl_in_clause_token1,
      aux_sym_sosl_returning_clause_token1,
      anon_sym_EQ,
      aux_sym_complex_field_expression_token1,
      aux_sym_complex_field_expression_token2,
      aux_sym_order_by_clause_token1,
      aux_sym_limit_clause_token1,
      aux_sym_offset_clause_token1,
      aux_sym_group_by_clause_token1,
      aux_sym_having_clause_token1,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      aux_sym_instanceof_expression_token1,
      sym_identifier,
    ACTIONS(725), 29,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_BANG_EQ,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [9766] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(747), 1,
      anon_sym_SEMI,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(463), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [9879] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(749), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(425), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [9992] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(751), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(421), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [10105] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(753), 1,
      anon_sym_SEMI,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(484), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [10218] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(755), 1,
      anon_sym_SEMI,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(469), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [10331] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(757), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(418), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [10444] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(759), 1,
      anon_sym_SEMI,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(472), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [10557] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(761), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(420), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [10670] = 28,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(763), 1,
      sym_identifier,
    ACTIONS(765), 1,
      aux_sym_default_switch_statement_group_token1,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(404), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [10783] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(767), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(427), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [10896] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(769), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(435), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [11009] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(771), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(428), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [11122] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(773), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(419), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [11235] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(775), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(415), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [11348] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(777), 1,
      anon_sym_SEMI,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(483), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [11461] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(779), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(416), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [11574] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(781), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(422), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [11687] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(783), 1,
      anon_sym_RBRACK,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(460), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [11800] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(785), 1,
      anon_sym_SEMI,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(487), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [11913] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(787), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(424), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [12026] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(789), 1,
      anon_sym_SEMI,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(458), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [12139] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(791), 1,
      anon_sym_SEMI,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(482), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [12252] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(793), 1,
      anon_sym_SEMI,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(470), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [12365] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(795), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(417), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [12478] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(797), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(413), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [12591] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(799), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(432), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [12704] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(801), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(430), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [12817] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(803), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(414), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [12930] = 28,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(805), 1,
      anon_sym_RBRACK,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(460), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [13043] = 27,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(807), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_LPAREN,
    ACTIONS(817), 1,
      anon_sym_new,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(408), 1,
      sym_primary_expression,
    STATE(437), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(811), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(813), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(815), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(819), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(378), 2,
      sym_field_access,
      sym_array_access,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [13153] = 27,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(807), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_LPAREN,
    ACTIONS(817), 1,
      anon_sym_new,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(408), 1,
      sym_primary_expression,
    STATE(450), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(811), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(813), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(815), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(819), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(378), 2,
      sym_field_access,
      sym_array_access,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [13263] = 27,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(456), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [13373] = 27,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(462), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [13483] = 27,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(807), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_LPAREN,
    ACTIONS(817), 1,
      anon_sym_new,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(376), 1,
      sym_expression,
    STATE(408), 1,
      sym_primary_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(811), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(813), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(815), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(819), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(378), 2,
      sym_field_access,
      sym_array_access,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [13593] = 27,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(453), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [13703] = 27,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(807), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_LPAREN,
    ACTIONS(817), 1,
      anon_sym_new,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(408), 1,
      sym_primary_expression,
    STATE(442), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(811), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(813), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(815), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(819), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(378), 2,
      sym_field_access,
      sym_array_access,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [13813] = 27,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(460), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [13923] = 27,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    ACTIONS(807), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_LPAREN,
    ACTIONS(817), 1,
      anon_sym_new,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(408), 1,
      sym_primary_expression,
    STATE(449), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(811), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(813), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(815), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(819), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(378), 2,
      sym_field_access,
      sym_array_access,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [14033] = 27,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(380), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STATE(290), 2,
      sym_field_access,
      sym_array_access,
    STATE(316), 2,
      sym_sosl_query,
      sym_soql_query,
    STATE(570), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(9), 4,
      sym_decimal_integer_literal,
      sym_true,
      sym_false,
      sym_null_literal,
    STATE(325), 7,
      sym__literal,
      sym_database_query,
      sym_array_creation_expression,
      sym_parenthesized_expression,
      sym_class_literal,
      sym_object_creation_expression,
      sym_method_invocation,
    STATE(373), 7,
      sym_cast_expression,
      sym_assignment_expression,
      sym_binary_expression,
      sym_instanceof_expression,
      sym_ternary_expression,
      sym_unary_expression,
      sym_update_expression,
  [14143] = 27,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_new,
    ACTIONS(77), 1,
      sym_this,
    ACTIONS(79), 1,
      sym_super,
    STATE(315), 1,
      sym__unqualified_object_creation_expression,
    STATE(375), 1,
      sym_primary_expression,
    STATE(466), 1,
      sym_expression,
    STATE(596), 1,
      sym_scoped_type_identifier,
    STATE(646), 1,
      sym_generic_type,
    STATE(766), 1,
      sym__unannotated_type,
    ACTIONS(3), 2,
      sym_line_comment,
      sym_block_comment,
    ACTIONS(11), 2,
      sym_decimal_floating_point_literal,
      sym_string_literal,
    ACTIONS(27), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(29), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(31), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(69), 2,
      aux_sym_integral_type_token1,
      aux_sym_integral_type_token2,
    ACTIONS(71), 2,
      aux_sym_floating_point_type_token1,
      aux_sym_floating_point_type_token2,
    ACTIONS(73), 2,
      sym_boolean_type,
      sym_void_type,
    ACTIONS(75), 2,
      anon_sym_open,
      anon_sym_module,
    STA