use std::time::Instant;

#[derive(Clone)]
pub struct Paste {
    /// Paste lifetime
    pub lifetime: Instant,
    /// HTTP content type
    pub content_type: String,
    /// Paste content
    pub content: Vec<u8>,
}

impl Paste {
    pub fn new_plain(content: Vec<u8>) -> Self {
        Self {
            lifetime: Instant::now(),
            content,
            content_type: "text/plain; charset=utf-8".to_string(),
        }
    }

    pub fn new_html(content: Vec<u8>) -> Self {
        Self {
            lifetime: Instant::now(),
            content,
            content_type: "text/html; charset=utf-8".to_string(),
        }
    }
}