#[derive(Clone)]
pub struct Paste {
    /// Paste lifetime (in minutes)
    pub lifetime: u32,
    /// HTTP conntent type
    pub content_type: String,
    /// Paste content
    pub content: Vec<u8>,
}

impl Paste {
    pub fn new_plain(lifetime: u32, content: Vec<u8>) -> Self {
        Self {
            lifetime,
            content,
            content_type: "text/plain; charset=utf-8".to_string(),
        }
    }

    pub fn new_html(lifetime: u32, content: Vec<u8>) -> Self {
        Self {
            lifetime,
            content,
            content_type: "text/html; charset=utf-8".to_string(),
        }
    }
}