use std::fs::File;
use std::io::{Result, Write};
use std::path::PathBuf;

fn main() -> Result<()> {
    gen_vector_asm()?;
    Ok(())
}

/// Generate assembly file for x86_64 trap vector
fn gen_vector_asm() -> Result<()> {
    let out_path = PathBuf::from(std::env::var("OUT_DIR").unwrap());
    let mut f = File::create(out_path.join("vector.S"))?;

    writeln!(f, "# generated by build.rs - do not edit")?;
    writeln!(f, ".section .text")?;
    writeln!(f, ".intel_syntax noprefix")?;
    for i in 0..256 {
        writeln!(f, "vector{}:", i)?;
        if !(i == 8 || (i >= 10 && i <= 14) || i == 17) {
            writeln!(f, "\tpush 0")?;
        }
        writeln!(f, "\tpush {}", i)?;
        writeln!(f, "\tjmp __alltraps")?;
    }

    writeln!(f, "\n.section .rodata")?;
    writeln!(f, ".global __vectors")?;
    writeln!(f, "__vectors:")?;
    for i in 0..256 {
        writeln!(f, "\t.quad vector{}", i)?;
    }
    Ok(())
}
