use serde::Deserialize;
use serde::Serialize;

use super::torrent::Torrent;

#[derive(Debug, Deserialize, Serialize)]
pub struct TorrentList {
	pub torrents: Vec<Torrent>
}

#[derive(Debug, Serialize)]
pub struct FieldList {
	pub fields: Vec<String>
}

impl FieldList {
	pub fn new(fields: &[impl ToString]) -> Self {
		Self{
			fields: fields.iter().map(|s| s.to_string()).collect()
		}
	}
}

