use serde::Deserialize;
use serde::Serialize;

#[derive(Debug, Serialize)]
pub struct Request<'a, T> {
	method: &'a str,
	tag: u8,
	pub arguments: T
}

impl<'a, T> Request<'a, T> {
	pub fn new(method: &'a str, tag: u8, arguments: T) -> Self {
		Self{
			method: method,
			tag,
			arguments
		}
	}
}

#[derive(Debug, Deserialize)]
pub struct Response<T> {
	#[serde(rename = "result")]
	_result: String,
	#[serde(rename = "tag")]
	_tag: u8,
	pub arguments: T
}

