#[derive(Debug, thiserror::Error)]
pub enum Error {
	#[error("HTTP error:  {0}")]
	Reqwest(#[from] reqwest::Error),
	#[error("HTTP header decoding error:  {0}")]
	ReqwestHeaderDecode(#[from] reqwest::header::ToStrError),
	#[error("invalid HTTP header value:  {0}")]
	ReqwestHeaderValue(#[from] reqwest::header::InvalidHeaderValue),
	#[error("Unknown HTTP failure")]
	HTTPUnknown,
	#[error("JSON error:  {0}")]
	JSON(#[from] serde_json::Error),
	#[error("I/O error:  {0}")]
	IO(#[from] std::io::Error),
	#[error("got more than one 'torrents' entry in a get files response")]
	WeirdGetFilesResponse,
}

