use serde::Deserialize;
use serde::Serialize;

#[derive(Debug, Serialize)]
pub struct Request<T> {
	method: String,
	tag: u8,
	pub arguments: T
}

impl<T> Request<T> {
	pub fn new(method: impl ToString, tag: u8, arguments: T) -> Self {
		Self{
			method: method.to_string(),
			tag,
			arguments
		}
	}
}

#[derive(Debug, Deserialize)]
pub struct Response<T> {
	#[serde(rename = "result")]
	_result: String,
	#[serde(rename = "tag")]
	_tag: u8,
	pub arguments: T
}

