use std::path::PathBuf;

use serde::Deserialize;
use serde::Serialize;

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(rename_all = "camelCase")]
pub struct Torrent {
	pub id: u16,
	pub error: u8,
	pub error_string: String,
	pub eta: i64, // TODO:  Option<u64> with -1 as None
	pub is_finished: bool,
	pub left_until_done: u64, // TODO:  u32?
	pub name: String,
	pub peers_getting_from_us: u16,
	pub peers_sending_to_us: u16,
	pub rate_download: u32,
	pub rate_upload: u32,
	pub size_when_done: u64,
	pub status: u8,
	pub upload_ratio: f32
}

#[serde_with::skip_serializing_none]
#[derive(Debug, Serialize)]
pub struct AddTorrent {
	pub filename: Option<String>,
	pub metainfo: Option<String>
}

#[derive(Debug, Deserialize, Serialize)]
#[serde(rename_all = "camelCase")]
pub struct AddedTorrent {
	pub id: u16,
	pub name: String,
	pub hash_string: String
}

#[derive(Debug, Deserialize, Serialize)]
#[serde(rename_all = "kebab-case")]
pub enum AddTorrentResponse {
	TorrentAdded(AddedTorrent),
	TorrentDuplicate(AddedTorrent)
}

#[derive(Debug, Serialize)]
#[serde(rename_all = "kebab-case")]
pub struct GetTorrentFilesRequest {
	fields: Vec<String>,
	ids: u16
}

impl GetTorrentFilesRequest {
	pub fn new(id: u16) -> Self {
		Self{
			fields: vec!["files".to_string()],
			ids: id
		}
	}
}

#[derive(Clone, Debug, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct TorrentFile {
	pub name: PathBuf,
	pub bytes_completed: u64,
	pub length: u64
}

impl TorrentFile {
	pub fn take_name(self) -> PathBuf {
		self.name
	}
}

#[derive(Debug, Deserialize)]
pub struct TorrentFileWrapper {
	pub files: Vec<TorrentFile>
}

#[derive(Debug, Deserialize)]
pub struct GetTorrentFilesResponse {
	pub torrents: Vec<TorrentFileWrapper>
}

