use serde::Deserialize;
use serde::Serialize;

#[derive(Debug, Serialize)]
pub struct Request<T> {
	method: String,
	tag: u8,
	pub arguments: T
}

impl<T> Request<T> {
	pub fn new(method: impl ToString, tag: u8, arguments: T) -> Self {
		Self{
			method: method.to_string(),
			tag: tag,
			arguments: arguments
		}
	}
}

#[derive(Debug, Deserialize)]
pub struct Response<T> {
	result: String,
	tag: u8,
	pub arguments: T
}

