use serde::Deserialize;
use serde::Serialize;

use super::torrent::Torrent;

#[derive(Debug, Deserialize, Serialize)]
pub struct TorrentList {
	pub torrents: Vec<Torrent>
}

#[derive(Debug, Serialize)]
pub struct FieldList {
	pub fields: Vec<String>
}

impl FieldList {
	pub fn from_vec(vec: Vec<impl ToString>) -> Self {
		Self{
			fields: vec.iter().map(|s| s.to_string()).collect()
		}
	}
}

