#![allow(unused_parens)]
//! Ergonomic Rust bindings for the [Transmission](https://transmissionbt.com/) BitTorrent client
//! based on [transmission-sys](https://gitlab.com/tornado-torrent/transmission-sys).
//!
//! Most interaction will be done through the `Client` struct.

extern crate serde;
extern crate serde_json;

// Re-exports
mod client;
pub use client::Client;
pub use client::torrent::Torrent;
pub use client::torrent::AddTorrentResponse;
pub use client::torrent::TorrentFile;
mod error;
pub use error::Error;

