#![allow(unused_parens)]

mod client;
mod error;
pub use error::Error;

#[tokio::main]
async fn main() {
	let mut client = client::Client::new("transmission.home.quadra-tec.net", 9091, false, Some(("rpc".to_string(), "faster".to_string()))).unwrap();
	client.authenticate().await.unwrap();
	/*
	let torrents = client.list_by_name().await.unwrap();
	println!("{}", serde_json::to_string(&torrents).unwrap());
	*/
	for torrent in client.list().await.unwrap() {
		println!("{}", torrent.name.len());
	}
	/*
	let add_result = client.add_torrent_from_link("http://jackett.cronce.io/dl/iptorrents/?jackett_apikey=ncc9usyrou9scugt8fddjsa8k2701ubs&path=Q2ZESjhNYjliVmJtcEpKRnEtdnNmMG8tZUlsYnhGVVZ5VTVVeW5XYjFsQ2JNdUFMejBQaldIa2JudFhmb3VjWXlMcHVsc1lqbFZiVmNDWUVHVkdqUEJVeUxRd0htYTAyLVRWczF5bjZTZmdhQ2xmUzJuLXV4aXZwRUMwM0VtZHlFLUFROUFmT0o2MGhuLW5PUTlkbGYxbGxkb3ZlekxxT3VobjFhdDhuREJWQkpqQ1I4MlJkbGFxX0FuN2RYYV9ueHM5aW12SG9WaVJUQVVURGptRFEtVmJZNTljdkJkZDB2azhSV0xEVUhIVE5oU081OWVMb0lGU2VFaDZ5TEh3MjVEejZUZw&file=The+Secrets+We+Keep+2020+1080p+WEB-DL+H264+AC3-EVO")
		.await.unwrap();
	println!("{}", serde_json::to_string(&add_result).unwrap());
	*/
}

