/*
 * Copyright 2021 Cargill Incorporated
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * -----------------------------------------------------------------------------
 */

//! Trait for reading transactions from a source

pub mod protobuf;

use crate::error::InternalError;
use crate::protocol::transaction::Transaction;

/// `TransactionReader` provides an API for reading transactions from a source
pub trait TransactionReader {
    /// Returns a vec with at least max_txns `Transactions` in it
    fn next(&mut self, max_txns: usize) -> Result<Vec<Transaction>, InternalError>;
}
