#![feature(trait_alias)]

use core::ops::{Add, Div, Mul, Rem, Sub};

/// Copy + Clone
pub trait CC = Copy + Clone;

/// Debug + Display
pub trait DD = core::fmt::Debug + core::fmt::Display;

/// [num::traits::NumOps]
///
/// see
/// - <https://docs.rs/num/latest/num/traits/trait.NumOps.html>
/// - <https://docs.rs/num-traits/0.2.14/src/num_traits/lib.rs.html#110-117>
pub trait NumOps<Rhs = Self, Output = Self> = Add<Rhs, Output = Output>
    + Sub<Rhs, Output = Output>
    + Mul<Rhs, Output = Output>
    + Div<Rhs, Output = Output>
    + Rem<Rhs, Output = Output>;

#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }
}
