use crate::infer::*;
use crate::internal::*;

use tract_core::broadcast::multi_broadcast;
pub use tract_core::ops::binary::wire_with_rank_broadcast;
pub use tract_core::ops::logic::*;

#[derive(Debug, Clone, Hash)]
pub struct Iff;

impl_dyn_hash!(Iff);

impl Expansion for Iff {
    fn name(&self) -> Cow<str> {
        "Iff".into()
    }

    op_hir!();

    fn rules<'r, 'p: 'r, 's: 'r>(
        &'s self,
        s: &mut Solver<'r>,
        inputs: &'p [TensorProxy],
        outputs: &'p [TensorProxy],
    ) -> InferenceResult {
        check_input_arity(&inputs, 3)?;
        check_output_arity(&outputs, 1)?;
        s.equals(&inputs[0].datum_type, DatumType::Bool)?;
        s.equals(&inputs[1].datum_type, &outputs[0].datum_type)?;
        s.equals(&inputs[2].datum_type, &outputs[0].datum_type)?;
        s.given_3(&inputs[0].shape, &inputs[1].shape, &inputs[2].shape, move |s, c, t, f| {
            let shape = multi_broadcast(&[&c, &t, &f])
                .with_context(|| format!("Incompatible shapes {:?}, {:?} and {:?}", c, t, f))?;
            s.equals(&outputs[0].shape, shape)
        })?;
        Ok(())
    }

    fn wire(&self, prefix: &str, model: &mut TypedModel, inputs: &[OutletId]) -> TractResult<TVec<OutletId>> {
        wire_with_rank_broadcast(prefix, model, tract_core::ops::logic::Iff, inputs)
    }
}
