// Generated by gir (https://github.com/gtk-rs/gir @ ee37253c10af)
// from 
// from gir-files (https://github.com/gtk-rs/gir-files.git @ 923f9a1041f5)
// DO NOT EDIT

use tracker_sys::*;
use std::mem::{align_of, size_of};
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::path::Path;
use std::process::Command;
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["tracker-sparql-3.0"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}", &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG")
        .unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}",
                           &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}


#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let value = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse value");
        c_constants.push((name, value));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_value, &c_value
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let size = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse size");
        let alignment = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse alignment");
        c_layouts.push((name, Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in
        RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!(
                "Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_layout, &c_layout
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}", &abi_cmd, &output).into());
    }

    Ok(String::from_utf8(output.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    ("TrackerBatch", Layout {size: size_of::<TrackerBatch>(), alignment: align_of::<TrackerBatch>()}),
    ("TrackerEndpoint", Layout {size: size_of::<TrackerEndpoint>(), alignment: align_of::<TrackerEndpoint>()}),
    ("TrackerNamespaceManagerClass", Layout {size: size_of::<TrackerNamespaceManagerClass>(), alignment: align_of::<TrackerNamespaceManagerClass>()}),
    ("TrackerNotifier", Layout {size: size_of::<TrackerNotifier>(), alignment: align_of::<TrackerNotifier>()}),
    ("TrackerNotifierEventType", Layout {size: size_of::<TrackerNotifierEventType>(), alignment: align_of::<TrackerNotifierEventType>()}),
    ("TrackerResource", Layout {size: size_of::<TrackerResource>(), alignment: align_of::<TrackerResource>()}),
    ("TrackerSparqlConnection", Layout {size: size_of::<TrackerSparqlConnection>(), alignment: align_of::<TrackerSparqlConnection>()}),
    ("TrackerSparqlConnectionFlags", Layout {size: size_of::<TrackerSparqlConnectionFlags>(), alignment: align_of::<TrackerSparqlConnectionFlags>()}),
    ("TrackerSparqlCursor", Layout {size: size_of::<TrackerSparqlCursor>(), alignment: align_of::<TrackerSparqlCursor>()}),
    ("TrackerSparqlError", Layout {size: size_of::<TrackerSparqlError>(), alignment: align_of::<TrackerSparqlError>()}),
    ("TrackerSparqlStatement", Layout {size: size_of::<TrackerSparqlStatement>(), alignment: align_of::<TrackerSparqlStatement>()}),
    ("TrackerSparqlValueType", Layout {size: size_of::<TrackerSparqlValueType>(), alignment: align_of::<TrackerSparqlValueType>()}),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) TRACKER_NOTIFIER_EVENT_CREATE", "0"),
    ("(gint) TRACKER_NOTIFIER_EVENT_DELETE", "1"),
    ("(gint) TRACKER_NOTIFIER_EVENT_UPDATE", "2"),
    ("TRACKER_PREFIX_DC", "http://purl.org/dc/elements/1.1/"),
    ("TRACKER_PREFIX_MFO", "http://tracker.api.gnome.org/ontology/v3/mfo#"),
    ("TRACKER_PREFIX_NAO", "http://tracker.api.gnome.org/ontology/v3/nao#"),
    ("TRACKER_PREFIX_NCO", "http://tracker.api.gnome.org/ontology/v3/nco#"),
    ("TRACKER_PREFIX_NFO", "http://tracker.api.gnome.org/ontology/v3/nfo#"),
    ("TRACKER_PREFIX_NIE", "http://tracker.api.gnome.org/ontology/v3/nie#"),
    ("TRACKER_PREFIX_NMM", "http://tracker.api.gnome.org/ontology/v3/nmm#"),
    ("TRACKER_PREFIX_NRL", "http://tracker.api.gnome.org/ontology/v3/nrl#"),
    ("TRACKER_PREFIX_OSINFO", "http://tracker.api.gnome.org/ontology/v3/osinfo#"),
    ("TRACKER_PREFIX_RDF", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"),
    ("TRACKER_PREFIX_RDFS", "http://www.w3.org/2000/01/rdf-schema#"),
    ("TRACKER_PREFIX_SLO", "http://tracker.api.gnome.org/ontology/v3/slo#"),
    ("TRACKER_PREFIX_TRACKER", "http://tracker.api.gnome.org/ontology/v3/tracker#"),
    ("TRACKER_PREFIX_XSD", "http://www.w3.org/2001/XMLSchema#"),
    ("(guint) TRACKER_SPARQL_CONNECTION_FLAGS_FTS_ENABLE_STEMMER", "2"),
    ("(guint) TRACKER_SPARQL_CONNECTION_FLAGS_FTS_ENABLE_STOP_WORDS", "8"),
    ("(guint) TRACKER_SPARQL_CONNECTION_FLAGS_FTS_ENABLE_UNACCENT", "4"),
    ("(guint) TRACKER_SPARQL_CONNECTION_FLAGS_FTS_IGNORE_NUMBERS", "16"),
    ("(guint) TRACKER_SPARQL_CONNECTION_FLAGS_NONE", "0"),
    ("(guint) TRACKER_SPARQL_CONNECTION_FLAGS_READONLY", "1"),
    ("(gint) TRACKER_SPARQL_ERROR_CONSTRAINT", "0"),
    ("(gint) TRACKER_SPARQL_ERROR_INTERNAL", "1"),
    ("(gint) TRACKER_SPARQL_ERROR_NO_SPACE", "2"),
    ("(gint) TRACKER_SPARQL_ERROR_ONTOLOGY_NOT_FOUND", "3"),
    ("(gint) TRACKER_SPARQL_ERROR_OPEN_ERROR", "4"),
    ("(gint) TRACKER_SPARQL_ERROR_PARSE", "5"),
    ("(gint) TRACKER_SPARQL_ERROR_QUERY_FAILED", "6"),
    ("(gint) TRACKER_SPARQL_ERROR_TYPE", "7"),
    ("(gint) TRACKER_SPARQL_ERROR_UNKNOWN_CLASS", "8"),
    ("(gint) TRACKER_SPARQL_ERROR_UNKNOWN_GRAPH", "9"),
    ("(gint) TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY", "10"),
    ("(gint) TRACKER_SPARQL_ERROR_UNSUPPORTED", "11"),
    ("(gint) TRACKER_SPARQL_N_ERRORS", "12"),
    ("(gint) TRACKER_SPARQL_VALUE_TYPE_BLANK_NODE", "6"),
    ("(gint) TRACKER_SPARQL_VALUE_TYPE_BOOLEAN", "7"),
    ("(gint) TRACKER_SPARQL_VALUE_TYPE_DATETIME", "5"),
    ("(gint) TRACKER_SPARQL_VALUE_TYPE_DOUBLE", "4"),
    ("(gint) TRACKER_SPARQL_VALUE_TYPE_INTEGER", "3"),
    ("(gint) TRACKER_SPARQL_VALUE_TYPE_STRING", "2"),
    ("(gint) TRACKER_SPARQL_VALUE_TYPE_UNBOUND", "0"),
    ("(gint) TRACKER_SPARQL_VALUE_TYPE_URI", "1"),
];


