// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Endpoint;
#[cfg(any(feature = "v3_1", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
use crate::SparqlConnection;
#[cfg(any(feature = "v3_1", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
#[cfg(any(feature = "v3_1", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
use std::ptr;

glib::wrapper! {
    #[doc(alias = "TrackerEndpointHttp")]
    pub struct EndpointHttp(Object<ffi::TrackerEndpointHttp>) @extends Endpoint, @implements gio::Initable;

    match fn {
        type_ => || ffi::tracker_endpoint_http_get_type(),
    }
}

impl EndpointHttp {
    #[cfg(any(feature = "v3_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
    #[doc(alias = "tracker_endpoint_http_new")]
    pub fn new(
        sparql_connection: &SparqlConnection,
        port: u32,
        certificate: Option<&impl IsA<gio::TlsCertificate>>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<EndpointHttp, glib::Error> {
        skip_assert_initialized!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::tracker_endpoint_http_new(
                sparql_connection.to_glib_none().0,
                port,
                certificate.map(|p| p.as_ref()).to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "http-certificate")]
    pub fn http_certificate(&self) -> Option<gio::TlsCertificate> {
        glib::ObjectExt::property(self, "http-certificate")
    }

    #[doc(alias = "http-port")]
    pub fn http_port(&self) -> u32 {
        glib::ObjectExt::property(self, "http-port")
    }

    #[doc(alias = "block-remote-address")]
    pub fn connect_block_remote_address<F: Fn(&Self, &gio::SocketAddress) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn block_remote_address_trampoline<
            F: Fn(&EndpointHttp, &gio::SocketAddress) -> bool + 'static,
        >(
            this: *mut ffi::TrackerEndpointHttp,
            address: *mut gio::ffi::GSocketAddress,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(address)).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"block-remote-address\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    block_remote_address_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for EndpointHttp {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("EndpointHttp")
    }
}
