// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

#[cfg(any(feature = "v3_1", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
use crate::Resource;
use crate::SparqlConnection;
#[cfg(any(feature = "v3_1", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
use glib::object::IsA;
use glib::translate::*;
#[cfg(any(feature = "v3_1", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
use std::boxed::Box as Box_;
use std::fmt;
#[cfg(any(feature = "v3_1", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
use std::pin::Pin;
#[cfg(any(feature = "v3_1", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
use std::ptr;

glib::wrapper! {
    #[doc(alias = "TrackerBatch")]
    pub struct Batch(Object<ffi::TrackerBatch, ffi::TrackerBatchClass>);

    match fn {
        type_ => || ffi::tracker_batch_get_type(),
    }
}

impl Batch {
    #[cfg(any(feature = "v3_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
    #[doc(alias = "tracker_batch_add_resource")]
    pub fn add_resource(&self, graph: &str, resource: &Resource) {
        unsafe {
            ffi::tracker_batch_add_resource(
                self.to_glib_none().0,
                graph.to_glib_none().0,
                resource.to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v3_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
    #[doc(alias = "tracker_batch_add_sparql")]
    pub fn add_sparql(&self, sparql: &str) {
        unsafe {
            ffi::tracker_batch_add_sparql(self.to_glib_none().0, sparql.to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
    #[doc(alias = "tracker_batch_execute")]
    pub fn execute(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::tracker_batch_execute(
                self.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(any(feature = "v3_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
    #[doc(alias = "tracker_batch_execute_async")]
    pub fn execute_async<P: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let user_data: Box_<P> = Box_::new(callback);
        unsafe extern "C" fn execute_async_trampoline<
            P: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::tracker_batch_execute_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<P> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = execute_async_trampoline::<P>;
        unsafe {
            ffi::tracker_batch_execute_async(
                self.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    #[cfg(any(feature = "v3_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
    pub fn execute_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.execute_async(Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    #[doc(alias = "tracker_batch_get_connection")]
    #[doc(alias = "get_connection")]
    pub fn connection(&self) -> Option<SparqlConnection> {
        unsafe { from_glib_none(ffi::tracker_batch_get_connection(self.to_glib_none().0)) }
    }
}

impl fmt::Display for Batch {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Batch")
    }
}
