use crate::SparqlCursor;
use glib::object::IsA;
use glib::translate::*;

pub trait SparqlCursorExtManual: 'static {
    fn string(&self, column: i32) -> Option<glib::GString>;
}

impl<O: IsA<SparqlCursor>> SparqlCursorExtManual for O {
    fn string(&self, column: i32) -> Option<glib::GString> {
        unsafe {
            let ret = from_glib_none(ffi::tracker_sparql_cursor_get_string(
                self.as_ref().to_glib_none().0,
                column,
                std::ptr::null_mut(),
            ));
            ret
        }
    }
}
