// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ..
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::NamespaceManager;
use glib::object::Cast;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "TrackerResource")]
    pub struct Resource(Object<ffi::TrackerResource, ffi::TrackerResourceClass>);

    match fn {
        type_ => || ffi::tracker_resource_get_type(),
    }
}

impl Resource {
    #[doc(alias = "tracker_resource_new")]
    pub fn new(identifier: Option<&str>) -> Resource {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::tracker_resource_new(identifier.to_glib_none().0)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Resource`] objects.
    ///
    /// This method returns an instance of [`ResourceBuilder`] which can be used to create [`Resource`] objects.
    pub fn builder() -> ResourceBuilder {
        ResourceBuilder::default()
    }

    #[doc(alias = "tracker_resource_add_boolean")]
    pub fn add_boolean(&self, property_uri: &str, value: bool) {
        unsafe {
            ffi::tracker_resource_add_boolean(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                value.into_glib(),
            );
        }
    }

    #[doc(alias = "tracker_resource_add_double")]
    pub fn add_double(&self, property_uri: &str, value: f64) {
        unsafe {
            ffi::tracker_resource_add_double(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                value,
            );
        }
    }

    #[doc(alias = "tracker_resource_add_gvalue")]
    pub fn add_gvalue(&self, property_uri: &str, value: &glib::Value) {
        unsafe {
            ffi::tracker_resource_add_gvalue(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                value.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "tracker_resource_add_int")]
    pub fn add_int(&self, property_uri: &str, value: i32) {
        unsafe {
            ffi::tracker_resource_add_int(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                value,
            );
        }
    }

    #[doc(alias = "tracker_resource_add_int64")]
    pub fn add_int64(&self, property_uri: &str, value: i64) {
        unsafe {
            ffi::tracker_resource_add_int64(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                value,
            );
        }
    }

    #[doc(alias = "tracker_resource_add_relation")]
    pub fn add_relation(&self, property_uri: &str, resource: &Resource) {
        unsafe {
            ffi::tracker_resource_add_relation(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                resource.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "tracker_resource_add_string")]
    pub fn add_string(&self, property_uri: &str, value: &str) {
        unsafe {
            ffi::tracker_resource_add_string(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                value.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "tracker_resource_add_take_relation")]
    pub fn add_take_relation(&self, property_uri: &str, resource: &Resource) {
        unsafe {
            ffi::tracker_resource_add_take_relation(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                resource.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "tracker_resource_add_uri")]
    pub fn add_uri(&self, property_uri: &str, value: &str) {
        unsafe {
            ffi::tracker_resource_add_uri(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                value.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "tracker_resource_get_first_boolean")]
    #[doc(alias = "get_first_boolean")]
    pub fn is_first_boolean(&self, property_uri: &str) -> bool {
        unsafe {
            from_glib(ffi::tracker_resource_get_first_boolean(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "tracker_resource_get_first_double")]
    #[doc(alias = "get_first_double")]
    pub fn first_double(&self, property_uri: &str) -> f64 {
        unsafe {
            ffi::tracker_resource_get_first_double(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
            )
        }
    }

    #[doc(alias = "tracker_resource_get_first_int")]
    #[doc(alias = "get_first_int")]
    pub fn first_int(&self, property_uri: &str) -> i32 {
        unsafe {
            ffi::tracker_resource_get_first_int(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
            )
        }
    }

    #[doc(alias = "tracker_resource_get_first_int64")]
    #[doc(alias = "get_first_int64")]
    pub fn first_int64(&self, property_uri: &str) -> i64 {
        unsafe {
            ffi::tracker_resource_get_first_int64(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
            )
        }
    }

    #[doc(alias = "tracker_resource_get_first_relation")]
    #[doc(alias = "get_first_relation")]
    pub fn first_relation(&self, property_uri: &str) -> Option<Resource> {
        unsafe {
            from_glib_none(ffi::tracker_resource_get_first_relation(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "tracker_resource_get_first_string")]
    #[doc(alias = "get_first_string")]
    pub fn first_string(&self, property_uri: &str) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::tracker_resource_get_first_string(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "tracker_resource_get_first_uri")]
    #[doc(alias = "get_first_uri")]
    pub fn first_uri(&self, property_uri: &str) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::tracker_resource_get_first_uri(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "tracker_resource_get_identifier")]
    #[doc(alias = "get_identifier")]
    pub fn identifier(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::tracker_resource_get_identifier(self.to_glib_none().0)) }
    }

    #[doc(alias = "tracker_resource_get_properties")]
    #[doc(alias = "get_properties")]
    pub fn properties(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::tracker_resource_get_properties(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v3_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_1")))]
    #[doc(alias = "tracker_resource_get_property_overwrite")]
    #[doc(alias = "get_property_overwrite")]
    pub fn is_property_overwrite(&self, property_uri: &str) -> bool {
        unsafe {
            from_glib(ffi::tracker_resource_get_property_overwrite(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "tracker_resource_identifier_compare_func")]
    pub fn identifier_compare_func(&self, identifier: &str) -> i32 {
        unsafe {
            ffi::tracker_resource_identifier_compare_func(
                self.to_glib_none().0,
                identifier.to_glib_none().0,
            )
        }
    }

    #[doc(alias = "tracker_resource_print_jsonld")]
    pub fn print_jsonld(&self, namespaces: Option<&NamespaceManager>) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::tracker_resource_print_jsonld(
                self.to_glib_none().0,
                namespaces.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "tracker_resource_print_sparql_update")]
    pub fn print_sparql_update(
        &self,
        namespaces: Option<&NamespaceManager>,
        graph_id: Option<&str>,
    ) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::tracker_resource_print_sparql_update(
                self.to_glib_none().0,
                namespaces.to_glib_none().0,
                graph_id.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "tracker_resource_print_turtle")]
    pub fn print_turtle(&self, namespaces: Option<&NamespaceManager>) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::tracker_resource_print_turtle(
                self.to_glib_none().0,
                namespaces.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "tracker_resource_serialize")]
    pub fn serialize(&self) -> Option<glib::Variant> {
        unsafe { from_glib_full(ffi::tracker_resource_serialize(self.to_glib_none().0)) }
    }

    #[doc(alias = "tracker_resource_set_boolean")]
    pub fn set_boolean(&self, property_uri: &str, value: bool) {
        unsafe {
            ffi::tracker_resource_set_boolean(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                value.into_glib(),
            );
        }
    }

    #[doc(alias = "tracker_resource_set_double")]
    pub fn set_double(&self, property_uri: &str, value: f64) {
        unsafe {
            ffi::tracker_resource_set_double(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                value,
            );
        }
    }

    #[doc(alias = "tracker_resource_set_gvalue")]
    pub fn set_gvalue(&self, property_uri: &str, value: &glib::Value) {
        unsafe {
            ffi::tracker_resource_set_gvalue(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                value.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "tracker_resource_set_identifier")]
    pub fn set_identifier(&self, identifier: Option<&str>) {
        unsafe {
            ffi::tracker_resource_set_identifier(
                self.to_glib_none().0,
                identifier.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "tracker_resource_set_int")]
    pub fn set_int(&self, property_uri: &str, value: i32) {
        unsafe {
            ffi::tracker_resource_set_int(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                value,
            );
        }
    }

    #[doc(alias = "tracker_resource_set_int64")]
    pub fn set_int64(&self, property_uri: &str, value: i64) {
        unsafe {
            ffi::tracker_resource_set_int64(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                value,
            );
        }
    }

    #[doc(alias = "tracker_resource_set_relation")]
    pub fn set_relation(&self, property_uri: &str, resource: &Resource) {
        unsafe {
            ffi::tracker_resource_set_relation(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                resource.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "tracker_resource_set_string")]
    pub fn set_string(&self, property_uri: &str, value: &str) {
        unsafe {
            ffi::tracker_resource_set_string(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                value.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "tracker_resource_set_take_relation")]
    pub fn set_take_relation(&self, property_uri: &str, resource: &Resource) {
        unsafe {
            ffi::tracker_resource_set_take_relation(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                resource.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "tracker_resource_set_uri")]
    pub fn set_uri(&self, property_uri: &str, value: &str) {
        unsafe {
            ffi::tracker_resource_set_uri(
                self.to_glib_none().0,
                property_uri.to_glib_none().0,
                value.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "tracker_resource_deserialize")]
    pub fn deserialize(variant: &glib::Variant) -> Option<Resource> {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::tracker_resource_deserialize(variant.to_glib_none().0)) }
    }

    #[doc(alias = "identifier")]
    pub fn connect_identifier_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_identifier_trampoline<F: Fn(&Resource) + 'static>(
            this: *mut ffi::TrackerResource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::identifier\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_identifier_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Resource`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct ResourceBuilder {
    identifier: Option<String>,
}

impl ResourceBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`ResourceBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Resource`].
    pub fn build(self) -> Resource {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref identifier) = self.identifier {
            properties.push(("identifier", identifier));
        }
        glib::Object::new::<Resource>(&properties)
            .expect("Failed to create an instance of Resource")
    }

    pub fn identifier(mut self, identifier: &str) -> Self {
        self.identifier = Some(identifier.to_string());
        self
    }
}

impl fmt::Display for Resource {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Resource")
    }
}
