// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ..
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::SparqlConnection;
use glib::object::Cast;
use glib::object::ObjectType as ObjectType_;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "TrackerNotifier")]
    pub struct Notifier(Object<ffi::TrackerNotifier, ffi::TrackerNotifierClass>);

    match fn {
        type_ => || ffi::tracker_notifier_get_type(),
    }
}

impl Notifier {
    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Notifier`] objects.
    ///
    /// This method returns an instance of [`NotifierBuilder`] which can be used to create [`Notifier`] objects.
    pub fn builder() -> NotifierBuilder {
        NotifierBuilder::default()
    }

    #[doc(alias = "tracker_notifier_signal_subscribe")]
    pub fn signal_subscribe(
        &self,
        connection: &gio::DBusConnection,
        service: &str,
        object_path: Option<&str>,
        graph: Option<&str>,
    ) -> u32 {
        unsafe {
            ffi::tracker_notifier_signal_subscribe(
                self.to_glib_none().0,
                connection.to_glib_none().0,
                service.to_glib_none().0,
                object_path.to_glib_none().0,
                graph.to_glib_none().0,
            )
        }
    }

    #[doc(alias = "tracker_notifier_signal_unsubscribe")]
    pub fn signal_unsubscribe(&self, handler_id: u32) {
        unsafe {
            ffi::tracker_notifier_signal_unsubscribe(self.to_glib_none().0, handler_id);
        }
    }

    pub fn connection(&self) -> Option<SparqlConnection> {
        unsafe {
            let mut value = glib::Value::from_type(<SparqlConnection as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"connection\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `connection` getter")
        }
    }

    //#[doc(alias = "events")]
    //pub fn connect_events<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    Empty ctype events: *.PtrArray TypeId { ns_id: 1, id: 11 }
    //}
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Notifier`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct NotifierBuilder {
    connection: Option<SparqlConnection>,
}

impl NotifierBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`NotifierBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Notifier`].
    pub fn build(self) -> Notifier {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref connection) = self.connection {
            properties.push(("connection", connection));
        }
        glib::Object::new::<Notifier>(&properties)
            .expect("Failed to create an instance of Notifier")
    }

    pub fn connection(mut self, connection: &SparqlConnection) -> Self {
        self.connection = Some(connection.clone());
        self
    }
}

impl fmt::Display for Notifier {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Notifier")
    }
}
