//! Procedural macro attributes for instrumenting functions with [`tracing`], in
//! HTTP use cases, following the [`opentelemetry`] conventions.
//!
use proc_macro::TokenStream;
use proc_macro_error::proc_macro_error;

/// Add tracing instrumentation attribute: Server-Send
///
/// # Example
///
/// ```ignore
/// use tracing_attributes_hyper::*;
///
/// #[server_send(level = tracing::Level::TRACE, name = "Server::encode", skip = [dst, msg])]
/// fn encode(mut msg: Encode<'_, Self::Outgoing>, dst: &mut Vec<u8>) -> crate::Result<Encoder> {
///     // ...
/// }
/// ```
///
///
#[allow(unused_variables)]
#[proc_macro_attribute]
#[proc_macro_error]
pub fn server_send(metadata: TokenStream, item: TokenStream) -> TokenStream {
    // let rust = quote::quote! {
    //    panic!("This macro is a placeholder for a tracing attribute plugin.  See the `examples` folder of the tracing-attributes-hyper crate.");
    // };
    // rust.into()
    item
}
