# `tracing-attributes-hyper`

This crate is in development and should not be used until version `> 0.0`

A proc-macro crate providing [Tracing] placeholder spans in [Hyper].

Many projects prefer or require specific structured log data is produced
by their application. In addition, bespoke tracing logic often cannot be
published to a registry.

Hyper does not impose trace data preferences on your application.
Hyper does not require your tracing logic be published.

Instead, this crate serves as a placeholder that your application
will:

1. in the `[dependencies]` stanza: redirect to a published crate, or
2. in the `[patch]` stanza: redirect to an published crate (e.g. github, etc.).

This pattern repurposes Cargo's `[patch]` (and `[dependencies]`) from
[overiding dependencies], to serve as a compile-time plugin system for
[Hyper] tracing.

Hyper uses a subset of the [`tracing-attributes-http`] crate, so this is a
functional default.

## Examples

### Published

If the Hyper tracing plugin has been published to [crates.io]:

```toml
[dependencies]
tracing-attributes-hyper = { version = "0.2", package = "tracing-attributes-http" }
```

### Unpublished

Plug in unpublished Hyper tracing logic uniformly across all your projects (see the note below),
[stabilized](https://doc.rust-lang.org/cargo/reference/unstable.html#patch-in-config)
in Rust version >= `1.56`:

```toml
# ~/.cargo/config.toml
# Your Cargo configuration details

[patch.crates-io]
tracing-attributes-hyper = {
    git = https://github.com/taqtiqa-mark/tracing-attributes-http,
    features = ["otel"]
  }
```

Plug in unpublished tracing logic specific to one project:

```toml
# Cargo.toml
[package]
# Your Hyper based application details

[patch.crates-io]
tracing-attributes-hyper = {
    git = https://github.com/taqtiqa-mark/tracing-attributes-http,
    features = ["otel", "http-optional"]
  }
```

## [NOTE]

> If a given dependency is patched both in a cargo configuration file and a
> Cargo.toml file, the patch in the configuration file is used.
> If multiple configuration files patch the same dependency, standard cargo
> configuration merging is used, which prefers the value defined closest to
> the current directory, with $HOME/.cargo/config.toml taking the lowest
> precedence.

### Development

To publish the crate:

```
cargo login <api-token>
cargo publish
cargo publish --dry-run
```

## License

Licensed under either of

- Apache License, Version 2.0 ([LICENSE-APACHE](LICENSE-APACHE) or
  http://www.apache.org/licenses/LICENSE-2.0)

- MIT license ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)

at your option.

### Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 license, shall be
licensed as above, without any additional terms or conditions.

[crates.io]: https://crates.io
[Hyper]: https://hyper.rs/
[Tracing]: https://tracing.rs/tracing/
[`patch`]: (https://doc.rust-lang.org/cargo/reference/overriding-dependencies.html#the-patch-section)
[NOTE]: https://doc.rust-lang.org/nightly/cargo/reference/config.html#patch
[overriding dependencies]: https://doc.rust-lang.org/cargo/reference/overriding-dependencies.html
[`tracing-attributes-http`]: https://docs.rs/tracing-attributes-http/latest/tracing_attributes_http/
