//! Provides entity handle, entry for the specific entity in the world.

pub use entry::Entry;
pub(crate) use registry::Registry;
pub use view_one::{ViewOne, ViewOneMut};

pub(crate) mod fetch;

mod entry;
mod registry;
mod view_one;
mod viewable;

slotmap::new_key_type! {
    /// Unique handle of the entity in ECS.
    ///
    /// Similarly as in arenas, you can store it anywhere
    /// to obtain components attached to the entity.
    pub struct Entity;
}
