pub mod postgres {
    use postgres::{Client, Error, NoTls};

    #[macro_export]
    macro_rules! db_connect {
        () => {
            "postgresql://stepanov:postgres@localhost/postgres"
        };
    }

    pub fn create_todo_table() -> Result<(), Error> {
        let mut client = Client::connect(db_connect!(), NoTls).unwrap();
        client
            .batch_execute(
                "
                CREATE TABLE IF NOT EXISTS todo_table (
                    task text NOT NULL,
                    mark timestamp default current_timestamp
                )
            ",
            )
            .unwrap();
        Ok(())
    }
}
