pub mod todo_app {
    use eframe::{egui, epi};
    use postgres::{Client, NoTls};

    /// We derive Deserialize/Serialize so we can persist app state on shutdown.
    #[cfg_attr(feature = "persistence", derive(serde::Deserialize, serde::Serialize))]
    #[cfg_attr(feature = "persistence", serde(default))] // if we add new fields, give them default values when deserializing old state
    pub struct TemplateApp {
        // Example stuff:
        input_text: String,

        // this how you opt-out of serialization of a member
        #[cfg_attr(feature = "persistence", serde(skip))]
        visual_mode: bool,
    }

    impl Default for TemplateApp {
        fn default() -> Self {
            Self {
                // Example stuff:
                input_text: "To make a bot".to_owned(),
                visual_mode: false,
            }
        }
    }

    impl epi::App for TemplateApp {
        fn name(&self) -> &str {
            "eframe template"
        }

        /// Called once before the first frame.
        fn setup(
            &mut self,
            _ctx: &egui::CtxRef,
            _frame: &epi::Frame,
            _storage: Option<&dyn epi::Storage>,
        ) {
            // Load previous app state (if any).
            // Note that you must enable the `persistence` feature for this to work.
            #[cfg(feature = "persistence")]
            if let Some(storage) = _storage {
                *self = epi::get_value(storage, epi::APP_KEY).unwrap_or_default()
            }
        }

        /// Called by the frame work to save state before shutdown.
        /// Note that you must enable the `persistence` feature for this to work.
        #[cfg(feature = "persistence")]
        fn save(&mut self, storage: &mut dyn epi::Storage) {
            epi::set_value(storage, epi::APP_KEY, self);
        }

        /// Called each time the UI needs repainting, which may be many times per second.
        /// Put your widgets into a `SidePanel`, `TopPanel`, `CentralPanel`, `Window` or `Area`.
        fn update(&mut self, ctx: &egui::CtxRef, frame: &epi::Frame) {
            let mut client = Client::connect(crate::db_connect!(), NoTls).unwrap();

            let Self {
                input_text,
                visual_mode,
            } = self;

            // Examples of how to create different panels and windows.
            // Pick whichever suits you.
            // Tip: a good default choice is to just keep the `CentralPanel`.
            // For inspiration and more examples, go to https://emilk.github.io/egui

            egui::TopBottomPanel::top("top_panel").show(ctx, |ui| {
                // The top panel is often a good place for a menu bar:
                egui::menu::bar(ui, |ui| {
                    ui.menu_button("File", |ui| {
                        if ui.button("Quit").clicked() {
                            frame.quit();
                        }
                    });
                });
            });

            egui::CentralPanel::default().show(ctx, |ui| {
                // The central panel the region left after adding TopPanel's and SidePanel's

                ui.horizontal_wrapped(|ui| {
                    ui.spacing_mut().item_spacing.x = 0.0; // remove spacing between widgets
                    // `radio_value` also works for enums, integers, and more.
                    ui.radio_value(visual_mode, false, "Dark mode");
                    ui.radio_value(visual_mode, true, "Light mode");
                    if visual_mode == &mut true {
                        ctx.set_visuals(egui::Visuals::light());
                    } else {
                        ctx.set_visuals(egui::Visuals::dark());
                    }
                });

                ui.vertical_centered_justified(|ui| {
                    ui.heading("Total Recall");
                    ui.heading("");
                    ui.separator();
                });

                ui.horizontal(|ui| {
                    ui.label("Write your task here for add in list: ");
                    ui.text_edit_multiline(input_text);
                    ui.vertical(|ui| {
                        if ui.button("Add task in list").clicked() {
                            let input_task = input_text;
                            client
                                .execute("INSERT INTO todo_table (task) VALUES ($1)", &[input_task])
                                .unwrap();
                        }
                        if ui.button("Delete all task").clicked() {
                            client.batch_execute("drop table todo_table").unwrap();
                            client
                                .batch_execute(
                                    "
                                CREATE TABLE todo_table (
                                    task text NOT NULL,
                                    mark timestamp default current_timestamp
                                )
                            ",
                                )
                                .unwrap();
                        }
                    });

                });

                ui.vertical(|ui| {
                    ui.separator();
                    ui.heading("Your TODO list:");
                    ui.label("");
                    egui::ScrollArea::vertical().show(ui, |ui| {
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 1", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 1)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 2", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 2)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 3", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 3)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 4", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 4)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 5", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 5)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 6", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 6)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 7", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 7)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 8", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 8)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 9", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 9)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 10", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 10)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 11", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 11)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 12", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 12)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 13", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 13)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 14", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 14)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 15", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 15)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 16", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 16)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 17", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 17)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 18", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 18)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 19", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 19)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 20", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 20)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 21", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 21)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 22", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 22)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 23", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 24)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 25", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 25)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 26", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 26)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 27", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 27)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 28", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 28)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                        ui.horizontal(|ui| {
                            for row in client
                                .query("SELECT task, mark FROM todo_table ORDER BY mark DESC LIMIT 1 OFFSET 29", &[])
                                .unwrap()
                            {
                                let output_task: &str = row.get(0);
                                if output_task != "" {
                                    if ui.button("Delete").clicked() {
                                        client
                                            .batch_execute("delete from todo_table where mark in (select mark from todo_table order by mark desc limit 1 offset 29)").unwrap();
                                    }
                                }
                                ui.label(output_task.to_owned());
                            }
                        });
                    });
                });

                ui.with_layout(egui::Layout::bottom_up(egui::Align::LEFT), |ui| {
                    ui.horizontal(|ui| {
                        ui.spacing_mut().item_spacing.x = 0.0;
                        ui.label("powered by ");
                        ui.hyperlink_to("Stepanov Denis", "https://github.com/stepanov-denis");
                    });
                });
            });

            if false {
                egui::Window::new("Window").show(ctx, |ui| {
                    ui.label("Windows can be moved by dragging them.");
                    ui.label("They are automatically sized based on contents.");
                    ui.label("You can turn on resizing and scrolling if you like.");
                    ui.label("You would normally chose either panels OR windows.");
                });
            }
        }
    }

    pub fn gui() {
        let options = eframe::NativeOptions::default();
        eframe::run_native(Box::new(TemplateApp::default()), options);
    }
}
