window.search = {"doc_urls":["1-introduction.html#toql---a-friendly-and-productive-orm","1-introduction.html#trivia","2-concept.html#concept","2-concept.html#quickstart","3-api/1-introduction.html#the-toql-api","3-api/1-introduction.html#creating-the-backend","3-api/2-load.html#loading","3-api/3-query-type.html#the-query-type","3-api/3-query-type.html#the-query-macro","3-api/3-query-type.html#working-with-keys","3-api/3-query-type.html#the--intoquery--trait","3-api/3-query-type.html#the--querywith--trait","3-api/3-query-type.html#parsing-queries","3-api/4-insert.html#inserts","3-api/4-insert.html#the-paths-macro","3-api/4-insert.html#skipping-values","3-api/4-insert.html#partial-tables","3-api/4-insert.html#key-dependencies","3-api/5-update.html#updates","3-api/5-update.html#the-fields-macro","3-api/5-update.html#example-updating-a-vec-with-new-items","3-api/6-delete.html#deletes","3-api/6-delete.html#cascading","3-api/7-writing-functions.html#writing-functions","3-api/7-writing-functions.html#passing-the-database","4-derive/1-introduction.html#the-toql-derive","4-derive/1-introduction.html#example","4-derive/2-fields.html#fields","4-derive/2-fields.html#renaming-tables-and-columns","4-derive/2-fields.html#toql-query-fields","4-derive/2-fields.html#exclusion","4-derive/3-optional-fields.html#optional-fields","4-derive/3-optional-fields.html#example","4-derive/3-optional-fields.html#preselection-and-joins","4-derive/3-optional-fields.html#preselection-on-parent-paths","4-derive/4-sql-expressions.html#sql-expressions","4-derive/4-sql-expressions.html#other-uses-of-raw-sql","4-derive/5-field-handlers.html#field-handlers","4-derive/5-field-handlers.html#filter-on-fields","4-derive/6-joins.html#joins","4-derive/6-joins.html#renaming-joined-columns","4-derive/6-joins.html#custom-on-predicate","4-derive/6-joins.html#example-with-on_aux_param","4-derive/6-joins.html#insert--update-implications","4-derive/6-joins.html#the-join-struct","4-derive/6-joins.html#sidenote-for-sql-generation","4-derive/7-join-handlers.html#join-handlers","4-derive/8-partial-tables.html#partial-tables","4-derive/9-merges.html#merges","4-derive/9-merges.html#renaming-merge-columns","4-derive/9-merges.html#no-association-table-with--join_sql","4-derive/9-merges.html#no-association-table-with--toqlforeign_key","4-derive/10-keys.html#keys","4-derive/10-keys.html#joins","4-derive/10-keys.html#generated-key-struct","4-derive/10-keys.html#unkeyable-fields","4-derive/11-insert.html#insert","4-derive/11-insert.html#default-values","4-derive/11-insert.html#insert-behaviour","4-derive/12-update.html#update","4-derive/13-selections.html#selections","4-derive/14-predicates.html#predicates","4-derive/14-predicates.html#reference","4-derive/15-predicate-handlers.html#predicate-handlers","4-derive/16-roles.html#roles","4-derive/17-reference.html#toql-derive-reference","4-derive/17-reference.html#attributes-for-structs","4-derive/17-reference.html#attributes-for-fields","5-query-language/1-introduction.html#the-query-language","5-query-language/2-select.html#selecting-fields","5-query-language/2-select.html#wildcards","5-query-language/2-select.html#role-restricted-selection","5-query-language/3-order.html#ordering-fields","5-query-language/3-order.html#ordering-priority","5-query-language/4-filter.html#filtering-fields","5-query-language/4-filter.html#filter-operations","5-query-language/4-filter.html#custom-functions","5-query-language/4-filter.html#joining-filters","5-query-language/4-filter.html#argument-types","5-query-language/5-selections.html#selections","5-query-language/5-selections.html#restriction-on-selection-names","5-query-language/6-predicates.html#predicates","6-appendix/1-introduction.html#appendix","6-appendix/2-mysql-enums.html#mysql-enums","6-appendix/3-row-access-control.html#row-access-control","6-appendix/4-serde.html#serde","6-appendix/4-serde.html#serializing","6-appendix/4-serde.html#serialize-example","6-appendix/4-serde.html#deserializing","6-appendix/4-serde.html#deserialize-example","6-appendix/5-debugging-toql.html#debugging-toql","6-appendix/5-debugging-toql.html#support"],"index":{"documentStore":{"docInfo":{"0":{"body":100,"breadcrumbs":4,"title":4},"1":{"body":50,"breadcrumbs":1,"title":1},"10":{"body":130,"breadcrumbs":3,"title":2},"11":{"body":63,"breadcrumbs":3,"title":2},"12":{"body":27,"breadcrumbs":3,"title":2},"13":{"body":58,"breadcrumbs":2,"title":1},"14":{"body":90,"breadcrumbs":3,"title":2},"15":{"body":18,"breadcrumbs":3,"title":2},"16":{"body":29,"breadcrumbs":3,"title":2},"17":{"body":8,"breadcrumbs":3,"title":2},"18":{"body":30,"breadcrumbs":2,"title":1},"19":{"body":129,"breadcrumbs":3,"title":2},"2":{"body":97,"breadcrumbs":1,"title":1},"20":{"body":128,"breadcrumbs":6,"title":5},"21":{"body":55,"breadcrumbs":2,"title":1},"22":{"body":25,"breadcrumbs":2,"title":1},"23":{"body":19,"breadcrumbs":3,"title":2},"24":{"body":72,"breadcrumbs":3,"title":2},"25":{"body":34,"breadcrumbs":2,"title":2},"26":{"body":37,"breadcrumbs":1,"title":1},"27":{"body":27,"breadcrumbs":3,"title":1},"28":{"body":80,"breadcrumbs":5,"title":3},"29":{"body":27,"breadcrumbs":5,"title":3},"3":{"body":13,"breadcrumbs":1,"title":1},"30":{"body":52,"breadcrumbs":3,"title":1},"31":{"body":15,"breadcrumbs":4,"title":2},"32":{"body":44,"breadcrumbs":3,"title":1},"33":{"body":64,"breadcrumbs":4,"title":2},"34":{"body":41,"breadcrumbs":5,"title":3},"35":{"body":107,"breadcrumbs":4,"title":2},"36":{"body":7,"breadcrumbs":5,"title":3},"37":{"body":21,"breadcrumbs":4,"title":2},"38":{"body":116,"breadcrumbs":4,"title":2},"39":{"body":63,"breadcrumbs":3,"title":1},"4":{"body":49,"breadcrumbs":2,"title":2},"40":{"body":33,"breadcrumbs":5,"title":3},"41":{"body":101,"breadcrumbs":4,"title":2},"42":{"body":101,"breadcrumbs":4,"title":2},"43":{"body":22,"breadcrumbs":5,"title":3},"44":{"body":101,"breadcrumbs":4,"title":2},"45":{"body":46,"breadcrumbs":5,"title":3},"46":{"body":64,"breadcrumbs":4,"title":2},"47":{"body":116,"breadcrumbs":4,"title":2},"48":{"body":53,"breadcrumbs":3,"title":1},"49":{"body":17,"breadcrumbs":5,"title":3},"5":{"body":152,"breadcrumbs":2,"title":2},"50":{"body":144,"breadcrumbs":5,"title":3},"51":{"body":93,"breadcrumbs":5,"title":3},"52":{"body":45,"breadcrumbs":3,"title":1},"53":{"body":59,"breadcrumbs":3,"title":1},"54":{"body":50,"breadcrumbs":5,"title":3},"55":{"body":15,"breadcrumbs":4,"title":2},"56":{"body":11,"breadcrumbs":3,"title":1},"57":{"body":23,"breadcrumbs":4,"title":2},"58":{"body":98,"breadcrumbs":4,"title":2},"59":{"body":109,"breadcrumbs":3,"title":1},"6":{"body":293,"breadcrumbs":2,"title":1},"60":{"body":77,"breadcrumbs":3,"title":1},"61":{"body":79,"breadcrumbs":3,"title":1},"62":{"body":89,"breadcrumbs":3,"title":1},"63":{"body":116,"breadcrumbs":4,"title":2},"64":{"body":68,"breadcrumbs":3,"title":1},"65":{"body":12,"breadcrumbs":5,"title":3},"66":{"body":76,"breadcrumbs":4,"title":2},"67":{"body":115,"breadcrumbs":4,"title":2},"68":{"body":58,"breadcrumbs":2,"title":2},"69":{"body":69,"breadcrumbs":4,"title":2},"7":{"body":29,"breadcrumbs":3,"title":2},"70":{"body":26,"breadcrumbs":3,"title":1},"71":{"body":18,"breadcrumbs":5,"title":3},"72":{"body":15,"breadcrumbs":4,"title":2},"73":{"body":31,"breadcrumbs":4,"title":2},"74":{"body":64,"breadcrumbs":4,"title":2},"75":{"body":99,"breadcrumbs":4,"title":2},"76":{"body":12,"breadcrumbs":4,"title":2},"77":{"body":75,"breadcrumbs":4,"title":2},"78":{"body":60,"breadcrumbs":4,"title":2},"79":{"body":60,"breadcrumbs":3,"title":1},"8":{"body":116,"breadcrumbs":3,"title":2},"80":{"body":15,"breadcrumbs":5,"title":3},"81":{"body":38,"breadcrumbs":3,"title":1},"82":{"body":8,"breadcrumbs":1,"title":1},"83":{"body":64,"breadcrumbs":3,"title":2},"84":{"body":279,"breadcrumbs":4,"title":3},"85":{"body":16,"breadcrumbs":2,"title":1},"86":{"body":9,"breadcrumbs":2,"title":1},"87":{"body":11,"breadcrumbs":3,"title":2},"88":{"body":9,"breadcrumbs":2,"title":1},"89":{"body":118,"breadcrumbs":3,"title":2},"9":{"body":153,"breadcrumbs":3,"title":2},"90":{"body":92,"breadcrumbs":3,"title":2},"91":{"body":4,"breadcrumbs":2,"title":1}},"docs":{"0":{"body":"Bollard by the Sea by Gábor Szakács (Public Domain) Toql is an ORM for async databases that features Translation between Rust structs and database tables. Can load and modify nested structs. A unique dead simple query language, suitable for web clients. Different table aliases from long and readable to tiny and fast. Prepared statements against SQL injection. Support for raw SQL for full database power. Support for role based access. Highly customizable through user defined parameters, query functions, field handlers, etc. Compile time safety for queries, fields and path names. No unsafe Rust code. Tested on real world scenario. This guide will explain you how to use Toql in your own project. Toql is free and open source software, distributed under a dual license of MIT and Apache. The code is available on Github . Check out the API for technical details.","breadcrumbs":"Toql - A friendly and productive ORM","id":"0","title":"Toql - A friendly and productive ORM"},"1":{"body":"Toql is pronounced to-cue-ell with o as in object. Toql stands for Transfer Object Query Language and refers to the query language that is unique to this ORM. In a sense though it's a missleading name, because Toql together with Serde effectively avoid the need for data transfer objects (DTO): you pass your model directly. The project's mascot is a bollard, because Toql pronounced in allemanic / swiss german sounds like Toggel : A funny word that can colloquially be used for bollards.","breadcrumbs":"Trivia","id":"1","title":"Trivia"},"10":{"body":"In the example above the query q3 is build with a UserKey . This is possible because UserKey implements Into<Query<User>> . You can also implement this trait for you own types. Let's assume a book category. Example 1: Adding an enum filter to the query use toql::prelude::Query; enum BookCategory { Novel, Cartoon\n}\nimpl Into<Query<Book> for BookCategory { pub fn info(&self) { query!(Book, \"category eq ?\", match self { Novel => \"NOVEL\", Cartoon => \"CARTOON\" }) }\n} Now use it like this let q = query!(Book, \"*, {}\", BookCategory::Novel); Example 2: Adding an authorization filter to the query use toql::prelude::{QueryWith, Query, Field}\nstruct Auth { user_id: u64\n}\nimpl Into<Query<Book>> for Auth { pub fn into(self) -> Query<Book> { // This time with the builder methods for educational reasons // In production do this query!(User, \"authorId eq ?\", self.user_id) Query::from(Book::fields().author_id().eq(self.user_id)) }\n} You may want trade typesafety for more flexibility. See the example above again, this time with the Field type. use toql::prelude::{ Query, Field}\nstruct Auth { author_id: u64\n}\nimpl<T> Into<Query<T>> for Auth { pub fn into(&self) -> Query<T>{ Query::from(Field::from(\"authorId\").eq(self.author_id)) }\n} Wrong field names in Field::from do not show up at compile time, but at runtime. You can use both examples like so use toql::prelude::query;\nlet auth = Auth {author: 5};\nlet q = query!(Book, \"*, {}\", auth);","breadcrumbs":"Api » The Into<Query> trait","id":"10","title":"The Into<Query> trait"},"11":{"body":"The query! macro produces a Query type and can further be altered using all methods from that type. One interesting method is with . It takes a QueryWith trait that can be implemented for any custom type to enhance the query. This is more powerful than Into<Query> because you can also access auxiliary parameters. Aux params can be used in SQL expressions. See here more information. struct Config { limit_pages: u64\n}\nimpl QueryWith for Config { pub fn with(&self, query: Query<T>) { query.aux_param(\"limit_pages\", self.limit_pages) }\n} This can now be used like so: use toql::prelude::query;\nlet config = Config {limit_pages: 200};\nlet k = UserKey::from(5);\nlet q = query!(User, \"*, {}\", k.to_query()).with(config);","breadcrumbs":"Api » The QueryWith trait","id":"11","title":"The QueryWith trait"},"12":{"body":"Use the query parser to turn a string into a Query type. Only syntax errors will returns as errors, wrong field names or paths will be rejected later when using the query. use toql::prelude::Parser; let s = \"*, id eq 5\"; let q = QueryParser::parse::<User>(s).unwrap();","breadcrumbs":"Api » Parsing queries","id":"12","title":"Parsing queries"},"13":{"body":"There are two insert functions: insert_one , and insert_many . The are used like so: use toql::prelude::{ToqlApi, paths}; let u = User {id:0, title: \"hello\".to_string(), adress: None}; toql.insert_one(&mut u, paths!(top)).await?;\ntoql.insert_one(&mut u, paths!(User, \"\")).await?; toql.insert_many(&[&mut u], paths!(top)).await?; In the example above the first insert_one will insert u into the database, load back the generated id and sets it on u . The second insert_one makes a copy of u and again refreshes its id field. Optional fields that are None will insert the default value of the database. See the mapping for details.","breadcrumbs":"Api » Inserts","id":"13","title":"Inserts"},"14":{"body":"The paths! macro compiles a path list. Any invalid path will show up at compile time. The insert functions insert all referenced joins and merges from such a path list. Let's assume a struct User that has a Vec of books with each book joining a publisher . A path list like paths!(User, \"books_publisher\") will insert all fields from User . if the id of User is marked as auto key , Toql will load the generated id from the database and update User and the composite key in books . insert all fields the the joined publisher . handle the id of publisher like the one in books . insert the merged books with the correct composite keys. Cool stuff! If you only want to insert a publisher , then you must call insert on a publisher object. The paths in the list may overlap. In the path list paths!(User, \"books_publisher, books_printedBy\") book appears twice. No problem it will only be inserted once.","breadcrumbs":"Api » The paths! macro","id":"14","title":"The paths! macro"},"15":{"body":"When inserting a struct some fields are excluded Fields that map to an SQL expression Fields or structs with the atribute skip_mut Joins with custom ON predicate Merges with custom sql_join","breadcrumbs":"Api » Skipping values","id":"15","title":"Skipping values"},"16":{"body":"It is possible to split up a table into multiple tables sharing the same primary key. See here . If a path in the path list refers to a struct that contains joins marked as partial table then these joins will also be inserted. There is no need to mention these dependencies in the path list.","breadcrumbs":"Api » Partial tables","id":"16","title":"Partial tables"},"17":{"body":"The order of SQL execution is based on key dependencies between structs.","breadcrumbs":"Api » Key dependencies","id":"17","title":"Key dependencies"},"18":{"body":"There are two update functions: update_one and update_many . They are used like so: use toql::prelude::{ToqlApi, fields}; let u = User {id:27, title: \"hello\".to_string(), address: None}; toql.update_one(&mut u, fields!(top))?;\ntoql.update_one(&mut u, fields!(User, \"*\"))?; toql.update_many(&[&mut u], fields!(top))?; In the example above all three statements do the same.","breadcrumbs":"Api » Updates","id":"18","title":"Updates"},"19":{"body":"The fields! macro compiles a list of fields. Any invalid path or field name shows up at compile time. The update function will consider all fields from the field list to update. Optional fields will only be updated if they contain some value. See the mapping for details. Joins You can update only the foreign key of a join or field from the join. Consider this field list: let f = fields!(User, \"*, address, address_*, address_id\") With * we consider all fields from User for updating, address will update the foreign key to Address in the User table, address_* will update all simple fields in table Address and finally address_id is ignored, since keys cannot be updated. Notice in the example above address is actually a duplicate, because foreign keys are included in * . It's just mentioned explicitly for the purpose of learning. Merges Updates can either update existing structs in a Vec or insert new structs in the Vec and delete removed structs. Consider this field list: let f = fields!(User, \"*, books, books_*\") With * we consider all simple fields from User for updating (this excludes merges), books resizes the Vec : It deletes all books that are linked to the user but are not found in the books vector and it inserts new book (toghether with possible partial joins ). books_* will update all simple fields in the existing books .","breadcrumbs":"Api » The fields! macro","id":"19","title":"The fields! macro"},"2":{"body":"Toql is a ORM that aim to boost your developer comfort and speed when working with databases. To use it you must derive Toql for all structs that represent a table in your database: The fields of those structs represent either columns, SQL expressions or relationships to other tables. The fields also determine the field name or in case of a relationship the path name in the Toql query A struct may map only some columns of a table and also multiple structs may refer to the same table. Structs are merly 'views' to a table. A derived struct can then be inserted, updated, deleted and loaded from your database. To do that you must call the Toql API functions with a query string or just a list of fields or paths. Here the typical flow in a web environment: A web client sends a Toql query to the REST Server. The server uses Toql to parse the query and create SQL statements. Toql sends the SQL to the database then deserializes the resulting rows into Rust structs. The server sends these structs to the client.","breadcrumbs":"Concept","id":"2","title":"Concept"},"20":{"body":"#[derive(Debug, PartialEq, Toql)] struct Book { #[toql(key)] id: u64, #[toql(key)] user_id: u64, title: Option<String> } #[derive(Debug, PartialEq, Toql)] #[toql(auto_key = true)] struct User { #[toql(key)] id: u64, name: Option<String>, #[toql(merge())] books : Option<Vec<Book>> } let u = User { id: 27, title: Some(\"Joe Pencil\"), books: Some(vec![ Book{ id: 100, user_id: 0, // Invalid key title: Some(\"King Kong\".to_string()) }, Book{ id: 200, user_id: 27, title: Some(\"Batman\".to_string()) } ]) } toql.update_one(&mut u, fields!(\"*, books, books_*\")).await?; To mark new books, add them with an invalid key. A value of 0 or an empty string '' is considered invalid. Normally databases start counting indexes from 1 and some databases consider an empty string like null, which is also forbidden as primary key. So this idea of invalid key should normally work, however check with you database. In rare cases where this does not work. Insert and delete your Vec manually, using the ToqlApi functions. In the example above the first book has an invalid composite key ( id , user_id ), because user_id is 0 . Toql will notice that and insert a new book (with the correct user_id of 27 ). From the second book with id 200 the field title will be updated.","breadcrumbs":"Api » Example: Updating a Vec with new items.","id":"20","title":"Example: Updating a Vec with new items."},"21":{"body":"There are two delete functions: delete_one , and delete_many . Both functions take a predicate and delete all rows that match that predicate. delete_one takes a key or entity. It will build a filter predicate from that and delete the row that coresponds to the key. delete_many builds a predicate from the filters of the Query argument. Field filters and predicates and considered, where as field selects and selections in the query are ignored. See the query language for details. use toql::prelude::ToqlApi; toql.delete_one(UserKey::from(5))?; let u = User {id: 5};\ntoql.delete_one(u).await?; toql.delete_many(query!(User, \"id eq 5\")).await?;","breadcrumbs":"Api » Deletes","id":"21","title":"Deletes"},"22":{"body":"delete does not do any cascading by itself. It just deletes rows from a single table. To cascade your deletes you must configure your database relations and tell the database what to do with your joined rows: Delete them too or just set the foreign key to NULL. Check the manual for MySQL Postgres","breadcrumbs":"Api » Cascading","id":"22","title":"Cascading"},"23":{"body":"In bigger projects you need to structure your code with functions. There as two common ways, each with different tradeoffs Pass the database driver to the function Pass ToqlApi to the function","breadcrumbs":"Api » Writing functions","id":"23","title":"Writing functions"},"24":{"body":"If you decide to pass the database you give up on database independence, but less trait bounds are needed: For MySQL this looks like this: ``rust use toql::prelude::ToqlApi; use toql_mysql_async::prelude::{MySqlAsync, Queryable}; fn do_stuff(toql: &mut MySqlAsync<'_,C>) where C:Queryable -> Resulty { let q = query!(...) let users = toql.load_many(&q).await?; toql.insert_many(users, paths!(top)).await?; toql.update_many(users, fields!(top)).await?; toql.delete_many(q).await?; } The `Queryable` trait makes the `MySqlAsync` work with a connection or a transaction. ## Database independed functions It's also possible to pass a struct that implements `ToqlApi`. However this requires more trait bounds to satisfy the bounds on `ToqlApi`.\nUnfortunately rust Rust compiler has a problem with [associated type bounds](https://rust-lang.github.io/rfcs/2289-associated-type-bounds.html), so it looks more complicated than it had to be.","breadcrumbs":"Api » Passing the database","id":"24","title":"Passing the database"},"25":{"body":"A struct must derive Toql . Only on a derived struct any function from the ToqlApi can be called. This derive builds a lot of code. This includes Mapping of Toql fields to struct fields and database columns or expressions. Creating field methods for the query builder. Handling relationships through joins and merges. Creating Key structs.","breadcrumbs":"The Toql derive","id":"25","title":"The Toql derive"},"26":{"body":"With this simple code #[derive(Toql)] struct User { #[toql(key)] id: u32, name: Option<String>\n} We can now do the following use toql::mysql::load_one; // Load function from derive\nuse toql::mysql::update_one; // Update function from derive let toql = --snip--\nlet cache = let q = query!(User, \"id eq 5\"); let mut user = toql.load_one(&q); user.age = Some(16);\ntoql.update_one(&mut user);","breadcrumbs":"Example","id":"26","title":"Example"},"27":{"body":"Struct fields are mapped to Toql query fields and database columns by default in a predictable way: Table names are UpperCamelCase. Column names are snake_case. Toql query fields are lowerCamelCase. Toql query paths are lowerCamelCase, separated with an underscore.","breadcrumbs":"The Toql derive » Fields","id":"27","title":"Fields"},"28":{"body":"To adjust the default naming to an existing database scheme use the attributes tables and columns for a renaming scheme or table and column for explicit name. Supported renaming schemes are CamelCase snake_case SHOUTY_SNAKE_CASE mixedCase Renaming scheme example #[derive(Toql)]\n#[toql(tables=\"SHOUTY_SNAKE_CASE\", columns=\"UpperCase\")]\nstruct User { #[toql(key)] user_id: u32 full_name: String,\n} is translated into SELECT t0.UserId, t0.FullName FROM USER_REF t0 Explicit naming example Use table an the struct and column on the fields to set a name. #[derive(Toql)]\n#[toql(table=\"User\")]\nstruct UserRef { #[toql(key, column=\"id\")] user_id: u32, full_name: String,\n} is translated into SELECT t0.id, t0.full_name FROM User t0 Use column also when mapping a field, that is a SQL keyword. Notice the back ticks: #[toql(column=\"`order`\")] order: u32,","breadcrumbs":"The Toql derive » Renaming tables and columns","id":"28","title":"Renaming tables and columns"},"29":{"body":"Toql query fields on a struct are always mixed case, while dependencies are separated with an unserscore. #[derive(Toql)]\n#[toql(table=\"User\")]\nstruct UserRef { #[toql(key, column=\"id\")] id: u32 full_name: String, #[toql(join())] county: Country\n} is referred to as id, fullName, country_id","breadcrumbs":"The Toql derive » Toql query fields","id":"29","title":"Toql query fields"},"3":{"body":"There is full featured REST server based on Rocket, Toql and MySQL. It can be used as a playground or starting point for own projects.","breadcrumbs":"Quickstart","id":"3","title":"Quickstart"},"30":{"body":"Field can be excluded in several ways skip excludes a field completely from the table, use for non-db fields. skip_mut ensures a field is never updated, automatically added for keys and SQL expressions. skip_wildcard removes a field from default wildcard selection , use for expensive SQL expressions or soft hiding. #[derive(Toql)]\n#[toql(table=\"User\")]\nstruct UserRef { #[toql(key, column=\"id\")] id: u32 full_name: String, #[toql(skip)] value: String, #[toql(skip_mut, skip_wildcard)] county: Country\n}","breadcrumbs":"The Toql derive » Exclusion","id":"30","title":"Exclusion"},"31":{"body":"A Toql query can select individual fields from a struct. However fields must be Option for this, otherwise they will always be selected in the SQL statement, regardless of the query.","breadcrumbs":"The Toql derive » Optional fields","id":"31","title":"Optional fields"},"32":{"body":"#[derive(Toql)] struct User { #[toql(key)] id: u32, // Always selected in SQL (keys must not be optional) age: u8, // Always selected in SQL firstname: Option<String>\t// Selectable field of non nullable column middlename: Option<Option<String>>// Selectable field of nullable column #[toql(preselect)] lastname: Option<String>\t// Always selected in SQL, nullable column } You noticed it: Nullable columns that should always be selected must be annotated with preselect .","breadcrumbs":"The Toql derive » Example:","id":"32","title":"Example:"},"33":{"body":"Preselected fields on joined structs are selected, if A join itself is preselected or at least one field on that join is selected Preselection example #[derive(Toql)] struct User { #[toql(key)] id: u32, #[toql(join())] native_language: Language,\t// Preselected inner join #[toql(join())] foreign_language: Option<Option<Language>>, } #[derive(Toql)] struct Language { #[toql(key)] id: u32, code: Option<String> } Above id in User is always selected, because it's not Option . As native_language is a preselected (inner) join, its id will also always be selected. But on the contrary foreign_language is a selectable (left) join. id will only be selected if the query requests any other field from that join. For example with foreignLanguage_code .","breadcrumbs":"The Toql derive » Preselection and joins","id":"33","title":"Preselection and joins"},"34":{"body":"One more thing: If a field on a related struct is selected, all preselected fields from the path line will be selected too. Lets assume we have a user that has an address , which contains country information. The query address_country_code would therefore select code from the table Country select all preseleted fields from table Country select all preseleted fields from table Address select all preseleted fields from table User","breadcrumbs":"The Toql derive » Preselection on parent paths","id":"34","title":"Preselection on parent paths"},"35":{"body":"Toql is an SQL friendly ORM. Instead of mapping a struct field to a column you can also map it to a raw SQL expression. There are small syntax enhancements to work with aliases and auxiliary parameters. Alias axample #[derive(Toql)]\nstruct User { #[toql(key)] id: u64, #[toql(sql=\"(SELECT COUNT(*) FROM Books b WHERE b.author_id = ..id)\")] number_of_book:u64\n} Notice the .. ! This special alias will be replaced with the alias crated for User . The generated SELECT might look like this: SELECT t0.id, (SELECT COUNT(*) FROM Books WHERE author_id = t0.id) FROM User t0 To use aux params in a SQL query use the <param_name> syntax. Aux params example #[derive(Toql)]\nstruct User { #[toql(key)] id: u64, #[toql(sql=\"(SELECT <page_limit>)\")] page_limit:u64 #[toql(sql=\"(SELECT COUNT(*) FROM Films f WHERE f.age >= <age>)\")] age_rated_films:u64\n} In the example page_limit might come from a server configuration. It would typically be put in the context and can be used in SQL expressions. The aux param age might be taken from the authorisation token and put as an aux param into the context or query. Here it restricts the number of films.","breadcrumbs":"The Toql derive » SQL expressions","id":"35","title":"SQL expressions"},"36":{"body":"There are other places you can use raw SQL: Predicates Custom Merge","breadcrumbs":"The Toql derive » Other uses of raw SQL","id":"36","title":"Other uses of raw SQL"},"37":{"body":"It's possible to write an own field handler. Do it, because You want to build an SQL expression with a function. You want to support a database function through FN You want to abuild a filter condition with a function","breadcrumbs":"The Toql derive » Field handlers","id":"37","title":"Field handlers"},"38":{"body":"Let's support a length function LLE , so that we can filter on maximum word length use toql::prelude::{BasicFieldFilter, FieldHandler, SqlExpr, SqlBuilderError, FieldFilter}; struct LengthFieldHandler{ // The default field handler gives us default filters, such as `eq`, `ne`, ... default_handler: BasicFieldHandler, }; impl FieldHandler for PermissionFieldHandler\n{ fn build_filter( &self, select: SqlExpr, // Our column or SQL expression filter: &FieldFilter, // The filter called with this field aux_params: &ParameterMap, // All aux params available ) -> Result<Option<SqlExpr>, SqlBuilderError> { match filter { // Support our custom LL filter that maps to the MySQL FIND_IN_FIELD function FieldFilter::Fn(name, args) => match name.as_str() { \"LLE\" => { if args.len() != 1 { return Err(SqlBuilderError::FilterInvalid( \"filter `FN LLE` expects exactly 1 argument\".to_string())); } Ok(Some(sql_expr!(\"LENGTH ({}) <= ?\", select, args[0]))) } name @ _ => Err(SqlBuilderError::FilterInvalid(name.to_string())), }, _ => self.default_handler.build_filter(select, filter, aux_params), } } } // Getter method for mapper\npub fn length_field_handler() -> impl FieldHandler { LengthFieldHandler:{ default_handler: BasicFieldHandler::new(), }\n} Now we can map our filter with #[toql(handler=\"length_field_handler\")]\nname: String and use it in a query with *, name FN LLE 5 For a bigger example, check out our permission handler .","breadcrumbs":"The Toql derive » Filter on fields","id":"38","title":"Filter on fields"},"39":{"body":"A struct can refer to another struct. This is done with a SQL join. Joins are added to the SQL statement when requested in the query, like so: phone1_id or joins are preselected. Join mapping example #[derive(Toql)]\nstruct User { #[toql(key)] id: u32, name: Option<String> #[toql(join())] phone1 : Phone // Always selected inner join #[toql(join())] phone2 : Option<Phone> // Selectable inner join #[toql(join())] phone3 : Option<Option<Phone>> // Selectable left join #[toql(join(), preselect)] phone4 : Option<Phone> // Always selected left join\n} Notice how Option makes the difference between an inner join and a left join.","breadcrumbs":"The Toql derive » Joins","id":"39","title":"Joins"},"4":{"body":"Toql relies on backends to handle database differences. These backends implement the ToqlApi trait which serves as an entry point for any high level function. The backends internally then use the Toql library to do their job. This chapter explains how to use the ToqlApi trait. Notice that you must derive your structs before you can load or modify them with the ToqlApi . See the derive chapter for details. The common ToqlApi trait makes it also possible to write database independend code. This is described here .","breadcrumbs":"The Toql API","id":"4","title":"The Toql API"},"40":{"body":"By default foreign keys are calulated by the primary columns of the join and the field name of the join. For the above it would be phone1_id , phone2_id , phone3_id and phone4_id . If your naming scheme differs from that default behaviour, use the columns attribute: #[toql(join(columns(self=\"mobile1_id\", other=\"id\")))] phone1 : Phone For a composite key use columns multiple times.","breadcrumbs":"The Toql derive » Renaming joined columns","id":"40","title":"Renaming joined columns"},"41":{"body":"It's possible to restrict the join with a ON SQL predicate. Here an example of a translated country name. #[derive(Toql)]\nstruct User { #[toql(key)] id: u32, country: Option<Country>\n} #[derive(Toql)]\n#[toql(auto_key = false))]\nstruct Country { #[toql(key)] id: u32, #[toql(join(columns(self = \"id\", other = \"id\"), on_sql = \"...language_id=<interface_language_id>\" ), )] pub translation: Option<CountryTranslation>\n}\n#[derive(Toql)]\n#[toql(auto_key = false))]\npub struct CountryTranslation { #[toql(key)] pub id: String, pub title: String,\n} You can use any raw SQL in the ON predicate. Did you spot the ... alias? This will resolve to the alias of the joined struct (CountryTranslation). Apart from ON predicates the ... alias can also be used in custom merge predicates. It is also possible to use the regular .. alias to refer to the joining struct (Country), but we don't need it here. You can use auxiliary parameters (here <interface_language_id> ) in ON expression. Aux params usually come from a context, query. However for ON there is a third source : Aux params may also come from query predicates . This allows some nifty joining, see here:","breadcrumbs":"The Toql derive » Custom ON predicate","id":"41","title":"Custom ON predicate"},"42":{"body":"#[derive(Toql)]\n#[toql(auto_key = false, predicate( name =\"language\", sql=\"EXISTS(SELECT 1 FROM Country c \\ JOIN Language l ON (c.id= l.id)) WHERE l.id= ?)\", on_aux_param=\"language_id\" ))]\nstruct Country { #[toql(key)] id: u32, #[toql(join(columns(self = \"id\", other = \"country_id\"), on_sql = \"...id=<language_id>\" ), )] pub language: Option<Language>\n} #[derive(Toql)]\n#[toql(auto_key = false))]\npub struct Language { #[toql(key)] pub id: String, pub title: String,\n} Above we add a predicate that allows to filter all countries by a language. There can be multiple countries that speak the same language. The predicate takes the one argument ( ? ) and adds it to the aux_params for custom joins ( on_param ). When the predicate is used in a Toql query, lets say *, @language 'fr' the SQL will return countries that speak french. In addition it will add fr to the aux_params when doing the custom join. So each country will contain the language field with information about french. It's somehow hacky, but it works and is useful in 1-n situations when you want 1-1 .","breadcrumbs":"The Toql derive » Example with on_aux_param","id":"42","title":"Example with on_aux_param"},"43":{"body":"Toql can insert joins with renamed columns and no custom ON expression, because key propagation is done internally through common column names. Joins with custom ON expressions can't be inserted or updated, they are read only.","breadcrumbs":"The Toql derive » Insert / update implications","id":"43","title":"Insert / update implications"},"44":{"body":"Joining directly another struct is not ergonomic when you want to update the struct. Thats why the Join enum exists. It can either take a struct value or just its key. Consider this #[derive(Toql)]\nstruct User { #[toql(key)] id: u32, #[toql(join())] phone: Phone\n} Here when we want to set a new Phone for the user, we need to provide a full Phone struct even tough we only want to set a new value for the foreign key phone_id in User . This feels unnesseary and toql::prelude::Join comes to our rescue: #[derive(Toql)]\nstruct User { #[toql(key)] id: u32, #[toql(join())] phone: Join<Phone> #[toql(join())] phone2: Option<Option<Join<Phone>>>\n} This has the following advantages: Loads as normal, Join will always hold a full value. Updating the phone_id column in User requires only a PhoneKey . This key can be always be taken out from Join . Web clients can send in keys or full entities. Join will deserialize into whatever is possible. For working with joins in your code checkout the toql::prelude::join! or toql::prelude::rval_join! macros.","breadcrumbs":"The Toql derive » The Join struct","id":"44","title":"The Join struct"},"45":{"body":"If you watch the generated SQL joins, you will notice that JOIN statements look slightly more complicated from Toql than you may expect. This is because Toql builds correctly nested JOIN statements that reflect the dependencies among the joined structs. Any SQL builder that simply concatenates inner joins and left joins may accidentally turn left joins into inner joins. This database behaviour is not well known and usually surprises users - Toql avoids this.","breadcrumbs":"The Toql derive » Sidenote for SQL generation","id":"45","title":"Sidenote for SQL generation"},"46":{"body":"When doing a join, it's possible do write a custom handler. The handler can only build a custom ON predicate. Why would you do it? I don't know :) In all cases I can think of you get your ON predicate cheaper with on_sql . However it's still possible: use toql::prelude::{JoinHandler, SqlExpr, SqlArg, ParameterMap, SqlBuilderError}; pub(crate) struct MyJoinHandler; impl JoinHandler for MyJoinHandler { fn build_on_predicate(&self, on_predicate: SqlExpr, aux_params: &ParameterMap,) ->Result<Option<SqlExpr>, SqlBuilderError> { Some(on_expr) }\n} // Getter function\npub fn my_join_handler() -> impl JoinHandler { MyJoinHandler {}\n} Now map the getter function with #[toql(join(), handler=\"my_join_handler\")]\naddress: Address And any join on Address will now call the join handler.","breadcrumbs":"The Toql derive » Join handlers","id":"46","title":"Join handlers"},"47":{"body":"A database table may split into several tables sharing the same primary key. This is done because the original table got too many columns A group of columns in the table is optional You want to control access with Toql roles. Partial tables are supported with joins. #[derive(Toql)]\n#[toql(auto_keys= true)]\nstruct Question { #[toql(key)] id: u64 text: String, #[toql(join(columns(self=\"id\", other=\"question_id\")), partial_table)] details: Option<QuestionDetails>\n} #[derive(Toql)]\nstruct QuestionDetails { #[toql(key)] question_id: u64 font: String\n} In the example above Question and QuestionDetails share the same values for primary keys.This is what patial_table says. So for a question with id = 42 there is a solution with question_id = 42 . Inserts will always insert all partial tables too, whenever a path list asks to insert the base table (Question). Also it will avoid to insert a non existing foreign key: If QuestionDetails was regular join (without partial_table ) insert would try to set a (non existing) column details_id with the value to the primary key of Questiondetails . This would be correct for regular joins, but fails on partial tables. Updates have the same behaviour when inserting new merges and for loading partial_table has no effect.","breadcrumbs":"The Toql derive » Partial tables","id":"47","title":"Partial tables"},"48":{"body":"A struct can contain a Vec of other structs. Because this can't be loaded done directly in SQL, Toql will execute multiple queries and merge the results. #[derive(Toql)]\n#[toql(auto_key = true)]\nstruct User { #[toql(key)] id: u32, name: Option<String> #[toql(merge())] mobile_phones : Vec<Phone>\n} #[derive(Toql)]\nstruct Phone { #[toql(key)] number: Option<String> prepaid : Option<bool>\n} Selecting all fields from above with *, mobilePhones_* will run 2 SELECT statements and merge the resulting Vec<Phone> into Vec<User> by the common column value of User.id and Phone.user_id .","breadcrumbs":"The Toql derive » Merges","id":"48","title":"Merges"},"49":{"body":"By default the merge column names follow the pattern above. However it's possible to explicitly specify the column names: #[toql(merge(columns(self=\"id\", other=\"user_id\")))] phones : Vec<Phone>","breadcrumbs":"The Toql derive » Renaming merge columns","id":"49","title":"Renaming merge columns"},"5":{"body":"To use the ToqlApi functions you need a Toql backend and the driver for your database. Currently the following backends are available Database Backend Crate Driver Crate MySQL toql_mysql_async mysql_async For MySQL add this to your cargo.toml : [dependency]\ntoql = \"0.3\"\nmysql_async = \"0.20\"\ntoql_mysql_async = \"0.3\" Then you can get the backend in your code. Notice that the backend takes a database connection and a cache object to keep database schema information. use mysql_async::MySql;\nuse toql_mysql_async::prelude::MySqlAsync;\nuse toql::prelude::Cache; let pool = mysql_async::Pool::new(database_url);\nlet mut conn = pool.get_conn().await?; let cache = Cache::new(); let toql = MySqlAsync::from(&mut conn, &cache); In a bigger project you may want to feed configuration or authentication values into your SQL. This is done through so called auxiliary parameters (aux params). There are two ways to feed in aux params: You can put them in the context and they will be available as long as the backend object lives You can also ship them with a query and they will be available only for that query Here how to put them in the context: use mysql_async::MySql;\nuse toql_mysql_async::prelude::MySqlAsync;\nuse toql::prelude::{Cache, ContextBuilder};\nuse std::collections::HashMap; let pool = mysql_async::Pool::new(database_url);\nlet mut conn = pool.get_conn().await?; let mut p = HashMap::new();\np.insert(\"page_limit\".into(), 200.into()); let context = ContextBuilder::new().with_aux_params(p).build();\nlet cache = Cache::new();\nlet toql = MySqlAsync::with_context(&mut conn, &cache, context); Beside aux params ContextBuilder allows you to choose an alias format ( user.id , us1.id , t0.id , ...) set the roles for access control use toql::prelude::{ContextBuilder, AliasFormat};\nuse std::collections::HashSet; let mut roles = HashSet::new();\nroles.insert(\"teacher\", \"admin\"); let context = ContextBuilder::new() .with_alias(AliasFormat::Tiny) .with_roles(roles) .build();","breadcrumbs":"Creating the backend","id":"5","title":"Creating the backend"},"50":{"body":"Often in a 1-n-1 situation the association table (n) does not contain any other columns apart from the composite key. In those situations it's often desirable to skip it. Let's go with an example: #[derive(Toql)]\n#[toql(auto_key = true)]\nstruct User { #[toql(key)] id: u32, name: Option<String> #[toql(merge()))] // Default merging on User.id = UserCountry.user_id countries1 : Vec<UserCountry> #[toql(merge( join_sql = \"JOIN UserCountry uc ON (...id = uc.country_id)\", columns(self = \"id\", other = \"uc.user_id\") ))] countries2 : Vec<Country>\n} #[derive(Toql)]\nstruct UserCountry { #[toql(key)] user_id: u32, #[toql(key, join())] // Default joining on UserCountry.country_id = Country.id country: Country }\n#[derive(Toql)]\nstruct Country { #[toql(key)] id: String, name: Option<String>\n} Wow, a lot going on here: countries1 merges on default column names (User.id = UserCountry.user_id). Here the Vec contains UserCountry , which does not contain any interesting data and is unconvenient when accessing Country . countries2 skips the association table with a custom SQL join. Let's look at join_sql first: The special other alias ... refers - as always- to the merged struct (Country here), so Country will be joined with UserCountry on Country.id = uc.country_id . After the select Toql merges the countries into the users on common column values of User.id and uc.user_id column value. Because the later column is already aliased with uc no alias will be added. In UserCountry , notice the nice example of a composite key made up with a join :)","breadcrumbs":"The Toql derive » No association table with join_sql","id":"50","title":"No association table with join_sql"},"51":{"body":"In the example above Country knows nothing about the User , so we must merge with join_sql . However sometimes the merged struct does have a suitable foreign key and we can apply a different pattern: In the example below we don't have a classic association table. Still we merge normally on User.id = Todo.user_id , but Todo.user_id is not part of a composite key, as it would be in a asscociation table. Instead it is just a normal foreign key. This is not a problem when loading the merge. But when doing inserts, Toql wishes to update Todo.user_id to ensure the foreign key contains the right value. If Todo.user_id was part of the primary key this would work out of the box. But since it's not, we have to mark it with #[foreign_key] . This tells to consider this column too when setting keys. Foreign key example #[derive(Toql)]\n#[toql(auto_keys= true)]\nstruct User { #[toql(key)] id: u64, #[toql(merge())] todos: Vec<UserTodo>\n} #[derive(Toql)]\n#[toql(auto_keys= true)]\nstruct Todo { #[toql(key)] id: u64, #[toql(foreign_key)] user_id: , what: String\n}","breadcrumbs":"The Toql derive » No association table with #[toql(foreign_key)]","id":"51","title":"No association table with #[toql(foreign_key)]"},"52":{"body":"Toql requires you to add the attribute key to the field that correspond to the primary key in your database. For composite keys mark multiple fields with the key attribute. For internal reasons keys must always be the first fields in a struct and must not be optional. This means that keys are preselected and therefore always loaded when a Toql query selects fields from the struct. Example: #[derive(Toql)]\nstruct User { #[toql(key)] id: u64 name: Option<String>\n}","breadcrumbs":"The Toql derive » Keys","id":"52","title":"Keys"},"53":{"body":"Inner joins can also have the key attribute. This is useful for association tables. For a join used as a key the SQL builder takes the primary key(s) of the joined struct to guess the foreign key columns. Example: #[derive(Toql)]\nstruct Language { #[toql(key)] code: String, name: String\n} #[derive(Toql)]\nstruct UserLanguage { #[toql(key)] user_id: u64 #[toql(join(), key)] language: Language; } For the example above Toql assumes that the database table UserLanguage has a composite key made up of the two columns user_id and language_code . You can change this assumption, see here .","breadcrumbs":"The Toql derive » Joins","id":"53","title":"Joins"},"54":{"body":"The Toql derive creates for every struct a corresponding key struct. The key struct contains only the fields marked as key form the derived stuct. Keys are useful to : Delete an value with delete_one Build a query Update a join Keys can be serialized and deserialized with serde [TODO feature]. This allows web clients to send either a full joined entity or just the key of it if they want to update some dependency. Example use crate::user::{User, UserKey}; let key = UserKey::from(10);\ntoql.delete_one(key).await?; // Convert","breadcrumbs":"The Toql derive » Generated key struct","id":"54","title":"Generated key struct"},"55":{"body":"Only columns and inner joins can be used as keys. Merged fields ( Vec<T> ) and fields that map to an Sql expression ( #[toql(sql=\"..\") ) cannot be used as keys.","breadcrumbs":"The Toql derive » Unkeyable fields","id":"55","title":"Unkeyable fields"},"56":{"body":"When you insert a struct, all fields, including foreign keys of joins, will be inserted. Check the api for details.","breadcrumbs":"The Toql derive » Insert","id":"56","title":"Insert"},"57":{"body":"For selectable fields in a struct that are None Toql will insert the default value for the corresponding table column. If you have not defined a default value in your database you must ensure that the field in the struct cannot be None . This can be done through prior validation.","breadcrumbs":"The Toql derive » Default values","id":"57","title":"Default values"},"58":{"body":"The insert behaviour depends on the type amd mapping of a field: #[derive(Toql)]\nstruct User { #[toql(key)] id: u64 // Keys are never inserted username: String, // Value realname: Option<String>,\t// Default or value address: Option<Option<<String>>,// Nullable column: Default, value or NULL #[toql(preselect)] info: Option<String> // Nullable column: Value or NULL #[toql(join)] address1: Option<Address> // Selectable inner Join: Foreign key is inserted or default #[toql(join)] address2: Option<Option<Address>>// Selectable left join: Default, value or NULL #[toql(join())] address3: Address // Inner Join: Foreign key or default #[toql(join(), preselect)] address4: Option<Address>>\t// Selectable inner join: Foreign key or default #[toql(merge())] phones1: Vec<Phone>> // No change on table 'User' #[toql(merge())] phones2: Option<Vec<Phone>>> // No change on table 'User'\n} When the path list requires to insert a dependency too, left joins and optional merges will only be inserted, if they contains a value.","breadcrumbs":"The Toql derive » Insert behaviour","id":"58","title":"Insert behaviour"},"59":{"body":"The update functions from the API will update a field, if the field name is in the field list and a selectable field in the struct contains a value. Update behaviour example If we want to update all fields of the struct below with a field list of * , the behaviour would be #[derive(Toql)]\nstruct User { #[toql(key)] id: u64 // Keys are never updated username: String, // Update realname: Option<String>, // Updated , if Some address: Option<Option<<String>>, // Update NULL or String, if Some #[toql(preselect)] info: Option<String>, //Update NULL or String #[toql(join)] address1: Option<Address>, // Update foreign_key, if Some #[toql(join)] address2: Option<Option<Address>>,// Update foreign_key or NULL, if Some #[toql(join())] address3: Address, // Update foreign_key #[toql(join(), preselect)] address4: Option<Address>>,\t// Update foreign_key or NULL #[toql(merge())] phones1: Vec<Phone>>,\t// No effect for * #[toql(merge())] phones2: Option<Vec<Phone>>> // No effect for *, } Notice that foreign keys of joins are included ( User.address1_id, User.address2_id, .. ) with the * in the field list. However merges must be explicitly mentioned. To update all fields from User and to resize the Vec of phones1 (insert new phones + delete old phones ) the field list would be *, phones1 .","breadcrumbs":"The Toql derive » Update","id":"59","title":"Update"},"6":{"body":"There are three loading functions: load_one , load_many and load_page . All loading functions take a Toql query and will translate it into SQL SELECT statement(s). The resulting rows will be deserialized and returned. If your Toql structs contain a Vec of other structs, the load functions issue multiple SELECT statements and merge the results. If you expect exactly one result, use load_one . use toql::prelude::{query, ToqlApi}; let toql = ... let q = query!(...); let u = toql.load_one(q).await?; The function will return ToqlError::NotFound if no row matched the query filter or ToqlError::NotUnique if more than one row matched. To load zero or one row use load_page , see below. Similarly, if you need to load multiple rows: use toql::prelude::{query, ToqlApi}; let toql = ... let q = query!(...); let u = toql.load_many(q).await?; load_many returns a Vec with deserialized rows. The Vec will be empty, if no row matched the filter criteria. load_page allows you to select a page with a starting point and a certain length. It returns a Vec and count information. The count information is either None for an uncounted page or contains count statistics that is needed for typical pagers in web apps, see below. (After all Toql was initially created to serve web pages.) To load the first 10 -or less- rows do this: use toql::prelude::{query, ToqlApi, Page}; let toql = ... let q = query!(...); let (u, _) = toql.load_page(q, Page::Uncounted(0, 10)).await?; To serve a webpage, you may also want to include count informations. use toql::prelude::{query, ToqlApi, Page}; let toql = ... let q = query!(...); let (u, c) = toql.load_page(q, Page::Counted(0, 10)).await?; The code is almost the same, but the different page argument will issue two more select statements to return the filtered page length and the total page length. Let's see what those are: Suppose you have a table with books. The books have an id, a title and an author_id. id title author_id 1 The world of foo 1 2 The world of bar 1 3 The world of baz 1 4 What 42 tells me 1 5 Flowers And Trees 2 Let's assume we have a webpage that contains a pager with page size 2 and a pager filter. The author wants to see all books that contain the word world . What will he get? The first two rows (id 1, id 2). The filtered page count of 3, because 3 rows match the filter criteria. The pager can now calculate the number of pages: ceil(3 / 2) = 2 The total page count of 4. The author knows now that with a different filter query, he could get at most 4 rows back. In practice the total page count is not so straight forward to select: Toql needs to decide, which filters from the query to consider or ignore when building the count SQL statement. For the total page count only filters are used on fields that are listed in the special count selection and predicates that are marked as count filters.","breadcrumbs":"Api » Loading","id":"6","title":"Loading"},"60":{"body":"Selections are a list of fields and can be defined on a struct. A Toql query can then select the selection instead of all the individual fields. See here . #[derive(Toql)]\n#[toql(selection(name=\"std\", fields=\"*, address_street\"))]\n#[toql(selection(name=\"tiny\", fields=\"id, name\"))]\nstruct User { #[toql(key)] id: u64 name: String #[toql(join())] address: Address } [derive(Toql)]\nstruct Address { #[toql(key)] id: u64 street: String Notice that selection names with 3 letters or less are internally reserved and my have special meanings. They can't be defined except std and cnt . The selections above can now be used in a query. Instead of writing name, address_street it is possible to write $std or event just $ . (Because the standart selection is so common, $ aliases to $std ). The cnt selection is defined in a similar way.TODO","breadcrumbs":"The Toql derive » Selections","id":"60","title":"Selections"},"61":{"body":"All normal filtering is based on fields, see here . However sometimes you may have a completely different filter criteria, that cannot be mapped on fields. An example is the MySQL full text search. Let's do it: #[derive(Toql)]\n#[toql(predicate(name=\"search\", sql=\"MATCH (..firstname, ..lastname) AGAINST (? IN BOOLEAN MODE)\"))] #[toql(predicate(name=\"street\", sql=\"EXISTS( SELECT 1 FROM User u JOIN Address a ON (u.address_id = a.id) \\ WHERE a.street = ? AND u.id = ..id)\"))]\nstruct User { #[toql(key)] id: u64, firstname: String, lastname: String,\n} With the two predicates above you can seach for users that have a certain name with @search 'peter' and retrieve all users from a certain street with @street 'elmstreet' . The question marks in the predicate are replaced by the arguments provided. If there is only one argument, it can also be used to build an ON predicate in a join. See on aux param .","breadcrumbs":"The Toql derive » Predicates","id":"61","title":"Predicates"},"62":{"body":"The full predicate syntax is predicate(name=\"..\", sql=\"..\", handler=\"..\", on_aux_param=\"..\", count_filter=true|false) where name is the name of the predicate. It can be called in a Toql query with @name .. . If a predicate is defined on a joined struct, that predicate can be called with a path @path_name .. . See predicates in the query for more details. sql is a raw QL expression. Use ? to insert a predicate param in the SQL, .. for the table alias and <aux_param> for an aux param value. handler allows a custom predicate handler (build SQL with a function). Provide a function name without parenthesis that return a struct that implement toql::prelude::PredicateHandler on_aux_param sets the value of an aux_param. This aux param is only available when building custom joins and can only be used when the predicate takes exactly one argument. See example . count_filter determines if a predicate used in Toql query should also be used for count queries . Default is false .","breadcrumbs":"The Toql derive » Reference","id":"62","title":"Reference"},"63":{"body":"It's also possible to write an own predicate handler. Let's write a handler that concatenates all argument passed to the predicate and puts those arguments into the SQL predicate. #[derive(Toql)]\n#[toql(predicate(name=\"names\", sql=\"EXISTS (Select 1 FROM User u JOIN Todo t ON (u.id = t.user_id) \\ AND u.name IN <args>)\", handler=\"my_handler\"))]\nstruct Todo { #[toql(key)] id: u64, what: String,\n} use toql::prelude::{PredicateHandler, SqlExpr, SqlArg, ParameterMap, SqlBuilderError}; pub(crate) struct MyPredicateHandler;\nimpl PredicateHandler for MyPredicateHandler { fn build_predicate( &self, predicate: SqlExpr, // SQL from predicate predicate_args: &[SqlArg],\t// Arguments from the query aux_params: &ParameterMap,\t// Aux params ) -> Result<Option<SqlExpr>, SqlBuilderError> // Return None if no filtering should take place { if predicate_args.is_empty() { return Err(SqlBuilderError::FilterInvalid( \"at least 1 argument expected\".to_string(), )); } let mut args_expr = SqlExpr::new(); predicate_args.iter().for_each(|a| { args_expr.push_arg(a.to_owned()); args_expr.push_literal(\", \"); }); args_expr.pop(); // remove trailing ', ' let mut replace = HashMap::new(); replace.insert(\"args\".to_string(), args_expr); let predicate = Resolver::replace_aux_params(predicate, &replace); // Replace aux params with SQL expressions Ok(Some(predicate)) }\n} // Getter function\npub fn my_handler() -> impl PredicateHandler { MyPredicateHandler {}\n} Use it in a Toql query with @names 'Peter' 'Sandy' 'Bob'","breadcrumbs":"The Toql derive » Predicate handlers","id":"63","title":"Predicate handlers"},"64":{"body":"It's possible to restrict access to fields and structs with boolean role expressions. #[derive(Toql)] {\n#[toql(roles(insert=\"poweruser\", delete=\"poweruser\"))\nstruct Book #[toql(key)] id : u64 #[toql(roles(load=\"superuser;poweruser\", update=\"poweruser\"))] rating: u64\n} The role expressions are similar to the Toql query syntax: OR is expressed with ; AND is expressed with , NOT is expressed with ! brackets are allowed An valid role expression would be (teacher;student), !lazy meaning A teacher OR student AND NOT lazy . Roles are provided with the context: let mut r = HashSet::new();\nr.insert(\"teacher\");\nlet context = ContextBuilder::new() .with_roles(r) .build(); See here for how to get a backend. Notice that roles can restrict access to columns but not to rows. For row access control, check out the chapter in the appendix.","breadcrumbs":"The Toql derive » Roles","id":"64","title":"Roles"},"65":{"body":"The derive provides struct level attributes and field level attributes. Here a list of all available attributes:","breadcrumbs":"The Toql derive » Toql derive reference","id":"65","title":"Toql derive reference"},"66":{"body":"Attribute Description Example / Remark tables Table renaming scheme for struct and joins CamelCase , snake_case , SHOUTY_SNAKE_CASE or mixedCase columns Column renaming scheme table Table name for a struct or join table =\"User\" on struct NewUser will access table User skip_mut No code for insert, delete and update struct cannot be updated predicate Define a predicate predicate(name=\"test\", sql=\"MATCH(..name, ..address) AGAINST (?)\") selection Define a selection selection(name=\"test\", fields=\"*, address_street\") alias Ignore calculated alias and use this alias instead alias=\"tb1\" auto_key Key is generated in database auto_key=true Updates struct keys after inserts. roles role restriction for load, update, insert, delete roles(update=\"admin;teacher\", insert=\"admin\")","breadcrumbs":"The Toql derive » Attributes for structs","id":"66","title":"Attributes for structs"},"67":{"body":"Attribute Description Example / Remark key Primary key For composite keys use multiple times. Skipped for insert, update. column column name Use to overide default naming column=\"UserNamE\" sql Map field to SQL expression sql=\"..title\" or sql=\"(SELECT o.name FROM Other o WHERE o.id = ..other_id)\" , skipped for insert, update. skip Completly ignore field skip_mut Ignore for updating Automatically added for keys and SQL expressions, add manually for db generated columns or safety restriction skip_wildcard Don't include this field in wildcard selection Use for expensive subselects join Required for fields that join other structs join(columns(self=\"address_id\", other=\"id\")) merge Required for fields that are Vec<> merge(columns(self=\"address_id\", other=\"id\")) handler Build SQL expression with code handler=\"get_handler\" , function returns struct implementing toql::prelude::FieldHandler aux_param set aux_param Use to give parameters to a field handler aux_param(name=\"entity\", value=\"USER\") roles role restriction for load, update roles(load=\"admin\") foreign_key The field is a foreign key. Update that field too, if struct is joined. Rarely needed.","breadcrumbs":"The Toql derive » Attributes for fields","id":"67","title":"Attributes for fields"},"68":{"body":"The Toql query language is a normal string that list all query fields, that should be retrieved from a database. Besides selection, query fields can also be filtered and ordered. They are separated either by comma or semicolon. If a filter is applied a comma will join the filters with AND, a semicolon with OR. Example 1: id, +name, age gt 18 is translated into SELECT t0.id, t0.name, t0.age FROM ... WHERE t0.age > 18 ORDER BY t0.name ASC Example 2: id, .age eq 12; .age eq 15 is translated into SELECT t0.id From ... WHERE t0.age = 12 OR t0.age = 15","breadcrumbs":"The query language","id":"68","title":"The query language"},"69":{"body":"Fields are selected if they are mentioned in the query. Names without underscore represent typically columns or SQL expressions from the table the query is run against. id, name, fullName, emailAddress Fields with underscores are called fields with a path . They are mapped to a joined or a merged dependency. For a join relationship, the join will be added to the SQL statement if the field is selected. For a merge relationship a second SQL query is run and the results are merged. Such a query might look like this book_id, book_title, book_createdBy_id, sellers_city Example id, book_id is translated into (SQL Mapper must be told how to join) SELECT a.id, b.id FROM User a JOIN Book b ON (a.book_id = b.id)","breadcrumbs":"The query language » Selecting fields","id":"69","title":"Selecting fields"},"7":{"body":"All load functions need a query, but how is this build? The recommended way is to use the query! macro. Alternatives are to create a new Query<T> object and use its builder methods or to parse a string This chapter does not explain the Toql query language itself, see here to learn about that.","breadcrumbs":"Api » The Query type","id":"7","title":"The Query type"},"70":{"body":"There are two wildcards to select multiple fields. They can neither be filtered nor ordered. * selects all fields from the top level. path_ * selects all fields from path . Fields can be excluded from the wildcard by setting them to skip_wildcard . So a query *, book_* would select all fields from user and book.","breadcrumbs":"The query language » Wildcards","id":"70","title":"Wildcards"},"71":{"body":"Fields can require roles to be loaded. An error is raised, if a query selects a field by name that it's not allowed to. However if the query selects with a wildcard, the disallowed field will just be ignored.","breadcrumbs":"The query language » Role restricted selection","id":"71","title":"Role restricted selection"},"72":{"body":"Fields can be ordered in ascending + or descending - way. Example +id, -title is translated into --snip-- ORDER BY id ASC, title DESC","breadcrumbs":"The query language » Ordering fields","id":"72","title":"Ordering fields"},"73":{"body":"Use numbers to express ordering priority. Lower numbers have higher priority. If two fields have the same number the first field in the query has more importance. Example -2id, -1title, -2age is translated into --snip-- ORDER BY title DESC, id DESC, age DESC","breadcrumbs":"The query language » Ordering priority","id":"73","title":"Ordering priority"},"74":{"body":"Fields can be filtered by adding a filter to the field name. Filters are case insensitiv. Arguments are separated by whitespace. Strings and enum arguments are enclosed with single quotes. Boolean arguments are expressed with numbers 0 and 1. To use a field only for filtering, but not for selection, hide it with a dot: .age gt 50, .book_reviewed eq 1 Example id, book_published eq 1, .age gt 50 is typically translated into (using canonical aliases) SELECT user.id, user_book.id, user_book.published FROM User user JOIN Book user_book ON (user.book_id = user_book.id) WHERE user_book.published = 1 AND user.age > 50","breadcrumbs":"The query language » Filtering fields","id":"74","title":"Filtering fields"},"75":{"body":"Toql Operation Example SQL eq equal age eq 50 age = 50 eqn equal null age eqn age IS NULL ne not equal name ne 'foo' name <> 'foo' nen not equal null age nen age IS NOT NULL gt greater than age gt 16 age > 16com ge greater than or equal age ge 16 age >= 16 lt less than age lt 16 age < 16 le less than or equal age le 16 age <= 16 bw between age bw 16 20 age BETWEEN 16 AND 20 in includes name in 'Peter' 'Susan' name in ('Peter, 'Susan') out excludes age out 1 2 3 name not in (1, 2, 3) fn custom function search fn ma 'arg1' depends on implementation","breadcrumbs":"The query language » Filter operations","id":"75","title":"Filter operations"},"76":{"body":"Custom functions are applied through the FN filter. They must be handled by a Field Handler. See API for details.","breadcrumbs":"The query language » Custom functions","id":"76","title":"Custom functions"},"77":{"body":"A field can be filtered multiple times by adding multiple the filter expressions in the query. To build complex filter expressions join filters by comma to express logical AND or semicolon for logical OR. Keep in mind that logical AND has higher precendence than logical OR. Use parens if required: age eq 12, animal eq 'chicken'; animal eq 'cow is the same as (age eq 12, animal eq 'chicken'); animal eq 'cow but different than age eq 12, (animal eq 'chicken'; animal eq 'cow) Use the dot notation if you only want to filter a field without selecting it: age eq 12, .animal eq 'chicken'; .animal eq 'cow'","breadcrumbs":"The query language » Joining filters","id":"77","title":"Joining filters"},"78":{"body":"Toql onyl knows integers, floats and strings. Use the following table to express more types: Type Toql Example Remark bool admin eq 1 0, 1 integer limit bw -12 5 float price le 0.5e2 string name in 'peter' Single quotes date subscribeUntil le '2050-12-31' SQL format time start ge '08:30:00' SQL format date time finishedAt ge '2005-12-31 08:30:00' SQL format","breadcrumbs":"The query language » Argument types","id":"78","title":"Argument types"},"79":{"body":"A typical query selects a lot of fields. Instead of writing out a long list of fields, predefined field lists can be mapped . The list can then be selected with a $ followed by the selection name. $mySelection, $otherSelection There is a set of predefined selections: Selection Scope $std Standart selection, must be to be used $ Alias for $std $cnt Fields that are considered for a count query, defaults to keys and preselects $all All fields on a struct, including dependencies $mut All mutable fields on a struct Selections on a dependency can be used with a path. To load the standart selection from a dependency address use $address_std","breadcrumbs":"The query language » Selections","id":"79","title":"Selections"},"8":{"body":"The query! macro will compile the provided string into Rust code. Any syntax mistakes, wrong path or field names show up as compiler errors! Queries are typesafe, so query! takes a type and a query expression. See here (This assumes a Toql derived User struct): use toql::prelude::query;\nlet user_id = 5;\nlet q = query!(User, \"*, id eq ?\", user_id); To include query parameters just insert a question mark in the query string and provide the parameter after the string. In the example above it would also be possible to put the number 5 directly into the query string, since it's a constant. The resulting SQL would be the same as Toql extracts the parameter in either case to prevent SQL injections. The Toql query only works with numbers and strings, see SqlArg . However this is not be a problem: Since database columns have a type, the database is able convert a string or number into its column type. It's also possible to include other queries into a query. Consider this: use toql::prelude::query;\nlet q1 = query!(User, \"id eq ?\", 5);\nlet q = query!(User, \"*, {}\", q1); Here we include the query q1 into q . Since queries are typesafe, so you can only include queries of the same type.","breadcrumbs":"Api » The query! macro","id":"8","title":"The query! macro"},"80":{"body":"Selection names with 3 or less characters are reserved for internal purposes. User defined selection names must contain at least 4 characters.","breadcrumbs":"The query language » Restriction on selection names","id":"80","title":"Restriction on selection names"},"81":{"body":"Normal query filters are applied to fields. Predicates overcome this limitation and can filter on any raw SQL predicate. The behaviour of predicates must be mapped , then they can be called with a @ , the predicate name and zero or more arguments. @search 'peter', @updated, @tags 'island' 'fun' Predicates can refer to a dependency, using a path. To search a dependency address use @address_search 'peter'","breadcrumbs":"The query language » Predicates","id":"81","title":"Predicates"},"82":{"body":"The appendix is a wild collection of issues around Toql in no particular order.","breadcrumbs":"Appendix","id":"82","title":"Appendix"},"83":{"body":"To map enums between a column and a struct field some MySQL boilerplate code is required. the enum must implement the ToString and FromStr traits. For the first I made a little crate mysql_enum and for the later several crates exit. Here an example with strum : With this in Cargo.toml [dependencies]\nmysql_enum = \"0.1\"\nstrum = \"0.22\"\nstrum_macros = \"0.22\" you can attribute your enums: use mysql_enum::MysqlEnum;\nuse strum_macros::{Display, EnumString}; #[derive(PartialEq, EnumString, Display, MysqlEnum)]\nenum Mood { Happy, Sad\n} Now Mood can be used: #[derive (Debug, Toql)]\nstruct User { id : u64, name: Option<string> mood: Option<Mood>\n}","breadcrumbs":"Appendix » MySQL Enums","id":"83","title":"MySQL Enums"},"84":{"body":"Toql comes with role based access. Roles can only restrict access to columns but not to rows. For a full security model you also need restricted access to rows. Row access control should always be done in databases. Reality is however that many databases (MySQL) provide little support for that. So if you really need to do it in Toql, here is a way to go: Let's assume a table Todo : id what owner_id done 1 Clean kitchen 5 10% 2 Take garbage out 5 100% 3 Go shopping 2 50% and a Permission table: entity action owner_only TODO QUERY true TODO UPDATE true To ensure that a user with id 5 can only see his own rows 1 + 2 set up a permission field and build a custom field handler. Like so use toql::prelude::{FieldHandler, DefaultFieldHandler, SqlExpr, ParameterMap, SqlBuilderError, SqlArg, sql_expr}; #[derive(Toql)]\n#[toql(auto_key = true)]\nstruct Todo { #[toql(key)] id: u64, what: String, #[toql(sql=\"\", handler=\"permission_handler\", aux_param(name = \"entity\", value = \"TODO\"))] permission: String\n} // Here comes our permission field handler\n// We also want a custom filter function SC // so that we can filter for a specific permission.\n//\n// This allows the following toql queries\n// Todos with any permissions -> `*, permission ne ''` // Todos with UPDATE permission -> `*, permission fn sc 'UPDATE'` struct PermissionFieldHandler{ default_handler: defaultFieldHandler, // The default field handler gives us default filters, such as `ne`\n}; impl FieldHandler for PermissionFieldHandler\n{ fn build_select( &self, sql: SqlExpr, aux_params: &ParameterMap, ) -> Result<Option<SqlExpr>, SqlBuilderError> { // Get user_id from aux params (typically from web auth token) let user_id = aux_params.get(\"user_id\").unwrap_or(&SqlArg::Null); // Get entity from aux params (locally provided with permission handler) let entity = aux_params.get(\"entity\").unwrap_or(&SqlArg::Null).to_string(); // Build subselect // Notice our special .. alias, it will be resolved later by the query builder // Build a string list with all permissions that we have as owners let sql = sql_expr!(\"(SELECT GROUP_CONCAT( p.action) FROM Permission p \\ WHERE p.entity = ? AND \\ (p.owner_only = false OR ..owner_id = ?))\", entity, user_id); Ok(Some(sql)) } fn build_filter( &self, select: SqlExpr, filter: &FieldFilter, aux_params: &ParameterMap, ) -> Result<Option<SqlExpr>, SqlBuilderError> { match filter { // Support our custom SC filter that maps to the MySQL FIND_IN_FIELD function FieldFilter::Fn(name, args) => match name.as_str() { \"SC\" => { filter_sc(name, select, args) }, name @ _ => Err(SqlBuilderError::FilterInvalid(name.to_string())), }, _ => self.default_handler.build_filter(select, filter, aux_params), } }\n} pub fn filter_sc( name: &str, select: SqlExpr, args: &[SqlArg]\n) -> Result<Option<SqlExpr>, SqlBuilderError> { if args.len() != 1 { return Err(SqlBuilderError::FilterInvalid( \"filter `{}` expects exactly 1 argument\", name ))); } Ok(Some(sql_expr!(\"FIND_IN_SET (? , {})\", args[0], select)))\n} // Getter fucntion for the mapper\npub fn permission_handler() -> impl FieldHandler { PermissionFieldHandler:{ default_handler: DefaultFieldHandler::new(), }\n}","breadcrumbs":"Appendix » Row access control","id":"84","title":"Row access control"},"85":{"body":"Toql structs usually have a lot of Option types to make fields selectable with a query. Let's look how to attribute them with serde for smooth interaction.","breadcrumbs":"Appendix » Serde","id":"85","title":"Serde"},"86":{"body":"It's nice to omit unselected fields. This can easily achieved with #[serde(skip_serializing_if = \"Option::is_none\")]","breadcrumbs":"Appendix » Serializing","id":"86","title":"Serializing"},"87":{"body":"#[serde(skip_serializing_if = \"Option::is_none\")] age: Option<u8> #[serde(skip_serializing_if = \"Option::is_none\")] address: Option<Option<Join<Address>>> // Selectable left join","breadcrumbs":"Appendix » Serialize example","id":"87","title":"Serialize example"},"88":{"body":"Your server needs deserializing either when creating a new item or when updating an existing item","breadcrumbs":"Appendix » Deserializing","id":"88","title":"Deserializing"},"89":{"body":"#[derive(Toql)] #[toql(auto_key = true)] struct User { // 'default' allows missing field 'id' in Json // Needed typically for insert #[serde(default)] #[toql(key)] id: u64 // No Serde attribute: // Field must always be present in Json, but may be null -> None name: Option<String> // Never deserialize expressions #[serde(skip_deserializing)] #[toql(sql = \"(SELECT COUNT(*) From Book b WHERE b.author_id = ..id)\")] pub number_of_books: Option<u64>, // See comment below #[serde(default, deserialize_with=\"des_double_option\")] address: Option<Option<Join<Address>>> } Notice the double Option on the selectable left join address . When deserializing from JSON the following mapping works: JSON Rust undefined None null Some(None) value Some(Some(value)) To make this happen you need a custom deserialization function: use serde::{Deserializer, Deserialze}; pub fn des_double_option<'de, T, D>(de: D) -> Result<Option<Option<T>>, D::Error>\nwhere T: Deserialize<'de>, D: Deserializer<'de>,\n{ Deserialize::deserialize(de).map(Some)\n} Now you get the following: If you omit address in your JSON #[serde(default)] kicks in and you get None . If you send \"addess\": null , you get Some(None) . If you send \"address: {\"id\": 5}\" , you get Some(Some(Join::Key(AddressKey{id:5}))) . If you send \"address: {\"id\": 5, ...}\" , you get Some(Some(Join::Entity(Address{id:5, ...}))) . Toql update will now work as expected.","breadcrumbs":"Appendix » Deserialize example:","id":"89","title":"Deserialize example:"},"9":{"body":"When entities have composite keys or you want to write generic code it's easier to work with keys. Key structs are automatically derived from the Toql derive and are located where the struct is. Keys contain all fields from the struct that are marked with #[toql(key)] . With a single key this is possible use toql::prelude::query; let k = UserKey::from(5); // Easier than UserKey{id:5};\nlet q1 = query!(User, \"id eq ?\", k);\nlet q2 = query!(User, \"*, {}\", Query::from(k));\nlet q3 = query!(User, \"*, {}\", k); With multiple keys you can do this: use toql::prelude::{query, Query}; let ks = vec![UserKey::from(1), UserKey::from(2)]; let q4 = query!(User, \"*, id in ?\", ks); let qk = ks.iter().collect::<Query<_>>();\nlet q5 = query!(User, \"*, {}\", qk); The query q4 only works for a simple key, not a composite key, whereas qk works for any type of key. If you deal with entities you can get their keys from them (notice the Keyed trait). See here use toql::prelude::{query, Keyed, Query}; let e = User{id:1}; let q5 = query!(User, \"{}\", e.key())\nlet q6 = Query::from(e.key()); Both q5 and q6 end up the same. Or with mutiple entities: use toql::prelude::{query, MapKey, Query}; let es = vec![User{id:1}, User{id:2}]; let qk = es.iter().map_key().collect::<Query<_>>();\nlet q7 = query!(User, \"*, {}\", qk); Do you like the collect style? There is a nifty implementation detail: If you collect keys, they will always be concatenated with OR , queries however will be concatenated with AND . Compare q8 and q10 here: let ks = Vec[UserKey{id:5}, UserKey{id:6}];\nlet q8 = ks.iter().collect::<Query<_>>(); // -> query!(User, \"(id eq5; id eq 6)\") let q9 = query!(User, \"username\");\nlet q10 = [q9, q8].iter().collect<Query<_>>(); // -> query!(User, \"username, (id eq 5; id eq 6)\")","breadcrumbs":"Api » Working with keys","id":"9","title":"Working with keys"},"90":{"body":"Toql generates a lot of code. Mostly from the Toql derive, but also from various macros, such as query! . Th elibrary does not have any serious software tests and the test matrix is huge. So it may happen that you hit a bug. the generated code doesn't compile. Or you just want to develop a new feature! To debug Toql generated code, follow these steps: If you have a lot of modules move the affected mod at the end of the mod list. (So generated code will appear in the terminal last). Run cargo with the logger enabled and a single job: RUST_LOG=DEBUG cargo check --jobs=1 Copy all the logged code from the derived struct and paste it into the source file. Remove the log headers by regex replacing \\[2.* with empty string. There should be 9 occurences. Copy your derived struct. Comment out your derived struct. On the copied struct remove all references to Toql. Format your document and debug!","breadcrumbs":"Appendix » Debugging Toql","id":"90","title":"Debugging Toql"},"91":{"body":"If you have issues with Toql you can post them on GitHub .","breadcrumbs":"Appendix » Support","id":"91","title":"Support"}},"length":92,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"1":{"df":1,"docs":{"83":{"tf":1.0}}},"2":{"0":{"df":1,"docs":{"5":{"tf":1.0}}},"2":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"3":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"5":{"df":0,"docs":{},"e":{"2":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"8":{":":{"3":{"0":{":":{"0":{"0":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"20":{"tf":1.7320508075688772},"74":{"tf":1.0},"78":{"tf":1.0}}},"1":{"0":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":2,"docs":{"20":{"tf":1.0},"84":{"tf":1.0}}},"df":2,"docs":{"6":{"tf":1.0},"84":{"tf":1.0}}},"2":{"df":3,"docs":{"68":{"tf":1.4142135623730951},"77":{"tf":2.0},"78":{"tf":1.7320508075688772}}},"5":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"6":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":1,"docs":{"75":{"tf":3.0}}},"8":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"df":13,"docs":{"10":{"tf":1.0},"20":{"tf":1.0},"38":{"tf":1.4142135623730951},"42":{"tf":2.0},"50":{"tf":1.4142135623730951},"6":{"tf":2.449489742783178},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"68":{"tf":1.0},"74":{"tf":2.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"84":{"tf":2.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"2":{"0":{"0":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"5":{"df":1,"docs":{"78":{"tf":1.0}}},"df":2,"docs":{"11":{"tf":1.0},"20":{"tf":1.4142135623730951}}},"5":{"0":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"7":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}},"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"73":{"tf":1.0}}}}},"df":7,"docs":{"10":{"tf":1.0},"48":{"tf":1.0},"6":{"tf":2.449489742783178},"68":{"tf":1.0},"75":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"90":{"tf":1.0}},"i":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"3":{"1":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"df":5,"docs":{"6":{"tf":1.7320508075688772},"60":{"tf":1.0},"75":{"tf":1.4142135623730951},"80":{"tf":1.0},"84":{"tf":1.0}}},"4":{"2":{"df":2,"docs":{"47":{"tf":1.4142135623730951},"6":{"tf":1.0}}},"df":2,"docs":{"6":{"tf":1.7320508075688772},"80":{"tf":1.0}}},"5":{"\"":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":3,"docs":{"74":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"df":11,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"38":{"tf":1.0},"6":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.7320508075688772},"84":{"tf":1.7320508075688772},"89":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"6":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"9":{"df":1,"docs":{"90":{"tf":1.0}}},"_":{"df":3,"docs":{"38":{"tf":1.4142135623730951},"6":{"tf":1.0},"84":{"tf":1.4142135623730951}}},"a":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"61":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":16,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"64":{"tf":1.7320508075688772},"66":{"tf":1.0},"84":{"tf":2.23606797749979}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":5,"docs":{"20":{"tf":1.0},"42":{"tf":1.7320508075688772},"5":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"1":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}},"2":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}},"3":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}},"4":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"19":{"tf":1.4142135623730951}},"i":{"d":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}}}}}},"df":13,"docs":{"18":{"tf":1.0},"19":{"tf":2.23606797749979},"34":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"66":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":2.23606797749979}}}}}}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"30":{"tf":1.0},"39":{"tf":1.0},"50":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"5":{"tf":1.0},"78":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}}}}}}},"df":8,"docs":{"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":4.123105625617661},"77":{"tf":2.0},"87":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{":":{"df":0,"docs":{},"u":{"6":{"4":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"a":{"df":8,"docs":{"35":{"tf":1.7320508075688772},"41":{"tf":2.0},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"62":{"tf":1.0},"66":{"tf":1.7320508075688772},"79":{"tf":1.0},"84":{"tf":1.0}},"s":{"=":{"\"":{"df":0,"docs":{},"t":{"b":{"1":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":5,"docs":{"0":{"tf":1.0},"35":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.0},"74":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"41":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":12,"docs":{"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":2.0},"33":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"84":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"77":{"tf":2.8284271247461903}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"39":{"tf":1.0},"44":{"tf":1.0}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"50":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":6,"docs":{"0":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"76":{"tf":1.0}}},"p":{"df":1,"docs":{"6":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"64":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"51":{"tf":1.0},"68":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"75":{"tf":1.0}}},"df":3,"docs":{"38":{"tf":1.0},"63":{"tf":1.0},"84":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}}}}},"[":{"0":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"63":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"(":{"a":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"63":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":10,"docs":{"21":{"tf":1.0},"42":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":2.0},"74":{"tf":1.7320508075688772},"78":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"c":{"df":2,"docs":{"68":{"tf":1.0},"72":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"47":{"tf":1.0}}},"s":{"c":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"df":4,"docs":{"24":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"53":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":7,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"34":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"28":{"tf":1.0},"40":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"65":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"83":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":2.6457513110645907},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"10":{"tf":1.0},"35":{"tf":1.0},"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":2,"docs":{"10":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}},"i":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"o":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":1,"docs":{"14":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"84":{"tf":1.0}},"e":{"=":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":7,"docs":{"38":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"46":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"67":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":9,"docs":{"11":{"tf":1.0},"35":{"tf":2.0},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"11":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"0":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.7320508075688772},"62":{"tf":1.0},"65":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"1":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{}}},"b":{".":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"35":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"13":{"tf":1.0},"28":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"4":{"tf":1.7320508075688772},"5":{"tf":2.6457513110645907},"64":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":6,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0},"47":{"tf":1.0},"61":{"tf":1.0},"84":{"tf":1.0}}},"i":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"z":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":3,"docs":{"35":{"tf":1.0},"69":{"tf":1.0},"89":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"40":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"81":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"51":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"89":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"5":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"39":{"tf":1.0},"75":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"23":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.0}}}}}}},"o":{"b":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"k":{"_":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":1,"docs":{"70":{"tf":1.0}},"i":{"d":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"74":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"74":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":11,"docs":{"10":{"tf":1.0},"14":{"tf":2.449489742783178},"19":{"tf":2.449489742783178},"20":{"tf":3.1622776601683795},"35":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"64":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"89":{"tf":1.0}},"s":{"_":{"*":{"\"":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"19":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"l":{"df":1,"docs":{"78":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"61":{"tf":1.0},"64":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"9":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"24":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"]":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"51":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"90":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":16,"docs":{"10":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"10":{"tf":1.0},"25":{"tf":1.0},"45":{"tf":1.0},"53":{"tf":1.0},"7":{"tf":1.0},"84":{"tf":1.0}}}}},"df":0,"docs":{}}}},"w":{"df":2,"docs":{"75":{"tf":1.4142135623730951},"78":{"tf":1.0}}}},"c":{".":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},":":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"26":{"tf":1.0},"5":{"tf":2.23606797749979}},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"6":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":9,"docs":{"14":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.4142135623730951},"69":{"tf":1.0},"81":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"28":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"43":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"74":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"5":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":1,"docs":{"90":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.7320508075688772}}}}}}},"s":{"c":{"a":{"d":{"df":1,"docs":{"22":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":6,"docs":{"2":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0},"46":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}}}}},"df":2,"docs":{"42":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"(":{"3":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"6":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"53":{"tf":1.0},"58":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"4":{"tf":1.4142135623730951},"64":{"tf":1.0},"7":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"k":{"df":7,"docs":{"0":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"38":{"tf":1.0},"56":{"tf":1.0},"64":{"tf":1.0},"90":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":2.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951},"44":{"tf":1.0},"54":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"79":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":17,"docs":{"0":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":2.23606797749979}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"82":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"=":{"\"":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":26,"docs":{"2":{"tf":1.4142135623730951},"25":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":2.23606797749979},"32":{"tf":2.0},"35":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":2.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"47":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":1.7320508075688772},"50":{"tf":2.23606797749979},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"64":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"69":{"tf":1.0},"8":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0}},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"=":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"e":{"df":4,"docs":{"35":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"84":{"tf":1.4142135623730951}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"m":{"a":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"77":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"23":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"24":{"tf":1.0},"8":{"tf":1.4142135623730951},"90":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"61":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}}},"x":{"df":1,"docs":{"77":{"tf":1.0}}}},"i":{"c":{"df":2,"docs":{"24":{"tf":1.0},"45":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":9,"docs":{"14":{"tf":1.4142135623730951},"20":{"tf":1.0},"40":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}}},"n":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"45":{"tf":1.0},"63":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":2.0}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"22":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.0}}}}}}},"n":{"df":1,"docs":{"5":{"tf":2.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"19":{"tf":2.23606797749979},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":13,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":2.0},"80":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"5":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{")":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"p":{")":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"5":{"tf":1.0},"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":4,"docs":{"35":{"tf":1.4142135623730951},"41":{"tf":1.0},"5":{"tf":2.23606797749979},"64":{"tf":1.4142135623730951}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":4,"docs":{"47":{"tf":1.0},"5":{"tf":1.0},"64":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"54":{"tf":1.0},"8":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"90":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.0},"20":{"tf":1.0},"47":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"52":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"|":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}},"df":6,"docs":{"20":{"tf":1.0},"35":{"tf":1.7320508075688772},"6":{"tf":3.3166247903554},"62":{"tf":1.0},"79":{"tf":1.0},"89":{"tf":1.0}},"i":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":7,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.7320508075688772},"41":{"tf":2.0},"42":{"tf":2.449489742783178},"50":{"tf":2.6457513110645907},"51":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"1":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"y":{".":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"29":{"tf":1.0},"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}}},"w":{"df":1,"docs":{"77":{"tf":2.0}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":3,"docs":{"35":{"tf":1.0},"5":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"2":{"tf":1.0},"25":{"tf":1.4142135623730951},"5":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":2,"docs":{"6":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":14,"docs":{"11":{"tf":1.0},"15":{"tf":1.4142135623730951},"36":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"62":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"89":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}}},"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{}},">":{"(":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":23,"docs":{"0":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"2":{"tf":2.0},"20":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":2.0},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.4142135623730951},"45":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":2.0},"52":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"8":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":2,"docs":{"1":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}},"b":{"df":2,"docs":{"30":{"tf":1.0},"67":{"tf":1.0}}},"df":1,"docs":{"89":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"83":{"tf":1.0},"90":{"tf":1.7320508075688772}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"24":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":15,"docs":{"13":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"58":{"tf":2.449489742783178},"62":{"tf":1.0},"67":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.4142135623730951},"89":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"0":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.7320508075688772},"62":{"tf":1.0},"66":{"tf":1.4142135623730951},"80":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":8,"docs":{"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":2.0},"54":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.4142135623730951}},"e":{"=":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":12,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"29":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.4142135623730951},"69":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.7320508075688772},"81":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":10,"docs":{"2":{"tf":1.4142135623730951},"25":{"tf":2.0},"26":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"8":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":2.0}},"e":{"(":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":25,"docs":{"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"41":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"s":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"'":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":2,"docs":{"72":{"tf":1.0},"73":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"66":{"tf":1.0},"67":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"(":{"d":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"'":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"\"":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"<":{"'":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"z":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":6,"docs":{"2":{"tf":1.0},"44":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":2.0}}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":10,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":1.0},"47":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"76":{"tf":1.0},"9":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"2":{"tf":1.0},"62":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"2":{"tf":1.0},"90":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"0":{"tf":1.0},"23":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"77":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"1":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}},"df":3,"docs":{"42":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"41":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":7,"docs":{"39":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"t":{"df":2,"docs":{"74":{"tf":1.0},"77":{"tf":1.0}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"23":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"1":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"14":{"tf":1.0},"23":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"9":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"df":1,"docs":{"1":{"tf":1.0}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"20":{"tf":1.4142135623730951},"6":{"tf":1.0},"90":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"74":{"tf":1.0}}}}}},"d":{"df":2,"docs":{"9":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"11":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"30":{"tf":1.0},"51":{"tf":1.0},"57":{"tf":1.0},"84":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":5,"docs":{"21":{"tf":1.0},"44":{"tf":1.0},"54":{"tf":1.0},"84":{"tf":2.23606797749979},"9":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"44":{"tf":1.0},"74":{"tf":1.0},"83":{"tf":2.23606797749979}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"q":{"5":{"df":1,"docs":{"9":{"tf":1.0}}},"df":12,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"38":{"tf":1.0},"68":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"77":{"tf":3.4641016151377544},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":2.0}},"n":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"75":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"38":{"tf":1.0},"63":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"71":{"tf":1.0},"8":{"tf":1.0}}}}}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"<":{"_":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"9":{"tf":1.0}}},"t":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"38":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":36,"docs":{"10":{"tf":2.23606797749979},"13":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":5,"docs":{"15":{"tf":1.0},"19":{"tf":1.0},"30":{"tf":1.4142135623730951},"70":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"48":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.4142135623730951},"28":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"t":{"df":1,"docs":{"83":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"38":{"tf":1.0},"45":{"tf":1.0},"6":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}},"e":{"d":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"30":{"tf":1.0},"67":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"19":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":22,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"55":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":2.449489742783178},"67":{"tf":1.7320508075688772},"69":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.7320508075688772},"78":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"f":{".":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"47":{"tf":1.0}}}},"l":{"df":0,"docs":{},"s":{"df":4,"docs":{"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"62":{"tf":1.0},"84":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":2,"docs":{"19":{"tf":1.4142135623730951},"35":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"54":{"tf":1.0},"90":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":58,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":2.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":3.7416573867739413},"2":{"tf":2.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"27":{"tf":2.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":2.23606797749979},"31":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"34":{"tf":2.23606797749979},"35":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.7320508075688772},"40":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":2.0},"54":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":3.0},"6":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":3.0},"68":{"tf":1.4142135623730951},"69":{"tf":2.23606797749979},"70":{"tf":2.23606797749979},"71":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"74":{"tf":2.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"79":{"tf":2.449489742783178},"8":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.0},"85":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.4142135623730951},"9":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.4142135623730951},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"!":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"18":{"tf":1.0},"19":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"=":{"\"":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"90":{"tf":1.0}}},"m":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"c":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}}},"df":16,"docs":{"10":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":3.1622776601683795},"42":{"tf":1.0},"6":{"tf":3.1622776601683795},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"68":{"tf":1.7320508075688772},"70":{"tf":1.0},"74":{"tf":2.23606797749979},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":2.449489742783178},"81":{"tf":1.4142135623730951},"84":{"tf":2.8284271247461903}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}},"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"13":{"tf":1.0},"20":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.4142135623730951},"73":{"tf":1.0},"83":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"32":{"tf":1.0},"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"2":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"n":{"df":11,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"24":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":2.0},"46":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"84":{"tf":2.23606797749979},"89":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":9,"docs":{"26":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}},"o":{"df":2,"docs":{"6":{"tf":1.0},"75":{"tf":1.4142135623730951}}},"r":{"b":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":3,"docs":{"51":{"tf":1.0},"59":{"tf":2.0},"67":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":11,"docs":{"19":{"tf":1.7320508075688772},"22":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":2.0},"53":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.0},"67":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"5":{"tf":1.0},"78":{"tf":1.7320508075688772},"90":{"tf":1.0}}}},"df":1,"docs":{"54":{"tf":1.0}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"42":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"35":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"u":{"c":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":7,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.7320508075688772},"54":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"84":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"29":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":27,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":2.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"4":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":2.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"89":{"tf":1.0}}}}}}},"df":1,"docs":{"81":{"tf":1.0}},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":2,"docs":{"75":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"35":{"tf":1.0},"45":{"tf":1.4142135623730951},"54":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":2.0}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"38":{"tf":1.0},"46":{"tf":1.4142135623730951},"63":{"tf":1.0},"84":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":2,"docs":{"0":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"24":{"tf":1.0},"38":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0}}}}},"o":{"df":2,"docs":{"50":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"47":{"tf":1.0}}}}}},"t":{"df":3,"docs":{"68":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"53":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"á":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":4,"docs":{"14":{"tf":1.0},"25":{"tf":1.0},"4":{"tf":1.0},"76":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"=":{"\"":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":9,"docs":{"0":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"46":{"tf":2.0},"62":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"76":{"tf":1.0},"84":{"tf":2.0}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}},"i":{"df":1,"docs":{"83":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"5":{"tf":1.0},"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"5":{"tf":1.0},"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":19,"docs":{"11":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":2.0},"44":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.7320508075688772},"53":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"30":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"73":{"tf":1.0},"77":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"i":{"d":{":":{"0":{"df":1,"docs":{"13":{"tf":1.0}}},"2":{"7":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"<":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":37,"docs":{"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"20":{"tf":2.6457513110645907},"21":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":2.23606797749979},"35":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":2.23606797749979},"42":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"50":{"tf":2.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":2.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"89":{"tf":2.23606797749979},"9":{"tf":2.449489742783178}},"e":{"a":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":6,"docs":{"19":{"tf":1.0},"21":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":6,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"38":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"24":{"tf":1.0},"4":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0}}}}}}},"i":{"c":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":9,"docs":{"19":{"tf":1.0},"25":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":2.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"24":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"20":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"31":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":5,"docs":{"11":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.7320508075688772}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"33":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"74":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"t":{"=":{"\"":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.7320508075688772}}}}},"df":19,"docs":{"13":{"tf":2.0},"14":{"tf":2.8284271247461903},"15":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"47":{"tf":2.449489742783178},"51":{"tf":1.0},"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"58":{"tf":2.449489742783178},"59":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"8":{"tf":1.0},"89":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"a":{"d":{"df":5,"docs":{"35":{"tf":1.0},"51":{"tf":1.0},"60":{"tf":1.4142135623730951},"66":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"50":{"tf":1.0}}}}},"f":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":5,"docs":{"4":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"80":{"tf":1.0}}}}},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"<":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"11":{"tf":1.0}}},"y":{"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":2.23606797749979}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":3,"docs":{"6":{"tf":1.4142135623730951},"82":{"tf":1.0},"91":{"tf":1.0}}}}},"t":{"'":{"df":17,"docs":{"1":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.4142135623730951},"86":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"20":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"22":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"4":{"tf":1.0},"90":{"tf":1.0}},"s":{"=":{"1":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"=":{"\"":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":2,"docs":{"50":{"tf":1.7320508075688772},"51":{"tf":1.0}}}}}},"df":34,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":2.0},"22":{"tf":1.0},"25":{"tf":1.0},"33":{"tf":2.8284271247461903},"39":{"tf":3.3166247903554},"40":{"tf":1.7320508075688772},"41":{"tf":2.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"44":{"tf":2.6457513110645907},"45":{"tf":2.8284271247461903},"46":{"tf":2.0},"47":{"tf":1.7320508075688772},"50":{"tf":2.449489742783178},"53":{"tf":2.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":2.23606797749979},"59":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":2.23606797749979},"74":{"tf":1.0},"77":{"tf":1.4142135623730951},"87":{"tf":1.0},"89":{"tf":1.0}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":2.23606797749979}}}}}},"k":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"(":{")":{")":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"11":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"5":{"tf":1.0},"77":{"tf":1.0}}}},"y":{"(":{"df":1,"docs":{"53":{"tf":1.0}}},"df":27,"docs":{"14":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":2.0},"20":{"tf":2.23606797749979},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":2.0},"47":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"51":{"tf":2.6457513110645907},"52":{"tf":2.6457513110645907},"53":{"tf":2.23606797749979},"54":{"tf":2.8284271247461903},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":2.0},"59":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":2.23606797749979},"79":{"tf":1.0},"9":{"tf":3.7416573867739413}},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"46":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"78":{"tf":1.0}},"n":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"<":{"_":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"9":{"tf":1.7320508075688772}}}},"l":{".":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"s":{"/":{"2":{"2":{"8":{"9":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"21":{"tf":1.0},"33":{"tf":1.4142135623730951},"42":{"tf":2.8284271247461903},"53":{"tf":1.7320508075688772},"68":{"tf":1.4142135623730951},"7":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"=":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"32":{"tf":1.0},"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"12":{"tf":1.0},"50":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"42":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"7":{"tf":1.0}}}}},"df":2,"docs":{"75":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"t":{"df":6,"docs":{"33":{"tf":1.0},"39":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"87":{"tf":1.0},"89":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"38":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"24":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"75":{"tf":1.4142135623730951},"80":{"tf":1.0}}}},"t":{"'":{"df":9,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"38":{"tf":1.0},"50":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}},"df":2,"docs":{"34":{"tf":1.0},"42":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"4":{"tf":1.0},"65":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}}},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":2,"docs":{"78":{"tf":1.0},"81":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}},"k":{"df":1,"docs":{"19":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":14,"docs":{"14":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"19":{"tf":2.0},"2":{"tf":1.0},"47":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":2.0},"6":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"79":{"tf":1.7320508075688772},"84":{"tf":1.0},"90":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":2,"docs":{"83":{"tf":1.0},"84":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}}},"l":{"df":1,"docs":{"38":{"tf":1.0}},"e":{"df":1,"docs":{"38":{"tf":2.0}}}},"o":{"a":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":17,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":2.6457513110645907},"66":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":1,"docs":{"90":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}}},"i":{"c":{"df":1,"docs":{"77":{"tf":2.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"0":{"tf":1.0},"5":{"tf":1.0},"79":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"24":{"tf":1.4142135623730951},"35":{"tf":1.0},"45":{"tf":1.0},"50":{"tf":1.0},"69":{"tf":1.0},"85":{"tf":1.0}}}},"t":{"df":5,"docs":{"25":{"tf":1.0},"50":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":1.0},"90":{"tf":1.4142135623730951}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":7,"docs":{"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"44":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"90":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"50":{"tf":1.0},"53":{"tf":1.0},"83":{"tf":1.0}}}},"df":1,"docs":{"75":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":6,"docs":{"13":{"tf":1.0},"24":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"47":{"tf":1.0},"84":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":21,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"35":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"9":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"38":{"tf":1.0},"69":{"tf":1.0},"84":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"k":{"df":10,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"38":{"tf":1.4142135623730951},"6":{"tf":2.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"52":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"59":{"tf":1.0},"69":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"g":{"df":17,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"25":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"50":{"tf":2.0},"51":{"tf":2.0},"55":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.7320508075688772}},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"=":{"\"":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"25":{"tf":1.0},"38":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}},"x":{"df":1,"docs":{"29":{"tf":1.0}},"e":{"d":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"28":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"d":{"df":1,"docs":{"90":{"tf":1.4142135623730951}},"e":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":2,"docs":{"1":{"tf":1.0},"84":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"4":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"83":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":10,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"34":{"tf":1.0},"45":{"tf":1.0},"6":{"tf":1.4142135623730951},"62":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"90":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":11,"docs":{"16":{"tf":1.0},"2":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.4142135623730951},"67":{"tf":1.0},"70":{"tf":1.0},"77":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}},"df":6,"docs":{"24":{"tf":1.0},"26":{"tf":1.0},"5":{"tf":2.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"79":{"tf":1.0}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"y":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}}}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"'":{"_":{",":{"c":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":8,"docs":{"22":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.4142135623730951},"61":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":41,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":2.0},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.0},"61":{"tf":1.0},"62":{"tf":2.0},"63":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":2.23606797749979},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"89":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"42":{"tf":1.0},"50":{"tf":1.4142135623730951}},"e":{"df":3,"docs":{"38":{"tf":1.0},"75":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"e":{"d":{"df":13,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.7320508075688772},"67":{"tf":1.0},"7":{"tf":1.0},"84":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"n":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"45":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"30":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"89":{"tf":1.0}}}}},"w":{"df":8,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"50":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"41":{"tf":1.0},"9":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"30":{"tf":1.0},"32":{"tf":1.0},"47":{"tf":1.4142135623730951}},"e":{"df":6,"docs":{"13":{"tf":1.4142135623730951},"18":{"tf":1.0},"57":{"tf":1.4142135623730951},"6":{"tf":1.0},"63":{"tf":1.0},"89":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"20":{"tf":1.4142135623730951},"44":{"tf":1.0},"51":{"tf":1.4142135623730951},"61":{"tf":1.0},"68":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"51":{"tf":1.0}}},"i":{"c":{"df":16,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.7320508075688772}}}}},"w":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"26":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"32":{"tf":2.0},"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":6,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":2.0},"75":{"tf":2.0},"89":{"tf":1.7320508075688772}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{":":{"df":0,"docs":{},"u":{"6":{"4":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"89":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":6,"docs":{"35":{"tf":1.0},"48":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}},"o":{".":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.7320508075688772},"14":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"1":{"tf":1.0},"67":{"tf":1.0}},"k":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"!":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"l":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"86":{"tf":1.0},"89":{"tf":1.0}}}}},"n":{"_":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"=":{"\"":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"42":{"tf":1.0},"62":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":3,"docs":{"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0}}}}}},"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":8,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.0},"6":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.0}},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}},"r":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"86":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}}}}},"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"<":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"87":{"tf":1.0},"89":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":12,"docs":{"20":{"tf":1.4142135623730951},"26":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"39":{"tf":1.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"83":{"tf":1.0},"89":{"tf":1.0}}}}},"u":{"6":{"4":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"c":{"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":11,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"47":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"17":{"tf":1.0},"28":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"72":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"82":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"m":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"\"":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"40":{"tf":1.0},"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"0":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.0},"64":{"tf":1.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.0},"84":{"tf":1.0},"90":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"df":1,"docs":{"84":{"tf":1.0}}}}}}},"p":{".":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"\"":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"(":{"0":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"(":{"0":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"u":{"6":{"4":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"35":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"6":{"tf":3.7416573867739413}},"r":{"df":1,"docs":{"6":{"tf":2.0}}}}},"r":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}},"df":9,"docs":{"11":{"tf":1.0},"35":{"tf":2.0},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":4,"docs":{"38":{"tf":1.0},"46":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}},"t":{"df":1,"docs":{"34":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}},"s":{"df":3,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}},"t":{"df":1,"docs":{"51":{"tf":1.4142135623730951}},"i":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.7320508075688772}}}},"df":3,"docs":{"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"47":{"tf":2.0}},"e":{"df":0,"docs":{},"q":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"1":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"63":{"tf":1.0}}},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"_":{"df":1,"docs":{"70":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":17,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":2.8284271247461903},"16":{"tf":1.7320508075688772},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"27":{"tf":1.0},"34":{"tf":1.4142135623730951},"47":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0}},"s":{"!":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"24":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"13":{"tf":1.0},"14":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"49":{"tf":1.0},"51":{"tf":1.0}}}}}}}},"df":2,"docs":{"5":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":3.4641016151377544}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"61":{"tf":1.0},"63":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.4142135623730951}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"1":{"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}},"2":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"39":{"tf":1.0},"44":{"tf":1.0}}},"3":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.0}}},"4":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.0}}},"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":6,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":2.23606797749979},"48":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"44":{"tf":1.0}}}}},"s":{"1":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.7320508075688772}}},"2":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"36":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"(":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":15,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"91":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}}}}},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.0}},"e":{"=":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"63":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"|":{"a":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":12,"docs":{"15":{"tf":1.0},"21":{"tf":2.23606797749979},"36":{"tf":1.0},"41":{"tf":2.449489742783178},"42":{"tf":2.0},"46":{"tf":1.4142135623730951},"6":{"tf":1.0},"61":{"tf":2.0},"62":{"tf":3.0},"63":{"tf":2.6457513110645907},"66":{"tf":1.4142135623730951},"81":{"tf":2.449489742783178}},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"32":{"tf":1.0},"33":{"tf":2.449489742783178},"34":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"52":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"16":{"tf":1.0},"20":{"tf":1.0},"40":{"tf":1.0},"47":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.7320508075688772}}}}}}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"14":{"tf":1.0},"24":{"tf":1.0},"51":{"tf":1.0},"8":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"11":{"tf":1.0}},"t":{"df":2,"docs":{"0":{"tf":1.0},"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"1":{"tf":1.0}}},"df":4,"docs":{"0":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"d":{"df":7,"docs":{"44":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"8":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"b":{"(":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":9,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":2.0},"46":{"tf":1.0},"63":{"tf":1.0},"84":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"19":{"tf":1.0},"80":{"tf":1.0}}}}}},"t":{"df":4,"docs":{"35":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"63":{"tf":1.0},"8":{"tf":1.0}}}}},"q":{"1":{"0":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":2,"docs":{"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"2":{"df":1,"docs":{"9":{"tf":1.0}}},"3":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"4":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}},"6":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"7":{"df":1,"docs":{"9":{"tf":1.0}}},"8":{"]":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"<":{"_":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"9":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":7,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"6":{"tf":2.0},"8":{"tf":1.7320508075688772}},"k":{"df":1,"docs":{"9":{"tf":2.23606797749979}}},"l":{"df":1,"docs":{"62":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":42,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.4142135623730951},"10":{"tf":2.23606797749979},"11":{"tf":2.0},"12":{"tf":2.0},"2":{"tf":2.0},"21":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":2.8284271247461903},"60":{"tf":1.4142135623730951},"62":{"tf":2.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"68":{"tf":2.0},"69":{"tf":2.0},"7":{"tf":2.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":3.7416573867739413},"81":{"tf":1.0},"84":{"tf":1.7320508075688772},"85":{"tf":1.0},"9":{"tf":2.23606797749979},"90":{"tf":1.0}}},"y":{"!":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"26":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":3.1622776601683795}}}}},"df":0,"docs":{}},".":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"(":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"s":{"(":{")":{".":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"k":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"7":{"tf":1.0}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{">":{"(":{"df":0,"docs":{},"s":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"47":{"tf":2.0}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"47":{"tf":2.0},"61":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"74":{"tf":1.0},"78":{"tf":1.0}}}}}},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"71":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"20":{"tf":1.0},"67":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"64":{"tf":1.0}}}},"w":{"df":6,"docs":{"0":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"41":{"tf":1.0},"62":{"tf":1.0},"81":{"tf":1.0}}}},"df":1,"docs":{"64":{"tf":1.0}},"e":{"a":{"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"52":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"50":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"81":{"tf":1.0},"90":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"90":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"41":{"tf":1.0},"47":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"34":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"25":{"tf":1.0},"69":{"tf":1.4142135623730951}}}}}}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":3,"docs":{"66":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":4,"docs":{"19":{"tf":1.0},"30":{"tf":1.0},"63":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":5,"docs":{"28":{"tf":2.0},"40":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":4,"docs":{"35":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.7320508075688772},"90":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"39":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":8,"docs":{"24":{"tf":1.0},"44":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.4142135623730951},"71":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.0}}}}}},"s":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"60":{"tf":1.0},"80":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"19":{"tf":1.0},"59":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"41":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"t":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"35":{"tf":1.0},"41":{"tf":1.0},"64":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"71":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":4,"docs":{"38":{"tf":1.0},"46":{"tf":1.0},"63":{"tf":1.0},"84":{"tf":1.7320508075688772}}}}}}}}}},"df":0,"docs":{}}}}}}}},"df":5,"docs":{"2":{"tf":1.0},"48":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"69":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"61":{"tf":1.0},"68":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":8,"docs":{"12":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"6":{"tf":2.23606797749979},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"67":{"tf":1.0},"84":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":8,"docs":{"0":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.4142135623730951},"64":{"tf":2.449489742783178},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"s":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"=":{"\"":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"=":{"\"":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{";":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"w":{"df":6,"docs":{"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"6":{"tf":3.3166247903554},"64":{"tf":1.4142135623730951},"84":{"tf":2.23606797749979}}}},"u":{"df":0,"docs":{},"n":{"df":3,"docs":{"48":{"tf":1.0},"69":{"tf":1.4142135623730951},"90":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"=":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":5,"docs":{"0":{"tf":1.4142135623730951},"2":{"tf":1.0},"24":{"tf":1.7320508075688772},"8":{"tf":1.0},"89":{"tf":1.0}}}}}},"s":{"a":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"67":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":10,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.7320508075688772},"6":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"c":{"df":1,"docs":{"84":{"tf":2.0}},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":3,"docs":{"28":{"tf":2.0},"40":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":1,"docs":{"12":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":1,"docs":{"0":{"tf":1.0}},"r":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"61":{"tf":1.4142135623730951},"75":{"tf":1.0},"81":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"13":{"tf":1.0},"20":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":20,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":2.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"7":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.4142135623730951},"84":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":34,"docs":{"21":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":2.449489742783178},"33":{"tf":2.449489742783178},"34":{"tf":2.449489742783178},"35":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"39":{"tf":2.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":2.449489742783178},"60":{"tf":2.8284271247461903},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":2.0},"70":{"tf":2.0},"71":{"tf":1.7320508075688772},"74":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":3.0},"80":{"tf":1.7320508075688772},"84":{"tf":2.0},"85":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"f":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":4,"docs":{"10":{"tf":1.0},"38":{"tf":1.0},"63":{"tf":1.0},"84":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"c":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"n":{"d":{"df":4,"docs":{"2":{"tf":1.7320508075688772},"44":{"tf":1.0},"54":{"tf":1.0},"89":{"tf":1.7320508075688772}}},"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"27":{"tf":1.0},"29":{"tf":1.0},"68":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":4,"docs":{"1":{"tf":1.0},"54":{"tf":1.0},"85":{"tf":1.4142135623730951},"89":{"tf":1.0}},"e":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"86":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},":":{":":{"df":0,"docs":{},"{":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"54":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"90":{"tf":1.0}}}}},"v":{"df":2,"docs":{"4":{"tf":1.0},"6":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"35":{"tf":1.0},"88":{"tf":1.0}}}}}},"t":{"df":12,"docs":{"13":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"30":{"tf":1.0},"47":{"tf":1.0},"83":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"16":{"tf":1.0},"47":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"5":{"tf":1.0}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"84":{"tf":1.0}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"28":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"w":{"df":4,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0},"8":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"60":{"tf":1.0},"64":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.0},"19":{"tf":1.7320508075688772},"26":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":5,"docs":{"22":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"42":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"6":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"15":{"tf":1.0},"30":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"30":{"tf":1.4142135623730951},"67":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":4,"docs":{"15":{"tf":1.0},"30":{"tf":1.0},"50":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"85":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":3,"docs":{"26":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"(":{"\"":{"b":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":1,"docs":{"20":{"tf":1.0}}}},"k":{"df":1,"docs":{"20":{"tf":1.0}}}},"1":{"6":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"{":{"df":0,"docs":{},"i":{"d":{":":{"5":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"(":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"{":{"df":0,"docs":{},"i":{"d":{":":{"5":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"42":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"51":{"tf":1.0},"61":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"r":{"c":{"df":3,"docs":{"0":{"tf":1.0},"41":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}},"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"35":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":1,"docs":{"84":{"tf":1.0}},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"47":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"l":{"=":{"\"":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}}},".":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"61":{"tf":1.0},"63":{"tf":1.0}},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"(":{".":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"!":{"(":{"\"":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"84":{"tf":1.0}}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":4,"docs":{"46":{"tf":1.0},"63":{"tf":1.4142135623730951},"8":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"38":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"84":{"tf":2.0}}}}}}}}}},"df":0,"docs":{}}}}},"df":32,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.7320508075688772},"28":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"35":{"tf":2.23606797749979},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"45":{"tf":1.7320508075688772},"48":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.4142135623730951},"62":{"tf":2.0},"63":{"tf":1.7320508075688772},"67":{"tf":2.0},"69":{"tf":2.0},"75":{"tf":1.0},"78":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"81":{"tf":1.0},"84":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"38":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"84":{"tf":2.0}}}}}}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"20":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"78":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":1,"docs":{"6":{"tf":1.0}}},"df":9,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.0},"6":{"tf":1.7320508075688772},"69":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"d":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"60":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"90":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"46":{"tf":1.0},"51":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"df":1,"docs":{"84":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":25,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":2.449489742783178},"84":{"tf":1.7320508075688772},"90":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":58,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.7320508075688772},"2":{"tf":2.8284271247461903},"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"38":{"tf":1.0},"39":{"tf":1.7320508075688772},"4":{"tf":1.0},"41":{"tf":2.23606797749979},"42":{"tf":1.4142135623730951},"44":{"tf":2.6457513110645907},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":2.0},"50":{"tf":2.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"54":{"tf":2.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":2.449489742783178},"67":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.7320508075688772},"90":{"tf":2.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"83":{"tf":1.0}},"s":{":":{":":{"df":0,"docs":{},"{":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"14":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"u":{"b":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"14":{"tf":1.0},"38":{"tf":1.0},"69":{"tf":1.0},"84":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"28":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"47":{"tf":1.0},"84":{"tf":1.4142135623730951},"91":{"tf":1.0}}}},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"s":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":5,"docs":{"12":{"tf":1.0},"35":{"tf":1.4142135623730951},"62":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"z":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"á":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"0":{".":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":2.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"i":{"d":{"df":4,"docs":{"28":{"tf":1.0},"35":{"tf":1.4142135623730951},"5":{"tf":1.0},"68":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"28":{"tf":1.4142135623730951},"35":{"tf":1.0}}},"a":{"b":{"df":0,"docs":{},"l":{"df":21,"docs":{"0":{"tf":1.4142135623730951},"16":{"tf":2.0},"19":{"tf":1.4142135623730951},"2":{"tf":2.23606797749979},"22":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.0},"30":{"tf":1.0},"34":{"tf":2.0},"47":{"tf":3.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"6":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":2.449489742783178},"69":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"81":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":11,"docs":{"11":{"tf":1.0},"21":{"tf":1.4142135623730951},"42":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0}},"n":{"df":2,"docs":{"35":{"tf":1.0},"44":{"tf":1.0}}}}}},"df":2,"docs":{"63":{"tf":1.0},"89":{"tf":1.4142135623730951}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{";":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"22":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"90":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"47":{"tf":1.0},"61":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":1,"docs":{"90":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"34":{"tf":1.0},"52":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}},"k":{"df":1,"docs":{"46":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"2":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"6":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"0":{"tf":1.0},"25":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0},"76":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":8,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"14":{"tf":1.0},"19":{"tf":1.0},"40":{"tf":1.0},"67":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":8,"docs":{"13":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":2.23606797749979},"41":{"tf":1.0},"42":{"tf":1.0},"6":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"73":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"51":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":4,"docs":{"51":{"tf":1.4142135623730951},"54":{"tf":1.0},"63":{"tf":1.4142135623730951},"84":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"35":{"tf":1.0},"84":{"tf":1.0}}}}},"l":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":1,"docs":{"70":{"tf":1.0}}},"q":{"df":0,"docs":{},"l":{"(":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":9,"docs":{"20":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"84":{"tf":1.0},"89":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"=":{"\"":{"`":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"=":{"\"":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"1":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":9,"docs":{"29":{"tf":1.0},"33":{"tf":1.4142135623730951},"39":{"tf":2.0},"44":{"tf":1.7320508075688772},"46":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":2.0},"59":{"tf":2.0},"60":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":27,"docs":{"20":{"tf":1.7320508075688772},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"41":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"50":{"tf":2.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":6,"docs":{"20":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951}},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"=":{"\"":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"=":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{";":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"l":{"=":{"\"":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"55":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"=":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"q":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"!":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"5":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"&":{"[":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"&":{"df":0,"docs":{},"q":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"q":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"q":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"q":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"q":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"&":{"[":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"20":{"tf":1.0},"26":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"10":{"tf":1.0}},"e":{":":{":":{"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"21":{"tf":1.0},"24":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"{":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"6":{"tf":2.0},"9":{"tf":1.7320508075688772}}},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"{":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":7,"docs":{"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"4":{"tf":2.0},"5":{"tf":1.0},"6":{"tf":2.0}}}}},"df":44,"docs":{"0":{"tf":2.0},"1":{"tf":2.0},"14":{"tf":1.0},"2":{"tf":2.6457513110645907},"20":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.7320508075688772},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":2.8284271247461903},"60":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"85":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":2.23606797749979},"91":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":2.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"r":{"a":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}},"t":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772},"83":{"tf":1.0},"9":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":9,"docs":{"0":{"tf":1.0},"28":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"6":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"6":{"tf":1.0}}}},"i":{"df":1,"docs":{"47":{"tf":1.0}},"v":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":7,"docs":{"20":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"89":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.0},"45":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":10,"docs":{"13":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"24":{"tf":1.4142135623730951},"58":{"tf":1.0},"7":{"tf":1.0},"78":{"tf":1.7320508075688772},"8":{"tf":2.0},"85":{"tf":1.0},"9":{"tf":1.0}},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":8,"docs":{"2":{"tf":1.0},"35":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{".":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}},"3":{"2":{"df":12,"docs":{"26":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"44":{"tf":1.4142135623730951},"48":{"tf":1.0},"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"6":{"4":{"df":17,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"20":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"32":{"tf":1.0}}},"c":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":7,"docs":{"13":{"tf":2.6457513110645907},"18":{"tf":2.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"6":{"tf":2.0},"61":{"tf":1.0},"63":{"tf":1.0}},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.0}}}}},"r":{"df":1,"docs":{"0":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.0},"69":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"55":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":19,"docs":{"14":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":3.4641016151377544},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"26":{"tf":1.0},"30":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.4142135623730951},"59":{"tf":3.872983346207417},"66":{"tf":2.0},"67":{"tf":2.23606797749979},"81":{"tf":1.0},"84":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.0}},"e":{"=":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":10,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"1":{".":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":46,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":2.449489742783178},"11":{"tf":2.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":2.0},"42":{"tf":1.4142135623730951},"46":{"tf":1.0},"5":{"tf":3.1622776601683795},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"6":{"tf":2.6457513110645907},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":2.0},"63":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":2.0},"7":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"84":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{".":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"1":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"2":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":2,"docs":{"26":{"tf":1.0},"74":{"tf":1.0}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"74":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"48":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"74":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"10":{"tf":1.0},"20":{"tf":2.449489742783178},"28":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"50":{"tf":2.23606797749979}}},"y":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":36,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":2.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":2.0},"39":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":2.23606797749979},"45":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":2.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"1":{"0":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":1,"docs":{"9":{"tf":1.0}}},"5":{"df":2,"docs":{"11":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"10":{"tf":1.4142135623730951},"54":{"tf":1.0}},"{":{"df":0,"docs":{},"i":{"d":{":":{"5":{"df":1,"docs":{"9":{"tf":1.0}}},"6":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"58":{"tf":1.0},"59":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}}}},"{":{"df":0,"docs":{},"i":{"d":{":":{"1":{"df":1,"docs":{"9":{"tf":1.0}}},"2":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"41":{"tf":1.0},"45":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"57":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":18,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"30":{"tf":1.0},"44":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":2.449489742783178},"59":{"tf":1.0},"62":{"tf":1.4142135623730951},"84":{"tf":1.0},"89":{"tf":1.0}},"e":{"=":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"90":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"!":{"[":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"1":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"{":{"df":0,"docs":{},"i":{"d":{":":{"1":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"<":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"55":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"48":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"[":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"{":{"df":0,"docs":{},"i":{"d":{":":{"5":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":8,"docs":{"14":{"tf":1.0},"19":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"48":{"tf":1.0},"50":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":2.0},"67":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":14,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"37":{"tf":1.7320508075688772},"42":{"tf":1.0},"44":{"tf":1.7320508075688772},"47":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}},"y":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":7,"docs":{"23":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"e":{"b":{"df":6,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951},"44":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.4142135623730951},"84":{"tf":1.0}},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"45":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"47":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"74":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":4,"docs":{"30":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.7320508075688772},"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"51":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"47":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"1":{"tf":1.0},"38":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":10,"docs":{"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"35":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.4142135623730951},"9":{"tf":2.0}}},"l":{"d":{"df":2,"docs":{"0":{"tf":1.0},"6":{"tf":2.0}}},"df":0,"docs":{}}},"w":{"df":1,"docs":{"50":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":8,"docs":{"23":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"79":{"tf":1.0},"9":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"8":{"tf":1.0}}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"6":{"tf":1.0},"81":{"tf":1.0}}}}}}}},"breadcrumbs":{"root":{"0":{".":{"1":{"df":1,"docs":{"83":{"tf":1.0}}},"2":{"0":{"df":1,"docs":{"5":{"tf":1.0}}},"2":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"3":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"5":{"df":0,"docs":{},"e":{"2":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"8":{":":{"3":{"0":{":":{"0":{"0":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"20":{"tf":1.7320508075688772},"74":{"tf":1.0},"78":{"tf":1.0}}},"1":{"0":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":2,"docs":{"20":{"tf":1.0},"84":{"tf":1.0}}},"df":2,"docs":{"6":{"tf":1.0},"84":{"tf":1.0}}},"2":{"df":3,"docs":{"68":{"tf":1.4142135623730951},"77":{"tf":2.0},"78":{"tf":1.7320508075688772}}},"5":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"6":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":1,"docs":{"75":{"tf":3.0}}},"8":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"df":13,"docs":{"10":{"tf":1.0},"20":{"tf":1.0},"38":{"tf":1.4142135623730951},"42":{"tf":2.0},"50":{"tf":1.4142135623730951},"6":{"tf":2.449489742783178},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"68":{"tf":1.0},"74":{"tf":2.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"84":{"tf":2.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"2":{"0":{"0":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"5":{"df":1,"docs":{"78":{"tf":1.0}}},"df":2,"docs":{"11":{"tf":1.0},"20":{"tf":1.4142135623730951}}},"5":{"0":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"7":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}},"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"73":{"tf":1.0}}}}},"df":7,"docs":{"10":{"tf":1.0},"48":{"tf":1.0},"6":{"tf":2.449489742783178},"68":{"tf":1.0},"75":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"90":{"tf":1.0}},"i":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"3":{"1":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"df":5,"docs":{"6":{"tf":1.7320508075688772},"60":{"tf":1.0},"75":{"tf":1.4142135623730951},"80":{"tf":1.0},"84":{"tf":1.0}}},"4":{"2":{"df":2,"docs":{"47":{"tf":1.4142135623730951},"6":{"tf":1.0}}},"df":2,"docs":{"6":{"tf":1.7320508075688772},"80":{"tf":1.0}}},"5":{"\"":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":3,"docs":{"74":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"df":11,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"38":{"tf":1.0},"6":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.7320508075688772},"84":{"tf":1.7320508075688772},"89":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"6":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"9":{"df":1,"docs":{"90":{"tf":1.0}}},"_":{"df":3,"docs":{"38":{"tf":1.4142135623730951},"6":{"tf":1.0},"84":{"tf":1.4142135623730951}}},"a":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"61":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":16,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"64":{"tf":1.7320508075688772},"66":{"tf":1.0},"84":{"tf":2.449489742783178}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":5,"docs":{"20":{"tf":1.0},"42":{"tf":1.7320508075688772},"5":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"1":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}},"2":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}},"3":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}},"4":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"19":{"tf":1.4142135623730951}},"i":{"d":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}}}}}},"df":13,"docs":{"18":{"tf":1.0},"19":{"tf":2.23606797749979},"34":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"66":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":2.23606797749979}}}}}}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"30":{"tf":1.0},"39":{"tf":1.0},"50":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"5":{"tf":1.0},"78":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}}}}}}},"df":8,"docs":{"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":4.123105625617661},"77":{"tf":2.0},"87":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{":":{"df":0,"docs":{},"u":{"6":{"4":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"a":{"df":8,"docs":{"35":{"tf":1.7320508075688772},"41":{"tf":2.0},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"62":{"tf":1.0},"66":{"tf":1.7320508075688772},"79":{"tf":1.0},"84":{"tf":1.0}},"s":{"=":{"\"":{"df":0,"docs":{},"t":{"b":{"1":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":5,"docs":{"0":{"tf":1.0},"35":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.0},"74":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"41":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":12,"docs":{"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":2.0},"33":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"84":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"77":{"tf":2.8284271247461903}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"39":{"tf":1.0},"44":{"tf":1.0}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"50":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":25,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"4":{"tf":1.4142135623730951},"56":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"p":{"df":1,"docs":{"6":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":11,"docs":{"64":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"51":{"tf":1.0},"68":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"75":{"tf":1.0}}},"df":3,"docs":{"38":{"tf":1.0},"63":{"tf":1.0},"84":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}}}}},"[":{"0":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"63":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"(":{"a":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"63":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":10,"docs":{"21":{"tf":1.0},"42":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":2.0},"74":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"81":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"c":{"df":2,"docs":{"68":{"tf":1.0},"72":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"47":{"tf":1.0}}},"s":{"c":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"df":4,"docs":{"24":{"tf":1.4142135623730951},"50":{"tf":2.0},"51":{"tf":1.7320508075688772},"53":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":7,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"34":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"28":{"tf":1.0},"40":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"65":{"tf":1.7320508075688772},"66":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772},"83":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":2.6457513110645907},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"10":{"tf":1.0},"35":{"tf":1.0},"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":2,"docs":{"10":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}},"i":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"o":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":1,"docs":{"14":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"84":{"tf":1.0}},"e":{"=":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":7,"docs":{"38":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"46":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"67":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":9,"docs":{"11":{"tf":1.0},"35":{"tf":2.0},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"11":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"0":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.7320508075688772},"62":{"tf":1.0},"65":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"1":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{}}},"b":{".":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"35":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"13":{"tf":1.0},"28":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"4":{"tf":1.7320508075688772},"5":{"tf":2.8284271247461903},"64":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":6,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0},"47":{"tf":1.0},"61":{"tf":1.0},"84":{"tf":1.0}}},"i":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"z":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":3,"docs":{"35":{"tf":1.0},"69":{"tf":1.0},"89":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"40":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"81":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"51":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"89":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"5":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"39":{"tf":1.0},"75":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"23":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.0}}}}}}},"o":{"b":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"k":{"_":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":1,"docs":{"70":{"tf":1.0}},"i":{"d":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"74":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"74":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":11,"docs":{"10":{"tf":1.0},"14":{"tf":2.449489742783178},"19":{"tf":2.449489742783178},"20":{"tf":3.1622776601683795},"35":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"64":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"89":{"tf":1.0}},"s":{"_":{"*":{"\"":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"19":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"l":{"df":1,"docs":{"78":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"61":{"tf":1.0},"64":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"9":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"24":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"]":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"51":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"90":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":16,"docs":{"10":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"10":{"tf":1.0},"25":{"tf":1.0},"45":{"tf":1.0},"53":{"tf":1.0},"7":{"tf":1.0},"84":{"tf":1.0}}}}},"df":0,"docs":{}}}},"w":{"df":2,"docs":{"75":{"tf":1.4142135623730951},"78":{"tf":1.0}}}},"c":{".":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},":":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"26":{"tf":1.0},"5":{"tf":2.23606797749979}},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"6":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":9,"docs":{"14":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.4142135623730951},"69":{"tf":1.0},"81":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"28":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"43":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"74":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"5":{"tf":1.0},"83":{"tf":1.0}}}}}}},"df":1,"docs":{"90":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.7320508075688772}}}}}}},"s":{"c":{"a":{"d":{"df":1,"docs":{"22":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":6,"docs":{"2":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0},"46":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}}}}},"df":2,"docs":{"42":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"(":{"3":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"6":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"53":{"tf":1.0},"58":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"4":{"tf":1.4142135623730951},"64":{"tf":1.0},"7":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"k":{"df":7,"docs":{"0":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"38":{"tf":1.0},"56":{"tf":1.0},"64":{"tf":1.0},"90":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":2.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951},"44":{"tf":1.0},"54":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"79":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":17,"docs":{"0":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":2.23606797749979}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"82":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"=":{"\"":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":26,"docs":{"2":{"tf":1.4142135623730951},"25":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":2.449489742783178},"32":{"tf":2.0},"35":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":2.23606797749979},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"47":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":2.0},"50":{"tf":2.23606797749979},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"64":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"69":{"tf":1.0},"8":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0}},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"=":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"e":{"df":4,"docs":{"35":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"84":{"tf":1.4142135623730951}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"m":{"a":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"77":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"23":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"60":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"24":{"tf":1.0},"8":{"tf":1.4142135623730951},"90":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"61":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}}},"x":{"df":1,"docs":{"77":{"tf":1.0}}}},"i":{"c":{"df":2,"docs":{"24":{"tf":1.0},"45":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":9,"docs":{"14":{"tf":1.4142135623730951},"20":{"tf":1.0},"40":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}}},"n":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"45":{"tf":1.0},"63":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":2.0}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"22":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.0}}}}}}},"n":{"df":1,"docs":{"5":{"tf":2.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"19":{"tf":2.23606797749979},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":13,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":2.0},"80":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"5":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{")":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"p":{")":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"5":{"tf":1.0},"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":4,"docs":{"35":{"tf":1.4142135623730951},"41":{"tf":1.0},"5":{"tf":2.23606797749979},"64":{"tf":1.4142135623730951}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":4,"docs":{"47":{"tf":1.0},"5":{"tf":1.0},"64":{"tf":1.0},"84":{"tf":1.7320508075688772}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"54":{"tf":1.0},"8":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"90":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.0},"20":{"tf":1.0},"47":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"52":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"|":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}},"df":6,"docs":{"20":{"tf":1.0},"35":{"tf":1.7320508075688772},"6":{"tf":3.3166247903554},"62":{"tf":1.0},"79":{"tf":1.0},"89":{"tf":1.0}},"i":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":7,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.7320508075688772},"41":{"tf":2.0},"42":{"tf":2.449489742783178},"50":{"tf":2.6457513110645907},"51":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"1":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"y":{".":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"29":{"tf":1.0},"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}}},"w":{"df":1,"docs":{"77":{"tf":2.0}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":3,"docs":{"35":{"tf":1.0},"5":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"2":{"tf":1.0},"25":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"54":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":2,"docs":{"6":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":14,"docs":{"11":{"tf":1.0},"15":{"tf":1.4142135623730951},"36":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"62":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.7320508075688772},"84":{"tf":1.7320508075688772},"89":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}}},"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{}},">":{"(":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":23,"docs":{"0":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"2":{"tf":2.0},"20":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":2.23606797749979},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.4142135623730951},"45":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":2.0},"52":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"8":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":2,"docs":{"1":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}},"b":{"df":2,"docs":{"30":{"tf":1.0},"67":{"tf":1.0}}},"df":1,"docs":{"89":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"83":{"tf":1.0},"90":{"tf":2.0}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"24":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":15,"docs":{"13":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"57":{"tf":2.0},"58":{"tf":2.449489742783178},"62":{"tf":1.0},"67":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.4142135623730951},"89":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"0":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.7320508075688772},"62":{"tf":1.0},"66":{"tf":1.4142135623730951},"80":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":8,"docs":{"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.23606797749979},"22":{"tf":2.0},"54":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.4142135623730951}},"e":{"=":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":12,"docs":{"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"29":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.4142135623730951},"69":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.7320508075688772},"81":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":49,"docs":{"2":{"tf":1.4142135623730951},"25":{"tf":2.23606797749979},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":2.0},"66":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":2.0}},"e":{"(":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":25,"docs":{"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"41":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"s":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"'":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":2,"docs":{"72":{"tf":1.0},"73":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"66":{"tf":1.0},"67":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"(":{"d":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"'":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"\"":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"<":{"'":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"z":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":6,"docs":{"2":{"tf":1.0},"44":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772},"89":{"tf":2.23606797749979}}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":10,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":1.0},"47":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"76":{"tf":1.0},"9":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"2":{"tf":1.0},"62":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"2":{"tf":1.0},"90":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"0":{"tf":1.0},"23":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"77":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"1":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}},"df":3,"docs":{"42":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"41":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":7,"docs":{"39":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"t":{"df":2,"docs":{"74":{"tf":1.0},"77":{"tf":1.0}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"23":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"1":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"14":{"tf":1.0},"23":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"9":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"df":1,"docs":{"1":{"tf":1.0}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"20":{"tf":1.4142135623730951},"6":{"tf":1.0},"90":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"74":{"tf":1.0}}}}}},"d":{"df":2,"docs":{"9":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"11":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"30":{"tf":1.0},"51":{"tf":1.0},"57":{"tf":1.0},"84":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":5,"docs":{"21":{"tf":1.0},"44":{"tf":1.0},"54":{"tf":1.0},"84":{"tf":2.23606797749979},"9":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"44":{"tf":1.0},"74":{"tf":1.0},"83":{"tf":2.449489742783178}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"q":{"5":{"df":1,"docs":{"9":{"tf":1.0}}},"df":12,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"38":{"tf":1.0},"68":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"77":{"tf":3.4641016151377544},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":2.0}},"n":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"75":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"38":{"tf":1.0},"63":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"71":{"tf":1.0},"8":{"tf":1.0}}}}}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"<":{"_":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"9":{"tf":1.0}}},"t":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"38":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":36,"docs":{"10":{"tf":2.23606797749979},"13":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"47":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":5,"docs":{"15":{"tf":1.0},"19":{"tf":1.0},"30":{"tf":1.4142135623730951},"70":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"48":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.4142135623730951},"28":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"t":{"df":1,"docs":{"83":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"38":{"tf":1.0},"45":{"tf":1.0},"6":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}},"e":{"d":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"30":{"tf":1.0},"67":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"19":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":22,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.4142135623730951},"35":{"tf":2.0},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"55":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":2.449489742783178},"67":{"tf":1.7320508075688772},"69":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.7320508075688772},"78":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"f":{".":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"47":{"tf":1.0}}}},"l":{"df":0,"docs":{},"s":{"df":4,"docs":{"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"62":{"tf":1.0},"84":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":2,"docs":{"19":{"tf":1.4142135623730951},"35":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"54":{"tf":1.0},"90":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":58,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":2.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":3.872983346207417},"2":{"tf":2.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"27":{"tf":2.23606797749979},"28":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"30":{"tf":2.23606797749979},"31":{"tf":2.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"34":{"tf":2.23606797749979},"35":{"tf":1.0},"37":{"tf":1.7320508075688772},"38":{"tf":2.0},"40":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":2.0},"54":{"tf":1.0},"55":{"tf":2.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":3.0},"6":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":3.1622776601683795},"68":{"tf":1.4142135623730951},"69":{"tf":2.449489742783178},"70":{"tf":2.23606797749979},"71":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951},"74":{"tf":2.23606797749979},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"79":{"tf":2.449489742783178},"8":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":2.0},"85":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.4142135623730951},"9":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.4142135623730951},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"!":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"18":{"tf":1.0},"19":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"=":{"\"":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"90":{"tf":1.0}}},"m":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"c":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}}},"df":16,"docs":{"10":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":3.3166247903554},"42":{"tf":1.0},"6":{"tf":3.1622776601683795},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"68":{"tf":1.7320508075688772},"70":{"tf":1.0},"74":{"tf":2.449489742783178},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":2.6457513110645907},"81":{"tf":1.4142135623730951},"84":{"tf":2.8284271247461903}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}},"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"13":{"tf":1.0},"20":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.4142135623730951},"73":{"tf":1.0},"83":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"32":{"tf":1.0},"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"2":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"n":{"df":11,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"24":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":2.0},"46":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"84":{"tf":2.23606797749979},"89":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":9,"docs":{"26":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}},"o":{"df":2,"docs":{"6":{"tf":1.0},"75":{"tf":1.4142135623730951}}},"r":{"b":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":3,"docs":{"51":{"tf":1.0},"59":{"tf":2.0},"67":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":11,"docs":{"19":{"tf":1.7320508075688772},"22":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":2.0},"53":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.0},"67":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"5":{"tf":1.0},"78":{"tf":1.7320508075688772},"90":{"tf":1.0}}}},"df":1,"docs":{"54":{"tf":1.0}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"42":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"35":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"u":{"c":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":7,"docs":{"0":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.7320508075688772},"54":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"84":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"29":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":27,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":2.23606797749979},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"4":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":2.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"89":{"tf":1.0}}}}}}},"df":1,"docs":{"81":{"tf":1.0}},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":2,"docs":{"75":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"35":{"tf":1.0},"45":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":2.0}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"38":{"tf":1.0},"46":{"tf":1.4142135623730951},"63":{"tf":1.0},"84":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":2,"docs":{"0":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"24":{"tf":1.0},"38":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0}}}}},"o":{"df":2,"docs":{"50":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"47":{"tf":1.0}}}}}},"t":{"df":3,"docs":{"68":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"53":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"á":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":4,"docs":{"14":{"tf":1.0},"25":{"tf":1.0},"4":{"tf":1.0},"76":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"=":{"\"":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":9,"docs":{"0":{"tf":1.0},"37":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"46":{"tf":2.23606797749979},"62":{"tf":1.7320508075688772},"63":{"tf":2.0},"67":{"tf":1.4142135623730951},"76":{"tf":1.0},"84":{"tf":2.0}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}},"i":{"df":1,"docs":{"83":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"5":{"tf":1.0},"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"5":{"tf":1.0},"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":19,"docs":{"11":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":2.0},"44":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.7320508075688772},"53":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"30":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"73":{"tf":1.0},"77":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"i":{"d":{":":{"0":{"df":1,"docs":{"13":{"tf":1.0}}},"2":{"7":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"<":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":37,"docs":{"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"20":{"tf":2.6457513110645907},"21":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":2.23606797749979},"35":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":2.23606797749979},"42":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"50":{"tf":2.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":2.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"89":{"tf":2.23606797749979},"9":{"tf":2.449489742783178}},"e":{"a":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":6,"docs":{"19":{"tf":1.0},"21":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":6,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"38":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"24":{"tf":1.0},"4":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0}}}}}}},"i":{"c":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":9,"docs":{"19":{"tf":1.0},"25":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":2.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"24":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"20":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"31":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":5,"docs":{"11":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.7320508075688772}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"33":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"74":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"t":{"=":{"\"":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.7320508075688772}}}}},"df":19,"docs":{"13":{"tf":2.23606797749979},"14":{"tf":2.8284271247461903},"15":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"43":{"tf":2.0},"47":{"tf":2.449489742783178},"51":{"tf":1.0},"56":{"tf":2.0},"57":{"tf":1.0},"58":{"tf":2.6457513110645907},"59":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"8":{"tf":1.0},"89":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"a":{"d":{"df":5,"docs":{"35":{"tf":1.0},"51":{"tf":1.0},"60":{"tf":1.4142135623730951},"66":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"50":{"tf":1.0}}}}},"f":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":5,"docs":{"4":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"80":{"tf":1.0}}}}},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"<":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0}}},"y":{"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":2.23606797749979}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":3,"docs":{"6":{"tf":1.4142135623730951},"82":{"tf":1.0},"91":{"tf":1.0}}}}},"t":{"'":{"df":17,"docs":{"1":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.4142135623730951},"86":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"22":{"tf":1.0},"33":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"4":{"tf":1.0},"90":{"tf":1.0}},"s":{"=":{"1":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"=":{"\"":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":2,"docs":{"50":{"tf":2.0},"51":{"tf":1.0}}}}}},"df":34,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":2.0},"22":{"tf":1.0},"25":{"tf":1.0},"33":{"tf":3.0},"39":{"tf":3.4641016151377544},"40":{"tf":2.0},"41":{"tf":2.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"44":{"tf":2.8284271247461903},"45":{"tf":2.8284271247461903},"46":{"tf":2.23606797749979},"47":{"tf":1.7320508075688772},"50":{"tf":2.449489742783178},"53":{"tf":2.23606797749979},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":2.23606797749979},"59":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":2.23606797749979},"74":{"tf":1.0},"77":{"tf":1.7320508075688772},"87":{"tf":1.0},"89":{"tf":1.0}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":2.23606797749979}}}}}},"k":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"(":{")":{")":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"11":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"5":{"tf":1.0},"77":{"tf":1.0}}}},"y":{"(":{"df":1,"docs":{"53":{"tf":1.0}}},"df":27,"docs":{"14":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":2.0},"20":{"tf":2.23606797749979},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":2.0},"47":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"51":{"tf":2.6457513110645907},"52":{"tf":2.8284271247461903},"53":{"tf":2.23606797749979},"54":{"tf":3.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":2.0},"59":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":2.23606797749979},"79":{"tf":1.0},"9":{"tf":3.872983346207417}},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"46":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"78":{"tf":1.0}},"n":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"<":{"_":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"9":{"tf":1.7320508075688772}}}},"l":{".":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"s":{"/":{"2":{"2":{"8":{"9":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":21,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"21":{"tf":1.0},"33":{"tf":1.4142135623730951},"42":{"tf":2.8284271247461903},"53":{"tf":1.7320508075688772},"68":{"tf":1.7320508075688772},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"=":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"32":{"tf":1.0},"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"12":{"tf":1.0},"50":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"42":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"7":{"tf":1.0}}}}},"df":2,"docs":{"75":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"t":{"df":6,"docs":{"33":{"tf":1.0},"39":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"87":{"tf":1.0},"89":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"38":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"24":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"75":{"tf":1.4142135623730951},"80":{"tf":1.0}}}},"t":{"'":{"df":9,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"38":{"tf":1.0},"50":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}},"df":2,"docs":{"34":{"tf":1.0},"42":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"4":{"tf":1.0},"65":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}}},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":2,"docs":{"78":{"tf":1.0},"81":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}},"k":{"df":1,"docs":{"19":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":14,"docs":{"14":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"19":{"tf":2.0},"2":{"tf":1.0},"47":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":2.0},"6":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"79":{"tf":1.7320508075688772},"84":{"tf":1.0},"90":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":2,"docs":{"83":{"tf":1.0},"84":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}}},"l":{"df":1,"docs":{"38":{"tf":1.0}},"e":{"df":1,"docs":{"38":{"tf":2.0}}}},"o":{"a":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":17,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":2.8284271247461903},"66":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":1,"docs":{"90":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}}},"i":{"c":{"df":1,"docs":{"77":{"tf":2.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"0":{"tf":1.0},"5":{"tf":1.0},"79":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"24":{"tf":1.4142135623730951},"35":{"tf":1.0},"45":{"tf":1.0},"50":{"tf":1.0},"69":{"tf":1.0},"85":{"tf":1.0}}}},"t":{"df":5,"docs":{"25":{"tf":1.0},"50":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":1.0},"90":{"tf":1.4142135623730951}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":7,"docs":{"11":{"tf":1.0},"14":{"tf":1.7320508075688772},"19":{"tf":1.7320508075688772},"44":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772},"90":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"50":{"tf":1.0},"53":{"tf":1.0},"83":{"tf":1.0}}}},"df":1,"docs":{"75":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":6,"docs":{"13":{"tf":1.0},"24":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"47":{"tf":1.0},"84":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":21,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"35":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"9":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"38":{"tf":1.0},"69":{"tf":1.0},"84":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"k":{"df":10,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"38":{"tf":1.4142135623730951},"6":{"tf":2.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"52":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"59":{"tf":1.0},"69":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"g":{"df":17,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"25":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":2.0},"49":{"tf":1.7320508075688772},"50":{"tf":2.0},"51":{"tf":2.0},"55":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.7320508075688772}},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"=":{"\"":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"25":{"tf":1.0},"38":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}},"x":{"df":1,"docs":{"29":{"tf":1.0}},"e":{"d":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"28":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"d":{"df":1,"docs":{"90":{"tf":1.4142135623730951}},"e":{"df":1,"docs":{"61":{"tf":1.0}},"l":{"df":2,"docs":{"1":{"tf":1.0},"84":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"4":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"83":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":10,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"34":{"tf":1.0},"45":{"tf":1.0},"6":{"tf":1.4142135623730951},"62":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"90":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":11,"docs":{"16":{"tf":1.0},"2":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.4142135623730951},"67":{"tf":1.0},"70":{"tf":1.0},"77":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}},"df":6,"docs":{"24":{"tf":1.0},"26":{"tf":1.0},"5":{"tf":2.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"79":{"tf":1.0}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"y":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}}}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"'":{"_":{",":{"c":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":8,"docs":{"22":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.4142135623730951},"61":{"tf":1.0},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":41,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":2.0},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.0},"61":{"tf":1.0},"62":{"tf":2.0},"63":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":2.23606797749979},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":2.0},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"89":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"42":{"tf":1.0},"50":{"tf":1.4142135623730951}},"e":{"df":3,"docs":{"38":{"tf":1.0},"75":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"e":{"d":{"df":13,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.7320508075688772},"67":{"tf":1.0},"7":{"tf":1.0},"84":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"n":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"45":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"30":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"89":{"tf":1.0}}}}},"w":{"df":8,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":2.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"50":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"41":{"tf":1.0},"9":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"30":{"tf":1.0},"32":{"tf":1.0},"47":{"tf":1.4142135623730951}},"e":{"df":6,"docs":{"13":{"tf":1.4142135623730951},"18":{"tf":1.0},"57":{"tf":1.4142135623730951},"6":{"tf":1.0},"63":{"tf":1.0},"89":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"20":{"tf":1.4142135623730951},"44":{"tf":1.0},"51":{"tf":1.4142135623730951},"61":{"tf":1.0},"68":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"51":{"tf":1.0}}},"i":{"c":{"df":16,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.7320508075688772}}}}},"w":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"26":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"32":{"tf":2.0},"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":6,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":2.0},"75":{"tf":2.0},"89":{"tf":1.7320508075688772}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{":":{"df":0,"docs":{},"u":{"6":{"4":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"89":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":6,"docs":{"35":{"tf":1.0},"48":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}},"o":{".":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.7320508075688772},"14":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"1":{"tf":1.0},"67":{"tf":1.0}},"k":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"!":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"l":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"86":{"tf":1.0},"89":{"tf":1.0}}}}},"n":{"_":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"=":{"\"":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"42":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":3,"docs":{"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0}}}}}},"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":8,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.0},"6":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.0}},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}},"r":{"df":1,"docs":{"75":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"86":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}}}}},"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"<":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"87":{"tf":1.0},"89":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":12,"docs":{"20":{"tf":1.4142135623730951},"26":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"39":{"tf":1.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"83":{"tf":1.0},"89":{"tf":1.0}}}}},"u":{"6":{"4":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"c":{"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":11,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"47":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"17":{"tf":1.0},"28":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"72":{"tf":2.0},"73":{"tf":2.0},"82":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"m":{"df":4,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"\"":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"40":{"tf":1.0},"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"0":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.0},"64":{"tf":1.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.0},"84":{"tf":1.0},"90":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"df":1,"docs":{"84":{"tf":1.0}}}}}}},"p":{".":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"\"":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"(":{"0":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"(":{"0":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"u":{"6":{"4":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"35":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"6":{"tf":3.7416573867739413}},"r":{"df":1,"docs":{"6":{"tf":2.0}}}}},"r":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}},"df":9,"docs":{"11":{"tf":1.0},"35":{"tf":2.0},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":4,"docs":{"38":{"tf":1.0},"46":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}},"t":{"df":1,"docs":{"34":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}},"s":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"2":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}},"t":{"df":1,"docs":{"51":{"tf":1.4142135623730951}},"i":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.7320508075688772}}}},"df":3,"docs":{"16":{"tf":1.7320508075688772},"19":{"tf":1.0},"47":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"q":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"1":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":2.0},"63":{"tf":1.0}}},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"_":{"df":1,"docs":{"70":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":17,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":3.0},"16":{"tf":1.7320508075688772},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"27":{"tf":1.0},"34":{"tf":1.7320508075688772},"47":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0}},"s":{"!":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{")":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"24":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"13":{"tf":1.0},"14":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"49":{"tf":1.0},"51":{"tf":1.0}}}}}}}},"df":2,"docs":{"5":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":3.4641016151377544}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"61":{"tf":1.0},"63":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.4142135623730951}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"1":{"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}},"2":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"39":{"tf":1.0},"44":{"tf":1.0}}},"3":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.0}}},"4":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.0}}},"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":6,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":2.23606797749979},"48":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"44":{"tf":1.0}}}}},"s":{"1":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.7320508075688772}}},"2":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"36":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"(":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":15,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"91":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"11":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}}}}},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.0}},"e":{"=":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"63":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"|":{"a":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":12,"docs":{"15":{"tf":1.0},"21":{"tf":2.23606797749979},"36":{"tf":1.0},"41":{"tf":2.6457513110645907},"42":{"tf":2.0},"46":{"tf":1.4142135623730951},"6":{"tf":1.0},"61":{"tf":2.23606797749979},"62":{"tf":3.0},"63":{"tf":2.8284271247461903},"66":{"tf":1.4142135623730951},"81":{"tf":2.6457513110645907}},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"32":{"tf":1.0},"33":{"tf":2.6457513110645907},"34":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"52":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"16":{"tf":1.0},"20":{"tf":1.0},"40":{"tf":1.0},"47":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":2.0}}}}}}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"14":{"tf":1.0},"24":{"tf":1.0},"51":{"tf":1.0},"8":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"11":{"tf":1.0}},"t":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"1":{"tf":1.0}}},"df":4,"docs":{"0":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"d":{"df":7,"docs":{"44":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"8":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"b":{"(":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":9,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":2.0},"46":{"tf":1.0},"63":{"tf":1.0},"84":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"19":{"tf":1.0},"80":{"tf":1.0}}}}}},"t":{"df":4,"docs":{"35":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"63":{"tf":1.0},"8":{"tf":1.0}}}}},"q":{"1":{"0":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":2,"docs":{"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"2":{"df":1,"docs":{"9":{"tf":1.0}}},"3":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"4":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}},"6":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"7":{"df":1,"docs":{"9":{"tf":1.0}}},"8":{"]":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"<":{"_":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"9":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":7,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"6":{"tf":2.0},"8":{"tf":1.7320508075688772}},"k":{"df":1,"docs":{"9":{"tf":2.23606797749979}}},"l":{"df":1,"docs":{"62":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":48,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.4142135623730951},"10":{"tf":2.23606797749979},"11":{"tf":2.0},"12":{"tf":2.23606797749979},"2":{"tf":2.0},"21":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.7320508075688772},"29":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":2.8284271247461903},"60":{"tf":1.4142135623730951},"62":{"tf":2.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"68":{"tf":2.23606797749979},"69":{"tf":2.23606797749979},"7":{"tf":2.23606797749979},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"8":{"tf":3.872983346207417},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"85":{"tf":1.0},"9":{"tf":2.23606797749979},"90":{"tf":1.0}}},"y":{"!":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"26":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":3.1622776601683795}}}}},"df":0,"docs":{}},".":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"(":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"s":{"(":{")":{".":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"k":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"7":{"tf":1.0}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{">":{"(":{"df":0,"docs":{},"s":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":2.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"47":{"tf":2.0}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"47":{"tf":2.0},"61":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"74":{"tf":1.0},"78":{"tf":1.0}}}}}},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"71":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"20":{"tf":1.0},"67":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"64":{"tf":1.0}}}},"w":{"df":6,"docs":{"0":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"41":{"tf":1.0},"62":{"tf":1.0},"81":{"tf":1.0}}}},"df":1,"docs":{"64":{"tf":1.0}},"e":{"a":{"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"84":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"52":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"50":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"81":{"tf":1.0},"90":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"90":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"41":{"tf":1.0},"47":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"34":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"25":{"tf":1.0},"69":{"tf":1.4142135623730951}}}}}}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":3,"docs":{"66":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":4,"docs":{"19":{"tf":1.0},"30":{"tf":1.0},"63":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":5,"docs":{"28":{"tf":2.23606797749979},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"49":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":4,"docs":{"35":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.7320508075688772},"90":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"39":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":8,"docs":{"24":{"tf":1.0},"44":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.4142135623730951},"71":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.0}}}}}},"s":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"60":{"tf":1.0},"80":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"19":{"tf":1.0},"59":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"41":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"t":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"35":{"tf":1.0},"41":{"tf":1.0},"64":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":4,"docs":{"38":{"tf":1.0},"46":{"tf":1.0},"63":{"tf":1.0},"84":{"tf":1.7320508075688772}}}}}}}}}},"df":0,"docs":{}}}}}}}},"df":5,"docs":{"2":{"tf":1.0},"48":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"69":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"61":{"tf":1.0},"68":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":8,"docs":{"12":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"6":{"tf":2.23606797749979},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"67":{"tf":1.0},"84":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":8,"docs":{"0":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.4142135623730951},"64":{"tf":2.6457513110645907},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951}},"s":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"=":{"\"":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"=":{"\"":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{";":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"w":{"df":6,"docs":{"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"6":{"tf":3.3166247903554},"64":{"tf":1.4142135623730951},"84":{"tf":2.449489742783178}}}},"u":{"df":0,"docs":{},"n":{"df":3,"docs":{"48":{"tf":1.0},"69":{"tf":1.4142135623730951},"90":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"=":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":5,"docs":{"0":{"tf":1.4142135623730951},"2":{"tf":1.0},"24":{"tf":1.7320508075688772},"8":{"tf":1.0},"89":{"tf":1.0}}}}}},"s":{"a":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"67":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":10,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.7320508075688772},"6":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"c":{"df":1,"docs":{"84":{"tf":2.0}},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":3,"docs":{"28":{"tf":2.0},"40":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":1,"docs":{"12":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":1,"docs":{"0":{"tf":1.0}},"r":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"61":{"tf":1.4142135623730951},"75":{"tf":1.0},"81":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"13":{"tf":1.0},"20":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":20,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":2.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"7":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.4142135623730951},"84":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":34,"docs":{"21":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":2.449489742783178},"33":{"tf":2.449489742783178},"34":{"tf":2.449489742783178},"35":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"39":{"tf":2.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":2.449489742783178},"60":{"tf":3.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":2.23606797749979},"70":{"tf":2.0},"71":{"tf":2.0},"74":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":3.1622776601683795},"80":{"tf":2.0},"84":{"tf":2.0},"85":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"f":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":4,"docs":{"10":{"tf":1.0},"38":{"tf":1.0},"63":{"tf":1.0},"84":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"c":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"n":{"d":{"df":4,"docs":{"2":{"tf":1.7320508075688772},"44":{"tf":1.0},"54":{"tf":1.0},"89":{"tf":1.7320508075688772}}},"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"27":{"tf":1.0},"29":{"tf":1.0},"68":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":4,"docs":{"1":{"tf":1.0},"54":{"tf":1.0},"85":{"tf":1.7320508075688772},"89":{"tf":1.0}},"e":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"86":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},":":{":":{"df":0,"docs":{},"{":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"54":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"90":{"tf":1.0}}}}},"v":{"df":2,"docs":{"4":{"tf":1.0},"6":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"35":{"tf":1.0},"88":{"tf":1.0}}}}}},"t":{"df":12,"docs":{"13":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"30":{"tf":1.0},"47":{"tf":1.0},"83":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"16":{"tf":1.0},"47":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"5":{"tf":1.0}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"84":{"tf":1.0}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"28":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"w":{"df":4,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0},"8":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"60":{"tf":1.0},"64":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.0},"19":{"tf":1.7320508075688772},"26":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":5,"docs":{"22":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"42":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"6":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"15":{"tf":1.0},"30":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"30":{"tf":1.4142135623730951},"67":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":4,"docs":{"15":{"tf":1.4142135623730951},"30":{"tf":1.0},"50":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"85":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":3,"docs":{"26":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"(":{"\"":{"b":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":1,"docs":{"20":{"tf":1.0}}}},"k":{"df":1,"docs":{"20":{"tf":1.0}}}},"1":{"6":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"{":{"df":0,"docs":{},"i":{"d":{":":{"5":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"(":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"{":{"df":0,"docs":{},"i":{"d":{":":{"5":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"42":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"51":{"tf":1.0},"61":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"r":{"c":{"df":3,"docs":{"0":{"tf":1.0},"41":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}},"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"35":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":1,"docs":{"84":{"tf":1.0}},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"47":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"l":{"=":{"\"":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}}},".":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"61":{"tf":1.0},"63":{"tf":1.0}},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"(":{".":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"!":{"(":{"\"":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"84":{"tf":1.0}}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":4,"docs":{"46":{"tf":1.0},"63":{"tf":1.4142135623730951},"8":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"38":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"84":{"tf":2.0}}}}}}}}}},"df":0,"docs":{}}}}},"df":32,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.7320508075688772},"28":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"35":{"tf":2.449489742783178},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"45":{"tf":2.0},"48":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.4142135623730951},"62":{"tf":2.0},"63":{"tf":1.7320508075688772},"67":{"tf":2.0},"69":{"tf":2.0},"75":{"tf":1.0},"78":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"81":{"tf":1.0},"84":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"38":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"84":{"tf":2.0}}}}}}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"20":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"78":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":1,"docs":{"6":{"tf":1.0}}},"df":9,"docs":{"0":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.0},"6":{"tf":1.7320508075688772},"69":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"d":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"60":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"90":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"46":{"tf":1.0},"51":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"df":1,"docs":{"84":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":25,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":2.449489742783178},"84":{"tf":1.7320508075688772},"90":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":58,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.7320508075688772},"2":{"tf":2.8284271247461903},"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"38":{"tf":1.0},"39":{"tf":1.7320508075688772},"4":{"tf":1.0},"41":{"tf":2.23606797749979},"42":{"tf":1.4142135623730951},"44":{"tf":2.8284271247461903},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":2.0},"50":{"tf":2.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"54":{"tf":2.23606797749979},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":2.6457513110645907},"67":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.7320508075688772},"90":{"tf":2.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"83":{"tf":1.0}},"s":{":":{":":{"df":0,"docs":{},"{":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"14":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"u":{"b":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"14":{"tf":1.0},"38":{"tf":1.0},"69":{"tf":1.0},"84":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"28":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"47":{"tf":1.0},"84":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951}}}},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"s":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":5,"docs":{"12":{"tf":1.0},"35":{"tf":1.4142135623730951},"62":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"z":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"á":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"0":{".":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":2.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"i":{"d":{"df":4,"docs":{"28":{"tf":1.0},"35":{"tf":1.4142135623730951},"5":{"tf":1.0},"68":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"28":{"tf":1.4142135623730951},"35":{"tf":1.0}}},"a":{"b":{"df":0,"docs":{},"l":{"df":21,"docs":{"0":{"tf":1.4142135623730951},"16":{"tf":2.23606797749979},"19":{"tf":1.4142135623730951},"2":{"tf":2.23606797749979},"22":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.23606797749979},"30":{"tf":1.0},"34":{"tf":2.0},"47":{"tf":3.1622776601683795},"50":{"tf":2.0},"51":{"tf":2.0},"53":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"6":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":2.449489742783178},"69":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"81":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":11,"docs":{"11":{"tf":1.0},"21":{"tf":1.4142135623730951},"42":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0}},"n":{"df":2,"docs":{"35":{"tf":1.0},"44":{"tf":1.0}}}}}},"df":2,"docs":{"63":{"tf":1.0},"89":{"tf":1.4142135623730951}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{";":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"22":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"90":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"47":{"tf":1.0},"61":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":1,"docs":{"90":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"34":{"tf":1.0},"52":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}},"k":{"df":1,"docs":{"46":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"2":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"6":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"0":{"tf":1.0},"25":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0},"76":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":8,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"14":{"tf":1.0},"19":{"tf":1.0},"40":{"tf":1.0},"67":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":8,"docs":{"13":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":2.23606797749979},"41":{"tf":1.0},"42":{"tf":1.0},"6":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"73":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"51":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":4,"docs":{"51":{"tf":1.4142135623730951},"54":{"tf":1.0},"63":{"tf":1.4142135623730951},"84":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"35":{"tf":1.0},"84":{"tf":1.0}}}}},"l":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":1,"docs":{"70":{"tf":1.0}}},"q":{"df":0,"docs":{},"l":{"(":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":9,"docs":{"20":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"84":{"tf":1.0},"89":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"=":{"\"":{"`":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"51":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"=":{"\"":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"1":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":9,"docs":{"29":{"tf":1.0},"33":{"tf":1.4142135623730951},"39":{"tf":2.0},"44":{"tf":1.7320508075688772},"46":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":2.0},"59":{"tf":2.0},"60":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":27,"docs":{"20":{"tf":1.7320508075688772},"26":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"41":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"50":{"tf":2.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":6,"docs":{"20":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951}},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"=":{"\"":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"=":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{";":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"l":{"=":{"\"":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"55":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"=":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"q":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"!":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"5":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"&":{"[":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"&":{"df":0,"docs":{},"q":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"q":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"q":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"q":{")":{".":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"q":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"&":{"[":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"20":{"tf":1.0},"26":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"10":{"tf":1.0}},"e":{":":{":":{"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"21":{"tf":1.0},"24":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"{":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"6":{"tf":2.0},"9":{"tf":1.7320508075688772}}},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"{":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":7,"docs":{"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"4":{"tf":2.0},"5":{"tf":1.0},"6":{"tf":2.0}}}}},"df":65,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":2.0},"14":{"tf":1.0},"2":{"tf":2.6457513110645907},"20":{"tf":1.7320508075688772},"25":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":2.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":2.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":2.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":2.8284271247461903},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"85":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":2.449489742783178},"91":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":2.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"r":{"a":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}},"t":{"df":6,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772},"83":{"tf":1.0},"9":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":9,"docs":{"0":{"tf":1.0},"28":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"6":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"6":{"tf":1.0}}}},"i":{"df":1,"docs":{"47":{"tf":1.0}},"v":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":7,"docs":{"20":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"89":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.0},"45":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":10,"docs":{"13":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"24":{"tf":1.4142135623730951},"58":{"tf":1.0},"7":{"tf":1.4142135623730951},"78":{"tf":2.0},"8":{"tf":2.0},"85":{"tf":1.0},"9":{"tf":1.0}},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":8,"docs":{"2":{"tf":1.0},"35":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{".":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}},"3":{"2":{"df":12,"docs":{"26":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"44":{"tf":1.4142135623730951},"48":{"tf":1.0},"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"6":{"4":{"df":17,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"20":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"32":{"tf":1.0}}},"c":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":7,"docs":{"13":{"tf":2.6457513110645907},"18":{"tf":2.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"6":{"tf":2.0},"61":{"tf":1.0},"63":{"tf":1.0}},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.0}}}}},"r":{"df":1,"docs":{"0":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.0},"69":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":19,"docs":{"14":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":3.4641016151377544},"2":{"tf":1.0},"20":{"tf":1.7320508075688772},"26":{"tf":1.0},"30":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.4142135623730951},"59":{"tf":4.0},"66":{"tf":2.0},"67":{"tf":2.23606797749979},"81":{"tf":1.0},"84":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.0}},"e":{"=":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":10,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"1":{".":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":46,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":2.449489742783178},"11":{"tf":2.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":2.0},"42":{"tf":1.4142135623730951},"46":{"tf":1.0},"5":{"tf":3.1622776601683795},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"6":{"tf":2.6457513110645907},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":2.0},"63":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":2.0},"7":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"84":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{".":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"1":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"2":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":2,"docs":{"26":{"tf":1.0},"74":{"tf":1.0}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"74":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"48":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"74":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"10":{"tf":1.0},"20":{"tf":2.449489742783178},"28":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"50":{"tf":2.23606797749979}}},"y":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":36,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":2.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":2.0},"39":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":2.23606797749979},"45":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":2.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"1":{"0":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":1,"docs":{"9":{"tf":1.0}}},"5":{"df":2,"docs":{"11":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"10":{"tf":1.4142135623730951},"54":{"tf":1.0}},"{":{"df":0,"docs":{},"i":{"d":{":":{"5":{"df":1,"docs":{"9":{"tf":1.0}}},"6":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"58":{"tf":1.0},"59":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}}}},"{":{"df":0,"docs":{},"i":{"d":{":":{"1":{"df":1,"docs":{"9":{"tf":1.0}}},"2":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"41":{"tf":1.0},"45":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"57":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":18,"docs":{"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"30":{"tf":1.0},"44":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":2.0},"58":{"tf":2.449489742783178},"59":{"tf":1.0},"62":{"tf":1.4142135623730951},"84":{"tf":1.0},"89":{"tf":1.0}},"e":{"=":{"\"":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"90":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"!":{"[":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"1":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"{":{"df":0,"docs":{},"i":{"d":{":":{"1":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"<":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"55":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"48":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"[":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"{":{"df":0,"docs":{},"i":{"d":{":":{"5":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":8,"docs":{"14":{"tf":1.0},"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"48":{"tf":1.0},"50":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":2.0},"67":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":14,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"37":{"tf":1.7320508075688772},"42":{"tf":1.0},"44":{"tf":1.7320508075688772},"47":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}},"y":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":7,"docs":{"23":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{},"e":{"b":{"df":6,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951},"44":{"tf":1.0},"54":{"tf":1.0},"6":{"tf":1.4142135623730951},"84":{"tf":1.0}},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"45":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"47":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"74":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":4,"docs":{"30":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"51":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"47":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"1":{"tf":1.0},"38":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":10,"docs":{"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"35":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.4142135623730951},"9":{"tf":2.23606797749979}}},"l":{"d":{"df":2,"docs":{"0":{"tf":1.0},"6":{"tf":2.0}}},"df":0,"docs":{}}},"w":{"df":1,"docs":{"50":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":8,"docs":{"23":{"tf":1.4142135623730951},"37":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"79":{"tf":1.0},"9":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"8":{"tf":1.0}}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"6":{"tf":1.0},"81":{"tf":1.0}}}}}}}},"title":{"root":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"66":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"s":{"c":{"a":{"d":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":3,"docs":{"28":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"41":{"tf":1.0},"76":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"25":{"tf":1.0},"65":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"88":{"tf":1.0},"89":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"83":{"tf":1.0}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"20":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.0},"42":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":11,"docs":{"19":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"55":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"38":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"76":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"45":{"tf":1.0},"54":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"37":{"tf":1.0},"46":{"tf":1.0},"63":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"43":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"<":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":7,"docs":{"33":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"53":{"tf":1.0},"77":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":4,"docs":{"17":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"9":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":3,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"48":{"tf":1.0},"49":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"80":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"_":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"72":{"tf":1.0},"73":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"s":{"df":1,"docs":{"12":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"24":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"14":{"tf":1.0},"34":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"41":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"12":{"tf":1.0},"29":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"62":{"tf":1.0},"65":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"28":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"71":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"64":{"tf":1.0},"71":{"tf":1.0}}}},"w":{"df":1,"docs":{"84":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"60":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"d":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"86":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"15":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"l":{"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"45":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"44":{"tf":1.0},"54":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"16":{"tf":1.0},"28":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"df":6,"docs":{"0":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"4":{"tf":1.0},"65":{"tf":1.0},"90":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"11":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"7":{"tf":1.0},"78":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"18":{"tf":1.0},"20":{"tf":1.0},"43":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":1,"docs":{"36":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"15":{"tf":1.0},"57":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"9":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"23":{"tf":1.0}}}}}}}}}},"pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}};