use serde::{Deserialize, Serialize};
use std::borrow::Cow;
fn save_toml<T : Serialize>(path : &str, data : &T) -> Result<(), std::io::Error> {
    std::fs::write(path, toml::ser::to_string(data).expect("Error Serializing data..."))
}

#[macro_export]
macro_rules! load_toml  {
    ($path : expr) => {
        {
            let bin = std::fs::read($path).unwrap_or_default().into_boxed_slice();
            toml::from_slice(&*bin).unwrap()
        }
    };
}

#[macro_export]
macro_rules! save_toml  {
    ($path : expr, $item : expr) => {
        {
            use std::fmt::Write;
            std::fs::write(
                $path,
                toml::ser::to_string_pretty($item).expect("Failed To Write Data To File...")
            )
        }
    };
}

