//! An example showing off the usage of `Deserialize` to automatically decode
//! TOML into a Rust `struct`, with enums.

mod storage;

use std::collections::HashMap;
use serde_derive::{Deserialize, Serialize};

#[derive(Debug, Deserialize, Serialize)]
struct Config {
    person  : HashMap<String, People>
}

#[derive(Debug, Deserialize, Serialize)]
struct People {
    name    : String,
    age     : usize,
    roles   : Vec<String>
}

fn main() {
        let mut person : Config = load_toml!("Person.toml");
        for p in &mut person.person {
            let mut entry = p.1;
            if contains_role(&entry.roles, "BANNED") {
                println!("Hello, {}! You are {} years old. YOU ARE BANNED...",entry.name, entry.age)
            } else {
                println!("Hello, {}! You are {} years old. Welcome to the Channel!", entry.name, entry.age)
            }

            if entry.age < 16 && !contains_role(&entry.roles, "BANNED") {
                entry.roles.push("BANNED".to_owned());
            }

            
        }

        save_toml!("Person.toml", &person).expect("Failed To Save Person Data...");

}

fn contains_role(role_list : &Vec<String>, role : &str) -> bool {
    for r in role_list {
        if r == role {return true;}
    }
    false
}

