+++
title = "Quick Start"
description = "Install and configure Toml Bombadil"
date = 2021-05-16
updated = 2021-05-16
draft = false
weight = 2
sort_by = "weight"
template = "docs/page.html"

[extra]
lead = "Install and configure Toml Bombadil"
toc = true
top = false
+++

## Installation

Toml Bombadil is a single rust binary. Currently, you can install it via [cargo](https://doc.rust-lang.org/cargo/),
the rust package manager, or via the Arch User Repository if you use an Arch based distro.

### Cargo

```bash
cargo install toml-bombadil
```

### Archlinux
```bash
pacman -S toml-bombadil
```

## Getting started

### Setup

If you already have some dotfiles on a git repository, no need to start from scratch:

```bash
git clone https://github.com/my_org/dotfiles
```

**1. Add a bombadil config to your dotfiles**

```bash
cd my_dotfiles && touch bombadil.toml
```

**2. Linking bombadil :**

For Bombadil to be able to run from any directory and use different config files we need to symlink its config to
`$XDG_CONFIG_DIR/bombadil.toml`:

```bash
bombadil install my_dotfiles/
```

⚠️ : Toml Bombadil will generate a copy of your dotfiles under `.dots`. If you use git to manage your dotfiles,
you need to add `.dots` to your `.gitignore`.

### Configuration

Toml Bombadil obviously uses the toml configuration format. here is a sample configuration :

```toml
# {dotfiles}/bombadil.toml

# Path to your dotfiles relative to your $HOME directory
dotfiles_dir = "my_dotfiles"

[settings]
# An array of toml files paths containing the variables to inject in your templatized dotfiles
# You can have multiple var files as long as variable names does not colide.
vars = [ "vars.toml" ]

# An array of post install shell commands
posthooks = [ "sway reload" ]

[settings.dots]

# A dot entry representing a symlink, `source` is relative to `dotfiles_dir`
# and `target` shall be relative to $HOME directory or absolute.
sway = { source = "sway", target = ".config/sway" }

# You can have as many dot entry as you want, linking files or directories
alacritty = { source = "alacritty.yml", target = ".config/alacritty/alacritty.yml" }
```

Once you are satisfied with your config, you can install your dotfiles:

```bash
bombadil link
```

### Clean up

If you want to remove symlinks generated by Toml Bombadil run the following:
```bash
bombadil unlink
```

### Workflow

Toml Bombadil behave slightly differently than other dotfiles managers: your dotfiles will not be directly symlinked
to their target locations. Instead, Toml Bombadil will create a copy of your dotfiles under `.dots` and then symlink
those copy.

The idea behind this is to inject variables into your dotfiles and allow you to compose various themes and profiles.
Because of this, you will need to reload your dotfiles with `bombadil link` whenever you make change.

A convenient way to work with Toml Bombadil would be to add a keyboard shortcut for `bombadil link` in your window manager.

### Going further

So far we have covered the basic on how to install and symlink your dotfiles, but Toml Bombadil as many more features.

