# Changelog
All notable changes to this project will be documented in this file. See [conventional commits](https://www.conventionalcommits.org/) for commit guidelines.

- - -
## [3.0.0](https://github.com/oknozor/toml-bombadil/compare/2.2.4..3.0.0) - 2022-02-23
#### Features
- use tera for templating - ([0a528fd](https://github.com/oknozor/toml-bombadil/commit/0a528fdf0cc284726ab0c25afc7702ebe8a2fcc5)) - Arne Beer
#### Miscellaneous Chores
- **(deps)** bump anyhow from 1.0.53 to 1.0.55 - ([787b4ba](https://github.com/oknozor/toml-bombadil/commit/787b4ba8e1993a78eddda77fc4b4bde5165047f8)) - dependabot[bot]
- Add codecov.yml and configure a threshold of 1% - ([c57a5d5](https://github.com/oknozor/toml-bombadil/commit/c57a5d567be68c5ef35d209c1c7a546031f16686)) - Sven-Hendrik Haase
- - -

## [2.2.4](https://github.com/oknozor/toml-bombadil/compare/2.2.3..2.2.4) - 2022-02-19
#### Bug Fixes
- run cargo bump early in cog.toml so Cargo.lock is updated after the release build - ([3880658](https://github.com/oknozor/toml-bombadil/commit/38806587c312d08a5e90269e351264d1312606bb)) - [@oknozor](https://github.com/oknozor)
- fix release github action workflow - ([eacf932](https://github.com/oknozor/toml-bombadil/commit/eacf932459051eb87b083dc0077d1419ee91cb9e)) - [@oknozor](https://github.com/oknozor)
#### Continuous Integration
- update codecov action - ([87eeeb5](https://github.com/oknozor/toml-bombadil/commit/87eeeb521910822f10c5bbee56b11ae7abe69625)) - [@oknozor](https://github.com/oknozor)
#### Documentation
- update displayed version to be bombadil version - ([409baf0](https://github.com/oknozor/toml-bombadil/commit/409baf0cdb803dd8305f95a77954534ef5cda88e)) - Thibaud Lepretre
- typo on punctuations - ([f6dae99](https://github.com/oknozor/toml-bombadil/commit/f6dae99abce5422540b7317dcee882c44bbaaaed)) - Thibaud Lepretre
- remove DSpeckhals example repositories - ([d516414](https://github.com/oknozor/toml-bombadil/commit/d5164148d6b8c6aace16e1849f494ee73c98eafa)) - Thibaud Lepretre
- Link bats HOWTO directly to abs github URL - ([d4d87a8](https://github.com/oknozor/toml-bombadil/commit/d4d87a85b591e63489ae5f99810a8fd3ad05015e)) - Thibaud Lepretre
#### Miscellaneous Chores
- use 2018 module imports - ([ae610e0](https://github.com/oknozor/toml-bombadil/commit/ae610e01d3c341989c39a0b2a7b50404706d4301)) - Arne Beer
- Add cargo.lock to project - ([bac3b31](https://github.com/oknozor/toml-bombadil/commit/bac3b316e8ea5a58e6d5d88894d9da1ddd29a7f9)) - Arne Beer
- - -

## [2.2.3](https://github.com/oknozor/toml-bombadil/compare/2.2.2..2.2.3) - 2021-12-30
#### Bug Fixes
- fix release version job output again - ([a9963e7](https://github.com/oknozor/toml-bombadil/commit/a9963e7d6f3bcb5f287e0d60b801d6defedf5732)) - [@oknozor](https://github.com/oknozor)
- - -

## [2.2.2](https://github.com/oknozor/toml-bombadil/compare/2.2.1..2.2.2) - 2021-12-30
#### Bug Fixes
- fix release version job output - ([0279e96](https://github.com/oknozor/toml-bombadil/commit/0279e96788bffc4e6a669ecc7e7538361db0b108)) - [@oknozor](https://github.com/oknozor)
- - -

## [2.2.1](https://github.com/oknozor/toml-bombadil/compare/2.2.0..2.2.1) - 2021-12-30
#### Bug Fixes
- use a single release github action workflow - ([e104eb0](https://github.com/oknozor/toml-bombadil/commit/e104eb023578bfd2aff7bb20db7b6f1e11d64f2a)) - [@oknozor](https://github.com/oknozor)
- - -

## [2.2.0](https://github.com/oknozor/toml-bombadil/compare/2.1.0..2.2.0) - 2021-12-30
#### Continuous Integration
- add cargo bump to build deps - ([a321566](https://github.com/oknozor/toml-bombadil/commit/a321566a4608f582fc8dc10c75c199f84a8fe914)) - [@oknozor](https://github.com/oknozor)
- add automated release, dependabot and github codeowners - ([9307457](https://github.com/oknozor/toml-bombadil/commit/93074570c2d70a501ba136cb645b53b13e284c13)) - [@oknozor](https://github.com/oknozor)
#### Documentation
- update documentation and shorten README - ([3780d09](https://github.com/oknozor/toml-bombadil/commit/3780d0984eaec42c7c64229e02810d5b94a58080)) - [@oknozor](https://github.com/oknozor)
#### Features
- add extra profiles - ([7741f39](https://github.com/oknozor/toml-bombadil/commit/7741f399069da6c48f58a44e102b73270e831170)) - [@oknozor](https://github.com/oknozor)
#### Miscellaneous Chores
- **(deps)** update dirs requirement from ^3 to ^4 - ([2ee87e0](https://github.com/oknozor/toml-bombadil/commit/2ee87e0d19d90f1adc17628aaf751056a08b71b5)) - dependabot[bot]
- fix clippy lints - ([482e9ae](https://github.com/oknozor/toml-bombadil/commit/482e9ae0408b6164a355f5c3f41288e7e43aeff9)) - [@oknozor](https://github.com/oknozor)
- - -

## [2.1.0](https://github.com/oknozor/toml-bombadil/compare/2.0.0..2.1.0) - 2021-11-21
#### Bug Fixes
- Fill in missing fmt argument in error message - ([14ed188](https://github.com/oknozor/toml-bombadil/commit/14ed18862e826e46642bdeb725d42a69da01e17a)) - David Tolnay
#### Documentation
- **(website)** fix website logo display - ([da2efdf](https://github.com/oknozor/toml-bombadil/commit/da2efdf140dfdd2f285dcbc57403d994a4f2800e)) - [@oknozor](https://github.com/oknozor)
- fix default language - ([9a43dca](https://github.com/oknozor/toml-bombadil/commit/9a43dca38467e053a6bdf447f3dd709e4d8b4dbe)) - [@oknozor](https://github.com/oknozor)
- document public functions - ([ede6828](https://github.com/oknozor/toml-bombadil/commit/ede68283e56b84244b46d730d83a948272da755a)) - [@oknozor](https://github.com/oknozor)
- update link command examples - ([8485455](https://github.com/oknozor/toml-bombadil/commit/8485455052c31534b442e974387ddaf9f731fa2e)) - [@oknozor](https://github.com/oknozor)
- Add use-case - ([c5e3c81](https://github.com/oknozor/toml-bombadil/commit/c5e3c8106c4e44c84d6209ff5984ddd3b603885f)) - Rohit Goswami
- Fix minor grammar issue - ([9f56272](https://github.com/oknozor/toml-bombadil/commit/9f562723ca0d1dce247f175756f8a04c5a8f7459)) - Rohit Goswami
- updated documentation for hooks - ([da56a4d](https://github.com/oknozor/toml-bombadil/commit/da56a4d481d2d78bdaa0fcd5c49239c5073feb37)) - [@travisdavis-ops](https://github.com/travisdavis-ops)
- add link to bombadil website in the readme - ([37096cd](https://github.com/oknozor/toml-bombadil/commit/37096cd03cd18dbefdff4f2e837a711bbc00b3ca)) - [@oknozor](https://github.com/oknozor)
#### Features
- clone dotfiles from remote - ([98afb6c](https://github.com/oknozor/toml-bombadil/commit/98afb6cb18b7c268e5ac64dcb00f567615aaf1f0)) - [@oknozor](https://github.com/oknozor)
- add pre&post hook to get command - ([2e7b651](https://github.com/oknozor/toml-bombadil/commit/2e7b651a851c6548d686ba393a17f0309827a585)) - [@travisdavis-ops](https://github.com/travisdavis-ops)
- add post install hooks, rename hooks to posthooks - ([4a21843](https://github.com/oknozor/toml-bombadil/commit/4a21843b4396e368120c90ee031c8e7ba7f3ce6c)) - [@travisdavis-ops](https://github.com/travisdavis-ops)
#### Miscellaneous Chores
- update cocogitto bump config - ([078d22b](https://github.com/oknozor/toml-bombadil/commit/078d22b290ba93a681156789107718222b326021)) - [@oknozor](https://github.com/oknozor)
- add github sponsor - ([20696fc](https://github.com/oknozor/toml-bombadil/commit/20696fc13ba33f0ad74930102081ce9113a32261)) - [@oknozor](https://github.com/oknozor)
- clippy lints and fmt * - ([36b82b0](https://github.com/oknozor/toml-bombadil/commit/36b82b02fa07bf0f908983906c3d95b2ddf377af)) - [@oknozor](https://github.com/oknozor)
#### Tests
- fix config path in tests - ([3032204](https://github.com/oknozor/toml-bombadil/commit/3032204e607c7abee71383f722455b4fca8752c2)) - [@oknozor](https://github.com/oknozor)
- fixed test code - ([337874e](https://github.com/oknozor/toml-bombadil/commit/337874e12cb386f484f4897e09e6d320b0fbc270)) - [@travisdavis-ops](https://github.com/travisdavis-ops)
- - -

## 2.0.0 - 2021-05-25


### Documentation

[0f6b10](https://github.com/oknozor/toml-bombadil/commit/0f6b104d0f55bec7a3ad46e41e9e8bb314085f74) - update intro and add a changelog blogpost on v2 - [oknozor](https://github.com/oknozor)

[becad6](https://github.com/oknozor/toml-bombadil/commit/becad6db4fd698665cb5797206758c467ed23e82) - update profiles and themes sections - [oknozor](https://github.com/oknozor)

[edbe4b](https://github.com/oknozor/toml-bombadil/commit/edbe4bff76e0e7dd9502a8df8ec6229858470f07) - update tests and docummentation on profile and vars - [oknozor](https://github.com/oknozor)

[b65d15](https://github.com/oknozor/toml-bombadil/commit/b65d150a1ab158be101f8cd8ec52754c92968a69) - update page on profiles and variables - [oknozor](https://github.com/oknozor)

[995ff2](https://github.com/oknozor/toml-bombadil/commit/995ff2d3e96d77d0ad8ac13c0ac0d9ab6ee92645) - add docs to the website, variable quick start etc - [oknozor](https://github.com/oknozor)

[48b74b](https://github.com/oknozor/toml-bombadil/commit/48b74b7cbeba11fe024c6e4a97a1601cc1996bb0) - add a toml bombadil website - [oknozor](https://github.com/oknozor)

[cf243e](https://github.com/oknozor/toml-bombadil/commit/cf243e94197e59e49b4ede630be8efba2f641ab5) - add minor corrections to contributing guidelines - [oknozor](https://github.com/oknozor)

[872e7f](https://github.com/oknozor/toml-bombadil/commit/872e7f3487f93bc0edf3f83cdaea7973add0e11f) - add small corrections to the readme - [oknozor](https://github.com/oknozor)

[aff785](https://github.com/oknozor/toml-bombadil/commit/aff785ca0faa75a117e9bc65d82cc68df66f653d) - update readme - [oknozor](https://github.com/oknozor)

[4f392a](https://github.com/oknozor/toml-bombadil/commit/4f392af305f98d7d0fee0077e7c7a92bb6d9d7d7) - add readme instruction for secret vars - [oknozor](https://github.com/oknozor)


### Continuous Integration

[e1b25d](https://github.com/oknozor/toml-bombadil/commit/e1b25d15df7628a21325d59c331304a24b2f53fa) - add a checkbranch script for cog bump - [oknozor](https://github.com/oknozor)

[f479e1](https://github.com/oknozor/toml-bombadil/commit/f479e1337bcfb452033e13427a536f7e79b100c0) - prepare website deployment from main branch - [oknozor](https://github.com/oknozor)

[7ef913](https://github.com/oknozor/toml-bombadil/commit/7ef913eb7f1d496409421291cb8f01c187b95aa9) - add github action step for e2e bats tests - [oknozor](https://github.com/oknozor)


### Miscellaneous Chores

[2717e8](https://github.com/oknozor/toml-bombadil/commit/2717e86f1e21dbcd5e7c595fa53f56b57cb80295) - fix action CD script - [oknozor](https://github.com/oknozor)

[ea6eac](https://github.com/oknozor/toml-bombadil/commit/ea6eac452bb5d78959e8a4fc485be197827a4578) - ignore aur package - [oknozor](https://github.com/oknozor)

[846550](https://github.com/oknozor/toml-bombadil/commit/8465509c62b82d507800cb5e93fe6798fdc9025f) - remove aur submodule, it can't be checked out in github CI - [oknozor](https://github.com/oknozor)

[8c1cf8](https://github.com/oknozor/toml-bombadil/commit/8c1cf88b4fce2556f09899a1596e3eeb82e8bb04) - add cargo home page and cog bump config - [oknozor](https://github.com/oknozor)

[1034c3](https://github.com/oknozor/toml-bombadil/commit/1034c36e11ca0dcc78d5b2d3d87eb433ff877bcb) - add aur package as a submodule - [oknozor](https://github.com/oknozor)

[37344d](https://github.com/oknozor/toml-bombadil/commit/37344d1c163d35bfecf66124e78a0602b7d1b91d) - deploy GH page with github actions - [oknozor](https://github.com/oknozor)

[8035c6](https://github.com/oknozor/toml-bombadil/commit/8035c61ef5e2dfeab77995325fae3f55478cf0d5) - fix bats-file submodule remote - [oknozor](https://github.com/oknozor)

[f5a326](https://github.com/oknozor/toml-bombadil/commit/f5a326a5d79e0a19a1344c58d3436f04720a5167) - fix clippy lints - [oknozor](https://github.com/oknozor)

[a69ab2](https://github.com/oknozor/toml-bombadil/commit/a69ab255c8a287a4f7e6aadb3fefdf0893d4fee1) - fmt all - [oknozor](https://github.com/oknozor)

[443e2e](https://github.com/oknozor/toml-bombadil/commit/443e2e6b3ab4e5fd4bcb9a19e971b94be0a6a036) - add contributors and bump hook to cog config - [oknozor](https://github.com/oknozor)

[99176d](https://github.com/oknozor/toml-bombadil/commit/99176dd79b19cefd80e973213f424def7c3dd994) - fix clippy lints - [oknozor](https://github.com/oknozor)

[6608b9](https://github.com/oknozor/toml-bombadil/commit/6608b9c4924ac351d91efb63435311d826565cf5) - fmt all - [oknozor](https://github.com/oknozor)

[4d7fc7](https://github.com/oknozor/toml-bombadil/commit/4d7fc733f0cc1074ab8c0a4465249a5366cbb7be) - Address review comments - [DSpeckhals](https://github.com/DSpeckhals)

[cd748d](https://github.com/oknozor/toml-bombadil/commit/cd748d21a294bb598f857b022455963aeb91a6fe) - bump crates.io version - [oknozor](https://github.com/oknozor)

[107ac9](https://github.com/oknozor/toml-bombadil/commit/107ac944ec4252a2c161876304860ef2920b79f0) - 1.11.2 - [oknozor](https://github.com/oknozor)

[abb91c](https://github.com/oknozor/toml-bombadil/commit/abb91c214da714bfe40a1f380f2e103f6ea06690) - add cocogitto config - [oknozor](https://github.com/oknozor)


### Tests

[29be69](https://github.com/oknozor/toml-bombadil/commit/29be6918539c17936944e8fcdf1699b113b50e92) - add dockerized bats test suite - [oknozor](https://github.com/oknozor)


### Features

[babc78](https://github.com/oknozor/toml-bombadil/commit/babc78b4e9102b4ca63e831958e141506d6aa3fc) - add preinstall configuration clean up - [oknozor](https://github.com/oknozor)

[b49bdb](https://github.com/oknozor/toml-bombadil/commit/b49bdb85c808709f0184122380998c25e1d7cda3) - add scoped variables - [oknozor](https://github.com/oknozor)

[03a725](https://github.com/oknozor/toml-bombadil/commit/03a7250aa0d4553d61ab150457eb272fc6bb2870) - implement ignore glob pattern - [oknozor](https://github.com/oknozor)

[9a89a9](https://github.com/oknozor/toml-bombadil/commit/9a89a92dabb799362d5a3da7d9c2786174200f9e) - Add command for shell completions generation - [DSpeckhals](https://github.com/DSpeckhals)

[fa56af](https://github.com/oknozor/toml-bombadil/commit/fa56afa9af88081e1bf0261c7a110213900aaf14) - add profile flag for get command - [oknozor](https://github.com/oknozor)

[d51567](https://github.com/oknozor/toml-bombadil/commit/d515673b43a6df68d8a051ffcf681271f422515e) - add armored gpg values - [oknozor](https://github.com/oknozor)

[0de10b](https://github.com/oknozor/toml-bombadil/commit/0de10b113e667fd07d95c996af7ac41364f85121) - add get command for metadata - [DSpeckhals](https://github.com/DSpeckhals)

[9abac9](https://github.com/oknozor/toml-bombadil/commit/9abac997769aa993df163a25ec4db6bb905ecc6f) - add unlink command - [DSpeckhals](https://github.com/DSpeckhals)

[4d3510](https://github.com/oknozor/toml-bombadil/commit/4d35106bd57d118f6eba171d75d0761d53075459) - gpg dummy implementation - [oknozor](https://github.com/oknozor)


### Bug Fixes

[2e5753](https://github.com/oknozor/toml-bombadil/commit/2e57530307896b03106d1ebd6545a7399f23c01a) - Secrets are now correctly decryted and injected on install - [oknozor](https://github.com/oknozor)

[aa64d5](https://github.com/oknozor/toml-bombadil/commit/aa64d572edc079bb1fca3f4ab9c0dcf5e59039c6) - fix toc ordering - [oknozor](https://github.com/oknozor)

[3c16c8](https://github.com/oknozor/toml-bombadil/commit/3c16c82f5790d259b538c2ee34a8fb4747aa333d) - unlink command now correctly remove dots based on previous config - [oknozor](https://github.com/oknozor)

[b7cdd3](https://github.com/oknozor/toml-bombadil/commit/b7cdd356a1989e6cd2d54d8e280b099487d98255) - fix empty var files in dot overrides - [oknozor](https://github.com/oknozor)

[6f5d9b](https://github.com/oknozor/toml-bombadil/commit/6f5d9ba404ff0d6ed5bd43980cfa14c514d6c223) - fix default var path typo - [oknozor](https://github.com/oknozor)

[532ae9](https://github.com/oknozor/toml-bombadil/commit/532ae93d62b55c662e428e7de202449d5c88d0f8) - ignore all varfile for a dot across profile - [oknozor](https://github.com/oknozor)

[2c7dcc](https://github.com/oknozor/toml-bombadil/commit/2c7dcce0dfda0eed0e76feaa3e40100a148d0e38) - resolve % refence in dot entries - [oknozor](https://github.com/oknozor)

[8fe546](https://github.com/oknozor/toml-bombadil/commit/8fe546282d22e18b6b6738adfbb2bf2322fad416) - add gpg keypair to CI - [oknozor](https://github.com/oknozor)


- - -
## 1.11.2 - 2020-10-04


### Documentation

[8d52de](https://github.com/oknozor/toml-bombadil/commit/8d52de5a5b38fb39aaa14bbad41fd46fcee7dec0) - add readme instruction for secret vars - [oknozor](https://github.com/oknozor)

[bb3336](https://github.com/oknozor/toml-bombadil/commit/bb3336767029b7ad164fce1aa66306e5004a77a4) - update config example - [oknozor](https://github.com/oknozor)

[7099e6](https://github.com/oknozor/toml-bombadil/commit/7099e65d46f36268f9f06720ffcdd09f874b6024) - add documentation for config imports - [oknozor](https://github.com/oknozor)

[802ead](https://github.com/oknozor/toml-bombadil/commit/802eadbeabde605d1c0c7db95287f3546d810be8) - fix toc - [oknozor](https://github.com/oknozor)

[e9a1b3](https://github.com/oknozor/toml-bombadil/commit/e9a1b306d3a42917808f3d928b73804d7eb7c272) - add contribution guidelines - [oknozor](https://github.com/oknozor)

[53b07f](https://github.com/oknozor/toml-bombadil/commit/53b07fd7d821cd4e0f0761a48f3f01f2d1f7d69d) - update readme according to the new config format - [oknozor](https://github.com/oknozor)

[2e452e](https://github.com/oknozor/toml-bombadil/commit/2e452ea67f17554508ae091ea8116c2b5f34cd1e) - add TOC to readme - [oknozor](https://github.com/oknozor)

[5d9cda](https://github.com/oknozor/toml-bombadil/commit/5d9cdae5fafde53d8f56fddaaf2efb033a2a38ad) - typo - [oknozor](https://github.com/oknozor)

[3d2cc7](https://github.com/oknozor/toml-bombadil/commit/3d2cc7cd3abd2577c949000c8a3564b7272bcf7e) - update readme - [oknozor](https://github.com/oknozor)

[8f05f6](https://github.com/oknozor/toml-bombadil/commit/8f05f6c3002978707c0b8c21d87a609a18ec3955) - display help by default if no subcommand is provided - [oknozor](https://github.com/oknozor)

[516ee0](https://github.com/oknozor/toml-bombadil/commit/516ee082a15dd714d82b7d3c4d131bd2cb785ce1) - add aur badge - [oknozor](https://github.com/oknozor)

[93bbdb](https://github.com/oknozor/toml-bombadil/commit/93bbdb5c02a7b47f6ebbe0441af1c879ff9203c8) - update readme - [oknozor](https://github.com/oknozor)

[a0e125](https://github.com/oknozor/toml-bombadil/commit/a0e1253f8422bcc32182027180ef2c22f2ff7964) - move config examples to a dedicated dir - [oknozor](https://github.com/oknozor)

[e083ce](https://github.com/oknozor/toml-bombadil/commit/e083cecd214cca48c85adf9a2ae1d5be8e27c71f) - add codecove badge - [oknozor](https://github.com/oknozor)

[87c1c4](https://github.com/oknozor/toml-bombadil/commit/87c1c4a922011dc8d1b57726e44f461f44aff9b5) - rewrite some fn docs - [oknozor](https://github.com/oknozor)

[3cca80](https://github.com/oknozor/toml-bombadil/commit/3cca801227852569789b926ca9feeb12423fb919) - update readme - [oknozor](https://github.com/oknozor)

[63437a](https://github.com/oknozor/toml-bombadil/commit/63437af96c3aedbe02a9d54a167be4fa59cc3b9a) - basic documentation for public functions - [oknozor](https://github.com/oknozor)


### Tests

[1e33cb](https://github.com/oknozor/toml-bombadil/commit/1e33cb30521e1ee226a0e22f2a868037a3a3efee) - add test for var extension - [oknozor](https://github.com/oknozor)

[5cf2b5](https://github.com/oknozor/toml-bombadil/commit/5cf2b54c2caf4b7afbfde4a8e4a67b548def18f2) - add test for file and dire removal - [oknozor](https://github.com/oknozor)

[86efba](https://github.com/oknozor/toml-bombadil/commit/86efba3eb53d63ff34bbdef957576d2dbe2bcc86) - add test for profile switching - [oknozor](https://github.com/oknozor)

[6b211b](https://github.com/oknozor/toml-bombadil/commit/6b211b81d34eedc5aef384a7f70988e2b3b55209) - add test for path creation and conversion - [oknozor](https://github.com/oknozor)

[2a9c13](https://github.com/oknozor/toml-bombadil/commit/2a9c1338f1694b2f3897ea7c5b358c68a37684c0) - hook - [oknozor](https://github.com/oknozor)

[7f6d14](https://github.com/oknozor/toml-bombadil/commit/7f6d143469f8b30633acfaa90c3a7a8d1ed27f08) - fix failing test using absolute target path - [oknozor](https://github.com/oknozor)


### Refactoring

[0c9665](https://github.com/oknozor/toml-bombadil/commit/0c9665cfcb9b1c0020cc5b53515a9c09df9c888f) - clippy lints - [oknozor](https://github.com/oknozor)

[88e449](https://github.com/oknozor/toml-bombadil/commit/88e449b9c4f1882b19b5f7ff7422f983a175ccf9) - use fatal! macro on cli error - [oknozor](https://github.com/oknozor)

[17ddf4](https://github.com/oknozor/toml-bombadil/commit/17ddf4b504075df8422b626bcead049cf9cca0ab) - lints - [oknozor](https://github.com/oknozor)

[3aca8c](https://github.com/oknozor/toml-bombadil/commit/3aca8c8656269f1777a1bde75d114aad66c598b3) - refactor theming to allow writing generic preprocessor - [oknozor](https://github.com/oknozor)


### Features

[dd0ca4](https://github.com/oknozor/toml-bombadil/commit/dd0ca47eb86f8d41dd51d9569785facb62585782) - gpg dummy implementation - [oknozor](https://github.com/oknozor)

[1ac891](https://github.com/oknozor/toml-bombadil/commit/1ac8911e6ed2fb6fa9b355d7379c1a7ef81b30e3) - replace per dot profile with global profiles - [oknozor](https://github.com/oknozor)

[0927b5](https://github.com/oknozor/toml-bombadil/commit/0927b51c32d41fbdca4651d244d17956a535aae2) - replace meta vars with $ variable reference - [oknozor](https://github.com/oknozor)

[03e37e](https://github.com/oknozor/toml-bombadil/commit/03e37e38714c59a61d4b48731dbdf1468d3712e3) - change settings structure and add import - [oknozor](https://github.com/oknozor)

[955976](https://github.com/oknozor/toml-bombadil/commit/9559769cd4210ca4372b1f94791d00db3ef35247) - add profile switching - [oknozor](https://github.com/oknozor)

[07a61b](https://github.com/oknozor/toml-bombadil/commit/07a61b51bfce8fc372b40f122ae47cd5227387c9) - add meta vars - [oknozor](https://github.com/oknozor)

[137461](https://github.com/oknozor/toml-bombadil/commit/13746134abbabdf6d310c01d558ab5888602d3c5) - add color to 'link' command ouput - [oknozor](https://github.com/oknozor)

[46eaff](https://github.com/oknozor/toml-bombadil/commit/46eaff28b1e39795c5500257edf5df7c326ac562) - post install hooks - [oknozor](https://github.com/oknozor)

[306782](https://github.com/oknozor/toml-bombadil/commit/3067821ee429938f060a9201833124a1c77de06d) - complete rework - [oknozor](https://github.com/oknozor)

[5c9ace](https://github.com/oknozor/toml-bombadil/commit/5c9ace38540055ff69627cb72e23ad4eedea3e4f) - theme display - [oknozor](https://github.com/oknozor)


### Bug Fixes

[766fe3](https://github.com/oknozor/toml-bombadil/commit/766fe383659daf75fe9f0674b0491067fc33a5b9) - source file permissions are now applied to dot entries - [oknozor](https://github.com/oknozor)

[04ae9d](https://github.com/oknozor/toml-bombadil/commit/04ae9d66fcb89adf1421ac644e9fdd033684907f) - fix var path when activating profile - [oknozor](https://github.com/oknozor)

[d5fc0e](https://github.com/oknozor/toml-bombadil/commit/d5fc0e501f2509a2dd8e6d222601a85e4cb2d078) - add double quoted arg parsing - [oknozor](https://github.com/oknozor)

[9a5210](https://github.com/oknozor/toml-bombadil/commit/9a52105ddafeed4a948850dc53ff3222ef4001f8) - use % instead of $ for reference format - [oknozor](https://github.com/oknozor)

[b34b68](https://github.com/oknozor/toml-bombadil/commit/b34b68f06179f05447f92fd2c36cc3a39e14bcf8) - process remaining dots when one dot is not found - [oknozor](https://github.com/oknozor)

[e36872](https://github.com/oknozor/toml-bombadil/commit/e3687220b17ce3ad4456dcc3162b28d3e7f4bf20) - do not panic when var file is not found - [oknozor](https://github.com/oknozor)

[a6e019](https://github.com/oknozor/toml-bombadil/commit/a6e0196fc8574030b68a596970c289dee7bb6762) - fall back coping file in place when failing to read or parse file content - [oknozor](https://github.com/oknozor)

[1d3bf5](https://github.com/oknozor/toml-bombadil/commit/1d3bf55bd9f90f412a01706c97295dbfa2fd783a) - empty test directory - [oknozor](https://github.com/oknozor)

[733f07](https://github.com/oknozor/toml-bombadil/commit/733f07b2cf10eae50ebbe88ffe52884940dd826b) - fix pathes and theme creation, add lazy static config - [oknozor](https://github.com/oknozor)

[a8aa88](https://github.com/oknozor/toml-bombadil/commit/a8aa88a4824704c9338200be05483be5769e514a) - error handling - [oknozor](https://github.com/oknozor)


### Miscellaneous Chores

[2254dc](https://github.com/oknozor/toml-bombadil/commit/2254dcaeed27dedea1295317b0efb2348c2a7e2d) - add cocogitto config - [oknozor](https://github.com/oknozor)

[9df20c](https://github.com/oknozor/toml-bombadil/commit/9df20c7925061a1ce1892dc52385f66dbefa40c1) - move master to main - [oknozor](https://github.com/oknozor)

[9e621c](https://github.com/oknozor/toml-bombadil/commit/9e621c9d139fdb0d0a012c8f9b9c51f16299ef26) - add awesome logo - [oknozor](https://github.com/oknozor)

[e52281](https://github.com/oknozor/toml-bombadil/commit/e52281824b06836dabf1590140cf58b40e6be4e6) - fix clippy lint - [oknozor](https://github.com/oknozor)

[ec3215](https://github.com/oknozor/toml-bombadil/commit/ec3215385ca95f830597a09ec22c38f0dd07d3f5) - fmt all - [oknozor](https://github.com/oknozor)

[d7a030](https://github.com/oknozor/toml-bombadil/commit/d7a0302597a3c8c59c3d45b512d37da8efd88da8) - fmt all - [oknozor](https://github.com/oknozor)

[2ff52b](https://github.com/oknozor/toml-bombadil/commit/2ff52be9bac49a7e5ffa068a6c4e638f5395705f) - update issue templates - [oknozor](https://github.com/oknozor)

[3ff9bd](https://github.com/oknozor/toml-bombadil/commit/3ff9bd4ac46d82b5d33aabaf5a0b89745ce2d289) - version 1.2.0 - [oknozor](https://github.com/oknozor)

[dad19c](https://github.com/oknozor/toml-bombadil/commit/dad19c71597ed241c2f1deee16bd289847bed00d) - bump to 1.1.0 - [oknozor](https://github.com/oknozor)

[76b10e](https://github.com/oknozor/toml-bombadil/commit/76b10e59f0e5beafb3a1a98721221825d0780984) - version 1.0.0 - [oknozor](https://github.com/oknozor)

[1aa72d](https://github.com/oknozor/toml-bombadil/commit/1aa72d8c813689a0d8c3e33f5f542422460a0e2a) - cargo fmt * - [oknozor](https://github.com/oknozor)

[ab1f7d](https://github.com/oknozor/toml-bombadil/commit/ab1f7d544bd50138bb4e909a4680b5c6af62b6f8) - add MIT licence - [oknozor](https://github.com/oknozor)

[1615fb](https://github.com/oknozor/toml-bombadil/commit/1615fb37a2331811983e4e7f2d259c6ef2ab4db8) - prepare release with github action - [oknozor](https://github.com/oknozor)

[393212](https://github.com/oknozor/toml-bombadil/commit/39321263a272e07de7ddd2b5ced70c79f8d7681c) - add code coverage - [oknozor](https://github.com/oknozor)

[2dbb7d](https://github.com/oknozor/toml-bombadil/commit/2dbb7de0b38b9c7ac32a0ac1a95d32844c3594cc) - fmt * - [oknozor](https://github.com/oknozor)

[c52fc6](https://github.com/oknozor/toml-bombadil/commit/c52fc64358dfeceb509d5a6c82892221402fad0c) - add github action CI - [oknozor](https://github.com/oknozor)


- - -

This changelog was generated by [cocogitto](https://github.com/oknozor/cocogitto).