#[derive(thiserror::Error, Debug)]
pub enum Error {
    #[error(transparent)]
    Etcd(#[from] etcd_client::Error),

    /// When using [`try_lock`] to try to acquire a lock that is already taken.
    ///
    /// [`try_lock`]: ./struct.Lease.html#method.try_lock
    #[error("Lock is unavailable")]
    Taken,

    /// When trying to release a lock that was lost or forcibly stolen.
    #[error("Lock was lost while held")]
    Lost,
}

pub(crate) type CrateResult<T> = Result<T, Error>;
