use crate::Token;
use token_parser::{Parsable, Parser, Result, Unit};

impl From<Token> for Unit {
    fn from(value: Token) -> Self {
        use Token::*;
        match value {
            Symbol(name) => Self::Symbol(name),
            List(elements) => Self::Parser(Parser::new(elements)),
        }
    }
}

impl<C> Parsable<C> for Token {
    fn parse_symbol(name: String, _context: &C) -> Result<Self> {
        Ok(Token::Symbol(name))
    }

    fn parse_list(parser: &mut Parser, context: &C) -> Result<Self> {
        Ok(Token::List(parser.parse_rest(context)?))
    }
}
