# Tokay /src folder

This is an overview over the tokay src/-folder.
```
.
├── builtin.rs          # Built-in structs and primary functions (print, ord, chr, ...)
├── _builtins.rs        # Built-in registry generated by build.rs
├── compiler            # Tokay compiler
│   ├── ast.rs          # Traversal of the parsed AST
│   ├── compiler.rs     # The compiler interface
│   ├── iml             # Intermediate language representation
│   ├── macros.rs       # Macros required for parser bootstrap
│   ├── parser.rs       # Tokay's own grammar implemented using macros
│   ├── test.rs         # Compiler tests
│   └── usage.rs        # Resolving undefined symbols
├── error.rs            # Error handling struct
├── main.rs             # Interpreter executable entry
├── reader.rs           # Universal Reader struct
├── repl.rs             # Read-eval-print-loop
├── test.rs             # Test cases
├── utils.rs            # Utility functions
├── value               # Tokay values
│   ├── dict.rs         # Dict object and its methods
│   ├── list.rs         # List object and its methods
│   ├── method.rs       # Method object
│   ├── object.rs       # Object trait
│   ├── parselet.rs     # Parselet object
│   ├── refvalue.rs     # Reference-counted value object
│   ├── str.rs          # Str object and its methods
│   ├── token.rs        # Token object and builtin tokens (Int, Float, Word...)
│   └── value.rs        # Value object for atomics and numbers
└── vm                  # Tokay virtual machine
    ├── capture.rs      # Stack capturing
    ├── context.rs      # Context struct
    ├── op.rs           # VM operations
    ├── program.rs      # Program struct
    └── runtime.rs      # Runtime struct that glues program, reader and context
```
