# Changelog

## [main]

Current main branch.

## [v0.5]

Released on May 17, 2022

- General
  - Improved Tokay parser newline behavior to support Windows and classic Mac line ending as well
  - Moved tests from `test.rs` into their particular locations, so tests are written next to their implementation
  - Read from stdin when no input stream but a program that is consuming was specified
  - Moved `ccl.rs` into separate [`charclass` crate](https://crates.io/crates/charclass)
  - Equipped Reader struct with better tools for scanning (`Reader::take()`, `Reader::span()`)
- Values
  - New `Object` trait
  - Splitting `enum Value` into separate objects using `Box<dyn Object>`
  - `unary_op()` and `binary_op()` for RefValue, with fast-lanes for some operations
  - Replacement of separate binary- and unary-VM instructions into `Op::BinaryOp` and `Op::UnaryOp`
  - Implemented all primary operations by builtin methods
- Builtins
  - Entire redesign of builtins using proc-macro
  - Builtin function registry generated by a build-script, substituting `inventory`/`linkme`-crates
  - Builtin functions
    - `repr()` to get string with Tokay object representation
    - `type()` to get string of Tokay value type
    - bool methods: `bool()`
    - int methods: `int()`
    - float methods: `float()`, `float.ceil()`, `float.fract()`, `float.trunc()`
    - addr methods: `addr()`
    - dict methods: `dict()`, `dict.len()`, `dict.update()`
    - list methods: `list()`, `list.add()`, `list.iadd()`, `list.len()`, `list.push()`, `list.pop()`
    - str methods: `str()`, `str.add()`, `str.byteslen()` `str.endswith()`, `str.mul()`, `str.join()`, `str.len()`, `str.lower()`, `str.replace()`, `str.startswith()`, `str.substr()`, `str.upper()`
  - Builtin tokens
    - `Float` allowing for parsing floating point numbers into float values
    - `Ident` renamed (from `Identifier`)
    - `Int` renamed (from `Integer`) and accepting parameters like a radix base
    - `Word` skipping words not in the wanted word size, but not rejecting
- New example files
  - Self-hosted Tokay parser in `examples/tokay.tok`
  - Simple JSON parser in `examples/json.tok`


## [v0.4]

Released on Nov 15, 2021

- Implementation of a separated virtual machine (VM) to reduce overall stack usage (#8)
- Removal of the recursive interpreter due to VM replacement
- Cleaned-up and modularization of an encapsulated compiler
- Turned compile-time building blocks into intermediate language (iml)
- Built-in character classes
- Started loop implementation
- Improved debug facilities


## [v0.3]

Released on Jul 7, 2021

- Cleaning and finalizing syntax
- Collections with list and dict expression
- Consumables and built-in tokens
- Implemented all remaining operators
- Inline increment/decrement
- R-value handling for subscripts and attributes, with calls to built-ins
- Compile-time expression evaluation
- Whitespace handling
- Escape sequences
- Command-line parameters


## [v0.2]

Released on Mar 21, 2021

- Parselets and built-ins with parameters
- Improved error reporting
- Interactive REPL


## [v0.1]

Released on Mar 4, 2021

- Character-classes
- Universal Reader trait
- Macros for grammar expression
- First draft of the Tokay grammar
- Implementing recursive interpreter
- Left-recursive parselets
- Sequence capturing and AST construction
- Distinction between constants and variables
- Symbol resolving and scopes


[main]: https://github.com/tokay-lang/tokay/compare/v0.5...main
[v0.5]: https://github.com/tokay-lang/tokay/compare/v0.4...v0.5
[v0.4]: https://github.com/tokay-lang/tokay/compare/v0.3...v0.4
[v0.3]: https://github.com/tokay-lang/tokay/compare/v0.2...v0.3
[v0.2]: https://github.com/tokay-lang/tokay/compare/v0.1...v0.2
[v0.1]: https://github.com/tokay-lang/tokay/compare/2d74215f4842d295371112a630d15ab03442cd1e...v0.1
