//! Utility functions

use crate::compiler::Compiler;
use crate::reader::Reader;
use crate::value::*;

/** Compiles and runs a source with an input.

Used mostly in tests and for quick testing purposes. */
pub fn compile_and_run(
    src: &str,
    input: &'static str,
    debug: bool,
) -> Result<Option<RefValue>, String> {
    let mut compiler = Compiler::new();
    compiler.debug = debug;

    match compiler.compile(Reader::new(Box::new(std::io::Cursor::new(src.to_owned())))) {
        Ok(program) => program.run_from_str(input).map_err(|err| err.to_string()),
        Err(errors) => Err(errors
            .into_iter()
            .map(|err| err.to_string())
            .collect::<Vec<String>>()
            .join("\n")),
    }
}
