use coord2d::*;
use std::cmp;

pub const REGULAR_PAIR: i16 = 0;
pub const HIGHLIGHT_PAIR: i16 = 1;

pub enum LayoutKind {
    Vert,
    Horz,
}

pub struct Layout {
    pub kind: LayoutKind,
    pub pos: coords::Coord,
    pub size: coords::Coord,
}

impl Layout {
    pub fn available_pos(&self) -> coords::Coord {
        use LayoutKind::*;
        match self.kind {
            Horz => self.pos + self.size * new_coord!(1, 0),
            Vert => self.pos + self.size * new_coord!(1),
        }
    }

    pub fn add_widget(&mut self, size: coords::Coord) {
        use LayoutKind::*;
        match self.kind {
            Horz => {
                self.size.x += size.x;
                self.size.y = cmp::max(self.size.y, size.y);
            }
            Vert => {
                self.size.x = cmp::max(self.size.x, size.x);
                self.size.y += size.y;
            }
        }
    }
}
