use crate::types::Amount;

#[derive(Debug)]
pub enum SyncItem {
    Block,
    //This is the metric used by Bitcoin and forks. One of the better ways to estimate how much
    //time is left.
    VerificationProgress,
    // @todo in the future we need Eth's State Tries here
}
// @todo for sync stats we need a better way of saying how much time is remaining
//
// One way to do it is to return a generic data point of "remaning", then another struct of
// "remaining_per_second" and that can just be the calculation of how much of whatever we've
// processed in the last time period. So that can be blocks (Nimiq, Eth) or Transactions (bitcoin,
// Raven, Handshake).
#[derive(Debug)]
pub struct SyncStats {
    //We need this to be able to tell how many blocks we've increased by.
    pub current_block: u64,
    pub syncing: bool,
    //@todo I think we should make these live behind an Option, and that way when syncing is false,
    //we don't even have to include them. We just have Option<None>.
    //
    //Could be named something like SyncEstimates
    //or we renaming syncstats to be syncing, and then make the new object syncstats.
    pub sync_item: SyncItem,
    pub estimated_sync_item_remaining: f64,
}

#[derive(Debug)]
pub struct WalletBalance {
    pub confirmed_balance: Amount,
    //@todo both these need to be bigint:q
    //
    pub unconfirmed_balance: Amount,
}

#[derive(Debug)]
pub struct ClientOptions {
    pub(crate) url: String,
    pub(crate) username: Option<String>,
    pub(crate) password: Option<String>,
}

