use crate::Protocol;
use num_bigint::BigInt;

#[derive(Debug)]
pub struct Amount {
    pub value: BigInt,
    pub currency: Currency,
}

impl Amount {
    pub fn from_decimal(protocol: Protocol, amount: f64) -> Self {
        let amt = amount * protocol.decimal_multiplier() as f64;
        let amt = amt.trunc();

        let value = BigInt::from(amt as u64);

        Self {
            value,
            currency: Currency::from(protocol),
        }
    }
}

//@todo this currency could probs be baked into Symbol as one and the same in that if we use BTC as
//an enum, we know that it is 8 decimals, no need to define it everywhere.
//Let's look into that for a round 2.
#[derive(Debug)]
pub struct Currency {
    pub symbol: Symbol,
    pub decimals: u32,
}

impl From<Protocol> for Currency {
    fn from(p: Protocol) -> Currency {
        match p {
            Protocol::Bitcoin => Currency {
                symbol: Symbol::BTC,
                decimals: p.decimals(),
            },
            _ => unimplemented!(),
        }
    }
}

#[derive(Debug)]
pub enum Symbol {
    BTC,
    ETH,
    HNS,
    NIM,
    RVN,
    SIA,
}
