use crate::client::ClientType;

#[derive(Debug)]
pub enum ClientError {
    UnsupportedType(ClientType),
    InvalidURL,
    UnknownProtocol,
    SerializationError,
    RequestError,
}

// impl From<serde::de::Error> for ClientType {
//     fn from(e: serde::de::Error) -> Self {
//         ClientError::SerializationError
//     }
// }

impl From<rpc_json_client::Error> for ClientError {
    fn from(_e: rpc_json_client::Error) -> Self {
        ClientError::RequestError
    }
}

impl From<surf::Error> for ClientError {
    fn from(_e: surf::Error) -> Self {
        ClientError::RequestError
    }
}
